--- src/crc32c_read_le.h.orig	2019-07-24 07:21:23 UTC
+++ src/crc32c_read_le.h
@@ -30,14 +30,14 @@ inline uint32_t ReadUint32LE(const uint8_t* buffer) {
 // Reads a little-endian 64-bit integer from a 64-bit-aligned buffer.
 inline uint64_t ReadUint64LE(const uint8_t* buffer) {
 #if BYTE_ORDER_BIG_ENDIAN
-  return ((static_cast<uint32_t>(static_cast<uint8_t>(buffer[0]))) |
-          (static_cast<uint32_t>(static_cast<uint8_t>(buffer[1])) << 8) |
-          (static_cast<uint32_t>(static_cast<uint8_t>(buffer[2])) << 16) |
-          (static_cast<uint32_t>(static_cast<uint8_t>(buffer[3])) << 24) |
-          (static_cast<uint32_t>(static_cast<uint8_t>(buffer[4])) << 32) |
-          (static_cast<uint32_t>(static_cast<uint8_t>(buffer[5])) << 40) |
-          (static_cast<uint32_t>(static_cast<uint8_t>(buffer[6])) << 48) |
-          (static_cast<uint32_t>(static_cast<uint8_t>(buffer[7])) << 56));
+  return ((static_cast<uint64_t>(static_cast<uint8_t>(buffer[0]))) |
+          (static_cast<uint64_t>(static_cast<uint8_t>(buffer[1])) << 8) |
+          (static_cast<uint64_t>(static_cast<uint8_t>(buffer[2])) << 16) |
+          (static_cast<uint64_t>(static_cast<uint8_t>(buffer[3])) << 24) |
+          (static_cast<uint64_t>(static_cast<uint8_t>(buffer[4])) << 32) |
+          (static_cast<uint64_t>(static_cast<uint8_t>(buffer[5])) << 40) |
+          (static_cast<uint64_t>(static_cast<uint8_t>(buffer[6])) << 48) |
+          (static_cast<uint64_t>(static_cast<uint8_t>(buffer[7])) << 56));
 #else   // !BYTE_ORDER_BIG_ENDIAN
   uint64_t result;
   // This should be optimized to a single instruction.
