/*-
 * SPDX-License-Identifier: BSD-2-Clause
  *
 * Copyright 2019 Pawel Biernacki, Mysterious Code Ltd.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/12/lib/libc/gen/sysctlbyname.c 364150 2020-08-12 10:03:10Z kaktus $");

#include <sys/param.h>
#include <sys/sysctl.h>
#include <string.h>

#include "libc_private.h"

#define	SYSCTLBYNAME_OSREL	1201522

extern int __sysctlbyname(const char *name, size_t namelen, void *oldp,
    size_t *oldlenp, const void *newp, size_t newlen);

int
sysctlbyname(const char *name, void *oldp, size_t *oldlenp,
    const void *newp, size_t newlen)
{
	int oid[CTL_MAXNAME];
	size_t len;

	if (__getosreldate() >= SYSCTLBYNAME_OSREL) {
		len = strlen(name);
		return (__sysctlbyname(name, len, oldp, oldlenp, newp,
		    newlen));
	}
	len = nitems(oid);
	if (sysctlnametomib(name, oid, &len) == -1)
		return (-1);
	return (sysctl(oid, len, oldp, oldlenp, newp, newlen));
}
