/*-
 * SPDX-License-Identifier: BSD-2-Clause-FreeBSD
 *
 * Copyright (C) 2018 Universita` di Pisa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/12/lib/libnetmap/nmctx-pthreads.c 366013 2020-09-22 21:16:03Z vmaffione $
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <net/netmap_user.h>
#include <pthread.h>
#include "libnetmap.h"

struct nmctx_pthread {
	struct nmctx up;
	pthread_mutex_t mutex;
};

static struct nmctx_pthread nmctx_pthreadsafe;

static void
nmctx_pthread_lock(struct nmctx *ctx, int lock)
{
	struct nmctx_pthread *ctxp =
		(struct nmctx_pthread *)ctx;
	if (lock) {
		pthread_mutex_lock(&ctxp->mutex);
	} else {
		pthread_mutex_unlock(&ctxp->mutex);
	}
}

void __attribute__ ((constructor))
nmctx_set_threadsafe(void)
{
	struct nmctx *old;

	pthread_mutex_init(&nmctx_pthreadsafe.mutex, NULL);
	old = nmctx_set_default(&nmctx_pthreadsafe.up);
	nmctx_pthreadsafe.up = *old;
	nmctx_pthreadsafe.up.lock = nmctx_pthread_lock;
}

int nmctx_threadsafe;
