/*-
 * Copyright (c) 2016 Stanislav Galabov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/12/stand/mips/uboot/start.S 296183 2016-02-29 07:47:04Z sgalabov $
 */

#include <machine/asm.h>

	.text
	.extern _C_LABEL(main)
	.weak	_DYNAMIC

/*
 * Entry point to the loader that U-Boot passes control to.
 */
ENTRY(_start)
	PTR_S	sp, uboot_address
	j	main
	nop
END(_start)

/*
 * syscall()
 */
ENTRY(syscall)
	PTR_S	ra, ret_address
	PTR_L	t9, syscall_ptr
	jalr	t9
	nop
	PTR_L	ra, ret_address
	jr	ra
	nop
END(syscall)

/*
 * Data section
 */
	.data
	.align	8
	.globl	syscall_ptr
syscall_ptr:
	.dword	0

	.globl	uboot_address
uboot_address:
	.dword	0

ret_address:
	.dword	0
