.ig
Copyright (C) 1989-2001, 2002, 2003, 2005 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.

	$FreeBSD: stable/7/contrib/groff/src/roff/nroff/nroff.man 151503 2005-10-20 10:53:15Z ru $

..
.
.TH @G@NROFF @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.
.SH NAME
@g@nroff \- emulate nroff command with groff
.
.SH SYNOPSIS
.nr a \n(.j
.ad l
.nr i \n(.i
.in +\w'\fB@g@nroff 'u
.ti \niu
.B @g@nroff
.de OP
.ie \\n(.$-1 .RI "[\ \fB\\$1\fP" "\\$2" "\ ]"
.el .RB "[\ " "\\$1" "\ ]"
..
.
.OP \-CchipStUv
.OP \-d cs
.OP \-M dir
.OP \-m name
.OP \-n num
.OP \-o list
.OP \-r cn
.OP \-T name
.RI "[\ " "file" "\ .\|.\|.\ ]"
.br
.ad \na
.
.SH DESCRIPTION
The
.B @g@nroff
script emulates the
.B nroff
command using groff.
Only 
.BR ascii ,
.BR latin1 ,
.BR koi8-r ,
.BR utf8 ,
and
.B cp1047
are valid arguments for the
.B -T
option, selecting the output encoding emitted by
.BR grotty ,
groff's TTY output device.
If an invalid or no
.BR \-T
option is given,
.B @g@nroff
checks the current locale to select a default output device.
It first tries the
.B locale
program, then the environment variables
.BR LC_ALL ,
.BR LC_CTYPE ,
and
.BR LANG ,
and finally the
.B LESSCHARSET
environment variable.
.PP
The
.B \-h
and
.B \-c
options
are equivalent to
.BR grotty 's
options
.B \-h
(using tabs in the output) and
.B \-c
(using the old output scheme instead of SGR escape sequences).
The
.BR \-d ,
.BR \-C ,
.BR \-i ,
.BR \-M ,
.BR \-m ,
.BR \-n ,
.BR \-o ,
and
.B \-r
options have the effect described in
.BR @g@troff (@MAN1EXT@).
In addition,
.B @g@nroff
silently ignores the options
.BR \-e ,
.BR \-q ,
and
.BR \-s
(which are not implemented in
.BR @g@troff ).
Options 
.B \-p
(pic),
.B \-t
(tbl),
.B \-S
(safer), and
.B \-U
(unsafe) are passed to
.BR groff . 
.B \-v
shows the version number.
.
.SH ENVIRONMENT
.TP
.SM
.B GROFF_BIN_PATH
A colon separated list of directories in which to search for the
.B groff
executable before searching in PATH.  If unset, `@BINDIR@' is used.
.SH NOTES
This shell script is basically intended for use with
.BR man (1),
so warnings are suppressed.
nroff-style character definitions (in the file tty-char.tmac) are also
loaded to emulate unrepresentable glyphs.
.
.SH "SEE ALSO"
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR grotty (@MAN1EXT@)
.
.\" Local Variables:
.\" mode: nroff
.\" End:
