/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import io.cucumber.datatable.DataTable;
import io.cucumber.datatable.DataTableFormatter;
import io.cucumber.datatable.DiffType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class DataTableDiff {
    private final List<List<String>> table;
    private final List<DiffType> diffTypes;

    static DataTableDiff create(List<AbstractMap.SimpleEntry<List<String>, DiffType>> diffTableRows) {
        ArrayList<DiffType> diffTypes = new ArrayList<DiffType>(diffTableRows.size());
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        for (AbstractMap.SimpleEntry<List<String>, DiffType> row : diffTableRows) {
            table.add(row.getKey());
            diffTypes.add(row.getValue());
        }
        return new DataTableDiff(table, diffTypes);
    }

    private DataTableDiff(List<List<String>> table, List<DiffType> diffTypes) {
        this.table = table;
        this.diffTypes = diffTypes;
    }

    public boolean isEmpty() {
        return !this.diffTypes.contains((Object)DiffType.DELETE) && !this.diffTypes.contains((Object)DiffType.INSERT);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        DataTableFormatter.builder().prefixRow(this::indentForRow).build().formatTo(DataTable.create(this.table), result);
        return result.toString();
    }

    private String indentForRow(Integer rowIndex) {
        switch (this.diffTypes.get(rowIndex)) {
            case DELETE: {
                return "    - ";
            }
            case INSERT: {
                return "    + ";
            }
        }
        return "      ";
    }
}

