/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.PropertyElement;
import java.util.Collections;
import java.util.Set;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.PropertyNode;

@Internal
abstract class GroovyPropertyElement
extends AbstractGroovyElement
implements PropertyElement {
    private final String name;
    private final boolean readOnly;
    private final Object nativeType;
    private final GroovyClassElement declaringClass;
    private ClassElement declaringElement;

    GroovyPropertyElement(GroovyVisitorContext visitorContext, GroovyClassElement declaringClass, AnnotatedNode annotatedNode, AnnotationMetadata annotationMetadata, String name, boolean readOnly, Object nativeType) {
        super(visitorContext, annotatedNode, annotationMetadata);
        this.name = name;
        this.readOnly = readOnly;
        this.nativeType = nativeType;
        this.declaringClass = declaringClass;
    }

    public Set<ElementModifier> getModifiers() {
        if (this.isReadOnly()) {
            return CollectionUtils.setOf((Object[])new ElementModifier[]{ElementModifier.FINAL, ElementModifier.PUBLIC});
        }
        return Collections.singleton(ElementModifier.PUBLIC);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getName() {
        return this.name;
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isPublic() {
        return true;
    }

    public Object getNativeType() {
        return this.nativeType;
    }

    public String toString() {
        return this.getName();
    }

    public ClassElement getDeclaringType() {
        if (this.declaringElement == null && this.nativeType instanceof PropertyNode) {
            PropertyNode propertyNode = (PropertyNode)this.nativeType;
            this.declaringElement = this.visitorContext.getElementFactory().newClassElement(propertyNode.getDeclaringClass(), AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)propertyNode.getDeclaringClass()));
        }
        if (this.declaringElement != null) {
            return this.declaringElement;
        }
        return this.declaringClass;
    }

    public ClassElement getOwningType() {
        return this.declaringClass;
    }
}

