/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.websocket;

import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lib.connections.websocket.ConnectionDescriptor;
import com.sun.star.lib.connections.websocket.WebsocketConnection;
import com.sun.star.registry.XRegistryKey;
import java.io.IOException;
import java.net.URISyntaxException;

public final class websocketConnector
implements XConnector {
    public static final String __serviceName = "com.sun.star.connection.websocketConnector";
    private boolean connected = false;

    public static XSingleServiceFactory __getServiceFactory(String implName, XMultiServiceFactory multiFactory, XRegistryKey regKey) {
        return implName.equals(websocketConnector.class.getName()) ? FactoryHelper.getServiceFactory(websocketConnector.class, __serviceName, multiFactory, regKey) : null;
    }

    @Override
    public synchronized XConnection connect(String connectionDescription) throws NoConnectException, ConnectionSetupException {
        ConnectionDescriptor desc;
        if (this.connected) {
            throw new ConnectionSetupException("Already connected to the socket");
        }
        try {
            desc = new ConnectionDescriptor(connectionDescription);
        }
        catch (IllegalArgumentException e) {
            throw new ConnectionSetupException(e);
        }
        WebsocketConnection websocket = null;
        try {
            websocket = new WebsocketConnection(connectionDescription, desc);
            this.connected = websocket.isOpen();
        }
        catch (IOException e) {
            throw new ConnectionSetupException(e);
        }
        catch (URISyntaxException e) {
            throw new ConnectionSetupException(e);
        }
        catch (InterruptedException e) {
            throw new ConnectionSetupException(e);
        }
        if (websocket == null || !this.connected) {
            throw new ConnectionSetupException("Could not connect to the server. Is it up?");
        }
        return websocket;
    }
}

