// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAMA5D31.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

//go:build sam && atsama5d31

// Atmel ATSAMA5D31 device: ARM Cortex-A5 processor-based embedded MPU, 536MHz, Linux support, FPU, LCD controller, 10/100 Ethernet, security (refer to http://www.atmel.com/devices/SAMA5D31.aspx for more)
//

package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device = "ATSAMA5D31"
)

// Interrupt numbers.
const (
	// Advanced Interrupt Controller
	IRQ_FIQ = 0

	// Power Management Controller
	IRQ_PMC = 1

	// Debug Unit
	IRQ_DBGU = 2

	// Parallel Input/Output Controller A
	IRQ_PIOA = 6

	// Parallel Input/Output Controller B
	IRQ_PIOB = 7

	// Parallel Input/Output Controller C
	IRQ_PIOC = 8

	// Parallel Input/Output Controller D
	IRQ_PIOD = 9

	// Parallel Input/Output Controller E
	IRQ_PIOE = 10

	// Software Modem Device
	IRQ_SMD = 11

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART0 = 12

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART1 = 13

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	IRQ_USART2 = 14

	// Universal Synchronous Asynchronous Receiver Transmitter 3
	IRQ_USART3 = 15

	// Universal Asynchronous Receiver Transmitter 0
	IRQ_UART0 = 16

	// Universal Asynchronous Receiver Transmitter 1
	IRQ_UART1 = 17

	// Two-wire Interface 0
	IRQ_TWI0 = 18

	// Two-wire Interface 1
	IRQ_TWI1 = 19

	// Two-wire Interface 2
	IRQ_TWI2 = 20

	// High Speed MultiMedia Card Interface 0
	IRQ_HSMCI0 = 21

	// High Speed MultiMedia Card Interface 1
	IRQ_HSMCI1 = 22

	// High Speed MultiMedia Card Interface 2
	IRQ_HSMCI2 = 23

	// Serial Peripheral Interface 0
	IRQ_SPI0 = 24

	// Serial Peripheral Interface 1
	IRQ_SPI1 = 25

	// Timer Counter 0
	IRQ_TC0 = 26

	// Timer Counter 0
	IRQ_TC1 = 27

	// Pulse Width Modulation Controller
	IRQ_PWM = 28

	// Analog-to-Digital Converter
	IRQ_ADC = 29

	// DMA Controller 0
	IRQ_DMAC0 = 30

	// DMA Controller 1
	IRQ_DMAC1 = 31

	// USB High Speed Device Port
	IRQ_UDPHS = 33

	// Ethernet MAC 10/100
	IRQ_EMAC = 35

	// LCD Controller
	IRQ_LCDC = 36

	// Image Sensor Interface
	IRQ_ISI = 37

	// Synchronous Serial Controller 0
	IRQ_SSC0 = 38

	// Synchronous Serial Controller 1
	IRQ_SSC1 = 39

	// True Random Number Generator
	IRQ_TRNG = 45

	// Advanced Interrupt Controller
	IRQ_IRQ = 47

	// Fuse Controller
	IRQ_FUSE = 48

	// Highest interrupt number on this device.
	IRQ_max = 48
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export FIQ_IRQHandler
func interruptFIQ() {
	callHandlers(IRQ_FIQ)
}

//export PMC_IRQHandler
func interruptPMC() {
	callHandlers(IRQ_PMC)
}

//export DBGU_IRQHandler
func interruptDBGU() {
	callHandlers(IRQ_DBGU)
}

//export PIOA_IRQHandler
func interruptPIOA() {
	callHandlers(IRQ_PIOA)
}

//export PIOB_IRQHandler
func interruptPIOB() {
	callHandlers(IRQ_PIOB)
}

//export PIOC_IRQHandler
func interruptPIOC() {
	callHandlers(IRQ_PIOC)
}

//export PIOD_IRQHandler
func interruptPIOD() {
	callHandlers(IRQ_PIOD)
}

//export PIOE_IRQHandler
func interruptPIOE() {
	callHandlers(IRQ_PIOE)
}

//export SMD_IRQHandler
func interruptSMD() {
	callHandlers(IRQ_SMD)
}

//export USART0_IRQHandler
func interruptUSART0() {
	callHandlers(IRQ_USART0)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_IRQHandler
func interruptUSART3() {
	callHandlers(IRQ_USART3)
}

//export UART0_IRQHandler
func interruptUART0() {
	callHandlers(IRQ_UART0)
}

//export UART1_IRQHandler
func interruptUART1() {
	callHandlers(IRQ_UART1)
}

//export TWI0_IRQHandler
func interruptTWI0() {
	callHandlers(IRQ_TWI0)
}

//export TWI1_IRQHandler
func interruptTWI1() {
	callHandlers(IRQ_TWI1)
}

//export TWI2_IRQHandler
func interruptTWI2() {
	callHandlers(IRQ_TWI2)
}

//export HSMCI0_IRQHandler
func interruptHSMCI0() {
	callHandlers(IRQ_HSMCI0)
}

//export HSMCI1_IRQHandler
func interruptHSMCI1() {
	callHandlers(IRQ_HSMCI1)
}

//export HSMCI2_IRQHandler
func interruptHSMCI2() {
	callHandlers(IRQ_HSMCI2)
}

//export SPI0_IRQHandler
func interruptSPI0() {
	callHandlers(IRQ_SPI0)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export TC0_IRQHandler
func interruptTC0() {
	callHandlers(IRQ_TC0)
}

//export TC1_IRQHandler
func interruptTC1() {
	callHandlers(IRQ_TC1)
}

//export PWM_IRQHandler
func interruptPWM() {
	callHandlers(IRQ_PWM)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export DMAC0_IRQHandler
func interruptDMAC0() {
	callHandlers(IRQ_DMAC0)
}

//export DMAC1_IRQHandler
func interruptDMAC1() {
	callHandlers(IRQ_DMAC1)
}

//export UDPHS_IRQHandler
func interruptUDPHS() {
	callHandlers(IRQ_UDPHS)
}

//export EMAC_IRQHandler
func interruptEMAC() {
	callHandlers(IRQ_EMAC)
}

//export LCDC_IRQHandler
func interruptLCDC() {
	callHandlers(IRQ_LCDC)
}

//export ISI_IRQHandler
func interruptISI() {
	callHandlers(IRQ_ISI)
}

//export SSC0_IRQHandler
func interruptSSC0() {
	callHandlers(IRQ_SSC0)
}

//export SSC1_IRQHandler
func interruptSSC1() {
	callHandlers(IRQ_SSC1)
}

//export TRNG_IRQHandler
func interruptTRNG() {
	callHandlers(IRQ_TRNG)
}

//export IRQ_IRQHandler
func interruptIRQ() {
	callHandlers(IRQ_IRQ)
}

//export FUSE_IRQHandler
func interruptFUSE() {
	callHandlers(IRQ_FUSE)
}

// Peripherals.
var (
	// Software Modem Device
	SMD = (*SMD_Type)(unsafe.Pointer(uintptr(0x400000)))

	// AXI Matrix
	AXIMX = (*AXIMX_Type)(unsafe.Pointer(uintptr(0x800000)))

	// High Speed MultiMedia Card Interface 0
	HSMCI0 = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xf0000000)))

	// Serial Peripheral Interface 0
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0xf0004000)))

	// Synchronous Serial Controller 0
	SSC0 = (*SSC_Type)(unsafe.Pointer(uintptr(0xf0008000)))

	// Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0xf0010000)))

	// Two-wire Interface 0
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0xf0014000)))

	// Two-wire Interface 1
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0xf0018000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0xf001c000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0xf0020000)))

	// Universal Asynchronous Receiver Transmitter 0
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0xf0024000)))

	// Pulse Width Modulation Controller
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0xf002c000)))

	// LCD Controller
	LCDC = (*LCDC_Type)(unsafe.Pointer(uintptr(0xf0030000)))

	// Image Sensor Interface
	ISI = (*ISI_Type)(unsafe.Pointer(uintptr(0xf0034000)))

	// Special Function Registers
	SFR = (*SFR_Type)(unsafe.Pointer(uintptr(0xf0038000)))

	// High Speed MultiMedia Card Interface 1
	HSMCI1 = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xf8000000)))

	// High Speed MultiMedia Card Interface 2
	HSMCI2 = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xf8004000)))

	// Serial Peripheral Interface 1
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0xf8008000)))

	// Synchronous Serial Controller 1
	SSC1 = (*SSC_Type)(unsafe.Pointer(uintptr(0xf800c000)))

	// Analog-to-Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0xf8018000)))

	// Two-wire Interface 2
	TWI2 = (*TWI_Type)(unsafe.Pointer(uintptr(0xf801c000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0xf8020000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 3
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0xf8024000)))

	// Universal Asynchronous Receiver Transmitter 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0xf8028000)))

	// Ethernet MAC 10/100
	EMAC = (*EMAC_Type)(unsafe.Pointer(uintptr(0xf802c000)))

	// USB High Speed Device Port
	UDPHS = (*UDPHS_Type)(unsafe.Pointer(uintptr(0xf8030000)))

	// True Random Number Generator
	TRNG = (*TRNG_Type)(unsafe.Pointer(uintptr(0xf8040000)))

	// Fuse Controller
	FUSE = (*FUSE_Type)(unsafe.Pointer(uintptr(0xffffe400)))

	// DMA Controller 0
	DMAC0 = (*DMAC_Type)(unsafe.Pointer(uintptr(0xffffe600)))

	// DMA Controller 1
	DMAC1 = (*DMAC_Type)(unsafe.Pointer(uintptr(0xffffe800)))

	// AHB Multi-port DDR-SDRAM Controller
	MPDDRC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffea00)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0xffffec00)))

	// Debug Unit
	DBGU = (*DBGU_Type)(unsafe.Pointer(uintptr(0xffffee00)))

	// Advanced Interrupt Controller
	AIC = (*AIC_Type)(unsafe.Pointer(uintptr(0xfffff000)))

	// Parallel Input/Output Controller A
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff200)))

	// Parallel Input/Output Controller B
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff400)))

	// Parallel Input/Output Controller C
	PIOC = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff600)))

	// Parallel Input/Output Controller D
	PIOD = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff800)))

	// Parallel Input/Output Controller E
	PIOE = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffffa00)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0xfffffc00)))

	// Reset Controller
	RSTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe00)))

	// Shutdown Controller
	SHDWC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe10)))

	// Periodic Interval Timer
	PIT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe30)))

	// Watchdog Timer
	WDT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe40)))

	// Slow Clock Controller
	SCKC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe50)))

	// Boot Sequence Controller
	BSC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe54)))

	// General Purpose Backup Register
	GPBR = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe60)))

	// Real-time Clock
	RTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffeb0)))
)

// Software Modem Device
type SMD_Type struct {
}

// AXI Matrix
type AXIMX_Type struct {
	REMAP               volatile.Register32 // 0x0
	_                   [8140]byte
	PERIPH_ID4          volatile.Register32    // 0x1FD0
	PERIPH_ID5          volatile.Register32    // 0x1FD4
	PERIPH_ID6          volatile.Register32    // 0x1FD8
	PERIPH_ID7          volatile.Register32    // 0x1FDC
	PERIPH_ID0          volatile.Register32    // 0x1FE0
	PERIPH_ID1          volatile.Register32    // 0x1FE4
	PERIPH_ID2          volatile.Register32    // 0x1FE8
	PERIPH_ID3          volatile.Register32    // 0x1FEC
	COMP_ID             [4]volatile.Register32 // 0x1FF0
	_                   [12296]byte
	AMIB3_FN_MOD_BM_ISS volatile.Register32 // 0x5008
	_                   [24]byte
	AMIB3_FN_MOD2       volatile.Register32 // 0x5024
	_                   [250072]byte
	ASIB0_READ_QOS      volatile.Register32 // 0x42100
	ASIB0_WRITE_QOS     volatile.Register32 // 0x42104
	_                   [3872]byte
	ASIB1_FN_MOD_AHB    volatile.Register32 // 0x43028
	_                   [212]byte
	ASIB1_READ_QOS      volatile.Register32 // 0x43100
	ASIB1_WRITE_QOS     volatile.Register32 // 0x43104
	ASIB1_FN_MOD        volatile.Register32 // 0x43108
}

// AXIMX.REMAP: Remap Register
func (o *AXIMX_Type) SetREMAP_REMAP0(value uint32) {
	volatile.StoreUint32(&o.REMAP.Reg, volatile.LoadUint32(&o.REMAP.Reg)&^(0x1)|value)
}
func (o *AXIMX_Type) GetREMAP_REMAP0() uint32 {
	return volatile.LoadUint32(&o.REMAP.Reg) & 0x1
}
func (o *AXIMX_Type) SetREMAP_REMAP1(value uint32) {
	volatile.StoreUint32(&o.REMAP.Reg, volatile.LoadUint32(&o.REMAP.Reg)&^(0x2)|value<<1)
}
func (o *AXIMX_Type) GetREMAP_REMAP1() uint32 {
	return (volatile.LoadUint32(&o.REMAP.Reg) & 0x2) >> 1
}

// AXIMX.PERIPH_ID4: Peripheral ID Register 4
func (o *AXIMX_Type) SetPERIPH_ID4_ID(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID4.Reg, volatile.LoadUint32(&o.PERIPH_ID4.Reg)&^(0xff)|value)
}
func (o *AXIMX_Type) GetPERIPH_ID4_ID() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID4.Reg) & 0xff
}

// AXIMX.PERIPH_ID5: Peripheral ID Register 5
func (o *AXIMX_Type) SetPERIPH_ID5_ID(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID5.Reg, volatile.LoadUint32(&o.PERIPH_ID5.Reg)&^(0xff)|value)
}
func (o *AXIMX_Type) GetPERIPH_ID5_ID() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID5.Reg) & 0xff
}

// AXIMX.PERIPH_ID6: Peripheral ID Register 6
func (o *AXIMX_Type) SetPERIPH_ID6_ID(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID6.Reg, volatile.LoadUint32(&o.PERIPH_ID6.Reg)&^(0xff)|value)
}
func (o *AXIMX_Type) GetPERIPH_ID6_ID() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID6.Reg) & 0xff
}

// AXIMX.PERIPH_ID7: Peripheral ID Register 7
func (o *AXIMX_Type) SetPERIPH_ID7_ID(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID7.Reg, volatile.LoadUint32(&o.PERIPH_ID7.Reg)&^(0xff)|value)
}
func (o *AXIMX_Type) GetPERIPH_ID7_ID() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID7.Reg) & 0xff
}

// AXIMX.PERIPH_ID0: Peripheral ID Register 0
func (o *AXIMX_Type) SetPERIPH_ID0_ID(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID0.Reg, volatile.LoadUint32(&o.PERIPH_ID0.Reg)&^(0xff)|value)
}
func (o *AXIMX_Type) GetPERIPH_ID0_ID() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID0.Reg) & 0xff
}

// AXIMX.PERIPH_ID1: Peripheral ID Register 1
func (o *AXIMX_Type) SetPERIPH_ID1_ID(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID1.Reg, volatile.LoadUint32(&o.PERIPH_ID1.Reg)&^(0xff)|value)
}
func (o *AXIMX_Type) GetPERIPH_ID1_ID() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID1.Reg) & 0xff
}

// AXIMX.PERIPH_ID2: Peripheral ID Register 2
func (o *AXIMX_Type) SetPERIPH_ID2_ID(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID2.Reg, volatile.LoadUint32(&o.PERIPH_ID2.Reg)&^(0xff)|value)
}
func (o *AXIMX_Type) GetPERIPH_ID2_ID() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID2.Reg) & 0xff
}

// AXIMX.PERIPH_ID3: Peripheral ID Register 3
func (o *AXIMX_Type) SetPERIPH_ID3_ID(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID3.Reg, volatile.LoadUint32(&o.PERIPH_ID3.Reg)&^(0xff)|value)
}
func (o *AXIMX_Type) GetPERIPH_ID3_ID() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID3.Reg) & 0xff
}

// AXIMX.COMP_ID: Component ID Register
func (o *AXIMX_Type) SetCOMP_ID_ID(idx int, value uint32) {
	volatile.StoreUint32(&o.COMP_ID[idx].Reg, volatile.LoadUint32(&o.COMP_ID[idx].Reg)&^(0xff)|value)
}
func (o *AXIMX_Type) GetCOMP_ID_ID(idx int) uint32 {
	return volatile.LoadUint32(&o.COMP_ID[idx].Reg) & 0xff
}

// AXIMX.AMIB3_FN_MOD_BM_ISS: AMIB3 Bus Matrix Functionality Modification Register
func (o *AXIMX_Type) SetAMIB3_FN_MOD_BM_ISS_RD_ISS(value uint32) {
	volatile.StoreUint32(&o.AMIB3_FN_MOD_BM_ISS.Reg, volatile.LoadUint32(&o.AMIB3_FN_MOD_BM_ISS.Reg)&^(0x1)|value)
}
func (o *AXIMX_Type) GetAMIB3_FN_MOD_BM_ISS_RD_ISS() uint32 {
	return volatile.LoadUint32(&o.AMIB3_FN_MOD_BM_ISS.Reg) & 0x1
}
func (o *AXIMX_Type) SetAMIB3_FN_MOD_BM_ISS_WR_ISS(value uint32) {
	volatile.StoreUint32(&o.AMIB3_FN_MOD_BM_ISS.Reg, volatile.LoadUint32(&o.AMIB3_FN_MOD_BM_ISS.Reg)&^(0x2)|value<<1)
}
func (o *AXIMX_Type) GetAMIB3_FN_MOD_BM_ISS_WR_ISS() uint32 {
	return (volatile.LoadUint32(&o.AMIB3_FN_MOD_BM_ISS.Reg) & 0x2) >> 1
}

// AXIMX.AMIB3_FN_MOD2: AMIB3 Bypass Merge
func (o *AXIMX_Type) SetAMIB3_FN_MOD2_BP_MRG(value uint32) {
	volatile.StoreUint32(&o.AMIB3_FN_MOD2.Reg, volatile.LoadUint32(&o.AMIB3_FN_MOD2.Reg)&^(0x1)|value)
}
func (o *AXIMX_Type) GetAMIB3_FN_MOD2_BP_MRG() uint32 {
	return volatile.LoadUint32(&o.AMIB3_FN_MOD2.Reg) & 0x1
}

// AXIMX.ASIB0_READ_QOS: ASIB0 Read Channel QoS Register
func (o *AXIMX_Type) SetASIB0_READ_QOS_RD_QOS(value uint32) {
	volatile.StoreUint32(&o.ASIB0_READ_QOS.Reg, volatile.LoadUint32(&o.ASIB0_READ_QOS.Reg)&^(0xf)|value)
}
func (o *AXIMX_Type) GetASIB0_READ_QOS_RD_QOS() uint32 {
	return volatile.LoadUint32(&o.ASIB0_READ_QOS.Reg) & 0xf
}

// AXIMX.ASIB0_WRITE_QOS: ASIB0 Write Channel QoS Register
func (o *AXIMX_Type) SetASIB0_WRITE_QOS_WR_QOS(value uint32) {
	volatile.StoreUint32(&o.ASIB0_WRITE_QOS.Reg, volatile.LoadUint32(&o.ASIB0_WRITE_QOS.Reg)&^(0xf)|value)
}
func (o *AXIMX_Type) GetASIB0_WRITE_QOS_WR_QOS() uint32 {
	return volatile.LoadUint32(&o.ASIB0_WRITE_QOS.Reg) & 0xf
}

// AXIMX.ASIB1_FN_MOD_AHB: ASIB1 AHB Functionality Modification Register
func (o *AXIMX_Type) SetASIB1_FN_MOD_AHB_RD_INCR_OVR(value uint32) {
	volatile.StoreUint32(&o.ASIB1_FN_MOD_AHB.Reg, volatile.LoadUint32(&o.ASIB1_FN_MOD_AHB.Reg)&^(0x1)|value)
}
func (o *AXIMX_Type) GetASIB1_FN_MOD_AHB_RD_INCR_OVR() uint32 {
	return volatile.LoadUint32(&o.ASIB1_FN_MOD_AHB.Reg) & 0x1
}
func (o *AXIMX_Type) SetASIB1_FN_MOD_AHB_WR_INCR_OVR(value uint32) {
	volatile.StoreUint32(&o.ASIB1_FN_MOD_AHB.Reg, volatile.LoadUint32(&o.ASIB1_FN_MOD_AHB.Reg)&^(0x2)|value<<1)
}
func (o *AXIMX_Type) GetASIB1_FN_MOD_AHB_WR_INCR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ASIB1_FN_MOD_AHB.Reg) & 0x2) >> 1
}
func (o *AXIMX_Type) SetASIB1_FN_MOD_AHB_LOCK_OVR(value uint32) {
	volatile.StoreUint32(&o.ASIB1_FN_MOD_AHB.Reg, volatile.LoadUint32(&o.ASIB1_FN_MOD_AHB.Reg)&^(0x4)|value<<2)
}
func (o *AXIMX_Type) GetASIB1_FN_MOD_AHB_LOCK_OVR() uint32 {
	return (volatile.LoadUint32(&o.ASIB1_FN_MOD_AHB.Reg) & 0x4) >> 2
}

// AXIMX.ASIB1_READ_QOS: ASIB1 Read Channel QoS Register
func (o *AXIMX_Type) SetASIB1_READ_QOS_RD_QOS(value uint32) {
	volatile.StoreUint32(&o.ASIB1_READ_QOS.Reg, volatile.LoadUint32(&o.ASIB1_READ_QOS.Reg)&^(0xf)|value)
}
func (o *AXIMX_Type) GetASIB1_READ_QOS_RD_QOS() uint32 {
	return volatile.LoadUint32(&o.ASIB1_READ_QOS.Reg) & 0xf
}

// AXIMX.ASIB1_WRITE_QOS: ASIB1 Write Channel QoS Register
func (o *AXIMX_Type) SetASIB1_WRITE_QOS_WR_QOS(value uint32) {
	volatile.StoreUint32(&o.ASIB1_WRITE_QOS.Reg, volatile.LoadUint32(&o.ASIB1_WRITE_QOS.Reg)&^(0xf)|value)
}
func (o *AXIMX_Type) GetASIB1_WRITE_QOS_WR_QOS() uint32 {
	return volatile.LoadUint32(&o.ASIB1_WRITE_QOS.Reg) & 0xf
}

// AXIMX.ASIB1_FN_MOD: ASIB1 Issuing Functionality Modification Register
func (o *AXIMX_Type) SetASIB1_FN_MOD_RD_ISS(value uint32) {
	volatile.StoreUint32(&o.ASIB1_FN_MOD.Reg, volatile.LoadUint32(&o.ASIB1_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXIMX_Type) GetASIB1_FN_MOD_RD_ISS() uint32 {
	return volatile.LoadUint32(&o.ASIB1_FN_MOD.Reg) & 0x1
}
func (o *AXIMX_Type) SetASIB1_FN_MOD_WR_ISS(value uint32) {
	volatile.StoreUint32(&o.ASIB1_FN_MOD.Reg, volatile.LoadUint32(&o.ASIB1_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXIMX_Type) GetASIB1_FN_MOD_WR_ISS() uint32 {
	return (volatile.LoadUint32(&o.ASIB1_FN_MOD.Reg) & 0x2) >> 1
}

// High Speed MultiMedia Card Interface 0
type HSMCI_Type struct {
	CR    volatile.Register32    // 0x0
	MR    volatile.Register32    // 0x4
	DTOR  volatile.Register32    // 0x8
	SDCR  volatile.Register32    // 0xC
	ARGR  volatile.Register32    // 0x10
	CMDR  volatile.Register32    // 0x14
	BLKR  volatile.Register32    // 0x18
	CSTOR volatile.Register32    // 0x1C
	RSPR  [4]volatile.Register32 // 0x20
	RDR   volatile.Register32    // 0x30
	TDR   volatile.Register32    // 0x34
	_     [8]byte
	SR    volatile.Register32 // 0x40
	IER   volatile.Register32 // 0x44
	IDR   volatile.Register32 // 0x48
	IMR   volatile.Register32 // 0x4C
	DMA   volatile.Register32 // 0x50
	CFG   volatile.Register32 // 0x54
	_     [140]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [276]byte
	FIFO  [256]volatile.Register32 // 0x200
}

// HSMCI.CR: Control Register
func (o *HSMCI_Type) SetCR_MCIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetCR_MCIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *HSMCI_Type) SetCR_MCIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetCR_MCIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetCR_PWSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetCR_PWSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetCR_PWSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetCR_PWSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *HSMCI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// HSMCI.MR: Mode Register
func (o *HSMCI_Type) SetMR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff)|value)
}
func (o *HSMCI_Type) GetMR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xff
}
func (o *HSMCI_Type) SetMR_PWSDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetMR_PWSDIV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetMR_RDPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetMR_RDPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetMR_WRPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetMR_WRPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetMR_FBYTE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetMR_FBYTE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetMR_PADV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4000)|value<<14)
}
func (o *HSMCI_Type) GetMR_PADV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4000) >> 14
}
func (o *HSMCI_Type) SetMR_CLKODD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetMR_CLKODD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000) >> 16
}

// HSMCI.DTOR: Data Timeout Register
func (o *HSMCI_Type) SetDTOR_DTOCYC(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetDTOR_DTOCYC() uint32 {
	return volatile.LoadUint32(&o.DTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetDTOR_DTOMUL(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetDTOR_DTOMUL() uint32 {
	return (volatile.LoadUint32(&o.DTOR.Reg) & 0x70) >> 4
}

// HSMCI.SDCR: SD/SDIO Card Register
func (o *HSMCI_Type) SetSDCR_SDCSEL(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x3)|value)
}
func (o *HSMCI_Type) GetSDCR_SDCSEL() uint32 {
	return volatile.LoadUint32(&o.SDCR.Reg) & 0x3
}
func (o *HSMCI_Type) SetSDCR_SDCBUS(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetSDCR_SDCBUS() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0xc0) >> 6
}

// HSMCI.ARGR: Argument Register
func (o *HSMCI_Type) SetARGR(value uint32) {
	volatile.StoreUint32(&o.ARGR.Reg, value)
}
func (o *HSMCI_Type) GetARGR() uint32 {
	return volatile.LoadUint32(&o.ARGR.Reg)
}

// HSMCI.CMDR: Command Register
func (o *HSMCI_Type) SetCMDR_CMDNB(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3f)|value)
}
func (o *HSMCI_Type) GetCMDR_CMDNB() uint32 {
	return volatile.LoadUint32(&o.CMDR.Reg) & 0x3f
}
func (o *HSMCI_Type) SetCMDR_RSPTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetCMDR_RSPTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0xc0) >> 6
}
func (o *HSMCI_Type) SetCMDR_SPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetCMDR_SPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetCMDR_OPDCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetCMDR_OPDCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetCMDR_MAXLAT(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetCMDR_MAXLAT() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetCMDR_TRCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x30000)|value<<16)
}
func (o *HSMCI_Type) GetCMDR_TRCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x30000) >> 16
}
func (o *HSMCI_Type) SetCMDR_TRDIR(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetCMDR_TRDIR() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetCMDR_TRTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x380000)|value<<19)
}
func (o *HSMCI_Type) GetCMDR_TRTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x380000) >> 19
}
func (o *HSMCI_Type) SetCMDR_IOSPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3000000)|value<<24)
}
func (o *HSMCI_Type) GetCMDR_IOSPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x3000000) >> 24
}
func (o *HSMCI_Type) SetCMDR_ATACS(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetCMDR_ATACS() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetCMDR_BOOT_ACK(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetCMDR_BOOT_ACK() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x8000000) >> 27
}

// HSMCI.BLKR: Block Register
func (o *HSMCI_Type) SetBLKR_BCNT(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff)|value)
}
func (o *HSMCI_Type) GetBLKR_BCNT() uint32 {
	return volatile.LoadUint32(&o.BLKR.Reg) & 0xffff
}
func (o *HSMCI_Type) SetBLKR_BLKLEN(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff0000)|value<<16)
}
func (o *HSMCI_Type) GetBLKR_BLKLEN() uint32 {
	return (volatile.LoadUint32(&o.BLKR.Reg) & 0xffff0000) >> 16
}

// HSMCI.CSTOR: Completion Signal Timeout Register
func (o *HSMCI_Type) SetCSTOR_CSTOCYC(value uint32) {
	volatile.StoreUint32(&o.CSTOR.Reg, volatile.LoadUint32(&o.CSTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetCSTOR_CSTOCYC() uint32 {
	return volatile.LoadUint32(&o.CSTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetCSTOR_CSTOMUL(value uint32) {
	volatile.StoreUint32(&o.CSTOR.Reg, volatile.LoadUint32(&o.CSTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetCSTOR_CSTOMUL() uint32 {
	return (volatile.LoadUint32(&o.CSTOR.Reg) & 0x70) >> 4
}

// HSMCI.RSPR: Response Register
func (o *HSMCI_Type) SetRSPR(idx int, value uint32) {
	volatile.StoreUint32(&o.RSPR[idx].Reg, value)
}
func (o *HSMCI_Type) GetRSPR(idx int) uint32 {
	return volatile.LoadUint32(&o.RSPR[idx].Reg)
}

// HSMCI.RDR: Receive Data Register
func (o *HSMCI_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, value)
}
func (o *HSMCI_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg)
}

// HSMCI.TDR: Transmit Data Register
func (o *HSMCI_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, value)
}
func (o *HSMCI_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg)
}

// HSMCI.SR: Status Register
func (o *HSMCI_Type) SetSR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetSR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *HSMCI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetSR_BLKE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetSR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetSR_DTIP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetSR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetSR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetSR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetSR_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetSR_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetSR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetSR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetSR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetSR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetSR_RINDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetSR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetSR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetSR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetSR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetSR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetSR_RENDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetSR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetSR_RTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetSR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetSR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetSR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetSR_DTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetSR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetSR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetSR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetSR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetSR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetSR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetSR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetSR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetSR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetSR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetSR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetSR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetSR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetSR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetSR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetSR_UNRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetSR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// HSMCI.IER: Interrupt Enable Register
func (o *HSMCI_Type) SetIER_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIER_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *HSMCI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIER_BLKE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIER_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIER_DTIP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIER_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIER_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIER_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIER_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIER_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIER_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIER_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIER_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIER_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIER_RINDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIER_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIER_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIER_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIER_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIER_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIER_RENDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIER_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIER_RTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIER_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIER_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIER_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIER_DTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIER_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIER_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIER_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIER_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIER_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIER_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIER_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIER_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIER_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIER_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIER_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIER_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIER_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIER_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIER_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIER_UNRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIER_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// HSMCI.IDR: Interrupt Disable Register
func (o *HSMCI_Type) SetIDR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIDR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *HSMCI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIDR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIDR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIDR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIDR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIDR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIDR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIDR_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIDR_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIDR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIDR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIDR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIDR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIDR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIDR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIDR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIDR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIDR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIDR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIDR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIDR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIDR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIDR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIDR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIDR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIDR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIDR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIDR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIDR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIDR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIDR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIDR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIDR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIDR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIDR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIDR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIDR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIDR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIDR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIDR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIDR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIDR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIDR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// HSMCI.IMR: Interrupt Mask Register
func (o *HSMCI_Type) SetIMR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIMR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIMR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIMR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIMR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIMR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIMR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIMR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIMR_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIMR_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIMR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIMR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIMR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIMR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIMR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIMR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIMR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIMR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIMR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIMR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIMR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIMR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIMR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIMR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIMR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIMR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIMR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIMR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIMR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIMR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIMR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIMR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIMR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIMR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIMR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIMR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIMR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIMR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIMR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIMR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIMR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIMR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIMR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIMR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// HSMCI.DMA: DMA Configuration Register
func (o *HSMCI_Type) SetDMA_OFFSET(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x3)|value)
}
func (o *HSMCI_Type) GetDMA_OFFSET() uint32 {
	return volatile.LoadUint32(&o.DMA.Reg) & 0x3
}
func (o *HSMCI_Type) SetDMA_CHKSIZE(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetDMA_CHKSIZE() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x70) >> 4
}
func (o *HSMCI_Type) SetDMA_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetDMA_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetDMA_ROPT(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetDMA_ROPT() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x1000) >> 12
}

// HSMCI.CFG: Configuration Register
func (o *HSMCI_Type) SetCFG_FIFOMODE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetCFG_FIFOMODE() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *HSMCI_Type) SetCFG_FERRCTRL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetCFG_FERRCTRL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetCFG_HSMODE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetCFG_HSMODE() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetCFG_LSYNC(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetCFG_LSYNC() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}

// HSMCI.WPMR: Write Protection Mode Register
func (o *HSMCI_Type) SetWPMR_WP_EN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetWPMR_WP_EN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetWPMR_WP_KEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *HSMCI_Type) GetWPMR_WP_KEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// HSMCI.WPSR: Write Protection Status Register
func (o *HSMCI_Type) SetWPSR_WP_VS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetWPSR_WP_VS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0xf
}
func (o *HSMCI_Type) SetWPSR_WP_VSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *HSMCI_Type) GetWPSR_WP_VSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// HSMCI.FIFO: FIFO Memory Aperture0
func (o *HSMCI_Type) SetFIFO(idx int, value uint32) {
	volatile.StoreUint32(&o.FIFO[idx].Reg, value)
}
func (o *HSMCI_Type) GetFIFO(idx int) uint32 {
	return volatile.LoadUint32(&o.FIFO[idx].Reg)
}

// Serial Peripheral Interface 0
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [164]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// SPI.CR: Control Register
func (o *SPI_Type) SetCR_SPIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR_SPIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SPI_Type) SetCR_SPIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR_SPIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// SPI.MR: Mode Register
func (o *SPI_Type) SetMR_MSTR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetMR_MSTR() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *SPI_Type) SetMR_PS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetMR_PS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetMR_PCSDEC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetMR_PCSDEC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetMR_MODFDIS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetMR_MODFDIS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetMR_WDRBT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetMR_WDRBT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetMR_LLB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetMR_LLB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetMR_PCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetMR_PCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetMR_DLYBCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetMR_DLYBCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// SPI.RDR: Receive Data Register
func (o *SPI_Type) SetRDR_RD(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRDR_RD() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0xffff
}
func (o *SPI_Type) SetRDR_PCS(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetRDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.RDR.Reg) & 0xf0000) >> 16
}

// SPI.TDR: Transmit Data Register
func (o *SPI_Type) SetTDR_TD(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTDR_TD() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0xffff
}
func (o *SPI_Type) SetTDR_PCS(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetTDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetTDR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetTDR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0x1000000) >> 24
}

// SPI.SR: Status Register
func (o *SPI_Type) SetSR_RDRF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RDRF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_TDRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_OVRES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_NSSR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetSR_UNDES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetSR_UNDES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetSR_SPIENS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetSR_SPIENS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// SPI.IER: Interrupt Enable Register
func (o *SPI_Type) SetIER_RDRF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIER_RDRF() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SPI_Type) SetIER_TDRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIER_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIER_MODF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIER_MODF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIER_OVRES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIER_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIER_NSSR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIER_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIER_UNDES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIER_UNDES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}

// SPI.IDR: Interrupt Disable Register
func (o *SPI_Type) SetIDR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIDR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SPI_Type) SetIDR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIDR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIDR_MODF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIDR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIDR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIDR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIDR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIDR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIDR_UNDES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIDR_UNDES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}

// SPI.IMR: Interrupt Mask Register
func (o *SPI_Type) SetIMR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIMR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SPI_Type) SetIMR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIMR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIMR_MODF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIMR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIMR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIMR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIMR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIMR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIMR_UNDES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIMR_UNDES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}

// SPI.CSR: Chip Select Register
func (o *SPI_Type) SetCSR_CPOL(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCSR_CPOL(idx int) uint32 {
	return volatile.LoadUint32(&o.CSR[idx].Reg) & 0x1
}
func (o *SPI_Type) SetCSR_NCPHA(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCSR_NCPHA(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCSR_CSNAAT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCSR_CSNAAT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCSR_CSAAT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCSR_CSAAT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCSR_BITS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCSR_BITS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCSR_SCBR(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetCSR_SCBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff00) >> 8
}
func (o *SPI_Type) SetCSR_DLYBS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *SPI_Type) GetCSR_DLYBS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff0000) >> 16
}
func (o *SPI_Type) SetCSR_DLYBCT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetCSR_DLYBCT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff000000) >> 24
}

// SPI.WPMR: Write Protection Control Register
func (o *SPI_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *SPI_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SPI_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// SPI.WPSR: Write Protection Status Register
func (o *SPI_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *SPI_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xff00) >> 8
}

// Synchronous Serial Controller 0
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// SSC.CR: Control Register
func (o *SSC_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetCR_RXEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SSC_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *SSC_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}

// SSC.CMR: Clock Mode Register
func (o *SSC_Type) SetCMR_DIV(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xfff)|value)
}
func (o *SSC_Type) GetCMR_DIV() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0xfff
}

// SSC.RCMR: Receive Clock Mode Register
func (o *SSC_Type) SetRCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetRCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.RCMR.Reg) & 0x3
}
func (o *SSC_Type) SetRCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetRCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetRCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetRCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetRCMR_START(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRCMR_START() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRCMR_STOP(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1000)|value<<12)
}
func (o *SSC_Type) GetRCMR_STOP() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1000) >> 12
}
func (o *SSC_Type) SetRCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetRCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetRCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetRCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff000000) >> 24
}

// SSC.RFMR: Receive Frame Mode Register
func (o *SSC_Type) SetRFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetRFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.RFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetRFMR_LOOP(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRFMR_LOOP() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetRFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetRFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetRFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetRFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetRFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetRFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetRFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetRFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetRFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000000) >> 28
}

// SSC.TCMR: Transmit Clock Mode Register
func (o *SSC_Type) SetTCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetTCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.TCMR.Reg) & 0x3
}
func (o *SSC_Type) SetTCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetTCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetTCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetTCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetTCMR_START(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTCMR_START() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetTCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetTCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetTCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff000000) >> 24
}

// SSC.TFMR: Transmit Frame Mode Register
func (o *SSC_Type) SetTFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetTFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.TFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetTFMR_DATDEF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTFMR_DATDEF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetTFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetTFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetTFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetTFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetTFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetTFMR_FSDEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x800000)|value<<23)
}
func (o *SSC_Type) GetTFMR_FSDEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x800000) >> 23
}
func (o *SSC_Type) SetTFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetTFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetTFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetTFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000000) >> 28
}

// SSC.RHR: Receive Holding Register
func (o *SSC_Type) SetRHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, value)
}
func (o *SSC_Type) GetRHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg)
}

// SSC.THR: Transmit Holding Register
func (o *SSC_Type) SetTHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, value)
}
func (o *SSC_Type) GetTHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg)
}

// SSC.RSHR: Receive Sync. Holding Register
func (o *SSC_Type) SetRSHR_RSDAT(value uint32) {
	volatile.StoreUint32(&o.RSHR.Reg, volatile.LoadUint32(&o.RSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRSHR_RSDAT() uint32 {
	return volatile.LoadUint32(&o.RSHR.Reg) & 0xffff
}

// SSC.TSHR: Transmit Sync. Holding Register
func (o *SSC_Type) SetTSHR_TSDAT(value uint32) {
	volatile.StoreUint32(&o.TSHR.Reg, volatile.LoadUint32(&o.TSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTSHR_TSDAT() uint32 {
	return volatile.LoadUint32(&o.TSHR.Reg) & 0xffff
}

// SSC.RC0R: Receive Compare 0 Register
func (o *SSC_Type) SetRC0R_CP0(value uint32) {
	volatile.StoreUint32(&o.RC0R.Reg, volatile.LoadUint32(&o.RC0R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC0R_CP0() uint32 {
	return volatile.LoadUint32(&o.RC0R.Reg) & 0xffff
}

// SSC.RC1R: Receive Compare 1 Register
func (o *SSC_Type) SetRC1R_CP1(value uint32) {
	volatile.StoreUint32(&o.RC1R.Reg, volatile.LoadUint32(&o.RC1R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC1R_CP1() uint32 {
	return volatile.LoadUint32(&o.RC1R.Reg) & 0xffff
}

// SSC.SR: Status Register
func (o *SSC_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetSR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SSC_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetSR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetSR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetSR_CP0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetSR_CP0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetSR_CP1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetSR_CP1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetSR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetSR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetSR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetSR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *SSC_Type) SetSR_TXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SSC_Type) GetSR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *SSC_Type) SetSR_RXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SSC_Type) GetSR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// SSC.IER: Interrupt Enable Register
func (o *SSC_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIER_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SSC_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIER_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIER_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIER_CP0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIER_CP0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIER_CP1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIER_CP1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIER_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIER_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIER_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIER_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}

// SSC.IDR: Interrupt Disable Register
func (o *SSC_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIDR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SSC_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIDR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIDR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIDR_CP0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIDR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIDR_CP1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIDR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIDR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIDR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIDR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIDR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}

// SSC.IMR: Interrupt Mask Register
func (o *SSC_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SSC_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIMR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIMR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIMR_CP0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIMR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIMR_CP1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIMR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIMR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIMR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIMR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIMR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}

// SSC.WPMR: Write Protect Mode Register
func (o *SSC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *SSC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SSC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// Timer Counter 0
type TC_Type struct {
	CCR0  volatile.Register32 // 0x0
	CMR0  volatile.Register32 // 0x4
	SMMR0 volatile.Register32 // 0x8
	RAB0  volatile.Register32 // 0xC
	CV0   volatile.Register32 // 0x10
	RA0   volatile.Register32 // 0x14
	RB0   volatile.Register32 // 0x18
	RC0   volatile.Register32 // 0x1C
	SR0   volatile.Register32 // 0x20
	IER0  volatile.Register32 // 0x24
	IDR0  volatile.Register32 // 0x28
	IMR0  volatile.Register32 // 0x2C
	_     [16]byte
	CCR1  volatile.Register32 // 0x40
	CMR1  volatile.Register32 // 0x44
	SMMR1 volatile.Register32 // 0x48
	RAB1  volatile.Register32 // 0x4C
	CV1   volatile.Register32 // 0x50
	RA1   volatile.Register32 // 0x54
	RB1   volatile.Register32 // 0x58
	RC1   volatile.Register32 // 0x5C
	SR1   volatile.Register32 // 0x60
	IER1  volatile.Register32 // 0x64
	IDR1  volatile.Register32 // 0x68
	IMR1  volatile.Register32 // 0x6C
	_     [16]byte
	CCR2  volatile.Register32 // 0x80
	CMR2  volatile.Register32 // 0x84
	SMMR2 volatile.Register32 // 0x88
	RAB2  volatile.Register32 // 0x8C
	CV2   volatile.Register32 // 0x90
	RA2   volatile.Register32 // 0x94
	RB2   volatile.Register32 // 0x98
	RC2   volatile.Register32 // 0x9C
	SR2   volatile.Register32 // 0xA0
	IER2  volatile.Register32 // 0xA4
	IDR2  volatile.Register32 // 0xA8
	IMR2  volatile.Register32 // 0xAC
	_     [16]byte
	BCR   volatile.Register32 // 0xC0
	BMR   volatile.Register32 // 0xC4
	QIER  volatile.Register32 // 0xC8
	QIDR  volatile.Register32 // 0xCC
	QIMR  volatile.Register32 // 0xD0
	QISR  volatile.Register32 // 0xD4
	_     [12]byte
	WPMR  volatile.Register32 // 0xE4
}

// TC.CCR0: Channel Control Register (channel = 0)
func (o *TC_Type) SetCCR0_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR0_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR0.Reg) & 0x1
}
func (o *TC_Type) SetCCR0_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR0_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR0_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR0_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x4) >> 2
}

// TC.CMR0: Channel Mode Register (channel = 0)
func (o *TC_Type) SetCMR0_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR0_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0x7
}
func (o *TC_Type) SetCMR0_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR0_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR0_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR0_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR0_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR0_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR0_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR0_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR0_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR0_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR0_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR0_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR0_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR0_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR0_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR0_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR0_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR0_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR0_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR0_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0xc0000) >> 18
}

// TC.SMMR0: Stepper Motor Mode Register (channel = 0)
func (o *TC_Type) SetSMMR0_GCEN(value uint32) {
	volatile.StoreUint32(&o.SMMR0.Reg, volatile.LoadUint32(&o.SMMR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSMMR0_GCEN() uint32 {
	return volatile.LoadUint32(&o.SMMR0.Reg) & 0x1
}
func (o *TC_Type) SetSMMR0_DOWN(value uint32) {
	volatile.StoreUint32(&o.SMMR0.Reg, volatile.LoadUint32(&o.SMMR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSMMR0_DOWN() uint32 {
	return (volatile.LoadUint32(&o.SMMR0.Reg) & 0x2) >> 1
}

// TC.RAB0: Register AB (channel = 0)
func (o *TC_Type) SetRAB0(value uint32) {
	volatile.StoreUint32(&o.RAB0.Reg, value)
}
func (o *TC_Type) GetRAB0() uint32 {
	return volatile.LoadUint32(&o.RAB0.Reg)
}

// TC.CV0: Counter Value (channel = 0)
func (o *TC_Type) SetCV0(value uint32) {
	volatile.StoreUint32(&o.CV0.Reg, value)
}
func (o *TC_Type) GetCV0() uint32 {
	return volatile.LoadUint32(&o.CV0.Reg)
}

// TC.RA0: Register A (channel = 0)
func (o *TC_Type) SetRA0(value uint32) {
	volatile.StoreUint32(&o.RA0.Reg, value)
}
func (o *TC_Type) GetRA0() uint32 {
	return volatile.LoadUint32(&o.RA0.Reg)
}

// TC.RB0: Register B (channel = 0)
func (o *TC_Type) SetRB0(value uint32) {
	volatile.StoreUint32(&o.RB0.Reg, value)
}
func (o *TC_Type) GetRB0() uint32 {
	return volatile.LoadUint32(&o.RB0.Reg)
}

// TC.RC0: Register C (channel = 0)
func (o *TC_Type) SetRC0(value uint32) {
	volatile.StoreUint32(&o.RC0.Reg, value)
}
func (o *TC_Type) GetRC0() uint32 {
	return volatile.LoadUint32(&o.RC0.Reg)
}

// TC.SR0: Status Register (channel = 0)
func (o *TC_Type) SetSR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR0.Reg) & 0x1
}
func (o *TC_Type) SetSR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR0_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR0_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR0_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR0_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR0_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR0_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40000) >> 18
}

// TC.IER0: Interrupt Enable Register (channel = 0)
func (o *TC_Type) SetIER0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER0.Reg) & 0x1
}
func (o *TC_Type) SetIER0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x80) >> 7
}

// TC.IDR0: Interrupt Disable Register (channel = 0)
func (o *TC_Type) SetIDR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR0.Reg) & 0x1
}
func (o *TC_Type) SetIDR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x80) >> 7
}

// TC.IMR0: Interrupt Mask Register (channel = 0)
func (o *TC_Type) SetIMR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR0.Reg) & 0x1
}
func (o *TC_Type) SetIMR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x80) >> 7
}

// TC.CCR1: Channel Control Register (channel = 1)
func (o *TC_Type) SetCCR1_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR1_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0x1
}
func (o *TC_Type) SetCCR1_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR1_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR1_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR1_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4) >> 2
}

// TC.CMR1: Channel Mode Register (channel = 1)
func (o *TC_Type) SetCMR1_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR1_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0x7
}
func (o *TC_Type) SetCMR1_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR1_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR1_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR1_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR1_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR1_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR1_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR1_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR1_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR1_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR1_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR1_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR1_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR1_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR1_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR1_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR1_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR1_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR1_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR1_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0xc0000) >> 18
}

// TC.SMMR1: Stepper Motor Mode Register (channel = 1)
func (o *TC_Type) SetSMMR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.SMMR1.Reg, volatile.LoadUint32(&o.SMMR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSMMR1_GCEN() uint32 {
	return volatile.LoadUint32(&o.SMMR1.Reg) & 0x1
}
func (o *TC_Type) SetSMMR1_DOWN(value uint32) {
	volatile.StoreUint32(&o.SMMR1.Reg, volatile.LoadUint32(&o.SMMR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSMMR1_DOWN() uint32 {
	return (volatile.LoadUint32(&o.SMMR1.Reg) & 0x2) >> 1
}

// TC.RAB1: Register AB (channel = 1)
func (o *TC_Type) SetRAB1(value uint32) {
	volatile.StoreUint32(&o.RAB1.Reg, value)
}
func (o *TC_Type) GetRAB1() uint32 {
	return volatile.LoadUint32(&o.RAB1.Reg)
}

// TC.CV1: Counter Value (channel = 1)
func (o *TC_Type) SetCV1(value uint32) {
	volatile.StoreUint32(&o.CV1.Reg, value)
}
func (o *TC_Type) GetCV1() uint32 {
	return volatile.LoadUint32(&o.CV1.Reg)
}

// TC.RA1: Register A (channel = 1)
func (o *TC_Type) SetRA1(value uint32) {
	volatile.StoreUint32(&o.RA1.Reg, value)
}
func (o *TC_Type) GetRA1() uint32 {
	return volatile.LoadUint32(&o.RA1.Reg)
}

// TC.RB1: Register B (channel = 1)
func (o *TC_Type) SetRB1(value uint32) {
	volatile.StoreUint32(&o.RB1.Reg, value)
}
func (o *TC_Type) GetRB1() uint32 {
	return volatile.LoadUint32(&o.RB1.Reg)
}

// TC.RC1: Register C (channel = 1)
func (o *TC_Type) SetRC1(value uint32) {
	volatile.StoreUint32(&o.RC1.Reg, value)
}
func (o *TC_Type) GetRC1() uint32 {
	return volatile.LoadUint32(&o.RC1.Reg)
}

// TC.SR1: Status Register (channel = 1)
func (o *TC_Type) SetSR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}
func (o *TC_Type) SetSR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR1_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR1_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR1_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR1_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR1_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR1_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40000) >> 18
}

// TC.IER1: Interrupt Enable Register (channel = 1)
func (o *TC_Type) SetIER1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *TC_Type) SetIER1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80) >> 7
}

// TC.IDR1: Interrupt Disable Register (channel = 1)
func (o *TC_Type) SetIDR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR1.Reg) & 0x1
}
func (o *TC_Type) SetIDR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80) >> 7
}

// TC.IMR1: Interrupt Mask Register (channel = 1)
func (o *TC_Type) SetIMR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *TC_Type) SetIMR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}

// TC.CCR2: Channel Control Register (channel = 2)
func (o *TC_Type) SetCCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR2_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0x1
}
func (o *TC_Type) SetCCR2_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR2_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR2_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR2_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4) >> 2
}

// TC.CMR2: Channel Mode Register (channel = 2)
func (o *TC_Type) SetCMR2_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR2_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0x7
}
func (o *TC_Type) SetCMR2_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR2_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR2_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR2_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR2_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR2_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR2_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR2_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR2_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR2_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR2_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR2_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR2_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR2_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR2_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR2_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR2_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR2_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR2_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR2_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0xc0000) >> 18
}

// TC.SMMR2: Stepper Motor Mode Register (channel = 2)
func (o *TC_Type) SetSMMR2_GCEN(value uint32) {
	volatile.StoreUint32(&o.SMMR2.Reg, volatile.LoadUint32(&o.SMMR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSMMR2_GCEN() uint32 {
	return volatile.LoadUint32(&o.SMMR2.Reg) & 0x1
}
func (o *TC_Type) SetSMMR2_DOWN(value uint32) {
	volatile.StoreUint32(&o.SMMR2.Reg, volatile.LoadUint32(&o.SMMR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSMMR2_DOWN() uint32 {
	return (volatile.LoadUint32(&o.SMMR2.Reg) & 0x2) >> 1
}

// TC.RAB2: Register AB (channel = 2)
func (o *TC_Type) SetRAB2(value uint32) {
	volatile.StoreUint32(&o.RAB2.Reg, value)
}
func (o *TC_Type) GetRAB2() uint32 {
	return volatile.LoadUint32(&o.RAB2.Reg)
}

// TC.CV2: Counter Value (channel = 2)
func (o *TC_Type) SetCV2(value uint32) {
	volatile.StoreUint32(&o.CV2.Reg, value)
}
func (o *TC_Type) GetCV2() uint32 {
	return volatile.LoadUint32(&o.CV2.Reg)
}

// TC.RA2: Register A (channel = 2)
func (o *TC_Type) SetRA2(value uint32) {
	volatile.StoreUint32(&o.RA2.Reg, value)
}
func (o *TC_Type) GetRA2() uint32 {
	return volatile.LoadUint32(&o.RA2.Reg)
}

// TC.RB2: Register B (channel = 2)
func (o *TC_Type) SetRB2(value uint32) {
	volatile.StoreUint32(&o.RB2.Reg, value)
}
func (o *TC_Type) GetRB2() uint32 {
	return volatile.LoadUint32(&o.RB2.Reg)
}

// TC.RC2: Register C (channel = 2)
func (o *TC_Type) SetRC2(value uint32) {
	volatile.StoreUint32(&o.RC2.Reg, value)
}
func (o *TC_Type) GetRC2() uint32 {
	return volatile.LoadUint32(&o.RC2.Reg)
}

// TC.SR2: Status Register (channel = 2)
func (o *TC_Type) SetSR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR2.Reg) & 0x1
}
func (o *TC_Type) SetSR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR2_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR2_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR2_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR2_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR2_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR2_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40000) >> 18
}

// TC.IER2: Interrupt Enable Register (channel = 2)
func (o *TC_Type) SetIER2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER2.Reg) & 0x1
}
func (o *TC_Type) SetIER2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x80) >> 7
}

// TC.IDR2: Interrupt Disable Register (channel = 2)
func (o *TC_Type) SetIDR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR2.Reg) & 0x1
}
func (o *TC_Type) SetIDR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x80) >> 7
}

// TC.IMR2: Interrupt Mask Register (channel = 2)
func (o *TC_Type) SetIMR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *TC_Type) SetIMR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80) >> 7
}

// TC.BCR: Block Control Register
func (o *TC_Type) SetBCR_SYNC(value uint32) {
	volatile.StoreUint32(&o.BCR.Reg, volatile.LoadUint32(&o.BCR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetBCR_SYNC() uint32 {
	return volatile.LoadUint32(&o.BCR.Reg) & 0x1
}

// TC.BMR: Block Mode Register
func (o *TC_Type) SetBMR_TC0XC0S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3)|value)
}
func (o *TC_Type) GetBMR_TC0XC0S() uint32 {
	return volatile.LoadUint32(&o.BMR.Reg) & 0x3
}
func (o *TC_Type) SetBMR_TC1XC1S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0xc)|value<<2)
}
func (o *TC_Type) GetBMR_TC1XC1S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0xc) >> 2
}
func (o *TC_Type) SetBMR_TC2XC2S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetBMR_TC2XC2S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetBMR_QDEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x100)|value<<8)
}
func (o *TC_Type) GetBMR_QDEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x100) >> 8
}
func (o *TC_Type) SetBMR_POSEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x200)|value<<9)
}
func (o *TC_Type) GetBMR_POSEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x200) >> 9
}
func (o *TC_Type) SetBMR_SPEEDEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetBMR_SPEEDEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetBMR_QDTRANS(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x800)|value<<11)
}
func (o *TC_Type) GetBMR_QDTRANS() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x800) >> 11
}
func (o *TC_Type) SetBMR_EDGPHA(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x1000)|value<<12)
}
func (o *TC_Type) GetBMR_EDGPHA() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x1000) >> 12
}
func (o *TC_Type) SetBMR_INVA(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x2000)|value<<13)
}
func (o *TC_Type) GetBMR_INVA() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x2000) >> 13
}
func (o *TC_Type) SetBMR_INVB(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetBMR_INVB() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetBMR_INVIDX(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetBMR_INVIDX() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetBMR_SWAP(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetBMR_SWAP() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetBMR_IDXPHB(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetBMR_IDXPHB() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetBMR_FILTER(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x80000)|value<<19)
}
func (o *TC_Type) GetBMR_FILTER() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x80000) >> 19
}
func (o *TC_Type) SetBMR_MAXFILT(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3f00000)|value<<20)
}
func (o *TC_Type) GetBMR_MAXFILT() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x3f00000) >> 20
}

// TC.QIER: QDEC Interrupt Enable Register
func (o *TC_Type) SetQIER_IDX(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIER_IDX() uint32 {
	return volatile.LoadUint32(&o.QIER.Reg) & 0x1
}
func (o *TC_Type) SetQIER_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIER_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIER.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIER_QERR(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIER_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIER.Reg) & 0x4) >> 2
}

// TC.QIDR: QDEC Interrupt Disable Register
func (o *TC_Type) SetQIDR_IDX(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIDR_IDX() uint32 {
	return volatile.LoadUint32(&o.QIDR.Reg) & 0x1
}
func (o *TC_Type) SetQIDR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIDR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIDR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIDR_QERR(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIDR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIDR.Reg) & 0x4) >> 2
}

// TC.QIMR: QDEC Interrupt Mask Register
func (o *TC_Type) SetQIMR_IDX(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIMR_IDX() uint32 {
	return volatile.LoadUint32(&o.QIMR.Reg) & 0x1
}
func (o *TC_Type) SetQIMR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIMR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIMR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIMR_QERR(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIMR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIMR.Reg) & 0x4) >> 2
}

// TC.QISR: QDEC Interrupt Status Register
func (o *TC_Type) SetQISR_IDX(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQISR_IDX() uint32 {
	return volatile.LoadUint32(&o.QISR.Reg) & 0x1
}
func (o *TC_Type) SetQISR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQISR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQISR_QERR(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQISR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetQISR_DIR(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x100)|value<<8)
}
func (o *TC_Type) GetQISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x100) >> 8
}

// TC.WPMR: Write Protect Mode Register
func (o *TC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *TC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *TC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// Two-wire Interface 0
type TWI_Type struct {
	CR           volatile.Register32 // 0x0
	MMR          volatile.Register32 // 0x4
	SMR          volatile.Register32 // 0x8
	IADR         volatile.Register32 // 0xC
	CWGR         volatile.Register32 // 0x10
	_            [12]byte
	SR           volatile.Register32 // 0x20
	IER          volatile.Register32 // 0x24
	IDR          volatile.Register32 // 0x28
	IMR          volatile.Register32 // 0x2C
	RHR          volatile.Register32 // 0x30
	THR          volatile.Register32 // 0x34
	_            [172]byte
	WPROT_MODE   volatile.Register32 // 0xE4
	WPROT_STATUS volatile.Register32 // 0xE8
}

// TWI.CR: Control Register
func (o *TWI_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *TWI_Type) SetCR_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetCR_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetCR_MSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetCR_MSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetCR_MSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetCR_MSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetCR_SVEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetCR_SVEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetCR_SVDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetCR_SVDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetCR_QUICK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetCR_QUICK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *TWI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// TWI.MMR: Master Mode Register
func (o *TWI_Type) SetMMR_IADRSZ(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x300)|value<<8)
}
func (o *TWI_Type) GetMMR_IADRSZ() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x300) >> 8
}
func (o *TWI_Type) SetMMR_MREAD(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetMMR_MREAD() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetMMR_DADR(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetMMR_DADR() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x7f0000) >> 16
}

// TWI.SMR: Slave Mode Register
func (o *TWI_Type) SetSMR_SADR(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetSMR_SADR() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x7f0000) >> 16
}

// TWI.IADR: Internal Address Register
func (o *TWI_Type) SetIADR(value uint32) {
	volatile.StoreUint32(&o.IADR.Reg, volatile.LoadUint32(&o.IADR.Reg)&^(0xffffff)|value)
}
func (o *TWI_Type) GetIADR() uint32 {
	return volatile.LoadUint32(&o.IADR.Reg) & 0xffffff
}

// TWI.CWGR: Clock Waveform Generator Register
func (o *TWI_Type) SetCWGR_CLDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetCWGR_CLDIV() uint32 {
	return volatile.LoadUint32(&o.CWGR.Reg) & 0xff
}
func (o *TWI_Type) SetCWGR_CHDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff00)|value<<8)
}
func (o *TWI_Type) GetCWGR_CHDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0xff00) >> 8
}
func (o *TWI_Type) SetCWGR_CKDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0x70000)|value<<16)
}
func (o *TWI_Type) GetCWGR_CKDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0x70000) >> 16
}

// TWI.SR: Status Register
func (o *TWI_Type) SetSR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetSR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TWI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetSR_SVREAD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetSR_SVREAD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetSR_SVACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetSR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetSR_GACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetSR_GACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetSR_NACK(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetSR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetSR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetSR_SCLWS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetSR_SCLWS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetSR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetSR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}

// TWI.IER: Interrupt Enable Register
func (o *TWI_Type) SetIER_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIER_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TWI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIER_SVACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIER_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIER_GACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIER_GACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIER_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIER_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIER_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIER_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIER_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIER_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}

// TWI.IDR: Interrupt Disable Register
func (o *TWI_Type) SetIDR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIDR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *TWI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIDR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIDR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIDR_GACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIDR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIDR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIDR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIDR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIDR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIDR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIDR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}

// TWI.IMR: Interrupt Mask Register
func (o *TWI_Type) SetIMR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIMR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *TWI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIMR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIMR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIMR_GACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIMR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIMR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIMR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIMR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIMR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIMR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIMR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}

// TWI.RHR: Receive Holding Register
func (o *TWI_Type) SetRHR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetRHR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// TWI.THR: Transmit Holding Register
func (o *TWI_Type) SetTHR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetTHR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// TWI.WPROT_MODE: Protection Mode Register
func (o *TWI_Type) SetWPROT_MODE_WPROT(value uint32) {
	volatile.StoreUint32(&o.WPROT_MODE.Reg, volatile.LoadUint32(&o.WPROT_MODE.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetWPROT_MODE_WPROT() uint32 {
	return volatile.LoadUint32(&o.WPROT_MODE.Reg) & 0x1
}
func (o *TWI_Type) SetWPROT_MODE_SECURITY_CODE(value uint32) {
	volatile.StoreUint32(&o.WPROT_MODE.Reg, volatile.LoadUint32(&o.WPROT_MODE.Reg)&^(0xffffff00)|value<<8)
}
func (o *TWI_Type) GetWPROT_MODE_SECURITY_CODE() uint32 {
	return (volatile.LoadUint32(&o.WPROT_MODE.Reg) & 0xffffff00) >> 8
}

// TWI.WPROT_STATUS: Protection Status Register
func (o *TWI_Type) SetWPROT_STATUS_WPROTERR(value uint32) {
	volatile.StoreUint32(&o.WPROT_STATUS.Reg, volatile.LoadUint32(&o.WPROT_STATUS.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetWPROT_STATUS_WPROTERR() uint32 {
	return volatile.LoadUint32(&o.WPROT_STATUS.Reg) & 0x1
}
func (o *TWI_Type) SetWPROT_STATUS_WPROTADDR(value uint32) {
	volatile.StoreUint32(&o.WPROT_STATUS.Reg, volatile.LoadUint32(&o.WPROT_STATUS.Reg)&^(0xffffff00)|value<<8)
}
func (o *TWI_Type) GetWPROT_STATUS_WPROTADDR() uint32 {
	return (volatile.LoadUint32(&o.WPROT_STATUS.Reg) & 0xffffff00) >> 8
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	RTOR volatile.Register32 // 0x24
	TTGR volatile.Register32 // 0x28
	_    [20]byte
	FIDI volatile.Register32 // 0x40
	NER  volatile.Register32 // 0x44
	_    [4]byte
	IF   volatile.Register32 // 0x4C
	MAN  volatile.Register32 // 0x50
	_    [144]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// USART.CR: Control Register
func (o *USART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR_STTBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR_STTBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR_STPBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR_STPBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR_STTTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR_STTTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR_SENDA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR_SENDA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR_RSTIT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR_RSTIT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR_RSTNACK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR_RSTNACK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR_RETTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR_RETTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR_RTSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR_RTSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR_RTSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR_RTSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}

// USART.MR: Mode Register
func (o *USART_Type) SetMR_USART_MODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMR_USART_MODE() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xf
}
func (o *USART_Type) SetMR_USCLKS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30)|value<<4)
}
func (o *USART_Type) GetMR_USCLKS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30) >> 4
}
func (o *USART_Type) SetMR_CHRL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc0)|value<<6)
}
func (o *USART_Type) GetMR_CHRL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc0) >> 6
}
func (o *USART_Type) SetMR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetMR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *USART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *USART_Type) SetMR_NBSTOP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetMR_NBSTOP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *USART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}
func (o *USART_Type) SetMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetMR_MODE9(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetMR_MODE9() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetMR_CLKO(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetMR_CLKO() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetMR_OVER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetMR_OVER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetMR_INACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetMR_INACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetMR_DSNACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetMR_DSNACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetMR_VAR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetMR_VAR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetMR_INVDATA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetMR_INVDATA() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetMR_MAX_ITERATION(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7000000)|value<<24)
}
func (o *USART_Type) GetMR_MAX_ITERATION() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7000000) >> 24
}
func (o *USART_Type) SetMR_FILTER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMR_FILTER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMR_MAN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMR_MAN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMR_MODSYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMR_MODSYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000000) >> 30
}
func (o *USART_Type) SetMR_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *USART_Type) GetMR_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// USART.IER: Interrupt Enable Register
func (o *USART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *USART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIER_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIER_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIER_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIER_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIER_ITER(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIER_ITER() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIER_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIER_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIER_MANE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIER_MANE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}

// USART.IDR: Interrupt Disable Register
func (o *USART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *USART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIDR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIDR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIDR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIDR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIDR_ITER(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIDR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIDR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIDR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIDR_MANE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIDR_MANE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}

// USART.IMR: Interrupt Mask Register
func (o *USART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *USART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIMR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIMR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIMR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIMR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIMR_ITER(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIMR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIMR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIMR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIMR_MANE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIMR_MANE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}

// USART.CSR: Channel Status Register
func (o *USART_Type) SetCSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *USART_Type) SetCSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCSR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCSR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCSR_PARE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCSR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCSR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCSR_ITER(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCSR_ITER() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCSR_NACK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCSR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCSR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCSR_CTS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCSR_MANERR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetCSR_MANERR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}

// USART.RHR: Receiver Holding Register
func (o *USART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0x1ff
}
func (o *USART_Type) SetRHR_RXSYNH(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetRHR_RXSYNH() uint32 {
	return (volatile.LoadUint32(&o.RHR.Reg) & 0x8000) >> 15
}

// USART.THR: Transmitter Holding Register
func (o *USART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0x1ff
}
func (o *USART_Type) SetTHR_TXSYNH(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetTHR_TXSYNH() uint32 {
	return (volatile.LoadUint32(&o.THR.Reg) & 0x8000) >> 15
}

// USART.BRGR: Baud Rate Generator Register
func (o *USART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}
func (o *USART_Type) SetBRGR_FP(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0x70000)|value<<16)
}
func (o *USART_Type) GetBRGR_FP() uint32 {
	return (volatile.LoadUint32(&o.BRGR.Reg) & 0x70000) >> 16
}

// USART.RTOR: Receiver Time-out Register
func (o *USART_Type) SetRTOR_TO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRTOR_TO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffff
}

// USART.TTGR: Transmitter Timeguard Register
func (o *USART_Type) SetTTGR_TG(value uint32) {
	volatile.StoreUint32(&o.TTGR.Reg, volatile.LoadUint32(&o.TTGR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetTTGR_TG() uint32 {
	return volatile.LoadUint32(&o.TTGR.Reg) & 0xff
}

// USART.FIDI: FI DI Ratio Register
func (o *USART_Type) SetFIDI_FI_DI_RATIO(value uint32) {
	volatile.StoreUint32(&o.FIDI.Reg, volatile.LoadUint32(&o.FIDI.Reg)&^(0x7ff)|value)
}
func (o *USART_Type) GetFIDI_FI_DI_RATIO() uint32 {
	return volatile.LoadUint32(&o.FIDI.Reg) & 0x7ff
}

// USART.NER: Number of Errors Register
func (o *USART_Type) SetNER_NB_ERRORS(value uint32) {
	volatile.StoreUint32(&o.NER.Reg, volatile.LoadUint32(&o.NER.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetNER_NB_ERRORS() uint32 {
	return volatile.LoadUint32(&o.NER.Reg) & 0xff
}

// USART.IF: IrDA Filter Register
func (o *USART_Type) SetIF_IRDA_FILTER(value uint32) {
	volatile.StoreUint32(&o.IF.Reg, volatile.LoadUint32(&o.IF.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetIF_IRDA_FILTER() uint32 {
	return volatile.LoadUint32(&o.IF.Reg) & 0xff
}

// USART.MAN: Manchester Encoder Decoder Register
func (o *USART_Type) SetMAN_TX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMAN_TX_PL() uint32 {
	return volatile.LoadUint32(&o.MAN.Reg) & 0xf
}
func (o *USART_Type) SetMAN_TX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x300)|value<<8)
}
func (o *USART_Type) GetMAN_TX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x300) >> 8
}
func (o *USART_Type) SetMAN_TX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetMAN_TX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetMAN_RX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf0000)|value<<16)
}
func (o *USART_Type) GetMAN_RX_PL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xf0000) >> 16
}
func (o *USART_Type) SetMAN_RX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x3000000)|value<<24)
}
func (o *USART_Type) GetMAN_RX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x3000000) >> 24
}
func (o *USART_Type) SetMAN_RX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMAN_RX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMAN_ONE(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMAN_ONE() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMAN_DRIFT(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMAN_DRIFT() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x40000000) >> 30
}

// USART.WPMR: Write Protect Mode Register
func (o *USART_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *USART_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// USART.WPSR: Write Protect Status Register
func (o *USART_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *USART_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *USART_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Universal Asynchronous Receiver Transmitter 0
type UART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
}

// UART.CR: Control Register
func (o *UART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// UART.MR: Mode Register
func (o *UART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *UART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *UART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *UART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}

// UART.IER: Interrupt Enable Register
func (o *UART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *UART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}

// UART.IDR: Interrupt Disable Register
func (o *UART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *UART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}

// UART.IMR: Interrupt Mask Register
func (o *UART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *UART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}

// UART.SR: Status Register
func (o *UART_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *UART_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetSR_PARE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}

// UART.RHR: Receive Holding Register
func (o *UART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// UART.THR: Transmit Holding Register
func (o *UART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// UART.BRGR: Baud Rate Generator Register
func (o *UART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	CLK      volatile.Register32 // 0x0
	ENA      volatile.Register32 // 0x4
	DIS      volatile.Register32 // 0x8
	SR       volatile.Register32 // 0xC
	IER1     volatile.Register32 // 0x10
	IDR1     volatile.Register32 // 0x14
	IMR1     volatile.Register32 // 0x18
	ISR1     volatile.Register32 // 0x1C
	SCM      volatile.Register32 // 0x20
	_        [4]byte
	SCUC     volatile.Register32 // 0x28
	SCUP     volatile.Register32 // 0x2C
	SCUPUPD  volatile.Register32 // 0x30
	IER2     volatile.Register32 // 0x34
	IDR2     volatile.Register32 // 0x38
	IMR2     volatile.Register32 // 0x3C
	ISR2     volatile.Register32 // 0x40
	OOV      volatile.Register32 // 0x44
	OS       volatile.Register32 // 0x48
	OSS      volatile.Register32 // 0x4C
	OSC      volatile.Register32 // 0x50
	OSSUPD   volatile.Register32 // 0x54
	OSCUPD   volatile.Register32 // 0x58
	FMR      volatile.Register32 // 0x5C
	FSR      volatile.Register32 // 0x60
	FCR      volatile.Register32 // 0x64
	FPV      volatile.Register32 // 0x68
	FPE      volatile.Register32 // 0x6C
	_        [12]byte
	ELMR     [2]volatile.Register32 // 0x7C
	_        [44]byte
	SMMR     volatile.Register32 // 0xB0
	_        [48]byte
	WPCR     volatile.Register32 // 0xE4
	WPSR     volatile.Register32 // 0xE8
	_        [68]byte
	CMPV0    volatile.Register32 // 0x130
	CMPVUPD0 volatile.Register32 // 0x134
	CMPM0    volatile.Register32 // 0x138
	CMPMUPD0 volatile.Register32 // 0x13C
	CMPV1    volatile.Register32 // 0x140
	CMPVUPD1 volatile.Register32 // 0x144
	CMPM1    volatile.Register32 // 0x148
	CMPMUPD1 volatile.Register32 // 0x14C
	CMPV2    volatile.Register32 // 0x150
	CMPVUPD2 volatile.Register32 // 0x154
	CMPM2    volatile.Register32 // 0x158
	CMPMUPD2 volatile.Register32 // 0x15C
	CMPV3    volatile.Register32 // 0x160
	CMPVUPD3 volatile.Register32 // 0x164
	CMPM3    volatile.Register32 // 0x168
	CMPMUPD3 volatile.Register32 // 0x16C
	CMPV4    volatile.Register32 // 0x170
	CMPVUPD4 volatile.Register32 // 0x174
	CMPM4    volatile.Register32 // 0x178
	CMPMUPD4 volatile.Register32 // 0x17C
	CMPV5    volatile.Register32 // 0x180
	CMPVUPD5 volatile.Register32 // 0x184
	CMPM5    volatile.Register32 // 0x188
	CMPMUPD5 volatile.Register32 // 0x18C
	CMPV6    volatile.Register32 // 0x190
	CMPVUPD6 volatile.Register32 // 0x194
	CMPM6    volatile.Register32 // 0x198
	CMPMUPD6 volatile.Register32 // 0x19C
	CMPV7    volatile.Register32 // 0x1A0
	CMPVUPD7 volatile.Register32 // 0x1A4
	CMPM7    volatile.Register32 // 0x1A8
	CMPMUPD7 volatile.Register32 // 0x1AC
	_        [80]byte
	CMR0     volatile.Register32 // 0x200
	CDTY0    volatile.Register32 // 0x204
	CDTYUPD0 volatile.Register32 // 0x208
	CPRD0    volatile.Register32 // 0x20C
	CPRDUPD0 volatile.Register32 // 0x210
	CCNT0    volatile.Register32 // 0x214
	DT0      volatile.Register32 // 0x218
	DTUPD0   volatile.Register32 // 0x21C
	CMR1     volatile.Register32 // 0x220
	CDTY1    volatile.Register32 // 0x224
	CDTYUPD1 volatile.Register32 // 0x228
	CPRD1    volatile.Register32 // 0x22C
	CPRDUPD1 volatile.Register32 // 0x230
	CCNT1    volatile.Register32 // 0x234
	DT1      volatile.Register32 // 0x238
	DTUPD1   volatile.Register32 // 0x23C
	CMR2     volatile.Register32 // 0x240
	CDTY2    volatile.Register32 // 0x244
	CDTYUPD2 volatile.Register32 // 0x248
	CPRD2    volatile.Register32 // 0x24C
	CPRDUPD2 volatile.Register32 // 0x250
	CCNT2    volatile.Register32 // 0x254
	DT2      volatile.Register32 // 0x258
	DTUPD2   volatile.Register32 // 0x25C
	CMR3     volatile.Register32 // 0x260
	CDTY3    volatile.Register32 // 0x264
	CDTYUPD3 volatile.Register32 // 0x268
	CPRD3    volatile.Register32 // 0x26C
	CPRDUPD3 volatile.Register32 // 0x270
	CCNT3    volatile.Register32 // 0x274
	DT3      volatile.Register32 // 0x278
	DTUPD3   volatile.Register32 // 0x27C
}

// PWM.CLK: PWM Clock Register
func (o *PWM_Type) SetCLK_DIVA(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetCLK_DIVA() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0xff
}
func (o *PWM_Type) SetCLK_PREA(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCLK_PREA() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCLK_DIVB(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetCLK_DIVB() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetCLK_PREB(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xf000000)|value<<24)
}
func (o *PWM_Type) GetCLK_PREB() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xf000000) >> 24
}

// PWM.ENA: PWM Enable Register
func (o *PWM_Type) SetENA_CHID0(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetENA_CHID0() uint32 {
	return volatile.LoadUint32(&o.ENA.Reg) & 0x1
}
func (o *PWM_Type) SetENA_CHID1(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetENA_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetENA_CHID2(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetENA_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetENA_CHID3(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetENA_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x8) >> 3
}

// PWM.DIS: PWM Disable Register
func (o *PWM_Type) SetDIS_CHID0(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetDIS_CHID0() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0x1
}
func (o *PWM_Type) SetDIS_CHID1(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetDIS_CHID1() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetDIS_CHID2(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetDIS_CHID2() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetDIS_CHID3(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetDIS_CHID3() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x8) >> 3
}

// PWM.SR: PWM Status Register
func (o *PWM_Type) SetSR_CHID0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSR_CHID0() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *PWM_Type) SetSR_CHID1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSR_CHID2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSR_CHID3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}

// PWM.IER1: PWM Interrupt Enable Register 1
func (o *PWM_Type) SetIER1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *PWM_Type) SetIER1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIER1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIER1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIER1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIER1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIER1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIER1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIER1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIER1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIER1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIER1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIER1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIER1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80000) >> 19
}

// PWM.IDR1: PWM Interrupt Disable Register 1
func (o *PWM_Type) SetIDR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IDR1.Reg) & 0x1
}
func (o *PWM_Type) SetIDR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIDR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIDR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIDR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIDR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIDR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIDR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIDR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIDR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIDR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIDR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIDR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIDR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80000) >> 19
}

// PWM.IMR1: PWM Interrupt Mask Register 1
func (o *PWM_Type) SetIMR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *PWM_Type) SetIMR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIMR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIMR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIMR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIMR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIMR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIMR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIMR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIMR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIMR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIMR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIMR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIMR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000) >> 19
}

// PWM.ISR1: PWM Interrupt Status Register 1
func (o *PWM_Type) SetISR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.ISR1.Reg) & 0x1
}
func (o *PWM_Type) SetISR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetISR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetISR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetISR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetISR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetISR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetISR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetISR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetISR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetISR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetISR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetISR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetISR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x80000) >> 19
}

// PWM.SCM: PWM Sync Channels Mode Register
func (o *PWM_Type) SetSCM_SYNC0(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSCM_SYNC0() uint32 {
	return volatile.LoadUint32(&o.SCM.Reg) & 0x1
}
func (o *PWM_Type) SetSCM_SYNC1(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSCM_SYNC1() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSCM_SYNC2(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSCM_SYNC2() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSCM_SYNC3(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSCM_SYNC3() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetSCM_UPDM(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x30000)|value<<16)
}
func (o *PWM_Type) GetSCM_UPDM() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x30000) >> 16
}

// PWM.SCUC: PWM Sync Channels Update Control Register
func (o *PWM_Type) SetSCUC_UPDULOCK(value uint32) {
	volatile.StoreUint32(&o.SCUC.Reg, volatile.LoadUint32(&o.SCUC.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSCUC_UPDULOCK() uint32 {
	return volatile.LoadUint32(&o.SCUC.Reg) & 0x1
}

// PWM.SCUP: PWM Sync Channels Update Period Register
func (o *PWM_Type) SetSCUP_UPR(value uint32) {
	volatile.StoreUint32(&o.SCUP.Reg, volatile.LoadUint32(&o.SCUP.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetSCUP_UPR() uint32 {
	return volatile.LoadUint32(&o.SCUP.Reg) & 0xf
}
func (o *PWM_Type) SetSCUP_UPRCNT(value uint32) {
	volatile.StoreUint32(&o.SCUP.Reg, volatile.LoadUint32(&o.SCUP.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetSCUP_UPRCNT() uint32 {
	return (volatile.LoadUint32(&o.SCUP.Reg) & 0xf0) >> 4
}

// PWM.SCUPUPD: PWM Sync Channels Update Period Update Register
func (o *PWM_Type) SetSCUPUPD_UPRUPD(value uint32) {
	volatile.StoreUint32(&o.SCUPUPD.Reg, volatile.LoadUint32(&o.SCUPUPD.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetSCUPUPD_UPRUPD() uint32 {
	return volatile.LoadUint32(&o.SCUPUPD.Reg) & 0xf
}

// PWM.IER2: PWM Interrupt Enable Register 2
func (o *PWM_Type) SetIER2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IER2.Reg) & 0x1
}
func (o *PWM_Type) SetIER2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIER2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIER2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIER2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIER2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIER2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIER2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIER2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIER2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIER2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIER2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIER2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIER2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIER2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIER2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIER2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIER2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIER2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIER2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIER2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIER2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIER2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIER2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIER2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIER2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIER2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIER2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIER2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIER2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIER2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIER2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIER2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIER2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x800000) >> 23
}

// PWM.IDR2: PWM Interrupt Disable Register 2
func (o *PWM_Type) SetIDR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IDR2.Reg) & 0x1
}
func (o *PWM_Type) SetIDR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIDR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIDR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIDR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIDR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIDR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIDR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIDR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIDR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIDR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIDR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIDR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIDR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIDR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIDR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIDR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIDR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIDR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIDR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIDR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIDR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIDR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIDR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIDR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIDR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIDR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIDR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIDR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIDR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIDR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIDR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIDR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIDR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x800000) >> 23
}

// PWM.IMR2: PWM Interrupt Mask Register 2
func (o *PWM_Type) SetIMR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *PWM_Type) SetIMR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIMR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIMR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIMR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIMR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIMR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIMR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIMR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIMR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIMR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIMR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIMR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIMR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIMR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIMR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIMR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIMR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIMR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIMR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIMR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIMR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIMR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIMR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIMR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIMR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIMR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIMR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIMR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIMR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIMR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIMR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIMR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIMR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x800000) >> 23
}

// PWM.ISR2: PWM Interrupt Status Register 2
func (o *PWM_Type) SetISR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.ISR2.Reg) & 0x1
}
func (o *PWM_Type) SetISR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetISR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetISR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetISR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetISR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetISR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetISR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetISR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetISR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetISR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetISR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetISR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetISR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetISR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetISR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetISR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetISR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetISR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetISR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetISR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetISR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetISR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetISR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetISR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetISR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetISR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetISR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetISR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetISR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetISR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetISR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetISR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetISR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x800000) >> 23
}

// PWM.OOV: PWM Output Override Value Register
func (o *PWM_Type) SetOOV_OOVH0(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOOV_OOVH0() uint32 {
	return volatile.LoadUint32(&o.OOV.Reg) & 0x1
}
func (o *PWM_Type) SetOOV_OOVH1(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOOV_OOVH1() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOOV_OOVH2(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOOV_OOVH2() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOOV_OOVH3(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOOV_OOVH3() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOOV_OOVL0(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOOV_OOVL0() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOOV_OOVL1(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOOV_OOVL1() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOOV_OOVL2(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOOV_OOVL2() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOOV_OOVL3(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOOV_OOVL3() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x80000) >> 19
}

// PWM.OS: PWM Output Selection Register
func (o *PWM_Type) SetOS_OSH0(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOS_OSH0() uint32 {
	return volatile.LoadUint32(&o.OS.Reg) & 0x1
}
func (o *PWM_Type) SetOS_OSH1(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOS_OSH1() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOS_OSH2(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOS_OSH2() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOS_OSH3(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOS_OSH3() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOS_OSL0(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOS_OSL0() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOS_OSL1(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOS_OSL1() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOS_OSL2(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOS_OSL2() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOS_OSL3(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOS_OSL3() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x80000) >> 19
}

// PWM.OSS: PWM Output Selection Set Register
func (o *PWM_Type) SetOSS_OSSH0(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSS_OSSH0() uint32 {
	return volatile.LoadUint32(&o.OSS.Reg) & 0x1
}
func (o *PWM_Type) SetOSS_OSSH1(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSS_OSSH1() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSS_OSSH2(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSS_OSSH2() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSS_OSSH3(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSS_OSSH3() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSS_OSSL0(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSS_OSSL0() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSS_OSSL1(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSS_OSSL1() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSS_OSSL2(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSS_OSSL2() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSS_OSSL3(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSS_OSSL3() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x80000) >> 19
}

// PWM.OSC: PWM Output Selection Clear Register
func (o *PWM_Type) SetOSC_OSCH0(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSC_OSCH0() uint32 {
	return volatile.LoadUint32(&o.OSC.Reg) & 0x1
}
func (o *PWM_Type) SetOSC_OSCH1(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSC_OSCH1() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSC_OSCH2(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSC_OSCH2() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSC_OSCH3(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSC_OSCH3() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSC_OSCL0(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSC_OSCL0() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSC_OSCL1(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSC_OSCL1() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSC_OSCL2(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSC_OSCL2() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSC_OSCL3(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSC_OSCL3() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x80000) >> 19
}

// PWM.OSSUPD: PWM Output Selection Set Update Register
func (o *PWM_Type) SetOSSUPD_OSSUPH0(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH0() uint32 {
	return volatile.LoadUint32(&o.OSSUPD.Reg) & 0x1
}
func (o *PWM_Type) SetOSSUPD_OSSUPH1(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH1() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSSUPD_OSSUPH2(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH2() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSSUPD_OSSUPH3(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH3() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSSUPD_OSSUPL0(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL0() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSSUPD_OSSUPL1(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL1() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSSUPD_OSSUPL2(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL2() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSSUPD_OSSUPL3(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL3() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x80000) >> 19
}

// PWM.OSCUPD: PWM Output Selection Clear Update Register
func (o *PWM_Type) SetOSCUPD_OSCUPH0(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH0() uint32 {
	return volatile.LoadUint32(&o.OSCUPD.Reg) & 0x1
}
func (o *PWM_Type) SetOSCUPD_OSCUPH1(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH1() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSCUPD_OSCUPH2(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH2() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSCUPD_OSCUPH3(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH3() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSCUPD_OSCUPL0(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL0() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSCUPD_OSCUPL1(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL1() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSCUPD_OSCUPL2(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL2() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSCUPD_OSCUPL3(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL3() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x80000) >> 19
}

// PWM.FMR: PWM Fault Mode Register
func (o *PWM_Type) SetFMR_FPOL(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFMR_FPOL() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0xff
}
func (o *PWM_Type) SetFMR_FMOD(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFMR_FMOD() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xff00) >> 8
}
func (o *PWM_Type) SetFMR_FFIL(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetFMR_FFIL() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xff0000) >> 16
}

// PWM.FSR: PWM Fault Status Register
func (o *PWM_Type) SetFSR_FIV(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFSR_FIV() uint32 {
	return volatile.LoadUint32(&o.FSR.Reg) & 0xff
}
func (o *PWM_Type) SetFSR_FS(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFSR_FS() uint32 {
	return (volatile.LoadUint32(&o.FSR.Reg) & 0xff00) >> 8
}

// PWM.FCR: PWM Fault Clear Register
func (o *PWM_Type) SetFCR_FCLR(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFCR_FCLR() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0xff
}

// PWM.FPV: PWM Fault Protection Value Register
func (o *PWM_Type) SetFPV_FPVH0(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetFPV_FPVH0() uint32 {
	return volatile.LoadUint32(&o.FPV.Reg) & 0x1
}
func (o *PWM_Type) SetFPV_FPVH1(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetFPV_FPVH1() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetFPV_FPVH2(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetFPV_FPVH2() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetFPV_FPVH3(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetFPV_FPVH3() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetFPV_FPVL0(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetFPV_FPVL0() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetFPV_FPVL1(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetFPV_FPVL1() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetFPV_FPVL2(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetFPV_FPVL2() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetFPV_FPVL3(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetFPV_FPVL3() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x80000) >> 19
}

// PWM.FPE: PWM Fault Protection Enable Register
func (o *PWM_Type) SetFPE_FPE0(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFPE_FPE0() uint32 {
	return volatile.LoadUint32(&o.FPE.Reg) & 0xff
}
func (o *PWM_Type) SetFPE_FPE1(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFPE_FPE1() uint32 {
	return (volatile.LoadUint32(&o.FPE.Reg) & 0xff00) >> 8
}
func (o *PWM_Type) SetFPE_FPE2(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetFPE_FPE2() uint32 {
	return (volatile.LoadUint32(&o.FPE.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetFPE_FPE3(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff000000)|value<<24)
}
func (o *PWM_Type) GetFPE_FPE3() uint32 {
	return (volatile.LoadUint32(&o.FPE.Reg) & 0xff000000) >> 24
}

// PWM.ELMR: PWM Event Line 0 Mode Register
func (o *PWM_Type) SetELMR_CSEL0(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetELMR_CSEL0(idx int) uint32 {
	return volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x1
}
func (o *PWM_Type) SetELMR_CSEL1(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetELMR_CSEL1(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetELMR_CSEL2(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetELMR_CSEL2(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetELMR_CSEL3(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetELMR_CSEL3(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetELMR_CSEL4(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetELMR_CSEL4(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetELMR_CSEL5(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetELMR_CSEL5(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetELMR_CSEL6(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetELMR_CSEL6(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetELMR_CSEL7(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetELMR_CSEL7(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x80) >> 7
}

// PWM.SMMR: PWM Stepper Motor Mode Register
func (o *PWM_Type) SetSMMR_GCEN0(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSMMR_GCEN0() uint32 {
	return volatile.LoadUint32(&o.SMMR.Reg) & 0x1
}
func (o *PWM_Type) SetSMMR_GCEN1(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSMMR_GCEN1() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSMMR_DOWN0(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetSMMR_DOWN0() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetSMMR_DOWN1(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetSMMR_DOWN1() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x20000) >> 17
}

// PWM.WPCR: PWM Write Protect Control Register
func (o *PWM_Type) SetWPCR_WPCMD(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x3)|value)
}
func (o *PWM_Type) GetWPCR_WPCMD() uint32 {
	return volatile.LoadUint32(&o.WPCR.Reg) & 0x3
}
func (o *PWM_Type) SetWPCR_WPRG0(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetWPCR_WPRG0() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetWPCR_WPRG1(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetWPCR_WPRG1() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetWPCR_WPRG2(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetWPCR_WPRG2() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetWPCR_WPRG3(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetWPCR_WPRG3() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetWPCR_WPRG4(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetWPCR_WPRG4() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetWPCR_WPRG5(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetWPCR_WPRG5() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetWPCR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PWM_Type) GetWPCR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0xffffff00) >> 8
}

// PWM.WPSR: PWM Write Protect Status Register
func (o *PWM_Type) SetWPSR_WPSWS0(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetWPSR_WPSWS0() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *PWM_Type) SetWPSR_WPSWS1(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetWPSR_WPSWS1() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetWPSR_WPSWS2(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetWPSR_WPSWS2() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetWPSR_WPSWS3(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetWPSR_WPSWS3() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetWPSR_WPSWS4(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetWPSR_WPSWS4() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetWPSR_WPSWS5(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetWPSR_WPSWS5() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetWPSR_WPVS() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetWPSR_WPHWS0(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetWPSR_WPHWS0() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetWPSR_WPHWS1(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetWPSR_WPHWS1() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetWPSR_WPHWS2(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetWPSR_WPHWS2() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetWPSR_WPHWS3(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetWPSR_WPHWS3() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetWPSR_WPHWS4(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetWPSR_WPHWS4() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetWPSR_WPHWS5(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetWPSR_WPHWS5() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff0000) >> 16
}

// PWM.CMPV0: PWM Comparison 0 Value Register
func (o *PWM_Type) SetCMPV0_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV0.Reg, volatile.LoadUint32(&o.CMPV0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV0_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV0.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV0_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV0.Reg, volatile.LoadUint32(&o.CMPV0.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV0_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV0.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD0: PWM Comparison 0 Value Update Register
func (o *PWM_Type) SetCMPVUPD0_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD0.Reg, volatile.LoadUint32(&o.CMPVUPD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD0_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD0.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD0_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD0.Reg, volatile.LoadUint32(&o.CMPVUPD0.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD0_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD0.Reg) & 0x1000000) >> 24
}

// PWM.CMPM0: PWM Comparison 0 Mode Register
func (o *PWM_Type) SetCMPM0_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM0_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM0.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM0_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM0_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM0_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM0_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM0_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM0_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM0_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM0_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM0_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM0_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD0: PWM Comparison 0 Mode Update Register
func (o *PWM_Type) SetCMPMUPD0_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD0_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD0_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD0_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD0_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD0_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD0_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD0_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0xf0000) >> 16
}

// PWM.CMPV1: PWM Comparison 1 Value Register
func (o *PWM_Type) SetCMPV1_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV1.Reg, volatile.LoadUint32(&o.CMPV1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV1_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV1.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV1_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV1.Reg, volatile.LoadUint32(&o.CMPV1.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV1_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV1.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD1: PWM Comparison 1 Value Update Register
func (o *PWM_Type) SetCMPVUPD1_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD1.Reg, volatile.LoadUint32(&o.CMPVUPD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD1_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD1.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD1_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD1.Reg, volatile.LoadUint32(&o.CMPVUPD1.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD1_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD1.Reg) & 0x1000000) >> 24
}

// PWM.CMPM1: PWM Comparison 1 Mode Register
func (o *PWM_Type) SetCMPM1_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM1_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM1.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM1_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM1_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM1_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM1_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM1_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM1_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM1_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM1_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM1_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM1_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD1: PWM Comparison 1 Mode Update Register
func (o *PWM_Type) SetCMPMUPD1_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD1_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD1_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD1_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD1_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD1_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD1_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD1_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0xf0000) >> 16
}

// PWM.CMPV2: PWM Comparison 2 Value Register
func (o *PWM_Type) SetCMPV2_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV2.Reg, volatile.LoadUint32(&o.CMPV2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV2_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV2.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV2_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV2.Reg, volatile.LoadUint32(&o.CMPV2.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV2_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV2.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD2: PWM Comparison 2 Value Update Register
func (o *PWM_Type) SetCMPVUPD2_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD2.Reg, volatile.LoadUint32(&o.CMPVUPD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD2_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD2.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD2_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD2.Reg, volatile.LoadUint32(&o.CMPVUPD2.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD2_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD2.Reg) & 0x1000000) >> 24
}

// PWM.CMPM2: PWM Comparison 2 Mode Register
func (o *PWM_Type) SetCMPM2_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM2_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM2.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM2_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM2_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM2_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM2_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM2_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM2_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM2_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM2_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM2_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM2_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD2: PWM Comparison 2 Mode Update Register
func (o *PWM_Type) SetCMPMUPD2_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD2_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD2_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD2_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD2_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD2_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD2_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD2_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0xf0000) >> 16
}

// PWM.CMPV3: PWM Comparison 3 Value Register
func (o *PWM_Type) SetCMPV3_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV3.Reg, volatile.LoadUint32(&o.CMPV3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV3_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV3.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV3_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV3.Reg, volatile.LoadUint32(&o.CMPV3.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV3_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV3.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD3: PWM Comparison 3 Value Update Register
func (o *PWM_Type) SetCMPVUPD3_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD3.Reg, volatile.LoadUint32(&o.CMPVUPD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD3_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD3.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD3_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD3.Reg, volatile.LoadUint32(&o.CMPVUPD3.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD3_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD3.Reg) & 0x1000000) >> 24
}

// PWM.CMPM3: PWM Comparison 3 Mode Register
func (o *PWM_Type) SetCMPM3_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM3_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM3.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM3_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM3_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM3_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM3_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM3_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM3_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM3_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM3_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM3_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM3_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD3: PWM Comparison 3 Mode Update Register
func (o *PWM_Type) SetCMPMUPD3_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD3_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD3_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD3_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD3_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD3_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD3_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD3_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0xf0000) >> 16
}

// PWM.CMPV4: PWM Comparison 4 Value Register
func (o *PWM_Type) SetCMPV4_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV4.Reg, volatile.LoadUint32(&o.CMPV4.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV4_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV4.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV4_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV4.Reg, volatile.LoadUint32(&o.CMPV4.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV4_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV4.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD4: PWM Comparison 4 Value Update Register
func (o *PWM_Type) SetCMPVUPD4_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD4.Reg, volatile.LoadUint32(&o.CMPVUPD4.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD4_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD4.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD4_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD4.Reg, volatile.LoadUint32(&o.CMPVUPD4.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD4_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD4.Reg) & 0x1000000) >> 24
}

// PWM.CMPM4: PWM Comparison 4 Mode Register
func (o *PWM_Type) SetCMPM4_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM4_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM4.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM4_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM4_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM4_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM4_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM4_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM4_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM4_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM4_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM4_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM4_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD4: PWM Comparison 4 Mode Update Register
func (o *PWM_Type) SetCMPMUPD4_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD4_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD4_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD4_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD4_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD4_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD4_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD4_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0xf0000) >> 16
}

// PWM.CMPV5: PWM Comparison 5 Value Register
func (o *PWM_Type) SetCMPV5_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV5.Reg, volatile.LoadUint32(&o.CMPV5.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV5_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV5.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV5_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV5.Reg, volatile.LoadUint32(&o.CMPV5.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV5_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV5.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD5: PWM Comparison 5 Value Update Register
func (o *PWM_Type) SetCMPVUPD5_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD5.Reg, volatile.LoadUint32(&o.CMPVUPD5.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD5_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD5.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD5_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD5.Reg, volatile.LoadUint32(&o.CMPVUPD5.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD5_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD5.Reg) & 0x1000000) >> 24
}

// PWM.CMPM5: PWM Comparison 5 Mode Register
func (o *PWM_Type) SetCMPM5_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM5_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM5.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM5_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM5_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM5_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM5_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM5_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM5_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM5_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM5_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM5_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM5_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD5: PWM Comparison 5 Mode Update Register
func (o *PWM_Type) SetCMPMUPD5_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD5_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD5_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD5_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD5_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD5_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD5_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD5_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0xf0000) >> 16
}

// PWM.CMPV6: PWM Comparison 6 Value Register
func (o *PWM_Type) SetCMPV6_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV6.Reg, volatile.LoadUint32(&o.CMPV6.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV6_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV6.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV6_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV6.Reg, volatile.LoadUint32(&o.CMPV6.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV6_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV6.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD6: PWM Comparison 6 Value Update Register
func (o *PWM_Type) SetCMPVUPD6_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD6.Reg, volatile.LoadUint32(&o.CMPVUPD6.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD6_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD6.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD6_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD6.Reg, volatile.LoadUint32(&o.CMPVUPD6.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD6_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD6.Reg) & 0x1000000) >> 24
}

// PWM.CMPM6: PWM Comparison 6 Mode Register
func (o *PWM_Type) SetCMPM6_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM6_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM6.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM6_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM6_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM6_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM6_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM6_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM6_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM6_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM6_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM6_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM6_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD6: PWM Comparison 6 Mode Update Register
func (o *PWM_Type) SetCMPMUPD6_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD6_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD6_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD6_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD6_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD6_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD6_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD6_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0xf0000) >> 16
}

// PWM.CMPV7: PWM Comparison 7 Value Register
func (o *PWM_Type) SetCMPV7_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV7.Reg, volatile.LoadUint32(&o.CMPV7.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV7_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV7.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV7_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV7.Reg, volatile.LoadUint32(&o.CMPV7.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV7_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV7.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD7: PWM Comparison 7 Value Update Register
func (o *PWM_Type) SetCMPVUPD7_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD7.Reg, volatile.LoadUint32(&o.CMPVUPD7.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD7_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD7.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD7_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD7.Reg, volatile.LoadUint32(&o.CMPVUPD7.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD7_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD7.Reg) & 0x1000000) >> 24
}

// PWM.CMPM7: PWM Comparison 7 Mode Register
func (o *PWM_Type) SetCMPM7_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM7_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM7.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM7_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM7_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM7_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM7_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM7_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM7_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM7_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM7_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM7_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM7_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD7: PWM Comparison 7 Mode Update Register
func (o *PWM_Type) SetCMPMUPD7_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD7_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD7_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD7_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD7_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD7_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD7_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD7_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0xf0000) >> 16
}

// PWM.CMR0: PWM Channel Mode Register (ch_num = 0)
func (o *PWM_Type) SetCMR0_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR0_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0xf
}
func (o *PWM_Type) SetCMR0_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR0_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR0_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR0_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR0_CES(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR0_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR0_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR0_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR0_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR0_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR0_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR0_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x40000) >> 18
}

// PWM.CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
func (o *PWM_Type) SetCDTY0_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY0.Reg, volatile.LoadUint32(&o.CDTY0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY0_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY0.Reg) & 0xffffff
}

// PWM.CDTYUPD0: PWM Channel Duty Cycle Update Register (ch_num = 0)
func (o *PWM_Type) SetCDTYUPD0_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD0.Reg, volatile.LoadUint32(&o.CDTYUPD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD0_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD0.Reg) & 0xffffff
}

// PWM.CPRD0: PWM Channel Period Register (ch_num = 0)
func (o *PWM_Type) SetCPRD0_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD0.Reg, volatile.LoadUint32(&o.CPRD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD0_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD0.Reg) & 0xffffff
}

// PWM.CPRDUPD0: PWM Channel Period Update Register (ch_num = 0)
func (o *PWM_Type) SetCPRDUPD0_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD0.Reg, volatile.LoadUint32(&o.CPRDUPD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD0_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD0.Reg) & 0xffffff
}

// PWM.CCNT0: PWM Channel Counter Register (ch_num = 0)
func (o *PWM_Type) SetCCNT0_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT0.Reg, volatile.LoadUint32(&o.CCNT0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT0_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT0.Reg) & 0xffffff
}

// PWM.DT0: PWM Channel Dead Time Register (ch_num = 0)
func (o *PWM_Type) SetDT0_DTH(value uint32) {
	volatile.StoreUint32(&o.DT0.Reg, volatile.LoadUint32(&o.DT0.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT0_DTH() uint32 {
	return volatile.LoadUint32(&o.DT0.Reg) & 0xffff
}
func (o *PWM_Type) SetDT0_DTL(value uint32) {
	volatile.StoreUint32(&o.DT0.Reg, volatile.LoadUint32(&o.DT0.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT0_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT0.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD0: PWM Channel Dead Time Update Register (ch_num = 0)
func (o *PWM_Type) SetDTUPD0_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD0.Reg, volatile.LoadUint32(&o.DTUPD0.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD0_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD0.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD0_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD0.Reg, volatile.LoadUint32(&o.DTUPD0.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD0_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD0.Reg) & 0xffff0000) >> 16
}

// PWM.CMR1: PWM Channel Mode Register (ch_num = 1)
func (o *PWM_Type) SetCMR1_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR1_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0xf
}
func (o *PWM_Type) SetCMR1_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR1_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR1_CES(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR1_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR1_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR1_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR1_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR1_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR1_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR1_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x40000) >> 18
}

// PWM.CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
func (o *PWM_Type) SetCDTY1_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY1.Reg, volatile.LoadUint32(&o.CDTY1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY1_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY1.Reg) & 0xffffff
}

// PWM.CDTYUPD1: PWM Channel Duty Cycle Update Register (ch_num = 1)
func (o *PWM_Type) SetCDTYUPD1_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD1.Reg, volatile.LoadUint32(&o.CDTYUPD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD1_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD1.Reg) & 0xffffff
}

// PWM.CPRD1: PWM Channel Period Register (ch_num = 1)
func (o *PWM_Type) SetCPRD1_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD1.Reg, volatile.LoadUint32(&o.CPRD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD1_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD1.Reg) & 0xffffff
}

// PWM.CPRDUPD1: PWM Channel Period Update Register (ch_num = 1)
func (o *PWM_Type) SetCPRDUPD1_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD1.Reg, volatile.LoadUint32(&o.CPRDUPD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD1_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD1.Reg) & 0xffffff
}

// PWM.CCNT1: PWM Channel Counter Register (ch_num = 1)
func (o *PWM_Type) SetCCNT1_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT1.Reg, volatile.LoadUint32(&o.CCNT1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT1_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT1.Reg) & 0xffffff
}

// PWM.DT1: PWM Channel Dead Time Register (ch_num = 1)
func (o *PWM_Type) SetDT1_DTH(value uint32) {
	volatile.StoreUint32(&o.DT1.Reg, volatile.LoadUint32(&o.DT1.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT1_DTH() uint32 {
	return volatile.LoadUint32(&o.DT1.Reg) & 0xffff
}
func (o *PWM_Type) SetDT1_DTL(value uint32) {
	volatile.StoreUint32(&o.DT1.Reg, volatile.LoadUint32(&o.DT1.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT1_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT1.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD1: PWM Channel Dead Time Update Register (ch_num = 1)
func (o *PWM_Type) SetDTUPD1_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD1.Reg, volatile.LoadUint32(&o.DTUPD1.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD1_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD1.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD1_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD1.Reg, volatile.LoadUint32(&o.DTUPD1.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD1_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD1.Reg) & 0xffff0000) >> 16
}

// PWM.CMR2: PWM Channel Mode Register (ch_num = 2)
func (o *PWM_Type) SetCMR2_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR2_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0xf
}
func (o *PWM_Type) SetCMR2_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR2_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR2_CES(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR2_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR2_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR2_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR2_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR2_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR2_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR2_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x40000) >> 18
}

// PWM.CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
func (o *PWM_Type) SetCDTY2_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY2.Reg, volatile.LoadUint32(&o.CDTY2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY2_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY2.Reg) & 0xffffff
}

// PWM.CDTYUPD2: PWM Channel Duty Cycle Update Register (ch_num = 2)
func (o *PWM_Type) SetCDTYUPD2_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD2.Reg, volatile.LoadUint32(&o.CDTYUPD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD2_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD2.Reg) & 0xffffff
}

// PWM.CPRD2: PWM Channel Period Register (ch_num = 2)
func (o *PWM_Type) SetCPRD2_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD2.Reg, volatile.LoadUint32(&o.CPRD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD2_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD2.Reg) & 0xffffff
}

// PWM.CPRDUPD2: PWM Channel Period Update Register (ch_num = 2)
func (o *PWM_Type) SetCPRDUPD2_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD2.Reg, volatile.LoadUint32(&o.CPRDUPD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD2_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD2.Reg) & 0xffffff
}

// PWM.CCNT2: PWM Channel Counter Register (ch_num = 2)
func (o *PWM_Type) SetCCNT2_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT2.Reg, volatile.LoadUint32(&o.CCNT2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT2_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT2.Reg) & 0xffffff
}

// PWM.DT2: PWM Channel Dead Time Register (ch_num = 2)
func (o *PWM_Type) SetDT2_DTH(value uint32) {
	volatile.StoreUint32(&o.DT2.Reg, volatile.LoadUint32(&o.DT2.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT2_DTH() uint32 {
	return volatile.LoadUint32(&o.DT2.Reg) & 0xffff
}
func (o *PWM_Type) SetDT2_DTL(value uint32) {
	volatile.StoreUint32(&o.DT2.Reg, volatile.LoadUint32(&o.DT2.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT2_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT2.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD2: PWM Channel Dead Time Update Register (ch_num = 2)
func (o *PWM_Type) SetDTUPD2_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD2.Reg, volatile.LoadUint32(&o.DTUPD2.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD2_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD2.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD2_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD2.Reg, volatile.LoadUint32(&o.DTUPD2.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD2_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD2.Reg) & 0xffff0000) >> 16
}

// PWM.CMR3: PWM Channel Mode Register (ch_num = 3)
func (o *PWM_Type) SetCMR3_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR3_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR3.Reg) & 0xf
}
func (o *PWM_Type) SetCMR3_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR3_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR3_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR3_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR3_CES(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR3_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR3_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR3_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR3_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR3_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR3_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR3_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x40000) >> 18
}

// PWM.CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
func (o *PWM_Type) SetCDTY3_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY3.Reg, volatile.LoadUint32(&o.CDTY3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY3_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY3.Reg) & 0xffffff
}

// PWM.CDTYUPD3: PWM Channel Duty Cycle Update Register (ch_num = 3)
func (o *PWM_Type) SetCDTYUPD3_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD3.Reg, volatile.LoadUint32(&o.CDTYUPD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD3_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD3.Reg) & 0xffffff
}

// PWM.CPRD3: PWM Channel Period Register (ch_num = 3)
func (o *PWM_Type) SetCPRD3_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD3.Reg, volatile.LoadUint32(&o.CPRD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD3_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD3.Reg) & 0xffffff
}

// PWM.CPRDUPD3: PWM Channel Period Update Register (ch_num = 3)
func (o *PWM_Type) SetCPRDUPD3_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD3.Reg, volatile.LoadUint32(&o.CPRDUPD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD3_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD3.Reg) & 0xffffff
}

// PWM.CCNT3: PWM Channel Counter Register (ch_num = 3)
func (o *PWM_Type) SetCCNT3_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT3.Reg, volatile.LoadUint32(&o.CCNT3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT3_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT3.Reg) & 0xffffff
}

// PWM.DT3: PWM Channel Dead Time Register (ch_num = 3)
func (o *PWM_Type) SetDT3_DTH(value uint32) {
	volatile.StoreUint32(&o.DT3.Reg, volatile.LoadUint32(&o.DT3.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT3_DTH() uint32 {
	return volatile.LoadUint32(&o.DT3.Reg) & 0xffff
}
func (o *PWM_Type) SetDT3_DTL(value uint32) {
	volatile.StoreUint32(&o.DT3.Reg, volatile.LoadUint32(&o.DT3.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT3_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT3.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD3: PWM Channel Dead Time Update Register (ch_num = 3)
func (o *PWM_Type) SetDTUPD3_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD3.Reg, volatile.LoadUint32(&o.DTUPD3.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD3_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD3.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD3_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD3.Reg, volatile.LoadUint32(&o.DTUPD3.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD3_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD3.Reg) & 0xffff0000) >> 16
}

// LCD Controller
type LCDC_Type struct {
	LCDCFG0  volatile.Register32 // 0x0
	LCDCFG1  volatile.Register32 // 0x4
	LCDCFG2  volatile.Register32 // 0x8
	LCDCFG3  volatile.Register32 // 0xC
	LCDCFG4  volatile.Register32 // 0x10
	LCDCFG5  volatile.Register32 // 0x14
	LCDCFG6  volatile.Register32 // 0x18
	_        [4]byte
	LCDEN    volatile.Register32 // 0x20
	LCDDIS   volatile.Register32 // 0x24
	LCDSR    volatile.Register32 // 0x28
	LCDIER   volatile.Register32 // 0x2C
	LCDIDR   volatile.Register32 // 0x30
	LCDIMR   volatile.Register32 // 0x34
	LCDISR   volatile.Register32 // 0x38
	_        [4]byte
	BASECHER volatile.Register32 // 0x40
	BASECHDR volatile.Register32 // 0x44
	BASECHSR volatile.Register32 // 0x48
	BASEIER  volatile.Register32 // 0x4C
	BASEIDR  volatile.Register32 // 0x50
	BASEIMR  volatile.Register32 // 0x54
	BASEISR  volatile.Register32 // 0x58
	BASEHEAD volatile.Register32 // 0x5C
	BASEADDR volatile.Register32 // 0x60
	BASECTRL volatile.Register32 // 0x64
	BASENEXT volatile.Register32 // 0x68
	BASECFG0 volatile.Register32 // 0x6C
	BASECFG1 volatile.Register32 // 0x70
	BASECFG2 volatile.Register32 // 0x74
	BASECFG3 volatile.Register32 // 0x78
	BASECFG4 volatile.Register32 // 0x7C
	BASECFG5 volatile.Register32 // 0x80
	BASECFG6 volatile.Register32 // 0x84
	_        [184]byte
	OVR1CHER volatile.Register32 // 0x140
	OVR1CHDR volatile.Register32 // 0x144
	OVR1CHSR volatile.Register32 // 0x148
	OVR1IER  volatile.Register32 // 0x14C
	OVR1IDR  volatile.Register32 // 0x150
	OVR1IMR  volatile.Register32 // 0x154
	OVR1ISR  volatile.Register32 // 0x158
	OVR1HEAD volatile.Register32 // 0x15C
	OVR1ADDR volatile.Register32 // 0x160
	OVR1CTRL volatile.Register32 // 0x164
	OVR1NEXT volatile.Register32 // 0x168
	OVR1CFG0 volatile.Register32 // 0x16C
	OVR1CFG1 volatile.Register32 // 0x170
	OVR1CFG2 volatile.Register32 // 0x174
	OVR1CFG3 volatile.Register32 // 0x178
	OVR1CFG4 volatile.Register32 // 0x17C
	OVR1CFG5 volatile.Register32 // 0x180
	OVR1CFG6 volatile.Register32 // 0x184
	OVR1CFG7 volatile.Register32 // 0x188
	OVR1CFG8 volatile.Register32 // 0x18C
	OVR1CFG9 volatile.Register32 // 0x190
	_        [172]byte
	OVR2CHER volatile.Register32 // 0x240
	OVR2CHDR volatile.Register32 // 0x244
	OVR2CHSR volatile.Register32 // 0x248
	OVR2IER  volatile.Register32 // 0x24C
	OVR2IDR  volatile.Register32 // 0x250
	OVR2IMR  volatile.Register32 // 0x254
	OVR2ISR  volatile.Register32 // 0x258
	OVR2HEAD volatile.Register32 // 0x25C
	OVR2ADDR volatile.Register32 // 0x260
	OVR2CTRL volatile.Register32 // 0x264
	OVR2NEXT volatile.Register32 // 0x268
	OVR2CFG0 volatile.Register32 // 0x26C
	OVR2CFG1 volatile.Register32 // 0x270
	OVR2CFG2 volatile.Register32 // 0x274
	OVR2CFG3 volatile.Register32 // 0x278
	OVR2CFG4 volatile.Register32 // 0x27C
	OVR2CFG5 volatile.Register32 // 0x280
	OVR2CFG6 volatile.Register32 // 0x284
	OVR2CFG7 volatile.Register32 // 0x288
	OVR2CFG8 volatile.Register32 // 0x28C
	OVR2CFG9 volatile.Register32 // 0x290
	_        [172]byte
	HEOCHER  volatile.Register32 // 0x340
	HEOCHDR  volatile.Register32 // 0x344
	HEOCHSR  volatile.Register32 // 0x348
	HEOIER   volatile.Register32 // 0x34C
	HEOIDR   volatile.Register32 // 0x350
	HEOIMR   volatile.Register32 // 0x354
	HEOISR   volatile.Register32 // 0x358
	HEOHEAD  volatile.Register32 // 0x35C
	HEOADDR  volatile.Register32 // 0x360
	HEOCTRL  volatile.Register32 // 0x364
	HEONEXT  volatile.Register32 // 0x368
	HEOUHEAD volatile.Register32 // 0x36C
	HEOUADDR volatile.Register32 // 0x370
	HEOUCTRL volatile.Register32 // 0x374
	HEOUNEXT volatile.Register32 // 0x378
	HEOVHEAD volatile.Register32 // 0x37C
	HEOVADDR volatile.Register32 // 0x380
	HEOVCTRL volatile.Register32 // 0x384
	HEOVNEXT volatile.Register32 // 0x388
	HEOCFG0  volatile.Register32 // 0x38C
	HEOCFG1  volatile.Register32 // 0x390
	HEOCFG2  volatile.Register32 // 0x394
	HEOCFG3  volatile.Register32 // 0x398
	HEOCFG4  volatile.Register32 // 0x39C
	HEOCFG5  volatile.Register32 // 0x3A0
	HEOCFG6  volatile.Register32 // 0x3A4
	HEOCFG7  volatile.Register32 // 0x3A8
	HEOCFG8  volatile.Register32 // 0x3AC
	HEOCFG9  volatile.Register32 // 0x3B0
	HEOCFG10 volatile.Register32 // 0x3B4
	HEOCFG11 volatile.Register32 // 0x3B8
	HEOCFG12 volatile.Register32 // 0x3BC
	HEOCFG13 volatile.Register32 // 0x3C0
	HEOCFG14 volatile.Register32 // 0x3C4
	HEOCFG15 volatile.Register32 // 0x3C8
	HEOCFG16 volatile.Register32 // 0x3CC
	HEOCFG17 volatile.Register32 // 0x3D0
	HEOCFG18 volatile.Register32 // 0x3D4
	HEOCFG19 volatile.Register32 // 0x3D8
	HEOCFG20 volatile.Register32 // 0x3DC
	HEOCFG21 volatile.Register32 // 0x3E0
	HEOCFG22 volatile.Register32 // 0x3E4
	HEOCFG23 volatile.Register32 // 0x3E8
	HEOCFG24 volatile.Register32 // 0x3EC
	HEOCFG25 volatile.Register32 // 0x3F0
	HEOCFG26 volatile.Register32 // 0x3F4
	HEOCFG27 volatile.Register32 // 0x3F8
	HEOCFG28 volatile.Register32 // 0x3FC
	HEOCFG29 volatile.Register32 // 0x400
	HEOCFG30 volatile.Register32 // 0x404
	HEOCFG31 volatile.Register32 // 0x408
	HEOCFG32 volatile.Register32 // 0x40C
	HEOCFG33 volatile.Register32 // 0x410
	HEOCFG34 volatile.Register32 // 0x414
	HEOCFG35 volatile.Register32 // 0x418
	HEOCFG36 volatile.Register32 // 0x41C
	HEOCFG37 volatile.Register32 // 0x420
	HEOCFG38 volatile.Register32 // 0x424
	HEOCFG39 volatile.Register32 // 0x428
	HEOCFG40 volatile.Register32 // 0x42C
	HEOCFG41 volatile.Register32 // 0x430
	_        [12]byte
	HCRCHER  volatile.Register32 // 0x440
	HCRCHDR  volatile.Register32 // 0x444
	HCRCHSR  volatile.Register32 // 0x448
	HCRIER   volatile.Register32 // 0x44C
	HCRIDR   volatile.Register32 // 0x450
	HCRIMR   volatile.Register32 // 0x454
	HCRISR   volatile.Register32 // 0x458
	HCRHEAD  volatile.Register32 // 0x45C
	HCRADDR  volatile.Register32 // 0x460
	HCRCTRL  volatile.Register32 // 0x464
	HCRNEXT  volatile.Register32 // 0x468
	HCRCFG0  volatile.Register32 // 0x46C
	HCRCFG1  volatile.Register32 // 0x470
	HCRCFG2  volatile.Register32 // 0x474
	HCRCFG3  volatile.Register32 // 0x478
	HCRCFG4  volatile.Register32 // 0x47C
	_        [4]byte
	HCRCFG6  volatile.Register32 // 0x484
	HCRCFG7  volatile.Register32 // 0x488
	HCRCFG8  volatile.Register32 // 0x48C
	HCRCFG9  volatile.Register32 // 0x490
	_        [172]byte
	PPCHER   volatile.Register32 // 0x540
	PPCHDR   volatile.Register32 // 0x544
	PPCHSR   volatile.Register32 // 0x548
	PPIER    volatile.Register32 // 0x54C
	PPIDR    volatile.Register32 // 0x550
	PPIMR    volatile.Register32 // 0x554
	PPISR    volatile.Register32 // 0x558
	PPHEAD   volatile.Register32 // 0x55C
	PPADDR   volatile.Register32 // 0x560
	PPCTRL   volatile.Register32 // 0x564
	PPNEXT   volatile.Register32 // 0x568
	PPCFG0   volatile.Register32 // 0x56C
	PPCFG1   volatile.Register32 // 0x570
	PPCFG2   volatile.Register32 // 0x574
	PPCFG3   volatile.Register32 // 0x578
	PPCFG4   volatile.Register32 // 0x57C
	PPCFG5   volatile.Register32 // 0x580
	_        [124]byte
	BASECLUT [256]volatile.Register32 // 0x600
	OVR1CLUT [256]volatile.Register32 // 0xA00
	OVR2CLUT [256]volatile.Register32 // 0xE00
	HEOCLUT  [256]volatile.Register32 // 0x1200
	HCRCLUT  [256]volatile.Register32 // 0x1600
}

// LCDC.LCDCFG0: LCD Controller Configuration Register 0
func (o *LCDC_Type) SetLCDCFG0_CLKPOL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDCFG0_CLKPOL() uint32 {
	return volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDCFG0_CLKSEL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDCFG0_CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDCFG0_CLKPWMSEL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetLCDCFG0_CLKPWMSEL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetLCDCFG0_CGDISBASE(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDCFG0_CGDISBASE() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDCFG0_CGDISOVR1(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetLCDCFG0_CGDISOVR1() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetLCDCFG0_CGDISOVR2(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetLCDCFG0_CGDISOVR2() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetLCDCFG0_CGDISHEO(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetLCDCFG0_CGDISHEO() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetLCDCFG0_CGDISHCR(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetLCDCFG0_CGDISHCR() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetLCDCFG0_CGDISPP(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetLCDCFG0_CGDISPP() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x2000) >> 13
}
func (o *LCDC_Type) SetLCDCFG0_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG0_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0xff0000) >> 16
}

// LCDC.LCDCFG1: LCD Controller Configuration Register 1
func (o *LCDC_Type) SetLCDCFG1_HSPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG1.Reg, volatile.LoadUint32(&o.LCDCFG1.Reg)&^(0x3f)|value)
}
func (o *LCDC_Type) GetLCDCFG1_HSPW() uint32 {
	return volatile.LoadUint32(&o.LCDCFG1.Reg) & 0x3f
}
func (o *LCDC_Type) SetLCDCFG1_VSPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG1.Reg, volatile.LoadUint32(&o.LCDCFG1.Reg)&^(0x3f0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG1_VSPW() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG1.Reg) & 0x3f0000) >> 16
}

// LCDC.LCDCFG2: LCD Controller Configuration Register 2
func (o *LCDC_Type) SetLCDCFG2_VFPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG2.Reg, volatile.LoadUint32(&o.LCDCFG2.Reg)&^(0x3f)|value)
}
func (o *LCDC_Type) GetLCDCFG2_VFPW() uint32 {
	return volatile.LoadUint32(&o.LCDCFG2.Reg) & 0x3f
}
func (o *LCDC_Type) SetLCDCFG2_VBPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG2.Reg, volatile.LoadUint32(&o.LCDCFG2.Reg)&^(0x3f0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG2_VBPW() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG2.Reg) & 0x3f0000) >> 16
}

// LCDC.LCDCFG3: LCD Controller Configuration Register 3
func (o *LCDC_Type) SetLCDCFG3_HFPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG3.Reg, volatile.LoadUint32(&o.LCDCFG3.Reg)&^(0x1ff)|value)
}
func (o *LCDC_Type) GetLCDCFG3_HFPW() uint32 {
	return volatile.LoadUint32(&o.LCDCFG3.Reg) & 0x1ff
}
func (o *LCDC_Type) SetLCDCFG3_HBPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG3.Reg, volatile.LoadUint32(&o.LCDCFG3.Reg)&^(0x1ff0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG3_HBPW() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG3.Reg) & 0x1ff0000) >> 16
}

// LCDC.LCDCFG4: LCD Controller Configuration Register 4
func (o *LCDC_Type) SetLCDCFG4_PPL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG4.Reg, volatile.LoadUint32(&o.LCDCFG4.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetLCDCFG4_PPL() uint32 {
	return volatile.LoadUint32(&o.LCDCFG4.Reg) & 0x7ff
}
func (o *LCDC_Type) SetLCDCFG4_RPF(value uint32) {
	volatile.StoreUint32(&o.LCDCFG4.Reg, volatile.LoadUint32(&o.LCDCFG4.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG4_RPF() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG4.Reg) & 0x7ff0000) >> 16
}

// LCDC.LCDCFG5: LCD Controller Configuration Register 5
func (o *LCDC_Type) SetLCDCFG5_HSPOL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDCFG5_HSPOL() uint32 {
	return volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDCFG5_VSPOL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDCFG5_VSPOL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDCFG5_VSPDLYS(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDCFG5_VSPDLYS() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDCFG5_VSPDLYE(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetLCDCFG5_VSPDLYE() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetLCDCFG5_DISPPOL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDCFG5_DISPPOL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDCFG5_DITHER(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetLCDCFG5_DITHER() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetLCDCFG5_DISPDLY(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x80)|value<<7)
}
func (o *LCDC_Type) GetLCDCFG5_DISPDLY() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x80) >> 7
}
func (o *LCDC_Type) SetLCDCFG5_MODE(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x300)|value<<8)
}
func (o *LCDC_Type) GetLCDCFG5_MODE() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x300) >> 8
}
func (o *LCDC_Type) SetLCDCFG5_PP(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetLCDCFG5_PP() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetLCDCFG5_VSPSU(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetLCDCFG5_VSPSU() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetLCDCFG5_VSPHO(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetLCDCFG5_VSPHO() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x2000) >> 13
}
func (o *LCDC_Type) SetLCDCFG5_GUARDTIME(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x1f0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG5_GUARDTIME() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x1f0000) >> 16
}

// LCDC.LCDCFG6: LCD Controller Configuration Register 6
func (o *LCDC_Type) SetLCDCFG6_PWMPS(value uint32) {
	volatile.StoreUint32(&o.LCDCFG6.Reg, volatile.LoadUint32(&o.LCDCFG6.Reg)&^(0x7)|value)
}
func (o *LCDC_Type) GetLCDCFG6_PWMPS() uint32 {
	return volatile.LoadUint32(&o.LCDCFG6.Reg) & 0x7
}
func (o *LCDC_Type) SetLCDCFG6_PWMPOL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG6.Reg, volatile.LoadUint32(&o.LCDCFG6.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDCFG6_PWMPOL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG6.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDCFG6_PWMCVAL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG6.Reg, volatile.LoadUint32(&o.LCDCFG6.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetLCDCFG6_PWMCVAL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG6.Reg) & 0xff00) >> 8
}

// LCDC.LCDEN: LCD Controller Enable Register
func (o *LCDC_Type) SetLCDEN_CLKEN(value uint32) {
	volatile.StoreUint32(&o.LCDEN.Reg, volatile.LoadUint32(&o.LCDEN.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDEN_CLKEN() uint32 {
	return volatile.LoadUint32(&o.LCDEN.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDEN_SYNCEN(value uint32) {
	volatile.StoreUint32(&o.LCDEN.Reg, volatile.LoadUint32(&o.LCDEN.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDEN_SYNCEN() uint32 {
	return (volatile.LoadUint32(&o.LCDEN.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDEN_DISPEN(value uint32) {
	volatile.StoreUint32(&o.LCDEN.Reg, volatile.LoadUint32(&o.LCDEN.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDEN_DISPEN() uint32 {
	return (volatile.LoadUint32(&o.LCDEN.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDEN_PWMEN(value uint32) {
	volatile.StoreUint32(&o.LCDEN.Reg, volatile.LoadUint32(&o.LCDEN.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetLCDEN_PWMEN() uint32 {
	return (volatile.LoadUint32(&o.LCDEN.Reg) & 0x8) >> 3
}

// LCDC.LCDDIS: LCD Controller Disable Register
func (o *LCDC_Type) SetLCDDIS_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDDIS_CLKDIS() uint32 {
	return volatile.LoadUint32(&o.LCDDIS.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDDIS_SYNCDIS(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDDIS_SYNCDIS() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDDIS_DISPDIS(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDDIS_DISPDIS() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDDIS_PWMDIS(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetLCDDIS_PWMDIS() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetLCDDIS_CLKRST(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDDIS_CLKRST() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDDIS_SYNCRST(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetLCDDIS_SYNCRST() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetLCDDIS_DISPRST(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetLCDDIS_DISPRST() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetLCDDIS_PWMRST(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetLCDDIS_PWMRST() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x800) >> 11
}

// LCDC.LCDSR: LCD Controller Status Register
func (o *LCDC_Type) SetLCDSR_CLKSTS(value uint32) {
	volatile.StoreUint32(&o.LCDSR.Reg, volatile.LoadUint32(&o.LCDSR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDSR_CLKSTS() uint32 {
	return volatile.LoadUint32(&o.LCDSR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDSR_LCDSTS(value uint32) {
	volatile.StoreUint32(&o.LCDSR.Reg, volatile.LoadUint32(&o.LCDSR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDSR_LCDSTS() uint32 {
	return (volatile.LoadUint32(&o.LCDSR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDSR_DISPSTS(value uint32) {
	volatile.StoreUint32(&o.LCDSR.Reg, volatile.LoadUint32(&o.LCDSR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDSR_DISPSTS() uint32 {
	return (volatile.LoadUint32(&o.LCDSR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDSR_PWMSTS(value uint32) {
	volatile.StoreUint32(&o.LCDSR.Reg, volatile.LoadUint32(&o.LCDSR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetLCDSR_PWMSTS() uint32 {
	return (volatile.LoadUint32(&o.LCDSR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetLCDSR_SIPSTS(value uint32) {
	volatile.StoreUint32(&o.LCDSR.Reg, volatile.LoadUint32(&o.LCDSR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDSR_SIPSTS() uint32 {
	return (volatile.LoadUint32(&o.LCDSR.Reg) & 0x10) >> 4
}

// LCDC.LCDIER: LCD Controller Interrupt Enable Register
func (o *LCDC_Type) SetLCDIER_SOFIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDIER_SOFIE() uint32 {
	return volatile.LoadUint32(&o.LCDIER.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDIER_DISIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDIER_DISIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDIER_DISPIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDIER_DISPIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDIER_FIFOERRIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDIER_FIFOERRIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDIER_BASEIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDIER_BASEIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDIER_OVR1IE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetLCDIER_OVR1IE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetLCDIER_OVR2IE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetLCDIER_OVR2IE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetLCDIER_HEOIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetLCDIER_HEOIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetLCDIER_HCRIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetLCDIER_HCRIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetLCDIER_PPIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetLCDIER_PPIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x2000) >> 13
}

// LCDC.LCDIDR: LCD Controller Interrupt Disable Register
func (o *LCDC_Type) SetLCDIDR_SOFID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDIDR_SOFID() uint32 {
	return volatile.LoadUint32(&o.LCDIDR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDIDR_DISID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDIDR_DISID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDIDR_DISPID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDIDR_DISPID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDIDR_FIFOERRID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDIDR_FIFOERRID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDIDR_BASEID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDIDR_BASEID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDIDR_OVR1ID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetLCDIDR_OVR1ID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetLCDIDR_OVR2ID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetLCDIDR_OVR2ID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetLCDIDR_HEOID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetLCDIDR_HEOID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetLCDIDR_HCRID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetLCDIDR_HCRID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetLCDIDR_PPID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetLCDIDR_PPID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x2000) >> 13
}

// LCDC.LCDIMR: LCD Controller Interrupt Mask Register
func (o *LCDC_Type) SetLCDIMR_SOFIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDIMR_SOFIM() uint32 {
	return volatile.LoadUint32(&o.LCDIMR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDIMR_DISIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDIMR_DISIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDIMR_DISPIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDIMR_DISPIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDIMR_FIFOERRIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDIMR_FIFOERRIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDIMR_BASEIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDIMR_BASEIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDIMR_OVR1IM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetLCDIMR_OVR1IM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetLCDIMR_OVR2IM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetLCDIMR_OVR2IM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetLCDIMR_HEOIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetLCDIMR_HEOIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetLCDIMR_HCRIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetLCDIMR_HCRIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetLCDIMR_PPIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetLCDIMR_PPIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x2000) >> 13
}

// LCDC.LCDISR: LCD Controller Interrupt Status Register
func (o *LCDC_Type) SetLCDISR_SOF(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDISR_SOF() uint32 {
	return volatile.LoadUint32(&o.LCDISR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDISR_DIS(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDISR_DIS() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDISR_DISP(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDISR_DISP() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDISR_FIFOERR(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDISR_FIFOERR() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDISR_BASE(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDISR_BASE() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDISR_OVR1(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetLCDISR_OVR1() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetLCDISR_OVR2(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetLCDISR_OVR2() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetLCDISR_HEO(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetLCDISR_HEO() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetLCDISR_HCR(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetLCDISR_HCR() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetLCDISR_PP(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetLCDISR_PP() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x2000) >> 13
}

// LCDC.BASECHER: Base Layer Channel Enable Register
func (o *LCDC_Type) SetBASECHER_CHEN(value uint32) {
	volatile.StoreUint32(&o.BASECHER.Reg, volatile.LoadUint32(&o.BASECHER.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECHER_CHEN() uint32 {
	return volatile.LoadUint32(&o.BASECHER.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECHER_UPDATEEN(value uint32) {
	volatile.StoreUint32(&o.BASECHER.Reg, volatile.LoadUint32(&o.BASECHER.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetBASECHER_UPDATEEN() uint32 {
	return (volatile.LoadUint32(&o.BASECHER.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetBASECHER_A2QEN(value uint32) {
	volatile.StoreUint32(&o.BASECHER.Reg, volatile.LoadUint32(&o.BASECHER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASECHER_A2QEN() uint32 {
	return (volatile.LoadUint32(&o.BASECHER.Reg) & 0x4) >> 2
}

// LCDC.BASECHDR: Base Layer Channel Disable Register
func (o *LCDC_Type) SetBASECHDR_CHDIS(value uint32) {
	volatile.StoreUint32(&o.BASECHDR.Reg, volatile.LoadUint32(&o.BASECHDR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECHDR_CHDIS() uint32 {
	return volatile.LoadUint32(&o.BASECHDR.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECHDR_CHRST(value uint32) {
	volatile.StoreUint32(&o.BASECHDR.Reg, volatile.LoadUint32(&o.BASECHDR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetBASECHDR_CHRST() uint32 {
	return (volatile.LoadUint32(&o.BASECHDR.Reg) & 0x100) >> 8
}

// LCDC.BASECHSR: Base Layer Channel Status Register
func (o *LCDC_Type) SetBASECHSR_CHSR(value uint32) {
	volatile.StoreUint32(&o.BASECHSR.Reg, volatile.LoadUint32(&o.BASECHSR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECHSR_CHSR() uint32 {
	return volatile.LoadUint32(&o.BASECHSR.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECHSR_UPDATESR(value uint32) {
	volatile.StoreUint32(&o.BASECHSR.Reg, volatile.LoadUint32(&o.BASECHSR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetBASECHSR_UPDATESR() uint32 {
	return (volatile.LoadUint32(&o.BASECHSR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetBASECHSR_A2QSR(value uint32) {
	volatile.StoreUint32(&o.BASECHSR.Reg, volatile.LoadUint32(&o.BASECHSR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASECHSR_A2QSR() uint32 {
	return (volatile.LoadUint32(&o.BASECHSR.Reg) & 0x4) >> 2
}

// LCDC.BASEIER: Base Layer Interrupt Enable Register
func (o *LCDC_Type) SetBASEIER_DMA(value uint32) {
	volatile.StoreUint32(&o.BASEIER.Reg, volatile.LoadUint32(&o.BASEIER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASEIER_DMA() uint32 {
	return (volatile.LoadUint32(&o.BASEIER.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetBASEIER_DSCR(value uint32) {
	volatile.StoreUint32(&o.BASEIER.Reg, volatile.LoadUint32(&o.BASEIER.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetBASEIER_DSCR() uint32 {
	return (volatile.LoadUint32(&o.BASEIER.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetBASEIER_ADD(value uint32) {
	volatile.StoreUint32(&o.BASEIER.Reg, volatile.LoadUint32(&o.BASEIER.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetBASEIER_ADD() uint32 {
	return (volatile.LoadUint32(&o.BASEIER.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetBASEIER_DONE(value uint32) {
	volatile.StoreUint32(&o.BASEIER.Reg, volatile.LoadUint32(&o.BASEIER.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetBASEIER_DONE() uint32 {
	return (volatile.LoadUint32(&o.BASEIER.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetBASEIER_OVR(value uint32) {
	volatile.StoreUint32(&o.BASEIER.Reg, volatile.LoadUint32(&o.BASEIER.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetBASEIER_OVR() uint32 {
	return (volatile.LoadUint32(&o.BASEIER.Reg) & 0x40) >> 6
}

// LCDC.BASEIDR: Base Layer Interrupt Disabled Register
func (o *LCDC_Type) SetBASEIDR_DMA(value uint32) {
	volatile.StoreUint32(&o.BASEIDR.Reg, volatile.LoadUint32(&o.BASEIDR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASEIDR_DMA() uint32 {
	return (volatile.LoadUint32(&o.BASEIDR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetBASEIDR_DSCR(value uint32) {
	volatile.StoreUint32(&o.BASEIDR.Reg, volatile.LoadUint32(&o.BASEIDR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetBASEIDR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.BASEIDR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetBASEIDR_ADD(value uint32) {
	volatile.StoreUint32(&o.BASEIDR.Reg, volatile.LoadUint32(&o.BASEIDR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetBASEIDR_ADD() uint32 {
	return (volatile.LoadUint32(&o.BASEIDR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetBASEIDR_DONE(value uint32) {
	volatile.StoreUint32(&o.BASEIDR.Reg, volatile.LoadUint32(&o.BASEIDR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetBASEIDR_DONE() uint32 {
	return (volatile.LoadUint32(&o.BASEIDR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetBASEIDR_OVR(value uint32) {
	volatile.StoreUint32(&o.BASEIDR.Reg, volatile.LoadUint32(&o.BASEIDR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetBASEIDR_OVR() uint32 {
	return (volatile.LoadUint32(&o.BASEIDR.Reg) & 0x40) >> 6
}

// LCDC.BASEIMR: Base Layer Interrupt Mask Register
func (o *LCDC_Type) SetBASEIMR_DMA(value uint32) {
	volatile.StoreUint32(&o.BASEIMR.Reg, volatile.LoadUint32(&o.BASEIMR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASEIMR_DMA() uint32 {
	return (volatile.LoadUint32(&o.BASEIMR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetBASEIMR_DSCR(value uint32) {
	volatile.StoreUint32(&o.BASEIMR.Reg, volatile.LoadUint32(&o.BASEIMR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetBASEIMR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.BASEIMR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetBASEIMR_ADD(value uint32) {
	volatile.StoreUint32(&o.BASEIMR.Reg, volatile.LoadUint32(&o.BASEIMR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetBASEIMR_ADD() uint32 {
	return (volatile.LoadUint32(&o.BASEIMR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetBASEIMR_DONE(value uint32) {
	volatile.StoreUint32(&o.BASEIMR.Reg, volatile.LoadUint32(&o.BASEIMR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetBASEIMR_DONE() uint32 {
	return (volatile.LoadUint32(&o.BASEIMR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetBASEIMR_OVR(value uint32) {
	volatile.StoreUint32(&o.BASEIMR.Reg, volatile.LoadUint32(&o.BASEIMR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetBASEIMR_OVR() uint32 {
	return (volatile.LoadUint32(&o.BASEIMR.Reg) & 0x40) >> 6
}

// LCDC.BASEISR: Base Layer Interrupt status Register
func (o *LCDC_Type) SetBASEISR_DMA(value uint32) {
	volatile.StoreUint32(&o.BASEISR.Reg, volatile.LoadUint32(&o.BASEISR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASEISR_DMA() uint32 {
	return (volatile.LoadUint32(&o.BASEISR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetBASEISR_DSCR(value uint32) {
	volatile.StoreUint32(&o.BASEISR.Reg, volatile.LoadUint32(&o.BASEISR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetBASEISR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.BASEISR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetBASEISR_ADD(value uint32) {
	volatile.StoreUint32(&o.BASEISR.Reg, volatile.LoadUint32(&o.BASEISR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetBASEISR_ADD() uint32 {
	return (volatile.LoadUint32(&o.BASEISR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetBASEISR_DONE(value uint32) {
	volatile.StoreUint32(&o.BASEISR.Reg, volatile.LoadUint32(&o.BASEISR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetBASEISR_DONE() uint32 {
	return (volatile.LoadUint32(&o.BASEISR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetBASEISR_OVR(value uint32) {
	volatile.StoreUint32(&o.BASEISR.Reg, volatile.LoadUint32(&o.BASEISR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetBASEISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.BASEISR.Reg) & 0x40) >> 6
}

// LCDC.BASEHEAD: Base DMA Head Register
func (o *LCDC_Type) SetBASEHEAD_HEAD(value uint32) {
	volatile.StoreUint32(&o.BASEHEAD.Reg, volatile.LoadUint32(&o.BASEHEAD.Reg)&^(0xfffffffc)|value<<2)
}
func (o *LCDC_Type) GetBASEHEAD_HEAD() uint32 {
	return (volatile.LoadUint32(&o.BASEHEAD.Reg) & 0xfffffffc) >> 2
}

// LCDC.BASEADDR: Base DMA Address Register
func (o *LCDC_Type) SetBASEADDR(value uint32) {
	volatile.StoreUint32(&o.BASEADDR.Reg, value)
}
func (o *LCDC_Type) GetBASEADDR() uint32 {
	return volatile.LoadUint32(&o.BASEADDR.Reg)
}

// LCDC.BASECTRL: Base DMA Control Register
func (o *LCDC_Type) SetBASECTRL_DFETCH(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECTRL_DFETCH() uint32 {
	return volatile.LoadUint32(&o.BASECTRL.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECTRL_LFETCH(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetBASECTRL_LFETCH() uint32 {
	return (volatile.LoadUint32(&o.BASECTRL.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetBASECTRL_DMAIEN(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASECTRL_DMAIEN() uint32 {
	return (volatile.LoadUint32(&o.BASECTRL.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetBASECTRL_DSCRIEN(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetBASECTRL_DSCRIEN() uint32 {
	return (volatile.LoadUint32(&o.BASECTRL.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetBASECTRL_ADDIEN(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetBASECTRL_ADDIEN() uint32 {
	return (volatile.LoadUint32(&o.BASECTRL.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetBASECTRL_DONEIEN(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetBASECTRL_DONEIEN() uint32 {
	return (volatile.LoadUint32(&o.BASECTRL.Reg) & 0x20) >> 5
}

// LCDC.BASENEXT: Base DMA Next Register
func (o *LCDC_Type) SetBASENEXT(value uint32) {
	volatile.StoreUint32(&o.BASENEXT.Reg, value)
}
func (o *LCDC_Type) GetBASENEXT() uint32 {
	return volatile.LoadUint32(&o.BASENEXT.Reg)
}

// LCDC.BASECFG0: Base Configuration register 0
func (o *LCDC_Type) SetBASECFG0_SIF(value uint32) {
	volatile.StoreUint32(&o.BASECFG0.Reg, volatile.LoadUint32(&o.BASECFG0.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECFG0_SIF() uint32 {
	return volatile.LoadUint32(&o.BASECFG0.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECFG0_BLEN(value uint32) {
	volatile.StoreUint32(&o.BASECFG0.Reg, volatile.LoadUint32(&o.BASECFG0.Reg)&^(0x30)|value<<4)
}
func (o *LCDC_Type) GetBASECFG0_BLEN() uint32 {
	return (volatile.LoadUint32(&o.BASECFG0.Reg) & 0x30) >> 4
}
func (o *LCDC_Type) SetBASECFG0_DLBO(value uint32) {
	volatile.StoreUint32(&o.BASECFG0.Reg, volatile.LoadUint32(&o.BASECFG0.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetBASECFG0_DLBO() uint32 {
	return (volatile.LoadUint32(&o.BASECFG0.Reg) & 0x100) >> 8
}

// LCDC.BASECFG1: Base Configuration register 1
func (o *LCDC_Type) SetBASECFG1_CLUTEN(value uint32) {
	volatile.StoreUint32(&o.BASECFG1.Reg, volatile.LoadUint32(&o.BASECFG1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECFG1_CLUTEN() uint32 {
	return volatile.LoadUint32(&o.BASECFG1.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECFG1_RGBMODE(value uint32) {
	volatile.StoreUint32(&o.BASECFG1.Reg, volatile.LoadUint32(&o.BASECFG1.Reg)&^(0xf0)|value<<4)
}
func (o *LCDC_Type) GetBASECFG1_RGBMODE() uint32 {
	return (volatile.LoadUint32(&o.BASECFG1.Reg) & 0xf0) >> 4
}
func (o *LCDC_Type) SetBASECFG1_CLUTMODE(value uint32) {
	volatile.StoreUint32(&o.BASECFG1.Reg, volatile.LoadUint32(&o.BASECFG1.Reg)&^(0x300)|value<<8)
}
func (o *LCDC_Type) GetBASECFG1_CLUTMODE() uint32 {
	return (volatile.LoadUint32(&o.BASECFG1.Reg) & 0x300) >> 8
}

// LCDC.BASECFG2: Base Configuration register 2
func (o *LCDC_Type) SetBASECFG2(value uint32) {
	volatile.StoreUint32(&o.BASECFG2.Reg, value)
}
func (o *LCDC_Type) GetBASECFG2() uint32 {
	return volatile.LoadUint32(&o.BASECFG2.Reg)
}

// LCDC.BASECFG3: Base Configuration register 3
func (o *LCDC_Type) SetBASECFG3_BDEF(value uint32) {
	volatile.StoreUint32(&o.BASECFG3.Reg, volatile.LoadUint32(&o.BASECFG3.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetBASECFG3_BDEF() uint32 {
	return volatile.LoadUint32(&o.BASECFG3.Reg) & 0xff
}
func (o *LCDC_Type) SetBASECFG3_GDEF(value uint32) {
	volatile.StoreUint32(&o.BASECFG3.Reg, volatile.LoadUint32(&o.BASECFG3.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetBASECFG3_GDEF() uint32 {
	return (volatile.LoadUint32(&o.BASECFG3.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetBASECFG3_RDEF(value uint32) {
	volatile.StoreUint32(&o.BASECFG3.Reg, volatile.LoadUint32(&o.BASECFG3.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetBASECFG3_RDEF() uint32 {
	return (volatile.LoadUint32(&o.BASECFG3.Reg) & 0xff0000) >> 16
}

// LCDC.BASECFG4: Base Configuration register 4
func (o *LCDC_Type) SetBASECFG4_DMA(value uint32) {
	volatile.StoreUint32(&o.BASECFG4.Reg, volatile.LoadUint32(&o.BASECFG4.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetBASECFG4_DMA() uint32 {
	return (volatile.LoadUint32(&o.BASECFG4.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetBASECFG4_REP(value uint32) {
	volatile.StoreUint32(&o.BASECFG4.Reg, volatile.LoadUint32(&o.BASECFG4.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetBASECFG4_REP() uint32 {
	return (volatile.LoadUint32(&o.BASECFG4.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetBASECFG4_DISCEN(value uint32) {
	volatile.StoreUint32(&o.BASECFG4.Reg, volatile.LoadUint32(&o.BASECFG4.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetBASECFG4_DISCEN() uint32 {
	return (volatile.LoadUint32(&o.BASECFG4.Reg) & 0x800) >> 11
}

// LCDC.BASECFG5: Base Configuration register 5
func (o *LCDC_Type) SetBASECFG5_DISCXPOS(value uint32) {
	volatile.StoreUint32(&o.BASECFG5.Reg, volatile.LoadUint32(&o.BASECFG5.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetBASECFG5_DISCXPOS() uint32 {
	return volatile.LoadUint32(&o.BASECFG5.Reg) & 0x7ff
}
func (o *LCDC_Type) SetBASECFG5_DISCYPOS(value uint32) {
	volatile.StoreUint32(&o.BASECFG5.Reg, volatile.LoadUint32(&o.BASECFG5.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetBASECFG5_DISCYPOS() uint32 {
	return (volatile.LoadUint32(&o.BASECFG5.Reg) & 0x7ff0000) >> 16
}

// LCDC.BASECFG6: Base Configuration register 6
func (o *LCDC_Type) SetBASECFG6_DISCXSIZE(value uint32) {
	volatile.StoreUint32(&o.BASECFG6.Reg, volatile.LoadUint32(&o.BASECFG6.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetBASECFG6_DISCXSIZE() uint32 {
	return volatile.LoadUint32(&o.BASECFG6.Reg) & 0x7ff
}
func (o *LCDC_Type) SetBASECFG6_DISCYSIZE(value uint32) {
	volatile.StoreUint32(&o.BASECFG6.Reg, volatile.LoadUint32(&o.BASECFG6.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetBASECFG6_DISCYSIZE() uint32 {
	return (volatile.LoadUint32(&o.BASECFG6.Reg) & 0x7ff0000) >> 16
}

// LCDC.OVR1CHER: Overlay 1 Channel Enable Register
func (o *LCDC_Type) SetOVR1CHER_CHEN(value uint32) {
	volatile.StoreUint32(&o.OVR1CHER.Reg, volatile.LoadUint32(&o.OVR1CHER.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVR1CHER_CHEN() uint32 {
	return volatile.LoadUint32(&o.OVR1CHER.Reg) & 0x1
}
func (o *LCDC_Type) SetOVR1CHER_UPDATEEN(value uint32) {
	volatile.StoreUint32(&o.OVR1CHER.Reg, volatile.LoadUint32(&o.OVR1CHER.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetOVR1CHER_UPDATEEN() uint32 {
	return (volatile.LoadUint32(&o.OVR1CHER.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetOVR1CHER_A2QEN(value uint32) {
	volatile.StoreUint32(&o.OVR1CHER.Reg, volatile.LoadUint32(&o.OVR1CHER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR1CHER_A2QEN() uint32 {
	return (volatile.LoadUint32(&o.OVR1CHER.Reg) & 0x4) >> 2
}

// LCDC.OVR1CHDR: Overlay 1 Channel Disable Register
func (o *LCDC_Type) SetOVR1CHDR_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OVR1CHDR.Reg, volatile.LoadUint32(&o.OVR1CHDR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVR1CHDR_CHDIS() uint32 {
	return volatile.LoadUint32(&o.OVR1CHDR.Reg) & 0x1
}
func (o *LCDC_Type) SetOVR1CHDR_CHRST(value uint32) {
	volatile.StoreUint32(&o.OVR1CHDR.Reg, volatile.LoadUint32(&o.OVR1CHDR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetOVR1CHDR_CHRST() uint32 {
	return (volatile.LoadUint32(&o.OVR1CHDR.Reg) & 0x100) >> 8
}

// LCDC.OVR1CHSR: Overlay 1 Channel Status Register
func (o *LCDC_Type) SetOVR1CHSR_CHSR(value uint32) {
	volatile.StoreUint32(&o.OVR1CHSR.Reg, volatile.LoadUint32(&o.OVR1CHSR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVR1CHSR_CHSR() uint32 {
	return volatile.LoadUint32(&o.OVR1CHSR.Reg) & 0x1
}
func (o *LCDC_Type) SetOVR1CHSR_UPDATESR(value uint32) {
	volatile.StoreUint32(&o.OVR1CHSR.Reg, volatile.LoadUint32(&o.OVR1CHSR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetOVR1CHSR_UPDATESR() uint32 {
	return (volatile.LoadUint32(&o.OVR1CHSR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetOVR1CHSR_A2QSR(value uint32) {
	volatile.StoreUint32(&o.OVR1CHSR.Reg, volatile.LoadUint32(&o.OVR1CHSR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR1CHSR_A2QSR() uint32 {
	return (volatile.LoadUint32(&o.OVR1CHSR.Reg) & 0x4) >> 2
}

// LCDC.OVR1IER: Overlay 1 Interrupt Enable Register
func (o *LCDC_Type) SetOVR1IER_DMA(value uint32) {
	volatile.StoreUint32(&o.OVR1IER.Reg, volatile.LoadUint32(&o.OVR1IER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR1IER_DMA() uint32 {
	return (volatile.LoadUint32(&o.OVR1IER.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVR1IER_DSCR(value uint32) {
	volatile.StoreUint32(&o.OVR1IER.Reg, volatile.LoadUint32(&o.OVR1IER.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVR1IER_DSCR() uint32 {
	return (volatile.LoadUint32(&o.OVR1IER.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVR1IER_ADD(value uint32) {
	volatile.StoreUint32(&o.OVR1IER.Reg, volatile.LoadUint32(&o.OVR1IER.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVR1IER_ADD() uint32 {
	return (volatile.LoadUint32(&o.OVR1IER.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVR1IER_DONE(value uint32) {
	volatile.StoreUint32(&o.OVR1IER.Reg, volatile.LoadUint32(&o.OVR1IER.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVR1IER_DONE() uint32 {
	return (volatile.LoadUint32(&o.OVR1IER.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetOVR1IER_OVR(value uint32) {
	volatile.StoreUint32(&o.OVR1IER.Reg, volatile.LoadUint32(&o.OVR1IER.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetOVR1IER_OVR() uint32 {
	return (volatile.LoadUint32(&o.OVR1IER.Reg) & 0x40) >> 6
}

// LCDC.OVR1IDR: Overlay 1 Interrupt Disable Register
func (o *LCDC_Type) SetOVR1IDR_DMA(value uint32) {
	volatile.StoreUint32(&o.OVR1IDR.Reg, volatile.LoadUint32(&o.OVR1IDR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR1IDR_DMA() uint32 {
	return (volatile.LoadUint32(&o.OVR1IDR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVR1IDR_DSCR(value uint32) {
	volatile.StoreUint32(&o.OVR1IDR.Reg, volatile.LoadUint32(&o.OVR1IDR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVR1IDR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.OVR1IDR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVR1IDR_ADD(value uint32) {
	volatile.StoreUint32(&o.OVR1IDR.Reg, volatile.LoadUint32(&o.OVR1IDR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVR1IDR_ADD() uint32 {
	return (volatile.LoadUint32(&o.OVR1IDR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVR1IDR_DONE(value uint32) {
	volatile.StoreUint32(&o.OVR1IDR.Reg, volatile.LoadUint32(&o.OVR1IDR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVR1IDR_DONE() uint32 {
	return (volatile.LoadUint32(&o.OVR1IDR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetOVR1IDR_OVR(value uint32) {
	volatile.StoreUint32(&o.OVR1IDR.Reg, volatile.LoadUint32(&o.OVR1IDR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetOVR1IDR_OVR() uint32 {
	return (volatile.LoadUint32(&o.OVR1IDR.Reg) & 0x40) >> 6
}

// LCDC.OVR1IMR: Overlay 1 Interrupt Mask Register
func (o *LCDC_Type) SetOVR1IMR_DMA(value uint32) {
	volatile.StoreUint32(&o.OVR1IMR.Reg, volatile.LoadUint32(&o.OVR1IMR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR1IMR_DMA() uint32 {
	return (volatile.LoadUint32(&o.OVR1IMR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVR1IMR_DSCR(value uint32) {
	volatile.StoreUint32(&o.OVR1IMR.Reg, volatile.LoadUint32(&o.OVR1IMR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVR1IMR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.OVR1IMR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVR1IMR_ADD(value uint32) {
	volatile.StoreUint32(&o.OVR1IMR.Reg, volatile.LoadUint32(&o.OVR1IMR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVR1IMR_ADD() uint32 {
	return (volatile.LoadUint32(&o.OVR1IMR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVR1IMR_DONE(value uint32) {
	volatile.StoreUint32(&o.OVR1IMR.Reg, volatile.LoadUint32(&o.OVR1IMR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVR1IMR_DONE() uint32 {
	return (volatile.LoadUint32(&o.OVR1IMR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetOVR1IMR_OVR(value uint32) {
	volatile.StoreUint32(&o.OVR1IMR.Reg, volatile.LoadUint32(&o.OVR1IMR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetOVR1IMR_OVR() uint32 {
	return (volatile.LoadUint32(&o.OVR1IMR.Reg) & 0x40) >> 6
}

// LCDC.OVR1ISR: Overlay 1 Interrupt Status Register
func (o *LCDC_Type) SetOVR1ISR_DMA(value uint32) {
	volatile.StoreUint32(&o.OVR1ISR.Reg, volatile.LoadUint32(&o.OVR1ISR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR1ISR_DMA() uint32 {
	return (volatile.LoadUint32(&o.OVR1ISR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVR1ISR_DSCR(value uint32) {
	volatile.StoreUint32(&o.OVR1ISR.Reg, volatile.LoadUint32(&o.OVR1ISR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVR1ISR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.OVR1ISR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVR1ISR_ADD(value uint32) {
	volatile.StoreUint32(&o.OVR1ISR.Reg, volatile.LoadUint32(&o.OVR1ISR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVR1ISR_ADD() uint32 {
	return (volatile.LoadUint32(&o.OVR1ISR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVR1ISR_DONE(value uint32) {
	volatile.StoreUint32(&o.OVR1ISR.Reg, volatile.LoadUint32(&o.OVR1ISR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVR1ISR_DONE() uint32 {
	return (volatile.LoadUint32(&o.OVR1ISR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetOVR1ISR_OVR(value uint32) {
	volatile.StoreUint32(&o.OVR1ISR.Reg, volatile.LoadUint32(&o.OVR1ISR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetOVR1ISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.OVR1ISR.Reg) & 0x40) >> 6
}

// LCDC.OVR1HEAD: Overlay 1 DMA Head Register
func (o *LCDC_Type) SetOVR1HEAD_HEAD(value uint32) {
	volatile.StoreUint32(&o.OVR1HEAD.Reg, volatile.LoadUint32(&o.OVR1HEAD.Reg)&^(0xfffffffc)|value<<2)
}
func (o *LCDC_Type) GetOVR1HEAD_HEAD() uint32 {
	return (volatile.LoadUint32(&o.OVR1HEAD.Reg) & 0xfffffffc) >> 2
}

// LCDC.OVR1ADDR: Overlay 1 DMA Address Register
func (o *LCDC_Type) SetOVR1ADDR(value uint32) {
	volatile.StoreUint32(&o.OVR1ADDR.Reg, value)
}
func (o *LCDC_Type) GetOVR1ADDR() uint32 {
	return volatile.LoadUint32(&o.OVR1ADDR.Reg)
}

// LCDC.OVR1CTRL: Overlay1 DMA Control Register
func (o *LCDC_Type) SetOVR1CTRL_DFETCH(value uint32) {
	volatile.StoreUint32(&o.OVR1CTRL.Reg, volatile.LoadUint32(&o.OVR1CTRL.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVR1CTRL_DFETCH() uint32 {
	return volatile.LoadUint32(&o.OVR1CTRL.Reg) & 0x1
}
func (o *LCDC_Type) SetOVR1CTRL_LFETCH(value uint32) {
	volatile.StoreUint32(&o.OVR1CTRL.Reg, volatile.LoadUint32(&o.OVR1CTRL.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetOVR1CTRL_LFETCH() uint32 {
	return (volatile.LoadUint32(&o.OVR1CTRL.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetOVR1CTRL_DMAIEN(value uint32) {
	volatile.StoreUint32(&o.OVR1CTRL.Reg, volatile.LoadUint32(&o.OVR1CTRL.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR1CTRL_DMAIEN() uint32 {
	return (volatile.LoadUint32(&o.OVR1CTRL.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVR1CTRL_DSCRIEN(value uint32) {
	volatile.StoreUint32(&o.OVR1CTRL.Reg, volatile.LoadUint32(&o.OVR1CTRL.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVR1CTRL_DSCRIEN() uint32 {
	return (volatile.LoadUint32(&o.OVR1CTRL.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVR1CTRL_ADDIEN(value uint32) {
	volatile.StoreUint32(&o.OVR1CTRL.Reg, volatile.LoadUint32(&o.OVR1CTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVR1CTRL_ADDIEN() uint32 {
	return (volatile.LoadUint32(&o.OVR1CTRL.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVR1CTRL_DONEIEN(value uint32) {
	volatile.StoreUint32(&o.OVR1CTRL.Reg, volatile.LoadUint32(&o.OVR1CTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVR1CTRL_DONEIEN() uint32 {
	return (volatile.LoadUint32(&o.OVR1CTRL.Reg) & 0x20) >> 5
}

// LCDC.OVR1NEXT: Overlay1 DMA Next Register
func (o *LCDC_Type) SetOVR1NEXT(value uint32) {
	volatile.StoreUint32(&o.OVR1NEXT.Reg, value)
}
func (o *LCDC_Type) GetOVR1NEXT() uint32 {
	return volatile.LoadUint32(&o.OVR1NEXT.Reg)
}

// LCDC.OVR1CFG0: Overlay 1 Configuration 0 Register
func (o *LCDC_Type) SetOVR1CFG0_SIF(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG0.Reg, volatile.LoadUint32(&o.OVR1CFG0.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVR1CFG0_SIF() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG0.Reg) & 0x1
}
func (o *LCDC_Type) SetOVR1CFG0_BLEN(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG0.Reg, volatile.LoadUint32(&o.OVR1CFG0.Reg)&^(0x30)|value<<4)
}
func (o *LCDC_Type) GetOVR1CFG0_BLEN() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG0.Reg) & 0x30) >> 4
}
func (o *LCDC_Type) SetOVR1CFG0_DLBO(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG0.Reg, volatile.LoadUint32(&o.OVR1CFG0.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetOVR1CFG0_DLBO() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG0.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetOVR1CFG0_ROTDIS(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG0.Reg, volatile.LoadUint32(&o.OVR1CFG0.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetOVR1CFG0_ROTDIS() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG0.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetOVR1CFG0_LOCKDIS(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG0.Reg, volatile.LoadUint32(&o.OVR1CFG0.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetOVR1CFG0_LOCKDIS() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG0.Reg) & 0x2000) >> 13
}

// LCDC.OVR1CFG1: Overlay 1 Configuration 1 Register
func (o *LCDC_Type) SetOVR1CFG1_CLUTEN(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG1.Reg, volatile.LoadUint32(&o.OVR1CFG1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVR1CFG1_CLUTEN() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG1.Reg) & 0x1
}
func (o *LCDC_Type) SetOVR1CFG1_RGBMODE(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG1.Reg, volatile.LoadUint32(&o.OVR1CFG1.Reg)&^(0xf0)|value<<4)
}
func (o *LCDC_Type) GetOVR1CFG1_RGBMODE() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG1.Reg) & 0xf0) >> 4
}
func (o *LCDC_Type) SetOVR1CFG1_CLUTMODE(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG1.Reg, volatile.LoadUint32(&o.OVR1CFG1.Reg)&^(0x300)|value<<8)
}
func (o *LCDC_Type) GetOVR1CFG1_CLUTMODE() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG1.Reg) & 0x300) >> 8
}

// LCDC.OVR1CFG2: Overlay 1 Configuration 2 Register
func (o *LCDC_Type) SetOVR1CFG2_XPOS(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG2.Reg, volatile.LoadUint32(&o.OVR1CFG2.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetOVR1CFG2_XPOS() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG2.Reg) & 0x7ff
}
func (o *LCDC_Type) SetOVR1CFG2_YPOS(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG2.Reg, volatile.LoadUint32(&o.OVR1CFG2.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR1CFG2_YPOS() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG2.Reg) & 0x7ff0000) >> 16
}

// LCDC.OVR1CFG3: Overlay 1 Configuration 3 Register
func (o *LCDC_Type) SetOVR1CFG3_XSIZE(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG3.Reg, volatile.LoadUint32(&o.OVR1CFG3.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetOVR1CFG3_XSIZE() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG3.Reg) & 0x7ff
}
func (o *LCDC_Type) SetOVR1CFG3_YSIZE(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG3.Reg, volatile.LoadUint32(&o.OVR1CFG3.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR1CFG3_YSIZE() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG3.Reg) & 0x7ff0000) >> 16
}

// LCDC.OVR1CFG4: Overlay 1 Configuration 4 Register
func (o *LCDC_Type) SetOVR1CFG4(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG4.Reg, value)
}
func (o *LCDC_Type) GetOVR1CFG4() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG4.Reg)
}

// LCDC.OVR1CFG5: Overlay 1 Configuration 5 Register
func (o *LCDC_Type) SetOVR1CFG5(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG5.Reg, value)
}
func (o *LCDC_Type) GetOVR1CFG5() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG5.Reg)
}

// LCDC.OVR1CFG6: Overlay 1 Configuration 6 Register
func (o *LCDC_Type) SetOVR1CFG6_BDEF(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG6.Reg, volatile.LoadUint32(&o.OVR1CFG6.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetOVR1CFG6_BDEF() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG6.Reg) & 0xff
}
func (o *LCDC_Type) SetOVR1CFG6_GDEF(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG6.Reg, volatile.LoadUint32(&o.OVR1CFG6.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetOVR1CFG6_GDEF() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG6.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetOVR1CFG6_RDEF(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG6.Reg, volatile.LoadUint32(&o.OVR1CFG6.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR1CFG6_RDEF() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG6.Reg) & 0xff0000) >> 16
}

// LCDC.OVR1CFG7: Overlay 1 Configuration 7 Register
func (o *LCDC_Type) SetOVR1CFG7_BKEY(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG7.Reg, volatile.LoadUint32(&o.OVR1CFG7.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetOVR1CFG7_BKEY() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG7.Reg) & 0xff
}
func (o *LCDC_Type) SetOVR1CFG7_GKEY(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG7.Reg, volatile.LoadUint32(&o.OVR1CFG7.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetOVR1CFG7_GKEY() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG7.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetOVR1CFG7_RKEY(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG7.Reg, volatile.LoadUint32(&o.OVR1CFG7.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR1CFG7_RKEY() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG7.Reg) & 0xff0000) >> 16
}

// LCDC.OVR1CFG8: Overlay 1 Configuration 8Register
func (o *LCDC_Type) SetOVR1CFG8_BMASK(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG8.Reg, volatile.LoadUint32(&o.OVR1CFG8.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetOVR1CFG8_BMASK() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG8.Reg) & 0xff
}
func (o *LCDC_Type) SetOVR1CFG8_GMASK(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG8.Reg, volatile.LoadUint32(&o.OVR1CFG8.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetOVR1CFG8_GMASK() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG8.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetOVR1CFG8_RMASK(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG8.Reg, volatile.LoadUint32(&o.OVR1CFG8.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR1CFG8_RMASK() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG8.Reg) & 0xff0000) >> 16
}

// LCDC.OVR1CFG9: Overlay 1 Configuration 9 Register
func (o *LCDC_Type) SetOVR1CFG9_CRKEY(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVR1CFG9_CRKEY() uint32 {
	return volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x1
}
func (o *LCDC_Type) SetOVR1CFG9_INV(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetOVR1CFG9_INV() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetOVR1CFG9_ITER2BL(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR1CFG9_ITER2BL() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVR1CFG9_ITER(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVR1CFG9_ITER() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVR1CFG9_REVALPHA(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVR1CFG9_REVALPHA() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVR1CFG9_GAEN(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVR1CFG9_GAEN() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetOVR1CFG9_LAEN(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetOVR1CFG9_LAEN() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetOVR1CFG9_OVR(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x80)|value<<7)
}
func (o *LCDC_Type) GetOVR1CFG9_OVR() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x80) >> 7
}
func (o *LCDC_Type) SetOVR1CFG9_DMA(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetOVR1CFG9_DMA() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetOVR1CFG9_REP(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetOVR1CFG9_REP() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetOVR1CFG9_DSTKEY(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetOVR1CFG9_DSTKEY() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetOVR1CFG9_GA(value uint32) {
	volatile.StoreUint32(&o.OVR1CFG9.Reg, volatile.LoadUint32(&o.OVR1CFG9.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR1CFG9_GA() uint32 {
	return (volatile.LoadUint32(&o.OVR1CFG9.Reg) & 0xff0000) >> 16
}

// LCDC.OVR2CHER: Overlay 2 Channel Enable Register
func (o *LCDC_Type) SetOVR2CHER_CHEN(value uint32) {
	volatile.StoreUint32(&o.OVR2CHER.Reg, volatile.LoadUint32(&o.OVR2CHER.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVR2CHER_CHEN() uint32 {
	return volatile.LoadUint32(&o.OVR2CHER.Reg) & 0x1
}
func (o *LCDC_Type) SetOVR2CHER_UPDATEEN(value uint32) {
	volatile.StoreUint32(&o.OVR2CHER.Reg, volatile.LoadUint32(&o.OVR2CHER.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetOVR2CHER_UPDATEEN() uint32 {
	return (volatile.LoadUint32(&o.OVR2CHER.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetOVR2CHER_A2QEN(value uint32) {
	volatile.StoreUint32(&o.OVR2CHER.Reg, volatile.LoadUint32(&o.OVR2CHER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR2CHER_A2QEN() uint32 {
	return (volatile.LoadUint32(&o.OVR2CHER.Reg) & 0x4) >> 2
}

// LCDC.OVR2CHDR: Overlay 2 Channel Disable Register
func (o *LCDC_Type) SetOVR2CHDR_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OVR2CHDR.Reg, volatile.LoadUint32(&o.OVR2CHDR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVR2CHDR_CHDIS() uint32 {
	return volatile.LoadUint32(&o.OVR2CHDR.Reg) & 0x1
}
func (o *LCDC_Type) SetOVR2CHDR_CHRST(value uint32) {
	volatile.StoreUint32(&o.OVR2CHDR.Reg, volatile.LoadUint32(&o.OVR2CHDR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetOVR2CHDR_CHRST() uint32 {
	return (volatile.LoadUint32(&o.OVR2CHDR.Reg) & 0x100) >> 8
}

// LCDC.OVR2CHSR: Overlay 2 Channel Status Register
func (o *LCDC_Type) SetOVR2CHSR_CHSR(value uint32) {
	volatile.StoreUint32(&o.OVR2CHSR.Reg, volatile.LoadUint32(&o.OVR2CHSR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVR2CHSR_CHSR() uint32 {
	return volatile.LoadUint32(&o.OVR2CHSR.Reg) & 0x1
}
func (o *LCDC_Type) SetOVR2CHSR_UPDATESR(value uint32) {
	volatile.StoreUint32(&o.OVR2CHSR.Reg, volatile.LoadUint32(&o.OVR2CHSR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetOVR2CHSR_UPDATESR() uint32 {
	return (volatile.LoadUint32(&o.OVR2CHSR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetOVR2CHSR_A2QSR(value uint32) {
	volatile.StoreUint32(&o.OVR2CHSR.Reg, volatile.LoadUint32(&o.OVR2CHSR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR2CHSR_A2QSR() uint32 {
	return (volatile.LoadUint32(&o.OVR2CHSR.Reg) & 0x4) >> 2
}

// LCDC.OVR2IER: Overlay 2 Interrupt Enable Register
func (o *LCDC_Type) SetOVR2IER_DMA(value uint32) {
	volatile.StoreUint32(&o.OVR2IER.Reg, volatile.LoadUint32(&o.OVR2IER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR2IER_DMA() uint32 {
	return (volatile.LoadUint32(&o.OVR2IER.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVR2IER_DSCR(value uint32) {
	volatile.StoreUint32(&o.OVR2IER.Reg, volatile.LoadUint32(&o.OVR2IER.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVR2IER_DSCR() uint32 {
	return (volatile.LoadUint32(&o.OVR2IER.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVR2IER_ADD(value uint32) {
	volatile.StoreUint32(&o.OVR2IER.Reg, volatile.LoadUint32(&o.OVR2IER.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVR2IER_ADD() uint32 {
	return (volatile.LoadUint32(&o.OVR2IER.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVR2IER_DONE(value uint32) {
	volatile.StoreUint32(&o.OVR2IER.Reg, volatile.LoadUint32(&o.OVR2IER.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVR2IER_DONE() uint32 {
	return (volatile.LoadUint32(&o.OVR2IER.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetOVR2IER_OVR(value uint32) {
	volatile.StoreUint32(&o.OVR2IER.Reg, volatile.LoadUint32(&o.OVR2IER.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetOVR2IER_OVR() uint32 {
	return (volatile.LoadUint32(&o.OVR2IER.Reg) & 0x40) >> 6
}

// LCDC.OVR2IDR: Overlay 2 Interrupt Disable Register
func (o *LCDC_Type) SetOVR2IDR_DMA(value uint32) {
	volatile.StoreUint32(&o.OVR2IDR.Reg, volatile.LoadUint32(&o.OVR2IDR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR2IDR_DMA() uint32 {
	return (volatile.LoadUint32(&o.OVR2IDR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVR2IDR_DSCR(value uint32) {
	volatile.StoreUint32(&o.OVR2IDR.Reg, volatile.LoadUint32(&o.OVR2IDR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVR2IDR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.OVR2IDR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVR2IDR_ADD(value uint32) {
	volatile.StoreUint32(&o.OVR2IDR.Reg, volatile.LoadUint32(&o.OVR2IDR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVR2IDR_ADD() uint32 {
	return (volatile.LoadUint32(&o.OVR2IDR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVR2IDR_DONE(value uint32) {
	volatile.StoreUint32(&o.OVR2IDR.Reg, volatile.LoadUint32(&o.OVR2IDR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVR2IDR_DONE() uint32 {
	return (volatile.LoadUint32(&o.OVR2IDR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetOVR2IDR_OVR(value uint32) {
	volatile.StoreUint32(&o.OVR2IDR.Reg, volatile.LoadUint32(&o.OVR2IDR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetOVR2IDR_OVR() uint32 {
	return (volatile.LoadUint32(&o.OVR2IDR.Reg) & 0x40) >> 6
}

// LCDC.OVR2IMR: Overlay 2 Interrupt Mask Register
func (o *LCDC_Type) SetOVR2IMR_DMA(value uint32) {
	volatile.StoreUint32(&o.OVR2IMR.Reg, volatile.LoadUint32(&o.OVR2IMR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR2IMR_DMA() uint32 {
	return (volatile.LoadUint32(&o.OVR2IMR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVR2IMR_DSCR(value uint32) {
	volatile.StoreUint32(&o.OVR2IMR.Reg, volatile.LoadUint32(&o.OVR2IMR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVR2IMR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.OVR2IMR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVR2IMR_ADD(value uint32) {
	volatile.StoreUint32(&o.OVR2IMR.Reg, volatile.LoadUint32(&o.OVR2IMR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVR2IMR_ADD() uint32 {
	return (volatile.LoadUint32(&o.OVR2IMR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVR2IMR_DONE(value uint32) {
	volatile.StoreUint32(&o.OVR2IMR.Reg, volatile.LoadUint32(&o.OVR2IMR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVR2IMR_DONE() uint32 {
	return (volatile.LoadUint32(&o.OVR2IMR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetOVR2IMR_OVR(value uint32) {
	volatile.StoreUint32(&o.OVR2IMR.Reg, volatile.LoadUint32(&o.OVR2IMR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetOVR2IMR_OVR() uint32 {
	return (volatile.LoadUint32(&o.OVR2IMR.Reg) & 0x40) >> 6
}

// LCDC.OVR2ISR: Overlay 2 Interrupt status Register
func (o *LCDC_Type) SetOVR2ISR_DMA(value uint32) {
	volatile.StoreUint32(&o.OVR2ISR.Reg, volatile.LoadUint32(&o.OVR2ISR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR2ISR_DMA() uint32 {
	return (volatile.LoadUint32(&o.OVR2ISR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVR2ISR_DSCR(value uint32) {
	volatile.StoreUint32(&o.OVR2ISR.Reg, volatile.LoadUint32(&o.OVR2ISR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVR2ISR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.OVR2ISR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVR2ISR_ADD(value uint32) {
	volatile.StoreUint32(&o.OVR2ISR.Reg, volatile.LoadUint32(&o.OVR2ISR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVR2ISR_ADD() uint32 {
	return (volatile.LoadUint32(&o.OVR2ISR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVR2ISR_DONE(value uint32) {
	volatile.StoreUint32(&o.OVR2ISR.Reg, volatile.LoadUint32(&o.OVR2ISR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVR2ISR_DONE() uint32 {
	return (volatile.LoadUint32(&o.OVR2ISR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetOVR2ISR_OVR(value uint32) {
	volatile.StoreUint32(&o.OVR2ISR.Reg, volatile.LoadUint32(&o.OVR2ISR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetOVR2ISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.OVR2ISR.Reg) & 0x40) >> 6
}

// LCDC.OVR2HEAD: Overlay 2 DMA Head Register
func (o *LCDC_Type) SetOVR2HEAD_HEAD(value uint32) {
	volatile.StoreUint32(&o.OVR2HEAD.Reg, volatile.LoadUint32(&o.OVR2HEAD.Reg)&^(0xfffffffc)|value<<2)
}
func (o *LCDC_Type) GetOVR2HEAD_HEAD() uint32 {
	return (volatile.LoadUint32(&o.OVR2HEAD.Reg) & 0xfffffffc) >> 2
}

// LCDC.OVR2ADDR: Overlay 2 DMA Address Register
func (o *LCDC_Type) SetOVR2ADDR(value uint32) {
	volatile.StoreUint32(&o.OVR2ADDR.Reg, value)
}
func (o *LCDC_Type) GetOVR2ADDR() uint32 {
	return volatile.LoadUint32(&o.OVR2ADDR.Reg)
}

// LCDC.OVR2CTRL: Overlay 2 DMA Control Register
func (o *LCDC_Type) SetOVR2CTRL_DFETCH(value uint32) {
	volatile.StoreUint32(&o.OVR2CTRL.Reg, volatile.LoadUint32(&o.OVR2CTRL.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVR2CTRL_DFETCH() uint32 {
	return volatile.LoadUint32(&o.OVR2CTRL.Reg) & 0x1
}
func (o *LCDC_Type) SetOVR2CTRL_LFETCH(value uint32) {
	volatile.StoreUint32(&o.OVR2CTRL.Reg, volatile.LoadUint32(&o.OVR2CTRL.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetOVR2CTRL_LFETCH() uint32 {
	return (volatile.LoadUint32(&o.OVR2CTRL.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetOVR2CTRL_DMAIEN(value uint32) {
	volatile.StoreUint32(&o.OVR2CTRL.Reg, volatile.LoadUint32(&o.OVR2CTRL.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR2CTRL_DMAIEN() uint32 {
	return (volatile.LoadUint32(&o.OVR2CTRL.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVR2CTRL_DSCRIEN(value uint32) {
	volatile.StoreUint32(&o.OVR2CTRL.Reg, volatile.LoadUint32(&o.OVR2CTRL.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVR2CTRL_DSCRIEN() uint32 {
	return (volatile.LoadUint32(&o.OVR2CTRL.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVR2CTRL_ADDIEN(value uint32) {
	volatile.StoreUint32(&o.OVR2CTRL.Reg, volatile.LoadUint32(&o.OVR2CTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVR2CTRL_ADDIEN() uint32 {
	return (volatile.LoadUint32(&o.OVR2CTRL.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVR2CTRL_DONEIEN(value uint32) {
	volatile.StoreUint32(&o.OVR2CTRL.Reg, volatile.LoadUint32(&o.OVR2CTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVR2CTRL_DONEIEN() uint32 {
	return (volatile.LoadUint32(&o.OVR2CTRL.Reg) & 0x20) >> 5
}

// LCDC.OVR2NEXT: Overlay 2 DMA Next Register
func (o *LCDC_Type) SetOVR2NEXT(value uint32) {
	volatile.StoreUint32(&o.OVR2NEXT.Reg, value)
}
func (o *LCDC_Type) GetOVR2NEXT() uint32 {
	return volatile.LoadUint32(&o.OVR2NEXT.Reg)
}

// LCDC.OVR2CFG0: Overlay 2 Configuration 0 Register
func (o *LCDC_Type) SetOVR2CFG0_BLEN(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG0.Reg, volatile.LoadUint32(&o.OVR2CFG0.Reg)&^(0x30)|value<<4)
}
func (o *LCDC_Type) GetOVR2CFG0_BLEN() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG0.Reg) & 0x30) >> 4
}
func (o *LCDC_Type) SetOVR2CFG0_DLBO(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG0.Reg, volatile.LoadUint32(&o.OVR2CFG0.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetOVR2CFG0_DLBO() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG0.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetOVR2CFG0_ROTDIS(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG0.Reg, volatile.LoadUint32(&o.OVR2CFG0.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetOVR2CFG0_ROTDIS() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG0.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetOVR2CFG0_LOCKDIS(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG0.Reg, volatile.LoadUint32(&o.OVR2CFG0.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetOVR2CFG0_LOCKDIS() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG0.Reg) & 0x2000) >> 13
}

// LCDC.OVR2CFG1: Overlay 2 Configuration 1 Register
func (o *LCDC_Type) SetOVR2CFG1_CLUTEN(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG1.Reg, volatile.LoadUint32(&o.OVR2CFG1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVR2CFG1_CLUTEN() uint32 {
	return volatile.LoadUint32(&o.OVR2CFG1.Reg) & 0x1
}
func (o *LCDC_Type) SetOVR2CFG1_RGBMODE(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG1.Reg, volatile.LoadUint32(&o.OVR2CFG1.Reg)&^(0xf0)|value<<4)
}
func (o *LCDC_Type) GetOVR2CFG1_RGBMODE() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG1.Reg) & 0xf0) >> 4
}
func (o *LCDC_Type) SetOVR2CFG1_CLUTMODE(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG1.Reg, volatile.LoadUint32(&o.OVR2CFG1.Reg)&^(0x300)|value<<8)
}
func (o *LCDC_Type) GetOVR2CFG1_CLUTMODE() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG1.Reg) & 0x300) >> 8
}

// LCDC.OVR2CFG2: Overlay 2 Configuration 2 Register
func (o *LCDC_Type) SetOVR2CFG2_XPOS(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG2.Reg, volatile.LoadUint32(&o.OVR2CFG2.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetOVR2CFG2_XPOS() uint32 {
	return volatile.LoadUint32(&o.OVR2CFG2.Reg) & 0x7ff
}
func (o *LCDC_Type) SetOVR2CFG2_YPOS(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG2.Reg, volatile.LoadUint32(&o.OVR2CFG2.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR2CFG2_YPOS() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG2.Reg) & 0x7ff0000) >> 16
}

// LCDC.OVR2CFG3: Overlay 2 Configuration 3 Register
func (o *LCDC_Type) SetOVR2CFG3_XSIZE(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG3.Reg, volatile.LoadUint32(&o.OVR2CFG3.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetOVR2CFG3_XSIZE() uint32 {
	return volatile.LoadUint32(&o.OVR2CFG3.Reg) & 0x7ff
}
func (o *LCDC_Type) SetOVR2CFG3_YSIZE(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG3.Reg, volatile.LoadUint32(&o.OVR2CFG3.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR2CFG3_YSIZE() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG3.Reg) & 0x7ff0000) >> 16
}

// LCDC.OVR2CFG4: Overlay 2 Configuration 4 Register
func (o *LCDC_Type) SetOVR2CFG4(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG4.Reg, value)
}
func (o *LCDC_Type) GetOVR2CFG4() uint32 {
	return volatile.LoadUint32(&o.OVR2CFG4.Reg)
}

// LCDC.OVR2CFG5: Overlay 2 Configuration 5 Register
func (o *LCDC_Type) SetOVR2CFG5(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG5.Reg, value)
}
func (o *LCDC_Type) GetOVR2CFG5() uint32 {
	return volatile.LoadUint32(&o.OVR2CFG5.Reg)
}

// LCDC.OVR2CFG6: Overlay 2 Configuration 6 Register
func (o *LCDC_Type) SetOVR2CFG6_BDEF(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG6.Reg, volatile.LoadUint32(&o.OVR2CFG6.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetOVR2CFG6_BDEF() uint32 {
	return volatile.LoadUint32(&o.OVR2CFG6.Reg) & 0xff
}
func (o *LCDC_Type) SetOVR2CFG6_GDEF(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG6.Reg, volatile.LoadUint32(&o.OVR2CFG6.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetOVR2CFG6_GDEF() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG6.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetOVR2CFG6_RDEF(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG6.Reg, volatile.LoadUint32(&o.OVR2CFG6.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR2CFG6_RDEF() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG6.Reg) & 0xff0000) >> 16
}

// LCDC.OVR2CFG7: Overlay 2 Configuration 7 Register
func (o *LCDC_Type) SetOVR2CFG7_BKEY(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG7.Reg, volatile.LoadUint32(&o.OVR2CFG7.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetOVR2CFG7_BKEY() uint32 {
	return volatile.LoadUint32(&o.OVR2CFG7.Reg) & 0xff
}
func (o *LCDC_Type) SetOVR2CFG7_GKEY(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG7.Reg, volatile.LoadUint32(&o.OVR2CFG7.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetOVR2CFG7_GKEY() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG7.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetOVR2CFG7_RKEY(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG7.Reg, volatile.LoadUint32(&o.OVR2CFG7.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR2CFG7_RKEY() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG7.Reg) & 0xff0000) >> 16
}

// LCDC.OVR2CFG8: Overlay 2 Configuration 8 Register
func (o *LCDC_Type) SetOVR2CFG8_BMASK(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG8.Reg, volatile.LoadUint32(&o.OVR2CFG8.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetOVR2CFG8_BMASK() uint32 {
	return volatile.LoadUint32(&o.OVR2CFG8.Reg) & 0xff
}
func (o *LCDC_Type) SetOVR2CFG8_GMASK(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG8.Reg, volatile.LoadUint32(&o.OVR2CFG8.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetOVR2CFG8_GMASK() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG8.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetOVR2CFG8_RMASK(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG8.Reg, volatile.LoadUint32(&o.OVR2CFG8.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR2CFG8_RMASK() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG8.Reg) & 0xff0000) >> 16
}

// LCDC.OVR2CFG9: Overlay 2 Configuration 9 Register
func (o *LCDC_Type) SetOVR2CFG9_CRKEY(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG9.Reg, volatile.LoadUint32(&o.OVR2CFG9.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetOVR2CFG9_CRKEY() uint32 {
	return volatile.LoadUint32(&o.OVR2CFG9.Reg) & 0x1
}
func (o *LCDC_Type) SetOVR2CFG9_INV(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG9.Reg, volatile.LoadUint32(&o.OVR2CFG9.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetOVR2CFG9_INV() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG9.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetOVR2CFG9_ITER2BL(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG9.Reg, volatile.LoadUint32(&o.OVR2CFG9.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetOVR2CFG9_ITER2BL() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG9.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetOVR2CFG9_ITER(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG9.Reg, volatile.LoadUint32(&o.OVR2CFG9.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetOVR2CFG9_ITER() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG9.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetOVR2CFG9_REVALPHA(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG9.Reg, volatile.LoadUint32(&o.OVR2CFG9.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetOVR2CFG9_REVALPHA() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG9.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetOVR2CFG9_GAEN(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG9.Reg, volatile.LoadUint32(&o.OVR2CFG9.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetOVR2CFG9_GAEN() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG9.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetOVR2CFG9_LAEN(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG9.Reg, volatile.LoadUint32(&o.OVR2CFG9.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetOVR2CFG9_LAEN() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG9.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetOVR2CFG9_OVR(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG9.Reg, volatile.LoadUint32(&o.OVR2CFG9.Reg)&^(0x80)|value<<7)
}
func (o *LCDC_Type) GetOVR2CFG9_OVR() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG9.Reg) & 0x80) >> 7
}
func (o *LCDC_Type) SetOVR2CFG9_DMA(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG9.Reg, volatile.LoadUint32(&o.OVR2CFG9.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetOVR2CFG9_DMA() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG9.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetOVR2CFG9_REP(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG9.Reg, volatile.LoadUint32(&o.OVR2CFG9.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetOVR2CFG9_REP() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG9.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetOVR2CFG9_DSTKEY(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG9.Reg, volatile.LoadUint32(&o.OVR2CFG9.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetOVR2CFG9_DSTKEY() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG9.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetOVR2CFG9_GA(value uint32) {
	volatile.StoreUint32(&o.OVR2CFG9.Reg, volatile.LoadUint32(&o.OVR2CFG9.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR2CFG9_GA() uint32 {
	return (volatile.LoadUint32(&o.OVR2CFG9.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCHER: High-End Overlay Channel Enable Register
func (o *LCDC_Type) SetHEOCHER_CHEN(value uint32) {
	volatile.StoreUint32(&o.HEOCHER.Reg, volatile.LoadUint32(&o.HEOCHER.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOCHER_CHEN() uint32 {
	return volatile.LoadUint32(&o.HEOCHER.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOCHER_UPDATEEN(value uint32) {
	volatile.StoreUint32(&o.HEOCHER.Reg, volatile.LoadUint32(&o.HEOCHER.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHEOCHER_UPDATEEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCHER.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHEOCHER_A2QEN(value uint32) {
	volatile.StoreUint32(&o.HEOCHER.Reg, volatile.LoadUint32(&o.HEOCHER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOCHER_A2QEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCHER.Reg) & 0x4) >> 2
}

// LCDC.HEOCHDR: High-End Overlay Channel Disable Register
func (o *LCDC_Type) SetHEOCHDR_CHDIS(value uint32) {
	volatile.StoreUint32(&o.HEOCHDR.Reg, volatile.LoadUint32(&o.HEOCHDR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOCHDR_CHDIS() uint32 {
	return volatile.LoadUint32(&o.HEOCHDR.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOCHDR_CHRST(value uint32) {
	volatile.StoreUint32(&o.HEOCHDR.Reg, volatile.LoadUint32(&o.HEOCHDR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetHEOCHDR_CHRST() uint32 {
	return (volatile.LoadUint32(&o.HEOCHDR.Reg) & 0x100) >> 8
}

// LCDC.HEOCHSR: High-End Overlay Channel Status Register
func (o *LCDC_Type) SetHEOCHSR_CHSR(value uint32) {
	volatile.StoreUint32(&o.HEOCHSR.Reg, volatile.LoadUint32(&o.HEOCHSR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOCHSR_CHSR() uint32 {
	return volatile.LoadUint32(&o.HEOCHSR.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOCHSR_UPDATESR(value uint32) {
	volatile.StoreUint32(&o.HEOCHSR.Reg, volatile.LoadUint32(&o.HEOCHSR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHEOCHSR_UPDATESR() uint32 {
	return (volatile.LoadUint32(&o.HEOCHSR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHEOCHSR_A2QSR(value uint32) {
	volatile.StoreUint32(&o.HEOCHSR.Reg, volatile.LoadUint32(&o.HEOCHSR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOCHSR_A2QSR() uint32 {
	return (volatile.LoadUint32(&o.HEOCHSR.Reg) & 0x4) >> 2
}

// LCDC.HEOIER: High-End Overlay Interrupt Enable Register
func (o *LCDC_Type) SetHEOIER_DMA(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOIER_DMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOIER_DSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOIER_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOIER_ADD(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOIER_ADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOIER_DONE(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOIER_DONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHEOIER_OVR(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHEOIER_OVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetHEOIER_UDMA(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetHEOIER_UDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetHEOIER_UDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetHEOIER_UDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetHEOIER_UADD(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetHEOIER_UADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetHEOIER_UDONE(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetHEOIER_UDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x2000) >> 13
}
func (o *LCDC_Type) SetHEOIER_UOVR(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x4000)|value<<14)
}
func (o *LCDC_Type) GetHEOIER_UOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x4000) >> 14
}
func (o *LCDC_Type) SetHEOIER_VDMA(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x40000)|value<<18)
}
func (o *LCDC_Type) GetHEOIER_VDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x40000) >> 18
}
func (o *LCDC_Type) SetHEOIER_VDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x80000)|value<<19)
}
func (o *LCDC_Type) GetHEOIER_VDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x80000) >> 19
}
func (o *LCDC_Type) SetHEOIER_VADD(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x100000)|value<<20)
}
func (o *LCDC_Type) GetHEOIER_VADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x100000) >> 20
}
func (o *LCDC_Type) SetHEOIER_VDONE(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x200000)|value<<21)
}
func (o *LCDC_Type) GetHEOIER_VDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x200000) >> 21
}
func (o *LCDC_Type) SetHEOIER_VOVR(value uint32) {
	volatile.StoreUint32(&o.HEOIER.Reg, volatile.LoadUint32(&o.HEOIER.Reg)&^(0x400000)|value<<22)
}
func (o *LCDC_Type) GetHEOIER_VOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIER.Reg) & 0x400000) >> 22
}

// LCDC.HEOIDR: High-End Overlay Interrupt Disable Register
func (o *LCDC_Type) SetHEOIDR_DMA(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOIDR_DMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOIDR_DSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOIDR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOIDR_ADD(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOIDR_ADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOIDR_DONE(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOIDR_DONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHEOIDR_OVR(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHEOIDR_OVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetHEOIDR_UDMA(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetHEOIDR_UDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetHEOIDR_UDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetHEOIDR_UDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetHEOIDR_UADD(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetHEOIDR_UADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetHEOIDR_UDONE(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetHEOIDR_UDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x2000) >> 13
}
func (o *LCDC_Type) SetHEOIDR_UOVR(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x4000)|value<<14)
}
func (o *LCDC_Type) GetHEOIDR_UOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x4000) >> 14
}
func (o *LCDC_Type) SetHEOIDR_VDMA(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x40000)|value<<18)
}
func (o *LCDC_Type) GetHEOIDR_VDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x40000) >> 18
}
func (o *LCDC_Type) SetHEOIDR_VDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x80000)|value<<19)
}
func (o *LCDC_Type) GetHEOIDR_VDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x80000) >> 19
}
func (o *LCDC_Type) SetHEOIDR_VADD(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x100000)|value<<20)
}
func (o *LCDC_Type) GetHEOIDR_VADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x100000) >> 20
}
func (o *LCDC_Type) SetHEOIDR_VDONE(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x200000)|value<<21)
}
func (o *LCDC_Type) GetHEOIDR_VDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x200000) >> 21
}
func (o *LCDC_Type) SetHEOIDR_VOVR(value uint32) {
	volatile.StoreUint32(&o.HEOIDR.Reg, volatile.LoadUint32(&o.HEOIDR.Reg)&^(0x400000)|value<<22)
}
func (o *LCDC_Type) GetHEOIDR_VOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIDR.Reg) & 0x400000) >> 22
}

// LCDC.HEOIMR: High-End Overlay Interrupt Mask Register
func (o *LCDC_Type) SetHEOIMR_DMA(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOIMR_DMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOIMR_DSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOIMR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOIMR_ADD(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOIMR_ADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOIMR_DONE(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOIMR_DONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHEOIMR_OVR(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHEOIMR_OVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetHEOIMR_UDMA(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetHEOIMR_UDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetHEOIMR_UDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetHEOIMR_UDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetHEOIMR_UADD(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetHEOIMR_UADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetHEOIMR_UDONE(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetHEOIMR_UDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x2000) >> 13
}
func (o *LCDC_Type) SetHEOIMR_UOVR(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x4000)|value<<14)
}
func (o *LCDC_Type) GetHEOIMR_UOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x4000) >> 14
}
func (o *LCDC_Type) SetHEOIMR_VDMA(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x40000)|value<<18)
}
func (o *LCDC_Type) GetHEOIMR_VDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x40000) >> 18
}
func (o *LCDC_Type) SetHEOIMR_VDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x80000)|value<<19)
}
func (o *LCDC_Type) GetHEOIMR_VDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x80000) >> 19
}
func (o *LCDC_Type) SetHEOIMR_VADD(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x100000)|value<<20)
}
func (o *LCDC_Type) GetHEOIMR_VADD() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x100000) >> 20
}
func (o *LCDC_Type) SetHEOIMR_VDONE(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x200000)|value<<21)
}
func (o *LCDC_Type) GetHEOIMR_VDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x200000) >> 21
}
func (o *LCDC_Type) SetHEOIMR_VOVR(value uint32) {
	volatile.StoreUint32(&o.HEOIMR.Reg, volatile.LoadUint32(&o.HEOIMR.Reg)&^(0x400000)|value<<22)
}
func (o *LCDC_Type) GetHEOIMR_VOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOIMR.Reg) & 0x400000) >> 22
}

// LCDC.HEOISR: High-End Overlay Interrupt Status Register
func (o *LCDC_Type) SetHEOISR_DMA(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOISR_DMA() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOISR_DSCR(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOISR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOISR_ADD(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOISR_ADD() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOISR_DONE(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOISR_DONE() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHEOISR_OVR(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHEOISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetHEOISR_UDMA(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetHEOISR_UDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetHEOISR_UDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetHEOISR_UDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetHEOISR_UADD(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetHEOISR_UADD() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetHEOISR_UDONE(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetHEOISR_UDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x2000) >> 13
}
func (o *LCDC_Type) SetHEOISR_UOVR(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x4000)|value<<14)
}
func (o *LCDC_Type) GetHEOISR_UOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x4000) >> 14
}
func (o *LCDC_Type) SetHEOISR_VDMA(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x40000)|value<<18)
}
func (o *LCDC_Type) GetHEOISR_VDMA() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x40000) >> 18
}
func (o *LCDC_Type) SetHEOISR_VDSCR(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x80000)|value<<19)
}
func (o *LCDC_Type) GetHEOISR_VDSCR() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x80000) >> 19
}
func (o *LCDC_Type) SetHEOISR_VADD(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x100000)|value<<20)
}
func (o *LCDC_Type) GetHEOISR_VADD() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x100000) >> 20
}
func (o *LCDC_Type) SetHEOISR_VDONE(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x200000)|value<<21)
}
func (o *LCDC_Type) GetHEOISR_VDONE() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x200000) >> 21
}
func (o *LCDC_Type) SetHEOISR_VOVR(value uint32) {
	volatile.StoreUint32(&o.HEOISR.Reg, volatile.LoadUint32(&o.HEOISR.Reg)&^(0x400000)|value<<22)
}
func (o *LCDC_Type) GetHEOISR_VOVR() uint32 {
	return (volatile.LoadUint32(&o.HEOISR.Reg) & 0x400000) >> 22
}

// LCDC.HEOHEAD: High-End Overlay DMA Head Register
func (o *LCDC_Type) SetHEOHEAD_HEAD(value uint32) {
	volatile.StoreUint32(&o.HEOHEAD.Reg, volatile.LoadUint32(&o.HEOHEAD.Reg)&^(0xfffffffc)|value<<2)
}
func (o *LCDC_Type) GetHEOHEAD_HEAD() uint32 {
	return (volatile.LoadUint32(&o.HEOHEAD.Reg) & 0xfffffffc) >> 2
}

// LCDC.HEOADDR: High-End Overlay DMA Address Register
func (o *LCDC_Type) SetHEOADDR(value uint32) {
	volatile.StoreUint32(&o.HEOADDR.Reg, value)
}
func (o *LCDC_Type) GetHEOADDR() uint32 {
	return volatile.LoadUint32(&o.HEOADDR.Reg)
}

// LCDC.HEOCTRL: High-End Overlay DMA Control Register
func (o *LCDC_Type) SetHEOCTRL_DFETCH(value uint32) {
	volatile.StoreUint32(&o.HEOCTRL.Reg, volatile.LoadUint32(&o.HEOCTRL.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOCTRL_DFETCH() uint32 {
	return volatile.LoadUint32(&o.HEOCTRL.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOCTRL_LFETCH(value uint32) {
	volatile.StoreUint32(&o.HEOCTRL.Reg, volatile.LoadUint32(&o.HEOCTRL.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHEOCTRL_LFETCH() uint32 {
	return (volatile.LoadUint32(&o.HEOCTRL.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHEOCTRL_DMAIEN(value uint32) {
	volatile.StoreUint32(&o.HEOCTRL.Reg, volatile.LoadUint32(&o.HEOCTRL.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOCTRL_DMAIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCTRL.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOCTRL_DSCRIEN(value uint32) {
	volatile.StoreUint32(&o.HEOCTRL.Reg, volatile.LoadUint32(&o.HEOCTRL.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOCTRL_DSCRIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCTRL.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOCTRL_ADDIEN(value uint32) {
	volatile.StoreUint32(&o.HEOCTRL.Reg, volatile.LoadUint32(&o.HEOCTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOCTRL_ADDIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCTRL.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOCTRL_DONEIEN(value uint32) {
	volatile.StoreUint32(&o.HEOCTRL.Reg, volatile.LoadUint32(&o.HEOCTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOCTRL_DONEIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCTRL.Reg) & 0x20) >> 5
}

// LCDC.HEONEXT: High-End Overlay DMA Next Register
func (o *LCDC_Type) SetHEONEXT(value uint32) {
	volatile.StoreUint32(&o.HEONEXT.Reg, value)
}
func (o *LCDC_Type) GetHEONEXT() uint32 {
	return volatile.LoadUint32(&o.HEONEXT.Reg)
}

// LCDC.HEOUHEAD: High-End Overlay U DMA Head Register
func (o *LCDC_Type) SetHEOUHEAD(value uint32) {
	volatile.StoreUint32(&o.HEOUHEAD.Reg, value)
}
func (o *LCDC_Type) GetHEOUHEAD() uint32 {
	return volatile.LoadUint32(&o.HEOUHEAD.Reg)
}

// LCDC.HEOUADDR: High-End Overlay U DMA Address Register
func (o *LCDC_Type) SetHEOUADDR(value uint32) {
	volatile.StoreUint32(&o.HEOUADDR.Reg, value)
}
func (o *LCDC_Type) GetHEOUADDR() uint32 {
	return volatile.LoadUint32(&o.HEOUADDR.Reg)
}

// LCDC.HEOUCTRL: High-End Overlay U DMA control Register
func (o *LCDC_Type) SetHEOUCTRL_UDFETCH(value uint32) {
	volatile.StoreUint32(&o.HEOUCTRL.Reg, volatile.LoadUint32(&o.HEOUCTRL.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOUCTRL_UDFETCH() uint32 {
	return volatile.LoadUint32(&o.HEOUCTRL.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOUCTRL_UDMAIEN(value uint32) {
	volatile.StoreUint32(&o.HEOUCTRL.Reg, volatile.LoadUint32(&o.HEOUCTRL.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOUCTRL_UDMAIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOUCTRL.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOUCTRL_UDSCRIEN(value uint32) {
	volatile.StoreUint32(&o.HEOUCTRL.Reg, volatile.LoadUint32(&o.HEOUCTRL.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOUCTRL_UDSCRIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOUCTRL.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOUCTRL_UADDIEN(value uint32) {
	volatile.StoreUint32(&o.HEOUCTRL.Reg, volatile.LoadUint32(&o.HEOUCTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOUCTRL_UADDIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOUCTRL.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOUCTRL_UDONEIEN(value uint32) {
	volatile.StoreUint32(&o.HEOUCTRL.Reg, volatile.LoadUint32(&o.HEOUCTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOUCTRL_UDONEIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOUCTRL.Reg) & 0x20) >> 5
}

// LCDC.HEOUNEXT: High-End Overlay U DMA Next Register
func (o *LCDC_Type) SetHEOUNEXT(value uint32) {
	volatile.StoreUint32(&o.HEOUNEXT.Reg, value)
}
func (o *LCDC_Type) GetHEOUNEXT() uint32 {
	return volatile.LoadUint32(&o.HEOUNEXT.Reg)
}

// LCDC.HEOVHEAD: High-End Overlay V DMA Head Register
func (o *LCDC_Type) SetHEOVHEAD(value uint32) {
	volatile.StoreUint32(&o.HEOVHEAD.Reg, value)
}
func (o *LCDC_Type) GetHEOVHEAD() uint32 {
	return volatile.LoadUint32(&o.HEOVHEAD.Reg)
}

// LCDC.HEOVADDR: High-End Overlay V DMA Address Register
func (o *LCDC_Type) SetHEOVADDR(value uint32) {
	volatile.StoreUint32(&o.HEOVADDR.Reg, value)
}
func (o *LCDC_Type) GetHEOVADDR() uint32 {
	return volatile.LoadUint32(&o.HEOVADDR.Reg)
}

// LCDC.HEOVCTRL: High-End Overlay V DMA control Register
func (o *LCDC_Type) SetHEOVCTRL_VDFETCH(value uint32) {
	volatile.StoreUint32(&o.HEOVCTRL.Reg, volatile.LoadUint32(&o.HEOVCTRL.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOVCTRL_VDFETCH() uint32 {
	return volatile.LoadUint32(&o.HEOVCTRL.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOVCTRL_VDMAIEN(value uint32) {
	volatile.StoreUint32(&o.HEOVCTRL.Reg, volatile.LoadUint32(&o.HEOVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOVCTRL_VDMAIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOVCTRL.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOVCTRL_VDSCRIEN(value uint32) {
	volatile.StoreUint32(&o.HEOVCTRL.Reg, volatile.LoadUint32(&o.HEOVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOVCTRL_VDSCRIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOVCTRL.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOVCTRL_VADDIEN(value uint32) {
	volatile.StoreUint32(&o.HEOVCTRL.Reg, volatile.LoadUint32(&o.HEOVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOVCTRL_VADDIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOVCTRL.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOVCTRL_VDONEIEN(value uint32) {
	volatile.StoreUint32(&o.HEOVCTRL.Reg, volatile.LoadUint32(&o.HEOVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOVCTRL_VDONEIEN() uint32 {
	return (volatile.LoadUint32(&o.HEOVCTRL.Reg) & 0x20) >> 5
}

// LCDC.HEOVNEXT: High-End Overlay VDMA Next Register
func (o *LCDC_Type) SetHEOVNEXT(value uint32) {
	volatile.StoreUint32(&o.HEOVNEXT.Reg, value)
}
func (o *LCDC_Type) GetHEOVNEXT() uint32 {
	return volatile.LoadUint32(&o.HEOVNEXT.Reg)
}

// LCDC.HEOCFG0: High-End Overlay Configuration Register 0
func (o *LCDC_Type) SetHEOCFG0_SIF(value uint32) {
	volatile.StoreUint32(&o.HEOCFG0.Reg, volatile.LoadUint32(&o.HEOCFG0.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOCFG0_SIF() uint32 {
	return volatile.LoadUint32(&o.HEOCFG0.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOCFG0_BLEN(value uint32) {
	volatile.StoreUint32(&o.HEOCFG0.Reg, volatile.LoadUint32(&o.HEOCFG0.Reg)&^(0x30)|value<<4)
}
func (o *LCDC_Type) GetHEOCFG0_BLEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG0.Reg) & 0x30) >> 4
}
func (o *LCDC_Type) SetHEOCFG0_BLENUV(value uint32) {
	volatile.StoreUint32(&o.HEOCFG0.Reg, volatile.LoadUint32(&o.HEOCFG0.Reg)&^(0xc0)|value<<6)
}
func (o *LCDC_Type) GetHEOCFG0_BLENUV() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG0.Reg) & 0xc0) >> 6
}
func (o *LCDC_Type) SetHEOCFG0_DLBO(value uint32) {
	volatile.StoreUint32(&o.HEOCFG0.Reg, volatile.LoadUint32(&o.HEOCFG0.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG0_DLBO() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG0.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetHEOCFG0_ROTDIS(value uint32) {
	volatile.StoreUint32(&o.HEOCFG0.Reg, volatile.LoadUint32(&o.HEOCFG0.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetHEOCFG0_ROTDIS() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG0.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetHEOCFG0_LOCKDIS(value uint32) {
	volatile.StoreUint32(&o.HEOCFG0.Reg, volatile.LoadUint32(&o.HEOCFG0.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetHEOCFG0_LOCKDIS() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG0.Reg) & 0x2000) >> 13
}

// LCDC.HEOCFG1: High-End Overlay Configuration Register 1
func (o *LCDC_Type) SetHEOCFG1_CLUTEN(value uint32) {
	volatile.StoreUint32(&o.HEOCFG1.Reg, volatile.LoadUint32(&o.HEOCFG1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOCFG1_CLUTEN() uint32 {
	return volatile.LoadUint32(&o.HEOCFG1.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOCFG1_YUVEN(value uint32) {
	volatile.StoreUint32(&o.HEOCFG1.Reg, volatile.LoadUint32(&o.HEOCFG1.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHEOCFG1_YUVEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG1.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHEOCFG1_RGBMODE(value uint32) {
	volatile.StoreUint32(&o.HEOCFG1.Reg, volatile.LoadUint32(&o.HEOCFG1.Reg)&^(0xf0)|value<<4)
}
func (o *LCDC_Type) GetHEOCFG1_RGBMODE() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG1.Reg) & 0xf0) >> 4
}
func (o *LCDC_Type) SetHEOCFG1_CLUTMODE(value uint32) {
	volatile.StoreUint32(&o.HEOCFG1.Reg, volatile.LoadUint32(&o.HEOCFG1.Reg)&^(0x300)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG1_CLUTMODE() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG1.Reg) & 0x300) >> 8
}
func (o *LCDC_Type) SetHEOCFG1_YUVMODE(value uint32) {
	volatile.StoreUint32(&o.HEOCFG1.Reg, volatile.LoadUint32(&o.HEOCFG1.Reg)&^(0xf000)|value<<12)
}
func (o *LCDC_Type) GetHEOCFG1_YUVMODE() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG1.Reg) & 0xf000) >> 12
}
func (o *LCDC_Type) SetHEOCFG1_YUV422ROT(value uint32) {
	volatile.StoreUint32(&o.HEOCFG1.Reg, volatile.LoadUint32(&o.HEOCFG1.Reg)&^(0x10000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG1_YUV422ROT() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG1.Reg) & 0x10000) >> 16
}
func (o *LCDC_Type) SetHEOCFG1_YUV422SWP(value uint32) {
	volatile.StoreUint32(&o.HEOCFG1.Reg, volatile.LoadUint32(&o.HEOCFG1.Reg)&^(0x20000)|value<<17)
}
func (o *LCDC_Type) GetHEOCFG1_YUV422SWP() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG1.Reg) & 0x20000) >> 17
}
func (o *LCDC_Type) SetHEOCFG1_DSCALEOPT(value uint32) {
	volatile.StoreUint32(&o.HEOCFG1.Reg, volatile.LoadUint32(&o.HEOCFG1.Reg)&^(0x100000)|value<<20)
}
func (o *LCDC_Type) GetHEOCFG1_DSCALEOPT() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG1.Reg) & 0x100000) >> 20
}

// LCDC.HEOCFG2: High-End Overlay Configuration Register 2
func (o *LCDC_Type) SetHEOCFG2_XPOS(value uint32) {
	volatile.StoreUint32(&o.HEOCFG2.Reg, volatile.LoadUint32(&o.HEOCFG2.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetHEOCFG2_XPOS() uint32 {
	return volatile.LoadUint32(&o.HEOCFG2.Reg) & 0x7ff
}
func (o *LCDC_Type) SetHEOCFG2_YPOS(value uint32) {
	volatile.StoreUint32(&o.HEOCFG2.Reg, volatile.LoadUint32(&o.HEOCFG2.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG2_YPOS() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG2.Reg) & 0x7ff0000) >> 16
}

// LCDC.HEOCFG3: High-End Overlay Configuration Register 3
func (o *LCDC_Type) SetHEOCFG3_XSIZE(value uint32) {
	volatile.StoreUint32(&o.HEOCFG3.Reg, volatile.LoadUint32(&o.HEOCFG3.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetHEOCFG3_XSIZE() uint32 {
	return volatile.LoadUint32(&o.HEOCFG3.Reg) & 0x7ff
}
func (o *LCDC_Type) SetHEOCFG3_YSIZE(value uint32) {
	volatile.StoreUint32(&o.HEOCFG3.Reg, volatile.LoadUint32(&o.HEOCFG3.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG3_YSIZE() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG3.Reg) & 0x7ff0000) >> 16
}

// LCDC.HEOCFG4: High-End Overlay Configuration Register 4
func (o *LCDC_Type) SetHEOCFG4_XMEMSIZE(value uint32) {
	volatile.StoreUint32(&o.HEOCFG4.Reg, volatile.LoadUint32(&o.HEOCFG4.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetHEOCFG4_XMEMSIZE() uint32 {
	return volatile.LoadUint32(&o.HEOCFG4.Reg) & 0x7ff
}
func (o *LCDC_Type) SetHEOCFG4_YMEMSIZE(value uint32) {
	volatile.StoreUint32(&o.HEOCFG4.Reg, volatile.LoadUint32(&o.HEOCFG4.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG4_YMEMSIZE() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG4.Reg) & 0x7ff0000) >> 16
}

// LCDC.HEOCFG5: High-End Overlay Configuration Register 5
func (o *LCDC_Type) SetHEOCFG5(value uint32) {
	volatile.StoreUint32(&o.HEOCFG5.Reg, value)
}
func (o *LCDC_Type) GetHEOCFG5() uint32 {
	return volatile.LoadUint32(&o.HEOCFG5.Reg)
}

// LCDC.HEOCFG6: High-End Overlay Configuration Register 6
func (o *LCDC_Type) SetHEOCFG6(value uint32) {
	volatile.StoreUint32(&o.HEOCFG6.Reg, value)
}
func (o *LCDC_Type) GetHEOCFG6() uint32 {
	return volatile.LoadUint32(&o.HEOCFG6.Reg)
}

// LCDC.HEOCFG7: High-End Overlay Configuration Register 7
func (o *LCDC_Type) SetHEOCFG7(value uint32) {
	volatile.StoreUint32(&o.HEOCFG7.Reg, value)
}
func (o *LCDC_Type) GetHEOCFG7() uint32 {
	return volatile.LoadUint32(&o.HEOCFG7.Reg)
}

// LCDC.HEOCFG8: High-End Overlay Configuration Register 8
func (o *LCDC_Type) SetHEOCFG8(value uint32) {
	volatile.StoreUint32(&o.HEOCFG8.Reg, value)
}
func (o *LCDC_Type) GetHEOCFG8() uint32 {
	return volatile.LoadUint32(&o.HEOCFG8.Reg)
}

// LCDC.HEOCFG9: High-End Overlay Configuration Register 9
func (o *LCDC_Type) SetHEOCFG9_BDEF(value uint32) {
	volatile.StoreUint32(&o.HEOCFG9.Reg, volatile.LoadUint32(&o.HEOCFG9.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG9_BDEF() uint32 {
	return volatile.LoadUint32(&o.HEOCFG9.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG9_GDEF(value uint32) {
	volatile.StoreUint32(&o.HEOCFG9.Reg, volatile.LoadUint32(&o.HEOCFG9.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG9_GDEF() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG9.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG9_RDEF(value uint32) {
	volatile.StoreUint32(&o.HEOCFG9.Reg, volatile.LoadUint32(&o.HEOCFG9.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG9_RDEF() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG9.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG10: High-End Overlay Configuration Register 10
func (o *LCDC_Type) SetHEOCFG10_BKEY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG10.Reg, volatile.LoadUint32(&o.HEOCFG10.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG10_BKEY() uint32 {
	return volatile.LoadUint32(&o.HEOCFG10.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG10_GKEY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG10.Reg, volatile.LoadUint32(&o.HEOCFG10.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG10_GKEY() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG10.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG10_RKEY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG10.Reg, volatile.LoadUint32(&o.HEOCFG10.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG10_RKEY() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG10.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG11: High-End Overlay Configuration Register 11
func (o *LCDC_Type) SetHEOCFG11_BMASK(value uint32) {
	volatile.StoreUint32(&o.HEOCFG11.Reg, volatile.LoadUint32(&o.HEOCFG11.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG11_BMASK() uint32 {
	return volatile.LoadUint32(&o.HEOCFG11.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG11_GMASK(value uint32) {
	volatile.StoreUint32(&o.HEOCFG11.Reg, volatile.LoadUint32(&o.HEOCFG11.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG11_GMASK() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG11.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG11_RMASK(value uint32) {
	volatile.StoreUint32(&o.HEOCFG11.Reg, volatile.LoadUint32(&o.HEOCFG11.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG11_RMASK() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG11.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG12: High-End Overlay Configuration Register 12
func (o *LCDC_Type) SetHEOCFG12_CRKEY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHEOCFG12_CRKEY() uint32 {
	return volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x1
}
func (o *LCDC_Type) SetHEOCFG12_INV(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHEOCFG12_INV() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHEOCFG12_ITER2BL(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHEOCFG12_ITER2BL() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHEOCFG12_ITER(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHEOCFG12_ITER() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHEOCFG12_REVALPHA(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHEOCFG12_REVALPHA() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHEOCFG12_GAEN(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHEOCFG12_GAEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHEOCFG12_LAEN(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHEOCFG12_LAEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetHEOCFG12_OVR(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x80)|value<<7)
}
func (o *LCDC_Type) GetHEOCFG12_OVR() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x80) >> 7
}
func (o *LCDC_Type) SetHEOCFG12_DMA(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG12_DMA() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetHEOCFG12_REP(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetHEOCFG12_REP() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetHEOCFG12_DSTKEY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetHEOCFG12_DSTKEY() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetHEOCFG12_VIDPRI(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetHEOCFG12_VIDPRI() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetHEOCFG12_GA(value uint32) {
	volatile.StoreUint32(&o.HEOCFG12.Reg, volatile.LoadUint32(&o.HEOCFG12.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG12_GA() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG12.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG13: High-End Overlay Configuration Register 13
func (o *LCDC_Type) SetHEOCFG13_XFACTOR(value uint32) {
	volatile.StoreUint32(&o.HEOCFG13.Reg, volatile.LoadUint32(&o.HEOCFG13.Reg)&^(0x3fff)|value)
}
func (o *LCDC_Type) GetHEOCFG13_XFACTOR() uint32 {
	return volatile.LoadUint32(&o.HEOCFG13.Reg) & 0x3fff
}
func (o *LCDC_Type) SetHEOCFG13_YFACTOR(value uint32) {
	volatile.StoreUint32(&o.HEOCFG13.Reg, volatile.LoadUint32(&o.HEOCFG13.Reg)&^(0x3fff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG13_YFACTOR() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG13.Reg) & 0x3fff0000) >> 16
}
func (o *LCDC_Type) SetHEOCFG13_SCALEN(value uint32) {
	volatile.StoreUint32(&o.HEOCFG13.Reg, volatile.LoadUint32(&o.HEOCFG13.Reg)&^(0x80000000)|value<<31)
}
func (o *LCDC_Type) GetHEOCFG13_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG13.Reg) & 0x80000000) >> 31
}

// LCDC.HEOCFG14: High-End Overlay Configuration Register 14
func (o *LCDC_Type) SetHEOCFG14_CSCRY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG14.Reg, volatile.LoadUint32(&o.HEOCFG14.Reg)&^(0x3ff)|value)
}
func (o *LCDC_Type) GetHEOCFG14_CSCRY() uint32 {
	return volatile.LoadUint32(&o.HEOCFG14.Reg) & 0x3ff
}
func (o *LCDC_Type) SetHEOCFG14_CSCRU(value uint32) {
	volatile.StoreUint32(&o.HEOCFG14.Reg, volatile.LoadUint32(&o.HEOCFG14.Reg)&^(0xffc00)|value<<10)
}
func (o *LCDC_Type) GetHEOCFG14_CSCRU() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG14.Reg) & 0xffc00) >> 10
}
func (o *LCDC_Type) SetHEOCFG14_CSCRV(value uint32) {
	volatile.StoreUint32(&o.HEOCFG14.Reg, volatile.LoadUint32(&o.HEOCFG14.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LCDC_Type) GetHEOCFG14_CSCRV() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG14.Reg) & 0x3ff00000) >> 20
}
func (o *LCDC_Type) SetHEOCFG14_CSCYOFF(value uint32) {
	volatile.StoreUint32(&o.HEOCFG14.Reg, volatile.LoadUint32(&o.HEOCFG14.Reg)&^(0x40000000)|value<<30)
}
func (o *LCDC_Type) GetHEOCFG14_CSCYOFF() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG14.Reg) & 0x40000000) >> 30
}

// LCDC.HEOCFG15: High-End Overlay Configuration Register 15
func (o *LCDC_Type) SetHEOCFG15_CSCGY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG15.Reg, volatile.LoadUint32(&o.HEOCFG15.Reg)&^(0x3ff)|value)
}
func (o *LCDC_Type) GetHEOCFG15_CSCGY() uint32 {
	return volatile.LoadUint32(&o.HEOCFG15.Reg) & 0x3ff
}
func (o *LCDC_Type) SetHEOCFG15_CSCGU(value uint32) {
	volatile.StoreUint32(&o.HEOCFG15.Reg, volatile.LoadUint32(&o.HEOCFG15.Reg)&^(0xffc00)|value<<10)
}
func (o *LCDC_Type) GetHEOCFG15_CSCGU() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG15.Reg) & 0xffc00) >> 10
}
func (o *LCDC_Type) SetHEOCFG15_CSCGV(value uint32) {
	volatile.StoreUint32(&o.HEOCFG15.Reg, volatile.LoadUint32(&o.HEOCFG15.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LCDC_Type) GetHEOCFG15_CSCGV() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG15.Reg) & 0x3ff00000) >> 20
}
func (o *LCDC_Type) SetHEOCFG15_CSCUOFF(value uint32) {
	volatile.StoreUint32(&o.HEOCFG15.Reg, volatile.LoadUint32(&o.HEOCFG15.Reg)&^(0x40000000)|value<<30)
}
func (o *LCDC_Type) GetHEOCFG15_CSCUOFF() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG15.Reg) & 0x40000000) >> 30
}

// LCDC.HEOCFG16: High-End Overlay Configuration Register 16
func (o *LCDC_Type) SetHEOCFG16_CSCBY(value uint32) {
	volatile.StoreUint32(&o.HEOCFG16.Reg, volatile.LoadUint32(&o.HEOCFG16.Reg)&^(0x3ff)|value)
}
func (o *LCDC_Type) GetHEOCFG16_CSCBY() uint32 {
	return volatile.LoadUint32(&o.HEOCFG16.Reg) & 0x3ff
}
func (o *LCDC_Type) SetHEOCFG16_CSCBU(value uint32) {
	volatile.StoreUint32(&o.HEOCFG16.Reg, volatile.LoadUint32(&o.HEOCFG16.Reg)&^(0xffc00)|value<<10)
}
func (o *LCDC_Type) GetHEOCFG16_CSCBU() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG16.Reg) & 0xffc00) >> 10
}
func (o *LCDC_Type) SetHEOCFG16_CSCBV(value uint32) {
	volatile.StoreUint32(&o.HEOCFG16.Reg, volatile.LoadUint32(&o.HEOCFG16.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LCDC_Type) GetHEOCFG16_CSCBV() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG16.Reg) & 0x3ff00000) >> 20
}
func (o *LCDC_Type) SetHEOCFG16_CSCVOFF(value uint32) {
	volatile.StoreUint32(&o.HEOCFG16.Reg, volatile.LoadUint32(&o.HEOCFG16.Reg)&^(0x40000000)|value<<30)
}
func (o *LCDC_Type) GetHEOCFG16_CSCVOFF() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG16.Reg) & 0x40000000) >> 30
}

// LCDC.HEOCFG17: High-End Overlay Configuration Register 17
func (o *LCDC_Type) SetHEOCFG17_XPHI0COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG17.Reg, volatile.LoadUint32(&o.HEOCFG17.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG17_XPHI0COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG17.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG17_XPHI0COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG17.Reg, volatile.LoadUint32(&o.HEOCFG17.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG17_XPHI0COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG17.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG17_XPHI0COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG17.Reg, volatile.LoadUint32(&o.HEOCFG17.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG17_XPHI0COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG17.Reg) & 0xff0000) >> 16
}
func (o *LCDC_Type) SetHEOCFG17_XPHI0COEFF3(value uint32) {
	volatile.StoreUint32(&o.HEOCFG17.Reg, volatile.LoadUint32(&o.HEOCFG17.Reg)&^(0xff000000)|value<<24)
}
func (o *LCDC_Type) GetHEOCFG17_XPHI0COEFF3() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG17.Reg) & 0xff000000) >> 24
}

// LCDC.HEOCFG18: High-End Overlay Configuration Register 18
func (o *LCDC_Type) SetHEOCFG18_XPHI0COEFF4(value uint32) {
	volatile.StoreUint32(&o.HEOCFG18.Reg, volatile.LoadUint32(&o.HEOCFG18.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG18_XPHI0COEFF4() uint32 {
	return volatile.LoadUint32(&o.HEOCFG18.Reg) & 0xff
}

// LCDC.HEOCFG19: High-End Overlay Configuration Register 19
func (o *LCDC_Type) SetHEOCFG19_XPHI1COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG19.Reg, volatile.LoadUint32(&o.HEOCFG19.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG19_XPHI1COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG19.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG19_XPHI1COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG19.Reg, volatile.LoadUint32(&o.HEOCFG19.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG19_XPHI1COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG19.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG19_XPHI1COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG19.Reg, volatile.LoadUint32(&o.HEOCFG19.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG19_XPHI1COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG19.Reg) & 0xff0000) >> 16
}
func (o *LCDC_Type) SetHEOCFG19_XPHI1COEFF3(value uint32) {
	volatile.StoreUint32(&o.HEOCFG19.Reg, volatile.LoadUint32(&o.HEOCFG19.Reg)&^(0xff000000)|value<<24)
}
func (o *LCDC_Type) GetHEOCFG19_XPHI1COEFF3() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG19.Reg) & 0xff000000) >> 24
}

// LCDC.HEOCFG20: High-End Overlay Configuration Register 20
func (o *LCDC_Type) SetHEOCFG20_XPHI1COEFF4(value uint32) {
	volatile.StoreUint32(&o.HEOCFG20.Reg, volatile.LoadUint32(&o.HEOCFG20.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG20_XPHI1COEFF4() uint32 {
	return volatile.LoadUint32(&o.HEOCFG20.Reg) & 0xff
}

// LCDC.HEOCFG21: High-End Overlay Configuration Register 21
func (o *LCDC_Type) SetHEOCFG21_XPHI2COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG21.Reg, volatile.LoadUint32(&o.HEOCFG21.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG21_XPHI2COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG21.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG21_XPHI2COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG21.Reg, volatile.LoadUint32(&o.HEOCFG21.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG21_XPHI2COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG21.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG21_XPHI2COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG21.Reg, volatile.LoadUint32(&o.HEOCFG21.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG21_XPHI2COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG21.Reg) & 0xff0000) >> 16
}
func (o *LCDC_Type) SetHEOCFG21_XPHI2COEFF3(value uint32) {
	volatile.StoreUint32(&o.HEOCFG21.Reg, volatile.LoadUint32(&o.HEOCFG21.Reg)&^(0xff000000)|value<<24)
}
func (o *LCDC_Type) GetHEOCFG21_XPHI2COEFF3() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG21.Reg) & 0xff000000) >> 24
}

// LCDC.HEOCFG22: High-End Overlay Configuration Register 22
func (o *LCDC_Type) SetHEOCFG22_XPHI2COEFF4(value uint32) {
	volatile.StoreUint32(&o.HEOCFG22.Reg, volatile.LoadUint32(&o.HEOCFG22.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG22_XPHI2COEFF4() uint32 {
	return volatile.LoadUint32(&o.HEOCFG22.Reg) & 0xff
}

// LCDC.HEOCFG23: High-End Overlay Configuration Register 23
func (o *LCDC_Type) SetHEOCFG23_XPHI3COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG23.Reg, volatile.LoadUint32(&o.HEOCFG23.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG23_XPHI3COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG23.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG23_XPHI3COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG23.Reg, volatile.LoadUint32(&o.HEOCFG23.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG23_XPHI3COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG23.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG23_XPHI3COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG23.Reg, volatile.LoadUint32(&o.HEOCFG23.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG23_XPHI3COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG23.Reg) & 0xff0000) >> 16
}
func (o *LCDC_Type) SetHEOCFG23_XPHI3COEFF3(value uint32) {
	volatile.StoreUint32(&o.HEOCFG23.Reg, volatile.LoadUint32(&o.HEOCFG23.Reg)&^(0xff000000)|value<<24)
}
func (o *LCDC_Type) GetHEOCFG23_XPHI3COEFF3() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG23.Reg) & 0xff000000) >> 24
}

// LCDC.HEOCFG24: High-End Overlay Configuration Register 24
func (o *LCDC_Type) SetHEOCFG24_XPHI3COEFF4(value uint32) {
	volatile.StoreUint32(&o.HEOCFG24.Reg, volatile.LoadUint32(&o.HEOCFG24.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG24_XPHI3COEFF4() uint32 {
	return volatile.LoadUint32(&o.HEOCFG24.Reg) & 0xff
}

// LCDC.HEOCFG25: High-End Overlay Configuration Register 25
func (o *LCDC_Type) SetHEOCFG25_XPHI4COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG25.Reg, volatile.LoadUint32(&o.HEOCFG25.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG25_XPHI4COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG25.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG25_XPHI4COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG25.Reg, volatile.LoadUint32(&o.HEOCFG25.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG25_XPHI4COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG25.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG25_XPHI4COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG25.Reg, volatile.LoadUint32(&o.HEOCFG25.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG25_XPHI4COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG25.Reg) & 0xff0000) >> 16
}
func (o *LCDC_Type) SetHEOCFG25_XPHI4COEFF3(value uint32) {
	volatile.StoreUint32(&o.HEOCFG25.Reg, volatile.LoadUint32(&o.HEOCFG25.Reg)&^(0xff000000)|value<<24)
}
func (o *LCDC_Type) GetHEOCFG25_XPHI4COEFF3() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG25.Reg) & 0xff000000) >> 24
}

// LCDC.HEOCFG26: High-End Overlay Configuration Register 26
func (o *LCDC_Type) SetHEOCFG26_XPHI4COEFF4(value uint32) {
	volatile.StoreUint32(&o.HEOCFG26.Reg, volatile.LoadUint32(&o.HEOCFG26.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG26_XPHI4COEFF4() uint32 {
	return volatile.LoadUint32(&o.HEOCFG26.Reg) & 0xff
}

// LCDC.HEOCFG27: High-End Overlay Configuration Register 27
func (o *LCDC_Type) SetHEOCFG27_XPHI5COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG27.Reg, volatile.LoadUint32(&o.HEOCFG27.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG27_XPHI5COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG27.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG27_XPHI5COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG27.Reg, volatile.LoadUint32(&o.HEOCFG27.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG27_XPHI5COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG27.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG27_XPHI5COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG27.Reg, volatile.LoadUint32(&o.HEOCFG27.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG27_XPHI5COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG27.Reg) & 0xff0000) >> 16
}
func (o *LCDC_Type) SetHEOCFG27_XPHI5COEFF3(value uint32) {
	volatile.StoreUint32(&o.HEOCFG27.Reg, volatile.LoadUint32(&o.HEOCFG27.Reg)&^(0xff000000)|value<<24)
}
func (o *LCDC_Type) GetHEOCFG27_XPHI5COEFF3() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG27.Reg) & 0xff000000) >> 24
}

// LCDC.HEOCFG28: High-End Overlay Configuration Register 28
func (o *LCDC_Type) SetHEOCFG28_XPHI5COEFF4(value uint32) {
	volatile.StoreUint32(&o.HEOCFG28.Reg, volatile.LoadUint32(&o.HEOCFG28.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG28_XPHI5COEFF4() uint32 {
	return volatile.LoadUint32(&o.HEOCFG28.Reg) & 0xff
}

// LCDC.HEOCFG29: High-End Overlay Configuration Register 29
func (o *LCDC_Type) SetHEOCFG29_XPHI6COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG29.Reg, volatile.LoadUint32(&o.HEOCFG29.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG29_XPHI6COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG29.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG29_XPHI6COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG29.Reg, volatile.LoadUint32(&o.HEOCFG29.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG29_XPHI6COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG29.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG29_XPHI6COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG29.Reg, volatile.LoadUint32(&o.HEOCFG29.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG29_XPHI6COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG29.Reg) & 0xff0000) >> 16
}
func (o *LCDC_Type) SetHEOCFG29_XPHI6COEFF3(value uint32) {
	volatile.StoreUint32(&o.HEOCFG29.Reg, volatile.LoadUint32(&o.HEOCFG29.Reg)&^(0xff000000)|value<<24)
}
func (o *LCDC_Type) GetHEOCFG29_XPHI6COEFF3() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG29.Reg) & 0xff000000) >> 24
}

// LCDC.HEOCFG30: High-End Overlay Configuration Register 30
func (o *LCDC_Type) SetHEOCFG30_XPHI6COEFF4(value uint32) {
	volatile.StoreUint32(&o.HEOCFG30.Reg, volatile.LoadUint32(&o.HEOCFG30.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG30_XPHI6COEFF4() uint32 {
	return volatile.LoadUint32(&o.HEOCFG30.Reg) & 0xff
}

// LCDC.HEOCFG31: High-End Overlay Configuration Register 31
func (o *LCDC_Type) SetHEOCFG31_XPHI7COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG31.Reg, volatile.LoadUint32(&o.HEOCFG31.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG31_XPHI7COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG31.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG31_XPHI7COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG31.Reg, volatile.LoadUint32(&o.HEOCFG31.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG31_XPHI7COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG31.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG31_XPHI7COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG31.Reg, volatile.LoadUint32(&o.HEOCFG31.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG31_XPHI7COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG31.Reg) & 0xff0000) >> 16
}
func (o *LCDC_Type) SetHEOCFG31_XPHI7COEFF3(value uint32) {
	volatile.StoreUint32(&o.HEOCFG31.Reg, volatile.LoadUint32(&o.HEOCFG31.Reg)&^(0xff000000)|value<<24)
}
func (o *LCDC_Type) GetHEOCFG31_XPHI7COEFF3() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG31.Reg) & 0xff000000) >> 24
}

// LCDC.HEOCFG32: High-End Overlay Configuration Register 32
func (o *LCDC_Type) SetHEOCFG32_XPHI7COEFF4(value uint32) {
	volatile.StoreUint32(&o.HEOCFG32.Reg, volatile.LoadUint32(&o.HEOCFG32.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG32_XPHI7COEFF4() uint32 {
	return volatile.LoadUint32(&o.HEOCFG32.Reg) & 0xff
}

// LCDC.HEOCFG33: High-End Overlay Configuration Register 33
func (o *LCDC_Type) SetHEOCFG33_YPHI0COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG33.Reg, volatile.LoadUint32(&o.HEOCFG33.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG33_YPHI0COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG33.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG33_YPHI0COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG33.Reg, volatile.LoadUint32(&o.HEOCFG33.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG33_YPHI0COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG33.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG33_YPHI0COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG33.Reg, volatile.LoadUint32(&o.HEOCFG33.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG33_YPHI0COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG33.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG34: High-End Overlay Configuration Register 34
func (o *LCDC_Type) SetHEOCFG34_YPHI1COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG34.Reg, volatile.LoadUint32(&o.HEOCFG34.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG34_YPHI1COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG34.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG34_YPHI1COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG34.Reg, volatile.LoadUint32(&o.HEOCFG34.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG34_YPHI1COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG34.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG34_YPHI1COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG34.Reg, volatile.LoadUint32(&o.HEOCFG34.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG34_YPHI1COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG34.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG35: High-End Overlay Configuration Register 35
func (o *LCDC_Type) SetHEOCFG35_YPHI2COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG35.Reg, volatile.LoadUint32(&o.HEOCFG35.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG35_YPHI2COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG35.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG35_YPHI2COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG35.Reg, volatile.LoadUint32(&o.HEOCFG35.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG35_YPHI2COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG35.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG35_YPHI2COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG35.Reg, volatile.LoadUint32(&o.HEOCFG35.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG35_YPHI2COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG35.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG36: High-End Overlay Configuration Register 36
func (o *LCDC_Type) SetHEOCFG36_YPHI3COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG36.Reg, volatile.LoadUint32(&o.HEOCFG36.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG36_YPHI3COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG36.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG36_YPHI3COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG36.Reg, volatile.LoadUint32(&o.HEOCFG36.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG36_YPHI3COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG36.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG36_YPHI3COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG36.Reg, volatile.LoadUint32(&o.HEOCFG36.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG36_YPHI3COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG36.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG37: High-End Overlay Configuration Register 37
func (o *LCDC_Type) SetHEOCFG37_YPHI4COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG37.Reg, volatile.LoadUint32(&o.HEOCFG37.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG37_YPHI4COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG37.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG37_YPHI4COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG37.Reg, volatile.LoadUint32(&o.HEOCFG37.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG37_YPHI4COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG37.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG37_YPHI4COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG37.Reg, volatile.LoadUint32(&o.HEOCFG37.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG37_YPHI4COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG37.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG38: High-End Overlay Configuration Register 38
func (o *LCDC_Type) SetHEOCFG38_YPHI5COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG38.Reg, volatile.LoadUint32(&o.HEOCFG38.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG38_YPHI5COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG38.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG38_YPHI5COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG38.Reg, volatile.LoadUint32(&o.HEOCFG38.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG38_YPHI5COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG38.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG38_YPHI5COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG38.Reg, volatile.LoadUint32(&o.HEOCFG38.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG38_YPHI5COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG38.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG39: High-End Overlay Configuration Register 39
func (o *LCDC_Type) SetHEOCFG39_YPHI6COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG39.Reg, volatile.LoadUint32(&o.HEOCFG39.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG39_YPHI6COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG39.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG39_YPHI6COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG39.Reg, volatile.LoadUint32(&o.HEOCFG39.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG39_YPHI6COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG39.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG39_YPHI6COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG39.Reg, volatile.LoadUint32(&o.HEOCFG39.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG39_YPHI6COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG39.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG40: High-End Overlay Configuration Register 40
func (o *LCDC_Type) SetHEOCFG40_YPHI7COEFF0(value uint32) {
	volatile.StoreUint32(&o.HEOCFG40.Reg, volatile.LoadUint32(&o.HEOCFG40.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCFG40_YPHI7COEFF0() uint32 {
	return volatile.LoadUint32(&o.HEOCFG40.Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCFG40_YPHI7COEFF1(value uint32) {
	volatile.StoreUint32(&o.HEOCFG40.Reg, volatile.LoadUint32(&o.HEOCFG40.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCFG40_YPHI7COEFF1() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG40.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCFG40_YPHI7COEFF2(value uint32) {
	volatile.StoreUint32(&o.HEOCFG40.Reg, volatile.LoadUint32(&o.HEOCFG40.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG40_YPHI7COEFF2() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG40.Reg) & 0xff0000) >> 16
}

// LCDC.HEOCFG41: High-End Overlay Configuration Register 41
func (o *LCDC_Type) SetHEOCFG41_XPHIDEF(value uint32) {
	volatile.StoreUint32(&o.HEOCFG41.Reg, volatile.LoadUint32(&o.HEOCFG41.Reg)&^(0x7)|value)
}
func (o *LCDC_Type) GetHEOCFG41_XPHIDEF() uint32 {
	return volatile.LoadUint32(&o.HEOCFG41.Reg) & 0x7
}
func (o *LCDC_Type) SetHEOCFG41_YPHIDEF(value uint32) {
	volatile.StoreUint32(&o.HEOCFG41.Reg, volatile.LoadUint32(&o.HEOCFG41.Reg)&^(0x70000)|value<<16)
}
func (o *LCDC_Type) GetHEOCFG41_YPHIDEF() uint32 {
	return (volatile.LoadUint32(&o.HEOCFG41.Reg) & 0x70000) >> 16
}

// LCDC.HCRCHER: Hardware Cursor Channel Enable Register
func (o *LCDC_Type) SetHCRCHER_CHEN(value uint32) {
	volatile.StoreUint32(&o.HCRCHER.Reg, volatile.LoadUint32(&o.HCRCHER.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHCRCHER_CHEN() uint32 {
	return volatile.LoadUint32(&o.HCRCHER.Reg) & 0x1
}
func (o *LCDC_Type) SetHCRCHER_UPDATEEN(value uint32) {
	volatile.StoreUint32(&o.HCRCHER.Reg, volatile.LoadUint32(&o.HCRCHER.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHCRCHER_UPDATEEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCHER.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHCRCHER_A2QEN(value uint32) {
	volatile.StoreUint32(&o.HCRCHER.Reg, volatile.LoadUint32(&o.HCRCHER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRCHER_A2QEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCHER.Reg) & 0x4) >> 2
}

// LCDC.HCRCHDR: Hardware Cursor Channel disable Register
func (o *LCDC_Type) SetHCRCHDR_CHDIS(value uint32) {
	volatile.StoreUint32(&o.HCRCHDR.Reg, volatile.LoadUint32(&o.HCRCHDR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHCRCHDR_CHDIS() uint32 {
	return volatile.LoadUint32(&o.HCRCHDR.Reg) & 0x1
}
func (o *LCDC_Type) SetHCRCHDR_CHRST(value uint32) {
	volatile.StoreUint32(&o.HCRCHDR.Reg, volatile.LoadUint32(&o.HCRCHDR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetHCRCHDR_CHRST() uint32 {
	return (volatile.LoadUint32(&o.HCRCHDR.Reg) & 0x100) >> 8
}

// LCDC.HCRCHSR: Hardware Cursor Channel Status Register
func (o *LCDC_Type) SetHCRCHSR_CHSR(value uint32) {
	volatile.StoreUint32(&o.HCRCHSR.Reg, volatile.LoadUint32(&o.HCRCHSR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHCRCHSR_CHSR() uint32 {
	return volatile.LoadUint32(&o.HCRCHSR.Reg) & 0x1
}
func (o *LCDC_Type) SetHCRCHSR_UPDATESR(value uint32) {
	volatile.StoreUint32(&o.HCRCHSR.Reg, volatile.LoadUint32(&o.HCRCHSR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHCRCHSR_UPDATESR() uint32 {
	return (volatile.LoadUint32(&o.HCRCHSR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHCRCHSR_A2QSR(value uint32) {
	volatile.StoreUint32(&o.HCRCHSR.Reg, volatile.LoadUint32(&o.HCRCHSR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRCHSR_A2QSR() uint32 {
	return (volatile.LoadUint32(&o.HCRCHSR.Reg) & 0x4) >> 2
}

// LCDC.HCRIER: Hardware Cursor Interrupt Enable Register
func (o *LCDC_Type) SetHCRIER_DMA(value uint32) {
	volatile.StoreUint32(&o.HCRIER.Reg, volatile.LoadUint32(&o.HCRIER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRIER_DMA() uint32 {
	return (volatile.LoadUint32(&o.HCRIER.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHCRIER_DSCR(value uint32) {
	volatile.StoreUint32(&o.HCRIER.Reg, volatile.LoadUint32(&o.HCRIER.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHCRIER_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HCRIER.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHCRIER_ADD(value uint32) {
	volatile.StoreUint32(&o.HCRIER.Reg, volatile.LoadUint32(&o.HCRIER.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHCRIER_ADD() uint32 {
	return (volatile.LoadUint32(&o.HCRIER.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHCRIER_DONE(value uint32) {
	volatile.StoreUint32(&o.HCRIER.Reg, volatile.LoadUint32(&o.HCRIER.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHCRIER_DONE() uint32 {
	return (volatile.LoadUint32(&o.HCRIER.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHCRIER_OVR(value uint32) {
	volatile.StoreUint32(&o.HCRIER.Reg, volatile.LoadUint32(&o.HCRIER.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHCRIER_OVR() uint32 {
	return (volatile.LoadUint32(&o.HCRIER.Reg) & 0x40) >> 6
}

// LCDC.HCRIDR: Hardware Cursor Interrupt Disable Register
func (o *LCDC_Type) SetHCRIDR_DMA(value uint32) {
	volatile.StoreUint32(&o.HCRIDR.Reg, volatile.LoadUint32(&o.HCRIDR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRIDR_DMA() uint32 {
	return (volatile.LoadUint32(&o.HCRIDR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHCRIDR_DSCR(value uint32) {
	volatile.StoreUint32(&o.HCRIDR.Reg, volatile.LoadUint32(&o.HCRIDR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHCRIDR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HCRIDR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHCRIDR_ADD(value uint32) {
	volatile.StoreUint32(&o.HCRIDR.Reg, volatile.LoadUint32(&o.HCRIDR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHCRIDR_ADD() uint32 {
	return (volatile.LoadUint32(&o.HCRIDR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHCRIDR_DONE(value uint32) {
	volatile.StoreUint32(&o.HCRIDR.Reg, volatile.LoadUint32(&o.HCRIDR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHCRIDR_DONE() uint32 {
	return (volatile.LoadUint32(&o.HCRIDR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHCRIDR_OVR(value uint32) {
	volatile.StoreUint32(&o.HCRIDR.Reg, volatile.LoadUint32(&o.HCRIDR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHCRIDR_OVR() uint32 {
	return (volatile.LoadUint32(&o.HCRIDR.Reg) & 0x40) >> 6
}

// LCDC.HCRIMR: Hardware Cursor Interrupt Mask Register
func (o *LCDC_Type) SetHCRIMR_DMA(value uint32) {
	volatile.StoreUint32(&o.HCRIMR.Reg, volatile.LoadUint32(&o.HCRIMR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRIMR_DMA() uint32 {
	return (volatile.LoadUint32(&o.HCRIMR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHCRIMR_DSCR(value uint32) {
	volatile.StoreUint32(&o.HCRIMR.Reg, volatile.LoadUint32(&o.HCRIMR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHCRIMR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HCRIMR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHCRIMR_ADD(value uint32) {
	volatile.StoreUint32(&o.HCRIMR.Reg, volatile.LoadUint32(&o.HCRIMR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHCRIMR_ADD() uint32 {
	return (volatile.LoadUint32(&o.HCRIMR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHCRIMR_DONE(value uint32) {
	volatile.StoreUint32(&o.HCRIMR.Reg, volatile.LoadUint32(&o.HCRIMR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHCRIMR_DONE() uint32 {
	return (volatile.LoadUint32(&o.HCRIMR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHCRIMR_OVR(value uint32) {
	volatile.StoreUint32(&o.HCRIMR.Reg, volatile.LoadUint32(&o.HCRIMR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHCRIMR_OVR() uint32 {
	return (volatile.LoadUint32(&o.HCRIMR.Reg) & 0x40) >> 6
}

// LCDC.HCRISR: Hardware Cursor Interrupt Status Register
func (o *LCDC_Type) SetHCRISR_DMA(value uint32) {
	volatile.StoreUint32(&o.HCRISR.Reg, volatile.LoadUint32(&o.HCRISR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRISR_DMA() uint32 {
	return (volatile.LoadUint32(&o.HCRISR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHCRISR_DSCR(value uint32) {
	volatile.StoreUint32(&o.HCRISR.Reg, volatile.LoadUint32(&o.HCRISR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHCRISR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.HCRISR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHCRISR_ADD(value uint32) {
	volatile.StoreUint32(&o.HCRISR.Reg, volatile.LoadUint32(&o.HCRISR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHCRISR_ADD() uint32 {
	return (volatile.LoadUint32(&o.HCRISR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHCRISR_DONE(value uint32) {
	volatile.StoreUint32(&o.HCRISR.Reg, volatile.LoadUint32(&o.HCRISR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHCRISR_DONE() uint32 {
	return (volatile.LoadUint32(&o.HCRISR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHCRISR_OVR(value uint32) {
	volatile.StoreUint32(&o.HCRISR.Reg, volatile.LoadUint32(&o.HCRISR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHCRISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.HCRISR.Reg) & 0x40) >> 6
}

// LCDC.HCRHEAD: Hardware Cursor DMA Head Register
func (o *LCDC_Type) SetHCRHEAD_HEAD(value uint32) {
	volatile.StoreUint32(&o.HCRHEAD.Reg, volatile.LoadUint32(&o.HCRHEAD.Reg)&^(0xfffffffc)|value<<2)
}
func (o *LCDC_Type) GetHCRHEAD_HEAD() uint32 {
	return (volatile.LoadUint32(&o.HCRHEAD.Reg) & 0xfffffffc) >> 2
}

// LCDC.HCRADDR: Hardware cursor DMA Address Register
func (o *LCDC_Type) SetHCRADDR(value uint32) {
	volatile.StoreUint32(&o.HCRADDR.Reg, value)
}
func (o *LCDC_Type) GetHCRADDR() uint32 {
	return volatile.LoadUint32(&o.HCRADDR.Reg)
}

// LCDC.HCRCTRL: Hardware Cursor DMA Control Register
func (o *LCDC_Type) SetHCRCTRL_DFETCH(value uint32) {
	volatile.StoreUint32(&o.HCRCTRL.Reg, volatile.LoadUint32(&o.HCRCTRL.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHCRCTRL_DFETCH() uint32 {
	return volatile.LoadUint32(&o.HCRCTRL.Reg) & 0x1
}
func (o *LCDC_Type) SetHCRCTRL_LFETCH(value uint32) {
	volatile.StoreUint32(&o.HCRCTRL.Reg, volatile.LoadUint32(&o.HCRCTRL.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHCRCTRL_LFETCH() uint32 {
	return (volatile.LoadUint32(&o.HCRCTRL.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHCRCTRL_DMAIEN(value uint32) {
	volatile.StoreUint32(&o.HCRCTRL.Reg, volatile.LoadUint32(&o.HCRCTRL.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRCTRL_DMAIEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCTRL.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHCRCTRL_DSCRIEN(value uint32) {
	volatile.StoreUint32(&o.HCRCTRL.Reg, volatile.LoadUint32(&o.HCRCTRL.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHCRCTRL_DSCRIEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCTRL.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHCRCTRL_ADDIEN(value uint32) {
	volatile.StoreUint32(&o.HCRCTRL.Reg, volatile.LoadUint32(&o.HCRCTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHCRCTRL_ADDIEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCTRL.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHCRCTRL_DONEIEN(value uint32) {
	volatile.StoreUint32(&o.HCRCTRL.Reg, volatile.LoadUint32(&o.HCRCTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHCRCTRL_DONEIEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCTRL.Reg) & 0x20) >> 5
}

// LCDC.HCRNEXT: Hardware Cursor DMA NExt Register
func (o *LCDC_Type) SetHCRNEXT(value uint32) {
	volatile.StoreUint32(&o.HCRNEXT.Reg, value)
}
func (o *LCDC_Type) GetHCRNEXT() uint32 {
	return volatile.LoadUint32(&o.HCRNEXT.Reg)
}

// LCDC.HCRCFG0: Hardware Cursor Configuration 0 Register
func (o *LCDC_Type) SetHCRCFG0_SIF(value uint32) {
	volatile.StoreUint32(&o.HCRCFG0.Reg, volatile.LoadUint32(&o.HCRCFG0.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHCRCFG0_SIF() uint32 {
	return volatile.LoadUint32(&o.HCRCFG0.Reg) & 0x1
}
func (o *LCDC_Type) SetHCRCFG0_BLEN(value uint32) {
	volatile.StoreUint32(&o.HCRCFG0.Reg, volatile.LoadUint32(&o.HCRCFG0.Reg)&^(0x30)|value<<4)
}
func (o *LCDC_Type) GetHCRCFG0_BLEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG0.Reg) & 0x30) >> 4
}
func (o *LCDC_Type) SetHCRCFG0_DLBO(value uint32) {
	volatile.StoreUint32(&o.HCRCFG0.Reg, volatile.LoadUint32(&o.HCRCFG0.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetHCRCFG0_DLBO() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG0.Reg) & 0x100) >> 8
}

// LCDC.HCRCFG1: Hardware Cursor Configuration 1 Register
func (o *LCDC_Type) SetHCRCFG1_CLUTEN(value uint32) {
	volatile.StoreUint32(&o.HCRCFG1.Reg, volatile.LoadUint32(&o.HCRCFG1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHCRCFG1_CLUTEN() uint32 {
	return volatile.LoadUint32(&o.HCRCFG1.Reg) & 0x1
}
func (o *LCDC_Type) SetHCRCFG1_RGBMODE(value uint32) {
	volatile.StoreUint32(&o.HCRCFG1.Reg, volatile.LoadUint32(&o.HCRCFG1.Reg)&^(0xf0)|value<<4)
}
func (o *LCDC_Type) GetHCRCFG1_RGBMODE() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG1.Reg) & 0xf0) >> 4
}
func (o *LCDC_Type) SetHCRCFG1_CLUTMODE(value uint32) {
	volatile.StoreUint32(&o.HCRCFG1.Reg, volatile.LoadUint32(&o.HCRCFG1.Reg)&^(0x300)|value<<8)
}
func (o *LCDC_Type) GetHCRCFG1_CLUTMODE() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG1.Reg) & 0x300) >> 8
}

// LCDC.HCRCFG2: Hardware Cursor Configuration 2 Register
func (o *LCDC_Type) SetHCRCFG2_XPOS(value uint32) {
	volatile.StoreUint32(&o.HCRCFG2.Reg, volatile.LoadUint32(&o.HCRCFG2.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetHCRCFG2_XPOS() uint32 {
	return volatile.LoadUint32(&o.HCRCFG2.Reg) & 0x7ff
}
func (o *LCDC_Type) SetHCRCFG2_YPOS(value uint32) {
	volatile.StoreUint32(&o.HCRCFG2.Reg, volatile.LoadUint32(&o.HCRCFG2.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetHCRCFG2_YPOS() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG2.Reg) & 0x7ff0000) >> 16
}

// LCDC.HCRCFG3: Hardware Cursor Configuration 3 Register
func (o *LCDC_Type) SetHCRCFG3_XSIZE(value uint32) {
	volatile.StoreUint32(&o.HCRCFG3.Reg, volatile.LoadUint32(&o.HCRCFG3.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetHCRCFG3_XSIZE() uint32 {
	return volatile.LoadUint32(&o.HCRCFG3.Reg) & 0x7ff
}
func (o *LCDC_Type) SetHCRCFG3_YSIZE(value uint32) {
	volatile.StoreUint32(&o.HCRCFG3.Reg, volatile.LoadUint32(&o.HCRCFG3.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetHCRCFG3_YSIZE() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG3.Reg) & 0x7ff0000) >> 16
}

// LCDC.HCRCFG4: Hardware Cursor Configuration 4 Register
func (o *LCDC_Type) SetHCRCFG4(value uint32) {
	volatile.StoreUint32(&o.HCRCFG4.Reg, value)
}
func (o *LCDC_Type) GetHCRCFG4() uint32 {
	return volatile.LoadUint32(&o.HCRCFG4.Reg)
}

// LCDC.HCRCFG6: Hardware Cursor Configuration 6 Register
func (o *LCDC_Type) SetHCRCFG6_BDEF(value uint32) {
	volatile.StoreUint32(&o.HCRCFG6.Reg, volatile.LoadUint32(&o.HCRCFG6.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHCRCFG6_BDEF() uint32 {
	return volatile.LoadUint32(&o.HCRCFG6.Reg) & 0xff
}
func (o *LCDC_Type) SetHCRCFG6_GDEF(value uint32) {
	volatile.StoreUint32(&o.HCRCFG6.Reg, volatile.LoadUint32(&o.HCRCFG6.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHCRCFG6_GDEF() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG6.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHCRCFG6_RDEF(value uint32) {
	volatile.StoreUint32(&o.HCRCFG6.Reg, volatile.LoadUint32(&o.HCRCFG6.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHCRCFG6_RDEF() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG6.Reg) & 0xff0000) >> 16
}

// LCDC.HCRCFG7: Hardware Cursor Configuration 7 Register
func (o *LCDC_Type) SetHCRCFG7_BKEY(value uint32) {
	volatile.StoreUint32(&o.HCRCFG7.Reg, volatile.LoadUint32(&o.HCRCFG7.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHCRCFG7_BKEY() uint32 {
	return volatile.LoadUint32(&o.HCRCFG7.Reg) & 0xff
}
func (o *LCDC_Type) SetHCRCFG7_GKEY(value uint32) {
	volatile.StoreUint32(&o.HCRCFG7.Reg, volatile.LoadUint32(&o.HCRCFG7.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHCRCFG7_GKEY() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG7.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHCRCFG7_RKEY(value uint32) {
	volatile.StoreUint32(&o.HCRCFG7.Reg, volatile.LoadUint32(&o.HCRCFG7.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHCRCFG7_RKEY() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG7.Reg) & 0xff0000) >> 16
}

// LCDC.HCRCFG8: Hardware Cursor Configuration 8 Register
func (o *LCDC_Type) SetHCRCFG8_BMASK(value uint32) {
	volatile.StoreUint32(&o.HCRCFG8.Reg, volatile.LoadUint32(&o.HCRCFG8.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHCRCFG8_BMASK() uint32 {
	return volatile.LoadUint32(&o.HCRCFG8.Reg) & 0xff
}
func (o *LCDC_Type) SetHCRCFG8_GMASK(value uint32) {
	volatile.StoreUint32(&o.HCRCFG8.Reg, volatile.LoadUint32(&o.HCRCFG8.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHCRCFG8_GMASK() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG8.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHCRCFG8_RMASK(value uint32) {
	volatile.StoreUint32(&o.HCRCFG8.Reg, volatile.LoadUint32(&o.HCRCFG8.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHCRCFG8_RMASK() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG8.Reg) & 0xff0000) >> 16
}

// LCDC.HCRCFG9: Hardware Cursor Configuration 9 Register
func (o *LCDC_Type) SetHCRCFG9_CRKEY(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetHCRCFG9_CRKEY() uint32 {
	return volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x1
}
func (o *LCDC_Type) SetHCRCFG9_INV(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetHCRCFG9_INV() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetHCRCFG9_ITER2BL(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetHCRCFG9_ITER2BL() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetHCRCFG9_ITER(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetHCRCFG9_ITER() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetHCRCFG9_REVALPHA(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetHCRCFG9_REVALPHA() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetHCRCFG9_GAEN(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetHCRCFG9_GAEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetHCRCFG9_LAEN(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetHCRCFG9_LAEN() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetHCRCFG9_OVR(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x80)|value<<7)
}
func (o *LCDC_Type) GetHCRCFG9_OVR() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x80) >> 7
}
func (o *LCDC_Type) SetHCRCFG9_DMA(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetHCRCFG9_DMA() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetHCRCFG9_REP(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetHCRCFG9_REP() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetHCRCFG9_DSTKEY(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetHCRCFG9_DSTKEY() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetHCRCFG9_GA(value uint32) {
	volatile.StoreUint32(&o.HCRCFG9.Reg, volatile.LoadUint32(&o.HCRCFG9.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHCRCFG9_GA() uint32 {
	return (volatile.LoadUint32(&o.HCRCFG9.Reg) & 0xff0000) >> 16
}

// LCDC.PPCHER: Post Processing Channel Enable Register
func (o *LCDC_Type) SetPPCHER_CHEN(value uint32) {
	volatile.StoreUint32(&o.PPCHER.Reg, volatile.LoadUint32(&o.PPCHER.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetPPCHER_CHEN() uint32 {
	return volatile.LoadUint32(&o.PPCHER.Reg) & 0x1
}
func (o *LCDC_Type) SetPPCHER_UPDATEEN(value uint32) {
	volatile.StoreUint32(&o.PPCHER.Reg, volatile.LoadUint32(&o.PPCHER.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetPPCHER_UPDATEEN() uint32 {
	return (volatile.LoadUint32(&o.PPCHER.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetPPCHER_A2QEN(value uint32) {
	volatile.StoreUint32(&o.PPCHER.Reg, volatile.LoadUint32(&o.PPCHER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetPPCHER_A2QEN() uint32 {
	return (volatile.LoadUint32(&o.PPCHER.Reg) & 0x4) >> 2
}

// LCDC.PPCHDR: Post Processing Channel Disable Register
func (o *LCDC_Type) SetPPCHDR_CHDIS(value uint32) {
	volatile.StoreUint32(&o.PPCHDR.Reg, volatile.LoadUint32(&o.PPCHDR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetPPCHDR_CHDIS() uint32 {
	return volatile.LoadUint32(&o.PPCHDR.Reg) & 0x1
}
func (o *LCDC_Type) SetPPCHDR_CHRST(value uint32) {
	volatile.StoreUint32(&o.PPCHDR.Reg, volatile.LoadUint32(&o.PPCHDR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetPPCHDR_CHRST() uint32 {
	return (volatile.LoadUint32(&o.PPCHDR.Reg) & 0x100) >> 8
}

// LCDC.PPCHSR: Post Processing Channel Status Register
func (o *LCDC_Type) SetPPCHSR_CHSR(value uint32) {
	volatile.StoreUint32(&o.PPCHSR.Reg, volatile.LoadUint32(&o.PPCHSR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetPPCHSR_CHSR() uint32 {
	return volatile.LoadUint32(&o.PPCHSR.Reg) & 0x1
}
func (o *LCDC_Type) SetPPCHSR_UPDATESR(value uint32) {
	volatile.StoreUint32(&o.PPCHSR.Reg, volatile.LoadUint32(&o.PPCHSR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetPPCHSR_UPDATESR() uint32 {
	return (volatile.LoadUint32(&o.PPCHSR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetPPCHSR_A2QSR(value uint32) {
	volatile.StoreUint32(&o.PPCHSR.Reg, volatile.LoadUint32(&o.PPCHSR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetPPCHSR_A2QSR() uint32 {
	return (volatile.LoadUint32(&o.PPCHSR.Reg) & 0x4) >> 2
}

// LCDC.PPIER: Post Processing Interrupt Enable Register
func (o *LCDC_Type) SetPPIER_DMA(value uint32) {
	volatile.StoreUint32(&o.PPIER.Reg, volatile.LoadUint32(&o.PPIER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetPPIER_DMA() uint32 {
	return (volatile.LoadUint32(&o.PPIER.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetPPIER_DSCR(value uint32) {
	volatile.StoreUint32(&o.PPIER.Reg, volatile.LoadUint32(&o.PPIER.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetPPIER_DSCR() uint32 {
	return (volatile.LoadUint32(&o.PPIER.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetPPIER_ADD(value uint32) {
	volatile.StoreUint32(&o.PPIER.Reg, volatile.LoadUint32(&o.PPIER.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetPPIER_ADD() uint32 {
	return (volatile.LoadUint32(&o.PPIER.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetPPIER_DONE(value uint32) {
	volatile.StoreUint32(&o.PPIER.Reg, volatile.LoadUint32(&o.PPIER.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetPPIER_DONE() uint32 {
	return (volatile.LoadUint32(&o.PPIER.Reg) & 0x20) >> 5
}

// LCDC.PPIDR: Post Processing Interrupt Disable Register
func (o *LCDC_Type) SetPPIDR_DMA(value uint32) {
	volatile.StoreUint32(&o.PPIDR.Reg, volatile.LoadUint32(&o.PPIDR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetPPIDR_DMA() uint32 {
	return (volatile.LoadUint32(&o.PPIDR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetPPIDR_DSCR(value uint32) {
	volatile.StoreUint32(&o.PPIDR.Reg, volatile.LoadUint32(&o.PPIDR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetPPIDR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.PPIDR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetPPIDR_ADD(value uint32) {
	volatile.StoreUint32(&o.PPIDR.Reg, volatile.LoadUint32(&o.PPIDR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetPPIDR_ADD() uint32 {
	return (volatile.LoadUint32(&o.PPIDR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetPPIDR_DONE(value uint32) {
	volatile.StoreUint32(&o.PPIDR.Reg, volatile.LoadUint32(&o.PPIDR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetPPIDR_DONE() uint32 {
	return (volatile.LoadUint32(&o.PPIDR.Reg) & 0x20) >> 5
}

// LCDC.PPIMR: Post Processing Interrupt Mask Register
func (o *LCDC_Type) SetPPIMR_DMA(value uint32) {
	volatile.StoreUint32(&o.PPIMR.Reg, volatile.LoadUint32(&o.PPIMR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetPPIMR_DMA() uint32 {
	return (volatile.LoadUint32(&o.PPIMR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetPPIMR_DSCR(value uint32) {
	volatile.StoreUint32(&o.PPIMR.Reg, volatile.LoadUint32(&o.PPIMR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetPPIMR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.PPIMR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetPPIMR_ADD(value uint32) {
	volatile.StoreUint32(&o.PPIMR.Reg, volatile.LoadUint32(&o.PPIMR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetPPIMR_ADD() uint32 {
	return (volatile.LoadUint32(&o.PPIMR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetPPIMR_DONE(value uint32) {
	volatile.StoreUint32(&o.PPIMR.Reg, volatile.LoadUint32(&o.PPIMR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetPPIMR_DONE() uint32 {
	return (volatile.LoadUint32(&o.PPIMR.Reg) & 0x20) >> 5
}

// LCDC.PPISR: Post Processing Interrupt Status Register
func (o *LCDC_Type) SetPPISR_DMA(value uint32) {
	volatile.StoreUint32(&o.PPISR.Reg, volatile.LoadUint32(&o.PPISR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetPPISR_DMA() uint32 {
	return (volatile.LoadUint32(&o.PPISR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetPPISR_DSCR(value uint32) {
	volatile.StoreUint32(&o.PPISR.Reg, volatile.LoadUint32(&o.PPISR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetPPISR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.PPISR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetPPISR_ADD(value uint32) {
	volatile.StoreUint32(&o.PPISR.Reg, volatile.LoadUint32(&o.PPISR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetPPISR_ADD() uint32 {
	return (volatile.LoadUint32(&o.PPISR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetPPISR_DONE(value uint32) {
	volatile.StoreUint32(&o.PPISR.Reg, volatile.LoadUint32(&o.PPISR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetPPISR_DONE() uint32 {
	return (volatile.LoadUint32(&o.PPISR.Reg) & 0x20) >> 5
}

// LCDC.PPHEAD: Post Processing Head Register
func (o *LCDC_Type) SetPPHEAD_HEAD(value uint32) {
	volatile.StoreUint32(&o.PPHEAD.Reg, volatile.LoadUint32(&o.PPHEAD.Reg)&^(0xfffffffc)|value<<2)
}
func (o *LCDC_Type) GetPPHEAD_HEAD() uint32 {
	return (volatile.LoadUint32(&o.PPHEAD.Reg) & 0xfffffffc) >> 2
}

// LCDC.PPADDR: Post Processing Address Register
func (o *LCDC_Type) SetPPADDR(value uint32) {
	volatile.StoreUint32(&o.PPADDR.Reg, value)
}
func (o *LCDC_Type) GetPPADDR() uint32 {
	return volatile.LoadUint32(&o.PPADDR.Reg)
}

// LCDC.PPCTRL: Post Processing Control Register
func (o *LCDC_Type) SetPPCTRL_DFETCH(value uint32) {
	volatile.StoreUint32(&o.PPCTRL.Reg, volatile.LoadUint32(&o.PPCTRL.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetPPCTRL_DFETCH() uint32 {
	return volatile.LoadUint32(&o.PPCTRL.Reg) & 0x1
}
func (o *LCDC_Type) SetPPCTRL_DMAIEN(value uint32) {
	volatile.StoreUint32(&o.PPCTRL.Reg, volatile.LoadUint32(&o.PPCTRL.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetPPCTRL_DMAIEN() uint32 {
	return (volatile.LoadUint32(&o.PPCTRL.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetPPCTRL_DSCRIEN(value uint32) {
	volatile.StoreUint32(&o.PPCTRL.Reg, volatile.LoadUint32(&o.PPCTRL.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetPPCTRL_DSCRIEN() uint32 {
	return (volatile.LoadUint32(&o.PPCTRL.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetPPCTRL_ADDIEN(value uint32) {
	volatile.StoreUint32(&o.PPCTRL.Reg, volatile.LoadUint32(&o.PPCTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetPPCTRL_ADDIEN() uint32 {
	return (volatile.LoadUint32(&o.PPCTRL.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetPPCTRL_DONEIEN(value uint32) {
	volatile.StoreUint32(&o.PPCTRL.Reg, volatile.LoadUint32(&o.PPCTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetPPCTRL_DONEIEN() uint32 {
	return (volatile.LoadUint32(&o.PPCTRL.Reg) & 0x20) >> 5
}

// LCDC.PPNEXT: Post Processing Next Register
func (o *LCDC_Type) SetPPNEXT(value uint32) {
	volatile.StoreUint32(&o.PPNEXT.Reg, value)
}
func (o *LCDC_Type) GetPPNEXT() uint32 {
	return volatile.LoadUint32(&o.PPNEXT.Reg)
}

// LCDC.PPCFG0: Post Processing Configuration Register 0
func (o *LCDC_Type) SetPPCFG0_SIF(value uint32) {
	volatile.StoreUint32(&o.PPCFG0.Reg, volatile.LoadUint32(&o.PPCFG0.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetPPCFG0_SIF() uint32 {
	return volatile.LoadUint32(&o.PPCFG0.Reg) & 0x1
}
func (o *LCDC_Type) SetPPCFG0_BLEN(value uint32) {
	volatile.StoreUint32(&o.PPCFG0.Reg, volatile.LoadUint32(&o.PPCFG0.Reg)&^(0x30)|value<<4)
}
func (o *LCDC_Type) GetPPCFG0_BLEN() uint32 {
	return (volatile.LoadUint32(&o.PPCFG0.Reg) & 0x30) >> 4
}
func (o *LCDC_Type) SetPPCFG0_DLBO(value uint32) {
	volatile.StoreUint32(&o.PPCFG0.Reg, volatile.LoadUint32(&o.PPCFG0.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetPPCFG0_DLBO() uint32 {
	return (volatile.LoadUint32(&o.PPCFG0.Reg) & 0x100) >> 8
}

// LCDC.PPCFG1: Post Processing Configuration Register 1
func (o *LCDC_Type) SetPPCFG1_PPMODE(value uint32) {
	volatile.StoreUint32(&o.PPCFG1.Reg, volatile.LoadUint32(&o.PPCFG1.Reg)&^(0x7)|value)
}
func (o *LCDC_Type) GetPPCFG1_PPMODE() uint32 {
	return volatile.LoadUint32(&o.PPCFG1.Reg) & 0x7
}
func (o *LCDC_Type) SetPPCFG1_ITUBT601(value uint32) {
	volatile.StoreUint32(&o.PPCFG1.Reg, volatile.LoadUint32(&o.PPCFG1.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetPPCFG1_ITUBT601() uint32 {
	return (volatile.LoadUint32(&o.PPCFG1.Reg) & 0x10) >> 4
}

// LCDC.PPCFG2: Post Processing Configuration Register 2
func (o *LCDC_Type) SetPPCFG2(value uint32) {
	volatile.StoreUint32(&o.PPCFG2.Reg, value)
}
func (o *LCDC_Type) GetPPCFG2() uint32 {
	return volatile.LoadUint32(&o.PPCFG2.Reg)
}

// LCDC.PPCFG3: Post Processing Configuration Register 3
func (o *LCDC_Type) SetPPCFG3_CSCYR(value uint32) {
	volatile.StoreUint32(&o.PPCFG3.Reg, volatile.LoadUint32(&o.PPCFG3.Reg)&^(0x3ff)|value)
}
func (o *LCDC_Type) GetPPCFG3_CSCYR() uint32 {
	return volatile.LoadUint32(&o.PPCFG3.Reg) & 0x3ff
}
func (o *LCDC_Type) SetPPCFG3_CSCYG(value uint32) {
	volatile.StoreUint32(&o.PPCFG3.Reg, volatile.LoadUint32(&o.PPCFG3.Reg)&^(0xffc00)|value<<10)
}
func (o *LCDC_Type) GetPPCFG3_CSCYG() uint32 {
	return (volatile.LoadUint32(&o.PPCFG3.Reg) & 0xffc00) >> 10
}
func (o *LCDC_Type) SetPPCFG3_CSCYB(value uint32) {
	volatile.StoreUint32(&o.PPCFG3.Reg, volatile.LoadUint32(&o.PPCFG3.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LCDC_Type) GetPPCFG3_CSCYB() uint32 {
	return (volatile.LoadUint32(&o.PPCFG3.Reg) & 0x3ff00000) >> 20
}
func (o *LCDC_Type) SetPPCFG3_CSCYOFF(value uint32) {
	volatile.StoreUint32(&o.PPCFG3.Reg, volatile.LoadUint32(&o.PPCFG3.Reg)&^(0x40000000)|value<<30)
}
func (o *LCDC_Type) GetPPCFG3_CSCYOFF() uint32 {
	return (volatile.LoadUint32(&o.PPCFG3.Reg) & 0x40000000) >> 30
}

// LCDC.PPCFG4: Post Processing Configuration Register 4
func (o *LCDC_Type) SetPPCFG4_CSCUR(value uint32) {
	volatile.StoreUint32(&o.PPCFG4.Reg, volatile.LoadUint32(&o.PPCFG4.Reg)&^(0x3ff)|value)
}
func (o *LCDC_Type) GetPPCFG4_CSCUR() uint32 {
	return volatile.LoadUint32(&o.PPCFG4.Reg) & 0x3ff
}
func (o *LCDC_Type) SetPPCFG4_CSCUG(value uint32) {
	volatile.StoreUint32(&o.PPCFG4.Reg, volatile.LoadUint32(&o.PPCFG4.Reg)&^(0xffc00)|value<<10)
}
func (o *LCDC_Type) GetPPCFG4_CSCUG() uint32 {
	return (volatile.LoadUint32(&o.PPCFG4.Reg) & 0xffc00) >> 10
}
func (o *LCDC_Type) SetPPCFG4_CSCUB(value uint32) {
	volatile.StoreUint32(&o.PPCFG4.Reg, volatile.LoadUint32(&o.PPCFG4.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LCDC_Type) GetPPCFG4_CSCUB() uint32 {
	return (volatile.LoadUint32(&o.PPCFG4.Reg) & 0x3ff00000) >> 20
}
func (o *LCDC_Type) SetPPCFG4_CSCUOFF(value uint32) {
	volatile.StoreUint32(&o.PPCFG4.Reg, volatile.LoadUint32(&o.PPCFG4.Reg)&^(0x40000000)|value<<30)
}
func (o *LCDC_Type) GetPPCFG4_CSCUOFF() uint32 {
	return (volatile.LoadUint32(&o.PPCFG4.Reg) & 0x40000000) >> 30
}

// LCDC.PPCFG5: Post Processing Configuration Register 5
func (o *LCDC_Type) SetPPCFG5_CSCVR(value uint32) {
	volatile.StoreUint32(&o.PPCFG5.Reg, volatile.LoadUint32(&o.PPCFG5.Reg)&^(0x3ff)|value)
}
func (o *LCDC_Type) GetPPCFG5_CSCVR() uint32 {
	return volatile.LoadUint32(&o.PPCFG5.Reg) & 0x3ff
}
func (o *LCDC_Type) SetPPCFG5_CSCVG(value uint32) {
	volatile.StoreUint32(&o.PPCFG5.Reg, volatile.LoadUint32(&o.PPCFG5.Reg)&^(0xffc00)|value<<10)
}
func (o *LCDC_Type) GetPPCFG5_CSCVG() uint32 {
	return (volatile.LoadUint32(&o.PPCFG5.Reg) & 0xffc00) >> 10
}
func (o *LCDC_Type) SetPPCFG5_CSCVB(value uint32) {
	volatile.StoreUint32(&o.PPCFG5.Reg, volatile.LoadUint32(&o.PPCFG5.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LCDC_Type) GetPPCFG5_CSCVB() uint32 {
	return (volatile.LoadUint32(&o.PPCFG5.Reg) & 0x3ff00000) >> 20
}
func (o *LCDC_Type) SetPPCFG5_CSCVOFF(value uint32) {
	volatile.StoreUint32(&o.PPCFG5.Reg, volatile.LoadUint32(&o.PPCFG5.Reg)&^(0x40000000)|value<<30)
}
func (o *LCDC_Type) GetPPCFG5_CSCVOFF() uint32 {
	return (volatile.LoadUint32(&o.PPCFG5.Reg) & 0x40000000) >> 30
}

// LCDC.BASECLUT: Base CLUT Register
func (o *LCDC_Type) SetBASECLUT_BCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.BASECLUT[idx].Reg, volatile.LoadUint32(&o.BASECLUT[idx].Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetBASECLUT_BCLUT(idx int) uint32 {
	return volatile.LoadUint32(&o.BASECLUT[idx].Reg) & 0xff
}
func (o *LCDC_Type) SetBASECLUT_GCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.BASECLUT[idx].Reg, volatile.LoadUint32(&o.BASECLUT[idx].Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetBASECLUT_GCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.BASECLUT[idx].Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetBASECLUT_RCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.BASECLUT[idx].Reg, volatile.LoadUint32(&o.BASECLUT[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetBASECLUT_RCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.BASECLUT[idx].Reg) & 0xff0000) >> 16
}

// LCDC.OVR1CLUT: Overlay 1 CLUT Register
func (o *LCDC_Type) SetOVR1CLUT_BCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.OVR1CLUT[idx].Reg, volatile.LoadUint32(&o.OVR1CLUT[idx].Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetOVR1CLUT_BCLUT(idx int) uint32 {
	return volatile.LoadUint32(&o.OVR1CLUT[idx].Reg) & 0xff
}
func (o *LCDC_Type) SetOVR1CLUT_GCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.OVR1CLUT[idx].Reg, volatile.LoadUint32(&o.OVR1CLUT[idx].Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetOVR1CLUT_GCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.OVR1CLUT[idx].Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetOVR1CLUT_RCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.OVR1CLUT[idx].Reg, volatile.LoadUint32(&o.OVR1CLUT[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR1CLUT_RCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.OVR1CLUT[idx].Reg) & 0xff0000) >> 16
}
func (o *LCDC_Type) SetOVR1CLUT_ACLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.OVR1CLUT[idx].Reg, volatile.LoadUint32(&o.OVR1CLUT[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *LCDC_Type) GetOVR1CLUT_ACLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.OVR1CLUT[idx].Reg) & 0xff000000) >> 24
}

// LCDC.OVR2CLUT: Overlay 2 CLUT Register
func (o *LCDC_Type) SetOVR2CLUT_BCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.OVR2CLUT[idx].Reg, volatile.LoadUint32(&o.OVR2CLUT[idx].Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetOVR2CLUT_BCLUT(idx int) uint32 {
	return volatile.LoadUint32(&o.OVR2CLUT[idx].Reg) & 0xff
}
func (o *LCDC_Type) SetOVR2CLUT_GCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.OVR2CLUT[idx].Reg, volatile.LoadUint32(&o.OVR2CLUT[idx].Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetOVR2CLUT_GCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.OVR2CLUT[idx].Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetOVR2CLUT_RCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.OVR2CLUT[idx].Reg, volatile.LoadUint32(&o.OVR2CLUT[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetOVR2CLUT_RCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.OVR2CLUT[idx].Reg) & 0xff0000) >> 16
}
func (o *LCDC_Type) SetOVR2CLUT_ACLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.OVR2CLUT[idx].Reg, volatile.LoadUint32(&o.OVR2CLUT[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *LCDC_Type) GetOVR2CLUT_ACLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.OVR2CLUT[idx].Reg) & 0xff000000) >> 24
}

// LCDC.HEOCLUT: High End Overlay CLUT Register
func (o *LCDC_Type) SetHEOCLUT_BCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HEOCLUT[idx].Reg, volatile.LoadUint32(&o.HEOCLUT[idx].Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHEOCLUT_BCLUT(idx int) uint32 {
	return volatile.LoadUint32(&o.HEOCLUT[idx].Reg) & 0xff
}
func (o *LCDC_Type) SetHEOCLUT_GCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HEOCLUT[idx].Reg, volatile.LoadUint32(&o.HEOCLUT[idx].Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHEOCLUT_GCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.HEOCLUT[idx].Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHEOCLUT_RCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HEOCLUT[idx].Reg, volatile.LoadUint32(&o.HEOCLUT[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHEOCLUT_RCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.HEOCLUT[idx].Reg) & 0xff0000) >> 16
}
func (o *LCDC_Type) SetHEOCLUT_ACLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HEOCLUT[idx].Reg, volatile.LoadUint32(&o.HEOCLUT[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *LCDC_Type) GetHEOCLUT_ACLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.HEOCLUT[idx].Reg) & 0xff000000) >> 24
}

// LCDC.HCRCLUT: Hardware Cursor CLUT Register
func (o *LCDC_Type) SetHCRCLUT_BCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HCRCLUT[idx].Reg, volatile.LoadUint32(&o.HCRCLUT[idx].Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetHCRCLUT_BCLUT(idx int) uint32 {
	return volatile.LoadUint32(&o.HCRCLUT[idx].Reg) & 0xff
}
func (o *LCDC_Type) SetHCRCLUT_GCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HCRCLUT[idx].Reg, volatile.LoadUint32(&o.HCRCLUT[idx].Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetHCRCLUT_GCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.HCRCLUT[idx].Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetHCRCLUT_RCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HCRCLUT[idx].Reg, volatile.LoadUint32(&o.HCRCLUT[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetHCRCLUT_RCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.HCRCLUT[idx].Reg) & 0xff0000) >> 16
}
func (o *LCDC_Type) SetHCRCLUT_ACLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HCRCLUT[idx].Reg, volatile.LoadUint32(&o.HCRCLUT[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *LCDC_Type) GetHCRCLUT_ACLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.HCRCLUT[idx].Reg) & 0xff000000) >> 24
}

// Image Sensor Interface
type ISI_Type struct {
	CFG1       volatile.Register32 // 0x0
	CFG2       volatile.Register32 // 0x4
	PSIZE      volatile.Register32 // 0x8
	PDECF      volatile.Register32 // 0xC
	Y2R_SET0   volatile.Register32 // 0x10
	Y2R_SET1   volatile.Register32 // 0x14
	R2Y_SET0   volatile.Register32 // 0x18
	R2Y_SET1   volatile.Register32 // 0x1C
	R2Y_SET2   volatile.Register32 // 0x20
	CR         volatile.Register32 // 0x24
	SR         volatile.Register32 // 0x28
	IER        volatile.Register32 // 0x2C
	IDR        volatile.Register32 // 0x30
	IMR        volatile.Register32 // 0x34
	DMA_CHER   volatile.Register32 // 0x38
	DMA_CHDR   volatile.Register32 // 0x3C
	DMA_CHSR   volatile.Register32 // 0x40
	DMA_P_ADDR volatile.Register32 // 0x44
	DMA_P_CTRL volatile.Register32 // 0x48
	DMA_P_DSCR volatile.Register32 // 0x4C
	DMA_C_ADDR volatile.Register32 // 0x50
	DMA_C_CTRL volatile.Register32 // 0x54
	DMA_C_DSCR volatile.Register32 // 0x58
	_          [136]byte
	WPCR       volatile.Register32 // 0xE4
	WPSR       volatile.Register32 // 0xE8
}

// ISI.CFG1: ISI Configuration 1 Register
func (o *ISI_Type) SetCFG1_HSYNC_POL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetCFG1_HSYNC_POL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetCFG1_VSYNC_POL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x8)|value<<3)
}
func (o *ISI_Type) GetCFG1_VSYNC_POL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x8) >> 3
}
func (o *ISI_Type) SetCFG1_PIXCLK_POL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x10)|value<<4)
}
func (o *ISI_Type) GetCFG1_PIXCLK_POL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x10) >> 4
}
func (o *ISI_Type) SetCFG1_EMB_SYNC(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x40)|value<<6)
}
func (o *ISI_Type) GetCFG1_EMB_SYNC() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x40) >> 6
}
func (o *ISI_Type) SetCFG1_CRC_SYNC(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x80)|value<<7)
}
func (o *ISI_Type) GetCFG1_CRC_SYNC() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x80) >> 7
}
func (o *ISI_Type) SetCFG1_FRATE(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x700)|value<<8)
}
func (o *ISI_Type) GetCFG1_FRATE() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x700) >> 8
}
func (o *ISI_Type) SetCFG1_DISCR(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x800)|value<<11)
}
func (o *ISI_Type) GetCFG1_DISCR() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x800) >> 11
}
func (o *ISI_Type) SetCFG1_FULL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x1000)|value<<12)
}
func (o *ISI_Type) GetCFG1_FULL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x1000) >> 12
}
func (o *ISI_Type) SetCFG1_THMASK(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x6000)|value<<13)
}
func (o *ISI_Type) GetCFG1_THMASK() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x6000) >> 13
}
func (o *ISI_Type) SetCFG1_SLD(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xff0000)|value<<16)
}
func (o *ISI_Type) GetCFG1_SLD() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xff0000) >> 16
}
func (o *ISI_Type) SetCFG1_SFD(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xff000000)|value<<24)
}
func (o *ISI_Type) GetCFG1_SFD() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xff000000) >> 24
}

// ISI.CFG2: ISI Configuration 2 Register
func (o *ISI_Type) SetCFG2_IM_VSIZE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x7ff)|value)
}
func (o *ISI_Type) GetCFG2_IM_VSIZE() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0x7ff
}
func (o *ISI_Type) SetCFG2_GS_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x800)|value<<11)
}
func (o *ISI_Type) GetCFG2_GS_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x800) >> 11
}
func (o *ISI_Type) SetCFG2_RGB_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x1000)|value<<12)
}
func (o *ISI_Type) GetCFG2_RGB_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x1000) >> 12
}
func (o *ISI_Type) SetCFG2_GRAYSCALE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x2000)|value<<13)
}
func (o *ISI_Type) GetCFG2_GRAYSCALE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x2000) >> 13
}
func (o *ISI_Type) SetCFG2_RGB_SWAP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x4000)|value<<14)
}
func (o *ISI_Type) GetCFG2_RGB_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x4000) >> 14
}
func (o *ISI_Type) SetCFG2_COL_SPACE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x8000)|value<<15)
}
func (o *ISI_Type) GetCFG2_COL_SPACE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x8000) >> 15
}
func (o *ISI_Type) SetCFG2_IM_HSIZE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x7ff0000)|value<<16)
}
func (o *ISI_Type) GetCFG2_IM_HSIZE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x7ff0000) >> 16
}
func (o *ISI_Type) SetCFG2_YCC_SWAP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x30000000)|value<<28)
}
func (o *ISI_Type) GetCFG2_YCC_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x30000000) >> 28
}
func (o *ISI_Type) SetCFG2_RGB_CFG(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xc0000000)|value<<30)
}
func (o *ISI_Type) GetCFG2_RGB_CFG() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xc0000000) >> 30
}

// ISI.PSIZE: ISI Preview Size Register
func (o *ISI_Type) SetPSIZE_PREV_VSIZE(value uint32) {
	volatile.StoreUint32(&o.PSIZE.Reg, volatile.LoadUint32(&o.PSIZE.Reg)&^(0x3ff)|value)
}
func (o *ISI_Type) GetPSIZE_PREV_VSIZE() uint32 {
	return volatile.LoadUint32(&o.PSIZE.Reg) & 0x3ff
}
func (o *ISI_Type) SetPSIZE_PREV_HSIZE(value uint32) {
	volatile.StoreUint32(&o.PSIZE.Reg, volatile.LoadUint32(&o.PSIZE.Reg)&^(0x3ff0000)|value<<16)
}
func (o *ISI_Type) GetPSIZE_PREV_HSIZE() uint32 {
	return (volatile.LoadUint32(&o.PSIZE.Reg) & 0x3ff0000) >> 16
}

// ISI.PDECF: ISI Preview Decimation Factor Register
func (o *ISI_Type) SetPDECF_DEC_FACTOR(value uint32) {
	volatile.StoreUint32(&o.PDECF.Reg, volatile.LoadUint32(&o.PDECF.Reg)&^(0xff)|value)
}
func (o *ISI_Type) GetPDECF_DEC_FACTOR() uint32 {
	return volatile.LoadUint32(&o.PDECF.Reg) & 0xff
}

// ISI.Y2R_SET0: ISI CSC YCrCb To RGB Set 0 Register
func (o *ISI_Type) SetY2R_SET0_C0(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET0.Reg, volatile.LoadUint32(&o.Y2R_SET0.Reg)&^(0xff)|value)
}
func (o *ISI_Type) GetY2R_SET0_C0() uint32 {
	return volatile.LoadUint32(&o.Y2R_SET0.Reg) & 0xff
}
func (o *ISI_Type) SetY2R_SET0_C1(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET0.Reg, volatile.LoadUint32(&o.Y2R_SET0.Reg)&^(0xff00)|value<<8)
}
func (o *ISI_Type) GetY2R_SET0_C1() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET0.Reg) & 0xff00) >> 8
}
func (o *ISI_Type) SetY2R_SET0_C2(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET0.Reg, volatile.LoadUint32(&o.Y2R_SET0.Reg)&^(0xff0000)|value<<16)
}
func (o *ISI_Type) GetY2R_SET0_C2() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET0.Reg) & 0xff0000) >> 16
}
func (o *ISI_Type) SetY2R_SET0_C3(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET0.Reg, volatile.LoadUint32(&o.Y2R_SET0.Reg)&^(0xff000000)|value<<24)
}
func (o *ISI_Type) GetY2R_SET0_C3() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET0.Reg) & 0xff000000) >> 24
}

// ISI.Y2R_SET1: ISI CSC YCrCb To RGB Set 1 Register
func (o *ISI_Type) SetY2R_SET1_C4(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET1.Reg, volatile.LoadUint32(&o.Y2R_SET1.Reg)&^(0x1ff)|value)
}
func (o *ISI_Type) GetY2R_SET1_C4() uint32 {
	return volatile.LoadUint32(&o.Y2R_SET1.Reg) & 0x1ff
}
func (o *ISI_Type) SetY2R_SET1_Yoff(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET1.Reg, volatile.LoadUint32(&o.Y2R_SET1.Reg)&^(0x1000)|value<<12)
}
func (o *ISI_Type) GetY2R_SET1_Yoff() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET1.Reg) & 0x1000) >> 12
}
func (o *ISI_Type) SetY2R_SET1_Croff(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET1.Reg, volatile.LoadUint32(&o.Y2R_SET1.Reg)&^(0x2000)|value<<13)
}
func (o *ISI_Type) GetY2R_SET1_Croff() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET1.Reg) & 0x2000) >> 13
}
func (o *ISI_Type) SetY2R_SET1_Cboff(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET1.Reg, volatile.LoadUint32(&o.Y2R_SET1.Reg)&^(0x4000)|value<<14)
}
func (o *ISI_Type) GetY2R_SET1_Cboff() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET1.Reg) & 0x4000) >> 14
}

// ISI.R2Y_SET0: ISI CSC RGB To YCrCb Set 0 Register
func (o *ISI_Type) SetR2Y_SET0_C0(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET0.Reg, volatile.LoadUint32(&o.R2Y_SET0.Reg)&^(0x7f)|value)
}
func (o *ISI_Type) GetR2Y_SET0_C0() uint32 {
	return volatile.LoadUint32(&o.R2Y_SET0.Reg) & 0x7f
}
func (o *ISI_Type) SetR2Y_SET0_C1(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET0.Reg, volatile.LoadUint32(&o.R2Y_SET0.Reg)&^(0x7f00)|value<<8)
}
func (o *ISI_Type) GetR2Y_SET0_C1() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET0.Reg) & 0x7f00) >> 8
}
func (o *ISI_Type) SetR2Y_SET0_C2(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET0.Reg, volatile.LoadUint32(&o.R2Y_SET0.Reg)&^(0x7f0000)|value<<16)
}
func (o *ISI_Type) GetR2Y_SET0_C2() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET0.Reg) & 0x7f0000) >> 16
}
func (o *ISI_Type) SetR2Y_SET0_Roff(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET0.Reg, volatile.LoadUint32(&o.R2Y_SET0.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetR2Y_SET0_Roff() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET0.Reg) & 0x1000000) >> 24
}

// ISI.R2Y_SET1: ISI CSC RGB To YCrCb Set 1 Register
func (o *ISI_Type) SetR2Y_SET1_C3(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET1.Reg, volatile.LoadUint32(&o.R2Y_SET1.Reg)&^(0x7f)|value)
}
func (o *ISI_Type) GetR2Y_SET1_C3() uint32 {
	return volatile.LoadUint32(&o.R2Y_SET1.Reg) & 0x7f
}
func (o *ISI_Type) SetR2Y_SET1_C4(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET1.Reg, volatile.LoadUint32(&o.R2Y_SET1.Reg)&^(0x7f00)|value<<8)
}
func (o *ISI_Type) GetR2Y_SET1_C4() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET1.Reg) & 0x7f00) >> 8
}
func (o *ISI_Type) SetR2Y_SET1_C5(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET1.Reg, volatile.LoadUint32(&o.R2Y_SET1.Reg)&^(0x7f0000)|value<<16)
}
func (o *ISI_Type) GetR2Y_SET1_C5() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET1.Reg) & 0x7f0000) >> 16
}
func (o *ISI_Type) SetR2Y_SET1_Goff(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET1.Reg, volatile.LoadUint32(&o.R2Y_SET1.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetR2Y_SET1_Goff() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET1.Reg) & 0x1000000) >> 24
}

// ISI.R2Y_SET2: ISI CSC RGB To YCrCb Set 2 Register
func (o *ISI_Type) SetR2Y_SET2_C6(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET2.Reg, volatile.LoadUint32(&o.R2Y_SET2.Reg)&^(0x7f)|value)
}
func (o *ISI_Type) GetR2Y_SET2_C6() uint32 {
	return volatile.LoadUint32(&o.R2Y_SET2.Reg) & 0x7f
}
func (o *ISI_Type) SetR2Y_SET2_C7(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET2.Reg, volatile.LoadUint32(&o.R2Y_SET2.Reg)&^(0x7f00)|value<<8)
}
func (o *ISI_Type) GetR2Y_SET2_C7() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET2.Reg) & 0x7f00) >> 8
}
func (o *ISI_Type) SetR2Y_SET2_C8(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET2.Reg, volatile.LoadUint32(&o.R2Y_SET2.Reg)&^(0x7f0000)|value<<16)
}
func (o *ISI_Type) GetR2Y_SET2_C8() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET2.Reg) & 0x7f0000) >> 16
}
func (o *ISI_Type) SetR2Y_SET2_Boff(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET2.Reg, volatile.LoadUint32(&o.R2Y_SET2.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetR2Y_SET2_Boff() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET2.Reg) & 0x1000000) >> 24
}

// ISI.CR: ISI Control Register
func (o *ISI_Type) SetCR_ISI_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetCR_ISI_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *ISI_Type) SetCR_ISI_DIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetCR_ISI_DIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetCR_ISI_SRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetCR_ISI_SRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetCR_ISI_CDC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *ISI_Type) GetCR_ISI_CDC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// ISI.SR: ISI Status Register
func (o *ISI_Type) SetSR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetSR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *ISI_Type) SetSR_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetSR_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetSR_SRST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetSR_SRST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetSR_CDC_PND(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *ISI_Type) GetSR_CDC_PND() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *ISI_Type) SetSR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetSR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetSR_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetSR_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetSR_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetSR_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetSR_SIP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *ISI_Type) GetSR_SIP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *ISI_Type) SetSR_P_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetSR_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetSR_C_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetSR_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetSR_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetSR_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetSR_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetSR_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}

// ISI.IER: ISI Interrupt Enable Register
func (o *ISI_Type) SetIER_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetIER_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetIER_SRST(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetIER_SRST() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetIER_VSYNC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetIER_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetIER_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetIER_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetIER_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetIER_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetIER_P_OVR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetIER_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetIER_C_OVR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetIER_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetIER_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetIER_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetIER_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetIER_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}

// ISI.IDR: ISI Interrupt Disable Register
func (o *ISI_Type) SetIDR_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetIDR_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetIDR_SRST(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetIDR_SRST() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetIDR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetIDR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetIDR_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetIDR_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetIDR_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetIDR_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetIDR_P_OVR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetIDR_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetIDR_C_OVR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetIDR_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetIDR_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetIDR_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetIDR_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetIDR_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}

// ISI.IMR: ISI Interrupt Mask Register
func (o *ISI_Type) SetIMR_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetIMR_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetIMR_SRST(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetIMR_SRST() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetIMR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetIMR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetIMR_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetIMR_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetIMR_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetIMR_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetIMR_P_OVR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetIMR_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetIMR_C_OVR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetIMR_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetIMR_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetIMR_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetIMR_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetIMR_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}

// ISI.DMA_CHER: DMA Channel Enable Register
func (o *ISI_Type) SetDMA_CHER_P_CH_EN(value uint32) {
	volatile.StoreUint32(&o.DMA_CHER.Reg, volatile.LoadUint32(&o.DMA_CHER.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_CHER_P_CH_EN() uint32 {
	return volatile.LoadUint32(&o.DMA_CHER.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_CHER_C_CH_EN(value uint32) {
	volatile.StoreUint32(&o.DMA_CHER.Reg, volatile.LoadUint32(&o.DMA_CHER.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_CHER_C_CH_EN() uint32 {
	return (volatile.LoadUint32(&o.DMA_CHER.Reg) & 0x2) >> 1
}

// ISI.DMA_CHDR: DMA Channel Disable Register
func (o *ISI_Type) SetDMA_CHDR_P_CH_DIS(value uint32) {
	volatile.StoreUint32(&o.DMA_CHDR.Reg, volatile.LoadUint32(&o.DMA_CHDR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_CHDR_P_CH_DIS() uint32 {
	return volatile.LoadUint32(&o.DMA_CHDR.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_CHDR_C_CH_DIS(value uint32) {
	volatile.StoreUint32(&o.DMA_CHDR.Reg, volatile.LoadUint32(&o.DMA_CHDR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_CHDR_C_CH_DIS() uint32 {
	return (volatile.LoadUint32(&o.DMA_CHDR.Reg) & 0x2) >> 1
}

// ISI.DMA_CHSR: DMA Channel Status Register
func (o *ISI_Type) SetDMA_CHSR_P_CH_S(value uint32) {
	volatile.StoreUint32(&o.DMA_CHSR.Reg, volatile.LoadUint32(&o.DMA_CHSR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_CHSR_P_CH_S() uint32 {
	return volatile.LoadUint32(&o.DMA_CHSR.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_CHSR_C_CH_S(value uint32) {
	volatile.StoreUint32(&o.DMA_CHSR.Reg, volatile.LoadUint32(&o.DMA_CHSR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_CHSR_C_CH_S() uint32 {
	return (volatile.LoadUint32(&o.DMA_CHSR.Reg) & 0x2) >> 1
}

// ISI.DMA_P_ADDR: DMA Preview Base Address Register
func (o *ISI_Type) SetDMA_P_ADDR_P_ADDR(value uint32) {
	volatile.StoreUint32(&o.DMA_P_ADDR.Reg, volatile.LoadUint32(&o.DMA_P_ADDR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_P_ADDR_P_ADDR() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_ADDR.Reg) & 0xfffffffc) >> 2
}

// ISI.DMA_P_CTRL: DMA Preview Control Register
func (o *ISI_Type) SetDMA_P_CTRL_P_FETCH(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_FETCH() uint32 {
	return volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_P_CTRL_P_WB(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_WB() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetDMA_P_CTRL_P_IEN(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_IEN() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetDMA_P_CTRL_P_DONE(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_DONE() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x8) >> 3
}

// ISI.DMA_P_DSCR: DMA Preview Descriptor Address Register
func (o *ISI_Type) SetDMA_P_DSCR_P_DSCR(value uint32) {
	volatile.StoreUint32(&o.DMA_P_DSCR.Reg, volatile.LoadUint32(&o.DMA_P_DSCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_P_DSCR_P_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_DSCR.Reg) & 0xfffffffc) >> 2
}

// ISI.DMA_C_ADDR: DMA Codec Base Address Register
func (o *ISI_Type) SetDMA_C_ADDR_C_ADDR(value uint32) {
	volatile.StoreUint32(&o.DMA_C_ADDR.Reg, volatile.LoadUint32(&o.DMA_C_ADDR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_C_ADDR_C_ADDR() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_ADDR.Reg) & 0xfffffffc) >> 2
}

// ISI.DMA_C_CTRL: DMA Codec Control Register
func (o *ISI_Type) SetDMA_C_CTRL_C_FETCH(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_FETCH() uint32 {
	return volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_C_CTRL_C_WB(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_WB() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetDMA_C_CTRL_C_IEN(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_IEN() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetDMA_C_CTRL_C_DONE(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_DONE() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x8) >> 3
}

// ISI.DMA_C_DSCR: DMA Codec Descriptor Address Register
func (o *ISI_Type) SetDMA_C_DSCR_C_DSCR(value uint32) {
	volatile.StoreUint32(&o.DMA_C_DSCR.Reg, volatile.LoadUint32(&o.DMA_C_DSCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_C_DSCR_C_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_DSCR.Reg) & 0xfffffffc) >> 2
}

// ISI.WPCR: Write Protection Control Register
func (o *ISI_Type) SetWPCR_WP_EN(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetWPCR_WP_EN() uint32 {
	return volatile.LoadUint32(&o.WPCR.Reg) & 0x1
}
func (o *ISI_Type) SetWPCR_WP_KEY(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ISI_Type) GetWPCR_WP_KEY() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0xffffff00) >> 8
}

// ISI.WPSR: Write Protection Status Register
func (o *ISI_Type) SetWPSR_WP_VS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xf)|value)
}
func (o *ISI_Type) GetWPSR_WP_VS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0xf
}
func (o *ISI_Type) SetWPSR_WP_VSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *ISI_Type) GetWPSR_WP_VSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Special Function Registers
type SFR_Type struct {
	_          [16]byte
	OHCIICR    volatile.Register32 // 0x10
	OHCIISR    volatile.Register32 // 0x14
	_          [8]byte
	AHB        volatile.Register32 // 0x20
	BRIDGE     volatile.Register32 // 0x24
	SECURE     volatile.Register32 // 0x28
	_          [4]byte
	UTMICKTRIM volatile.Register32 // 0x30
	UTMIHSTRIM volatile.Register32 // 0x34
	UTMIFSTRIM volatile.Register32 // 0x38
	UTMISWAP   volatile.Register32 // 0x3C
	EBICFG     volatile.Register32 // 0x40
}

// SFR.OHCIICR: OHCI Interrupt Configuration Register
func (o *SFR_Type) SetOHCIICR_RES0(value uint32) {
	volatile.StoreUint32(&o.OHCIICR.Reg, volatile.LoadUint32(&o.OHCIICR.Reg)&^(0x1)|value)
}
func (o *SFR_Type) GetOHCIICR_RES0() uint32 {
	return volatile.LoadUint32(&o.OHCIICR.Reg) & 0x1
}
func (o *SFR_Type) SetOHCIICR_RES1(value uint32) {
	volatile.StoreUint32(&o.OHCIICR.Reg, volatile.LoadUint32(&o.OHCIICR.Reg)&^(0x2)|value<<1)
}
func (o *SFR_Type) GetOHCIICR_RES1() uint32 {
	return (volatile.LoadUint32(&o.OHCIICR.Reg) & 0x2) >> 1
}
func (o *SFR_Type) SetOHCIICR_RES2(value uint32) {
	volatile.StoreUint32(&o.OHCIICR.Reg, volatile.LoadUint32(&o.OHCIICR.Reg)&^(0x4)|value<<2)
}
func (o *SFR_Type) GetOHCIICR_RES2() uint32 {
	return (volatile.LoadUint32(&o.OHCIICR.Reg) & 0x4) >> 2
}
func (o *SFR_Type) SetOHCIICR_ARIE(value uint32) {
	volatile.StoreUint32(&o.OHCIICR.Reg, volatile.LoadUint32(&o.OHCIICR.Reg)&^(0x10)|value<<4)
}
func (o *SFR_Type) GetOHCIICR_ARIE() uint32 {
	return (volatile.LoadUint32(&o.OHCIICR.Reg) & 0x10) >> 4
}
func (o *SFR_Type) SetOHCIICR_APPSTART(value uint32) {
	volatile.StoreUint32(&o.OHCIICR.Reg, volatile.LoadUint32(&o.OHCIICR.Reg)&^(0x20)|value<<5)
}
func (o *SFR_Type) GetOHCIICR_APPSTART() uint32 {
	return (volatile.LoadUint32(&o.OHCIICR.Reg) & 0x20) >> 5
}
func (o *SFR_Type) SetOHCIICR_UDPPUDIS(value uint32) {
	volatile.StoreUint32(&o.OHCIICR.Reg, volatile.LoadUint32(&o.OHCIICR.Reg)&^(0x800000)|value<<23)
}
func (o *SFR_Type) GetOHCIICR_UDPPUDIS() uint32 {
	return (volatile.LoadUint32(&o.OHCIICR.Reg) & 0x800000) >> 23
}

// SFR.OHCIISR: OHCI Interrupt Status Register
func (o *SFR_Type) SetOHCIISR_RIS0(value uint32) {
	volatile.StoreUint32(&o.OHCIISR.Reg, volatile.LoadUint32(&o.OHCIISR.Reg)&^(0x1)|value)
}
func (o *SFR_Type) GetOHCIISR_RIS0() uint32 {
	return volatile.LoadUint32(&o.OHCIISR.Reg) & 0x1
}
func (o *SFR_Type) SetOHCIISR_RIS1(value uint32) {
	volatile.StoreUint32(&o.OHCIISR.Reg, volatile.LoadUint32(&o.OHCIISR.Reg)&^(0x2)|value<<1)
}
func (o *SFR_Type) GetOHCIISR_RIS1() uint32 {
	return (volatile.LoadUint32(&o.OHCIISR.Reg) & 0x2) >> 1
}
func (o *SFR_Type) SetOHCIISR_RIS2(value uint32) {
	volatile.StoreUint32(&o.OHCIISR.Reg, volatile.LoadUint32(&o.OHCIISR.Reg)&^(0x4)|value<<2)
}
func (o *SFR_Type) GetOHCIISR_RIS2() uint32 {
	return (volatile.LoadUint32(&o.OHCIISR.Reg) & 0x4) >> 2
}

// SFR.AHB: AHB Configuration Register
func (o *SFR_Type) SetAHB_PFETCH10(value uint32) {
	volatile.StoreUint32(&o.AHB.Reg, volatile.LoadUint32(&o.AHB.Reg)&^(0x400)|value<<10)
}
func (o *SFR_Type) GetAHB_PFETCH10() uint32 {
	return (volatile.LoadUint32(&o.AHB.Reg) & 0x400) >> 10
}
func (o *SFR_Type) SetAHB_PFETCH11(value uint32) {
	volatile.StoreUint32(&o.AHB.Reg, volatile.LoadUint32(&o.AHB.Reg)&^(0x800)|value<<11)
}
func (o *SFR_Type) GetAHB_PFETCH11() uint32 {
	return (volatile.LoadUint32(&o.AHB.Reg) & 0x800) >> 11
}
func (o *SFR_Type) SetAHB_PFETCH12(value uint32) {
	volatile.StoreUint32(&o.AHB.Reg, volatile.LoadUint32(&o.AHB.Reg)&^(0x1000)|value<<12)
}
func (o *SFR_Type) GetAHB_PFETCH12() uint32 {
	return (volatile.LoadUint32(&o.AHB.Reg) & 0x1000) >> 12
}
func (o *SFR_Type) SetAHB_PFETCH13(value uint32) {
	volatile.StoreUint32(&o.AHB.Reg, volatile.LoadUint32(&o.AHB.Reg)&^(0x2000)|value<<13)
}
func (o *SFR_Type) GetAHB_PFETCH13() uint32 {
	return (volatile.LoadUint32(&o.AHB.Reg) & 0x2000) >> 13
}
func (o *SFR_Type) SetAHB_PFETCH14(value uint32) {
	volatile.StoreUint32(&o.AHB.Reg, volatile.LoadUint32(&o.AHB.Reg)&^(0x4000)|value<<14)
}
func (o *SFR_Type) GetAHB_PFETCH14() uint32 {
	return (volatile.LoadUint32(&o.AHB.Reg) & 0x4000) >> 14
}
func (o *SFR_Type) SetAHB_DLBOPT10(value uint32) {
	volatile.StoreUint32(&o.AHB.Reg, volatile.LoadUint32(&o.AHB.Reg)&^(0x4000000)|value<<26)
}
func (o *SFR_Type) GetAHB_DLBOPT10() uint32 {
	return (volatile.LoadUint32(&o.AHB.Reg) & 0x4000000) >> 26
}
func (o *SFR_Type) SetAHB_DLBOPT11(value uint32) {
	volatile.StoreUint32(&o.AHB.Reg, volatile.LoadUint32(&o.AHB.Reg)&^(0x8000000)|value<<27)
}
func (o *SFR_Type) GetAHB_DLBOPT11() uint32 {
	return (volatile.LoadUint32(&o.AHB.Reg) & 0x8000000) >> 27
}
func (o *SFR_Type) SetAHB_DLBOPT12(value uint32) {
	volatile.StoreUint32(&o.AHB.Reg, volatile.LoadUint32(&o.AHB.Reg)&^(0x10000000)|value<<28)
}
func (o *SFR_Type) GetAHB_DLBOPT12() uint32 {
	return (volatile.LoadUint32(&o.AHB.Reg) & 0x10000000) >> 28
}
func (o *SFR_Type) SetAHB_DLBOPT13(value uint32) {
	volatile.StoreUint32(&o.AHB.Reg, volatile.LoadUint32(&o.AHB.Reg)&^(0x20000000)|value<<29)
}
func (o *SFR_Type) GetAHB_DLBOPT13() uint32 {
	return (volatile.LoadUint32(&o.AHB.Reg) & 0x20000000) >> 29
}
func (o *SFR_Type) SetAHB_DLBOPT14(value uint32) {
	volatile.StoreUint32(&o.AHB.Reg, volatile.LoadUint32(&o.AHB.Reg)&^(0x40000000)|value<<30)
}
func (o *SFR_Type) GetAHB_DLBOPT14() uint32 {
	return (volatile.LoadUint32(&o.AHB.Reg) & 0x40000000) >> 30
}

// SFR.BRIDGE: Bridge Configuration Register
func (o *SFR_Type) SetBRIDGE_APBTURBO(value uint32) {
	volatile.StoreUint32(&o.BRIDGE.Reg, volatile.LoadUint32(&o.BRIDGE.Reg)&^(0x1)|value)
}
func (o *SFR_Type) GetBRIDGE_APBTURBO() uint32 {
	return volatile.LoadUint32(&o.BRIDGE.Reg) & 0x1
}
func (o *SFR_Type) SetBRIDGE_AXI2AHBSEL(value uint32) {
	volatile.StoreUint32(&o.BRIDGE.Reg, volatile.LoadUint32(&o.BRIDGE.Reg)&^(0x100)|value<<8)
}
func (o *SFR_Type) GetBRIDGE_AXI2AHBSEL() uint32 {
	return (volatile.LoadUint32(&o.BRIDGE.Reg) & 0x100) >> 8
}

// SFR.SECURE: Security Configuration Register
func (o *SFR_Type) SetSECURE_ROM(value uint32) {
	volatile.StoreUint32(&o.SECURE.Reg, volatile.LoadUint32(&o.SECURE.Reg)&^(0x1)|value)
}
func (o *SFR_Type) GetSECURE_ROM() uint32 {
	return volatile.LoadUint32(&o.SECURE.Reg) & 0x1
}
func (o *SFR_Type) SetSECURE_FUSE(value uint32) {
	volatile.StoreUint32(&o.SECURE.Reg, volatile.LoadUint32(&o.SECURE.Reg)&^(0x100)|value<<8)
}
func (o *SFR_Type) GetSECURE_FUSE() uint32 {
	return (volatile.LoadUint32(&o.SECURE.Reg) & 0x100) >> 8
}

// SFR.UTMICKTRIM: UTMI Clock Trimming Register
func (o *SFR_Type) SetUTMICKTRIM_FREQ(value uint32) {
	volatile.StoreUint32(&o.UTMICKTRIM.Reg, volatile.LoadUint32(&o.UTMICKTRIM.Reg)&^(0x3)|value)
}
func (o *SFR_Type) GetUTMICKTRIM_FREQ() uint32 {
	return volatile.LoadUint32(&o.UTMICKTRIM.Reg) & 0x3
}
func (o *SFR_Type) SetUTMICKTRIM_VBG(value uint32) {
	volatile.StoreUint32(&o.UTMICKTRIM.Reg, volatile.LoadUint32(&o.UTMICKTRIM.Reg)&^(0xf0000)|value<<16)
}
func (o *SFR_Type) GetUTMICKTRIM_VBG() uint32 {
	return (volatile.LoadUint32(&o.UTMICKTRIM.Reg) & 0xf0000) >> 16
}

// SFR.UTMIHSTRIM: UTMI High Speed Trimming Register
func (o *SFR_Type) SetUTMIHSTRIM_SQUELCH(value uint32) {
	volatile.StoreUint32(&o.UTMIHSTRIM.Reg, volatile.LoadUint32(&o.UTMIHSTRIM.Reg)&^(0x7)|value)
}
func (o *SFR_Type) GetUTMIHSTRIM_SQUELCH() uint32 {
	return volatile.LoadUint32(&o.UTMIHSTRIM.Reg) & 0x7
}
func (o *SFR_Type) SetUTMIHSTRIM_DISC(value uint32) {
	volatile.StoreUint32(&o.UTMIHSTRIM.Reg, volatile.LoadUint32(&o.UTMIHSTRIM.Reg)&^(0x70)|value<<4)
}
func (o *SFR_Type) GetUTMIHSTRIM_DISC() uint32 {
	return (volatile.LoadUint32(&o.UTMIHSTRIM.Reg) & 0x70) >> 4
}
func (o *SFR_Type) SetUTMIHSTRIM_SLOPE0(value uint32) {
	volatile.StoreUint32(&o.UTMIHSTRIM.Reg, volatile.LoadUint32(&o.UTMIHSTRIM.Reg)&^(0x700)|value<<8)
}
func (o *SFR_Type) GetUTMIHSTRIM_SLOPE0() uint32 {
	return (volatile.LoadUint32(&o.UTMIHSTRIM.Reg) & 0x700) >> 8
}
func (o *SFR_Type) SetUTMIHSTRIM_SLOPE1(value uint32) {
	volatile.StoreUint32(&o.UTMIHSTRIM.Reg, volatile.LoadUint32(&o.UTMIHSTRIM.Reg)&^(0x7000)|value<<12)
}
func (o *SFR_Type) GetUTMIHSTRIM_SLOPE1() uint32 {
	return (volatile.LoadUint32(&o.UTMIHSTRIM.Reg) & 0x7000) >> 12
}
func (o *SFR_Type) SetUTMIHSTRIM_SLOPE2(value uint32) {
	volatile.StoreUint32(&o.UTMIHSTRIM.Reg, volatile.LoadUint32(&o.UTMIHSTRIM.Reg)&^(0x70000)|value<<16)
}
func (o *SFR_Type) GetUTMIHSTRIM_SLOPE2() uint32 {
	return (volatile.LoadUint32(&o.UTMIHSTRIM.Reg) & 0x70000) >> 16
}

// SFR.UTMIFSTRIM: UTMI Full Speed Trimming Register
func (o *SFR_Type) SetUTMIFSTRIM_RISE(value uint32) {
	volatile.StoreUint32(&o.UTMIFSTRIM.Reg, volatile.LoadUint32(&o.UTMIFSTRIM.Reg)&^(0x7)|value)
}
func (o *SFR_Type) GetUTMIFSTRIM_RISE() uint32 {
	return volatile.LoadUint32(&o.UTMIFSTRIM.Reg) & 0x7
}
func (o *SFR_Type) SetUTMIFSTRIM_FALL(value uint32) {
	volatile.StoreUint32(&o.UTMIFSTRIM.Reg, volatile.LoadUint32(&o.UTMIFSTRIM.Reg)&^(0x70)|value<<4)
}
func (o *SFR_Type) GetUTMIFSTRIM_FALL() uint32 {
	return (volatile.LoadUint32(&o.UTMIFSTRIM.Reg) & 0x70) >> 4
}
func (o *SFR_Type) SetUTMIFSTRIM_XCVR(value uint32) {
	volatile.StoreUint32(&o.UTMIFSTRIM.Reg, volatile.LoadUint32(&o.UTMIFSTRIM.Reg)&^(0x300)|value<<8)
}
func (o *SFR_Type) GetUTMIFSTRIM_XCVR() uint32 {
	return (volatile.LoadUint32(&o.UTMIFSTRIM.Reg) & 0x300) >> 8
}
func (o *SFR_Type) SetUTMIFSTRIM_ZN(value uint32) {
	volatile.StoreUint32(&o.UTMIFSTRIM.Reg, volatile.LoadUint32(&o.UTMIFSTRIM.Reg)&^(0x70000)|value<<16)
}
func (o *SFR_Type) GetUTMIFSTRIM_ZN() uint32 {
	return (volatile.LoadUint32(&o.UTMIFSTRIM.Reg) & 0x70000) >> 16
}
func (o *SFR_Type) SetUTMIFSTRIM_ZP(value uint32) {
	volatile.StoreUint32(&o.UTMIFSTRIM.Reg, volatile.LoadUint32(&o.UTMIFSTRIM.Reg)&^(0x700000)|value<<20)
}
func (o *SFR_Type) GetUTMIFSTRIM_ZP() uint32 {
	return (volatile.LoadUint32(&o.UTMIFSTRIM.Reg) & 0x700000) >> 20
}

// SFR.UTMISWAP: UTMI DP/DM Pin Swapping Register
func (o *SFR_Type) SetUTMISWAP_PORT0(value uint32) {
	volatile.StoreUint32(&o.UTMISWAP.Reg, volatile.LoadUint32(&o.UTMISWAP.Reg)&^(0x1)|value)
}
func (o *SFR_Type) GetUTMISWAP_PORT0() uint32 {
	return volatile.LoadUint32(&o.UTMISWAP.Reg) & 0x1
}
func (o *SFR_Type) SetUTMISWAP_PORT1(value uint32) {
	volatile.StoreUint32(&o.UTMISWAP.Reg, volatile.LoadUint32(&o.UTMISWAP.Reg)&^(0x2)|value<<1)
}
func (o *SFR_Type) GetUTMISWAP_PORT1() uint32 {
	return (volatile.LoadUint32(&o.UTMISWAP.Reg) & 0x2) >> 1
}
func (o *SFR_Type) SetUTMISWAP_PORT2(value uint32) {
	volatile.StoreUint32(&o.UTMISWAP.Reg, volatile.LoadUint32(&o.UTMISWAP.Reg)&^(0x4)|value<<2)
}
func (o *SFR_Type) GetUTMISWAP_PORT2() uint32 {
	return (volatile.LoadUint32(&o.UTMISWAP.Reg) & 0x4) >> 2
}

// SFR.EBICFG: EBI Configuration Register
func (o *SFR_Type) SetEBICFG_DRIVE0(value uint32) {
	volatile.StoreUint32(&o.EBICFG.Reg, volatile.LoadUint32(&o.EBICFG.Reg)&^(0x3)|value)
}
func (o *SFR_Type) GetEBICFG_DRIVE0() uint32 {
	return volatile.LoadUint32(&o.EBICFG.Reg) & 0x3
}
func (o *SFR_Type) SetEBICFG_PULL0(value uint32) {
	volatile.StoreUint32(&o.EBICFG.Reg, volatile.LoadUint32(&o.EBICFG.Reg)&^(0xc)|value<<2)
}
func (o *SFR_Type) GetEBICFG_PULL0() uint32 {
	return (volatile.LoadUint32(&o.EBICFG.Reg) & 0xc) >> 2
}
func (o *SFR_Type) SetEBICFG_SCH0(value uint32) {
	volatile.StoreUint32(&o.EBICFG.Reg, volatile.LoadUint32(&o.EBICFG.Reg)&^(0x10)|value<<4)
}
func (o *SFR_Type) GetEBICFG_SCH0() uint32 {
	return (volatile.LoadUint32(&o.EBICFG.Reg) & 0x10) >> 4
}
func (o *SFR_Type) SetEBICFG_DRIVE1(value uint32) {
	volatile.StoreUint32(&o.EBICFG.Reg, volatile.LoadUint32(&o.EBICFG.Reg)&^(0x300)|value<<8)
}
func (o *SFR_Type) GetEBICFG_DRIVE1() uint32 {
	return (volatile.LoadUint32(&o.EBICFG.Reg) & 0x300) >> 8
}
func (o *SFR_Type) SetEBICFG_PULL1(value uint32) {
	volatile.StoreUint32(&o.EBICFG.Reg, volatile.LoadUint32(&o.EBICFG.Reg)&^(0xc00)|value<<10)
}
func (o *SFR_Type) GetEBICFG_PULL1() uint32 {
	return (volatile.LoadUint32(&o.EBICFG.Reg) & 0xc00) >> 10
}
func (o *SFR_Type) SetEBICFG_SCH1(value uint32) {
	volatile.StoreUint32(&o.EBICFG.Reg, volatile.LoadUint32(&o.EBICFG.Reg)&^(0x1000)|value<<12)
}
func (o *SFR_Type) GetEBICFG_SCH1() uint32 {
	return (volatile.LoadUint32(&o.EBICFG.Reg) & 0x1000) >> 12
}
func (o *SFR_Type) SetEBICFG_BMS(value uint32) {
	volatile.StoreUint32(&o.EBICFG.Reg, volatile.LoadUint32(&o.EBICFG.Reg)&^(0x10000)|value<<16)
}
func (o *SFR_Type) GetEBICFG_BMS() uint32 {
	return (volatile.LoadUint32(&o.EBICFG.Reg) & 0x10000) >> 16
}

// Analog-to-Digital Converter
type ADC_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	SEQR1  volatile.Register32 // 0x8
	SEQR2  volatile.Register32 // 0xC
	CHER   volatile.Register32 // 0x10
	CHDR   volatile.Register32 // 0x14
	CHSR   volatile.Register32 // 0x18
	_      [4]byte
	LCDR   volatile.Register32 // 0x20
	IER    volatile.Register32 // 0x24
	IDR    volatile.Register32 // 0x28
	IMR    volatile.Register32 // 0x2C
	ISR    volatile.Register32 // 0x30
	_      [8]byte
	OVER   volatile.Register32     // 0x3C
	EMR    volatile.Register32     // 0x40
	CWR    volatile.Register32     // 0x44
	CGR    volatile.Register32     // 0x48
	COR    volatile.Register32     // 0x4C
	CDR    [12]volatile.Register32 // 0x50
	_      [20]byte
	ACR    volatile.Register32 // 0x94
	_      [24]byte
	TSMR   volatile.Register32 // 0xB0
	XPOSR  volatile.Register32 // 0xB4
	YPOSR  volatile.Register32 // 0xB8
	PRESSR volatile.Register32 // 0xBC
	TRGR   volatile.Register32 // 0xC0
	_      [32]byte
	WPMR   volatile.Register32 // 0xE4
	WPSR   volatile.Register32 // 0xE8
}

// ADC.CR: Control Register
func (o *ADC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *ADC_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR_TSCALIB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCR_TSCALIB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCR_AUTOCAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCR_AUTOCAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}

// ADC.MR: Mode Register
func (o *ADC_Type) SetMR_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe)|value<<1)
}
func (o *ADC_Type) GetMR_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe) >> 1
}
func (o *ADC_Type) SetMR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetMR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetMR_FWUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetMR_FWUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetMR_PRESCAL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff00)|value<<8)
}
func (o *ADC_Type) GetMR_PRESCAL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff00) >> 8
}
func (o *ADC_Type) SetMR_STARTUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetMR_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetMR_SETTLING(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetMR_SETTLING() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetMR_ANACH(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetMR_ANACH() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetMR_TRACKTIM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetMR_TRACKTIM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetMR_USEQ(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetMR_USEQ() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// ADC.SEQR1: Channel Sequence Register 1
func (o *ADC_Type) SetSEQR1_USCH1(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQR1_USCH1() uint32 {
	return volatile.LoadUint32(&o.SEQR1.Reg) & 0xf
}
func (o *ADC_Type) SetSEQR1_USCH2(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetSEQR1_USCH2() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetSEQR1_USCH3(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetSEQR1_USCH3() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf00) >> 8
}
func (o *ADC_Type) SetSEQR1_USCH4(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetSEQR1_USCH4() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf000) >> 12
}
func (o *ADC_Type) SetSEQR1_USCH5(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetSEQR1_USCH5() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetSEQR1_USCH6(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSEQR1_USCH6() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSEQR1_USCH7(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetSEQR1_USCH7() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetSEQR1_USCH8(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetSEQR1_USCH8() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0000000) >> 28
}

// ADC.SEQR2: Channel Sequence Register 2
func (o *ADC_Type) SetSEQR2_USCH9(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQR2_USCH9() uint32 {
	return volatile.LoadUint32(&o.SEQR2.Reg) & 0xf
}
func (o *ADC_Type) SetSEQR2_USCH10(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetSEQR2_USCH10() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetSEQR2_USCH11(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetSEQR2_USCH11() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf00) >> 8
}

// ADC.CHER: Channel Enable Register
func (o *ADC_Type) SetCHER_CH0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHER_CH0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *ADC_Type) SetCHER_CH1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHER_CH2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHER_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHER_CH3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHER_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHER_CH4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHER_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHER_CH5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHER_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHER_CH6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHER_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHER_CH7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHER_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHER_CH8(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHER_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHER_CH9(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHER_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHER_CH10(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHER_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHER_CH11(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHER_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x800) >> 11
}

// ADC.CHDR: Channel Disable Register
func (o *ADC_Type) SetCHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *ADC_Type) SetCHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHDR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHDR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHDR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHDR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHDR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHDR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHDR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHDR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHDR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHDR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHDR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHDR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHDR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHDR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHDR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHDR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHDR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHDR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHDR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHDR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x800) >> 11
}

// ADC.CHSR: Channel Status Register
func (o *ADC_Type) SetCHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *ADC_Type) SetCHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHSR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHSR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHSR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHSR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHSR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHSR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHSR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHSR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHSR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHSR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHSR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHSR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHSR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHSR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHSR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHSR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHSR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHSR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHSR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHSR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800) >> 11
}

// ADC.LCDR: Last Converted Data Register
func (o *ADC_Type) SetLCDR_LDATA(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetLCDR_LDATA() uint32 {
	return volatile.LoadUint32(&o.LCDR.Reg) & 0xfff
}
func (o *ADC_Type) SetLCDR_CHNB(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetLCDR_CHNB() uint32 {
	return (volatile.LoadUint32(&o.LCDR.Reg) & 0xf000) >> 12
}

// ADC.IER: Interrupt Enable Register
func (o *ADC_Type) SetIER_EOC0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIER_EOC0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *ADC_Type) SetIER_EOC1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIER_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIER_EOC2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIER_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIER_EOC3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIER_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIER_EOC4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIER_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIER_EOC5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIER_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIER_EOC6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIER_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIER_EOC7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIER_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIER_EOC8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIER_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIER_EOC9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIER_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIER_EOC10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIER_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIER_EOC11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIER_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIER_XRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetIER_XRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetIER_YRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetIER_YRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetIER_PRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetIER_PRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetIER_EOCAL(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetIER_EOCAL() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetIER_DRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIER_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIER_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIER_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIER_COMPE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIER_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIER_PEN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetIER_PEN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetIER_NOPEN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetIER_NOPEN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}

// ADC.IDR: Interrupt Disable Register
func (o *ADC_Type) SetIDR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIDR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *ADC_Type) SetIDR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIDR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIDR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIDR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIDR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIDR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIDR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIDR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIDR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIDR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIDR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIDR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIDR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIDR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIDR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIDR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIDR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIDR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIDR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIDR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIDR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIDR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIDR_XRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetIDR_XRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetIDR_YRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetIDR_YRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetIDR_PRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetIDR_PRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetIDR_EOCAL(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetIDR_EOCAL() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetIDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIDR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIDR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIDR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIDR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIDR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIDR_PEN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetIDR_PEN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetIDR_NOPEN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetIDR_NOPEN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}

// ADC.IMR: Interrupt Mask Register
func (o *ADC_Type) SetIMR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIMR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *ADC_Type) SetIMR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIMR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIMR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIMR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIMR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIMR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIMR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIMR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIMR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIMR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIMR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIMR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIMR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIMR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIMR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIMR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIMR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIMR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIMR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIMR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIMR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIMR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIMR_XRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetIMR_XRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetIMR_YRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetIMR_YRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetIMR_PRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetIMR_PRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetIMR_EOCAL(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetIMR_EOCAL() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetIMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIMR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIMR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIMR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIMR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIMR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIMR_PEN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetIMR_PEN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetIMR_NOPEN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetIMR_NOPEN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}

// ADC.ISR: Interrupt Status Register
func (o *ADC_Type) SetISR_EOC0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetISR_EOC0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *ADC_Type) SetISR_EOC1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetISR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetISR_EOC2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetISR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetISR_EOC3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetISR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetISR_EOC4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetISR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetISR_EOC5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetISR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetISR_EOC6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetISR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetISR_EOC7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetISR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetISR_EOC8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetISR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetISR_EOC9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetISR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetISR_EOC10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetISR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetISR_EOC11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetISR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetISR_XRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetISR_XRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetISR_YRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetISR_YRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetISR_PRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetISR_PRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetISR_EOCAL(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetISR_EOCAL() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetISR_DRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetISR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetISR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetISR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetISR_COMPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetISR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetISR_PEN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetISR_PEN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetISR_NOPEN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetISR_NOPEN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetISR_PENS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetISR_PENS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}

// ADC.OVER: Overrun Status Register
func (o *ADC_Type) SetOVER_OVRE0(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetOVER_OVRE0() uint32 {
	return volatile.LoadUint32(&o.OVER.Reg) & 0x1
}
func (o *ADC_Type) SetOVER_OVRE1(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetOVER_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetOVER_OVRE2(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetOVER_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetOVER_OVRE3(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetOVER_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetOVER_OVRE4(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetOVER_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetOVER_OVRE5(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetOVER_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetOVER_OVRE6(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetOVER_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetOVER_OVRE7(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetOVER_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetOVER_OVRE8(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetOVER_OVRE8() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetOVER_OVRE9(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetOVER_OVRE9() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetOVER_OVRE10(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetOVER_OVRE10() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetOVER_OVRE11(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetOVER_OVRE11() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x800) >> 11
}

// ADC.EMR: Extended Mode Register
func (o *ADC_Type) SetEMR_CMPMODE(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetEMR_CMPMODE() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x3
}
func (o *ADC_Type) SetEMR_CMPSEL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetEMR_CMPSEL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetEMR_CMPALL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetEMR_CMPALL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetEMR_CMPFILTER(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x3000)|value<<12)
}
func (o *ADC_Type) GetEMR_CMPFILTER() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x3000) >> 12
}
func (o *ADC_Type) SetEMR_TAG(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetEMR_TAG() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x1000000) >> 24
}

// ADC.CWR: Compare Window Register
func (o *ADC_Type) SetCWR_LOWTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetCWR_LOWTHRES() uint32 {
	return volatile.LoadUint32(&o.CWR.Reg) & 0xfff
}
func (o *ADC_Type) SetCWR_HIGHTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetCWR_HIGHTHRES() uint32 {
	return (volatile.LoadUint32(&o.CWR.Reg) & 0xfff0000) >> 16
}

// ADC.CGR: Channel Gain Register
func (o *ADC_Type) SetCGR_GAIN0(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetCGR_GAIN0() uint32 {
	return volatile.LoadUint32(&o.CGR.Reg) & 0x3
}
func (o *ADC_Type) SetCGR_GAIN1(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc)|value<<2)
}
func (o *ADC_Type) GetCGR_GAIN1() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc) >> 2
}
func (o *ADC_Type) SetCGR_GAIN2(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x30)|value<<4)
}
func (o *ADC_Type) GetCGR_GAIN2() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x30) >> 4
}
func (o *ADC_Type) SetCGR_GAIN3(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc0)|value<<6)
}
func (o *ADC_Type) GetCGR_GAIN3() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc0) >> 6
}
func (o *ADC_Type) SetCGR_GAIN4(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x300)|value<<8)
}
func (o *ADC_Type) GetCGR_GAIN4() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x300) >> 8
}
func (o *ADC_Type) SetCGR_GAIN5(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc00)|value<<10)
}
func (o *ADC_Type) GetCGR_GAIN5() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc00) >> 10
}
func (o *ADC_Type) SetCGR_GAIN6(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x3000)|value<<12)
}
func (o *ADC_Type) GetCGR_GAIN6() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x3000) >> 12
}
func (o *ADC_Type) SetCGR_GAIN7(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc000)|value<<14)
}
func (o *ADC_Type) GetCGR_GAIN7() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc000) >> 14
}
func (o *ADC_Type) SetCGR_GAIN8(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x30000)|value<<16)
}
func (o *ADC_Type) GetCGR_GAIN8() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x30000) >> 16
}
func (o *ADC_Type) SetCGR_GAIN9(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc0000)|value<<18)
}
func (o *ADC_Type) GetCGR_GAIN9() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc0000) >> 18
}
func (o *ADC_Type) SetCGR_GAIN10(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetCGR_GAIN10() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetCGR_GAIN11(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc00000)|value<<22)
}
func (o *ADC_Type) GetCGR_GAIN11() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc00000) >> 22
}

// ADC.COR: Channel Offset Register
func (o *ADC_Type) SetCOR_OFF0(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCOR_OFF0() uint32 {
	return volatile.LoadUint32(&o.COR.Reg) & 0x1
}
func (o *ADC_Type) SetCOR_OFF1(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCOR_OFF1() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCOR_OFF2(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCOR_OFF2() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCOR_OFF3(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCOR_OFF3() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCOR_OFF4(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCOR_OFF4() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCOR_OFF5(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCOR_OFF5() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCOR_OFF6(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCOR_OFF6() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCOR_OFF7(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCOR_OFF7() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCOR_OFF8(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCOR_OFF8() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCOR_OFF9(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCOR_OFF9() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCOR_OFF10(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCOR_OFF10() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCOR_OFF11(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCOR_OFF11() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCOR_DIFF0(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCOR_DIFF0() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCOR_DIFF1(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetCOR_DIFF1() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetCOR_DIFF2(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetCOR_DIFF2() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetCOR_DIFF3(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetCOR_DIFF3() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x80000) >> 19
}
func (o *ADC_Type) SetCOR_DIFF4(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetCOR_DIFF4() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetCOR_DIFF5(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetCOR_DIFF5() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetCOR_DIFF6(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCOR_DIFF6() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCOR_DIFF7(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCOR_DIFF7() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCOR_DIFF8(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetCOR_DIFF8() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetCOR_DIFF9(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetCOR_DIFF9() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetCOR_DIFF10(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetCOR_DIFF10() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetCOR_DIFF11(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetCOR_DIFF11() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x8000000) >> 27
}

// ADC.CDR: Channel Data Register
func (o *ADC_Type) SetCDR_DATA(idx int, value uint32) {
	volatile.StoreUint32(&o.CDR[idx].Reg, volatile.LoadUint32(&o.CDR[idx].Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetCDR_DATA(idx int) uint32 {
	return volatile.LoadUint32(&o.CDR[idx].Reg) & 0xfff
}

// ADC.ACR: Analog Control Register
func (o *ADC_Type) SetACR_PENDETSENS(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetACR_PENDETSENS() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x3
}

// ADC.TSMR: Touchscreen Mode Register
func (o *ADC_Type) SetTSMR_TSMODE(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetTSMR_TSMODE() uint32 {
	return volatile.LoadUint32(&o.TSMR.Reg) & 0x3
}
func (o *ADC_Type) SetTSMR_TSAV(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0x30)|value<<4)
}
func (o *ADC_Type) GetTSMR_TSAV() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0x30) >> 4
}
func (o *ADC_Type) SetTSMR_TSFREQ(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetTSMR_TSFREQ() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0xf00) >> 8
}
func (o *ADC_Type) SetTSMR_TSSCTIM(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetTSMR_TSSCTIM() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetTSMR_NOTSDMA(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetTSMR_NOTSDMA() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetTSMR_PENDET(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetTSMR_PENDET() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetTSMR_PENDBC(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetTSMR_PENDBC() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0xf0000000) >> 28
}

// ADC.XPOSR: Touchscreen X Position Register
func (o *ADC_Type) SetXPOSR_XPOS(value uint32) {
	volatile.StoreUint32(&o.XPOSR.Reg, volatile.LoadUint32(&o.XPOSR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetXPOSR_XPOS() uint32 {
	return volatile.LoadUint32(&o.XPOSR.Reg) & 0xfff
}
func (o *ADC_Type) SetXPOSR_XSCALE(value uint32) {
	volatile.StoreUint32(&o.XPOSR.Reg, volatile.LoadUint32(&o.XPOSR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetXPOSR_XSCALE() uint32 {
	return (volatile.LoadUint32(&o.XPOSR.Reg) & 0xfff0000) >> 16
}

// ADC.YPOSR: Touchscreen Y Position Register
func (o *ADC_Type) SetYPOSR_YPOS(value uint32) {
	volatile.StoreUint32(&o.YPOSR.Reg, volatile.LoadUint32(&o.YPOSR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetYPOSR_YPOS() uint32 {
	return volatile.LoadUint32(&o.YPOSR.Reg) & 0xfff
}
func (o *ADC_Type) SetYPOSR_YSCALE(value uint32) {
	volatile.StoreUint32(&o.YPOSR.Reg, volatile.LoadUint32(&o.YPOSR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetYPOSR_YSCALE() uint32 {
	return (volatile.LoadUint32(&o.YPOSR.Reg) & 0xfff0000) >> 16
}

// ADC.PRESSR: Touchscreen Pressure Register
func (o *ADC_Type) SetPRESSR_Z1(value uint32) {
	volatile.StoreUint32(&o.PRESSR.Reg, volatile.LoadUint32(&o.PRESSR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetPRESSR_Z1() uint32 {
	return volatile.LoadUint32(&o.PRESSR.Reg) & 0xfff
}
func (o *ADC_Type) SetPRESSR_Z2(value uint32) {
	volatile.StoreUint32(&o.PRESSR.Reg, volatile.LoadUint32(&o.PRESSR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetPRESSR_Z2() uint32 {
	return (volatile.LoadUint32(&o.PRESSR.Reg) & 0xfff0000) >> 16
}

// ADC.TRGR: Trigger Register
func (o *ADC_Type) SetTRGR_TRGMOD(value uint32) {
	volatile.StoreUint32(&o.TRGR.Reg, volatile.LoadUint32(&o.TRGR.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetTRGR_TRGMOD() uint32 {
	return volatile.LoadUint32(&o.TRGR.Reg) & 0x7
}
func (o *ADC_Type) SetTRGR_TRGPER(value uint32) {
	volatile.StoreUint32(&o.TRGR.Reg, volatile.LoadUint32(&o.TRGR.Reg)&^(0xffff0000)|value<<16)
}
func (o *ADC_Type) GetTRGR_TRGPER() uint32 {
	return (volatile.LoadUint32(&o.TRGR.Reg) & 0xffff0000) >> 16
}

// ADC.WPMR: Write Protect Mode Register
func (o *ADC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *ADC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ADC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// ADC.WPSR: Write Protect Status Register
func (o *ADC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *ADC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *ADC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Ethernet MAC 10/100
type EMAC_Type struct {
	NCR   volatile.Register32 // 0x0
	NCFGR volatile.Register32 // 0x4
	NSR   volatile.Register32 // 0x8
	_     [8]byte
	TSR   volatile.Register32 // 0x14
	RBQP  volatile.Register32 // 0x18
	TBQP  volatile.Register32 // 0x1C
	RSR   volatile.Register32 // 0x20
	ISR   volatile.Register32 // 0x24
	IER   volatile.Register32 // 0x28
	IDR   volatile.Register32 // 0x2C
	IMR   volatile.Register32 // 0x30
	MAN   volatile.Register32 // 0x34
	PTR   volatile.Register32 // 0x38
	PFR   volatile.Register32 // 0x3C
	FTO   volatile.Register32 // 0x40
	SCF   volatile.Register32 // 0x44
	MCF   volatile.Register32 // 0x48
	FRO   volatile.Register32 // 0x4C
	FCSE  volatile.Register32 // 0x50
	ALE   volatile.Register32 // 0x54
	DTF   volatile.Register32 // 0x58
	LCOL  volatile.Register32 // 0x5C
	ECOL  volatile.Register32 // 0x60
	TUND  volatile.Register32 // 0x64
	CSE   volatile.Register32 // 0x68
	RRE   volatile.Register32 // 0x6C
	ROV   volatile.Register32 // 0x70
	RSE   volatile.Register32 // 0x74
	ELE   volatile.Register32 // 0x78
	RJA   volatile.Register32 // 0x7C
	USF   volatile.Register32 // 0x80
	STE   volatile.Register32 // 0x84
	RLE   volatile.Register32 // 0x88
	_     [4]byte
	HRB   volatile.Register32 // 0x90
	HRT   volatile.Register32 // 0x94
	SA1B  volatile.Register32 // 0x98
	SA1T  volatile.Register32 // 0x9C
	SA2B  volatile.Register32 // 0xA0
	SA2T  volatile.Register32 // 0xA4
	SA3B  volatile.Register32 // 0xA8
	SA3T  volatile.Register32 // 0xAC
	SA4B  volatile.Register32 // 0xB0
	SA4T  volatile.Register32 // 0xB4
	TID   volatile.Register32 // 0xB8
	_     [4]byte
	USRIO volatile.Register32 // 0xC0
	WOL   volatile.Register32 // 0xC4
}

// EMAC.NCR: Network Control Register
func (o *EMAC_Type) SetNCR_LB(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetNCR_LB() uint32 {
	return volatile.LoadUint32(&o.NCR.Reg) & 0x1
}
func (o *EMAC_Type) SetNCR_LLB(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetNCR_LLB() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetNCR_RE(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetNCR_RE() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetNCR_TE(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetNCR_TE() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetNCR_MPE(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetNCR_MPE() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetNCR_CLRSTAT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetNCR_CLRSTAT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetNCR_INCSTAT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetNCR_INCSTAT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetNCR_WESTAT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetNCR_WESTAT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetNCR_BP(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x100)|value<<8)
}
func (o *EMAC_Type) GetNCR_BP() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x100) >> 8
}
func (o *EMAC_Type) SetNCR_TSTART(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x200)|value<<9)
}
func (o *EMAC_Type) GetNCR_TSTART() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x200) >> 9
}
func (o *EMAC_Type) SetNCR_THALT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetNCR_THALT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x400) >> 10
}

// EMAC.NCFGR: Network Configuration Register
func (o *EMAC_Type) SetNCFGR_SPD(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetNCFGR_SPD() uint32 {
	return volatile.LoadUint32(&o.NCFGR.Reg) & 0x1
}
func (o *EMAC_Type) SetNCFGR_FD(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetNCFGR_FD() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetNCFGR_JFRAME(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetNCFGR_JFRAME() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetNCFGR_CAF(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetNCFGR_CAF() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetNCFGR_NBC(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetNCFGR_NBC() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetNCFGR_MTI(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetNCFGR_MTI() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetNCFGR_UNI(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetNCFGR_UNI() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetNCFGR_BIG(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x100)|value<<8)
}
func (o *EMAC_Type) GetNCFGR_BIG() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x100) >> 8
}
func (o *EMAC_Type) SetNCFGR_CLK(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0xc00)|value<<10)
}
func (o *EMAC_Type) GetNCFGR_CLK() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0xc00) >> 10
}
func (o *EMAC_Type) SetNCFGR_RTY(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetNCFGR_RTY() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetNCFGR_PAE(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetNCFGR_PAE() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x2000) >> 13
}
func (o *EMAC_Type) SetNCFGR_RBOF(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0xc000)|value<<14)
}
func (o *EMAC_Type) GetNCFGR_RBOF() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0xc000) >> 14
}
func (o *EMAC_Type) SetNCFGR_RLCE(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x10000)|value<<16)
}
func (o *EMAC_Type) GetNCFGR_RLCE() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x10000) >> 16
}
func (o *EMAC_Type) SetNCFGR_DRFCS(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x20000)|value<<17)
}
func (o *EMAC_Type) GetNCFGR_DRFCS() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x20000) >> 17
}
func (o *EMAC_Type) SetNCFGR_EFRHD(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x40000)|value<<18)
}
func (o *EMAC_Type) GetNCFGR_EFRHD() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x40000) >> 18
}
func (o *EMAC_Type) SetNCFGR_IRXFCS(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x80000)|value<<19)
}
func (o *EMAC_Type) GetNCFGR_IRXFCS() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x80000) >> 19
}

// EMAC.NSR: Network Status Register
func (o *EMAC_Type) SetNSR_MDIO(value uint32) {
	volatile.StoreUint32(&o.NSR.Reg, volatile.LoadUint32(&o.NSR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetNSR_MDIO() uint32 {
	return (volatile.LoadUint32(&o.NSR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetNSR_IDLE(value uint32) {
	volatile.StoreUint32(&o.NSR.Reg, volatile.LoadUint32(&o.NSR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetNSR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.NSR.Reg) & 0x4) >> 2
}

// EMAC.TSR: Transmit Status Register
func (o *EMAC_Type) SetTSR_UBR(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetTSR_UBR() uint32 {
	return volatile.LoadUint32(&o.TSR.Reg) & 0x1
}
func (o *EMAC_Type) SetTSR_COL(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetTSR_COL() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetTSR_RLES(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetTSR_RLES() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetTSR_TGO(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetTSR_TGO() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetTSR_BEX(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetTSR_BEX() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetTSR_COMP(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetTSR_COMP() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetTSR_UND(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetTSR_UND() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40) >> 6
}

// EMAC.RBQP: Receive Buffer Queue Pointer Register
func (o *EMAC_Type) SetRBQP_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBQP.Reg, volatile.LoadUint32(&o.RBQP.Reg)&^(0xfffffffc)|value<<2)
}
func (o *EMAC_Type) GetRBQP_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBQP.Reg) & 0xfffffffc) >> 2
}

// EMAC.TBQP: Transmit Buffer Queue Pointer Register
func (o *EMAC_Type) SetTBQP_ADDR(value uint32) {
	volatile.StoreUint32(&o.TBQP.Reg, volatile.LoadUint32(&o.TBQP.Reg)&^(0xfffffffc)|value<<2)
}
func (o *EMAC_Type) GetTBQP_ADDR() uint32 {
	return (volatile.LoadUint32(&o.TBQP.Reg) & 0xfffffffc) >> 2
}

// EMAC.RSR: Receive Status Register
func (o *EMAC_Type) SetRSR_BNA(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetRSR_BNA() uint32 {
	return volatile.LoadUint32(&o.RSR.Reg) & 0x1
}
func (o *EMAC_Type) SetRSR_REC(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetRSR_REC() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetRSR_OVR(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetRSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x4) >> 2
}

// EMAC.ISR: Interrupt Status Register
func (o *EMAC_Type) SetISR_MFD(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetISR_MFD() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *EMAC_Type) SetISR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetISR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetISR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetISR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetISR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetISR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetISR_TUND(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetISR_TUND() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetISR_RLEX(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetISR_RLEX() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetISR_TXERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetISR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetISR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetISR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetISR_ROVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetISR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetISR_HRESP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetISR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetISR_PFRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetISR_PFRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetISR_PTZ(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetISR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *EMAC_Type) SetISR_WOL(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *EMAC_Type) GetISR_WOL() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}

// EMAC.IER: Interrupt Enable Register
func (o *EMAC_Type) SetIER_MFD(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetIER_MFD() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *EMAC_Type) SetIER_RCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetIER_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetIER_RXUBR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetIER_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetIER_TXUBR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetIER_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetIER_TUND(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetIER_TUND() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetIER_RLE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetIER_RLE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetIER_TXERR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetIER_TXERR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetIER_TCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetIER_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetIER_ROVR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetIER_ROVR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetIER_HRESP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetIER_HRESP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetIER_PFR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetIER_PFR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetIER_PTZ(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetIER_PTZ() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *EMAC_Type) SetIER_WOL(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *EMAC_Type) GetIER_WOL() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}

// EMAC.IDR: Interrupt Disable Register
func (o *EMAC_Type) SetIDR_MFD(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetIDR_MFD() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *EMAC_Type) SetIDR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetIDR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetIDR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetIDR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetIDR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetIDR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetIDR_TUND(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetIDR_TUND() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetIDR_RLE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetIDR_RLE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetIDR_TXERR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetIDR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetIDR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetIDR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetIDR_ROVR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetIDR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetIDR_HRESP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetIDR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetIDR_PFR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetIDR_PFR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetIDR_PTZ(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetIDR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *EMAC_Type) SetIDR_WOL(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *EMAC_Type) GetIDR_WOL() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}

// EMAC.IMR: Interrupt Mask Register
func (o *EMAC_Type) SetIMR_MFD(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetIMR_MFD() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *EMAC_Type) SetIMR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetIMR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetIMR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetIMR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetIMR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetIMR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetIMR_TUND(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetIMR_TUND() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetIMR_RLE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetIMR_RLE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetIMR_TXERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetIMR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetIMR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetIMR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetIMR_ROVR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetIMR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetIMR_HRESP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetIMR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetIMR_PFR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetIMR_PFR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetIMR_PTZ(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetIMR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *EMAC_Type) SetIMR_WOL(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *EMAC_Type) GetIMR_WOL() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}

// EMAC.MAN: Phy Maintenance Register
func (o *EMAC_Type) SetMAN_DATA(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetMAN_DATA() uint32 {
	return volatile.LoadUint32(&o.MAN.Reg) & 0xffff
}
func (o *EMAC_Type) SetMAN_CODE(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x30000)|value<<16)
}
func (o *EMAC_Type) GetMAN_CODE() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x30000) >> 16
}
func (o *EMAC_Type) SetMAN_REGA(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x7c0000)|value<<18)
}
func (o *EMAC_Type) GetMAN_REGA() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x7c0000) >> 18
}
func (o *EMAC_Type) SetMAN_PHYA(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf800000)|value<<23)
}
func (o *EMAC_Type) GetMAN_PHYA() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xf800000) >> 23
}
func (o *EMAC_Type) SetMAN_RW(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x30000000)|value<<28)
}
func (o *EMAC_Type) GetMAN_RW() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x30000000) >> 28
}
func (o *EMAC_Type) SetMAN_SOF(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xc0000000)|value<<30)
}
func (o *EMAC_Type) GetMAN_SOF() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xc0000000) >> 30
}

// EMAC.PTR: Pause Time Register
func (o *EMAC_Type) SetPTR_PTIME(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, volatile.LoadUint32(&o.PTR.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetPTR_PTIME() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg) & 0xffff
}

// EMAC.PFR: Pause Frames Received Register
func (o *EMAC_Type) SetPFR_FROK(value uint32) {
	volatile.StoreUint32(&o.PFR.Reg, volatile.LoadUint32(&o.PFR.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetPFR_FROK() uint32 {
	return volatile.LoadUint32(&o.PFR.Reg) & 0xffff
}

// EMAC.FTO: Frames Transmitted Ok Register
func (o *EMAC_Type) SetFTO_FTOK(value uint32) {
	volatile.StoreUint32(&o.FTO.Reg, volatile.LoadUint32(&o.FTO.Reg)&^(0xffffff)|value)
}
func (o *EMAC_Type) GetFTO_FTOK() uint32 {
	return volatile.LoadUint32(&o.FTO.Reg) & 0xffffff
}

// EMAC.SCF: Single Collision Frames Register
func (o *EMAC_Type) SetSCF(value uint32) {
	volatile.StoreUint32(&o.SCF.Reg, volatile.LoadUint32(&o.SCF.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSCF() uint32 {
	return volatile.LoadUint32(&o.SCF.Reg) & 0xffff
}

// EMAC.MCF: Multiple Collision Frames Register
func (o *EMAC_Type) SetMCF(value uint32) {
	volatile.StoreUint32(&o.MCF.Reg, volatile.LoadUint32(&o.MCF.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetMCF() uint32 {
	return volatile.LoadUint32(&o.MCF.Reg) & 0xffff
}

// EMAC.FRO: Frames Received Ok Register
func (o *EMAC_Type) SetFRO_FROK(value uint32) {
	volatile.StoreUint32(&o.FRO.Reg, volatile.LoadUint32(&o.FRO.Reg)&^(0xffffff)|value)
}
func (o *EMAC_Type) GetFRO_FROK() uint32 {
	return volatile.LoadUint32(&o.FRO.Reg) & 0xffffff
}

// EMAC.FCSE: Frame Check Sequence Errors Register
func (o *EMAC_Type) SetFCSE(value uint32) {
	volatile.StoreUint32(&o.FCSE.Reg, volatile.LoadUint32(&o.FCSE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetFCSE() uint32 {
	return volatile.LoadUint32(&o.FCSE.Reg) & 0xff
}

// EMAC.ALE: Alignment Errors Register
func (o *EMAC_Type) SetALE(value uint32) {
	volatile.StoreUint32(&o.ALE.Reg, volatile.LoadUint32(&o.ALE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetALE() uint32 {
	return volatile.LoadUint32(&o.ALE.Reg) & 0xff
}

// EMAC.DTF: Deferred Transmission Frames Register
func (o *EMAC_Type) SetDTF(value uint32) {
	volatile.StoreUint32(&o.DTF.Reg, volatile.LoadUint32(&o.DTF.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetDTF() uint32 {
	return volatile.LoadUint32(&o.DTF.Reg) & 0xffff
}

// EMAC.LCOL: Late Collisions Register
func (o *EMAC_Type) SetLCOL(value uint32) {
	volatile.StoreUint32(&o.LCOL.Reg, volatile.LoadUint32(&o.LCOL.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetLCOL() uint32 {
	return volatile.LoadUint32(&o.LCOL.Reg) & 0xff
}

// EMAC.ECOL: Excessive Collisions Register
func (o *EMAC_Type) SetECOL_EXCOL(value uint32) {
	volatile.StoreUint32(&o.ECOL.Reg, volatile.LoadUint32(&o.ECOL.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetECOL_EXCOL() uint32 {
	return volatile.LoadUint32(&o.ECOL.Reg) & 0xff
}

// EMAC.TUND: Transmit Underrun Errors Register
func (o *EMAC_Type) SetTUND(value uint32) {
	volatile.StoreUint32(&o.TUND.Reg, volatile.LoadUint32(&o.TUND.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetTUND() uint32 {
	return volatile.LoadUint32(&o.TUND.Reg) & 0xff
}

// EMAC.CSE: Carrier Sense Errors Register
func (o *EMAC_Type) SetCSE(value uint32) {
	volatile.StoreUint32(&o.CSE.Reg, volatile.LoadUint32(&o.CSE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetCSE() uint32 {
	return volatile.LoadUint32(&o.CSE.Reg) & 0xff
}

// EMAC.RRE: Receive Resource Errors Register
func (o *EMAC_Type) SetRRE(value uint32) {
	volatile.StoreUint32(&o.RRE.Reg, volatile.LoadUint32(&o.RRE.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetRRE() uint32 {
	return volatile.LoadUint32(&o.RRE.Reg) & 0xffff
}

// EMAC.ROV: Receive Overrun Errors Register
func (o *EMAC_Type) SetROV_ROVR(value uint32) {
	volatile.StoreUint32(&o.ROV.Reg, volatile.LoadUint32(&o.ROV.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetROV_ROVR() uint32 {
	return volatile.LoadUint32(&o.ROV.Reg) & 0xff
}

// EMAC.RSE: Receive Symbol Errors Register
func (o *EMAC_Type) SetRSE(value uint32) {
	volatile.StoreUint32(&o.RSE.Reg, volatile.LoadUint32(&o.RSE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetRSE() uint32 {
	return volatile.LoadUint32(&o.RSE.Reg) & 0xff
}

// EMAC.ELE: Excessive Length Errors Register
func (o *EMAC_Type) SetELE_EXL(value uint32) {
	volatile.StoreUint32(&o.ELE.Reg, volatile.LoadUint32(&o.ELE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetELE_EXL() uint32 {
	return volatile.LoadUint32(&o.ELE.Reg) & 0xff
}

// EMAC.RJA: Receive Jabbers Register
func (o *EMAC_Type) SetRJA_RJB(value uint32) {
	volatile.StoreUint32(&o.RJA.Reg, volatile.LoadUint32(&o.RJA.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetRJA_RJB() uint32 {
	return volatile.LoadUint32(&o.RJA.Reg) & 0xff
}

// EMAC.USF: Undersize Frames Register
func (o *EMAC_Type) SetUSF(value uint32) {
	volatile.StoreUint32(&o.USF.Reg, volatile.LoadUint32(&o.USF.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetUSF() uint32 {
	return volatile.LoadUint32(&o.USF.Reg) & 0xff
}

// EMAC.STE: SQE Test Errors Register
func (o *EMAC_Type) SetSTE_SQER(value uint32) {
	volatile.StoreUint32(&o.STE.Reg, volatile.LoadUint32(&o.STE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetSTE_SQER() uint32 {
	return volatile.LoadUint32(&o.STE.Reg) & 0xff
}

// EMAC.RLE: Received Length Field Mismatch Register
func (o *EMAC_Type) SetRLE_RLFM(value uint32) {
	volatile.StoreUint32(&o.RLE.Reg, volatile.LoadUint32(&o.RLE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetRLE_RLFM() uint32 {
	return volatile.LoadUint32(&o.RLE.Reg) & 0xff
}

// EMAC.HRB: Hash Register Bottom [31:0] Register
func (o *EMAC_Type) SetHRB(value uint32) {
	volatile.StoreUint32(&o.HRB.Reg, value)
}
func (o *EMAC_Type) GetHRB() uint32 {
	return volatile.LoadUint32(&o.HRB.Reg)
}

// EMAC.HRT: Hash Register Top [63:32] Register
func (o *EMAC_Type) SetHRT(value uint32) {
	volatile.StoreUint32(&o.HRT.Reg, value)
}
func (o *EMAC_Type) GetHRT() uint32 {
	return volatile.LoadUint32(&o.HRT.Reg)
}

// EMAC.SA1B: Specific Address 1 Bottom Register
func (o *EMAC_Type) SetSA1B(value uint32) {
	volatile.StoreUint32(&o.SA1B.Reg, value)
}
func (o *EMAC_Type) GetSA1B() uint32 {
	return volatile.LoadUint32(&o.SA1B.Reg)
}

// EMAC.SA1T: Specific Address 1 Top Register
func (o *EMAC_Type) SetSA1T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA1T.Reg, volatile.LoadUint32(&o.SA1T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA1T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA1T.Reg) & 0xffff
}

// EMAC.SA2B: Specific Address 2 Bottom Register
func (o *EMAC_Type) SetSA2B(value uint32) {
	volatile.StoreUint32(&o.SA2B.Reg, value)
}
func (o *EMAC_Type) GetSA2B() uint32 {
	return volatile.LoadUint32(&o.SA2B.Reg)
}

// EMAC.SA2T: Specific Address 2 Top Register
func (o *EMAC_Type) SetSA2T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA2T.Reg, volatile.LoadUint32(&o.SA2T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA2T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA2T.Reg) & 0xffff
}

// EMAC.SA3B: Specific Address 3 Bottom Register
func (o *EMAC_Type) SetSA3B(value uint32) {
	volatile.StoreUint32(&o.SA3B.Reg, value)
}
func (o *EMAC_Type) GetSA3B() uint32 {
	return volatile.LoadUint32(&o.SA3B.Reg)
}

// EMAC.SA3T: Specific Address 3 Top Register
func (o *EMAC_Type) SetSA3T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA3T.Reg, volatile.LoadUint32(&o.SA3T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA3T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA3T.Reg) & 0xffff
}

// EMAC.SA4B: Specific Address 4 Bottom Register
func (o *EMAC_Type) SetSA4B(value uint32) {
	volatile.StoreUint32(&o.SA4B.Reg, value)
}
func (o *EMAC_Type) GetSA4B() uint32 {
	return volatile.LoadUint32(&o.SA4B.Reg)
}

// EMAC.SA4T: Specific Address 4 Top Register
func (o *EMAC_Type) SetSA4T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA4T.Reg, volatile.LoadUint32(&o.SA4T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA4T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA4T.Reg) & 0xffff
}

// EMAC.TID: Type ID Checking Register
func (o *EMAC_Type) SetTID(value uint32) {
	volatile.StoreUint32(&o.TID.Reg, volatile.LoadUint32(&o.TID.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetTID() uint32 {
	return volatile.LoadUint32(&o.TID.Reg) & 0xffff
}

// EMAC.USRIO: User Input/Output Register
func (o *EMAC_Type) SetUSRIO_RMII(value uint32) {
	volatile.StoreUint32(&o.USRIO.Reg, volatile.LoadUint32(&o.USRIO.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetUSRIO_RMII() uint32 {
	return volatile.LoadUint32(&o.USRIO.Reg) & 0x1
}
func (o *EMAC_Type) SetUSRIO_CLKEN(value uint32) {
	volatile.StoreUint32(&o.USRIO.Reg, volatile.LoadUint32(&o.USRIO.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetUSRIO_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.USRIO.Reg) & 0x2) >> 1
}

// EMAC.WOL: Wake on LAN Register
func (o *EMAC_Type) SetWOL_IP(value uint32) {
	volatile.StoreUint32(&o.WOL.Reg, volatile.LoadUint32(&o.WOL.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetWOL_IP() uint32 {
	return volatile.LoadUint32(&o.WOL.Reg) & 0xffff
}
func (o *EMAC_Type) SetWOL_MAG(value uint32) {
	volatile.StoreUint32(&o.WOL.Reg, volatile.LoadUint32(&o.WOL.Reg)&^(0x10000)|value<<16)
}
func (o *EMAC_Type) GetWOL_MAG() uint32 {
	return (volatile.LoadUint32(&o.WOL.Reg) & 0x10000) >> 16
}
func (o *EMAC_Type) SetWOL_ARP(value uint32) {
	volatile.StoreUint32(&o.WOL.Reg, volatile.LoadUint32(&o.WOL.Reg)&^(0x20000)|value<<17)
}
func (o *EMAC_Type) GetWOL_ARP() uint32 {
	return (volatile.LoadUint32(&o.WOL.Reg) & 0x20000) >> 17
}
func (o *EMAC_Type) SetWOL_SA1(value uint32) {
	volatile.StoreUint32(&o.WOL.Reg, volatile.LoadUint32(&o.WOL.Reg)&^(0x40000)|value<<18)
}
func (o *EMAC_Type) GetWOL_SA1() uint32 {
	return (volatile.LoadUint32(&o.WOL.Reg) & 0x40000) >> 18
}
func (o *EMAC_Type) SetWOL_MTI(value uint32) {
	volatile.StoreUint32(&o.WOL.Reg, volatile.LoadUint32(&o.WOL.Reg)&^(0x80000)|value<<19)
}
func (o *EMAC_Type) GetWOL_MTI() uint32 {
	return (volatile.LoadUint32(&o.WOL.Reg) & 0x80000) >> 19
}

// USB High Speed Device Port
type UDPHS_Type struct {
	CTRL        volatile.Register32 // 0x0
	FNUM        volatile.Register32 // 0x4
	_           [8]byte
	IEN         volatile.Register32 // 0x10
	INTSTA      volatile.Register32 // 0x14
	CLRINT      volatile.Register32 // 0x18
	EPTRST      volatile.Register32 // 0x1C
	_           [192]byte
	TST         volatile.Register32 // 0xE0
	_           [28]byte
	EPTCFG0     volatile.Register32 // 0x100
	EPTCTLENB0  volatile.Register32 // 0x104
	EPTCTLDIS0  volatile.Register32 // 0x108
	EPTCTL0     volatile.Register32 // 0x10C
	_           [4]byte
	EPTSETSTA0  volatile.Register32 // 0x114
	EPTCLRSTA0  volatile.Register32 // 0x118
	EPTSTA0     volatile.Register32 // 0x11C
	EPTCFG1     volatile.Register32 // 0x120
	EPTCTLENB1  volatile.Register32 // 0x124
	EPTCTLDIS1  volatile.Register32 // 0x128
	EPTCTL1     volatile.Register32 // 0x12C
	_           [4]byte
	EPTSETSTA1  volatile.Register32 // 0x134
	EPTCLRSTA1  volatile.Register32 // 0x138
	EPTSTA1     volatile.Register32 // 0x13C
	EPTCFG2     volatile.Register32 // 0x140
	EPTCTLENB2  volatile.Register32 // 0x144
	EPTCTLDIS2  volatile.Register32 // 0x148
	EPTCTL2     volatile.Register32 // 0x14C
	_           [4]byte
	EPTSETSTA2  volatile.Register32 // 0x154
	EPTCLRSTA2  volatile.Register32 // 0x158
	EPTSTA2     volatile.Register32 // 0x15C
	EPTCFG3     volatile.Register32 // 0x160
	EPTCTLENB3  volatile.Register32 // 0x164
	EPTCTLDIS3  volatile.Register32 // 0x168
	EPTCTL3     volatile.Register32 // 0x16C
	_           [4]byte
	EPTSETSTA3  volatile.Register32 // 0x174
	EPTCLRSTA3  volatile.Register32 // 0x178
	EPTSTA3     volatile.Register32 // 0x17C
	EPTCFG4     volatile.Register32 // 0x180
	EPTCTLENB4  volatile.Register32 // 0x184
	EPTCTLDIS4  volatile.Register32 // 0x188
	EPTCTL4     volatile.Register32 // 0x18C
	_           [4]byte
	EPTSETSTA4  volatile.Register32 // 0x194
	EPTCLRSTA4  volatile.Register32 // 0x198
	EPTSTA4     volatile.Register32 // 0x19C
	EPTCFG5     volatile.Register32 // 0x1A0
	EPTCTLENB5  volatile.Register32 // 0x1A4
	EPTCTLDIS5  volatile.Register32 // 0x1A8
	EPTCTL5     volatile.Register32 // 0x1AC
	_           [4]byte
	EPTSETSTA5  volatile.Register32 // 0x1B4
	EPTCLRSTA5  volatile.Register32 // 0x1B8
	EPTSTA5     volatile.Register32 // 0x1BC
	EPTCFG6     volatile.Register32 // 0x1C0
	EPTCTLENB6  volatile.Register32 // 0x1C4
	EPTCTLDIS6  volatile.Register32 // 0x1C8
	EPTCTL6     volatile.Register32 // 0x1CC
	_           [4]byte
	EPTSETSTA6  volatile.Register32 // 0x1D4
	EPTCLRSTA6  volatile.Register32 // 0x1D8
	EPTSTA6     volatile.Register32 // 0x1DC
	EPTCFG7     volatile.Register32 // 0x1E0
	EPTCTLENB7  volatile.Register32 // 0x1E4
	EPTCTLDIS7  volatile.Register32 // 0x1E8
	EPTCTL7     volatile.Register32 // 0x1EC
	_           [4]byte
	EPTSETSTA7  volatile.Register32 // 0x1F4
	EPTCLRSTA7  volatile.Register32 // 0x1F8
	EPTSTA7     volatile.Register32 // 0x1FC
	EPTCFG8     volatile.Register32 // 0x200
	EPTCTLENB8  volatile.Register32 // 0x204
	EPTCTLDIS8  volatile.Register32 // 0x208
	EPTCTL8     volatile.Register32 // 0x20C
	_           [4]byte
	EPTSETSTA8  volatile.Register32 // 0x214
	EPTCLRSTA8  volatile.Register32 // 0x218
	EPTSTA8     volatile.Register32 // 0x21C
	EPTCFG9     volatile.Register32 // 0x220
	EPTCTLENB9  volatile.Register32 // 0x224
	EPTCTLDIS9  volatile.Register32 // 0x228
	EPTCTL9     volatile.Register32 // 0x22C
	_           [4]byte
	EPTSETSTA9  volatile.Register32 // 0x234
	EPTCLRSTA9  volatile.Register32 // 0x238
	EPTSTA9     volatile.Register32 // 0x23C
	EPTCFG10    volatile.Register32 // 0x240
	EPTCTLENB10 volatile.Register32 // 0x244
	EPTCTLDIS10 volatile.Register32 // 0x248
	EPTCTL10    volatile.Register32 // 0x24C
	_           [4]byte
	EPTSETSTA10 volatile.Register32 // 0x254
	EPTCLRSTA10 volatile.Register32 // 0x258
	EPTSTA10    volatile.Register32 // 0x25C
	EPTCFG11    volatile.Register32 // 0x260
	EPTCTLENB11 volatile.Register32 // 0x264
	EPTCTLDIS11 volatile.Register32 // 0x268
	EPTCTL11    volatile.Register32 // 0x26C
	_           [4]byte
	EPTSETSTA11 volatile.Register32 // 0x274
	EPTCLRSTA11 volatile.Register32 // 0x278
	EPTSTA11    volatile.Register32 // 0x27C
	EPTCFG12    volatile.Register32 // 0x280
	EPTCTLENB12 volatile.Register32 // 0x284
	EPTCTLDIS12 volatile.Register32 // 0x288
	EPTCTL12    volatile.Register32 // 0x28C
	_           [4]byte
	EPTSETSTA12 volatile.Register32 // 0x294
	EPTCLRSTA12 volatile.Register32 // 0x298
	EPTSTA12    volatile.Register32 // 0x29C
	EPTCFG13    volatile.Register32 // 0x2A0
	EPTCTLENB13 volatile.Register32 // 0x2A4
	EPTCTLDIS13 volatile.Register32 // 0x2A8
	EPTCTL13    volatile.Register32 // 0x2AC
	_           [4]byte
	EPTSETSTA13 volatile.Register32 // 0x2B4
	EPTCLRSTA13 volatile.Register32 // 0x2B8
	EPTSTA13    volatile.Register32 // 0x2BC
	EPTCFG14    volatile.Register32 // 0x2C0
	EPTCTLENB14 volatile.Register32 // 0x2C4
	EPTCTLDIS14 volatile.Register32 // 0x2C8
	EPTCTL14    volatile.Register32 // 0x2CC
	_           [4]byte
	EPTSETSTA14 volatile.Register32 // 0x2D4
	EPTCLRSTA14 volatile.Register32 // 0x2D8
	EPTSTA14    volatile.Register32 // 0x2DC
	EPTCFG15    volatile.Register32 // 0x2E0
	EPTCTLENB15 volatile.Register32 // 0x2E4
	EPTCTLDIS15 volatile.Register32 // 0x2E8
	EPTCTL15    volatile.Register32 // 0x2EC
	_           [4]byte
	EPTSETSTA15 volatile.Register32 // 0x2F4
	EPTCLRSTA15 volatile.Register32 // 0x2F8
	EPTSTA15    volatile.Register32 // 0x2FC
	DMANXTDSC0  volatile.Register32 // 0x300
	DMAADDRESS0 volatile.Register32 // 0x304
	DMACONTROL0 volatile.Register32 // 0x308
	DMASTATUS0  volatile.Register32 // 0x30C
	DMANXTDSC1  volatile.Register32 // 0x310
	DMAADDRESS1 volatile.Register32 // 0x314
	DMACONTROL1 volatile.Register32 // 0x318
	DMASTATUS1  volatile.Register32 // 0x31C
	DMANXTDSC2  volatile.Register32 // 0x320
	DMAADDRESS2 volatile.Register32 // 0x324
	DMACONTROL2 volatile.Register32 // 0x328
	DMASTATUS2  volatile.Register32 // 0x32C
	DMANXTDSC3  volatile.Register32 // 0x330
	DMAADDRESS3 volatile.Register32 // 0x334
	DMACONTROL3 volatile.Register32 // 0x338
	DMASTATUS3  volatile.Register32 // 0x33C
	DMANXTDSC4  volatile.Register32 // 0x340
	DMAADDRESS4 volatile.Register32 // 0x344
	DMACONTROL4 volatile.Register32 // 0x348
	DMASTATUS4  volatile.Register32 // 0x34C
	DMANXTDSC5  volatile.Register32 // 0x350
	DMAADDRESS5 volatile.Register32 // 0x354
	DMACONTROL5 volatile.Register32 // 0x358
	DMASTATUS5  volatile.Register32 // 0x35C
	DMANXTDSC6  volatile.Register32 // 0x360
	DMAADDRESS6 volatile.Register32 // 0x364
	DMACONTROL6 volatile.Register32 // 0x368
	DMASTATUS6  volatile.Register32 // 0x36C
}

// UDPHS.CTRL: UDPHS Control Register
func (o *UDPHS_Type) SetCTRL_DEV_ADDR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x7f)|value)
}
func (o *UDPHS_Type) GetCTRL_DEV_ADDR() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x7f
}
func (o *UDPHS_Type) SetCTRL_FADDR_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetCTRL_FADDR_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetCTRL_EN_UDPHS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetCTRL_EN_UDPHS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetCTRL_DETACH(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetCTRL_DETACH() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetCTRL_REWAKEUP(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetCTRL_REWAKEUP() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetCTRL_PULLD_DIS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetCTRL_PULLD_DIS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800) >> 11
}

// UDPHS.FNUM: UDPHS Frame Number Register
func (o *UDPHS_Type) SetFNUM_MICRO_FRAME_NUM(value uint32) {
	volatile.StoreUint32(&o.FNUM.Reg, volatile.LoadUint32(&o.FNUM.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetFNUM_MICRO_FRAME_NUM() uint32 {
	return volatile.LoadUint32(&o.FNUM.Reg) & 0x7
}
func (o *UDPHS_Type) SetFNUM_FRAME_NUMBER(value uint32) {
	volatile.StoreUint32(&o.FNUM.Reg, volatile.LoadUint32(&o.FNUM.Reg)&^(0x3ff8)|value<<3)
}
func (o *UDPHS_Type) GetFNUM_FRAME_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.FNUM.Reg) & 0x3ff8) >> 3
}
func (o *UDPHS_Type) SetFNUM_FNUM_ERR(value uint32) {
	volatile.StoreUint32(&o.FNUM.Reg, volatile.LoadUint32(&o.FNUM.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetFNUM_FNUM_ERR() uint32 {
	return (volatile.LoadUint32(&o.FNUM.Reg) & 0x80000000) >> 31
}

// UDPHS.IEN: UDPHS Interrupt Enable Register
func (o *UDPHS_Type) SetIEN_DET_SUSPD(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetIEN_DET_SUSPD() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetIEN_MICRO_SOF(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetIEN_MICRO_SOF() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetIEN_INT_SOF(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetIEN_INT_SOF() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetIEN_ENDRESET(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetIEN_ENDRESET() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetIEN_WAKE_UP(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetIEN_WAKE_UP() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetIEN_ENDOFRSM(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetIEN_ENDOFRSM() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetIEN_UPSTR_RES(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetIEN_UPSTR_RES() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetIEN_EPT_0(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetIEN_EPT_0() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetIEN_EPT_1(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetIEN_EPT_1() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetIEN_EPT_2(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetIEN_EPT_2() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetIEN_EPT_3(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetIEN_EPT_3() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetIEN_EPT_4(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetIEN_EPT_4() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetIEN_EPT_5(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetIEN_EPT_5() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetIEN_EPT_6(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetIEN_EPT_6() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetIEN_EPT_7(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetIEN_EPT_7() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetIEN_EPT_8(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x10000)|value<<16)
}
func (o *UDPHS_Type) GetIEN_EPT_8() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x10000) >> 16
}
func (o *UDPHS_Type) SetIEN_EPT_9(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x20000)|value<<17)
}
func (o *UDPHS_Type) GetIEN_EPT_9() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x20000) >> 17
}
func (o *UDPHS_Type) SetIEN_EPT_10(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetIEN_EPT_10() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetIEN_EPT_11(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x80000)|value<<19)
}
func (o *UDPHS_Type) GetIEN_EPT_11() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x80000) >> 19
}
func (o *UDPHS_Type) SetIEN_EPT_12(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x100000)|value<<20)
}
func (o *UDPHS_Type) GetIEN_EPT_12() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x100000) >> 20
}
func (o *UDPHS_Type) SetIEN_EPT_13(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x200000)|value<<21)
}
func (o *UDPHS_Type) GetIEN_EPT_13() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x200000) >> 21
}
func (o *UDPHS_Type) SetIEN_EPT_14(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x400000)|value<<22)
}
func (o *UDPHS_Type) GetIEN_EPT_14() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x400000) >> 22
}
func (o *UDPHS_Type) SetIEN_EPT_15(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x800000)|value<<23)
}
func (o *UDPHS_Type) GetIEN_EPT_15() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x800000) >> 23
}
func (o *UDPHS_Type) SetIEN_DMA_1(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x2000000)|value<<25)
}
func (o *UDPHS_Type) GetIEN_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x2000000) >> 25
}
func (o *UDPHS_Type) SetIEN_DMA_2(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x4000000)|value<<26)
}
func (o *UDPHS_Type) GetIEN_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x4000000) >> 26
}
func (o *UDPHS_Type) SetIEN_DMA_3(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x8000000)|value<<27)
}
func (o *UDPHS_Type) GetIEN_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x8000000) >> 27
}
func (o *UDPHS_Type) SetIEN_DMA_4(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x10000000)|value<<28)
}
func (o *UDPHS_Type) GetIEN_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x10000000) >> 28
}
func (o *UDPHS_Type) SetIEN_DMA_5(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x20000000)|value<<29)
}
func (o *UDPHS_Type) GetIEN_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x20000000) >> 29
}
func (o *UDPHS_Type) SetIEN_DMA_6(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x40000000)|value<<30)
}
func (o *UDPHS_Type) GetIEN_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x40000000) >> 30
}
func (o *UDPHS_Type) SetIEN_DMA_7(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetIEN_DMA_7() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x80000000) >> 31
}

// UDPHS.INTSTA: UDPHS Interrupt Status Register
func (o *UDPHS_Type) SetINTSTA_SPEED(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetINTSTA_SPEED() uint32 {
	return volatile.LoadUint32(&o.INTSTA.Reg) & 0x1
}
func (o *UDPHS_Type) SetINTSTA_DET_SUSPD(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetINTSTA_DET_SUSPD() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetINTSTA_MICRO_SOF(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetINTSTA_MICRO_SOF() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetINTSTA_INT_SOF(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetINTSTA_INT_SOF() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetINTSTA_ENDRESET(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetINTSTA_ENDRESET() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetINTSTA_WAKE_UP(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetINTSTA_WAKE_UP() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetINTSTA_ENDOFRSM(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetINTSTA_ENDOFRSM() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetINTSTA_UPSTR_RES(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetINTSTA_UPSTR_RES() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetINTSTA_EPT_0(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetINTSTA_EPT_0() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetINTSTA_EPT_1(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetINTSTA_EPT_1() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetINTSTA_EPT_2(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetINTSTA_EPT_2() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetINTSTA_EPT_3(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetINTSTA_EPT_3() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetINTSTA_EPT_4(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetINTSTA_EPT_4() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetINTSTA_EPT_5(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetINTSTA_EPT_5() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetINTSTA_EPT_6(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetINTSTA_EPT_6() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetINTSTA_EPT_7(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetINTSTA_EPT_7() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetINTSTA_EPT_8(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x10000)|value<<16)
}
func (o *UDPHS_Type) GetINTSTA_EPT_8() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x10000) >> 16
}
func (o *UDPHS_Type) SetINTSTA_EPT_9(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x20000)|value<<17)
}
func (o *UDPHS_Type) GetINTSTA_EPT_9() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x20000) >> 17
}
func (o *UDPHS_Type) SetINTSTA_EPT_10(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetINTSTA_EPT_10() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetINTSTA_EPT_11(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x80000)|value<<19)
}
func (o *UDPHS_Type) GetINTSTA_EPT_11() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x80000) >> 19
}
func (o *UDPHS_Type) SetINTSTA_EPT_12(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x100000)|value<<20)
}
func (o *UDPHS_Type) GetINTSTA_EPT_12() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x100000) >> 20
}
func (o *UDPHS_Type) SetINTSTA_EPT_13(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x200000)|value<<21)
}
func (o *UDPHS_Type) GetINTSTA_EPT_13() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x200000) >> 21
}
func (o *UDPHS_Type) SetINTSTA_EPT_14(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x400000)|value<<22)
}
func (o *UDPHS_Type) GetINTSTA_EPT_14() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x400000) >> 22
}
func (o *UDPHS_Type) SetINTSTA_EPT_15(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x800000)|value<<23)
}
func (o *UDPHS_Type) GetINTSTA_EPT_15() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x800000) >> 23
}
func (o *UDPHS_Type) SetINTSTA_DMA_1(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x2000000)|value<<25)
}
func (o *UDPHS_Type) GetINTSTA_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x2000000) >> 25
}
func (o *UDPHS_Type) SetINTSTA_DMA_2(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x4000000)|value<<26)
}
func (o *UDPHS_Type) GetINTSTA_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x4000000) >> 26
}
func (o *UDPHS_Type) SetINTSTA_DMA_3(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x8000000)|value<<27)
}
func (o *UDPHS_Type) GetINTSTA_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x8000000) >> 27
}
func (o *UDPHS_Type) SetINTSTA_DMA_4(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x10000000)|value<<28)
}
func (o *UDPHS_Type) GetINTSTA_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x10000000) >> 28
}
func (o *UDPHS_Type) SetINTSTA_DMA_5(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x20000000)|value<<29)
}
func (o *UDPHS_Type) GetINTSTA_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x20000000) >> 29
}
func (o *UDPHS_Type) SetINTSTA_DMA_6(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x40000000)|value<<30)
}
func (o *UDPHS_Type) GetINTSTA_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x40000000) >> 30
}
func (o *UDPHS_Type) SetINTSTA_DMA_7(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetINTSTA_DMA_7() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x80000000) >> 31
}

// UDPHS.CLRINT: UDPHS Clear Interrupt Register
func (o *UDPHS_Type) SetCLRINT_DET_SUSPD(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetCLRINT_DET_SUSPD() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetCLRINT_MICRO_SOF(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetCLRINT_MICRO_SOF() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetCLRINT_INT_SOF(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetCLRINT_INT_SOF() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetCLRINT_ENDRESET(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetCLRINT_ENDRESET() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetCLRINT_WAKE_UP(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetCLRINT_WAKE_UP() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetCLRINT_ENDOFRSM(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetCLRINT_ENDOFRSM() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetCLRINT_UPSTR_RES(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetCLRINT_UPSTR_RES() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x80) >> 7
}

// UDPHS.EPTRST: UDPHS Endpoints Reset Register
func (o *UDPHS_Type) SetEPTRST_EPT_0(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTRST_EPT_0() uint32 {
	return volatile.LoadUint32(&o.EPTRST.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTRST_EPT_1(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTRST_EPT_1() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTRST_EPT_2(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetEPTRST_EPT_2() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetEPTRST_EPT_3(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTRST_EPT_3() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTRST_EPT_4(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTRST_EPT_4() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTRST_EPT_5(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTRST_EPT_5() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTRST_EPT_6(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTRST_EPT_6() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTRST_EPT_7(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetEPTRST_EPT_7() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetEPTRST_EPT_8(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTRST_EPT_8() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTRST_EPT_9(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTRST_EPT_9() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTRST_EPT_10(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTRST_EPT_10() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTRST_EPT_11(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTRST_EPT_11() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTRST_EPT_12(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTRST_EPT_12() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTRST_EPT_13(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTRST_EPT_13() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTRST_EPT_14(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTRST_EPT_14() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTRST_EPT_15(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTRST_EPT_15() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x8000) >> 15
}

// UDPHS.TST: UDPHS Test Register
func (o *UDPHS_Type) SetTST_SPEED_CFG(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x3)|value)
}
func (o *UDPHS_Type) GetTST_SPEED_CFG() uint32 {
	return volatile.LoadUint32(&o.TST.Reg) & 0x3
}
func (o *UDPHS_Type) SetTST_TST_J(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetTST_TST_J() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetTST_TST_K(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetTST_TST_K() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetTST_TST_PKT(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetTST_TST_PKT() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetTST_OPMODE2(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetTST_OPMODE2() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x20) >> 5
}

// UDPHS.EPTCFG0: UDPHS Endpoint Configuration Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCFG0_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG0_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG0_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG0_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG0_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG0_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG0_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG0_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB0: UDPHS Endpoint Control Enable Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCTLENB0_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB0_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB0_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB0_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB0_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB0_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB0_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB0_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB0_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB0_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS0: UDPHS Endpoint Control Disable Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCTLDIS0_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS0_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS0_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS0_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS0_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL0: UDPHS Endpoint Control Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCTL0_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL0_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL0_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL0_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL0_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL0_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL0_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL0_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL0_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL0_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA0: UDPHS Endpoint Set Status Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTSETSTA0_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA0.Reg, volatile.LoadUint32(&o.EPTSETSTA0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA0_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA0.Reg, volatile.LoadUint32(&o.EPTSETSTA0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA0.Reg, volatile.LoadUint32(&o.EPTSETSTA0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA0.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA0: UDPHS Endpoint Clear Status Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCLRSTA0_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA0_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA0: UDPHS Endpoint Status Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTSTA0_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA0_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA0_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA0_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA0_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA0_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA0_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA0_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA0_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA0_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG1: UDPHS Endpoint Configuration Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCFG1_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG1_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG1_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG1_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG1_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG1_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG1_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG1_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB1: UDPHS Endpoint Control Enable Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCTLENB1_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB1_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB1_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB1_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB1_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB1_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB1_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB1_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB1_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB1_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS1: UDPHS Endpoint Control Disable Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCTLDIS1_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS1_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS1_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS1_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS1_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL1: UDPHS Endpoint Control Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCTL1_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL1_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL1_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL1_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL1_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL1_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL1_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL1_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL1_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL1_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA1: UDPHS Endpoint Set Status Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTSETSTA1_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA1.Reg, volatile.LoadUint32(&o.EPTSETSTA1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA1_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA1.Reg, volatile.LoadUint32(&o.EPTSETSTA1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA1.Reg, volatile.LoadUint32(&o.EPTSETSTA1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA1.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA1: UDPHS Endpoint Clear Status Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCLRSTA1_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA1_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA1: UDPHS Endpoint Status Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTSTA1_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA1_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA1_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA1_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA1_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA1_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA1_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA1_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA1_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA1_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG2: UDPHS Endpoint Configuration Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCFG2_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG2_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG2_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG2_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG2_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG2_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG2_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG2_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB2: UDPHS Endpoint Control Enable Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCTLENB2_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB2_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB2_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB2_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB2_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB2_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB2_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB2_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB2_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB2_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS2: UDPHS Endpoint Control Disable Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCTLDIS2_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS2_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS2_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS2_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS2_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL2: UDPHS Endpoint Control Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCTL2_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL2_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL2_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL2_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL2_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL2_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL2_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL2_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL2_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL2_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA2: UDPHS Endpoint Set Status Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTSETSTA2_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA2.Reg, volatile.LoadUint32(&o.EPTSETSTA2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA2_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA2.Reg, volatile.LoadUint32(&o.EPTSETSTA2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA2.Reg, volatile.LoadUint32(&o.EPTSETSTA2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA2.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA2: UDPHS Endpoint Clear Status Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCLRSTA2_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA2_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA2: UDPHS Endpoint Status Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTSTA2_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA2_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA2_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA2_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA2_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA2_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA2_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA2_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA2_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA2_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG3: UDPHS Endpoint Configuration Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCFG3_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG3_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG3_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG3_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG3_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG3_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG3_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG3_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB3: UDPHS Endpoint Control Enable Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCTLENB3_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB3_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB3_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB3_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB3_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB3_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB3_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB3_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB3_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB3_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS3: UDPHS Endpoint Control Disable Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCTLDIS3_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS3_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS3_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS3_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS3_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL3: UDPHS Endpoint Control Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCTL3_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL3_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL3_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL3_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL3_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL3_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL3_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL3_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL3_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL3_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA3: UDPHS Endpoint Set Status Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTSETSTA3_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA3.Reg, volatile.LoadUint32(&o.EPTSETSTA3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA3_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA3.Reg, volatile.LoadUint32(&o.EPTSETSTA3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA3.Reg, volatile.LoadUint32(&o.EPTSETSTA3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA3.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA3: UDPHS Endpoint Clear Status Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCLRSTA3_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA3_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA3: UDPHS Endpoint Status Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTSTA3_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA3_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA3_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA3_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA3_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA3_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA3_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA3_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA3_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA3_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG4: UDPHS Endpoint Configuration Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCFG4_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG4_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG4_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG4_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG4_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG4_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG4_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG4_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB4: UDPHS Endpoint Control Enable Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCTLENB4_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB4_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB4_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB4_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB4_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB4_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB4_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB4_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB4_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB4_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS4: UDPHS Endpoint Control Disable Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCTLDIS4_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS4_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS4_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS4_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS4_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL4: UDPHS Endpoint Control Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCTL4_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL4_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL4_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL4_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL4_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL4_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL4_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL4_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL4_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL4_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA4: UDPHS Endpoint Set Status Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTSETSTA4_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA4.Reg, volatile.LoadUint32(&o.EPTSETSTA4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA4_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA4.Reg, volatile.LoadUint32(&o.EPTSETSTA4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA4.Reg, volatile.LoadUint32(&o.EPTSETSTA4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA4.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA4: UDPHS Endpoint Clear Status Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCLRSTA4_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA4_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA4: UDPHS Endpoint Status Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTSTA4_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA4_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA4_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA4_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA4_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA4_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA4_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA4_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA4_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA4_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG5: UDPHS Endpoint Configuration Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCFG5_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG5_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG5_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG5_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG5_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG5_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG5_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG5_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB5: UDPHS Endpoint Control Enable Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCTLENB5_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB5_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB5_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB5_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB5_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB5_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB5_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB5_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB5_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB5_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS5: UDPHS Endpoint Control Disable Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCTLDIS5_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS5_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS5_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS5_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS5_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL5: UDPHS Endpoint Control Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCTL5_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL5_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL5_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL5_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL5_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL5_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL5_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL5_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL5_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL5_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA5: UDPHS Endpoint Set Status Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTSETSTA5_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA5.Reg, volatile.LoadUint32(&o.EPTSETSTA5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA5_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA5.Reg, volatile.LoadUint32(&o.EPTSETSTA5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA5.Reg, volatile.LoadUint32(&o.EPTSETSTA5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA5.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA5: UDPHS Endpoint Clear Status Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCLRSTA5_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA5_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA5: UDPHS Endpoint Status Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTSTA5_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA5_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA5_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA5_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA5_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA5_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA5_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA5_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA5_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA5_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG6: UDPHS Endpoint Configuration Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCFG6_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG6_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG6_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG6_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG6_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG6_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG6_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG6_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB6: UDPHS Endpoint Control Enable Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCTLENB6_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB6_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB6_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB6_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB6_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB6_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB6_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB6_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB6_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB6_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS6: UDPHS Endpoint Control Disable Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCTLDIS6_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS6_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS6_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS6_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS6_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL6: UDPHS Endpoint Control Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCTL6_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL6_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL6_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL6_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL6_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL6_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL6_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL6_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL6_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL6_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA6: UDPHS Endpoint Set Status Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTSETSTA6_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA6.Reg, volatile.LoadUint32(&o.EPTSETSTA6.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA6_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA6.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA6.Reg, volatile.LoadUint32(&o.EPTSETSTA6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA6.Reg, volatile.LoadUint32(&o.EPTSETSTA6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA6.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA6: UDPHS Endpoint Clear Status Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCLRSTA6_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA6_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA6: UDPHS Endpoint Status Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTSTA6_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA6_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA6_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA6_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA6_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA6_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA6_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA6_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA6_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA6_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG7: UDPHS Endpoint Configuration Register (endpoint = 7)
func (o *UDPHS_Type) SetEPTCFG7_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG7.Reg, volatile.LoadUint32(&o.EPTCFG7.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG7_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG7.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG7_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG7.Reg, volatile.LoadUint32(&o.EPTCFG7.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG7_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG7.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG7_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG7.Reg, volatile.LoadUint32(&o.EPTCFG7.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG7_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG7.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG7_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG7.Reg, volatile.LoadUint32(&o.EPTCFG7.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG7_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG7.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG7_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG7.Reg, volatile.LoadUint32(&o.EPTCFG7.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG7_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG7.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG7_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG7.Reg, volatile.LoadUint32(&o.EPTCFG7.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG7_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG7.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB7: UDPHS Endpoint Control Enable Register (endpoint = 7)
func (o *UDPHS_Type) SetEPTCTLENB7_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB7.Reg, volatile.LoadUint32(&o.EPTCTLENB7.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB7_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB7.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB7_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB7.Reg, volatile.LoadUint32(&o.EPTCTLENB7.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB7_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB7.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB7_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB7.Reg, volatile.LoadUint32(&o.EPTCTLENB7.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB7_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB7.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB7_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB7.Reg, volatile.LoadUint32(&o.EPTCTLENB7.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB7_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB7.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB7_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB7.Reg, volatile.LoadUint32(&o.EPTCTLENB7.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB7_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB7.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB7_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB7.Reg, volatile.LoadUint32(&o.EPTCTLENB7.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB7_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB7.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB7_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB7.Reg, volatile.LoadUint32(&o.EPTCTLENB7.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB7_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB7.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB7_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB7.Reg, volatile.LoadUint32(&o.EPTCTLENB7.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB7_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB7.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB7_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB7.Reg, volatile.LoadUint32(&o.EPTCTLENB7.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB7_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB7.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB7_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB7.Reg, volatile.LoadUint32(&o.EPTCTLENB7.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB7_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB7.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB7_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB7.Reg, volatile.LoadUint32(&o.EPTCTLENB7.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB7_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB7.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB7_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB7.Reg, volatile.LoadUint32(&o.EPTCTLENB7.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB7_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB7.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB7_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB7.Reg, volatile.LoadUint32(&o.EPTCTLENB7.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB7_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB7.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB7_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB7.Reg, volatile.LoadUint32(&o.EPTCTLENB7.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB7_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB7.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS7: UDPHS Endpoint Control Disable Register (endpoint = 7)
func (o *UDPHS_Type) SetEPTCTLDIS7_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS7.Reg, volatile.LoadUint32(&o.EPTCTLDIS7.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS7_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS7.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS7_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS7.Reg, volatile.LoadUint32(&o.EPTCTLDIS7.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS7_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS7.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS7_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS7.Reg, volatile.LoadUint32(&o.EPTCTLDIS7.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS7_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS7.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS7_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS7.Reg, volatile.LoadUint32(&o.EPTCTLDIS7.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS7_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS7.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS7_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS7.Reg, volatile.LoadUint32(&o.EPTCTLDIS7.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS7_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS7.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS7_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS7.Reg, volatile.LoadUint32(&o.EPTCTLDIS7.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS7_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS7.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS7_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS7.Reg, volatile.LoadUint32(&o.EPTCTLDIS7.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS7_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS7.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS7_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS7.Reg, volatile.LoadUint32(&o.EPTCTLDIS7.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS7_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS7.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS7_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS7.Reg, volatile.LoadUint32(&o.EPTCTLDIS7.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS7_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS7.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS7_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS7.Reg, volatile.LoadUint32(&o.EPTCTLDIS7.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS7_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS7.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS7_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS7.Reg, volatile.LoadUint32(&o.EPTCTLDIS7.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS7_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS7.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS7_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS7.Reg, volatile.LoadUint32(&o.EPTCTLDIS7.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS7_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS7.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS7_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS7.Reg, volatile.LoadUint32(&o.EPTCTLDIS7.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS7_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS7.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS7_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS7.Reg, volatile.LoadUint32(&o.EPTCTLDIS7.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS7_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS7.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL7: UDPHS Endpoint Control Register (endpoint = 7)
func (o *UDPHS_Type) SetEPTCTL7_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL7.Reg, volatile.LoadUint32(&o.EPTCTL7.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL7_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL7.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL7_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL7.Reg, volatile.LoadUint32(&o.EPTCTL7.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL7_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL7.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL7_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL7.Reg, volatile.LoadUint32(&o.EPTCTL7.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL7_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL7.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL7_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL7.Reg, volatile.LoadUint32(&o.EPTCTL7.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL7_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL7.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL7_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL7.Reg, volatile.LoadUint32(&o.EPTCTL7.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL7_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL7.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL7_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL7.Reg, volatile.LoadUint32(&o.EPTCTL7.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL7_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL7.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL7_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL7.Reg, volatile.LoadUint32(&o.EPTCTL7.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL7_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL7.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL7_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL7.Reg, volatile.LoadUint32(&o.EPTCTL7.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL7_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL7.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL7_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL7.Reg, volatile.LoadUint32(&o.EPTCTL7.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL7_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL7.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL7_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL7.Reg, volatile.LoadUint32(&o.EPTCTL7.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL7_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL7.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL7_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL7.Reg, volatile.LoadUint32(&o.EPTCTL7.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL7_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL7.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL7_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL7.Reg, volatile.LoadUint32(&o.EPTCTL7.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL7_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL7.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL7_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL7.Reg, volatile.LoadUint32(&o.EPTCTL7.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL7_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL7.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL7_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL7.Reg, volatile.LoadUint32(&o.EPTCTL7.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL7_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL7.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA7: UDPHS Endpoint Set Status Register (endpoint = 7)
func (o *UDPHS_Type) SetEPTSETSTA7_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA7.Reg, volatile.LoadUint32(&o.EPTSETSTA7.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA7_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA7.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA7_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA7.Reg, volatile.LoadUint32(&o.EPTSETSTA7.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA7_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA7.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA7_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA7.Reg, volatile.LoadUint32(&o.EPTSETSTA7.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA7_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA7.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA7: UDPHS Endpoint Clear Status Register (endpoint = 7)
func (o *UDPHS_Type) SetEPTCLRSTA7_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA7.Reg, volatile.LoadUint32(&o.EPTCLRSTA7.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA7_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA7.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA7_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA7.Reg, volatile.LoadUint32(&o.EPTCLRSTA7.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA7_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA7.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA7_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA7.Reg, volatile.LoadUint32(&o.EPTCLRSTA7.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA7_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA7.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA7_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA7.Reg, volatile.LoadUint32(&o.EPTCLRSTA7.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA7_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA7.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA7_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA7.Reg, volatile.LoadUint32(&o.EPTCLRSTA7.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA7_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA7.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA7_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA7.Reg, volatile.LoadUint32(&o.EPTCLRSTA7.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA7_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA7.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA7_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA7.Reg, volatile.LoadUint32(&o.EPTCLRSTA7.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA7_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA7.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA7_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA7.Reg, volatile.LoadUint32(&o.EPTCLRSTA7.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA7_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA7.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA7: UDPHS Endpoint Status Register (endpoint = 7)
func (o *UDPHS_Type) SetEPTSTA7_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA7.Reg, volatile.LoadUint32(&o.EPTSTA7.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA7_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA7.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA7_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA7.Reg, volatile.LoadUint32(&o.EPTSTA7.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA7_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA7.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA7_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA7.Reg, volatile.LoadUint32(&o.EPTSTA7.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA7_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA7.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA7_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA7.Reg, volatile.LoadUint32(&o.EPTSTA7.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA7_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA7.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA7_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA7.Reg, volatile.LoadUint32(&o.EPTSTA7.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA7_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA7.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA7_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA7.Reg, volatile.LoadUint32(&o.EPTSTA7.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA7_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA7.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA7_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA7.Reg, volatile.LoadUint32(&o.EPTSTA7.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA7_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA7.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA7_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA7.Reg, volatile.LoadUint32(&o.EPTSTA7.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA7_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA7.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA7_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA7.Reg, volatile.LoadUint32(&o.EPTSTA7.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA7_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA7.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA7_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA7.Reg, volatile.LoadUint32(&o.EPTSTA7.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA7_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA7.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA7_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA7.Reg, volatile.LoadUint32(&o.EPTSTA7.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA7_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA7.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA7_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA7.Reg, volatile.LoadUint32(&o.EPTSTA7.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA7_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA7.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA7_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA7.Reg, volatile.LoadUint32(&o.EPTSTA7.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA7_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA7.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA7_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA7.Reg, volatile.LoadUint32(&o.EPTSTA7.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA7_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA7.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG8: UDPHS Endpoint Configuration Register (endpoint = 8)
func (o *UDPHS_Type) SetEPTCFG8_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG8.Reg, volatile.LoadUint32(&o.EPTCFG8.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG8_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG8.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG8_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG8.Reg, volatile.LoadUint32(&o.EPTCFG8.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG8_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG8.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG8_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG8.Reg, volatile.LoadUint32(&o.EPTCFG8.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG8_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG8.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG8_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG8.Reg, volatile.LoadUint32(&o.EPTCFG8.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG8_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG8.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG8_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG8.Reg, volatile.LoadUint32(&o.EPTCFG8.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG8_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG8.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG8_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG8.Reg, volatile.LoadUint32(&o.EPTCFG8.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG8_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG8.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB8: UDPHS Endpoint Control Enable Register (endpoint = 8)
func (o *UDPHS_Type) SetEPTCTLENB8_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB8.Reg, volatile.LoadUint32(&o.EPTCTLENB8.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB8_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB8.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB8_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB8.Reg, volatile.LoadUint32(&o.EPTCTLENB8.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB8_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB8.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB8_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB8.Reg, volatile.LoadUint32(&o.EPTCTLENB8.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB8_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB8.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB8_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB8.Reg, volatile.LoadUint32(&o.EPTCTLENB8.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB8_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB8.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB8_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB8.Reg, volatile.LoadUint32(&o.EPTCTLENB8.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB8_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB8.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB8_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB8.Reg, volatile.LoadUint32(&o.EPTCTLENB8.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB8_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB8.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB8_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB8.Reg, volatile.LoadUint32(&o.EPTCTLENB8.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB8_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB8.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB8_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB8.Reg, volatile.LoadUint32(&o.EPTCTLENB8.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB8_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB8.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB8_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB8.Reg, volatile.LoadUint32(&o.EPTCTLENB8.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB8_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB8.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB8_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB8.Reg, volatile.LoadUint32(&o.EPTCTLENB8.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB8_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB8.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB8_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB8.Reg, volatile.LoadUint32(&o.EPTCTLENB8.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB8_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB8.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB8_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB8.Reg, volatile.LoadUint32(&o.EPTCTLENB8.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB8_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB8.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB8_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB8.Reg, volatile.LoadUint32(&o.EPTCTLENB8.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB8_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB8.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB8_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB8.Reg, volatile.LoadUint32(&o.EPTCTLENB8.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB8_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB8.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS8: UDPHS Endpoint Control Disable Register (endpoint = 8)
func (o *UDPHS_Type) SetEPTCTLDIS8_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS8.Reg, volatile.LoadUint32(&o.EPTCTLDIS8.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS8_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS8.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS8_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS8.Reg, volatile.LoadUint32(&o.EPTCTLDIS8.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS8_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS8.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS8_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS8.Reg, volatile.LoadUint32(&o.EPTCTLDIS8.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS8_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS8.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS8_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS8.Reg, volatile.LoadUint32(&o.EPTCTLDIS8.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS8_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS8.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS8_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS8.Reg, volatile.LoadUint32(&o.EPTCTLDIS8.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS8_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS8.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS8_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS8.Reg, volatile.LoadUint32(&o.EPTCTLDIS8.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS8_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS8.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS8_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS8.Reg, volatile.LoadUint32(&o.EPTCTLDIS8.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS8_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS8.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS8_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS8.Reg, volatile.LoadUint32(&o.EPTCTLDIS8.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS8_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS8.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS8_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS8.Reg, volatile.LoadUint32(&o.EPTCTLDIS8.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS8_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS8.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS8_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS8.Reg, volatile.LoadUint32(&o.EPTCTLDIS8.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS8_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS8.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS8_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS8.Reg, volatile.LoadUint32(&o.EPTCTLDIS8.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS8_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS8.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS8_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS8.Reg, volatile.LoadUint32(&o.EPTCTLDIS8.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS8_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS8.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS8_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS8.Reg, volatile.LoadUint32(&o.EPTCTLDIS8.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS8_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS8.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS8_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS8.Reg, volatile.LoadUint32(&o.EPTCTLDIS8.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS8_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS8.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL8: UDPHS Endpoint Control Register (endpoint = 8)
func (o *UDPHS_Type) SetEPTCTL8_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL8.Reg, volatile.LoadUint32(&o.EPTCTL8.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL8_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL8.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL8_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL8.Reg, volatile.LoadUint32(&o.EPTCTL8.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL8_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL8.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL8_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL8.Reg, volatile.LoadUint32(&o.EPTCTL8.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL8_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL8.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL8_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL8.Reg, volatile.LoadUint32(&o.EPTCTL8.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL8_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL8.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL8_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL8.Reg, volatile.LoadUint32(&o.EPTCTL8.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL8_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL8.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL8_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL8.Reg, volatile.LoadUint32(&o.EPTCTL8.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL8_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL8.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL8_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL8.Reg, volatile.LoadUint32(&o.EPTCTL8.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL8_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL8.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL8_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL8.Reg, volatile.LoadUint32(&o.EPTCTL8.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL8_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL8.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL8_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL8.Reg, volatile.LoadUint32(&o.EPTCTL8.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL8_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL8.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL8_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL8.Reg, volatile.LoadUint32(&o.EPTCTL8.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL8_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL8.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL8_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL8.Reg, volatile.LoadUint32(&o.EPTCTL8.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL8_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL8.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL8_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL8.Reg, volatile.LoadUint32(&o.EPTCTL8.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL8_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL8.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL8_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL8.Reg, volatile.LoadUint32(&o.EPTCTL8.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL8_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL8.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL8_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL8.Reg, volatile.LoadUint32(&o.EPTCTL8.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL8_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL8.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA8: UDPHS Endpoint Set Status Register (endpoint = 8)
func (o *UDPHS_Type) SetEPTSETSTA8_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA8.Reg, volatile.LoadUint32(&o.EPTSETSTA8.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA8_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA8.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA8_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA8.Reg, volatile.LoadUint32(&o.EPTSETSTA8.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA8_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA8.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA8_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA8.Reg, volatile.LoadUint32(&o.EPTSETSTA8.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA8_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA8.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA8: UDPHS Endpoint Clear Status Register (endpoint = 8)
func (o *UDPHS_Type) SetEPTCLRSTA8_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA8.Reg, volatile.LoadUint32(&o.EPTCLRSTA8.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA8_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA8.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA8_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA8.Reg, volatile.LoadUint32(&o.EPTCLRSTA8.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA8_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA8.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA8_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA8.Reg, volatile.LoadUint32(&o.EPTCLRSTA8.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA8_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA8.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA8_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA8.Reg, volatile.LoadUint32(&o.EPTCLRSTA8.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA8_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA8.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA8_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA8.Reg, volatile.LoadUint32(&o.EPTCLRSTA8.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA8_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA8.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA8_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA8.Reg, volatile.LoadUint32(&o.EPTCLRSTA8.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA8_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA8.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA8_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA8.Reg, volatile.LoadUint32(&o.EPTCLRSTA8.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA8_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA8.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA8_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA8.Reg, volatile.LoadUint32(&o.EPTCLRSTA8.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA8_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA8.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA8: UDPHS Endpoint Status Register (endpoint = 8)
func (o *UDPHS_Type) SetEPTSTA8_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA8.Reg, volatile.LoadUint32(&o.EPTSTA8.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA8_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA8.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA8_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA8.Reg, volatile.LoadUint32(&o.EPTSTA8.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA8_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA8.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA8_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA8.Reg, volatile.LoadUint32(&o.EPTSTA8.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA8_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA8.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA8_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA8.Reg, volatile.LoadUint32(&o.EPTSTA8.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA8_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA8.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA8_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA8.Reg, volatile.LoadUint32(&o.EPTSTA8.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA8_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA8.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA8_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA8.Reg, volatile.LoadUint32(&o.EPTSTA8.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA8_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA8.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA8_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA8.Reg, volatile.LoadUint32(&o.EPTSTA8.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA8_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA8.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA8_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA8.Reg, volatile.LoadUint32(&o.EPTSTA8.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA8_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA8.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA8_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA8.Reg, volatile.LoadUint32(&o.EPTSTA8.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA8_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA8.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA8_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA8.Reg, volatile.LoadUint32(&o.EPTSTA8.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA8_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA8.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA8_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA8.Reg, volatile.LoadUint32(&o.EPTSTA8.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA8_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA8.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA8_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA8.Reg, volatile.LoadUint32(&o.EPTSTA8.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA8_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA8.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA8_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA8.Reg, volatile.LoadUint32(&o.EPTSTA8.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA8_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA8.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA8_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA8.Reg, volatile.LoadUint32(&o.EPTSTA8.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA8_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA8.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG9: UDPHS Endpoint Configuration Register (endpoint = 9)
func (o *UDPHS_Type) SetEPTCFG9_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG9.Reg, volatile.LoadUint32(&o.EPTCFG9.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG9_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG9.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG9_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG9.Reg, volatile.LoadUint32(&o.EPTCFG9.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG9_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG9.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG9_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG9.Reg, volatile.LoadUint32(&o.EPTCFG9.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG9_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG9.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG9_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG9.Reg, volatile.LoadUint32(&o.EPTCFG9.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG9_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG9.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG9_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG9.Reg, volatile.LoadUint32(&o.EPTCFG9.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG9_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG9.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG9_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG9.Reg, volatile.LoadUint32(&o.EPTCFG9.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG9_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG9.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB9: UDPHS Endpoint Control Enable Register (endpoint = 9)
func (o *UDPHS_Type) SetEPTCTLENB9_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB9.Reg, volatile.LoadUint32(&o.EPTCTLENB9.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB9_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB9.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB9_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB9.Reg, volatile.LoadUint32(&o.EPTCTLENB9.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB9_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB9.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB9_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB9.Reg, volatile.LoadUint32(&o.EPTCTLENB9.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB9_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB9.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB9_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB9.Reg, volatile.LoadUint32(&o.EPTCTLENB9.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB9_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB9.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB9_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB9.Reg, volatile.LoadUint32(&o.EPTCTLENB9.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB9_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB9.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB9_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB9.Reg, volatile.LoadUint32(&o.EPTCTLENB9.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB9_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB9.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB9_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB9.Reg, volatile.LoadUint32(&o.EPTCTLENB9.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB9_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB9.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB9_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB9.Reg, volatile.LoadUint32(&o.EPTCTLENB9.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB9_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB9.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB9_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB9.Reg, volatile.LoadUint32(&o.EPTCTLENB9.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB9_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB9.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB9_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB9.Reg, volatile.LoadUint32(&o.EPTCTLENB9.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB9_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB9.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB9_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB9.Reg, volatile.LoadUint32(&o.EPTCTLENB9.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB9_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB9.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB9_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB9.Reg, volatile.LoadUint32(&o.EPTCTLENB9.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB9_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB9.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB9_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB9.Reg, volatile.LoadUint32(&o.EPTCTLENB9.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB9_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB9.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB9_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB9.Reg, volatile.LoadUint32(&o.EPTCTLENB9.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB9_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB9.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS9: UDPHS Endpoint Control Disable Register (endpoint = 9)
func (o *UDPHS_Type) SetEPTCTLDIS9_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS9.Reg, volatile.LoadUint32(&o.EPTCTLDIS9.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS9_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS9.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS9_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS9.Reg, volatile.LoadUint32(&o.EPTCTLDIS9.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS9_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS9.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS9_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS9.Reg, volatile.LoadUint32(&o.EPTCTLDIS9.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS9_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS9.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS9_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS9.Reg, volatile.LoadUint32(&o.EPTCTLDIS9.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS9_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS9.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS9_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS9.Reg, volatile.LoadUint32(&o.EPTCTLDIS9.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS9_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS9.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS9_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS9.Reg, volatile.LoadUint32(&o.EPTCTLDIS9.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS9_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS9.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS9_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS9.Reg, volatile.LoadUint32(&o.EPTCTLDIS9.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS9_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS9.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS9_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS9.Reg, volatile.LoadUint32(&o.EPTCTLDIS9.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS9_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS9.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS9_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS9.Reg, volatile.LoadUint32(&o.EPTCTLDIS9.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS9_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS9.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS9_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS9.Reg, volatile.LoadUint32(&o.EPTCTLDIS9.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS9_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS9.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS9_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS9.Reg, volatile.LoadUint32(&o.EPTCTLDIS9.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS9_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS9.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS9_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS9.Reg, volatile.LoadUint32(&o.EPTCTLDIS9.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS9_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS9.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS9_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS9.Reg, volatile.LoadUint32(&o.EPTCTLDIS9.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS9_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS9.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS9_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS9.Reg, volatile.LoadUint32(&o.EPTCTLDIS9.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS9_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS9.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL9: UDPHS Endpoint Control Register (endpoint = 9)
func (o *UDPHS_Type) SetEPTCTL9_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL9.Reg, volatile.LoadUint32(&o.EPTCTL9.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL9_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL9.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL9_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL9.Reg, volatile.LoadUint32(&o.EPTCTL9.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL9_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL9.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL9_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL9.Reg, volatile.LoadUint32(&o.EPTCTL9.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL9_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL9.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL9_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL9.Reg, volatile.LoadUint32(&o.EPTCTL9.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL9_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL9.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL9_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL9.Reg, volatile.LoadUint32(&o.EPTCTL9.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL9_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL9.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL9_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL9.Reg, volatile.LoadUint32(&o.EPTCTL9.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL9_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL9.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL9_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL9.Reg, volatile.LoadUint32(&o.EPTCTL9.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL9_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL9.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL9_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL9.Reg, volatile.LoadUint32(&o.EPTCTL9.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL9_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL9.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL9_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL9.Reg, volatile.LoadUint32(&o.EPTCTL9.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL9_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL9.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL9_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL9.Reg, volatile.LoadUint32(&o.EPTCTL9.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL9_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL9.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL9_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL9.Reg, volatile.LoadUint32(&o.EPTCTL9.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL9_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL9.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL9_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL9.Reg, volatile.LoadUint32(&o.EPTCTL9.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL9_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL9.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL9_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL9.Reg, volatile.LoadUint32(&o.EPTCTL9.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL9_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL9.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL9_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL9.Reg, volatile.LoadUint32(&o.EPTCTL9.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL9_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL9.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA9: UDPHS Endpoint Set Status Register (endpoint = 9)
func (o *UDPHS_Type) SetEPTSETSTA9_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA9.Reg, volatile.LoadUint32(&o.EPTSETSTA9.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA9_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA9.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA9_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA9.Reg, volatile.LoadUint32(&o.EPTSETSTA9.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA9_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA9.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA9_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA9.Reg, volatile.LoadUint32(&o.EPTSETSTA9.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA9_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA9.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA9: UDPHS Endpoint Clear Status Register (endpoint = 9)
func (o *UDPHS_Type) SetEPTCLRSTA9_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA9.Reg, volatile.LoadUint32(&o.EPTCLRSTA9.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA9_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA9.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA9_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA9.Reg, volatile.LoadUint32(&o.EPTCLRSTA9.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA9_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA9.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA9_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA9.Reg, volatile.LoadUint32(&o.EPTCLRSTA9.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA9_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA9.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA9_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA9.Reg, volatile.LoadUint32(&o.EPTCLRSTA9.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA9_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA9.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA9_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA9.Reg, volatile.LoadUint32(&o.EPTCLRSTA9.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA9_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA9.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA9_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA9.Reg, volatile.LoadUint32(&o.EPTCLRSTA9.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA9_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA9.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA9_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA9.Reg, volatile.LoadUint32(&o.EPTCLRSTA9.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA9_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA9.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA9_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA9.Reg, volatile.LoadUint32(&o.EPTCLRSTA9.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA9_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA9.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA9: UDPHS Endpoint Status Register (endpoint = 9)
func (o *UDPHS_Type) SetEPTSTA9_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA9.Reg, volatile.LoadUint32(&o.EPTSTA9.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA9_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA9.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA9_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA9.Reg, volatile.LoadUint32(&o.EPTSTA9.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA9_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA9.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA9_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA9.Reg, volatile.LoadUint32(&o.EPTSTA9.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA9_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA9.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA9_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA9.Reg, volatile.LoadUint32(&o.EPTSTA9.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA9_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA9.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA9_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA9.Reg, volatile.LoadUint32(&o.EPTSTA9.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA9_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA9.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA9_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA9.Reg, volatile.LoadUint32(&o.EPTSTA9.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA9_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA9.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA9_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA9.Reg, volatile.LoadUint32(&o.EPTSTA9.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA9_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA9.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA9_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA9.Reg, volatile.LoadUint32(&o.EPTSTA9.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA9_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA9.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA9_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA9.Reg, volatile.LoadUint32(&o.EPTSTA9.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA9_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA9.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA9_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA9.Reg, volatile.LoadUint32(&o.EPTSTA9.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA9_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA9.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA9_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA9.Reg, volatile.LoadUint32(&o.EPTSTA9.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA9_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA9.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA9_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA9.Reg, volatile.LoadUint32(&o.EPTSTA9.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA9_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA9.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA9_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA9.Reg, volatile.LoadUint32(&o.EPTSTA9.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA9_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA9.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA9_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA9.Reg, volatile.LoadUint32(&o.EPTSTA9.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA9_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA9.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG10: UDPHS Endpoint Configuration Register (endpoint = 10)
func (o *UDPHS_Type) SetEPTCFG10_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG10.Reg, volatile.LoadUint32(&o.EPTCFG10.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG10_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG10.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG10_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG10.Reg, volatile.LoadUint32(&o.EPTCFG10.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG10_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG10.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG10_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG10.Reg, volatile.LoadUint32(&o.EPTCFG10.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG10_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG10.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG10_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG10.Reg, volatile.LoadUint32(&o.EPTCFG10.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG10_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG10.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG10_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG10.Reg, volatile.LoadUint32(&o.EPTCFG10.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG10_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG10.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG10_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG10.Reg, volatile.LoadUint32(&o.EPTCFG10.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG10_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG10.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB10: UDPHS Endpoint Control Enable Register (endpoint = 10)
func (o *UDPHS_Type) SetEPTCTLENB10_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB10.Reg, volatile.LoadUint32(&o.EPTCTLENB10.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB10_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB10.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB10_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB10.Reg, volatile.LoadUint32(&o.EPTCTLENB10.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB10_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB10.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB10_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB10.Reg, volatile.LoadUint32(&o.EPTCTLENB10.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB10_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB10.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB10_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB10.Reg, volatile.LoadUint32(&o.EPTCTLENB10.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB10_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB10.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB10_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB10.Reg, volatile.LoadUint32(&o.EPTCTLENB10.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB10_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB10.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB10_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB10.Reg, volatile.LoadUint32(&o.EPTCTLENB10.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB10_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB10.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB10_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB10.Reg, volatile.LoadUint32(&o.EPTCTLENB10.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB10_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB10.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB10_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB10.Reg, volatile.LoadUint32(&o.EPTCTLENB10.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB10_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB10.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB10_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB10.Reg, volatile.LoadUint32(&o.EPTCTLENB10.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB10_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB10.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB10_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB10.Reg, volatile.LoadUint32(&o.EPTCTLENB10.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB10_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB10.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB10_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB10.Reg, volatile.LoadUint32(&o.EPTCTLENB10.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB10_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB10.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB10_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB10.Reg, volatile.LoadUint32(&o.EPTCTLENB10.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB10_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB10.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB10_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB10.Reg, volatile.LoadUint32(&o.EPTCTLENB10.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB10_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB10.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB10_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB10.Reg, volatile.LoadUint32(&o.EPTCTLENB10.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB10_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB10.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS10: UDPHS Endpoint Control Disable Register (endpoint = 10)
func (o *UDPHS_Type) SetEPTCTLDIS10_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS10.Reg, volatile.LoadUint32(&o.EPTCTLDIS10.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS10_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS10.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS10_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS10.Reg, volatile.LoadUint32(&o.EPTCTLDIS10.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS10_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS10.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS10_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS10.Reg, volatile.LoadUint32(&o.EPTCTLDIS10.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS10_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS10.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS10_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS10.Reg, volatile.LoadUint32(&o.EPTCTLDIS10.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS10_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS10.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS10_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS10.Reg, volatile.LoadUint32(&o.EPTCTLDIS10.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS10_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS10.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS10_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS10.Reg, volatile.LoadUint32(&o.EPTCTLDIS10.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS10_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS10.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS10_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS10.Reg, volatile.LoadUint32(&o.EPTCTLDIS10.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS10_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS10.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS10_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS10.Reg, volatile.LoadUint32(&o.EPTCTLDIS10.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS10_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS10.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS10_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS10.Reg, volatile.LoadUint32(&o.EPTCTLDIS10.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS10_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS10.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS10_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS10.Reg, volatile.LoadUint32(&o.EPTCTLDIS10.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS10_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS10.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS10_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS10.Reg, volatile.LoadUint32(&o.EPTCTLDIS10.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS10_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS10.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS10_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS10.Reg, volatile.LoadUint32(&o.EPTCTLDIS10.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS10_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS10.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS10_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS10.Reg, volatile.LoadUint32(&o.EPTCTLDIS10.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS10_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS10.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS10_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS10.Reg, volatile.LoadUint32(&o.EPTCTLDIS10.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS10_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS10.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL10: UDPHS Endpoint Control Register (endpoint = 10)
func (o *UDPHS_Type) SetEPTCTL10_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL10.Reg, volatile.LoadUint32(&o.EPTCTL10.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL10_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL10.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL10_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL10.Reg, volatile.LoadUint32(&o.EPTCTL10.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL10_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL10.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL10_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL10.Reg, volatile.LoadUint32(&o.EPTCTL10.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL10_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL10.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL10_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL10.Reg, volatile.LoadUint32(&o.EPTCTL10.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL10_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL10.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL10_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL10.Reg, volatile.LoadUint32(&o.EPTCTL10.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL10_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL10.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL10_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL10.Reg, volatile.LoadUint32(&o.EPTCTL10.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL10_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL10.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL10_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL10.Reg, volatile.LoadUint32(&o.EPTCTL10.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL10_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL10.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL10_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL10.Reg, volatile.LoadUint32(&o.EPTCTL10.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL10_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL10.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL10_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL10.Reg, volatile.LoadUint32(&o.EPTCTL10.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL10_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL10.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL10_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL10.Reg, volatile.LoadUint32(&o.EPTCTL10.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL10_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL10.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL10_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL10.Reg, volatile.LoadUint32(&o.EPTCTL10.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL10_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL10.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL10_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL10.Reg, volatile.LoadUint32(&o.EPTCTL10.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL10_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL10.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL10_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL10.Reg, volatile.LoadUint32(&o.EPTCTL10.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL10_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL10.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL10_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL10.Reg, volatile.LoadUint32(&o.EPTCTL10.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL10_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL10.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA10: UDPHS Endpoint Set Status Register (endpoint = 10)
func (o *UDPHS_Type) SetEPTSETSTA10_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA10.Reg, volatile.LoadUint32(&o.EPTSETSTA10.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA10_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA10.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA10_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA10.Reg, volatile.LoadUint32(&o.EPTSETSTA10.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA10_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA10.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA10_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA10.Reg, volatile.LoadUint32(&o.EPTSETSTA10.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA10_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA10.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA10: UDPHS Endpoint Clear Status Register (endpoint = 10)
func (o *UDPHS_Type) SetEPTCLRSTA10_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA10.Reg, volatile.LoadUint32(&o.EPTCLRSTA10.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA10_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA10.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA10_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA10.Reg, volatile.LoadUint32(&o.EPTCLRSTA10.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA10_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA10.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA10_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA10.Reg, volatile.LoadUint32(&o.EPTCLRSTA10.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA10_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA10.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA10_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA10.Reg, volatile.LoadUint32(&o.EPTCLRSTA10.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA10_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA10.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA10_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA10.Reg, volatile.LoadUint32(&o.EPTCLRSTA10.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA10_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA10.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA10_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA10.Reg, volatile.LoadUint32(&o.EPTCLRSTA10.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA10_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA10.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA10_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA10.Reg, volatile.LoadUint32(&o.EPTCLRSTA10.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA10_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA10.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA10_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA10.Reg, volatile.LoadUint32(&o.EPTCLRSTA10.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA10_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA10.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA10: UDPHS Endpoint Status Register (endpoint = 10)
func (o *UDPHS_Type) SetEPTSTA10_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA10.Reg, volatile.LoadUint32(&o.EPTSTA10.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA10_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA10.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA10_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA10.Reg, volatile.LoadUint32(&o.EPTSTA10.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA10_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA10.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA10_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA10.Reg, volatile.LoadUint32(&o.EPTSTA10.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA10_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA10.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA10_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA10.Reg, volatile.LoadUint32(&o.EPTSTA10.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA10_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA10.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA10_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA10.Reg, volatile.LoadUint32(&o.EPTSTA10.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA10_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA10.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA10_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA10.Reg, volatile.LoadUint32(&o.EPTSTA10.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA10_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA10.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA10_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA10.Reg, volatile.LoadUint32(&o.EPTSTA10.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA10_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA10.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA10_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA10.Reg, volatile.LoadUint32(&o.EPTSTA10.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA10_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA10.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA10_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA10.Reg, volatile.LoadUint32(&o.EPTSTA10.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA10_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA10.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA10_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA10.Reg, volatile.LoadUint32(&o.EPTSTA10.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA10_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA10.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA10_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA10.Reg, volatile.LoadUint32(&o.EPTSTA10.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA10_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA10.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA10_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA10.Reg, volatile.LoadUint32(&o.EPTSTA10.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA10_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA10.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA10_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA10.Reg, volatile.LoadUint32(&o.EPTSTA10.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA10_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA10.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA10_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA10.Reg, volatile.LoadUint32(&o.EPTSTA10.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA10_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA10.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG11: UDPHS Endpoint Configuration Register (endpoint = 11)
func (o *UDPHS_Type) SetEPTCFG11_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG11.Reg, volatile.LoadUint32(&o.EPTCFG11.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG11_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG11.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG11_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG11.Reg, volatile.LoadUint32(&o.EPTCFG11.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG11_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG11.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG11_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG11.Reg, volatile.LoadUint32(&o.EPTCFG11.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG11_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG11.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG11_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG11.Reg, volatile.LoadUint32(&o.EPTCFG11.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG11_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG11.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG11_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG11.Reg, volatile.LoadUint32(&o.EPTCFG11.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG11_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG11.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG11_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG11.Reg, volatile.LoadUint32(&o.EPTCFG11.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG11_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG11.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB11: UDPHS Endpoint Control Enable Register (endpoint = 11)
func (o *UDPHS_Type) SetEPTCTLENB11_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB11.Reg, volatile.LoadUint32(&o.EPTCTLENB11.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB11_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB11.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB11_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB11.Reg, volatile.LoadUint32(&o.EPTCTLENB11.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB11_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB11.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB11_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB11.Reg, volatile.LoadUint32(&o.EPTCTLENB11.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB11_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB11.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB11_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB11.Reg, volatile.LoadUint32(&o.EPTCTLENB11.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB11_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB11.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB11_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB11.Reg, volatile.LoadUint32(&o.EPTCTLENB11.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB11_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB11.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB11_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB11.Reg, volatile.LoadUint32(&o.EPTCTLENB11.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB11_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB11.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB11_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB11.Reg, volatile.LoadUint32(&o.EPTCTLENB11.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB11_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB11.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB11_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB11.Reg, volatile.LoadUint32(&o.EPTCTLENB11.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB11_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB11.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB11_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB11.Reg, volatile.LoadUint32(&o.EPTCTLENB11.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB11_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB11.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB11_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB11.Reg, volatile.LoadUint32(&o.EPTCTLENB11.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB11_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB11.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB11_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB11.Reg, volatile.LoadUint32(&o.EPTCTLENB11.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB11_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB11.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB11_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB11.Reg, volatile.LoadUint32(&o.EPTCTLENB11.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB11_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB11.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB11_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB11.Reg, volatile.LoadUint32(&o.EPTCTLENB11.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB11_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB11.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB11_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB11.Reg, volatile.LoadUint32(&o.EPTCTLENB11.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB11_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB11.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS11: UDPHS Endpoint Control Disable Register (endpoint = 11)
func (o *UDPHS_Type) SetEPTCTLDIS11_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS11.Reg, volatile.LoadUint32(&o.EPTCTLDIS11.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS11_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS11.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS11_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS11.Reg, volatile.LoadUint32(&o.EPTCTLDIS11.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS11_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS11.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS11_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS11.Reg, volatile.LoadUint32(&o.EPTCTLDIS11.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS11_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS11.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS11_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS11.Reg, volatile.LoadUint32(&o.EPTCTLDIS11.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS11_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS11.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS11_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS11.Reg, volatile.LoadUint32(&o.EPTCTLDIS11.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS11_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS11.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS11_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS11.Reg, volatile.LoadUint32(&o.EPTCTLDIS11.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS11_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS11.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS11_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS11.Reg, volatile.LoadUint32(&o.EPTCTLDIS11.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS11_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS11.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS11_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS11.Reg, volatile.LoadUint32(&o.EPTCTLDIS11.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS11_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS11.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS11_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS11.Reg, volatile.LoadUint32(&o.EPTCTLDIS11.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS11_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS11.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS11_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS11.Reg, volatile.LoadUint32(&o.EPTCTLDIS11.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS11_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS11.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS11_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS11.Reg, volatile.LoadUint32(&o.EPTCTLDIS11.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS11_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS11.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS11_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS11.Reg, volatile.LoadUint32(&o.EPTCTLDIS11.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS11_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS11.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS11_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS11.Reg, volatile.LoadUint32(&o.EPTCTLDIS11.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS11_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS11.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS11_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS11.Reg, volatile.LoadUint32(&o.EPTCTLDIS11.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS11_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS11.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL11: UDPHS Endpoint Control Register (endpoint = 11)
func (o *UDPHS_Type) SetEPTCTL11_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL11.Reg, volatile.LoadUint32(&o.EPTCTL11.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL11_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL11.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL11_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL11.Reg, volatile.LoadUint32(&o.EPTCTL11.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL11_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL11.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL11_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL11.Reg, volatile.LoadUint32(&o.EPTCTL11.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL11_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL11.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL11_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL11.Reg, volatile.LoadUint32(&o.EPTCTL11.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL11_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL11.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL11_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL11.Reg, volatile.LoadUint32(&o.EPTCTL11.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL11_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL11.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL11_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL11.Reg, volatile.LoadUint32(&o.EPTCTL11.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL11_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL11.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL11_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL11.Reg, volatile.LoadUint32(&o.EPTCTL11.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL11_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL11.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL11_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL11.Reg, volatile.LoadUint32(&o.EPTCTL11.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL11_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL11.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL11_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL11.Reg, volatile.LoadUint32(&o.EPTCTL11.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL11_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL11.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL11_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL11.Reg, volatile.LoadUint32(&o.EPTCTL11.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL11_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL11.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL11_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL11.Reg, volatile.LoadUint32(&o.EPTCTL11.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL11_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL11.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL11_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL11.Reg, volatile.LoadUint32(&o.EPTCTL11.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL11_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL11.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL11_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL11.Reg, volatile.LoadUint32(&o.EPTCTL11.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL11_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL11.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL11_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL11.Reg, volatile.LoadUint32(&o.EPTCTL11.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL11_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL11.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA11: UDPHS Endpoint Set Status Register (endpoint = 11)
func (o *UDPHS_Type) SetEPTSETSTA11_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA11.Reg, volatile.LoadUint32(&o.EPTSETSTA11.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA11_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA11.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA11_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA11.Reg, volatile.LoadUint32(&o.EPTSETSTA11.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA11_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA11.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA11_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA11.Reg, volatile.LoadUint32(&o.EPTSETSTA11.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA11_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA11.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA11: UDPHS Endpoint Clear Status Register (endpoint = 11)
func (o *UDPHS_Type) SetEPTCLRSTA11_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA11.Reg, volatile.LoadUint32(&o.EPTCLRSTA11.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA11_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA11.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA11_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA11.Reg, volatile.LoadUint32(&o.EPTCLRSTA11.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA11_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA11.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA11_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA11.Reg, volatile.LoadUint32(&o.EPTCLRSTA11.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA11_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA11.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA11_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA11.Reg, volatile.LoadUint32(&o.EPTCLRSTA11.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA11_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA11.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA11_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA11.Reg, volatile.LoadUint32(&o.EPTCLRSTA11.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA11_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA11.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA11_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA11.Reg, volatile.LoadUint32(&o.EPTCLRSTA11.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA11_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA11.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA11_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA11.Reg, volatile.LoadUint32(&o.EPTCLRSTA11.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA11_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA11.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA11_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA11.Reg, volatile.LoadUint32(&o.EPTCLRSTA11.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA11_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA11.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA11: UDPHS Endpoint Status Register (endpoint = 11)
func (o *UDPHS_Type) SetEPTSTA11_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA11.Reg, volatile.LoadUint32(&o.EPTSTA11.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA11_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA11.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA11_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA11.Reg, volatile.LoadUint32(&o.EPTSTA11.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA11_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA11.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA11_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA11.Reg, volatile.LoadUint32(&o.EPTSTA11.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA11_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA11.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA11_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA11.Reg, volatile.LoadUint32(&o.EPTSTA11.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA11_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA11.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA11_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA11.Reg, volatile.LoadUint32(&o.EPTSTA11.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA11_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA11.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA11_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA11.Reg, volatile.LoadUint32(&o.EPTSTA11.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA11_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA11.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA11_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA11.Reg, volatile.LoadUint32(&o.EPTSTA11.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA11_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA11.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA11_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA11.Reg, volatile.LoadUint32(&o.EPTSTA11.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA11_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA11.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA11_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA11.Reg, volatile.LoadUint32(&o.EPTSTA11.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA11_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA11.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA11_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA11.Reg, volatile.LoadUint32(&o.EPTSTA11.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA11_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA11.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA11_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA11.Reg, volatile.LoadUint32(&o.EPTSTA11.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA11_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA11.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA11_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA11.Reg, volatile.LoadUint32(&o.EPTSTA11.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA11_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA11.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA11_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA11.Reg, volatile.LoadUint32(&o.EPTSTA11.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA11_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA11.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA11_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA11.Reg, volatile.LoadUint32(&o.EPTSTA11.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA11_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA11.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG12: UDPHS Endpoint Configuration Register (endpoint = 12)
func (o *UDPHS_Type) SetEPTCFG12_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG12.Reg, volatile.LoadUint32(&o.EPTCFG12.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG12_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG12.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG12_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG12.Reg, volatile.LoadUint32(&o.EPTCFG12.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG12_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG12.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG12_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG12.Reg, volatile.LoadUint32(&o.EPTCFG12.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG12_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG12.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG12_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG12.Reg, volatile.LoadUint32(&o.EPTCFG12.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG12_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG12.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG12_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG12.Reg, volatile.LoadUint32(&o.EPTCFG12.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG12_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG12.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG12_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG12.Reg, volatile.LoadUint32(&o.EPTCFG12.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG12_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG12.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB12: UDPHS Endpoint Control Enable Register (endpoint = 12)
func (o *UDPHS_Type) SetEPTCTLENB12_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB12.Reg, volatile.LoadUint32(&o.EPTCTLENB12.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB12_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB12.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB12_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB12.Reg, volatile.LoadUint32(&o.EPTCTLENB12.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB12_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB12.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB12_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB12.Reg, volatile.LoadUint32(&o.EPTCTLENB12.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB12_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB12.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB12_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB12.Reg, volatile.LoadUint32(&o.EPTCTLENB12.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB12_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB12.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB12_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB12.Reg, volatile.LoadUint32(&o.EPTCTLENB12.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB12_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB12.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB12_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB12.Reg, volatile.LoadUint32(&o.EPTCTLENB12.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB12_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB12.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB12_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB12.Reg, volatile.LoadUint32(&o.EPTCTLENB12.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB12_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB12.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB12_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB12.Reg, volatile.LoadUint32(&o.EPTCTLENB12.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB12_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB12.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB12_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB12.Reg, volatile.LoadUint32(&o.EPTCTLENB12.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB12_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB12.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB12_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB12.Reg, volatile.LoadUint32(&o.EPTCTLENB12.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB12_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB12.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB12_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB12.Reg, volatile.LoadUint32(&o.EPTCTLENB12.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB12_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB12.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB12_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB12.Reg, volatile.LoadUint32(&o.EPTCTLENB12.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB12_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB12.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB12_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB12.Reg, volatile.LoadUint32(&o.EPTCTLENB12.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB12_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB12.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB12_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB12.Reg, volatile.LoadUint32(&o.EPTCTLENB12.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB12_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB12.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS12: UDPHS Endpoint Control Disable Register (endpoint = 12)
func (o *UDPHS_Type) SetEPTCTLDIS12_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS12.Reg, volatile.LoadUint32(&o.EPTCTLDIS12.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS12_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS12.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS12_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS12.Reg, volatile.LoadUint32(&o.EPTCTLDIS12.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS12_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS12.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS12_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS12.Reg, volatile.LoadUint32(&o.EPTCTLDIS12.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS12_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS12.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS12_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS12.Reg, volatile.LoadUint32(&o.EPTCTLDIS12.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS12_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS12.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS12_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS12.Reg, volatile.LoadUint32(&o.EPTCTLDIS12.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS12_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS12.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS12_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS12.Reg, volatile.LoadUint32(&o.EPTCTLDIS12.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS12_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS12.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS12_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS12.Reg, volatile.LoadUint32(&o.EPTCTLDIS12.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS12_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS12.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS12_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS12.Reg, volatile.LoadUint32(&o.EPTCTLDIS12.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS12_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS12.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS12_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS12.Reg, volatile.LoadUint32(&o.EPTCTLDIS12.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS12_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS12.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS12_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS12.Reg, volatile.LoadUint32(&o.EPTCTLDIS12.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS12_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS12.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS12_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS12.Reg, volatile.LoadUint32(&o.EPTCTLDIS12.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS12_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS12.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS12_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS12.Reg, volatile.LoadUint32(&o.EPTCTLDIS12.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS12_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS12.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS12_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS12.Reg, volatile.LoadUint32(&o.EPTCTLDIS12.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS12_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS12.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS12_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS12.Reg, volatile.LoadUint32(&o.EPTCTLDIS12.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS12_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS12.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL12: UDPHS Endpoint Control Register (endpoint = 12)
func (o *UDPHS_Type) SetEPTCTL12_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL12.Reg, volatile.LoadUint32(&o.EPTCTL12.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL12_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL12.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL12_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL12.Reg, volatile.LoadUint32(&o.EPTCTL12.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL12_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL12.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL12_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL12.Reg, volatile.LoadUint32(&o.EPTCTL12.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL12_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL12.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL12_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL12.Reg, volatile.LoadUint32(&o.EPTCTL12.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL12_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL12.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL12_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL12.Reg, volatile.LoadUint32(&o.EPTCTL12.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL12_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL12.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL12_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL12.Reg, volatile.LoadUint32(&o.EPTCTL12.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL12_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL12.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL12_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL12.Reg, volatile.LoadUint32(&o.EPTCTL12.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL12_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL12.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL12_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL12.Reg, volatile.LoadUint32(&o.EPTCTL12.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL12_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL12.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL12_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL12.Reg, volatile.LoadUint32(&o.EPTCTL12.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL12_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL12.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL12_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL12.Reg, volatile.LoadUint32(&o.EPTCTL12.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL12_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL12.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL12_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL12.Reg, volatile.LoadUint32(&o.EPTCTL12.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL12_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL12.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL12_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL12.Reg, volatile.LoadUint32(&o.EPTCTL12.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL12_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL12.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL12_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL12.Reg, volatile.LoadUint32(&o.EPTCTL12.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL12_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL12.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL12_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL12.Reg, volatile.LoadUint32(&o.EPTCTL12.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL12_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL12.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA12: UDPHS Endpoint Set Status Register (endpoint = 12)
func (o *UDPHS_Type) SetEPTSETSTA12_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA12.Reg, volatile.LoadUint32(&o.EPTSETSTA12.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA12_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA12.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA12_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA12.Reg, volatile.LoadUint32(&o.EPTSETSTA12.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA12_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA12.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA12_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA12.Reg, volatile.LoadUint32(&o.EPTSETSTA12.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA12_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA12.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA12: UDPHS Endpoint Clear Status Register (endpoint = 12)
func (o *UDPHS_Type) SetEPTCLRSTA12_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA12.Reg, volatile.LoadUint32(&o.EPTCLRSTA12.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA12_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA12.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA12_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA12.Reg, volatile.LoadUint32(&o.EPTCLRSTA12.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA12_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA12.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA12_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA12.Reg, volatile.LoadUint32(&o.EPTCLRSTA12.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA12_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA12.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA12_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA12.Reg, volatile.LoadUint32(&o.EPTCLRSTA12.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA12_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA12.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA12_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA12.Reg, volatile.LoadUint32(&o.EPTCLRSTA12.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA12_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA12.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA12_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA12.Reg, volatile.LoadUint32(&o.EPTCLRSTA12.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA12_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA12.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA12_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA12.Reg, volatile.LoadUint32(&o.EPTCLRSTA12.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA12_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA12.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA12_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA12.Reg, volatile.LoadUint32(&o.EPTCLRSTA12.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA12_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA12.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA12: UDPHS Endpoint Status Register (endpoint = 12)
func (o *UDPHS_Type) SetEPTSTA12_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA12.Reg, volatile.LoadUint32(&o.EPTSTA12.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA12_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA12.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA12_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA12.Reg, volatile.LoadUint32(&o.EPTSTA12.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA12_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA12.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA12_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA12.Reg, volatile.LoadUint32(&o.EPTSTA12.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA12_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA12.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA12_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA12.Reg, volatile.LoadUint32(&o.EPTSTA12.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA12_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA12.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA12_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA12.Reg, volatile.LoadUint32(&o.EPTSTA12.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA12_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA12.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA12_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA12.Reg, volatile.LoadUint32(&o.EPTSTA12.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA12_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA12.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA12_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA12.Reg, volatile.LoadUint32(&o.EPTSTA12.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA12_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA12.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA12_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA12.Reg, volatile.LoadUint32(&o.EPTSTA12.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA12_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA12.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA12_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA12.Reg, volatile.LoadUint32(&o.EPTSTA12.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA12_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA12.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA12_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA12.Reg, volatile.LoadUint32(&o.EPTSTA12.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA12_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA12.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA12_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA12.Reg, volatile.LoadUint32(&o.EPTSTA12.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA12_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA12.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA12_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA12.Reg, volatile.LoadUint32(&o.EPTSTA12.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA12_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA12.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA12_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA12.Reg, volatile.LoadUint32(&o.EPTSTA12.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA12_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA12.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA12_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA12.Reg, volatile.LoadUint32(&o.EPTSTA12.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA12_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA12.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG13: UDPHS Endpoint Configuration Register (endpoint = 13)
func (o *UDPHS_Type) SetEPTCFG13_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG13.Reg, volatile.LoadUint32(&o.EPTCFG13.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG13_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG13.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG13_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG13.Reg, volatile.LoadUint32(&o.EPTCFG13.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG13_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG13.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG13_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG13.Reg, volatile.LoadUint32(&o.EPTCFG13.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG13_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG13.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG13_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG13.Reg, volatile.LoadUint32(&o.EPTCFG13.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG13_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG13.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG13_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG13.Reg, volatile.LoadUint32(&o.EPTCFG13.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG13_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG13.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG13_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG13.Reg, volatile.LoadUint32(&o.EPTCFG13.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG13_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG13.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB13: UDPHS Endpoint Control Enable Register (endpoint = 13)
func (o *UDPHS_Type) SetEPTCTLENB13_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB13.Reg, volatile.LoadUint32(&o.EPTCTLENB13.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB13_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB13.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB13_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB13.Reg, volatile.LoadUint32(&o.EPTCTLENB13.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB13_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB13.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB13_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB13.Reg, volatile.LoadUint32(&o.EPTCTLENB13.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB13_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB13.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB13_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB13.Reg, volatile.LoadUint32(&o.EPTCTLENB13.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB13_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB13.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB13_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB13.Reg, volatile.LoadUint32(&o.EPTCTLENB13.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB13_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB13.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB13_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB13.Reg, volatile.LoadUint32(&o.EPTCTLENB13.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB13_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB13.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB13_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB13.Reg, volatile.LoadUint32(&o.EPTCTLENB13.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB13_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB13.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB13_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB13.Reg, volatile.LoadUint32(&o.EPTCTLENB13.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB13_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB13.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB13_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB13.Reg, volatile.LoadUint32(&o.EPTCTLENB13.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB13_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB13.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB13_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB13.Reg, volatile.LoadUint32(&o.EPTCTLENB13.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB13_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB13.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB13_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB13.Reg, volatile.LoadUint32(&o.EPTCTLENB13.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB13_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB13.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB13_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB13.Reg, volatile.LoadUint32(&o.EPTCTLENB13.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB13_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB13.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB13_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB13.Reg, volatile.LoadUint32(&o.EPTCTLENB13.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB13_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB13.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB13_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB13.Reg, volatile.LoadUint32(&o.EPTCTLENB13.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB13_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB13.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS13: UDPHS Endpoint Control Disable Register (endpoint = 13)
func (o *UDPHS_Type) SetEPTCTLDIS13_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS13.Reg, volatile.LoadUint32(&o.EPTCTLDIS13.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS13_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS13.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS13_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS13.Reg, volatile.LoadUint32(&o.EPTCTLDIS13.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS13_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS13.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS13_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS13.Reg, volatile.LoadUint32(&o.EPTCTLDIS13.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS13_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS13.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS13_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS13.Reg, volatile.LoadUint32(&o.EPTCTLDIS13.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS13_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS13.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS13_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS13.Reg, volatile.LoadUint32(&o.EPTCTLDIS13.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS13_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS13.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS13_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS13.Reg, volatile.LoadUint32(&o.EPTCTLDIS13.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS13_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS13.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS13_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS13.Reg, volatile.LoadUint32(&o.EPTCTLDIS13.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS13_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS13.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS13_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS13.Reg, volatile.LoadUint32(&o.EPTCTLDIS13.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS13_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS13.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS13_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS13.Reg, volatile.LoadUint32(&o.EPTCTLDIS13.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS13_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS13.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS13_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS13.Reg, volatile.LoadUint32(&o.EPTCTLDIS13.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS13_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS13.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS13_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS13.Reg, volatile.LoadUint32(&o.EPTCTLDIS13.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS13_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS13.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS13_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS13.Reg, volatile.LoadUint32(&o.EPTCTLDIS13.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS13_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS13.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS13_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS13.Reg, volatile.LoadUint32(&o.EPTCTLDIS13.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS13_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS13.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS13_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS13.Reg, volatile.LoadUint32(&o.EPTCTLDIS13.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS13_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS13.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL13: UDPHS Endpoint Control Register (endpoint = 13)
func (o *UDPHS_Type) SetEPTCTL13_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL13.Reg, volatile.LoadUint32(&o.EPTCTL13.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL13_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL13.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL13_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL13.Reg, volatile.LoadUint32(&o.EPTCTL13.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL13_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL13.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL13_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL13.Reg, volatile.LoadUint32(&o.EPTCTL13.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL13_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL13.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL13_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL13.Reg, volatile.LoadUint32(&o.EPTCTL13.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL13_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL13.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL13_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL13.Reg, volatile.LoadUint32(&o.EPTCTL13.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL13_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL13.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL13_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL13.Reg, volatile.LoadUint32(&o.EPTCTL13.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL13_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL13.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL13_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL13.Reg, volatile.LoadUint32(&o.EPTCTL13.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL13_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL13.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL13_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL13.Reg, volatile.LoadUint32(&o.EPTCTL13.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL13_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL13.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL13_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL13.Reg, volatile.LoadUint32(&o.EPTCTL13.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL13_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL13.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL13_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL13.Reg, volatile.LoadUint32(&o.EPTCTL13.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL13_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL13.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL13_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL13.Reg, volatile.LoadUint32(&o.EPTCTL13.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL13_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL13.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL13_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL13.Reg, volatile.LoadUint32(&o.EPTCTL13.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL13_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL13.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL13_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL13.Reg, volatile.LoadUint32(&o.EPTCTL13.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL13_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL13.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL13_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL13.Reg, volatile.LoadUint32(&o.EPTCTL13.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL13_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL13.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA13: UDPHS Endpoint Set Status Register (endpoint = 13)
func (o *UDPHS_Type) SetEPTSETSTA13_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA13.Reg, volatile.LoadUint32(&o.EPTSETSTA13.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA13_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA13.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA13_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA13.Reg, volatile.LoadUint32(&o.EPTSETSTA13.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA13_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA13.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA13_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA13.Reg, volatile.LoadUint32(&o.EPTSETSTA13.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA13_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA13.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA13: UDPHS Endpoint Clear Status Register (endpoint = 13)
func (o *UDPHS_Type) SetEPTCLRSTA13_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA13.Reg, volatile.LoadUint32(&o.EPTCLRSTA13.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA13_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA13.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA13_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA13.Reg, volatile.LoadUint32(&o.EPTCLRSTA13.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA13_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA13.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA13_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA13.Reg, volatile.LoadUint32(&o.EPTCLRSTA13.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA13_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA13.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA13_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA13.Reg, volatile.LoadUint32(&o.EPTCLRSTA13.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA13_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA13.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA13_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA13.Reg, volatile.LoadUint32(&o.EPTCLRSTA13.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA13_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA13.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA13_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA13.Reg, volatile.LoadUint32(&o.EPTCLRSTA13.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA13_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA13.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA13_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA13.Reg, volatile.LoadUint32(&o.EPTCLRSTA13.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA13_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA13.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA13_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA13.Reg, volatile.LoadUint32(&o.EPTCLRSTA13.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA13_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA13.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA13: UDPHS Endpoint Status Register (endpoint = 13)
func (o *UDPHS_Type) SetEPTSTA13_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA13.Reg, volatile.LoadUint32(&o.EPTSTA13.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA13_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA13.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA13_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA13.Reg, volatile.LoadUint32(&o.EPTSTA13.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA13_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA13.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA13_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA13.Reg, volatile.LoadUint32(&o.EPTSTA13.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA13_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA13.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA13_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA13.Reg, volatile.LoadUint32(&o.EPTSTA13.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA13_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA13.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA13_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA13.Reg, volatile.LoadUint32(&o.EPTSTA13.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA13_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA13.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA13_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA13.Reg, volatile.LoadUint32(&o.EPTSTA13.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA13_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA13.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA13_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA13.Reg, volatile.LoadUint32(&o.EPTSTA13.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA13_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA13.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA13_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA13.Reg, volatile.LoadUint32(&o.EPTSTA13.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA13_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA13.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA13_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA13.Reg, volatile.LoadUint32(&o.EPTSTA13.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA13_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA13.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA13_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA13.Reg, volatile.LoadUint32(&o.EPTSTA13.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA13_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA13.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA13_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA13.Reg, volatile.LoadUint32(&o.EPTSTA13.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA13_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA13.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA13_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA13.Reg, volatile.LoadUint32(&o.EPTSTA13.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA13_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA13.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA13_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA13.Reg, volatile.LoadUint32(&o.EPTSTA13.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA13_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA13.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA13_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA13.Reg, volatile.LoadUint32(&o.EPTSTA13.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA13_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA13.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG14: UDPHS Endpoint Configuration Register (endpoint = 14)
func (o *UDPHS_Type) SetEPTCFG14_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG14.Reg, volatile.LoadUint32(&o.EPTCFG14.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG14_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG14.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG14_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG14.Reg, volatile.LoadUint32(&o.EPTCFG14.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG14_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG14.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG14_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG14.Reg, volatile.LoadUint32(&o.EPTCFG14.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG14_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG14.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG14_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG14.Reg, volatile.LoadUint32(&o.EPTCFG14.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG14_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG14.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG14_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG14.Reg, volatile.LoadUint32(&o.EPTCFG14.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG14_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG14.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG14_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG14.Reg, volatile.LoadUint32(&o.EPTCFG14.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG14_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG14.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB14: UDPHS Endpoint Control Enable Register (endpoint = 14)
func (o *UDPHS_Type) SetEPTCTLENB14_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB14.Reg, volatile.LoadUint32(&o.EPTCTLENB14.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB14_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB14.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB14_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB14.Reg, volatile.LoadUint32(&o.EPTCTLENB14.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB14_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB14.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB14_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB14.Reg, volatile.LoadUint32(&o.EPTCTLENB14.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB14_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB14.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB14_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB14.Reg, volatile.LoadUint32(&o.EPTCTLENB14.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB14_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB14.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB14_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB14.Reg, volatile.LoadUint32(&o.EPTCTLENB14.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB14_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB14.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB14_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB14.Reg, volatile.LoadUint32(&o.EPTCTLENB14.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB14_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB14.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB14_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB14.Reg, volatile.LoadUint32(&o.EPTCTLENB14.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB14_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB14.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB14_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB14.Reg, volatile.LoadUint32(&o.EPTCTLENB14.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB14_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB14.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB14_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB14.Reg, volatile.LoadUint32(&o.EPTCTLENB14.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB14_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB14.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB14_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB14.Reg, volatile.LoadUint32(&o.EPTCTLENB14.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB14_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB14.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB14_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB14.Reg, volatile.LoadUint32(&o.EPTCTLENB14.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB14_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB14.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB14_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB14.Reg, volatile.LoadUint32(&o.EPTCTLENB14.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB14_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB14.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB14_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB14.Reg, volatile.LoadUint32(&o.EPTCTLENB14.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB14_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB14.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB14_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB14.Reg, volatile.LoadUint32(&o.EPTCTLENB14.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB14_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB14.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS14: UDPHS Endpoint Control Disable Register (endpoint = 14)
func (o *UDPHS_Type) SetEPTCTLDIS14_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS14.Reg, volatile.LoadUint32(&o.EPTCTLDIS14.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS14_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS14.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS14_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS14.Reg, volatile.LoadUint32(&o.EPTCTLDIS14.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS14_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS14.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS14_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS14.Reg, volatile.LoadUint32(&o.EPTCTLDIS14.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS14_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS14.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS14_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS14.Reg, volatile.LoadUint32(&o.EPTCTLDIS14.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS14_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS14.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS14_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS14.Reg, volatile.LoadUint32(&o.EPTCTLDIS14.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS14_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS14.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS14_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS14.Reg, volatile.LoadUint32(&o.EPTCTLDIS14.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS14_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS14.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS14_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS14.Reg, volatile.LoadUint32(&o.EPTCTLDIS14.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS14_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS14.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS14_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS14.Reg, volatile.LoadUint32(&o.EPTCTLDIS14.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS14_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS14.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS14_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS14.Reg, volatile.LoadUint32(&o.EPTCTLDIS14.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS14_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS14.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS14_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS14.Reg, volatile.LoadUint32(&o.EPTCTLDIS14.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS14_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS14.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS14_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS14.Reg, volatile.LoadUint32(&o.EPTCTLDIS14.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS14_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS14.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS14_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS14.Reg, volatile.LoadUint32(&o.EPTCTLDIS14.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS14_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS14.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS14_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS14.Reg, volatile.LoadUint32(&o.EPTCTLDIS14.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS14_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS14.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS14_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS14.Reg, volatile.LoadUint32(&o.EPTCTLDIS14.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS14_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS14.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL14: UDPHS Endpoint Control Register (endpoint = 14)
func (o *UDPHS_Type) SetEPTCTL14_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL14.Reg, volatile.LoadUint32(&o.EPTCTL14.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL14_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL14.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL14_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL14.Reg, volatile.LoadUint32(&o.EPTCTL14.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL14_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL14.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL14_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL14.Reg, volatile.LoadUint32(&o.EPTCTL14.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL14_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL14.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL14_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL14.Reg, volatile.LoadUint32(&o.EPTCTL14.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL14_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL14.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL14_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL14.Reg, volatile.LoadUint32(&o.EPTCTL14.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL14_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL14.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL14_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL14.Reg, volatile.LoadUint32(&o.EPTCTL14.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL14_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL14.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL14_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL14.Reg, volatile.LoadUint32(&o.EPTCTL14.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL14_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL14.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL14_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL14.Reg, volatile.LoadUint32(&o.EPTCTL14.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL14_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL14.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL14_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL14.Reg, volatile.LoadUint32(&o.EPTCTL14.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL14_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL14.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL14_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL14.Reg, volatile.LoadUint32(&o.EPTCTL14.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL14_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL14.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL14_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL14.Reg, volatile.LoadUint32(&o.EPTCTL14.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL14_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL14.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL14_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL14.Reg, volatile.LoadUint32(&o.EPTCTL14.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL14_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL14.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL14_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL14.Reg, volatile.LoadUint32(&o.EPTCTL14.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL14_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL14.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL14_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL14.Reg, volatile.LoadUint32(&o.EPTCTL14.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL14_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL14.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA14: UDPHS Endpoint Set Status Register (endpoint = 14)
func (o *UDPHS_Type) SetEPTSETSTA14_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA14.Reg, volatile.LoadUint32(&o.EPTSETSTA14.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA14_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA14.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA14_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA14.Reg, volatile.LoadUint32(&o.EPTSETSTA14.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA14_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA14.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA14_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA14.Reg, volatile.LoadUint32(&o.EPTSETSTA14.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA14_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA14.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA14: UDPHS Endpoint Clear Status Register (endpoint = 14)
func (o *UDPHS_Type) SetEPTCLRSTA14_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA14.Reg, volatile.LoadUint32(&o.EPTCLRSTA14.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA14_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA14.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA14_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA14.Reg, volatile.LoadUint32(&o.EPTCLRSTA14.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA14_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA14.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA14_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA14.Reg, volatile.LoadUint32(&o.EPTCLRSTA14.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA14_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA14.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA14_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA14.Reg, volatile.LoadUint32(&o.EPTCLRSTA14.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA14_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA14.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA14_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA14.Reg, volatile.LoadUint32(&o.EPTCLRSTA14.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA14_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA14.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA14_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA14.Reg, volatile.LoadUint32(&o.EPTCLRSTA14.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA14_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA14.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA14_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA14.Reg, volatile.LoadUint32(&o.EPTCLRSTA14.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA14_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA14.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA14_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA14.Reg, volatile.LoadUint32(&o.EPTCLRSTA14.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA14_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA14.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA14: UDPHS Endpoint Status Register (endpoint = 14)
func (o *UDPHS_Type) SetEPTSTA14_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA14.Reg, volatile.LoadUint32(&o.EPTSTA14.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA14_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA14.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA14_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA14.Reg, volatile.LoadUint32(&o.EPTSTA14.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA14_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA14.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA14_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA14.Reg, volatile.LoadUint32(&o.EPTSTA14.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA14_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA14.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA14_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA14.Reg, volatile.LoadUint32(&o.EPTSTA14.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA14_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA14.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA14_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA14.Reg, volatile.LoadUint32(&o.EPTSTA14.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA14_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA14.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA14_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA14.Reg, volatile.LoadUint32(&o.EPTSTA14.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA14_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA14.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA14_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA14.Reg, volatile.LoadUint32(&o.EPTSTA14.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA14_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA14.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA14_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA14.Reg, volatile.LoadUint32(&o.EPTSTA14.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA14_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA14.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA14_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA14.Reg, volatile.LoadUint32(&o.EPTSTA14.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA14_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA14.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA14_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA14.Reg, volatile.LoadUint32(&o.EPTSTA14.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA14_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA14.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA14_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA14.Reg, volatile.LoadUint32(&o.EPTSTA14.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA14_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA14.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA14_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA14.Reg, volatile.LoadUint32(&o.EPTSTA14.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA14_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA14.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA14_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA14.Reg, volatile.LoadUint32(&o.EPTSTA14.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA14_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA14.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA14_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA14.Reg, volatile.LoadUint32(&o.EPTSTA14.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA14_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA14.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG15: UDPHS Endpoint Configuration Register (endpoint = 15)
func (o *UDPHS_Type) SetEPTCFG15_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG15.Reg, volatile.LoadUint32(&o.EPTCFG15.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG15_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG15.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG15_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG15.Reg, volatile.LoadUint32(&o.EPTCFG15.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG15_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG15.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG15_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG15.Reg, volatile.LoadUint32(&o.EPTCFG15.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG15_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG15.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG15_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG15.Reg, volatile.LoadUint32(&o.EPTCFG15.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG15_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG15.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG15_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG15.Reg, volatile.LoadUint32(&o.EPTCFG15.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG15_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG15.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG15_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG15.Reg, volatile.LoadUint32(&o.EPTCFG15.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG15_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG15.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB15: UDPHS Endpoint Control Enable Register (endpoint = 15)
func (o *UDPHS_Type) SetEPTCTLENB15_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB15.Reg, volatile.LoadUint32(&o.EPTCTLENB15.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB15_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB15.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB15_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB15.Reg, volatile.LoadUint32(&o.EPTCTLENB15.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB15_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB15.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB15_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB15.Reg, volatile.LoadUint32(&o.EPTCTLENB15.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB15_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB15.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB15_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB15.Reg, volatile.LoadUint32(&o.EPTCTLENB15.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB15_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB15.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB15_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB15.Reg, volatile.LoadUint32(&o.EPTCTLENB15.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB15_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB15.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB15_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB15.Reg, volatile.LoadUint32(&o.EPTCTLENB15.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB15_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB15.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB15_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB15.Reg, volatile.LoadUint32(&o.EPTCTLENB15.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB15_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB15.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB15_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB15.Reg, volatile.LoadUint32(&o.EPTCTLENB15.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB15_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB15.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB15_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB15.Reg, volatile.LoadUint32(&o.EPTCTLENB15.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB15_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB15.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB15_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB15.Reg, volatile.LoadUint32(&o.EPTCTLENB15.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB15_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB15.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB15_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB15.Reg, volatile.LoadUint32(&o.EPTCTLENB15.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB15_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB15.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB15_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB15.Reg, volatile.LoadUint32(&o.EPTCTLENB15.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB15_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB15.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB15_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB15.Reg, volatile.LoadUint32(&o.EPTCTLENB15.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB15_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB15.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB15_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB15.Reg, volatile.LoadUint32(&o.EPTCTLENB15.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB15_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB15.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS15: UDPHS Endpoint Control Disable Register (endpoint = 15)
func (o *UDPHS_Type) SetEPTCTLDIS15_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS15.Reg, volatile.LoadUint32(&o.EPTCTLDIS15.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS15_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS15.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS15_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS15.Reg, volatile.LoadUint32(&o.EPTCTLDIS15.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS15_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS15.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS15_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS15.Reg, volatile.LoadUint32(&o.EPTCTLDIS15.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS15_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS15.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS15_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS15.Reg, volatile.LoadUint32(&o.EPTCTLDIS15.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS15_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS15.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS15_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS15.Reg, volatile.LoadUint32(&o.EPTCTLDIS15.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS15_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS15.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS15_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS15.Reg, volatile.LoadUint32(&o.EPTCTLDIS15.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS15_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS15.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS15_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS15.Reg, volatile.LoadUint32(&o.EPTCTLDIS15.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS15_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS15.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS15_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS15.Reg, volatile.LoadUint32(&o.EPTCTLDIS15.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS15_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS15.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS15_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS15.Reg, volatile.LoadUint32(&o.EPTCTLDIS15.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS15_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS15.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS15_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS15.Reg, volatile.LoadUint32(&o.EPTCTLDIS15.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS15_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS15.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS15_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS15.Reg, volatile.LoadUint32(&o.EPTCTLDIS15.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS15_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS15.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS15_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS15.Reg, volatile.LoadUint32(&o.EPTCTLDIS15.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS15_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS15.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS15_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS15.Reg, volatile.LoadUint32(&o.EPTCTLDIS15.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS15_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS15.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS15_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS15.Reg, volatile.LoadUint32(&o.EPTCTLDIS15.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS15_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS15.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL15: UDPHS Endpoint Control Register (endpoint = 15)
func (o *UDPHS_Type) SetEPTCTL15_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL15.Reg, volatile.LoadUint32(&o.EPTCTL15.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL15_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL15.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL15_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL15.Reg, volatile.LoadUint32(&o.EPTCTL15.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL15_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL15.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL15_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL15.Reg, volatile.LoadUint32(&o.EPTCTL15.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL15_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL15.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL15_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL15.Reg, volatile.LoadUint32(&o.EPTCTL15.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL15_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL15.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL15_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL15.Reg, volatile.LoadUint32(&o.EPTCTL15.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL15_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL15.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL15_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL15.Reg, volatile.LoadUint32(&o.EPTCTL15.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL15_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL15.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL15_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL15.Reg, volatile.LoadUint32(&o.EPTCTL15.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL15_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL15.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL15_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL15.Reg, volatile.LoadUint32(&o.EPTCTL15.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL15_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL15.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL15_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL15.Reg, volatile.LoadUint32(&o.EPTCTL15.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL15_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL15.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL15_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL15.Reg, volatile.LoadUint32(&o.EPTCTL15.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL15_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL15.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL15_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL15.Reg, volatile.LoadUint32(&o.EPTCTL15.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL15_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL15.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL15_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL15.Reg, volatile.LoadUint32(&o.EPTCTL15.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL15_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL15.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL15_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL15.Reg, volatile.LoadUint32(&o.EPTCTL15.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL15_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL15.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL15_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL15.Reg, volatile.LoadUint32(&o.EPTCTL15.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL15_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL15.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA15: UDPHS Endpoint Set Status Register (endpoint = 15)
func (o *UDPHS_Type) SetEPTSETSTA15_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA15.Reg, volatile.LoadUint32(&o.EPTSETSTA15.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA15_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA15.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA15_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA15.Reg, volatile.LoadUint32(&o.EPTSETSTA15.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA15_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA15.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA15_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA15.Reg, volatile.LoadUint32(&o.EPTSETSTA15.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA15_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA15.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA15: UDPHS Endpoint Clear Status Register (endpoint = 15)
func (o *UDPHS_Type) SetEPTCLRSTA15_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA15.Reg, volatile.LoadUint32(&o.EPTCLRSTA15.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA15_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA15.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA15_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA15.Reg, volatile.LoadUint32(&o.EPTCLRSTA15.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA15_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA15.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA15_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA15.Reg, volatile.LoadUint32(&o.EPTCLRSTA15.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA15_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA15.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA15_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA15.Reg, volatile.LoadUint32(&o.EPTCLRSTA15.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA15_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA15.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA15_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA15.Reg, volatile.LoadUint32(&o.EPTCLRSTA15.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA15_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA15.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA15_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA15.Reg, volatile.LoadUint32(&o.EPTCLRSTA15.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA15_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA15.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA15_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA15.Reg, volatile.LoadUint32(&o.EPTCLRSTA15.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA15_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA15.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA15_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA15.Reg, volatile.LoadUint32(&o.EPTCLRSTA15.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA15_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA15.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA15: UDPHS Endpoint Status Register (endpoint = 15)
func (o *UDPHS_Type) SetEPTSTA15_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA15.Reg, volatile.LoadUint32(&o.EPTSTA15.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA15_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA15.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA15_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA15.Reg, volatile.LoadUint32(&o.EPTSTA15.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA15_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA15.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA15_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA15.Reg, volatile.LoadUint32(&o.EPTSTA15.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA15_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA15.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA15_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA15.Reg, volatile.LoadUint32(&o.EPTSTA15.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA15_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA15.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA15_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA15.Reg, volatile.LoadUint32(&o.EPTSTA15.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA15_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA15.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA15_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA15.Reg, volatile.LoadUint32(&o.EPTSTA15.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA15_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA15.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA15_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA15.Reg, volatile.LoadUint32(&o.EPTSTA15.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA15_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA15.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA15_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA15.Reg, volatile.LoadUint32(&o.EPTSTA15.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA15_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA15.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA15_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA15.Reg, volatile.LoadUint32(&o.EPTSTA15.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA15_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA15.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA15_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA15.Reg, volatile.LoadUint32(&o.EPTSTA15.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA15_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA15.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA15_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA15.Reg, volatile.LoadUint32(&o.EPTSTA15.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA15_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA15.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA15_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA15.Reg, volatile.LoadUint32(&o.EPTSTA15.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA15_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA15.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA15_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA15.Reg, volatile.LoadUint32(&o.EPTSTA15.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA15_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA15.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA15_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA15.Reg, volatile.LoadUint32(&o.EPTSTA15.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA15_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA15.Reg) & 0x80000000) >> 31
}

// UDPHS.DMANXTDSC0: UDPHS DMA Next Descriptor Address Register (channel = 0)
func (o *UDPHS_Type) SetDMANXTDSC0(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC0.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC0() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC0.Reg)
}

// UDPHS.DMAADDRESS0: UDPHS DMA Channel Address Register (channel = 0)
func (o *UDPHS_Type) SetDMAADDRESS0(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS0.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS0() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS0.Reg)
}

// UDPHS.DMACONTROL0: UDPHS DMA Channel Control Register (channel = 0)
func (o *UDPHS_Type) SetDMACONTROL0_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL0_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL0_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL0_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL0_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL0_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL0_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL0_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL0_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL0_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL0_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL0_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL0_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL0_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS0: UDPHS DMA Channel Status Register (channel = 0)
func (o *UDPHS_Type) SetDMASTATUS0_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS0_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS0_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS0_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS0_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS0_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS0_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS0_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS0_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS0_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS0_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS0_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC1: UDPHS DMA Next Descriptor Address Register (channel = 1)
func (o *UDPHS_Type) SetDMANXTDSC1(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC1.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC1() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC1.Reg)
}

// UDPHS.DMAADDRESS1: UDPHS DMA Channel Address Register (channel = 1)
func (o *UDPHS_Type) SetDMAADDRESS1(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS1.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS1() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS1.Reg)
}

// UDPHS.DMACONTROL1: UDPHS DMA Channel Control Register (channel = 1)
func (o *UDPHS_Type) SetDMACONTROL1_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL1_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL1_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL1_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL1_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL1_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL1_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL1_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL1_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL1_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL1_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL1_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL1_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL1_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS1: UDPHS DMA Channel Status Register (channel = 1)
func (o *UDPHS_Type) SetDMASTATUS1_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS1_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS1_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS1_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS1_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS1_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS1_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS1_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS1_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS1_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS1_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS1_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC2: UDPHS DMA Next Descriptor Address Register (channel = 2)
func (o *UDPHS_Type) SetDMANXTDSC2(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC2.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC2() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC2.Reg)
}

// UDPHS.DMAADDRESS2: UDPHS DMA Channel Address Register (channel = 2)
func (o *UDPHS_Type) SetDMAADDRESS2(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS2.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS2() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS2.Reg)
}

// UDPHS.DMACONTROL2: UDPHS DMA Channel Control Register (channel = 2)
func (o *UDPHS_Type) SetDMACONTROL2_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL2_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL2_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL2_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL2_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL2_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL2_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL2_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL2_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL2_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL2_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL2_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL2_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL2_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS2: UDPHS DMA Channel Status Register (channel = 2)
func (o *UDPHS_Type) SetDMASTATUS2_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS2_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS2_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS2_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS2_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS2_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS2_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS2_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS2_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS2_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS2_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS2_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC3: UDPHS DMA Next Descriptor Address Register (channel = 3)
func (o *UDPHS_Type) SetDMANXTDSC3(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC3.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC3() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC3.Reg)
}

// UDPHS.DMAADDRESS3: UDPHS DMA Channel Address Register (channel = 3)
func (o *UDPHS_Type) SetDMAADDRESS3(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS3.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS3() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS3.Reg)
}

// UDPHS.DMACONTROL3: UDPHS DMA Channel Control Register (channel = 3)
func (o *UDPHS_Type) SetDMACONTROL3_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL3_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL3_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL3_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL3_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL3_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL3_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL3_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL3_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL3_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL3_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL3_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL3_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL3_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS3: UDPHS DMA Channel Status Register (channel = 3)
func (o *UDPHS_Type) SetDMASTATUS3_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS3_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS3_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS3_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS3_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS3_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS3_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS3_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS3_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS3_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS3_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS3_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC4: UDPHS DMA Next Descriptor Address Register (channel = 4)
func (o *UDPHS_Type) SetDMANXTDSC4(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC4.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC4() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC4.Reg)
}

// UDPHS.DMAADDRESS4: UDPHS DMA Channel Address Register (channel = 4)
func (o *UDPHS_Type) SetDMAADDRESS4(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS4.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS4() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS4.Reg)
}

// UDPHS.DMACONTROL4: UDPHS DMA Channel Control Register (channel = 4)
func (o *UDPHS_Type) SetDMACONTROL4_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL4_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL4_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL4_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL4_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL4_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL4_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL4_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL4_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL4_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL4_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL4_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL4_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL4_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS4: UDPHS DMA Channel Status Register (channel = 4)
func (o *UDPHS_Type) SetDMASTATUS4_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS4_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS4_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS4_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS4_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS4_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS4_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS4_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS4_DESC_LDST(value uint32) {
	volatile.StoreUint32