// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32g0c1.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32g0c1

// STM32G0C1
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32G0C1"
	CPU          = "CM0"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// System window watchdog
	IRQ_WWDG = 0

	// Power control
	IRQ_PVD = 1

	// Real-time clock
	IRQ_RTC_TAMP = 2

	// Flash
	IRQ_FLASH = 3

	// Reset and clock control
	IRQ_RCC_CRS = 4

	// External interrupt/event controller
	IRQ_EXTI0_1 = 5

	// External interrupt/event controller
	IRQ_EXTI2_3 = 6

	// External interrupt/event controller
	IRQ_EXTI4_15 = 7

	// USB Power Delivery interface
	IRQ_UCPD1_UCPD2_USB = 8

	// Analog to Digital Converter
	IRQ_ADC_COMP = 12

	// Advanced-timers
	IRQ_TIM1_BRK_UP_TRG_COM = 13

	// Advanced-timers
	IRQ_TIM1_CC = 14

	// General-purpose-timers
	IRQ_TIM2 = 15

	IRQ_TIM3_TIM4 = 16

	// Basic timers
	IRQ_TIM6_DAC = 17

	IRQ_TIM7 = 18

	// General purpose timers
	IRQ_TIM14 = 19

	// General purpose timers
	IRQ_TIM15 = 20

	// General purpose timers
	IRQ_TIM16 = 21

	IRQ_TIM17 = 22

	// Inter-integrated circuit
	IRQ_I2C1 = 23

	IRQ_I2C2_I2C3 = 24

	// Serial peripheral interface
	IRQ_SPI1 = 25

	IRQ_SPI2_SPI3 = 26

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 27

	IRQ_USART2_LPUART2 = 28

	IRQ_USART3_USART4_USART5_USART6_LPUART1 = 29

	// HDMI-CEC
	IRQ_CEC = 30

	// Random number generator
	IRQ_AES_RNG = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG_IRQHandler
func interruptWWDG() {
	callHandlers(IRQ_WWDG)
}

//export PVD_IRQHandler
func interruptPVD() {
	callHandlers(IRQ_PVD)
}

//export RTC_TAMP_IRQHandler
func interruptRTC_TAMP() {
	callHandlers(IRQ_RTC_TAMP)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export RCC_CRS_IRQHandler
func interruptRCC_CRS() {
	callHandlers(IRQ_RCC_CRS)
}

//export EXTI0_1_IRQHandler
func interruptEXTI0_1() {
	callHandlers(IRQ_EXTI0_1)
}

//export EXTI2_3_IRQHandler
func interruptEXTI2_3() {
	callHandlers(IRQ_EXTI2_3)
}

//export EXTI4_15_IRQHandler
func interruptEXTI4_15() {
	callHandlers(IRQ_EXTI4_15)
}

//export UCPD1_UCPD2_USB_IRQHandler
func interruptUCPD1_UCPD2_USB() {
	callHandlers(IRQ_UCPD1_UCPD2_USB)
}

//export ADC_COMP_IRQHandler
func interruptADC_COMP() {
	callHandlers(IRQ_ADC_COMP)
}

//export TIM1_BRK_UP_TRG_COM_IRQHandler
func interruptTIM1_BRK_UP_TRG_COM() {
	callHandlers(IRQ_TIM1_BRK_UP_TRG_COM)
}

//export TIM1_CC_IRQHandler
func interruptTIM1_CC() {
	callHandlers(IRQ_TIM1_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM3_TIM4_IRQHandler
func interruptTIM3_TIM4() {
	callHandlers(IRQ_TIM3_TIM4)
}

//export TIM6_DAC_IRQHandler
func interruptTIM6_DAC() {
	callHandlers(IRQ_TIM6_DAC)
}

//export TIM7_IRQHandler
func interruptTIM7() {
	callHandlers(IRQ_TIM7)
}

//export TIM14_IRQHandler
func interruptTIM14() {
	callHandlers(IRQ_TIM14)
}

//export TIM15_IRQHandler
func interruptTIM15() {
	callHandlers(IRQ_TIM15)
}

//export TIM16_IRQHandler
func interruptTIM16() {
	callHandlers(IRQ_TIM16)
}

//export TIM17_IRQHandler
func interruptTIM17() {
	callHandlers(IRQ_TIM17)
}

//export I2C1_IRQHandler
func interruptI2C1() {
	callHandlers(IRQ_I2C1)
}

//export I2C2_I2C3_IRQHandler
func interruptI2C2_I2C3() {
	callHandlers(IRQ_I2C2_I2C3)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_SPI3_IRQHandler
func interruptSPI2_SPI3() {
	callHandlers(IRQ_SPI2_SPI3)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_LPUART2_IRQHandler
func interruptUSART2_LPUART2() {
	callHandlers(IRQ_USART2_LPUART2)
}

//export USART3_USART4_USART5_USART6_LPUART1_IRQHandler
func interruptUSART3_USART4_USART5_USART6_LPUART1() {
	callHandlers(IRQ_USART3_USART4_USART5_USART6_LPUART1)
}

//export CEC_IRQHandler
func interruptCEC() {
	callHandlers(IRQ_CEC)
}

//export AES_RNG_IRQHandler
func interruptAES_RNG() {
	callHandlers(IRQ_AES_RNG)
}

// Peripherals.
var (
	// Advanced Encryption Standard
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// Analog to Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012400)))

	// Comparator
	COMP = (*COMP_Type)(unsafe.Pointer(uintptr(0x40010200)))

	// Cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// DAC
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// Debug support
	DBG = (*DBG_Type)(unsafe.Pointer(uintptr(0x40015800)))

	// DMAMUX
	DMAMUX = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40021800)))

	// FD controller area network
	FDCAN1 = (*FDCAN_Type)(unsafe.Pointer(uintptr(0x40006400)))

	// Flash
	FLASH = (*Flash_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000400)))

	// HDMI-CEC
	HDMI_CEC = (*CEC_Type)(unsafe.Pointer(uintptr(0x40007800)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Low power timer
	LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Low-power universal asynchronous receiver transmitter
	LPUART1 = (*LPUART_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// Random number generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x40025000)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Serial peripheral interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Tamper and backup registers
	TAMP = (*TAMP_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// General-purpose-timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Basic timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// General purpose timers
	TIM14 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// General purpose timers
	TIM15 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General purpose timers
	TIM16 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// USB Power Delivery interface
	UCPD1 = (*UCPD_Type)(unsafe.Pointer(uintptr(0x4000a000)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Universal serial bus full-speed host/device interface
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// System configuration controller
	VREFBUF = (*VREFBUF_Type)(unsafe.Pointer(uintptr(0x40010030)))

	// System window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// DMA controller
	DMA1 = (*DMA1_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// DMA controller
	DMA2 = (*DMA2_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// FD controller area network
	FDCAN2 = (*FDCAN_Type)(unsafe.Pointer(uintptr(0x40006800)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000800)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000c00)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50001000)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50001400)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40008800)))

	// Low power timer
	LPTIM2 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40009400)))

	// Low-power universal asynchronous receiver transmitter
	LPUART2 = (*LPUART_Type)(unsafe.Pointer(uintptr(0x40008400)))

	// Serial peripheral interface
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// General-purpose-timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// General-purpose-timers
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// Basic timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// General purpose timers
	TIM17 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// USB Power Delivery interface
	UCPD2 = (*UCPD_Type)(unsafe.Pointer(uintptr(0x4000a400)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Universal synchronous asynchronous receiver transmitter
	USART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Universal synchronous asynchronous receiver transmitter
	USART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Universal synchronous asynchronous receiver transmitter
	USART6 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013c00)))
)

// Advanced Encryption Standard
type AES_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	DINR   volatile.Register32 // 0x8
	DOUTR  volatile.Register32 // 0xC
	KEYR0  volatile.Register32 // 0x10
	KEYR1  volatile.Register32 // 0x14
	KEYR2  volatile.Register32 // 0x18
	KEYR3  volatile.Register32 // 0x1C
	IVR0   volatile.Register32 // 0x20
	IVR1   volatile.Register32 // 0x24
	IVR2   volatile.Register32 // 0x28
	IVR3   volatile.Register32 // 0x2C
	KEYR4  volatile.Register32 // 0x30
	KEYR5  volatile.Register32 // 0x34
	KEYR6  volatile.Register32 // 0x38
	KEYR7  volatile.Register32 // 0x3C
	SUSP0R volatile.Register32 // 0x40
	SUSP1R volatile.Register32 // 0x44
	SUSP2R volatile.Register32 // 0x48
	SUSP3R volatile.Register32 // 0x4C
	SUSP4R volatile.Register32 // 0x50
	SUSP5R volatile.Register32 // 0x54
	SUSP6R volatile.Register32 // 0x58
	SUSP7R volatile.Register32 // 0x5C
}

// AES.CR: AES control register
func (o *AES_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *AES_Type) SetCR_DATATYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6)|value<<1)
}
func (o *AES_Type) GetCR_DATATYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6) >> 1
}
func (o *AES_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *AES_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *AES_Type) SetCR_CHMOD1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *AES_Type) GetCR_CHMOD1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *AES_Type) SetCR_CCFC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *AES_Type) GetCR_CCFC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *AES_Type) SetCR_ERRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetCR_ERRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetCR_CCFIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *AES_Type) GetCR_CCFIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *AES_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *AES_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *AES_Type) SetCR_DMAINEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *AES_Type) GetCR_DMAINEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *AES_Type) SetCR_DMAOUTEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *AES_Type) GetCR_DMAOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *AES_Type) SetCR_GCMPH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6000)|value<<13)
}
func (o *AES_Type) GetCR_GCMPH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6000) >> 13
}
func (o *AES_Type) SetCR_CHMOD2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetCR_CHMOD2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *AES_Type) SetCR_KEYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *AES_Type) GetCR_KEYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *AES_Type) SetCR_NPBLB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00000)|value<<20)
}
func (o *AES_Type) GetCR_NPBLB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00000) >> 20
}

// AES.SR: AES status register
func (o *AES_Type) SetSR_CCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetSR_CCF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *AES_Type) SetSR_RDERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *AES_Type) GetSR_RDERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *AES_Type) SetSR_WRERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *AES_Type) GetSR_WRERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *AES_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *AES_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}

// AES.DINR: AES data input register
func (o *AES_Type) SetDINR(value uint32) {
	volatile.StoreUint32(&o.DINR.Reg, value)
}
func (o *AES_Type) GetDINR() uint32 {
	return volatile.LoadUint32(&o.DINR.Reg)
}

// AES.DOUTR: AES data output register
func (o *AES_Type) SetDOUTR(value uint32) {
	volatile.StoreUint32(&o.DOUTR.Reg, value)
}
func (o *AES_Type) GetDOUTR() uint32 {
	return volatile.LoadUint32(&o.DOUTR.Reg)
}

// AES.KEYR0: AES key register 0
func (o *AES_Type) SetKEYR0(value uint32) {
	volatile.StoreUint32(&o.KEYR0.Reg, value)
}
func (o *AES_Type) GetKEYR0() uint32 {
	return volatile.LoadUint32(&o.KEYR0.Reg)
}

// AES.KEYR1: AES key register 1
func (o *AES_Type) SetKEYR1(value uint32) {
	volatile.StoreUint32(&o.KEYR1.Reg, value)
}
func (o *AES_Type) GetKEYR1() uint32 {
	return volatile.LoadUint32(&o.KEYR1.Reg)
}

// AES.KEYR2: AES key register 2
func (o *AES_Type) SetKEYR2(value uint32) {
	volatile.StoreUint32(&o.KEYR2.Reg, value)
}
func (o *AES_Type) GetKEYR2() uint32 {
	return volatile.LoadUint32(&o.KEYR2.Reg)
}

// AES.KEYR3: AES key register 3
func (o *AES_Type) SetKEYR3(value uint32) {
	volatile.StoreUint32(&o.KEYR3.Reg, value)
}
func (o *AES_Type) GetKEYR3() uint32 {
	return volatile.LoadUint32(&o.KEYR3.Reg)
}

// AES.IVR0: AES initialization vector register 0
func (o *AES_Type) SetIVR0(value uint32) {
	volatile.StoreUint32(&o.IVR0.Reg, value)
}
func (o *AES_Type) GetIVR0() uint32 {
	return volatile.LoadUint32(&o.IVR0.Reg)
}

// AES.IVR1: AES initialization vector register 1
func (o *AES_Type) SetIVR1(value uint32) {
	volatile.StoreUint32(&o.IVR1.Reg, value)
}
func (o *AES_Type) GetIVR1() uint32 {
	return volatile.LoadUint32(&o.IVR1.Reg)
}

// AES.IVR2: AES initialization vector register 2
func (o *AES_Type) SetIVR2(value uint32) {
	volatile.StoreUint32(&o.IVR2.Reg, value)
}
func (o *AES_Type) GetIVR2() uint32 {
	return volatile.LoadUint32(&o.IVR2.Reg)
}

// AES.IVR3: AES initialization vector register 3
func (o *AES_Type) SetIVR3(value uint32) {
	volatile.StoreUint32(&o.IVR3.Reg, value)
}
func (o *AES_Type) GetIVR3() uint32 {
	return volatile.LoadUint32(&o.IVR3.Reg)
}

// AES.KEYR4: AES key register 4
func (o *AES_Type) SetKEYR4(value uint32) {
	volatile.StoreUint32(&o.KEYR4.Reg, value)
}
func (o *AES_Type) GetKEYR4() uint32 {
	return volatile.LoadUint32(&o.KEYR4.Reg)
}

// AES.KEYR5: AES key register 5
func (o *AES_Type) SetKEYR5(value uint32) {
	volatile.StoreUint32(&o.KEYR5.Reg, value)
}
func (o *AES_Type) GetKEYR5() uint32 {
	return volatile.LoadUint32(&o.KEYR5.Reg)
}

// AES.KEYR6: AES key register 6
func (o *AES_Type) SetKEYR6(value uint32) {
	volatile.StoreUint32(&o.KEYR6.Reg, value)
}
func (o *AES_Type) GetKEYR6() uint32 {
	return volatile.LoadUint32(&o.KEYR6.Reg)
}

// AES.KEYR7: AES key register 7
func (o *AES_Type) SetKEYR7(value uint32) {
	volatile.StoreUint32(&o.KEYR7.Reg, value)
}
func (o *AES_Type) GetKEYR7() uint32 {
	return volatile.LoadUint32(&o.KEYR7.Reg)
}

// AES.SUSP0R: AES suspend registers
func (o *AES_Type) SetSUSP0R(value uint32) {
	volatile.StoreUint32(&o.SUSP0R.Reg, value)
}
func (o *AES_Type) GetSUSP0R() uint32 {
	return volatile.LoadUint32(&o.SUSP0R.Reg)
}

// AES.SUSP1R: AES suspend registers
func (o *AES_Type) SetSUSP1R(value uint32) {
	volatile.StoreUint32(&o.SUSP1R.Reg, value)
}
func (o *AES_Type) GetSUSP1R() uint32 {
	return volatile.LoadUint32(&o.SUSP1R.Reg)
}

// AES.SUSP2R: AES suspend registers
func (o *AES_Type) SetSUSP2R(value uint32) {
	volatile.StoreUint32(&o.SUSP2R.Reg, value)
}
func (o *AES_Type) GetSUSP2R() uint32 {
	return volatile.LoadUint32(&o.SUSP2R.Reg)
}

// AES.SUSP3R: AES suspend registers
func (o *AES_Type) SetSUSP3R(value uint32) {
	volatile.StoreUint32(&o.SUSP3R.Reg, value)
}
func (o *AES_Type) GetSUSP3R() uint32 {
	return volatile.LoadUint32(&o.SUSP3R.Reg)
}

// AES.SUSP4R: AES suspend registers
func (o *AES_Type) SetSUSP4R(value uint32) {
	volatile.StoreUint32(&o.SUSP4R.Reg, value)
}
func (o *AES_Type) GetSUSP4R() uint32 {
	return volatile.LoadUint32(&o.SUSP4R.Reg)
}

// AES.SUSP5R: AES suspend registers
func (o *AES_Type) SetSUSP5R(value uint32) {
	volatile.StoreUint32(&o.SUSP5R.Reg, value)
}
func (o *AES_Type) GetSUSP5R() uint32 {
	return volatile.LoadUint32(&o.SUSP5R.Reg)
}

// AES.SUSP6R: AES suspend registers
func (o *AES_Type) SetSUSP6R(value uint32) {
	volatile.StoreUint32(&o.SUSP6R.Reg, value)
}
func (o *AES_Type) GetSUSP6R() uint32 {
	return volatile.LoadUint32(&o.SUSP6R.Reg)
}

// AES.SUSP7R: AES suspend registers
func (o *AES_Type) SetSUSP7R(value uint32) {
	volatile.StoreUint32(&o.SUSP7R.Reg, value)
}
func (o *AES_Type) GetSUSP7R() uint32 {
	return volatile.LoadUint32(&o.SUSP7R.Reg)
}

// Analog to Digital Converter
type ADC_Type struct {
	ISR     volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	CR      volatile.Register32 // 0x8
	CFGR1   volatile.Register32 // 0xC
	CFGR2   volatile.Register32 // 0x10
	SMPR    volatile.Register32 // 0x14
	_       [8]byte
	AWD1TR  volatile.Register32 // 0x20
	AWD2TR  volatile.Register32 // 0x24
	CHSELR  volatile.Register32 // 0x28
	AWD3TR  volatile.Register32 // 0x2C
	_       [16]byte
	DR      volatile.Register32 // 0x40
	_       [92]byte
	AWD2CR  volatile.Register32 // 0xA0
	AWD3CR  volatile.Register32 // 0xA4
	_       [12]byte
	CALFACT volatile.Register32 // 0xB4
	_       [592]byte
	CCR     volatile.Register32 // 0x308
}

// ADC.ISR: ADC interrupt and status register
func (o *ADC_Type) SetISR_ADRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetISR_ADRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *ADC_Type) SetISR_EOSMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetISR_EOSMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetISR_EOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetISR_EOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetISR_EOS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetISR_EOS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetISR_AWD1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetISR_AWD1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetISR_AWD2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetISR_AWD2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetISR_AWD3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetISR_AWD3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetISR_EOCAL(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetISR_EOCAL() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetISR_CCRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetISR_CCRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}

// ADC.IER: ADC interrupt enable register
func (o *ADC_Type) SetIER_ADRDYIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIER_ADRDYIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *ADC_Type) SetIER_EOSMPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIER_EOSMPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIER_EOCIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIER_EOCIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIER_EOSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIER_EOSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIER_OVRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIER_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIER_AWD1IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIER_AWD1IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIER_AWD2IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIER_AWD2IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIER_AWD3IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIER_AWD3IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIER_EOCALIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIER_EOCALIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIER_CCRDYIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetIER_CCRDYIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}

// ADC.CR: ADC control register
func (o *ADC_Type) SetCR_ADEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR_ADEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *ADC_Type) SetCR_ADDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR_ADDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR_ADSTART(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCR_ADSTART() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCR_ADSTP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCR_ADSTP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCR_ADVREGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetCR_ADVREGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetCR_ADCAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCR_ADCAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// ADC.CFGR1: ADC configuration register 1
func (o *ADC_Type) SetCFGR1_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCFGR1_DMAEN() uint32 {
	return volatile.LoadUint32(&o.CFGR1.Reg) & 0x1
}
func (o *ADC_Type) SetCFGR1_DMACFG(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCFGR1_DMACFG() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCFGR1_SCANDIR(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCFGR1_SCANDIR() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCFGR1_RES(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x18)|value<<3)
}
func (o *ADC_Type) GetCFGR1_RES() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x18) >> 3
}
func (o *ADC_Type) SetCFGR1_ALIGN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCFGR1_ALIGN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCFGR1_EXTSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetCFGR1_EXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetCFGR1_EXTEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xc00)|value<<10)
}
func (o *ADC_Type) GetCFGR1_EXTEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xc00) >> 10
}
func (o *ADC_Type) SetCFGR1_OVRMOD(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCFGR1_OVRMOD() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCFGR1_CONT(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCFGR1_CONT() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCFGR1_WAIT(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCFGR1_WAIT() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCFGR1_AUTOFF(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetCFGR1_AUTOFF() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetCFGR1_DISCEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCFGR1_DISCEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCFGR1_CHSELRMOD(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetCFGR1_CHSELRMOD() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetCFGR1_AWD1SGL(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCFGR1_AWD1SGL() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCFGR1_AWD1EN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCFGR1_AWD1EN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCFGR1_AWD1CH(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetCFGR1_AWD1CH() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x7c000000) >> 26
}

// ADC.CFGR2: ADC configuration register 2
func (o *ADC_Type) SetCFGR2_OVSE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCFGR2_OVSE() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x1
}
func (o *ADC_Type) SetCFGR2_OVSR(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1c)|value<<2)
}
func (o *ADC_Type) GetCFGR2_OVSR() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x1c) >> 2
}
func (o *ADC_Type) SetCFGR2_OVSS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1e0)|value<<5)
}
func (o *ADC_Type) GetCFGR2_OVSS() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x1e0) >> 5
}
func (o *ADC_Type) SetCFGR2_TOVS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCFGR2_TOVS() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCFGR2_LFTRIG(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetCFGR2_LFTRIG() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetCFGR2_CKMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0xc0000000)|value<<30)
}
func (o *ADC_Type) GetCFGR2_CKMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0xc0000000) >> 30
}

// ADC.SMPR: ADC sampling time register
func (o *ADC_Type) SetSMPR_SMP1(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR_SMP1() uint32 {
	return volatile.LoadUint32(&o.SMPR.Reg) & 0x7
}
func (o *ADC_Type) SetSMPR_SMP2(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x70)|value<<4)
}
func (o *ADC_Type) GetSMPR_SMP2() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x70) >> 4
}
func (o *ADC_Type) SetSMPR_SMPSEL0(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetSMPR_SMPSEL0() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetSMPR_SMPSEL1(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetSMPR_SMPSEL1() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetSMPR_SMPSEL2(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetSMPR_SMPSEL2() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetSMPR_SMPSEL3(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetSMPR_SMPSEL3() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetSMPR_SMPSEL4(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetSMPR_SMPSEL4() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetSMPR_SMPSEL5(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetSMPR_SMPSEL5() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetSMPR_SMPSEL6(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetSMPR_SMPSEL6() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetSMPR_SMPSEL7(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetSMPR_SMPSEL7() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetSMPR_SMPSEL8(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetSMPR_SMPSEL8() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetSMPR_SMPSEL9(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetSMPR_SMPSEL9() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetSMPR_SMPSEL10(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetSMPR_SMPSEL10() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetSMPR_SMPSEL11(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetSMPR_SMPSEL11() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x80000) >> 19
}
func (o *ADC_Type) SetSMPR_SMPSEL12(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetSMPR_SMPSEL12() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetSMPR_SMPSEL13(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetSMPR_SMPSEL13() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetSMPR_SMPSEL14(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetSMPR_SMPSEL14() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetSMPR_SMPSEL15(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetSMPR_SMPSEL15() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetSMPR_SMPSEL16(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetSMPR_SMPSEL16() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetSMPR_SMPSEL17(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetSMPR_SMPSEL17() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetSMPR_SMPSEL18(value uint32) {
	volatile.StoreUint32(&o.SMPR.Reg, volatile.LoadUint32(&o.SMPR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetSMPR_SMPSEL18() uint32 {
	return (volatile.LoadUint32(&o.SMPR.Reg) & 0x4000000) >> 26
}

// ADC.AWD1TR: ADC watchdog threshold register
func (o *ADC_Type) SetAWD1TR_LT1(value uint32) {
	volatile.StoreUint32(&o.AWD1TR.Reg, volatile.LoadUint32(&o.AWD1TR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetAWD1TR_LT1() uint32 {
	return volatile.LoadUint32(&o.AWD1TR.Reg) & 0xfff
}
func (o *ADC_Type) SetAWD1TR_HT1(value uint32) {
	volatile.StoreUint32(&o.AWD1TR.Reg, volatile.LoadUint32(&o.AWD1TR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetAWD1TR_HT1() uint32 {
	return (volatile.LoadUint32(&o.AWD1TR.Reg) & 0xfff0000) >> 16
}

// ADC.AWD2TR: ADC watchdog threshold register
func (o *ADC_Type) SetAWD2TR_LT2(value uint32) {
	volatile.StoreUint32(&o.AWD2TR.Reg, volatile.LoadUint32(&o.AWD2TR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetAWD2TR_LT2() uint32 {
	return volatile.LoadUint32(&o.AWD2TR.Reg) & 0xfff
}
func (o *ADC_Type) SetAWD2TR_HT2(value uint32) {
	volatile.StoreUint32(&o.AWD2TR.Reg, volatile.LoadUint32(&o.AWD2TR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetAWD2TR_HT2() uint32 {
	return (volatile.LoadUint32(&o.AWD2TR.Reg) & 0xfff0000) >> 16
}

// ADC.CHSELR: ADC channel selection register [alternate]
func (o *ADC_Type) SetCHSELR_CHSEL0(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHSELR_CHSEL0() uint32 {
	return volatile.LoadUint32(&o.CHSELR.Reg) & 0x1
}
func (o *ADC_Type) SetCHSELR_CHSEL1(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHSELR_CHSEL1() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHSELR_CHSEL2(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHSELR_CHSEL2() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHSELR_CHSEL3(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHSELR_CHSEL3() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHSELR_CHSEL4(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHSELR_CHSEL4() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHSELR_CHSEL5(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHSELR_CHSEL5() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHSELR_CHSEL6(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHSELR_CHSEL6() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHSELR_CHSEL7(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHSELR_CHSEL7() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHSELR_CHSEL8(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHSELR_CHSEL8() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHSELR_CHSEL9(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHSELR_CHSEL9() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHSELR_CHSEL10(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHSELR_CHSEL10() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHSELR_CHSEL11(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHSELR_CHSEL11() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCHSELR_CHSEL12(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCHSELR_CHSEL12() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCHSELR_CHSEL13(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCHSELR_CHSEL13() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCHSELR_CHSEL14(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCHSELR_CHSEL14() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCHSELR_CHSEL15(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetCHSELR_CHSEL15() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetCHSELR_CHSEL16(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCHSELR_CHSEL16() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCHSELR_CHSEL17(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetCHSELR_CHSEL17() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetCHSELR_CHSEL18(value uint32) {
	volatile.StoreUint32(&o.CHSELR.Reg, volatile.LoadUint32(&o.CHSELR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetCHSELR_CHSEL18() uint32 {
	return (volatile.LoadUint32(&o.CHSELR.Reg) & 0x40000) >> 18
}

// ADC.AWD3TR: ADC watchdog threshold register
func (o *ADC_Type) SetAWD3TR_LT3(value uint32) {
	volatile.StoreUint32(&o.AWD3TR.Reg, volatile.LoadUint32(&o.AWD3TR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetAWD3TR_LT3() uint32 {
	return volatile.LoadUint32(&o.AWD3TR.Reg) & 0xfff
}
func (o *ADC_Type) SetAWD3TR_HT3(value uint32) {
	volatile.StoreUint32(&o.AWD3TR.Reg, volatile.LoadUint32(&o.AWD3TR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetAWD3TR_HT3() uint32 {
	return (volatile.LoadUint32(&o.AWD3TR.Reg) & 0xfff0000) >> 16
}

// ADC.DR: ADC data register
func (o *ADC_Type) SetDR_DATA(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetDR_DATA() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// ADC.AWD2CR: ADC Analog Watchdog 2 Configuration register
func (o *ADC_Type) SetAWD2CR_AWD2CH0(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH0() uint32 {
	return volatile.LoadUint32(&o.AWD2CR.Reg) & 0x1
}
func (o *ADC_Type) SetAWD2CR_AWD2CH1(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH1() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetAWD2CR_AWD2CH2(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH2() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetAWD2CR_AWD2CH3(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH3() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetAWD2CR_AWD2CH4(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH4() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetAWD2CR_AWD2CH5(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH5() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetAWD2CR_AWD2CH6(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH6() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetAWD2CR_AWD2CH7(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH7() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetAWD2CR_AWD2CH8(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH8() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetAWD2CR_AWD2CH9(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH9() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetAWD2CR_AWD2CH10(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH10() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetAWD2CR_AWD2CH11(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH11() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetAWD2CR_AWD2CH12(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH12() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetAWD2CR_AWD2CH13(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH13() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetAWD2CR_AWD2CH14(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH14() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetAWD2CR_AWD2CH15(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH15() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetAWD2CR_AWD2CH16(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH16() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetAWD2CR_AWD2CH17(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH17() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetAWD2CR_AWD2CH18(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH18() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x40000) >> 18
}

// ADC.AWD3CR: ADC Analog Watchdog 3 Configuration register
func (o *ADC_Type) SetAWD3CR_AWD3CH0(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH0() uint32 {
	return volatile.LoadUint32(&o.AWD3CR.Reg) & 0x1
}
func (o *ADC_Type) SetAWD3CR_AWD3CH1(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH1() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetAWD3CR_AWD3CH2(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH2() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetAWD3CR_AWD3CH3(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH3() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetAWD3CR_AWD3CH4(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH4() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetAWD3CR_AWD3CH5(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH5() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetAWD3CR_AWD3CH6(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH6() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetAWD3CR_AWD3CH7(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH7() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetAWD3CR_AWD3CH8(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH8() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetAWD3CR_AWD3CH9(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH9() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetAWD3CR_AWD3CH10(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH10() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetAWD3CR_AWD3CH11(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH11() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetAWD3CR_AWD3CH12(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH12() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetAWD3CR_AWD3CH13(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH13() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetAWD3CR_AWD3CH14(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH14() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetAWD3CR_AWD3CH15(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH15() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetAWD3CR_AWD3CH16(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH16() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetAWD3CR_AWD3CH17(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH17() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetAWD3CR_AWD3CH18(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH18() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x40000) >> 18
}

// ADC.CALFACT: ADC Calibration factor
func (o *ADC_Type) SetCALFACT(value uint32) {
	volatile.StoreUint32(&o.CALFACT.Reg, volatile.LoadUint32(&o.CALFACT.Reg)&^(0x7f)|value)
}
func (o *ADC_Type) GetCALFACT() uint32 {
	return volatile.LoadUint32(&o.CALFACT.Reg) & 0x7f
}

// ADC.CCR: ADC common configuration register
func (o *ADC_Type) SetCCR_PRESC(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3c0000)|value<<18)
}
func (o *ADC_Type) GetCCR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x3c0000) >> 18
}
func (o *ADC_Type) SetCCR_VREFEN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCCR_VREFEN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCCR_TSEN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCCR_TSEN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCCR_VBATEN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetCCR_VBATEN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x1000000) >> 24
}

// Comparator
type COMP_Type struct {
	COMP1_CSR volatile.Register32 // 0x0
	COMP2_CSR volatile.Register32 // 0x4
	COMP3_CSR volatile.Register32 // 0x8
}

// COMP.COMP1_CSR: Comparator 1 control and status register
func (o *COMP_Type) SetCOMP1_CSR_EN(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetCOMP1_CSR_EN() uint32 {
	return volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x1
}
func (o *COMP_Type) SetCOMP1_CSR_INMSEL(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0xf0)|value<<4)
}
func (o *COMP_Type) GetCOMP1_CSR_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0xf0) >> 4
}
func (o *COMP_Type) SetCOMP1_CSR_INPSEL(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x300)|value<<8)
}
func (o *COMP_Type) GetCOMP1_CSR_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x300) >> 8
}
func (o *COMP_Type) SetCOMP1_CSR_WINMODE(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x800)|value<<11)
}
func (o *COMP_Type) GetCOMP1_CSR_WINMODE() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x800) >> 11
}
func (o *COMP_Type) SetCOMP1_CSR_WINOUT(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x4000)|value<<14)
}
func (o *COMP_Type) GetCOMP1_CSR_WINOUT() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x4000) >> 14
}
func (o *COMP_Type) SetCOMP1_CSR_POLARITY(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetCOMP1_CSR_POLARITY() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetCOMP1_CSR_HYST(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x30000)|value<<16)
}
func (o *COMP_Type) GetCOMP1_CSR_HYST() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x30000) >> 16
}
func (o *COMP_Type) SetCOMP1_CSR_PWRMODE(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0xc0000)|value<<18)
}
func (o *COMP_Type) GetCOMP1_CSR_PWRMODE() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0xc0000) >> 18
}
func (o *COMP_Type) SetCOMP1_CSR_BLANKSEL(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x1f00000)|value<<20)
}
func (o *COMP_Type) GetCOMP1_CSR_BLANKSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x1f00000) >> 20
}
func (o *COMP_Type) SetCOMP1_CSR_VALUE(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetCOMP1_CSR_VALUE() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetCOMP1_CSR_LOCK(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetCOMP1_CSR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x80000000) >> 31
}

// COMP.COMP2_CSR: Comparator 2 control and status register
func (o *COMP_Type) SetCOMP2_CSR_EN(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetCOMP2_CSR_EN() uint32 {
	return volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x1
}
func (o *COMP_Type) SetCOMP2_CSR_INMSEL(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0xf0)|value<<4)
}
func (o *COMP_Type) GetCOMP2_CSR_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0xf0) >> 4
}
func (o *COMP_Type) SetCOMP2_CSR_INPSEL(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x300)|value<<8)
}
func (o *COMP_Type) GetCOMP2_CSR_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x300) >> 8
}
func (o *COMP_Type) SetCOMP2_CSR_WINMODE(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x800)|value<<11)
}
func (o *COMP_Type) GetCOMP2_CSR_WINMODE() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x800) >> 11
}
func (o *COMP_Type) SetCOMP2_CSR_WINOUT(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x4000)|value<<14)
}
func (o *COMP_Type) GetCOMP2_CSR_WINOUT() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x4000) >> 14
}
func (o *COMP_Type) SetCOMP2_CSR_POLARITY(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetCOMP2_CSR_POLARITY() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetCOMP2_CSR_HYST(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x30000)|value<<16)
}
func (o *COMP_Type) GetCOMP2_CSR_HYST() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x30000) >> 16
}
func (o *COMP_Type) SetCOMP2_CSR_PWRMODE(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0xc0000)|value<<18)
}
func (o *COMP_Type) GetCOMP2_CSR_PWRMODE() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0xc0000) >> 18
}
func (o *COMP_Type) SetCOMP2_CSR_BLANKSEL(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x1f00000)|value<<20)
}
func (o *COMP_Type) GetCOMP2_CSR_BLANKSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x1f00000) >> 20
}
func (o *COMP_Type) SetCOMP2_CSR_VALUE(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetCOMP2_CSR_VALUE() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetCOMP2_CSR_LOCK(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetCOMP2_CSR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x80000000) >> 31
}

// COMP.COMP3_CSR: Comparator 2 control and status register
func (o *COMP_Type) SetCOMP3_CSR_EN(value uint32) {
	volatile.StoreUint32(&o.COMP3_CSR.Reg, volatile.LoadUint32(&o.COMP3_CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetCOMP3_CSR_EN() uint32 {
	return volatile.LoadUint32(&o.COMP3_CSR.Reg) & 0x1
}
func (o *COMP_Type) SetCOMP3_CSR_INMSEL(value uint32) {
	volatile.StoreUint32(&o.COMP3_CSR.Reg, volatile.LoadUint32(&o.COMP3_CSR.Reg)&^(0xf0)|value<<4)
}
func (o *COMP_Type) GetCOMP3_CSR_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP3_CSR.Reg) & 0xf0) >> 4
}
func (o *COMP_Type) SetCOMP3_CSR_INPSEL(value uint32) {
	volatile.StoreUint32(&o.COMP3_CSR.Reg, volatile.LoadUint32(&o.COMP3_CSR.Reg)&^(0x300)|value<<8)
}
func (o *COMP_Type) GetCOMP3_CSR_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP3_CSR.Reg) & 0x300) >> 8
}
func (o *COMP_Type) SetCOMP3_CSR_WINMODE(value uint32) {
	volatile.StoreUint32(&o.COMP3_CSR.Reg, volatile.LoadUint32(&o.COMP3_CSR.Reg)&^(0x800)|value<<11)
}
func (o *COMP_Type) GetCOMP3_CSR_WINMODE() uint32 {
	return (volatile.LoadUint32(&o.COMP3_CSR.Reg) & 0x800) >> 11
}
func (o *COMP_Type) SetCOMP3_CSR_WINOUT(value uint32) {
	volatile.StoreUint32(&o.COMP3_CSR.Reg, volatile.LoadUint32(&o.COMP3_CSR.Reg)&^(0x4000)|value<<14)
}
func (o *COMP_Type) GetCOMP3_CSR_WINOUT() uint32 {
	return (volatile.LoadUint32(&o.COMP3_CSR.Reg) & 0x4000) >> 14
}
func (o *COMP_Type) SetCOMP3_CSR_POLARITY(value uint32) {
	volatile.StoreUint32(&o.COMP3_CSR.Reg, volatile.LoadUint32(&o.COMP3_CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetCOMP3_CSR_POLARITY() uint32 {
	return (volatile.LoadUint32(&o.COMP3_CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetCOMP3_CSR_HYST(value uint32) {
	volatile.StoreUint32(&o.COMP3_CSR.Reg, volatile.LoadUint32(&o.COMP3_CSR.Reg)&^(0x30000)|value<<16)
}
func (o *COMP_Type) GetCOMP3_CSR_HYST() uint32 {
	return (volatile.LoadUint32(&o.COMP3_CSR.Reg) & 0x30000) >> 16
}
func (o *COMP_Type) SetCOMP3_CSR_PWRMODE(value uint32) {
	volatile.StoreUint32(&o.COMP3_CSR.Reg, volatile.LoadUint32(&o.COMP3_CSR.Reg)&^(0xc0000)|value<<18)
}
func (o *COMP_Type) GetCOMP3_CSR_PWRMODE() uint32 {
	return (volatile.LoadUint32(&o.COMP3_CSR.Reg) & 0xc0000) >> 18
}
func (o *COMP_Type) SetCOMP3_CSR_BLANKSEL(value uint32) {
	volatile.StoreUint32(&o.COMP3_CSR.Reg, volatile.LoadUint32(&o.COMP3_CSR.Reg)&^(0x1f00000)|value<<20)
}
func (o *COMP_Type) GetCOMP3_CSR_BLANKSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP3_CSR.Reg) & 0x1f00000) >> 20
}
func (o *COMP_Type) SetCOMP3_CSR_VALUE(value uint32) {
	volatile.StoreUint32(&o.COMP3_CSR.Reg, volatile.LoadUint32(&o.COMP3_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetCOMP3_CSR_VALUE() uint32 {
	return (volatile.LoadUint32(&o.COMP3_CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetCOMP3_CSR_LOCK(value uint32) {
	volatile.StoreUint32(&o.COMP3_CSR.Reg, volatile.LoadUint32(&o.COMP3_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetCOMP3_CSR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.COMP3_CSR.Reg) & 0x80000000) >> 31
}

// Cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// CRC.DR: Data register
func (o *CRC_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *CRC_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// CRC.IDR: Independent data register
func (o *CRC_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, value)
}
func (o *CRC_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg)
}

// CRC.CR: Control register
func (o *CRC_Type) SetCR_REV_OUT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRC_Type) GetCR_REV_OUT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *CRC_Type) SetCR_REV_IN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *CRC_Type) GetCR_REV_IN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *CRC_Type) SetCR_POLYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *CRC_Type) GetCR_POLYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *CRC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRC_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// CRC.INIT: Initial CRC value
func (o *CRC_Type) SetINIT(value uint32) {
	volatile.StoreUint32(&o.INIT.Reg, value)
}
func (o *CRC_Type) GetINIT() uint32 {
	return volatile.LoadUint32(&o.INIT.Reg)
}

// CRC.POL: polynomial
func (o *CRC_Type) SetPOL(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, value)
}
func (o *CRC_Type) GetPOL() uint32 {
	return volatile.LoadUint32(&o.POL.Reg)
}

// DAC
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRGR  volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
	CCR     volatile.Register32 // 0x38
	MCR     volatile.Register32 // 0x3C
	SHSR1   volatile.Register32 // 0x40
	SHSR2   volatile.Register32 // 0x44
	SHHR    volatile.Register32 // 0x48
	SHRR    volatile.Register32 // 0x4C
}

// DAC.CR: DAC control register
func (o *DAC_Type) SetCR_EN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCR_EN1() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DAC_Type) SetCR_TEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetCR_TEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetCR_TSEL1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3c)|value<<2)
}
func (o *DAC_Type) GetCR_TSEL1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3c) >> 2
}
func (o *DAC_Type) SetCR_WAVE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DAC_Type) GetCR_WAVE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DAC_Type) SetCR_MAMP1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *DAC_Type) GetCR_MAMP1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *DAC_Type) SetCR_DMAEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DAC_Type) GetCR_DMAEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DAC_Type) SetCR_DMAUDRIE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetCR_DMAUDRIE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetCR_CEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *DAC_Type) GetCR_CEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *DAC_Type) SetCR_EN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DAC_Type) GetCR_EN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DAC_Type) SetCR_TEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *DAC_Type) GetCR_TEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *DAC_Type) SetCR_TSEL2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3c0000)|value<<18)
}
func (o *DAC_Type) GetCR_TSEL2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3c0000) >> 18
}
func (o *DAC_Type) SetCR_WAVE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00000)|value<<22)
}
func (o *DAC_Type) GetCR_WAVE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00000) >> 22
}
func (o *DAC_Type) SetCR_MAMP2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf000000)|value<<24)
}
func (o *DAC_Type) GetCR_MAMP2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf000000) >> 24
}
func (o *DAC_Type) SetCR_DMAEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *DAC_Type) GetCR_DMAEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *DAC_Type) SetCR_DMAUDRIE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetCR_DMAUDRIE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetCR_CEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *DAC_Type) GetCR_CEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}

// DAC.SWTRGR: DAC software trigger register
func (o *DAC_Type) SetSWTRGR_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.SWTRGR.Reg, volatile.LoadUint32(&o.SWTRGR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetSWTRGR_SWTRIG1() uint32 {
	return volatile.LoadUint32(&o.SWTRGR.Reg) & 0x1
}
func (o *DAC_Type) SetSWTRGR_SWTRIG2(value uint32) {
	volatile.StoreUint32(&o.SWTRGR.Reg, volatile.LoadUint32(&o.SWTRGR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetSWTRGR_SWTRIG2() uint32 {
	return (volatile.LoadUint32(&o.SWTRGR.Reg) & 0x2) >> 1
}

// DAC.DHR12R1: DAC channel1 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R1.Reg, volatile.LoadUint32(&o.DHR12R1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R1.Reg) & 0xfff
}

// DAC.DHR12L1: DAC channel1 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L1.Reg, volatile.LoadUint32(&o.DHR12L1.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L1_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L1.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R1: DAC channel1 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R1.Reg, volatile.LoadUint32(&o.DHR8R1.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R1.Reg) & 0xff
}

// DAC.DHR12R2: DAC channel2 12-bit right aligned data holding register
func (o *DAC_Type) SetDHR12R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R2.Reg, volatile.LoadUint32(&o.DHR12R2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R2.Reg) & 0xfff
}

// DAC.DHR12L2: DAC channel2 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L2.Reg, volatile.LoadUint32(&o.DHR12L2.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L2_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L2.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R2: DAC channel2 8-bit right-aligned data holding register
func (o *DAC_Type) SetDHR8R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R2.Reg, volatile.LoadUint32(&o.DHR8R2.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R2.Reg) & 0xff
}

// DAC.DHR12RD: Dual DAC 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff
}
func (o *DAC_Type) SetDHR12RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff0000)|value<<16)
}
func (o *DAC_Type) GetDHR12RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff0000) >> 16
}

// DAC.DHR12LD: DUAL DAC 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12LD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12LD_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff0) >> 4
}
func (o *DAC_Type) SetDHR12LD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff00000)|value<<20)
}
func (o *DAC_Type) GetDHR12LD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff00000) >> 20
}

// DAC.DHR8RD: DUAL DAC 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff
}
func (o *DAC_Type) SetDHR8RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff00)|value<<8)
}
func (o *DAC_Type) GetDHR8RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff00) >> 8
}

// DAC.DOR1: DAC channel1 data output register
func (o *DAC_Type) SetDOR1_DACC1DOR(value uint32) {
	volatile.StoreUint32(&o.DOR1.Reg, volatile.LoadUint32(&o.DOR1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR1_DACC1DOR() uint32 {
	return volatile.LoadUint32(&o.DOR1.Reg) & 0xfff
}

// DAC.DOR2: DAC channel2 data output register
func (o *DAC_Type) SetDOR2_DACC2DOR(value uint32) {
	volatile.StoreUint32(&o.DOR2.Reg, volatile.LoadUint32(&o.DOR2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR2_DACC2DOR() uint32 {
	return volatile.LoadUint32(&o.DOR2.Reg) & 0xfff
}

// DAC.SR: DAC status register
func (o *DAC_Type) SetSR_DMAUDR1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetSR_DMAUDR1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetSR_CAL_FLAG1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *DAC_Type) GetSR_CAL_FLAG1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *DAC_Type) SetSR_BWST1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *DAC_Type) GetSR_BWST1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *DAC_Type) SetSR_DMAUDR2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetSR_DMAUDR2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetSR_CAL_FLAG2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *DAC_Type) GetSR_CAL_FLAG2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *DAC_Type) SetSR_BWST2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *DAC_Type) GetSR_BWST2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// DAC.CCR: DAC calibration control register
func (o *DAC_Type) SetCCR_OTRIM1(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1f)|value)
}
func (o *DAC_Type) GetCCR_OTRIM1() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1f
}
func (o *DAC_Type) SetCCR_OTRIM2(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1f0000)|value<<16)
}
func (o *DAC_Type) GetCCR_OTRIM2() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x1f0000) >> 16
}

// DAC.MCR: DAC mode control register
func (o *DAC_Type) SetMCR_MODE1(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x7)|value)
}
func (o *DAC_Type) GetMCR_MODE1() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x7
}
func (o *DAC_Type) SetMCR_MODE2(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x70000)|value<<16)
}
func (o *DAC_Type) GetMCR_MODE2() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x70000) >> 16
}

// DAC.SHSR1: DAC Sample and Hold sample time register 1
func (o *DAC_Type) SetSHSR1_TSAMPLE1(value uint32) {
	volatile.StoreUint32(&o.SHSR1.Reg, volatile.LoadUint32(&o.SHSR1.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetSHSR1_TSAMPLE1() uint32 {
	return volatile.LoadUint32(&o.SHSR1.Reg) & 0x3ff
}

// DAC.SHSR2: DAC Sample and Hold sample time register 2
func (o *DAC_Type) SetSHSR2_TSAMPLE2(value uint32) {
	volatile.StoreUint32(&o.SHSR2.Reg, volatile.LoadUint32(&o.SHSR2.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetSHSR2_TSAMPLE2() uint32 {
	return volatile.LoadUint32(&o.SHSR2.Reg) & 0x3ff
}

// DAC.SHHR: DAC Sample and Hold hold time register
func (o *DAC_Type) SetSHHR_THOLD1(value uint32) {
	volatile.StoreUint32(&o.SHHR.Reg, volatile.LoadUint32(&o.SHHR.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetSHHR_THOLD1() uint32 {
	return volatile.LoadUint32(&o.SHHR.Reg) & 0x3ff
}
func (o *DAC_Type) SetSHHR_THOLD2(value uint32) {
	volatile.StoreUint32(&o.SHHR.Reg, volatile.LoadUint32(&o.SHHR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DAC_Type) GetSHHR_THOLD2() uint32 {
	return (volatile.LoadUint32(&o.SHHR.Reg) & 0x3ff0000) >> 16
}

// DAC.SHRR: DAC Sample and Hold refresh time register
func (o *DAC_Type) SetSHRR_TREFRESH1(value uint32) {
	volatile.StoreUint32(&o.SHRR.Reg, volatile.LoadUint32(&o.SHRR.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetSHRR_TREFRESH1() uint32 {
	return volatile.LoadUint32(&o.SHRR.Reg) & 0xff
}
func (o *DAC_Type) SetSHRR_TREFRESH2(value uint32) {
	volatile.StoreUint32(&o.SHRR.Reg, volatile.LoadUint32(&o.SHRR.Reg)&^(0xff0000)|value<<16)
}
func (o *DAC_Type) GetSHRR_TREFRESH2() uint32 {
	return (volatile.LoadUint32(&o.SHRR.Reg) & 0xff0000) >> 16
}

// Debug support
type DBG_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB_FZ1 volatile.Register32 // 0x8
	APB_FZ2 volatile.Register32 // 0xC
}

// DBG.IDCODE: MCU Device ID Code Register
func (o *DBG_Type) SetIDCODE_DEV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xfff)|value)
}
func (o *DBG_Type) GetIDCODE_DEV_ID() uint32 {
	return volatile.LoadUint32(&o.IDCODE.Reg) & 0xfff
}
func (o *DBG_Type) SetIDCODE_REV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *DBG_Type) GetIDCODE_REV_ID() uint32 {
	return (volatile.LoadUint32(&o.IDCODE.Reg) & 0xffff0000) >> 16
}

// DBG.CR: DBG configuration register
func (o *DBG_Type) SetCR_DBG_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetCR_DBG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetCR_DBG_STANDBY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBG_Type) GetCR_DBG_STANDBY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}

// DBG.APB_FZ1: DBG APB freeze register 1
func (o *DBG_Type) SetAPB_FZ1_DBG_TIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_TIM2_STOP() uint32 {
	return volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x1
}
func (o *DBG_Type) SetAPB_FZ1_DBG_TIM3_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_TIM3_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetAPB_FZ1_DBG_TIM6_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x10)|value<<4)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_TIM6_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x10) >> 4
}
func (o *DBG_Type) SetAPB_FZ1_DBG_TIM7_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x20)|value<<5)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_TIM7_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x20) >> 5
}
func (o *DBG_Type) SetAPB_FZ1_DBG_RTC_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x400)|value<<10)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_RTC_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x400) >> 10
}
func (o *DBG_Type) SetAPB_FZ1_DBG_WWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x800)|value<<11)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_WWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x800) >> 11
}
func (o *DBG_Type) SetAPB_FZ1_DBG_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x1000)|value<<12)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x1000) >> 12
}
func (o *DBG_Type) SetAPB_FZ1_DBG_I2C1_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x200000)|value<<21)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_I2C1_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x200000) >> 21
}
func (o *DBG_Type) SetAPB_FZ1_DBG_LPTIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x40000000)|value<<30)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_LPTIM2_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x40000000) >> 30
}
func (o *DBG_Type) SetAPB_FZ1_DBG_LPTIM1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x80000000)|value<<31)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_LPTIM1_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x80000000) >> 31
}

// DBG.APB_FZ2: DBG APB freeze register 2
func (o *DBG_Type) SetAPB_FZ2_DBG_TIM1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ2.Reg, volatile.LoadUint32(&o.APB_FZ2.Reg)&^(0x800)|value<<11)
}
func (o *DBG_Type) GetAPB_FZ2_DBG_TIM1_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ2.Reg) & 0x800) >> 11
}
func (o *DBG_Type) SetAPB_FZ2_DBG_TIM14_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ2.Reg, volatile.LoadUint32(&o.APB_FZ2.Reg)&^(0x8000)|value<<15)
}
func (o *DBG_Type) GetAPB_FZ2_DBG_TIM14_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ2.Reg) & 0x8000) >> 15
}
func (o *DBG_Type) SetAPB_FZ2_DBG_TIM15_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ2.Reg, volatile.LoadUint32(&o.APB_FZ2.Reg)&^(0x10000)|value<<16)
}
func (o *DBG_Type) GetAPB_FZ2_DBG_TIM15_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ2.Reg) & 0x10000) >> 16
}
func (o *DBG_Type) SetAPB_FZ2_DBG_TIM16_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ2.Reg, volatile.LoadUint32(&o.APB_FZ2.Reg)&^(0x20000)|value<<17)
}
func (o *DBG_Type) GetAPB_FZ2_DBG_TIM16_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ2.Reg) & 0x20000) >> 17
}
func (o *DBG_Type) SetAPB_FZ2_DBG_TIM17_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ2.Reg, volatile.LoadUint32(&o.APB_FZ2.Reg)&^(0x40000)|value<<18)
}
func (o *DBG_Type) GetAPB_FZ2_DBG_TIM17_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ2.Reg) & 0x40000) >> 18
}

// DMAMUX
type DMAMUX_Type struct {
	C0CR  volatile.Register32 // 0x0
	C1CR  volatile.Register32 // 0x4
	C2CR  volatile.Register32 // 0x8
	C3CR  volatile.Register32 // 0xC
	C4CR  volatile.Register32 // 0x10
	C5CR  volatile.Register32 // 0x14
	C6CR  volatile.Register32 // 0x18
	_     [100]byte
	CSR   volatile.Register32 // 0x80
	CFR   volatile.Register32 // 0x84
	_     [120]byte
	RG0CR volatile.Register32 // 0x100
	RG1CR volatile.Register32 // 0x104
	RG2CR volatile.Register32 // 0x108
	RG3CR volatile.Register32 // 0x10C
	_     [48]byte
	RGSR  volatile.Register32 // 0x140
	RGCFR volatile.Register32 // 0x144
}

// DMAMUX.C0CR: DMAMUX request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC0CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetC0CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C0CR.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetC0CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC0CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC0CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC0CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC0CR_SE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC0CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC0CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC0CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC0CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC0CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC0CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC0CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C1CR: DMAMUX request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC1CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetC1CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C1CR.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetC1CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC1CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC1CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC1CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC1CR_SE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC1CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC1CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC1CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC1CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC1CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC1CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC1CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C2CR: DMAMUX request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC2CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetC2CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C2CR.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetC2CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC2CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC2CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC2CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC2CR_SE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC2CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC2CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC2CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC2CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC2CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC2CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC2CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C3CR: DMAMUX request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC3CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetC3CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C3CR.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetC3CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC3CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC3CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC3CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC3CR_SE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC3CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC3CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC3CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC3CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC3CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC3CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC3CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C4CR: DMAMUX request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC4CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetC4CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C4CR.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetC4CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC4CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC4CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC4CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC4CR_SE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC4CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC4CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC4CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC4CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC4CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC4CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC4CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C5CR: DMAMUX request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC5CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetC5CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C5CR.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetC5CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC5CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC5CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC5CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC5CR_SE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC5CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC5CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC5CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC5CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC5CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC5CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC5CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C6CR: DMAMUX request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC6CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetC6CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C6CR.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetC6CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC6CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC6CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC6CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC6CR_SE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC6CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC6CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC6CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC6CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC6CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC6CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC6CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CSR: DMAMUX request line multiplexer interrupt channel status register
func (o *DMAMUX_Type) SetCSR_SOF0(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetCSR_SOF0() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetCSR_SOF1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetCSR_SOF1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetCSR_SOF2(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetCSR_SOF2() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetCSR_SOF3(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetCSR_SOF3() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetCSR_SOF4(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetCSR_SOF4() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetCSR_SOF5(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetCSR_SOF5() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetCSR_SOF6(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCSR_SOF6() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}

// DMAMUX.CFR: DMAMUX request line multiplexer interrupt clear flag register
func (o *DMAMUX_Type) SetCFR_CSOF0(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetCFR_CSOF0() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetCFR_CSOF1(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetCFR_CSOF1() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetCFR_CSOF2(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetCFR_CSOF2() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetCFR_CSOF3(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetCFR_CSOF3() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetCFR_CSOF4(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetCFR_CSOF4() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetCFR_CSOF5(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetCFR_CSOF5() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetCFR_CSOF6(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCFR_CSOF6() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x40) >> 6
}

// DMAMUX.RG0CR: DMAMUX request generator channel x configuration register
func (o *DMAMUX_Type) SetRG0CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG0CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG0CR.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRG0CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG0CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG0CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG0CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG0CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG0CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG0CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG0CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0xf80000) >> 19
}

// DMAMUX.RG1CR: DMAMUX request generator channel x configuration register
func (o *DMAMUX_Type) SetRG1CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG1CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG1CR.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRG1CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG1CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG1CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG1CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG1CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG1CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG1CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG1CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0xf80000) >> 19
}

// DMAMUX.RG2CR: DMAMUX request generator channel x configuration register
func (o *DMAMUX_Type) SetRG2CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG2CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG2CR.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRG2CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG2CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG2CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG2CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG2CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG2CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG2CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG2CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0xf80000) >> 19
}

// DMAMUX.RG3CR: DMAMUX request generator channel x configuration register
func (o *DMAMUX_Type) SetRG3CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG3CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG3CR.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRG3CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG3CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG3CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG3CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG3CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG3CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG3CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG3CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGSR: DMAMUX request generator interrupt status register
func (o *DMAMUX_Type) SetRGSR_OF0(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetRGSR_OF0() uint32 {
	return volatile.LoadUint32(&o.RGSR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetRGSR_OF1(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetRGSR_OF1() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetRGSR_OF2(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetRGSR_OF2() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetRGSR_OF3(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetRGSR_OF3() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x8) >> 3
}

// DMAMUX.RGCFR: DMAMUX request generator interrupt clear flag register
func (o *DMAMUX_Type) SetRGCFR_COF0(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetRGCFR_COF0() uint32 {
	return volatile.LoadUint32(&o.RGCFR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetRGCFR_COF1(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetRGCFR_COF1() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetRGCFR_COF2(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetRGCFR_COF2() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetRGCFR_COF3(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetRGCFR_COF3() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x8) >> 3
}

// External interrupt/event controller
type EXTI_Type struct {
	RTSR1   volatile.Register32 // 0x0
	FTSR1   volatile.Register32 // 0x4
	SWIER1  volatile.Register32 // 0x8
	RPR1    volatile.Register32 // 0xC
	FPR1    volatile.Register32 // 0x10
	_       [20]byte
	RTSR2   volatile.Register32 // 0x28
	FTSR2   volatile.Register32 // 0x2C
	SWIER2  volatile.Register32 // 0x30
	RPR2    volatile.Register32 // 0x34
	FPR2    volatile.Register32 // 0x38
	_       [36]byte
	EXTICR1 volatile.Register32 // 0x60
	EXTICR2 volatile.Register32 // 0x64
	EXTICR3 volatile.Register32 // 0x68
	EXTICR4 volatile.Register32 // 0x6C
	_       [16]byte
	IMR1    volatile.Register32 // 0x80
	EMR1    volatile.Register32 // 0x84
	_       [8]byte
	IMR2    volatile.Register32 // 0x90
	EMR2    volatile.Register32 // 0x94
}

// EXTI.RTSR1: EXTI rising trigger selection register
func (o *EXTI_Type) SetRTSR1_RT0(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR1_RT0() uint32 {
	return volatile.LoadUint32(&o.RTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR1_RT1(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR1_RT1() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR1_RT2(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR1_RT2() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR1_RT3(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR1_RT3() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR1_RT4(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR1_RT4() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR1_RT5(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR1_RT5() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR1_RT6(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR1_RT6() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRTSR1_RT7(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRTSR1_RT7() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRTSR1_RT8(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR1_RT8() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR1_RT9(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR1_RT9() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR1_RT10(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRTSR1_RT10() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRTSR1_RT11(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRTSR1_RT11() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRTSR1_RT12(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRTSR1_RT12() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRTSR1_RT13(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR1_RT13() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRTSR1_RT14(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRTSR1_RT14() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRTSR1_RT15(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRTSR1_RT15() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRTSR1_RT16(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRTSR1_RT16() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRTSR1_RT17(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetRTSR1_RT17() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetRTSR1_RT18(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetRTSR1_RT18() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetRTSR1_RT20(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRTSR1_RT20() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100000) >> 20
}

// EXTI.FTSR1: EXTI falling trigger selection register
func (o *EXTI_Type) SetFTSR1_FT0(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR1_FT0() uint32 {
	return volatile.LoadUint32(&o.FTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR1_FT1(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR1_FT1() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR1_FT2(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR1_FT2() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR1_FT3(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR1_FT3() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR1_FT4(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR1_FT4() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR1_FT5(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR1_FT5() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR1_FT6(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR1_FT6() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFTSR1_FT7(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFTSR1_FT7() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFTSR1_FT8(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR1_FT8() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR1_FT9(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR1_FT9() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR1_FT10(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFTSR1_FT10() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFTSR1_FT11(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFTSR1_FT11() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFTSR1_FT12(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFTSR1_FT12() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFTSR1_FT13(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR1_FT13() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFTSR1_FT14(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFTSR1_FT14() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFTSR1_FT15(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFTSR1_FT15() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFTSR1_FT16(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFTSR1_FT16() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFTSR1_FT17(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetFTSR1_FT17() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetFTSR1_FT18(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetFTSR1_FT18() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetFTSR1_FT20(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFTSR1_FT20() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100000) >> 20
}

// EXTI.SWIER1: EXTI software interrupt event register
func (o *EXTI_Type) SetSWIER1_SWI0(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER1_SWI0() uint32 {
	return volatile.LoadUint32(&o.SWIER1.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER1_SWI1(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER1_SWI1() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER1_SWI2(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER1_SWI2() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER1_SWI3(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER1_SWI3() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER1_SWI4(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER1_SWI4() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER1_SWI5(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER1_SWI5() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER1_SWI6(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER1_SWI6() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSWIER1_SWI7(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSWIER1_SWI7() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSWIER1_SWI8(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER1_SWI8() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER1_SWI9(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER1_SWI9() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER1_SWI10(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSWIER1_SWI10() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSWIER1_SWI11(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSWIER1_SWI11() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSWIER1_SWI12(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSWIER1_SWI12() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSWIER1_SWI13(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER1_SWI13() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSWIER1_SWI14(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSWIER1_SWI14() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSWIER1_SWI15(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSWIER1_SWI15() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSWIER1_SWI16(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSWIER1_SWI16() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetSWIER1_SWI17(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetSWIER1_SWI17() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetSWIER1_SWI18(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetSWIER1_SWI18() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetSWIER1_SWI20(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSWIER1_SWI20() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100000) >> 20
}

// EXTI.RPR1: EXTI rising edge pending register
func (o *EXTI_Type) SetRPR1_RPIF0(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRPR1_RPIF0() uint32 {
	return volatile.LoadUint32(&o.RPR1.Reg) & 0x1
}
func (o *EXTI_Type) SetRPR1_RPIF1(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRPR1_RPIF1() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRPR1_RPIF2(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRPR1_RPIF2() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRPR1_RPIF3(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRPR1_RPIF3() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRPR1_RPIF4(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRPR1_RPIF4() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRPR1_RPIF5(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRPR1_RPIF5() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRPR1_RPIF6(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRPR1_RPIF6() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRPR1_RPIF7(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRPR1_RPIF7() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRPR1_RPIF8(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRPR1_RPIF8() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRPR1_RPIF9(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRPR1_RPIF9() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRPR1_RPIF10(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRPR1_RPIF10() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRPR1_RPIF11(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRPR1_RPIF11() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRPR1_RPIF12(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRPR1_RPIF12() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRPR1_RPIF13(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRPR1_RPIF13() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRPR1_RPIF14(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRPR1_RPIF14() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRPR1_RPIF15(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRPR1_RPIF15() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRPR1_RPIF16(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRPR1_RPIF16() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRPR1_RPIF17(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetRPR1_RPIF17() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetRPR1_RPIF18(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetRPR1_RPIF18() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetRPR1_RPIF20(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRPR1_RPIF20() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x100000) >> 20
}

// EXTI.FPR1: EXTI falling edge pending register
func (o *EXTI_Type) SetFPR1_FPIF0(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFPR1_FPIF0() uint32 {
	return volatile.LoadUint32(&o.FPR1.Reg) & 0x1
}
func (o *EXTI_Type) SetFPR1_FPIF1(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFPR1_FPIF1() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFPR1_FPIF2(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFPR1_FPIF2() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFPR1_FPIF3(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFPR1_FPIF3() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFPR1_FPIF4(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFPR1_FPIF4() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFPR1_FPIF5(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFPR1_FPIF5() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFPR1_FPIF6(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFPR1_FPIF6() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFPR1_FPIF7(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFPR1_FPIF7() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFPR1_FPIF8(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFPR1_FPIF8() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFPR1_FPIF9(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFPR1_FPIF9() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFPR1_FPIF10(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFPR1_FPIF10() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFPR1_FPIF11(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFPR1_FPIF11() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFPR1_FPIF12(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFPR1_FPIF12() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFPR1_FPIF13(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFPR1_FPIF13() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFPR1_FPIF14(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFPR1_FPIF14() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFPR1_FPIF15(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFPR1_FPIF15() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFPR1_FPIF16(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFPR1_FPIF16() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFPR1_FPIF17(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetFPR1_FPIF17() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetFPR1_FPIF18(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetFPR1_FPIF18() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetFPR1_FPIF20(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFPR1_FPIF20() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x100000) >> 20
}

// EXTI.RTSR2: EXTI rising trigger selection register 2
func (o *EXTI_Type) SetRTSR2_RT2(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR2_RT2() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x4) >> 2
}

// EXTI.FTSR2: EXTI falling trigger selection register 2
func (o *EXTI_Type) SetFTSR2_FT2(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR2_FT2() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x4) >> 2
}

// EXTI.SWIER2: EXTI software interrupt event register 2
func (o *EXTI_Type) SetSWIER2_SWI2(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER2_SWI2() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x4) >> 2
}

// EXTI.RPR2: EXTI rising edge pending register 2
func (o *EXTI_Type) SetRPR2_RPIF2(value uint32) {
	volatile.StoreUint32(&o.RPR2.Reg, volatile.LoadUint32(&o.RPR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRPR2_RPIF2() uint32 {
	return (volatile.LoadUint32(&o.RPR2.Reg) & 0x4) >> 2
}

// EXTI.FPR2: EXTI falling edge pending register 2
func (o *EXTI_Type) SetFPR2_FPIF2(value uint32) {
	volatile.StoreUint32(&o.FPR2.Reg, volatile.LoadUint32(&o.FPR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFPR2_FPIF2() uint32 {
	return (volatile.LoadUint32(&o.FPR2.Reg) & 0x4) >> 2
}

// EXTI.EXTICR1: EXTI external interrupt selection register
func (o *EXTI_Type) SetEXTICR1_EXTI0_7(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xff)|value)
}
func (o *EXTI_Type) GetEXTICR1_EXTI0_7() uint32 {
	return volatile.LoadUint32(&o.EXTICR1.Reg) & 0xff
}
func (o *EXTI_Type) SetEXTICR1_EXTI8_15(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xff00)|value<<8)
}
func (o *EXTI_Type) GetEXTICR1_EXTI8_15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xff00) >> 8
}
func (o *EXTI_Type) SetEXTICR1_EXTI16_23(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xff0000)|value<<16)
}
func (o *EXTI_Type) GetEXTICR1_EXTI16_23() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xff0000) >> 16
}
func (o *EXTI_Type) SetEXTICR1_EXTI24_31(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xff000000)|value<<24)
}
func (o *EXTI_Type) GetEXTICR1_EXTI24_31() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xff000000) >> 24
}

// EXTI.EXTICR2: EXTI external interrupt selection register
func (o *EXTI_Type) SetEXTICR2_EXTI0_7(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xff)|value)
}
func (o *EXTI_Type) GetEXTICR2_EXTI0_7() uint32 {
	return volatile.LoadUint32(&o.EXTICR2.Reg) & 0xff
}
func (o *EXTI_Type) SetEXTICR2_EXTI8_15(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xff00)|value<<8)
}
func (o *EXTI_Type) GetEXTICR2_EXTI8_15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xff00) >> 8
}
func (o *EXTI_Type) SetEXTICR2_EXTI16_23(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xff0000)|value<<16)
}
func (o *EXTI_Type) GetEXTICR2_EXTI16_23() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xff0000) >> 16
}
func (o *EXTI_Type) SetEXTICR2_EXTI24_31(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xff000000)|value<<24)
}
func (o *EXTI_Type) GetEXTICR2_EXTI24_31() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xff000000) >> 24
}

// EXTI.EXTICR3: EXTI external interrupt selection register
func (o *EXTI_Type) SetEXTICR3_EXTI0_7(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xff)|value)
}
func (o *EXTI_Type) GetEXTICR3_EXTI0_7() uint32 {
	return volatile.LoadUint32(&o.EXTICR3.Reg) & 0xff
}
func (o *EXTI_Type) SetEXTICR3_EXTI8_15(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xff00)|value<<8)
}
func (o *EXTI_Type) GetEXTICR3_EXTI8_15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xff00) >> 8
}
func (o *EXTI_Type) SetEXTICR3_EXTI16_23(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xff0000)|value<<16)
}
func (o *EXTI_Type) GetEXTICR3_EXTI16_23() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xff0000) >> 16
}
func (o *EXTI_Type) SetEXTICR3_EXTI24_31(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xff000000)|value<<24)
}
func (o *EXTI_Type) GetEXTICR3_EXTI24_31() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xff000000) >> 24
}

// EXTI.EXTICR4: EXTI external interrupt selection register
func (o *EXTI_Type) SetEXTICR4_EXTI0_7(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xff)|value)
}
func (o *EXTI_Type) GetEXTICR4_EXTI0_7() uint32 {
	return volatile.LoadUint32(&o.EXTICR4.Reg) & 0xff
}
func (o *EXTI_Type) SetEXTICR4_EXTI8_15(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xff00)|value<<8)
}
func (o *EXTI_Type) GetEXTICR4_EXTI8_15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xff00) >> 8
}
func (o *EXTI_Type) SetEXTICR4_EXTI16_23(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xff0000)|value<<16)
}
func (o *EXTI_Type) GetEXTICR4_EXTI16_23() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xff0000) >> 16
}
func (o *EXTI_Type) SetEXTICR4_EXTI24_31(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xff000000)|value<<24)
}
func (o *EXTI_Type) GetEXTICR4_EXTI24_31() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xff000000) >> 24
}

// EXTI.IMR1: EXTI CPU wakeup with interrupt mask register
func (o *EXTI_Type) SetIMR1_IM0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR1_IM0() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR1_IM1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR1_IM1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR1_IM2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR1_IM2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR1_IM3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR1_IM3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR1_IM4(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR1_IM4() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR1_IM5(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR1_IM5() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR1_IM6(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetIMR1_IM6() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetIMR1_IM7(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetIMR1_IM7() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetIMR1_IM8(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetIMR1_IM8() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetIMR1_IM9(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetIMR1_IM9() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetIMR1_IM10(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetIMR1_IM10() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetIMR1_IM11(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetIMR1_IM11() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetIMR1_IM12(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetIMR1_IM12() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetIMR1_IM13(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetIMR1_IM13() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetIMR1_IM14(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetIMR1_IM14() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetIMR1_IM15(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetIMR1_IM15() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetIMR1_IM16(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetIMR1_IM16() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetIMR1_IM17(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetIMR1_IM17() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetIMR1_IM18(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetIMR1_IM18() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetIMR1_IM19(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetIMR1_IM19() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetIMR1_IM20(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetIMR1_IM20() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetIMR1_IM21(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetIMR1_IM21() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetIMR1_IM22(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetIMR1_IM22() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetIMR1_IM23(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetIMR1_IM23() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetIMR1_IM24(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetIMR1_IM24() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetIMR1_IM25(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetIMR1_IM25() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetIMR1_IM26(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetIMR1_IM26() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetIMR1_IM27(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetIMR1_IM27() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetIMR1_IM28(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetIMR1_IM28() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetIMR1_IM29(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetIMR1_IM29() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetIMR1_IM30(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetIMR1_IM30() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetIMR1_IM31(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetIMR1_IM31() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000000) >> 31
}

// EXTI.EMR1: EXTI CPU wakeup with event mask register
func (o *EXTI_Type) SetEMR1_EM0(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR1_EM0() uint32 {
	return volatile.LoadUint32(&o.EMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR1_EM1(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR1_EM1() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR1_EM2(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR1_EM2() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR1_EM3(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR1_EM3() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetEMR1_EM4(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetEMR1_EM4() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetEMR1_EM5(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetEMR1_EM5() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetEMR1_EM6(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetEMR1_EM6() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetEMR1_EM7(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetEMR1_EM7() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetEMR1_EM8(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetEMR1_EM8() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetEMR1_EM9(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetEMR1_EM9() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetEMR1_EM10(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetEMR1_EM10() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetEMR1_EM11(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetEMR1_EM11() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetEMR1_EM12(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetEMR1_EM12() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetEMR1_EM13(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetEMR1_EM13() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetEMR1_EM14(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetEMR1_EM14() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetEMR1_EM15(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetEMR1_EM15() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetEMR1_EM16(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetEMR1_EM16() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetEMR1_EM17(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetEMR1_EM17() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetEMR1_EM18(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetEMR1_EM18() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetEMR1_EM19(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetEMR1_EM19() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetEMR1_EM21(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetEMR1_EM21() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetEMR1_EM23(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetEMR1_EM23() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetEMR1_EM25(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetEMR1_EM25() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetEMR1_EM26(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetEMR1_EM26() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetEMR1_EM27(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetEMR1_EM27() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetEMR1_EM28(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetEMR1_EM28() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetEMR1_EM29(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetEMR1_EM29() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetEMR1_EM30(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetEMR1_EM30() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetEMR1_EM31(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetEMR1_EM31() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x80000000) >> 31
}

// EXTI.IMR2: EXTI CPU wakeup with interrupt mask register
func (o *EXTI_Type) SetIMR2_IM32(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR2_IM32() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR2_IM33(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR2_IM33() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR2_IM34(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR2_IM34() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR2_IM35(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR2_IM35() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}

// EXTI.EMR2: EXTI CPU wakeup with event mask register
func (o *EXTI_Type) SetEMR2_EM32(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR2_EM32() uint32 {
	return volatile.LoadUint32(&o.EMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR2_EM33(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR2_EM33() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR2_EM34(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR2_EM34() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR2_EM35(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR2_EM35() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x8) >> 3
}

// FD controller area network
type FDCAN_Type struct {
	CREL   volatile.Register32 // 0x0
	ENDN   volatile.Register32 // 0x4
	_      [4]byte
	DBTP   volatile.Register32 // 0xC
	TEST   volatile.Register32 // 0x10
	RWD    volatile.Register32 // 0x14
	CCCR   volatile.Register32 // 0x18
	NBTP   volatile.Register32 // 0x1C
	TSCC   volatile.Register32 // 0x20
	TSCV   volatile.Register32 // 0x24
	TOCC   volatile.Register32 // 0x28
	TOCV   volatile.Register32 // 0x2C
	_      [16]byte
	ECR    volatile.Register32 // 0x40
	PSR    volatile.Register32 // 0x44
	TDCR   volatile.Register32 // 0x48
	_      [4]byte
	IR     volatile.Register32 // 0x50
	IE     volatile.Register32 // 0x54
	ILS    volatile.Register32 // 0x58
	ILE    volatile.Register32 // 0x5C
	_      [32]byte
	RXGFC  volatile.Register32 // 0x80
	XIDAM  volatile.Register32 // 0x84
	HPMS   volatile.Register32 // 0x88
	_      [4]byte
	RXF0S  volatile.Register32 // 0x90
	RXF0A  volatile.Register32 // 0x94
	RXF1S  volatile.Register32 // 0x98
	RXF1A  volatile.Register32 // 0x9C
	_      [32]byte
	TXBC   volatile.Register32 // 0xC0
	TXFQS  volatile.Register32 // 0xC4
	TXBRP  volatile.Register32 // 0xC8
	TXBAR  volatile.Register32 // 0xCC
	TXBCR  volatile.Register32 // 0xD0
	TXBTO  volatile.Register32 // 0xD4
	TXBCF  volatile.Register32 // 0xD8
	TXBTIE volatile.Register32 // 0xDC
	TXBCIE volatile.Register32 // 0xE0
	TXEFS  volatile.Register32 // 0xE4
	TXEFA  volatile.Register32 // 0xE8
	_      [20]byte
	CKDIV  volatile.Register32 // 0x100
}

// FDCAN.CREL: FDCAN core release register
func (o *FDCAN_Type) SetCREL_DAY(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xff)|value)
}
func (o *FDCAN_Type) GetCREL_DAY() uint32 {
	return volatile.LoadUint32(&o.CREL.Reg) & 0xff
}
func (o *FDCAN_Type) SetCREL_MON(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xff00)|value<<8)
}
func (o *FDCAN_Type) GetCREL_MON() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xff00) >> 8
}
func (o *FDCAN_Type) SetCREL_YEAR(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf0000)|value<<16)
}
func (o *FDCAN_Type) GetCREL_YEAR() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf0000) >> 16
}
func (o *FDCAN_Type) SetCREL_SUBSTEP(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf00000)|value<<20)
}
func (o *FDCAN_Type) GetCREL_SUBSTEP() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf00000) >> 20
}
func (o *FDCAN_Type) SetCREL_STEP(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf000000)|value<<24)
}
func (o *FDCAN_Type) GetCREL_STEP() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf000000) >> 24
}
func (o *FDCAN_Type) SetCREL_REL(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf0000000)|value<<28)
}
func (o *FDCAN_Type) GetCREL_REL() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf0000000) >> 28
}

// FDCAN.ENDN: FDCAN endian register
func (o *FDCAN_Type) SetENDN(value uint32) {
	volatile.StoreUint32(&o.ENDN.Reg, value)
}
func (o *FDCAN_Type) GetENDN() uint32 {
	return volatile.LoadUint32(&o.ENDN.Reg)
}

// FDCAN.DBTP: FDCAN data bit timing and prescaler register
func (o *FDCAN_Type) SetDBTP_DSJW(value uint32) {
	volatile.StoreUint32(&o.DBTP.Reg, volatile.LoadUint32(&o.DBTP.Reg)&^(0xf)|value)
}
func (o *FDCAN_Type) GetDBTP_DSJW() uint32 {
	return volatile.LoadUint32(&o.DBTP.Reg) & 0xf
}
func (o *FDCAN_Type) SetDBTP_DTSEG2(value uint32) {
	volatile.StoreUint32(&o.DBTP.Reg, volatile.LoadUint32(&o.DBTP.Reg)&^(0xf0)|value<<4)
}
func (o *FDCAN_Type) GetDBTP_DTSEG2() uint32 {
	return (volatile.LoadUint32(&o.DBTP.Reg) & 0xf0) >> 4
}
func (o *FDCAN_Type) SetDBTP_DTSEG1(value uint32) {
	volatile.StoreUint32(&o.DBTP.Reg, volatile.LoadUint32(&o.DBTP.Reg)&^(0x1f00)|value<<8)
}
func (o *FDCAN_Type) GetDBTP_DTSEG1() uint32 {
	return (volatile.LoadUint32(&o.DBTP.Reg) & 0x1f00) >> 8
}
func (o *FDCAN_Type) SetDBTP_DBRP(value uint32) {
	volatile.StoreUint32(&o.DBTP.Reg, volatile.LoadUint32(&o.DBTP.Reg)&^(0x1f0000)|value<<16)
}
func (o *FDCAN_Type) GetDBTP_DBRP() uint32 {
	return (volatile.LoadUint32(&o.DBTP.Reg) & 0x1f0000) >> 16
}
func (o *FDCAN_Type) SetDBTP_TDC(value uint32) {
	volatile.StoreUint32(&o.DBTP.Reg, volatile.LoadUint32(&o.DBTP.Reg)&^(0x800000)|value<<23)
}
func (o *FDCAN_Type) GetDBTP_TDC() uint32 {
	return (volatile.LoadUint32(&o.DBTP.Reg) & 0x800000) >> 23
}

// FDCAN.TEST: FDCAN test register
func (o *FDCAN_Type) SetTEST_LBCK(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x10)|value<<4)
}
func (o *FDCAN_Type) GetTEST_LBCK() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x10) >> 4
}
func (o *FDCAN_Type) SetTEST_TX(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x60)|value<<5)
}
func (o *FDCAN_Type) GetTEST_TX() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x60) >> 5
}
func (o *FDCAN_Type) SetTEST_RX(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x80)|value<<7)
}
func (o *FDCAN_Type) GetTEST_RX() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x80) >> 7
}

// FDCAN.RWD: FDCAN RAM watchdog register
func (o *FDCAN_Type) SetRWD_WDC(value uint32) {
	volatile.StoreUint32(&o.RWD.Reg, volatile.LoadUint32(&o.RWD.Reg)&^(0xff)|value)
}
func (o *FDCAN_Type) GetRWD_WDC() uint32 {
	return volatile.LoadUint32(&o.RWD.Reg) & 0xff
}
func (o *FDCAN_Type) SetRWD_WDV(value uint32) {
	volatile.StoreUint32(&o.RWD.Reg, volatile.LoadUint32(&o.RWD.Reg)&^(0xff00)|value<<8)
}
func (o *FDCAN_Type) GetRWD_WDV() uint32 {
	return (volatile.LoadUint32(&o.RWD.Reg) & 0xff00) >> 8
}

// FDCAN.CCCR: FDCAN CC control register
func (o *FDCAN_Type) SetCCCR_INIT(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetCCCR_INIT() uint32 {
	return volatile.LoadUint32(&o.CCCR.Reg) & 0x1
}
func (o *FDCAN_Type) SetCCCR_CCE(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x2)|value<<1)
}
func (o *FDCAN_Type) GetCCCR_CCE() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x2) >> 1
}
func (o *FDCAN_Type) SetCCCR_ASM(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x4)|value<<2)
}
func (o *FDCAN_Type) GetCCCR_ASM() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x4) >> 2
}
func (o *FDCAN_Type) SetCCCR_CSA(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x8)|value<<3)
}
func (o *FDCAN_Type) GetCCCR_CSA() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x8) >> 3
}
func (o *FDCAN_Type) SetCCCR_CSR(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x10)|value<<4)
}
func (o *FDCAN_Type) GetCCCR_CSR() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x10) >> 4
}
func (o *FDCAN_Type) SetCCCR_MON(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x20)|value<<5)
}
func (o *FDCAN_Type) GetCCCR_MON() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x20) >> 5
}
func (o *FDCAN_Type) SetCCCR_DAR(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x40)|value<<6)
}
func (o *FDCAN_Type) GetCCCR_DAR() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x40) >> 6
}
func (o *FDCAN_Type) SetCCCR_TEST(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x80)|value<<7)
}
func (o *FDCAN_Type) GetCCCR_TEST() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x80) >> 7
}
func (o *FDCAN_Type) SetCCCR_FDOE(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x100)|value<<8)
}
func (o *FDCAN_Type) GetCCCR_FDOE() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x100) >> 8
}
func (o *FDCAN_Type) SetCCCR_BRSE(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x200)|value<<9)
}
func (o *FDCAN_Type) GetCCCR_BRSE() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x200) >> 9
}
func (o *FDCAN_Type) SetCCCR_PXHD(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x1000)|value<<12)
}
func (o *FDCAN_Type) GetCCCR_PXHD() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x1000) >> 12
}
func (o *FDCAN_Type) SetCCCR_EFBI(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x2000)|value<<13)
}
func (o *FDCAN_Type) GetCCCR_EFBI() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x2000) >> 13
}
func (o *FDCAN_Type) SetCCCR_TXP(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x4000)|value<<14)
}
func (o *FDCAN_Type) GetCCCR_TXP() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x4000) >> 14
}
func (o *FDCAN_Type) SetCCCR_NISO(value uint32) {
	volatile.StoreUint32(&o.CCCR.Reg, volatile.LoadUint32(&o.CCCR.Reg)&^(0x8000)|value<<15)
}
func (o *FDCAN_Type) GetCCCR_NISO() uint32 {
	return (volatile.LoadUint32(&o.CCCR.Reg) & 0x8000) >> 15
}

// FDCAN.NBTP: FDCAN nominal bit timing and prescaler register
func (o *FDCAN_Type) SetNBTP_NTSEG2(value uint32) {
	volatile.StoreUint32(&o.NBTP.Reg, volatile.LoadUint32(&o.NBTP.Reg)&^(0x7f)|value)
}
func (o *FDCAN_Type) GetNBTP_NTSEG2() uint32 {
	return volatile.LoadUint32(&o.NBTP.Reg) & 0x7f
}
func (o *FDCAN_Type) SetNBTP_NTSEG1(value uint32) {
	volatile.StoreUint32(&o.NBTP.Reg, volatile.LoadUint32(&o.NBTP.Reg)&^(0xff00)|value<<8)
}
func (o *FDCAN_Type) GetNBTP_NTSEG1() uint32 {
	return (volatile.LoadUint32(&o.NBTP.Reg) & 0xff00) >> 8
}
func (o *FDCAN_Type) SetNBTP_NBRP(value uint32) {
	volatile.StoreUint32(&o.NBTP.Reg, volatile.LoadUint32(&o.NBTP.Reg)&^(0x1ff0000)|value<<16)
}
func (o *FDCAN_Type) GetNBTP_NBRP() uint32 {
	return (volatile.LoadUint32(&o.NBTP.Reg) & 0x1ff0000) >> 16
}
func (o *FDCAN_Type) SetNBTP_NSJW(value uint32) {
	volatile.StoreUint32(&o.NBTP.Reg, volatile.LoadUint32(&o.NBTP.Reg)&^(0xfe000000)|value<<25)
}
func (o *FDCAN_Type) GetNBTP_NSJW() uint32 {
	return (volatile.LoadUint32(&o.NBTP.Reg) & 0xfe000000) >> 25
}

// FDCAN.TSCC: FDCAN timestamp counter configuration register
func (o *FDCAN_Type) SetTSCC_TSS(value uint32) {
	volatile.StoreUint32(&o.TSCC.Reg, volatile.LoadUint32(&o.TSCC.Reg)&^(0x3)|value)
}
func (o *FDCAN_Type) GetTSCC_TSS() uint32 {
	return volatile.LoadUint32(&o.TSCC.Reg) & 0x3
}
func (o *FDCAN_Type) SetTSCC_TCP(value uint32) {
	volatile.StoreUint32(&o.TSCC.Reg, volatile.LoadUint32(&o.TSCC.Reg)&^(0xf0000)|value<<16)
}
func (o *FDCAN_Type) GetTSCC_TCP() uint32 {
	return (volatile.LoadUint32(&o.TSCC.Reg) & 0xf0000) >> 16
}

// FDCAN.TSCV: FDCAN timestamp counter value register
func (o *FDCAN_Type) SetTSCV_TSC(value uint32) {
	volatile.StoreUint32(&o.TSCV.Reg, volatile.LoadUint32(&o.TSCV.Reg)&^(0xffff)|value)
}
func (o *FDCAN_Type) GetTSCV_TSC() uint32 {
	return volatile.LoadUint32(&o.TSCV.Reg) & 0xffff
}

// FDCAN.TOCC: FDCAN timeout counter configuration register
func (o *FDCAN_Type) SetTOCC_ETOC(value uint32) {
	volatile.StoreUint32(&o.TOCC.Reg, volatile.LoadUint32(&o.TOCC.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetTOCC_ETOC() uint32 {
	return volatile.LoadUint32(&o.TOCC.Reg) & 0x1
}
func (o *FDCAN_Type) SetTOCC_TOS(value uint32) {
	volatile.StoreUint32(&o.TOCC.Reg, volatile.LoadUint32(&o.TOCC.Reg)&^(0x6)|value<<1)
}
func (o *FDCAN_Type) GetTOCC_TOS() uint32 {
	return (volatile.LoadUint32(&o.TOCC.Reg) & 0x6) >> 1
}
func (o *FDCAN_Type) SetTOCC_TOP(value uint32) {
	volatile.StoreUint32(&o.TOCC.Reg, volatile.LoadUint32(&o.TOCC.Reg)&^(0xffff0000)|value<<16)
}
func (o *FDCAN_Type) GetTOCC_TOP() uint32 {
	return (volatile.LoadUint32(&o.TOCC.Reg) & 0xffff0000) >> 16
}

// FDCAN.TOCV: FDCAN timeout counter value register
func (o *FDCAN_Type) SetTOCV_TOC(value uint32) {
	volatile.StoreUint32(&o.TOCV.Reg, volatile.LoadUint32(&o.TOCV.Reg)&^(0xffff)|value)
}
func (o *FDCAN_Type) GetTOCV_TOC() uint32 {
	return volatile.LoadUint32(&o.TOCV.Reg) & 0xffff
}

// FDCAN.ECR: FDCAN error counter register
func (o *FDCAN_Type) SetECR_TEC(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0xff)|value)
}
func (o *FDCAN_Type) GetECR_TEC() uint32 {
	return volatile.LoadUint32(&o.ECR.Reg) & 0xff
}
func (o *FDCAN_Type) SetECR_REC(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0x7f00)|value<<8)
}
func (o *FDCAN_Type) GetECR_REC() uint32 {
	return (volatile.LoadUint32(&o.ECR.Reg) & 0x7f00) >> 8
}
func (o *FDCAN_Type) SetECR_RP(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0x8000)|value<<15)
}
func (o *FDCAN_Type) GetECR_RP() uint32 {
	return (volatile.LoadUint32(&o.ECR.Reg) & 0x8000) >> 15
}
func (o *FDCAN_Type) SetECR_CEL(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0xff0000)|value<<16)
}
func (o *FDCAN_Type) GetECR_CEL() uint32 {
	return (volatile.LoadUint32(&o.ECR.Reg) & 0xff0000) >> 16
}

// FDCAN.PSR: FDCAN protocol status register
func (o *FDCAN_Type) SetPSR_LEC(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetPSR_LEC() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x7
}
func (o *FDCAN_Type) SetPSR_ACT(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x18)|value<<3)
}
func (o *FDCAN_Type) GetPSR_ACT() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x18) >> 3
}
func (o *FDCAN_Type) SetPSR_EP(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20)|value<<5)
}
func (o *FDCAN_Type) GetPSR_EP() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20) >> 5
}
func (o *FDCAN_Type) SetPSR_EW(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40)|value<<6)
}
func (o *FDCAN_Type) GetPSR_EW() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40) >> 6
}
func (o *FDCAN_Type) SetPSR_BO(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80)|value<<7)
}
func (o *FDCAN_Type) GetPSR_BO() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80) >> 7
}
func (o *FDCAN_Type) SetPSR_DLEC(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x700)|value<<8)
}
func (o *FDCAN_Type) GetPSR_DLEC() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x700) >> 8
}
func (o *FDCAN_Type) SetPSR_RESI(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800)|value<<11)
}
func (o *FDCAN_Type) GetPSR_RESI() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800) >> 11
}
func (o *FDCAN_Type) SetPSR_RBRS(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000)|value<<12)
}
func (o *FDCAN_Type) GetPSR_RBRS() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000) >> 12
}
func (o *FDCAN_Type) SetPSR_REDL(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000)|value<<13)
}
func (o *FDCAN_Type) GetPSR_REDL() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000) >> 13
}
func (o *FDCAN_Type) SetPSR_PXE(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000)|value<<14)
}
func (o *FDCAN_Type) GetPSR_PXE() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000) >> 14
}
func (o *FDCAN_Type) SetPSR_TDCV(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x7f0000)|value<<16)
}
func (o *FDCAN_Type) GetPSR_TDCV() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x7f0000) >> 16
}

// FDCAN.TDCR: FDCAN transmitter delay compensation register
func (o *FDCAN_Type) SetTDCR_TDCF(value uint32) {
	volatile.StoreUint32(&o.TDCR.Reg, volatile.LoadUint32(&o.TDCR.Reg)&^(0x7f)|value)
}
func (o *FDCAN_Type) GetTDCR_TDCF() uint32 {
	return volatile.LoadUint32(&o.TDCR.Reg) & 0x7f
}
func (o *FDCAN_Type) SetTDCR_TDCO(value uint32) {
	volatile.StoreUint32(&o.TDCR.Reg, volatile.LoadUint32(&o.TDCR.Reg)&^(0x7f00)|value<<8)
}
func (o *FDCAN_Type) GetTDCR_TDCO() uint32 {
	return (volatile.LoadUint32(&o.TDCR.Reg) & 0x7f00) >> 8
}

// FDCAN.IR: FDCAN interrupt register
func (o *FDCAN_Type) SetIR_RF0N(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetIR_RF0N() uint32 {
	return volatile.LoadUint32(&o.IR.Reg) & 0x1
}
func (o *FDCAN_Type) SetIR_RF0F(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2)|value<<1)
}
func (o *FDCAN_Type) GetIR_RF0F() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2) >> 1
}
func (o *FDCAN_Type) SetIR_RF0L(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x4)|value<<2)
}
func (o *FDCAN_Type) GetIR_RF0L() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x4) >> 2
}
func (o *FDCAN_Type) SetIR_RF1N(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x8)|value<<3)
}
func (o *FDCAN_Type) GetIR_RF1N() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x8) >> 3
}
func (o *FDCAN_Type) SetIR_RF1F(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x10)|value<<4)
}
func (o *FDCAN_Type) GetIR_RF1F() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x10) >> 4
}
func (o *FDCAN_Type) SetIR_RF1L(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x20)|value<<5)
}
func (o *FDCAN_Type) GetIR_RF1L() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x20) >> 5
}
func (o *FDCAN_Type) SetIR_HPM(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x40)|value<<6)
}
func (o *FDCAN_Type) GetIR_HPM() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x40) >> 6
}
func (o *FDCAN_Type) SetIR_TC(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x80)|value<<7)
}
func (o *FDCAN_Type) GetIR_TC() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x80) >> 7
}
func (o *FDCAN_Type) SetIR_TCF(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x100)|value<<8)
}
func (o *FDCAN_Type) GetIR_TCF() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x100) >> 8
}
func (o *FDCAN_Type) SetIR_TFE(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x200)|value<<9)
}
func (o *FDCAN_Type) GetIR_TFE() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x200) >> 9
}
func (o *FDCAN_Type) SetIR_TEFN(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x400)|value<<10)
}
func (o *FDCAN_Type) GetIR_TEFN() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x400) >> 10
}
func (o *FDCAN_Type) SetIR_TEFF(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x800)|value<<11)
}
func (o *FDCAN_Type) GetIR_TEFF() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x800) >> 11
}
func (o *FDCAN_Type) SetIR_TEFL(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1000)|value<<12)
}
func (o *FDCAN_Type) GetIR_TEFL() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x1000) >> 12
}
func (o *FDCAN_Type) SetIR_TSW(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2000)|value<<13)
}
func (o *FDCAN_Type) GetIR_TSW() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2000) >> 13
}
func (o *FDCAN_Type) SetIR_MRAF(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x4000)|value<<14)
}
func (o *FDCAN_Type) GetIR_MRAF() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x4000) >> 14
}
func (o *FDCAN_Type) SetIR_TOO(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x8000)|value<<15)
}
func (o *FDCAN_Type) GetIR_TOO() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x8000) >> 15
}
func (o *FDCAN_Type) SetIR_ELO(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x10000)|value<<16)
}
func (o *FDCAN_Type) GetIR_ELO() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x10000) >> 16
}
func (o *FDCAN_Type) SetIR_EP(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x20000)|value<<17)
}
func (o *FDCAN_Type) GetIR_EP() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x20000) >> 17
}
func (o *FDCAN_Type) SetIR_EW(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x40000)|value<<18)
}
func (o *FDCAN_Type) GetIR_EW() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x40000) >> 18
}
func (o *FDCAN_Type) SetIR_BO(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x80000)|value<<19)
}
func (o *FDCAN_Type) GetIR_BO() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x80000) >> 19
}
func (o *FDCAN_Type) SetIR_WDI(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x100000)|value<<20)
}
func (o *FDCAN_Type) GetIR_WDI() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x100000) >> 20
}
func (o *FDCAN_Type) SetIR_PEA(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x200000)|value<<21)
}
func (o *FDCAN_Type) GetIR_PEA() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x200000) >> 21
}
func (o *FDCAN_Type) SetIR_PED(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x400000)|value<<22)
}
func (o *FDCAN_Type) GetIR_PED() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x400000) >> 22
}
func (o *FDCAN_Type) SetIR_ARA(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x800000)|value<<23)
}
func (o *FDCAN_Type) GetIR_ARA() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x800000) >> 23
}

// FDCAN.IE: FDCAN interrupt enable register
func (o *FDCAN_Type) SetIE_RF0NE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetIE_RF0NE() uint32 {
	return volatile.LoadUint32(&o.IE.Reg) & 0x1
}
func (o *FDCAN_Type) SetIE_RF0FE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2)|value<<1)
}
func (o *FDCAN_Type) GetIE_RF0FE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2) >> 1
}
func (o *FDCAN_Type) SetIE_RF0LE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x4)|value<<2)
}
func (o *FDCAN_Type) GetIE_RF0LE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x4) >> 2
}
func (o *FDCAN_Type) SetIE_RF1NE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x8)|value<<3)
}
func (o *FDCAN_Type) GetIE_RF1NE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x8) >> 3
}
func (o *FDCAN_Type) SetIE_RF1FE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x10)|value<<4)
}
func (o *FDCAN_Type) GetIE_RF1FE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x10) >> 4
}
func (o *FDCAN_Type) SetIE_RF1LE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x20)|value<<5)
}
func (o *FDCAN_Type) GetIE_RF1LE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x20) >> 5
}
func (o *FDCAN_Type) SetIE_HPME(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x40)|value<<6)
}
func (o *FDCAN_Type) GetIE_HPME() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x40) >> 6
}
func (o *FDCAN_Type) SetIE_TCE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x80)|value<<7)
}
func (o *FDCAN_Type) GetIE_TCE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x80) >> 7
}
func (o *FDCAN_Type) SetIE_TCFE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x100)|value<<8)
}
func (o *FDCAN_Type) GetIE_TCFE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x100) >> 8
}
func (o *FDCAN_Type) SetIE_TFEE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x200)|value<<9)
}
func (o *FDCAN_Type) GetIE_TFEE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x200) >> 9
}
func (o *FDCAN_Type) SetIE_TEFNE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x400)|value<<10)
}
func (o *FDCAN_Type) GetIE_TEFNE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x400) >> 10
}
func (o *FDCAN_Type) SetIE_TEFFE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x800)|value<<11)
}
func (o *FDCAN_Type) GetIE_TEFFE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x800) >> 11
}
func (o *FDCAN_Type) SetIE_TEFLE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1000)|value<<12)
}
func (o *FDCAN_Type) GetIE_TEFLE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x1000) >> 12
}
func (o *FDCAN_Type) SetIE_TSWE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2000)|value<<13)
}
func (o *FDCAN_Type) GetIE_TSWE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2000) >> 13
}
func (o *FDCAN_Type) SetIE_MRAFE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x4000)|value<<14)
}
func (o *FDCAN_Type) GetIE_MRAFE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x4000) >> 14
}
func (o *FDCAN_Type) SetIE_TOOE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x8000)|value<<15)
}
func (o *FDCAN_Type) GetIE_TOOE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x8000) >> 15
}
func (o *FDCAN_Type) SetIE_ELOE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x10000)|value<<16)
}
func (o *FDCAN_Type) GetIE_ELOE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x10000) >> 16
}
func (o *FDCAN_Type) SetIE_EPE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x20000)|value<<17)
}
func (o *FDCAN_Type) GetIE_EPE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x20000) >> 17
}
func (o *FDCAN_Type) SetIE_EWE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x40000)|value<<18)
}
func (o *FDCAN_Type) GetIE_EWE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x40000) >> 18
}
func (o *FDCAN_Type) SetIE_BOE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x80000)|value<<19)
}
func (o *FDCAN_Type) GetIE_BOE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x80000) >> 19
}
func (o *FDCAN_Type) SetIE_WDIE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x100000)|value<<20)
}
func (o *FDCAN_Type) GetIE_WDIE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x100000) >> 20
}
func (o *FDCAN_Type) SetIE_PEAE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x200000)|value<<21)
}
func (o *FDCAN_Type) GetIE_PEAE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x200000) >> 21
}
func (o *FDCAN_Type) SetIE_PEDE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x400000)|value<<22)
}
func (o *FDCAN_Type) GetIE_PEDE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x400000) >> 22
}
func (o *FDCAN_Type) SetIE_ARAE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x800000)|value<<23)
}
func (o *FDCAN_Type) GetIE_ARAE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x800000) >> 23
}

// FDCAN.ILS: FDCAN interrupt line select register
func (o *FDCAN_Type) SetILS_RxFIFO0(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetILS_RxFIFO0() uint32 {
	return volatile.LoadUint32(&o.ILS.Reg) & 0x1
}
func (o *FDCAN_Type) SetILS_RxFIFO1(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x2)|value<<1)
}
func (o *FDCAN_Type) GetILS_RxFIFO1() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x2) >> 1
}
func (o *FDCAN_Type) SetILS_SMSG(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x4)|value<<2)
}
func (o *FDCAN_Type) GetILS_SMSG() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x4) >> 2
}
func (o *FDCAN_Type) SetILS_TFERR(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x8)|value<<3)
}
func (o *FDCAN_Type) GetILS_TFERR() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x8) >> 3
}
func (o *FDCAN_Type) SetILS_MISC(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x10)|value<<4)
}
func (o *FDCAN_Type) GetILS_MISC() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x10) >> 4
}
func (o *FDCAN_Type) SetILS_BERR(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x20)|value<<5)
}
func (o *FDCAN_Type) GetILS_BERR() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x20) >> 5
}
func (o *FDCAN_Type) SetILS_PERR(value uint32) {
	volatile.StoreUint32(&o.ILS.Reg, volatile.LoadUint32(&o.ILS.Reg)&^(0x40)|value<<6)
}
func (o *FDCAN_Type) GetILS_PERR() uint32 {
	return (volatile.LoadUint32(&o.ILS.Reg) & 0x40) >> 6
}

// FDCAN.ILE: FDCAN interrupt line enable register
func (o *FDCAN_Type) SetILE_EINT0(value uint32) {
	volatile.StoreUint32(&o.ILE.Reg, volatile.LoadUint32(&o.ILE.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetILE_EINT0() uint32 {
	return volatile.LoadUint32(&o.ILE.Reg) & 0x1
}
func (o *FDCAN_Type) SetILE_EINT1(value uint32) {
	volatile.StoreUint32(&o.ILE.Reg, volatile.LoadUint32(&o.ILE.Reg)&^(0x2)|value<<1)
}
func (o *FDCAN_Type) GetILE_EINT1() uint32 {
	return (volatile.LoadUint32(&o.ILE.Reg) & 0x2) >> 1
}

// FDCAN.RXGFC: FDCAN global filter configuration register
func (o *FDCAN_Type) SetRXGFC_RRFE(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetRXGFC_RRFE() uint32 {
	return volatile.LoadUint32(&o.RXGFC.Reg) & 0x1
}
func (o *FDCAN_Type) SetRXGFC_RRFS(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0x2)|value<<1)
}
func (o *FDCAN_Type) GetRXGFC_RRFS() uint32 {
	return (volatile.LoadUint32(&o.RXGFC.Reg) & 0x2) >> 1
}
func (o *FDCAN_Type) SetRXGFC_ANFE(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0xc)|value<<2)
}
func (o *FDCAN_Type) GetRXGFC_ANFE() uint32 {
	return (volatile.LoadUint32(&o.RXGFC.Reg) & 0xc) >> 2
}
func (o *FDCAN_Type) SetRXGFC_ANFS(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0x30)|value<<4)
}
func (o *FDCAN_Type) GetRXGFC_ANFS() uint32 {
	return (volatile.LoadUint32(&o.RXGFC.Reg) & 0x30) >> 4
}
func (o *FDCAN_Type) SetRXGFC_F1OM(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0x100)|value<<8)
}
func (o *FDCAN_Type) GetRXGFC_F1OM() uint32 {
	return (volatile.LoadUint32(&o.RXGFC.Reg) & 0x100) >> 8
}
func (o *FDCAN_Type) SetRXGFC_F0OM(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0x200)|value<<9)
}
func (o *FDCAN_Type) GetRXGFC_F0OM() uint32 {
	return (volatile.LoadUint32(&o.RXGFC.Reg) & 0x200) >> 9
}
func (o *FDCAN_Type) SetRXGFC_LSS(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0x1f0000)|value<<16)
}
func (o *FDCAN_Type) GetRXGFC_LSS() uint32 {
	return (volatile.LoadUint32(&o.RXGFC.Reg) & 0x1f0000) >> 16
}
func (o *FDCAN_Type) SetRXGFC_LSE(value uint32) {
	volatile.StoreUint32(&o.RXGFC.Reg, volatile.LoadUint32(&o.RXGFC.Reg)&^(0xf000000)|value<<24)
}
func (o *FDCAN_Type) GetRXGFC_LSE() uint32 {
	return (volatile.LoadUint32(&o.RXGFC.Reg) & 0xf000000) >> 24
}

// FDCAN.XIDAM: FDCAN extended ID and mask register
func (o *FDCAN_Type) SetXIDAM_EIDM(value uint32) {
	volatile.StoreUint32(&o.XIDAM.Reg, volatile.LoadUint32(&o.XIDAM.Reg)&^(0x1fffffff)|value)
}
func (o *FDCAN_Type) GetXIDAM_EIDM() uint32 {
	return volatile.LoadUint32(&o.XIDAM.Reg) & 0x1fffffff
}

// FDCAN.HPMS: FDCAN high-priority message status register
func (o *FDCAN_Type) SetHPMS_BIDX(value uint32) {
	volatile.StoreUint32(&o.HPMS.Reg, volatile.LoadUint32(&o.HPMS.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetHPMS_BIDX() uint32 {
	return volatile.LoadUint32(&o.HPMS.Reg) & 0x7
}
func (o *FDCAN_Type) SetHPMS_MSI(value uint32) {
	volatile.StoreUint32(&o.HPMS.Reg, volatile.LoadUint32(&o.HPMS.Reg)&^(0xc0)|value<<6)
}
func (o *FDCAN_Type) GetHPMS_MSI() uint32 {
	return (volatile.LoadUint32(&o.HPMS.Reg) & 0xc0) >> 6
}
func (o *FDCAN_Type) SetHPMS_FIDX(value uint32) {
	volatile.StoreUint32(&o.HPMS.Reg, volatile.LoadUint32(&o.HPMS.Reg)&^(0x1f00)|value<<8)
}
func (o *FDCAN_Type) GetHPMS_FIDX() uint32 {
	return (volatile.LoadUint32(&o.HPMS.Reg) & 0x1f00) >> 8
}
func (o *FDCAN_Type) SetHPMS_FLST(value uint32) {
	volatile.StoreUint32(&o.HPMS.Reg, volatile.LoadUint32(&o.HPMS.Reg)&^(0x8000)|value<<15)
}
func (o *FDCAN_Type) GetHPMS_FLST() uint32 {
	return (volatile.LoadUint32(&o.HPMS.Reg) & 0x8000) >> 15
}

// FDCAN.RXF0S: FDCAN Rx FIFO 0 status register
func (o *FDCAN_Type) SetRXF0S_F0FL(value uint32) {
	volatile.StoreUint32(&o.RXF0S.Reg, volatile.LoadUint32(&o.RXF0S.Reg)&^(0xf)|value)
}
func (o *FDCAN_Type) GetRXF0S_F0FL() uint32 {
	return volatile.LoadUint32(&o.RXF0S.Reg) & 0xf
}
func (o *FDCAN_Type) SetRXF0S_F0GI(value uint32) {
	volatile.StoreUint32(&o.RXF0S.Reg, volatile.LoadUint32(&o.RXF0S.Reg)&^(0x300)|value<<8)
}
func (o *FDCAN_Type) GetRXF0S_F0GI() uint32 {
	return (volatile.LoadUint32(&o.RXF0S.Reg) & 0x300) >> 8
}
func (o *FDCAN_Type) SetRXF0S_F0PI(value uint32) {
	volatile.StoreUint32(&o.RXF0S.Reg, volatile.LoadUint32(&o.RXF0S.Reg)&^(0x30000)|value<<16)
}
func (o *FDCAN_Type) GetRXF0S_F0PI() uint32 {
	return (volatile.LoadUint32(&o.RXF0S.Reg) & 0x30000) >> 16
}
func (o *FDCAN_Type) SetRXF0S_F0F(value uint32) {
	volatile.StoreUint32(&o.RXF0S.Reg, volatile.LoadUint32(&o.RXF0S.Reg)&^(0x1000000)|value<<24)
}
func (o *FDCAN_Type) GetRXF0S_F0F() uint32 {
	return (volatile.LoadUint32(&o.RXF0S.Reg) & 0x1000000) >> 24
}
func (o *FDCAN_Type) SetRXF0S_RF0L(value uint32) {
	volatile.StoreUint32(&o.RXF0S.Reg, volatile.LoadUint32(&o.RXF0S.Reg)&^(0x2000000)|value<<25)
}
func (o *FDCAN_Type) GetRXF0S_RF0L() uint32 {
	return (volatile.LoadUint32(&o.RXF0S.Reg) & 0x2000000) >> 25
}

// FDCAN.RXF0A: CAN Rx FIFO 0 acknowledge register
func (o *FDCAN_Type) SetRXF0A_F0AI(value uint32) {
	volatile.StoreUint32(&o.RXF0A.Reg, volatile.LoadUint32(&o.RXF0A.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetRXF0A_F0AI() uint32 {
	return volatile.LoadUint32(&o.RXF0A.Reg) & 0x7
}

// FDCAN.RXF1S: FDCAN Rx FIFO 1 status register
func (o *FDCAN_Type) SetRXF1S_F1FL(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0xf)|value)
}
func (o *FDCAN_Type) GetRXF1S_F1FL() uint32 {
	return volatile.LoadUint32(&o.RXF1S.Reg) & 0xf
}
func (o *FDCAN_Type) SetRXF1S_F1GI(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0x300)|value<<8)
}
func (o *FDCAN_Type) GetRXF1S_F1GI() uint32 {
	return (volatile.LoadUint32(&o.RXF1S.Reg) & 0x300) >> 8
}
func (o *FDCAN_Type) SetRXF1S_F1PI(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0x30000)|value<<16)
}
func (o *FDCAN_Type) GetRXF1S_F1PI() uint32 {
	return (volatile.LoadUint32(&o.RXF1S.Reg) & 0x30000) >> 16
}
func (o *FDCAN_Type) SetRXF1S_F1F(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0x1000000)|value<<24)
}
func (o *FDCAN_Type) GetRXF1S_F1F() uint32 {
	return (volatile.LoadUint32(&o.RXF1S.Reg) & 0x1000000) >> 24
}
func (o *FDCAN_Type) SetRXF1S_RF1L(value uint32) {
	volatile.StoreUint32(&o.RXF1S.Reg, volatile.LoadUint32(&o.RXF1S.Reg)&^(0x2000000)|value<<25)
}
func (o *FDCAN_Type) GetRXF1S_RF1L() uint32 {
	return (volatile.LoadUint32(&o.RXF1S.Reg) & 0x2000000) >> 25
}

// FDCAN.RXF1A: FDCAN Rx FIFO 1 acknowledge register
func (o *FDCAN_Type) SetRXF1A_F1AI(value uint32) {
	volatile.StoreUint32(&o.RXF1A.Reg, volatile.LoadUint32(&o.RXF1A.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetRXF1A_F1AI() uint32 {
	return volatile.LoadUint32(&o.RXF1A.Reg) & 0x7
}

// FDCAN.TXBC: FDCAN Tx buffer configuration register
func (o *FDCAN_Type) SetTXBC_TFQM(value uint32) {
	volatile.StoreUint32(&o.TXBC.Reg, volatile.LoadUint32(&o.TXBC.Reg)&^(0x1000000)|value<<24)
}
func (o *FDCAN_Type) GetTXBC_TFQM() uint32 {
	return (volatile.LoadUint32(&o.TXBC.Reg) & 0x1000000) >> 24
}

// FDCAN.TXFQS: FDCAN Tx FIFO/queue status register
func (o *FDCAN_Type) SetTXFQS_TFFL(value uint32) {
	volatile.StoreUint32(&o.TXFQS.Reg, volatile.LoadUint32(&o.TXFQS.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXFQS_TFFL() uint32 {
	return volatile.LoadUint32(&o.TXFQS.Reg) & 0x7
}
func (o *FDCAN_Type) SetTXFQS_TFGI(value uint32) {
	volatile.StoreUint32(&o.TXFQS.Reg, volatile.LoadUint32(&o.TXFQS.Reg)&^(0x300)|value<<8)
}
func (o *FDCAN_Type) GetTXFQS_TFGI() uint32 {
	return (volatile.LoadUint32(&o.TXFQS.Reg) & 0x300) >> 8
}
func (o *FDCAN_Type) SetTXFQS_TFQPI(value uint32) {
	volatile.StoreUint32(&o.TXFQS.Reg, volatile.LoadUint32(&o.TXFQS.Reg)&^(0x30000)|value<<16)
}
func (o *FDCAN_Type) GetTXFQS_TFQPI() uint32 {
	return (volatile.LoadUint32(&o.TXFQS.Reg) & 0x30000) >> 16
}
func (o *FDCAN_Type) SetTXFQS_TFQF(value uint32) {
	volatile.StoreUint32(&o.TXFQS.Reg, volatile.LoadUint32(&o.TXFQS.Reg)&^(0x200000)|value<<21)
}
func (o *FDCAN_Type) GetTXFQS_TFQF() uint32 {
	return (volatile.LoadUint32(&o.TXFQS.Reg) & 0x200000) >> 21
}

// FDCAN.TXBRP: FDCAN Tx buffer request pending register
func (o *FDCAN_Type) SetTXBRP_TRP(value uint32) {
	volatile.StoreUint32(&o.TXBRP.Reg, volatile.LoadUint32(&o.TXBRP.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXBRP_TRP() uint32 {
	return volatile.LoadUint32(&o.TXBRP.Reg) & 0x7
}

// FDCAN.TXBAR: FDCAN Tx buffer add request register
func (o *FDCAN_Type) SetTXBAR_AR(value uint32) {
	volatile.StoreUint32(&o.TXBAR.Reg, volatile.LoadUint32(&o.TXBAR.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXBAR_AR() uint32 {
	return volatile.LoadUint32(&o.TXBAR.Reg) & 0x7
}

// FDCAN.TXBCR: FDCAN Tx buffer cancellation request register
func (o *FDCAN_Type) SetTXBCR_CR(value uint32) {
	volatile.StoreUint32(&o.TXBCR.Reg, volatile.LoadUint32(&o.TXBCR.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXBCR_CR() uint32 {
	return volatile.LoadUint32(&o.TXBCR.Reg) & 0x7
}

// FDCAN.TXBTO: FDCAN Tx buffer transmission occurred register
func (o *FDCAN_Type) SetTXBTO_TO(value uint32) {
	volatile.StoreUint32(&o.TXBTO.Reg, volatile.LoadUint32(&o.TXBTO.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXBTO_TO() uint32 {
	return volatile.LoadUint32(&o.TXBTO.Reg) & 0x7
}

// FDCAN.TXBCF: FDCAN Tx buffer cancellation finished register
func (o *FDCAN_Type) SetTXBCF_CF(value uint32) {
	volatile.StoreUint32(&o.TXBCF.Reg, volatile.LoadUint32(&o.TXBCF.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXBCF_CF() uint32 {
	return volatile.LoadUint32(&o.TXBCF.Reg) & 0x7
}

// FDCAN.TXBTIE: FDCAN Tx buffer transmission interrupt enable register
func (o *FDCAN_Type) SetTXBTIE_TIE(value uint32) {
	volatile.StoreUint32(&o.TXBTIE.Reg, volatile.LoadUint32(&o.TXBTIE.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXBTIE_TIE() uint32 {
	return volatile.LoadUint32(&o.TXBTIE.Reg) & 0x7
}

// FDCAN.TXBCIE: FDCAN Tx buffer cancellation finished interrupt enable register
func (o *FDCAN_Type) SetTXBCIE_CFIE(value uint32) {
	volatile.StoreUint32(&o.TXBCIE.Reg, volatile.LoadUint32(&o.TXBCIE.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXBCIE_CFIE() uint32 {
	return volatile.LoadUint32(&o.TXBCIE.Reg) & 0x7
}

// FDCAN.TXEFS: FDCAN Tx event FIFO status register
func (o *FDCAN_Type) SetTXEFS_EFFL(value uint32) {
	volatile.StoreUint32(&o.TXEFS.Reg, volatile.LoadUint32(&o.TXEFS.Reg)&^(0x7)|value)
}
func (o *FDCAN_Type) GetTXEFS_EFFL() uint32 {
	return volatile.LoadUint32(&o.TXEFS.Reg) & 0x7
}
func (o *FDCAN_Type) SetTXEFS_EFGI(value uint32) {
	volatile.StoreUint32(&o.TXEFS.Reg, volatile.LoadUint32(&o.TXEFS.Reg)&^(0x300)|value<<8)
}
func (o *FDCAN_Type) GetTXEFS_EFGI() uint32 {
	return (volatile.LoadUint32(&o.TXEFS.Reg) & 0x300) >> 8
}
func (o *FDCAN_Type) SetTXEFS_EFPI(value uint32) {
	volatile.StoreUint32(&o.TXEFS.Reg, volatile.LoadUint32(&o.TXEFS.Reg)&^(0x30000)|value<<16)
}
func (o *FDCAN_Type) GetTXEFS_EFPI() uint32 {
	return (volatile.LoadUint32(&o.TXEFS.Reg) & 0x30000) >> 16
}
func (o *FDCAN_Type) SetTXEFS_EFF(value uint32) {
	volatile.StoreUint32(&o.TXEFS.Reg, volatile.LoadUint32(&o.TXEFS.Reg)&^(0x1000000)|value<<24)
}
func (o *FDCAN_Type) GetTXEFS_EFF() uint32 {
	return (volatile.LoadUint32(&o.TXEFS.Reg) & 0x1000000) >> 24
}
func (o *FDCAN_Type) SetTXEFS_TEFL(value uint32) {
	volatile.StoreUint32(&o.TXEFS.Reg, volatile.LoadUint32(&o.TXEFS.Reg)&^(0x2000000)|value<<25)
}
func (o *FDCAN_Type) GetTXEFS_TEFL() uint32 {
	return (volatile.LoadUint32(&o.TXEFS.Reg) & 0x2000000) >> 25
}

// FDCAN.TXEFA: FDCAN Tx event FIFO acknowledge register
func (o *FDCAN_Type) SetTXEFA_EFAI(value uint32) {
	volatile.StoreUint32(&o.TXEFA.Reg, volatile.LoadUint32(&o.TXEFA.Reg)&^(0x3)|value)
}
func (o *FDCAN_Type) GetTXEFA_EFAI() uint32 {
	return volatile.LoadUint32(&o.TXEFA.Reg) & 0x3
}

// FDCAN.CKDIV: FDCAN CFG clock divider register
func (o *FDCAN_Type) SetCKDIV_PDIV(value uint32) {
	volatile.StoreUint32(&o.CKDIV.Reg, volatile.LoadUint32(&o.CKDIV.Reg)&^(0xf)|value)
}
func (o *FDCAN_Type) GetCKDIV_PDIV() uint32 {
	return volatile.LoadUint32(&o.CKDIV.Reg) & 0xf
}

// Flash
type Flash_Type struct {
	ACR       volatile.Register32 // 0x0
	_         [4]byte
	KEYR      volatile.Register32 // 0x8
	OPTKEYR   volatile.Register32 // 0xC
	SR        volatile.Register32 // 0x10
	CR        volatile.Register32 // 0x14
	ECCR      volatile.Register32 // 0x18
	_         [4]byte
	OPTR      volatile.Register32 // 0x20
	PCROP1ASR volatile.Register32 // 0x24
	PCROP1AER volatile.Register32 // 0x28
	WRP1AR    volatile.Register32 // 0x2C
	WRP1BR    volatile.Register32 // 0x30
	PCROP1BSR volatile.Register32 // 0x34
	PCROP1BER volatile.Register32 // 0x38
	_         [8]byte
	PCROP2ASR volatile.Register32 // 0x44
	PCROP2AER volatile.Register32 // 0x48
	WRP2AR    volatile.Register32 // 0x4C
	WRP2BR    volatile.Register32 // 0x50
	PCROP2BSR volatile.Register32 // 0x54
	PCROP2BER volatile.Register32 // 0x58
	_         [36]byte
	SECR      volatile.Register32 // 0x80
}

// Flash.ACR: Access control register
func (o *Flash_Type) SetACR_LATENCY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x7)|value)
}
func (o *Flash_Type) GetACR_LATENCY() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x7
}
func (o *Flash_Type) SetACR_PRFTEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetACR_PRFTEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetACR_ICEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetACR_ICEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetACR_ICRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x800)|value<<11)
}
func (o *Flash_Type) GetACR_ICRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x800) >> 11
}
func (o *Flash_Type) SetACR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetACR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetACR_DBG_SWEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetACR_DBG_SWEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x40000) >> 18
}

// Flash.KEYR: Flash key register
func (o *Flash_Type) SetKEYR(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, value)
}
func (o *Flash_Type) GetKEYR() uint32 {
	return volatile.LoadUint32(&o.KEYR.Reg)
}

// Flash.OPTKEYR: Option byte key register
func (o *Flash_Type) SetOPTKEYR(value uint32) {
	volatile.StoreUint32(&o.OPTKEYR.Reg, value)
}
func (o *Flash_Type) GetOPTKEYR() uint32 {
	return volatile.LoadUint32(&o.OPTKEYR.Reg)
}

// Flash.SR: Status register
func (o *Flash_Type) SetSR_EOP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetSR_EOP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *Flash_Type) SetSR_OPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetSR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetSR_PROGERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *Flash_Type) GetSR_PROGERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *Flash_Type) SetSR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *Flash_Type) GetSR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *Flash_Type) SetSR_PGAERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *Flash_Type) GetSR_PGAERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *Flash_Type) SetSR_SIZERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *Flash_Type) GetSR_SIZERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *Flash_Type) SetSR_PGSERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *Flash_Type) GetSR_PGSERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *Flash_Type) SetSR_MISERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetSR_MISERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetSR_FASTERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetSR_FASTERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetSR_RDERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetSR_RDERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *Flash_Type) SetSR_OPTVERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetSR_OPTVERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *Flash_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetSR_CFGBSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetSR_CFGBSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}

// Flash.CR: Flash control register
func (o *Flash_Type) SetCR_PG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetCR_PG() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *Flash_Type) SetCR_PER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetCR_PER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetCR_MER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *Flash_Type) GetCR_MER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *Flash_Type) SetCR_PNB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1f8)|value<<3)
}
func (o *Flash_Type) GetCR_PNB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1f8) >> 3
}
func (o *Flash_Type) SetCR_STRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetCR_STRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetCR_OPTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *Flash_Type) GetCR_OPTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *Flash_Type) SetCR_FSTPG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetCR_FSTPG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetCR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetCR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *Flash_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *Flash_Type) SetCR_RDERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *Flash_Type) GetCR_RDERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *Flash_Type) SetCR_OBL_LAUNCH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *Flash_Type) GetCR_OBL_LAUNCH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *Flash_Type) SetCR_SEC_PROT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *Flash_Type) GetCR_SEC_PROT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *Flash_Type) SetCR_OPTLOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetCR_OPTLOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *Flash_Type) SetCR_LOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetCR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// Flash.ECCR: Flash ECC register
func (o *Flash_Type) SetECCR_ADDR_ECC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x3fff)|value)
}
func (o *Flash_Type) GetECCR_ADDR_ECC() uint32 {
	return volatile.LoadUint32(&o.ECCR.Reg) & 0x3fff
}
func (o *Flash_Type) SetECCR_SYSF_ECC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x100000)|value<<20)
}
func (o *Flash_Type) GetECCR_SYSF_ECC() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x100000) >> 20
}
func (o *Flash_Type) SetECCR_ECCIE(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetECCR_ECCIE() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetECCR_ECCC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetECCR_ECCC() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x40000000) >> 30
}
func (o *Flash_Type) SetECCR_ECCD(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetECCR_ECCD() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x80000000) >> 31
}

// Flash.OPTR: Flash option register
func (o *Flash_Type) SetOPTR_RDP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetOPTR_RDP() uint32 {
	return volatile.LoadUint32(&o.OPTR.Reg) & 0xff
}
func (o *Flash_Type) SetOPTR_BOREN(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetOPTR_BOREN() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetOPTR_BORF_LEV(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x600)|value<<9)
}
func (o *Flash_Type) GetOPTR_BORF_LEV() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x600) >> 9
}
func (o *Flash_Type) SetOPTR_BORR_LEV(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x1800)|value<<11)
}
func (o *Flash_Type) GetOPTR_BORR_LEV() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x1800) >> 11
}
func (o *Flash_Type) SetOPTR_NRST_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x2000)|value<<13)
}
func (o *Flash_Type) GetOPTR_NRST_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x2000) >> 13
}
func (o *Flash_Type) SetOPTR_NRST_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetOPTR_NRST_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x4000) >> 14
}
func (o *Flash_Type) SetOPTR_NRSTS_HDW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetOPTR_NRSTS_HDW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x8000) >> 15
}
func (o *Flash_Type) SetOPTR_IDWG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetOPTR_IDWG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetOPTR_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x20000)|value<<17)
}
func (o *Flash_Type) GetOPTR_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x20000) >> 17
}
func (o *Flash_Type) SetOPTR_IWDG_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetOPTR_IWDG_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetOPTR_WWDG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x80000)|value<<19)
}
func (o *Flash_Type) GetOPTR_WWDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x80000) >> 19
}
func (o *Flash_Type) SetOPTR_RAM_PARITY_CHECK(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x400000)|value<<22)
}
func (o *Flash_Type) GetOPTR_RAM_PARITY_CHECK() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x400000) >> 22
}
func (o *Flash_Type) SetOPTR_NBOOT_SEL(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetOPTR_NBOOT_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetOPTR_NBOOT1(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x2000000)|value<<25)
}
func (o *Flash_Type) GetOPTR_NBOOT1() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x2000000) >> 25
}
func (o *Flash_Type) SetOPTR_NBOOT0(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x4000000)|value<<26)
}
func (o *Flash_Type) GetOPTR_NBOOT0() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x4000000) >> 26
}
func (o *Flash_Type) SetOPTR_NRST_MODE(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x18000000)|value<<27)
}
func (o *Flash_Type) GetOPTR_NRST_MODE() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x18000000) >> 27
}
func (o *Flash_Type) SetOPTR_IRHEN(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x20000000)|value<<29)
}
func (o *Flash_Type) GetOPTR_IRHEN() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x20000000) >> 29
}

// Flash.PCROP1ASR: Flash PCROP zone A Start address register
func (o *Flash_Type) SetPCROP1ASR_PCROP1A_STRT(value uint32) {
	volatile.StoreUint32(&o.PCROP1ASR.Reg, volatile.LoadUint32(&o.PCROP1ASR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetPCROP1ASR_PCROP1A_STRT() uint32 {
	return volatile.LoadUint32(&o.PCROP1ASR.Reg) & 0xff
}

// Flash.PCROP1AER: Flash PCROP zone A End address register
func (o *Flash_Type) SetPCROP1AER_PCROP1A_END(value uint32) {
	volatile.StoreUint32(&o.PCROP1AER.Reg, volatile.LoadUint32(&o.PCROP1AER.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetPCROP1AER_PCROP1A_END() uint32 {
	return volatile.LoadUint32(&o.PCROP1AER.Reg) & 0xff
}
func (o *Flash_Type) SetPCROP1AER_PCROP_RDP(value uint32) {
	volatile.StoreUint32(&o.PCROP1AER.Reg, volatile.LoadUint32(&o.PCROP1AER.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetPCROP1AER_PCROP_RDP() uint32 {
	return (volatile.LoadUint32(&o.PCROP1AER.Reg) & 0x80000000) >> 31
}

// Flash.WRP1AR: Flash WRP area A address register
func (o *Flash_Type) SetWRP1AR_WRP1A_STRT(value uint32) {
	volatile.StoreUint32(&o.WRP1AR.Reg, volatile.LoadUint32(&o.WRP1AR.Reg)&^(0x3f)|value)
}
func (o *Flash_Type) GetWRP1AR_WRP1A_STRT() uint32 {
	return volatile.LoadUint32(&o.WRP1AR.Reg) & 0x3f
}
func (o *Flash_Type) SetWRP1AR_WRP1A_END(value uint32) {
	volatile.StoreUint32(&o.WRP1AR.Reg, volatile.LoadUint32(&o.WRP1AR.Reg)&^(0x3f0000)|value<<16)
}
func (o *Flash_Type) GetWRP1AR_WRP1A_END() uint32 {
	return (volatile.LoadUint32(&o.WRP1AR.Reg) & 0x3f0000) >> 16
}

// Flash.WRP1BR: Flash WRP area B address register
func (o *Flash_Type) SetWRP1BR_WRP1B_STRT(value uint32) {
	volatile.StoreUint32(&o.WRP1BR.Reg, volatile.LoadUint32(&o.WRP1BR.Reg)&^(0x3f)|value)
}
func (o *Flash_Type) GetWRP1BR_WRP1B_STRT() uint32 {
	return volatile.LoadUint32(&o.WRP1BR.Reg) & 0x3f
}
func (o *Flash_Type) SetWRP1BR_WRP1B_END(value uint32) {
	volatile.StoreUint32(&o.WRP1BR.Reg, volatile.LoadUint32(&o.WRP1BR.Reg)&^(0x3f0000)|value<<16)
}
func (o *Flash_Type) GetWRP1BR_WRP1B_END() uint32 {
	return (volatile.LoadUint32(&o.WRP1BR.Reg) & 0x3f0000) >> 16
}

// Flash.PCROP1BSR: Flash PCROP zone B Start address register
func (o *Flash_Type) SetPCROP1BSR_PCROP1B_STRT(value uint32) {
	volatile.StoreUint32(&o.PCROP1BSR.Reg, volatile.LoadUint32(&o.PCROP1BSR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetPCROP1BSR_PCROP1B_STRT() uint32 {
	return volatile.LoadUint32(&o.PCROP1BSR.Reg) & 0xff
}

// Flash.PCROP1BER: Flash PCROP area B End address register
func (o *Flash_Type) SetPCROP1BER_PCROP1B_END(value uint32) {
	volatile.StoreUint32(&o.PCROP1BER.Reg, volatile.LoadUint32(&o.PCROP1BER.Reg)&^(0x1ff)|value)
}
func (o *Flash_Type) GetPCROP1BER_PCROP1B_END() uint32 {
	return volatile.LoadUint32(&o.PCROP1BER.Reg) & 0x1ff
}

// Flash.PCROP2ASR: Flash PCROP2 area A start address register
func (o *Flash_Type) SetPCROP2ASR_PCROP2A_STRT(value uint32) {
	volatile.StoreUint32(&o.PCROP2ASR.Reg, volatile.LoadUint32(&o.PCROP2ASR.Reg)&^(0x1ff)|value)
}
func (o *Flash_Type) GetPCROP2ASR_PCROP2A_STRT() uint32 {
	return volatile.LoadUint32(&o.PCROP2ASR.Reg) & 0x1ff
}

// Flash.PCROP2AER: Flash PCROP2 area A end address register
func (o *Flash_Type) SetPCROP2AER_PCROP2A_END(value uint32) {
	volatile.StoreUint32(&o.PCROP2AER.Reg, volatile.LoadUint32(&o.PCROP2AER.Reg)&^(0x1ff)|value)
}
func (o *Flash_Type) GetPCROP2AER_PCROP2A_END() uint32 {
	return volatile.LoadUint32(&o.PCROP2AER.Reg) & 0x1ff
}

// Flash.WRP2AR: Flash WRP2 area A address register
func (o *Flash_Type) SetWRP2AR_WRP2A_STRT(value uint32) {
	volatile.StoreUint32(&o.WRP2AR.Reg, volatile.LoadUint32(&o.WRP2AR.Reg)&^(0x7f)|value)
}
func (o *Flash_Type) GetWRP2AR_WRP2A_STRT() uint32 {
	return volatile.LoadUint32(&o.WRP2AR.Reg) & 0x7f
}
func (o *Flash_Type) SetWRP2AR_WRP2A_END(value uint32) {
	volatile.StoreUint32(&o.WRP2AR.Reg, volatile.LoadUint32(&o.WRP2AR.Reg)&^(0x7f0000)|value<<16)
}
func (o *Flash_Type) GetWRP2AR_WRP2A_END() uint32 {
	return (volatile.LoadUint32(&o.WRP2AR.Reg) & 0x7f0000) >> 16
}

// Flash.WRP2BR: Flash WRP2 area B address register
func (o *Flash_Type) SetWRP2BR_WRP2B_STRT(value uint32) {
	volatile.StoreUint32(&o.WRP2BR.Reg, volatile.LoadUint32(&o.WRP2BR.Reg)&^(0x7f)|value)
}
func (o *Flash_Type) GetWRP2BR_WRP2B_STRT() uint32 {
	return volatile.LoadUint32(&o.WRP2BR.Reg) & 0x7f
}
func (o *Flash_Type) SetWRP2BR_WRP2B_END(value uint32) {
	volatile.StoreUint32(&o.WRP2BR.Reg, volatile.LoadUint32(&o.WRP2BR.Reg)&^(0x7f0000)|value<<16)
}
func (o *Flash_Type) GetWRP2BR_WRP2B_END() uint32 {
	return (volatile.LoadUint32(&o.WRP2BR.Reg) & 0x7f0000) >> 16
}

// Flash.PCROP2BSR: FLASH PCROP2 area B start address register
func (o *Flash_Type) SetPCROP2BSR_PCROP2B_STRT(value uint32) {
	volatile.StoreUint32(&o.PCROP2BSR.Reg, volatile.LoadUint32(&o.PCROP2BSR.Reg)&^(0x1ff)|value)
}
func (o *Flash_Type) GetPCROP2BSR_PCROP2B_STRT() uint32 {
	return volatile.LoadUint32(&o.PCROP2BSR.Reg) & 0x1ff
}

// Flash.PCROP2BER: FLASH PCROP2 area B end address register
func (o *Flash_Type) SetPCROP2BER_PCROP2B_END(value uint32) {
	volatile.StoreUint32(&o.PCROP2BER.Reg, volatile.LoadUint32(&o.PCROP2BER.Reg)&^(0x1ff)|value)
}
func (o *Flash_Type) GetPCROP2BER_PCROP2B_END() uint32 {
	return volatile.LoadUint32(&o.PCROP2BER.Reg) & 0x1ff
}

// Flash.SECR: Flash Security register
func (o *Flash_Type) SetSECR_SEC_SIZE(value uint32) {
	volatile.StoreUint32(&o.SECR.Reg, volatile.LoadUint32(&o.SECR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetSECR_SEC_SIZE() uint32 {
	return volatile.LoadUint32(&o.SECR.Reg) & 0xff
}
func (o *Flash_Type) SetSECR_BOOT_LOCK(value uint32) {
	volatile.StoreUint32(&o.SECR.Reg, volatile.LoadUint32(&o.SECR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetSECR_BOOT_LOCK() uint32 {
	return (volatile.LoadUint32(&o.SECR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetSECR_SEC_SIZE2(value uint32) {
	volatile.StoreUint32(&o.SECR.Reg, volatile.LoadUint32(&o.SECR.Reg)&^(0xff00000)|value<<20)
}
func (o *Flash_Type) GetSECR_SEC_SIZE2() uint32 {
	return (volatile.LoadUint32(&o.SECR.Reg) & 0xff00000) >> 20
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}

// GPIO.LCKR: GPIO port configuration lock register
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}

// GPIO.AFRL: GPIO alternate function low register
func (o *GPIO_Type) SetAFRL_AFSEL7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFSEL7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRL_AFSEL6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFSEL6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFSEL5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFSEL5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFSEL4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFSEL4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFSEL3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFSEL3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFSEL2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFSEL2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFSEL1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFSEL1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFSEL0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFSEL0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFSEL15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFSEL15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRH_AFSEL14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFSEL14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFSEL13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFSEL13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFSEL12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFSEL12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFSEL11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFSEL11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFSEL10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFSEL10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFSEL9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFSEL9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFSEL8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFSEL8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}

// GPIO.BRR: port bit reset register
func (o *GPIO_Type) SetBRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBRR_BR0() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0x1
}
func (o *GPIO_Type) SetBRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8000) >> 15
}

// HDMI-CEC
type CEC_Type struct {
	CEC_CR   volatile.Register32 // 0x0
	CEC_CFGR volatile.Register32 // 0x4
	CEC_TXDR volatile.Register32 // 0x8
	CEC_RXDR volatile.Register32 // 0xC
	CEC_ISR  volatile.Register32 // 0x10
	CEC_IER  volatile.Register32 // 0x14
}

// CEC.CEC_CR: CEC control register
func (o *CEC_Type) SetCEC_CR_CECEN(value uint32) {
	volatile.StoreUint32(&o.CEC_CR.Reg, volatile.LoadUint32(&o.CEC_CR.Reg)&^(0x1)|value)
}
func (o *CEC_Type) GetCEC_CR_CECEN() uint32 {
	return volatile.LoadUint32(&o.CEC_CR.Reg) & 0x1
}
func (o *CEC_Type) SetCEC_CR_TXSOM(value uint32) {
	volatile.StoreUint32(&o.CEC_CR.Reg, volatile.LoadUint32(&o.CEC_CR.Reg)&^(0x2)|value<<1)
}
func (o *CEC_Type) GetCEC_CR_TXSOM() uint32 {
	return (volatile.LoadUint32(&o.CEC_CR.Reg) & 0x2) >> 1
}
func (o *CEC_Type) SetCEC_CR_TXEOM(value uint32) {
	volatile.StoreUint32(&o.CEC_CR.Reg, volatile.LoadUint32(&o.CEC_CR.Reg)&^(0x4)|value<<2)
}
func (o *CEC_Type) GetCEC_CR_TXEOM() uint32 {
	return (volatile.LoadUint32(&o.CEC_CR.Reg) & 0x4) >> 2
}

// CEC.CEC_CFGR: This register is used to configure the HDMI-CEC controller. It is mandatory to write CEC_CFGR only when CECEN=0.
func (o *CEC_Type) SetCEC_CFGR_SFT(value uint32) {
	volatile.StoreUint32(&o.CEC_CFGR.Reg, volatile.LoadUint32(&o.CEC_CFGR.Reg)&^(0x7)|value)
}
func (o *CEC_Type) GetCEC_CFGR_SFT() uint32 {
	return volatile.LoadUint32(&o.CEC_CFGR.Reg) & 0x7
}
func (o *CEC_Type) SetCEC_CFGR_RXTOL(value uint32) {
	volatile.StoreUint32(&o.CEC_CFGR.Reg, volatile.LoadUint32(&o.CEC_CFGR.Reg)&^(0x8)|value<<3)
}
func (o *CEC_Type) GetCEC_CFGR_RXTOL() uint32 {
	return (volatile.LoadUint32(&o.CEC_CFGR.Reg) & 0x8) >> 3
}
func (o *CEC_Type) SetCEC_CFGR_BRESTP(value uint32) {
	volatile.StoreUint32(&o.CEC_CFGR.Reg, volatile.LoadUint32(&o.CEC_CFGR.Reg)&^(0x10)|value<<4)
}
func (o *CEC_Type) GetCEC_CFGR_BRESTP() uint32 {
	return (volatile.LoadUint32(&o.CEC_CFGR.Reg) & 0x10) >> 4
}
func (o *CEC_Type) SetCEC_CFGR_BREGEN(value uint32) {
	volatile.StoreUint32(&o.CEC_CFGR.Reg, volatile.LoadUint32(&o.CEC_CFGR.Reg)&^(0x20)|value<<5)
}
func (o *CEC_Type) GetCEC_CFGR_BREGEN() uint32 {
	return (volatile.LoadUint32(&o.CEC_CFGR.Reg) & 0x20) >> 5
}
func (o *CEC_Type) SetCEC_CFGR_LBPEGEN(value uint32) {
	volatile.StoreUint32(&o.CEC_CFGR.Reg, volatile.LoadUint32(&o.CEC_CFGR.Reg)&^(0x40)|value<<6)
}
func (o *CEC_Type) GetCEC_CFGR_LBPEGEN() uint32 {
	return (volatile.LoadUint32(&o.CEC_CFGR.Reg) & 0x40) >> 6
}
func (o *CEC_Type) SetCEC_CFGR_BRDNOGEN(value uint32) {
	volatile.StoreUint32(&o.CEC_CFGR.Reg, volatile.LoadUint32(&o.CEC_CFGR.Reg)&^(0x80)|value<<7)
}
func (o *CEC_Type) GetCEC_CFGR_BRDNOGEN() uint32 {
	return (volatile.LoadUint32(&o.CEC_CFGR.Reg) & 0x80) >> 7
}
func (o *CEC_Type) SetCEC_CFGR_SFTOP(value uint32) {
	volatile.StoreUint32(&o.CEC_CFGR.Reg, volatile.LoadUint32(&o.CEC_CFGR.Reg)&^(0x100)|value<<8)
}
func (o *CEC_Type) GetCEC_CFGR_SFTOP() uint32 {
	return (volatile.LoadUint32(&o.CEC_CFGR.Reg) & 0x100) >> 8
}
func (o *CEC_Type) SetCEC_CFGR_OAR(value uint32) {
	volatile.StoreUint32(&o.CEC_CFGR.Reg, volatile.LoadUint32(&o.CEC_CFGR.Reg)&^(0x7fff0000)|value<<16)
}
func (o *CEC_Type) GetCEC_CFGR_OAR() uint32 {
	return (volatile.LoadUint32(&o.CEC_CFGR.Reg) & 0x7fff0000) >> 16
}
func (o *CEC_Type) SetCEC_CFGR_LSTN(value uint32) {
	volatile.StoreUint32(&o.CEC_CFGR.Reg, volatile.LoadUint32(&o.CEC_CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *CEC_Type) GetCEC_CFGR_LSTN() uint32 {
	return (volatile.LoadUint32(&o.CEC_CFGR.Reg) & 0x80000000) >> 31
}

// CEC.CEC_TXDR: CEC Tx data register
func (o *CEC_Type) SetCEC_TXDR_TXD(value uint32) {
	volatile.StoreUint32(&o.CEC_TXDR.Reg, volatile.LoadUint32(&o.CEC_TXDR.Reg)&^(0xff)|value)
}
func (o *CEC_Type) GetCEC_TXDR_TXD() uint32 {
	return volatile.LoadUint32(&o.CEC_TXDR.Reg) & 0xff
}

// CEC.CEC_RXDR: CEC Rx Data Register
func (o *CEC_Type) SetCEC_RXDR_RXD(value uint32) {
	volatile.StoreUint32(&o.CEC_RXDR.Reg, volatile.LoadUint32(&o.CEC_RXDR.Reg)&^(0xff)|value)
}
func (o *CEC_Type) GetCEC_RXDR_RXD() uint32 {
	return volatile.LoadUint32(&o.CEC_RXDR.Reg) & 0xff
}

// CEC.CEC_ISR: CEC Interrupt and Status Register
func (o *CEC_Type) SetCEC_ISR_RXBR(value uint32) {
	volatile.StoreUint32(&o.CEC_ISR.Reg, volatile.LoadUint32(&o.CEC_ISR.Reg)&^(0x1)|value)
}
func (o *CEC_Type) GetCEC_ISR_RXBR() uint32 {
	return volatile.LoadUint32(&o.CEC_ISR.Reg) & 0x1
}
func (o *CEC_Type) SetCEC_ISR_RXEND(value uint32) {
	volatile.StoreUint32(&o.CEC_ISR.Reg, volatile.LoadUint32(&o.CEC_ISR.Reg)&^(0x2)|value<<1)
}
func (o *CEC_Type) GetCEC_ISR_RXEND() uint32 {
	return (volatile.LoadUint32(&o.CEC_ISR.Reg) & 0x2) >> 1
}
func (o *CEC_Type) SetCEC_ISR_RXOVR(value uint32) {
	volatile.StoreUint32(&o.CEC_ISR.Reg, volatile.LoadUint32(&o.CEC_ISR.Reg)&^(0x4)|value<<2)
}
func (o *CEC_Type) GetCEC_ISR_RXOVR() uint32 {
	return (volatile.LoadUint32(&o.CEC_ISR.Reg) & 0x4) >> 2
}
func (o *CEC_Type) SetCEC_ISR_BRE(value uint32) {
	volatile.StoreUint32(&o.CEC_ISR.Reg, volatile.LoadUint32(&o.CEC_ISR.Reg)&^(0x8)|value<<3)
}
func (o *CEC_Type) GetCEC_ISR_BRE() uint32 {
	return (volatile.LoadUint32(&o.CEC_ISR.Reg) & 0x8) >> 3
}
func (o *CEC_Type) SetCEC_ISR_SBPE(value uint32) {
	volatile.StoreUint32(&o.CEC_ISR.Reg, volatile.LoadUint32(&o.CEC_ISR.Reg)&^(0x10)|value<<4)
}
func (o *CEC_Type) GetCEC_ISR_SBPE() uint32 {
	return (volatile.LoadUint32(&o.CEC_ISR.Reg) & 0x10) >> 4
}
func (o *CEC_Type) SetCEC_ISR_LBPE(value uint32) {
	volatile.StoreUint32(&o.CEC_ISR.Reg, volatile.LoadUint32(&o.CEC_ISR.Reg)&^(0x20)|value<<5)
}
func (o *CEC_Type) GetCEC_ISR_LBPE() uint32 {
	return (volatile.LoadUint32(&o.CEC_ISR.Reg) & 0x20) >> 5
}
func (o *CEC_Type) SetCEC_ISR_RXACKE(value uint32) {
	volatile.StoreUint32(&o.CEC_ISR.Reg, volatile.LoadUint32(&o.CEC_ISR.Reg)&^(0x40)|value<<6)
}
func (o *CEC_Type) GetCEC_ISR_RXACKE() uint32 {
	return (volatile.LoadUint32(&o.CEC_ISR.Reg) & 0x40) >> 6
}
func (o *CEC_Type) SetCEC_ISR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.CEC_ISR.Reg, volatile.LoadUint32(&o.CEC_ISR.Reg)&^(0x80)|value<<7)
}
func (o *CEC_Type) GetCEC_ISR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.CEC_ISR.Reg) & 0x80) >> 7
}
func (o *CEC_Type) SetCEC_ISR_TXBR(value uint32) {
	volatile.StoreUint32(&o.CEC_ISR.Reg, volatile.LoadUint32(&o.CEC_ISR.Reg)&^(0x100)|value<<8)
}
func (o *CEC_Type) GetCEC_ISR_TXBR() uint32 {
	return (volatile.LoadUint32(&o.CEC_ISR.Reg) & 0x100) >> 8
}
func (o *CEC_Type) SetCEC_ISR_TXEND(value uint32) {
	volatile.StoreUint32(&o.CEC_ISR.Reg, volatile.LoadUint32(&o.CEC_ISR.Reg)&^(0x200)|value<<9)
}
func (o *CEC_Type) GetCEC_ISR_TXEND() uint32 {
	return (volatile.LoadUint32(&o.CEC_ISR.Reg) & 0x200) >> 9
}
func (o *CEC_Type) SetCEC_ISR_TXUDR(value uint32) {
	volatile.StoreUint32(&o.CEC_ISR.Reg, volatile.LoadUint32(&o.CEC_ISR.Reg)&^(0x400)|value<<10)
}
func (o *CEC_Type) GetCEC_ISR_TXUDR() uint32 {
	return (volatile.LoadUint32(&o.CEC_ISR.Reg) & 0x400) >> 10
}
func (o *CEC_Type) SetCEC_ISR_TXERR(value uint32) {
	volatile.StoreUint32(&o.CEC_ISR.Reg, volatile.LoadUint32(&o.CEC_ISR.Reg)&^(0x800)|value<<11)
}
func (o *CEC_Type) GetCEC_ISR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.CEC_ISR.Reg) & 0x800) >> 11
}
func (o *CEC_Type) SetCEC_ISR_TXACKE(value uint32) {
	volatile.StoreUint32(&o.CEC_ISR.Reg, volatile.LoadUint32(&o.CEC_ISR.Reg)&^(0x1000)|value<<12)
}
func (o *CEC_Type) GetCEC_ISR_TXACKE() uint32 {
	return (volatile.LoadUint32(&o.CEC_ISR.Reg) & 0x1000) >> 12
}

// CEC.CEC_IER: CEC interrupt enable register
func (o *CEC_Type) SetCEC_IER_RXBRIE(value uint32) {
	volatile.StoreUint32(&o.CEC_IER.Reg, volatile.LoadUint32(&o.CEC_IER.Reg)&^(0x1)|value)
}
func (o *CEC_Type) GetCEC_IER_RXBRIE() uint32 {
	return volatile.LoadUint32(&o.CEC_IER.Reg) & 0x1
}
func (o *CEC_Type) SetCEC_IER_RXENDIE(value uint32) {
	volatile.StoreUint32(&o.CEC_IER.Reg, volatile.LoadUint32(&o.CEC_IER.Reg)&^(0x2)|value<<1)
}
func (o *CEC_Type) GetCEC_IER_RXENDIE() uint32 {
	return (volatile.LoadUint32(&o.CEC_IER.Reg) & 0x2) >> 1
}
func (o *CEC_Type) SetCEC_IER_RXOVRIE(value uint32) {
	volatile.StoreUint32(&o.CEC_IER.Reg, volatile.LoadUint32(&o.CEC_IER.Reg)&^(0x4)|value<<2)
}
func (o *CEC_Type) GetCEC_IER_RXOVRIE() uint32 {
	return (volatile.LoadUint32(&o.CEC_IER.Reg) & 0x4) >> 2
}
func (o *CEC_Type) SetCEC_IER_BREIE(value uint32) {
	volatile.StoreUint32(&o.CEC_IER.Reg, volatile.LoadUint32(&o.CEC_IER.Reg)&^(0x8)|value<<3)
}
func (o *CEC_Type) GetCEC_IER_BREIE() uint32 {
	return (volatile.LoadUint32(&o.CEC_IER.Reg) & 0x8) >> 3
}
func (o *CEC_Type) SetCEC_IER_SBPEIE(value uint32) {
	volatile.StoreUint32(&o.CEC_IER.Reg, volatile.LoadUint32(&o.CEC_IER.Reg)&^(0x10)|value<<4)
}
func (o *CEC_Type) GetCEC_IER_SBPEIE() uint32 {
	return (volatile.LoadUint32(&o.CEC_IER.Reg) & 0x10) >> 4
}
func (o *CEC_Type) SetCEC_IER_LBPEIE(value uint32) {
	volatile.StoreUint32(&o.CEC_IER.Reg, volatile.LoadUint32(&o.CEC_IER.Reg)&^(0x20)|value<<5)
}
func (o *CEC_Type) GetCEC_IER_LBPEIE() uint32 {
	return (volatile.LoadUint32(&o.CEC_IER.Reg) & 0x20) >> 5
}
func (o *CEC_Type) SetCEC_IER_RXACKIE(value uint32) {
	volatile.StoreUint32(&o.CEC_IER.Reg, volatile.LoadUint32(&o.CEC_IER.Reg)&^(0x40)|value<<6)
}
func (o *CEC_Type) GetCEC_IER_RXACKIE() uint32 {
	return (volatile.LoadUint32(&o.CEC_IER.Reg) & 0x40) >> 6
}
func (o *CEC_Type) SetCEC_IER_ARBLSTIE(value uint32) {
	volatile.StoreUint32(&o.CEC_IER.Reg, volatile.LoadUint32(&o.CEC_IER.Reg)&^(0x80)|value<<7)
}
func (o *CEC_Type) GetCEC_IER_ARBLSTIE() uint32 {
	return (volatile.LoadUint32(&o.CEC_IER.Reg) & 0x80) >> 7
}
func (o *CEC_Type) SetCEC_IER_TXBRIE(value uint32) {
	volatile.StoreUint32(&o.CEC_IER.Reg, volatile.LoadUint32(&o.CEC_IER.Reg)&^(0x100)|value<<8)
}
func (o *CEC_Type) GetCEC_IER_TXBRIE() uint32 {
	return (volatile.LoadUint32(&o.CEC_IER.Reg) & 0x100) >> 8
}
func (o *CEC_Type) SetCEC_IER_TXENDIE(value uint32) {
	volatile.StoreUint32(&o.CEC_IER.Reg, volatile.LoadUint32(&o.CEC_IER.Reg)&^(0x200)|value<<9)
}
func (o *CEC_Type) GetCEC_IER_TXENDIE() uint32 {
	return (volatile.LoadUint32(&o.CEC_IER.Reg) & 0x200) >> 9
}
func (o *CEC_Type) SetCEC_IER_TXUDRIE(value uint32) {
	volatile.StoreUint32(&o.CEC_IER.Reg, volatile.LoadUint32(&o.CEC_IER.Reg)&^(0x400)|value<<10)
}
func (o *CEC_Type) GetCEC_IER_TXUDRIE() uint32 {
	return (volatile.LoadUint32(&o.CEC_IER.Reg) & 0x400) >> 10
}
func (o *CEC_Type) SetCEC_IER_TXERRIE(value uint32) {
	volatile.StoreUint32(&o.CEC_IER.Reg, volatile.LoadUint32(&o.CEC_IER.Reg)&^(0x800)|value<<11)
}
func (o *CEC_Type) GetCEC_IER_TXERRIE() uint32 {
	return (volatile.LoadUint32(&o.CEC_IER.Reg) & 0x800) >> 11
}
func (o *CEC_Type) SetCEC_IER_TXACKIE(value uint32) {
	volatile.StoreUint32(&o.CEC_IER.Reg, volatile.LoadUint32(&o.CEC_IER.Reg)&^(0x1000)|value<<12)
}
func (o *CEC_Type) GetCEC_IER_TXACKIE() uint32 {
	return (volatile.LoadUint32(&o.CEC_IER.Reg) & 0x1000) >> 12
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// I2C.CR1: Control register 1
func (o *I2C_Type) SetCR1_PE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCR1_PE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *I2C_Type) SetCR1_TXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCR1_TXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCR1_RXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCR1_RXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCR1_ADDRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCR1_ADDRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCR1_NACKIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCR1_NACKIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCR1_STOPIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCR1_STOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCR1_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCR1_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCR1_DNF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00)|value<<8)
}
func (o *I2C_Type) GetCR1_DNF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00) >> 8
}
func (o *I2C_Type) SetCR1_ANFOFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR1_ANFOFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR1_SBC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetCR1_SBC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetCR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetCR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetCR1_WUPEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *I2C_Type) GetCR1_WUPEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *I2C_Type) SetCR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetCR1_GCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetCR1_SMBHEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetCR1_SMBHEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetCR1_SMBDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetCR1_SMBDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *I2C_Type) SetCR1_ALERTEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *I2C_Type) GetCR1_ALERTEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *I2C_Type) SetCR1_PECEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *I2C_Type) GetCR1_PECEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}

// I2C.CR2: Control register 2
func (o *I2C_Type) SetCR2_SADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetCR2_SADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x3ff
}
func (o *I2C_Type) SetCR2_RD_WRN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR2_RD_WRN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR2_ADD10(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR2_ADD10() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR2_HEAD10R(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR2_HEAD10R() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR2_START(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR2_START() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR2_NACK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR2_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR2_NBYTES(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C_Type) GetCR2_NBYTES() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff0000) >> 16
}
func (o *I2C_Type) SetCR2_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetCR2_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetCR2_AUTOEND(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetCR2_AUTOEND() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetCR2_PECBYTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *I2C_Type) GetCR2_PECBYTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000000) >> 26
}

// I2C.OAR1: Own address register 1
func (o *I2C_Type) SetOAR1_OA1(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetOAR1_OA1() uint32 {
	return volatile.LoadUint32(&o.OAR1.Reg) & 0x3ff
}
func (o *I2C_Type) SetOAR1_OA1MODE(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetOAR1_OA1MODE() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetOAR1_OA1EN(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR1_OA1EN() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x8000) >> 15
}

// I2C.OAR2: Own address register 2
func (o *I2C_Type) SetOAR2_OA2(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR2_OA2() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR2_OA2MSK(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x700)|value<<8)
}
func (o *I2C_Type) GetOAR2_OA2MSK() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x700) >> 8
}
func (o *I2C_Type) SetOAR2_OA2EN(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR2_OA2EN() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x8000) >> 15
}

// I2C.TIMINGR: Timing register
func (o *I2C_Type) SetTIMINGR_SCLL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTIMINGR_SCLL() uint32 {
	return volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff
}
func (o *I2C_Type) SetTIMINGR_SCLH(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetTIMINGR_SCLH() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetTIMINGR_SDADEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000)|value<<16)
}
func (o *I2C_Type) GetTIMINGR_SDADEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000) >> 16
}
func (o *I2C_Type) SetTIMINGR_SCLDEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetTIMINGR_SCLDEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetTIMINGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000000)|value<<28)
}
func (o *I2C_Type) GetTIMINGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000000) >> 28
}

// I2C.TIMEOUTR: Status register 1
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTA(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTA() uint32 {
	return volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff
}
func (o *I2C_Type) SetTIMEOUTR_TIDLE(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetTIMEOUTR_TIDLE() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetTIMEOUTR_TIMOUTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetTIMEOUTR_TIMOUTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTB(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff0000)|value<<16)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTB() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff0000) >> 16
}
func (o *I2C_Type) SetTIMEOUTR_TEXTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetTIMEOUTR_TEXTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x80000000) >> 31
}

// I2C.ISR: Interrupt and Status register
func (o *I2C_Type) SetISR_ADDCODE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xfe0000)|value<<17)
}
func (o *I2C_Type) GetISR_ADDCODE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xfe0000) >> 17
}
func (o *I2C_Type) SetISR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetISR_ALERT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetISR_ALERT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetISR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetISR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetISR_PECERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetISR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetISR_ARLO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetISR_ARLO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetISR_BERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetISR_BERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetISR_TCR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetISR_TCR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetISR_STOPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetISR_STOPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetISR_NACKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetISR_NACKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetISR_ADDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetISR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetISR_TXIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetISR_TXIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetISR_TXE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// I2C.ICR: Interrupt clear register
func (o *I2C_Type) SetICR_ALERTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetICR_ALERTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetICR_TIMOUTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetICR_TIMOUTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetICR_PECCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetICR_PECCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetICR_OVRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetICR_OVRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetICR_ARLOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetICR_ARLOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetICR_BERRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetICR_BERRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetICR_STOPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetICR_STOPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetICR_NACKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetICR_NACKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetICR_ADDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetICR_ADDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}

// I2C.PECR: PEC register
func (o *I2C_Type) SetPECR_PEC(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetPECR_PEC() uint32 {
	return volatile.LoadUint32(&o.PECR.Reg) & 0xff
}

// I2C.RXDR: Receive data register
func (o *I2C_Type) SetRXDR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetRXDR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// I2C.TXDR: Transmit data register
func (o *I2C_Type) SetTXDR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTXDR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_WVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *IWDG_Type) GetSR_WVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}

// IWDG.WINR: Window register
func (o *IWDG_Type) SetWINR_WIN(value uint32) {
	volatile.StoreUint32(&o.WINR.Reg, volatile.LoadUint32(&o.WINR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetWINR_WIN() uint32 {
	return volatile.LoadUint32(&o.WINR.Reg) & 0xfff
}

// Low power timer
type LPTIM_Type struct {
	ISR   volatile.Register32 // 0x0
	ICR   volatile.Register32 // 0x4
	IER   volatile.Register32 // 0x8
	CFGR  volatile.Register32 // 0xC
	CR    volatile.Register32 // 0x10
	CMP   volatile.Register32 // 0x14
	ARR   volatile.Register32 // 0x18
	CNT   volatile.Register32 // 0x1C
	_     [4]byte
	CFGR2 volatile.Register32 // 0x24
}

// LPTIM.ISR: Interrupt and Status Register
func (o *LPTIM_Type) SetISR_CMPM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetISR_CMPM() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *LPTIM_Type) SetISR_ARRM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetISR_ARRM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetISR_EXTTRIG(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetISR_EXTTRIG() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetISR_CMPOK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetISR_CMPOK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetISR_ARROK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetISR_ARROK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetISR_UP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetISR_UP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetISR_DOWN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetISR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}

// LPTIM.ICR: Interrupt Clear Register
func (o *LPTIM_Type) SetICR_CMPMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetICR_CMPMCF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *LPTIM_Type) SetICR_ARRMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetICR_ARRMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetICR_EXTTRIGCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetICR_EXTTRIGCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetICR_CMPOKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetICR_CMPOKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetICR_ARROKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetICR_ARROKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetICR_UPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetICR_UPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetICR_DOWNCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetICR_DOWNCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}

// LPTIM.IER: Interrupt Enable Register
func (o *LPTIM_Type) SetIER_CMPMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetIER_CMPMIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *LPTIM_Type) SetIER_ARRMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetIER_ARRMIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetIER_EXTTRIGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetIER_EXTTRIGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetIER_CMPOKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetIER_CMPOKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetIER_ARROKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetIER_ARROKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetIER_UPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetIER_UPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetIER_DOWNIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetIER_DOWNIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}

// LPTIM.CFGR: Configuration Register
func (o *LPTIM_Type) SetCFGR_CKSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCFGR_CKSEL() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}
func (o *LPTIM_Type) SetCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x6)|value<<1)
}
func (o *LPTIM_Type) GetCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x6) >> 1
}
func (o *LPTIM_Type) SetCFGR_CKFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x18)|value<<3)
}
func (o *LPTIM_Type) GetCFGR_CKFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x18) >> 3
}
func (o *LPTIM_Type) SetCFGR_TRGFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0)|value<<6)
}
func (o *LPTIM_Type) GetCFGR_TRGFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0) >> 6
}
func (o *LPTIM_Type) SetCFGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe00)|value<<9)
}
func (o *LPTIM_Type) GetCFGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe00) >> 9
}
func (o *LPTIM_Type) SetCFGR_TRIGSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe000)|value<<13)
}
func (o *LPTIM_Type) GetCFGR_TRIGSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe000) >> 13
}
func (o *LPTIM_Type) SetCFGR_TRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x60000)|value<<17)
}
func (o *LPTIM_Type) GetCFGR_TRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x60000) >> 17
}
func (o *LPTIM_Type) SetCFGR_TIMOUT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000)|value<<19)
}
func (o *LPTIM_Type) GetCFGR_TIMOUT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000) >> 19
}
func (o *LPTIM_Type) SetCFGR_WAVE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *LPTIM_Type) GetCFGR_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *LPTIM_Type) SetCFGR_WAVPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *LPTIM_Type) GetCFGR_WAVPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *LPTIM_Type) SetCFGR_PRELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *LPTIM_Type) GetCFGR_PRELOAD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *LPTIM_Type) SetCFGR_COUNTMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *LPTIM_Type) GetCFGR_COUNTMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *LPTIM_Type) SetCFGR_ENC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *LPTIM_Type) GetCFGR_ENC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}

// LPTIM.CR: Control Register
func (o *LPTIM_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *LPTIM_Type) SetCR_SNGSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetCR_SNGSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetCR_CNTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetCR_CNTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetCR_COUNTRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetCR_COUNTRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetCR_RSTARE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetCR_RSTARE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}

// LPTIM.CMP: Compare Register
func (o *LPTIM_Type) SetCMP(value uint32) {
	volatile.StoreUint32(&o.CMP.Reg, volatile.LoadUint32(&o.CMP.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCMP() uint32 {
	return volatile.LoadUint32(&o.CMP.Reg) & 0xffff
}

// LPTIM.ARR: Autoreload Register
func (o *LPTIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// LPTIM.CNT: Counter Register
func (o *LPTIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// LPTIM.CFGR2: LPTIM configuration register 2
func (o *LPTIM_Type) SetCFGR2_IN1SEL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x3)|value)
}
func (o *LPTIM_Type) GetCFGR2_IN1SEL() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x3
}
func (o *LPTIM_Type) SetCFGR2_IN2SEL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x30)|value<<4)
}
func (o *LPTIM_Type) GetCFGR2_IN2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x30) >> 4
}

// Low-power universal asynchronous receiver transmitter
type LPUART_Type struct {
	CR1_enabled volatile.Register32 // 0x0
	CR2         volatile.Register32 // 0x4
	CR3         volatile.Register32 // 0x8
	BRR         volatile.Register32 // 0xC
	_           [8]byte
	RQR         volatile.Register32 // 0x18
	ISR_enabled volatile.Register32 // 0x1C
	ICR         volatile.Register32 // 0x20
	RDR         volatile.Register32 // 0x24
	TDR         volatile.Register32 // 0x28
	PRESC       volatile.Register32 // 0x2C
}

// LPUART.CR1_enabled: LPUART control register 1 [alternate]
func (o *LPUART_Type) SetCR1_enabled_UE(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x1)|value)
}
func (o *LPUART_Type) GetCR1_enabled_UE() uint32 {
	return volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x1
}
func (o *LPUART_Type) SetCR1_enabled_UESM(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x2)|value<<1)
}
func (o *LPUART_Type) GetCR1_enabled_UESM() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x2) >> 1
}
func (o *LPUART_Type) SetCR1_enabled_RE(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x4)|value<<2)
}
func (o *LPUART_Type) GetCR1_enabled_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x4) >> 2
}
func (o *LPUART_Type) SetCR1_enabled_TE(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x8)|value<<3)
}
func (o *LPUART_Type) GetCR1_enabled_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x8) >> 3
}
func (o *LPUART_Type) SetCR1_enabled_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x10)|value<<4)
}
func (o *LPUART_Type) GetCR1_enabled_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x10) >> 4
}
func (o *LPUART_Type) SetCR1_enabled_RXFNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x20)|value<<5)
}
func (o *LPUART_Type) GetCR1_enabled_RXFNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x20) >> 5
}
func (o *LPUART_Type) SetCR1_enabled_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x40)|value<<6)
}
func (o *LPUART_Type) GetCR1_enabled_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x40) >> 6
}
func (o *LPUART_Type) SetCR1_enabled_TXFNFIE(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x80)|value<<7)
}
func (o *LPUART_Type) GetCR1_enabled_TXFNFIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x80) >> 7
}
func (o *LPUART_Type) SetCR1_enabled_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x100)|value<<8)
}
func (o *LPUART_Type) GetCR1_enabled_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x100) >> 8
}
func (o *LPUART_Type) SetCR1_enabled_PS(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x200)|value<<9)
}
func (o *LPUART_Type) GetCR1_enabled_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x200) >> 9
}
func (o *LPUART_Type) SetCR1_enabled_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x400)|value<<10)
}
func (o *LPUART_Type) GetCR1_enabled_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x400) >> 10
}
func (o *LPUART_Type) SetCR1_enabled_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x800)|value<<11)
}
func (o *LPUART_Type) GetCR1_enabled_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x800) >> 11
}
func (o *LPUART_Type) SetCR1_enabled_M0(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x1000)|value<<12)
}
func (o *LPUART_Type) GetCR1_enabled_M0() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x1000) >> 12
}
func (o *LPUART_Type) SetCR1_enabled_MME(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x2000)|value<<13)
}
func (o *LPUART_Type) GetCR1_enabled_MME() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x2000) >> 13
}
func (o *LPUART_Type) SetCR1_enabled_CMIE(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x4000)|value<<14)
}
func (o *LPUART_Type) GetCR1_enabled_CMIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x4000) >> 14
}
func (o *LPUART_Type) SetCR1_enabled_DEDT(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x1f0000)|value<<16)
}
func (o *LPUART_Type) GetCR1_enabled_DEDT() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x1f0000) >> 16
}
func (o *LPUART_Type) SetCR1_enabled_DEAT(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x3e00000)|value<<21)
}
func (o *LPUART_Type) GetCR1_enabled_DEAT() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x3e00000) >> 21
}
func (o *LPUART_Type) SetCR1_enabled_M1(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x10000000)|value<<28)
}
func (o *LPUART_Type) GetCR1_enabled_M1() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x10000000) >> 28
}
func (o *LPUART_Type) SetCR1_enabled_FIFOEN(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x20000000)|value<<29)
}
func (o *LPUART_Type) GetCR1_enabled_FIFOEN() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x20000000) >> 29
}
func (o *LPUART_Type) SetCR1_enabled_TXFEIE(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x40000000)|value<<30)
}
func (o *LPUART_Type) GetCR1_enabled_TXFEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x40000000) >> 30
}
func (o *LPUART_Type) SetCR1_enabled_RXFFIE(value uint32) {
	volatile.StoreUint32(&o.CR1_enabled.Reg, volatile.LoadUint32(&o.CR1_enabled.Reg)&^(0x80000000)|value<<31)
}
func (o *LPUART_Type) GetCR1_enabled_RXFFIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_enabled.Reg) & 0x80000000) >> 31
}

// LPUART.CR2: LPUART control register 2
func (o *LPUART_Type) SetCR2_ADDM7(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *LPUART_Type) GetCR2_ADDM7() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *LPUART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *LPUART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *LPUART_Type) SetCR2_SWAP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *LPUART_Type) GetCR2_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *LPUART_Type) SetCR2_RXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *LPUART_Type) GetCR2_RXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *LPUART_Type) SetCR2_TXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *LPUART_Type) GetCR2_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *LPUART_Type) SetCR2_DATAINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *LPUART_Type) GetCR2_DATAINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *LPUART_Type) SetCR2_MSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80000)|value<<19)
}
func (o *LPUART_Type) GetCR2_MSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80000) >> 19
}
func (o *LPUART_Type) SetCR2_ADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff000000)|value<<24)
}
func (o *LPUART_Type) GetCR2_ADD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff000000) >> 24
}

// LPUART.CR3: LPUART control register 3
func (o *LPUART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *LPUART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}
func (o *LPUART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *LPUART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *LPUART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *LPUART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *LPUART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *LPUART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *LPUART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *LPUART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *LPUART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *LPUART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *LPUART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *LPUART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *LPUART_Type) SetCR3_OVRDIS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000)|value<<12)
}
func (o *LPUART_Type) GetCR3_OVRDIS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000) >> 12
}
func (o *LPUART_Type) SetCR3_DDRE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *LPUART_Type) GetCR3_DDRE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *LPUART_Type) SetCR3_DEM(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *LPUART_Type) GetCR3_DEM() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *LPUART_Type) SetCR3_DEP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *LPUART_Type) GetCR3_DEP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}
func (o *LPUART_Type) SetCR3_WUS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x300000)|value<<20)
}
func (o *LPUART_Type) GetCR3_WUS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x300000) >> 20
}
func (o *LPUART_Type) SetCR3_WUFIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400000)|value<<22)
}
func (o *LPUART_Type) GetCR3_WUFIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400000) >> 22
}
func (o *LPUART_Type) SetCR3_TXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800000)|value<<23)
}
func (o *LPUART_Type) GetCR3_TXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800000) >> 23
}
func (o *LPUART_Type) SetCR3_RXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe000000)|value<<25)
}
func (o *LPUART_Type) GetCR3_RXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe000000) >> 25
}
func (o *LPUART_Type) SetCR3_RXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10000000)|value<<28)
}
func (o *LPUART_Type) GetCR3_RXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10000000) >> 28
}
func (o *LPUART_Type) SetCR3_TXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000000)|value<<29)
}
func (o *LPUART_Type) GetCR3_TXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000000) >> 29
}

// LPUART.BRR: LPUART baud rate register
func (o *LPUART_Type) SetBRR(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xfffff)|value)
}
func (o *LPUART_Type) GetBRR() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xfffff
}

// LPUART.RQR: LPUART request register
func (o *LPUART_Type) SetRQR_SBKRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x2)|value<<1)
}
func (o *LPUART_Type) GetRQR_SBKRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x2) >> 1
}
func (o *LPUART_Type) SetRQR_MMRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x4)|value<<2)
}
func (o *LPUART_Type) GetRQR_MMRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x4) >> 2
}
func (o *LPUART_Type) SetRQR_RXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x8)|value<<3)
}
func (o *LPUART_Type) GetRQR_RXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x8) >> 3
}
func (o *LPUART_Type) SetRQR_TXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x10)|value<<4)
}
func (o *LPUART_Type) GetRQR_TXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x10) >> 4
}

// LPUART.ISR_enabled: LPUART interrupt and status register [alternate]
func (o *LPUART_Type) SetISR_enabled_PE(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x1)|value)
}
func (o *LPUART_Type) GetISR_enabled_PE() uint32 {
	return volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x1
}
func (o *LPUART_Type) SetISR_enabled_FE(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x2)|value<<1)
}
func (o *LPUART_Type) GetISR_enabled_FE() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x2) >> 1
}
func (o *LPUART_Type) SetISR_enabled_NE(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x4)|value<<2)
}
func (o *LPUART_Type) GetISR_enabled_NE() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x4) >> 2
}
func (o *LPUART_Type) SetISR_enabled_ORE(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x8)|value<<3)
}
func (o *LPUART_Type) GetISR_enabled_ORE() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x8) >> 3
}
func (o *LPUART_Type) SetISR_enabled_IDLE(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x10)|value<<4)
}
func (o *LPUART_Type) GetISR_enabled_IDLE() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x10) >> 4
}
func (o *LPUART_Type) SetISR_enabled_RXFNE(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x20)|value<<5)
}
func (o *LPUART_Type) GetISR_enabled_RXFNE() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x20) >> 5
}
func (o *LPUART_Type) SetISR_enabled_TC(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x40)|value<<6)
}
func (o *LPUART_Type) GetISR_enabled_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x40) >> 6
}
func (o *LPUART_Type) SetISR_enabled_TXFNF(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x80)|value<<7)
}
func (o *LPUART_Type) GetISR_enabled_TXFNF() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x80) >> 7
}
func (o *LPUART_Type) SetISR_enabled_CTSIF(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x200)|value<<9)
}
func (o *LPUART_Type) GetISR_enabled_CTSIF() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x200) >> 9
}
func (o *LPUART_Type) SetISR_enabled_CTS(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x400)|value<<10)
}
func (o *LPUART_Type) GetISR_enabled_CTS() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x400) >> 10
}
func (o *LPUART_Type) SetISR_enabled_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x10000)|value<<16)
}
func (o *LPUART_Type) GetISR_enabled_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x10000) >> 16
}
func (o *LPUART_Type) SetISR_enabled_CMF(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x20000)|value<<17)
}
func (o *LPUART_Type) GetISR_enabled_CMF() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x20000) >> 17
}
func (o *LPUART_Type) SetISR_enabled_SBKF(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x40000)|value<<18)
}
func (o *LPUART_Type) GetISR_enabled_SBKF() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x40000) >> 18
}
func (o *LPUART_Type) SetISR_enabled_RWU(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x80000)|value<<19)
}
func (o *LPUART_Type) GetISR_enabled_RWU() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x80000) >> 19
}
func (o *LPUART_Type) SetISR_enabled_WUF(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x100000)|value<<20)
}
func (o *LPUART_Type) GetISR_enabled_WUF() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x100000) >> 20
}
func (o *LPUART_Type) SetISR_enabled_TEACK(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x200000)|value<<21)
}
func (o *LPUART_Type) GetISR_enabled_TEACK() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x200000) >> 21
}
func (o *LPUART_Type) SetISR_enabled_REACK(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x400000)|value<<22)
}
func (o *LPUART_Type) GetISR_enabled_REACK() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x400000) >> 22
}
func (o *LPUART_Type) SetISR_enabled_TXFE(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x800000)|value<<23)
}
func (o *LPUART_Type) GetISR_enabled_TXFE() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x800000) >> 23
}
func (o *LPUART_Type) SetISR_enabled_RXFF(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x1000000)|value<<24)
}
func (o *LPUART_Type) GetISR_enabled_RXFF() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x1000000) >> 24
}
func (o *LPUART_Type) SetISR_enabled_RXFT(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x4000000)|value<<26)
}
func (o *LPUART_Type) GetISR_enabled_RXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x4000000) >> 26
}
func (o *LPUART_Type) SetISR_enabled_TXFT(value uint32) {
	volatile.StoreUint32(&o.ISR_enabled.Reg, volatile.LoadUint32(&o.ISR_enabled.Reg)&^(0x8000000)|value<<27)
}
func (o *LPUART_Type) GetISR_enabled_TXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR_enabled.Reg) & 0x8000000) >> 27
}

// LPUART.ICR: LPUART interrupt flag clear register
func (o *LPUART_Type) SetICR_PECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LPUART_Type) GetICR_PECF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *LPUART_Type) SetICR_FECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LPUART_Type) GetICR_FECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LPUART_Type) SetICR_NECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LPUART_Type) GetICR_NECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LPUART_Type) SetICR_ORECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LPUART_Type) GetICR_ORECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LPUART_Type) SetICR_IDLECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *LPUART_Type) GetICR_IDLECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *LPUART_Type) SetICR_TCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *LPUART_Type) GetICR_TCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *LPUART_Type) SetICR_CTSCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *LPUART_Type) GetICR_CTSCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *LPUART_Type) SetICR_CMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20000)|value<<17)
}
func (o *LPUART_Type) GetICR_CMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20000) >> 17
}
func (o *LPUART_Type) SetICR_WUCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100000)|value<<20)
}
func (o *LPUART_Type) GetICR_WUCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100000) >> 20
}

// LPUART.RDR: LPUART receive data register
func (o *LPUART_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0x1ff)|value)
}
func (o *LPUART_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0x1ff
}

// LPUART.TDR: LPUART transmit data register
func (o *LPUART_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1ff)|value)
}
func (o *LPUART_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0x1ff
}

// LPUART.PRESC: LPUART prescaler register
func (o *LPUART_Type) SetPRESC_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESC.Reg, volatile.LoadUint32(&o.PRESC.Reg)&^(0xf)|value)
}
func (o *LPUART_Type) GetPRESC_PRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESC.Reg) & 0xf
}

// Power control
type PWR_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	CR3   volatile.Register32 // 0x8
	CR4   volatile.Register32 // 0xC
	SR1   volatile.Register32 // 0x10
	SR2   volatile.Register32 // 0x14
	SCR   volatile.Register32 // 0x18
	_     [4]byte
	PUCRA volatile.Register32 // 0x20
	PDCRA volatile.Register32 // 0x24
	PUCRB volatile.Register32 // 0x28
	PDCRB volatile.Register32 // 0x2C
	PUCRC volatile.Register32 // 0x30
	PDCRC volatile.Register32 // 0x34
	PUCRD volatile.Register32 // 0x38
	PDCRD volatile.Register32 // 0x3C
	PUCRE volatile.Register32 // 0x40
	PDCRE volatile.Register32 // 0x44
	PUCRF volatile.Register32 // 0x48
	PDCRF volatile.Register32 // 0x4C
}

// PWR.CR1: Power control register 1
func (o *PWR_Type) SetCR1_LPR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCR1_LPR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetCR1_VOS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x600)|value<<9)
}
func (o *PWR_Type) GetCR1_VOS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x600) >> 9
}
func (o *PWR_Type) SetCR1_DBP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR1_DBP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR1_FPD_LPSLP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetCR1_FPD_LPSLP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetCR1_FPD_LPRUN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR1_FPD_LPRUN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR1_FPD_STOP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR1_FPD_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR1_LPMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x7)|value)
}
func (o *PWR_Type) GetCR1_LPMS() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x7
}

// PWR.CR2: Power control register 2
func (o *PWR_Type) SetCR2_PVDE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR2_PVDE() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *PWR_Type) SetCR2_PVDFT(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xe)|value<<1)
}
func (o *PWR_Type) GetCR2_PVDFT() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xe) >> 1
}
func (o *PWR_Type) SetCR2_PVDRT(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *PWR_Type) GetCR2_PVDRT() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}
func (o *PWR_Type) SetCR2_PVMENDAC(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetCR2_PVMENDAC() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetCR2_PVMENUSB(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR2_PVMENUSB() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR2_IOSV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR2_IOSV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR2_USV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR2_USV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}

// PWR.CR3: Power control register 3
func (o *PWR_Type) SetCR3_EWUP1(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR3_EWUP1() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}
func (o *PWR_Type) SetCR3_EWUP2(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR3_EWUP2() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR3_EWUP3(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR3_EWUP3() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR3_EWUP4(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR3_EWUP4() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR3_EWUP5(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR3_EWUP5() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR3_EWUP6(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetCR3_EWUP6() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetCR3_RRS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR3_RRS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR3_ENB_ULP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR3_ENB_ULP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR3_APC(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR3_APC() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCR3_EIWUL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetCR3_EIWUL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}

// PWR.CR4: Power control register 4
func (o *PWR_Type) SetCR4_WP1(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR4_WP1() uint32 {
	return volatile.LoadUint32(&o.CR4.Reg) & 0x1
}
func (o *PWR_Type) SetCR4_WP2(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR4_WP2() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR4_WP3(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR4_WP3() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR4_WP4(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR4_WP4() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR4_WP5(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR4_WP5() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR4_WP6(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetCR4_WP6() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetCR4_VBE(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR4_VBE() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR4_VBRS(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR4_VBRS() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x200) >> 9
}

// PWR.SR1: Power status register 1
func (o *PWR_Type) SetSR1_WUF1(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetSR1_WUF1() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}
func (o *PWR_Type) SetSR1_WUF2(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetSR1_WUF2() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetSR1_WUF3(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetSR1_WUF3() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetSR1_WUF4(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetSR1_WUF4() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetSR1_WUF5(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetSR1_WUF5() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetSR1_WUF6(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetSR1_WUF6() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetSR1_SBF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSR1_SBF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetSR1_WUFI(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetSR1_WUFI() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8000) >> 15
}

// PWR.SR2: Power status register 2
func (o *PWR_Type) SetSR2_PVMODAC(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetSR2_PVMODAC() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetSR2_PVMOUSB(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetSR2_PVMOUSB() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetSR2_PVDO(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetSR2_PVDO() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetSR2_VOSF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetSR2_VOSF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetSR2_REGLPF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetSR2_REGLPF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetSR2_REGLPS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSR2_REGLPS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetSR2_FLASH_RDY(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetSR2_FLASH_RDY() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x80) >> 7
}

// PWR.SCR: Power status clear register
func (o *PWR_Type) SetSCR_CSBF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSCR_CSBF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetSCR_CWUF6(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetSCR_CWUF6() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetSCR_CWUF5(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetSCR_CWUF5() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetSCR_CWUF4(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetSCR_CWUF4() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetSCR_CWUF3(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetSCR_CWUF3() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetSCR_CWUF2(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetSCR_CWUF2() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetSCR_CWUF1(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetSCR_CWUF1() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}

// PWR.PUCRA: Power Port A pull-up control register
func (o *PWR_Type) SetPUCRA_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRA_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRA_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRA_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRA_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRA_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRA_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRA_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRA_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRA_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRA_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRA_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRA_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRA_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRA_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRA_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRA_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRA_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRA_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRA_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRA_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRA_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRA_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRA_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRA_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRA_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRA_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRA_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRA_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRA_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRA_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRA_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRA.Reg) & 0x1
}

// PWR.PDCRA: Power Port A pull-down control register
func (o *PWR_Type) SetPDCRA_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRA_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRA_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRA_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRA_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRA_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRA_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRA_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRA_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRA_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRA_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRA_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRA_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRA_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRA_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRA_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRA_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRA_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRA_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRA_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRA_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRA_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRA_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRA_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRA_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRA_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRA_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRA_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRA_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRA_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRA_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRA_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRA.Reg) & 0x1
}

// PWR.PUCRB: Power Port B pull-up control register
func (o *PWR_Type) SetPUCRB_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRB_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRB_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRB_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRB_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRB_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRB_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRB_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRB_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRB_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRB_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRB_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRB_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRB_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRB_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRB_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRB_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRB_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRB_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRB_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRB_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRB_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRB_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRB_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRB_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRB_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRB_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRB_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRB_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRB_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRB_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRB_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRB.Reg) & 0x1
}

// PWR.PDCRB: Power Port B pull-down control register
func (o *PWR_Type) SetPDCRB_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRB_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRB_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRB_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRB_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRB_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRB_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRB_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRB_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRB_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRB_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRB_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRB_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRB_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRB_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRB_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRB_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRB_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRB_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRB_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRB_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRB_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRB_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRB_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRB_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRB_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRB_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRB_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRB_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRB_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRB_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRB_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRB.Reg) & 0x1
}

// PWR.PUCRC: Power Port C pull-up control register
func (o *PWR_Type) SetPUCRC_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRC_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRC_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRC_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRC_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRC_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRC_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRC_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRC_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRC_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRC_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRC_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRC_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRC_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRC_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRC_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRC_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRC_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRC_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRC_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRC_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRC_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRC_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRC_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRC_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRC_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRC_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRC_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRC_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRC_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRC_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRC_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRC.Reg) & 0x1
}

// PWR.PDCRC: Power Port C pull-down control register
func (o *PWR_Type) SetPDCRC_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRC_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRC_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRC_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRC_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRC_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRC_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRC_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRC_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRC_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRC_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRC_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRC_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRC_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRC_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRC_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRC_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRC_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRC_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRC_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRC_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRC_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRC_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRC_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRC_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRC_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRC_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRC_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRC_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRC_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRC_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRC_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRC.Reg) & 0x1
}

// PWR.PUCRD: Power Port D pull-up control register
func (o *PWR_Type) SetPUCRD_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRD_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRD_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRD_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRD_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRD_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRD_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRD_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRD_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRD_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRD_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRD_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRD_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRD_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRD_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRD_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRD_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRD_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRD_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRD_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRD_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRD_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRD_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRD_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRD_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRD_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRD_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRD_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRD_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRD_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRD_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRD_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRD.Reg) & 0x1
}

// PWR.PDCRD: Power Port D pull-down control register
func (o *PWR_Type) SetPDCRD_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRD_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRD_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRD_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRD_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRD_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRD_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRD_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRD_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRD_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRD_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRD_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRD_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRD_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRD_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRD_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRD_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRD_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRD_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRD_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRD_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRD_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRD_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRD_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRD_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRD_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRD_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRD_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRD_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRD_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRD_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRD_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRD.Reg) & 0x1
}

// PWR.PUCRE: Power Port E pull-UP control register
func (o *PWR_Type) SetPUCRE_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRE_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRE_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRE_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRE_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRE_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRE_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRE_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRE_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRE_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRE_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRE_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRE_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRE_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRE_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRE_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRE_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRE_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRE_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRE_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRE_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRE_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRE_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRE_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRE_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRE_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRE_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRE_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRE_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRE_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRE_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRE_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRE.Reg) & 0x1
}

// PWR.PDCRE: Power Port E pull-down control register
func (o *PWR_Type) SetPDCRE_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRE_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRE_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRE_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRE_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRE_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRE_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRE_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRE_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRE_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRE_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRE_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRE_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRE_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRE_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRE_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRE_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRE_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRE_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRE_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRE_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRE_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRE_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRE_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRE_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRE_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRE_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRE_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRE_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRE_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRE_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRE_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRE.Reg) & 0x1
}

// PWR.PUCRF: Power Port F pull-up control register
func (o *PWR_Type) SetPUCRF_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRF_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRF_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRF_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRF_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRF_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRF_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRF_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRF_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRF_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRF_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRF_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRF_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRF_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRF_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRF_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRF_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRF_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRF_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRF_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRF_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRF_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRF_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRF_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRF_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRF_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRF_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRF_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRF.Reg) & 0x1
}

// PWR.PDCRF: Power Port F pull-down control register
func (o *PWR_Type) SetPDCRF_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRF_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRF_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRF_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRF_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRF_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRF_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRF_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRF_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRF_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRF_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRF_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRF_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRF_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRF_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRF_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRF_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRF_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRF_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRF_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRF_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRF_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRF_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRF_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRF_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRF_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRF_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRF_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRF.Reg) & 0x1
}

// Reset and clock control
type RCC_Type struct {
	CR        volatile.Register32 // 0x0
	ICSCR     volatile.Register32 // 0x4
	CFGR      volatile.Register32 // 0x8
	PLLCFGR   volatile.Register32 // 0xC
	_         [4]byte
	CRRCR     volatile.Register32 // 0x14
	CIER      volatile.Register32 // 0x18
	CIFR      volatile.Register32 // 0x1C
	CICR      volatile.Register32 // 0x20
	IOPRSTR   volatile.Register32 // 0x24
	AHBRSTR   volatile.Register32 // 0x28
	APBRSTR1  volatile.Register32 // 0x2C
	APBRSTR2  volatile.Register32 // 0x30
	IOPENR    volatile.Register32 // 0x34
	AHBENR    volatile.Register32 // 0x38
	APBENR1   volatile.Register32 // 0x3C
	APBENR2   volatile.Register32 // 0x40
	IOPSMENR  volatile.Register32 // 0x44
	AHBSMENR  volatile.Register32 // 0x48
	APBSMENR1 volatile.Register32 // 0x4C
	APBSMENR2 volatile.Register32 // 0x50
	CCIPR     volatile.Register32 // 0x54
	CCIPR2    volatile.Register32 // 0x58
	BDCR      volatile.Register32 // 0x5C
	CSR       volatile.Register32 // 0x60
}

// RCC.CR: Clock control register
func (o *RCC_Type) SetCR_HSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCR_HSION() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCR_HSIKERON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCR_HSIKERON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCR_HSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCR_HSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCR_HSIDIV(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3800)|value<<11)
}
func (o *RCC_Type) GetCR_HSIDIV() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3800) >> 11
}
func (o *RCC_Type) SetCR_HSEON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCR_HSEON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCR_HSERDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCR_HSERDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCR_HSEBYP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCR_HSEBYP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCR_CSSON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCR_CSSON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCR_HSI48ON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetCR_HSI48ON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetCR_HSI48RDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCR_HSI48RDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCR_PLLON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCR_PLLON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCR_PLLRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCR_PLLRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}

// RCC.ICSCR: Internal clock sources calibration register
func (o *RCC_Type) SetICSCR_HSICAL(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0xff)|value)
}
func (o *RCC_Type) GetICSCR_HSICAL() uint32 {
	return volatile.LoadUint32(&o.ICSCR.Reg) & 0xff
}
func (o *RCC_Type) SetICSCR_HSITRIM(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0x7f00)|value<<8)
}
func (o *RCC_Type) GetICSCR_HSITRIM() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0x7f00) >> 8
}

// RCC.CFGR: Clock configuration register
func (o *RCC_Type) SetCFGR_MCOPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf0000000)|value<<28)
}
func (o *RCC_Type) GetCFGR_MCOPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf0000000) >> 28
}
func (o *RCC_Type) SetCFGR_MCOSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf000000)|value<<24)
}
func (o *RCC_Type) GetCFGR_MCOSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf000000) >> 24
}
func (o *RCC_Type) SetCFGR_MCO2PRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf00000)|value<<20)
}
func (o *RCC_Type) GetCFGR_MCO2PRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf00000) >> 20
}
func (o *RCC_Type) SetCFGR_MCO2SEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf0000)|value<<16)
}
func (o *RCC_Type) GetCFGR_MCO2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf0000) >> 16
}
func (o *RCC_Type) SetCFGR_PPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7000)|value<<12)
}
func (o *RCC_Type) GetCFGR_PPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7000) >> 12
}
func (o *RCC_Type) SetCFGR_HPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf00)|value<<8)
}
func (o *RCC_Type) GetCFGR_HPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf00) >> 8
}
func (o *RCC_Type) SetCFGR_SWS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x38)|value<<3)
}
func (o *RCC_Type) GetCFGR_SWS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x38) >> 3
}
func (o *RCC_Type) SetCFGR_SW(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7)|value)
}
func (o *RCC_Type) GetCFGR_SW() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x7
}

// RCC.PLLCFGR: PLL configuration register
func (o *RCC_Type) SetPLLCFGR_PLLSRC(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetPLLCFGR_PLLSRC() uint32 {
	return volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x3
}
func (o *RCC_Type) SetPLLCFGR_PLLM(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x70)|value<<4)
}
func (o *RCC_Type) GetPLLCFGR_PLLM() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x70) >> 4
}
func (o *RCC_Type) SetPLLCFGR_PLLN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xff00)|value<<8)
}
func (o *RCC_Type) GetPLLCFGR_PLLN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xff00) >> 8
}
func (o *RCC_Type) SetPLLCFGR_PLLPEN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetPLLCFGR_PLLPEN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetPLLCFGR_PLLP(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x3e0000)|value<<17)
}
func (o *RCC_Type) GetPLLCFGR_PLLP() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x3e0000) >> 17
}
func (o *RCC_Type) SetPLLCFGR_PLLQEN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetPLLCFGR_PLLQEN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetPLLCFGR_PLLQ(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xe000000)|value<<25)
}
func (o *RCC_Type) GetPLLCFGR_PLLQ() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xe000000) >> 25
}
func (o *RCC_Type) SetPLLCFGR_PLLREN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetPLLCFGR_PLLREN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetPLLCFGR_PLLR(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xe0000000)|value<<29)
}
func (o *RCC_Type) GetPLLCFGR_PLLR() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xe0000000) >> 29
}

// RCC.CRRCR: RCC clock recovery RC register
func (o *RCC_Type) SetCRRCR_HSI48CAL(value uint32) {
	volatile.StoreUint32(&o.CRRCR.Reg, volatile.LoadUint32(&o.CRRCR.Reg)&^(0x1ff)|value)
}
func (o *RCC_Type) GetCRRCR_HSI48CAL() uint32 {
	return volatile.LoadUint32(&o.CRRCR.Reg) & 0x1ff
}

// RCC.CIER: Clock interrupt enable register
func (o *RCC_Type) SetCIER_LSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIER_LSIRDYIE() uint32 {
	return volatile.LoadUint32(&o.CIER.Reg) & 0x1
}
func (o *RCC_Type) SetCIER_LSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIER_LSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIER_HSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIER_HSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIER_HSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIER_HSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIER_PLLSYSRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIER_PLLSYSRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x20) >> 5
}

// RCC.CIFR: Clock interrupt flag register
func (o *RCC_Type) SetCIFR_LSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIFR_LSIRDYF() uint32 {
	return volatile.LoadUint32(&o.CIFR.Reg) & 0x1
}
func (o *RCC_Type) SetCIFR_LSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIFR_LSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIFR_HSI48RDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIFR_HSI48RDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIFR_HSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIFR_HSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIFR_HSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIFR_HSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIFR_PLLSYSRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIFR_PLLSYSRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIFR_CSSF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCIFR_CSSF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCIFR_LSECSSF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIFR_LSECSSF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x200) >> 9
}

// RCC.CICR: Clock interrupt clear register
func (o *RCC_Type) SetCICR_LSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCICR_LSIRDYC() uint32 {
	return volatile.LoadUint32(&o.CICR.Reg) & 0x1
}
func (o *RCC_Type) SetCICR_LSERDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCICR_LSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCICR_HSI48RDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCICR_HSI48RDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCICR_HSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCICR_HSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCICR_HSERDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCICR_HSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCICR_PLLSYSRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCICR_PLLSYSRDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCICR_CSSC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCICR_CSSC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCICR_LSECSSC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCICR_LSECSSC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x200) >> 9
}

// RCC.IOPRSTR: I/O port reset register
func (o *RCC_Type) SetIOPRSTR_GPIOARST(value uint32) {
	volatile.StoreUint32(&o.IOPRSTR.Reg, volatile.LoadUint32(&o.IOPRSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetIOPRSTR_GPIOARST() uint32 {
	return volatile.LoadUint32(&o.IOPRSTR.Reg) & 0x1
}
func (o *RCC_Type) SetIOPRSTR_GPIOBRST(value uint32) {
	volatile.StoreUint32(&o.IOPRSTR.Reg, volatile.LoadUint32(&o.IOPRSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetIOPRSTR_GPIOBRST() uint32 {
	return (volatile.LoadUint32(&o.IOPRSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetIOPRSTR_GPIOCRST(value uint32) {
	volatile.StoreUint32(&o.IOPRSTR.Reg, volatile.LoadUint32(&o.IOPRSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetIOPRSTR_GPIOCRST() uint32 {
	return (volatile.LoadUint32(&o.IOPRSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetIOPRSTR_GPIODRST(value uint32) {
	volatile.StoreUint32(&o.IOPRSTR.Reg, volatile.LoadUint32(&o.IOPRSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetIOPRSTR_GPIODRST() uint32 {
	return (volatile.LoadUint32(&o.IOPRSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetIOPRSTR_GPIOERST(value uint32) {
	volatile.StoreUint32(&o.IOPRSTR.Reg, volatile.LoadUint32(&o.IOPRSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetIOPRSTR_GPIOERST() uint32 {
	return (volatile.LoadUint32(&o.IOPRSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetIOPRSTR_GPIOFRST(value uint32) {
	volatile.StoreUint32(&o.IOPRSTR.Reg, volatile.LoadUint32(&o.IOPRSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetIOPRSTR_GPIOFRST() uint32 {
	return (volatile.LoadUint32(&o.IOPRSTR.Reg) & 0x20) >> 5
}

// RCC.AHBRSTR: AHB peripheral reset register
func (o *RCC_Type) SetAHBRSTR_DMA1RST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHBRSTR_DMA1RST() uint32 {
	return volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAHBRSTR_DMA2RST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHBRSTR_DMA2RST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHBRSTR_FLASHRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHBRSTR_FLASHRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHBRSTR_CRCRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHBRSTR_CRCRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHBRSTR_AESRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHBRSTR_AESRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHBRSTR_RNGRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHBRSTR_RNGRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x40000) >> 18
}

// RCC.APBRSTR1: APB peripheral reset register 1
func (o *RCC_Type) SetAPBRSTR1_TIM2RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPBRSTR1_TIM2RST() uint32 {
	return volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x1
}
func (o *RCC_Type) SetAPBRSTR1_TIM3RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPBRSTR1_TIM3RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPBRSTR1_TIM4RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPBRSTR1_TIM4RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPBRSTR1_TIM6RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPBRSTR1_TIM6RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPBRSTR1_TIM7RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPBRSTR1_TIM7RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPBRSTR1_LPUART2RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPBRSTR1_LPUART2RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPBRSTR1_USART5RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPBRSTR1_USART5RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPBRSTR1_USART6RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPBRSTR1_USART6RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPBRSTR1_FDCANRST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPBRSTR1_FDCANRST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPBRSTR1_USBRST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPBRSTR1_USBRST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPBRSTR1_SPI2RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPBRSTR1_SPI2RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPBRSTR1_SPI3RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPBRSTR1_SPI3RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPBRSTR1_CRSRST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPBRSTR1_CRSRST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPBRSTR1_USART2RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPBRSTR1_USART2RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPBRSTR1_USART3RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPBRSTR1_USART3RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPBRSTR1_USART4RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPBRSTR1_USART4RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPBRSTR1_LPUART1RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPBRSTR1_LPUART1RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPBRSTR1_I2C1RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPBRSTR1_I2C1RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPBRSTR1_I2C2RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPBRSTR1_I2C2RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPBRSTR1_I2C3RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPBRSTR1_I2C3RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPBRSTR1_CECRST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPBRSTR1_CECRST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPBRSTR1_UCPD1RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPBRSTR1_UCPD1RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPBRSTR1_UCPD2RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPBRSTR1_UCPD2RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPBRSTR1_DBGRST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAPBRSTR1_DBGRST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAPBRSTR1_PWRRST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPBRSTR1_PWRRST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPBRSTR1_DAC1RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPBRSTR1_DAC1RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPBRSTR1_LPTIM2RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPBRSTR1_LPTIM2RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPBRSTR1_LPTIM1RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR1.Reg, volatile.LoadUint32(&o.APBRSTR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPBRSTR1_LPTIM1RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR1.Reg) & 0x80000000) >> 31
}

// RCC.APBRSTR2: APB peripheral reset register 2
func (o *RCC_Type) SetAPBRSTR2_SYSCFGRST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR2.Reg, volatile.LoadUint32(&o.APBRSTR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPBRSTR2_SYSCFGRST() uint32 {
	return volatile.LoadUint32(&o.APBRSTR2.Reg) & 0x1
}
func (o *RCC_Type) SetAPBRSTR2_TIM1RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR2.Reg, volatile.LoadUint32(&o.APBRSTR2.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPBRSTR2_TIM1RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR2.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPBRSTR2_SPI1RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR2.Reg, volatile.LoadUint32(&o.APBRSTR2.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPBRSTR2_SPI1RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR2.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPBRSTR2_USART1RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR2.Reg, volatile.LoadUint32(&o.APBRSTR2.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPBRSTR2_USART1RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR2.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPBRSTR2_TIM14RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR2.Reg, volatile.LoadUint32(&o.APBRSTR2.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPBRSTR2_TIM14RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR2.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPBRSTR2_TIM15RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR2.Reg, volatile.LoadUint32(&o.APBRSTR2.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPBRSTR2_TIM15RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR2.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPBRSTR2_TIM16RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR2.Reg, volatile.LoadUint32(&o.APBRSTR2.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPBRSTR2_TIM16RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR2.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPBRSTR2_TIM17RST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR2.Reg, volatile.LoadUint32(&o.APBRSTR2.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPBRSTR2_TIM17RST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR2.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPBRSTR2_ADCRST(value uint32) {
	volatile.StoreUint32(&o.APBRSTR2.Reg, volatile.LoadUint32(&o.APBRSTR2.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPBRSTR2_ADCRST() uint32 {
	return (volatile.LoadUint32(&o.APBRSTR2.Reg) & 0x100000) >> 20
}

// RCC.IOPENR: GPIO clock enable register
func (o *RCC_Type) SetIOPENR_GPIOAEN(value uint32) {
	volatile.StoreUint32(&o.IOPENR.Reg, volatile.LoadUint32(&o.IOPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetIOPENR_GPIOAEN() uint32 {
	return volatile.LoadUint32(&o.IOPENR.Reg) & 0x1
}
func (o *RCC_Type) SetIOPENR_GPIOBEN(value uint32) {
	volatile.StoreUint32(&o.IOPENR.Reg, volatile.LoadUint32(&o.IOPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetIOPENR_GPIOBEN() uint32 {
	return (volatile.LoadUint32(&o.IOPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetIOPENR_GPIOCEN(value uint32) {
	volatile.StoreUint32(&o.IOPENR.Reg, volatile.LoadUint32(&o.IOPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetIOPENR_GPIOCEN() uint32 {
	return (volatile.LoadUint32(&o.IOPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetIOPENR_GPIODEN(value uint32) {
	volatile.StoreUint32(&o.IOPENR.Reg, volatile.LoadUint32(&o.IOPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetIOPENR_GPIODEN() uint32 {
	return (volatile.LoadUint32(&o.IOPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetIOPENR_GPIOEEN(value uint32) {
	volatile.StoreUint32(&o.IOPENR.Reg, volatile.LoadUint32(&o.IOPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetIOPENR_GPIOEEN() uint32 {
	return (volatile.LoadUint32(&o.IOPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetIOPENR_GPIOFEN(value uint32) {
	volatile.StoreUint32(&o.IOPENR.Reg, volatile.LoadUint32(&o.IOPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetIOPENR_GPIOFEN() uint32 {
	return (volatile.LoadUint32(&o.IOPENR.Reg) & 0x20) >> 5
}

// RCC.AHBENR: AHB peripheral clock enable register
func (o *RCC_Type) SetAHBENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHBENR_DMA1EN() uint32 {
	return volatile.LoadUint32(&o.AHBENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHBENR_DMA2EN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHBENR_DMA2EN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHBENR_FLASHEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHBENR_FLASHEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHBENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHBENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHBENR_AESEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHBENR_AESEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHBENR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHBENR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x40000) >> 18
}

// RCC.APBENR1: APB peripheral clock enable register 1
func (o *RCC_Type) SetAPBENR1_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPBENR1_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.APBENR1.Reg) & 0x1
}
func (o *RCC_Type) SetAPBENR1_TIM3EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPBENR1_TIM3EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPBENR1_TIM4EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPBENR1_TIM4EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPBENR1_TIM6EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPBENR1_TIM6EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPBENR1_TIM7EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPBENR1_TIM7EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPBENR1_LPUART2EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPBENR1_LPUART2EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPBENR1_USART5EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPBENR1_USART5EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPBENR1_USART6EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPBENR1_USART6EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPBENR1_RTCAPBEN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPBENR1_RTCAPBEN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPBENR1_WWDGEN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPBENR1_WWDGEN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPBENR1_FDCANEN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPBENR1_FDCANEN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPBENR1_USBEN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPBENR1_USBEN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPBENR1_SPI2EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPBENR1_SPI2EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPBENR1_SPI3EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPBENR1_SPI3EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPBENR1_CRSEN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPBENR1_CRSEN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPBENR1_USART2EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPBENR1_USART2EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPBENR1_USART3EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPBENR1_USART3EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPBENR1_USART4EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPBENR1_USART4EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPBENR1_LPUART1EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPBENR1_LPUART1EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPBENR1_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPBENR1_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPBENR1_I2C2EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPBENR1_I2C2EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPBENR1_I2C3EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPBENR1_I2C3EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPBENR1_CECEN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPBENR1_CECEN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPBENR1_UCPD1EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPBENR1_UCPD1EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPBENR1_UCPD2EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPBENR1_UCPD2EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPBENR1_DBGEN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAPBENR1_DBGEN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAPBENR1_PWREN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPBENR1_PWREN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPBENR1_DAC1EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPBENR1_DAC1EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPBENR1_LPTIM2EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPBENR1_LPTIM2EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPBENR1_LPTIM1EN(value uint32) {
	volatile.StoreUint32(&o.APBENR1.Reg, volatile.LoadUint32(&o.APBENR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPBENR1_LPTIM1EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR1.Reg) & 0x80000000) >> 31
}

// RCC.APBENR2: APB peripheral clock enable register 2
func (o *RCC_Type) SetAPBENR2_SYSCFGEN(value uint32) {
	volatile.StoreUint32(&o.APBENR2.Reg, volatile.LoadUint32(&o.APBENR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPBENR2_SYSCFGEN() uint32 {
	return volatile.LoadUint32(&o.APBENR2.Reg) & 0x1
}
func (o *RCC_Type) SetAPBENR2_TIM1EN(value uint32) {
	volatile.StoreUint32(&o.APBENR2.Reg, volatile.LoadUint32(&o.APBENR2.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPBENR2_TIM1EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR2.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPBENR2_SPI1EN(value uint32) {
	volatile.StoreUint32(&o.APBENR2.Reg, volatile.LoadUint32(&o.APBENR2.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPBENR2_SPI1EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR2.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPBENR2_USART1EN(value uint32) {
	volatile.StoreUint32(&o.APBENR2.Reg, volatile.LoadUint32(&o.APBENR2.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPBENR2_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR2.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPBENR2_TIM14EN(value uint32) {
	volatile.StoreUint32(&o.APBENR2.Reg, volatile.LoadUint32(&o.APBENR2.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPBENR2_TIM14EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR2.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPBENR2_TIM15EN(value uint32) {
	volatile.StoreUint32(&o.APBENR2.Reg, volatile.LoadUint32(&o.APBENR2.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPBENR2_TIM15EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR2.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPBENR2_TIM16EN(value uint32) {
	volatile.StoreUint32(&o.APBENR2.Reg, volatile.LoadUint32(&o.APBENR2.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPBENR2_TIM16EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR2.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPBENR2_TIM17EN(value uint32) {
	volatile.StoreUint32(&o.APBENR2.Reg, volatile.LoadUint32(&o.APBENR2.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPBENR2_TIM17EN() uint32 {
	return (volatile.LoadUint32(&o.APBENR2.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPBENR2_ADCEN(value uint32) {
	volatile.StoreUint32(&o.APBENR2.Reg, volatile.LoadUint32(&o.APBENR2.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPBENR2_ADCEN() uint32 {
	return (volatile.LoadUint32(&o.APBENR2.Reg) & 0x100000) >> 20
}

// RCC.IOPSMENR: GPIO in Sleep mode clock enable register
func (o *RCC_Type) SetIOPSMENR_GPIOASMEN(value uint32) {
	volatile.StoreUint32(&o.IOPSMENR.Reg, volatile.LoadUint32(&o.IOPSMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetIOPSMENR_GPIOASMEN() uint32 {
	return volatile.LoadUint32(&o.IOPSMENR.Reg) & 0x1
}
func (o *RCC_Type) SetIOPSMENR_GPIOBSMEN(value uint32) {
	volatile.StoreUint32(&o.IOPSMENR.Reg, volatile.LoadUint32(&o.IOPSMENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetIOPSMENR_GPIOBSMEN() uint32 {
	return (volatile.LoadUint32(&o.IOPSMENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetIOPSMENR_GPIOCSMEN(value uint32) {
	volatile.StoreUint32(&o.IOPSMENR.Reg, volatile.LoadUint32(&o.IOPSMENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetIOPSMENR_GPIOCSMEN() uint32 {
	return (volatile.LoadUint32(&o.IOPSMENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetIOPSMENR_GPIODSMEN(value uint32) {
	volatile.StoreUint32(&o.IOPSMENR.Reg, volatile.LoadUint32(&o.IOPSMENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetIOPSMENR_GPIODSMEN() uint32 {
	return (volatile.LoadUint32(&o.IOPSMENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetIOPSMENR_GPIOESMEN(value uint32) {
	volatile.StoreUint32(&o.IOPSMENR.Reg, volatile.LoadUint32(&o.IOPSMENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetIOPSMENR_GPIOESMEN() uint32 {
	return (volatile.LoadUint32(&o.IOPSMENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetIOPSMENR_GPIOFSMEN(value uint32) {
	volatile.StoreUint32(&o.IOPSMENR.Reg, volatile.LoadUint32(&o.IOPSMENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetIOPSMENR_GPIOFSMEN() uint32 {
	return (volatile.LoadUint32(&o.IOPSMENR.Reg) & 0x20) >> 5
}

// RCC.AHBSMENR: AHB peripheral clock enable in Sleep mode register
func (o *RCC_Type) SetAHBSMENR_DMA1SMEN(value uint32) {
	volatile.StoreUint32(&o.AHBSMENR.Reg, volatile.LoadUint32(&o.AHBSMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHBSMENR_DMA1SMEN() uint32 {
	return volatile.LoadUint32(&o.AHBSMENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHBSMENR_DMA2SMEN(value uint32) {
	volatile.StoreUint32(&o.AHBSMENR.Reg, volatile.LoadUint32(&o.AHBSMENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHBSMENR_DMA2SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHBSMENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHBSMENR_FLASHSMEN(value uint32) {
	volatile.StoreUint32(&o.AHBSMENR.Reg, volatile.LoadUint32(&o.AHBSMENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHBSMENR_FLASHSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHBSMENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHBSMENR_SRAMSMEN(value uint32) {
	volatile.StoreUint32(&o.AHBSMENR.Reg, volatile.LoadUint32(&o.AHBSMENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAHBSMENR_SRAMSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHBSMENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAHBSMENR_CRCSMEN(value uint32) {
	volatile.StoreUint32(&o.AHBSMENR.Reg, volatile.LoadUint32(&o.AHBSMENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHBSMENR_CRCSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHBSMENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHBSMENR_AESSMEN(value uint32) {
	volatile.StoreUint32(&o.AHBSMENR.Reg, volatile.LoadUint32(&o.AHBSMENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHBSMENR_AESSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHBSMENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHBSMENR_RNGSMEN(value uint32) {
	volatile.StoreUint32(&o.AHBSMENR.Reg, volatile.LoadUint32(&o.AHBSMENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHBSMENR_RNGSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHBSMENR.Reg) & 0x40000) >> 18
}

// RCC.APBSMENR1: APB peripheral clock enable in Sleep mode register 1
func (o *RCC_Type) SetAPBSMENR1_TIM2SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPBSMENR1_TIM2SMEN() uint32 {
	return volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x1
}
func (o *RCC_Type) SetAPBSMENR1_TIM3SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPBSMENR1_TIM3SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPBSMENR1_TIM4SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPBSMENR1_TIM4SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPBSMENR1_TIM6SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPBSMENR1_TIM6SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPBSMENR1_TIM7SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPBSMENR1_TIM7SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPBSMENR1_LPUART2SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPBSMENR1_LPUART2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPBSMENR1_USART5SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPBSMENR1_USART5SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPBSMENR1_USART6SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPBSMENR1_USART6SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPBSMENR1_RTCAPBSMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPBSMENR1_RTCAPBSMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPBSMENR1_WWDGSMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPBSMENR1_WWDGSMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPBSMENR1_FDCANSMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPBSMENR1_FDCANSMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPBSMENR1_USBSMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPBSMENR1_USBSMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPBSMENR1_SPI2SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPBSMENR1_SPI2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPBSMENR1_SPI3SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPBSMENR1_SPI3SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPBSMENR1_CRSSSMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPBSMENR1_CRSSSMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPBSMENR1_USART2SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPBSMENR1_USART2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPBSMENR1_USART3SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPBSMENR1_USART3SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPBSMENR1_USART4SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPBSMENR1_USART4SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPBSMENR1_LPUART1SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPBSMENR1_LPUART1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPBSMENR1_I2C1SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPBSMENR1_I2C1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPBSMENR1_I2C2SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPBSMENR1_I2C2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPBSMENR1_I2C3SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPBSMENR1_I2C3SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPBSMENR1_CECSMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPBSMENR1_CECSMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPBSMENR1_UCPD1SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPBSMENR1_UCPD1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPBSMENR1_UCPD2SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPBSMENR1_UCPD2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPBSMENR1_DBGSMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAPBSMENR1_DBGSMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAPBSMENR1_PWRSMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPBSMENR1_PWRSMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPBSMENR1_DAC1SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPBSMENR1_DAC1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPBSMENR1_LPTIM2SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPBSMENR1_LPTIM2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPBSMENR1_LPTIM1SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR1.Reg, volatile.LoadUint32(&o.APBSMENR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPBSMENR1_LPTIM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR1.Reg) & 0x80000000) >> 31
}

// RCC.APBSMENR2: APB peripheral clock enable in Sleep mode register 2
func (o *RCC_Type) SetAPBSMENR2_SYSCFGSMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR2.Reg, volatile.LoadUint32(&o.APBSMENR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPBSMENR2_SYSCFGSMEN() uint32 {
	return volatile.LoadUint32(&o.APBSMENR2.Reg) & 0x1
}
func (o *RCC_Type) SetAPBSMENR2_TIM1SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR2.Reg, volatile.LoadUint32(&o.APBSMENR2.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPBSMENR2_TIM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR2.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPBSMENR2_SPI1SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR2.Reg, volatile.LoadUint32(&o.APBSMENR2.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPBSMENR2_SPI1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR2.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPBSMENR2_USART1SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR2.Reg, volatile.LoadUint32(&o.APBSMENR2.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPBSMENR2_USART1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR2.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPBSMENR2_TIM14SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR2.Reg, volatile.LoadUint32(&o.APBSMENR2.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPBSMENR2_TIM14SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR2.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPBSMENR2_TIM15SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR2.Reg, volatile.LoadUint32(&o.APBSMENR2.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPBSMENR2_TIM15SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR2.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPBSMENR2_TIM16SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR2.Reg, volatile.LoadUint32(&o.APBSMENR2.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPBSMENR2_TIM16SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR2.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPBSMENR2_TIM17SMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR2.Reg, volatile.LoadUint32(&o.APBSMENR2.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPBSMENR2_TIM17SMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR2.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPBSMENR2_ADCSMEN(value uint32) {
	volatile.StoreUint32(&o.APBSMENR2.Reg, volatile.LoadUint32(&o.APBSMENR2.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPBSMENR2_ADCSMEN() uint32 {
	return (volatile.LoadUint32(&o.APBSMENR2.Reg) & 0x100000) >> 20
}

// RCC.CCIPR: Peripherals independent clock configuration register
func (o *RCC_Type) SetCCIPR_USART1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCCIPR_USART1SEL() uint32 {
	return volatile.LoadUint32(&o.CCIPR.Reg) & 0x3
}
func (o *RCC_Type) SetCCIPR_USART2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCCIPR_USART2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc) >> 2
}
func (o *RCC_Type) SetCCIPR_USART3SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x30)|value<<4)
}
func (o *RCC_Type) GetCCIPR_USART3SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x30) >> 4
}
func (o *RCC_Type) SetCCIPR_CECSEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetCCIPR_CECSEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetCCIPR_LPUART2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetCCIPR_LPUART2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetCCIPR_LPUART1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc00)|value<<10)
}
func (o *RCC_Type) GetCCIPR_LPUART1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc00) >> 10
}
func (o *RCC_Type) SetCCIPR_I2C1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x3000)|value<<12)
}
func (o *RCC_Type) GetCCIPR_I2C1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x3000) >> 12
}
func (o *RCC_Type) SetCCIPR_I2S2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc000)|value<<14)
}
func (o *RCC_Type) GetCCIPR_I2S2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc000) >> 14
}
func (o *RCC_Type) SetCCIPR_LPTIM1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc0000)|value<<18)
}
func (o *RCC_Type) GetCCIPR_LPTIM1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc0000) >> 18
}
func (o *RCC_Type) SetCCIPR_LPTIM2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x300000)|value<<20)
}
func (o *RCC_Type) GetCCIPR_LPTIM2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x300000) >> 20
}
func (o *RCC_Type) SetCCIPR_TIM1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetCCIPR_TIM1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetCCIPR_TIM15SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCCIPR_TIM15SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCCIPR_RNGSEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc000000)|value<<26)
}
func (o *RCC_Type) GetCCIPR_RNGSEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc000000) >> 26
}
func (o *RCC_Type) SetCCIPR_RNGDIV(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x30000000)|value<<28)
}
func (o *RCC_Type) GetCCIPR_RNGDIV() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x30000000) >> 28
}
func (o *RCC_Type) SetCCIPR_ADCSEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc0000000)|value<<30)
}
func (o *RCC_Type) GetCCIPR_ADCSEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc0000000) >> 30
}

// RCC.CCIPR2: Peripherals independent clock configuration register 2
func (o *RCC_Type) SetCCIPR2_I2S1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR2.Reg, volatile.LoadUint32(&o.CCIPR2.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCCIPR2_I2S1SEL() uint32 {
	return volatile.LoadUint32(&o.CCIPR2.Reg) & 0x3
}
func (o *RCC_Type) SetCCIPR2_I2S2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR2.Reg, volatile.LoadUint32(&o.CCIPR2.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCCIPR2_I2S2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR2.Reg) & 0xc) >> 2
}
func (o *RCC_Type) SetCCIPR2_FDCANSEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR2.Reg, volatile.LoadUint32(&o.CCIPR2.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetCCIPR2_FDCANSEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR2.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetCCIPR2_USBSEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR2.Reg, volatile.LoadUint32(&o.CCIPR2.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetCCIPR2_USBSEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR2.Reg) & 0x1000) >> 12
}

// RCC.BDCR: RTC domain control register
func (o *RCC_Type) SetBDCR_LSEON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetBDCR_LSEON() uint32 {
	return volatile.LoadUint32(&o.BDCR.Reg) & 0x1
}
func (o *RCC_Type) SetBDCR_LSERDY(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetBDCR_LSERDY() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetBDCR_LSEBYP(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetBDCR_LSEBYP() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetBDCR_LSEDRV(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x18)|value<<3)
}
func (o *RCC_Type) GetBDCR_LSEDRV() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x18) >> 3
}
func (o *RCC_Type) SetBDCR_LSECSSON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetBDCR_LSECSSON() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetBDCR_LSECSSD(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetBDCR_LSECSSD() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetBDCR_RTCSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetBDCR_RTCSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetBDCR_RTCEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetBDCR_RTCEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetBDCR_BDRST(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetBDCR_BDRST() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetBDCR_LSCOEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetBDCR_LSCOEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetBDCR_LSCOSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetBDCR_LSCOSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2000000) >> 25
}

// RCC.CSR: Control/status register
func (o *RCC_Type) SetCSR_LSION(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCSR_LSION() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *RCC_Type) SetCSR_LSIRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCSR_LSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCSR_RMVF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCSR_RMVF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCSR_OBLRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCSR_OBLRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCSR_PINRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCSR_PINRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCSR_PWRRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCSR_PWRRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCSR_SFTRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCSR_SFTRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetCSR_IWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCSR_IWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCSR_WWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetCSR_WWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetCSR_LPWRRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetCSR_LPWRRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000000) >> 31
}

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// RNG.CR: control register
func (o *RNG_Type) SetCR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetCR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetCR_IE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RNG_Type) GetCR_IE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RNG_Type) SetCR_CED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RNG_Type) GetCR_CED() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}

// RNG.SR: status register
func (o *RNG_Type) SetSR_DRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetSR_DRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *RNG_Type) SetSR_CECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RNG_Type) GetSR_CECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RNG_Type) SetSR_SECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetSR_SECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetSR_CEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *RNG_Type) GetSR_CEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *RNG_Type) SetSR_SEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *RNG_Type) GetSR_SEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}

// RNG.DR: data register
func (o *RNG_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *RNG_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	SSR      volatile.Register32 // 0x8
	ICSR     volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	CR       volatile.Register32 // 0x18
	_        [8]byte
	WPR      volatile.Register32 // 0x24
	CALR     volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBR   volatile.Register32 // 0x48
	ALRMBSSR volatile.Register32 // 0x4C
	SR       volatile.Register32 // 0x50
	MISR     volatile.Register32 // 0x54
	_        [4]byte
	SCR      volatile.Register32 // 0x5C
}

// RTC.TR: RTC time register
func (o *RTC_Type) SetTR_SU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTR_SU() uint32 {
	return volatile.LoadUint32(&o.TR.Reg) & 0xf
}
func (o *RTC_Type) SetTR_ST(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTR_HU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTR_HT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTR_PM(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x400000) >> 22
}

// RTC.DR: RTC date register
func (o *RTC_Type) SetDR_DU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetDR_DU() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xf
}
func (o *RTC_Type) SetDR_DT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetDR_DT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetDR_MU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetDR_MU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetDR_MT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetDR_MT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetDR_WDU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetDR_YU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetDR_YU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetDR_YT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00000)|value<<20)
}
func (o *RTC_Type) GetDR_YT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00000) >> 20
}

// RTC.SSR: RTC sub second register
func (o *RTC_Type) SetSSR_SS(value uint32) {
	volatile.StoreUint32(&o.SSR.Reg, volatile.LoadUint32(&o.SSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetSSR_SS() uint32 {
	return volatile.LoadUint32(&o.SSR.Reg) & 0xffff
}

// RTC.ICSR: RTC initialization control and status register
func (o *RTC_Type) SetICSR_ALRAWF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetICSR_ALRAWF() uint32 {
	return volatile.LoadUint32(&o.ICSR.Reg) & 0x1
}
func (o *RTC_Type) SetICSR_ALRBWF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetICSR_ALRBWF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetICSR_WUTWF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetICSR_WUTWF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetICSR_SHPF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetICSR_SHPF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetICSR_INITS(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetICSR_INITS() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetICSR_RSF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetICSR_RSF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetICSR_INITF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetICSR_INITF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetICSR_INIT(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetICSR_INIT() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetICSR_RECALPF(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetICSR_RECALPF() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x10000) >> 16
}

// RTC.PRER: RTC prescaler register
func (o *RTC_Type) SetPRER_PREDIV_S(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetPRER_PREDIV_S() uint32 {
	return volatile.LoadUint32(&o.PRER.Reg) & 0x7fff
}
func (o *RTC_Type) SetPRER_PREDIV_A(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7f0000)|value<<16)
}
func (o *RTC_Type) GetPRER_PREDIV_A() uint32 {
	return (volatile.LoadUint32(&o.PRER.Reg) & 0x7f0000) >> 16
}

// RTC.WUTR: RTC wakeup timer register
func (o *RTC_Type) SetWUTR_WUT(value uint32) {
	volatile.StoreUint32(&o.WUTR.Reg, volatile.LoadUint32(&o.WUTR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetWUTR_WUT() uint32 {
	return volatile.LoadUint32(&o.WUTR.Reg) & 0xffff
}

// RTC.CR: RTC control register
func (o *RTC_Type) SetCR_WUCKSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetCR_WUCKSEL() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7
}
func (o *RTC_Type) SetCR_TSEDGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_TSEDGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_REFCKON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_REFCKON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_BYPSHAD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCR_BYPSHAD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCR_FMT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCR_FMT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCR_ALRAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_ALRAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_ALRBE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_ALRBE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_WUTE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_WUTE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_TSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_TSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_ALRAIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_ALRAIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_ALRBIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_ALRBIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCR_WUTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCR_WUTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCR_TSIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCR_TSIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCR_ADD1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetCR_ADD1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetCR_SUB1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetCR_SUB1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetCR_BKP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetCR_BKP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetCR_COSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetCR_COSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetCR_POL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetCR_POL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetCR_OSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *RTC_Type) GetCR_OSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *RTC_Type) SetCR_COE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetCR_COE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetCR_ITSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_Type) GetCR_ITSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RTC_Type) SetCR_TAMPTS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_Type) GetCR_TAMPTS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *RTC_Type) SetCR_TAMPOE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_Type) GetCR_TAMPOE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *RTC_Type) SetCR_TAMPALRM_PU(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_Type) GetCR_TAMPALRM_PU() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *RTC_Type) SetCR_TAMPALRM_TYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetCR_TAMPALRM_TYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetCR_OUT2EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetCR_OUT2EN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// RTC.WPR: RTC write protection register
func (o *RTC_Type) SetWPR_KEY(value uint32) {
	volatile.StoreUint32(&o.WPR.Reg, volatile.LoadUint32(&o.WPR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetWPR_KEY() uint32 {
	return volatile.LoadUint32(&o.WPR.Reg) & 0xff
}

// RTC.CALR: RTC calibration register
func (o *RTC_Type) SetCALR_CALM(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetCALR_CALM() uint32 {
	return volatile.LoadUint32(&o.CALR.Reg) & 0x1ff
}
func (o *RTC_Type) SetCALR_CALW16(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCALR_CALW16() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCALR_CALW8(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCALR_CALW8() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCALR_CALP(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCALR_CALP() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x8000) >> 15
}

// RTC.SHIFTR: RTC shift control register
func (o *RTC_Type) SetSHIFTR_SUBFS(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetSHIFTR_SUBFS() uint32 {
	return volatile.LoadUint32(&o.SHIFTR.Reg) & 0x7fff
}
func (o *RTC_Type) SetSHIFTR_ADD1S(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSHIFTR_ADD1S() uint32 {
	return (volatile.LoadUint32(&o.SHIFTR.Reg) & 0x80000000) >> 31
}

// RTC.TSTR: RTC timestamp time register
func (o *RTC_Type) SetTSTR_SU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSTR_SU() uint32 {
	return volatile.LoadUint32(&o.TSTR.Reg) & 0xf
}
func (o *RTC_Type) SetTSTR_ST(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTSTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTSTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTSTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTSTR_HU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTSTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTSTR_HT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTSTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTSTR_PM(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTSTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x400000) >> 22
}

// RTC.TSDR: RTC timestamp date register
func (o *RTC_Type) SetTSDR_DU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSDR_DU() uint32 {
	return volatile.LoadUint32(&o.TSDR.Reg) & 0xf
}
func (o *RTC_Type) SetTSDR_DT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetTSDR_DT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetTSDR_MU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSDR_MU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSDR_MT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetTSDR_MT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetTSDR_WDU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetTSDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xe000) >> 13
}

// RTC.TSSSR: RTC timestamp sub second register
func (o *RTC_Type) SetTSSSR_SS(value uint32) {
	volatile.StoreUint32(&o.TSSSR.Reg, volatile.LoadUint32(&o.TSSSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetTSSSR_SS() uint32 {
	return volatile.LoadUint32(&o.TSSSR.Reg) & 0xffff
}

// RTC.ALRMAR: RTC alarm A register
func (o *RTC_Type) SetALRMAR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMAR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf
}
func (o *RTC_Type) SetALRMAR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMAR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMAR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMAR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMAR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMAR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMAR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMAR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMAR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMAR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMAR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMAR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMAR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMAR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMAR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMAR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMAR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMAR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMAR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMAR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMAR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMAR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMAR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMAR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMAR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMAR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80000000) >> 31
}

// RTC.ALRMASSR: RTC alarm A sub second register
func (o *RTC_Type) SetALRMASSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMASSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMASSR.Reg) & 0x7fff
}
func (o *RTC_Type) SetALRMASSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMASSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMASSR.Reg) & 0xf000000) >> 24
}

// RTC.ALRMBR: RTC alarm B register
func (o *RTC_Type) SetALRMBR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMBR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf
}
func (o *RTC_Type) SetALRMBR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMBR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMBR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMBR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMBR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMBR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMBR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMBR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMBR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMBR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMBR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMBR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMBR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMBR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMBR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMBR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMBR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMBR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMBR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMBR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMBR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMBR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMBR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMBR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80000000) >> 31
}

// RTC.ALRMBSSR: RTC alarm B sub second register
func (o *RTC_Type) SetALRMBSSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMBSSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0x7fff
}
func (o *RTC_Type) SetALRMBSSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBSSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0xf000000) >> 24
}

// RTC.SR: RTC status register
func (o *RTC_Type) SetSR_ALRAF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetSR_ALRAF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *RTC_Type) SetSR_ALRBF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetSR_ALRBF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetSR_WUTF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetSR_WUTF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetSR_TSF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetSR_TSF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetSR_TSOVF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetSR_TSOVF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetSR_ITSF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetSR_ITSF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}

// RTC.MISR: RTC masked interrupt status register
func (o *RTC_Type) SetMISR_ALRAMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetMISR_ALRAMF() uint32 {
	return volatile.LoadUint32(&o.MISR.Reg) & 0x1
}
func (o *RTC_Type) SetMISR_ALRBMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetMISR_ALRBMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetMISR_WUTMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetMISR_WUTMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetMISR_TSMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetMISR_TSMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetMISR_TSOVMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetMISR_TSOVMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetMISR_ITSMF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetMISR_ITSMF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x20) >> 5
}

// RTC.SCR: RTC status clear register
func (o *RTC_Type) SetSCR_CALRAF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetSCR_CALRAF() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}
func (o *RTC_Type) SetSCR_CALRBF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetSCR_CALRBF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetSCR_CWUTF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetSCR_CWUTF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetSCR_CTSF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetSCR_CTSF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetSCR_CTSOVF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetSCR_CTSOVF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetSCR_CITSF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetSCR_CITSF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x20) >> 5
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register16 // 0x0
	_       [2]byte
	CR2     volatile.Register16 // 0x4
	_       [2]byte
	SR      volatile.Register16 // 0x8
	_       [2]byte
	DR      volatile.Register16 // 0xC
	_       [2]byte
	CRCPR   volatile.Register16 // 0x10
	_       [2]byte
	RXCRCR  volatile.Register16 // 0x14
	_       [2]byte
	TXCRCR  volatile.Register16 // 0x18
	_       [2]byte
	I2SCFGR volatile.Register16 // 0x1C
	_       [2]byte
	I2SPR   volatile.Register16 // 0x20
}

// SPI.CR1: SPI control register 1
func (o *SPI_Type) SetCR1_CPHA(value uint16) {
	volatile.StoreUint16(&o.CR1.Reg, volatile.LoadUint16(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR1_CPHA() uint16 {
	return volatile.LoadUint16(&o.CR1.Reg) & 0x1
}
func (o *SPI_Type) SetCR1_CPOL(value uint16) {
	volatile.StoreUint16(&o.CR1.Reg, volatile.LoadUint16(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR1_CPOL() uint16 {
	return (volatile.LoadUint16(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR1_MSTR(value uint16) {
	volatile.StoreUint16(&o.CR1.Reg, volatile.LoadUint16(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR1_MSTR() uint16 {
	return (volatile.LoadUint16(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR1_BR(value uint16) {
	volatile.StoreUint16(&o.CR1.Reg, volatile.LoadUint16(&o.CR1.Reg)&^(0x38)|value<<3)
}
func (o *SPI_Type) GetCR1_BR() uint16 {
	return (volatile.LoadUint16(&o.CR1.Reg) & 0x38) >> 3
}
func (o *SPI_Type) SetCR1_SPE(value uint16) {
	volatile.StoreUint16(&o.CR1.Reg, volatile.LoadUint16(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR1_SPE() uint16 {
	return (volatile.LoadUint16(&o.CR1.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR1_LSBFIRST(value uint16) {
	volatile.StoreUint16(&o.CR1.Reg, volatile.LoadUint16(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR1_LSBFIRST() uint16 {
	return (volatile.LoadUint16(&o.CR1.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR1_SSI(value uint16) {
	volatile.StoreUint16(&o.CR1.Reg, volatile.LoadUint16(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetCR1_SSI() uint16 {
	return (volatile.LoadUint16(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetCR1_SSM(value uint16) {
	volatile.StoreUint16(&o.CR1.Reg, volatile.LoadUint16(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetCR1_SSM() uint16 {
	return (volatile.LoadUint16(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetCR1_RXONLY(value uint16) {
	volatile.StoreUint16(&o.CR1.Reg, volatile.LoadUint16(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetCR1_RXONLY() uint16 {
	return (volatile.LoadUint16(&o.CR1.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetCR1_CRCL(value uint16) {
	volatile.StoreUint16(&o.CR1.Reg, volatile.LoadUint16(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetCR1_CRCL() uint16 {
	return (volatile.LoadUint16(&o.CR1.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetCR1_CRCNEXT(value uint16) {
	volatile.StoreUint16(&o.CR1.Reg, volatile.LoadUint16(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR1_CRCNEXT() uint16 {
	return (volatile.LoadUint16(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR1_CRCEN(value uint16) {
	volatile.StoreUint16(&o.CR1.Reg, volatile.LoadUint16(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR1_CRCEN() uint16 {
	return (volatile.LoadUint16(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR1_BIDIOE(value uint16) {
	volatile.StoreUint16(&o.CR1.Reg, volatile.LoadUint16(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR1_BIDIOE() uint16 {
	return (volatile.LoadUint16(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetCR1_BIDIMODE(value uint16) {
	volatile.StoreUint16(&o.CR1.Reg, volatile.LoadUint16(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetCR1_BIDIMODE() uint16 {
	return (volatile.LoadUint16(&o.CR1.Reg) & 0x8000) >> 15
}

// SPI.CR2: SPI control register 2
func (o *SPI_Type) SetCR2_RXDMAEN(value uint16) {
	volatile.StoreUint16(&o.CR2.Reg, volatile.LoadUint16(&o.CR2.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR2_RXDMAEN() uint16 {
	return volatile.LoadUint16(&o.CR2.Reg) & 0x1
}
func (o *SPI_Type) SetCR2_TXDMAEN(value uint16) {
	volatile.StoreUint16(&o.CR2.Reg, volatile.LoadUint16(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR2_TXDMAEN() uint16 {
	return (volatile.LoadUint16(&o.CR2.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR2_SSOE(value uint16) {
	volatile.StoreUint16(&o.CR2.Reg, volatile.LoadUint16(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR2_SSOE() uint16 {
	return (volatile.LoadUint16(&o.CR2.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR2_NSSP(value uint16) {
	volatile.StoreUint16(&o.CR2.Reg, volatile.LoadUint16(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCR2_NSSP() uint16 {
	return (volatile.LoadUint16(&o.CR2.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCR2_FRF(value uint16) {
	volatile.StoreUint16(&o.CR2.Reg, volatile.LoadUint16(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetCR2_FRF() uint16 {
	return (volatile.LoadUint16(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetCR2_ERRIE(value uint16) {
	volatile.StoreUint16(&o.CR2.Reg, volatile.LoadUint16(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetCR2_ERRIE() uint16 {
	return (volatile.LoadUint16(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetCR2_RXNEIE(value uint16) {
	volatile.StoreUint16(&o.CR2.Reg, volatile.LoadUint16(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR2_RXNEIE() uint16 {
	return (volatile.LoadUint16(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR2_TXEIE(value uint16) {
	volatile.StoreUint16(&o.CR2.Reg, volatile.LoadUint16(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR2_TXEIE() uint16 {
	return (volatile.LoadUint16(&o.CR2.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR2_DS(value uint16) {
	volatile.StoreUint16(&o.CR2.Reg, volatile.LoadUint16(&o.CR2.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetCR2_DS() uint16 {
	return (volatile.LoadUint16(&o.CR2.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetCR2_FRXTH(value uint16) {
	volatile.StoreUint16(&o.CR2.Reg, volatile.LoadUint16(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR2_FRXTH() uint16 {
	return (volatile.LoadUint16(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR2_LDMA_RX(value uint16) {
	volatile.StoreUint16(&o.CR2.Reg, volatile.LoadUint16(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR2_LDMA_RX() uint16 {
	return (volatile.LoadUint16(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR2_LDMA_TX(value uint16) {
	volatile.StoreUint16(&o.CR2.Reg, volatile.LoadUint16(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR2_LDMA_TX() uint16 {
	return (volatile.LoadUint16(&o.CR2.Reg) & 0x4000) >> 14
}

// SPI.SR: SPI status register
func (o *SPI_Type) SetSR_RXNE(value uint16) {
	volatile.StoreUint16(&o.SR.Reg, volatile.LoadUint16(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RXNE() uint16 {
	return volatile.LoadUint16(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_TXE(value uint16) {
	volatile.StoreUint16(&o.SR.Reg, volatile.LoadUint16(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TXE() uint16 {
	return (volatile.LoadUint16(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_CHSIDE(value uint16) {
	volatile.StoreUint16(&o.SR.Reg, volatile.LoadUint16(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_CHSIDE() uint16 {
	return (volatile.LoadUint16(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_UDR(value uint16) {
	volatile.StoreUint16(&o.SR.Reg, volatile.LoadUint16(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_UDR() uint16 {
	return (volatile.LoadUint16(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_CRCERR(value uint16) {
	volatile.StoreUint16(&o.SR.Reg, volatile.LoadUint16(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_CRCERR() uint16 {
	return (volatile.LoadUint16(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_MODF(value uint16) {
	volatile.StoreUint16(&o.SR.Reg, volatile.LoadUint16(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_MODF() uint16 {
	return (volatile.LoadUint16(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_OVR(value uint16) {
	volatile.StoreUint16(&o.SR.Reg, volatile.LoadUint16(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_OVR() uint16 {
	return (volatile.LoadUint16(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_BSY(value uint16) {
	volatile.StoreUint16(&o.SR.Reg, volatile.LoadUint16(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_BSY() uint16 {
	return (volatile.LoadUint16(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_FRE(value uint16) {
	volatile.StoreUint16(&o.SR.Reg, volatile.LoadUint16(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_FRE() uint16 {
	return (volatile.LoadUint16(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_FRLVL(value uint16) {
	volatile.StoreUint16(&o.SR.Reg, volatile.LoadUint16(&o.SR.Reg)&^(0x600)|value<<9)
}
func (o *SPI_Type) GetSR_FRLVL() uint16 {
	return (volatile.LoadUint16(&o.SR.Reg) & 0x600) >> 9
}
func (o *SPI_Type) SetSR_FTLVL(value uint16) {
	volatile.StoreUint16(&o.SR.Reg, volatile.LoadUint16(&o.SR.Reg)&^(0x1800)|value<<11)
}
func (o *SPI_Type) GetSR_FTLVL() uint16 {
	return (volatile.LoadUint16(&o.SR.Reg) & 0x1800) >> 11
}

// SPI.DR: SPI data register
func (o *SPI_Type) SetDR(value uint16) {
	volatile.StoreUint16(&o.DR.Reg, value)
}
func (o *SPI_Type) GetDR() uint16 {
	return volatile.LoadUint16(&o.DR.Reg)
}

// SPI.CRCPR: SPI CRC polynomial register
func (o *SPI_Type) SetCRCPR(value uint16) {
	volatile.StoreUint16(&o.CRCPR.Reg, value)
}
func (o *SPI_Type) GetCRCPR() uint16 {
	return volatile.LoadUint16(&o.CRCPR.Reg)
}

// SPI.RXCRCR: SPI Rx CRC register
func (o *SPI_Type) SetRXCRCR(value uint16) {
	volatile.StoreUint16(&o.RXCRCR.Reg, value)
}
func (o *SPI_Type) GetRXCRCR() uint16 {
	return volatile.LoadUint16(&o.RXCRCR.Reg)
}

// SPI.TXCRCR: SPI Tx CRC register
func (o *SPI_Type) SetTXCRCR(value uint16) {
	volatile.StoreUint16(&o.TXCRCR.Reg, value)
}
func (o *SPI_Type) GetTXCRCR() uint16 {
	return volatile.LoadUint16(&o.TXCRCR.Reg)
}

// SPI.I2SCFGR: SPI_I2S configuration register
func (o *SPI_Type) SetI2SCFGR_CHLEN(value uint16) {
	volatile.StoreUint16(&o.I2SCFGR.Reg, volatile.LoadUint16(&o.I2SCFGR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetI2SCFGR_CHLEN() uint16 {
	return volatile.LoadUint16(&o.I2SCFGR.Reg) & 0x1
}
func (o *SPI_Type) SetI2SCFGR_DATLEN(value uint16) {
	volatile.StoreUint16(&o.I2SCFGR.Reg, volatile.LoadUint16(&o.I2SCFGR.Reg)&^(0x6)|value<<1)
}
func (o *SPI_Type) GetI2SCFGR_DATLEN() uint16 {
	return (volatile.LoadUint16(&o.I2SCFGR.Reg) & 0x6) >> 1
}
func (o *SPI_Type) SetI2SCFGR_CKPOL(value uint16) {
	volatile.StoreUint16(&o.I2SCFGR.Reg, volatile.LoadUint16(&o.I2SCFGR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetI2SCFGR_CKPOL() uint16 {
	return (volatile.LoadUint16(&o.I2SCFGR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetI2SCFGR_I2SSTD(value uint16) {
	volatile.StoreUint16(&o.I2SCFGR.Reg, volatile.LoadUint16(&o.I2SCFGR.Reg)&^(0x30)|value<<4)
}
func (o *SPI_Type) GetI2SCFGR_I2SSTD() uint16 {
	return (volatile.LoadUint16(&o.I2SCFGR.Reg) & 0x30) >> 4
}
func (o *SPI_Type) SetI2SCFGR_PCMSYNC(value uint16) {
	volatile.StoreUint16(&o.I2SCFGR.Reg, volatile.LoadUint16(&o.I2SCFGR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetI2SCFGR_PCMSYNC() uint16 {
	return (volatile.LoadUint16(&o.I2SCFGR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetI2SCFGR_I2SCFG(value uint16) {
	volatile.StoreUint16(&o.I2SCFGR.Reg, volatile.LoadUint16(&o.I2SCFGR.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetI2SCFGR_I2SCFG() uint16 {
	return (volatile.LoadUint16(&o.I2SCFGR.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetI2SCFGR_I2SE(value uint16) {
	volatile.StoreUint16(&o.I2SCFGR.Reg, volatile.LoadUint16(&o.I2SCFGR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetI2SCFGR_I2SE() uint16 {
	return (volatile.LoadUint16(&o.I2SCFGR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetI2SCFGR_I2SMOD(value uint16) {
	volatile.StoreUint16(&o.I2SCFGR.Reg, volatile.LoadUint16(&o.I2SCFGR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetI2SCFGR_I2SMOD() uint16 {
	return (volatile.LoadUint16(&o.I2SCFGR.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetI2SCFGR_ASTRTEN(value uint16) {
	volatile.StoreUint16(&o.I2SCFGR.Reg, volatile.LoadUint16(&o.I2SCFGR.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetI2SCFGR_ASTRTEN() uint16 {
	return (volatile.LoadUint16(&o.I2SCFGR.Reg) & 0x1000) >> 12
}

// SPI.I2SPR: SPI_I2S prescaler register
func (o *SPI_Type) SetI2SPR_I2SDIV(value uint16) {
	volatile.StoreUint16(&o.I2SPR.Reg, volatile.LoadUint16(&o.I2SPR.Reg)&^(0xff)|value)
}
func (o *SPI_Type) GetI2SPR_I2SDIV() uint16 {
	return volatile.LoadUint16(&o.I2SPR.Reg) & 0xff
}
func (o *SPI_Type) SetI2SPR_ODD(value uint16) {
	volatile.StoreUint16(&o.I2SPR.Reg, volatile.LoadUint16(&o.I2SPR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetI2SPR_ODD() uint16 {
	return (volatile.LoadUint16(&o.I2SPR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetI2SPR_MCKOE(value uint16) {
	volatile.StoreUint16(&o.I2SPR.Reg, volatile.LoadUint16(&o.I2SPR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetI2SPR_MCKOE() uint16 {
	return (volatile.LoadUint16(&o.I2SPR.Reg) & 0x200) >> 9
}

// Tamper and backup registers
type TAMP_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	_     [4]byte
	FLTCR volatile.Register32 // 0xC
	_     [28]byte
	IER   volatile.Register32 // 0x2C
	SR    volatile.Register32 // 0x30
	MISR  volatile.Register32 // 0x34
	_     [4]byte
	SCR   volatile.Register32 // 0x3C
	_     [192]byte
	BKP0R volatile.Register32 // 0x100
	BKP1R volatile.Register32 // 0x104
	BKP2R volatile.Register32 // 0x108
	BKP3R volatile.Register32 // 0x10C
	BKP4R volatile.Register32 // 0x110
}

// TAMP.CR1: TAMP control register 1
func (o *TAMP_Type) SetCR1_TAMP1E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetCR1_TAMP1E() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *TAMP_Type) SetCR1_TAMP2E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetCR1_TAMP2E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetCR1_ITAMP3E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetCR1_ITAMP3E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetCR1_ITAMP4E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *TAMP_Type) GetCR1_ITAMP4E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *TAMP_Type) SetCR1_ITAMP5E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetCR1_ITAMP5E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetCR1_ITAMP6E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *TAMP_Type) GetCR1_ITAMP6E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}

// TAMP.CR2: TAMP control register 2
func (o *TAMP_Type) SetCR2_TAMP1NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetCR2_TAMP1NOER() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *TAMP_Type) SetCR2_TAMP2NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetCR2_TAMP2NOER() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetCR2_TAMP1MSK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *TAMP_Type) GetCR2_TAMP1MSK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *TAMP_Type) SetCR2_TAMP2MSK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *TAMP_Type) GetCR2_TAMP2MSK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *TAMP_Type) SetCR2_TAMP1TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *TAMP_Type) GetCR2_TAMP1TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *TAMP_Type) SetCR2_TAMP2TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *TAMP_Type) GetCR2_TAMP2TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}

// TAMP.FLTCR: TAMP filter control register
func (o *TAMP_Type) SetFLTCR_TAMPFREQ(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x7)|value)
}
func (o *TAMP_Type) GetFLTCR_TAMPFREQ() uint32 {
	return volatile.LoadUint32(&o.FLTCR.Reg) & 0x7
}
func (o *TAMP_Type) SetFLTCR_TAMPFLT(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x18)|value<<3)
}
func (o *TAMP_Type) GetFLTCR_TAMPFLT() uint32 {
	return (volatile.LoadUint32(&o.FLTCR.Reg) & 0x18) >> 3
}
func (o *TAMP_Type) SetFLTCR_TAMPPRCH(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x60)|value<<5)
}
func (o *TAMP_Type) GetFLTCR_TAMPPRCH() uint32 {
	return (volatile.LoadUint32(&o.FLTCR.Reg) & 0x60) >> 5
}
func (o *TAMP_Type) SetFLTCR_TAMPPUDIS(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x80)|value<<7)
}
func (o *TAMP_Type) GetFLTCR_TAMPPUDIS() uint32 {
	return (volatile.LoadUint32(&o.FLTCR.Reg) & 0x80) >> 7
}

// TAMP.IER: TAMP interrupt enable register
func (o *TAMP_Type) SetIER_TAMP1IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetIER_TAMP1IE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TAMP_Type) SetIER_TAMP2IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetIER_TAMP2IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetIER_ITAMP3IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetIER_ITAMP3IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetIER_ITAMP4IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *TAMP_Type) GetIER_ITAMP4IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *TAMP_Type) SetIER_ITAMP5IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetIER_ITAMP5IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetIER_ITAMP6IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *TAMP_Type) GetIER_ITAMP6IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}

// TAMP.SR: TAMP status register
func (o *TAMP_Type) SetSR_TAMP1F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetSR_TAMP1F() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TAMP_Type) SetSR_TAMP2F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetSR_TAMP2F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetSR_ITAMP3F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetSR_ITAMP3F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetSR_ITAMP4F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *TAMP_Type) GetSR_ITAMP4F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *TAMP_Type) SetSR_ITAMP5F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetSR_ITAMP5F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetSR_ITAMP6F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *TAMP_Type) GetSR_ITAMP6F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}

// TAMP.MISR: TAMP masked interrupt status register
func (o *TAMP_Type) SetMISR_TAMP1MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetMISR_TAMP1MF() uint32 {
	return volatile.LoadUint32(&o.MISR.Reg) & 0x1
}
func (o *TAMP_Type) SetMISR_TAMP2MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetMISR_TAMP2MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetMISR_ITAMP3MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetMISR_ITAMP3MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetMISR_ITAMP4MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x80000)|value<<19)
}
func (o *TAMP_Type) GetMISR_ITAMP4MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x80000) >> 19
}
func (o *TAMP_Type) SetMISR_ITAMP5MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetMISR_ITAMP5MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetMISR_ITAMP6MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x200000)|value<<21)
}
func (o *TAMP_Type) GetMISR_ITAMP6MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x200000) >> 21
}

// TAMP.SCR: TAMP status clear register
func (o *TAMP_Type) SetSCR_CTAMP1F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetSCR_CTAMP1F() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}
func (o *TAMP_Type) SetSCR_CTAMP2F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetSCR_CTAMP2F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetSCR_CITAMP3F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetSCR_CITAMP3F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetSCR_CITAMP4F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x80000)|value<<19)
}
func (o *TAMP_Type) GetSCR_CITAMP4F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x80000) >> 19
}
func (o *TAMP_Type) SetSCR_CITAMP5F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetSCR_CITAMP5F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetSCR_CITAMP6F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x200000)|value<<21)
}
func (o *TAMP_Type) GetSCR_CITAMP6F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x200000) >> 21
}

// TAMP.BKP0R: TAMP backup 0 register
func (o *TAMP_Type) SetBKP0R(value uint32) {
	volatile.StoreUint32(&o.BKP0R.Reg, value)
}
func (o *TAMP_Type) GetBKP0R() uint32 {
	return volatile.LoadUint32(&o.BKP0R.Reg)
}

// TAMP.BKP1R: TAMP backup 1 register
func (o *TAMP_Type) SetBKP1R(value uint32) {
	volatile.StoreUint32(&o.BKP1R.Reg, value)
}
func (o *TAMP_Type) GetBKP1R() uint32 {
	return volatile.LoadUint32(&o.BKP1R.Reg)
}

// TAMP.BKP2R: TAMP backup 2 register
func (o *TAMP_Type) SetBKP2R(value uint32) {
	volatile.StoreUint32(&o.BKP2R.Reg, value)
}
func (o *TAMP_Type) GetBKP2R() uint32 {
	return volatile.LoadUint32(&o.BKP2R.Reg)
}

// TAMP.BKP3R: TAMP backup 3 register
func (o *TAMP_Type) SetBKP3R(value uint32) {
	volatile.StoreUint32(&o.BKP3R.Reg, value)
}
func (o *TAMP_Type) GetBKP3R() uint32 {
	return volatile.LoadUint32(&o.BKP3R.Reg)
}

// TAMP.BKP4R: TAMP backup 4 register
func (o *TAMP_Type) SetBKP4R(value uint32) {
	volatile.StoreUint32(&o.BKP4R.Reg, value)
}
func (o *TAMP_Type) GetBKP4R() uint32 {
	return volatile.LoadUint32(&o.BKP4R.Reg)
}

// Advanced-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	OR1          volatile.Register32 // 0x50
	CCMR3_Output volatile.Register32 // 0x54
	CCR5         volatile.Register32 // 0x58
	CCR6         volatile.Register32 // 0x5C
	AF1          volatile.Register32 // 0x60
	AF2          volatile.Register32 // 0x64
	TISEL        volatile.Register32 // 0x68
}

// TIM.CR1: control register 1
func (o *TIM_Type) SetCR1_CEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR1_CEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *TIM_Type) SetCR1_UDIS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCR1_UDIS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCR1_URS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR1_URS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR1_OPM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR1_OPM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCR1_CMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x60)|value<<5)
}
func (o *TIM_Type) GetCR1_CMS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x60) >> 5
}
func (o *TIM_Type) SetCR1_ARPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR1_ARPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR1_CKD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCR1_CKD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCR1_UIFREMAP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCR1_UIFREMAP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}

// TIM.CR2: control register 2
func (o *TIM_Type) SetCR2_CCPC(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR2_CCPC() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *TIM_Type) SetCR2_CCUS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR2_CCUS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR2_CCDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR2_CCDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR2_MMS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCR2_MMS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCR2_TI1S(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR2_TI1S() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR2_OIS1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCR2_OIS1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCR2_OIS1N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCR2_OIS1N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCR2_OIS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCR2_OIS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCR2_OIS2N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCR2_OIS2N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCR2_OIS3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCR2_OIS3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCR2_OIS3N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCR2_OIS3N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCR2_OIS4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetCR2_OIS4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetCR2_OIS5(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCR2_OIS5() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCR2_OIS6(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *TIM_Type) GetCR2_OIS6() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *TIM_Type) SetCR2_MMS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf00000)|value<<20)
}
func (o *TIM_Type) GetCR2_MMS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf00000) >> 20
}

// TIM.SMCR: slave mode control register
func (o *TIM_Type) SetSMCR_SMS1(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x7)|value)
}
func (o *TIM_Type) GetSMCR_SMS1() uint32 {
	return volatile.LoadUint32(&o.SMCR.Reg) & 0x7
}
func (o *TIM_Type) SetSMCR_OCCS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSMCR_OCCS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSMCR_TS1(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetSMCR_TS1() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetSMCR_MSM(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSMCR_MSM() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSMCR_ETF(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetSMCR_ETF() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0xf00) >> 8
}
func (o *TIM_Type) SetSMCR_ETPS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x3000)|value<<12)
}
func (o *TIM_Type) GetSMCR_ETPS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x3000) >> 12
}
func (o *TIM_Type) SetSMCR_ECE(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetSMCR_ECE() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetSMCR_ETP(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetSMCR_ETP() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetSMCR_SMS2(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetSMCR_SMS2() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetSMCR_TS2(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x300000)|value<<20)
}
func (o *TIM_Type) GetSMCR_TS2() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x300000) >> 20
}

// TIM.DIER: DMA/Interrupt enable register
func (o *TIM_Type) SetDIER_UIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetDIER_UIE() uint32 {
	return volatile.LoadUint32(&o.DIER.Reg) & 0x1
}
func (o *TIM_Type) SetDIER_CC1IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetDIER_CC1IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetDIER_CC2IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetDIER_CC2IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetDIER_CC3IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetDIER_CC3IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetDIER_CC4IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetDIER_CC4IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetDIER_COMIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetDIER_COMIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetDIER_TIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetDIER_TIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetDIER_BIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetDIER_BIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetDIER_UDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetDIER_UDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetDIER_CC1DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetDIER_CC1DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetDIER_CC2DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetDIER_CC2DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetDIER_CC3DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetDIER_CC3DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetDIER_CC4DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetDIER_CC4DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetDIER_COMDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetDIER_COMDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetDIER_TDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetDIER_TDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4000) >> 14
}

// TIM.SR: status register
func (o *TIM_Type) SetSR_UIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetSR_UIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TIM_Type) SetSR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetSR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetSR_CC2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetSR_CC2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetSR_CC3IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSR_CC3IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSR_CC4IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetSR_CC4IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetSR_COMIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetSR_COMIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetSR_TIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetSR_BIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSR_BIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSR_B2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetSR_B2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetSR_CC1OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetSR_CC1OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetSR_CC2OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetSR_CC2OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetSR_CC3OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetSR_CC3OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetSR_CC4OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetSR_CC4OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetSR_SBIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetSR_SBIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetSR_CC5IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetSR_CC5IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetSR_CC6IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *TIM_Type) GetSR_CC6IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// TIM.EGR: event generation register
func (o *TIM_Type) SetEGR_UG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetEGR_UG() uint32 {
	return volatile.LoadUint32(&o.EGR.Reg) & 0x1
}
func (o *TIM_Type) SetEGR_CC1G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetEGR_CC1G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetEGR_CC2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetEGR_CC2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetEGR_CC3G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetEGR_CC3G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetEGR_CC4G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetEGR_CC4G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetEGR_COMG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetEGR_COMG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetEGR_TG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetEGR_TG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetEGR_BG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetEGR_BG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetEGR_B2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetEGR_B2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x100) >> 8
}

// TIM.CCMR1_Output: capture/compare mode register 1 (output mode)
func (o *TIM_Type) SetCCMR1_Output_CC1S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR1_Output_CC1S() uint32 {
	return volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x3
}
func (o *TIM_Type) SetCCMR1_Output_OC1FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR1_Output_OC1FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR1_Output_OC1PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR1_Output_OC1PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR1_Output_OC1M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR1_Output_OC1CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR1_Output_OC1CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR1_Output_CC2S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR1_Output_CC2S() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR1_Output_OC2FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR1_Output_OC2FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR1_Output_OC2PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR1_Output_OC2PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR1_Output_OC2M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR1_Output_OC2CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR1_Output_OC2CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR1_Output_OC1M2(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M2() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR1_Output_OC2M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x1000000) >> 24
}

// TIM.CCMR2_Output: capture/compare mode register 2 (output mode)
func (o *TIM_Type) SetCCMR2_Output_CC3S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR2_Output_CC3S() uint32 {
	return volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x3
}
func (o *TIM_Type) SetCCMR2_Output_OC3FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR2_Output_OC3FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR2_Output_OC3PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR2_Output_OC3PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR2_Output_OC3M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR2_Output_OC3CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR2_Output_OC3CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR2_Output_CC4S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR2_Output_CC4S() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR2_Output_OC4FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR2_Output_OC4FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR2_Output_OC4PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR2_Output_OC4PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR2_Output_OC4M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR2_Output_OC4CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR2_Output_OC4CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR2_Output_OC3M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR2_Output_OC4M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x1000000) >> 24
}

// TIM.CCER: capture/compare enable register
func (o *TIM_Type) SetCCER_CC1E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCCER_CC1E() uint32 {
	return volatile.LoadUint32(&o.CCER.Reg) & 0x1
}
func (o *TIM_Type) SetCCER_CC1P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCCER_CC1P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCCER_CC1NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCER_CC1NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCER_CC1NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCER_CC1NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCER_CC2E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCCER_CC2E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCCER_CC2P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetCCER_CC2P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetCCER_CC2NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetCCER_CC2NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetCCER_CC2NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCER_CC2NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCER_CC3E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCCER_CC3E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCCER_CC3P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCCER_CC3P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCCER_CC3NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCER_CC3NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCER_CC3NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCER_CC3NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCER_CC4E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCCER_CC4E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCCER_CC4P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCCER_CC4P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCCER_CC4NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCER_CC4NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCER_CC5E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCER_CC5E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCER_CC5P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20000)|value<<17)
}
func (o *TIM_Type) GetCCER_CC5P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20000) >> 17
}
func (o *TIM_Type) SetCCER_CC6E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100000)|value<<20)
}
func (o *TIM_Type) GetCCER_CC6E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100000) >> 20
}
func (o *TIM_Type) SetCCER_CC6P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200000)|value<<21)
}
func (o *TIM_Type) GetCCER_CC6P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200000) >> 21
}

// TIM.CNT: counter
func (o *TIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}
func (o *TIM_Type) SetCNT_UIFCPY(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0x80000000)|value<<31)
}
func (o *TIM_Type) GetCNT_UIFCPY() uint32 {
	return (volatile.LoadUint32(&o.CNT.Reg) & 0x80000000) >> 31
}

// TIM.PSC: prescaler
func (o *TIM_Type) SetPSC(value uint32) {
	volatile.StoreUint32(&o.PSC.Reg, volatile.LoadUint32(&o.PSC.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetPSC() uint32 {
	return volatile.LoadUint32(&o.PSC.Reg) & 0xffff
}

// TIM.ARR: auto-reload register
func (o *TIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// TIM.RCR: repetition counter register
func (o *TIM_Type) SetRCR_REP(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetRCR_REP() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// TIM.CCR1: capture/compare register 1
func (o *TIM_Type) SetCCR1(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR1() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0xffff
}

// TIM.CCR2: capture/compare register 2
func (o *TIM_Type) SetCCR2(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR2() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0xffff
}

// TIM.CCR3: capture/compare register 3
func (o *TIM_Type) SetCCR3(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR3() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0xffff
}

// TIM.CCR4: capture/compare register 4
func (o *TIM_Type) SetCCR4(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR4() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0xffff
}

// TIM.BDTR: break and dead-time register
func (o *TIM_Type) SetBDTR_DTG(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetBDTR_DTG() uint32 {
	return volatile.LoadUint32(&o.BDTR.Reg) & 0xff
}
func (o *TIM_Type) SetBDTR_LOCK(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetBDTR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetBDTR_OSSI(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetBDTR_OSSI() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetBDTR_OSSR(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetBDTR_OSSR() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetBDTR_BKE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetBDTR_BKE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetBDTR_BKP(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetBDTR_BKP() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetBDTR_AOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetBDTR_AOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetBDTR_MOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetBDTR_MOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetBDTR_BKF(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xf0000)|value<<16)
}
func (o *TIM_Type) GetBDTR_BKF() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0xf0000) >> 16
}
func (o *TIM_Type) SetBDTR_BK2F(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xf00000)|value<<20)
}
func (o *TIM_Type) GetBDTR_BK2F() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0xf00000) >> 20
}
func (o *TIM_Type) SetBDTR_BK2E(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetBDTR_BK2E() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetBDTR_BK2P(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000000)|value<<25)
}
func (o *TIM_Type) GetBDTR_BK2P() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000000) >> 25
}
func (o *TIM_Type) SetBDTR_BKDSRM(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x4000000)|value<<26)
}
func (o *TIM_Type) GetBDTR_BKDSRM() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x4000000) >> 26
}
func (o *TIM_Type) SetBDTR_BK2DSRM(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x8000000)|value<<27)
}
func (o *TIM_Type) GetBDTR_BK2DSRM() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x8000000) >> 27
}
func (o *TIM_Type) SetBDTR_BKBID(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x10000000)|value<<28)
}
func (o *TIM_Type) GetBDTR_BKBID() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x10000000) >> 28
}
func (o *TIM_Type) SetBDTR_BK2BID(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x20000000)|value<<29)
}
func (o *TIM_Type) GetBDTR_BK2BID() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x20000000) >> 29
}

// TIM.DCR: DMA control register
func (o *TIM_Type) SetDCR_DBA(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f)|value)
}
func (o *TIM_Type) GetDCR_DBA() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1f
}
func (o *TIM_Type) SetDCR_DBL(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f00)|value<<8)
}
func (o *TIM_Type) GetDCR_DBL() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f00) >> 8
}

// TIM.DMAR: DMA address for full transfer
func (o *TIM_Type) SetDMAR(value uint32) {
	volatile.StoreUint32(&o.DMAR.Reg, value)
}
func (o *TIM_Type) GetDMAR() uint32 {
	return volatile.LoadUint32(&o.DMAR.Reg)
}

// TIM.OR1: option register 1
func (o *TIM_Type) SetOR1_OCREF_CLR(value uint32) {
	volatile.StoreUint32(&o.OR1.Reg, volatile.LoadUint32(&o.OR1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetOR1_OCREF_CLR() uint32 {
	return volatile.LoadUint32(&o.OR1.Reg) & 0x1
}

// TIM.CCMR3_Output: capture/compare mode register 2 (output mode)
func (o *TIM_Type) SetCCMR3_Output_OC6M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR3_Output_OC6M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetCCMR3_Output_OC5M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR3_Output_OC5M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR3_Output_OC6CE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR3_Output_OC6CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR3_Output_OC6M(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR3_Output_OC6M() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR3_Output_OC6PE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR3_Output_OC6PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR3_Output_OC6FE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR3_Output_OC6FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR3_Output_OC5CE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR3_Output_OC5CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR3_Output_OC5M(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR3_Output_OC5M() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR3_Output_OC5PE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR3_Output_OC5PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR3_Output_OC5FE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR3_Output_OC5FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x4) >> 2
}

// TIM.CCR5: capture/compare register 4
func (o *TIM_Type) SetCCR5(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR5() uint32 {
	return volatile.LoadUint32(&o.CCR5.Reg) & 0xffff
}
func (o *TIM_Type) SetCCR5_GC5C1(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x20000000)|value<<29)
}
func (o *TIM_Type) GetCCR5_GC5C1() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x20000000) >> 29
}
func (o *TIM_Type) SetCCR5_GC5C2(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x40000000)|value<<30)
}
func (o *TIM_Type) GetCCR5_GC5C2() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x40000000) >> 30
}
func (o *TIM_Type) SetCCR5_GC5C3(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x80000000)|value<<31)
}
func (o *TIM_Type) GetCCR5_GC5C3() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x80000000) >> 31
}

// TIM.CCR6: capture/compare register 4
func (o *TIM_Type) SetCCR6(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR6() uint32 {
	return volatile.LoadUint32(&o.CCR6.Reg) & 0xffff
}

// TIM.AF1: DMA address for full transfer
func (o *TIM_Type) SetAF1_BKINE(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetAF1_BKINE() uint32 {
	return volatile.LoadUint32(&o.AF1.Reg) & 0x1
}
func (o *TIM_Type) SetAF1_BKCMP1E(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetAF1_BKCMP1E() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetAF1_BKCMP2E(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetAF1_BKCMP2E() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetAF1_BKINP(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetAF1_BKINP() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetAF1_BKCMP1P(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetAF1_BKCMP1P() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetAF1_BKCMP2P(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetAF1_BKCMP2P() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetAF1_ETRSEL(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x3c000)|value<<14)
}
func (o *TIM_Type) GetAF1_ETRSEL() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x3c000) >> 14
}

// TIM.AF2: DMA address for full transfer
func (o *TIM_Type) SetAF2_BK2INE(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetAF2_BK2INE() uint32 {
	return volatile.LoadUint32(&o.AF2.Reg) & 0x1
}
func (o *TIM_Type) SetAF2_BK2CMP1E(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetAF2_BK2CMP1E() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetAF2_BK2CMP2E(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetAF2_BK2CMP2E() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetAF2_BK2INP(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetAF2_BK2INP() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetAF2_BK2CMP1P(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetAF2_BK2CMP1P() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetAF2_BK2CMP2P(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetAF2_BK2CMP2P() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x800) >> 11
}

// TIM.TISEL: TIM1 timer input selection register
func (o *TIM_Type) SetTISEL_TI1SEL(value uint32) {
	volatile.StoreUint32(&o.TISEL.Reg, volatile.LoadUint32(&o.TISEL.Reg)&^(0xf)|value)
}
func (o *TIM_Type) GetTISEL_TI1SEL() uint32 {
	return volatile.LoadUint32(&o.TISEL.Reg) & 0xf
}
func (o *TIM_Type) SetTISEL_TI2SEL(value uint32) {
	volatile.StoreUint32(&o.TISEL.Reg, volatile.LoadUint32(&o.TISEL.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetTISEL_TI2SEL() uint32 {
	return (volatile.LoadUint32(&o.TISEL.Reg) & 0xf00) >> 8
}
func (o *TIM_Type) SetTISEL_TI3SEL(value uint32) {
	volatile.StoreUint32(&o.TISEL.Reg, volatile.LoadUint32(&o.TISEL.Reg)&^(0xf0000)|value<<16)
}
func (o *TIM_Type) GetTISEL_TI3SEL() uint32 {
	return (volatile.LoadUint32(&o.TISEL.Reg) & 0xf0000) >> 16
}
func (o *TIM_Type) SetTISEL_TI4SEL(value uint32) {
	volatile.StoreUint32(&o.TISEL.Reg, volatile.LoadUint32(&o.TISEL.Reg)&^(0xf000000)|value<<24)
}
func (o *TIM_Type) GetTISEL_TI4SEL() uint32 {
	return (volatile.LoadUint32(&o.TISEL.Reg) & 0xf000000) >> 24
}

// USB Power Delivery interface
type UCPD_Type struct {
	CFGR1       volatile.Register32 // 0x0
	CFGR2       volatile.Register32 // 0x4
	CFGR3       volatile.Register32 // 0x8
	CR          volatile.Register32 // 0xC
	IMR         volatile.Register32 // 0x10
	SR          volatile.Register32 // 0x14
	ICR         volatile.Register32 // 0x18
	TX_ORDSETR  volatile.Register32 // 0x1C
	TX_PAYSZR   volatile.Register32 // 0x20
	TXDR        volatile.Register32 // 0x24
	RX_ORDSETR  volatile.Register32 // 0x28
	RX_PAYSZR   volatile.Register32 // 0x2C
	RXDR        volatile.Register32 // 0x30
	RX_ORDEXTR1 volatile.Register32 // 0x34
	RX_ORDEXTR2 volatile.Register32 // 0x38
}

// UCPD.CFGR1: UCPD configuration register 1
func (o *UCPD_Type) SetCFGR1_HBITCLKDIV(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x3f)|value)
}
func (o *UCPD_Type) GetCFGR1_HBITCLKDIV() uint32 {
	return volatile.LoadUint32(&o.CFGR1.Reg) & 0x3f
}
func (o *UCPD_Type) SetCFGR1_IFRGAP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x7c0)|value<<6)
}
func (o *UCPD_Type) GetCFGR1_IFRGAP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x7c0) >> 6
}
func (o *UCPD_Type) SetCFGR1_TRANSWIN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xf800)|value<<11)
}
func (o *UCPD_Type) GetCFGR1_TRANSWIN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xf800) >> 11
}
func (o *UCPD_Type) SetCFGR1_PSC_USBPDCLK(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xe0000)|value<<17)
}
func (o *UCPD_Type) GetCFGR1_PSC_USBPDCLK() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xe0000) >> 17
}
func (o *UCPD_Type) SetCFGR1_RXORDSETEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x1ff00000)|value<<20)
}
func (o *UCPD_Type) GetCFGR1_RXORDSETEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x1ff00000) >> 20
}
func (o *UCPD_Type) SetCFGR1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x20000000)|value<<29)
}
func (o *UCPD_Type) GetCFGR1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x20000000) >> 29
}
func (o *UCPD_Type) SetCFGR1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x40000000)|value<<30)
}
func (o *UCPD_Type) GetCFGR1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x40000000) >> 30
}
func (o *UCPD_Type) SetCFGR1_UCPDEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *UCPD_Type) GetCFGR1_UCPDEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x80000000) >> 31
}

// UCPD.CFGR2: UCPD configuration register 2
func (o *UCPD_Type) SetCFGR2_RXFILTDIS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1)|value)
}
func (o *UCPD_Type) GetCFGR2_RXFILTDIS() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x1
}
func (o *UCPD_Type) SetCFGR2_RXFILT2N3(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x2)|value<<1)
}
func (o *UCPD_Type) GetCFGR2_RXFILT2N3() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x2) >> 1
}
func (o *UCPD_Type) SetCFGR2_FORCECLK(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x4)|value<<2)
}
func (o *UCPD_Type) GetCFGR2_FORCECLK() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x4) >> 2
}
func (o *UCPD_Type) SetCFGR2_WUPEN(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x8)|value<<3)
}
func (o *UCPD_Type) GetCFGR2_WUPEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x8) >> 3
}

// UCPD.CFGR3: UCPD configuration register 3
func (o *UCPD_Type) SetCFGR3_TRIM1_NG_CCRPD(value uint32) {
	volatile.StoreUint32(&o.CFGR3.Reg, volatile.LoadUint32(&o.CFGR3.Reg)&^(0xf)|value)
}
func (o *UCPD_Type) GetCFGR3_TRIM1_NG_CCRPD() uint32 {
	return volatile.LoadUint32(&o.CFGR3.Reg) & 0xf
}
func (o *UCPD_Type) SetCFGR3_TRIM1_NG_CC1A5(value uint32) {
	volatile.StoreUint32(&o.CFGR3.Reg, volatile.LoadUint32(&o.CFGR3.Reg)&^(0x1f0)|value<<4)
}
func (o *UCPD_Type) GetCFGR3_TRIM1_NG_CC1A5() uint32 {
	return (volatile.LoadUint32(&o.CFGR3.Reg) & 0x1f0) >> 4
}
func (o *UCPD_Type) SetCFGR3_TRIM1_NG_CC3A0(value uint32) {
	volatile.StoreUint32(&o.CFGR3.Reg, volatile.LoadUint32(&o.CFGR3.Reg)&^(0x1e00)|value<<9)
}
func (o *UCPD_Type) GetCFGR3_TRIM1_NG_CC3A0() uint32 {
	return (volatile.LoadUint32(&o.CFGR3.Reg) & 0x1e00) >> 9
}
func (o *UCPD_Type) SetCFGR3_TRIM2_NG_CCRPD(value uint32) {
	volatile.StoreUint32(&o.CFGR3.Reg, volatile.LoadUint32(&o.CFGR3.Reg)&^(0xf0000)|value<<16)
}
func (o *UCPD_Type) GetCFGR3_TRIM2_NG_CCRPD() uint32 {
	return (volatile.LoadUint32(&o.CFGR3.Reg) & 0xf0000) >> 16
}
func (o *UCPD_Type) SetCFGR3_TRIM2_NG_CC1A5(value uint32) {
	volatile.StoreUint32(&o.CFGR3.Reg, volatile.LoadUint32(&o.CFGR3.Reg)&^(0x1f00000)|value<<20)
}
func (o *UCPD_Type) GetCFGR3_TRIM2_NG_CC1A5() uint32 {
	return (volatile.LoadUint32(&o.CFGR3.Reg) & 0x1f00000) >> 20
}
func (o *UCPD_Type) SetCFGR3_TRIM2_NG_CC3A0(value uint32) {
	volatile.StoreUint32(&o.CFGR3.Reg, volatile.LoadUint32(&o.CFGR3.Reg)&^(0x1e000000)|value<<25)
}
func (o *UCPD_Type) GetCFGR3_TRIM2_NG_CC3A0() uint32 {
	return (volatile.LoadUint32(&o.CFGR3.Reg) & 0x1e000000) >> 25
}

// UCPD.CR: UCPD control register
func (o *UCPD_Type) SetCR_TXMODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3)|value)
}
func (o *UCPD_Type) GetCR_TXMODE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x3
}
func (o *UCPD_Type) SetCR_TXSEND(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *UCPD_Type) GetCR_TXSEND() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *UCPD_Type) SetCR_TXHRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *UCPD_Type) GetCR_TXHRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *UCPD_Type) SetCR_RXMODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *UCPD_Type) GetCR_RXMODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *UCPD_Type) SetCR_PHYRXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *UCPD_Type) GetCR_PHYRXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *UCPD_Type) SetCR_PHYCCSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *UCPD_Type) GetCR_PHYCCSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *UCPD_Type) SetCR_ANASUBMODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x180)|value<<7)
}
func (o *UCPD_Type) GetCR_ANASUBMODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x180) >> 7
}
func (o *UCPD_Type) SetCR_ANAMODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *UCPD_Type) GetCR_ANAMODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *UCPD_Type) SetCR_CCENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00)|value<<10)
}
func (o *UCPD_Type) GetCR_CCENABLE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00) >> 10
}
func (o *UCPD_Type) SetCR_CC1VCONNEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *UCPD_Type) GetCR_CC1VCONNEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *UCPD_Type) SetCR_CC2VCONNEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *UCPD_Type) GetCR_CC2VCONNEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *UCPD_Type) SetCR_DBATTEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *UCPD_Type) GetCR_DBATTEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *UCPD_Type) SetCR_FRSRXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *UCPD_Type) GetCR_FRSRXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *UCPD_Type) SetCR_FRSTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *UCPD_Type) GetCR_FRSTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *UCPD_Type) SetCR_RDCH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *UCPD_Type) GetCR_RDCH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *UCPD_Type) SetCR_CC1TCDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *UCPD_Type) GetCR_CC1TCDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *UCPD_Type) SetCR_CC2TCDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200000)|value<<21)
}
func (o *UCPD_Type) GetCR_CC2TCDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200000) >> 21
}

// UCPD.IMR: UCPD interrupt mask register
func (o *UCPD_Type) SetIMR_TXISIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *UCPD_Type) GetIMR_TXISIE() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *UCPD_Type) SetIMR_TXMSGDISCIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *UCPD_Type) GetIMR_TXMSGDISCIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *UCPD_Type) SetIMR_TXMSGSENTIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *UCPD_Type) GetIMR_TXMSGSENTIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *UCPD_Type) SetIMR_TXMSGABTIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *UCPD_Type) GetIMR_TXMSGABTIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *UCPD_Type) SetIMR_HRSTDISCIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *UCPD_Type) GetIMR_HRSTDISCIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *UCPD_Type) SetIMR_HRSTSENTIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *UCPD_Type) GetIMR_HRSTSENTIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *UCPD_Type) SetIMR_TXUNDIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *UCPD_Type) GetIMR_TXUNDIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *UCPD_Type) SetIMR_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *UCPD_Type) GetIMR_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *UCPD_Type) SetIMR_RXORDDETIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *UCPD_Type) GetIMR_RXORDDETIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *UCPD_Type) SetIMR_RXHRSTDETIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *UCPD_Type) GetIMR_RXHRSTDETIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *UCPD_Type) SetIMR_RXOVRIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *UCPD_Type) GetIMR_RXOVRIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *UCPD_Type) SetIMR_RXMSGENDIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *UCPD_Type) GetIMR_RXMSGENDIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *UCPD_Type) SetIMR_TYPECEVT1IE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *UCPD_Type) GetIMR_TYPECEVT1IE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *UCPD_Type) SetIMR_TYPECEVT2IE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *UCPD_Type) GetIMR_TYPECEVT2IE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *UCPD_Type) SetIMR_FRSEVTIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *UCPD_Type) GetIMR_FRSEVTIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}

// UCPD.SR: UCPD status register
func (o *UCPD_Type) SetSR_TXIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *UCPD_Type) GetSR_TXIS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *UCPD_Type) SetSR_TXMSGDISC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *UCPD_Type) GetSR_TXMSGDISC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *UCPD_Type) SetSR_TXMSGSENT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *UCPD_Type) GetSR_TXMSGSENT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *UCPD_Type) SetSR_TXMSGABT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *UCPD_Type) GetSR_TXMSGABT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *UCPD_Type) SetSR_HRSTDISC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *UCPD_Type) GetSR_HRSTDISC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *UCPD_Type) SetSR_HRSTSENT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *UCPD_Type) GetSR_HRSTSENT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *UCPD_Type) SetSR_TXUND(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *UCPD_Type) GetSR_TXUND() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *UCPD_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *UCPD_Type) GetSR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *UCPD_Type) SetSR_RXORDDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *UCPD_Type) GetSR_RXORDDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *UCPD_Type) SetSR_RXHRSTDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *UCPD_Type) GetSR_RXHRSTDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *UCPD_Type) SetSR_RXOVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *UCPD_Type) GetSR_RXOVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *UCPD_Type) SetSR_RXMSGEND(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *UCPD_Type) GetSR_RXMSGEND() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *UCPD_Type) SetSR_RXERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *UCPD_Type) GetSR_RXERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *UCPD_Type) SetSR_TYPECEVT1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *UCPD_Type) GetSR_TYPECEVT1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *UCPD_Type) SetSR_TYPECEVT2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *UCPD_Type) GetSR_TYPECEVT2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *UCPD_Type) SetSR_TYPEC_VSTATE_CC1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x30000)|value<<16)
}
func (o *UCPD_Type) GetSR_TYPEC_VSTATE_CC1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x30000) >> 16
}
func (o *UCPD_Type) SetSR_TYPEC_VSTATE_CC2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xc0000)|value<<18)
}
func (o *UCPD_Type) GetSR_TYPEC_VSTATE_CC2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xc0000) >> 18
}
func (o *UCPD_Type) SetSR_FRSEVT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *UCPD_Type) GetSR_FRSEVT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}

// UCPD.ICR: UCPD interrupt clear register
func (o *UCPD_Type) SetICR_TXMSGDISCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *UCPD_Type) GetICR_TXMSGDISCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *UCPD_Type) SetICR_TXMSGSENTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *UCPD_Type) GetICR_TXMSGSENTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *UCPD_Type) SetICR_TXMSGABTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *UCPD_Type) GetICR_TXMSGABTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *UCPD_Type) SetICR_HRSTDISCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *UCPD_Type) GetICR_HRSTDISCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *UCPD_Type) SetICR_HRSTSENTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *UCPD_Type) GetICR_HRSTSENTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *UCPD_Type) SetICR_TXUNDCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *UCPD_Type) GetICR_TXUNDCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *UCPD_Type) SetICR_RXORDDETCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *UCPD_Type) GetICR_RXORDDETCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *UCPD_Type) SetICR_RXHRSTDETCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *UCPD_Type) GetICR_RXHRSTDETCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *UCPD_Type) SetICR_RXOVRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *UCPD_Type) GetICR_RXOVRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *UCPD_Type) SetICR_RXMSGENDCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *UCPD_Type) GetICR_RXMSGENDCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *UCPD_Type) SetICR_TYPECEVT1CF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4000)|value<<14)
}
func (o *UCPD_Type) GetICR_TYPECEVT1CF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4000) >> 14
}
func (o *UCPD_Type) SetICR_TYPECEVT2CF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8000)|value<<15)
}
func (o *UCPD_Type) GetICR_TYPECEVT2CF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8000) >> 15
}
func (o *UCPD_Type) SetICR_FRSEVTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100000)|value<<20)
}
func (o *UCPD_Type) GetICR_FRSEVTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100000) >> 20
}

// UCPD.TX_ORDSETR: UCPD Tx ordered set type register
func (o *UCPD_Type) SetTX_ORDSETR_TXORDSET(value uint32) {
	volatile.StoreUint32(&o.TX_ORDSETR.Reg, volatile.LoadUint32(&o.TX_ORDSETR.Reg)&^(0xfffff)|value)
}
func (o *UCPD_Type) GetTX_ORDSETR_TXORDSET() uint32 {
	return volatile.LoadUint32(&o.TX_ORDSETR.Reg) & 0xfffff
}

// UCPD.TX_PAYSZR: UCPD Tx payload size register
func (o *UCPD_Type) SetTX_PAYSZR_TXPAYSZ(value uint32) {
	volatile.StoreUint32(&o.TX_PAYSZR.Reg, volatile.LoadUint32(&o.TX_PAYSZR.Reg)&^(0x3ff)|value)
}
func (o *UCPD_Type) GetTX_PAYSZR_TXPAYSZ() uint32 {
	return volatile.LoadUint32(&o.TX_PAYSZR.Reg) & 0x3ff
}

// UCPD.TXDR: UCPD Tx data register
func (o *UCPD_Type) SetTXDR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *UCPD_Type) GetTXDR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// UCPD.RX_ORDSETR: UCPD Rx ordered set register
func (o *UCPD_Type) SetRX_ORDSETR_RXORDSET(value uint32) {
	volatile.StoreUint32(&o.RX_ORDSETR.Reg, volatile.LoadUint32(&o.RX_ORDSETR.Reg)&^(0x7)|value)
}
func (o *UCPD_Type) GetRX_ORDSETR_RXORDSET() uint32 {
	return volatile.LoadUint32(&o.RX_ORDSETR.Reg) & 0x7
}
func (o *UCPD_Type) SetRX_ORDSETR_RXSOP3OF4(value uint32) {
	volatile.StoreUint32(&o.RX_ORDSETR.Reg, volatile.LoadUint32(&o.RX_ORDSETR.Reg)&^(0x8)|value<<3)
}
func (o *UCPD_Type) GetRX_ORDSETR_RXSOP3OF4() uint32 {
	return (volatile.LoadUint32(&o.RX_ORDSETR.Reg) & 0x8) >> 3
}
func (o *UCPD_Type) SetRX_ORDSETR_RXSOPKINVALID(value uint32) {
	volatile.StoreUint32(&o.RX_ORDSETR.Reg, volatile.LoadUint32(&o.RX_ORDSETR.Reg)&^(0x70)|value<<4)
}
func (o *UCPD_Type) GetRX_ORDSETR_RXSOPKINVALID() uint32 {
	return (volatile.LoadUint32(&o.RX_ORDSETR.Reg) & 0x70) >> 4
}

// UCPD.RX_PAYSZR: UCPD Rx payload size register
func (o *UCPD_Type) SetRX_PAYSZR_RXPAYSZ(value uint32) {
	volatile.StoreUint32(&o.RX_PAYSZR.Reg, volatile.LoadUint32(&o.RX_PAYSZR.Reg)&^(0x3ff)|value)
}
func (o *UCPD_Type) GetRX_PAYSZR_RXPAYSZ() uint32 {
	return volatile.LoadUint32(&o.RX_PAYSZR.Reg) & 0x3ff
}

// UCPD.RXDR: UCPD receive data register
func (o *UCPD_Type) SetRXDR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *UCPD_Type) GetRXDR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// UCPD.RX_ORDEXTR1: UCPD Rx ordered set extension register 1
func (o *UCPD_Type) SetRX_ORDEXTR1_RXSOPX1(value uint32) {
	volatile.StoreUint32(&o.RX_ORDEXTR1.Reg, volatile.LoadUint32(&o.RX_ORDEXTR1.Reg)&^(0xfffff)|value)
}
func (o *UCPD_Type) GetRX_ORDEXTR1_RXSOPX1() uint32 {
	return volatile.LoadUint32(&o.RX_ORDEXTR1.Reg) & 0xfffff
}

// UCPD.RX_ORDEXTR2: UCPD Rx ordered set extension register 2
func (o *UCPD_Type) SetRX_ORDEXTR2_RXSOPX2(value uint32) {
	volatile.StoreUint32(&o.RX_ORDEXTR2.Reg, volatile.LoadUint32(&o.RX_ORDEXTR2.Reg)&^(0xfffff)|value)
}
func (o *UCPD_Type) GetRX_ORDEXTR2_RXSOPX2() uint32 {
	return volatile.LoadUint32(&o.RX_ORDEXTR2.Reg) & 0xfffff
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1_FIFO_ENABLED volatile.Register32 // 0x0
	CR2              volatile.Register32 // 0x4
	CR3              volatile.Register32 // 0x8
	BRR              volatile.Register32 // 0xC
	GTPR             volatile.Register32 // 0x10
	RTOR             volatile.Register32 // 0x14
	RQR              volatile.Register32 // 0x18
	ISR_FIFO_ENABLED volatile.Register32 // 0x1C
	ICR              volatile.Register32 // 0x20
	RDR              volatile.Register32 // 0x24
	TDR              volatile.Register32 // 0x28
	PRESC            volatile.Register32 // 0x2C
}

// USART.CR1_FIFO_ENABLED: Control register 1
func (o *USART_Type) SetCR1_FIFO_ENABLED_UE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_UE() uint32 {
	return volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x1
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_UESM(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_UESM() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_RE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_TE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_RXFNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_RXFNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_TXFNFIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_TXFNFIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_PS(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_M0(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_M0() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_MME(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_MME() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_CMIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_CMIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_OVER8(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_OVER8() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_DEDT(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x1f0000)|value<<16)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_DEDT() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x1f0000) >> 16
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_DEAT(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x3e00000)|value<<21)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_DEAT() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x3e00000) >> 21
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_RTOIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x4000000)|value<<26)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_RTOIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x4000000) >> 26
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_EOBIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x8000000)|value<<27)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_EOBIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x8000000) >> 27
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_M1(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_M1() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_FIFOEN(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_FIFOEN() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_TXFEIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_TXFEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x40000000) >> 30
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_RXFFIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x80000000)|value<<31)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_RXFFIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x80000000) >> 31
}

// USART.CR2: Control register 2
func (o *USART_Type) SetCR2_SLVEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR2_SLVEN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *USART_Type) SetCR2_DIS_NSS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR2_DIS_NSS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR2_ADDM7(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR2_ADDM7() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR2_LBDL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR2_LBDL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR2_LBDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR2_LBDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR2_LBCL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR2_LBCL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR2_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR2_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR2_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetCR2_LINEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR2_LINEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR2_SWAP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR2_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR2_RXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetCR2_RXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetCR2_TXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetCR2_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetCR2_DATAINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR2_DATAINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR2_MSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR2_MSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCR2_ABREN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetCR2_ABREN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetCR2_ABRMOD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x600000)|value<<21)
}
func (o *USART_Type) GetCR2_ABRMOD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x600000) >> 21
}
func (o *USART_Type) SetCR2_RTOEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCR2_RTOEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCR2_ADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff000000)|value<<24)
}
func (o *USART_Type) GetCR2_ADD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff000000) >> 24
}

// USART.CR3: Control register 3
func (o *USART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}
func (o *USART_Type) SetCR3_IREN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR3_IREN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR3_IRLP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR3_IRLP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR3_NACK(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR3_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR3_SCEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR3_SCEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR3_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR3_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR3_OVRDIS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR3_OVRDIS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR3_DDRE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR3_DDRE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR3_DEM(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR3_DEM() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR3_DEP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR3_DEP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR3_SCARCNT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000)|value<<17)
}
func (o *USART_Type) GetCR3_SCARCNT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000) >> 17
}
func (o *USART_Type) SetCR3_WUS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x300000)|value<<20)
}
func (o *USART_Type) GetCR3_WUS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x300000) >> 20
}
func (o *USART_Type) SetCR3_WUFIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetCR3_WUFIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetCR3_TXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCR3_TXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCR3_TCBGTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetCR3_TCBGTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000000) >> 24
}
func (o *USART_Type) SetCR3_RXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe000000)|value<<25)
}
func (o *USART_Type) GetCR3_RXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe000000) >> 25
}
func (o *USART_Type) SetCR3_RXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetCR3_RXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetCR3_TXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000000)|value<<29)
}
func (o *USART_Type) GetCR3_TXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000000) >> 29
}

// USART.BRR: Baud rate register
func (o *USART_Type) SetBRR(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRR() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xffff
}

// USART.GTPR: Guard time and prescaler register
func (o *USART_Type) SetGTPR_PSC(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetGTPR_PSC() uint32 {
	return volatile.LoadUint32(&o.GTPR.Reg) & 0xff
}
func (o *USART_Type) SetGTPR_GT(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetGTPR_GT() uint32 {
	return (volatile.LoadUint32(&o.GTPR.Reg) & 0xff00) >> 8
}

// USART.RTOR: Receiver timeout register
func (o *USART_Type) SetRTOR_RTO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffffff)|value)
}
func (o *USART_Type) GetRTOR_RTO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffffff
}
func (o *USART_Type) SetRTOR_BLEN(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xff000000)|value<<24)
}
func (o *USART_Type) GetRTOR_BLEN() uint32 {
	return (volatile.LoadUint32(&o.RTOR.Reg) & 0xff000000) >> 24
}

// USART.RQR: Request register
func (o *USART_Type) SetRQR_ABRRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetRQR_ABRRQ() uint32 {
	return volatile.LoadUint32(&o.RQR.Reg) & 0x1
}
func (o *USART_Type) SetRQR_SBKRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetRQR_SBKRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetRQR_MMRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetRQR_MMRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetRQR_RXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetRQR_RXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetRQR_TXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetRQR_TXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x10) >> 4
}

// USART.ISR_FIFO_ENABLED: Interrupt & status register
func (o *USART_Type) SetISR_FIFO_ENABLED_PE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_PE() uint32 {
	return volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x1
}
func (o *USART_Type) SetISR_FIFO_ENABLED_FE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_FE() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetISR_FIFO_ENABLED_NE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_NE() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetISR_FIFO_ENABLED_ORE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_ORE() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetISR_FIFO_ENABLED_IDLE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_IDLE() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetISR_FIFO_ENABLED_RXFNE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_RXFNE() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetISR_FIFO_ENABLED_TC(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetISR_FIFO_ENABLED_TXFNF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_TXFNF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetISR_FIFO_ENABLED_LBDF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_LBDF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetISR_FIFO_ENABLED_CTSIF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_CTSIF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetISR_FIFO_ENABLED_CTS(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_CTS() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetISR_FIFO_ENABLED_RTOF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_RTOF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetISR_FIFO_ENABLED_EOBF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_EOBF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetISR_FIFO_ENABLED_UDR(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_UDR() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetISR_FIFO_ENABLED_ABRE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_ABRE() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetISR_FIFO_ENABLED_ABRF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_ABRF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetISR_FIFO_ENABLED_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetISR_FIFO_ENABLED_CMF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_CMF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetISR_FIFO_ENABLED_SBKF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_SBKF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetISR_FIFO_ENABLED_RWU(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_RWU() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetISR_FIFO_ENABLED_WUF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_WUF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetISR_FIFO_ENABLED_TEACK(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_TEACK() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetISR_FIFO_ENABLED_REACK(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_REACK() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetISR_FIFO_ENABLED_TXFE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_TXFE() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetISR_FIFO_ENABLED_RXFF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_RXFF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x1000000) >> 24
}
func (o *USART_Type) SetISR_FIFO_ENABLED_TCBGT(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x2000000)|value<<25)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_TCBGT() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x2000000) >> 25
}
func (o *USART_Type) SetISR_FIFO_ENABLED_RXFT(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x4000000)|value<<26)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_RXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x4000000) >> 26
}
func (o *USART_Type) SetISR_FIFO_ENABLED_TXFT(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x8000000)|value<<27)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_TXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x8000000) >> 27
}

// USART.ICR: Interrupt flag clear register
func (o *USART_Type) SetICR_PECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetICR_PECF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *USART_Type) SetICR_FECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetICR_FECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetICR_NECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetICR_NECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetICR_ORECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetICR_ORECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetICR_IDLECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetICR_IDLECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetICR_TXFECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetICR_TXFECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetICR_TCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetICR_TCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetICR_TCBGTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetICR_TCBGTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetICR_LBDCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetICR_LBDCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetICR_CTSCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetICR_CTSCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetICR_RTOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetICR_RTOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetICR_EOBCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetICR_EOBCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetICR_UDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetICR_UDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetICR_CMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetICR_CMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetICR_WUCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetICR_WUCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100000) >> 20
}

// USART.RDR: Receive data register
func (o *USART_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0x1ff
}

// USART.TDR: Transmit data register
func (o *USART_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0x1ff
}

// USART.PRESC: Prescaler register
func (o *USART_Type) SetPRESC_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESC.Reg, volatile.LoadUint32(&o.PRESC.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetPRESC_PRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESC.Reg) & 0xf
}

// Universal serial bus full-speed host/device interface
type USB_Type struct {
	CHEP0R volatile.Register32 // 0x0
	CHEP1R volatile.Register32 // 0x4
	CHEP2R volatile.Register32 // 0x8
	CHEP3R volatile.Register32 // 0xC
	CHEP4R volatile.Register32 // 0x10
	CHEP5R volatile.Register32 // 0x14
	CHEP6R volatile.Register32 // 0x18
	CHEP7R volatile.Register32 // 0x1C
	_      [32]byte
	CNTR   volatile.Register32 // 0x40
	ISTR   volatile.Register32 // 0x44
	FNR    volatile.Register32 // 0x48
	DADDR  volatile.Register32 // 0x4C
	_      [4]byte
	LPMCSR volatile.Register32 // 0x54
	BCDR   volatile.Register32 // 0x58
}

// USB.CHEP0R: USB endpoint/channel 0 register
func (o *USB_Type) SetCHEP0R_EA(value uint32) {
	volatile.StoreUint32(&o.CHEP0R.Reg, volatile.LoadUint32(&o.CHEP0R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetCHEP0R_EA() uint32 {
	return volatile.LoadUint32(&o.CHEP0R.Reg) & 0xf
}
func (o *USB_Type) SetCHEP0R_STATTX(value uint32) {
	volatile.StoreUint32(&o.CHEP0R.Reg, volatile.LoadUint32(&o.CHEP0R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetCHEP0R_STATTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP0R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetCHEP0R_DTOGTX(value uint32) {
	volatile.StoreUint32(&o.CHEP0R.Reg, volatile.LoadUint32(&o.CHEP0R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetCHEP0R_DTOGTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP0R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetCHEP0R_VTTX(value uint32) {
	volatile.StoreUint32(&o.CHEP0R.Reg, volatile.LoadUint32(&o.CHEP0R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetCHEP0R_VTTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP0R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetCHEP0R_EPKIND(value uint32) {
	volatile.StoreUint32(&o.CHEP0R.Reg, volatile.LoadUint32(&o.CHEP0R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetCHEP0R_EPKIND() uint32 {
	return (volatile.LoadUint32(&o.CHEP0R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetCHEP0R_UTYPE(value uint32) {
	volatile.StoreUint32(&o.CHEP0R.Reg, volatile.LoadUint32(&o.CHEP0R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetCHEP0R_UTYPE() uint32 {
	return (volatile.LoadUint32(&o.CHEP0R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetCHEP0R_SETUP(value uint32) {
	volatile.StoreUint32(&o.CHEP0R.Reg, volatile.LoadUint32(&o.CHEP0R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetCHEP0R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.CHEP0R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetCHEP0R_STATRX(value uint32) {
	volatile.StoreUint32(&o.CHEP0R.Reg, volatile.LoadUint32(&o.CHEP0R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetCHEP0R_STATRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP0R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetCHEP0R_DTOGRX(value uint32) {
	volatile.StoreUint32(&o.CHEP0R.Reg, volatile.LoadUint32(&o.CHEP0R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetCHEP0R_DTOGRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP0R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetCHEP0R_VTRX(value uint32) {
	volatile.StoreUint32(&o.CHEP0R.Reg, volatile.LoadUint32(&o.CHEP0R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCHEP0R_VTRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP0R.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetCHEP0R_DEVADDR(value uint32) {
	volatile.StoreUint32(&o.CHEP0R.Reg, volatile.LoadUint32(&o.CHEP0R.Reg)&^(0x7f0000)|value<<16)
}
func (o *USB_Type) GetCHEP0R_DEVADDR() uint32 {
	return (volatile.LoadUint32(&o.CHEP0R.Reg) & 0x7f0000) >> 16
}
func (o *USB_Type) SetCHEP0R_NAK(value uint32) {
	volatile.StoreUint32(&o.CHEP0R.Reg, volatile.LoadUint32(&o.CHEP0R.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetCHEP0R_NAK() uint32 {
	return (volatile.LoadUint32(&o.CHEP0R.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetCHEP0R_LS_EP(value uint32) {
	volatile.StoreUint32(&o.CHEP0R.Reg, volatile.LoadUint32(&o.CHEP0R.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetCHEP0R_LS_EP() uint32 {
	return (volatile.LoadUint32(&o.CHEP0R.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetCHEP0R_ERR_TX(value uint32) {
	volatile.StoreUint32(&o.CHEP0R.Reg, volatile.LoadUint32(&o.CHEP0R.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetCHEP0R_ERR_TX() uint32 {
	return (volatile.LoadUint32(&o.CHEP0R.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetCHEP0R_ERR_RX(value uint32) {
	volatile.StoreUint32(&o.CHEP0R.Reg, volatile.LoadUint32(&o.CHEP0R.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetCHEP0R_ERR_RX() uint32 {
	return (volatile.LoadUint32(&o.CHEP0R.Reg) & 0x4000000) >> 26
}

// USB.CHEP1R: USB endpoint/channel 1 register
func (o *USB_Type) SetCHEP1R_EA(value uint32) {
	volatile.StoreUint32(&o.CHEP1R.Reg, volatile.LoadUint32(&o.CHEP1R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetCHEP1R_EA() uint32 {
	return volatile.LoadUint32(&o.CHEP1R.Reg) & 0xf
}
func (o *USB_Type) SetCHEP1R_STATTX(value uint32) {
	volatile.StoreUint32(&o.CHEP1R.Reg, volatile.LoadUint32(&o.CHEP1R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetCHEP1R_STATTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP1R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetCHEP1R_DTOGTX(value uint32) {
	volatile.StoreUint32(&o.CHEP1R.Reg, volatile.LoadUint32(&o.CHEP1R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetCHEP1R_DTOGTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP1R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetCHEP1R_VTTX(value uint32) {
	volatile.StoreUint32(&o.CHEP1R.Reg, volatile.LoadUint32(&o.CHEP1R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetCHEP1R_VTTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP1R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetCHEP1R_EPKIND(value uint32) {
	volatile.StoreUint32(&o.CHEP1R.Reg, volatile.LoadUint32(&o.CHEP1R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetCHEP1R_EPKIND() uint32 {
	return (volatile.LoadUint32(&o.CHEP1R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetCHEP1R_UTYPE(value uint32) {
	volatile.StoreUint32(&o.CHEP1R.Reg, volatile.LoadUint32(&o.CHEP1R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetCHEP1R_UTYPE() uint32 {
	return (volatile.LoadUint32(&o.CHEP1R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetCHEP1R_SETUP(value uint32) {
	volatile.StoreUint32(&o.CHEP1R.Reg, volatile.LoadUint32(&o.CHEP1R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetCHEP1R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.CHEP1R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetCHEP1R_STATRX(value uint32) {
	volatile.StoreUint32(&o.CHEP1R.Reg, volatile.LoadUint32(&o.CHEP1R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetCHEP1R_STATRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP1R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetCHEP1R_DTOGRX(value uint32) {
	volatile.StoreUint32(&o.CHEP1R.Reg, volatile.LoadUint32(&o.CHEP1R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetCHEP1R_DTOGRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP1R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetCHEP1R_VTRX(value uint32) {
	volatile.StoreUint32(&o.CHEP1R.Reg, volatile.LoadUint32(&o.CHEP1R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCHEP1R_VTRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP1R.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetCHEP1R_DEVADDR(value uint32) {
	volatile.StoreUint32(&o.CHEP1R.Reg, volatile.LoadUint32(&o.CHEP1R.Reg)&^(0x7f0000)|value<<16)
}
func (o *USB_Type) GetCHEP1R_DEVADDR() uint32 {
	return (volatile.LoadUint32(&o.CHEP1R.Reg) & 0x7f0000) >> 16
}
func (o *USB_Type) SetCHEP1R_NAK(value uint32) {
	volatile.StoreUint32(&o.CHEP1R.Reg, volatile.LoadUint32(&o.CHEP1R.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetCHEP1R_NAK() uint32 {
	return (volatile.LoadUint32(&o.CHEP1R.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetCHEP1R_LS_EP(value uint32) {
	volatile.StoreUint32(&o.CHEP1R.Reg, volatile.LoadUint32(&o.CHEP1R.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetCHEP1R_LS_EP() uint32 {
	return (volatile.LoadUint32(&o.CHEP1R.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetCHEP1R_ERR_TX(value uint32) {
	volatile.StoreUint32(&o.CHEP1R.Reg, volatile.LoadUint32(&o.CHEP1R.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetCHEP1R_ERR_TX() uint32 {
	return (volatile.LoadUint32(&o.CHEP1R.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetCHEP1R_ERR_RX(value uint32) {
	volatile.StoreUint32(&o.CHEP1R.Reg, volatile.LoadUint32(&o.CHEP1R.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetCHEP1R_ERR_RX() uint32 {
	return (volatile.LoadUint32(&o.CHEP1R.Reg) & 0x4000000) >> 26
}

// USB.CHEP2R: USB endpoint/channel 2 register
func (o *USB_Type) SetCHEP2R_EA(value uint32) {
	volatile.StoreUint32(&o.CHEP2R.Reg, volatile.LoadUint32(&o.CHEP2R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetCHEP2R_EA() uint32 {
	return volatile.LoadUint32(&o.CHEP2R.Reg) & 0xf
}
func (o *USB_Type) SetCHEP2R_STATTX(value uint32) {
	volatile.StoreUint32(&o.CHEP2R.Reg, volatile.LoadUint32(&o.CHEP2R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetCHEP2R_STATTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP2R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetCHEP2R_DTOGTX(value uint32) {
	volatile.StoreUint32(&o.CHEP2R.Reg, volatile.LoadUint32(&o.CHEP2R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetCHEP2R_DTOGTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP2R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetCHEP2R_VTTX(value uint32) {
	volatile.StoreUint32(&o.CHEP2R.Reg, volatile.LoadUint32(&o.CHEP2R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetCHEP2R_VTTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP2R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetCHEP2R_EPKIND(value uint32) {
	volatile.StoreUint32(&o.CHEP2R.Reg, volatile.LoadUint32(&o.CHEP2R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetCHEP2R_EPKIND() uint32 {
	return (volatile.LoadUint32(&o.CHEP2R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetCHEP2R_UTYPE(value uint32) {
	volatile.StoreUint32(&o.CHEP2R.Reg, volatile.LoadUint32(&o.CHEP2R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetCHEP2R_UTYPE() uint32 {
	return (volatile.LoadUint32(&o.CHEP2R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetCHEP2R_SETUP(value uint32) {
	volatile.StoreUint32(&o.CHEP2R.Reg, volatile.LoadUint32(&o.CHEP2R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetCHEP2R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.CHEP2R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetCHEP2R_STATRX(value uint32) {
	volatile.StoreUint32(&o.CHEP2R.Reg, volatile.LoadUint32(&o.CHEP2R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetCHEP2R_STATRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP2R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetCHEP2R_DTOGRX(value uint32) {
	volatile.StoreUint32(&o.CHEP2R.Reg, volatile.LoadUint32(&o.CHEP2R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetCHEP2R_DTOGRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP2R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetCHEP2R_VTRX(value uint32) {
	volatile.StoreUint32(&o.CHEP2R.Reg, volatile.LoadUint32(&o.CHEP2R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCHEP2R_VTRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP2R.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetCHEP2R_DEVADDR(value uint32) {
	volatile.StoreUint32(&o.CHEP2R.Reg, volatile.LoadUint32(&o.CHEP2R.Reg)&^(0x7f0000)|value<<16)
}
func (o *USB_Type) GetCHEP2R_DEVADDR() uint32 {
	return (volatile.LoadUint32(&o.CHEP2R.Reg) & 0x7f0000) >> 16
}
func (o *USB_Type) SetCHEP2R_NAK(value uint32) {
	volatile.StoreUint32(&o.CHEP2R.Reg, volatile.LoadUint32(&o.CHEP2R.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetCHEP2R_NAK() uint32 {
	return (volatile.LoadUint32(&o.CHEP2R.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetCHEP2R_LS_EP(value uint32) {
	volatile.StoreUint32(&o.CHEP2R.Reg, volatile.LoadUint32(&o.CHEP2R.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetCHEP2R_LS_EP() uint32 {
	return (volatile.LoadUint32(&o.CHEP2R.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetCHEP2R_ERR_TX(value uint32) {
	volatile.StoreUint32(&o.CHEP2R.Reg, volatile.LoadUint32(&o.CHEP2R.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetCHEP2R_ERR_TX() uint32 {
	return (volatile.LoadUint32(&o.CHEP2R.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetCHEP2R_ERR_RX(value uint32) {
	volatile.StoreUint32(&o.CHEP2R.Reg, volatile.LoadUint32(&o.CHEP2R.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetCHEP2R_ERR_RX() uint32 {
	return (volatile.LoadUint32(&o.CHEP2R.Reg) & 0x4000000) >> 26
}

// USB.CHEP3R: USB endpoint/channel 3 register
func (o *USB_Type) SetCHEP3R_EA(value uint32) {
	volatile.StoreUint32(&o.CHEP3R.Reg, volatile.LoadUint32(&o.CHEP3R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetCHEP3R_EA() uint32 {
	return volatile.LoadUint32(&o.CHEP3R.Reg) & 0xf
}
func (o *USB_Type) SetCHEP3R_STATTX(value uint32) {
	volatile.StoreUint32(&o.CHEP3R.Reg, volatile.LoadUint32(&o.CHEP3R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetCHEP3R_STATTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP3R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetCHEP3R_DTOGTX(value uint32) {
	volatile.StoreUint32(&o.CHEP3R.Reg, volatile.LoadUint32(&o.CHEP3R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetCHEP3R_DTOGTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP3R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetCHEP3R_VTTX(value uint32) {
	volatile.StoreUint32(&o.CHEP3R.Reg, volatile.LoadUint32(&o.CHEP3R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetCHEP3R_VTTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP3R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetCHEP3R_EPKIND(value uint32) {
	volatile.StoreUint32(&o.CHEP3R.Reg, volatile.LoadUint32(&o.CHEP3R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetCHEP3R_EPKIND() uint32 {
	return (volatile.LoadUint32(&o.CHEP3R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetCHEP3R_UTYPE(value uint32) {
	volatile.StoreUint32(&o.CHEP3R.Reg, volatile.LoadUint32(&o.CHEP3R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetCHEP3R_UTYPE() uint32 {
	return (volatile.LoadUint32(&o.CHEP3R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetCHEP3R_SETUP(value uint32) {
	volatile.StoreUint32(&o.CHEP3R.Reg, volatile.LoadUint32(&o.CHEP3R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetCHEP3R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.CHEP3R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetCHEP3R_STATRX(value uint32) {
	volatile.StoreUint32(&o.CHEP3R.Reg, volatile.LoadUint32(&o.CHEP3R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetCHEP3R_STATRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP3R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetCHEP3R_DTOGRX(value uint32) {
	volatile.StoreUint32(&o.CHEP3R.Reg, volatile.LoadUint32(&o.CHEP3R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetCHEP3R_DTOGRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP3R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetCHEP3R_VTRX(value uint32) {
	volatile.StoreUint32(&o.CHEP3R.Reg, volatile.LoadUint32(&o.CHEP3R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCHEP3R_VTRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP3R.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetCHEP3R_DEVADDR(value uint32) {
	volatile.StoreUint32(&o.CHEP3R.Reg, volatile.LoadUint32(&o.CHEP3R.Reg)&^(0x7f0000)|value<<16)
}
func (o *USB_Type) GetCHEP3R_DEVADDR() uint32 {
	return (volatile.LoadUint32(&o.CHEP3R.Reg) & 0x7f0000) >> 16
}
func (o *USB_Type) SetCHEP3R_NAK(value uint32) {
	volatile.StoreUint32(&o.CHEP3R.Reg, volatile.LoadUint32(&o.CHEP3R.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetCHEP3R_NAK() uint32 {
	return (volatile.LoadUint32(&o.CHEP3R.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetCHEP3R_LS_EP(value uint32) {
	volatile.StoreUint32(&o.CHEP3R.Reg, volatile.LoadUint32(&o.CHEP3R.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetCHEP3R_LS_EP() uint32 {
	return (volatile.LoadUint32(&o.CHEP3R.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetCHEP3R_ERR_TX(value uint32) {
	volatile.StoreUint32(&o.CHEP3R.Reg, volatile.LoadUint32(&o.CHEP3R.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetCHEP3R_ERR_TX() uint32 {
	return (volatile.LoadUint32(&o.CHEP3R.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetCHEP3R_ERR_RX(value uint32) {
	volatile.StoreUint32(&o.CHEP3R.Reg, volatile.LoadUint32(&o.CHEP3R.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetCHEP3R_ERR_RX() uint32 {
	return (volatile.LoadUint32(&o.CHEP3R.Reg) & 0x4000000) >> 26
}

// USB.CHEP4R: USB endpoint/channel 4 register
func (o *USB_Type) SetCHEP4R_EA(value uint32) {
	volatile.StoreUint32(&o.CHEP4R.Reg, volatile.LoadUint32(&o.CHEP4R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetCHEP4R_EA() uint32 {
	return volatile.LoadUint32(&o.CHEP4R.Reg) & 0xf
}
func (o *USB_Type) SetCHEP4R_STATTX(value uint32) {
	volatile.StoreUint32(&o.CHEP4R.Reg, volatile.LoadUint32(&o.CHEP4R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetCHEP4R_STATTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP4R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetCHEP4R_DTOGTX(value uint32) {
	volatile.StoreUint32(&o.CHEP4R.Reg, volatile.LoadUint32(&o.CHEP4R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetCHEP4R_DTOGTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP4R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetCHEP4R_VTTX(value uint32) {
	volatile.StoreUint32(&o.CHEP4R.Reg, volatile.LoadUint32(&o.CHEP4R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetCHEP4R_VTTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP4R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetCHEP4R_EPKIND(value uint32) {
	volatile.StoreUint32(&o.CHEP4R.Reg, volatile.LoadUint32(&o.CHEP4R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetCHEP4R_EPKIND() uint32 {
	return (volatile.LoadUint32(&o.CHEP4R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetCHEP4R_UTYPE(value uint32) {
	volatile.StoreUint32(&o.CHEP4R.Reg, volatile.LoadUint32(&o.CHEP4R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetCHEP4R_UTYPE() uint32 {
	return (volatile.LoadUint32(&o.CHEP4R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetCHEP4R_SETUP(value uint32) {
	volatile.StoreUint32(&o.CHEP4R.Reg, volatile.LoadUint32(&o.CHEP4R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetCHEP4R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.CHEP4R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetCHEP4R_STATRX(value uint32) {
	volatile.StoreUint32(&o.CHEP4R.Reg, volatile.LoadUint32(&o.CHEP4R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetCHEP4R_STATRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP4R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetCHEP4R_DTOGRX(value uint32) {
	volatile.StoreUint32(&o.CHEP4R.Reg, volatile.LoadUint32(&o.CHEP4R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetCHEP4R_DTOGRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP4R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetCHEP4R_VTRX(value uint32) {
	volatile.StoreUint32(&o.CHEP4R.Reg, volatile.LoadUint32(&o.CHEP4R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCHEP4R_VTRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP4R.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetCHEP4R_DEVADDR(value uint32) {
	volatile.StoreUint32(&o.CHEP4R.Reg, volatile.LoadUint32(&o.CHEP4R.Reg)&^(0x7f0000)|value<<16)
}
func (o *USB_Type) GetCHEP4R_DEVADDR() uint32 {
	return (volatile.LoadUint32(&o.CHEP4R.Reg) & 0x7f0000) >> 16
}
func (o *USB_Type) SetCHEP4R_NAK(value uint32) {
	volatile.StoreUint32(&o.CHEP4R.Reg, volatile.LoadUint32(&o.CHEP4R.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetCHEP4R_NAK() uint32 {
	return (volatile.LoadUint32(&o.CHEP4R.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetCHEP4R_LS_EP(value uint32) {
	volatile.StoreUint32(&o.CHEP4R.Reg, volatile.LoadUint32(&o.CHEP4R.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetCHEP4R_LS_EP() uint32 {
	return (volatile.LoadUint32(&o.CHEP4R.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetCHEP4R_ERR_TX(value uint32) {
	volatile.StoreUint32(&o.CHEP4R.Reg, volatile.LoadUint32(&o.CHEP4R.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetCHEP4R_ERR_TX() uint32 {
	return (volatile.LoadUint32(&o.CHEP4R.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetCHEP4R_ERR_RX(value uint32) {
	volatile.StoreUint32(&o.CHEP4R.Reg, volatile.LoadUint32(&o.CHEP4R.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetCHEP4R_ERR_RX() uint32 {
	return (volatile.LoadUint32(&o.CHEP4R.Reg) & 0x4000000) >> 26
}

// USB.CHEP5R: USB endpoint/channel 5 register
func (o *USB_Type) SetCHEP5R_EA(value uint32) {
	volatile.StoreUint32(&o.CHEP5R.Reg, volatile.LoadUint32(&o.CHEP5R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetCHEP5R_EA() uint32 {
	return volatile.LoadUint32(&o.CHEP5R.Reg) & 0xf
}
func (o *USB_Type) SetCHEP5R_STATTX(value uint32) {
	volatile.StoreUint32(&o.CHEP5R.Reg, volatile.LoadUint32(&o.CHEP5R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetCHEP5R_STATTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP5R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetCHEP5R_DTOGTX(value uint32) {
	volatile.StoreUint32(&o.CHEP5R.Reg, volatile.LoadUint32(&o.CHEP5R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetCHEP5R_DTOGTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP5R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetCHEP5R_VTTX(value uint32) {
	volatile.StoreUint32(&o.CHEP5R.Reg, volatile.LoadUint32(&o.CHEP5R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetCHEP5R_VTTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP5R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetCHEP5R_EPKIND(value uint32) {
	volatile.StoreUint32(&o.CHEP5R.Reg, volatile.LoadUint32(&o.CHEP5R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetCHEP5R_EPKIND() uint32 {
	return (volatile.LoadUint32(&o.CHEP5R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetCHEP5R_UTYPE(value uint32) {
	volatile.StoreUint32(&o.CHEP5R.Reg, volatile.LoadUint32(&o.CHEP5R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetCHEP5R_UTYPE() uint32 {
	return (volatile.LoadUint32(&o.CHEP5R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetCHEP5R_SETUP(value uint32) {
	volatile.StoreUint32(&o.CHEP5R.Reg, volatile.LoadUint32(&o.CHEP5R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetCHEP5R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.CHEP5R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetCHEP5R_STATRX(value uint32) {
	volatile.StoreUint32(&o.CHEP5R.Reg, volatile.LoadUint32(&o.CHEP5R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetCHEP5R_STATRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP5R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetCHEP5R_DTOGRX(value uint32) {
	volatile.StoreUint32(&o.CHEP5R.Reg, volatile.LoadUint32(&o.CHEP5R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetCHEP5R_DTOGRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP5R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetCHEP5R_VTRX(value uint32) {
	volatile.StoreUint32(&o.CHEP5R.Reg, volatile.LoadUint32(&o.CHEP5R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCHEP5R_VTRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP5R.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetCHEP5R_DEVADDR(value uint32) {
	volatile.StoreUint32(&o.CHEP5R.Reg, volatile.LoadUint32(&o.CHEP5R.Reg)&^(0x7f0000)|value<<16)
}
func (o *USB_Type) GetCHEP5R_DEVADDR() uint32 {
	return (volatile.LoadUint32(&o.CHEP5R.Reg) & 0x7f0000) >> 16
}
func (o *USB_Type) SetCHEP5R_NAK(value uint32) {
	volatile.StoreUint32(&o.CHEP5R.Reg, volatile.LoadUint32(&o.CHEP5R.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetCHEP5R_NAK() uint32 {
	return (volatile.LoadUint32(&o.CHEP5R.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetCHEP5R_LS_EP(value uint32) {
	volatile.StoreUint32(&o.CHEP5R.Reg, volatile.LoadUint32(&o.CHEP5R.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetCHEP5R_LS_EP() uint32 {
	return (volatile.LoadUint32(&o.CHEP5R.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetCHEP5R_ERR_TX(value uint32) {
	volatile.StoreUint32(&o.CHEP5R.Reg, volatile.LoadUint32(&o.CHEP5R.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetCHEP5R_ERR_TX() uint32 {
	return (volatile.LoadUint32(&o.CHEP5R.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetCHEP5R_ERR_RX(value uint32) {
	volatile.StoreUint32(&o.CHEP5R.Reg, volatile.LoadUint32(&o.CHEP5R.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetCHEP5R_ERR_RX() uint32 {
	return (volatile.LoadUint32(&o.CHEP5R.Reg) & 0x4000000) >> 26
}

// USB.CHEP6R: USB endpoint/channel 6 register
func (o *USB_Type) SetCHEP6R_EA(value uint32) {
	volatile.StoreUint32(&o.CHEP6R.Reg, volatile.LoadUint32(&o.CHEP6R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetCHEP6R_EA() uint32 {
	return volatile.LoadUint32(&o.CHEP6R.Reg) & 0xf
}
func (o *USB_Type) SetCHEP6R_STATTX(value uint32) {
	volatile.StoreUint32(&o.CHEP6R.Reg, volatile.LoadUint32(&o.CHEP6R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetCHEP6R_STATTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP6R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetCHEP6R_DTOGTX(value uint32) {
	volatile.StoreUint32(&o.CHEP6R.Reg, volatile.LoadUint32(&o.CHEP6R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetCHEP6R_DTOGTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP6R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetCHEP6R_VTTX(value uint32) {
	volatile.StoreUint32(&o.CHEP6R.Reg, volatile.LoadUint32(&o.CHEP6R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetCHEP6R_VTTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP6R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetCHEP6R_EPKIND(value uint32) {
	volatile.StoreUint32(&o.CHEP6R.Reg, volatile.LoadUint32(&o.CHEP6R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetCHEP6R_EPKIND() uint32 {
	return (volatile.LoadUint32(&o.CHEP6R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetCHEP6R_UTYPE(value uint32) {
	volatile.StoreUint32(&o.CHEP6R.Reg, volatile.LoadUint32(&o.CHEP6R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetCHEP6R_UTYPE() uint32 {
	return (volatile.LoadUint32(&o.CHEP6R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetCHEP6R_SETUP(value uint32) {
	volatile.StoreUint32(&o.CHEP6R.Reg, volatile.LoadUint32(&o.CHEP6R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetCHEP6R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.CHEP6R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetCHEP6R_STATRX(value uint32) {
	volatile.StoreUint32(&o.CHEP6R.Reg, volatile.LoadUint32(&o.CHEP6R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetCHEP6R_STATRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP6R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetCHEP6R_DTOGRX(value uint32) {
	volatile.StoreUint32(&o.CHEP6R.Reg, volatile.LoadUint32(&o.CHEP6R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetCHEP6R_DTOGRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP6R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetCHEP6R_VTRX(value uint32) {
	volatile.StoreUint32(&o.CHEP6R.Reg, volatile.LoadUint32(&o.CHEP6R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCHEP6R_VTRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP6R.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetCHEP6R_DEVADDR(value uint32) {
	volatile.StoreUint32(&o.CHEP6R.Reg, volatile.LoadUint32(&o.CHEP6R.Reg)&^(0x7f0000)|value<<16)
}
func (o *USB_Type) GetCHEP6R_DEVADDR() uint32 {
	return (volatile.LoadUint32(&o.CHEP6R.Reg) & 0x7f0000) >> 16
}
func (o *USB_Type) SetCHEP6R_NAK(value uint32) {
	volatile.StoreUint32(&o.CHEP6R.Reg, volatile.LoadUint32(&o.CHEP6R.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetCHEP6R_NAK() uint32 {
	return (volatile.LoadUint32(&o.CHEP6R.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetCHEP6R_LS_EP(value uint32) {
	volatile.StoreUint32(&o.CHEP6R.Reg, volatile.LoadUint32(&o.CHEP6R.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetCHEP6R_LS_EP() uint32 {
	return (volatile.LoadUint32(&o.CHEP6R.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetCHEP6R_ERR_TX(value uint32) {
	volatile.StoreUint32(&o.CHEP6R.Reg, volatile.LoadUint32(&o.CHEP6R.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetCHEP6R_ERR_TX() uint32 {
	return (volatile.LoadUint32(&o.CHEP6R.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetCHEP6R_ERR_RX(value uint32) {
	volatile.StoreUint32(&o.CHEP6R.Reg, volatile.LoadUint32(&o.CHEP6R.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetCHEP6R_ERR_RX() uint32 {
	return (volatile.LoadUint32(&o.CHEP6R.Reg) & 0x4000000) >> 26
}

// USB.CHEP7R: USB endpoint/channel 7 register
func (o *USB_Type) SetCHEP7R_EA(value uint32) {
	volatile.StoreUint32(&o.CHEP7R.Reg, volatile.LoadUint32(&o.CHEP7R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetCHEP7R_EA() uint32 {
	return volatile.LoadUint32(&o.CHEP7R.Reg) & 0xf
}
func (o *USB_Type) SetCHEP7R_STATTX(value uint32) {
	volatile.StoreUint32(&o.CHEP7R.Reg, volatile.LoadUint32(&o.CHEP7R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetCHEP7R_STATTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP7R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetCHEP7R_DTOGTX(value uint32) {
	volatile.StoreUint32(&o.CHEP7R.Reg, volatile.LoadUint32(&o.CHEP7R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetCHEP7R_DTOGTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP7R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetCHEP7R_VTTX(value uint32) {
	volatile.StoreUint32(&o.CHEP7R.Reg, volatile.LoadUint32(&o.CHEP7R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetCHEP7R_VTTX() uint32 {
	return (volatile.LoadUint32(&o.CHEP7R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetCHEP7R_EPKIND(value uint32) {
	volatile.StoreUint32(&o.CHEP7R.Reg, volatile.LoadUint32(&o.CHEP7R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetCHEP7R_EPKIND() uint32 {
	return (volatile.LoadUint32(&o.CHEP7R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetCHEP7R_UTYPE(value uint32) {
	volatile.StoreUint32(&o.CHEP7R.Reg, volatile.LoadUint32(&o.CHEP7R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetCHEP7R_UTYPE() uint32 {
	return (volatile.LoadUint32(&o.CHEP7R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetCHEP7R_SETUP(value uint32) {
	volatile.StoreUint32(&o.CHEP7R.Reg, volatile.LoadUint32(&o.CHEP7R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetCHEP7R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.CHEP7R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetCHEP7R_STATRX(value uint32) {
	volatile.StoreUint32(&o.CHEP7R.Reg, volatile.LoadUint32(&o.CHEP7R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetCHEP7R_STATRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP7R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetCHEP7R_DTOGRX(value uint32) {
	volatile.StoreUint32(&o.CHEP7R.Reg, volatile.LoadUint32(&o.CHEP7R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetCHEP7R_DTOGRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP7R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetCHEP7R_VTRX(value uint32) {
	volatile.StoreUint32(&o.CHEP7R.Reg, volatile.LoadUint32(&o.CHEP7R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCHEP7R_VTRX() uint32 {
	return (volatile.LoadUint32(&o.CHEP7R.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetCHEP7R_DEVADDR(value uint32) {
	volatile.StoreUint32(&o.CHEP7R.Reg, volatile.LoadUint32(&o.CHEP7R.Reg)&^(0x7f0000)|value<<16)
}
func (o *USB_Type) GetCHEP7R_DEVADDR() uint32 {
	return (volatile.LoadUint32(&o.CHEP7R.Reg) & 0x7f0000) >> 16
}
func (o *USB_Type) SetCHEP7R_NAK(value uint32) {
	volatile.StoreUint32(&o.CHEP7R.Reg, volatile.LoadUint32(&o.CHEP7R.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetCHEP7R_NAK() uint32 {
	return (volatile.LoadUint32(&o.CHEP7R.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetCHEP7R_LS_EP(value uint32) {
	volatile.StoreUint32(&o.CHEP7R.Reg, volatile.LoadUint32(&o.CHEP7R.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetCHEP7R_LS_EP() uint32 {
	return (volatile.LoadUint32(&o.CHEP7R.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetCHEP7R_ERR_TX(value uint32) {
	volatile.StoreUint32(&o.CHEP7R.Reg, volatile.LoadUint32(&o.CHEP7R.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetCHEP7R_ERR_TX() uint32 {
	return (volatile.LoadUint32(&o.CHEP7R.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetCHEP7R_ERR_RX(value uint32) {
	volatile.StoreUint32(&o.CHEP7R.Reg, volatile.LoadUint32(&o.CHEP7R.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetCHEP7R_ERR_RX() uint32 {
	return (volatile.LoadUint32(&o.CHEP7R.Reg) & 0x4000000) >> 26
}

// USB.CNTR: USB control register
func (o *USB_Type) SetCNTR_USBRST(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetCNTR_USBRST() uint32 {
	return volatile.LoadUint32(&o.CNTR.Reg) & 0x1
}
func (o *USB_Type) SetCNTR_PDWN(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetCNTR_PDWN() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetCNTR_SUSPRDY(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetCNTR_SUSPRDY() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetCNTR_SUSPEN(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetCNTR_SUSPEN() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetCNTR_L2RESUME(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetCNTR_L2RESUME() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetCNTR_L1RESUME(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetCNTR_L1RESUME() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetCNTR_L1REQM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetCNTR_L1REQM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetCNTR_ESOFM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetCNTR_ESOFM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetCNTR_SOFM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetCNTR_SOFM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetCNTR_RESETM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetCNTR_RESETM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetCNTR_SUSPM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetCNTR_SUSPM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetCNTR_WKUPM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetCNTR_WKUPM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetCNTR_ERRM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetCNTR_ERRM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetCNTR_PMAOVRM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetCNTR_PMAOVRM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetCNTR_CTRM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCNTR_CTRM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetCNTR_THR512M(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetCNTR_THR512M() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetCNTR_HOST(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetCNTR_HOST() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x80000000) >> 31
}

// USB.ISTR: USB interrupt status register
func (o *USB_Type) SetISTR_IDN(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetISTR_IDN() uint32 {
	return volatile.LoadUint32(&o.ISTR.Reg) & 0xf
}
func (o *USB_Type) SetISTR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetISTR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetISTR_L1REQ(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetISTR_L1REQ() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetISTR_ESOF(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetISTR_ESOF() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetISTR_SOF(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetISTR_SOF() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetISTR_RST_DCON(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetISTR_RST_DCON() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetISTR_SUSP(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetISTR_SUSP() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetISTR_WKUP(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetISTR_WKUP() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetISTR_ERR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetISTR_ERR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetISTR_PMAOVR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetISTR_PMAOVR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetISTR_CTR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetISTR_CTR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetISTR_THR512(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetISTR_THR512() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetISTR_DCON_STAT(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetISTR_DCON_STAT() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetISTR_LS_DCON(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetISTR_LS_DCON() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x40000000) >> 30
}

// USB.FNR: USB frame number register
func (o *USB_Type) SetFNR_FN(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x7ff)|value)
}
func (o *USB_Type) GetFNR_FN() uint32 {
	return volatile.LoadUint32(&o.FNR.Reg) & 0x7ff
}
func (o *USB_Type) SetFNR_LSOF(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x1800)|value<<11)
}
func (o *USB_Type) GetFNR_LSOF() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x1800) >> 11
}
func (o *USB_Type) SetFNR_LCK(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetFNR_LCK() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetFNR_RXDM(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetFNR_RXDM() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetFNR_RXDP(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetFNR_RXDP() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x8000) >> 15
}

// USB.DADDR: USB device address
func (o *USB_Type) SetDADDR_ADD(value uint32) {
	volatile.StoreUint32(&o.DADDR.Reg, volatile.LoadUint32(&o.DADDR.Reg)&^(0x7f)|value)
}
func (o *USB_Type) GetDADDR_ADD() uint32 {
	return volatile.LoadUint32(&o.DADDR.Reg) & 0x7f
}
func (o *USB_Type) SetDADDR_EF(value uint32) {
	volatile.StoreUint32(&o.DADDR.Reg, volatile.LoadUint32(&o.DADDR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDADDR_EF() uint32 {
	return (volatile.LoadUint32(&o.DADDR.Reg) & 0x80) >> 7
}

// USB.LPMCSR: LPM control and status register
func (o *USB_Type) SetLPMCSR_LPMEN(value uint32) {
	volatile.StoreUint32(&o.LPMCSR.Reg, volatile.LoadUint32(&o.LPMCSR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetLPMCSR_LPMEN() uint32 {
	return volatile.LoadUint32(&o.LPMCSR.Reg) & 0x1
}
func (o *USB_Type) SetLPMCSR_LPMACK(value uint32) {
	volatile.StoreUint32(&o.LPMCSR.Reg, volatile.LoadUint32(&o.LPMCSR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetLPMCSR_LPMACK() uint32 {
	return (volatile.LoadUint32(&o.LPMCSR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetLPMCSR_REMWAKE(value uint32) {
	volatile.StoreUint32(&o.LPMCSR.Reg, volatile.LoadUint32(&o.LPMCSR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetLPMCSR_REMWAKE() uint32 {
	return (volatile.LoadUint32(&o.LPMCSR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetLPMCSR_BESL(value uint32) {
	volatile.StoreUint32(&o.LPMCSR.Reg, volatile.LoadUint32(&o.LPMCSR.Reg)&^(0xf0)|value<<4)
}
func (o *USB_Type) GetLPMCSR_BESL() uint32 {
	return (volatile.LoadUint32(&o.LPMCSR.Reg) & 0xf0) >> 4
}

// USB.BCDR: Battery charging detector
func (o *USB_Type) SetBCDR_BCDEN(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetBCDR_BCDEN() uint32 {
	return volatile.LoadUint32(&o.BCDR.Reg) & 0x1
}
func (o *USB_Type) SetBCDR_DCDEN(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetBCDR_DCDEN() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetBCDR_PDEN(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetBCDR_PDEN() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetBCDR_SDEN(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetBCDR_SDEN() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetBCDR_DCDET(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetBCDR_DCDET() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetBCDR_PDET(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetBCDR_PDET() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetBCDR_SDET(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetBCDR_SDET() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetBCDR_PS2DET(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetBCDR_PS2DET() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetBCDR_DPPU_DPD(value uint32) {
	volatile.StoreUint32(&o.BCDR.Reg, volatile.LoadUint32(&o.BCDR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetBCDR_DPPU_DPD() uint32 {
	return (volatile.LoadUint32(&o.BCDR.Reg) & 0x8000) >> 15
}

// System configuration controller
type VREFBUF_Type struct {
	CSR volatile.Register32 // 0x0
	CCR volatile.Register32 // 0x4
}

// VREFBUF.CSR: VREFBUF control and status register
func (o *VREFBUF_Type) SetCSR_ENVR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *VREFBUF_Type) GetCSR_ENVR() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *VREFBUF_Type) SetCSR_HIZ(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *VREFBUF_Type) GetCSR_HIZ() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *VREFBUF_Type) SetCSR_VRS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *VREFBUF_Type) GetCSR_VRS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *VREFBUF_Type) SetCSR_VRR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *VREFBUF_Type) GetCSR_VRR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}

// VREFBUF.CCR: VREFBUF calibration control register
func (o *VREFBUF_Type) SetCCR_TRIM(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3f)|value)
}
func (o *VREFBUF_Type) GetCCR_TRIM() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x3f
}

// System window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// WWDG.CR: Control register
func (o *WWDG_Type) SetCR_T(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCR_T() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCR_WDGA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *WWDG_Type) GetCR_WDGA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// WWDG.CFR: Configuration register
func (o *WWDG_Type) SetCFR_W(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCFR_W() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCFR_EWI(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *WWDG_Type) GetCFR_EWI() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *WWDG_Type) SetCFR_WDGTB(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x3800)|value<<11)
}
func (o *WWDG_Type) GetCFR_WDGTB() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x3800) >> 11
}

// WWDG.SR: Status register
func (o *WWDG_Type) SetSR_EWIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *WWDG_Type) GetSR_EWIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// DMA controller
type DMA1_Type struct {
	ISR  volatile.Register32 // 0x0
	IFCR volatile.Register32 // 0x4
	CH   [7]DMA1_CH_Type     // 0x8
}

// DMA1.ISR: low interrupt status register
func (o *DMA1_Type) SetISR_GIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DMA1_Type) GetISR_GIF1() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *DMA1_Type) SetISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DMA1_Type) GetISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DMA1_Type) SetISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA1_Type) GetISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DMA1_Type) SetISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA1_Type) GetISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DMA1_Type) SetISR_GIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA1_Type) GetISR_GIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DMA1_Type) SetISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA1_Type) GetISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *DMA1_Type) SetISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA1_Type) GetISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *DMA1_Type) SetISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *DMA1_Type) GetISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *DMA1_Type) SetISR_GIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA1_Type) GetISR_GIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *DMA1_Type) SetISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA1_Type) GetISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *DMA1_Type) SetISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA1_Type) GetISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *DMA1_Type) SetISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA1_Type) GetISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *DMA1_Type) SetISR_GIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA1_Type) GetISR_GIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *DMA1_Type) SetISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA1_Type) GetISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *DMA1_Type) SetISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA1_Type) GetISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *DMA1_Type) SetISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA1_Type) GetISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *DMA1_Type) SetISR_GIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA1_Type) GetISR_GIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *DMA1_Type) SetISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA1_Type) GetISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *DMA1_Type) SetISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA1_Type) GetISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *DMA1_Type) SetISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA1_Type) GetISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *DMA1_Type) SetISR_GIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA1_Type) GetISR_GIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *DMA1_Type) SetISR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA1_Type) GetISR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *DMA1_Type) SetISR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA1_Type) GetISR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *DMA1_Type) SetISR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA1_Type) GetISR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *DMA1_Type) SetISR_GIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA1_Type) GetISR_GIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *DMA1_Type) SetISR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA1_Type) GetISR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *DMA1_Type) SetISR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA1_Type) GetISR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *DMA1_Type) SetISR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA1_Type) GetISR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}

// DMA1.IFCR: high interrupt status register
func (o *DMA1_Type) SetIFCR_CGIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *DMA1_Type) GetIFCR_CGIF1() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}
func (o *DMA1_Type) SetIFCR_CTCIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *DMA1_Type) GetIFCR_CTCIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *DMA1_Type) SetIFCR_CHTIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA1_Type) GetIFCR_CHTIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *DMA1_Type) SetIFCR_CTEIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA1_Type) GetIFCR_CTEIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *DMA1_Type) SetIFCR_CGIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA1_Type) GetIFCR_CGIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *DMA1_Type) SetIFCR_CTCIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA1_Type) GetIFCR_CTCIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}
func (o *DMA1_Type) SetIFCR_CHTIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA1_Type) GetIFCR_CHTIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40) >> 6
}
func (o *DMA1_Type) SetIFCR_CTEIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA1_Type) GetIFCR_CTEIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80) >> 7
}
func (o *DMA1_Type) SetIFCR_CGIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA1_Type) GetIFCR_CGIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100) >> 8
}
func (o *DMA1_Type) SetIFCR_CTCIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA1_Type) GetIFCR_CTCIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200) >> 9
}
func (o *DMA1_Type) SetIFCR_CHTIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA1_Type) GetIFCR_CHTIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400) >> 10
}
func (o *DMA1_Type) SetIFCR_CTEIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA1_Type) GetIFCR_CTEIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800) >> 11
}
func (o *DMA1_Type) SetIFCR_CGIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA1_Type) GetIFCR_CGIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000) >> 12
}
func (o *DMA1_Type) SetIFCR_CTCIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA1_Type) GetIFCR_CTCIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000) >> 13
}
func (o *DMA1_Type) SetIFCR_CHTIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA1_Type) GetIFCR_CHTIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000) >> 14
}
func (o *DMA1_Type) SetIFCR_CTEIF15(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA1_Type) GetIFCR_CTEIF15() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000) >> 15
}
func (o *DMA1_Type) SetIFCR_CGIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA1_Type) GetIFCR_CGIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10000) >> 16
}
func (o *DMA1_Type) SetIFCR_CTCIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA1_Type) GetIFCR_CTCIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20000) >> 17
}
func (o *DMA1_Type) SetIFCR_CHTIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA1_Type) GetIFCR_CHTIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40000) >> 18
}
func (o *DMA1_Type) SetIFCR_CTEIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA1_Type) GetIFCR_CTEIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80000) >> 19
}
func (o *DMA1_Type) SetIFCR_CGIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA1_Type) GetIFCR_CGIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100000) >> 20
}
func (o *DMA1_Type) SetIFCR_CTCIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA1_Type) GetIFCR_CTCIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200000) >> 21
}
func (o *DMA1_Type) SetIFCR_CHTIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA1_Type) GetIFCR_CHTIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400000) >> 22
}
func (o *DMA1_Type) SetIFCR_CTEIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA1_Type) GetIFCR_CTEIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800000) >> 23
}
func (o *DMA1_Type) SetIFCR_CGIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA1_Type) GetIFCR_CGIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA1_Type) SetIFCR_CTCIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA1_Type) GetIFCR_CTCIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA1_Type) SetIFCR_CHTIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA1_Type) GetIFCR_CHTIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA1_Type) SetIFCR_CTEIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA1_Type) GetIFCR_CTEIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000000) >> 27
}

// Channel cluster: CCR?, CNDTR?, CPAR?, and CMAR? registers
type DMA1_CH_Type struct {
	CR   volatile.Register32 // 0x8
	NDTR volatile.Register32 // 0xC
	PAR  volatile.Register32 // 0x10
	MAR  volatile.Register32 // 0x14
	_    [4]byte
}

// DMA1_CH.CR: DMA channel 1 configuration register
func (o *DMA1_CH_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DMA1_CH_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DMA1_CH_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA1_CH_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA1_CH_Type) SetCR_HTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA1_CH_Type) GetCR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA1_CH_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA1_CH_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DMA1_CH_Type) SetCR_DIR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA1_CH_Type) GetCR_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DMA1_CH_Type) SetCR_CIRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA1_CH_Type) GetCR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DMA1_CH_Type) SetCR_PINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DMA1_CH_Type) GetCR_PINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DMA1_CH_Type) SetCR_MINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DMA1_CH_Type) GetCR_MINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DMA1_CH_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *DMA1_CH_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *DMA1_CH_Type) SetCR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00)|value<<10)
}
func (o *DMA1_CH_Type) GetCR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00) >> 10
}
func (o *DMA1_CH_Type) SetCR_PL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3000)|value<<12)
}
func (o *DMA1_CH_Type) GetCR_PL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3000) >> 12
}
func (o *DMA1_CH_Type) SetCR_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA1_CH_Type) GetCR_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}

// DMA1_CH.NDTR: DMA channel 1 number of data tegister
func (o *DMA1_CH_Type) SetNDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.NDTR.Reg, volatile.LoadUint32(&o.NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA1_CH_Type) GetNDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.NDTR.Reg) & 0xffff
}

// DMA1_CH.PAR: DMA channel 1 peripheral address
func (o *DMA1_CH_Type) SetPAR(value uint32) {
	volatile.StoreUint32(&o.PAR.Reg, value)
}
func (o *DMA1_CH_Type) GetPAR() uint32 {
	return volatile.LoadUint32(&o.PAR.Reg)
}

// DMA1_CH.MAR: DMA channel 1 memory address
func (o *DMA1_CH_Type) SetMAR(value uint32) {
	volatile.StoreUint32(&o.MAR.Reg, value)
}
func (o *DMA1_CH_Type) GetMAR() uint32 {
	return volatile.LoadUint32(&o.MAR.Reg)
}

// DMA controller
type DMA2_Type struct {
	ISR  volatile.Register32 // 0x0
	IFCR volatile.Register32 // 0x4
	CH   [5]DMA2_CH_Type     // 0x8
}

// DMA2.ISR: low interrupt status register
func (o *DMA2_Type) SetISR_GIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DMA2_Type) GetISR_GIF1() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *DMA2_Type) SetISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2_Type) GetISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DMA2_Type) SetISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2_Type) GetISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DMA2_Type) SetISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA2_Type) GetISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DMA2_Type) SetISR_GIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2_Type) GetISR_GIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DMA2_Type) SetISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2_Type) GetISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *DMA2_Type) SetISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA2_Type) GetISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *DMA2_Type) SetISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *DMA2_Type) GetISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *DMA2_Type) SetISR_GIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA2_Type) GetISR_GIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *DMA2_Type) SetISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA2_Type) GetISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *DMA2_Type) SetISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA2_Type) GetISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *DMA2_Type) SetISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA2_Type) GetISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *DMA2_Type) SetISR_GIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA2_Type) GetISR_GIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *DMA2_Type) SetISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA2_Type) GetISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *DMA2_Type) SetISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA2_Type) GetISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *DMA2_Type) SetISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA2_Type) GetISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *DMA2_Type) SetISR_GIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA2_Type) GetISR_GIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *DMA2_Type) SetISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA2_Type) GetISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *DMA2_Type) SetISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA2_Type) GetISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *DMA2_Type) SetISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA2_Type) GetISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}

// DMA2.IFCR: high interrupt status register
func (o *DMA2_Type) SetIFCR_CGIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *DMA2_Type) GetIFCR_CGIF1() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}
func (o *DMA2_Type) SetIFCR_CTCIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2_Type) GetIFCR_CTCIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *DMA2_Type) SetIFCR_CHTIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2_Type) GetIFCR_CHTIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *DMA2_Type) SetIFCR_CTEIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA2_Type) GetIFCR_CTEIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *DMA2_Type) SetIFCR_CGIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2_Type) GetIFCR_CGIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *DMA2_Type) SetIFCR_CTCIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2_Type) GetIFCR_CTCIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}
func (o *DMA2_Type) SetIFCR_CHTIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA2_Type) GetIFCR_CHTIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40) >> 6
}
func (o *DMA2_Type) SetIFCR_CTEIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA2_Type) GetIFCR_CTEIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80) >> 7
}
func (o *DMA2_Type) SetIFCR_CGIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA2_Type) GetIFCR_CGIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100) >> 8
}
func (o *DMA2_Type) SetIFCR_CTCIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA2_Type) GetIFCR_CTCIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200) >> 9
}
func (o *DMA2_Type) SetIFCR_CHTIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA2_Type) GetIFCR_CHTIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400) >> 10
}
func (o *DMA2_Type) SetIFCR_CTEIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA2_Type) GetIFCR_CTEIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800) >> 11
}
func (o *DMA2_Type) SetIFCR_CGIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA2_Type) GetIFCR_CGIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000) >> 12
}
func (o *DMA2_Type) SetIFCR_CTCIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA2_Type) GetIFCR_CTCIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000) >> 13
}
func (o *DMA2_Type) SetIFCR_CHTIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA2_Type) GetIFCR_CHTIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000) >> 14
}
func (o *DMA2_Type) SetIFCR_CTEIF15(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA2_Type) GetIFCR_CTEIF15() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000) >> 15
}
func (o *DMA2_Type) SetIFCR_CGIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA2_Type) GetIFCR_CGIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10000) >> 16
}
func (o *DMA2_Type) SetIFCR_CTCIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA2_Type) GetIFCR_CTCIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20000) >> 17
}
func (o *DMA2_Type) SetIFCR_CHTIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA2_Type) GetIFCR_CHTIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40000) >> 18
}
func (o *DMA2_Type) SetIFCR_CTEIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA2_Type) GetIFCR_CTEIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80000) >> 19
}

// Channel cluster: CCR?, CNDTR?, CPAR?, and CMAR? registers
type DMA2_CH_Type struct {
	CR   volatile.Register32 // 0x8
	NDTR volatile.Register32 // 0xC
	PAR  volatile.Register32 // 0x10
	MAR  volatile.Register32 // 0x14
	_    [4]byte
}

// DMA2_CH.CR: DMA channel 1 configuration register
func (o *DMA2_CH_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DMA2_CH_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DMA2_CH_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2_CH_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA2_CH_Type) SetCR_HTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2_CH_Type) GetCR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA2_CH_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA2_CH_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DMA2_CH_Type) SetCR_DIR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2_CH_Type) GetCR_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DMA2_CH_Type) SetCR_CIRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2_CH_Type) GetCR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DMA2_CH_Type) SetCR_PINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DMA2_CH_Type) GetCR_PINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DMA2_CH_Type) SetCR_MINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DMA2_CH_Type) GetCR_MINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DMA2_CH_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *DMA2_CH_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *DMA2_CH_Type) SetCR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00)|value<<10)
}
func (o *DMA2_CH_Type) GetCR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00) >> 10
}
func (o *DMA2_CH_Type) SetCR_PL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3000)|value<<12)
}
func (o *DMA2_CH_Type) GetCR_PL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3000) >> 12
}
func (o *DMA2_CH_Type) SetCR_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA2_CH_Type) GetCR_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}

// DMA2_CH.NDTR: DMA channel 1 number of data tegister
func (o *DMA2_CH_Type) SetNDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.NDTR.Reg, volatile.LoadUint32(&o.NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA2_CH_Type) GetNDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.NDTR.Reg) & 0xffff
}

// DMA2_CH.PAR: DMA channel 1 peripheral address
func (o *DMA2_CH_Type) SetPAR(value uint32) {
	volatile.StoreUint32(&o.PAR.Reg, value)
}
func (o *DMA2_CH_Type) GetPAR() uint32 {
	return volatile.LoadUint32(&o.PAR.Reg)
}

// DMA2_CH.MAR: DMA channel 1 memory address
func (o *DMA2_CH_Type) SetMAR(value uint32) {
	volatile.StoreUint32(&o.MAR.Reg, value)
}
func (o *DMA2_CH_Type) GetMAR() uint32 {
	return volatile.LoadUint32(&o.MAR.Reg)
}

// Constants for AES: Advanced Encryption Standard
const (
	// CR: AES control register
	// Position of EN field.
	AES_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	AES_CR_EN_Msk = 0x1
	// Bit EN.
	AES_CR_EN = 0x1
	// Disable
	AES_CR_EN_B_0x0 = 0x0
	// Enable
	AES_CR_EN_B_0x1 = 0x1
	// Position of DATATYPE field.
	AES_CR_DATATYPE_Pos = 0x1
	// Bit mask of DATATYPE field.
	AES_CR_DATATYPE_Msk = 0x6
	// None
	AES_CR_DATATYPE_B_0x0 = 0x0
	// Half-word (16-bit)
	AES_CR_DATATYPE_B_0x1 = 0x1
	// Byte (8-bit)
	AES_CR_DATATYPE_B_0x2 = 0x2
	// Bit
	AES_CR_DATATYPE_B_0x3 = 0x3
	// Position of MODE field.
	AES_CR_MODE_Pos = 0x3
	// Bit mask of MODE field.
	AES_CR_MODE_Msk = 0x18
	// Mode 1: encryption
	AES_CR_MODE_B_0x0 = 0x0
	// Mode 2: key derivation (or key preparation for ECB/CBC decryption)
	AES_CR_MODE_B_0x1 = 0x1
	// Mode 3: decryption
	AES_CR_MODE_B_0x2 = 0x2
	// Mode 4: key derivation then single decryption
	AES_CR_MODE_B_0x3 = 0x3
	// Position of CHMOD1 field.
	AES_CR_CHMOD1_Pos = 0x5
	// Bit mask of CHMOD1 field.
	AES_CR_CHMOD1_Msk = 0x60
	// Position of CCFC field.
	AES_CR_CCFC_Pos = 0x7
	// Bit mask of CCFC field.
	AES_CR_CCFC_Msk = 0x80
	// Bit CCFC.
	AES_CR_CCFC = 0x80
	// No effect
	AES_CR_CCFC_B_0x0 = 0x0
	// Clear CCF
	AES_CR_CCFC_B_0x1 = 0x1
	// Position of ERRC field.
	AES_CR_ERRC_Pos = 0x8
	// Bit mask of ERRC field.
	AES_CR_ERRC_Msk = 0x100
	// Bit ERRC.
	AES_CR_ERRC = 0x100
	// No effect
	AES_CR_ERRC_B_0x0 = 0x0
	// Clear RDERR and WRERR flags
	AES_CR_ERRC_B_0x1 = 0x1
	// Position of CCFIE field.
	AES_CR_CCFIE_Pos = 0x9
	// Bit mask of CCFIE field.
	AES_CR_CCFIE_Msk = 0x200
	// Bit CCFIE.
	AES_CR_CCFIE = 0x200
	// Disable (mask)
	AES_CR_CCFIE_B_0x0 = 0x0
	// Enable
	AES_CR_CCFIE_B_0x1 = 0x1
	// Position of ERRIE field.
	AES_CR_ERRIE_Pos = 0xa
	// Bit mask of ERRIE field.
	AES_CR_ERRIE_Msk = 0x400
	// Bit ERRIE.
	AES_CR_ERRIE = 0x400
	// Disable (mask)
	AES_CR_ERRIE_B_0x0 = 0x0
	// Enable
	AES_CR_ERRIE_B_0x1 = 0x1
	// Position of DMAINEN field.
	AES_CR_DMAINEN_Pos = 0xb
	// Bit mask of DMAINEN field.
	AES_CR_DMAINEN_Msk = 0x800
	// Bit DMAINEN.
	AES_CR_DMAINEN = 0x800
	// Disable
	AES_CR_DMAINEN_B_0x0 = 0x0
	// Enable
	AES_CR_DMAINEN_B_0x1 = 0x1
	// Position of DMAOUTEN field.
	AES_CR_DMAOUTEN_Pos = 0xc
	// Bit mask of DMAOUTEN field.
	AES_CR_DMAOUTEN_Msk = 0x1000
	// Bit DMAOUTEN.
	AES_CR_DMAOUTEN = 0x1000
	// Disable
	AES_CR_DMAOUTEN_B_0x0 = 0x0
	// Enable
	AES_CR_DMAOUTEN_B_0x1 = 0x1
	// Position of GCMPH field.
	AES_CR_GCMPH_Pos = 0xd
	// Bit mask of GCMPH field.
	AES_CR_GCMPH_Msk = 0x6000
	// Init phase
	AES_CR_GCMPH_B_0x0 = 0x0
	// Header phase
	AES_CR_GCMPH_B_0x1 = 0x1
	// Payload phase
	AES_CR_GCMPH_B_0x2 = 0x2
	// Final phase
	AES_CR_GCMPH_B_0x3 = 0x3
	// Position of CHMOD2 field.
	AES_CR_CHMOD2_Pos = 0x10
	// Bit mask of CHMOD2 field.
	AES_CR_CHMOD2_Msk = 0x10000
	// Bit CHMOD2.
	AES_CR_CHMOD2 = 0x10000
	// Position of KEYSIZE field.
	AES_CR_KEYSIZE_Pos = 0x12
	// Bit mask of KEYSIZE field.
	AES_CR_KEYSIZE_Msk = 0x40000
	// Bit KEYSIZE.
	AES_CR_KEYSIZE = 0x40000
	// 128
	AES_CR_KEYSIZE_B_0x0 = 0x0
	// 256
	AES_CR_KEYSIZE_B_0x1 = 0x1
	// Position of NPBLB field.
	AES_CR_NPBLB_Pos = 0x14
	// Bit mask of NPBLB field.
	AES_CR_NPBLB_Msk = 0xf00000
	// All bytes are valid (no padding)
	AES_CR_NPBLB_B_0x0 = 0x0
	// Padding for one least-significant byte of last block
	AES_CR_NPBLB_B_0x1 = 0x1
	// Padding for 15 least-significant bytes of last block
	AES_CR_NPBLB_B_0xF = 0xf

	// SR: AES status register
	// Position of CCF field.
	AES_SR_CCF_Pos = 0x0
	// Bit mask of CCF field.
	AES_SR_CCF_Msk = 0x1
	// Bit CCF.
	AES_SR_CCF = 0x1
	// Not completed
	AES_SR_CCF_B_0x0 = 0x0
	// Completed
	AES_SR_CCF_B_0x1 = 0x1
	// Position of RDERR field.
	AES_SR_RDERR_Pos = 0x1
	// Bit mask of RDERR field.
	AES_SR_RDERR_Msk = 0x2
	// Bit RDERR.
	AES_SR_RDERR = 0x2
	// Not detected
	AES_SR_RDERR_B_0x0 = 0x0
	// Detected
	AES_SR_RDERR_B_0x1 = 0x1
	// Position of WRERR field.
	AES_SR_WRERR_Pos = 0x2
	// Bit mask of WRERR field.
	AES_SR_WRERR_Msk = 0x4
	// Bit WRERR.
	AES_SR_WRERR = 0x4
	// Not detected
	AES_SR_WRERR_B_0x0 = 0x0
	// Detected
	AES_SR_WRERR_B_0x1 = 0x1
	// Position of BUSY field.
	AES_SR_BUSY_Pos = 0x3
	// Bit mask of BUSY field.
	AES_SR_BUSY_Msk = 0x8
	// Bit BUSY.
	AES_SR_BUSY = 0x8
	// Idle
	AES_SR_BUSY_B_0x0 = 0x0
	// Busy
	AES_SR_BUSY_B_0x1 = 0x1

	// DINR: AES data input register
	// Position of DIN field.
	AES_DINR_DIN_Pos = 0x0
	// Bit mask of DIN field.
	AES_DINR_DIN_Msk = 0xffffffff

	// DOUTR: AES data output register
	// Position of DOUT field.
	AES_DOUTR_DOUT_Pos = 0x0
	// Bit mask of DOUT field.
	AES_DOUTR_DOUT_Msk = 0xffffffff

	// KEYR0: AES key register 0
	// Position of KEY field.
	AES_KEYR0_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR0_KEY_Msk = 0xffffffff

	// KEYR1: AES key register 1
	// Position of KEY field.
	AES_KEYR1_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR1_KEY_Msk = 0xffffffff

	// KEYR2: AES key register 2
	// Position of KEY field.
	AES_KEYR2_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR2_KEY_Msk = 0xffffffff

	// KEYR3: AES key register 3
	// Position of KEY field.
	AES_KEYR3_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR3_KEY_Msk = 0xffffffff

	// IVR0: AES initialization vector register 0
	// Position of IVI field.
	AES_IVR0_IVI_Pos = 0x0
	// Bit mask of IVI field.
	AES_IVR0_IVI_Msk = 0xffffffff

	// IVR1: AES initialization vector register 1
	// Position of IVI field.
	AES_IVR1_IVI_Pos = 0x0
	// Bit mask of IVI field.
	AES_IVR1_IVI_Msk = 0xffffffff

	// IVR2: AES initialization vector register 2
	// Position of IVI field.
	AES_IVR2_IVI_Pos = 0x0
	// Bit mask of IVI field.
	AES_IVR2_IVI_Msk = 0xffffffff

	// IVR3: AES initialization vector register 3
	// Position of IVI field.
	AES_IVR3_IVI_Pos = 0x0
	// Bit mask of IVI field.
	AES_IVR3_IVI_Msk = 0xffffffff

	// KEYR4: AES key register 4
	// Position of KEY field.
	AES_KEYR4_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR4_KEY_Msk = 0xffffffff

	// KEYR5: AES key register 5
	// Position of KEY field.
	AES_KEYR5_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR5_KEY_Msk = 0xffffffff

	// KEYR6: AES key register 6
	// Position of KEY field.
	AES_KEYR6_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR6_KEY_Msk = 0xffffffff

	// KEYR7: AES key register 7
	// Position of KEY field.
	AES_KEYR7_KEY_Pos = 0x0
	// Bit mask of KEY field.
	AES_KEYR7_KEY_Msk = 0xffffffff

	// SUSP0R: AES suspend registers
	// Position of SUSP field.
	AES_SUSP0R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP0R_SUSP_Msk = 0xffffffff

	// SUSP1R: AES suspend registers
	// Position of SUSP field.
	AES_SUSP1R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP1R_SUSP_Msk = 0xffffffff

	// SUSP2R: AES suspend registers
	// Position of SUSP field.
	AES_SUSP2R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP2R_SUSP_Msk = 0xffffffff

	// SUSP3R: AES suspend registers
	// Position of SUSP field.
	AES_SUSP3R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP3R_SUSP_Msk = 0xffffffff

	// SUSP4R: AES suspend registers
	// Position of SUSP field.
	AES_SUSP4R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP4R_SUSP_Msk = 0xffffffff

	// SUSP5R: AES suspend registers
	// Position of SUSP field.
	AES_SUSP5R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP5R_SUSP_Msk = 0xffffffff

	// SUSP6R: AES suspend registers
	// Position of SUSP field.
	AES_SUSP6R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP6R_SUSP_Msk = 0xffffffff

	// SUSP7R: AES suspend registers
	// Position of SUSP field.
	AES_SUSP7R_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	AES_SUSP7R_SUSP_Msk = 0xffffffff
)

// Constants for ADC: Analog to Digital Converter
const (
	// ISR: ADC interrupt and status register
	// Position of ADRDY field.
	ADC_ISR_ADRDY_Pos = 0x0
	// Bit mask of ADRDY field.
	ADC_ISR_ADRDY_Msk = 0x1
	// Bit ADRDY.
	ADC_ISR_ADRDY = 0x1
	// ADC not yet ready to start conversion (or the flag event was already acknowledged and cleared by software)
	ADC_ISR_ADRDY_B_0x0 = 0x0
	// ADC is ready to start conversion
	ADC_ISR_ADRDY_B_0x1 = 0x1
	// Position of EOSMP field.
	ADC_ISR_EOSMP_Pos = 0x1
	// Bit mask of EOSMP field.
	ADC_ISR_EOSMP_Msk = 0x2
	// Bit EOSMP.
	ADC_ISR_EOSMP = 0x2
	// Not at the end of the sampling phase (or the flag event was already acknowledged and cleared by software)
	ADC_ISR_EOSMP_B_0x0 = 0x0
	// End of sampling phase reached
	ADC_ISR_EOSMP_B_0x1 = 0x1
	// Position of EOC field.
	ADC_ISR_EOC_Pos = 0x2
	// Bit mask of EOC field.
	ADC_ISR_EOC_Msk = 0x4
	// Bit EOC.
	ADC_ISR_EOC = 0x4
	// Channel conversion not complete (or the flag event was already acknowledged and cleared by software)
	ADC_ISR_EOC_B_0x0 = 0x0
	// Channel conversion complete
	ADC_ISR_EOC_B_0x1 = 0x1
	// Position of EOS field.
	ADC_ISR_EOS_Pos = 0x3
	// Bit mask of EOS field.
	ADC_ISR_EOS_Msk = 0x8
	// Bit EOS.
	ADC_ISR_EOS = 0x8
	// Conversion sequence not complete (or the flag event was already acknowledged and cleared by software)
	ADC_ISR_EOS_B_0x0 = 0x0
	// Conversion sequence complete
	ADC_ISR_EOS_B_0x1 = 0x1
	// Position of OVR field.
	ADC_ISR_OVR_Pos = 0x4
	// Bit mask of OVR field.
	ADC_ISR_OVR_Msk = 0x10
	// Bit OVR.
	ADC_ISR_OVR = 0x10
	// No overrun occurred (or the flag event was already acknowledged and cleared by software)
	ADC_ISR_OVR_B_0x0 = 0x0
	// Overrun has occurred
	ADC_ISR_OVR_B_0x1 = 0x1
	// Position of AWD1 field.
	ADC_ISR_AWD1_Pos = 0x7
	// Bit mask of AWD1 field.
	ADC_ISR_AWD1_Msk = 0x80
	// Bit AWD1.
	ADC_ISR_AWD1 = 0x80
	// No analog watchdog event occurred (or the flag event was already acknowledged and cleared by software)
	ADC_ISR_AWD1_B_0x0 = 0x0
	// Analog watchdog event occurred
	ADC_ISR_AWD1_B_0x1 = 0x1
	// Position of AWD2 field.
	ADC_ISR_AWD2_Pos = 0x8
	// Bit mask of AWD2 field.
	ADC_ISR_AWD2_Msk = 0x100
	// Bit AWD2.
	ADC_ISR_AWD2 = 0x100
	// No analog watchdog event occurred (or the flag event was already acknowledged and cleared by software)
	ADC_ISR_AWD2_B_0x0 = 0x0
	// Analog watchdog event occurred
	ADC_ISR_AWD2_B_0x1 = 0x1
	// Position of AWD3 field.
	ADC_ISR_AWD3_Pos = 0x9
	// Bit mask of AWD3 field.
	ADC_ISR_AWD3_Msk = 0x200
	// Bit AWD3.
	ADC_ISR_AWD3 = 0x200
	// No analog watchdog event occurred (or the flag event was already acknowledged and cleared by software)
	ADC_ISR_AWD3_B_0x0 = 0x0
	// Analog watchdog event occurred
	ADC_ISR_AWD3_B_0x1 = 0x1
	// Position of EOCAL field.
	ADC_ISR_EOCAL_Pos = 0xb
	// Bit mask of EOCAL field.
	ADC_ISR_EOCAL_Msk = 0x800
	// Bit EOCAL.
	ADC_ISR_EOCAL = 0x800
	// Calibration is not complete
	ADC_ISR_EOCAL_B_0x0 = 0x0
	// Calibration is complete
	ADC_ISR_EOCAL_B_0x1 = 0x1
	// Position of CCRDY field.
	ADC_ISR_CCRDY_Pos = 0xd
	// Bit mask of CCRDY field.
	ADC_ISR_CCRDY_Msk = 0x2000
	// Bit CCRDY.
	ADC_ISR_CCRDY = 0x2000
	// Channel configuration update not applied.
	ADC_ISR_CCRDY_B_0x0 = 0x0
	// Channel configuration update is applied.
	ADC_ISR_CCRDY_B_0x1 = 0x1

	// IER: ADC interrupt enable register
	// Position of ADRDYIE field.
	ADC_IER_ADRDYIE_Pos = 0x0
	// Bit mask of ADRDYIE field.
	ADC_IER_ADRDYIE_Msk = 0x1
	// Bit ADRDYIE.
	ADC_IER_ADRDYIE = 0x1
	// ADRDY interrupt disabled.
	ADC_IER_ADRDYIE_B_0x0 = 0x0
	// ADRDY interrupt enabled. An interrupt is generated when the ADRDY bit is set.
	ADC_IER_ADRDYIE_B_0x1 = 0x1
	// Position of EOSMPIE field.
	ADC_IER_EOSMPIE_Pos = 0x1
	// Bit mask of EOSMPIE field.
	ADC_IER_EOSMPIE_Msk = 0x2
	// Bit EOSMPIE.
	ADC_IER_EOSMPIE = 0x2
	// EOSMP interrupt disabled.
	ADC_IER_EOSMPIE_B_0x0 = 0x0
	// EOSMP interrupt enabled. An interrupt is generated when the EOSMP bit is set.
	ADC_IER_EOSMPIE_B_0x1 = 0x1
	// Position of EOCIE field.
	ADC_IER_EOCIE_Pos = 0x2
	// Bit mask of EOCIE field.
	ADC_IER_EOCIE_Msk = 0x4
	// Bit EOCIE.
	ADC_IER_EOCIE = 0x4
	// EOC interrupt disabled
	ADC_IER_EOCIE_B_0x0 = 0x0
	// EOC interrupt enabled. An interrupt is generated when the EOC bit is set.
	ADC_IER_EOCIE_B_0x1 = 0x1
	// Position of EOSIE field.
	ADC_IER_EOSIE_Pos = 0x3
	// Bit mask of EOSIE field.
	ADC_IER_EOSIE_Msk = 0x8
	// Bit EOSIE.
	ADC_IER_EOSIE = 0x8
	// EOS interrupt disabled
	ADC_IER_EOSIE_B_0x0 = 0x0
	// EOS interrupt enabled. An interrupt is generated when the EOS bit is set.
	ADC_IER_EOSIE_B_0x1 = 0x1
	// Position of OVRIE field.
	ADC_IER_OVRIE_Pos = 0x4
	// Bit mask of OVRIE field.
	ADC_IER_OVRIE_Msk = 0x10
	// Bit OVRIE.
	ADC_IER_OVRIE = 0x10
	// Overrun interrupt disabled
	ADC_IER_OVRIE_B_0x0 = 0x0
	// Overrun interrupt enabled. An interrupt is generated when the OVR bit is set.
	ADC_IER_OVRIE_B_0x1 = 0x1
	// Position of AWD1IE field.
	ADC_IER_AWD1IE_Pos = 0x7
	// Bit mask of AWD1IE field.
	ADC_IER_AWD1IE_Msk = 0x80
	// Bit AWD1IE.
	ADC_IER_AWD1IE = 0x80
	// Analog watchdog interrupt disabled
	ADC_IER_AWD1IE_B_0x0 = 0x0
	// Analog watchdog interrupt enabled
	ADC_IER_AWD1IE_B_0x1 = 0x1
	// Position of AWD2IE field.
	ADC_IER_AWD2IE_Pos = 0x8
	// Bit mask of AWD2IE field.
	ADC_IER_AWD2IE_Msk = 0x100
	// Bit AWD2IE.
	ADC_IER_AWD2IE = 0x100
	// Analog watchdog interrupt disabled
	ADC_IER_AWD2IE_B_0x0 = 0x0
	// Analog watchdog interrupt enabled
	ADC_IER_AWD2IE_B_0x1 = 0x1
	// Position of AWD3IE field.
	ADC_IER_AWD3IE_Pos = 0x9
	// Bit mask of AWD3IE field.
	ADC_IER_AWD3IE_Msk = 0x200
	// Bit AWD3IE.
	ADC_IER_AWD3IE = 0x200
	// Analog watchdog interrupt disabled
	ADC_IER_AWD3IE_B_0x0 = 0x0
	// Analog watchdog interrupt enabled
	ADC_IER_AWD3IE_B_0x1 = 0x1
	// Position of EOCALIE field.
	ADC_IER_EOCALIE_Pos = 0xb
	// Bit mask of EOCALIE field.
	ADC_IER_EOCALIE_Msk = 0x800
	// Bit EOCALIE.
	ADC_IER_EOCALIE = 0x800
	// End of calibration interrupt disabled
	ADC_IER_EOCALIE_B_0x0 = 0x0
	// End of calibration interrupt enabled
	ADC_IER_EOCALIE_B_0x1 = 0x1
	// Position of CCRDYIE field.
	ADC_IER_CCRDYIE_Pos = 0xd
	// Bit mask of CCRDYIE field.
	ADC_IER_CCRDYIE_Msk = 0x2000
	// Bit CCRDYIE.
	ADC_IER_CCRDYIE = 0x2000
	// Channel configuration ready interrupt disabled
	ADC_IER_CCRDYIE_B_0x0 = 0x0
	// Channel configuration ready interrupt enabled
	ADC_IER_CCRDYIE_B_0x1 = 0x1

	// CR: ADC control register
	// Position of ADEN field.
	ADC_CR_ADEN_Pos = 0x0
	// Bit mask of ADEN field.
	ADC_CR_ADEN_Msk = 0x1
	// Bit ADEN.
	ADC_CR_ADEN = 0x1
	// ADC is disabled (OFF state)
	ADC_CR_ADEN_B_0x0 = 0x0
	// Write 1 to enable the ADC.
	ADC_CR_ADEN_B_0x1 = 0x1
	// Position of ADDIS field.
	ADC_CR_ADDIS_Pos = 0x1
	// Bit mask of ADDIS field.
	ADC_CR_ADDIS_Msk = 0x2
	// Bit ADDIS.
	ADC_CR_ADDIS = 0x2
	// No ADDIS command ongoing
	ADC_CR_ADDIS_B_0x0 = 0x0
	// Write 1 to disable the ADC. Read 1 means that an ADDIS command is in progress.
	ADC_CR_ADDIS_B_0x1 = 0x1
	// Position of ADSTART field.
	ADC_CR_ADSTART_Pos = 0x2
	// Bit mask of ADSTART field.
	ADC_CR_ADSTART_Msk = 0x4
	// Bit ADSTART.
	ADC_CR_ADSTART = 0x4
	// No ADC conversion is ongoing.
	ADC_CR_ADSTART_B_0x0 = 0x0
	// Write 1 to start the ADC. Read 1 means that the ADC is operating and may be converting.
	ADC_CR_ADSTART_B_0x1 = 0x1
	// Position of ADSTP field.
	ADC_CR_ADSTP_Pos = 0x4
	// Bit mask of ADSTP field.
	ADC_CR_ADSTP_Msk = 0x10
	// Bit ADSTP.
	ADC_CR_ADSTP = 0x10
	// No ADC stop conversion command ongoing
	ADC_CR_ADSTP_B_0x0 = 0x0
	// Write 1 to stop the ADC. Read 1 means that an ADSTP command is in progress.
	ADC_CR_ADSTP_B_0x1 = 0x1
	// Position of ADVREGEN field.
	ADC_CR_ADVREGEN_Pos = 0x1c
	// Bit mask of ADVREGEN field.
	ADC_CR_ADVREGEN_Msk = 0x10000000
	// Bit ADVREGEN.
	ADC_CR_ADVREGEN = 0x10000000
	// ADC voltage regulator disabled
	ADC_CR_ADVREGEN_B_0x0 = 0x0
	// ADC voltage regulator enabled
	ADC_CR_ADVREGEN_B_0x1 = 0x1
	// Position of ADCAL field.
	ADC_CR_ADCAL_Pos = 0x1f
	// Bit mask of ADCAL field.
	ADC_CR_ADCAL_Msk = 0x80000000
	// Bit ADCAL.
	ADC_CR_ADCAL = 0x80000000
	// Calibration complete
	ADC_CR_ADCAL_B_0x0 = 0x0
	// Write 1 to calibrate the ADC. Read at 1 means that a calibration is in progress.
	ADC_CR_ADCAL_B_0x1 = 0x1

	// CFGR1: ADC configuration register 1
	// Position of DMAEN field.
	ADC_CFGR1_DMAEN_Pos = 0x0
	// Bit mask of DMAEN field.
	ADC_CFGR1_DMAEN_Msk = 0x1
	// Bit DMAEN.
	ADC_CFGR1_DMAEN = 0x1
	// DMA disabled
	ADC_CFGR1_DMAEN_B_0x0 = 0x0
	// DMA enabled
	ADC_CFGR1_DMAEN_B_0x1 = 0x1
	// Position of DMACFG field.
	ADC_CFGR1_DMACFG_Pos = 0x1
	// Bit mask of DMACFG field.
	ADC_CFGR1_DMACFG_Msk = 0x2
	// Bit DMACFG.
	ADC_CFGR1_DMACFG = 0x2
	// DMA one shot mode selected
	ADC_CFGR1_DMACFG_B_0x0 = 0x0
	// DMA circular mode selected
	ADC_CFGR1_DMACFG_B_0x1 = 0x1
	// Position of SCANDIR field.
	ADC_CFGR1_SCANDIR_Pos = 0x2
	// Bit mask of SCANDIR field.
	ADC_CFGR1_SCANDIR_Msk = 0x4
	// Bit SCANDIR.
	ADC_CFGR1_SCANDIR = 0x4
	// Upward scan (from CHSEL0 to CHSEL18)
	ADC_CFGR1_SCANDIR_B_0x0 = 0x0
	// Backward scan (from CHSEL18 to CHSEL0)
	ADC_CFGR1_SCANDIR_B_0x1 = 0x1
	// Position of RES field.
	ADC_CFGR1_RES_Pos = 0x3
	// Bit mask of RES field.
	ADC_CFGR1_RES_Msk = 0x18
	// 12 bits
	ADC_CFGR1_RES_B_0x0 = 0x0
	// 10 bits
	ADC_CFGR1_RES_B_0x1 = 0x1
	// 8 bits
	ADC_CFGR1_RES_B_0x2 = 0x2
	// 6 bits
	ADC_CFGR1_RES_B_0x3 = 0x3
	// Position of ALIGN field.
	ADC_CFGR1_ALIGN_Pos = 0x5
	// Bit mask of ALIGN field.
	ADC_CFGR1_ALIGN_Msk = 0x20
	// Bit ALIGN.
	ADC_CFGR1_ALIGN = 0x20
	// Right alignment
	ADC_CFGR1_ALIGN_B_0x0 = 0x0
	// Left alignment
	ADC_CFGR1_ALIGN_B_0x1 = 0x1
	// Position of EXTSEL field.
	ADC_CFGR1_EXTSEL_Pos = 0x6
	// Bit mask of EXTSEL field.
	ADC_CFGR1_EXTSEL_Msk = 0x1c0
	// TRG0
	ADC_CFGR1_EXTSEL_B_0x0 = 0x0
	// TRG1
	ADC_CFGR1_EXTSEL_B_0x1 = 0x1
	// TRG2
	ADC_CFGR1_EXTSEL_B_0x2 = 0x2
	// TRG3
	ADC_CFGR1_EXTSEL_B_0x3 = 0x3
	// TRG4
	ADC_CFGR1_EXTSEL_B_0x4 = 0x4
	// TRG5
	ADC_CFGR1_EXTSEL_B_0x5 = 0x5
	// TRG6
	ADC_CFGR1_EXTSEL_B_0x6 = 0x6
	// TRG7
	ADC_CFGR1_EXTSEL_B_0x7 = 0x7
	// Position of EXTEN field.
	ADC_CFGR1_EXTEN_Pos = 0xa
	// Bit mask of EXTEN field.
	ADC_CFGR1_EXTEN_Msk = 0xc00
	// Hardware trigger detection disabled (conversions can be started by software)
	ADC_CFGR1_EXTEN_B_0x0 = 0x0
	// Hardware trigger detection on the rising edge
	ADC_CFGR1_EXTEN_B_0x1 = 0x1
	// Hardware trigger detection on the falling edge
	ADC_CFGR1_EXTEN_B_0x2 = 0x2
	// Hardware trigger detection on both the rising and falling edges
	ADC_CFGR1_EXTEN_B_0x3 = 0x3
	// Position of OVRMOD field.
	ADC_CFGR1_OVRMOD_Pos = 0xc
	// Bit mask of OVRMOD field.
	ADC_CFGR1_OVRMOD_Msk = 0x1000
	// Bit OVRMOD.
	ADC_CFGR1_OVRMOD = 0x1000
	// ADC_DR register is preserved with the old data when an overrun is detected.
	ADC_CFGR1_OVRMOD_B_0x0 = 0x0
	// ADC_DR register is overwritten with the last conversion result when an overrun is detected.
	ADC_CFGR1_OVRMOD_B_0x1 = 0x1
	// Position of CONT field.
	ADC_CFGR1_CONT_Pos = 0xd
	// Bit mask of CONT field.
	ADC_CFGR1_CONT_Msk = 0x2000
	// Bit CONT.
	ADC_CFGR1_CONT = 0x2000
	// Single conversion mode
	ADC_CFGR1_CONT_B_0x0 = 0x0
	// Continuous conversion mode
	ADC_CFGR1_CONT_B_0x1 = 0x1
	// Position of WAIT field.
	ADC_CFGR1_WAIT_Pos = 0xe
	// Bit mask of WAIT field.
	ADC_CFGR1_WAIT_Msk = 0x4000
	// Bit WAIT.
	ADC_CFGR1_WAIT = 0x4000
	// Wait conversion mode off
	ADC_CFGR1_WAIT_B_0x0 = 0x0
	// Wait conversion mode on
	ADC_CFGR1_WAIT_B_0x1 = 0x1
	// Position of AUTOFF field.
	ADC_CFGR1_AUTOFF_Pos = 0xf
	// Bit mask of AUTOFF field.
	ADC_CFGR1_AUTOFF_Msk = 0x8000
	// Bit AUTOFF.
	ADC_CFGR1_AUTOFF = 0x8000
	// Auto-off mode disabled
	ADC_CFGR1_AUTOFF_B_0x0 = 0x0
	// Auto-off mode enabled
	ADC_CFGR1_AUTOFF_B_0x1 = 0x1
	// Position of DISCEN field.
	ADC_CFGR1_DISCEN_Pos = 0x10
	// Bit mask of DISCEN field.
	ADC_CFGR1_DISCEN_Msk = 0x10000
	// Bit DISCEN.
	ADC_CFGR1_DISCEN = 0x10000
	// Discontinuous mode disabled
	ADC_CFGR1_DISCEN_B_0x0 = 0x0
	// Discontinuous mode enabled
	ADC_CFGR1_DISCEN_B_0x1 = 0x1
	// Position of CHSELRMOD field.
	ADC_CFGR1_CHSELRMOD_Pos = 0x15
	// Bit mask of CHSELRMOD field.
	ADC_CFGR1_CHSELRMOD_Msk = 0x200000
	// Bit CHSELRMOD.
	ADC_CFGR1_CHSELRMOD = 0x200000
	// Each bit of the ADC_CHSELR register enables an input
	ADC_CFGR1_CHSELRMOD_B_0x0 = 0x0
	// ADC_CHSELR register is able to sequence up to 8 channels
	ADC_CFGR1_CHSELRMOD_B_0x1 = 0x1
	// Position of AWD1SGL field.
	ADC_CFGR1_AWD1SGL_Pos = 0x16
	// Bit mask of AWD1SGL field.
	ADC_CFGR1_AWD1SGL_Msk = 0x400000
	// Bit AWD1SGL.
	ADC_CFGR1_AWD1SGL = 0x400000
	// Analog watchdog 1 enabled on all channels
	ADC_CFGR1_AWD1SGL_B_0x0 = 0x0
	// Analog watchdog 1 enabled on a single channel
	ADC_CFGR1_AWD1SGL_B_0x1 = 0x1
	// Position of AWD1EN field.
	ADC_CFGR1_AWD1EN_Pos = 0x17
	// Bit mask of AWD1EN field.
	ADC_CFGR1_AWD1EN_Msk = 0x800000
	// Bit AWD1EN.
	ADC_CFGR1_AWD1EN = 0x800000
	// Analog watchdog 1 disabled
	ADC_CFGR1_AWD1EN_B_0x0 = 0x0
	// Analog watchdog 1 enabled
	ADC_CFGR1_AWD1EN_B_0x1 = 0x1
	// Position of AWD1CH field.
	ADC_CFGR1_AWD1CH_Pos = 0x1a
	// Bit mask of AWD1CH field.
	ADC_CFGR1_AWD1CH_Msk = 0x7c000000
	// ADC analog input Channel 0 monitored by AWD
	ADC_CFGR1_AWD1CH_B_0x0 = 0x0
	// ADC analog input Channel 1 monitored by AWD
	ADC_CFGR1_AWD1CH_B_0x1 = 0x1
	// ADC analog input Channel 17 monitored by AWD
	ADC_CFGR1_AWD1CH_B_0x11 = 0x11
	// ADC analog input Channel 18 monitored by AWD
	ADC_CFGR1_AWD1CH_B_0x12 = 0x12

	// CFGR2: ADC configuration register 2
	// Position of OVSE field.
	ADC_CFGR2_OVSE_Pos = 0x0
	// Bit mask of OVSE field.
	ADC_CFGR2_OVSE_Msk = 0x1
	// Bit OVSE.
	ADC_CFGR2_OVSE = 0x1
	// Oversampler disabled
	ADC_CFGR2_OVSE_B_0x0 = 0x0
	// Oversampler enabled
	ADC_CFGR2_OVSE_B_0x1 = 0x1
	// Position of OVSR field.
	ADC_CFGR2_OVSR_Pos = 0x2
	// Bit mask of OVSR field.
	ADC_CFGR2_OVSR_Msk = 0x1c
	// 2x
	ADC_CFGR2_OVSR_B_0x0 = 0x0
	// 4x
	ADC_CFGR2_OVSR_B_0x1 = 0x1
	// 8x
	ADC_CFGR2_OVSR_B_0x2 = 0x2
	// 16x
	ADC_CFGR2_OVSR_B_0x3 = 0x3
	// 32x
	ADC_CFGR2_OVSR_B_0x4 = 0x4
	// 64x
	ADC_CFGR2_OVSR_B_0x5 = 0x5
	// 128x
	ADC_CFGR2_OVSR_B_0x6 = 0x6
	// 256x
	ADC_CFGR2_OVSR_B_0x7 = 0x7
	// Position of OVSS field.
	ADC_CFGR2_OVSS_Pos = 0x5
	// Bit mask of OVSS field.
	ADC_CFGR2_OVSS_Msk = 0x1e0
	// No shift
	ADC_CFGR2_OVSS_B_0x0 = 0x0
	// Shift 1-bit
	ADC_CFGR2_OVSS_B_0x1 = 0x1
	// Shift 2-bits
	ADC_CFGR2_OVSS_B_0x2 = 0x2
	// Shift 3-bits
	ADC_CFGR2_OVSS_B_0x3 = 0x3
	// Shift 4-bits
	ADC_CFGR2_OVSS_B_0x4 = 0x4
	// Shift 5-bits
	ADC_CFGR2_OVSS_B_0x5 = 0x5
	// Shift 6-bits
	ADC_CFGR2_OVSS_B_0x6 = 0x6
	// Shift 7-bits
	ADC_CFGR2_OVSS_B_0x7 = 0x7
	// Shift 8-bits
	ADC_CFGR2_OVSS_B_0x8 = 0x8
	// Position of TOVS field.
	ADC_CFGR2_TOVS_Pos = 0x9
	// Bit mask of TOVS field.
	ADC_CFGR2_TOVS_Msk = 0x200
	// Bit TOVS.
	ADC_CFGR2_TOVS = 0x200
	// All oversampled conversions for a channel are done consecutively after a trigger
	ADC_CFGR2_TOVS_B_0x0 = 0x0
	// Each oversampled conversion for a channel needs a trigger
	ADC_CFGR2_TOVS_B_0x1 = 0x1
	// Position of LFTRIG field.
	ADC_CFGR2_LFTRIG_Pos = 0x1d
	// Bit mask of LFTRIG field.
	ADC_CFGR2_LFTRIG_Msk = 0x20000000
	// Bit LFTRIG.
	ADC_CFGR2_LFTRIG = 0x20000000
	// Low Frequency Trigger Mode disabled
	ADC_CFGR2_LFTRIG_B_0x0 = 0x0
	// Low Frequency Trigger Mode enabled
	ADC_CFGR2_LFTRIG_B_0x1 = 0x1
	// Position of CKMODE field.
	ADC_CFGR2_CKMODE_Pos = 0x1e
	// Bit mask of CKMODE field.
	ADC_CFGR2_CKMODE_Msk = 0xc0000000
	// ADCCLK (Asynchronous clock mode), generated at product level (refer to RCC section)
	ADC_CFGR2_CKMODE_B_0x0 = 0x0
	// PCLK/2 (Synchronous clock mode)
	ADC_CFGR2_CKMODE_B_0x1 = 0x1
	// PCLK/4 (Synchronous clock mode)
	ADC_CFGR2_CKMODE_B_0x2 = 0x2
	// PCLK (Synchronous clock mode). This configuration must be enabled only if PCLK has a 50% duty clock cycle (APB prescaler configured inside the RCC must be bypassed and the system clock must by 50% duty cycle)
	ADC_CFGR2_CKMODE_B_0x3 = 0x3

	// SMPR: ADC sampling time register
	// Position of SMP1 field.
	ADC_SMPR_SMP1_Pos = 0x0
	// Bit mask of SMP1 field.
	ADC_SMPR_SMP1_Msk = 0x7
	// 1.5 ADC clock cycles
	ADC_SMPR_SMP1_B_0x0 = 0x0
	// 3.5 ADC clock cycles
	ADC_SMPR_SMP1_B_0x1 = 0x1
	// 7.5 ADC clock cycles
	ADC_SMPR_SMP1_B_0x2 = 0x2
	// 12.5 ADC clock cycles
	ADC_SMPR_SMP1_B_0x3 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR_SMP1_B_0x4 = 0x4
	// 39.5 ADC clock cycles
	ADC_SMPR_SMP1_B_0x5 = 0x5
	// 79.5 ADC clock cycles
	ADC_SMPR_SMP1_B_0x6 = 0x6
	// 160.5 ADC clock cycles
	ADC_SMPR_SMP1_B_0x7 = 0x7
	// Position of SMP2 field.
	ADC_SMPR_SMP2_Pos = 0x4
	// Bit mask of SMP2 field.
	ADC_SMPR_SMP2_Msk = 0x70
	// 1.5 ADC clock cycles
	ADC_SMPR_SMP2_B_0x0 = 0x0
	// 3.5 ADC clock cycles
	ADC_SMPR_SMP2_B_0x1 = 0x1
	// 7.5 ADC clock cycles
	ADC_SMPR_SMP2_B_0x2 = 0x2
	// 12.5 ADC clock cycles
	ADC_SMPR_SMP2_B_0x3 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR_SMP2_B_0x4 = 0x4
	// 39.5 ADC clock cycles
	ADC_SMPR_SMP2_B_0x5 = 0x5
	// 79.5 ADC clock cycles
	ADC_SMPR_SMP2_B_0x6 = 0x6
	// 160.5 ADC clock cycles
	ADC_SMPR_SMP2_B_0x7 = 0x7
	// Position of SMPSEL0 field.
	ADC_SMPR_SMPSEL0_Pos = 0x8
	// Bit mask of SMPSEL0 field.
	ADC_SMPR_SMPSEL0_Msk = 0x100
	// Bit SMPSEL0.
	ADC_SMPR_SMPSEL0 = 0x100
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL0_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL0_B_0x1 = 0x1
	// Position of SMPSEL1 field.
	ADC_SMPR_SMPSEL1_Pos = 0x9
	// Bit mask of SMPSEL1 field.
	ADC_SMPR_SMPSEL1_Msk = 0x200
	// Bit SMPSEL1.
	ADC_SMPR_SMPSEL1 = 0x200
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL1_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL1_B_0x1 = 0x1
	// Position of SMPSEL2 field.
	ADC_SMPR_SMPSEL2_Pos = 0xa
	// Bit mask of SMPSEL2 field.
	ADC_SMPR_SMPSEL2_Msk = 0x400
	// Bit SMPSEL2.
	ADC_SMPR_SMPSEL2 = 0x400
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL2_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL2_B_0x1 = 0x1
	// Position of SMPSEL3 field.
	ADC_SMPR_SMPSEL3_Pos = 0xb
	// Bit mask of SMPSEL3 field.
	ADC_SMPR_SMPSEL3_Msk = 0x800
	// Bit SMPSEL3.
	ADC_SMPR_SMPSEL3 = 0x800
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL3_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL3_B_0x1 = 0x1
	// Position of SMPSEL4 field.
	ADC_SMPR_SMPSEL4_Pos = 0xc
	// Bit mask of SMPSEL4 field.
	ADC_SMPR_SMPSEL4_Msk = 0x1000
	// Bit SMPSEL4.
	ADC_SMPR_SMPSEL4 = 0x1000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL4_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL4_B_0x1 = 0x1
	// Position of SMPSEL5 field.
	ADC_SMPR_SMPSEL5_Pos = 0xd
	// Bit mask of SMPSEL5 field.
	ADC_SMPR_SMPSEL5_Msk = 0x2000
	// Bit SMPSEL5.
	ADC_SMPR_SMPSEL5 = 0x2000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL5_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL5_B_0x1 = 0x1
	// Position of SMPSEL6 field.
	ADC_SMPR_SMPSEL6_Pos = 0xe
	// Bit mask of SMPSEL6 field.
	ADC_SMPR_SMPSEL6_Msk = 0x4000
	// Bit SMPSEL6.
	ADC_SMPR_SMPSEL6 = 0x4000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL6_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL6_B_0x1 = 0x1
	// Position of SMPSEL7 field.
	ADC_SMPR_SMPSEL7_Pos = 0xf
	// Bit mask of SMPSEL7 field.
	ADC_SMPR_SMPSEL7_Msk = 0x8000
	// Bit SMPSEL7.
	ADC_SMPR_SMPSEL7 = 0x8000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL7_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL7_B_0x1 = 0x1
	// Position of SMPSEL8 field.
	ADC_SMPR_SMPSEL8_Pos = 0x10
	// Bit mask of SMPSEL8 field.
	ADC_SMPR_SMPSEL8_Msk = 0x10000
	// Bit SMPSEL8.
	ADC_SMPR_SMPSEL8 = 0x10000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL8_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL8_B_0x1 = 0x1
	// Position of SMPSEL9 field.
	ADC_SMPR_SMPSEL9_Pos = 0x11
	// Bit mask of SMPSEL9 field.
	ADC_SMPR_SMPSEL9_Msk = 0x20000
	// Bit SMPSEL9.
	ADC_SMPR_SMPSEL9 = 0x20000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL9_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL9_B_0x1 = 0x1
	// Position of SMPSEL10 field.
	ADC_SMPR_SMPSEL10_Pos = 0x12
	// Bit mask of SMPSEL10 field.
	ADC_SMPR_SMPSEL10_Msk = 0x40000
	// Bit SMPSEL10.
	ADC_SMPR_SMPSEL10 = 0x40000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL10_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL10_B_0x1 = 0x1
	// Position of SMPSEL11 field.
	ADC_SMPR_SMPSEL11_Pos = 0x13
	// Bit mask of SMPSEL11 field.
	ADC_SMPR_SMPSEL11_Msk = 0x80000
	// Bit SMPSEL11.
	ADC_SMPR_SMPSEL11 = 0x80000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL11_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL11_B_0x1 = 0x1
	// Position of SMPSEL12 field.
	ADC_SMPR_SMPSEL12_Pos = 0x14
	// Bit mask of SMPSEL12 field.
	ADC_SMPR_SMPSEL12_Msk = 0x100000
	// Bit SMPSEL12.
	ADC_SMPR_SMPSEL12 = 0x100000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL12_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL12_B_0x1 = 0x1
	// Position of SMPSEL13 field.
	ADC_SMPR_SMPSEL13_Pos = 0x15
	// Bit mask of SMPSEL13 field.
	ADC_SMPR_SMPSEL13_Msk = 0x200000
	// Bit SMPSEL13.
	ADC_SMPR_SMPSEL13 = 0x200000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL13_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL13_B_0x1 = 0x1
	// Position of SMPSEL14 field.
	ADC_SMPR_SMPSEL14_Pos = 0x16
	// Bit mask of SMPSEL14 field.
	ADC_SMPR_SMPSEL14_Msk = 0x400000
	// Bit SMPSEL14.
	ADC_SMPR_SMPSEL14 = 0x400000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL14_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL14_B_0x1 = 0x1
	// Position of SMPSEL15 field.
	ADC_SMPR_SMPSEL15_Pos = 0x17
	// Bit mask of SMPSEL15 field.
	ADC_SMPR_SMPSEL15_Msk = 0x800000
	// Bit SMPSEL15.
	ADC_SMPR_SMPSEL15 = 0x800000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL15_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL15_B_0x1 = 0x1
	// Position of SMPSEL16 field.
	ADC_SMPR_SMPSEL16_Pos = 0x18
	// Bit mask of SMPSEL16 field.
	ADC_SMPR_SMPSEL16_Msk = 0x1000000
	// Bit SMPSEL16.
	ADC_SMPR_SMPSEL16 = 0x1000000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL16_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL16_B_0x1 = 0x1
	// Position of SMPSEL17 field.
	ADC_SMPR_SMPSEL17_Pos = 0x19
	// Bit mask of SMPSEL17 field.
	ADC_SMPR_SMPSEL17_Msk = 0x2000000
	// Bit SMPSEL17.
	ADC_SMPR_SMPSEL17 = 0x2000000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL17_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL17_B_0x1 = 0x1
	// Position of SMPSEL18 field.
	ADC_SMPR_SMPSEL18_Pos = 0x1a
	// Bit mask of SMPSEL18 field.
	ADC_SMPR_SMPSEL18_Msk = 0x4000000
	// Bit SMPSEL18.
	ADC_SMPR_SMPSEL18 = 0x4000000
	// Sampling time of CHANNELx use the setting of SMP1[2:0] register.
	ADC_SMPR_SMPSEL18_B_0x0 = 0x0
	// Sampling time of CHANNELx use the setting of SMP2[2:0] register.
	ADC_SMPR_SMPSEL18_B_0x1 = 0x1

	// AWD1TR: ADC watchdog threshold register
	// Position of LT1 field.
	ADC_AWD1TR_LT1_Pos = 0x0
	// Bit mask of LT1 field.
	ADC_AWD1TR_LT1_Msk = 0xfff
	// Position of HT1 field.
	ADC_AWD1TR_HT1_Pos = 0x10
	// Bit mask of HT1 field.
	ADC_AWD1TR_HT1_Msk = 0xfff0000

	// AWD2TR: ADC watchdog threshold register
	// Position of LT2 field.
	ADC_AWD2TR_LT2_Pos = 0x0
	// Bit mask of LT2 field.
	ADC_AWD2TR_LT2_Msk = 0xfff
	// Position of HT2 field.
	ADC_AWD2TR_HT2_Pos = 0x10
	// Bit mask of HT2 field.
	ADC_AWD2TR_HT2_Msk = 0xfff0000

	// CHSELR: ADC channel selection register [alternate]
	// Position of CHSEL0 field.
	ADC_CHSELR_CHSEL0_Pos = 0x0
	// Bit mask of CHSEL0 field.
	ADC_CHSELR_CHSEL0_Msk = 0x1
	// Bit CHSEL0.
	ADC_CHSELR_CHSEL0 = 0x1
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL0_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL0_B_0x1 = 0x1
	// Position of CHSEL1 field.
	ADC_CHSELR_CHSEL1_Pos = 0x1
	// Bit mask of CHSEL1 field.
	ADC_CHSELR_CHSEL1_Msk = 0x2
	// Bit CHSEL1.
	ADC_CHSELR_CHSEL1 = 0x2
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL1_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL1_B_0x1 = 0x1
	// Position of CHSEL2 field.
	ADC_CHSELR_CHSEL2_Pos = 0x2
	// Bit mask of CHSEL2 field.
	ADC_CHSELR_CHSEL2_Msk = 0x4
	// Bit CHSEL2.
	ADC_CHSELR_CHSEL2 = 0x4
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL2_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL2_B_0x1 = 0x1
	// Position of CHSEL3 field.
	ADC_CHSELR_CHSEL3_Pos = 0x3
	// Bit mask of CHSEL3 field.
	ADC_CHSELR_CHSEL3_Msk = 0x8
	// Bit CHSEL3.
	ADC_CHSELR_CHSEL3 = 0x8
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL3_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL3_B_0x1 = 0x1
	// Position of CHSEL4 field.
	ADC_CHSELR_CHSEL4_Pos = 0x4
	// Bit mask of CHSEL4 field.
	ADC_CHSELR_CHSEL4_Msk = 0x10
	// Bit CHSEL4.
	ADC_CHSELR_CHSEL4 = 0x10
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL4_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL4_B_0x1 = 0x1
	// Position of CHSEL5 field.
	ADC_CHSELR_CHSEL5_Pos = 0x5
	// Bit mask of CHSEL5 field.
	ADC_CHSELR_CHSEL5_Msk = 0x20
	// Bit CHSEL5.
	ADC_CHSELR_CHSEL5 = 0x20
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL5_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL5_B_0x1 = 0x1
	// Position of CHSEL6 field.
	ADC_CHSELR_CHSEL6_Pos = 0x6
	// Bit mask of CHSEL6 field.
	ADC_CHSELR_CHSEL6_Msk = 0x40
	// Bit CHSEL6.
	ADC_CHSELR_CHSEL6 = 0x40
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL6_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL6_B_0x1 = 0x1
	// Position of CHSEL7 field.
	ADC_CHSELR_CHSEL7_Pos = 0x7
	// Bit mask of CHSEL7 field.
	ADC_CHSELR_CHSEL7_Msk = 0x80
	// Bit CHSEL7.
	ADC_CHSELR_CHSEL7 = 0x80
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL7_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL7_B_0x1 = 0x1
	// Position of CHSEL8 field.
	ADC_CHSELR_CHSEL8_Pos = 0x8
	// Bit mask of CHSEL8 field.
	ADC_CHSELR_CHSEL8_Msk = 0x100
	// Bit CHSEL8.
	ADC_CHSELR_CHSEL8 = 0x100
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL8_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL8_B_0x1 = 0x1
	// Position of CHSEL9 field.
	ADC_CHSELR_CHSEL9_Pos = 0x9
	// Bit mask of CHSEL9 field.
	ADC_CHSELR_CHSEL9_Msk = 0x200
	// Bit CHSEL9.
	ADC_CHSELR_CHSEL9 = 0x200
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL9_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL9_B_0x1 = 0x1
	// Position of CHSEL10 field.
	ADC_CHSELR_CHSEL10_Pos = 0xa
	// Bit mask of CHSEL10 field.
	ADC_CHSELR_CHSEL10_Msk = 0x400
	// Bit CHSEL10.
	ADC_CHSELR_CHSEL10 = 0x400
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL10_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL10_B_0x1 = 0x1
	// Position of CHSEL11 field.
	ADC_CHSELR_CHSEL11_Pos = 0xb
	// Bit mask of CHSEL11 field.
	ADC_CHSELR_CHSEL11_Msk = 0x800
	// Bit CHSEL11.
	ADC_CHSELR_CHSEL11 = 0x800
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL11_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL11_B_0x1 = 0x1
	// Position of CHSEL12 field.
	ADC_CHSELR_CHSEL12_Pos = 0xc
	// Bit mask of CHSEL12 field.
	ADC_CHSELR_CHSEL12_Msk = 0x1000
	// Bit CHSEL12.
	ADC_CHSELR_CHSEL12 = 0x1000
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL12_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL12_B_0x1 = 0x1
	// Position of CHSEL13 field.
	ADC_CHSELR_CHSEL13_Pos = 0xd
	// Bit mask of CHSEL13 field.
	ADC_CHSELR_CHSEL13_Msk = 0x2000
	// Bit CHSEL13.
	ADC_CHSELR_CHSEL13 = 0x2000
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL13_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL13_B_0x1 = 0x1
	// Position of CHSEL14 field.
	ADC_CHSELR_CHSEL14_Pos = 0xe
	// Bit mask of CHSEL14 field.
	ADC_CHSELR_CHSEL14_Msk = 0x4000
	// Bit CHSEL14.
	ADC_CHSELR_CHSEL14 = 0x4000
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL14_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL14_B_0x1 = 0x1
	// Position of CHSEL15 field.
	ADC_CHSELR_CHSEL15_Pos = 0xf
	// Bit mask of CHSEL15 field.
	ADC_CHSELR_CHSEL15_Msk = 0x8000
	// Bit CHSEL15.
	ADC_CHSELR_CHSEL15 = 0x8000
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL15_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL15_B_0x1 = 0x1
	// Position of CHSEL16 field.
	ADC_CHSELR_CHSEL16_Pos = 0x10
	// Bit mask of CHSEL16 field.
	ADC_CHSELR_CHSEL16_Msk = 0x10000
	// Bit CHSEL16.
	ADC_CHSELR_CHSEL16 = 0x10000
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL16_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL16_B_0x1 = 0x1
	// Position of CHSEL17 field.
	ADC_CHSELR_CHSEL17_Pos = 0x11
	// Bit mask of CHSEL17 field.
	ADC_CHSELR_CHSEL17_Msk = 0x20000
	// Bit CHSEL17.
	ADC_CHSELR_CHSEL17 = 0x20000
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL17_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL17_B_0x1 = 0x1
	// Position of CHSEL18 field.
	ADC_CHSELR_CHSEL18_Pos = 0x12
	// Bit mask of CHSEL18 field.
	ADC_CHSELR_CHSEL18_Msk = 0x40000
	// Bit CHSEL18.
	ADC_CHSELR_CHSEL18 = 0x40000
	// Input Channel-x is not selected for conversion
	ADC_CHSELR_CHSEL18_B_0x0 = 0x0
	// Input Channel-x is selected for conversion
	ADC_CHSELR_CHSEL18_B_0x1 = 0x1

	// CHSELR_1: channel selection register CHSELRMOD = 1 in ADC_CFGR1
	// Position of SQ1 field.
	ADC_CHSELR_1_SQ1_Pos = 0x0
	// Bit mask of SQ1 field.
	ADC_CHSELR_1_SQ1_Msk = 0xf
	// Position of SQ2 field.
	ADC_CHSELR_1_SQ2_Pos = 0x4
	// Bit mask of SQ2 field.
	ADC_CHSELR_1_SQ2_Msk = 0xf0
	// Position of SQ3 field.
	ADC_CHSELR_1_SQ3_Pos = 0x8
	// Bit mask of SQ3 field.
	ADC_CHSELR_1_SQ3_Msk = 0xf00
	// Position of SQ4 field.
	ADC_CHSELR_1_SQ4_Pos = 0xc
	// Bit mask of SQ4 field.
	ADC_CHSELR_1_SQ4_Msk = 0xf000
	// Position of SQ5 field.
	ADC_CHSELR_1_SQ5_Pos = 0x10
	// Bit mask of SQ5 field.
	ADC_CHSELR_1_SQ5_Msk = 0xf0000
	// Position of SQ6 field.
	ADC_CHSELR_1_SQ6_Pos = 0x14
	// Bit mask of SQ6 field.
	ADC_CHSELR_1_SQ6_Msk = 0xf00000
	// Position of SQ7 field.
	ADC_CHSELR_1_SQ7_Pos = 0x18
	// Bit mask of SQ7 field.
	ADC_CHSELR_1_SQ7_Msk = 0xf000000
	// Position of SQ8 field.
	ADC_CHSELR_1_SQ8_Pos = 0x1c
	// Bit mask of SQ8 field.
	ADC_CHSELR_1_SQ8_Msk = 0xf0000000
	// CH0
	ADC_CHSELR_1_SQ8_B_0x0 = 0x0
	// CH1
	ADC_CHSELR_1_SQ8_B_0x1 = 0x1
	// CH12
	ADC_CHSELR_1_SQ8_B_0xC = 0xc
	// CH13
	ADC_CHSELR_1_SQ8_B_0xD = 0xd
	// CH14
	ADC_CHSELR_1_SQ8_B_0xE = 0xe
	// No channel selected (End of sequence)
	ADC_CHSELR_1_SQ8_B_0xF = 0xf

	// AWD3TR: ADC watchdog threshold register
	// Position of LT3 field.
	ADC_AWD3TR_LT3_Pos = 0x0
	// Bit mask of LT3 field.
	ADC_AWD3TR_LT3_Msk = 0xfff
	// Position of HT3 field.
	ADC_AWD3TR_HT3_Pos = 0x10
	// Bit mask of HT3 field.
	ADC_AWD3TR_HT3_Msk = 0xfff0000

	// DR: ADC data register
	// Position of DATA field.
	ADC_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_DR_DATA_Msk = 0xffff

	// AWD2CR: ADC Analog Watchdog 2 Configuration register
	// Position of AWD2CH0 field.
	ADC_AWD2CR_AWD2CH0_Pos = 0x0
	// Bit mask of AWD2CH0 field.
	ADC_AWD2CR_AWD2CH0_Msk = 0x1
	// Bit AWD2CH0.
	ADC_AWD2CR_AWD2CH0 = 0x1
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH0_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH0_B_0x1 = 0x1
	// Position of AWD2CH1 field.
	ADC_AWD2CR_AWD2CH1_Pos = 0x1
	// Bit mask of AWD2CH1 field.
	ADC_AWD2CR_AWD2CH1_Msk = 0x2
	// Bit AWD2CH1.
	ADC_AWD2CR_AWD2CH1 = 0x2
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH1_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH1_B_0x1 = 0x1
	// Position of AWD2CH2 field.
	ADC_AWD2CR_AWD2CH2_Pos = 0x2
	// Bit mask of AWD2CH2 field.
	ADC_AWD2CR_AWD2CH2_Msk = 0x4
	// Bit AWD2CH2.
	ADC_AWD2CR_AWD2CH2 = 0x4
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH2_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH2_B_0x1 = 0x1
	// Position of AWD2CH3 field.
	ADC_AWD2CR_AWD2CH3_Pos = 0x3
	// Bit mask of AWD2CH3 field.
	ADC_AWD2CR_AWD2CH3_Msk = 0x8
	// Bit AWD2CH3.
	ADC_AWD2CR_AWD2CH3 = 0x8
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH3_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH3_B_0x1 = 0x1
	// Position of AWD2CH4 field.
	ADC_AWD2CR_AWD2CH4_Pos = 0x4
	// Bit mask of AWD2CH4 field.
	ADC_AWD2CR_AWD2CH4_Msk = 0x10
	// Bit AWD2CH4.
	ADC_AWD2CR_AWD2CH4 = 0x10
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH4_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH4_B_0x1 = 0x1
	// Position of AWD2CH5 field.
	ADC_AWD2CR_AWD2CH5_Pos = 0x5
	// Bit mask of AWD2CH5 field.
	ADC_AWD2CR_AWD2CH5_Msk = 0x20
	// Bit AWD2CH5.
	ADC_AWD2CR_AWD2CH5 = 0x20
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH5_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH5_B_0x1 = 0x1
	// Position of AWD2CH6 field.
	ADC_AWD2CR_AWD2CH6_Pos = 0x6
	// Bit mask of AWD2CH6 field.
	ADC_AWD2CR_AWD2CH6_Msk = 0x40
	// Bit AWD2CH6.
	ADC_AWD2CR_AWD2CH6 = 0x40
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH6_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH6_B_0x1 = 0x1
	// Position of AWD2CH7 field.
	ADC_AWD2CR_AWD2CH7_Pos = 0x7
	// Bit mask of AWD2CH7 field.
	ADC_AWD2CR_AWD2CH7_Msk = 0x80
	// Bit AWD2CH7.
	ADC_AWD2CR_AWD2CH7 = 0x80
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH7_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH7_B_0x1 = 0x1
	// Position of AWD2CH8 field.
	ADC_AWD2CR_AWD2CH8_Pos = 0x8
	// Bit mask of AWD2CH8 field.
	ADC_AWD2CR_AWD2CH8_Msk = 0x100
	// Bit AWD2CH8.
	ADC_AWD2CR_AWD2CH8 = 0x100
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH8_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH8_B_0x1 = 0x1
	// Position of AWD2CH9 field.
	ADC_AWD2CR_AWD2CH9_Pos = 0x9
	// Bit mask of AWD2CH9 field.
	ADC_AWD2CR_AWD2CH9_Msk = 0x200
	// Bit AWD2CH9.
	ADC_AWD2CR_AWD2CH9 = 0x200
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH9_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH9_B_0x1 = 0x1
	// Position of AWD2CH10 field.
	ADC_AWD2CR_AWD2CH10_Pos = 0xa
	// Bit mask of AWD2CH10 field.
	ADC_AWD2CR_AWD2CH10_Msk = 0x400
	// Bit AWD2CH10.
	ADC_AWD2CR_AWD2CH10 = 0x400
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH10_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH10_B_0x1 = 0x1
	// Position of AWD2CH11 field.
	ADC_AWD2CR_AWD2CH11_Pos = 0xb
	// Bit mask of AWD2CH11 field.
	ADC_AWD2CR_AWD2CH11_Msk = 0x800
	// Bit AWD2CH11.
	ADC_AWD2CR_AWD2CH11 = 0x800
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH11_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH11_B_0x1 = 0x1
	// Position of AWD2CH12 field.
	ADC_AWD2CR_AWD2CH12_Pos = 0xc
	// Bit mask of AWD2CH12 field.
	ADC_AWD2CR_AWD2CH12_Msk = 0x1000
	// Bit AWD2CH12.
	ADC_AWD2CR_AWD2CH12 = 0x1000
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH12_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH12_B_0x1 = 0x1
	// Position of AWD2CH13 field.
	ADC_AWD2CR_AWD2CH13_Pos = 0xd
	// Bit mask of AWD2CH13 field.
	ADC_AWD2CR_AWD2CH13_Msk = 0x2000
	// Bit AWD2CH13.
	ADC_AWD2CR_AWD2CH13 = 0x2000
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH13_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH13_B_0x1 = 0x1
	// Position of AWD2CH14 field.
	ADC_AWD2CR_AWD2CH14_Pos = 0xe
	// Bit mask of AWD2CH14 field.
	ADC_AWD2CR_AWD2CH14_Msk = 0x4000
	// Bit AWD2CH14.
	ADC_AWD2CR_AWD2CH14 = 0x4000
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH14_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH14_B_0x1 = 0x1
	// Position of AWD2CH15 field.
	ADC_AWD2CR_AWD2CH15_Pos = 0xf
	// Bit mask of AWD2CH15 field.
	ADC_AWD2CR_AWD2CH15_Msk = 0x8000
	// Bit AWD2CH15.
	ADC_AWD2CR_AWD2CH15 = 0x8000
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH15_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH15_B_0x1 = 0x1
	// Position of AWD2CH16 field.
	ADC_AWD2CR_AWD2CH16_Pos = 0x10
	// Bit mask of AWD2CH16 field.
	ADC_AWD2CR_AWD2CH16_Msk = 0x10000
	// Bit AWD2CH16.
	ADC_AWD2CR_AWD2CH16 = 0x10000
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH16_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH16_B_0x1 = 0x1
	// Position of AWD2CH17 field.
	ADC_AWD2CR_AWD2CH17_Pos = 0x11
	// Bit mask of AWD2CH17 field.
	ADC_AWD2CR_AWD2CH17_Msk = 0x20000
	// Bit AWD2CH17.
	ADC_AWD2CR_AWD2CH17 = 0x20000
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH17_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH17_B_0x1 = 0x1
	// Position of AWD2CH18 field.
	ADC_AWD2CR_AWD2CH18_Pos = 0x12
	// Bit mask of AWD2CH18 field.
	ADC_AWD2CR_AWD2CH18_Msk = 0x40000
	// Bit AWD2CH18.
	ADC_AWD2CR_AWD2CH18 = 0x40000
	// ADC analog channel-x is not monitored by AWD2
	ADC_AWD2CR_AWD2CH18_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD2
	ADC_AWD2CR_AWD2CH18_B_0x1 = 0x1

	// AWD3CR: ADC Analog Watchdog 3 Configuration register
	// Position of AWD3CH0 field.
	ADC_AWD3CR_AWD3CH0_Pos = 0x0
	// Bit mask of AWD3CH0 field.
	ADC_AWD3CR_AWD3CH0_Msk = 0x1
	// Bit AWD3CH0.
	ADC_AWD3CR_AWD3CH0 = 0x1
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH0_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH0_B_0x1 = 0x1
	// Position of AWD3CH1 field.
	ADC_AWD3CR_AWD3CH1_Pos = 0x1
	// Bit mask of AWD3CH1 field.
	ADC_AWD3CR_AWD3CH1_Msk = 0x2
	// Bit AWD3CH1.
	ADC_AWD3CR_AWD3CH1 = 0x2
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH1_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH1_B_0x1 = 0x1
	// Position of AWD3CH2 field.
	ADC_AWD3CR_AWD3CH2_Pos = 0x2
	// Bit mask of AWD3CH2 field.
	ADC_AWD3CR_AWD3CH2_Msk = 0x4
	// Bit AWD3CH2.
	ADC_AWD3CR_AWD3CH2 = 0x4
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH2_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH2_B_0x1 = 0x1
	// Position of AWD3CH3 field.
	ADC_AWD3CR_AWD3CH3_Pos = 0x3
	// Bit mask of AWD3CH3 field.
	ADC_AWD3CR_AWD3CH3_Msk = 0x8
	// Bit AWD3CH3.
	ADC_AWD3CR_AWD3CH3 = 0x8
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH3_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH3_B_0x1 = 0x1
	// Position of AWD3CH4 field.
	ADC_AWD3CR_AWD3CH4_Pos = 0x4
	// Bit mask of AWD3CH4 field.
	ADC_AWD3CR_AWD3CH4_Msk = 0x10
	// Bit AWD3CH4.
	ADC_AWD3CR_AWD3CH4 = 0x10
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH4_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH4_B_0x1 = 0x1
	// Position of AWD3CH5 field.
	ADC_AWD3CR_AWD3CH5_Pos = 0x5
	// Bit mask of AWD3CH5 field.
	ADC_AWD3CR_AWD3CH5_Msk = 0x20
	// Bit AWD3CH5.
	ADC_AWD3CR_AWD3CH5 = 0x20
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH5_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH5_B_0x1 = 0x1
	// Position of AWD3CH6 field.
	ADC_AWD3CR_AWD3CH6_Pos = 0x6
	// Bit mask of AWD3CH6 field.
	ADC_AWD3CR_AWD3CH6_Msk = 0x40
	// Bit AWD3CH6.
	ADC_AWD3CR_AWD3CH6 = 0x40
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH6_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH6_B_0x1 = 0x1
	// Position of AWD3CH7 field.
	ADC_AWD3CR_AWD3CH7_Pos = 0x7
	// Bit mask of AWD3CH7 field.
	ADC_AWD3CR_AWD3CH7_Msk = 0x80
	// Bit AWD3CH7.
	ADC_AWD3CR_AWD3CH7 = 0x80
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH7_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH7_B_0x1 = 0x1
	// Position of AWD3CH8 field.
	ADC_AWD3CR_AWD3CH8_Pos = 0x8
	// Bit mask of AWD3CH8 field.
	ADC_AWD3CR_AWD3CH8_Msk = 0x100
	// Bit AWD3CH8.
	ADC_AWD3CR_AWD3CH8 = 0x100
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH8_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH8_B_0x1 = 0x1
	// Position of AWD3CH9 field.
	ADC_AWD3CR_AWD3CH9_Pos = 0x9
	// Bit mask of AWD3CH9 field.
	ADC_AWD3CR_AWD3CH9_Msk = 0x200
	// Bit AWD3CH9.
	ADC_AWD3CR_AWD3CH9 = 0x200
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH9_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH9_B_0x1 = 0x1
	// Position of AWD3CH10 field.
	ADC_AWD3CR_AWD3CH10_Pos = 0xa
	// Bit mask of AWD3CH10 field.
	ADC_AWD3CR_AWD3CH10_Msk = 0x400
	// Bit AWD3CH10.
	ADC_AWD3CR_AWD3CH10 = 0x400
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH10_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH10_B_0x1 = 0x1
	// Position of AWD3CH11 field.
	ADC_AWD3CR_AWD3CH11_Pos = 0xb
	// Bit mask of AWD3CH11 field.
	ADC_AWD3CR_AWD3CH11_Msk = 0x800
	// Bit AWD3CH11.
	ADC_AWD3CR_AWD3CH11 = 0x800
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH11_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH11_B_0x1 = 0x1
	// Position of AWD3CH12 field.
	ADC_AWD3CR_AWD3CH12_Pos = 0xc
	// Bit mask of AWD3CH12 field.
	ADC_AWD3CR_AWD3CH12_Msk = 0x1000
	// Bit AWD3CH12.
	ADC_AWD3CR_AWD3CH12 = 0x1000
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH12_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH12_B_0x1 = 0x1
	// Position of AWD3CH13 field.
	ADC_AWD3CR_AWD3CH13_Pos = 0xd
	// Bit mask of AWD3CH13 field.
	ADC_AWD3CR_AWD3CH13_Msk = 0x2000
	// Bit AWD3CH13.
	ADC_AWD3CR_AWD3CH13 = 0x2000
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH13_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH13_B_0x1 = 0x1
	// Position of AWD3CH14 field.
	ADC_AWD3CR_AWD3CH14_Pos = 0xe
	// Bit mask of AWD3CH14 field.
	ADC_AWD3CR_AWD3CH14_Msk = 0x4000
	// Bit AWD3CH14.
	ADC_AWD3CR_AWD3CH14 = 0x4000
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH14_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH14_B_0x1 = 0x1
	// Position of AWD3CH15 field.
	ADC_AWD3CR_AWD3CH15_Pos = 0xf
	// Bit mask of AWD3CH15 field.
	ADC_AWD3CR_AWD3CH15_Msk = 0x8000
	// Bit AWD3CH15.
	ADC_AWD3CR_AWD3CH15 = 0x8000
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH15_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH15_B_0x1 = 0x1
	// Position of AWD3CH16 field.
	ADC_AWD3CR_AWD3CH16_Pos = 0x10
	// Bit mask of AWD3CH16 field.
	ADC_AWD3CR_AWD3CH16_Msk = 0x10000
	// Bit AWD3CH16.
	ADC_AWD3CR_AWD3CH16 = 0x10000
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH16_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH16_B_0x1 = 0x1
	// Position of AWD3CH17 field.
	ADC_AWD3CR_AWD3CH17_Pos = 0x11
	// Bit mask of AWD3CH17 field.
	ADC_AWD3CR_AWD3CH17_Msk = 0x20000
	// Bit AWD3CH17.
	ADC_AWD3CR_AWD3CH17 = 0x20000
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH17_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH17_B_0x1 = 0x1
	// Position of AWD3CH18 field.
	ADC_AWD3CR_AWD3CH18_Pos = 0x12
	// Bit mask of AWD3CH18 field.
	ADC_AWD3CR_AWD3CH18_Msk = 0x40000
	// Bit AWD3CH18.
	ADC_AWD3CR_AWD3CH18 = 0x40000
	// ADC analog channel-x is not monitored by AWD3
	ADC_AWD3CR_AWD3CH18_B_0x0 = 0x0
	// ADC analog channel-x is monitored by AWD3
	ADC_AWD3CR_AWD3CH18_B_0x1 = 0x1

	// CALFACT: ADC Calibration factor
	// Position of CALFACT field.
	ADC_CALFACT_CALFACT_Pos = 0x0
	// Bit mask of CALFACT field.
	ADC_CALFACT_CALFACT_Msk = 0x7f

	// CCR: ADC common configuration register
	// Position of PRESC field.
	ADC_CCR_PRESC_Pos = 0x12
	// Bit mask of PRESC field.
	ADC_CCR_PRESC_Msk = 0x3c0000
	// input ADC clock not divided
	ADC_CCR_PRESC_B_0x0 = 0x0
	// input ADC clock divided by 2
	ADC_CCR_PRESC_B_0x1 = 0x1
	// input ADC clock divided by 4
	ADC_CCR_PRESC_B_0x2 = 0x2
	// input ADC clock divided by 6
	ADC_CCR_PRESC_B_0x3 = 0x3
	// input ADC clock divided by 8
	ADC_CCR_PRESC_B_0x4 = 0x4
	// input ADC clock divided by 10
	ADC_CCR_PRESC_B_0x5 = 0x5
	// input ADC clock divided by 12
	ADC_CCR_PRESC_B_0x6 = 0x6
	// input ADC clock divided by 16
	ADC_CCR_PRESC_B_0x7 = 0x7
	// input ADC clock divided by 32
	ADC_CCR_PRESC_B_0x8 = 0x8
	// input ADC clock divided by 64
	ADC_CCR_PRESC_B_0x9 = 0x9
	// input ADC clock divided by 128
	ADC_CCR_PRESC_B_0xA = 0xa
	// input ADC clock divided by 256
	ADC_CCR_PRESC_B_0xB = 0xb
	// Position of VREFEN field.
	ADC_CCR_VREFEN_Pos = 0x16
	// Bit mask of VREFEN field.
	ADC_CCR_VREFEN_Msk = 0x400000
	// Bit VREFEN.
	ADC_CCR_VREFEN = 0x400000
	// VREFINT disabled
	ADC_CCR_VREFEN_B_0x0 = 0x0
	// VREFINT enabled
	ADC_CCR_VREFEN_B_0x1 = 0x1
	// Position of TSEN field.
	ADC_CCR_TSEN_Pos = 0x17
	// Bit mask of TSEN field.
	ADC_CCR_TSEN_Msk = 0x800000
	// Bit TSEN.
	ADC_CCR_TSEN = 0x800000
	// Temperature sensor disabled, DAC_OUT1 connected to ADC channel 12
	ADC_CCR_TSEN_B_0x0 = 0x0
	// Temperature sensor enabled
	ADC_CCR_TSEN_B_0x1 = 0x1
	// Position of VBATEN field.
	ADC_CCR_VBATEN_Pos = 0x18
	// Bit mask of VBATEN field.
	ADC_CCR_VBATEN_Msk = 0x1000000
	// Bit VBATEN.
	ADC_CCR_VBATEN = 0x1000000
	// VBAT channel disabled, DAC_OUT2 connected to ADC channel 14
	ADC_CCR_VBATEN_B_0x0 = 0x0
	// VBAT channel enabled
	ADC_CCR_VBATEN_B_0x1 = 0x1
)

// Constants for COMP: Comparator
const (
	// COMP1_CSR: Comparator 1 control and status register
	// Position of EN field.
	COMP_COMP1_CSR_EN_Pos = 0x0
	// Bit mask of EN field.
	COMP_COMP1_CSR_EN_Msk = 0x1
	// Bit EN.
	COMP_COMP1_CSR_EN = 0x1
	// Disable
	COMP_COMP1_CSR_EN_B_0x0 = 0x0
	// Enable
	COMP_COMP1_CSR_EN_B_0x1 = 0x1
	// Position of INMSEL field.
	COMP_COMP1_CSR_INMSEL_Pos = 0x4
	// Bit mask of INMSEL field.
	COMP_COMP1_CSR_INMSEL_Msk = 0xf0
	// 1/4 VREFINT
	COMP_COMP1_CSR_INMSEL_B_0x0 = 0x0
	// 1/2 VREFINT
	COMP_COMP1_CSR_INMSEL_B_0x1 = 0x1
	// 3/4 VREFINT
	COMP_COMP1_CSR_INMSEL_B_0x2 = 0x2
	// VREFINT
	COMP_COMP1_CSR_INMSEL_B_0x3 = 0x3
	// DAC channel 1
	COMP_COMP1_CSR_INMSEL_B_0x4 = 0x4
	// DAC channel 2
	COMP_COMP1_CSR_INMSEL_B_0x5 = 0x5
	// PB1
	COMP_COMP1_CSR_INMSEL_B_0x6 = 0x6
	// PC4
	COMP_COMP1_CSR_INMSEL_B_0x7 = 0x7
	// PA0
	COMP_COMP1_CSR_INMSEL_B_0x8 = 0x8
	// Position of INPSEL field.
	COMP_COMP1_CSR_INPSEL_Pos = 0x8
	// Bit mask of INPSEL field.
	COMP_COMP1_CSR_INPSEL_Msk = 0x300
	// PC5
	COMP_COMP1_CSR_INPSEL_B_0x0 = 0x0
	// PB2
	COMP_COMP1_CSR_INPSEL_B_0x1 = 0x1
	// PA1
	COMP_COMP1_CSR_INPSEL_B_0x2 = 0x2
	// None (open)
	COMP_COMP1_CSR_INPSEL_B_0x3 = 0x3
	// Position of WINMODE field.
	COMP_COMP1_CSR_WINMODE_Pos = 0xb
	// Bit mask of WINMODE field.
	COMP_COMP1_CSR_WINMODE_Msk = 0x800
	// Bit WINMODE.
	COMP_COMP1_CSR_WINMODE = 0x800
	// Signal selected with INPSEL[1:0] bitfield of this register
	COMP_COMP1_CSR_WINMODE_B_0x0 = 0x0
	// COMP2_INP signal of the comparator 2 (required for window mode, see Figure 64)
	COMP_COMP1_CSR_WINMODE_B_0x1 = 0x1
	// Position of WINOUT field.
	COMP_COMP1_CSR_WINOUT_Pos = 0xe
	// Bit mask of WINOUT field.
	COMP_COMP1_CSR_WINOUT_Msk = 0x4000
	// Bit WINOUT.
	COMP_COMP1_CSR_WINOUT = 0x4000
	// COMP1_VALUE
	COMP_COMP1_CSR_WINOUT_B_0x0 = 0x0
	// COMP1_VALUE XOR COMP2_VALUE (required for window mode, see Figure 64)
	COMP_COMP1_CSR_WINOUT_B_0x1 = 0x1
	// Position of POLARITY field.
	COMP_COMP1_CSR_POLARITY_Pos = 0xf
	// Bit mask of POLARITY field.
	COMP_COMP1_CSR_POLARITY_Msk = 0x8000
	// Bit POLARITY.
	COMP_COMP1_CSR_POLARITY = 0x8000
	// Non-inverted
	COMP_COMP1_CSR_POLARITY_B_0x0 = 0x0
	// Inverted
	COMP_COMP1_CSR_POLARITY_B_0x1 = 0x1
	// Position of HYST field.
	COMP_COMP1_CSR_HYST_Pos = 0x10
	// Bit mask of HYST field.
	COMP_COMP1_CSR_HYST_Msk = 0x30000
	// None
	COMP_COMP1_CSR_HYST_B_0x0 = 0x0
	// Low
	COMP_COMP1_CSR_HYST_B_0x1 = 0x1
	// Medium
	COMP_COMP1_CSR_HYST_B_0x2 = 0x2
	// High
	COMP_COMP1_CSR_HYST_B_0x3 = 0x3
	// Position of PWRMODE field.
	COMP_COMP1_CSR_PWRMODE_Pos = 0x12
	// Bit mask of PWRMODE field.
	COMP_COMP1_CSR_PWRMODE_Msk = 0xc0000
	// High speed
	COMP_COMP1_CSR_PWRMODE_B_0x0 = 0x0
	// Medium speed
	COMP_COMP1_CSR_PWRMODE_B_0x1 = 0x1
	// Position of BLANKSEL field.
	COMP_COMP1_CSR_BLANKSEL_Pos = 0x14
	// Bit mask of BLANKSEL field.
	COMP_COMP1_CSR_BLANKSEL_Msk = 0x1f00000
	// None (no blanking)
	COMP_COMP1_CSR_BLANKSEL_B_0x0 = 0x0
	// Position of VALUE field.
	COMP_COMP1_CSR_VALUE_Pos = 0x1e
	// Bit mask of VALUE field.
	COMP_COMP1_CSR_VALUE_Msk = 0x40000000
	// Bit VALUE.
	COMP_COMP1_CSR_VALUE = 0x40000000
	// Position of LOCK field.
	COMP_COMP1_CSR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	COMP_COMP1_CSR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	COMP_COMP1_CSR_LOCK = 0x80000000
	// COMP1_CSR[31:0] register read/write bits can be written by software
	COMP_COMP1_CSR_LOCK_B_0x0 = 0x0
	// COMP1_CSR[31:0] register bits can be read but not written by software
	COMP_COMP1_CSR_LOCK_B_0x1 = 0x1

	// COMP2_CSR: Comparator 2 control and status register
	// Position of EN field.
	COMP_COMP2_CSR_EN_Pos = 0x0
	// Bit mask of EN field.
	COMP_COMP2_CSR_EN_Msk = 0x1
	// Bit EN.
	COMP_COMP2_CSR_EN = 0x1
	// Disable
	COMP_COMP2_CSR_EN_B_0x0 = 0x0
	// Enable
	COMP_COMP2_CSR_EN_B_0x1 = 0x1
	// Position of INMSEL field.
	COMP_COMP2_CSR_INMSEL_Pos = 0x4
	// Bit mask of INMSEL field.
	COMP_COMP2_CSR_INMSEL_Msk = 0xf0
	// 1/4 VREFINT
	COMP_COMP2_CSR_INMSEL_B_0x0 = 0x0
	// 1/2 VREFINT
	COMP_COMP2_CSR_INMSEL_B_0x1 = 0x1
	// 3/4 VREFINT
	COMP_COMP2_CSR_INMSEL_B_0x2 = 0x2
	// VREFINT
	COMP_COMP2_CSR_INMSEL_B_0x3 = 0x3
	// DAC channel 1
	COMP_COMP2_CSR_INMSEL_B_0x4 = 0x4
	// DAC channel 2
	COMP_COMP2_CSR_INMSEL_B_0x5 = 0x5
	// PB3
	COMP_COMP2_CSR_INMSEL_B_0x6 = 0x6
	// PB7
	COMP_COMP2_CSR_INMSEL_B_0x7 = 0x7
	// PA2
	COMP_COMP2_CSR_INMSEL_B_0x8 = 0x8
	// Position of INPSEL field.
	COMP_COMP2_CSR_INPSEL_Pos = 0x8
	// Bit mask of INPSEL field.
	COMP_COMP2_CSR_INPSEL_Msk = 0x300
	// PB4
	COMP_COMP2_CSR_INPSEL_B_0x0 = 0x0
	// PB6
	COMP_COMP2_CSR_INPSEL_B_0x1 = 0x1
	// PA3
	COMP_COMP2_CSR_INPSEL_B_0x2 = 0x2
	// None (open)
	COMP_COMP2_CSR_INPSEL_B_0x3 = 0x3
	// Position of WINMODE field.
	COMP_COMP2_CSR_WINMODE_Pos = 0xb
	// Bit mask of WINMODE field.
	COMP_COMP2_CSR_WINMODE_Msk = 0x800
	// Bit WINMODE.
	COMP_COMP2_CSR_WINMODE = 0x800
	// Signal selected with INPSEL[1:0] bitfield of this register
	COMP_COMP2_CSR_WINMODE_B_0x0 = 0x0
	// COMP1_INP signal of the comparator 1 (required for window mode, see Figure 64)
	COMP_COMP2_CSR_WINMODE_B_0x1 = 0x1
	// Position of WINOUT field.
	COMP_COMP2_CSR_WINOUT_Pos = 0xe
	// Bit mask of WINOUT field.
	COMP_COMP2_CSR_WINOUT_Msk = 0x4000
	// Bit WINOUT.
	COMP_COMP2_CSR_WINOUT = 0x4000
	// COMP2_VALUE
	COMP_COMP2_CSR_WINOUT_B_0x0 = 0x0
	// COMP1_VALUE XOR COMP2_VALUE (required for window mode, see Figure 64)
	COMP_COMP2_CSR_WINOUT_B_0x1 = 0x1
	// Position of POLARITY field.
	COMP_COMP2_CSR_POLARITY_Pos = 0xf
	// Bit mask of POLARITY field.
	COMP_COMP2_CSR_POLARITY_Msk = 0x8000
	// Bit POLARITY.
	COMP_COMP2_CSR_POLARITY = 0x8000
	// Non-inverted
	COMP_COMP2_CSR_POLARITY_B_0x0 = 0x0
	// Inverted
	COMP_COMP2_CSR_POLARITY_B_0x1 = 0x1
	// Position of HYST field.
	COMP_COMP2_CSR_HYST_Pos = 0x10
	// Bit mask of HYST field.
	COMP_COMP2_CSR_HYST_Msk = 0x30000
	// None
	COMP_COMP2_CSR_HYST_B_0x0 = 0x0
	// Low
	COMP_COMP2_CSR_HYST_B_0x1 = 0x1
	// Medium
	COMP_COMP2_CSR_HYST_B_0x2 = 0x2
	// High
	COMP_COMP2_CSR_HYST_B_0x3 = 0x3
	// Position of PWRMODE field.
	COMP_COMP2_CSR_PWRMODE_Pos = 0x12
	// Bit mask of PWRMODE field.
	COMP_COMP2_CSR_PWRMODE_Msk = 0xc0000
	// High speed
	COMP_COMP2_CSR_PWRMODE_B_0x0 = 0x0
	// Medium speed
	COMP_COMP2_CSR_PWRMODE_B_0x1 = 0x1
	// Position of BLANKSEL field.
	COMP_COMP2_CSR_BLANKSEL_Pos = 0x14
	// Bit mask of BLANKSEL field.
	COMP_COMP2_CSR_BLANKSEL_Msk = 0x1f00000
	// None (no blanking)
	COMP_COMP2_CSR_BLANKSEL_B_0x0 = 0x0
	// Position of VALUE field.
	COMP_COMP2_CSR_VALUE_Pos = 0x1e
	// Bit mask of VALUE field.
	COMP_COMP2_CSR_VALUE_Msk = 0x40000000
	// Bit VALUE.
	COMP_COMP2_CSR_VALUE = 0x40000000
	// Position of LOCK field.
	COMP_COMP2_CSR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	COMP_COMP2_CSR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	COMP_COMP2_CSR_LOCK = 0x80000000
	// COMP2_CSR[31:0] register read/write bits can be written by software
	COMP_COMP2_CSR_LOCK_B_0x0 = 0x0
	// COMP2_CSR[31:0] register bits can be read but not written by software
	COMP_COMP2_CSR_LOCK_B_0x1 = 0x1

	// COMP3_CSR: Comparator 2 control and status register
	// Position of EN field.
	COMP_COMP3_CSR_EN_Pos = 0x0
	// Bit mask of EN field.
	COMP_COMP3_CSR_EN_Msk = 0x1
	// Bit EN.
	COMP_COMP3_CSR_EN = 0x1
	// Disable
	COMP_COMP3_CSR_EN_B_0x0 = 0x0
	// Enable
	COMP_COMP3_CSR_EN_B_0x1 = 0x1
	// Position of INMSEL field.
	COMP_COMP3_CSR_INMSEL_Pos = 0x4
	// Bit mask of INMSEL field.
	COMP_COMP3_CSR_INMSEL_Msk = 0xf0
	// 1/4 VREFINT
	COMP_COMP3_CSR_INMSEL_B_0x0 = 0x0
	// 1/2 VREFINT
	COMP_COMP3_CSR_INMSEL_B_0x1 = 0x1
	// 3/4 VREFINT
	COMP_COMP3_CSR_INMSEL_B_0x2 = 0x2
	// VREFINT
	COMP_COMP3_CSR_INMSEL_B_0x3 = 0x3
	// DAC channel 1
	COMP_COMP3_CSR_INMSEL_B_0x4 = 0x4
	// DAC channel 2
	COMP_COMP3_CSR_INMSEL_B_0x5 = 0x5
	// PB3
	COMP_COMP3_CSR_INMSEL_B_0x6 = 0x6
	// PB7
	COMP_COMP3_CSR_INMSEL_B_0x7 = 0x7
	// PA2
	COMP_COMP3_CSR_INMSEL_B_0x8 = 0x8
	// Position of INPSEL field.
	COMP_COMP3_CSR_INPSEL_Pos = 0x8
	// Bit mask of INPSEL field.
	COMP_COMP3_CSR_INPSEL_Msk = 0x300
	// PB4
	COMP_COMP3_CSR_INPSEL_B_0x0 = 0x0
	// PB6
	COMP_COMP3_CSR_INPSEL_B_0x1 = 0x1
	// PA3
	COMP_COMP3_CSR_INPSEL_B_0x2 = 0x2
	// None (open)
	COMP_COMP3_CSR_INPSEL_B_0x3 = 0x3
	// Position of WINMODE field.
	COMP_COMP3_CSR_WINMODE_Pos = 0xb
	// Bit mask of WINMODE field.
	COMP_COMP3_CSR_WINMODE_Msk = 0x800
	// Bit WINMODE.
	COMP_COMP3_CSR_WINMODE = 0x800
	// Signal selected with INPSEL[1:0] bitfield of this register
	COMP_COMP3_CSR_WINMODE_B_0x0 = 0x0
	// COMP1_INP signal of the comparator 1 (required for window mode, see Figure 64)
	COMP_COMP3_CSR_WINMODE_B_0x1 = 0x1
	// Position of WINOUT field.
	COMP_COMP3_CSR_WINOUT_Pos = 0xe
	// Bit mask of WINOUT field.
	COMP_COMP3_CSR_WINOUT_Msk = 0x4000
	// Bit WINOUT.
	COMP_COMP3_CSR_WINOUT = 0x4000
	// COMP2_VALUE
	COMP_COMP3_CSR_WINOUT_B_0x0 = 0x0
	// COMP1_VALUE XOR COMP3_VALUE (required for window mode, see Figure 64)
	COMP_COMP3_CSR_WINOUT_B_0x1 = 0x1
	// Position of POLARITY field.
	COMP_COMP3_CSR_POLARITY_Pos = 0xf
	// Bit mask of POLARITY field.
	COMP_COMP3_CSR_POLARITY_Msk = 0x8000
	// Bit POLARITY.
	COMP_COMP3_CSR_POLARITY = 0x8000
	// Non-inverted
	COMP_COMP3_CSR_POLARITY_B_0x0 = 0x0
	// Inverted
	COMP_COMP3_CSR_POLARITY_B_0x1 = 0x1
	// Position of HYST field.
	COMP_COMP3_CSR_HYST_Pos = 0x10
	// Bit mask of HYST field.
	COMP_COMP3_CSR_HYST_Msk = 0x30000
	// None
	COMP_COMP3_CSR_HYST_B_0x0 = 0x0
	// Low
	COMP_COMP3_CSR_HYST_B_0x1 = 0x1
	// Medium
	COMP_COMP3_CSR_HYST_B_0x2 = 0x2
	// High
	COMP_COMP3_CSR_HYST_B_0x3 = 0x3
	// Position of PWRMODE field.
	COMP_COMP3_CSR_PWRMODE_Pos = 0x12
	// Bit mask of PWRMODE field.
	COMP_COMP3_CSR_PWRMODE_Msk = 0xc0000
	// High speed
	COMP_COMP3_CSR_PWRMODE_B_0x0 = 0x0
	// Medium speed
	COMP_COMP3_CSR_PWRMODE_B_0x1 = 0x1
	// Position of BLANKSEL field.
	COMP_COMP3_CSR_BLANKSEL_Pos = 0x14
	// Bit mask of BLANKSEL field.
	COMP_COMP3_CSR_BLANKSEL_Msk = 0x1f00000
	// None (no blanking)
	COMP_COMP3_CSR_BLANKSEL_B_0x0 = 0x0
	// Position of VALUE field.
	COMP_COMP3_CSR_VALUE_Pos = 0x1e
	// Bit mask of VALUE field.
	COMP_COMP3_CSR_VALUE_Msk = 0x40000000
	// Bit VALUE.
	COMP_COMP3_CSR_VALUE = 0x40000000
	// Position of LOCK field.
	COMP_COMP3_CSR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	COMP_COMP3_CSR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	COMP_COMP3_CSR_LOCK = 0x80000000
	// COMP3_CSR[31:0] register read/write bits can be written by software
	COMP_COMP3_CSR_LOCK_B_0x0 = 0x0
	// COMP3_CSR[31:0] register bits can be read but not written by software
	COMP_COMP3_CSR_LOCK_B_0x1 = 0x1
)

// Constants for CRC: Cyclic redundancy check calculation unit
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// IDR: Independent data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xffffffff

	// CR: Control register
	// Position of REV_OUT field.
	CRC_CR_REV_OUT_Pos = 0x7
	// Bit mask of REV_OUT field.
	CRC_CR_REV_OUT_Msk = 0x80
	// Bit REV_OUT.
	CRC_CR_REV_OUT = 0x80
	// Bit order not affected
	CRC_CR_REV_OUT_B_0x0 = 0x0
	// Bit-reversed output format
	CRC_CR_REV_OUT_B_0x1 = 0x1
	// Position of REV_IN field.
	CRC_CR_REV_IN_Pos = 0x5
	// Bit mask of REV_IN field.
	CRC_CR_REV_IN_Msk = 0x60
	// Bit order not affected
	CRC_CR_REV_IN_B_0x0 = 0x0
	// Bit reversal done by byte
	CRC_CR_REV_IN_B_0x1 = 0x1
	// Bit reversal done by half-word
	CRC_CR_REV_IN_B_0x2 = 0x2
	// Bit reversal done by word
	CRC_CR_REV_IN_B_0x3 = 0x3
	// Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Pos = 0x3
	// Bit mask of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18
	// 32 bit polynomial
	CRC_CR_POLYSIZE_B_0x0 = 0x0
	// 16 bit polynomial
	CRC_CR_POLYSIZE_B_0x1 = 0x1
	// 8 bit polynomial
	CRC_CR_POLYSIZE_B_0x2 = 0x2
	// 7 bit polynomial
	CRC_CR_POLYSIZE_B_0x3 = 0x3
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1

	// INIT: Initial CRC value
	// Position of CRC_INIT field.
	CRC_INIT_CRC_INIT_Pos = 0x0
	// Bit mask of CRC_INIT field.
	CRC_INIT_CRC_INIT_Msk = 0xffffffff

	// POL: polynomial
	// Position of POL field.
	CRC_POL_POL_Pos = 0x0
	// Bit mask of POL field.
	CRC_POL_POL_Msk = 0xffffffff
)

// Constants for DAC: DAC
const (
	// CR: DAC control register
	// Position of EN1 field.
	DAC_CR_EN1_Pos = 0x0
	// Bit mask of EN1 field.
	DAC_CR_EN1_Msk = 0x1
	// Bit EN1.
	DAC_CR_EN1 = 0x1
	// DAC channel1 disabled
	DAC_CR_EN1_B_0x0 = 0x0
	// DAC channel1 enabled
	DAC_CR_EN1_B_0x1 = 0x1
	// Position of TEN1 field.
	DAC_CR_TEN1_Pos = 0x1
	// Bit mask of TEN1 field.
	DAC_CR_TEN1_Msk = 0x2
	// Bit TEN1.
	DAC_CR_TEN1 = 0x2
	// DAC channel1 trigger disabled and data written into the DAC_DHR1 register are transferred one dac_pclk clock cycle later to the DAC_DOR1 register
	DAC_CR_TEN1_B_0x0 = 0x0
	// DAC channel1 trigger enabled and data from the DAC_DHR1 register are transferred three dac_pclk clock cycles later to the DAC_DOR1 register
	DAC_CR_TEN1_B_0x1 = 0x1
	// Position of TSEL1 field.
	DAC_CR_TSEL1_Pos = 0x2
	// Bit mask of TSEL1 field.
	DAC_CR_TSEL1_Msk = 0x3c
	// SWTRIG1
	DAC_CR_TSEL1_B_0x0 = 0x0
	// dac_ch1_trg1
	DAC_CR_TSEL1_B_0x1 = 0x1
	// dac_ch1_trg2
	DAC_CR_TSEL1_B_0x2 = 0x2
	// dac_ch1_trg15
	DAC_CR_TSEL1_B_0xF = 0xf
	// Position of WAVE1 field.
	DAC_CR_WAVE1_Pos = 0x6
	// Bit mask of WAVE1 field.
	DAC_CR_WAVE1_Msk = 0xc0
	// wave generation disabled
	DAC_CR_WAVE1_B_0x0 = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE1_B_0x1 = 0x1
	// Position of MAMP1 field.
	DAC_CR_MAMP1_Pos = 0x8
	// Bit mask of MAMP1 field.
	DAC_CR_MAMP1_Msk = 0xf00
	// Unmask bit0 of LFSR/ triangle amplitude equal to 1
	DAC_CR_MAMP1_B_0x0 = 0x0
	// Unmask bits[1:0] of LFSR/ triangle amplitude equal to 3
	DAC_CR_MAMP1_B_0x1 = 0x1
	// Unmask bits[2:0] of LFSR/ triangle amplitude equal to 7
	DAC_CR_MAMP1_B_0x2 = 0x2
	// Unmask bits[3:0] of LFSR/ triangle amplitude equal to 15
	DAC_CR_MAMP1_B_0x3 = 0x3
	// Unmask bits[4:0] of LFSR/ triangle amplitude equal to 31
	DAC_CR_MAMP1_B_0x4 = 0x4
	// Unmask bits[5:0] of LFSR/ triangle amplitude equal to 63
	DAC_CR_MAMP1_B_0x5 = 0x5
	// Unmask bits[6:0] of LFSR/ triangle amplitude equal to 127
	DAC_CR_MAMP1_B_0x6 = 0x6
	// Unmask bits[7:0] of LFSR/ triangle amplitude equal to 255
	DAC_CR_MAMP1_B_0x7 = 0x7
	// Unmask bits[8:0] of LFSR/ triangle amplitude equal to 511
	DAC_CR_MAMP1_B_0x8 = 0x8
	// Unmask bits[9:0] of LFSR/ triangle amplitude equal to 1023
	DAC_CR_MAMP1_B_0x9 = 0x9
	// Unmask bits[10:0] of LFSR/ triangle amplitude equal to 2047
	DAC_CR_MAMP1_B_0xA = 0xa
	// Position of DMAEN1 field.
	DAC_CR_DMAEN1_Pos = 0xc
	// Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1_Msk = 0x1000
	// Bit DMAEN1.
	DAC_CR_DMAEN1 = 0x1000
	// DAC channel1 DMA mode disabled
	DAC_CR_DMAEN1_B_0x0 = 0x0
	// DAC channel1 DMA mode enabled
	DAC_CR_DMAEN1_B_0x1 = 0x1
	// Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Pos = 0xd
	// Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000
	// Bit DMAUDRIE1.
	DAC_CR_DMAUDRIE1 = 0x2000
	// DAC channel1 DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE1_B_0x0 = 0x0
	// DAC channel1 DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE1_B_0x1 = 0x1
	// Position of CEN1 field.
	DAC_CR_CEN1_Pos = 0xe
	// Bit mask of CEN1 field.
	DAC_CR_CEN1_Msk = 0x4000
	// Bit CEN1.
	DAC_CR_CEN1 = 0x4000
	// DAC channel1 in Normal operating mode
	DAC_CR_CEN1_B_0x0 = 0x0
	// DAC channel1 in calibration mode
	DAC_CR_CEN1_B_0x1 = 0x1
	// Position of EN2 field.
	DAC_CR_EN2_Pos = 0x10
	// Bit mask of EN2 field.
	DAC_CR_EN2_Msk = 0x10000
	// Bit EN2.
	DAC_CR_EN2 = 0x10000
	// DAC channel2 disabled
	DAC_CR_EN2_B_0x0 = 0x0
	// DAC channel2 enabled
	DAC_CR_EN2_B_0x1 = 0x1
	// Position of TEN2 field.
	DAC_CR_TEN2_Pos = 0x11
	// Bit mask of TEN2 field.
	DAC_CR_TEN2_Msk = 0x20000
	// Bit TEN2.
	DAC_CR_TEN2 = 0x20000
	// DAC channel2 trigger disabled and data written into the DAC_DHR2 register are transferred one dac_pclk clock cycle later to the DAC_DOR2 register
	DAC_CR_TEN2_B_0x0 = 0x0
	// DAC channel2 trigger enabled and data from the DAC_DHR2 register are transferred three dac_pclk clock cycles later to the DAC_DOR2 register
	DAC_CR_TEN2_B_0x1 = 0x1
	// Position of TSEL2 field.
	DAC_CR_TSEL2_Pos = 0x12
	// Bit mask of TSEL2 field.
	DAC_CR_TSEL2_Msk = 0x3c0000
	// SWTRIG2
	DAC_CR_TSEL2_B_0x0 = 0x0
	// dac_ch2_trg1
	DAC_CR_TSEL2_B_0x1 = 0x1
	// dac_ch2_trg2
	DAC_CR_TSEL2_B_0x2 = 0x2
	// dac_ch2_trg15
	DAC_CR_TSEL2_B_0xF = 0xf
	// Position of WAVE2 field.
	DAC_CR_WAVE2_Pos = 0x16
	// Bit mask of WAVE2 field.
	DAC_CR_WAVE2_Msk = 0xc00000
	// wave generation disabled
	DAC_CR_WAVE2_B_0x0 = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE2_B_0x1 = 0x1
	// Position of MAMP2 field.
	DAC_CR_MAMP2_Pos = 0x18
	// Bit mask of MAMP2 field.
	DAC_CR_MAMP2_Msk = 0xf000000
	// Unmask bit0 of LFSR/ triangle amplitude equal to 1
	DAC_CR_MAMP2_B_0x0 = 0x0
	// Unmask bits[1:0] of LFSR/ triangle amplitude equal to 3
	DAC_CR_MAMP2_B_0x1 = 0x1
	// Unmask bits[2:0] of LFSR/ triangle amplitude equal to 7
	DAC_CR_MAMP2_B_0x2 = 0x2
	// Unmask bits[3:0] of LFSR/ triangle amplitude equal to 15
	DAC_CR_MAMP2_B_0x3 = 0x3
	// Unmask bits[4:0] of LFSR/ triangle amplitude equal to 31
	DAC_CR_MAMP2_B_0x4 = 0x4
	// Unmask bits[5:0] of LFSR/ triangle amplitude equal to 63
	DAC_CR_MAMP2_B_0x5 = 0x5
	// Unmask bits[6:0] of LFSR/ triangle amplitude equal to 127
	DAC_CR_MAMP2_B_0x6 = 0x6
	// Unmask bits[7:0] of LFSR/ triangle amplitude equal to 255
	DAC_CR_MAMP2_B_0x7 = 0x7
	// Unmask bits[8:0] of LFSR/ triangle amplitude equal to 511
	DAC_CR_MAMP2_B_0x8 = 0x8
	// Unmask bits[9:0] of LFSR/ triangle amplitude equal to 1023
	DAC_CR_MAMP2_B_0x9 = 0x9
	// Unmask bits[10:0] of LFSR/ triangle amplitude equal to 2047
	DAC_CR_MAMP2_B_0xA = 0xa
	// Position of DMAEN2 field.
	DAC_CR_DMAEN2_Pos = 0x1c
	// Bit mask of DMAEN2 field.
	DAC_CR_DMAEN2_Msk = 0x10000000
	// Bit DMAEN2.
	DAC_CR_DMAEN2 = 0x10000000
	// DAC channel2 DMA mode disabled
	DAC_CR_DMAEN2_B_0x0 = 0x0
	// DAC channel2 DMA mode enabled
	DAC_CR_DMAEN2_B_0x1 = 0x1
	// Position of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Pos = 0x1d
	// Bit mask of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Msk = 0x20000000
	// Bit DMAUDRIE2.
	DAC_CR_DMAUDRIE2 = 0x20000000
	// DAC channel2 DMA underrun interrupt disabled
	DAC_CR_DMAUDRIE2_B_0x0 = 0x0
	// DAC channel2 DMA underrun interrupt enabled
	DAC_CR_DMAUDRIE2_B_0x1 = 0x1
	// Position of CEN2 field.
	DAC_CR_CEN2_Pos = 0x1e
	// Bit mask of CEN2 field.
	DAC_CR_CEN2_Msk = 0x40000000
	// Bit CEN2.
	DAC_CR_CEN2 = 0x40000000
	// DAC channel2 in Normal operating mode
	DAC_CR_CEN2_B_0x0 = 0x0
	// DAC channel2 in calibration mode
	DAC_CR_CEN2_B_0x1 = 0x1

	// SWTRGR: DAC software trigger register
	// Position of SWTRIG1 field.
	DAC_SWTRGR_SWTRIG1_Pos = 0x0
	// Bit mask of SWTRIG1 field.
	DAC_SWTRGR_SWTRIG1_Msk = 0x1
	// Bit SWTRIG1.
	DAC_SWTRGR_SWTRIG1 = 0x1
	// No trigger
	DAC_SWTRGR_SWTRIG1_B_0x0 = 0x0
	// Trigger
	DAC_SWTRGR_SWTRIG1_B_0x1 = 0x1
	// Position of SWTRIG2 field.
	DAC_SWTRGR_SWTRIG2_Pos = 0x1
	// Bit mask of SWTRIG2 field.
	DAC_SWTRGR_SWTRIG2_Msk = 0x2
	// Bit SWTRIG2.
	DAC_SWTRGR_SWTRIG2 = 0x2
	// No trigger
	DAC_SWTRGR_SWTRIG2_B_0x0 = 0x0
	// Trigger
	DAC_SWTRGR_SWTRIG2_B_0x1 = 0x1

	// DHR12R1: DAC channel1 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff

	// DHR12L1: DAC channel1 12-bit left aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0

	// DHR8R1: DAC channel1 8-bit right aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff

	// DHR12R2: DAC channel2 12-bit right aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff

	// DHR12L2: DAC channel2 12-bit left aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Pos = 0x4
	// Bit mask of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0

	// DHR8R2: DAC channel2 8-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff

	// DHR12RD: Dual DAC 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff
	// Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Pos = 0x10
	// Bit mask of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000

	// DHR12LD: DUAL DAC 12-bit left aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0
	// Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Pos = 0x14
	// Bit mask of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000

	// DHR8RD: DUAL DAC 8-bit right aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff
	// Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Pos = 0x8
	// Bit mask of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00

	// DOR1: DAC channel1 data output register
	// Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Pos = 0x0
	// Bit mask of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff

	// DOR2: DAC channel2 data output register
	// Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Pos = 0x0
	// Bit mask of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff

	// SR: DAC status register
	// Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Pos = 0xd
	// Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000
	// Bit DMAUDR1.
	DAC_SR_DMAUDR1 = 0x2000
	// No DMA underrun error condition occurred for DAC channel1
	DAC_SR_DMAUDR1_B_0x0 = 0x0
	// DMA underrun error condition occurred for DAC channel1 (the currently selected trigger is driving DAC channel1 conversion at a frequency higher than the DMA service capability rate)
	DAC_SR_DMAUDR1_B_0x1 = 0x1
	// Position of CAL_FLAG1 field.
	DAC_SR_CAL_FLAG1_Pos = 0xe
	// Bit mask of CAL_FLAG1 field.
	DAC_SR_CAL_FLAG1_Msk = 0x4000
	// Bit CAL_FLAG1.
	DAC_SR_CAL_FLAG1 = 0x4000
	// calibration trimming value is lower than the offset correction value
	DAC_SR_CAL_FLAG1_B_0x0 = 0x0
	// calibration trimming value is equal or greater than the offset correction value
	DAC_SR_CAL_FLAG1_B_0x1 = 0x1
	// Position of BWST1 field.
	DAC_SR_BWST1_Pos = 0xf
	// Bit mask of BWST1 field.
	DAC_SR_BWST1_Msk = 0x8000
	// Bit BWST1.
	DAC_SR_BWST1 = 0x8000
	// There is no write operation of DAC_SHSR1 ongoing: DAC_SHSR1 can be written
	DAC_SR_BWST1_B_0x0 = 0x0
	// There is a write operation of DAC_SHSR1 ongoing: DAC_SHSR1 cannot be written
	DAC_SR_BWST1_B_0x1 = 0x1
	// Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Pos = 0x1d
	// Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk = 0x20000000
	// Bit DMAUDR2.
	DAC_SR_DMAUDR2 = 0x20000000
	// No DMA underrun error condition occurred for DAC channel2
	DAC_SR_DMAUDR2_B_0x0 = 0x0
	// DMA underrun error condition occurred for DAC channel2 (the currently selected trigger is driving DAC channel2 conversion at a frequency higher than the DMA service capability rate).
	DAC_SR_DMAUDR2_B_0x1 = 0x1
	// Position of CAL_FLAG2 field.
	DAC_SR_CAL_FLAG2_Pos = 0x1e
	// Bit mask of CAL_FLAG2 field.
	DAC_SR_CAL_FLAG2_Msk = 0x40000000
	// Bit CAL_FLAG2.
	DAC_SR_CAL_FLAG2 = 0x40000000
	// calibration trimming value is lower than the offset correction value
	DAC_SR_CAL_FLAG2_B_0x0 = 0x0
	// calibration trimming value is equal or greater than the offset correction value
	DAC_SR_CAL_FLAG2_B_0x1 = 0x1
	// Position of BWST2 field.
	DAC_SR_BWST2_Pos = 0x1f
	// Bit mask of BWST2 field.
	DAC_SR_BWST2_Msk = 0x80000000
	// Bit BWST2.
	DAC_SR_BWST2 = 0x80000000
	// There is no write operation of DAC_SHSR2 ongoing: DAC_SHSR2 can be written
	DAC_SR_BWST2_B_0x0 = 0x0
	// There is a write operation of DAC_SHSR2 ongoing: DAC_SHSR2 cannot be written
	DAC_SR_BWST2_B_0x1 = 0x1

	// CCR: DAC calibration control register
	// Position of OTRIM1 field.
	DAC_CCR_OTRIM1_Pos = 0x0
	// Bit mask of OTRIM1 field.
	DAC_CCR_OTRIM1_Msk = 0x1f
	// Position of OTRIM2 field.
	DAC_CCR_OTRIM2_Pos = 0x10
	// Bit mask of OTRIM2 field.
	DAC_CCR_OTRIM2_Msk = 0x1f0000

	// MCR: DAC mode control register
	// Position of MODE1 field.
	DAC_MCR_MODE1_Pos = 0x0
	// Bit mask of MODE1 field.
	DAC_MCR_MODE1_Msk = 0x7
	// DAC channel1 is connected to external pin with Buffer enabled
	DAC_MCR_MODE1_B_0x0 = 0x0
	// DAC channel1 is connected to external pin and to on chip peripherals with Buffer enabled
	DAC_MCR_MODE1_B_0x1 = 0x1
	// DAC channel1 is connected to external pin with Buffer disabled
	DAC_MCR_MODE1_B_0x2 = 0x2
	// DAC channel1 is connected to on chip peripherals with Buffer disabled
	DAC_MCR_MODE1_B_0x3 = 0x3
	// DAC channel1 is connected to external pin with Buffer enabled
	DAC_MCR_MODE1_B_0x4 = 0x4
	// DAC channel1 is connected to external pin and to on chip peripherals with Buffer enabled
	DAC_MCR_MODE1_B_0x5 = 0x5
	// DAC channel1 is connected to external pin and to on chip peripherals with Buffer disabled
	DAC_MCR_MODE1_B_0x6 = 0x6
	// DAC channel1 is connected to on chip peripherals with Buffer disabled
	DAC_MCR_MODE1_B_0x7 = 0x7
	// Position of MODE2 field.
	DAC_MCR_MODE2_Pos = 0x10
	// Bit mask of MODE2 field.
	DAC_MCR_MODE2_Msk = 0x70000
	// DAC channel2 is connected to external pin with Buffer enabled
	DAC_MCR_MODE2_B_0x0 = 0x0
	// DAC channel2 is connected to external pin and to on chip peripherals with buffer enabled
	DAC_MCR_MODE2_B_0x1 = 0x1
	// DAC channel2 is connected to external pin with buffer disabled
	DAC_MCR_MODE2_B_0x2 = 0x2
	// DAC channel2 is connected to on chip peripherals with Buffer disabled
	DAC_MCR_MODE2_B_0x3 = 0x3
	// DAC channel2 is connected to external pin with Buffer enabled
	DAC_MCR_MODE2_B_0x4 = 0x4
	// DAC channel2 is connected to external pin and to on chip peripherals with Buffer enabled
	DAC_MCR_MODE2_B_0x5 = 0x5
	// DAC channel2 is connected to external pin and to on chip peripherals with Buffer disabled
	DAC_MCR_MODE2_B_0x6 = 0x6
	// DAC channel2 is connected to on chip peripherals with Buffer disabled
	DAC_MCR_MODE2_B_0x7 = 0x7

	// SHSR1: DAC Sample and Hold sample time register 1
	// Position of TSAMPLE1 field.
	DAC_SHSR1_TSAMPLE1_Pos = 0x0
	// Bit mask of TSAMPLE1 field.
	DAC_SHSR1_TSAMPLE1_Msk = 0x3ff

	// SHSR2: DAC Sample and Hold sample time register 2
	// Position of TSAMPLE2 field.
	DAC_SHSR2_TSAMPLE2_Pos = 0x0
	// Bit mask of TSAMPLE2 field.
	DAC_SHSR2_TSAMPLE2_Msk = 0x3ff

	// SHHR: DAC Sample and Hold hold time register
	// Position of THOLD1 field.
	DAC_SHHR_THOLD1_Pos = 0x0
	// Bit mask of THOLD1 field.
	DAC_SHHR_THOLD1_Msk = 0x3ff
	// Position of THOLD2 field.
	DAC_SHHR_THOLD2_Pos = 0x10
	// Bit mask of THOLD2 field.
	DAC_SHHR_THOLD2_Msk = 0x3ff0000

	// SHRR: DAC Sample and Hold refresh time register
	// Position of TREFRESH1 field.
	DAC_SHRR_TREFRESH1_Pos = 0x0
	// Bit mask of TREFRESH1 field.
	DAC_SHRR_TREFRESH1_Msk = 0xff
	// Position of TREFRESH2 field.
	DAC_SHRR_TREFRESH2_Pos = 0x10
	// Bit mask of TREFRESH2 field.
	DAC_SHRR_TREFRESH2_Msk = 0xff0000
)

// Constants for DBG: Debug support
const (
	// IDCODE: MCU Device ID Code Register
	// Position of DEV_ID field.
	DBG_IDCODE_DEV_ID_Pos = 0x0
	// Bit mask of DEV_ID field.
	DBG_IDCODE_DEV_ID_Msk = 0xfff
	// Position of REV_ID field.
	DBG_IDCODE_REV_ID_Pos = 0x10
	// Bit mask of REV_ID field.
	DBG_IDCODE_REV_ID_Msk = 0xffff0000

	// CR: DBG configuration register
	// Position of DBG_STOP field.
	DBG_CR_DBG_STOP_Pos = 0x1
	// Bit mask of DBG_STOP field.
	DBG_CR_DBG_STOP_Msk = 0x2
	// Bit DBG_STOP.
	DBG_CR_DBG_STOP = 0x2
	// All clocks disabled, including FCLK and HCLK. Upon Stop mode exit, the CPU is clocked by the HSI internal RC oscillator.
	DBG_CR_DBG_STOP_B_0x0 = 0x0
	// FCLK and HCLK running, derived from the internal RC oscillator remaining active. If Systick is enabled, it may generate periodic interrupt and wake up events.
	DBG_CR_DBG_STOP_B_0x1 = 0x1
	// Position of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Pos = 0x2
	// Bit mask of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Msk = 0x4
	// Bit DBG_STANDBY.
	DBG_CR_DBG_STANDBY = 0x4
	// Digital part powered. From software point of view, exiting Standby and Shutdown modes is identical as fetching reset vector (except for status bits indicating that the MCU exits Standby)
	DBG_CR_DBG_STANDBY_B_0x0 = 0x0
	// Digital part powered and FCLK and HCLK running, derived from the internal RC oscillator remaining active. The MCU generates a system reset so that exiting Standby and Shutdown has the same effect as starting from reset.
	DBG_CR_DBG_STANDBY_B_0x1 = 0x1

	// APB_FZ1: DBG APB freeze register 1
	// Position of DBG_TIM2_STOP field.
	DBG_APB_FZ1_DBG_TIM2_STOP_Pos = 0x0
	// Bit mask of DBG_TIM2_STOP field.
	DBG_APB_FZ1_DBG_TIM2_STOP_Msk = 0x1
	// Bit DBG_TIM2_STOP.
	DBG_APB_FZ1_DBG_TIM2_STOP = 0x1
	// Enable
	DBG_APB_FZ1_DBG_TIM2_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_TIM2_STOP_B_0x1 = 0x1
	// Position of DBG_TIM3_STOP field.
	DBG_APB_FZ1_DBG_TIM3_STOP_Pos = 0x1
	// Bit mask of DBG_TIM3_STOP field.
	DBG_APB_FZ1_DBG_TIM3_STOP_Msk = 0x2
	// Bit DBG_TIM3_STOP.
	DBG_APB_FZ1_DBG_TIM3_STOP = 0x2
	// Enable
	DBG_APB_FZ1_DBG_TIM3_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_TIM3_STOP_B_0x1 = 0x1
	// Position of DBG_TIM6_STOP field.
	DBG_APB_FZ1_DBG_TIM6_STOP_Pos = 0x4
	// Bit mask of DBG_TIM6_STOP field.
	DBG_APB_FZ1_DBG_TIM6_STOP_Msk = 0x10
	// Bit DBG_TIM6_STOP.
	DBG_APB_FZ1_DBG_TIM6_STOP = 0x10
	// Enable
	DBG_APB_FZ1_DBG_TIM6_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_TIM6_STOP_B_0x1 = 0x1
	// Position of DBG_TIM7_STOP field.
	DBG_APB_FZ1_DBG_TIM7_STOP_Pos = 0x5
	// Bit mask of DBG_TIM7_STOP field.
	DBG_APB_FZ1_DBG_TIM7_STOP_Msk = 0x20
	// Bit DBG_TIM7_STOP.
	DBG_APB_FZ1_DBG_TIM7_STOP = 0x20
	// Enable
	DBG_APB_FZ1_DBG_TIM7_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_TIM7_STOP_B_0x1 = 0x1
	// Position of DBG_RTC_STOP field.
	DBG_APB_FZ1_DBG_RTC_STOP_Pos = 0xa
	// Bit mask of DBG_RTC_STOP field.
	DBG_APB_FZ1_DBG_RTC_STOP_Msk = 0x400
	// Bit DBG_RTC_STOP.
	DBG_APB_FZ1_DBG_RTC_STOP = 0x400
	// Enable
	DBG_APB_FZ1_DBG_RTC_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_RTC_STOP_B_0x1 = 0x1
	// Position of DBG_WWDG_STOP field.
	DBG_APB_FZ1_DBG_WWDG_STOP_Pos = 0xb
	// Bit mask of DBG_WWDG_STOP field.
	DBG_APB_FZ1_DBG_WWDG_STOP_Msk = 0x800
	// Bit DBG_WWDG_STOP.
	DBG_APB_FZ1_DBG_WWDG_STOP = 0x800
	// Enable
	DBG_APB_FZ1_DBG_WWDG_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_WWDG_STOP_B_0x1 = 0x1
	// Position of DBG_IWDG_STOP field.
	DBG_APB_FZ1_DBG_IWDG_STOP_Pos = 0xc
	// Bit mask of DBG_IWDG_STOP field.
	DBG_APB_FZ1_DBG_IWDG_STOP_Msk = 0x1000
	// Bit DBG_IWDG_STOP.
	DBG_APB_FZ1_DBG_IWDG_STOP = 0x1000
	// Enable
	DBG_APB_FZ1_DBG_IWDG_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_IWDG_STOP_B_0x1 = 0x1
	// Position of DBG_I2C1_SMBUS_TIMEOUT field.
	DBG_APB_FZ1_DBG_I2C1_SMBUS_TIMEOUT_Pos = 0x15
	// Bit mask of DBG_I2C1_SMBUS_TIMEOUT field.
	DBG_APB_FZ1_DBG_I2C1_SMBUS_TIMEOUT_Msk = 0x200000
	// Bit DBG_I2C1_SMBUS_TIMEOUT.
	DBG_APB_FZ1_DBG_I2C1_SMBUS_TIMEOUT = 0x200000
	// Same behavior as in normal mode
	DBG_APB_FZ1_DBG_I2C1_SMBUS_TIMEOUT_B_0x0 = 0x0
	// The SMBUS timeout is frozen
	DBG_APB_FZ1_DBG_I2C1_SMBUS_TIMEOUT_B_0x1 = 0x1
	// Position of DBG_LPTIM2_STOP field.
	DBG_APB_FZ1_DBG_LPTIM2_STOP_Pos = 0x1e
	// Bit mask of DBG_LPTIM2_STOP field.
	DBG_APB_FZ1_DBG_LPTIM2_STOP_Msk = 0x40000000
	// Bit DBG_LPTIM2_STOP.
	DBG_APB_FZ1_DBG_LPTIM2_STOP = 0x40000000
	// Enable
	DBG_APB_FZ1_DBG_LPTIM2_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_LPTIM2_STOP_B_0x1 = 0x1
	// Position of DBG_LPTIM1_STOP field.
	DBG_APB_FZ1_DBG_LPTIM1_STOP_Pos = 0x1f
	// Bit mask of DBG_LPTIM1_STOP field.
	DBG_APB_FZ1_DBG_LPTIM1_STOP_Msk = 0x80000000
	// Bit DBG_LPTIM1_STOP.
	DBG_APB_FZ1_DBG_LPTIM1_STOP = 0x80000000
	// Enable
	DBG_APB_FZ1_DBG_LPTIM1_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_LPTIM1_STOP_B_0x1 = 0x1

	// APB_FZ2: DBG APB freeze register 2
	// Position of DBG_TIM1_STOP field.
	DBG_APB_FZ2_DBG_TIM1_STOP_Pos = 0xb
	// Bit mask of DBG_TIM1_STOP field.
	DBG_APB_FZ2_DBG_TIM1_STOP_Msk = 0x800
	// Bit DBG_TIM1_STOP.
	DBG_APB_FZ2_DBG_TIM1_STOP = 0x800
	// Enable
	DBG_APB_FZ2_DBG_TIM1_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ2_DBG_TIM1_STOP_B_0x1 = 0x1
	// Position of DBG_TIM14_STOP field.
	DBG_APB_FZ2_DBG_TIM14_STOP_Pos = 0xf
	// Bit mask of DBG_TIM14_STOP field.
	DBG_APB_FZ2_DBG_TIM14_STOP_Msk = 0x8000
	// Bit DBG_TIM14_STOP.
	DBG_APB_FZ2_DBG_TIM14_STOP = 0x8000
	// Enable
	DBG_APB_FZ2_DBG_TIM14_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ2_DBG_TIM14_STOP_B_0x1 = 0x1
	// Position of DBG_TIM15_STOP field.
	DBG_APB_FZ2_DBG_TIM15_STOP_Pos = 0x10
	// Bit mask of DBG_TIM15_STOP field.
	DBG_APB_FZ2_DBG_TIM15_STOP_Msk = 0x10000
	// Bit DBG_TIM15_STOP.
	DBG_APB_FZ2_DBG_TIM15_STOP = 0x10000
	// Enable
	DBG_APB_FZ2_DBG_TIM15_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ2_DBG_TIM15_STOP_B_0x1 = 0x1
	// Position of DBG_TIM16_STOP field.
	DBG_APB_FZ2_DBG_TIM16_STOP_Pos = 0x11
	// Bit mask of DBG_TIM16_STOP field.
	DBG_APB_FZ2_DBG_TIM16_STOP_Msk = 0x20000
	// Bit DBG_TIM16_STOP.
	DBG_APB_FZ2_DBG_TIM16_STOP = 0x20000
	// Enable
	DBG_APB_FZ2_DBG_TIM16_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ2_DBG_TIM16_STOP_B_0x1 = 0x1
	// Position of DBG_TIM17_STOP field.
	DBG_APB_FZ2_DBG_TIM17_STOP_Pos = 0x12
	// Bit mask of DBG_TIM17_STOP field.
	DBG_APB_FZ2_DBG_TIM17_STOP_Msk = 0x40000
	// Bit DBG_TIM17_STOP.
	DBG_APB_FZ2_DBG_TIM17_STOP = 0x40000
	// Enable
	DBG_APB_FZ2_DBG_TIM17_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ2_DBG_TIM17_STOP_B_0x1 = 0x1
)

// Constants for DMAMUX: DMAMUX
const (
	// C0CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_C0CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C0CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_C0CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C0CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C0CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_C0CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_C0CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_C0CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C0CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C0CR_EGE = 0x200
	// event generation disabled
	DMAMUX_C0CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_C0CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_C0CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C0CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C0CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_C0CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_C0CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_C0CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C0CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_C0CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_C0CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_C0CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_C0CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_C0CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C0CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C0CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C0CR_SYNC_ID_Msk = 0x1f000000

	// C1CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_C1CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C1CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_C1CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C1CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C1CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_C1CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_C1CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_C1CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C1CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C1CR_EGE = 0x200
	// event generation disabled
	DMAMUX_C1CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_C1CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_C1CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C1CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C1CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_C1CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_C1CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_C1CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C1CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_C1CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_C1CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_C1CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_C1CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_C1CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C1CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C1CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C1CR_SYNC_ID_Msk = 0x1f000000

	// C2CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_C2CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C2CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_C2CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C2CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C2CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_C2CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_C2CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_C2CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C2CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C2CR_EGE = 0x200
	// event generation disabled
	DMAMUX_C2CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_C2CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_C2CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C2CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C2CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_C2CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_C2CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_C2CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C2CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_C2CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_C2CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_C2CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_C2CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_C2CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C2CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C2CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C2CR_SYNC_ID_Msk = 0x1f000000

	// C3CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_C3CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C3CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_C3CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C3CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C3CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_C3CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_C3CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_C3CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C3CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C3CR_EGE = 0x200
	// event generation disabled
	DMAMUX_C3CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_C3CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_C3CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C3CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C3CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_C3CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_C3CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_C3CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C3CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_C3CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_C3CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_C3CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_C3CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_C3CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C3CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C3CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C3CR_SYNC_ID_Msk = 0x1f000000

	// C4CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_C4CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C4CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_C4CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C4CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C4CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_C4CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_C4CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_C4CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C4CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C4CR_EGE = 0x200
	// event generation disabled
	DMAMUX_C4CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_C4CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_C4CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C4CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C4CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_C4CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_C4CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_C4CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C4CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_C4CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_C4CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_C4CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_C4CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_C4CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C4CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C4CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C4CR_SYNC_ID_Msk = 0x1f000000

	// C5CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_C5CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C5CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_C5CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C5CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C5CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_C5CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_C5CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_C5CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C5CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C5CR_EGE = 0x200
	// event generation disabled
	DMAMUX_C5CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_C5CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_C5CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C5CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C5CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_C5CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_C5CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_C5CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C5CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_C5CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_C5CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_C5CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_C5CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_C5CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C5CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C5CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C5CR_SYNC_ID_Msk = 0x1f000000

	// C6CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_C6CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C6CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_C6CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C6CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C6CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_C6CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_C6CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_C6CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C6CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C6CR_EGE = 0x200
	// event generation disabled
	DMAMUX_C6CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_C6CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_C6CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C6CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C6CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_C6CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_C6CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_C6CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C6CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_C6CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_C6CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_C6CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_C6CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_C6CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C6CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C6CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C6CR_SYNC_ID_Msk = 0x1f000000

	// CSR: DMAMUX request line multiplexer interrupt channel status register
	// Position of SOF0 field.
	DMAMUX_CSR_SOF0_Pos = 0x0
	// Bit mask of SOF0 field.
	DMAMUX_CSR_SOF0_Msk = 0x1
	// Bit SOF0.
	DMAMUX_CSR_SOF0 = 0x1
	// Position of SOF1 field.
	DMAMUX_CSR_SOF1_Pos = 0x1
	// Bit mask of SOF1 field.
	DMAMUX_CSR_SOF1_Msk = 0x2
	// Bit SOF1.
	DMAMUX_CSR_SOF1 = 0x2
	// Position of SOF2 field.
	DMAMUX_CSR_SOF2_Pos = 0x2
	// Bit mask of SOF2 field.
	DMAMUX_CSR_SOF2_Msk = 0x4
	// Bit SOF2.
	DMAMUX_CSR_SOF2 = 0x4
	// Position of SOF3 field.
	DMAMUX_CSR_SOF3_Pos = 0x3
	// Bit mask of SOF3 field.
	DMAMUX_CSR_SOF3_Msk = 0x8
	// Bit SOF3.
	DMAMUX_CSR_SOF3 = 0x8
	// Position of SOF4 field.
	DMAMUX_CSR_SOF4_Pos = 0x4
	// Bit mask of SOF4 field.
	DMAMUX_CSR_SOF4_Msk = 0x10
	// Bit SOF4.
	DMAMUX_CSR_SOF4 = 0x10
	// Position of SOF5 field.
	DMAMUX_CSR_SOF5_Pos = 0x5
	// Bit mask of SOF5 field.
	DMAMUX_CSR_SOF5_Msk = 0x20
	// Bit SOF5.
	DMAMUX_CSR_SOF5 = 0x20
	// Position of SOF6 field.
	DMAMUX_CSR_SOF6_Pos = 0x6
	// Bit mask of SOF6 field.
	DMAMUX_CSR_SOF6_Msk = 0x40
	// Bit SOF6.
	DMAMUX_CSR_SOF6 = 0x40

	// CFR: DMAMUX request line multiplexer interrupt clear flag register
	// Position of CSOF0 field.
	DMAMUX_CFR_CSOF0_Pos = 0x0
	// Bit mask of CSOF0 field.
	DMAMUX_CFR_CSOF0_Msk = 0x1
	// Bit CSOF0.
	DMAMUX_CFR_CSOF0 = 0x1
	// Position of CSOF1 field.
	DMAMUX_CFR_CSOF1_Pos = 0x1
	// Bit mask of CSOF1 field.
	DMAMUX_CFR_CSOF1_Msk = 0x2
	// Bit CSOF1.
	DMAMUX_CFR_CSOF1 = 0x2
	// Position of CSOF2 field.
	DMAMUX_CFR_CSOF2_Pos = 0x2
	// Bit mask of CSOF2 field.
	DMAMUX_CFR_CSOF2_Msk = 0x4
	// Bit CSOF2.
	DMAMUX_CFR_CSOF2 = 0x4
	// Position of CSOF3 field.
	DMAMUX_CFR_CSOF3_Pos = 0x3
	// Bit mask of CSOF3 field.
	DMAMUX_CFR_CSOF3_Msk = 0x8
	// Bit CSOF3.
	DMAMUX_CFR_CSOF3 = 0x8
	// Position of CSOF4 field.
	DMAMUX_CFR_CSOF4_Pos = 0x4
	// Bit mask of CSOF4 field.
	DMAMUX_CFR_CSOF4_Msk = 0x10
	// Bit CSOF4.
	DMAMUX_CFR_CSOF4 = 0x10
	// Position of CSOF5 field.
	DMAMUX_CFR_CSOF5_Pos = 0x5
	// Bit mask of CSOF5 field.
	DMAMUX_CFR_CSOF5_Msk = 0x20
	// Bit CSOF5.
	DMAMUX_CFR_CSOF5 = 0x20
	// Position of CSOF6 field.
	DMAMUX_CFR_CSOF6_Pos = 0x6
	// Bit mask of CSOF6 field.
	DMAMUX_CFR_CSOF6_Msk = 0x40
	// Bit CSOF6.
	DMAMUX_CFR_CSOF6 = 0x40

	// RG0CR: DMAMUX request generator channel x configuration register
	// Position of SIG_ID field.
	DMAMUX_RG0CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG0CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_RG0CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG0CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG0CR_OIE = 0x100
	// interrupt on a trigger overrun event occurrence is disabled
	DMAMUX_RG0CR_OIE_B_0x0 = 0x0
	// interrupt on a trigger overrun event occurrence is enabled
	DMAMUX_RG0CR_OIE_B_0x1 = 0x1
	// Position of GE field.
	DMAMUX_RG0CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG0CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG0CR_GE = 0x10000
	// DMA request generator channel x disabled
	DMAMUX_RG0CR_GE_B_0x0 = 0x0
	// DMA request generator channel x enabled
	DMAMUX_RG0CR_GE_B_0x1 = 0x1
	// Position of GPOL field.
	DMAMUX_RG0CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG0CR_GPOL_Msk = 0x60000
	// no event. I.e. none trigger detection nor generation.
	DMAMUX_RG0CR_GPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_RG0CR_GPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_RG0CR_GPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_RG0CR_GPOL_B_0x3 = 0x3
	// Position of GNBREQ field.
	DMAMUX_RG0CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG0CR_GNBREQ_Msk = 0xf80000

	// RG1CR: DMAMUX request generator channel x configuration register
	// Position of SIG_ID field.
	DMAMUX_RG1CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG1CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_RG1CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG1CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG1CR_OIE = 0x100
	// interrupt on a trigger overrun event occurrence is disabled
	DMAMUX_RG1CR_OIE_B_0x0 = 0x0
	// interrupt on a trigger overrun event occurrence is enabled
	DMAMUX_RG1CR_OIE_B_0x1 = 0x1
	// Position of GE field.
	DMAMUX_RG1CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG1CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG1CR_GE = 0x10000
	// DMA request generator channel x disabled
	DMAMUX_RG1CR_GE_B_0x0 = 0x0
	// DMA request generator channel x enabled
	DMAMUX_RG1CR_GE_B_0x1 = 0x1
	// Position of GPOL field.
	DMAMUX_RG1CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG1CR_GPOL_Msk = 0x60000
	// no event. I.e. none trigger detection nor generation.
	DMAMUX_RG1CR_GPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_RG1CR_GPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_RG1CR_GPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_RG1CR_GPOL_B_0x3 = 0x3
	// Position of GNBREQ field.
	DMAMUX_RG1CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG1CR_GNBREQ_Msk = 0xf80000

	// RG2CR: DMAMUX request generator channel x configuration register
	// Position of SIG_ID field.
	DMAMUX_RG2CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG2CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_RG2CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG2CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG2CR_OIE = 0x100
	// interrupt on a trigger overrun event occurrence is disabled
	DMAMUX_RG2CR_OIE_B_0x0 = 0x0
	// interrupt on a trigger overrun event occurrence is enabled
	DMAMUX_RG2CR_OIE_B_0x1 = 0x1
	// Position of GE field.
	DMAMUX_RG2CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG2CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG2CR_GE = 0x10000
	// DMA request generator channel x disabled
	DMAMUX_RG2CR_GE_B_0x0 = 0x0
	// DMA request generator channel x enabled
	DMAMUX_RG2CR_GE_B_0x1 = 0x1
	// Position of GPOL field.
	DMAMUX_RG2CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG2CR_GPOL_Msk = 0x60000
	// no event. I.e. none trigger detection nor generation.
	DMAMUX_RG2CR_GPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_RG2CR_GPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_RG2CR_GPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_RG2CR_GPOL_B_0x3 = 0x3
	// Position of GNBREQ field.
	DMAMUX_RG2CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG2CR_GNBREQ_Msk = 0xf80000

	// RG3CR: DMAMUX request generator channel x configuration register
	// Position of SIG_ID field.
	DMAMUX_RG3CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG3CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_RG3CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG3CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG3CR_OIE = 0x100
	// interrupt on a trigger overrun event occurrence is disabled
	DMAMUX_RG3CR_OIE_B_0x0 = 0x0
	// interrupt on a trigger overrun event occurrence is enabled
	DMAMUX_RG3CR_OIE_B_0x1 = 0x1
	// Position of GE field.
	DMAMUX_RG3CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG3CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG3CR_GE = 0x10000
	// DMA request generator channel x disabled
	DMAMUX_RG3CR_GE_B_0x0 = 0x0
	// DMA request generator channel x enabled
	DMAMUX_RG3CR_GE_B_0x1 = 0x1
	// Position of GPOL field.
	DMAMUX_RG3CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG3CR_GPOL_Msk = 0x60000
	// no event. I.e. none trigger detection nor generation.
	DMAMUX_RG3CR_GPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_RG3CR_GPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_RG3CR_GPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_RG3CR_GPOL_B_0x3 = 0x3
	// Position of GNBREQ field.
	DMAMUX_RG3CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG3CR_GNBREQ_Msk = 0xf80000

	// RGSR: DMAMUX request generator interrupt status register
	// Position of OF0 field.
	DMAMUX_RGSR_OF0_Pos = 0x0
	// Bit mask of OF0 field.
	DMAMUX_RGSR_OF0_Msk = 0x1
	// Bit OF0.
	DMAMUX_RGSR_OF0 = 0x1
	// Position of OF1 field.
	DMAMUX_RGSR_OF1_Pos = 0x1
	// Bit mask of OF1 field.
	DMAMUX_RGSR_OF1_Msk = 0x2
	// Bit OF1.
	DMAMUX_RGSR_OF1 = 0x2
	// Position of OF2 field.
	DMAMUX_RGSR_OF2_Pos = 0x2
	// Bit mask of OF2 field.
	DMAMUX_RGSR_OF2_Msk = 0x4
	// Bit OF2.
	DMAMUX_RGSR_OF2 = 0x4
	// Position of OF3 field.
	DMAMUX_RGSR_OF3_Pos = 0x3
	// Bit mask of OF3 field.
	DMAMUX_RGSR_OF3_Msk = 0x8
	// Bit OF3.
	DMAMUX_RGSR_OF3 = 0x8

	// RGCFR: DMAMUX request generator interrupt clear flag register
	// Position of COF0 field.
	DMAMUX_RGCFR_COF0_Pos = 0x0
	// Bit mask of COF0 field.
	DMAMUX_RGCFR_COF0_Msk = 0x1
	// Bit COF0.
	DMAMUX_RGCFR_COF0 = 0x1
	// Position of COF1 field.
	DMAMUX_RGCFR_COF1_Pos = 0x1
	// Bit mask of COF1 field.
	DMAMUX_RGCFR_COF1_Msk = 0x2
	// Bit COF1.
	DMAMUX_RGCFR_COF1 = 0x2
	// Position of COF2 field.
	DMAMUX_RGCFR_COF2_Pos = 0x2
	// Bit mask of COF2 field.
	DMAMUX_RGCFR_COF2_Msk = 0x4
	// Bit COF2.
	DMAMUX_RGCFR_COF2 = 0x4
	// Position of COF3 field.
	DMAMUX_RGCFR_COF3_Pos = 0x3
	// Bit mask of COF3 field.
	DMAMUX_RGCFR_COF3_Msk = 0x8
	// Bit COF3.
	DMAMUX_RGCFR_COF3 = 0x8
)

// Constants for EXTI: External interrupt/event controller
const (
	// RTSR1: EXTI rising trigger selection register
	// Position of RT0 field.
	EXTI_RTSR1_RT0_Pos = 0x0
	// Bit mask of RT0 field.
	EXTI_RTSR1_RT0_Msk = 0x1
	// Bit RT0.
	EXTI_RTSR1_RT0 = 0x1
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT0_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT0_Enabled = 0x1
	// Position of RT1 field.
	EXTI_RTSR1_RT1_Pos = 0x1
	// Bit mask of RT1 field.
	EXTI_RTSR1_RT1_Msk = 0x2
	// Bit RT1.
	EXTI_RTSR1_RT1 = 0x2
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT1_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT1_Enabled = 0x1
	// Position of RT2 field.
	EXTI_RTSR1_RT2_Pos = 0x2
	// Bit mask of RT2 field.
	EXTI_RTSR1_RT2_Msk = 0x4
	// Bit RT2.
	EXTI_RTSR1_RT2 = 0x4
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT2_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT2_Enabled = 0x1
	// Position of RT3 field.
	EXTI_RTSR1_RT3_Pos = 0x3
	// Bit mask of RT3 field.
	EXTI_RTSR1_RT3_Msk = 0x8
	// Bit RT3.
	EXTI_RTSR1_RT3 = 0x8
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT3_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT3_Enabled = 0x1
	// Position of RT4 field.
	EXTI_RTSR1_RT4_Pos = 0x4
	// Bit mask of RT4 field.
	EXTI_RTSR1_RT4_Msk = 0x10
	// Bit RT4.
	EXTI_RTSR1_RT4 = 0x10
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT4_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT4_Enabled = 0x1
	// Position of RT5 field.
	EXTI_RTSR1_RT5_Pos = 0x5
	// Bit mask of RT5 field.
	EXTI_RTSR1_RT5_Msk = 0x20
	// Bit RT5.
	EXTI_RTSR1_RT5 = 0x20
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT5_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT5_Enabled = 0x1
	// Position of RT6 field.
	EXTI_RTSR1_RT6_Pos = 0x6
	// Bit mask of RT6 field.
	EXTI_RTSR1_RT6_Msk = 0x40
	// Bit RT6.
	EXTI_RTSR1_RT6 = 0x40
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT6_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT6_Enabled = 0x1
	// Position of RT7 field.
	EXTI_RTSR1_RT7_Pos = 0x7
	// Bit mask of RT7 field.
	EXTI_RTSR1_RT7_Msk = 0x80
	// Bit RT7.
	EXTI_RTSR1_RT7 = 0x80
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT7_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT7_Enabled = 0x1
	// Position of RT8 field.
	EXTI_RTSR1_RT8_Pos = 0x8
	// Bit mask of RT8 field.
	EXTI_RTSR1_RT8_Msk = 0x100
	// Bit RT8.
	EXTI_RTSR1_RT8 = 0x100
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT8_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT8_Enabled = 0x1
	// Position of RT9 field.
	EXTI_RTSR1_RT9_Pos = 0x9
	// Bit mask of RT9 field.
	EXTI_RTSR1_RT9_Msk = 0x200
	// Bit RT9.
	EXTI_RTSR1_RT9 = 0x200
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT9_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT9_Enabled = 0x1
	// Position of RT10 field.
	EXTI_RTSR1_RT10_Pos = 0xa
	// Bit mask of RT10 field.
	EXTI_RTSR1_RT10_Msk = 0x400
	// Bit RT10.
	EXTI_RTSR1_RT10 = 0x400
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT10_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT10_Enabled = 0x1
	// Position of RT11 field.
	EXTI_RTSR1_RT11_Pos = 0xb
	// Bit mask of RT11 field.
	EXTI_RTSR1_RT11_Msk = 0x800
	// Bit RT11.
	EXTI_RTSR1_RT11 = 0x800
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT11_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT11_Enabled = 0x1
	// Position of RT12 field.
	EXTI_RTSR1_RT12_Pos = 0xc
	// Bit mask of RT12 field.
	EXTI_RTSR1_RT12_Msk = 0x1000
	// Bit RT12.
	EXTI_RTSR1_RT12 = 0x1000
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT12_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT12_Enabled = 0x1
	// Position of RT13 field.
	EXTI_RTSR1_RT13_Pos = 0xd
	// Bit mask of RT13 field.
	EXTI_RTSR1_RT13_Msk = 0x2000
	// Bit RT13.
	EXTI_RTSR1_RT13 = 0x2000
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT13_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT13_Enabled = 0x1
	// Position of RT14 field.
	EXTI_RTSR1_RT14_Pos = 0xe
	// Bit mask of RT14 field.
	EXTI_RTSR1_RT14_Msk = 0x4000
	// Bit RT14.
	EXTI_RTSR1_RT14 = 0x4000
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT14_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT14_Enabled = 0x1
	// Position of RT15 field.
	EXTI_RTSR1_RT15_Pos = 0xf
	// Bit mask of RT15 field.
	EXTI_RTSR1_RT15_Msk = 0x8000
	// Bit RT15.
	EXTI_RTSR1_RT15 = 0x8000
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT15_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT15_Enabled = 0x1
	// Position of RT16 field.
	EXTI_RTSR1_RT16_Pos = 0x10
	// Bit mask of RT16 field.
	EXTI_RTSR1_RT16_Msk = 0x10000
	// Bit RT16.
	EXTI_RTSR1_RT16 = 0x10000
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT16_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT16_Enabled = 0x1
	// Position of RT17 field.
	EXTI_RTSR1_RT17_Pos = 0x11
	// Bit mask of RT17 field.
	EXTI_RTSR1_RT17_Msk = 0x20000
	// Bit RT17.
	EXTI_RTSR1_RT17 = 0x20000
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT17_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT17_Enabled = 0x1
	// Position of RT18 field.
	EXTI_RTSR1_RT18_Pos = 0x12
	// Bit mask of RT18 field.
	EXTI_RTSR1_RT18_Msk = 0x40000
	// Bit RT18.
	EXTI_RTSR1_RT18 = 0x40000
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT18_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT18_Enabled = 0x1
	// Position of RT20 field.
	EXTI_RTSR1_RT20_Pos = 0x14
	// Bit mask of RT20 field.
	EXTI_RTSR1_RT20_Msk = 0x100000
	// Bit RT20.
	EXTI_RTSR1_RT20 = 0x100000
	// Rising edge trigger is disabled
	EXTI_RTSR1_RT20_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_RT20_Enabled = 0x1

	// FTSR1: EXTI falling trigger selection register
	// Position of FT0 field.
	EXTI_FTSR1_FT0_Pos = 0x0
	// Bit mask of FT0 field.
	EXTI_FTSR1_FT0_Msk = 0x1
	// Bit FT0.
	EXTI_FTSR1_FT0 = 0x1
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT0_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT0_Enabled = 0x1
	// Position of FT1 field.
	EXTI_FTSR1_FT1_Pos = 0x1
	// Bit mask of FT1 field.
	EXTI_FTSR1_FT1_Msk = 0x2
	// Bit FT1.
	EXTI_FTSR1_FT1 = 0x2
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT1_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT1_Enabled = 0x1
	// Position of FT2 field.
	EXTI_FTSR1_FT2_Pos = 0x2
	// Bit mask of FT2 field.
	EXTI_FTSR1_FT2_Msk = 0x4
	// Bit FT2.
	EXTI_FTSR1_FT2 = 0x4
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT2_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT2_Enabled = 0x1
	// Position of FT3 field.
	EXTI_FTSR1_FT3_Pos = 0x3
	// Bit mask of FT3 field.
	EXTI_FTSR1_FT3_Msk = 0x8
	// Bit FT3.
	EXTI_FTSR1_FT3 = 0x8
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT3_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT3_Enabled = 0x1
	// Position of FT4 field.
	EXTI_FTSR1_FT4_Pos = 0x4
	// Bit mask of FT4 field.
	EXTI_FTSR1_FT4_Msk = 0x10
	// Bit FT4.
	EXTI_FTSR1_FT4 = 0x10
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT4_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT4_Enabled = 0x1
	// Position of FT5 field.
	EXTI_FTSR1_FT5_Pos = 0x5
	// Bit mask of FT5 field.
	EXTI_FTSR1_FT5_Msk = 0x20
	// Bit FT5.
	EXTI_FTSR1_FT5 = 0x20
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT5_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT5_Enabled = 0x1
	// Position of FT6 field.
	EXTI_FTSR1_FT6_Pos = 0x6
	// Bit mask of FT6 field.
	EXTI_FTSR1_FT6_Msk = 0x40
	// Bit FT6.
	EXTI_FTSR1_FT6 = 0x40
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT6_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT6_Enabled = 0x1
	// Position of FT7 field.
	EXTI_FTSR1_FT7_Pos = 0x7
	// Bit mask of FT7 field.
	EXTI_FTSR1_FT7_Msk = 0x80
	// Bit FT7.
	EXTI_FTSR1_FT7 = 0x80
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT7_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT7_Enabled = 0x1
	// Position of FT8 field.
	EXTI_FTSR1_FT8_Pos = 0x8
	// Bit mask of FT8 field.
	EXTI_FTSR1_FT8_Msk = 0x100
	// Bit FT8.
	EXTI_FTSR1_FT8 = 0x100
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT8_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT8_Enabled = 0x1
	// Position of FT9 field.
	EXTI_FTSR1_FT9_Pos = 0x9
	// Bit mask of FT9 field.
	EXTI_FTSR1_FT9_Msk = 0x200
	// Bit FT9.
	EXTI_FTSR1_FT9 = 0x200
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT9_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT9_Enabled = 0x1
	// Position of FT10 field.
	EXTI_FTSR1_FT10_Pos = 0xa
	// Bit mask of FT10 field.
	EXTI_FTSR1_FT10_Msk = 0x400
	// Bit FT10.
	EXTI_FTSR1_FT10 = 0x400
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT10_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT10_Enabled = 0x1
	// Position of FT11 field.
	EXTI_FTSR1_FT11_Pos = 0xb
	// Bit mask of FT11 field.
	EXTI_FTSR1_FT11_Msk = 0x800
	// Bit FT11.
	EXTI_FTSR1_FT11 = 0x800
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT11_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT11_Enabled = 0x1
	// Position of FT12 field.
	EXTI_FTSR1_FT12_Pos = 0xc
	// Bit mask of FT12 field.
	EXTI_FTSR1_FT12_Msk = 0x1000
	// Bit FT12.
	EXTI_FTSR1_FT12 = 0x1000
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT12_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT12_Enabled = 0x1
	// Position of FT13 field.
	EXTI_FTSR1_FT13_Pos = 0xd
	// Bit mask of FT13 field.
	EXTI_FTSR1_FT13_Msk = 0x2000
	// Bit FT13.
	EXTI_FTSR1_FT13 = 0x2000
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT13_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT13_Enabled = 0x1
	// Position of FT14 field.
	EXTI_FTSR1_FT14_Pos = 0xe
	// Bit mask of FT14 field.
	EXTI_FTSR1_FT14_Msk = 0x4000
	// Bit FT14.
	EXTI_FTSR1_FT14 = 0x4000
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT14_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT14_Enabled = 0x1
	// Position of FT15 field.
	EXTI_FTSR1_FT15_Pos = 0xf
	// Bit mask of FT15 field.
	EXTI_FTSR1_FT15_Msk = 0x8000
	// Bit FT15.
	EXTI_FTSR1_FT15 = 0x8000
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT15_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT15_Enabled = 0x1
	// Position of FT16 field.
	EXTI_FTSR1_FT16_Pos = 0x10
	// Bit mask of FT16 field.
	EXTI_FTSR1_FT16_Msk = 0x10000
	// Bit FT16.
	EXTI_FTSR1_FT16 = 0x10000
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT16_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT16_Enabled = 0x1
	// Position of FT17 field.
	EXTI_FTSR1_FT17_Pos = 0x11
	// Bit mask of FT17 field.
	EXTI_FTSR1_FT17_Msk = 0x20000
	// Bit FT17.
	EXTI_FTSR1_FT17 = 0x20000
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT17_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT17_Enabled = 0x1
	// Position of FT18 field.
	EXTI_FTSR1_FT18_Pos = 0x12
	// Bit mask of FT18 field.
	EXTI_FTSR1_FT18_Msk = 0x40000
	// Bit FT18.
	EXTI_FTSR1_FT18 = 0x40000
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT18_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT18_Enabled = 0x1
	// Position of FT20 field.
	EXTI_FTSR1_FT20_Pos = 0x14
	// Bit mask of FT20 field.
	EXTI_FTSR1_FT20_Msk = 0x100000
	// Bit FT20.
	EXTI_FTSR1_FT20 = 0x100000
	// Falling edge trigger is disabled
	EXTI_FTSR1_FT20_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_FT20_Enabled = 0x1

	// SWIER1: EXTI software interrupt event register
	// Position of SWI0 field.
	EXTI_SWIER1_SWI0_Pos = 0x0
	// Bit mask of SWI0 field.
	EXTI_SWIER1_SWI0_Msk = 0x1
	// Bit SWI0.
	EXTI_SWIER1_SWI0 = 0x1
	// Generates an interrupt request
	EXTI_SWIER1_SWI0_Pend = 0x1
	// Position of SWI1 field.
	EXTI_SWIER1_SWI1_Pos = 0x1
	// Bit mask of SWI1 field.
	EXTI_SWIER1_SWI1_Msk = 0x2
	// Bit SWI1.
	EXTI_SWIER1_SWI1 = 0x2
	// Generates an interrupt request
	EXTI_SWIER1_SWI1_Pend = 0x1
	// Position of SWI2 field.
	EXTI_SWIER1_SWI2_Pos = 0x2
	// Bit mask of SWI2 field.
	EXTI_SWIER1_SWI2_Msk = 0x4
	// Bit SWI2.
	EXTI_SWIER1_SWI2 = 0x4
	// Generates an interrupt request
	EXTI_SWIER1_SWI2_Pend = 0x1
	// Position of SWI3 field.
	EXTI_SWIER1_SWI3_Pos = 0x3
	// Bit mask of SWI3 field.
	EXTI_SWIER1_SWI3_Msk = 0x8
	// Bit SWI3.
	EXTI_SWIER1_SWI3 = 0x8
	// Generates an interrupt request
	EXTI_SWIER1_SWI3_Pend = 0x1
	// Position of SWI4 field.
	EXTI_SWIER1_SWI4_Pos = 0x4
	// Bit mask of SWI4 field.
	EXTI_SWIER1_SWI4_Msk = 0x10
	// Bit SWI4.
	EXTI_SWIER1_SWI4 = 0x10
	// Generates an interrupt request
	EXTI_SWIER1_SWI4_Pend = 0x1
	// Position of SWI5 field.
	EXTI_SWIER1_SWI5_Pos = 0x5
	// Bit mask of SWI5 field.
	EXTI_SWIER1_SWI5_Msk = 0x20
	// Bit SWI5.
	EXTI_SWIER1_SWI5 = 0x20
	// Generates an interrupt request
	EXTI_SWIER1_SWI5_Pend = 0x1
	// Position of SWI6 field.
	EXTI_SWIER1_SWI6_Pos = 0x6
	// Bit mask of SWI6 field.
	EXTI_SWIER1_SWI6_Msk = 0x40
	// Bit SWI6.
	EXTI_SWIER1_SWI6 = 0x40
	// Generates an interrupt request
	EXTI_SWIER1_SWI6_Pend = 0x1
	// Position of SWI7 field.
	EXTI_SWIER1_SWI7_Pos = 0x7
	// Bit mask of SWI7 field.
	EXTI_SWIER1_SWI7_Msk = 0x80
	// Bit SWI7.
	EXTI_SWIER1_SWI7 = 0x80
	// Generates an interrupt request
	EXTI_SWIER1_SWI7_Pend = 0x1
	// Position of SWI8 field.
	EXTI_SWIER1_SWI8_Pos = 0x8
	// Bit mask of SWI8 field.
	EXTI_SWIER1_SWI8_Msk = 0x100
	// Bit SWI8.
	EXTI_SWIER1_SWI8 = 0x100
	// Generates an interrupt request
	EXTI_SWIER1_SWI8_Pend = 0x1
	// Position of SWI9 field.
	EXTI_SWIER1_SWI9_Pos = 0x9
	// Bit mask of SWI9 field.
	EXTI_SWIER1_SWI9_Msk = 0x200
	// Bit SWI9.
	EXTI_SWIER1_SWI9 = 0x200
	// Generates an interrupt request
	EXTI_SWIER1_SWI9_Pend = 0x1
	// Position of SWI10 field.
	EXTI_SWIER1_SWI10_Pos = 0xa
	// Bit mask of SWI10 field.
	EXTI_SWIER1_SWI10_Msk = 0x400
	// Bit SWI10.
	EXTI_SWIER1_SWI10 = 0x400
	// Generates an interrupt request
	EXTI_SWIER1_SWI10_Pend = 0x1
	// Position of SWI11 field.
	EXTI_SWIER1_SWI11_Pos = 0xb
	// Bit mask of SWI11 field.
	EXTI_SWIER1_SWI11_Msk = 0x800
	// Bit SWI11.
	EXTI_SWIER1_SWI11 = 0x800
	// Generates an interrupt request
	EXTI_SWIER1_SWI11_Pend = 0x1
	// Position of SWI12 field.
	EXTI_SWIER1_SWI12_Pos = 0xc
	// Bit mask of SWI12 field.
	EXTI_SWIER1_SWI12_Msk = 0x1000
	// Bit SWI12.
	EXTI_SWIER1_SWI12 = 0x1000
	// Generates an interrupt request
	EXTI_SWIER1_SWI12_Pend = 0x1
	// Position of SWI13 field.
	EXTI_SWIER1_SWI13_Pos = 0xd
	// Bit mask of SWI13 field.
	EXTI_SWIER1_SWI13_Msk = 0x2000
	// Bit SWI13.
	EXTI_SWIER1_SWI13 = 0x2000
	// Generates an interrupt request
	EXTI_SWIER1_SWI13_Pend = 0x1
	// Position of SWI14 field.
	EXTI_SWIER1_SWI14_Pos = 0xe
	// Bit mask of SWI14 field.
	EXTI_SWIER1_SWI14_Msk = 0x4000
	// Bit SWI14.
	EXTI_SWIER1_SWI14 = 0x4000
	// Generates an interrupt request
	EXTI_SWIER1_SWI14_Pend = 0x1
	// Position of SWI15 field.
	EXTI_SWIER1_SWI15_Pos = 0xf
	// Bit mask of SWI15 field.
	EXTI_SWIER1_SWI15_Msk = 0x8000
	// Bit SWI15.
	EXTI_SWIER1_SWI15 = 0x8000
	// Generates an interrupt request
	EXTI_SWIER1_SWI15_Pend = 0x1
	// Position of SWI16 field.
	EXTI_SWIER1_SWI16_Pos = 0x10
	// Bit mask of SWI16 field.
	EXTI_SWIER1_SWI16_Msk = 0x10000
	// Bit SWI16.
	EXTI_SWIER1_SWI16 = 0x10000
	// Generates an interrupt request
	EXTI_SWIER1_SWI16_Pend = 0x1
	// Position of SWI17 field.
	EXTI_SWIER1_SWI17_Pos = 0x11
	// Bit mask of SWI17 field.
	EXTI_SWIER1_SWI17_Msk = 0x20000
	// Bit SWI17.
	EXTI_SWIER1_SWI17 = 0x20000
	// Generates an interrupt request
	EXTI_SWIER1_SWI17_Pend = 0x1
	// Position of SWI18 field.
	EXTI_SWIER1_SWI18_Pos = 0x12
	// Bit mask of SWI18 field.
	EXTI_SWIER1_SWI18_Msk = 0x40000
	// Bit SWI18.
	EXTI_SWIER1_SWI18 = 0x40000
	// Generates an interrupt request
	EXTI_SWIER1_SWI18_Pend = 0x1
	// Position of SWI20 field.
	EXTI_SWIER1_SWI20_Pos = 0x14
	// Bit mask of SWI20 field.
	EXTI_SWIER1_SWI20_Msk = 0x100000
	// Bit SWI20.
	EXTI_SWIER1_SWI20 = 0x100000
	// Generates an interrupt request
	EXTI_SWIER1_SWI20_Pend = 0x1

	// RPR1: EXTI rising edge pending register
	// Position of RPIF0 field.
	EXTI_RPR1_RPIF0_Pos = 0x0
	// Bit mask of RPIF0 field.
	EXTI_RPR1_RPIF0_Msk = 0x1
	// Bit RPIF0.
	EXTI_RPR1_RPIF0 = 0x1
	// No trigger request occurred
	EXTI_RPR1_RPIF0_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF0_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF0_Clear = 0x1
	// Position of RPIF1 field.
	EXTI_RPR1_RPIF1_Pos = 0x1
	// Bit mask of RPIF1 field.
	EXTI_RPR1_RPIF1_Msk = 0x2
	// Bit RPIF1.
	EXTI_RPR1_RPIF1 = 0x2
	// No trigger request occurred
	EXTI_RPR1_RPIF1_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF1_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF1_Clear = 0x1
	// Position of RPIF2 field.
	EXTI_RPR1_RPIF2_Pos = 0x2
	// Bit mask of RPIF2 field.
	EXTI_RPR1_RPIF2_Msk = 0x4
	// Bit RPIF2.
	EXTI_RPR1_RPIF2 = 0x4
	// No trigger request occurred
	EXTI_RPR1_RPIF2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF2_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF2_Clear = 0x1
	// Position of RPIF3 field.
	EXTI_RPR1_RPIF3_Pos = 0x3
	// Bit mask of RPIF3 field.
	EXTI_RPR1_RPIF3_Msk = 0x8
	// Bit RPIF3.
	EXTI_RPR1_RPIF3 = 0x8
	// No trigger request occurred
	EXTI_RPR1_RPIF3_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF3_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF3_Clear = 0x1
	// Position of RPIF4 field.
	EXTI_RPR1_RPIF4_Pos = 0x4
	// Bit mask of RPIF4 field.
	EXTI_RPR1_RPIF4_Msk = 0x10
	// Bit RPIF4.
	EXTI_RPR1_RPIF4 = 0x10
	// No trigger request occurred
	EXTI_RPR1_RPIF4_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF4_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF4_Clear = 0x1
	// Position of RPIF5 field.
	EXTI_RPR1_RPIF5_Pos = 0x5
	// Bit mask of RPIF5 field.
	EXTI_RPR1_RPIF5_Msk = 0x20
	// Bit RPIF5.
	EXTI_RPR1_RPIF5 = 0x20
	// No trigger request occurred
	EXTI_RPR1_RPIF5_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF5_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF5_Clear = 0x1
	// Position of RPIF6 field.
	EXTI_RPR1_RPIF6_Pos = 0x6
	// Bit mask of RPIF6 field.
	EXTI_RPR1_RPIF6_Msk = 0x40
	// Bit RPIF6.
	EXTI_RPR1_RPIF6 = 0x40
	// No trigger request occurred
	EXTI_RPR1_RPIF6_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF6_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF6_Clear = 0x1
	// Position of RPIF7 field.
	EXTI_RPR1_RPIF7_Pos = 0x7
	// Bit mask of RPIF7 field.
	EXTI_RPR1_RPIF7_Msk = 0x80
	// Bit RPIF7.
	EXTI_RPR1_RPIF7 = 0x80
	// No trigger request occurred
	EXTI_RPR1_RPIF7_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF7_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF7_Clear = 0x1
	// Position of RPIF8 field.
	EXTI_RPR1_RPIF8_Pos = 0x8
	// Bit mask of RPIF8 field.
	EXTI_RPR1_RPIF8_Msk = 0x100
	// Bit RPIF8.
	EXTI_RPR1_RPIF8 = 0x100
	// No trigger request occurred
	EXTI_RPR1_RPIF8_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF8_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF8_Clear = 0x1
	// Position of RPIF9 field.
	EXTI_RPR1_RPIF9_Pos = 0x9
	// Bit mask of RPIF9 field.
	EXTI_RPR1_RPIF9_Msk = 0x200
	// Bit RPIF9.
	EXTI_RPR1_RPIF9 = 0x200
	// No trigger request occurred
	EXTI_RPR1_RPIF9_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF9_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF9_Clear = 0x1
	// Position of RPIF10 field.
	EXTI_RPR1_RPIF10_Pos = 0xa
	// Bit mask of RPIF10 field.
	EXTI_RPR1_RPIF10_Msk = 0x400
	// Bit RPIF10.
	EXTI_RPR1_RPIF10 = 0x400
	// No trigger request occurred
	EXTI_RPR1_RPIF10_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF10_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF10_Clear = 0x1
	// Position of RPIF11 field.
	EXTI_RPR1_RPIF11_Pos = 0xb
	// Bit mask of RPIF11 field.
	EXTI_RPR1_RPIF11_Msk = 0x800
	// Bit RPIF11.
	EXTI_RPR1_RPIF11 = 0x800
	// No trigger request occurred
	EXTI_RPR1_RPIF11_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF11_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF11_Clear = 0x1
	// Position of RPIF12 field.
	EXTI_RPR1_RPIF12_Pos = 0xc
	// Bit mask of RPIF12 field.
	EXTI_RPR1_RPIF12_Msk = 0x1000
	// Bit RPIF12.
	EXTI_RPR1_RPIF12 = 0x1000
	// No trigger request occurred
	EXTI_RPR1_RPIF12_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF12_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF12_Clear = 0x1
	// Position of RPIF13 field.
	EXTI_RPR1_RPIF13_Pos = 0xd
	// Bit mask of RPIF13 field.
	EXTI_RPR1_RPIF13_Msk = 0x2000
	// Bit RPIF13.
	EXTI_RPR1_RPIF13 = 0x2000
	// No trigger request occurred
	EXTI_RPR1_RPIF13_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF13_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF13_Clear = 0x1
	// Position of RPIF14 field.
	EXTI_RPR1_RPIF14_Pos = 0xe
	// Bit mask of RPIF14 field.
	EXTI_RPR1_RPIF14_Msk = 0x4000
	// Bit RPIF14.
	EXTI_RPR1_RPIF14 = 0x4000
	// No trigger request occurred
	EXTI_RPR1_RPIF14_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF14_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF14_Clear = 0x1
	// Position of RPIF15 field.
	EXTI_RPR1_RPIF15_Pos = 0xf
	// Bit mask of RPIF15 field.
	EXTI_RPR1_RPIF15_Msk = 0x8000
	// Bit RPIF15.
	EXTI_RPR1_RPIF15 = 0x8000
	// No trigger request occurred
	EXTI_RPR1_RPIF15_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF15_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF15_Clear = 0x1
	// Position of RPIF16 field.
	EXTI_RPR1_RPIF16_Pos = 0x10
	// Bit mask of RPIF16 field.
	EXTI_RPR1_RPIF16_Msk = 0x10000
	// Bit RPIF16.
	EXTI_RPR1_RPIF16 = 0x10000
	// No trigger request occurred
	EXTI_RPR1_RPIF16_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF16_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF16_Clear = 0x1
	// Position of RPIF17 field.
	EXTI_RPR1_RPIF17_Pos = 0x11
	// Bit mask of RPIF17 field.
	EXTI_RPR1_RPIF17_Msk = 0x20000
	// Bit RPIF17.
	EXTI_RPR1_RPIF17 = 0x20000
	// No trigger request occurred
	EXTI_RPR1_RPIF17_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF17_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF17_Clear = 0x1
	// Position of RPIF18 field.
	EXTI_RPR1_RPIF18_Pos = 0x12
	// Bit mask of RPIF18 field.
	EXTI_RPR1_RPIF18_Msk = 0x40000
	// Bit RPIF18.
	EXTI_RPR1_RPIF18 = 0x40000
	// No trigger request occurred
	EXTI_RPR1_RPIF18_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF18_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF18_Clear = 0x1
	// Position of RPIF20 field.
	EXTI_RPR1_RPIF20_Pos = 0x14
	// Bit mask of RPIF20 field.
	EXTI_RPR1_RPIF20_Msk = 0x100000
	// Bit RPIF20.
	EXTI_RPR1_RPIF20 = 0x100000
	// No trigger request occurred
	EXTI_RPR1_RPIF20_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR1_RPIF20_Pending = 0x1
	// Clears pending bit
	EXTI_RPR1_RPIF20_Clear = 0x1

	// FPR1: EXTI falling edge pending register
	// Position of FPIF0 field.
	EXTI_FPR1_FPIF0_Pos = 0x0
	// Bit mask of FPIF0 field.
	EXTI_FPR1_FPIF0_Msk = 0x1
	// Bit FPIF0.
	EXTI_FPR1_FPIF0 = 0x1
	// No trigger request occurred
	EXTI_FPR1_FPIF0_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF0_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF0_Clear = 0x1
	// Position of FPIF1 field.
	EXTI_FPR1_FPIF1_Pos = 0x1
	// Bit mask of FPIF1 field.
	EXTI_FPR1_FPIF1_Msk = 0x2
	// Bit FPIF1.
	EXTI_FPR1_FPIF1 = 0x2
	// No trigger request occurred
	EXTI_FPR1_FPIF1_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF1_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF1_Clear = 0x1
	// Position of FPIF2 field.
	EXTI_FPR1_FPIF2_Pos = 0x2
	// Bit mask of FPIF2 field.
	EXTI_FPR1_FPIF2_Msk = 0x4
	// Bit FPIF2.
	EXTI_FPR1_FPIF2 = 0x4
	// No trigger request occurred
	EXTI_FPR1_FPIF2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF2_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF2_Clear = 0x1
	// Position of FPIF3 field.
	EXTI_FPR1_FPIF3_Pos = 0x3
	// Bit mask of FPIF3 field.
	EXTI_FPR1_FPIF3_Msk = 0x8
	// Bit FPIF3.
	EXTI_FPR1_FPIF3 = 0x8
	// No trigger request occurred
	EXTI_FPR1_FPIF3_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF3_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF3_Clear = 0x1
	// Position of FPIF4 field.
	EXTI_FPR1_FPIF4_Pos = 0x4
	// Bit mask of FPIF4 field.
	EXTI_FPR1_FPIF4_Msk = 0x10
	// Bit FPIF4.
	EXTI_FPR1_FPIF4 = 0x10
	// No trigger request occurred
	EXTI_FPR1_FPIF4_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF4_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF4_Clear = 0x1
	// Position of FPIF5 field.
	EXTI_FPR1_FPIF5_Pos = 0x5
	// Bit mask of FPIF5 field.
	EXTI_FPR1_FPIF5_Msk = 0x20
	// Bit FPIF5.
	EXTI_FPR1_FPIF5 = 0x20
	// No trigger request occurred
	EXTI_FPR1_FPIF5_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF5_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF5_Clear = 0x1
	// Position of FPIF6 field.
	EXTI_FPR1_FPIF6_Pos = 0x6
	// Bit mask of FPIF6 field.
	EXTI_FPR1_FPIF6_Msk = 0x40
	// Bit FPIF6.
	EXTI_FPR1_FPIF6 = 0x40
	// No trigger request occurred
	EXTI_FPR1_FPIF6_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF6_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF6_Clear = 0x1
	// Position of FPIF7 field.
	EXTI_FPR1_FPIF7_Pos = 0x7
	// Bit mask of FPIF7 field.
	EXTI_FPR1_FPIF7_Msk = 0x80
	// Bit FPIF7.
	EXTI_FPR1_FPIF7 = 0x80
	// No trigger request occurred
	EXTI_FPR1_FPIF7_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF7_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF7_Clear = 0x1
	// Position of FPIF8 field.
	EXTI_FPR1_FPIF8_Pos = 0x8
	// Bit mask of FPIF8 field.
	EXTI_FPR1_FPIF8_Msk = 0x100
	// Bit FPIF8.
	EXTI_FPR1_FPIF8 = 0x100
	// No trigger request occurred
	EXTI_FPR1_FPIF8_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF8_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF8_Clear = 0x1
	// Position of FPIF9 field.
	EXTI_FPR1_FPIF9_Pos = 0x9
	// Bit mask of FPIF9 field.
	EXTI_FPR1_FPIF9_Msk = 0x200
	// Bit FPIF9.
	EXTI_FPR1_FPIF9 = 0x200
	// No trigger request occurred
	EXTI_FPR1_FPIF9_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF9_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF9_Clear = 0x1
	// Position of FPIF10 field.
	EXTI_FPR1_FPIF10_Pos = 0xa
	// Bit mask of FPIF10 field.
	EXTI_FPR1_FPIF10_Msk = 0x400
	// Bit FPIF10.
	EXTI_FPR1_FPIF10 = 0x400
	// No trigger request occurred
	EXTI_FPR1_FPIF10_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF10_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF10_Clear = 0x1
	// Position of FPIF11 field.
	EXTI_FPR1_FPIF11_Pos = 0xb
	// Bit mask of FPIF11 field.
	EXTI_FPR1_FPIF11_Msk = 0x800
	// Bit FPIF11.
	EXTI_FPR1_FPIF11 = 0x800
	// No trigger request occurred
	EXTI_FPR1_FPIF11_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF11_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF11_Clear = 0x1
	// Position of FPIF12 field.
	EXTI_FPR1_FPIF12_Pos = 0xc
	// Bit mask of FPIF12 field.
	EXTI_FPR1_FPIF12_Msk = 0x1000
	// Bit FPIF12.
	EXTI_FPR1_FPIF12 = 0x1000
	// No trigger request occurred
	EXTI_FPR1_FPIF12_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF12_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF12_Clear = 0x1
	// Position of FPIF13 field.
	EXTI_FPR1_FPIF13_Pos = 0xd
	// Bit mask of FPIF13 field.
	EXTI_FPR1_FPIF13_Msk = 0x2000
	// Bit FPIF13.
	EXTI_FPR1_FPIF13 = 0x2000
	// No trigger request occurred
	EXTI_FPR1_FPIF13_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF13_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF13_Clear = 0x1
	// Position of FPIF14 field.
	EXTI_FPR1_FPIF14_Pos = 0xe
	// Bit mask of FPIF14 field.
	EXTI_FPR1_FPIF14_Msk = 0x4000
	// Bit FPIF14.
	EXTI_FPR1_FPIF14 = 0x4000
	// No trigger request occurred
	EXTI_FPR1_FPIF14_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF14_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF14_Clear = 0x1
	// Position of FPIF15 field.
	EXTI_FPR1_FPIF15_Pos = 0xf
	// Bit mask of FPIF15 field.
	EXTI_FPR1_FPIF15_Msk = 0x8000
	// Bit FPIF15.
	EXTI_FPR1_FPIF15 = 0x8000
	// No trigger request occurred
	EXTI_FPR1_FPIF15_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF15_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF15_Clear = 0x1
	// Position of FPIF16 field.
	EXTI_FPR1_FPIF16_Pos = 0x10
	// Bit mask of FPIF16 field.
	EXTI_FPR1_FPIF16_Msk = 0x10000
	// Bit FPIF16.
	EXTI_FPR1_FPIF16 = 0x10000
	// No trigger request occurred
	EXTI_FPR1_FPIF16_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF16_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF16_Clear = 0x1
	// Position of FPIF17 field.
	EXTI_FPR1_FPIF17_Pos = 0x11
	// Bit mask of FPIF17 field.
	EXTI_FPR1_FPIF17_Msk = 0x20000
	// Bit FPIF17.
	EXTI_FPR1_FPIF17 = 0x20000
	// No trigger request occurred
	EXTI_FPR1_FPIF17_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF17_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF17_Clear = 0x1
	// Position of FPIF18 field.
	EXTI_FPR1_FPIF18_Pos = 0x12
	// Bit mask of FPIF18 field.
	EXTI_FPR1_FPIF18_Msk = 0x40000
	// Bit FPIF18.
	EXTI_FPR1_FPIF18 = 0x40000
	// No trigger request occurred
	EXTI_FPR1_FPIF18_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF18_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF18_Clear = 0x1
	// Position of FPIF20 field.
	EXTI_FPR1_FPIF20_Pos = 0x14
	// Bit mask of FPIF20 field.
	EXTI_FPR1_FPIF20_Msk = 0x100000
	// Bit FPIF20.
	EXTI_FPR1_FPIF20 = 0x100000
	// No trigger request occurred
	EXTI_FPR1_FPIF20_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR1_FPIF20_Pending = 0x1
	// Clears pending bit
	EXTI_FPR1_FPIF20_Clear = 0x1

	// RTSR2: EXTI rising trigger selection register 2
	// Position of RT2 field.
	EXTI_RTSR2_RT2_Pos = 0x2
	// Bit mask of RT2 field.
	EXTI_RTSR2_RT2_Msk = 0x4
	// Bit RT2.
	EXTI_RTSR2_RT2 = 0x4
	// Rising edge trigger is disabled
	EXTI_RTSR2_RT2_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR2_RT2_Enabled = 0x1

	// FTSR2: EXTI falling trigger selection register 2
	// Position of FT2 field.
	EXTI_FTSR2_FT2_Pos = 0x2
	// Bit mask of FT2 field.
	EXTI_FTSR2_FT2_Msk = 0x4
	// Bit FT2.
	EXTI_FTSR2_FT2 = 0x4
	// Falling edge trigger is disabled
	EXTI_FTSR2_FT2_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR2_FT2_Enabled = 0x1

	// SWIER2: EXTI software interrupt event register 2
	// Position of SWI2 field.
	EXTI_SWIER2_SWI2_Pos = 0x2
	// Bit mask of SWI2 field.
	EXTI_SWIER2_SWI2_Msk = 0x4
	// Bit SWI2.
	EXTI_SWIER2_SWI2 = 0x4
	// Generates an interrupt request
	EXTI_SWIER2_SWI2_Pend = 0x1

	// RPR2: EXTI rising edge pending register 2
	// Position of RPIF2 field.
	EXTI_RPR2_RPIF2_Pos = 0x2
	// Bit mask of RPIF2 field.
	EXTI_RPR2_RPIF2_Msk = 0x4
	// Bit RPIF2.
	EXTI_RPR2_RPIF2 = 0x4
	// No trigger request occurred
	EXTI_RPR2_RPIF2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_RPR2_RPIF2_Pending = 0x1
	// Clears pending bit
	EXTI_RPR2_RPIF2_Clear = 0x1

	// FPR2: EXTI falling edge pending register 2
	// Position of FPIF2 field.
	EXTI_FPR2_FPIF2_Pos = 0x2
	// Bit mask of FPIF2 field.
	EXTI_FPR2_FPIF2_Msk = 0x4
	// Bit FPIF2.
	EXTI_FPR2_FPIF2 = 0x4
	// No trigger request occurred
	EXTI_FPR2_FPIF2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_FPR2_FPIF2_Pending = 0x1
	// Clears pending bit
	EXTI_FPR2_FPIF2_Clear = 0x1

	// EXTICR1: EXTI external interrupt selection register
	// Position of EXTI0_7 field.
	EXTI_EXTICR1_EXTI0_7_Pos = 0x0
	// Bit mask of EXTI0_7 field.
	EXTI_EXTICR1_EXTI0_7_Msk = 0xff
	// GPIO port A selected
	EXTI_EXTICR1_EXTI0_7_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR1_EXTI0_7_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR1_EXTI0_7_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR1_EXTI0_7_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR1_EXTI0_7_PF = 0x5
	// Position of EXTI8_15 field.
	EXTI_EXTICR1_EXTI8_15_Pos = 0x8
	// Bit mask of EXTI8_15 field.
	EXTI_EXTICR1_EXTI8_15_Msk = 0xff00
	// GPIO port A selected
	EXTI_EXTICR1_EXTI8_15_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR1_EXTI8_15_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR1_EXTI8_15_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR1_EXTI8_15_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR1_EXTI8_15_PF = 0x5
	// Position of EXTI16_23 field.
	EXTI_EXTICR1_EXTI16_23_Pos = 0x10
	// Bit mask of EXTI16_23 field.
	EXTI_EXTICR1_EXTI16_23_Msk = 0xff0000
	// GPIO port A selected
	EXTI_EXTICR1_EXTI16_23_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR1_EXTI16_23_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR1_EXTI16_23_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR1_EXTI16_23_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR1_EXTI16_23_PF = 0x5
	// Position of EXTI24_31 field.
	EXTI_EXTICR1_EXTI24_31_Pos = 0x18
	// Bit mask of EXTI24_31 field.
	EXTI_EXTICR1_EXTI24_31_Msk = 0xff000000
	// GPIO port A selected
	EXTI_EXTICR1_EXTI24_31_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR1_EXTI24_31_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR1_EXTI24_31_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR1_EXTI24_31_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR1_EXTI24_31_PF = 0x5

	// EXTICR2: EXTI external interrupt selection register
	// Position of EXTI0_7 field.
	EXTI_EXTICR2_EXTI0_7_Pos = 0x0
	// Bit mask of EXTI0_7 field.
	EXTI_EXTICR2_EXTI0_7_Msk = 0xff
	// GPIO port A selected
	EXTI_EXTICR2_EXTI0_7_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR2_EXTI0_7_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR2_EXTI0_7_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR2_EXTI0_7_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR2_EXTI0_7_PF = 0x5
	// Position of EXTI8_15 field.
	EXTI_EXTICR2_EXTI8_15_Pos = 0x8
	// Bit mask of EXTI8_15 field.
	EXTI_EXTICR2_EXTI8_15_Msk = 0xff00
	// GPIO port A selected
	EXTI_EXTICR2_EXTI8_15_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR2_EXTI8_15_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR2_EXTI8_15_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR2_EXTI8_15_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR2_EXTI8_15_PF = 0x5
	// Position of EXTI16_23 field.
	EXTI_EXTICR2_EXTI16_23_Pos = 0x10
	// Bit mask of EXTI16_23 field.
	EXTI_EXTICR2_EXTI16_23_Msk = 0xff0000
	// GPIO port A selected
	EXTI_EXTICR2_EXTI16_23_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR2_EXTI16_23_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR2_EXTI16_23_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR2_EXTI16_23_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR2_EXTI16_23_PF = 0x5
	// Position of EXTI24_31 field.
	EXTI_EXTICR2_EXTI24_31_Pos = 0x18
	// Bit mask of EXTI24_31 field.
	EXTI_EXTICR2_EXTI24_31_Msk = 0xff000000
	// GPIO port A selected
	EXTI_EXTICR2_EXTI24_31_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR2_EXTI24_31_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR2_EXTI24_31_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR2_EXTI24_31_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR2_EXTI24_31_PF = 0x5

	// EXTICR3: EXTI external interrupt selection register
	// Position of EXTI0_7 field.
	EXTI_EXTICR3_EXTI0_7_Pos = 0x0
	// Bit mask of EXTI0_7 field.
	EXTI_EXTICR3_EXTI0_7_Msk = 0xff
	// GPIO port A selected
	EXTI_EXTICR3_EXTI0_7_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR3_EXTI0_7_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR3_EXTI0_7_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR3_EXTI0_7_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR3_EXTI0_7_PF = 0x5
	// Position of EXTI8_15 field.
	EXTI_EXTICR3_EXTI8_15_Pos = 0x8
	// Bit mask of EXTI8_15 field.
	EXTI_EXTICR3_EXTI8_15_Msk = 0xff00
	// GPIO port A selected
	EXTI_EXTICR3_EXTI8_15_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR3_EXTI8_15_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR3_EXTI8_15_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR3_EXTI8_15_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR3_EXTI8_15_PF = 0x5
	// Position of EXTI16_23 field.
	EXTI_EXTICR3_EXTI16_23_Pos = 0x10
	// Bit mask of EXTI16_23 field.
	EXTI_EXTICR3_EXTI16_23_Msk = 0xff0000
	// GPIO port A selected
	EXTI_EXTICR3_EXTI16_23_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR3_EXTI16_23_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR3_EXTI16_23_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR3_EXTI16_23_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR3_EXTI16_23_PF = 0x5
	// Position of EXTI24_31 field.
	EXTI_EXTICR3_EXTI24_31_Pos = 0x18
	// Bit mask of EXTI24_31 field.
	EXTI_EXTICR3_EXTI24_31_Msk = 0xff000000
	// GPIO port A selected
	EXTI_EXTICR3_EXTI24_31_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR3_EXTI24_31_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR3_EXTI24_31_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR3_EXTI24_31_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR3_EXTI24_31_PF = 0x5

	// EXTICR4: EXTI external interrupt selection register
	// Position of EXTI0_7 field.
	EXTI_EXTICR4_EXTI0_7_Pos = 0x0
	// Bit mask of EXTI0_7 field.
	EXTI_EXTICR4_EXTI0_7_Msk = 0xff
	// GPIO port A selected
	EXTI_EXTICR4_EXTI0_7_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR4_EXTI0_7_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR4_EXTI0_7_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR4_EXTI0_7_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR4_EXTI0_7_PF = 0x5
	// Position of EXTI8_15 field.
	EXTI_EXTICR4_EXTI8_15_Pos = 0x8
	// Bit mask of EXTI8_15 field.
	EXTI_EXTICR4_EXTI8_15_Msk = 0xff00
	// GPIO port A selected
	EXTI_EXTICR4_EXTI8_15_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR4_EXTI8_15_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR4_EXTI8_15_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR4_EXTI8_15_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR4_EXTI8_15_PF = 0x5
	// Position of EXTI16_23 field.
	EXTI_EXTICR4_EXTI16_23_Pos = 0x10
	// Bit mask of EXTI16_23 field.
	EXTI_EXTICR4_EXTI16_23_Msk = 0xff0000
	// GPIO port A selected
	EXTI_EXTICR4_EXTI16_23_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR4_EXTI16_23_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR4_EXTI16_23_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR4_EXTI16_23_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR4_EXTI16_23_PF = 0x5
	// Position of EXTI24_31 field.
	EXTI_EXTICR4_EXTI24_31_Pos = 0x18
	// Bit mask of EXTI24_31 field.
	EXTI_EXTICR4_EXTI24_31_Msk = 0xff000000
	// GPIO port A selected
	EXTI_EXTICR4_EXTI24_31_PA = 0x0
	// GPIO port B selected
	EXTI_EXTICR4_EXTI24_31_PB = 0x1
	// GPIO port C selected
	EXTI_EXTICR4_EXTI24_31_PC = 0x2
	// GPIO port D selected
	EXTI_EXTICR4_EXTI24_31_PD = 0x3
	// GPIO port F selected
	EXTI_EXTICR4_EXTI24_31_PF = 0x5

	// IMR1: EXTI CPU wakeup with interrupt mask register
	// Position of IM0 field.
	EXTI_IMR1_IM0_Pos = 0x0
	// Bit mask of IM0 field.
	EXTI_IMR1_IM0_Msk = 0x1
	// Bit IM0.
	EXTI_IMR1_IM0 = 0x1
	// Interrupt request line is masked
	EXTI_IMR1_IM0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM0_Unmasked = 0x1
	// Position of IM1 field.
	EXTI_IMR1_IM1_Pos = 0x1
	// Bit mask of IM1 field.
	EXTI_IMR1_IM1_Msk = 0x2
	// Bit IM1.
	EXTI_IMR1_IM1 = 0x2
	// Interrupt request line is masked
	EXTI_IMR1_IM1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM1_Unmasked = 0x1
	// Position of IM2 field.
	EXTI_IMR1_IM2_Pos = 0x2
	// Bit mask of IM2 field.
	EXTI_IMR1_IM2_Msk = 0x4
	// Bit IM2.
	EXTI_IMR1_IM2 = 0x4
	// Interrupt request line is masked
	EXTI_IMR1_IM2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM2_Unmasked = 0x1
	// Position of IM3 field.
	EXTI_IMR1_IM3_Pos = 0x3
	// Bit mask of IM3 field.
	EXTI_IMR1_IM3_Msk = 0x8
	// Bit IM3.
	EXTI_IMR1_IM3 = 0x8
	// Interrupt request line is masked
	EXTI_IMR1_IM3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM3_Unmasked = 0x1
	// Position of IM4 field.
	EXTI_IMR1_IM4_Pos = 0x4
	// Bit mask of IM4 field.
	EXTI_IMR1_IM4_Msk = 0x10
	// Bit IM4.
	EXTI_IMR1_IM4 = 0x10
	// Interrupt request line is masked
	EXTI_IMR1_IM4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM4_Unmasked = 0x1
	// Position of IM5 field.
	EXTI_IMR1_IM5_Pos = 0x5
	// Bit mask of IM5 field.
	EXTI_IMR1_IM5_Msk = 0x20
	// Bit IM5.
	EXTI_IMR1_IM5 = 0x20
	// Interrupt request line is masked
	EXTI_IMR1_IM5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM5_Unmasked = 0x1
	// Position of IM6 field.
	EXTI_IMR1_IM6_Pos = 0x6
	// Bit mask of IM6 field.
	EXTI_IMR1_IM6_Msk = 0x40
	// Bit IM6.
	EXTI_IMR1_IM6 = 0x40
	// Interrupt request line is masked
	EXTI_IMR1_IM6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM6_Unmasked = 0x1
	// Position of IM7 field.
	EXTI_IMR1_IM7_Pos = 0x7
	// Bit mask of IM7 field.
	EXTI_IMR1_IM7_Msk = 0x80
	// Bit IM7.
	EXTI_IMR1_IM7 = 0x80
	// Interrupt request line is masked
	EXTI_IMR1_IM7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM7_Unmasked = 0x1
	// Position of IM8 field.
	EXTI_IMR1_IM8_Pos = 0x8
	// Bit mask of IM8 field.
	EXTI_IMR1_IM8_Msk = 0x100
	// Bit IM8.
	EXTI_IMR1_IM8 = 0x100
	// Interrupt request line is masked
	EXTI_IMR1_IM8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM8_Unmasked = 0x1
	// Position of IM9 field.
	EXTI_IMR1_IM9_Pos = 0x9
	// Bit mask of IM9 field.
	EXTI_IMR1_IM9_Msk = 0x200
	// Bit IM9.
	EXTI_IMR1_IM9 = 0x200
	// Interrupt request line is masked
	EXTI_IMR1_IM9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM9_Unmasked = 0x1
	// Position of IM10 field.
	EXTI_IMR1_IM10_Pos = 0xa
	// Bit mask of IM10 field.
	EXTI_IMR1_IM10_Msk = 0x400
	// Bit IM10.
	EXTI_IMR1_IM10 = 0x400
	// Interrupt request line is masked
	EXTI_IMR1_IM10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM10_Unmasked = 0x1
	// Position of IM11 field.
	EXTI_IMR1_IM11_Pos = 0xb
	// Bit mask of IM11 field.
	EXTI_IMR1_IM11_Msk = 0x800
	// Bit IM11.
	EXTI_IMR1_IM11 = 0x800
	// Interrupt request line is masked
	EXTI_IMR1_IM11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM11_Unmasked = 0x1
	// Position of IM12 field.
	EXTI_IMR1_IM12_Pos = 0xc
	// Bit mask of IM12 field.
	EXTI_IMR1_IM12_Msk = 0x1000
	// Bit IM12.
	EXTI_IMR1_IM12 = 0x1000
	// Interrupt request line is masked
	EXTI_IMR1_IM12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM12_Unmasked = 0x1
	// Position of IM13 field.
	EXTI_IMR1_IM13_Pos = 0xd
	// Bit mask of IM13 field.
	EXTI_IMR1_IM13_Msk = 0x2000
	// Bit IM13.
	EXTI_IMR1_IM13 = 0x2000
	// Interrupt request line is masked
	EXTI_IMR1_IM13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM13_Unmasked = 0x1
	// Position of IM14 field.
	EXTI_IMR1_IM14_Pos = 0xe
	// Bit mask of IM14 field.
	EXTI_IMR1_IM14_Msk = 0x4000
	// Bit IM14.
	EXTI_IMR1_IM14 = 0x4000
	// Interrupt request line is masked
	EXTI_IMR1_IM14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM14_Unmasked = 0x1
	// Position of IM15 field.
	EXTI_IMR1_IM15_Pos = 0xf
	// Bit mask of IM15 field.
	EXTI_IMR1_IM15_Msk = 0x8000
	// Bit IM15.
	EXTI_IMR1_IM15 = 0x8000
	// Interrupt request line is masked
	EXTI_IMR1_IM15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM15_Unmasked = 0x1
	// Position of IM16 field.
	EXTI_IMR1_IM16_Pos = 0x10
	// Bit mask of IM16 field.
	EXTI_IMR1_IM16_Msk = 0x10000
	// Bit IM16.
	EXTI_IMR1_IM16 = 0x10000
	// Interrupt request line is masked
	EXTI_IMR1_IM16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM16_Unmasked = 0x1
	// Position of IM17 field.
	EXTI_IMR1_IM17_Pos = 0x11
	// Bit mask of IM17 field.
	EXTI_IMR1_IM17_Msk = 0x20000
	// Bit IM17.
	EXTI_IMR1_IM17 = 0x20000
	// Interrupt request line is masked
	EXTI_IMR1_IM17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM17_Unmasked = 0x1
	// Position of IM18 field.
	EXTI_IMR1_IM18_Pos = 0x12
	// Bit mask of IM18 field.
	EXTI_IMR1_IM18_Msk = 0x40000
	// Bit IM18.
	EXTI_IMR1_IM18 = 0x40000
	// Interrupt request line is masked
	EXTI_IMR1_IM18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM18_Unmasked = 0x1
	// Position of IM19 field.
	EXTI_IMR1_IM19_Pos = 0x13
	// Bit mask of IM19 field.
	EXTI_IMR1_IM19_Msk = 0x80000
	// Bit IM19.
	EXTI_IMR1_IM19 = 0x80000
	// Interrupt request line is masked
	EXTI_IMR1_IM19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM19_Unmasked = 0x1
	// Position of IM20 field.
	EXTI_IMR1_IM20_Pos = 0x14
	// Bit mask of IM20 field.
	EXTI_IMR1_IM20_Msk = 0x100000
	// Bit IM20.
	EXTI_IMR1_IM20 = 0x100000
	// Interrupt request line is masked
	EXTI_IMR1_IM20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM20_Unmasked = 0x1
	// Position of IM21 field.
	EXTI_IMR1_IM21_Pos = 0x15
	// Bit mask of IM21 field.
	EXTI_IMR1_IM21_Msk = 0x200000
	// Bit IM21.
	EXTI_IMR1_IM21 = 0x200000
	// Interrupt request line is masked
	EXTI_IMR1_IM21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM21_Unmasked = 0x1
	// Position of IM22 field.
	EXTI_IMR1_IM22_Pos = 0x16
	// Bit mask of IM22 field.
	EXTI_IMR1_IM22_Msk = 0x400000
	// Bit IM22.
	EXTI_IMR1_IM22 = 0x400000
	// Interrupt request line is masked
	EXTI_IMR1_IM22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM22_Unmasked = 0x1
	// Position of IM23 field.
	EXTI_IMR1_IM23_Pos = 0x17
	// Bit mask of IM23 field.
	EXTI_IMR1_IM23_Msk = 0x800000
	// Bit IM23.
	EXTI_IMR1_IM23 = 0x800000
	// Interrupt request line is masked
	EXTI_IMR1_IM23_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM23_Unmasked = 0x1
	// Position of IM24 field.
	EXTI_IMR1_IM24_Pos = 0x18
	// Bit mask of IM24 field.
	EXTI_IMR1_IM24_Msk = 0x1000000
	// Bit IM24.
	EXTI_IMR1_IM24 = 0x1000000
	// Interrupt request line is masked
	EXTI_IMR1_IM24_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM24_Unmasked = 0x1
	// Position of IM25 field.
	EXTI_IMR1_IM25_Pos = 0x19
	// Bit mask of IM25 field.
	EXTI_IMR1_IM25_Msk = 0x2000000
	// Bit IM25.
	EXTI_IMR1_IM25 = 0x2000000
	// Interrupt request line is masked
	EXTI_IMR1_IM25_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM25_Unmasked = 0x1
	// Position of IM26 field.
	EXTI_IMR1_IM26_Pos = 0x1a
	// Bit mask of IM26 field.
	EXTI_IMR1_IM26_Msk = 0x4000000
	// Bit IM26.
	EXTI_IMR1_IM26 = 0x4000000
	// Interrupt request line is masked
	EXTI_IMR1_IM26_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM26_Unmasked = 0x1
	// Position of IM27 field.
	EXTI_IMR1_IM27_Pos = 0x1b
	// Bit mask of IM27 field.
	EXTI_IMR1_IM27_Msk = 0x8000000
	// Bit IM27.
	EXTI_IMR1_IM27 = 0x8000000
	// Interrupt request line is masked
	EXTI_IMR1_IM27_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM27_Unmasked = 0x1
	// Position of IM28 field.
	EXTI_IMR1_IM28_Pos = 0x1c
	// Bit mask of IM28 field.
	EXTI_IMR1_IM28_Msk = 0x10000000
	// Bit IM28.
	EXTI_IMR1_IM28 = 0x10000000
	// Interrupt request line is masked
	EXTI_IMR1_IM28_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM28_Unmasked = 0x1
	// Position of IM29 field.
	EXTI_IMR1_IM29_Pos = 0x1d
	// Bit mask of IM29 field.
	EXTI_IMR1_IM29_Msk = 0x20000000
	// Bit IM29.
	EXTI_IMR1_IM29 = 0x20000000
	// Interrupt request line is masked
	EXTI_IMR1_IM29_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM29_Unmasked = 0x1
	// Position of IM30 field.
	EXTI_IMR1_IM30_Pos = 0x1e
	// Bit mask of IM30 field.
	EXTI_IMR1_IM30_Msk = 0x40000000
	// Bit IM30.
	EXTI_IMR1_IM30 = 0x40000000
	// Interrupt request line is masked
	EXTI_IMR1_IM30_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM30_Unmasked = 0x1
	// Position of IM31 field.
	EXTI_IMR1_IM31_Pos = 0x1f
	// Bit mask of IM31 field.
	EXTI_IMR1_IM31_Msk = 0x80000000
	// Bit IM31.
	EXTI_IMR1_IM31 = 0x80000000
	// Interrupt request line is masked
	EXTI_IMR1_IM31_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_IM31_Unmasked = 0x1

	// EMR1: EXTI CPU wakeup with event mask register
	// Position of EM0 field.
	EXTI_EMR1_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	EXTI_EMR1_EM0_Msk = 0x1
	// Bit EM0.
	EXTI_EMR1_EM0 = 0x1
	// Interrupt request line is masked
	EXTI_EMR1_EM0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM0_Unmasked = 0x1
	// Position of EM1 field.
	EXTI_EMR1_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	EXTI_EMR1_EM1_Msk = 0x2
	// Bit EM1.
	EXTI_EMR1_EM1 = 0x2
	// Interrupt request line is masked
	EXTI_EMR1_EM1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM1_Unmasked = 0x1
	// Position of EM2 field.
	EXTI_EMR1_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	EXTI_EMR1_EM2_Msk = 0x4
	// Bit EM2.
	EXTI_EMR1_EM2 = 0x4
	// Interrupt request line is masked
	EXTI_EMR1_EM2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM2_Unmasked = 0x1
	// Position of EM3 field.
	EXTI_EMR1_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	EXTI_EMR1_EM3_Msk = 0x8
	// Bit EM3.
	EXTI_EMR1_EM3 = 0x8
	// Interrupt request line is masked
	EXTI_EMR1_EM3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM3_Unmasked = 0x1
	// Position of EM4 field.
	EXTI_EMR1_EM4_Pos = 0x4
	// Bit mask of EM4 field.
	EXTI_EMR1_EM4_Msk = 0x10
	// Bit EM4.
	EXTI_EMR1_EM4 = 0x10
	// Interrupt request line is masked
	EXTI_EMR1_EM4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM4_Unmasked = 0x1
	// Position of EM5 field.
	EXTI_EMR1_EM5_Pos = 0x5
	// Bit mask of EM5 field.
	EXTI_EMR1_EM5_Msk = 0x20
	// Bit EM5.
	EXTI_EMR1_EM5 = 0x20
	// Interrupt request line is masked
	EXTI_EMR1_EM5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM5_Unmasked = 0x1
	// Position of EM6 field.
	EXTI_EMR1_EM6_Pos = 0x6
	// Bit mask of EM6 field.
	EXTI_EMR1_EM6_Msk = 0x40
	// Bit EM6.
	EXTI_EMR1_EM6 = 0x40
	// Interrupt request line is masked
	EXTI_EMR1_EM6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM6_Unmasked = 0x1
	// Position of EM7 field.
	EXTI_EMR1_EM7_Pos = 0x7
	// Bit mask of EM7 field.
	EXTI_EMR1_EM7_Msk = 0x80
	// Bit EM7.
	EXTI_EMR1_EM7 = 0x80
	// Interrupt request line is masked
	EXTI_EMR1_EM7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM7_Unmasked = 0x1
	// Position of EM8 field.
	EXTI_EMR1_EM8_Pos = 0x8
	// Bit mask of EM8 field.
	EXTI_EMR1_EM8_Msk = 0x100
	// Bit EM8.
	EXTI_EMR1_EM8 = 0x100
	// Interrupt request line is masked
	EXTI_EMR1_EM8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM8_Unmasked = 0x1
	// Position of EM9 field.
	EXTI_EMR1_EM9_Pos = 0x9
	// Bit mask of EM9 field.
	EXTI_EMR1_EM9_Msk = 0x200
	// Bit EM9.
	EXTI_EMR1_EM9 = 0x200
	// Interrupt request line is masked
	EXTI_EMR1_EM9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM9_Unmasked = 0x1
	// Position of EM10 field.
	EXTI_EMR1_EM10_Pos = 0xa
	// Bit mask of EM10 field.
	EXTI_EMR1_EM10_Msk = 0x400
	// Bit EM10.
	EXTI_EMR1_EM10 = 0x400
	// Interrupt request line is masked
	EXTI_EMR1_EM10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM10_Unmasked = 0x1
	// Position of EM11 field.
	EXTI_EMR1_EM11_Pos = 0xb
	// Bit mask of EM11 field.
	EXTI_EMR1_EM11_Msk = 0x800
	// Bit EM11.
	EXTI_EMR1_EM11 = 0x800
	// Interrupt request line is masked
	EXTI_EMR1_EM11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM11_Unmasked = 0x1
	// Position of EM12 field.
	EXTI_EMR1_EM12_Pos = 0xc
	// Bit mask of EM12 field.
	EXTI_EMR1_EM12_Msk = 0x1000
	// Bit EM12.
	EXTI_EMR1_EM12 = 0x1000
	// Interrupt request line is masked
	EXTI_EMR1_EM12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM12_Unmasked = 0x1
	// Position of EM13 field.
	EXTI_EMR1_EM13_Pos = 0xd
	// Bit mask of EM13 field.
	EXTI_EMR1_EM13_Msk = 0x2000
	// Bit EM13.
	EXTI_EMR1_EM13 = 0x2000
	// Interrupt request line is masked
	EXTI_EMR1_EM13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM13_Unmasked = 0x1
	// Position of EM14 field.
	EXTI_EMR1_EM14_Pos = 0xe
	// Bit mask of EM14 field.
	EXTI_EMR1_EM14_Msk = 0x4000
	// Bit EM14.
	EXTI_EMR1_EM14 = 0x4000
	// Interrupt request line is masked
	EXTI_EMR1_EM14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM14_Unmasked = 0x1
	// Position of EM15 field.
	EXTI_EMR1_EM15_Pos = 0xf
	// Bit mask of EM15 field.
	EXTI_EMR1_EM15_Msk = 0x8000
	// Bit EM15.
	EXTI_EMR1_EM15 = 0x8000
	// Interrupt request line is masked
	EXTI_EMR1_EM15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM15_Unmasked = 0x1
	// Position of EM16 field.
	EXTI_EMR1_EM16_Pos = 0x10
	// Bit mask of EM16 field.
	EXTI_EMR1_EM16_Msk = 0x10000
	// Bit EM16.
	EXTI_EMR1_EM16 = 0x10000
	// Interrupt request line is masked
	EXTI_EMR1_EM16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM16_Unmasked = 0x1
	// Position of EM17 field.
	EXTI_EMR1_EM17_Pos = 0x11
	// Bit mask of EM17 field.
	EXTI_EMR1_EM17_Msk = 0x20000
	// Bit EM17.
	EXTI_EMR1_EM17 = 0x20000
	// Interrupt request line is masked
	EXTI_EMR1_EM17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM17_Unmasked = 0x1
	// Position of EM18 field.
	EXTI_EMR1_EM18_Pos = 0x12
	// Bit mask of EM18 field.
	EXTI_EMR1_EM18_Msk = 0x40000
	// Bit EM18.
	EXTI_EMR1_EM18 = 0x40000
	// Interrupt request line is masked
	EXTI_EMR1_EM18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM18_Unmasked = 0x1
	// Position of EM19 field.
	EXTI_EMR1_EM19_Pos = 0x13
	// Bit mask of EM19 field.
	EXTI_EMR1_EM19_Msk = 0x80000
	// Bit EM19.
	EXTI_EMR1_EM19 = 0x80000
	// Interrupt request line is masked
	EXTI_EMR1_EM19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM19_Unmasked = 0x1
	// Position of EM21 field.
	EXTI_EMR1_EM21_Pos = 0x15
	// Bit mask of EM21 field.
	EXTI_EMR1_EM21_Msk = 0x200000
	// Bit EM21.
	EXTI_EMR1_EM21 = 0x200000
	// Interrupt request line is masked
	EXTI_EMR1_EM21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM21_Unmasked = 0x1
	// Position of EM23 field.
	EXTI_EMR1_EM23_Pos = 0x17
	// Bit mask of EM23 field.
	EXTI_EMR1_EM23_Msk = 0x800000
	// Bit EM23.
	EXTI_EMR1_EM23 = 0x800000
	// Interrupt request line is masked
	EXTI_EMR1_EM23_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM23_Unmasked = 0x1
	// Position of EM25 field.
	EXTI_EMR1_EM25_Pos = 0x19
	// Bit mask of EM25 field.
	EXTI_EMR1_EM25_Msk = 0x2000000
	// Bit EM25.
	EXTI_EMR1_EM25 = 0x2000000
	// Interrupt request line is masked
	EXTI_EMR1_EM25_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM25_Unmasked = 0x1
	// Position of EM26 field.
	EXTI_EMR1_EM26_Pos = 0x1a
	// Bit mask of EM26 field.
	EXTI_EMR1_EM26_Msk = 0x4000000
	// Bit EM26.
	EXTI_EMR1_EM26 = 0x4000000
	// Interrupt request line is masked
	EXTI_EMR1_EM26_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM26_Unmasked = 0x1
	// Position of EM27 field.
	EXTI_EMR1_EM27_Pos = 0x1b
	// Bit mask of EM27 field.
	EXTI_EMR1_EM27_Msk = 0x8000000
	// Bit EM27.
	EXTI_EMR1_EM27 = 0x8000000
	// Interrupt request line is masked
	EXTI_EMR1_EM27_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM27_Unmasked = 0x1
	// Position of EM28 field.
	EXTI_EMR1_EM28_Pos = 0x1c
	// Bit mask of EM28 field.
	EXTI_EMR1_EM28_Msk = 0x10000000
	// Bit EM28.
	EXTI_EMR1_EM28 = 0x10000000
	// Interrupt request line is masked
	EXTI_EMR1_EM28_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM28_Unmasked = 0x1
	// Position of EM29 field.
	EXTI_EMR1_EM29_Pos = 0x1d
	// Bit mask of EM29 field.
	EXTI_EMR1_EM29_Msk = 0x20000000
	// Bit EM29.
	EXTI_EMR1_EM29 = 0x20000000
	// Interrupt request line is masked
	EXTI_EMR1_EM29_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM29_Unmasked = 0x1
	// Position of EM30 field.
	EXTI_EMR1_EM30_Pos = 0x1e
	// Bit mask of EM30 field.
	EXTI_EMR1_EM30_Msk = 0x40000000
	// Bit EM30.
	EXTI_EMR1_EM30 = 0x40000000
	// Interrupt request line is masked
	EXTI_EMR1_EM30_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM30_Unmasked = 0x1
	// Position of EM31 field.
	EXTI_EMR1_EM31_Pos = 0x1f
	// Bit mask of EM31 field.
	EXTI_EMR1_EM31_Msk = 0x80000000
	// Bit EM31.
	EXTI_EMR1_EM31 = 0x80000000
	// Interrupt request line is masked
	EXTI_EMR1_EM31_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_EM31_Unmasked = 0x1

	// IMR2: EXTI CPU wakeup with interrupt mask register
	// Position of IM32 field.
	EXTI_IMR2_IM32_Pos = 0x0
	// Bit mask of IM32 field.
	EXTI_IMR2_IM32_Msk = 0x1
	// Bit IM32.
	EXTI_IMR2_IM32 = 0x1
	// Interrupt request line is masked
	EXTI_IMR2_IM32_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_IM32_Unmasked = 0x1
	// Position of IM33 field.
	EXTI_IMR2_IM33_Pos = 0x1
	// Bit mask of IM33 field.
	EXTI_IMR2_IM33_Msk = 0x2
	// Bit IM33.
	EXTI_IMR2_IM33 = 0x2
	// Interrupt request line is masked
	EXTI_IMR2_IM33_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_IM33_Unmasked = 0x1
	// Position of IM34 field.
	EXTI_IMR2_IM34_Pos = 0x2
	// Bit mask of IM34 field.
	EXTI_IMR2_IM34_Msk = 0x4
	// Bit IM34.
	EXTI_IMR2_IM34 = 0x4
	// Interrupt request line is masked
	EXTI_IMR2_IM34_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_IM34_Unmasked = 0x1
	// Position of IM35 field.
	EXTI_IMR2_IM35_Pos = 0x3
	// Bit mask of IM35 field.
	EXTI_IMR2_IM35_Msk = 0x8
	// Bit IM35.
	EXTI_IMR2_IM35 = 0x8
	// Interrupt request line is masked
	EXTI_IMR2_IM35_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_IM35_Unmasked = 0x1

	// EMR2: EXTI CPU wakeup with event mask register
	// Position of EM32 field.
	EXTI_EMR2_EM32_Pos = 0x0
	// Bit mask of EM32 field.
	EXTI_EMR2_EM32_Msk = 0x1
	// Bit EM32.
	EXTI_EMR2_EM32 = 0x1
	// Interrupt request line is masked
	EXTI_EMR2_EM32_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_EM32_Unmasked = 0x1
	// Position of EM33 field.
	EXTI_EMR2_EM33_Pos = 0x1
	// Bit mask of EM33 field.
	EXTI_EMR2_EM33_Msk = 0x2
	// Bit EM33.
	EXTI_EMR2_EM33 = 0x2
	// Interrupt request line is masked
	EXTI_EMR2_EM33_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_EM33_Unmasked = 0x1
	// Position of EM34 field.
	EXTI_EMR2_EM34_Pos = 0x2
	// Bit mask of EM34 field.
	EXTI_EMR2_EM34_Msk = 0x4
	// Bit EM34.
	EXTI_EMR2_EM34 = 0x4
	// Interrupt request line is masked
	EXTI_EMR2_EM34_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_EM34_Unmasked = 0x1
	// Position of EM35 field.
	EXTI_EMR2_EM35_Pos = 0x3
	// Bit mask of EM35 field.
	EXTI_EMR2_EM35_Msk = 0x8
	// Bit EM35.
	EXTI_EMR2_EM35 = 0x8
	// Interrupt request line is masked
	EXTI_EMR2_EM35_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_EM35_Unmasked = 0x1
)

// Constants for FDCAN1: FD controller area network
const (
	// CREL: FDCAN core release register
	// Position of DAY field.
	FDCAN_CREL_DAY_Pos = 0x0
	// Bit mask of DAY field.
	FDCAN_CREL_DAY_Msk = 0xff
	// Position of MON field.
	FDCAN_CREL_MON_Pos = 0x8
	// Bit mask of MON field.
	FDCAN_CREL_MON_Msk = 0xff00
	// Position of YEAR field.
	FDCAN_CREL_YEAR_Pos = 0x10
	// Bit mask of YEAR field.
	FDCAN_CREL_YEAR_Msk = 0xf0000
	// Position of SUBSTEP field.
	FDCAN_CREL_SUBSTEP_Pos = 0x14
	// Bit mask of SUBSTEP field.
	FDCAN_CREL_SUBSTEP_Msk = 0xf00000
	// Position of STEP field.
	FDCAN_CREL_STEP_Pos = 0x18
	// Bit mask of STEP field.
	FDCAN_CREL_STEP_Msk = 0xf000000
	// Position of REL field.
	FDCAN_CREL_REL_Pos = 0x1c
	// Bit mask of REL field.
	FDCAN_CREL_REL_Msk = 0xf0000000

	// ENDN: FDCAN endian register
	// Position of ETV field.
	FDCAN_ENDN_ETV_Pos = 0x0
	// Bit mask of ETV field.
	FDCAN_ENDN_ETV_Msk = 0xffffffff

	// DBTP: FDCAN data bit timing and prescaler register
	// Position of DSJW field.
	FDCAN_DBTP_DSJW_Pos = 0x0
	// Bit mask of DSJW field.
	FDCAN_DBTP_DSJW_Msk = 0xf
	// Position of DTSEG2 field.
	FDCAN_DBTP_DTSEG2_Pos = 0x4
	// Bit mask of DTSEG2 field.
	FDCAN_DBTP_DTSEG2_Msk = 0xf0
	// Position of DTSEG1 field.
	FDCAN_DBTP_DTSEG1_Pos = 0x8
	// Bit mask of DTSEG1 field.
	FDCAN_DBTP_DTSEG1_Msk = 0x1f00
	// Position of DBRP field.
	FDCAN_DBTP_DBRP_Pos = 0x10
	// Bit mask of DBRP field.
	FDCAN_DBTP_DBRP_Msk = 0x1f0000
	// Position of TDC field.
	FDCAN_DBTP_TDC_Pos = 0x17
	// Bit mask of TDC field.
	FDCAN_DBTP_TDC_Msk = 0x800000
	// Bit TDC.
	FDCAN_DBTP_TDC = 0x800000
	// Transceiver delay compensation disabled
	FDCAN_DBTP_TDC_B_0x0 = 0x0
	// Transceiver delay compensation enabled
	FDCAN_DBTP_TDC_B_0x1 = 0x1

	// TEST: FDCAN test register
	// Position of LBCK field.
	FDCAN_TEST_LBCK_Pos = 0x4
	// Bit mask of LBCK field.
	FDCAN_TEST_LBCK_Msk = 0x10
	// Bit LBCK.
	FDCAN_TEST_LBCK = 0x10
	// Reset value, Loop Back mode is disabled
	FDCAN_TEST_LBCK_B_0x0 = 0x0
	// Loop Back mode is enabled (see Power down (Sleep mode))
	FDCAN_TEST_LBCK_B_0x1 = 0x1
	// Position of TX field.
	FDCAN_TEST_TX_Pos = 0x5
	// Bit mask of TX field.
	FDCAN_TEST_TX_Msk = 0x60
	// Reset value, FDCANx_TX TX is controlled by the CAN core, updated at the end of the CAN bit time
	FDCAN_TEST_TX_B_0x0 = 0x0
	// Sample point can be monitored at pin FDCANx_TX
	FDCAN_TEST_TX_B_0x1 = 0x1
	// Dominant (0) level at pin FDCANx_TX
	FDCAN_TEST_TX_B_0x2 = 0x2
	// Recessive (1) at pin FDCANx_TX
	FDCAN_TEST_TX_B_0x3 = 0x3
	// Position of RX field.
	FDCAN_TEST_RX_Pos = 0x7
	// Bit mask of RX field.
	FDCAN_TEST_RX_Msk = 0x80
	// Bit RX.
	FDCAN_TEST_RX = 0x80
	// The CAN bus is dominant (FDCANx_RX = 0)
	FDCAN_TEST_RX_B_0x0 = 0x0
	// The CAN bus is recessive (FDCANx_RX = 1)
	FDCAN_TEST_RX_B_0x1 = 0x1

	// RWD: FDCAN RAM watchdog register
	// Position of WDC field.
	FDCAN_RWD_WDC_Pos = 0x0
	// Bit mask of WDC field.
	FDCAN_RWD_WDC_Msk = 0xff
	// Position of WDV field.
	FDCAN_RWD_WDV_Pos = 0x8
	// Bit mask of WDV field.
	FDCAN_RWD_WDV_Msk = 0xff00

	// CCCR: FDCAN CC control register
	// Position of INIT field.
	FDCAN_CCCR_INIT_Pos = 0x0
	// Bit mask of INIT field.
	FDCAN_CCCR_INIT_Msk = 0x1
	// Bit INIT.
	FDCAN_CCCR_INIT = 0x1
	// Normal operation
	FDCAN_CCCR_INIT_B_0x0 = 0x0
	// Initialization started
	FDCAN_CCCR_INIT_B_0x1 = 0x1
	// Position of CCE field.
	FDCAN_CCCR_CCE_Pos = 0x1
	// Bit mask of CCE field.
	FDCAN_CCCR_CCE_Msk = 0x2
	// Bit CCE.
	FDCAN_CCCR_CCE = 0x2
	// The CPU has no write access to the protected configuration registers.
	FDCAN_CCCR_CCE_B_0x0 = 0x0
	// The CPU has write access to the protected configuration registers (while CCCR.INIT = 1).
	FDCAN_CCCR_CCE_B_0x1 = 0x1
	// Position of ASM field.
	FDCAN_CCCR_ASM_Pos = 0x2
	// Bit mask of ASM field.
	FDCAN_CCCR_ASM_Msk = 0x4
	// Bit ASM.
	FDCAN_CCCR_ASM = 0x4
	// Normal CAN operation
	FDCAN_CCCR_ASM_B_0x0 = 0x0
	// Restricted Operation Mode active
	FDCAN_CCCR_ASM_B_0x1 = 0x1
	// Position of CSA field.
	FDCAN_CCCR_CSA_Pos = 0x3
	// Bit mask of CSA field.
	FDCAN_CCCR_CSA_Msk = 0x8
	// Bit CSA.
	FDCAN_CCCR_CSA = 0x8
	// No clock stop acknowledged
	FDCAN_CCCR_CSA_B_0x0 = 0x0
	// FDCAN may be set in power down by stopping APB clock and kernel clock.
	FDCAN_CCCR_CSA_B_0x1 = 0x1
	// Position of CSR field.
	FDCAN_CCCR_CSR_Pos = 0x4
	// Bit mask of CSR field.
	FDCAN_CCCR_CSR_Msk = 0x10
	// Bit CSR.
	FDCAN_CCCR_CSR = 0x10
	// No clock stop requested
	FDCAN_CCCR_CSR_B_0x0 = 0x0
	// Clock stop requested. When clock stop is requested, first INIT and then CSA is set after all pending transfer requests have been completed and the CAN bus reached idle.
	FDCAN_CCCR_CSR_B_0x1 = 0x1
	// Position of MON field.
	FDCAN_CCCR_MON_Pos = 0x5
	// Bit mask of MON field.
	FDCAN_CCCR_MON_Msk = 0x20
	// Bit MON.
	FDCAN_CCCR_MON = 0x20
	// Bus monitoring mode disabled
	FDCAN_CCCR_MON_B_0x0 = 0x0
	// Bus monitoring mode enabled
	FDCAN_CCCR_MON_B_0x1 = 0x1
	// Position of DAR field.
	FDCAN_CCCR_DAR_Pos = 0x6
	// Bit mask of DAR field.
	FDCAN_CCCR_DAR_Msk = 0x40
	// Bit DAR.
	FDCAN_CCCR_DAR = 0x40
	// Automatic retransmission of messages not transmitted successfully enabled
	FDCAN_CCCR_DAR_B_0x0 = 0x0
	// Automatic retransmission disabled
	FDCAN_CCCR_DAR_B_0x1 = 0x1
	// Position of TEST field.
	FDCAN_CCCR_TEST_Pos = 0x7
	// Bit mask of TEST field.
	FDCAN_CCCR_TEST_Msk = 0x80
	// Bit TEST.
	FDCAN_CCCR_TEST = 0x80
	// Normal operation, register TEST holds reset values
	FDCAN_CCCR_TEST_B_0x0 = 0x0
	// Test Mode, write access to register TEST enabled
	FDCAN_CCCR_TEST_B_0x1 = 0x1
	// Position of FDOE field.
	FDCAN_CCCR_FDOE_Pos = 0x8
	// Bit mask of FDOE field.
	FDCAN_CCCR_FDOE_Msk = 0x100
	// Bit FDOE.
	FDCAN_CCCR_FDOE = 0x100
	// FD operation disabled
	FDCAN_CCCR_FDOE_B_0x0 = 0x0
	// FD operation enabled
	FDCAN_CCCR_FDOE_B_0x1 = 0x1
	// Position of BRSE field.
	FDCAN_CCCR_BRSE_Pos = 0x9
	// Bit mask of BRSE field.
	FDCAN_CCCR_BRSE_Msk = 0x200
	// Bit BRSE.
	FDCAN_CCCR_BRSE = 0x200
	// Bit rate switching for transmissions disabled
	FDCAN_CCCR_BRSE_B_0x0 = 0x0
	// Bit rate switching for transmissions enabled
	FDCAN_CCCR_BRSE_B_0x1 = 0x1
	// Position of PXHD field.
	FDCAN_CCCR_PXHD_Pos = 0xc
	// Bit mask of PXHD field.
	FDCAN_CCCR_PXHD_Msk = 0x1000
	// Bit PXHD.
	FDCAN_CCCR_PXHD = 0x1000
	// Protocol exception handling enabled
	FDCAN_CCCR_PXHD_B_0x0 = 0x0
	// Protocol exception handling disabled
	FDCAN_CCCR_PXHD_B_0x1 = 0x1
	// Position of EFBI field.
	FDCAN_CCCR_EFBI_Pos = 0xd
	// Bit mask of EFBI field.
	FDCAN_CCCR_EFBI_Msk = 0x2000
	// Bit EFBI.
	FDCAN_CCCR_EFBI = 0x2000
	// Edge filtering disabled
	FDCAN_CCCR_EFBI_B_0x0 = 0x0
	// Two consecutive dominant tq required to detect an edge for hard synchronization
	FDCAN_CCCR_EFBI_B_0x1 = 0x1
	// Position of TXP field.
	FDCAN_CCCR_TXP_Pos = 0xe
	// Bit mask of TXP field.
	FDCAN_CCCR_TXP_Msk = 0x4000
	// Bit TXP.
	FDCAN_CCCR_TXP = 0x4000
	// disabled
	FDCAN_CCCR_TXP_B_0x0 = 0x0
	// enabled
	FDCAN_CCCR_TXP_B_0x1 = 0x1
	// Position of NISO field.
	FDCAN_CCCR_NISO_Pos = 0xf
	// Bit mask of NISO field.
	FDCAN_CCCR_NISO_Msk = 0x8000
	// Bit NISO.
	FDCAN_CCCR_NISO = 0x8000
	// CAN FD frame format according to ISO11898-1
	FDCAN_CCCR_NISO_B_0x0 = 0x0
	// CAN FD frame format according to Bosch CAN FD Specification V1.0
	FDCAN_CCCR_NISO_B_0x1 = 0x1

	// NBTP: FDCAN nominal bit timing and prescaler register
	// Position of NTSEG2 field.
	FDCAN_NBTP_NTSEG2_Pos = 0x0
	// Bit mask of NTSEG2 field.
	FDCAN_NBTP_NTSEG2_Msk = 0x7f
	// Position of NTSEG1 field.
	FDCAN_NBTP_NTSEG1_Pos = 0x8
	// Bit mask of NTSEG1 field.
	FDCAN_NBTP_NTSEG1_Msk = 0xff00
	// Position of NBRP field.
	FDCAN_NBTP_NBRP_Pos = 0x10
	// Bit mask of NBRP field.
	FDCAN_NBTP_NBRP_Msk = 0x1ff0000
	// Position of NSJW field.
	FDCAN_NBTP_NSJW_Pos = 0x19
	// Bit mask of NSJW field.
	FDCAN_NBTP_NSJW_Msk = 0xfe000000

	// TSCC: FDCAN timestamp counter configuration register
	// Position of TSS field.
	FDCAN_TSCC_TSS_Pos = 0x0
	// Bit mask of TSS field.
	FDCAN_TSCC_TSS_Msk = 0x3
	// Timestamp counter value always 0x0000
	FDCAN_TSCC_TSS_B_0x0 = 0x0
	// Timestamp counter value incremented according to TCP
	FDCAN_TSCC_TSS_B_0x1 = 0x1
	// External timestamp counter from TIM3 value (tim3_cnt[0:15])
	FDCAN_TSCC_TSS_B_0x2 = 0x2
	// Same as 00.
	FDCAN_TSCC_TSS_B_0x3 = 0x3
	// Position of TCP field.
	FDCAN_TSCC_TCP_Pos = 0x10
	// Bit mask of TCP field.
	FDCAN_TSCC_TCP_Msk = 0xf0000

	// TSCV: FDCAN timestamp counter value register
	// Position of TSC field.
	FDCAN_TSCV_TSC_Pos = 0x0
	// Bit mask of TSC field.
	FDCAN_TSCV_TSC_Msk = 0xffff

	// TOCC: FDCAN timeout counter configuration register
	// Position of ETOC field.
	FDCAN_TOCC_ETOC_Pos = 0x0
	// Bit mask of ETOC field.
	FDCAN_TOCC_ETOC_Msk = 0x1
	// Bit ETOC.
	FDCAN_TOCC_ETOC = 0x1
	// Timeout counter disabled
	FDCAN_TOCC_ETOC_B_0x0 = 0x0
	// Timeout counter enabled
	FDCAN_TOCC_ETOC_B_0x1 = 0x1
	// Position of TOS field.
	FDCAN_TOCC_TOS_Pos = 0x1
	// Bit mask of TOS field.
	FDCAN_TOCC_TOS_Msk = 0x6
	// Continuous operation
	FDCAN_TOCC_TOS_B_0x0 = 0x0
	// Timeout controlled by Tx Event FIFO
	FDCAN_TOCC_TOS_B_0x1 = 0x1
	// Timeout controlled by Rx FIFO 0
	FDCAN_TOCC_TOS_B_0x2 = 0x2
	// Timeout controlled by Rx FIFO 1
	FDCAN_TOCC_TOS_B_0x3 = 0x3
	// Position of TOP field.
	FDCAN_TOCC_TOP_Pos = 0x10
	// Bit mask of TOP field.
	FDCAN_TOCC_TOP_Msk = 0xffff0000

	// TOCV: FDCAN timeout counter value register
	// Position of TOC field.
	FDCAN_TOCV_TOC_Pos = 0x0
	// Bit mask of TOC field.
	FDCAN_TOCV_TOC_Msk = 0xffff

	// ECR: FDCAN error counter register
	// Position of TEC field.
	FDCAN_ECR_TEC_Pos = 0x0
	// Bit mask of TEC field.
	FDCAN_ECR_TEC_Msk = 0xff
	// Position of REC field.
	FDCAN_ECR_REC_Pos = 0x8
	// Bit mask of REC field.
	FDCAN_ECR_REC_Msk = 0x7f00
	// Position of RP field.
	FDCAN_ECR_RP_Pos = 0xf
	// Bit mask of RP field.
	FDCAN_ECR_RP_Msk = 0x8000
	// Bit RP.
	FDCAN_ECR_RP = 0x8000
	// The receive error counter is below the error passive level of 128.
	FDCAN_ECR_RP_B_0x0 = 0x0
	// The receive error counter has reached the error passive level of 128.
	FDCAN_ECR_RP_B_0x1 = 0x1
	// Position of CEL field.
	FDCAN_ECR_CEL_Pos = 0x10
	// Bit mask of CEL field.
	FDCAN_ECR_CEL_Msk = 0xff0000

	// PSR: FDCAN protocol status register
	// Position of LEC field.
	FDCAN_PSR_LEC_Pos = 0x0
	// Bit mask of LEC field.
	FDCAN_PSR_LEC_Msk = 0x7
	// No Error: No error occurred since LEC has been reset by successful reception or transmission.
	FDCAN_PSR_LEC_B_0x0 = 0x0
	// Stuff Error: More than 5 equal bits in a sequence have occurred in a part of a received message where this is not allowed.
	FDCAN_PSR_LEC_B_0x1 = 0x1
	// Form Error: A fixed format part of a received frame has the wrong format.
	FDCAN_PSR_LEC_B_0x2 = 0x2
	// AckError: The message transmitted by the FDCAN was not acknowledged by another node.
	FDCAN_PSR_LEC_B_0x3 = 0x3
	// Bit1Error: During the transmission of a message (with the exception of the arbitration field), the device wanted to send a recessive level (bit of logical value 1), but the monitored bus value was dominant.
	FDCAN_PSR_LEC_B_0x4 = 0x4
	// Bit0Error: During the transmission of a message (or acknowledge bit, or active error flag, or overload flag), the device wanted to send a dominant level (data or identifier bit logical value 0), but the monitored bus value was recessive. During Bus_Off recovery this status is set each time a sequence of 11 recessive bits has been monitored. This enables the CPU to monitor the proceeding of the Bus_Off recovery sequence (indicating the bus is not stuck at dominant or continuously disturbed).
	FDCAN_PSR_LEC_B_0x5 = 0x5
	// CRCError: The CRC check sum of a received message was incorrect. The CRC of an incoming message does not match with the CRC calculated from the received data.
	FDCAN_PSR_LEC_B_0x6 = 0x6
	// NoChange: Any read access to the Protocol status register re-initializes the LEC to '7â. When the LEC shows the value '7â, no CAN bus event was detected since the last CPU read access to the Protocol status register.
	FDCAN_PSR_LEC_B_0x7 = 0x7
	// Position of ACT field.
	FDCAN_PSR_ACT_Pos = 0x3
	// Bit mask of ACT field.
	FDCAN_PSR_ACT_Msk = 0x18
	// Synchronizing: node is synchronizing on CAN communication.
	FDCAN_PSR_ACT_B_0x0 = 0x0
	// Idle: node is neither receiver nor transmitter.
	FDCAN_PSR_ACT_B_0x1 = 0x1
	// Receiver: node is operating as receiver.
	FDCAN_PSR_ACT_B_0x2 = 0x2
	// Transmitter: node is operating as transmitter.
	FDCAN_PSR_ACT_B_0x3 = 0x3
	// Position of EP field.
	FDCAN_PSR_EP_Pos = 0x5
	// Bit mask of EP field.
	FDCAN_PSR_EP_Msk = 0x20
	// Bit EP.
	FDCAN_PSR_EP = 0x20
	// The FDCAN is in the Error_Active state. It normally takes part in bus communication and sends an active error flag when an error has been detected.
	FDCAN_PSR_EP_B_0x0 = 0x0
	// The FDCAN is in the Error_Passive state.
	FDCAN_PSR_EP_B_0x1 = 0x1
	// Position of EW field.
	FDCAN_PSR_EW_Pos = 0x6
	// Bit mask of EW field.
	FDCAN_PSR_EW_Msk = 0x40
	// Bit EW.
	FDCAN_PSR_EW = 0x40
	// Both error counters are below the Error_Warning limit of 96.
	FDCAN_PSR_EW_B_0x0 = 0x0
	// At least one of error counter has reached the Error_Warning limit of 96.
	FDCAN_PSR_EW_B_0x1 = 0x1
	// Position of BO field.
	FDCAN_PSR_BO_Pos = 0x7
	// Bit mask of BO field.
	FDCAN_PSR_BO_Msk = 0x80
	// Bit BO.
	FDCAN_PSR_BO = 0x80
	// The FDCAN is not Bus_Off.
	FDCAN_PSR_BO_B_0x0 = 0x0
	// The FDCAN is in Bus_Off state.
	FDCAN_PSR_BO_B_0x1 = 0x1
	// Position of DLEC field.
	FDCAN_PSR_DLEC_Pos = 0x8
	// Bit mask of DLEC field.
	FDCAN_PSR_DLEC_Msk = 0x700
	// Position of RESI field.
	FDCAN_PSR_RESI_Pos = 0xb
	// Bit mask of RESI field.
	FDCAN_PSR_RESI_Msk = 0x800
	// Bit RESI.
	FDCAN_PSR_RESI = 0x800
	// Last received FDCAN message did not have its ESI flag set.
	FDCAN_PSR_RESI_B_0x0 = 0x0
	// Last received FDCAN message had its ESI flag set.
	FDCAN_PSR_RESI_B_0x1 = 0x1
	// Position of RBRS field.
	FDCAN_PSR_RBRS_Pos = 0xc
	// Bit mask of RBRS field.
	FDCAN_PSR_RBRS_Msk = 0x1000
	// Bit RBRS.
	FDCAN_PSR_RBRS = 0x1000
	// Last received FDCAN message did not have its BRS flag set.
	FDCAN_PSR_RBRS_B_0x0 = 0x0
	// Last received FDCAN message had its BRS flag set.
	FDCAN_PSR_RBRS_B_0x1 = 0x1
	// Position of REDL field.
	FDCAN_PSR_REDL_Pos = 0xd
	// Bit mask of REDL field.
	FDCAN_PSR_REDL_Msk = 0x2000
	// Bit REDL.
	FDCAN_PSR_REDL = 0x2000
	// Since this bit was reset by the CPU, no FDCAN message has been received.
	FDCAN_PSR_REDL_B_0x0 = 0x0
	// Message in FDCAN format with EDL flag set has been received.
	FDCAN_PSR_REDL_B_0x1 = 0x1
	// Position of PXE field.
	FDCAN_PSR_PXE_Pos = 0xe
	// Bit mask of PXE field.
	FDCAN_PSR_PXE_Msk = 0x4000
	// Bit PXE.
	FDCAN_PSR_PXE = 0x4000
	// No protocol exception event occurred since last read access
	FDCAN_PSR_PXE_B_0x0 = 0x0
	// Protocol exception event occurred
	FDCAN_PSR_PXE_B_0x1 = 0x1
	// Position of TDCV field.
	FDCAN_PSR_TDCV_Pos = 0x10
	// Bit mask of TDCV field.
	FDCAN_PSR_TDCV_Msk = 0x7f0000

	// TDCR: FDCAN transmitter delay compensation register
	// Position of TDCF field.
	FDCAN_TDCR_TDCF_Pos = 0x0
	// Bit mask of TDCF field.
	FDCAN_TDCR_TDCF_Msk = 0x7f
	// Position of TDCO field.
	FDCAN_TDCR_TDCO_Pos = 0x8
	// Bit mask of TDCO field.
	FDCAN_TDCR_TDCO_Msk = 0x7f00

	// IR: FDCAN interrupt register
	// Position of RF0N field.
	FDCAN_IR_RF0N_Pos = 0x0
	// Bit mask of RF0N field.
	FDCAN_IR_RF0N_Msk = 0x1
	// Bit RF0N.
	FDCAN_IR_RF0N = 0x1
	// No new message written to Rx FIFO 0
	FDCAN_IR_RF0N_B_0x0 = 0x0
	// New message written to Rx FIFO 0
	FDCAN_IR_RF0N_B_0x1 = 0x1
	// Position of RF0F field.
	FDCAN_IR_RF0F_Pos = 0x1
	// Bit mask of RF0F field.
	FDCAN_IR_RF0F_Msk = 0x2
	// Bit RF0F.
	FDCAN_IR_RF0F = 0x2
	// Rx FIFO 0 not full
	FDCAN_IR_RF0F_B_0x0 = 0x0
	// Rx FIFO 0 full
	FDCAN_IR_RF0F_B_0x1 = 0x1
	// Position of RF0L field.
	FDCAN_IR_RF0L_Pos = 0x2
	// Bit mask of RF0L field.
	FDCAN_IR_RF0L_Msk = 0x4
	// Bit RF0L.
	FDCAN_IR_RF0L = 0x4
	// No Rx FIFO 0 message lost
	FDCAN_IR_RF0L_B_0x0 = 0x0
	// Rx FIFO 0 message lost
	FDCAN_IR_RF0L_B_0x1 = 0x1
	// Position of RF1N field.
	FDCAN_IR_RF1N_Pos = 0x3
	// Bit mask of RF1N field.
	FDCAN_IR_RF1N_Msk = 0x8
	// Bit RF1N.
	FDCAN_IR_RF1N = 0x8
	// No new message written to Rx FIFO 1
	FDCAN_IR_RF1N_B_0x0 = 0x0
	// New message written to Rx FIFO 1
	FDCAN_IR_RF1N_B_0x1 = 0x1
	// Position of RF1F field.
	FDCAN_IR_RF1F_Pos = 0x4
	// Bit mask of RF1F field.
	FDCAN_IR_RF1F_Msk = 0x10
	// Bit RF1F.
	FDCAN_IR_RF1F = 0x10
	// Rx FIFO 1 not full
	FDCAN_IR_RF1F_B_0x0 = 0x0
	// Rx FIFO 1 full
	FDCAN_IR_RF1F_B_0x1 = 0x1
	// Position of RF1L field.
	FDCAN_IR_RF1L_Pos = 0x5
	// Bit mask of RF1L field.
	FDCAN_IR_RF1L_Msk = 0x20
	// Bit RF1L.
	FDCAN_IR_RF1L = 0x20
	// No Rx FIFO 1 message lost
	FDCAN_IR_RF1L_B_0x0 = 0x0
	// Rx FIFO 1 message lost
	FDCAN_IR_RF1L_B_0x1 = 0x1
	// Position of HPM field.
	FDCAN_IR_HPM_Pos = 0x6
	// Bit mask of HPM field.
	FDCAN_IR_HPM_Msk = 0x40
	// Bit HPM.
	FDCAN_IR_HPM = 0x40
	// No high-priority message received
	FDCAN_IR_HPM_B_0x0 = 0x0
	// High-priority message received
	FDCAN_IR_HPM_B_0x1 = 0x1
	// Position of TC field.
	FDCAN_IR_TC_Pos = 0x7
	// Bit mask of TC field.
	FDCAN_IR_TC_Msk = 0x80
	// Bit TC.
	FDCAN_IR_TC = 0x80
	// No transmission completed
	FDCAN_IR_TC_B_0x0 = 0x0
	// Transmission completed
	FDCAN_IR_TC_B_0x1 = 0x1
	// Position of TCF field.
	FDCAN_IR_TCF_Pos = 0x8
	// Bit mask of TCF field.
	FDCAN_IR_TCF_Msk = 0x100
	// Bit TCF.
	FDCAN_IR_TCF = 0x100
	// No transmission cancellation finished
	FDCAN_IR_TCF_B_0x0 = 0x0
	// Transmission cancellation finished
	FDCAN_IR_TCF_B_0x1 = 0x1
	// Position of TFE field.
	FDCAN_IR_TFE_Pos = 0x9
	// Bit mask of TFE field.
	FDCAN_IR_TFE_Msk = 0x200
	// Bit TFE.
	FDCAN_IR_TFE = 0x200
	// Tx FIFO non-empty
	FDCAN_IR_TFE_B_0x0 = 0x0
	// Tx FIFO empty
	FDCAN_IR_TFE_B_0x1 = 0x1
	// Position of TEFN field.
	FDCAN_IR_TEFN_Pos = 0xa
	// Bit mask of TEFN field.
	FDCAN_IR_TEFN_Msk = 0x400
	// Bit TEFN.
	FDCAN_IR_TEFN = 0x400
	// Tx event FIFO unchanged
	FDCAN_IR_TEFN_B_0x0 = 0x0
	// Tx handler wrote Tx event FIFO element.
	FDCAN_IR_TEFN_B_0x1 = 0x1
	// Position of TEFF field.
	FDCAN_IR_TEFF_Pos = 0xb
	// Bit mask of TEFF field.
	FDCAN_IR_TEFF_Msk = 0x800
	// Bit TEFF.
	FDCAN_IR_TEFF = 0x800
	// Tx event FIFO Not full
	FDCAN_IR_TEFF_B_0x0 = 0x0
	// Tx event FIFO full
	FDCAN_IR_TEFF_B_0x1 = 0x1
	// Position of TEFL field.
	FDCAN_IR_TEFL_Pos = 0xc
	// Bit mask of TEFL field.
	FDCAN_IR_TEFL_Msk = 0x1000
	// Bit TEFL.
	FDCAN_IR_TEFL = 0x1000
	// No Tx event FIFO element lost
	FDCAN_IR_TEFL_B_0x0 = 0x0
	// Tx event FIFO element lost
	FDCAN_IR_TEFL_B_0x1 = 0x1
	// Position of TSW field.
	FDCAN_IR_TSW_Pos = 0xd
	// Bit mask of TSW field.
	FDCAN_IR_TSW_Msk = 0x2000
	// Bit TSW.
	FDCAN_IR_TSW = 0x2000
	// No timestamp counter wrap-around
	FDCAN_IR_TSW_B_0x0 = 0x0
	// Timestamp counter wrapped around
	FDCAN_IR_TSW_B_0x1 = 0x1
	// Position of MRAF field.
	FDCAN_IR_MRAF_Pos = 0xe
	// Bit mask of MRAF field.
	FDCAN_IR_MRAF_Msk = 0x4000
	// Bit MRAF.
	FDCAN_IR_MRAF = 0x4000
	// No Message RAM access failure occurred
	FDCAN_IR_MRAF_B_0x0 = 0x0
	// Message RAM access failure occurred
	FDCAN_IR_MRAF_B_0x1 = 0x1
	// Position of TOO field.
	FDCAN_IR_TOO_Pos = 0xf
	// Bit mask of TOO field.
	FDCAN_IR_TOO_Msk = 0x8000
	// Bit TOO.
	FDCAN_IR_TOO = 0x8000
	// No timeout
	FDCAN_IR_TOO_B_0x0 = 0x0
	// Timeout reached
	FDCAN_IR_TOO_B_0x1 = 0x1
	// Position of ELO field.
	FDCAN_IR_ELO_Pos = 0x10
	// Bit mask of ELO field.
	FDCAN_IR_ELO_Msk = 0x10000
	// Bit ELO.
	FDCAN_IR_ELO = 0x10000
	// CAN error logging counter did not overflow.
	FDCAN_IR_ELO_B_0x0 = 0x0
	// Overflow of CAN error logging counter occurred.
	FDCAN_IR_ELO_B_0x1 = 0x1
	// Position of EP field.
	FDCAN_IR_EP_Pos = 0x11
	// Bit mask of EP field.
	FDCAN_IR_EP_Msk = 0x20000
	// Bit EP.
	FDCAN_IR_EP = 0x20000
	// Error_Passive status unchanged
	FDCAN_IR_EP_B_0x0 = 0x0
	// Error_Passive status changed
	FDCAN_IR_EP_B_0x1 = 0x1
	// Position of EW field.
	FDCAN_IR_EW_Pos = 0x12
	// Bit mask of EW field.
	FDCAN_IR_EW_Msk = 0x40000
	// Bit EW.
	FDCAN_IR_EW = 0x40000
	// Error_Warning status unchanged
	FDCAN_IR_EW_B_0x0 = 0x0
	// Error_Warning status changed
	FDCAN_IR_EW_B_0x1 = 0x1
	// Position of BO field.
	FDCAN_IR_BO_Pos = 0x13
	// Bit mask of BO field.
	FDCAN_IR_BO_Msk = 0x80000
	// Bit BO.
	FDCAN_IR_BO = 0x80000
	// Bus_Off status unchanged
	FDCAN_IR_BO_B_0x0 = 0x0
	// Bus_Off status changed
	FDCAN_IR_BO_B_0x1 = 0x1
	// Position of WDI field.
	FDCAN_IR_WDI_Pos = 0x14
	// Bit mask of WDI field.
	FDCAN_IR_WDI_Msk = 0x100000
	// Bit WDI.
	FDCAN_IR_WDI = 0x100000
	// No message RAM watchdog event occurred
	FDCAN_IR_WDI_B_0x0 = 0x0
	// Message RAM watchdog event due to missing READY
	FDCAN_IR_WDI_B_0x1 = 0x1
	// Position of PEA field.
	FDCAN_IR_PEA_Pos = 0x15
	// Bit mask of PEA field.
	FDCAN_IR_PEA_Msk = 0x200000
	// Bit PEA.
	FDCAN_IR_PEA = 0x200000
	// No protocol error in arbitration phase
	FDCAN_IR_PEA_B_0x0 = 0x0
	// Protocol error in arbitration phase detected (PSR.LEC different from 0,7)
	FDCAN_IR_PEA_B_0x1 = 0x1
	// Position of PED field.
	FDCAN_IR_PED_Pos = 0x16
	// Bit mask of PED field.
	FDCAN_IR_PED_Msk = 0x400000
	// Bit PED.
	FDCAN_IR_PED = 0x400000
	// No protocol error in data phase
	FDCAN_IR_PED_B_0x0 = 0x0
	// Protocol error in data phase detected (PSR.DLEC different from 0,7)
	FDCAN_IR_PED_B_0x1 = 0x1
	// Position of ARA field.
	FDCAN_IR_ARA_Pos = 0x17
	// Bit mask of ARA field.
	FDCAN_IR_ARA_Msk = 0x800000
	// Bit ARA.
	FDCAN_IR_ARA = 0x800000
	// No access to reserved address occurred
	FDCAN_IR_ARA_B_0x0 = 0x0
	// Access to reserved address occurred
	FDCAN_IR_ARA_B_0x1 = 0x1

	// IE: FDCAN interrupt enable register
	// Position of RF0NE field.
	FDCAN_IE_RF0NE_Pos = 0x0
	// Bit mask of RF0NE field.
	FDCAN_IE_RF0NE_Msk = 0x1
	// Bit RF0NE.
	FDCAN_IE_RF0NE = 0x1
	// Interrupt disabled
	FDCAN_IE_RF0NE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_RF0NE_B_0x1 = 0x1
	// Position of RF0FE field.
	FDCAN_IE_RF0FE_Pos = 0x1
	// Bit mask of RF0FE field.
	FDCAN_IE_RF0FE_Msk = 0x2
	// Bit RF0FE.
	FDCAN_IE_RF0FE = 0x2
	// Interrupt disabled
	FDCAN_IE_RF0FE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_RF0FE_B_0x1 = 0x1
	// Position of RF0LE field.
	FDCAN_IE_RF0LE_Pos = 0x2
	// Bit mask of RF0LE field.
	FDCAN_IE_RF0LE_Msk = 0x4
	// Bit RF0LE.
	FDCAN_IE_RF0LE = 0x4
	// Interrupt disabled
	FDCAN_IE_RF0LE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_RF0LE_B_0x1 = 0x1
	// Position of RF1NE field.
	FDCAN_IE_RF1NE_Pos = 0x3
	// Bit mask of RF1NE field.
	FDCAN_IE_RF1NE_Msk = 0x8
	// Bit RF1NE.
	FDCAN_IE_RF1NE = 0x8
	// Interrupt disabled
	FDCAN_IE_RF1NE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_RF1NE_B_0x1 = 0x1
	// Position of RF1FE field.
	FDCAN_IE_RF1FE_Pos = 0x4
	// Bit mask of RF1FE field.
	FDCAN_IE_RF1FE_Msk = 0x10
	// Bit RF1FE.
	FDCAN_IE_RF1FE = 0x10
	// Interrupt disabled
	FDCAN_IE_RF1FE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_RF1FE_B_0x1 = 0x1
	// Position of RF1LE field.
	FDCAN_IE_RF1LE_Pos = 0x5
	// Bit mask of RF1LE field.
	FDCAN_IE_RF1LE_Msk = 0x20
	// Bit RF1LE.
	FDCAN_IE_RF1LE = 0x20
	// Interrupt disabled
	FDCAN_IE_RF1LE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_RF1LE_B_0x1 = 0x1
	// Position of HPME field.
	FDCAN_IE_HPME_Pos = 0x6
	// Bit mask of HPME field.
	FDCAN_IE_HPME_Msk = 0x40
	// Bit HPME.
	FDCAN_IE_HPME = 0x40
	// Interrupt disabled
	FDCAN_IE_HPME_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_HPME_B_0x1 = 0x1
	// Position of TCE field.
	FDCAN_IE_TCE_Pos = 0x7
	// Bit mask of TCE field.
	FDCAN_IE_TCE_Msk = 0x80
	// Bit TCE.
	FDCAN_IE_TCE = 0x80
	// Interrupt disabled
	FDCAN_IE_TCE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_TCE_B_0x1 = 0x1
	// Position of TCFE field.
	FDCAN_IE_TCFE_Pos = 0x8
	// Bit mask of TCFE field.
	FDCAN_IE_TCFE_Msk = 0x100
	// Bit TCFE.
	FDCAN_IE_TCFE = 0x100
	// Interrupt disabled
	FDCAN_IE_TCFE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_TCFE_B_0x1 = 0x1
	// Position of TFEE field.
	FDCAN_IE_TFEE_Pos = 0x9
	// Bit mask of TFEE field.
	FDCAN_IE_TFEE_Msk = 0x200
	// Bit TFEE.
	FDCAN_IE_TFEE = 0x200
	// Interrupt disabled
	FDCAN_IE_TFEE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_TFEE_B_0x1 = 0x1
	// Position of TEFNE field.
	FDCAN_IE_TEFNE_Pos = 0xa
	// Bit mask of TEFNE field.
	FDCAN_IE_TEFNE_Msk = 0x400
	// Bit TEFNE.
	FDCAN_IE_TEFNE = 0x400
	// Interrupt disabled
	FDCAN_IE_TEFNE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_TEFNE_B_0x1 = 0x1
	// Position of TEFFE field.
	FDCAN_IE_TEFFE_Pos = 0xb
	// Bit mask of TEFFE field.
	FDCAN_IE_TEFFE_Msk = 0x800
	// Bit TEFFE.
	FDCAN_IE_TEFFE = 0x800
	// Interrupt disabled
	FDCAN_IE_TEFFE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_TEFFE_B_0x1 = 0x1
	// Position of TEFLE field.
	FDCAN_IE_TEFLE_Pos = 0xc
	// Bit mask of TEFLE field.
	FDCAN_IE_TEFLE_Msk = 0x1000
	// Bit TEFLE.
	FDCAN_IE_TEFLE = 0x1000
	// Interrupt disabled
	FDCAN_IE_TEFLE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_TEFLE_B_0x1 = 0x1
	// Position of TSWE field.
	FDCAN_IE_TSWE_Pos = 0xd
	// Bit mask of TSWE field.
	FDCAN_IE_TSWE_Msk = 0x2000
	// Bit TSWE.
	FDCAN_IE_TSWE = 0x2000
	// Interrupt disabled
	FDCAN_IE_TSWE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_TSWE_B_0x1 = 0x1
	// Position of MRAFE field.
	FDCAN_IE_MRAFE_Pos = 0xe
	// Bit mask of MRAFE field.
	FDCAN_IE_MRAFE_Msk = 0x4000
	// Bit MRAFE.
	FDCAN_IE_MRAFE = 0x4000
	// Interrupt disabled
	FDCAN_IE_MRAFE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_MRAFE_B_0x1 = 0x1
	// Position of TOOE field.
	FDCAN_IE_TOOE_Pos = 0xf
	// Bit mask of TOOE field.
	FDCAN_IE_TOOE_Msk = 0x8000
	// Bit TOOE.
	FDCAN_IE_TOOE = 0x8000
	// Interrupt disabled
	FDCAN_IE_TOOE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_TOOE_B_0x1 = 0x1
	// Position of ELOE field.
	FDCAN_IE_ELOE_Pos = 0x10
	// Bit mask of ELOE field.
	FDCAN_IE_ELOE_Msk = 0x10000
	// Bit ELOE.
	FDCAN_IE_ELOE = 0x10000
	// Interrupt disabled
	FDCAN_IE_ELOE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_ELOE_B_0x1 = 0x1
	// Position of EPE field.
	FDCAN_IE_EPE_Pos = 0x11
	// Bit mask of EPE field.
	FDCAN_IE_EPE_Msk = 0x20000
	// Bit EPE.
	FDCAN_IE_EPE = 0x20000
	// Interrupt disabled
	FDCAN_IE_EPE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_EPE_B_0x1 = 0x1
	// Position of EWE field.
	FDCAN_IE_EWE_Pos = 0x12
	// Bit mask of EWE field.
	FDCAN_IE_EWE_Msk = 0x40000
	// Bit EWE.
	FDCAN_IE_EWE = 0x40000
	// Interrupt disabled
	FDCAN_IE_EWE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_EWE_B_0x1 = 0x1
	// Position of BOE field.
	FDCAN_IE_BOE_Pos = 0x13
	// Bit mask of BOE field.
	FDCAN_IE_BOE_Msk = 0x80000
	// Bit BOE.
	FDCAN_IE_BOE = 0x80000
	// Interrupt disabled
	FDCAN_IE_BOE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_BOE_B_0x1 = 0x1
	// Position of WDIE field.
	FDCAN_IE_WDIE_Pos = 0x14
	// Bit mask of WDIE field.
	FDCAN_IE_WDIE_Msk = 0x100000
	// Bit WDIE.
	FDCAN_IE_WDIE = 0x100000
	// Interrupt disabled
	FDCAN_IE_WDIE_B_0x0 = 0x0
	// Interrupt enabled
	FDCAN_IE_WDIE_B_0x1 = 0x1
	// Position of PEAE field.
	FDCAN_IE_PEAE_Pos = 0x15
	// Bit mask of PEAE field.
	FDCAN_IE_PEAE_Msk = 0x200000
	// Bit PEAE.
	FDCAN_IE_PEAE = 0x200000
	// Position of PEDE field.
	FDCAN_IE_PEDE_Pos = 0x16
	// Bit mask of PEDE field.
	FDCAN_IE_PEDE_Msk = 0x400000
	// Bit PEDE.
	FDCAN_IE_PEDE = 0x400000
	// Position of ARAE field.
	FDCAN_IE_ARAE_Pos = 0x17
	// Bit mask of ARAE field.
	FDCAN_IE_ARAE_Msk = 0x800000
	// Bit ARAE.
	FDCAN_IE_ARAE = 0x800000

	// ILS: FDCAN interrupt line select register
	// Position of RxFIFO0 field.
	FDCAN_ILS_RxFIFO0_Pos = 0x0
	// Bit mask of RxFIFO0 field.
	FDCAN_ILS_RxFIFO0_Msk = 0x1
	// Bit RxFIFO0.
	FDCAN_ILS_RxFIFO0 = 0x1
	// Position of RxFIFO1 field.
	FDCAN_ILS_RxFIFO1_Pos = 0x1
	// Bit mask of RxFIFO1 field.
	FDCAN_ILS_RxFIFO1_Msk = 0x2
	// Bit RxFIFO1.
	FDCAN_ILS_RxFIFO1 = 0x2
	// Position of SMSG field.
	FDCAN_ILS_SMSG_Pos = 0x2
	// Bit mask of SMSG field.
	FDCAN_ILS_SMSG_Msk = 0x4
	// Bit SMSG.
	FDCAN_ILS_SMSG = 0x4
	// Position of TFERR field.
	FDCAN_ILS_TFERR_Pos = 0x3
	// Bit mask of TFERR field.
	FDCAN_ILS_TFERR_Msk = 0x8
	// Bit TFERR.
	FDCAN_ILS_TFERR = 0x8
	// Position of MISC field.
	FDCAN_ILS_MISC_Pos = 0x4
	// Bit mask of MISC field.
	FDCAN_ILS_MISC_Msk = 0x10
	// Bit MISC.
	FDCAN_ILS_MISC = 0x10
	// Position of BERR field.
	FDCAN_ILS_BERR_Pos = 0x5
	// Bit mask of BERR field.
	FDCAN_ILS_BERR_Msk = 0x20
	// Bit BERR.
	FDCAN_ILS_BERR = 0x20
	// Position of PERR field.
	FDCAN_ILS_PERR_Pos = 0x6
	// Bit mask of PERR field.
	FDCAN_ILS_PERR_Msk = 0x40
	// Bit PERR.
	FDCAN_ILS_PERR = 0x40

	// ILE: FDCAN interrupt line enable register
	// Position of EINT0 field.
	FDCAN_ILE_EINT0_Pos = 0x0
	// Bit mask of EINT0 field.
	FDCAN_ILE_EINT0_Msk = 0x1
	// Bit EINT0.
	FDCAN_ILE_EINT0 = 0x1
	// Interrupt line fdcan_intr1_it disabled
	FDCAN_ILE_EINT0_B_0x0 = 0x0
	// Interrupt line fdcan_intr1_it enabled
	FDCAN_ILE_EINT0_B_0x1 = 0x1
	// Position of EINT1 field.
	FDCAN_ILE_EINT1_Pos = 0x1
	// Bit mask of EINT1 field.
	FDCAN_ILE_EINT1_Msk = 0x2
	// Bit EINT1.
	FDCAN_ILE_EINT1 = 0x2
	// Interrupt line fdcan_intr0_it disabled
	FDCAN_ILE_EINT1_B_0x0 = 0x0
	// Interrupt line fdcan_intr0_it enabled
	FDCAN_ILE_EINT1_B_0x1 = 0x1

	// RXGFC: FDCAN global filter configuration register
	// Position of RRFE field.
	FDCAN_RXGFC_RRFE_Pos = 0x0
	// Bit mask of RRFE field.
	FDCAN_RXGFC_RRFE_Msk = 0x1
	// Bit RRFE.
	FDCAN_RXGFC_RRFE = 0x1
	// Filter remote frames with 29-bit standard IDs
	FDCAN_RXGFC_RRFE_B_0x0 = 0x0
	// Reject all remote frames with 29-bit standard IDs
	FDCAN_RXGFC_RRFE_B_0x1 = 0x1
	// Position of RRFS field.
	FDCAN_RXGFC_RRFS_Pos = 0x1
	// Bit mask of RRFS field.
	FDCAN_RXGFC_RRFS_Msk = 0x2
	// Bit RRFS.
	FDCAN_RXGFC_RRFS = 0x2
	// Filter remote frames with 11-bit standard IDs
	FDCAN_RXGFC_RRFS_B_0x0 = 0x0
	// Reject all remote frames with 11-bit standard IDs
	FDCAN_RXGFC_RRFS_B_0x1 = 0x1
	// Position of ANFE field.
	FDCAN_RXGFC_ANFE_Pos = 0x2
	// Bit mask of ANFE field.
	FDCAN_RXGFC_ANFE_Msk = 0xc
	// Accept in Rx FIFO 0
	FDCAN_RXGFC_ANFE_B_0x0 = 0x0
	// Accept in Rx FIFO 1
	FDCAN_RXGFC_ANFE_B_0x1 = 0x1
	// Reject
	FDCAN_RXGFC_ANFE_B_0x2 = 0x2
	// Reject
	FDCAN_RXGFC_ANFE_B_0x3 = 0x3
	// Position of ANFS field.
	FDCAN_RXGFC_ANFS_Pos = 0x4
	// Bit mask of ANFS field.
	FDCAN_RXGFC_ANFS_Msk = 0x30
	// Accept in Rx FIFO 0
	FDCAN_RXGFC_ANFS_B_0x0 = 0x0
	// Accept in Rx FIFO 1
	FDCAN_RXGFC_ANFS_B_0x1 = 0x1
	// Reject
	FDCAN_RXGFC_ANFS_B_0x2 = 0x2
	// Reject
	FDCAN_RXGFC_ANFS_B_0x3 = 0x3
	// Position of F1OM field.
	FDCAN_RXGFC_F1OM_Pos = 0x8
	// Bit mask of F1OM field.
	FDCAN_RXGFC_F1OM_Msk = 0x100
	// Bit F1OM.
	FDCAN_RXGFC_F1OM = 0x100
	// Position of F0OM field.
	FDCAN_RXGFC_F0OM_Pos = 0x9
	// Bit mask of F0OM field.
	FDCAN_RXGFC_F0OM_Msk = 0x200
	// Bit F0OM.
	FDCAN_RXGFC_F0OM = 0x200
	// Position of LSS field.
	FDCAN_RXGFC_LSS_Pos = 0x10
	// Bit mask of LSS field.
	FDCAN_RXGFC_LSS_Msk = 0x1f0000
	// No standard message ID filter
	FDCAN_RXGFC_LSS_B_0x0 = 0x0
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x1 = 0x1
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x2 = 0x2
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x3 = 0x3
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x4 = 0x4
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x5 = 0x5
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x6 = 0x6
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x7 = 0x7
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x8 = 0x8
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x9 = 0x9
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0xa = 0xa
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0xb = 0xb
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0xc = 0xc
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0xd = 0xd
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0xe = 0xe
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0xf = 0xf
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x10 = 0x10
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x11 = 0x11
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x12 = 0x12
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x13 = 0x13
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x14 = 0x14
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x15 = 0x15
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x16 = 0x16
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x17 = 0x17
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x18 = 0x18
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x19 = 0x19
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x1a = 0x1a
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x1b = 0x1b
	// Number of standard message ID filter elements
	FDCAN_RXGFC_LSS_B_0x1c = 0x1c
	// Position of LSE field.
	FDCAN_RXGFC_LSE_Pos = 0x18
	// Bit mask of LSE field.
	FDCAN_RXGFC_LSE_Msk = 0xf000000
	// No extended message ID filter
	FDCAN_RXGFC_LSE_B_0x0 = 0x0
	// Number of extended message ID filter elements
	FDCAN_RXGFC_LSE_B_0x1 = 0x1
	// Number of extended message ID filter elements
	FDCAN_RXGFC_LSE_B_0x2 = 0x2
	// Number of extended message ID filter elements
	FDCAN_RXGFC_LSE_B_0x3 = 0x3
	// Number of extended message ID filter elements
	FDCAN_RXGFC_LSE_B_0x4 = 0x4
	// Number of extended message ID filter elements
	FDCAN_RXGFC_LSE_B_0x5 = 0x5
	// Number of extended message ID filter elements
	FDCAN_RXGFC_LSE_B_0x6 = 0x6
	// Number of extended message ID filter elements
	FDCAN_RXGFC_LSE_B_0x7 = 0x7
	// Number of extended message ID filter elements
	FDCAN_RXGFC_LSE_B_0x8 = 0x8

	// XIDAM: FDCAN extended ID and mask register
	// Position of EIDM field.
	FDCAN_XIDAM_EIDM_Pos = 0x0
	// Bit mask of EIDM field.
	FDCAN_XIDAM_EIDM_Msk = 0x1fffffff

	// HPMS: FDCAN high-priority message status register
	// Position of BIDX field.
	FDCAN_HPMS_BIDX_Pos = 0x0
	// Bit mask of BIDX field.
	FDCAN_HPMS_BIDX_Msk = 0x7
	// Position of MSI field.
	FDCAN_HPMS_MSI_Pos = 0x6
	// Bit mask of MSI field.
	FDCAN_HPMS_MSI_Msk = 0xc0
	// No FIFO selected
	FDCAN_HPMS_MSI_B_0x0 = 0x0
	// FIFO overrun
	FDCAN_HPMS_MSI_B_0x1 = 0x1
	// Message stored in FIFO 0
	FDCAN_HPMS_MSI_B_0x2 = 0x2
	// Message stored in FIFO 1
	FDCAN_HPMS_MSI_B_0x3 = 0x3
	// Position of FIDX field.
	FDCAN_HPMS_FIDX_Pos = 0x8
	// Bit mask of FIDX field.
	FDCAN_HPMS_FIDX_Msk = 0x1f00
	// Position of FLST field.
	FDCAN_HPMS_FLST_Pos = 0xf
	// Bit mask of FLST field.
	FDCAN_HPMS_FLST_Msk = 0x8000
	// Bit FLST.
	FDCAN_HPMS_FLST = 0x8000
	// Standard filter list
	FDCAN_HPMS_FLST_B_0x0 = 0x0
	// Extended filter list
	FDCAN_HPMS_FLST_B_0x1 = 0x1

	// RXF0S: FDCAN Rx FIFO 0 status register
	// Position of F0FL field.
	FDCAN_RXF0S_F0FL_Pos = 0x0
	// Bit mask of F0FL field.
	FDCAN_RXF0S_F0FL_Msk = 0xf
	// Position of F0GI field.
	FDCAN_RXF0S_F0GI_Pos = 0x8
	// Bit mask of F0GI field.
	FDCAN_RXF0S_F0GI_Msk = 0x300
	// Position of F0PI field.
	FDCAN_RXF0S_F0PI_Pos = 0x10
	// Bit mask of F0PI field.
	FDCAN_RXF0S_F0PI_Msk = 0x30000
	// Position of F0F field.
	FDCAN_RXF0S_F0F_Pos = 0x18
	// Bit mask of F0F field.
	FDCAN_RXF0S_F0F_Msk = 0x1000000
	// Bit F0F.
	FDCAN_RXF0S_F0F = 0x1000000
	// Rx FIFO 0 not full
	FDCAN_RXF0S_F0F_B_0x0 = 0x0
	// Rx FIFO 0 full
	FDCAN_RXF0S_F0F_B_0x1 = 0x1
	// Position of RF0L field.
	FDCAN_RXF0S_RF0L_Pos = 0x19
	// Bit mask of RF0L field.
	FDCAN_RXF0S_RF0L_Msk = 0x2000000
	// Bit RF0L.
	FDCAN_RXF0S_RF0L = 0x2000000
	// No Rx FIFO 0 message lost
	FDCAN_RXF0S_RF0L_B_0x0 = 0x0
	// Rx FIFO 0 message lost, also set after write attempt to Rx FIFO 0 of size 0
	FDCAN_RXF0S_RF0L_B_0x1 = 0x1

	// RXF0A: CAN Rx FIFO 0 acknowledge register
	// Position of F0AI field.
	FDCAN_RXF0A_F0AI_Pos = 0x0
	// Bit mask of F0AI field.
	FDCAN_RXF0A_F0AI_Msk = 0x7

	// RXF1S: FDCAN Rx FIFO 1 status register
	// Position of F1FL field.
	FDCAN_RXF1S_F1FL_Pos = 0x0
	// Bit mask of F1FL field.
	FDCAN_RXF1S_F1FL_Msk = 0xf
	// Position of F1GI field.
	FDCAN_RXF1S_F1GI_Pos = 0x8
	// Bit mask of F1GI field.
	FDCAN_RXF1S_F1GI_Msk = 0x300
	// Position of F1PI field.
	FDCAN_RXF1S_F1PI_Pos = 0x10
	// Bit mask of F1PI field.
	FDCAN_RXF1S_F1PI_Msk = 0x30000
	// Position of F1F field.
	FDCAN_RXF1S_F1F_Pos = 0x18
	// Bit mask of F1F field.
	FDCAN_RXF1S_F1F_Msk = 0x1000000
	// Bit F1F.
	FDCAN_RXF1S_F1F = 0x1000000
	// Rx FIFO 1 not full
	FDCAN_RXF1S_F1F_B_0x0 = 0x0
	// Rx FIFO 1 full
	FDCAN_RXF1S_F1F_B_0x1 = 0x1
	// Position of RF1L field.
	FDCAN_RXF1S_RF1L_Pos = 0x19
	// Bit mask of RF1L field.
	FDCAN_RXF1S_RF1L_Msk = 0x2000000
	// Bit RF1L.
	FDCAN_RXF1S_RF1L = 0x2000000
	// No Rx FIFO 1 message lost
	FDCAN_RXF1S_RF1L_B_0x0 = 0x0
	// Rx FIFO 1 message lost, also set after write attempt to Rx FIFO 1 of size 0
	FDCAN_RXF1S_RF1L_B_0x1 = 0x1

	// RXF1A: FDCAN Rx FIFO 1 acknowledge register
	// Position of F1AI field.
	FDCAN_RXF1A_F1AI_Pos = 0x0
	// Bit mask of F1AI field.
	FDCAN_RXF1A_F1AI_Msk = 0x7

	// TXBC: FDCAN Tx buffer configuration register
	// Position of TFQM field.
	FDCAN_TXBC_TFQM_Pos = 0x18
	// Bit mask of TFQM field.
	FDCAN_TXBC_TFQM_Msk = 0x1000000
	// Bit TFQM.
	FDCAN_TXBC_TFQM = 0x1000000
	// Tx FIFO operation
	FDCAN_TXBC_TFQM_B_0x0 = 0x0
	// Tx queue operation.
	FDCAN_TXBC_TFQM_B_0x1 = 0x1

	// TXFQS: FDCAN Tx FIFO/queue status register
	// Position of TFFL field.
	FDCAN_TXFQS_TFFL_Pos = 0x0
	// Bit mask of TFFL field.
	FDCAN_TXFQS_TFFL_Msk = 0x7
	// Position of TFGI field.
	FDCAN_TXFQS_TFGI_Pos = 0x8
	// Bit mask of TFGI field.
	FDCAN_TXFQS_TFGI_Msk = 0x300
	// Position of TFQPI field.
	FDCAN_TXFQS_TFQPI_Pos = 0x10
	// Bit mask of TFQPI field.
	FDCAN_TXFQS_TFQPI_Msk = 0x30000
	// Position of TFQF field.
	FDCAN_TXFQS_TFQF_Pos = 0x15
	// Bit mask of TFQF field.
	FDCAN_TXFQS_TFQF_Msk = 0x200000
	// Bit TFQF.
	FDCAN_TXFQS_TFQF = 0x200000
	// Tx FIFO/queue not full
	FDCAN_TXFQS_TFQF_B_0x0 = 0x0
	// Tx FIFO/queue full
	FDCAN_TXFQS_TFQF_B_0x1 = 0x1

	// TXBRP: FDCAN Tx buffer request pending register
	// Position of TRP field.
	FDCAN_TXBRP_TRP_Pos = 0x0
	// Bit mask of TRP field.
	FDCAN_TXBRP_TRP_Msk = 0x7
	// No transmission request pending
	FDCAN_TXBRP_TRP_B_0x0 = 0x0
	// Transmission request pending
	FDCAN_TXBRP_TRP_B_0x1 = 0x1

	// TXBAR: FDCAN Tx buffer add request register
	// Position of AR field.
	FDCAN_TXBAR_AR_Pos = 0x0
	// Bit mask of AR field.
	FDCAN_TXBAR_AR_Msk = 0x7
	// No transmission request added
	FDCAN_TXBAR_AR_B_0x0 = 0x0
	// Transmission requested added.
	FDCAN_TXBAR_AR_B_0x1 = 0x1

	// TXBCR: FDCAN Tx buffer cancellation request register
	// Position of CR field.
	FDCAN_TXBCR_CR_Pos = 0x0
	// Bit mask of CR field.
	FDCAN_TXBCR_CR_Msk = 0x7
	// No cancellation pending
	FDCAN_TXBCR_CR_B_0x0 = 0x0
	// Cancellation pending
	FDCAN_TXBCR_CR_B_0x1 = 0x1

	// TXBTO: FDCAN Tx buffer transmission occurred register
	// Position of TO field.
	FDCAN_TXBTO_TO_Pos = 0x0
	// Bit mask of TO field.
	FDCAN_TXBTO_TO_Msk = 0x7
	// No transmission occurred
	FDCAN_TXBTO_TO_B_0x0 = 0x0
	// Transmission occurred
	FDCAN_TXBTO_TO_B_0x1 = 0x1

	// TXBCF: FDCAN Tx buffer cancellation finished register
	// Position of CF field.
	FDCAN_TXBCF_CF_Pos = 0x0
	// Bit mask of CF field.
	FDCAN_TXBCF_CF_Msk = 0x7
	// No transmit buffer cancellation
	FDCAN_TXBCF_CF_B_0x0 = 0x0
	// Transmit buffer cancellation finished
	FDCAN_TXBCF_CF_B_0x1 = 0x1

	// TXBTIE: FDCAN Tx buffer transmission interrupt enable register
	// Position of TIE field.
	FDCAN_TXBTIE_TIE_Pos = 0x0
	// Bit mask of TIE field.
	FDCAN_TXBTIE_TIE_Msk = 0x7
	// Transmission interrupt disabled
	FDCAN_TXBTIE_TIE_B_0x0 = 0x0
	// Transmission interrupt enable
	FDCAN_TXBTIE_TIE_B_0x1 = 0x1

	// TXBCIE: FDCAN Tx buffer cancellation finished interrupt enable register
	// Position of CFIE field.
	FDCAN_TXBCIE_CFIE_Pos = 0x0
	// Bit mask of CFIE field.
	FDCAN_TXBCIE_CFIE_Msk = 0x7
	// Cancellation finished interrupt disabled
	FDCAN_TXBCIE_CFIE_B_0x0 = 0x0
	// Cancellation finished interrupt enabled
	FDCAN_TXBCIE_CFIE_B_0x1 = 0x1

	// TXEFS: FDCAN Tx event FIFO status register
	// Position of EFFL field.
	FDCAN_TXEFS_EFFL_Pos = 0x0
	// Bit mask of EFFL field.
	FDCAN_TXEFS_EFFL_Msk = 0x7
	// Position of EFGI field.
	FDCAN_TXEFS_EFGI_Pos = 0x8
	// Bit mask of EFGI field.
	FDCAN_TXEFS_EFGI_Msk = 0x300
	// Position of EFPI field.
	FDCAN_TXEFS_EFPI_Pos = 0x10
	// Bit mask of EFPI field.
	FDCAN_TXEFS_EFPI_Msk = 0x30000
	// Position of EFF field.
	FDCAN_TXEFS_EFF_Pos = 0x18
	// Bit mask of EFF field.
	FDCAN_TXEFS_EFF_Msk = 0x1000000
	// Bit EFF.
	FDCAN_TXEFS_EFF = 0x1000000
	// Tx event FIFO not full
	FDCAN_TXEFS_EFF_B_0x0 = 0x0
	// Tx event FIFO full
	FDCAN_TXEFS_EFF_B_0x1 = 0x1
	// Position of TEFL field.
	FDCAN_TXEFS_TEFL_Pos = 0x19
	// Bit mask of TEFL field.
	FDCAN_TXEFS_TEFL_Msk = 0x2000000
	// Bit TEFL.
	FDCAN_TXEFS_TEFL = 0x2000000

	// TXEFA: FDCAN Tx event FIFO acknowledge register
	// Position of EFAI field.
	FDCAN_TXEFA_EFAI_Pos = 0x0
	// Bit mask of EFAI field.
	FDCAN_TXEFA_EFAI_Msk = 0x3

	// CKDIV: FDCAN CFG clock divider register
	// Position of PDIV field.
	FDCAN_CKDIV_PDIV_Pos = 0x0
	// Bit mask of PDIV field.
	FDCAN_CKDIV_PDIV_Msk = 0xf
	// Divide by 1
	FDCAN_CKDIV_PDIV_B_0x0 = 0x0
	// Divide by 2
	FDCAN_CKDIV_PDIV_B_0x1 = 0x1
	// Divide by 4
	FDCAN_CKDIV_PDIV_B_0x2 = 0x2
	// Divide by 6
	FDCAN_CKDIV_PDIV_B_0x3 = 0x3
	// Divide by 8
	FDCAN_CKDIV_PDIV_B_0x4 = 0x4
	// Divide by 10
	FDCAN_CKDIV_PDIV_B_0x5 = 0x5
	// Divide by 12
	FDCAN_CKDIV_PDIV_B_0x6 = 0x6
	// Divide by 14
	FDCAN_CKDIV_PDIV_B_0x7 = 0x7
	// Divide by 16
	FDCAN_CKDIV_PDIV_B_0x8 = 0x8
	// Divide by 18
	FDCAN_CKDIV_PDIV_B_0x9 = 0x9
	// Divide by 20
	FDCAN_CKDIV_PDIV_B_0xA = 0xa
	// Divide by 22
	FDCAN_CKDIV_PDIV_B_0xB = 0xb
	// Divide by 24
	FDCAN_CKDIV_PDIV_B_0xC = 0xc
	// Divide by 26
	FDCAN_CKDIV_PDIV_B_0xD = 0xd
	// Divide by 28
	FDCAN_CKDIV_PDIV_B_0xE = 0xe
	// Divide by 30
	FDCAN_CKDIV_PDIV_B_0xF = 0xf
)

// Constants for FLASH: Flash
const (
	// ACR: Access control register
	// Position of LATENCY field.
	Flash_ACR_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	Flash_ACR_LATENCY_Msk = 0x7
	// Position of PRFTEN field.
	Flash_ACR_PRFTEN_Pos = 0x8
	// Bit mask of PRFTEN field.
	Flash_ACR_PRFTEN_Msk = 0x100
	// Bit PRFTEN.
	Flash_ACR_PRFTEN = 0x100
	// Position of ICEN field.
	Flash_ACR_ICEN_Pos = 0x9
	// Bit mask of ICEN field.
	Flash_ACR_ICEN_Msk = 0x200
	// Bit ICEN.
	Flash_ACR_ICEN = 0x200
	// Position of ICRST field.
	Flash_ACR_ICRST_Pos = 0xb
	// Bit mask of ICRST field.
	Flash_ACR_ICRST_Msk = 0x800
	// Bit ICRST.
	Flash_ACR_ICRST = 0x800
	// Position of EMPTY field.
	Flash_ACR_EMPTY_Pos = 0x10
	// Bit mask of EMPTY field.
	Flash_ACR_EMPTY_Msk = 0x10000
	// Bit EMPTY.
	Flash_ACR_EMPTY = 0x10000
	// Position of DBG_SWEN field.
	Flash_ACR_DBG_SWEN_Pos = 0x12
	// Bit mask of DBG_SWEN field.
	Flash_ACR_DBG_SWEN_Msk = 0x40000
	// Bit DBG_SWEN.
	Flash_ACR_DBG_SWEN = 0x40000

	// KEYR: Flash key register
	// Position of KEYR field.
	Flash_KEYR_KEYR_Pos = 0x0
	// Bit mask of KEYR field.
	Flash_KEYR_KEYR_Msk = 0xffffffff

	// OPTKEYR: Option byte key register
	// Position of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Pos = 0x0
	// Bit mask of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Msk = 0xffffffff

	// SR: Status register
	// Position of EOP field.
	Flash_SR_EOP_Pos = 0x0
	// Bit mask of EOP field.
	Flash_SR_EOP_Msk = 0x1
	// Bit EOP.
	Flash_SR_EOP = 0x1
	// Position of OPERR field.
	Flash_SR_OPERR_Pos = 0x1
	// Bit mask of OPERR field.
	Flash_SR_OPERR_Msk = 0x2
	// Bit OPERR.
	Flash_SR_OPERR = 0x2
	// Position of PROGERR field.
	Flash_SR_PROGERR_Pos = 0x3
	// Bit mask of PROGERR field.
	Flash_SR_PROGERR_Msk = 0x8
	// Bit PROGERR.
	Flash_SR_PROGERR = 0x8
	// Position of WRPERR field.
	Flash_SR_WRPERR_Pos = 0x4
	// Bit mask of WRPERR field.
	Flash_SR_WRPERR_Msk = 0x10
	// Bit WRPERR.
	Flash_SR_WRPERR = 0x10
	// Position of PGAERR field.
	Flash_SR_PGAERR_Pos = 0x5
	// Bit mask of PGAERR field.
	Flash_SR_PGAERR_Msk = 0x20
	// Bit PGAERR.
	Flash_SR_PGAERR = 0x20
	// Position of SIZERR field.
	Flash_SR_SIZERR_Pos = 0x6
	// Bit mask of SIZERR field.
	Flash_SR_SIZERR_Msk = 0x40
	// Bit SIZERR.
	Flash_SR_SIZERR = 0x40
	// Position of PGSERR field.
	Flash_SR_PGSERR_Pos = 0x7
	// Bit mask of PGSERR field.
	Flash_SR_PGSERR_Msk = 0x80
	// Bit PGSERR.
	Flash_SR_PGSERR = 0x80
	// Position of MISERR field.
	Flash_SR_MISERR_Pos = 0x8
	// Bit mask of MISERR field.
	Flash_SR_MISERR_Msk = 0x100
	// Bit MISERR.
	Flash_SR_MISERR = 0x100
	// Position of FASTERR field.
	Flash_SR_FASTERR_Pos = 0x9
	// Bit mask of FASTERR field.
	Flash_SR_FASTERR_Msk = 0x200
	// Bit FASTERR.
	Flash_SR_FASTERR = 0x200
	// Position of RDERR field.
	Flash_SR_RDERR_Pos = 0xe
	// Bit mask of RDERR field.
	Flash_SR_RDERR_Msk = 0x4000
	// Bit RDERR.
	Flash_SR_RDERR = 0x4000
	// Position of OPTVERR field.
	Flash_SR_OPTVERR_Pos = 0xf
	// Bit mask of OPTVERR field.
	Flash_SR_OPTVERR_Msk = 0x8000
	// Bit OPTVERR.
	Flash_SR_OPTVERR = 0x8000
	// Position of BSY field.
	Flash_SR_BSY_Pos = 0x10
	// Bit mask of BSY field.
	Flash_SR_BSY_Msk = 0x10000
	// Bit BSY.
	Flash_SR_BSY = 0x10000
	// Position of CFGBSY field.
	Flash_SR_CFGBSY_Pos = 0x12
	// Bit mask of CFGBSY field.
	Flash_SR_CFGBSY_Msk = 0x40000
	// Bit CFGBSY.
	Flash_SR_CFGBSY = 0x40000

	// CR: Flash control register
	// Position of PG field.
	Flash_CR_PG_Pos = 0x0
	// Bit mask of PG field.
	Flash_CR_PG_Msk = 0x1
	// Bit PG.
	Flash_CR_PG = 0x1
	// Position of PER field.
	Flash_CR_PER_Pos = 0x1
	// Bit mask of PER field.
	Flash_CR_PER_Msk = 0x2
	// Bit PER.
	Flash_CR_PER = 0x2
	// Position of MER field.
	Flash_CR_MER_Pos = 0x2
	// Bit mask of MER field.
	Flash_CR_MER_Msk = 0x4
	// Bit MER.
	Flash_CR_MER = 0x4
	// Position of PNB field.
	Flash_CR_PNB_Pos = 0x3
	// Bit mask of PNB field.
	Flash_CR_PNB_Msk = 0x1f8
	// Position of STRT field.
	Flash_CR_STRT_Pos = 0x10
	// Bit mask of STRT field.
	Flash_CR_STRT_Msk = 0x10000
	// Bit STRT.
	Flash_CR_STRT = 0x10000
	// Position of OPTSTRT field.
	Flash_CR_OPTSTRT_Pos = 0x11
	// Bit mask of OPTSTRT field.
	Flash_CR_OPTSTRT_Msk = 0x20000
	// Bit OPTSTRT.
	Flash_CR_OPTSTRT = 0x20000
	// Position of FSTPG field.
	Flash_CR_FSTPG_Pos = 0x12
	// Bit mask of FSTPG field.
	Flash_CR_FSTPG_Msk = 0x40000
	// Bit FSTPG.
	Flash_CR_FSTPG = 0x40000
	// Position of EOPIE field.
	Flash_CR_EOPIE_Pos = 0x18
	// Bit mask of EOPIE field.
	Flash_CR_EOPIE_Msk = 0x1000000
	// Bit EOPIE.
	Flash_CR_EOPIE = 0x1000000
	// Position of ERRIE field.
	Flash_CR_ERRIE_Pos = 0x19
	// Bit mask of ERRIE field.
	Flash_CR_ERRIE_Msk = 0x2000000
	// Bit ERRIE.
	Flash_CR_ERRIE = 0x2000000
	// Position of RDERRIE field.
	Flash_CR_RDERRIE_Pos = 0x1a
	// Bit mask of RDERRIE field.
	Flash_CR_RDERRIE_Msk = 0x4000000
	// Bit RDERRIE.
	Flash_CR_RDERRIE = 0x4000000
	// Position of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Pos = 0x1b
	// Bit mask of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Msk = 0x8000000
	// Bit OBL_LAUNCH.
	Flash_CR_OBL_LAUNCH = 0x8000000
	// Position of SEC_PROT field.
	Flash_CR_SEC_PROT_Pos = 0x1c
	// Bit mask of SEC_PROT field.
	Flash_CR_SEC_PROT_Msk = 0x10000000
	// Bit SEC_PROT.
	Flash_CR_SEC_PROT = 0x10000000
	// Position of OPTLOCK field.
	Flash_CR_OPTLOCK_Pos = 0x1e
	// Bit mask of OPTLOCK field.
	Flash_CR_OPTLOCK_Msk = 0x40000000
	// Bit OPTLOCK.
	Flash_CR_OPTLOCK = 0x40000000
	// Position of LOCK field.
	Flash_CR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Flash_CR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Flash_CR_LOCK = 0x80000000

	// ECCR: Flash ECC register
	// Position of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Pos = 0x0
	// Bit mask of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Msk = 0x3fff
	// Position of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Pos = 0x14
	// Bit mask of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Msk = 0x100000
	// Bit SYSF_ECC.
	Flash_ECCR_SYSF_ECC = 0x100000
	// Position of ECCIE field.
	Flash_ECCR_ECCIE_Pos = 0x18
	// Bit mask of ECCIE field.
	Flash_ECCR_ECCIE_Msk = 0x1000000
	// Bit ECCIE.
	Flash_ECCR_ECCIE = 0x1000000
	// Position of ECCC field.
	Flash_ECCR_ECCC_Pos = 0x1e
	// Bit mask of ECCC field.
	Flash_ECCR_ECCC_Msk = 0x40000000
	// Bit ECCC.
	Flash_ECCR_ECCC = 0x40000000
	// Position of ECCD field.
	Flash_ECCR_ECCD_Pos = 0x1f
	// Bit mask of ECCD field.
	Flash_ECCR_ECCD_Msk = 0x80000000
	// Bit ECCD.
	Flash_ECCR_ECCD = 0x80000000

	// OPTR: Flash option register
	// Position of RDP field.
	Flash_OPTR_RDP_Pos = 0x0
	// Bit mask of RDP field.
	Flash_OPTR_RDP_Msk = 0xff
	// Position of BOREN field.
	Flash_OPTR_BOREN_Pos = 0x8
	// Bit mask of BOREN field.
	Flash_OPTR_BOREN_Msk = 0x100
	// Bit BOREN.
	Flash_OPTR_BOREN = 0x100
	// Position of BORF_LEV field.
	Flash_OPTR_BORF_LEV_Pos = 0x9
	// Bit mask of BORF_LEV field.
	Flash_OPTR_BORF_LEV_Msk = 0x600
	// Position of BORR_LEV field.
	Flash_OPTR_BORR_LEV_Pos = 0xb
	// Bit mask of BORR_LEV field.
	Flash_OPTR_BORR_LEV_Msk = 0x1800
	// Position of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Pos = 0xd
	// Bit mask of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Msk = 0x2000
	// Bit NRST_STOP.
	Flash_OPTR_NRST_STOP = 0x2000
	// Position of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Pos = 0xe
	// Bit mask of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Msk = 0x4000
	// Bit NRST_STDBY.
	Flash_OPTR_NRST_STDBY = 0x4000
	// Position of NRSTS_HDW field.
	Flash_OPTR_NRSTS_HDW_Pos = 0xf
	// Bit mask of NRSTS_HDW field.
	Flash_OPTR_NRSTS_HDW_Msk = 0x8000
	// Bit NRSTS_HDW.
	Flash_OPTR_NRSTS_HDW = 0x8000
	// Position of IDWG_SW field.
	Flash_OPTR_IDWG_SW_Pos = 0x10
	// Bit mask of IDWG_SW field.
	Flash_OPTR_IDWG_SW_Msk = 0x10000
	// Bit IDWG_SW.
	Flash_OPTR_IDWG_SW = 0x10000
	// Position of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Pos = 0x11
	// Bit mask of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Msk = 0x20000
	// Bit IWDG_STOP.
	Flash_OPTR_IWDG_STOP = 0x20000
	// Position of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Pos = 0x12
	// Bit mask of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Msk = 0x40000
	// Bit IWDG_STDBY.
	Flash_OPTR_IWDG_STDBY = 0x40000
	// Position of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Pos = 0x13
	// Bit mask of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Msk = 0x80000
	// Bit WWDG_SW.
	Flash_OPTR_WWDG_SW = 0x80000
	// Position of RAM_PARITY_CHECK field.
	Flash_OPTR_RAM_PARITY_CHECK_Pos = 0x16
	// Bit mask of RAM_PARITY_CHECK field.
	Flash_OPTR_RAM_PARITY_CHECK_Msk = 0x400000
	// Bit RAM_PARITY_CHECK.
	Flash_OPTR_RAM_PARITY_CHECK = 0x400000
	// Position of NBOOT_SEL field.
	Flash_OPTR_NBOOT_SEL_Pos = 0x18
	// Bit mask of NBOOT_SEL field.
	Flash_OPTR_NBOOT_SEL_Msk = 0x1000000
	// Bit NBOOT_SEL.
	Flash_OPTR_NBOOT_SEL = 0x1000000
	// Position of NBOOT1 field.
	Flash_OPTR_NBOOT1_Pos = 0x19
	// Bit mask of NBOOT1 field.
	Flash_OPTR_NBOOT1_Msk = 0x2000000
	// Bit NBOOT1.
	Flash_OPTR_NBOOT1 = 0x2000000
	// Position of NBOOT0 field.
	Flash_OPTR_NBOOT0_Pos = 0x1a
	// Bit mask of NBOOT0 field.
	Flash_OPTR_NBOOT0_Msk = 0x4000000
	// Bit NBOOT0.
	Flash_OPTR_NBOOT0 = 0x4000000
	// Position of NRST_MODE field.
	Flash_OPTR_NRST_MODE_Pos = 0x1b
	// Bit mask of NRST_MODE field.
	Flash_OPTR_NRST_MODE_Msk = 0x18000000
	// Position of IRHEN field.
	Flash_OPTR_IRHEN_Pos = 0x1d
	// Bit mask of IRHEN field.
	Flash_OPTR_IRHEN_Msk = 0x20000000
	// Bit IRHEN.
	Flash_OPTR_IRHEN = 0x20000000

	// PCROP1ASR: Flash PCROP zone A Start address register
	// Position of PCROP1A_STRT field.
	Flash_PCROP1ASR_PCROP1A_STRT_Pos = 0x0
	// Bit mask of PCROP1A_STRT field.
	Flash_PCROP1ASR_PCROP1A_STRT_Msk = 0xff

	// PCROP1AER: Flash PCROP zone A End address register
	// Position of PCROP1A_END field.
	Flash_PCROP1AER_PCROP1A_END_Pos = 0x0
	// Bit mask of PCROP1A_END field.
	Flash_PCROP1AER_PCROP1A_END_Msk = 0xff
	// Position of PCROP_RDP field.
	Flash_PCROP1AER_PCROP_RDP_Pos = 0x1f
	// Bit mask of PCROP_RDP field.
	Flash_PCROP1AER_PCROP_RDP_Msk = 0x80000000
	// Bit PCROP_RDP.
	Flash_PCROP1AER_PCROP_RDP = 0x80000000

	// WRP1AR: Flash WRP area A address register
	// Position of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Pos = 0x0
	// Bit mask of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Msk = 0x3f
	// Position of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Pos = 0x10
	// Bit mask of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Msk = 0x3f0000

	// WRP1BR: Flash WRP area B address register
	// Position of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Pos = 0x0
	// Bit mask of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Msk = 0x3f
	// Position of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Pos = 0x10
	// Bit mask of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Msk = 0x3f0000

	// PCROP1BSR: Flash PCROP zone B Start address register
	// Position of PCROP1B_STRT field.
	Flash_PCROP1BSR_PCROP1B_STRT_Pos = 0x0
	// Bit mask of PCROP1B_STRT field.
	Flash_PCROP1BSR_PCROP1B_STRT_Msk = 0xff

	// PCROP1BER: Flash PCROP area B End address register
	// Position of PCROP1B_END field.
	Flash_PCROP1BER_PCROP1B_END_Pos = 0x0
	// Bit mask of PCROP1B_END field.
	Flash_PCROP1BER_PCROP1B_END_Msk = 0x1ff

	// PCROP2ASR: Flash PCROP2 area A start address register
	// Position of PCROP2A_STRT field.
	Flash_PCROP2ASR_PCROP2A_STRT_Pos = 0x0
	// Bit mask of PCROP2A_STRT field.
	Flash_PCROP2ASR_PCROP2A_STRT_Msk = 0x1ff

	// PCROP2AER: Flash PCROP2 area A end address register
	// Position of PCROP2A_END field.
	Flash_PCROP2AER_PCROP2A_END_Pos = 0x0
	// Bit mask of PCROP2A_END field.
	Flash_PCROP2AER_PCROP2A_END_Msk = 0x1ff

	// WRP2AR: Flash WRP2 area A address register
	// Position of WRP2A_STRT field.
	Flash_WRP2AR_WRP2A_STRT_Pos = 0x0
	// Bit mask of WRP2A_STRT field.
	Flash_WRP2AR_WRP2A_STRT_Msk = 0x7f
	// Position of WRP2A_END field.
	Flash_WRP2AR_WRP2A_END_Pos = 0x10
	// Bit mask of WRP2A_END field.
	Flash_WRP2AR_WRP2A_END_Msk = 0x7f0000

	// WRP2BR: Flash WRP2 area B address register
	// Position of WRP2B_STRT field.
	Flash_WRP2BR_WRP2B_STRT_Pos = 0x0
	// Bit mask of WRP2B_STRT field.
	Flash_WRP2BR_WRP2B_STRT_Msk = 0x7f
	// Position of WRP2B_END field.
	Flash_WRP2BR_WRP2B_END_Pos = 0x10
	// Bit mask of WRP2B_END field.
	Flash_WRP2BR_WRP2B_END_Msk = 0x7f0000

	// PCROP2BSR: FLASH PCROP2 area B start address register
	// Position of PCROP2B_STRT field.
	Flash_PCROP2BSR_PCROP2B_STRT_Pos = 0x0
	// Bit mask of PCROP2B_STRT field.
	Flash_PCROP2BSR_PCROP2B_STRT_Msk = 0x1ff

	// PCROP2BER: FLASH PCROP2 area B end address register
	// Position of PCROP2B_END field.
	Flash_PCROP2BER_PCROP2B_END_Pos = 0x0
	// Bit mask of PCROP2B_END field.
	Flash_PCROP2BER_PCROP2B_END_Msk = 0x1ff

	// SECR: Flash Security register
	// Position of SEC_SIZE field.
	Flash_SECR_SEC_SIZE_Pos = 0x0
	// Bit mask of SEC_SIZE field.
	Flash_SECR_SEC_SIZE_Msk = 0xff
	// Position of BOOT_LOCK field.
	Flash_SECR_BOOT_LOCK_Pos = 0x10
	// Bit mask of BOOT_LOCK field.
	Flash_SECR_BOOT_LOCK_Msk = 0x10000
	// Bit BOOT_LOCK.
	Flash_SECR_BOOT_LOCK = 0x10000
	// Position of SEC_SIZE2 field.
	Flash_SECR_SEC_SIZE2_Pos = 0x14
	// Bit mask of SEC_SIZE2 field.
	Flash_SECR_SEC_SIZE2_Msk = 0xff00000
)

// Constants for GPIOA: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODER15 field.
	GPIO_MODER_MODER15_Pos = 0x1e
	// Bit mask of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000
	// Position of MODER14 field.
	GPIO_MODER_MODER14_Pos = 0x1c
	// Bit mask of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000
	// Position of MODER13 field.
	GPIO_MODER_MODER13_Pos = 0x1a
	// Bit mask of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000
	// Position of MODER12 field.
	GPIO_MODER_MODER12_Pos = 0x18
	// Bit mask of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000
	// Position of MODER11 field.
	GPIO_MODER_MODER11_Pos = 0x16
	// Bit mask of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000
	// Position of MODER10 field.
	GPIO_MODER_MODER10_Pos = 0x14
	// Bit mask of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000
	// Position of MODER9 field.
	GPIO_MODER_MODER9_Pos = 0x12
	// Bit mask of MODER9 field.
	GPIO_MODER_MODER9_Msk = 0xc0000
	// Position of MODER8 field.
	GPIO_MODER_MODER8_Pos = 0x10
	// Bit mask of MODER8 field.
	GPIO_MODER_MODER8_Msk = 0x30000
	// Position of MODER7 field.
	GPIO_MODER_MODER7_Pos = 0xe
	// Bit mask of MODER7 field.
	GPIO_MODER_MODER7_Msk = 0xc000
	// Position of MODER6 field.
	GPIO_MODER_MODER6_Pos = 0xc
	// Bit mask of MODER6 field.
	GPIO_MODER_MODER6_Msk = 0x3000
	// Position of MODER5 field.
	GPIO_MODER_MODER5_Pos = 0xa
	// Bit mask of MODER5 field.
	GPIO_MODER_MODER5_Msk = 0xc00
	// Position of MODER4 field.
	GPIO_MODER_MODER4_Pos = 0x8
	// Bit mask of MODER4 field.
	GPIO_MODER_MODER4_Msk = 0x300
	// Position of MODER3 field.
	GPIO_MODER_MODER3_Pos = 0x6
	// Bit mask of MODER3 field.
	GPIO_MODER_MODER3_Msk = 0xc0
	// Position of MODER2 field.
	GPIO_MODER_MODER2_Pos = 0x4
	// Bit mask of MODER2 field.
	GPIO_MODER_MODER2_Msk = 0x30
	// Position of MODER1 field.
	GPIO_MODER_MODER1_Pos = 0x2
	// Bit mask of MODER1 field.
	GPIO_MODER_MODER1_Msk = 0xc
	// Position of MODER0 field.
	GPIO_MODER_MODER0_Pos = 0x0
	// Bit mask of MODER0 field.
	GPIO_MODER_MODER0_Msk = 0x3

	// OTYPER: GPIO port output type register
	// Position of OT15 field.
	GPIO_OTYPER_OT15_Pos = 0xf
	// Bit mask of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000
	// Bit OT15.
	GPIO_OTYPER_OT15 = 0x8000
	// Position of OT14 field.
	GPIO_OTYPER_OT14_Pos = 0xe
	// Bit mask of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000
	// Bit OT14.
	GPIO_OTYPER_OT14 = 0x4000
	// Position of OT13 field.
	GPIO_OTYPER_OT13_Pos = 0xd
	// Bit mask of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000
	// Bit OT13.
	GPIO_OTYPER_OT13 = 0x2000
	// Position of OT12 field.
	GPIO_OTYPER_OT12_Pos = 0xc
	// Bit mask of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000
	// Bit OT12.
	GPIO_OTYPER_OT12 = 0x1000
	// Position of OT11 field.
	GPIO_OTYPER_OT11_Pos = 0xb
	// Bit mask of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800
	// Bit OT11.
	GPIO_OTYPER_OT11 = 0x800
	// Position of OT10 field.
	GPIO_OTYPER_OT10_Pos = 0xa
	// Bit mask of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400
	// Bit OT10.
	GPIO_OTYPER_OT10 = 0x400
	// Position of OT9 field.
	GPIO_OTYPER_OT9_Pos = 0x9
	// Bit mask of OT9 field.
	GPIO_OTYPER_OT9_Msk = 0x200
	// Bit OT9.
	GPIO_OTYPER_OT9 = 0x200
	// Position of OT8 field.
	GPIO_OTYPER_OT8_Pos = 0x8
	// Bit mask of OT8 field.
	GPIO_OTYPER_OT8_Msk = 0x100
	// Bit OT8.
	GPIO_OTYPER_OT8 = 0x100
	// Position of OT7 field.
	GPIO_OTYPER_OT7_Pos = 0x7
	// Bit mask of OT7 field.
	GPIO_OTYPER_OT7_Msk = 0x80
	// Bit OT7.
	GPIO_OTYPER_OT7 = 0x80
	// Position of OT6 field.
	GPIO_OTYPER_OT6_Pos = 0x6
	// Bit mask of OT6 field.
	GPIO_OTYPER_OT6_Msk = 0x40
	// Bit OT6.
	GPIO_OTYPER_OT6 = 0x40
	// Position of OT5 field.
	GPIO_OTYPER_OT5_Pos = 0x5
	// Bit mask of OT5 field.
	GPIO_OTYPER_OT5_Msk = 0x20
	// Bit OT5.
	GPIO_OTYPER_OT5 = 0x20
	// Position of OT4 field.
	GPIO_OTYPER_OT4_Pos = 0x4
	// Bit mask of OT4 field.
	GPIO_OTYPER_OT4_Msk = 0x10
	// Bit OT4.
	GPIO_OTYPER_OT4 = 0x10
	// Position of OT3 field.
	GPIO_OTYPER_OT3_Pos = 0x3
	// Bit mask of OT3 field.
	GPIO_OTYPER_OT3_Msk = 0x8
	// Bit OT3.
	GPIO_OTYPER_OT3 = 0x8
	// Position of OT2 field.
	GPIO_OTYPER_OT2_Pos = 0x2
	// Bit mask of OT2 field.
	GPIO_OTYPER_OT2_Msk = 0x4
	// Bit OT2.
	GPIO_OTYPER_OT2 = 0x4
	// Position of OT1 field.
	GPIO_OTYPER_OT1_Pos = 0x1
	// Bit mask of OT1 field.
	GPIO_OTYPER_OT1_Msk = 0x2
	// Bit OT1.
	GPIO_OTYPER_OT1 = 0x2
	// Position of OT0 field.
	GPIO_OTYPER_OT0_Pos = 0x0
	// Bit mask of OT0 field.
	GPIO_OTYPER_OT0_Msk = 0x1
	// Bit OT0.
	GPIO_OTYPER_OT0 = 0x1

	// OSPEEDR: GPIO port output speed register
	// Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e
	// Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000
	// Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c
	// Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000
	// Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a
	// Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000
	// Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18
	// Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000
	// Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16
	// Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000
	// Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14
	// Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000
	// Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos = 0x12
	// Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk = 0xc0000
	// Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos = 0x10
	// Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk = 0x30000
	// Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos = 0xe
	// Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk = 0xc000
	// Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos = 0xc
	// Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk = 0x3000
	// Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos = 0xa
	// Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk = 0xc00
	// Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos = 0x8
	// Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk = 0x300
	// Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos = 0x6
	// Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk = 0xc0
	// Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos = 0x4
	// Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk = 0x30
	// Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos = 0x2
	// Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk = 0xc
	// Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos = 0x0
	// Bit mask of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk = 0x3

	// PUPDR: GPIO port pull-up/pull-down register
	// Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Pos = 0x1e
	// Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000
	// Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c
	// Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000
	// Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a
	// Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000
	// Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18
	// Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000
	// Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16
	// Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000
	// Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14
	// Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000
	// Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Pos = 0x12
	// Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk = 0xc0000
	// Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Pos = 0x10
	// Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk = 0x30000
	// Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Pos = 0xe
	// Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk = 0xc000
	// Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Pos = 0xc
	// Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk = 0x3000
	// Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Pos = 0xa
	// Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk = 0xc00
	// Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Pos = 0x8
	// Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk = 0x300
	// Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Pos = 0x6
	// Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk = 0xc0
	// Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Pos = 0x4
	// Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk = 0x30
	// Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Pos = 0x2
	// Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk = 0xc
	// Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Pos = 0x0
	// Bit mask of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk = 0x3

	// IDR: GPIO port input data register
	// Position of IDR15 field.
	GPIO_IDR_IDR15_Pos = 0xf
	// Bit mask of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000
	// Bit IDR15.
	GPIO_IDR_IDR15 = 0x8000
	// Position of IDR14 field.
	GPIO_IDR_IDR14_Pos = 0xe
	// Bit mask of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000
	// Bit IDR14.
	GPIO_IDR_IDR14 = 0x4000
	// Position of IDR13 field.
	GPIO_IDR_IDR13_Pos = 0xd
	// Bit mask of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000
	// Bit IDR13.
	GPIO_IDR_IDR13 = 0x2000
	// Position of IDR12 field.
	GPIO_IDR_IDR12_Pos = 0xc
	// Bit mask of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000
	// Bit IDR12.
	GPIO_IDR_IDR12 = 0x1000
	// Position of IDR11 field.
	GPIO_IDR_IDR11_Pos = 0xb
	// Bit mask of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800
	// Bit IDR11.
	GPIO_IDR_IDR11 = 0x800
	// Position of IDR10 field.
	GPIO_IDR_IDR10_Pos = 0xa
	// Bit mask of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400
	// Bit IDR10.
	GPIO_IDR_IDR10 = 0x400
	// Position of IDR9 field.
	GPIO_IDR_IDR9_Pos = 0x9
	// Bit mask of IDR9 field.
	GPIO_IDR_IDR9_Msk = 0x200
	// Bit IDR9.
	GPIO_IDR_IDR9 = 0x200
	// Position of IDR8 field.
	GPIO_IDR_IDR8_Pos = 0x8
	// Bit mask of IDR8 field.
	GPIO_IDR_IDR8_Msk = 0x100
	// Bit IDR8.
	GPIO_IDR_IDR8 = 0x100
	// Position of IDR7 field.
	GPIO_IDR_IDR7_Pos = 0x7
	// Bit mask of IDR7 field.
	GPIO_IDR_IDR7_Msk = 0x80
	// Bit IDR7.
	GPIO_IDR_IDR7 = 0x80
	// Position of IDR6 field.
	GPIO_IDR_IDR6_Pos = 0x6
	// Bit mask of IDR6 field.
	GPIO_IDR_IDR6_Msk = 0x40
	// Bit IDR6.
	GPIO_IDR_IDR6 = 0x40
	// Position of IDR5 field.
	GPIO_IDR_IDR5_Pos = 0x5
	// Bit mask of IDR5 field.
	GPIO_IDR_IDR5_Msk = 0x20
	// Bit IDR5.
	GPIO_IDR_IDR5 = 0x20
	// Position of IDR4 field.
	GPIO_IDR_IDR4_Pos = 0x4
	// Bit mask of IDR4 field.
	GPIO_IDR_IDR4_Msk = 0x10
	// Bit IDR4.
	GPIO_IDR_IDR4 = 0x10
	// Position of IDR3 field.
	GPIO_IDR_IDR3_Pos = 0x3
	// Bit mask of IDR3 field.
	GPIO_IDR_IDR3_Msk = 0x8
	// Bit IDR3.
	GPIO_IDR_IDR3 = 0x8
	// Position of IDR2 field.
	GPIO_IDR_IDR2_Pos = 0x2
	// Bit mask of IDR2 field.
	GPIO_IDR_IDR2_Msk = 0x4
	// Bit IDR2.
	GPIO_IDR_IDR2 = 0x4
	// Position of IDR1 field.
	GPIO_IDR_IDR1_Pos = 0x1
	// Bit mask of IDR1 field.
	GPIO_IDR_IDR1_Msk = 0x2
	// Bit IDR1.
	GPIO_IDR_IDR1 = 0x2
	// Position of IDR0 field.
	GPIO_IDR_IDR0_Pos = 0x0
	// Bit mask of IDR0 field.
	GPIO_IDR_IDR0_Msk = 0x1
	// Bit IDR0.
	GPIO_IDR_IDR0 = 0x1

	// ODR: GPIO port output data register
	// Position of ODR15 field.
	GPIO_ODR_ODR15_Pos = 0xf
	// Bit mask of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000
	// Bit ODR15.
	GPIO_ODR_ODR15 = 0x8000
	// Position of ODR14 field.
	GPIO_ODR_ODR14_Pos = 0xe
	// Bit mask of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000
	// Bit ODR14.
	GPIO_ODR_ODR14 = 0x4000
	// Position of ODR13 field.
	GPIO_ODR_ODR13_Pos = 0xd
	// Bit mask of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000
	// Bit ODR13.
	GPIO_ODR_ODR13 = 0x2000
	// Position of ODR12 field.
	GPIO_ODR_ODR12_Pos = 0xc
	// Bit mask of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000
	// Bit ODR12.
	GPIO_ODR_ODR12 = 0x1000
	// Position of ODR11 field.
	GPIO_ODR_ODR11_Pos = 0xb
	// Bit mask of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800
	// Bit ODR11.
	GPIO_ODR_ODR11 = 0x800
	// Position of ODR10 field.
	GPIO_ODR_ODR10_Pos = 0xa
	// Bit mask of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400
	// Bit ODR10.
	GPIO_ODR_ODR10 = 0x400
	// Position of ODR9 field.
	GPIO_ODR_ODR9_Pos = 0x9
	// Bit mask of ODR9 field.
	GPIO_ODR_ODR9_Msk = 0x200
	// Bit ODR9.
	GPIO_ODR_ODR9 = 0x200
	// Position of ODR8 field.
	GPIO_ODR_ODR8_Pos = 0x8
	// Bit mask of ODR8 field.
	GPIO_ODR_ODR8_Msk = 0x100
	// Bit ODR8.
	GPIO_ODR_ODR8 = 0x100
	// Position of ODR7 field.
	GPIO_ODR_ODR7_Pos = 0x7
	// Bit mask of ODR7 field.
	GPIO_ODR_ODR7_Msk = 0x80
	// Bit ODR7.
	GPIO_ODR_ODR7 = 0x80
	// Position of ODR6 field.
	GPIO_ODR_ODR6_Pos = 0x6
	// Bit mask of ODR6 field.
	GPIO_ODR_ODR6_Msk = 0x40
	// Bit ODR6.
	GPIO_ODR_ODR6 = 0x40
	// Position of ODR5 field.
	GPIO_ODR_ODR5_Pos = 0x5
	// Bit mask of ODR5 field.
	GPIO_ODR_ODR5_Msk = 0x20
	// Bit ODR5.
	GPIO_ODR_ODR5 = 0x20
	// Position of ODR4 field.
	GPIO_ODR_ODR4_Pos = 0x4
	// Bit mask of ODR4 field.
	GPIO_ODR_ODR4_Msk = 0x10
	// Bit ODR4.
	GPIO_ODR_ODR4 = 0x10
	// Position of ODR3 field.
	GPIO_ODR_ODR3_Pos = 0x3
	// Bit mask of ODR3 field.
	GPIO_ODR_ODR3_Msk = 0x8
	// Bit ODR3.
	GPIO_ODR_ODR3 = 0x8
	// Position of ODR2 field.
	GPIO_ODR_ODR2_Pos = 0x2
	// Bit mask of ODR2 field.
	GPIO_ODR_ODR2_Msk = 0x4
	// Bit ODR2.
	GPIO_ODR_ODR2 = 0x4
	// Position of ODR1 field.
	GPIO_ODR_ODR1_Pos = 0x1
	// Bit mask of ODR1 field.
	GPIO_ODR_ODR1_Msk = 0x2
	// Bit ODR1.
	GPIO_ODR_ODR1 = 0x2
	// Position of ODR0 field.
	GPIO_ODR_ODR0_Pos = 0x0
	// Bit mask of ODR0 field.
	GPIO_ODR_ODR0_Msk = 0x1
	// Bit ODR0.
	GPIO_ODR_ODR0 = 0x1

	// BSRR: GPIO port bit set/reset register
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1

	// LCKR: GPIO port configuration lock register
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1

	// AFRL: GPIO alternate function low register
	// Position of AFSEL7 field.
	GPIO_AFRL_AFSEL7_Pos = 0x1c
	// Bit mask of AFSEL7 field.
	GPIO_AFRL_AFSEL7_Msk = 0xf0000000
	// Position of AFSEL6 field.
	GPIO_AFRL_AFSEL6_Pos = 0x18
	// Bit mask of AFSEL6 field.
	GPIO_AFRL_AFSEL6_Msk = 0xf000000
	// Position of AFSEL5 field.
	GPIO_AFRL_AFSEL5_Pos = 0x14
	// Bit mask of AFSEL5 field.
	GPIO_AFRL_AFSEL5_Msk = 0xf00000
	// Position of AFSEL4 field.
	GPIO_AFRL_AFSEL4_Pos = 0x10
	// Bit mask of AFSEL4 field.
	GPIO_AFRL_AFSEL4_Msk = 0xf0000
	// Position of AFSEL3 field.
	GPIO_AFRL_AFSEL3_Pos = 0xc
	// Bit mask of AFSEL3 field.
	GPIO_AFRL_AFSEL3_Msk = 0xf000
	// Position of AFSEL2 field.
	GPIO_AFRL_AFSEL2_Pos = 0x8
	// Bit mask of AFSEL2 field.
	GPIO_AFRL_AFSEL2_Msk = 0xf00
	// Position of AFSEL1 field.
	GPIO_AFRL_AFSEL1_Pos = 0x4
	// Bit mask of AFSEL1 field.
	GPIO_AFRL_AFSEL1_Msk = 0xf0
	// Position of AFSEL0 field.
	GPIO_AFRL_AFSEL0_Pos = 0x0
	// Bit mask of AFSEL0 field.
	GPIO_AFRL_AFSEL0_Msk = 0xf

	// AFRH: GPIO alternate function high register
	// Position of AFSEL15 field.
	GPIO_AFRH_AFSEL15_Pos = 0x1c
	// Bit mask of AFSEL15 field.
	GPIO_AFRH_AFSEL15_Msk = 0xf0000000
	// Position of AFSEL14 field.
	GPIO_AFRH_AFSEL14_Pos = 0x18
	// Bit mask of AFSEL14 field.
	GPIO_AFRH_AFSEL14_Msk = 0xf000000
	// Position of AFSEL13 field.
	GPIO_AFRH_AFSEL13_Pos = 0x14
	// Bit mask of AFSEL13 field.
	GPIO_AFRH_AFSEL13_Msk = 0xf00000
	// Position of AFSEL12 field.
	GPIO_AFRH_AFSEL12_Pos = 0x10
	// Bit mask of AFSEL12 field.
	GPIO_AFRH_AFSEL12_Msk = 0xf0000
	// Position of AFSEL11 field.
	GPIO_AFRH_AFSEL11_Pos = 0xc
	// Bit mask of AFSEL11 field.
	GPIO_AFRH_AFSEL11_Msk = 0xf000
	// Position of AFSEL10 field.
	GPIO_AFRH_AFSEL10_Pos = 0x8
	// Bit mask of AFSEL10 field.
	GPIO_AFRH_AFSEL10_Msk = 0xf00
	// Position of AFSEL9 field.
	GPIO_AFRH_AFSEL9_Pos = 0x4
	// Bit mask of AFSEL9 field.
	GPIO_AFRH_AFSEL9_Msk = 0xf0
	// Position of AFSEL8 field.
	GPIO_AFRH_AFSEL8_Pos = 0x0
	// Bit mask of AFSEL8 field.
	GPIO_AFRH_AFSEL8_Msk = 0xf

	// BRR: port bit reset register
	// Position of BR0 field.
	GPIO_BRR_BR0_Pos = 0x0
	// Bit mask of BR0 field.
	GPIO_BRR_BR0_Msk = 0x1
	// Bit BR0.
	GPIO_BRR_BR0 = 0x1
	// Position of BR1 field.
	GPIO_BRR_BR1_Pos = 0x1
	// Bit mask of BR1 field.
	GPIO_BRR_BR1_Msk = 0x2
	// Bit BR1.
	GPIO_BRR_BR1 = 0x2
	// Position of BR2 field.
	GPIO_BRR_BR2_Pos = 0x2
	// Bit mask of BR2 field.
	GPIO_BRR_BR2_Msk = 0x4
	// Bit BR2.
	GPIO_BRR_BR2 = 0x4
	// Position of BR3 field.
	GPIO_BRR_BR3_Pos = 0x3
	// Bit mask of BR3 field.
	GPIO_BRR_BR3_Msk = 0x8
	// Bit BR3.
	GPIO_BRR_BR3 = 0x8
	// Position of BR4 field.
	GPIO_BRR_BR4_Pos = 0x4
	// Bit mask of BR4 field.
	GPIO_BRR_BR4_Msk = 0x10
	// Bit BR4.
	GPIO_BRR_BR4 = 0x10
	// Position of BR5 field.
	GPIO_BRR_BR5_Pos = 0x5
	// Bit mask of BR5 field.
	GPIO_BRR_BR5_Msk = 0x20
	// Bit BR5.
	GPIO_BRR_BR5 = 0x20
	// Position of BR6 field.
	GPIO_BRR_BR6_Pos = 0x6
	// Bit mask of BR6 field.
	GPIO_BRR_BR6_Msk = 0x40
	// Bit BR6.
	GPIO_BRR_BR6 = 0x40
	// Position of BR7 field.
	GPIO_BRR_BR7_Pos = 0x7
	// Bit mask of BR7 field.
	GPIO_BRR_BR7_Msk = 0x80
	// Bit BR7.
	GPIO_BRR_BR7 = 0x80
	// Position of BR8 field.
	GPIO_BRR_BR8_Pos = 0x8
	// Bit mask of BR8 field.
	GPIO_BRR_BR8_Msk = 0x100
	// Bit BR8.
	GPIO_BRR_BR8 = 0x100
	// Position of BR9 field.
	GPIO_BRR_BR9_Pos = 0x9
	// Bit mask of BR9 field.
	GPIO_BRR_BR9_Msk = 0x200
	// Bit BR9.
	GPIO_BRR_BR9 = 0x200
	// Position of BR10 field.
	GPIO_BRR_BR10_Pos = 0xa
	// Bit mask of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400
	// Bit BR10.
	GPIO_BRR_BR10 = 0x400
	// Position of BR11 field.
	GPIO_BRR_BR11_Pos = 0xb
	// Bit mask of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800
	// Bit BR11.
	GPIO_BRR_BR11 = 0x800
	// Position of BR12 field.
	GPIO_BRR_BR12_Pos = 0xc
	// Bit mask of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000
	// Bit BR12.
	GPIO_BRR_BR12 = 0x1000
	// Position of BR13 field.
	GPIO_BRR_BR13_Pos = 0xd
	// Bit mask of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000
	// Bit BR13.
	GPIO_BRR_BR13 = 0x2000
	// Position of BR14 field.
	GPIO_BRR_BR14_Pos = 0xe
	// Bit mask of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000
	// Bit BR14.
	GPIO_BRR_BR14 = 0x4000
	// Position of BR15 field.
	GPIO_BRR_BR15_Pos = 0xf
	// Bit mask of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000
	// Bit BR15.
	GPIO_BRR_BR15 = 0x8000
)

// Constants for HDMI_CEC: HDMI-CEC
const (
	// CEC_CR: CEC control register
	// Position of CECEN field.
	CEC_CEC_CR_CECEN_Pos = 0x0
	// Bit mask of CECEN field.
	CEC_CEC_CR_CECEN_Msk = 0x1
	// Bit CECEN.
	CEC_CEC_CR_CECEN = 0x1
	// CEC peripheral is off.
	CEC_CEC_CR_CECEN_B_0x0 = 0x0
	// CEC peripheral is on.
	CEC_CEC_CR_CECEN_B_0x1 = 0x1
	// Position of TXSOM field.
	CEC_CEC_CR_TXSOM_Pos = 0x1
	// Bit mask of TXSOM field.
	CEC_CEC_CR_TXSOM_Msk = 0x2
	// Bit TXSOM.
	CEC_CEC_CR_TXSOM = 0x2
	// No CEC transmission is on-going
	CEC_CEC_CR_TXSOM_B_0x0 = 0x0
	// CEC transmission command
	CEC_CEC_CR_TXSOM_B_0x1 = 0x1
	// Position of TXEOM field.
	CEC_CEC_CR_TXEOM_Pos = 0x2
	// Bit mask of TXEOM field.
	CEC_CEC_CR_TXEOM_Msk = 0x4
	// Bit TXEOM.
	CEC_CEC_CR_TXEOM = 0x4
	// TXDR data byte is transmitted with EOM = 0
	CEC_CEC_CR_TXEOM_B_0x0 = 0x0
	// TXDR data byte is transmitted with EOM = 1
	CEC_CEC_CR_TXEOM_B_0x1 = 0x1

	// CEC_CFGR: This register is used to configure the HDMI-CEC controller. It is mandatory to write CEC_CFGR only when CECEN=0.
	// Position of SFT field.
	CEC_CEC_CFGR_SFT_Pos = 0x0
	// Bit mask of SFT field.
	CEC_CEC_CFGR_SFT_Msk = 0x7
	// 0.5 nominal data bit periods
	CEC_CEC_CFGR_SFT_B_0x1 = 0x1
	// 1.5 nominal data bit periods
	CEC_CEC_CFGR_SFT_B_0x2 = 0x2
	// 2.5 nominal data bit periods
	CEC_CEC_CFGR_SFT_B_0x3 = 0x3
	// 3.5 nominal data bit periods
	CEC_CEC_CFGR_SFT_B_0x4 = 0x4
	// 4.5 nominal data bit periods
	CEC_CEC_CFGR_SFT_B_0x5 = 0x5
	// 5.5 nominal data bit periods
	CEC_CEC_CFGR_SFT_B_0x6 = 0x6
	// 6.5 nominal data bit periods
	CEC_CEC_CFGR_SFT_B_0x7 = 0x7
	// Position of RXTOL field.
	CEC_CEC_CFGR_RXTOL_Pos = 0x3
	// Bit mask of RXTOL field.
	CEC_CEC_CFGR_RXTOL_Msk = 0x8
	// Bit RXTOL.
	CEC_CEC_CFGR_RXTOL = 0x8
	// Standard tolerance margin:
	CEC_CEC_CFGR_RXTOL_B_0x0 = 0x0
	// Extended tolerance
	CEC_CEC_CFGR_RXTOL_B_0x1 = 0x1
	// Position of BRESTP field.
	CEC_CEC_CFGR_BRESTP_Pos = 0x4
	// Bit mask of BRESTP field.
	CEC_CEC_CFGR_BRESTP_Msk = 0x10
	// Bit BRESTP.
	CEC_CEC_CFGR_BRESTP = 0x10
	// BRE detection does not stop reception of the CEC message. Data bit is sampled at 1.05 ms.
	CEC_CEC_CFGR_BRESTP_B_0x0 = 0x0
	// BRE detection stops message reception.
	CEC_CEC_CFGR_BRESTP_B_0x1 = 0x1
	// Position of BREGEN field.
	CEC_CEC_CFGR_BREGEN_Pos = 0x5
	// Bit mask of BREGEN field.
	CEC_CEC_CFGR_BREGEN_Msk = 0x20
	// Bit BREGEN.
	CEC_CEC_CFGR_BREGEN = 0x20
	// BRE detection does not generate an error-bit on the CEC line.
	CEC_CEC_CFGR_BREGEN_B_0x0 = 0x0
	// BRE detection generates an error-bit on the CEC line (if BRESTP is set).
	CEC_CEC_CFGR_BREGEN_B_0x1 = 0x1
	// Position of LBPEGEN field.
	CEC_CEC_CFGR_LBPEGEN_Pos = 0x6
	// Bit mask of LBPEGEN field.
	CEC_CEC_CFGR_LBPEGEN_Msk = 0x40
	// Bit LBPEGEN.
	CEC_CEC_CFGR_LBPEGEN = 0x40
	// LBPE detection does not generate an error-bit on the CEC line.
	CEC_CEC_CFGR_LBPEGEN_B_0x0 = 0x0
	// LBPE detection generates an error-bit on the CEC line.
	CEC_CEC_CFGR_LBPEGEN_B_0x1 = 0x1
	// Position of BRDNOGEN field.
	CEC_CEC_CFGR_BRDNOGEN_Pos = 0x7
	// Bit mask of BRDNOGEN field.
	CEC_CEC_CFGR_BRDNOGEN_Msk = 0x80
	// Bit BRDNOGEN.
	CEC_CEC_CFGR_BRDNOGEN = 0x80
	// BRE detection with BRESTP = 1 and BREGEN = 0 on a broadcast message generates an
	CEC_CEC_CFGR_BRDNOGEN_B_0x0 = 0x0
	// Error-bit is not generated in the same condition as above. An error-bit is not generated even in case of an SBPE detection in a broadcast message if listen mode is set.
	CEC_CEC_CFGR_BRDNOGEN_B_0x1 = 0x1
	// Position of SFTOP field.
	CEC_CEC_CFGR_SFTOP_Pos = 0x8
	// Bit mask of SFTOP field.
	CEC_CEC_CFGR_SFTOP_Msk = 0x100
	// Bit SFTOP.
	CEC_CEC_CFGR_SFTOP = 0x100
	// SFT timer starts when TXSOM is set by software.
	CEC_CEC_CFGR_SFTOP_B_0x0 = 0x0
	// SFT timer starts automatically at the end of message transmission/reception.
	CEC_CEC_CFGR_SFTOP_B_0x1 = 0x1
	// Position of OAR field.
	CEC_CEC_CFGR_OAR_Pos = 0x10
	// Bit mask of OAR field.
	CEC_CEC_CFGR_OAR_Msk = 0x7fff0000
	// Position of LSTN field.
	CEC_CEC_CFGR_LSTN_Pos = 0x1f
	// Bit mask of LSTN field.
	CEC_CEC_CFGR_LSTN_Msk = 0x80000000
	// Bit LSTN.
	CEC_CEC_CFGR_LSTN = 0x80000000
	// CEC peripheral receives only message addressed to its own address (OAR). Messages addressed to different destination are ignored. Broadcast messages are always received.
	CEC_CEC_CFGR_LSTN_B_0x0 = 0x0
	// CEC peripheral receives messages addressed to its own address (OAR) with positive acknowledge. Messages addressed to different destination are received, but without interfering with the CEC bus: no acknowledge sent.
	CEC_CEC_CFGR_LSTN_B_0x1 = 0x1

	// CEC_TXDR: CEC Tx data register
	// Position of TXD field.
	CEC_CEC_TXDR_TXD_Pos = 0x0
	// Bit mask of TXD field.
	CEC_CEC_TXDR_TXD_Msk = 0xff

	// CEC_RXDR: CEC Rx Data Register
	// Position of RXD field.
	CEC_CEC_RXDR_RXD_Pos = 0x0
	// Bit mask of RXD field.
	CEC_CEC_RXDR_RXD_Msk = 0xff

	// CEC_ISR: CEC Interrupt and Status Register
	// Position of RXBR field.
	CEC_CEC_ISR_RXBR_Pos = 0x0
	// Bit mask of RXBR field.
	CEC_CEC_ISR_RXBR_Msk = 0x1
	// Bit RXBR.
	CEC_CEC_ISR_RXBR = 0x1
	// Position of RXEND field.
	CEC_CEC_ISR_RXEND_Pos = 0x1
	// Bit mask of RXEND field.
	CEC_CEC_ISR_RXEND_Msk = 0x2
	// Bit RXEND.
	CEC_CEC_ISR_RXEND = 0x2
	// Position of RXOVR field.
	CEC_CEC_ISR_RXOVR_Pos = 0x2
	// Bit mask of RXOVR field.
	CEC_CEC_ISR_RXOVR_Msk = 0x4
	// Bit RXOVR.
	CEC_CEC_ISR_RXOVR = 0x4
	// Position of BRE field.
	CEC_CEC_ISR_BRE_Pos = 0x3
	// Bit mask of BRE field.
	CEC_CEC_ISR_BRE_Msk = 0x8
	// Bit BRE.
	CEC_CEC_ISR_BRE = 0x8
	// Position of SBPE field.
	CEC_CEC_ISR_SBPE_Pos = 0x4
	// Bit mask of SBPE field.
	CEC_CEC_ISR_SBPE_Msk = 0x10
	// Bit SBPE.
	CEC_CEC_ISR_SBPE = 0x10
	// Position of LBPE field.
	CEC_CEC_ISR_LBPE_Pos = 0x5
	// Bit mask of LBPE field.
	CEC_CEC_ISR_LBPE_Msk = 0x20
	// Bit LBPE.
	CEC_CEC_ISR_LBPE = 0x20
	// Position of RXACKE field.
	CEC_CEC_ISR_RXACKE_Pos = 0x6
	// Bit mask of RXACKE field.
	CEC_CEC_ISR_RXACKE_Msk = 0x40
	// Bit RXACKE.
	CEC_CEC_ISR_RXACKE = 0x40
	// Position of ARBLST field.
	CEC_CEC_ISR_ARBLST_Pos = 0x7
	// Bit mask of ARBLST field.
	CEC_CEC_ISR_ARBLST_Msk = 0x80
	// Bit ARBLST.
	CEC_CEC_ISR_ARBLST = 0x80
	// Position of TXBR field.
	CEC_CEC_ISR_TXBR_Pos = 0x8
	// Bit mask of TXBR field.
	CEC_CEC_ISR_TXBR_Msk = 0x100
	// Bit TXBR.
	CEC_CEC_ISR_TXBR = 0x100
	// Position of TXEND field.
	CEC_CEC_ISR_TXEND_Pos = 0x9
	// Bit mask of TXEND field.
	CEC_CEC_ISR_TXEND_Msk = 0x200
	// Bit TXEND.
	CEC_CEC_ISR_TXEND = 0x200
	// Position of TXUDR field.
	CEC_CEC_ISR_TXUDR_Pos = 0xa
	// Bit mask of TXUDR field.
	CEC_CEC_ISR_TXUDR_Msk = 0x400
	// Bit TXUDR.
	CEC_CEC_ISR_TXUDR = 0x400
	// Position of TXERR field.
	CEC_CEC_ISR_TXERR_Pos = 0xb
	// Bit mask of TXERR field.
	CEC_CEC_ISR_TXERR_Msk = 0x800
	// Bit TXERR.
	CEC_CEC_ISR_TXERR = 0x800
	// Position of TXACKE field.
	CEC_CEC_ISR_TXACKE_Pos = 0xc
	// Bit mask of TXACKE field.
	CEC_CEC_ISR_TXACKE_Msk = 0x1000
	// Bit TXACKE.
	CEC_CEC_ISR_TXACKE = 0x1000

	// CEC_IER: CEC interrupt enable register
	// Position of RXBRIE field.
	CEC_CEC_IER_RXBRIE_Pos = 0x0
	// Bit mask of RXBRIE field.
	CEC_CEC_IER_RXBRIE_Msk = 0x1
	// Bit RXBRIE.
	CEC_CEC_IER_RXBRIE = 0x1
	// RXBR interrupt disabled
	CEC_CEC_IER_RXBRIE_B_0x0 = 0x0
	// RXBR interrupt enabled
	CEC_CEC_IER_RXBRIE_B_0x1 = 0x1
	// Position of RXENDIE field.
	CEC_CEC_IER_RXENDIE_Pos = 0x1
	// Bit mask of RXENDIE field.
	CEC_CEC_IER_RXENDIE_Msk = 0x2
	// Bit RXENDIE.
	CEC_CEC_IER_RXENDIE = 0x2
	// RXEND interrupt disabled
	CEC_CEC_IER_RXENDIE_B_0x0 = 0x0
	// RXEND interrupt enabled
	CEC_CEC_IER_RXENDIE_B_0x1 = 0x1
	// Position of RXOVRIE field.
	CEC_CEC_IER_RXOVRIE_Pos = 0x2
	// Bit mask of RXOVRIE field.
	CEC_CEC_IER_RXOVRIE_Msk = 0x4
	// Bit RXOVRIE.
	CEC_CEC_IER_RXOVRIE = 0x4
	// RXOVR interrupt disabled
	CEC_CEC_IER_RXOVRIE_B_0x0 = 0x0
	// RXOVR interrupt enabled
	CEC_CEC_IER_RXOVRIE_B_0x1 = 0x1
	// Position of BREIE field.
	CEC_CEC_IER_BREIE_Pos = 0x3
	// Bit mask of BREIE field.
	CEC_CEC_IER_BREIE_Msk = 0x8
	// Bit BREIE.
	CEC_CEC_IER_BREIE = 0x8
	// BRE interrupt disabled
	CEC_CEC_IER_BREIE_B_0x0 = 0x0
	// BRE interrupt enabled
	CEC_CEC_IER_BREIE_B_0x1 = 0x1
	// Position of SBPEIE field.
	CEC_CEC_IER_SBPEIE_Pos = 0x4
	// Bit mask of SBPEIE field.
	CEC_CEC_IER_SBPEIE_Msk = 0x10
	// Bit SBPEIE.
	CEC_CEC_IER_SBPEIE = 0x10
	// SBPE interrupt disabled
	CEC_CEC_IER_SBPEIE_B_0x0 = 0x0
	// SBPE interrupt enabled
	CEC_CEC_IER_SBPEIE_B_0x1 = 0x1
	// Position of LBPEIE field.
	CEC_CEC_IER_LBPEIE_Pos = 0x5
	// Bit mask of LBPEIE field.
	CEC_CEC_IER_LBPEIE_Msk = 0x20
	// Bit LBPEIE.
	CEC_CEC_IER_LBPEIE = 0x20
	// LBPE interrupt disabled
	CEC_CEC_IER_LBPEIE_B_0x0 = 0x0
	// LBPE interrupt enabled
	CEC_CEC_IER_LBPEIE_B_0x1 = 0x1
	// Position of RXACKIE field.
	CEC_CEC_IER_RXACKIE_Pos = 0x6
	// Bit mask of RXACKIE field.
	CEC_CEC_IER_RXACKIE_Msk = 0x40
	// Bit RXACKIE.
	CEC_CEC_IER_RXACKIE = 0x40
	// RXACKE interrupt disabled
	CEC_CEC_IER_RXACKIE_B_0x0 = 0x0
	// RXACKE interrupt enabled
	CEC_CEC_IER_RXACKIE_B_0x1 = 0x1
	// Position of ARBLSTIE field.
	CEC_CEC_IER_ARBLSTIE_Pos = 0x7
	// Bit mask of ARBLSTIE field.
	CEC_CEC_IER_ARBLSTIE_Msk = 0x80
	// Bit ARBLSTIE.
	CEC_CEC_IER_ARBLSTIE = 0x80
	// ARBLST interrupt disabled
	CEC_CEC_IER_ARBLSTIE_B_0x0 = 0x0
	// ARBLST interrupt enabled
	CEC_CEC_IER_ARBLSTIE_B_0x1 = 0x1
	// Position of TXBRIE field.
	CEC_CEC_IER_TXBRIE_Pos = 0x8
	// Bit mask of TXBRIE field.
	CEC_CEC_IER_TXBRIE_Msk = 0x100
	// Bit TXBRIE.
	CEC_CEC_IER_TXBRIE = 0x100
	// TXBR interrupt disabled
	CEC_CEC_IER_TXBRIE_B_0x0 = 0x0
	// TXBR interrupt enabled
	CEC_CEC_IER_TXBRIE_B_0x1 = 0x1
	// Position of TXENDIE field.
	CEC_CEC_IER_TXENDIE_Pos = 0x9
	// Bit mask of TXENDIE field.
	CEC_CEC_IER_TXENDIE_Msk = 0x200
	// Bit TXENDIE.
	CEC_CEC_IER_TXENDIE = 0x200
	// TXEND interrupt disabled
	CEC_CEC_IER_TXENDIE_B_0x0 = 0x0
	// TXEND interrupt enabled
	CEC_CEC_IER_TXENDIE_B_0x1 = 0x1
	// Position of TXUDRIE field.
	CEC_CEC_IER_TXUDRIE_Pos = 0xa
	// Bit mask of TXUDRIE field.
	CEC_CEC_IER_TXUDRIE_Msk = 0x400
	// Bit TXUDRIE.
	CEC_CEC_IER_TXUDRIE = 0x400
	// TXUDR interrupt disabled
	CEC_CEC_IER_TXUDRIE_B_0x0 = 0x0
	// TXUDR interrupt enabled
	CEC_CEC_IER_TXUDRIE_B_0x1 = 0x1
	// Position of TXERRIE field.
	CEC_CEC_IER_TXERRIE_Pos = 0xb
	// Bit mask of TXERRIE field.
	CEC_CEC_IER_TXERRIE_Msk = 0x800
	// Bit TXERRIE.
	CEC_CEC_IER_TXERRIE = 0x800
	// TXERR interrupt disabled
	CEC_CEC_IER_TXERRIE_B_0x0 = 0x0
	// TXERR interrupt enabled
	CEC_CEC_IER_TXERRIE_B_0x1 = 0x1
	// Position of TXACKIE field.
	CEC_CEC_IER_TXACKIE_Pos = 0xc
	// Bit mask of TXACKIE field.
	CEC_CEC_IER_TXACKIE_Msk = 0x1000
	// Bit TXACKIE.
	CEC_CEC_IER_TXACKIE = 0x1000
	// TXACKE interrupt disabled
	CEC_CEC_IER_TXACKIE_B_0x0 = 0x0
	// TXACKE interrupt enabled
	CEC_CEC_IER_TXACKIE_B_0x1 = 0x1
)

// Constants for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	// Position of PE field.
	I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_CR1_PE = 0x1
	// Peripheral disable
	I2C_CR1_PE_B_0x0 = 0x0
	// Peripheral enable
	I2C_CR1_PE_B_0x1 = 0x1
	// Position of TXIE field.
	I2C_CR1_TXIE_Pos = 0x1
	// Bit mask of TXIE field.
	I2C_CR1_TXIE_Msk = 0x2
	// Bit TXIE.
	I2C_CR1_TXIE = 0x2
	// Transmit (TXIS) interrupt disabled
	I2C_CR1_TXIE_B_0x0 = 0x0
	// Transmit (TXIS) interrupt enabled
	I2C_CR1_TXIE_B_0x1 = 0x1
	// Position of RXIE field.
	I2C_CR1_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	I2C_CR1_RXIE_Msk = 0x4
	// Bit RXIE.
	I2C_CR1_RXIE = 0x4
	// Receive (RXNE) interrupt disabled
	I2C_CR1_RXIE_B_0x0 = 0x0
	// Receive (RXNE) interrupt enabled
	I2C_CR1_RXIE_B_0x1 = 0x1
	// Position of ADDRIE field.
	I2C_CR1_ADDRIE_Pos = 0x3
	// Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE_Msk = 0x8
	// Bit ADDRIE.
	I2C_CR1_ADDRIE = 0x8
	// Address match (ADDR) interrupts disabled
	I2C_CR1_ADDRIE_B_0x0 = 0x0
	// Address match (ADDR) interrupts enabled
	I2C_CR1_ADDRIE_B_0x1 = 0x1
	// Position of NACKIE field.
	I2C_CR1_NACKIE_Pos = 0x4
	// Bit mask of NACKIE field.
	I2C_CR1_NACKIE_Msk = 0x10
	// Bit NACKIE.
	I2C_CR1_NACKIE = 0x10
	// Not acknowledge (NACKF) received interrupts disabled
	I2C_CR1_NACKIE_B_0x0 = 0x0
	// Not acknowledge (NACKF) received interrupts enabled
	I2C_CR1_NACKIE_B_0x1 = 0x1
	// Position of STOPIE field.
	I2C_CR1_STOPIE_Pos = 0x5
	// Bit mask of STOPIE field.
	I2C_CR1_STOPIE_Msk = 0x20
	// Bit STOPIE.
	I2C_CR1_STOPIE = 0x20
	// Stop detection (STOPF) interrupt disabled
	I2C_CR1_STOPIE_B_0x0 = 0x0
	// Stop detection (STOPF) interrupt enabled
	I2C_CR1_STOPIE_B_0x1 = 0x1
	// Position of TCIE field.
	I2C_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	I2C_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	I2C_CR1_TCIE = 0x40
	// Transfer Complete interrupt disabled
	I2C_CR1_TCIE_B_0x0 = 0x0
	// Transfer Complete interrupt enabled
	I2C_CR1_TCIE_B_0x1 = 0x1
	// Position of ERRIE field.
	I2C_CR1_ERRIE_Pos = 0x7
	// Bit mask of ERRIE field.
	I2C_CR1_ERRIE_Msk = 0x80
	// Bit ERRIE.
	I2C_CR1_ERRIE = 0x80
	// Error detection interrupts disabled
	I2C_CR1_ERRIE_B_0x0 = 0x0
	// Error detection interrupts enabled
	I2C_CR1_ERRIE_B_0x1 = 0x1
	// Position of DNF field.
	I2C_CR1_DNF_Pos = 0x8
	// Bit mask of DNF field.
	I2C_CR1_DNF_Msk = 0xf00
	// Digital filter disabled
	I2C_CR1_DNF_B_0x0 = 0x0
	// Digital filter enabled and filtering capability up to 1 tI2CCLK
	I2C_CR1_DNF_B_0x1 = 0x1
	// digital filter enabled and filtering capability up to15 tI2CCLK
	I2C_CR1_DNF_B_0xF = 0xf
	// Position of ANFOFF field.
	I2C_CR1_ANFOFF_Pos = 0xc
	// Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF_Msk = 0x1000
	// Bit ANFOFF.
	I2C_CR1_ANFOFF = 0x1000
	// Analog noise filter enabled
	I2C_CR1_ANFOFF_B_0x0 = 0x0
	// Analog noise filter disabled
	I2C_CR1_ANFOFF_B_0x1 = 0x1
	// Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Pos = 0xe
	// Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk = 0x4000
	// Bit TXDMAEN.
	I2C_CR1_TXDMAEN = 0x4000
	// DMA mode disabled for transmission
	I2C_CR1_TXDMAEN_B_0x0 = 0x0
	// DMA mode enabled for transmission
	I2C_CR1_TXDMAEN_B_0x1 = 0x1
	// Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Pos = 0xf
	// Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk = 0x8000
	// Bit RXDMAEN.
	I2C_CR1_RXDMAEN = 0x8000
	// DMA mode disabled for reception
	I2C_CR1_RXDMAEN_B_0x0 = 0x0
	// DMA mode enabled for reception
	I2C_CR1_RXDMAEN_B_0x1 = 0x1
	// Position of SBC field.
	I2C_CR1_SBC_Pos = 0x10
	// Bit mask of SBC field.
	I2C_CR1_SBC_Msk = 0x10000
	// Bit SBC.
	I2C_CR1_SBC = 0x10000
	// Slave byte control disabled
	I2C_CR1_SBC_B_0x0 = 0x0
	// Slave byte control enabled
	I2C_CR1_SBC_B_0x1 = 0x1
	// Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Pos = 0x11
	// Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000
	// Bit NOSTRETCH.
	I2C_CR1_NOSTRETCH = 0x20000
	// Clock stretching enabled
	I2C_CR1_NOSTRETCH_B_0x0 = 0x0
	// Clock stretching disabled
	I2C_CR1_NOSTRETCH_B_0x1 = 0x1
	// Position of WUPEN field.
	I2C_CR1_WUPEN_Pos = 0x12
	// Bit mask of WUPEN field.
	I2C_CR1_WUPEN_Msk = 0x40000
	// Bit WUPEN.
	I2C_CR1_WUPEN = 0x40000
	// Wakeup from Stop mode disable.
	I2C_CR1_WUPEN_B_0x0 = 0x0
	// Wakeup from Stop mode enable.
	I2C_CR1_WUPEN_B_0x1 = 0x1
	// Position of GCEN field.
	I2C_CR1_GCEN_Pos = 0x13
	// Bit mask of GCEN field.
	I2C_CR1_GCEN_Msk = 0x80000
	// Bit GCEN.
	I2C_CR1_GCEN = 0x80000
	// General call disabled. Address 0b00000000 is NACKed.
	I2C_CR1_GCEN_B_0x0 = 0x0
	// General call enabled. Address 0b00000000 is ACKed.
	I2C_CR1_GCEN_B_0x1 = 0x1
	// Position of SMBHEN field.
	I2C_CR1_SMBHEN_Pos = 0x14
	// Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN_Msk = 0x100000
	// Bit SMBHEN.
	I2C_CR1_SMBHEN = 0x100000
	// Host Address disabled. Address 0b0001000x is NACKed.
	I2C_CR1_SMBHEN_B_0x0 = 0x0
	// Host Address enabled. Address 0b0001000x is ACKed.
	I2C_CR1_SMBHEN_B_0x1 = 0x1
	// Position of SMBDEN field.
	I2C_CR1_SMBDEN_Pos = 0x15
	// Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN_Msk = 0x200000
	// Bit SMBDEN.
	I2C_CR1_SMBDEN = 0x200000
	// Device Default Address disabled. Address 0b1100001x is NACKed.
	I2C_CR1_SMBDEN_B_0x0 = 0x0
	// Device Default Address enabled. Address 0b1100001x is ACKed.
	I2C_CR1_SMBDEN_B_0x1 = 0x1
	// Position of ALERTEN field.
	I2C_CR1_ALERTEN_Pos = 0x16
	// Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN_Msk = 0x400000
	// Bit ALERTEN.
	I2C_CR1_ALERTEN = 0x400000
	// The SMBus alert pin (SMBA) is not supported in host mode (SMBHEN=1). In device mode (SMBHEN=0), the SMBA pin is released and the Alert Response Address header is disabled (0001100x followed by NACK).
	I2C_CR1_ALERTEN_B_0x0 = 0x0
	// The SMBus alert pin is supported in host mode (SMBHEN=1). In device mode (SMBHEN=0), the SMBA pin is driven low and the Alert Response Address header is enabled (0001100x followed by ACK).
	I2C_CR1_ALERTEN_B_0x1 = 0x1
	// Position of PECEN field.
	I2C_CR1_PECEN_Pos = 0x17
	// Bit mask of PECEN field.
	I2C_CR1_PECEN_Msk = 0x800000
	// Bit PECEN.
	I2C_CR1_PECEN = 0x800000
	// PEC calculation disabled
	I2C_CR1_PECEN_B_0x0 = 0x0
	// PEC calculation enabled
	I2C_CR1_PECEN_B_0x1 = 0x1

	// CR2: Control register 2
	// Position of SADD field.
	I2C_CR2_SADD_Pos = 0x0
	// Bit mask of SADD field.
	I2C_CR2_SADD_Msk = 0x3ff
	// Position of RD_WRN field.
	I2C_CR2_RD_WRN_Pos = 0xa
	// Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN_Msk = 0x400
	// Bit RD_WRN.
	I2C_CR2_RD_WRN = 0x400
	// Master requests a write transfer.
	I2C_CR2_RD_WRN_B_0x0 = 0x0
	// Master requests a read transfer.
	I2C_CR2_RD_WRN_B_0x1 = 0x1
	// Position of ADD10 field.
	I2C_CR2_ADD10_Pos = 0xb
	// Bit mask of ADD10 field.
	I2C_CR2_ADD10_Msk = 0x800
	// Bit ADD10.
	I2C_CR2_ADD10 = 0x800
	// The master operates in 7-bit addressing mode,
	I2C_CR2_ADD10_B_0x0 = 0x0
	// The master operates in 10-bit addressing mode
	I2C_CR2_ADD10_B_0x1 = 0x1
	// Position of HEAD10R field.
	I2C_CR2_HEAD10R_Pos = 0xc
	// Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000
	// Bit HEAD10R.
	I2C_CR2_HEAD10R = 0x1000
	// The master sends the complete 10 bit slave address read sequence: Start + 2 bytes 10bit address in write direction + Restart + 1st 7 bits of the 10 bit address in read direction.
	I2C_CR2_HEAD10R_B_0x0 = 0x0
	// The master only sends the 1st 7 bits of the 10 bit address, followed by Read direction.
	I2C_CR2_HEAD10R_B_0x1 = 0x1
	// Position of START field.
	I2C_CR2_START_Pos = 0xd
	// Bit mask of START field.
	I2C_CR2_START_Msk = 0x2000
	// Bit START.
	I2C_CR2_START = 0x2000
	// No Start generation.
	I2C_CR2_START_B_0x0 = 0x0
	// Restart/Start generation:
	I2C_CR2_START_B_0x1 = 0x1
	// Position of STOP field.
	I2C_CR2_STOP_Pos = 0xe
	// Bit mask of STOP field.
	I2C_CR2_STOP_Msk = 0x4000
	// Bit STOP.
	I2C_CR2_STOP = 0x4000
	// No Stop generation.
	I2C_CR2_STOP_B_0x0 = 0x0
	// Stop generation after current byte transfer.
	I2C_CR2_STOP_B_0x1 = 0x1
	// Position of NACK field.
	I2C_CR2_NACK_Pos = 0xf
	// Bit mask of NACK field.
	I2C_CR2_NACK_Msk = 0x8000
	// Bit NACK.
	I2C_CR2_NACK = 0x8000
	// an ACK is sent after current received byte.
	I2C_CR2_NACK_B_0x0 = 0x0
	// a NACK is sent after current received byte.
	I2C_CR2_NACK_B_0x1 = 0x1
	// Position of NBYTES field.
	I2C_CR2_NBYTES_Pos = 0x10
	// Bit mask of NBYTES field.
	I2C_CR2_NBYTES_Msk = 0xff0000
	// Position of RELOAD field.
	I2C_CR2_RELOAD_Pos = 0x18
	// Bit mask of RELOAD field.
	I2C_CR2_RELOAD_Msk = 0x1000000
	// Bit RELOAD.
	I2C_CR2_RELOAD = 0x1000000
	// The transfer is completed after the NBYTES data transfer (STOP or RESTART follows).
	I2C_CR2_RELOAD_B_0x0 = 0x0
	// The transfer is not completed after the NBYTES data transfer (NBYTES is reloaded). TCR flag is set when NBYTES data are transferred, stretching SCL low.
	I2C_CR2_RELOAD_B_0x1 = 0x1
	// Position of AUTOEND field.
	I2C_CR2_AUTOEND_Pos = 0x19
	// Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000
	// Bit AUTOEND.
	I2C_CR2_AUTOEND = 0x2000000
	// software end mode: TC flag is set when NBYTES data are transferred, stretching SCL low.
	I2C_CR2_AUTOEND_B_0x0 = 0x0
	// Automatic end mode: a STOP condition is automatically sent when NBYTES data are transferred.
	I2C_CR2_AUTOEND_B_0x1 = 0x1
	// Position of PECBYTE field.
	I2C_CR2_PECBYTE_Pos = 0x1a
	// Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000
	// Bit PECBYTE.
	I2C_CR2_PECBYTE = 0x4000000
	// No PEC transfer.
	I2C_CR2_PECBYTE_B_0x0 = 0x0
	// PEC transmission/reception is requested
	I2C_CR2_PECBYTE_B_0x1 = 0x1

	// OAR1: Own address register 1
	// Position of OA1 field.
	I2C_OAR1_OA1_Pos = 0x0
	// Bit mask of OA1 field.
	I2C_OAR1_OA1_Msk = 0x3ff
	// Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Pos = 0xa
	// Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400
	// Bit OA1MODE.
	I2C_OAR1_OA1MODE = 0x400
	// Own address 1 is a 7-bit address.
	I2C_OAR1_OA1MODE_B_0x0 = 0x0
	// Own address 1 is a 10-bit address.
	I2C_OAR1_OA1MODE_B_0x1 = 0x1
	// Position of OA1EN field.
	I2C_OAR1_OA1EN_Pos = 0xf
	// Bit mask of OA1EN field.
	I2C_OAR1_OA1EN_Msk = 0x8000
	// Bit OA1EN.
	I2C_OAR1_OA1EN = 0x8000
	// Own address 1 disabled. The received slave address OA1 is NACKed.
	I2C_OAR1_OA1EN_B_0x0 = 0x0
	// Own address 1 enabled. The received slave address OA1 is ACKed.
	I2C_OAR1_OA1EN_B_0x1 = 0x1

	// OAR2: Own address register 2
	// Position of OA2 field.
	I2C_OAR2_OA2_Pos = 0x1
	// Bit mask of OA2 field.
	I2C_OAR2_OA2_Msk = 0xfe
	// Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Pos = 0x8
	// Bit mask of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700
	// No mask
	I2C_OAR2_OA2MSK_B_0x0 = 0x0
	// OA2[1] is masked and donât care. Only OA2[7:2] are compared.
	I2C_OAR2_OA2MSK_B_0x1 = 0x1
	// OA2[2:1] are masked and donât care. Only OA2[7:3] are compared.
	I2C_OAR2_OA2MSK_B_0x2 = 0x2
	// OA2[3:1] are masked and donât care. Only OA2[7:4] are compared.
	I2C_OAR2_OA2MSK_B_0x3 = 0x3
	// OA2[4:1] are masked and donât care. Only OA2[7:5] are compared.
	I2C_OAR2_OA2MSK_B_0x4 = 0x4
	// OA2[5:1] are masked and donât care. Only OA2[7:6] are compared.
	I2C_OAR2_OA2MSK_B_0x5 = 0x5
	// OA2[6:1] are masked and donât care. Only OA2[7] is compared.
	I2C_OAR2_OA2MSK_B_0x6 = 0x6
	// OA2[7:1] are masked and donât care. No comparison is done, and all (except reserved) 7-bit received addresses are acknowledged.
	I2C_OAR2_OA2MSK_B_0x7 = 0x7
	// Position of OA2EN field.
	I2C_OAR2_OA2EN_Pos = 0xf
	// Bit mask of OA2EN field.
	I2C_OAR2_OA2EN_Msk = 0x8000
	// Bit OA2EN.
	I2C_OAR2_OA2EN = 0x8000
	// Own address 2 disabled. The received slave address OA2 is NACKed.
	I2C_OAR2_OA2EN_B_0x0 = 0x0
	// Own address 2 enabled. The received slave address OA2 is ACKed.
	I2C_OAR2_OA2EN_B_0x1 = 0x1

	// TIMINGR: Timing register
	// Position of SCLL field.
	I2C_TIMINGR_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C_TIMINGR_SCLL_Msk = 0xff
	// Position of SCLH field.
	I2C_TIMINGR_SCLH_Pos = 0x8
	// Bit mask of SCLH field.
	I2C_TIMINGR_SCLH_Msk = 0xff00
	// Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Pos = 0x10
	// Bit mask of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000
	// Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14
	// Bit mask of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000
	// Position of PRESC field.
	I2C_TIMINGR_PRESC_Pos = 0x1c
	// Bit mask of PRESC field.
	I2C_TIMINGR_PRESC_Msk = 0xf0000000

	// TIMEOUTR: Status register 1
	// Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0
	// Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff
	// Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Pos = 0xc
	// Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk = 0x1000
	// Bit TIDLE.
	I2C_TIMEOUTR_TIDLE = 0x1000
	// TIMEOUTA is used to detect SCL low timeout
	I2C_TIMEOUTR_TIDLE_B_0x0 = 0x0
	// TIMEOUTA is used to detect both SCL and SDA high timeout (bus idle condition)
	I2C_TIMEOUTR_TIDLE_B_0x1 = 0x1
	// Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf
	// Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000
	// Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMOUTEN = 0x8000
	// SCL timeout detection is disabled
	I2C_TIMEOUTR_TIMOUTEN_B_0x0 = 0x0
	// SCL timeout detection is enabled: when SCL is low for more than tTIMEOUT (TIDLE=0) or high for more than tIDLE (TIDLE=1), a timeout error is detected (TIMEOUT=1).
	I2C_TIMEOUTR_TIMOUTEN_B_0x1 = 0x1
	// Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10
	// Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000
	// Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Pos = 0x1f
	// Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk = 0x80000000
	// Bit TEXTEN.
	I2C_TIMEOUTR_TEXTEN = 0x80000000
	// Extended clock timeout detection is disabled
	I2C_TIMEOUTR_TEXTEN_B_0x0 = 0x0
	// Extended clock timeout detection is enabled. When a cumulative SCL stretch for more than tLOW:EXT is done by the I2C interface, a timeout error is detected (TIMEOUT=1).
	I2C_TIMEOUTR_TEXTEN_B_0x1 = 0x1

	// ISR: Interrupt and Status register
	// Position of ADDCODE field.
	I2C_ISR_ADDCODE_Pos = 0x11
	// Bit mask of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000
	// Position of DIR field.
	I2C_ISR_DIR_Pos = 0x10
	// Bit mask of DIR field.
	I2C_ISR_DIR_Msk = 0x10000
	// Bit DIR.
	I2C_ISR_DIR = 0x10000
	// Write transfer, slave enters receiver mode.
	I2C_ISR_DIR_B_0x0 = 0x0
	// Read transfer, slave enters transmitter mode.
	I2C_ISR_DIR_B_0x1 = 0x1
	// Position of BUSY field.
	I2C_ISR_BUSY_Pos = 0xf
	// Bit mask of BUSY field.
	I2C_ISR_BUSY_Msk = 0x8000
	// Bit BUSY.
	I2C_ISR_BUSY = 0x8000
	// Position of ALERT field.
	I2C_ISR_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_ISR_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_ISR_ALERT = 0x2000
	// Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Pos = 0xc
	// Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000
	// Bit TIMEOUT.
	I2C_ISR_TIMEOUT = 0x1000
	// Position of PECERR field.
	I2C_ISR_PECERR_Pos = 0xb
	// Bit mask of PECERR field.
	I2C_ISR_PECERR_Msk = 0x800
	// Bit PECERR.
	I2C_ISR_PECERR = 0x800
	// Position of OVR field.
	I2C_ISR_OVR_Pos = 0xa
	// Bit mask of OVR field.
	I2C_ISR_OVR_Msk = 0x400
	// Bit OVR.
	I2C_ISR_OVR = 0x400
	// Position of ARLO field.
	I2C_ISR_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_ISR_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_ISR_ARLO = 0x200
	// Position of BERR field.
	I2C_ISR_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_ISR_BERR_Msk = 0x100
	// Bit BERR.
	I2C_ISR_BERR = 0x100
	// Position of TCR field.
	I2C_ISR_TCR_Pos = 0x7
	// Bit mask of TCR field.
	I2C_ISR_TCR_Msk = 0x80
	// Bit TCR.
	I2C_ISR_TCR = 0x80
	// Position of TC field.
	I2C_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	I2C_ISR_TC_Msk = 0x40
	// Bit TC.
	I2C_ISR_TC = 0x40
	// Position of STOPF field.
	I2C_ISR_STOPF_Pos = 0x5
	// Bit mask of STOPF field.
	I2C_ISR_STOPF_Msk = 0x20
	// Bit STOPF.
	I2C_ISR_STOPF = 0x20
	// Position of NACKF field.
	I2C_ISR_NACKF_Pos = 0x4
	// Bit mask of NACKF field.
	I2C_ISR_NACKF_Msk = 0x10
	// Bit NACKF.
	I2C_ISR_NACKF = 0x10
	// Position of ADDR field.
	I2C_ISR_ADDR_Pos = 0x3
	// Bit mask of ADDR field.
	I2C_ISR_ADDR_Msk = 0x8
	// Bit ADDR.
	I2C_ISR_ADDR = 0x8
	// Position of RXNE field.
	I2C_ISR_RXNE_Pos = 0x2
	// Bit mask of RXNE field.
	I2C_ISR_RXNE_Msk = 0x4
	// Bit RXNE.
	I2C_ISR_RXNE = 0x4
	// Position of TXIS field.
	I2C_ISR_TXIS_Pos = 0x1
	// Bit mask of TXIS field.
	I2C_ISR_TXIS_Msk = 0x2
	// Bit TXIS.
	I2C_ISR_TXIS = 0x2
	// Position of TXE field.
	I2C_ISR_TXE_Pos = 0x0
	// Bit mask of TXE field.
	I2C_ISR_TXE_Msk = 0x1
	// Bit TXE.
	I2C_ISR_TXE = 0x1

	// ICR: Interrupt clear register
	// Position of ALERTCF field.
	I2C_ICR_ALERTCF_Pos = 0xd
	// Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF_Msk = 0x2000
	// Bit ALERTCF.
	I2C_ICR_ALERTCF = 0x2000
	// Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Pos = 0xc
	// Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000
	// Bit TIMOUTCF.
	I2C_ICR_TIMOUTCF = 0x1000
	// Position of PECCF field.
	I2C_ICR_PECCF_Pos = 0xb
	// Bit mask of PECCF field.
	I2C_ICR_PECCF_Msk = 0x800
	// Bit PECCF.
	I2C_ICR_PECCF = 0x800
	// Position of OVRCF field.
	I2C_ICR_OVRCF_Pos = 0xa
	// Bit mask of OVRCF field.
	I2C_ICR_OVRCF_Msk = 0x400
	// Bit OVRCF.
	I2C_ICR_OVRCF = 0x400
	// Position of ARLOCF field.
	I2C_ICR_ARLOCF_Pos = 0x9
	// Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF_Msk = 0x200
	// Bit ARLOCF.
	I2C_ICR_ARLOCF = 0x200
	// Position of BERRCF field.
	I2C_ICR_BERRCF_Pos = 0x8
	// Bit mask of BERRCF field.
	I2C_ICR_BERRCF_Msk = 0x100
	// Bit BERRCF.
	I2C_ICR_BERRCF = 0x100
	// Position of STOPCF field.
	I2C_ICR_STOPCF_Pos = 0x5
	// Bit mask of STOPCF field.
	I2C_ICR_STOPCF_Msk = 0x20
	// Bit STOPCF.
	I2C_ICR_STOPCF = 0x20
	// Position of NACKCF field.
	I2C_ICR_NACKCF_Pos = 0x4
	// Bit mask of NACKCF field.
	I2C_ICR_NACKCF_Msk = 0x10
	// Bit NACKCF.
	I2C_ICR_NACKCF = 0x10
	// Position of ADDRCF field.
	I2C_ICR_ADDRCF_Pos = 0x3
	// Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF_Msk = 0x8
	// Bit ADDRCF.
	I2C_ICR_ADDRCF = 0x8

	// PECR: PEC register
	// Position of PEC field.
	I2C_PECR_PEC_Pos = 0x0
	// Bit mask of PEC field.
	I2C_PECR_PEC_Msk = 0xff

	// RXDR: Receive data register
	// Position of RXDATA field.
	I2C_RXDR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff

	// TXDR: Transmit data register
	// Position of TXDATA field.
	I2C_TXDR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff
)

// Constants for IWDG: Independent watchdog
const (
	// KR: Key register
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff

	// PR: Prescaler register
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7
	// divider /4
	IWDG_PR_PR_B_0x0 = 0x0
	// divider /8
	IWDG_PR_PR_B_0x1 = 0x1
	// divider /16
	IWDG_PR_PR_B_0x2 = 0x2
	// divider /32
	IWDG_PR_PR_B_0x3 = 0x3
	// divider /64
	IWDG_PR_PR_B_0x4 = 0x4
	// divider /128
	IWDG_PR_PR_B_0x5 = 0x5
	// divider /256
	IWDG_PR_PR_B_0x6 = 0x6
	// divider /256
	IWDG_PR_PR_B_0x7 = 0x7

	// RLR: Reload register
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
	// Position of WVU field.
	IWDG_SR_WVU_Pos = 0x2
	// Bit mask of WVU field.
	IWDG_SR_WVU_Msk = 0x4
	// Bit WVU.
	IWDG_SR_WVU = 0x4

	// WINR: Window register
	// Position of WIN field.
	IWDG_WINR_WIN_Pos = 0x0
	// Bit mask of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff
)

// Constants for LPTIM1: Low power timer
const (
	// ISR: Interrupt and Status Register
	// Position of CMPM field.
	LPTIM_ISR_CMPM_Pos = 0x0
	// Bit mask of CMPM field.
	LPTIM_ISR_CMPM_Msk = 0x1
	// Bit CMPM.
	LPTIM_ISR_CMPM = 0x1
	// Position of ARRM field.
	LPTIM_ISR_ARRM_Pos = 0x1
	// Bit mask of ARRM field.
	LPTIM_ISR_ARRM_Msk = 0x2
	// Bit ARRM.
	LPTIM_ISR_ARRM = 0x2
	// Position of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Pos = 0x2
	// Bit mask of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Msk = 0x4
	// Bit EXTTRIG.
	LPTIM_ISR_EXTTRIG = 0x4
	// Position of CMPOK field.
	LPTIM_ISR_CMPOK_Pos = 0x3
	// Bit mask of CMPOK field.
	LPTIM_ISR_CMPOK_Msk = 0x8
	// Bit CMPOK.
	LPTIM_ISR_CMPOK = 0x8
	// Position of ARROK field.
	LPTIM_ISR_ARROK_Pos = 0x4
	// Bit mask of ARROK field.
	LPTIM_ISR_ARROK_Msk = 0x10
	// Bit ARROK.
	LPTIM_ISR_ARROK = 0x10
	// Position of UP field.
	LPTIM_ISR_UP_Pos = 0x5
	// Bit mask of UP field.
	LPTIM_ISR_UP_Msk = 0x20
	// Bit UP.
	LPTIM_ISR_UP = 0x20
	// Position of DOWN field.
	LPTIM_ISR_DOWN_Pos = 0x6
	// Bit mask of DOWN field.
	LPTIM_ISR_DOWN_Msk = 0x40
	// Bit DOWN.
	LPTIM_ISR_DOWN = 0x40

	// ICR: Interrupt Clear Register
	// Position of CMPMCF field.
	LPTIM_ICR_CMPMCF_Pos = 0x0
	// Bit mask of CMPMCF field.
	LPTIM_ICR_CMPMCF_Msk = 0x1
	// Bit CMPMCF.
	LPTIM_ICR_CMPMCF = 0x1
	// Position of ARRMCF field.
	LPTIM_ICR_ARRMCF_Pos = 0x1
	// Bit mask of ARRMCF field.
	LPTIM_ICR_ARRMCF_Msk = 0x2
	// Bit ARRMCF.
	LPTIM_ICR_ARRMCF = 0x2
	// Position of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Pos = 0x2
	// Bit mask of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Msk = 0x4
	// Bit EXTTRIGCF.
	LPTIM_ICR_EXTTRIGCF = 0x4
	// Position of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Pos = 0x3
	// Bit mask of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Msk = 0x8
	// Bit CMPOKCF.
	LPTIM_ICR_CMPOKCF = 0x8
	// Position of ARROKCF field.
	LPTIM_ICR_ARROKCF_Pos = 0x4
	// Bit mask of ARROKCF field.
	LPTIM_ICR_ARROKCF_Msk = 0x10
	// Bit ARROKCF.
	LPTIM_ICR_ARROKCF = 0x10
	// Position of UPCF field.
	LPTIM_ICR_UPCF_Pos = 0x5
	// Bit mask of UPCF field.
	LPTIM_ICR_UPCF_Msk = 0x20
	// Bit UPCF.
	LPTIM_ICR_UPCF = 0x20
	// Position of DOWNCF field.
	LPTIM_ICR_DOWNCF_Pos = 0x6
	// Bit mask of DOWNCF field.
	LPTIM_ICR_DOWNCF_Msk = 0x40
	// Bit DOWNCF.
	LPTIM_ICR_DOWNCF = 0x40

	// IER: Interrupt Enable Register
	// Position of CMPMIE field.
	LPTIM_IER_CMPMIE_Pos = 0x0
	// Bit mask of CMPMIE field.
	LPTIM_IER_CMPMIE_Msk = 0x1
	// Bit CMPMIE.
	LPTIM_IER_CMPMIE = 0x1
	// CMPM interrupt disabled
	LPTIM_IER_CMPMIE_B_0x0 = 0x0
	// CMPM interrupt enabled
	LPTIM_IER_CMPMIE_B_0x1 = 0x1
	// Position of ARRMIE field.
	LPTIM_IER_ARRMIE_Pos = 0x1
	// Bit mask of ARRMIE field.
	LPTIM_IER_ARRMIE_Msk = 0x2
	// Bit ARRMIE.
	LPTIM_IER_ARRMIE = 0x2
	// ARRM interrupt disabled
	LPTIM_IER_ARRMIE_B_0x0 = 0x0
	// ARRM interrupt enabled
	LPTIM_IER_ARRMIE_B_0x1 = 0x1
	// Position of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Pos = 0x2
	// Bit mask of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Msk = 0x4
	// Bit EXTTRIGIE.
	LPTIM_IER_EXTTRIGIE = 0x4
	// EXTTRIG interrupt disabled
	LPTIM_IER_EXTTRIGIE_B_0x0 = 0x0
	// EXTTRIG interrupt enabled
	LPTIM_IER_EXTTRIGIE_B_0x1 = 0x1
	// Position of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Pos = 0x3
	// Bit mask of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Msk = 0x8
	// Bit CMPOKIE.
	LPTIM_IER_CMPOKIE = 0x8
	// CMPOK interrupt disabled
	LPTIM_IER_CMPOKIE_B_0x0 = 0x0
	// CMPOK interrupt enabled
	LPTIM_IER_CMPOKIE_B_0x1 = 0x1
	// Position of ARROKIE field.
	LPTIM_IER_ARROKIE_Pos = 0x4
	// Bit mask of ARROKIE field.
	LPTIM_IER_ARROKIE_Msk = 0x10
	// Bit ARROKIE.
	LPTIM_IER_ARROKIE = 0x10
	// ARROK interrupt disabled
	LPTIM_IER_ARROKIE_B_0x0 = 0x0
	// ARROK interrupt enabled
	LPTIM_IER_ARROKIE_B_0x1 = 0x1
	// Position of UPIE field.
	LPTIM_IER_UPIE_Pos = 0x5
	// Bit mask of UPIE field.
	LPTIM_IER_UPIE_Msk = 0x20
	// Bit UPIE.
	LPTIM_IER_UPIE = 0x20
	// UP interrupt disabled
	LPTIM_IER_UPIE_B_0x0 = 0x0
	// UP interrupt enabled
	LPTIM_IER_UPIE_B_0x1 = 0x1
	// Position of DOWNIE field.
	LPTIM_IER_DOWNIE_Pos = 0x6
	// Bit mask of DOWNIE field.
	LPTIM_IER_DOWNIE_Msk = 0x40
	// Bit DOWNIE.
	LPTIM_IER_DOWNIE = 0x40
	// DOWN interrupt disabled
	LPTIM_IER_DOWNIE_B_0x0 = 0x0
	// DOWN interrupt enabled
	LPTIM_IER_DOWNIE_B_0x1 = 0x1

	// CFGR: Configuration Register
	// Position of CKSEL field.
	LPTIM_CFGR_CKSEL_Pos = 0x0
	// Bit mask of CKSEL field.
	LPTIM_CFGR_CKSEL_Msk = 0x1
	// Bit CKSEL.
	LPTIM_CFGR_CKSEL = 0x1
	// LPTIM is clocked by internal clock source (APB clock or any of the embedded oscillators)
	LPTIM_CFGR_CKSEL_B_0x0 = 0x0
	// LPTIM is clocked by an external clock source through the LPTIM external Input1
	LPTIM_CFGR_CKSEL_B_0x1 = 0x1
	// Position of CKPOL field.
	LPTIM_CFGR_CKPOL_Pos = 0x1
	// Bit mask of CKPOL field.
	LPTIM_CFGR_CKPOL_Msk = 0x6
	// the rising edge is the active edge used for counting.
	LPTIM_CFGR_CKPOL_B_0x0 = 0x0
	// the falling edge is the active edge used for counting
	LPTIM_CFGR_CKPOL_B_0x1 = 0x1
	// both edges are active edges. When both external clock signal edges are considered active ones, the LPTIM must also be clocked by an internal clock source with a frequency equal to at least four times the external clock frequency.If the LPTIM is configured in Encoder mode (ENC bit is set), the encoder sub-mode 3 is active.
	LPTIM_CFGR_CKPOL_B_0x2 = 0x2
	// not allowed
	LPTIM_CFGR_CKPOL_B_0x3 = 0x3
	// Position of CKFLT field.
	LPTIM_CFGR_CKFLT_Pos = 0x3
	// Bit mask of CKFLT field.
	LPTIM_CFGR_CKFLT_Msk = 0x18
	// any external clock signal level change is considered as a valid transition
	LPTIM_CFGR_CKFLT_B_0x0 = 0x0
	// external clock signal level change must be stable for at least 2 clock periods before it is considered as valid transition.
	LPTIM_CFGR_CKFLT_B_0x1 = 0x1
	// external clock signal level change must be stable for at least 4 clock periods before it is considered as valid transition.
	LPTIM_CFGR_CKFLT_B_0x2 = 0x2
	// external clock signal level change must be stable for at least 8 clock periods before it is considered as valid transition.
	LPTIM_CFGR_CKFLT_B_0x3 = 0x3
	// Position of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Pos = 0x6
	// Bit mask of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Msk = 0xc0
	// any trigger active level change is considered as a valid trigger
	LPTIM_CFGR_TRGFLT_B_0x0 = 0x0
	// trigger active level change must be stable for at least 2 clock periods before it is considered as valid trigger.
	LPTIM_CFGR_TRGFLT_B_0x1 = 0x1
	// trigger active level change must be stable for at least 4 clock periods before it is considered as valid trigger.
	LPTIM_CFGR_TRGFLT_B_0x2 = 0x2
	// trigger active level change must be stable for at least 8 clock periods before it is considered as valid trigger.
	LPTIM_CFGR_TRGFLT_B_0x3 = 0x3
	// Position of PRESC field.
	LPTIM_CFGR_PRESC_Pos = 0x9
	// Bit mask of PRESC field.
	LPTIM_CFGR_PRESC_Msk = 0xe00
	// /1
	LPTIM_CFGR_PRESC_B_0x0 = 0x0
	// /2
	LPTIM_CFGR_PRESC_B_0x1 = 0x1
	// /4
	LPTIM_CFGR_PRESC_B_0x2 = 0x2
	// /8
	LPTIM_CFGR_PRESC_B_0x3 = 0x3
	// /16
	LPTIM_CFGR_PRESC_B_0x4 = 0x4
	// /32
	LPTIM_CFGR_PRESC_B_0x5 = 0x5
	// /64
	LPTIM_CFGR_PRESC_B_0x6 = 0x6
	// /128
	LPTIM_CFGR_PRESC_B_0x7 = 0x7
	// Position of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Pos = 0xd
	// Bit mask of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Msk = 0xe000
	// lptim_ext_trig0
	LPTIM_CFGR_TRIGSEL_B_0x0 = 0x0
	// lptim_ext_trig1
	LPTIM_CFGR_TRIGSEL_B_0x1 = 0x1
	// lptim_ext_trig2
	LPTIM_CFGR_TRIGSEL_B_0x2 = 0x2
	// lptim_ext_trig3
	LPTIM_CFGR_TRIGSEL_B_0x3 = 0x3
	// lptim_ext_trig4
	LPTIM_CFGR_TRIGSEL_B_0x4 = 0x4
	// lptim_ext_trig5
	LPTIM_CFGR_TRIGSEL_B_0x5 = 0x5
	// lptim_ext_trig6
	LPTIM_CFGR_TRIGSEL_B_0x6 = 0x6
	// lptim_ext_trig7
	LPTIM_CFGR_TRIGSEL_B_0x7 = 0x7
	// Position of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Pos = 0x11
	// Bit mask of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Msk = 0x60000
	// software trigger (counting start is initiated by software)
	LPTIM_CFGR_TRIGEN_B_0x0 = 0x0
	// rising edge is the active edge
	LPTIM_CFGR_TRIGEN_B_0x1 = 0x1
	// falling edge is the active edge
	LPTIM_CFGR_TRIGEN_B_0x2 = 0x2
	// both edges are active edges
	LPTIM_CFGR_TRIGEN_B_0x3 = 0x3
	// Position of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Pos = 0x13
	// Bit mask of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Msk = 0x80000
	// Bit TIMOUT.
	LPTIM_CFGR_TIMOUT = 0x80000
	// A trigger event arriving when the timer is already started will be ignored
	LPTIM_CFGR_TIMOUT_B_0x0 = 0x0
	// A trigger event arriving when the timer is already started will reset and restart the counter
	LPTIM_CFGR_TIMOUT_B_0x1 = 0x1
	// Position of WAVE field.
	LPTIM_CFGR_WAVE_Pos = 0x14
	// Bit mask of WAVE field.
	LPTIM_CFGR_WAVE_Msk = 0x100000
	// Bit WAVE.
	LPTIM_CFGR_WAVE = 0x100000
	// Deactivate Set-once mode, PWM or One Pulse waveform depending on how the timer was started, CNTSTRT for PWM or SNGSTRT for One Pulse waveform.
	LPTIM_CFGR_WAVE_B_0x0 = 0x0
	// Activate the Set-once mode
	LPTIM_CFGR_WAVE_B_0x1 = 0x1
	// Position of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Pos = 0x15
	// Bit mask of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Msk = 0x200000
	// Bit WAVPOL.
	LPTIM_CFGR_WAVPOL = 0x200000
	// The LPTIM output reflects the compare results between LPTIM_CNT and LPTIM_CMP registers
	LPTIM_CFGR_WAVPOL_B_0x0 = 0x0
	// The LPTIM output reflects the inverse of the compare results between LPTIM_CNT and LPTIM_CMP registers
	LPTIM_CFGR_WAVPOL_B_0x1 = 0x1
	// Position of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Pos = 0x16
	// Bit mask of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Msk = 0x400000
	// Bit PRELOAD.
	LPTIM_CFGR_PRELOAD = 0x400000
	// Registers are updated after each APB bus write access
	LPTIM_CFGR_PRELOAD_B_0x0 = 0x0
	// Registers are updated at the end of the current LPTIM period
	LPTIM_CFGR_PRELOAD_B_0x1 = 0x1
	// Position of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Pos = 0x17
	// Bit mask of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Msk = 0x800000
	// Bit COUNTMODE.
	LPTIM_CFGR_COUNTMODE = 0x800000
	// the counter is incremented following each internal clock pulse
	LPTIM_CFGR_COUNTMODE_B_0x0 = 0x0
	// the counter is incremented following each valid clock pulse on the LPTIM external Input1
	LPTIM_CFGR_COUNTMODE_B_0x1 = 0x1
	// Position of ENC field.
	LPTIM_CFGR_ENC_Pos = 0x18
	// Bit mask of ENC field.
	LPTIM_CFGR_ENC_Msk = 0x1000000
	// Bit ENC.
	LPTIM_CFGR_ENC = 0x1000000
	// Encoder mode disabled
	LPTIM_CFGR_ENC_B_0x0 = 0x0
	// Encoder mode enabled
	LPTIM_CFGR_ENC_B_0x1 = 0x1

	// CR: Control Register
	// Position of ENABLE field.
	LPTIM_CR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	LPTIM_CR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	LPTIM_CR_ENABLE = 0x1
	// LPTIM is disabled
	LPTIM_CR_ENABLE_B_0x0 = 0x0
	// LPTIM is enabled
	LPTIM_CR_ENABLE_B_0x1 = 0x1
	// Position of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Pos = 0x1
	// Bit mask of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Msk = 0x2
	// Bit SNGSTRT.
	LPTIM_CR_SNGSTRT = 0x2
	// Position of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Pos = 0x2
	// Bit mask of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Msk = 0x4
	// Bit CNTSTRT.
	LPTIM_CR_CNTSTRT = 0x4
	// Position of COUNTRST field.
	LPTIM_CR_COUNTRST_Pos = 0x3
	// Bit mask of COUNTRST field.
	LPTIM_CR_COUNTRST_Msk = 0x8
	// Bit COUNTRST.
	LPTIM_CR_COUNTRST = 0x8
	// Position of RSTARE field.
	LPTIM_CR_RSTARE_Pos = 0x4
	// Bit mask of RSTARE field.
	LPTIM_CR_RSTARE_Msk = 0x10
	// Bit RSTARE.
	LPTIM_CR_RSTARE = 0x10

	// CMP: Compare Register
	// Position of CMP field.
	LPTIM_CMP_CMP_Pos = 0x0
	// Bit mask of CMP field.
	LPTIM_CMP_CMP_Msk = 0xffff

	// ARR: Autoreload Register
	// Position of ARR field.
	LPTIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	LPTIM_ARR_ARR_Msk = 0xffff

	// CNT: Counter Register
	// Position of CNT field.
	LPTIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	LPTIM_CNT_CNT_Msk = 0xffff

	// CFGR2: LPTIM configuration register 2
	// Position of IN1SEL field.
	LPTIM_CFGR2_IN1SEL_Pos = 0x0
	// Bit mask of IN1SEL field.
	LPTIM_CFGR2_IN1SEL_Msk = 0x3
	// lptim_in1_mux0
	LPTIM_CFGR2_IN1SEL_B_0x0 = 0x0
	// lptim_in1_mux1
	LPTIM_CFGR2_IN1SEL_B_0x1 = 0x1
	// lptim_in1_mux2
	LPTIM_CFGR2_IN1SEL_B_0x2 = 0x2
	// lptim_in1_mux3
	LPTIM_CFGR2_IN1SEL_B_0x3 = 0x3
	// Position of IN2SEL field.
	LPTIM_CFGR2_IN2SEL_Pos = 0x4
	// Bit mask of IN2SEL field.
	LPTIM_CFGR2_IN2SEL_Msk = 0x30
	// lptim_in2_mux0
	LPTIM_CFGR2_IN2SEL_B_0x0 = 0x0
	// lptim_in2_mux1
	LPTIM_CFGR2_IN2SEL_B_0x1 = 0x1
	// lptim_in2_mux2
	LPTIM_CFGR2_IN2SEL_B_0x2 = 0x2
	// lptim_in2_mux3
	LPTIM_CFGR2_IN2SEL_B_0x3 = 0x3
)

// Constants for LPUART1: Low-power universal asynchronous receiver transmitter
const (
	// CR1_enabled: LPUART control register 1 [alternate]
	// Position of UE field.
	LPUART_CR1_enabled_UE_Pos = 0x0
	// Bit mask of UE field.
	LPUART_CR1_enabled_UE_Msk = 0x1
	// Bit UE.
	LPUART_CR1_enabled_UE = 0x1
	// LPUART prescaler and outputs disabled, low-power mode
	LPUART_CR1_enabled_UE_B_0x0 = 0x0
	// LPUART enabled
	LPUART_CR1_enabled_UE_B_0x1 = 0x1
	// Position of UESM field.
	LPUART_CR1_enabled_UESM_Pos = 0x1
	// Bit mask of UESM field.
	LPUART_CR1_enabled_UESM_Msk = 0x2
	// Bit UESM.
	LPUART_CR1_enabled_UESM = 0x2
	// LPUART not able to wake up the MCU from low-power mode.
	LPUART_CR1_enabled_UESM_B_0x0 = 0x0
	// LPUART able to wake up the MCU from low-power mode. When this function is active, the clock source for the LPUART must be HSI or LSE (see RCC chapter)
	LPUART_CR1_enabled_UESM_B_0x1 = 0x1
	// Position of RE field.
	LPUART_CR1_enabled_RE_Pos = 0x2
	// Bit mask of RE field.
	LPUART_CR1_enabled_RE_Msk = 0x4
	// Bit RE.
	LPUART_CR1_enabled_RE = 0x4
	// Receiver is disabled
	LPUART_CR1_enabled_RE_B_0x0 = 0x0
	// Receiver is enabled and begins searching for a start bit
	LPUART_CR1_enabled_RE_B_0x1 = 0x1
	// Position of TE field.
	LPUART_CR1_enabled_TE_Pos = 0x3
	// Bit mask of TE field.
	LPUART_CR1_enabled_TE_Msk = 0x8
	// Bit TE.
	LPUART_CR1_enabled_TE = 0x8
	// Transmitter is disabled
	LPUART_CR1_enabled_TE_B_0x0 = 0x0
	// Transmitter is enabled
	LPUART_CR1_enabled_TE_B_0x1 = 0x1
	// Position of IDLEIE field.
	LPUART_CR1_enabled_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	LPUART_CR1_enabled_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	LPUART_CR1_enabled_IDLEIE = 0x10
	// Interrupt is inhibited
	LPUART_CR1_enabled_IDLEIE_B_0x0 = 0x0
	// An LPUART interrupt is generated whenever IDLE = 1 in the LPUART_ISR register
	LPUART_CR1_enabled_IDLEIE_B_0x1 = 0x1
	// Position of RXFNEIE field.
	LPUART_CR1_enabled_RXFNEIE_Pos = 0x5
	// Bit mask of RXFNEIE field.
	LPUART_CR1_enabled_RXFNEIE_Msk = 0x20
	// Bit RXFNEIE.
	LPUART_CR1_enabled_RXFNEIE = 0x20
	// Interrupt is inhibited
	LPUART_CR1_enabled_RXFNEIE_B_0x0 = 0x0
	// A LPUART interrupt is generated whenever ORE = 1 or RXNE/RXFNE = 1 in the LPUART_ISR register
	LPUART_CR1_enabled_RXFNEIE_B_0x1 = 0x1
	// Position of TCIE field.
	LPUART_CR1_enabled_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	LPUART_CR1_enabled_TCIE_Msk = 0x40
	// Bit TCIE.
	LPUART_CR1_enabled_TCIE = 0x40
	// Interrupt is inhibited
	LPUART_CR1_enabled_TCIE_B_0x0 = 0x0
	// An LPUART interrupt is generated whenever TC = 1 in the LPUART_ISR register
	LPUART_CR1_enabled_TCIE_B_0x1 = 0x1
	// Position of TXFNFIE field.
	LPUART_CR1_enabled_TXFNFIE_Pos = 0x7
	// Bit mask of TXFNFIE field.
	LPUART_CR1_enabled_TXFNFIE_Msk = 0x80
	// Bit TXFNFIE.
	LPUART_CR1_enabled_TXFNFIE = 0x80
	// Interrupt is inhibited
	LPUART_CR1_enabled_TXFNFIE_B_0x0 = 0x0
	// A LPUART interrupt is generated whenever TXE/TXFNF =1 in the LPUART_ISR register
	LPUART_CR1_enabled_TXFNFIE_B_0x1 = 0x1
	// Position of PEIE field.
	LPUART_CR1_enabled_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	LPUART_CR1_enabled_PEIE_Msk = 0x100
	// Bit PEIE.
	LPUART_CR1_enabled_PEIE = 0x100
	// Interrupt is inhibited
	LPUART_CR1_enabled_PEIE_B_0x0 = 0x0
	// An LPUART interrupt is generated whenever PE = 1 in the LPUART_ISR register
	LPUART_CR1_enabled_PEIE_B_0x1 = 0x1
	// Position of PS field.
	LPUART_CR1_enabled_PS_Pos = 0x9
	// Bit mask of PS field.
	LPUART_CR1_enabled_PS_Msk = 0x200
	// Bit PS.
	LPUART_CR1_enabled_PS = 0x200
	// Even parity
	LPUART_CR1_enabled_PS_B_0x0 = 0x0
	// Odd parity
	LPUART_CR1_enabled_PS_B_0x1 = 0x1
	// Position of PCE field.
	LPUART_CR1_enabled_PCE_Pos = 0xa
	// Bit mask of PCE field.
	LPUART_CR1_enabled_PCE_Msk = 0x400
	// Bit PCE.
	LPUART_CR1_enabled_PCE = 0x400
	// Parity control disabled
	LPUART_CR1_enabled_PCE_B_0x0 = 0x0
	// Parity control enabled
	LPUART_CR1_enabled_PCE_B_0x1 = 0x1
	// Position of WAKE field.
	LPUART_CR1_enabled_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	LPUART_CR1_enabled_WAKE_Msk = 0x800
	// Bit WAKE.
	LPUART_CR1_enabled_WAKE = 0x800
	// Idle line
	LPUART_CR1_enabled_WAKE_B_0x0 = 0x0
	// Address mark
	LPUART_CR1_enabled_WAKE_B_0x1 = 0x1
	// Position of M0 field.
	LPUART_CR1_enabled_M0_Pos = 0xc
	// Bit mask of M0 field.
	LPUART_CR1_enabled_M0_Msk = 0x1000
	// Bit M0.
	LPUART_CR1_enabled_M0 = 0x1000
	// Position of MME field.
	LPUART_CR1_enabled_MME_Pos = 0xd
	// Bit mask of MME field.
	LPUART_CR1_enabled_MME_Msk = 0x2000
	// Bit MME.
	LPUART_CR1_enabled_MME = 0x2000
	// Receiver in active mode permanently
	LPUART_CR1_enabled_MME_B_0x0 = 0x0
	// Receiver can switch between Mute mode and active mode.
	LPUART_CR1_enabled_MME_B_0x1 = 0x1
	// Position of CMIE field.
	LPUART_CR1_enabled_CMIE_Pos = 0xe
	// Bit mask of CMIE field.
	LPUART_CR1_enabled_CMIE_Msk = 0x4000
	// Bit CMIE.
	LPUART_CR1_enabled_CMIE = 0x4000
	// Interrupt is inhibited
	LPUART_CR1_enabled_CMIE_B_0x0 = 0x0
	// A LPUART interrupt is generated when the CMF bit is set in the LPUART_ISR register.
	LPUART_CR1_enabled_CMIE_B_0x1 = 0x1
	// Position of DEDT field.
	LPUART_CR1_enabled_DEDT_Pos = 0x10
	// Bit mask of DEDT field.
	LPUART_CR1_enabled_DEDT_Msk = 0x1f0000
	// Position of DEAT field.
	LPUART_CR1_enabled_DEAT_Pos = 0x15
	// Bit mask of DEAT field.
	LPUART_CR1_enabled_DEAT_Msk = 0x3e00000
	// Position of M1 field.
	LPUART_CR1_enabled_M1_Pos = 0x1c
	// Bit mask of M1 field.
	LPUART_CR1_enabled_M1_Msk = 0x10000000
	// Bit M1.
	LPUART_CR1_enabled_M1 = 0x10000000
	// Position of FIFOEN field.
	LPUART_CR1_enabled_FIFOEN_Pos = 0x1d
	// Bit mask of FIFOEN field.
	LPUART_CR1_enabled_FIFOEN_Msk = 0x20000000
	// Bit FIFOEN.
	LPUART_CR1_enabled_FIFOEN = 0x20000000
	// FIFO mode is disabled.
	LPUART_CR1_enabled_FIFOEN_B_0x0 = 0x0
	// FIFO mode is enabled.
	LPUART_CR1_enabled_FIFOEN_B_0x1 = 0x1
	// Position of TXFEIE field.
	LPUART_CR1_enabled_TXFEIE_Pos = 0x1e
	// Bit mask of TXFEIE field.
	LPUART_CR1_enabled_TXFEIE_Msk = 0x40000000
	// Bit TXFEIE.
	LPUART_CR1_enabled_TXFEIE = 0x40000000
	// Interrupt is inhibited
	LPUART_CR1_enabled_TXFEIE_B_0x0 = 0x0
	// An LPUART interrupt is generated when TXFE = 1 in the LPUART_ISR register
	LPUART_CR1_enabled_TXFEIE_B_0x1 = 0x1
	// Position of RXFFIE field.
	LPUART_CR1_enabled_RXFFIE_Pos = 0x1f
	// Bit mask of RXFFIE field.
	LPUART_CR1_enabled_RXFFIE_Msk = 0x80000000
	// Bit RXFFIE.
	LPUART_CR1_enabled_RXFFIE = 0x80000000
	// Interrupt is inhibited
	LPUART_CR1_enabled_RXFFIE_B_0x0 = 0x0
	// An LPUART interrupt is generated when RXFF = 1 in the LPUART_ISR register
	LPUART_CR1_enabled_RXFFIE_B_0x1 = 0x1

	// CR1_disabled: LPUART control register 1 [alternate]
	// Position of UE field.
	LPUART_CR1_disabled_UE_Pos = 0x0
	// Bit mask of UE field.
	LPUART_CR1_disabled_UE_Msk = 0x1
	// Bit UE.
	LPUART_CR1_disabled_UE = 0x1
	// LPUART prescaler and outputs disabled, low-power mode
	LPUART_CR1_disabled_UE_B_0x0 = 0x0
	// LPUART enabled
	LPUART_CR1_disabled_UE_B_0x1 = 0x1
	// Position of UESM field.
	LPUART_CR1_disabled_UESM_Pos = 0x1
	// Bit mask of UESM field.
	LPUART_CR1_disabled_UESM_Msk = 0x2
	// Bit UESM.
	LPUART_CR1_disabled_UESM = 0x2
	// LPUART not able to wake up the MCU from low-power mode.
	LPUART_CR1_disabled_UESM_B_0x0 = 0x0
	// LPUART able to wake up the MCU from low-power mode. When this function is active, the clock source for the LPUART must be HSI or LSE (see RCC chapter)
	LPUART_CR1_disabled_UESM_B_0x1 = 0x1
	// Position of RE field.
	LPUART_CR1_disabled_RE_Pos = 0x2
	// Bit mask of RE field.
	LPUART_CR1_disabled_RE_Msk = 0x4
	// Bit RE.
	LPUART_CR1_disabled_RE = 0x4
	// Receiver is disabled
	LPUART_CR1_disabled_RE_B_0x0 = 0x0
	// Receiver is enabled and begins searching for a start bit
	LPUART_CR1_disabled_RE_B_0x1 = 0x1
	// Position of TE field.
	LPUART_CR1_disabled_TE_Pos = 0x3
	// Bit mask of TE field.
	LPUART_CR1_disabled_TE_Msk = 0x8
	// Bit TE.
	LPUART_CR1_disabled_TE = 0x8
	// Transmitter is disabled
	LPUART_CR1_disabled_TE_B_0x0 = 0x0
	// Transmitter is enabled
	LPUART_CR1_disabled_TE_B_0x1 = 0x1
	// Position of IDLEIE field.
	LPUART_CR1_disabled_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	LPUART_CR1_disabled_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	LPUART_CR1_disabled_IDLEIE = 0x10
	// Interrupt is inhibited
	LPUART_CR1_disabled_IDLEIE_B_0x0 = 0x0
	// An LPUART interrupt is generated whenever IDLE = 1 in the LPUART_ISR register
	LPUART_CR1_disabled_IDLEIE_B_0x1 = 0x1
	// Position of RXFNEIE field.
	LPUART_CR1_disabled_RXFNEIE_Pos = 0x5
	// Bit mask of RXFNEIE field.
	LPUART_CR1_disabled_RXFNEIE_Msk = 0x20
	// Bit RXFNEIE.
	LPUART_CR1_disabled_RXFNEIE = 0x20
	// Interrupt is inhibited
	LPUART_CR1_disabled_RXFNEIE_B_0x0 = 0x0
	// A LPUART interrupt is generated whenever ORE = 1 or RXNE/RXFNE = 1 in the LPUART_ISR register
	LPUART_CR1_disabled_RXFNEIE_B_0x1 = 0x1
	// Position of TCIE field.
	LPUART_CR1_disabled_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	LPUART_CR1_disabled_TCIE_Msk = 0x40
	// Bit TCIE.
	LPUART_CR1_disabled_TCIE = 0x40
	// Interrupt is inhibited
	LPUART_CR1_disabled_TCIE_B_0x0 = 0x0
	// An LPUART interrupt is generated whenever TC = 1 in the LPUART_ISR register
	LPUART_CR1_disabled_TCIE_B_0x1 = 0x1
	// Position of TXFNFIE field.
	LPUART_CR1_disabled_TXFNFIE_Pos = 0x7
	// Bit mask of TXFNFIE field.
	LPUART_CR1_disabled_TXFNFIE_Msk = 0x80
	// Bit TXFNFIE.
	LPUART_CR1_disabled_TXFNFIE = 0x80
	// Interrupt is inhibited
	LPUART_CR1_disabled_TXFNFIE_B_0x0 = 0x0
	// A LPUART interrupt is generated whenever TXE/TXFNF =1 in the LPUART_ISR register
	LPUART_CR1_disabled_TXFNFIE_B_0x1 = 0x1
	// Position of PEIE field.
	LPUART_CR1_disabled_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	LPUART_CR1_disabled_PEIE_Msk = 0x100
	// Bit PEIE.
	LPUART_CR1_disabled_PEIE = 0x100
	// Interrupt is inhibited
	LPUART_CR1_disabled_PEIE_B_0x0 = 0x0
	// An LPUART interrupt is generated whenever PE = 1 in the LPUART_ISR register
	LPUART_CR1_disabled_PEIE_B_0x1 = 0x1
	// Position of PS field.
	LPUART_CR1_disabled_PS_Pos = 0x9
	// Bit mask of PS field.
	LPUART_CR1_disabled_PS_Msk = 0x200
	// Bit PS.
	LPUART_CR1_disabled_PS = 0x200
	// Even parity
	LPUART_CR1_disabled_PS_B_0x0 = 0x0
	// Odd parity
	LPUART_CR1_disabled_PS_B_0x1 = 0x1
	// Position of PCE field.
	LPUART_CR1_disabled_PCE_Pos = 0xa
	// Bit mask of PCE field.
	LPUART_CR1_disabled_PCE_Msk = 0x400
	// Bit PCE.
	LPUART_CR1_disabled_PCE = 0x400
	// Parity control disabled
	LPUART_CR1_disabled_PCE_B_0x0 = 0x0
	// Parity control enabled
	LPUART_CR1_disabled_PCE_B_0x1 = 0x1
	// Position of WAKE field.
	LPUART_CR1_disabled_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	LPUART_CR1_disabled_WAKE_Msk = 0x800
	// Bit WAKE.
	LPUART_CR1_disabled_WAKE = 0x800
	// Idle line
	LPUART_CR1_disabled_WAKE_B_0x0 = 0x0
	// Address mark
	LPUART_CR1_disabled_WAKE_B_0x1 = 0x1
	// Position of M0 field.
	LPUART_CR1_disabled_M0_Pos = 0xc
	// Bit mask of M0 field.
	LPUART_CR1_disabled_M0_Msk = 0x1000
	// Bit M0.
	LPUART_CR1_disabled_M0 = 0x1000
	// Position of MME field.
	LPUART_CR1_disabled_MME_Pos = 0xd
	// Bit mask of MME field.
	LPUART_CR1_disabled_MME_Msk = 0x2000
	// Bit MME.
	LPUART_CR1_disabled_MME = 0x2000
	// Receiver in active mode permanently
	LPUART_CR1_disabled_MME_B_0x0 = 0x0
	// Receiver can switch between Mute mode and active mode.
	LPUART_CR1_disabled_MME_B_0x1 = 0x1
	// Position of CMIE field.
	LPUART_CR1_disabled_CMIE_Pos = 0xe
	// Bit mask of CMIE field.
	LPUART_CR1_disabled_CMIE_Msk = 0x4000
	// Bit CMIE.
	LPUART_CR1_disabled_CMIE = 0x4000
	// Interrupt is inhibited
	LPUART_CR1_disabled_CMIE_B_0x0 = 0x0
	// A LPUART interrupt is generated when the CMF bit is set in the LPUART_ISR register.
	LPUART_CR1_disabled_CMIE_B_0x1 = 0x1
	// Position of DEDT field.
	LPUART_CR1_disabled_DEDT_Pos = 0x10
	// Bit mask of DEDT field.
	LPUART_CR1_disabled_DEDT_Msk = 0x1f0000
	// Position of DEAT field.
	LPUART_CR1_disabled_DEAT_Pos = 0x15
	// Bit mask of DEAT field.
	LPUART_CR1_disabled_DEAT_Msk = 0x3e00000
	// Position of M1 field.
	LPUART_CR1_disabled_M1_Pos = 0x1c
	// Bit mask of M1 field.
	LPUART_CR1_disabled_M1_Msk = 0x10000000
	// Bit M1.
	LPUART_CR1_disabled_M1 = 0x10000000
	// Position of FIFOEN field.
	LPUART_CR1_disabled_FIFOEN_Pos = 0x1d
	// Bit mask of FIFOEN field.
	LPUART_CR1_disabled_FIFOEN_Msk = 0x20000000
	// Bit FIFOEN.
	LPUART_CR1_disabled_FIFOEN = 0x20000000
	// FIFO mode is disabled.
	LPUART_CR1_disabled_FIFOEN_B_0x0 = 0x0
	// FIFO mode is enabled.
	LPUART_CR1_disabled_FIFOEN_B_0x1 = 0x1

	// CR2: LPUART control register 2
	// Position of ADDM7 field.
	LPUART_CR2_ADDM7_Pos = 0x4
	// Bit mask of ADDM7 field.
	LPUART_CR2_ADDM7_Msk = 0x10
	// Bit ADDM7.
	LPUART_CR2_ADDM7 = 0x10
	// 4-bit address detection
	LPUART_CR2_ADDM7_B_0x0 = 0x0
	// 7-bit address detection (in 8-bit data mode)
	LPUART_CR2_ADDM7_B_0x1 = 0x1
	// Position of STOP field.
	LPUART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	LPUART_CR2_STOP_Msk = 0x3000
	// 1 stop bit
	LPUART_CR2_STOP_B_0x0 = 0x0
	// 2 stop bits
	LPUART_CR2_STOP_B_0x2 = 0x2
	// Position of SWAP field.
	LPUART_CR2_SWAP_Pos = 0xf
	// Bit mask of SWAP field.
	LPUART_CR2_SWAP_Msk = 0x8000
	// Bit SWAP.
	LPUART_CR2_SWAP = 0x8000
	// TX/RX pins are used as defined in standard pinout
	LPUART_CR2_SWAP_B_0x0 = 0x0
	// The TX and RX pins functions are swapped. This enables to work in the case of a cross-wired connection to another UART.
	LPUART_CR2_SWAP_B_0x1 = 0x1
	// Position of RXINV field.
	LPUART_CR2_RXINV_Pos = 0x10
	// Bit mask of RXINV field.
	LPUART_CR2_RXINV_Msk = 0x10000
	// Bit RXINV.
	LPUART_CR2_RXINV = 0x10000
	// RX pin signal works using the standard logic levels (VDD = 1/idle, Gnd = 0/mark)
	LPUART_CR2_RXINV_B_0x0 = 0x0
	// RX pin signal values are inverted (VDD = 0/mark, Gnd = 1/idle).
	LPUART_CR2_RXINV_B_0x1 = 0x1
	// Position of TXINV field.
	LPUART_CR2_TXINV_Pos = 0x11
	// Bit mask of TXINV field.
	LPUART_CR2_TXINV_Msk = 0x20000
	// Bit TXINV.
	LPUART_CR2_TXINV = 0x20000
	// TX pin signal works using the standard logic levels (VDD = 1/idle, Gnd = 0/mark)
	LPUART_CR2_TXINV_B_0x0 = 0x0
	// TX pin signal values are inverted (VDD = 0/mark, Gnd = 1/idle).
	LPUART_CR2_TXINV_B_0x1 = 0x1
	// Position of DATAINV field.
	LPUART_CR2_DATAINV_Pos = 0x12
	// Bit mask of DATAINV field.
	LPUART_CR2_DATAINV_Msk = 0x40000
	// Bit DATAINV.
	LPUART_CR2_DATAINV = 0x40000
	// Logical data from the data register are send/received in positive/direct logic. (1 