"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
function register() {
    return (pugDoc) => {
        const result = [];
        const docEndPos = pugDoc.pugTextDocument.positionAt(pugDoc.pugTextDocument.getText().length);
        if (pugDoc.ast) {
            visitNode(pugDoc.ast, findMinimalEndLine(docEndPos.line));
        }
        return result;
        function visitNode(node, endLine) {
            if (node.type === 'Block') {
                for (let i = 0; i < node.nodes.length; i++) {
                    const child = node.nodes[i];
                    const next = i + 1 < node.nodes.length ? node.nodes[i + 1] : undefined;
                    visitNode(child, next ? findMinimalEndLine(next.line - 2) : endLine);
                }
            }
            else if (node.type === 'Tag' || node.type === 'BlockComment') {
                const nodeLine = node.line - 1; // one base to zero base
                if (nodeLine !== endLine) {
                    result.push({
                        startLine: nodeLine,
                        endLine,
                        kind: node.type === 'BlockComment' ? 'comment' : undefined,
                    });
                }
                visitNode(node.block, endLine);
            }
        }
        function findMinimalEndLine(endLine) {
            while (endLine > 0 && getLineText(endLine).trim() === '') {
                endLine--;
            }
            return endLine;
        }
        function getLineText(line) {
            if (line === docEndPos.line) {
                return pugDoc.pugTextDocument.getText({
                    start: { line: line, character: 0 },
                    end: docEndPos,
                });
            }
            const text = pugDoc.pugTextDocument.getText({
                start: { line: line, character: 0 },
                end: { line: line + 1, character: 0 },
            });
            return text.substring(0, text.length - 1);
        }
    };
}
exports.register = register;
//# sourceMappingURL=foldingRanges.js.map