# Copyright (C) 2003 Konstantin Korikov

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

importer_class = "KPPPImporter"
    
import ConfigParser
import re
import os.path
import importer
import chestnut_dialer.account_set
from chestnut_dialer import _

class Account(chestnut_dialer.account_set.Account):
  _acc_conf = None
  _section = None
  _id = None
  _kppp_attrs = {
    "connect_program": "Command",
    "default_route": "DefaultRoute",
    "disconnect_program": "DisconnectCommand",
    "ip": "IPAddr",
    "mask": "SubnetMask",
    "name": "Name",
    "passwd": "Password",
    "user": "Username",
    "dial_prefix": "DialPrefix"}
  def __init__(self, acc_conf, acc_id):
    chestnut_dialer.account_set.Account.__init__(self)
    self._acc_conf = acc_conf
    self._id = acc_id
    self._section = "Account%d" % acc_id
  def _get_acc_attr(self, name):
    acc_conf = self._acc_conf
    section = self._section
    if name == "id": return self._id
    if name == "auth_type":
      try: value = int(acc_conf.get(section, "Authentication"))
      except ConfigParser.NoOptionError: return u"pap/chap"
      return (u'term', u'pap/chap', u'term',
          u'pap/chap', u'pap/chap')[value]    
    if name == "use_script":
      return u'predef-auto'
    if name == "phone_numbers":
      try: 
        return filter(
	  lambda i: i != "", unicode(
            acc_conf.get(section, "Phonenumber"), "UTF-8").split(":"))
      except ConfigParser.NoOptionError: return []
    if name == "dns_servers":
      try: 
        return filter(
	  lambda i: i != "", unicode(
            acc_conf.get(section, "DNS"), "UTF-8").split(","))
      except ConfigParser.NoOptionError: return None
    if name in self._kppp_attrs.keys():
      try: value = unicode(
          acc_conf.get(section, self._kppp_attrs[name]), "UTF-8")
      except ConfigParser.NoOptionError: return None
      if value == "" and name == 'default_route': return None
      if value == "0.0.0.0" and name in ('ip', 'mask'): return u""
      if name in ('default_route',):
	try: return int(value)
	except ValueError: return 0
      return value
    return None

class KPPPImporter(chestnut_dialer.account_set.AccountSet):
  __doc__ = _("Import accounts from kppp")
  author = _("Konstantin Korikov")
  constructor_args = (
    { "name": "file_name",
      "type": "filename",
      "display": _("Source File"),
      "default":  os.path.expanduser("~/.kde/share/config/kppprc")},)
  program = "kppp"
  acc_conf = None
  def __init__(self, file_name):
    self.acc_conf = ConfigParser.ConfigParser()
    try: self.acc_conf.read(file_name)
    except: pass
    if not self.acc_conf.sections():
      raise importer.ConstructImporterException(
      _("The source file is empty or broken"))
  def ls_accounts(self):
    accounts = []
    regexp = re.compile(r'Account(\d+)')
    for section in self.acc_conf.sections():
      m = regexp.match(section)
      if m:
        try: name = unicode(self.acc_conf.get(section, "Name"), "UTF-8")
	except ConfigParser.NoOptionError: name = u""
        accounts.append((name, int(m.group(1))))
    return accounts
  def get_account(self, account_id):
    return Account(self.acc_conf, account_id)
