import socket
import select
import os
import glob
import time
import chestnut_dialer
import chestnut_dialer.config
import chestnut_dialer.dobj as dobj
from chestnut_dialer import _
from chestnut_dialer import debug_msg

def wait_session_server(child = None):
  filename = chestnut_dialer.session_wait_base + str(os.getpid())
  try:
    os.mkfifo(filename)
    f = open(filename, 'r')
  except OSError: return False
  result = False
  for i in range(0, 12):
    (r, w, x) = select.select([f], [], [f], 5)
    if r:
      result = True
      break
    if x: break
    if child != None:
      try: os.waitpid(child, os.WNOHANG)
      except OSError: break
    elif not filter(lambda x: x != filename,
        glob.glob(chestnut_dialer.session_wait_base + '*')): break
  f.close()
  os.remove(filename)
  return result

def is_session_server_running():
  if not os.access(chestnut_dialer.session_socket, os.F_OK):
    if glob.glob(chestnut_dialer.session_wait_base + '*'):
      return wait_session_server()
    else: return False
  try: pid = int(open(chestnut_dialer.session_pid_file, 'r').read())
  except: pass
  else:
    try: os.kill(pid, 0)
    except OSError: pass
    else: return True
  try: os.remove(chestnut_dialer.session_socket)
  except OSError:
    if os.access(chestnut_dialer.session_socket, os.F_OK):
      debug_msg(_("cannot remove session socket: %s") %
          chestnut_dialer.session_socket, 0)
    else: time.sleep(1)
  return False

def start_session_server(args = []):
  p = os.fork()
  if p < 0:
    debug_msg(_("fork() failed"), 0)
    return False
  if p == 0:
    os.setsid()
    try: path = os.environ['PYTHONPATH'] + ":"
    except KeyError: path = ""
    os.execve(chestnut_dialer.config.python,
        [chestnut_dialer.session_server,
        chestnut_dialer.session_server] + args,
        {'PYTHONPATH': path + os.path.dirname(os.path.dirname(__file__))})
    debug_msg(_("execve() failed"), 0)
    sys.exit(chestnut_dialer.EX_SOFTWARE)  
  return wait_session_server(p)

class Share:
  def __init__(self):
    if not is_session_server_running():
      if not start_session_server():
        debug_msg(_("unable to start session server"), 0)
        return None
    self._dobj_connection = dobj.DObjConnection(
        dobj.AF_UNIX, chestnut_dialer.session_socket)
    self._share = self._dobj_connection.get_object()
  def __getattr__(self, name):
    try: return getattr(self._share, name)
    except AttributeError:
      return getattr(self._dobj_connection, name)
