from chestnut_dialer import _
from chestnut_dialer import debug_msg
from chestnut_dialer import compare_versions
from chestnut_dialer.xml_account_set import XmlAccount
from chestnut_dialer.sig import Signal, SignalAdaptor

class XmlUIConfig:
  _attr_changed_signal = None
  _xml_node = None
  def __init__(self, xml_node, changed_callback):
    self._attr_changed_signal = Signal()
    self._xml_node = xml_node
    self._attr_changed_signal.append(SignalAdaptor(
      changed_callback, lambda n,v: ()))
  def __getattr__(self, name):    
    try:
      for n in self._xml_node.xpathEval(name.replace('_', '-')):
        return unicode(n.content, "UTF-8").strip()
    except TypeError: pass
    raise AttributeError(name)
  def __setattr__(self, name, value):
    if name[0:1] != '_':
      node = self._xml_node
      xname = name.replace('_', '-')
      xvalue = unicode(value).encode("UTF-8").replace("&", "&amp;")
      for n in node.xpathEval(xname):
        if n.content != xvalue:
          n.setContent(xvalue)
          self._attr_changed_signal(name, value)
	return
      node.newChild(None, xname, xvalue)
      self._attr_changed_signal(name, value)
      return
    self.__dict__[name] = value
  def __delattr__(self, name):
    for n in self._xml_node.xpathEval(name.replace('_', '-')):
      n.unlinkNode()
      n.freeNode()
      self._attr_changed_signal(name, None)
      return
    try: del self.__dict__[name]
    except KeyError: raise AttributeError(name)

class XmlConfig:
  changed_signal = None
  attr_changed_signal = None
  _xml_node = None
  _current_version = "0.3.0"
  def __init__(self, xml_node, changed_callbacks = ()):
    self._xml_node = xml_node
    self.changed_signal = Signal(changed_callbacks)
    self.attr_changed_signal = Signal()
    version = xml_node.prop("version")
    if not version: version = "0.0.1"
    if compare_versions(version, self._current_version) < 0:
      inter_version = version
      while compare_versions(inter_version, self._current_version) < 0:
	modname = "conv_conf_" + inter_version.replace(".", "_")
	try: m = __import__(modname, globals(), locals())
	except ImportError:
	  debug_msg(_("cannot convert configuration file of version %s") % 
	    inter_version, 1)
	  break
	m.convert_config(xml_node)
	inter_version = xml_node.prop("version")      
      self.changed_signal()
    elif compare_versions(version, self._current_version) > 0:
      debug_msg(_("incompatible configuration file version (%s > %s)") %
	(version, self._current_version), 1)
  def __getattr__(self, name):    
    node = self._xml_node
    xname = name.replace('_', '-')
    def get_str_val(default):
      for n in node.xpathEval(xname):
        return unicode(n.content, "UTF-8").strip()
      return default
    def get_float_val(default):
      for n in node.xpathEval(xname):
        try: return float(str(n.content).strip())
        except ValueError, e:
          debug_msg(str(e), 1)
          return default
      return default
    def get_int_val(default):
      for n in node.xpathEval(xname):
        try: return int(str(n.content).strip())
        except ValueError, e:
          debug_msg(str(e), 1)
          return default
      return default
    if name in (
      "dockicons_dir",
      "wnd_title_fmt_disconnected",
      "wnd_title_fmt_connecting",
      "wnd_title_fmt_connected"): return get_str_val(u"")
    if name in (
      "monitor_period", 
      "status_refresh_period"): return get_float_val(1.0)
    if name in (
      "confirm_exit", 
      "confirm_delete_account",
      "write_dns_to_resolv_conf"): return get_int_val(1)
    if name == "pppd_cbcp_with_auto_answer":
      return get_int_val(0)
    if name == "default_account":
      for n in node.xpathEval("default-account"):
        v = XmlAccount(n, self.changed_signal)
        return v
      return None
    if name[-3:] == "_ui":
      ui_conf = None
      for n in node.xpathEval(xname):
        ui_conf = XmlUIConfig(n, self.changed_signal)
        ui_conf._attr_changed_signal.append(
            SignalAdaptor(self.attr_changed_signal,
              lambda n,v: (name + "." + n, v)))
        break
      if ui_conf == None:
        ui_conf = XmlUIConfig(node.newChild(None, xname, ""),
            self.changed_signal)
        ui_conf._attr_changed_signal.append(
            SignalAdaptor(self.attr_changed_signal,
              lambda n,v: (name + "." + n, v)))
        self.changed_signal()
      return ui_conf
    raise AttributeError(name)
  def __setattr__(self, name, value):
    if name[:1] == "_":
      self.__dict__[name] = value
      return
    node = self._xml_node
    xname = name.replace('_', '-')
    def set_str_val():
      xvalue = value.encode("UTF-8").replace("&", "&amp;")
      xres = node.xpathEval(xname)
      if not len(xres):
	node.newChild(None, xname, xvalue)
        return 1
      else:
        if xres[0].content != xvalue:
          xres[0].setContent(xvalue)
          return 1
        return 0
    def set_float_val():
      xvalue = str(float(value))
      xres = node.xpathEval(xname)
      if not len(xres):
	node.newChild(None, xname, str(float(value)))
        return 1
      else:
        if xres[0].content != xvalue:
          xres[0].setContent(xvalue)
          return 1
        return 0
    def set_int_val():
      xvalue = str(int(value))
      xres = node.xpathEval(xname)
      if not len(xres):
	node.newChild(None, xname, str(int(value)))
        return 1
      else:
        if xres[0].content != xvalue:
          xres[0].setContent(xvalue)
          return 1
        return 0
    if name in (
      "dockicons_dir",
      "wnd_title_fmt_disconnected",
      "wnd_title_fmt_connecting",
      "wnd_title_fmt_connected"):
      if set_str_val():
        self.attr_changed_signal(name, value)
        self.changed_signal()
      return
    if name in (
      "monitor_period", 
      "status_refresh_period"): 
      if set_float_val():
        self.attr_changed_signal(name, value)
        self.changed_signal()
      return
    if name in (
      "confirm_exit",
      "confirm_delete_account",
      "write_dns_to_resolv_conf",
      "pppd_cbcp_with_auto_answer"):
      if set_int_val():
        self.attr_changed_signal(name, value)
        self.changed_signal()
      return
    if name == "default_account": raise AttributeError(name)    
    self.__dict__[name] = value
