/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.jdbc;

import java.awt.Color;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import org.graalvm.visualvm.lib.ui.UIUtils;

final class SQLFormatter {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.jdbc.Bundle");
    private static final String DATABASE_PING = messages.getString("SQLFormatter_DatabasePing");
    private static final String PING_TEXT = " - <b>" + DATABASE_PING + "</b>";
    private static String[] keywords = new String[]{"AS", "ALL", "AND", "ASC", "AVG", "BY", "COUNT", "CROSS", "DESC", "DISTINCT", "FROM", "FULL", "GROUP", "HAVING", "INNER", "LEFT", "JOIN", "MAX", "MIN", "NATURAL", "NOT", "ON", "OR", "ORDER", "OUTER", "RIGHT", "SELECT", "SUM", "WHERE", "CREATE TABLE", "ALTER TABLE", "TRUNCATE TABLE", "DROP TABLE", "INSERT INTO", "ALTER SESSION", "DELETE", "UPDATE", "VALUES", "SET", "'[^']*'"};
    private static final Pattern keywordsPattern = Pattern.compile(SQLFormatter.getPattern(keywords), 2);
    private static final String[] pingSQL = new String[]{"^SELECT\\s+1", "^VALUES\\s*\\(\\s*1\\s*\\)"};
    private static final Pattern pingSQLPattern = Pattern.compile(SQLFormatter.getPattern(pingSQL), 2);
    private static String grayHTMLString;

    SQLFormatter() {
    }

    private static String getPattern(String[] patterns) {
        StringBuilder pattern = new StringBuilder();
        for (String patternString : patterns) {
            pattern.append("(");
            if (Character.isLetter(patternString.charAt(0))) {
                pattern.append("\\b");
                pattern.append(patternString);
                pattern.append("\\b");
            } else {
                pattern.append(patternString);
            }
            pattern.append(")|");
        }
        return pattern.substring(0, pattern.length() - 1);
    }

    static String format(String command) {
        StringBuilder s = new StringBuilder();
        int offset = 0;
        command = SQLFormatter.htmlize(command);
        Matcher m = keywordsPattern.matcher(command);
        s.append("<html>");
        while (m.find()) {
            String kw = m.group();
            s.append(command.substring(offset, m.start()));
            if (kw.startsWith("'")) {
                s.append(kw);
            } else {
                s.append("<b>");
                s.append(kw);
                s.append("</b>");
            }
            offset = m.end();
        }
        s.append(command.substring(offset, command.length()));
        s.append(SQLFormatter.checkPingSQL(command));
        s.append("</html>");
        String formattedCommand = s.toString();
        formattedCommand = formattedCommand.replace(")", ")</font>");
        formattedCommand = formattedCommand.replace("(", "<font color='" + SQLFormatter.getGrayHTMLString() + "'>(");
        return formattedCommand;
    }

    private static String htmlize(String value) {
        return value.replace(">", "&gt;").replace("<", "&lt;");
    }

    private static String checkPingSQL(String command) {
        Matcher m = pingSQLPattern.matcher(command);
        if (m.find()) {
            return PING_TEXT;
        }
        return "";
    }

    private static String getGrayHTMLString() {
        if (grayHTMLString == null) {
            Color grayColor = UIUtils.getDisabledForeground(new JLabel().getForeground());
            grayHTMLString = "rgb(" + grayColor.getRed() + "," + grayColor.getGreen() + "," + grayColor.getBlue() + ")";
        }
        return grayHTMLString;
    }
}

