This directory contains all files related to shell completions.

The current stable shell completions can be found in `completions/`. They are
copied into standard shell completion directories when j4-dmenu-desktop is
installed.

All shell completions are generated by
[crazy-complete](https://github.com/crazy-complete/crazy-complete).

Shell completions in `completions/` are updated with each release of
j4-dmenu-desktop. You can also generate shell completions manually. This can be
useful if:

- you want to modify completions
- you are running j4-dmenu-desktop from `develop` or from some other unstable
  version and the stable completions in `completions/` are out of date
- there is a newer version of `crazy-complete` available which fixes some issues
  with current stable completions or which adds some new features
- you want to generate them for other reasons

# How to manually generate completions?
J4-dmenu-desktop currently supports generating completions via the Meson build
system only (CMake only supports using completions from `completions/`).

Meson tries to detect whether `crazy-complete` is available. If it is, Meson
will ignore `completions/` and it will generate the completions manually. If
`crazy-complete` isn't available, it will work with `completions/`.

This behavior can be controlled via `-Dgenerate-shell-completions`. For example,
if you want to make sure that manually generated completions will always be
used, set up the builddir as follows:

```
meson setup -Dgenerate-shell-completions=enabled builddir
```

Completions (either generated or the ones from `completions/`) will be installed
upon request (via `meson install`, `ninja install` or through similar methods).

You can run `ninja` in the builddir to build j4-dmenu-desktop including
its shell completions. If you want to only build the completions, you can run

```
ninja shell-completions
```

from within the builddir. Shell completions will appear in the `etc/`
subdirectory of the builddir.

You can also generate them by manually invoking `crazy-complete`.
The completion file is located at
[`etc/j4-dmenu-desktop.yaml`](j4-dmenu-desktop.yaml).

# Why crazy-complete?
Crazy-complete is a niche project with a small user base. Because of this, I,
[meator](https://github.com/meator), will thoroughly test j4-dmenu-desktop's
completions whenever a new release of crazy-complete or j4-dmenu-desktop comes
around.

My research into shell completion generators showed that crazy-complete is the
best completion generator on the market. Its input format is easy to use, the
completions are robust and reasonably readable for a machine-generated shell
script and all major shells (Bash, Fish, ZSH) are supported.

j4-dmenu-desktop provided handwritten shell completions in the past. They can
now be found in the `deprecated/` directory. [Read its README for more
info](deprecated/README.md).
