package jiconfont.icons.font_awesome;

import jiconfont.IconCode;
import jiconfont.IconFont;

import java.io.InputStream;

/**
 * Copyright (c) 2016 jIconFont <BR>
 * <BR>
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to the following conditions:<BR>
 * <BR>
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.<BR>
 * <BR>
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
public enum FontAwesome implements IconCode {

  ADDRESS_BOOK('\uF2B9'),
  ADDRESS_BOOK_O('\uF2BA'),
  ADDRESS_CARD('\uF2BB'),
  ADDRESS_CARD_O('\uF2BC'),
  ADJUST('\uF042'),
  ADN('\uF170'),
  ALIGN_CENTER('\uF037'),
  ALIGN_JUSTIFY('\uF039'),
  ALIGN_LEFT('\uF036'),
  ALIGN_RIGHT('\uF038'),
  AMAZON('\uF270'),
  AMBULANCE('\uF0F9'),
  AMERICAN_SIGN_LANGUAGE_INTERPRETING('\uF2A3'),
  ANCHOR('\uF13D'),
  ANDROID('\uF17B'),
  ANGELLIST('\uF209'),
  ANGLE_DOUBLE_DOWN('\uF103'),
  ANGLE_DOUBLE_LEFT('\uF100'),
  ANGLE_DOUBLE_RIGHT('\uF101'),
  ANGLE_DOUBLE_UP('\uF102'),
  ANGLE_DOWN('\uF107'),
  ANGLE_LEFT('\uF104'),
  ANGLE_RIGHT('\uF105'),
  ANGLE_UP('\uF106'),
  APPLE('\uF179'),
  ARCHIVE('\uF187'),
  AREA_CHART('\uF1FE'),
  ARROWS('\uF047'),
  ARROWS_ALT('\uF0B2'),
  ARROWS_H('\uF07E'),
  ARROWS_V('\uF07D'),
  ARROW_CIRCLE_DOWN('\uF0AB'),
  ARROW_CIRCLE_LEFT('\uF0A8'),
  ARROW_CIRCLE_O_DOWN('\uF01A'),
  ARROW_CIRCLE_O_LEFT('\uF190'),
  ARROW_CIRCLE_O_RIGHT('\uF18E'),
  ARROW_CIRCLE_O_UP('\uF01B'),
  ARROW_CIRCLE_RIGHT('\uF0A9'),
  ARROW_CIRCLE_UP('\uF0AA'),
  ARROW_DOWN('\uF063'),
  ARROW_LEFT('\uF060'),
  ARROW_RIGHT('\uF061'),
  ARROW_UP('\uF062'),
  ASSISTIVE_LISTENING_SYSTEMS('\uF2A2'),
  ASTERISK('\uF069'),
  AT('\uF1FA'),
  AUDIO_DESCRIPTION('\uF29E'),
  BACKWARD('\uF04A'),
  BALANCE_SCALE('\uF24E'),
  BAN('\uF05E'),
  BANDCAMP('\uF2D5'),
  BARCODE('\uF02A'),
  BARS('\uF0C9'),
  BAR_CHART('\uF080'),
  BATH('\uF2CD'),
  BATTERY_EMPTY('\uF244'),
  BATTERY_FULL('\uF240'),
  BATTERY_HALF('\uF242'),
  BATTERY_QUARTER('\uF243'),
  BATTERY_THREE_QUARTERS('\uF241'),
  BED('\uF236'),
  BEER('\uF0FC'),
  BEHANCE('\uF1B4'),
  BEHANCE_SQUARE('\uF1B5'),
  BELL('\uF0F3'),
  BELL_O('\uF0A2'),
  BELL_SLASH('\uF1F6'),
  BELL_SLASH_O('\uF1F7'),
  BICYCLE('\uF206'),
  BINOCULARS('\uF1E5'),
  BIRTHDAY_CAKE('\uF1FD'),
  BITBUCKET('\uF171'),
  BITBUCKET_SQUARE('\uF172'),
  BLACK_TIE('\uF27E'),
  BLIND('\uF29D'),
  BLUETOOTH('\uF293'),
  BLUETOOTH_B('\uF294'),
  BOLD('\uF032'),
  BOLT('\uF0E7'),
  BOMB('\uF1E2'),
  BOOK('\uF02D'),
  BOOKMARK('\uF02E'),
  BOOKMARK_O('\uF097'),
  BRAILLE('\uF2A1'),
  BRIEFCASE('\uF0B1'),
  BTC('\uF15A'),
  BUG('\uF188'),
  BUILDING('\uF1AD'),
  BUILDING_O('\uF0F7'),
  BULLHORN('\uF0A1'),
  BULLSEYE('\uF140'),
  BUS('\uF207'),
  BUYSELLADS('\uF20D'),
  CALCULATOR('\uF1EC'),
  CALENDAR('\uF073'),
  CALENDAR_CHECK_O('\uF274'),
  CALENDAR_MINUS_O('\uF272'),
  CALENDAR_O('\uF133'),
  CALENDAR_PLUS_O('\uF271'),
  CALENDAR_TIMES_O('\uF273'),
  CAMERA('\uF030'),
  CAMERA_RETRO('\uF083'),
  CAR('\uF1B9'),
  CARET_DOWN('\uF0D7'),
  CARET_LEFT('\uF0D9'),
  CARET_RIGHT('\uF0DA'),
  CARET_SQUARE_O_DOWN('\uF150'),
  CARET_SQUARE_O_LEFT('\uF191'),
  CARET_SQUARE_O_RIGHT('\uF152'),
  CARET_SQUARE_O_UP('\uF151'),
  CARET_UP('\uF0D8'),
  CART_ARROW_DOWN('\uF218'),
  CART_PLUS('\uF217'),
  CC('\uF20A'),
  CC_AMEX('\uF1F3'),
  CC_DINERS_CLUB('\uF24C'),
  CC_DISCOVER('\uF1F2'),
  CC_JCB('\uF24B'),
  CC_MASTERCARD('\uF1F1'),
  CC_PAYPAL('\uF1F4'),
  CC_STRIPE('\uF1F5'),
  CC_VISA('\uF1F0'),
  CERTIFICATE('\uF0A3'),
  CHAIN_BROKEN('\uF127'),
  CHECK('\uF00C'),
  CHECK_CIRCLE('\uF058'),
  CHECK_CIRCLE_O('\uF05D'),
  CHECK_SQUARE('\uF14A'),
  CHECK_SQUARE_O('\uF046'),
  CHEVRON_CIRCLE_DOWN('\uF13A'),
  CHEVRON_CIRCLE_LEFT('\uF137'),
  CHEVRON_CIRCLE_RIGHT('\uF138'),
  CHEVRON_CIRCLE_UP('\uF139'),
  CHEVRON_DOWN('\uF078'),
  CHEVRON_LEFT('\uF053'),
  CHEVRON_RIGHT('\uF054'),
  CHEVRON_UP('\uF077'),
  CHILD('\uF1AE'),
  CHROME('\uF268'),
  CIRCLE('\uF111'),
  CIRCLE_O('\uF10C'),
  CIRCLE_O_NOTCH('\uF1CE'),
  CIRCLE_THIN('\uF1DB'),
  CLIPBOARD('\uF0EA'),
  CLOCK_O('\uF017'),
  CLONE('\uF24D'),
  CLOUD('\uF0C2'),
  CLOUD_DOWNLOAD('\uF0ED'),
  CLOUD_UPLOAD('\uF0EE'),
  CODE('\uF121'),
  CODEPEN('\uF1CB'),
  CODE_FORK('\uF126'),
  CODIEPIE('\uF284'),
  COFFEE('\uF0F4'),
  COG('\uF013'),
  COGS('\uF085'),
  COLUMNS('\uF0DB'),
  COMMENT('\uF075'),
  COMMENTING('\uF27A'),
  COMMENTING_O('\uF27B'),
  COMMENTS('\uF086'),
  COMMENTS_O('\uF0E6'),
  COMMENT_O('\uF0E5'),
  COMPASS('\uF14E'),
  COMPRESS('\uF066'),
  CONNECTDEVELOP('\uF20E'),
  CONTAO('\uF26D'),
  COPYRIGHT('\uF1F9'),
  CREATIVE_COMMONS('\uF25E'),
  CREDIT_CARD('\uF09D'),
  CREDIT_CARD_ALT('\uF283'),
  CROP('\uF125'),
  CROSSHAIRS('\uF05B'),
  CSS3('\uF13C'),
  CUBE('\uF1B2'),
  CUBES('\uF1B3'),
  CUTLERY('\uF0F5'),
  DASHCUBE('\uF210'),
  DATABASE('\uF1C0'),
  DEAF('\uF2A4'),
  DELICIOUS('\uF1A5'),
  DESKTOP('\uF108'),
  DEVIANTART('\uF1BD'),
  DIAMOND('\uF219'),
  DIGG('\uF1A6'),
  DOT_CIRCLE_O('\uF192'),
  DOWNLOAD('\uF019'),
  DRIBBBLE('\uF17D'),
  DROPBOX('\uF16B'),
  DRUPAL('\uF1A9'),
  EDGE('\uF282'),
  EERCAST('\uF2DA'),
  EJECT('\uF052'),
  ELLIPSIS_H('\uF141'),
  ELLIPSIS_V('\uF142'),
  EMPIRE('\uF1D1'),
  ENVELOPE('\uF0E0'),
  ENVELOPE_O('\uF003'),
  ENVELOPE_OPEN('\uF2B6'),
  ENVELOPE_OPEN_O('\uF2B7'),
  ENVELOPE_SQUARE('\uF199'),
  ENVIRA('\uF299'),
  ERASER('\uF12D'),
  ETSY('\uF2D7'),
  EUR('\uF153'),
  EXCHANGE('\uF0EC'),
  EXCLAMATION('\uF12A'),
  EXCLAMATION_CIRCLE('\uF06A'),
  EXCLAMATION_TRIANGLE('\uF071'),
  EXPAND('\uF065'),
  EXPEDITEDSSL('\uF23E'),
  EXTERNAL_LINK('\uF08E'),
  EXTERNAL_LINK_SQUARE('\uF14C'),
  EYE('\uF06E'),
  EYEDROPPER('\uF1FB'),
  EYE_SLASH('\uF070'),
  FACEBOOK('\uF09A'),
  FACEBOOK_OFFICIAL('\uF230'),
  FACEBOOK_SQUARE('\uF082'),
  FAST_BACKWARD('\uF049'),
  FAST_FORWARD('\uF050'),
  FAX('\uF1AC'),
  FA_500PX('\uF26E'),
  FEMALE('\uF182'),
  FIGHTER_JET('\uF0FB'),
  FILE('\uF15B'),
  FILES_O('\uF0C5'),
  FILE_ARCHIVE_O('\uF1C6'),
  FILE_AUDIO_O('\uF1C7'),
  FILE_CODE_O('\uF1C9'),
  FILE_EXCEL_O('\uF1C3'),
  FILE_IMAGE_O('\uF1C5'),
  FILE_O('\uF016'),
  FILE_PDF_O('\uF1C1'),
  FILE_POWERPOINT_O('\uF1C4'),
  FILE_TEXT('\uF15C'),
  FILE_TEXT_O('\uF0F6'),
  FILE_VIDEO_O('\uF1C8'),
  FILE_WORD_O('\uF1C2'),
  FILM('\uF008'),
  FILTER('\uF0B0'),
  FIRE('\uF06D'),
  FIREFOX('\uF269'),
  FIRE_EXTINGUISHER('\uF134'),
  FIRST_ORDER('\uF2B0'),
  FLAG('\uF024'),
  FLAG_CHECKERED('\uF11E'),
  FLAG_O('\uF11D'),
  FLASK('\uF0C3'),
  FLICKR('\uF16E'),
  FLOPPY_O('\uF0C7'),
  FOLDER('\uF07B'),
  FOLDER_O('\uF114'),
  FOLDER_OPEN('\uF07C'),
  FOLDER_OPEN_O('\uF115'),
  FONT('\uF031'),
  FONTICONS('\uF280'),
  FONT_AWESOME('\uF2B4'),
  FORT_AWESOME('\uF286'),
  FORUMBEE('\uF211'),
  FORWARD('\uF04E'),
  FOURSQUARE('\uF180'),
  FREE_CODE_CAMP('\uF2C5'),
  FROWN_O('\uF119'),
  FUTBOL_O('\uF1E3'),
  GAMEPAD('\uF11B'),
  GAVEL('\uF0E3'),
  GBP('\uF154'),
  GENDERLESS('\uF22D'),
  GET_POCKET('\uF265'),
  GG('\uF260'),
  GG_CIRCLE('\uF261'),
  GIFT('\uF06B'),
  GIT('\uF1D3'),
  GITHUB('\uF09B'),
  GITHUB_ALT('\uF113'),
  GITHUB_SQUARE('\uF092'),
  GITLAB('\uF296'),
  GIT_SQUARE('\uF1D2'),
  GLASS('\uF000'),
  GLIDE('\uF2A5'),
  GLIDE_G('\uF2A6'),
  GLOBE('\uF0AC'),
  GOOGLE('\uF1A0'),
  GOOGLE_PLUS('\uF0D5'),
  GOOGLE_PLUS_OFFICIAL('\uF2B3'),
  GOOGLE_PLUS_SQUARE('\uF0D4'),
  GOOGLE_WALLET('\uF1EE'),
  GRADUATION_CAP('\uF19D'),
  GRATIPAY('\uF184'),
  GRAV('\uF2D6'),
  HACKER_NEWS('\uF1D4'),
  HANDSHAKE_O('\uF2B5'),
  HAND_LIZARD_O('\uF258'),
  HAND_O_DOWN('\uF0A7'),
  HAND_O_LEFT('\uF0A5'),
  HAND_O_RIGHT('\uF0A4'),
  HAND_O_UP('\uF0A6'),
  HAND_PAPER_O('\uF256'),
  HAND_PEACE_O('\uF25B'),
  HAND_POINTER_O('\uF25A'),
  HAND_ROCK_O('\uF255'),
  HAND_SCISSORS_O('\uF257'),
  HAND_SPOCK_O('\uF259'),
  HASHTAG('\uF292'),
  HDD_O('\uF0A0'),
  HEADER('\uF1DC'),
  HEADPHONES('\uF025'),
  HEART('\uF004'),
  HEARTBEAT('\uF21E'),
  HEART_O('\uF08A'),
  HISTORY('\uF1DA'),
  HOME('\uF015'),
  HOSPITAL_O('\uF0F8'),
  HOURGLASS('\uF254'),
  HOURGLASS_END('\uF253'),
  HOURGLASS_HALF('\uF252'),
  HOURGLASS_O('\uF250'),
  HOURGLASS_START('\uF251'),
  HOUZZ('\uF27C'),
  HTML5('\uF13B'),
  H_SQUARE('\uF0FD'),
  ID_BADGE('\uF2C1'),
  ID_CARD('\uF2C2'),
  ID_CARD_O('\uF2C3'),
  ILS('\uF20B'),
  IMDB('\uF2D8'),
  INBOX('\uF01C'),
  INDENT('\uF03C'),
  INDUSTRY('\uF275'),
  INFO('\uF129'),
  INFO_CIRCLE('\uF05A'),
  INR('\uF156'),
  INSTAGRAM('\uF16D'),
  INTERNET_EXPLORER('\uF26B'),
  IOXHOST('\uF208'),
  ITALIC('\uF033'),
  I_CURSOR('\uF246'),
  JOOMLA('\uF1AA'),
  JPY('\uF157'),
  JSFIDDLE('\uF1CC'),
  KEY('\uF084'),
  KEYBOARD_O('\uF11C'),
  KRW('\uF159'),
  LANGUAGE('\uF1AB'),
  LAPTOP('\uF109'),
  LASTFM('\uF202'),
  LASTFM_SQUARE('\uF203'),
  LEAF('\uF06C'),
  LEANPUB('\uF212'),
  LEMON_O('\uF094'),
  LEVEL_DOWN('\uF149'),
  LEVEL_UP('\uF148'),
  LIFE_RING('\uF1CD'),
  LIGHTBULB_O('\uF0EB'),
  LINE_CHART('\uF201'),
  LINK('\uF0C1'),
  LINKEDIN('\uF0E1'),
  LINKEDIN_SQUARE('\uF08C'),
  LINODE('\uF2B8'),
  LINUX('\uF17C'),
  LIST('\uF03A'),
  LIST_ALT('\uF022'),
  LIST_OL('\uF0CB'),
  LIST_UL('\uF0CA'),
  LOCATION_ARROW('\uF124'),
  LOCK('\uF023'),
  LONG_ARROW_DOWN('\uF175'),
  LONG_ARROW_LEFT('\uF177'),
  LONG_ARROW_RIGHT('\uF178'),
  LONG_ARROW_UP('\uF176'),
  LOW_VISION('\uF2A8'),
  MAGIC('\uF0D0'),
  MAGNET('\uF076'),
  MALE('\uF183'),
  MAP('\uF279'),
  MAP_MARKER('\uF041'),
  MAP_O('\uF278'),
  MAP_PIN('\uF276'),
  MAP_SIGNS('\uF277'),
  MARS('\uF222'),
  MARS_DOUBLE('\uF227'),
  MARS_STROKE('\uF229'),
  MARS_STROKE_H('\uF22B'),
  MARS_STROKE_V('\uF22A'),
  MAXCDN('\uF136'),
  MEANPATH('\uF20C'),
  MEDIUM('\uF23A'),
  MEDKIT('\uF0FA'),
  MEETUP('\uF2E0'),
  MEH_O('\uF11A'),
  MERCURY('\uF223'),
  MICROCHIP('\uF2DB'),
  MICROPHONE('\uF130'),
  MICROPHONE_SLASH('\uF131'),
  MINUS('\uF068'),
  MINUS_CIRCLE('\uF056'),
  MINUS_SQUARE('\uF146'),
  MINUS_SQUARE_O('\uF147'),
  MIXCLOUD('\uF289'),
  MOBILE('\uF10B'),
  MODX('\uF285'),
  MONEY('\uF0D6'),
  MOON_O('\uF186'),
  MOTORCYCLE('\uF21C'),
  MOUSE_POINTER('\uF245'),
  MUSIC('\uF001'),
  NEUTER('\uF22C'),
  NEWSPAPER_O('\uF1EA'),
  OBJECT_GROUP('\uF247'),
  OBJECT_UNGROUP('\uF248'),
  ODNOKLASSNIKI('\uF263'),
  ODNOKLASSNIKI_SQUARE('\uF264'),
  OPENCART('\uF23D'),
  OPENID('\uF19B'),
  OPERA('\uF26A'),
  OPTIN_MONSTER('\uF23C'),
  OUTDENT('\uF03B'),
  PAGELINES('\uF18C'),
  PAINT_BRUSH('\uF1FC'),
  PAPERCLIP('\uF0C6'),
  PAPER_PLANE('\uF1D8'),
  PAPER_PLANE_O('\uF1D9'),
  PARAGRAPH('\uF1DD'),
  PAUSE('\uF04C'),
  PAUSE_CIRCLE('\uF28B'),
  PAUSE_CIRCLE_O('\uF28C'),
  PAW('\uF1B0'),
  PAYPAL('\uF1ED'),
  PENCIL('\uF040'),
  PENCIL_SQUARE('\uF14B'),
  PENCIL_SQUARE_O('\uF044'),
  PERCENT('\uF295'),
  PHONE('\uF095'),
  PHONE_SQUARE('\uF098'),
  PICTURE_O('\uF03E'),
  PIED_PIPER('\uF2AE'),
  PIED_PIPER_ALT('\uF1A8'),
  PIED_PIPER_PP('\uF1A7'),
  PIE_CHART('\uF200'),
  PINTEREST('\uF0D2'),
  PINTEREST_P('\uF231'),
  PINTEREST_SQUARE('\uF0D3'),
  PLANE('\uF072'),
  PLAY('\uF04B'),
  PLAY_CIRCLE('\uF144'),
  PLAY_CIRCLE_O('\uF01D'),
  PLUG('\uF1E6'),
  PLUS('\uF067'),
  PLUS_CIRCLE('\uF055'),
  PLUS_SQUARE('\uF0FE'),
  PLUS_SQUARE_O('\uF196'),
  PODCAST('\uF2CE'),
  POWER_OFF('\uF011'),
  PRINT('\uF02F'),
  PRODUCT_HUNT('\uF288'),
  PUZZLE_PIECE('\uF12E'),
  QQ('\uF1D6'),
  QRCODE('\uF029'),
  QUESTION('\uF128'),
  QUESTION_CIRCLE('\uF059'),
  QUESTION_CIRCLE_O('\uF29C'),
  QUORA('\uF2C4'),
  QUOTE_LEFT('\uF10D'),
  QUOTE_RIGHT('\uF10E'),
  RANDOM('\uF074'),
  RAVELRY('\uF2D9'),
  REBEL('\uF1D0'),
  RECYCLE('\uF1B8'),
  REDDIT('\uF1A1'),
  REDDIT_ALIEN('\uF281'),
  REDDIT_SQUARE('\uF1A2'),
  REFRESH('\uF021'),
  REGISTERED('\uF25D'),
  RENREN('\uF18B'),
  REPEAT('\uF01E'),
  REPLY('\uF112'),
  REPLY_ALL('\uF122'),
  RETWEET('\uF079'),
  ROAD('\uF018'),
  ROCKET('\uF135'),
  RSS('\uF09E'),
  RSS_SQUARE('\uF143'),
  RUB('\uF158'),
  SAFARI('\uF267'),
  SCISSORS('\uF0C4'),
  SCRIBD('\uF28A'),
  SEARCH('\uF002'),
  SEARCH_MINUS('\uF010'),
  SEARCH_PLUS('\uF00E'),
  SELLSY('\uF213'),
  SERVER('\uF233'),
  SHARE('\uF064'),
  SHARE_ALT('\uF1E0'),
  SHARE_ALT_SQUARE('\uF1E1'),
  SHARE_SQUARE('\uF14D'),
  SHARE_SQUARE_O('\uF045'),
  SHIELD('\uF132'),
  SHIP('\uF21A'),
  SHIRTSINBULK('\uF214'),
  SHOPPING_BAG('\uF290'),
  SHOPPING_BASKET('\uF291'),
  SHOPPING_CART('\uF07A'),
  SHOWER('\uF2CC'),
  SIGNAL('\uF012'),
  SIGN_IN('\uF090'),
  SIGN_LANGUAGE('\uF2A7'),
  SIGN_OUT('\uF08B'),
  SIMPLYBUILT('\uF215'),
  SITEMAP('\uF0E8'),
  SKYATLAS('\uF216'),
  SKYPE('\uF17E'),
  SLACK('\uF198'),
  SLIDERS('\uF1DE'),
  SLIDESHARE('\uF1E7'),
  SMILE_O('\uF118'),
  SNAPCHAT('\uF2AB'),
  SNAPCHAT_GHOST('\uF2AC'),
  SNAPCHAT_SQUARE('\uF2AD'),
  SNOWFLAKE_O('\uF2DC'),
  SORT('\uF0DC'),
  SORT_ALPHA_ASC('\uF15D'),
  SORT_ALPHA_DESC('\uF15E'),
  SORT_AMOUNT_ASC('\uF160'),
  SORT_AMOUNT_DESC('\uF161'),
  SORT_ASC('\uF0DE'),
  SORT_DESC('\uF0DD'),
  SORT_NUMERIC_ASC('\uF162'),
  SORT_NUMERIC_DESC('\uF163'),
  SOUNDCLOUD('\uF1BE'),
  SPACE_SHUTTLE('\uF197'),
  SPINNER('\uF110'),
  SPOON('\uF1B1'),
  SPOTIFY('\uF1BC'),
  SQUARE('\uF0C8'),
  SQUARE_O('\uF096'),
  STACK_EXCHANGE('\uF18D'),
  STACK_OVERFLOW('\uF16C'),
  STAR('\uF005'),
  STAR_HALF('\uF089'),
  STAR_HALF_O('\uF123'),
  STAR_O('\uF006'),
  STEAM('\uF1B6'),
  STEAM_SQUARE('\uF1B7'),
  STEP_BACKWARD('\uF048'),
  STEP_FORWARD('\uF051'),
  STETHOSCOPE('\uF0F1'),
  STICKY_NOTE('\uF249'),
  STICKY_NOTE_O('\uF24A'),
  STOP('\uF04D'),
  STOP_CIRCLE('\uF28D'),
  STOP_CIRCLE_O('\uF28E'),
  STREET_VIEW('\uF21D'),
  STRIKETHROUGH('\uF0CC'),
  STUMBLEUPON('\uF1A4'),
  STUMBLEUPON_CIRCLE('\uF1A3'),
  SUBSCRIPT('\uF12C'),
  SUBWAY('\uF239'),
  SUITCASE('\uF0F2'),
  SUN_O('\uF185'),
  SUPERPOWERS('\uF2DD'),
  SUPERSCRIPT('\uF12B'),
  TABLE('\uF0CE'),
  TABLET('\uF10A'),
  TACHOMETER('\uF0E4'),
  TAG('\uF02B'),
  TAGS('\uF02C'),
  TASKS('\uF0AE'),
  TAXI('\uF1BA'),
  TELEGRAM('\uF2C6'),
  TELEVISION('\uF26C'),
  TENCENT_WEIBO('\uF1D5'),
  TERMINAL('\uF120'),
  TEXT_HEIGHT('\uF034'),
  TEXT_WIDTH('\uF035'),
  TH('\uF00A'),
  THEMEISLE('\uF2B2'),
  THERMOMETER_EMPTY('\uF2CB'),
  THERMOMETER_FULL('\uF2C7'),
  THERMOMETER_HALF('\uF2C9'),
  THERMOMETER_QUARTER('\uF2CA'),
  THERMOMETER_THREE_QUARTERS('\uF2C8'),
  THUMBS_DOWN('\uF165'),
  THUMBS_O_DOWN('\uF088'),
  THUMBS_O_UP('\uF087'),
  THUMBS_UP('\uF164'),
  THUMB_TACK('\uF08D'),
  TH_LARGE('\uF009'),
  TH_LIST('\uF00B'),
  TICKET('\uF145'),
  TIMES('\uF00D'),
  TIMES_CIRCLE('\uF057'),
  TIMES_CIRCLE_O('\uF05C'),
  TINT('\uF043'),
  TOGGLE_OFF('\uF204'),
  TOGGLE_ON('\uF205'),
  TRADEMARK('\uF25C'),
  TRAIN('\uF238'),
  TRANSGENDER('\uF224'),
  TRANSGENDER_ALT('\uF225'),
  TRASH('\uF1F8'),
  TRASH_O('\uF014'),
  TREE('\uF1BB'),
  TRELLO('\uF181'),
  TRIPADVISOR('\uF262'),
  TROPHY('\uF091'),
  TRUCK('\uF0D1'),
  TRY('\uF195'),
  TTY('\uF1E4'),
  TUMBLR('\uF173'),
  TUMBLR_SQUARE('\uF174'),
  TWITCH('\uF1E8'),
  TWITTER('\uF099'),
  TWITTER_SQUARE('\uF081'),
  UMBRELLA('\uF0E9'),
  UNDERLINE('\uF0CD'),
  UNDO('\uF0E2'),
  UNIVERSAL_ACCESS('\uF29A'),
  UNIVERSITY('\uF19C'),
  UNLOCK('\uF09C'),
  UNLOCK_ALT('\uF13E'),
  UPLOAD('\uF093'),
  USB('\uF287'),
  USD('\uF155'),
  USER('\uF007'),
  USERS('\uF0C0'),
  USER_CIRCLE('\uF2BD'),
  USER_CIRCLE_O('\uF2BE'),
  USER_MD('\uF0F0'),
  USER_O('\uF2C0'),
  USER_PLUS('\uF234'),
  USER_SECRET('\uF21B'),
  USER_TIMES('\uF235'),
  VENUS('\uF221'),
  VENUS_DOUBLE('\uF226'),
  VENUS_MARS('\uF228'),
  VIACOIN('\uF237'),
  VIADEO('\uF2A9'),
  VIADEO_SQUARE('\uF2AA'),
  VIDEO_CAMERA('\uF03D'),
  VIMEO('\uF27D'),
  VIMEO_SQUARE('\uF194'),
  VINE('\uF1CA'),
  VK('\uF189'),
  VOLUME_CONTROL_PHONE('\uF2A0'),
  VOLUME_DOWN('\uF027'),
  VOLUME_OFF('\uF026'),
  VOLUME_UP('\uF028'),
  WEIBO('\uF18A'),
  WEIXIN('\uF1D7'),
  WHATSAPP('\uF232'),
  WHEELCHAIR('\uF193'),
  WHEELCHAIR_ALT('\uF29B'),
  WIFI('\uF1EB'),
  WIKIPEDIA_W('\uF266'),
  WINDOWS('\uF17A'),
  WINDOW_CLOSE('\uF2D3'),
  WINDOW_CLOSE_O('\uF2D4'),
  WINDOW_MAXIMIZE('\uF2D0'),
  WINDOW_MINIMIZE('\uF2D1'),
  WINDOW_RESTORE('\uF2D2'),
  WORDPRESS('\uF19A'),
  WPBEGINNER('\uF297'),
  WPEXPLORER('\uF2DE'),
  WPFORMS('\uF298'),
  WRENCH('\uF0AD'),
  XING('\uF168'),
  XING_SQUARE('\uF169'),
  YAHOO('\uF19E'),
  YELP('\uF1E9'),
  YOAST('\uF2B1'),
  YOUTUBE('\uF167'),
  YOUTUBE_PLAY('\uF16A'),
  YOUTUBE_SQUARE('\uF166'),
  Y_COMBINATOR('\uF23B');

  private final char character;

  FontAwesome(char character) {
    this.character = character;
  }

  @Override
  public char getUnicode() {
    return character;
  }

  @Override
  public String getFontFamily() {
    return "FontAwesome";
  }

  public static IconFont getIconFont() {
    return new IconFont() {
      @Override
      public String getFontFamily() {
        return "FontAwesome";
      }

      @Override
      public InputStream getFontInputStream() {
        return FontAwesome.class.getResourceAsStream("/fonts/font_awesome/fontawesome-webfont.ttf");
      }
    };
  }

}
