libntruprime is a microlibrary for the
[Streamlined NTRU Prime](https://ntruprime.cr.yp.to)
cryptosystem.
Streamlined NTRU Prime (`sntrup`) is a lattice-based cryptosystem with the following features:

* Stability:
  Almost all details of `sntrup` match a
  [May 2016](https://ntruprime.cr.yp.to/ntruprime-20160511.pdf) publication.
  The only exceptions are small changes to encoding and hashing published in
  [April 2019](https://ntruprime.cr.yp.to/nist/ntruprime-20190330.pdf).
* Patent-freeness:
  April 2019 predates almost all
  [post-quantum patents](https://patents.google.com/?q=(%22post-quantum%22)).
  Analyses of various [lattice patents](https://ntruprime.cr.yp.to/faq.html)
  filed before April 2019 indicate no problems for `sntrup`.
* Deployment:
  The popular OpenSSH tool switched to `sntrup761` by default
  in [April 2022](https://www.openssh.com/txt/release-9.0),
  following initial integration of `sntrup` into [TinySSH](https://github.com/janmojzis/tinyssh).
* Affordability:
  Keys and ciphertexts are [about 1KB](https://ntruprime.cr.yp.to/speed.html)
  for `sntrup761`,
  and computations are [fast](speed.html).
* Careful design:
  Subject to the requirement of being a small lattice-based cryptosystem,
  `sntrup` is systematically designed to
  [eliminate unnecessary complications in security review](https://ntruprime.cr.yp.to/).
  It eliminates decryption failures, for example, and eliminates cyclotomics.
  The cryptosystem has never needed a security patch.
* Risk management: A much higher `sntrup1277` security level is
  [fully supported](https://ntruprime.cr.yp.to/speed.html),
  and is recommended whenever 2KB keys and ciphertexts are affordable,
  to reduce risks from
  [improvements in lattice attacks](https://ntruprime.cr.yp.to/warnings.html).
* Flexibility:
  The `sntrup` design allows a full spectrum of tradeoffs between size and security level,
  so applications with intermediate size limits aren't forced into much lower security levels.
  [Six different sizes](https://ntruprime.cr.yp.to/speed.html)
  have been selected for support.

libntruprime has a very simple stateless [API](api.html)
based on the SUPERCOP API,
with wire-format inputs and outputs,
providing functions
that directly match the KEM operations provided by the `sntrup` specification,
such as functions

    sntrup1277_keypair
    sntrup1277_enc
    sntrup1277_dec

for the `sntrup1277` KEM.

Internally,
libntruprime includes implementations designed to work portably across CPUs,
and implementations designed for [higher performance](speed.html)
on Intel/AMD CPUs with AVX2 instructions.
libntruprime includes automatic run-time selection of implementations.

libntruprime is intended to be
called by larger multi-function libraries
(such as traditional cryptographic libraries),
including libraries in other languages via FFI.
The idea is that libntruprime takes responsibility
for the details of `sntrup` computation,
including optimization, timing-attack protection, and (in ongoing work) verification,
freeing up the calling libraries to concentrate on
application-specific needs such as protocol integration.
Applications can also call libntruprime directly.

Latest release: [20241021](download.html).
