/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_c_ccalda.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t8, t10, t13, t14;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t26, t29, t30, t31, t32, t33, t34;
  double t35, t36, t39, t41, t42, t45, t47, t48;
  double t49, t52, t54, t57, t58, t62, t64, t70;
  double t72, t77, t80, t81, t85, t87, t89, t90;
  double t93, t94, tzk0;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t8 = rho[0] * rho[0];
  t10 = 0.1e1 / t4 / t8;
  t13 = tau[0] * t6 - sigma[0] * t10 / 0.8e1;
  t14 = t2 * t13;
  t15 = M_CBRT6;
  t16 = t14 * t15;
  t17 = M_PI * M_PI;
  t18 = POW_1_3(t17);
  t19 = t18 * t18;
  t20 = 0.1e1 / t19;
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t23 = t20 * t22;
  t26 = t15 * t20 * t22;
  t29 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t13 * t26;
  t30 = 0.1e1 / t29;
  t31 = M_CBRT3;
  t32 = 0.1e1 / M_PI;
  t33 = POW_1_3(t32);
  t34 = t31 * t33;
  t35 = M_CBRT4;
  t36 = t35 * t35;
  t39 = t34 * t36 / t3;
  t41 = 0.1e1 + 0.53425e-1 * t39;
  t42 = sqrt(t39);
  t45 = POW_3_2(t39);
  t47 = t31 * t31;
  t48 = t33 * t33;
  t49 = t47 * t48;
  t52 = t49 * t35 / t4;
  t54 = 0.379785e1 * t42 + 0.8969e0 * t39 + 0.204775e0 * t45 + 0.123235e0 * t52;
  t57 = 0.1e1 + 0.16081979498692535067e2 / t54;
  t58 = log(t57);
  t62 = POW_1_3(p->zeta_threshold);
  t64 = my_piecewise3(0.1e1 <= p->zeta_threshold, t62 * p->zeta_threshold, 1);
  t70 = (0.2e1 * t64 - 0.2e1) / (0.2e1 * t21 - 0.2e1);
  t72 = 0.1e1 + 0.278125e-1 * t39;
  t77 = 0.51785e1 * t42 + 0.905775e0 * t39 + 0.1100325e0 * t45 + 0.1241775e0 * t52;
  t80 = 0.1e1 + 0.29608749977793437516e2 / t77;
  t81 = log(t80);
  t85 = -0.621814e-1 * t41 * t58 + 0.19751673498613801407e-1 * t70 * t72 * t81;
  t87 = t23 * t30 * t85;
  t89 = 0.5e1 / 0.9e1 * t16 * t87;
  t90 = t23 * t30;
  t93 = 0.1e1 - 0.5e1 / 0.9e1 * t16 * t90;
  t94 = t93 * t85;
  tzk0 = t89 + t94;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t8, t10, t13, t14;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t26, t29, t30, t31, t32, t33, t34;
  double t35, t36, t39, t41, t42, t45, t47, t48;
  double t49, t52, t54, t57, t58, t62, t64, t70;
  double t72, t77, t80, t81, t85, t87, t89, t90;
  double t93, t94, tzk0;

  double t97, t99, t102, t103, t104, t105, t107, t109;
  double t110, t111, t112, t113, t114, t115, t117, t118;
  double t121, t122, t126, t127, t128, t130, t131, t132;
  double t133, t135, t137, t138, t139, t142, t144, t145;
  double t146, t149, t154, t155, t156, t161, t163, t164;
  double t167, t169, t170, t175, t178, t179, t180, tvrho0;
  double t183, t184, t185, t186, t189, t190, t191, t195;
  double t197, t198, tvsigma0, tvlapl0, t200, t201, t203, t207;
  double t214, t215, tvtau0;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t8 = rho[0] * rho[0];
  t10 = 0.1e1 / t4 / t8;
  t13 = tau[0] * t6 - sigma[0] * t10 / 0.8e1;
  t14 = t2 * t13;
  t15 = M_CBRT6;
  t16 = t14 * t15;
  t17 = M_PI * M_PI;
  t18 = POW_1_3(t17);
  t19 = t18 * t18;
  t20 = 0.1e1 / t19;
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t23 = t20 * t22;
  t26 = t15 * t20 * t22;
  t29 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t13 * t26;
  t30 = 0.1e1 / t29;
  t31 = M_CBRT3;
  t32 = 0.1e1 / M_PI;
  t33 = POW_1_3(t32);
  t34 = t31 * t33;
  t35 = M_CBRT4;
  t36 = t35 * t35;
  t39 = t34 * t36 / t3;
  t41 = 0.1e1 + 0.53425e-1 * t39;
  t42 = sqrt(t39);
  t45 = POW_3_2(t39);
  t47 = t31 * t31;
  t48 = t33 * t33;
  t49 = t47 * t48;
  t52 = t49 * t35 / t4;
  t54 = 0.379785e1 * t42 + 0.8969e0 * t39 + 0.204775e0 * t45 + 0.123235e0 * t52;
  t57 = 0.1e1 + 0.16081979498692535067e2 / t54;
  t58 = log(t57);
  t62 = POW_1_3(p->zeta_threshold);
  t64 = my_piecewise3(0.1e1 <= p->zeta_threshold, t62 * p->zeta_threshold, 1);
  t70 = (0.2e1 * t64 - 0.2e1) / (0.2e1 * t21 - 0.2e1);
  t72 = 0.1e1 + 0.278125e-1 * t39;
  t77 = 0.51785e1 * t42 + 0.905775e0 * t39 + 0.1100325e0 * t45 + 0.1241775e0 * t52;
  t80 = 0.1e1 + 0.29608749977793437516e2 / t77;
  t81 = log(t80);
  t85 = -0.621814e-1 * t41 * t58 + 0.19751673498613801407e-1 * t70 * t72 * t81;
  t87 = t23 * t30 * t85;
  t89 = 0.5e1 / 0.9e1 * t16 * t87;
  t90 = t23 * t30;
  t93 = 0.1e1 - 0.5e1 / 0.9e1 * t16 * t90;
  t94 = t93 * t85;
  tzk0 = t89 + t94;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t97 = t8 * rho[0];
  t99 = 0.1e1 / t4 / t97;
  t102 = -0.5e1 / 0.3e1 * tau[0] * t10 + sigma[0] * t99 / 0.3e1;
  t103 = t2 * t102;
  t104 = t103 * t15;
  t105 = t104 * t87;
  t107 = t15 * t15;
  t109 = 0.1e1 / t18 / t17;
  t110 = t107 * t109;
  t111 = t14 * t110;
  t112 = t29 * t29;
  t113 = 0.1e1 / t112;
  t114 = t21 * t113;
  t115 = t85 * params->c;
  t117 = t114 * t115 * t102;
  t118 = t111 * t117;
  t121 = 0.1e1 / t3 / rho[0];
  t122 = t36 * t121;
  t126 = t54 * t54;
  t127 = 0.1e1 / t126;
  t128 = t41 * t127;
  t130 = 0.1e1 / t42 * t31;
  t131 = t33 * t36;
  t132 = t131 * t121;
  t133 = t130 * t132;
  t135 = t34 * t122;
  t137 = sqrt(t39);
  t138 = t137 * t31;
  t139 = t138 * t132;
  t142 = t49 * t35 * t6;
  t144 = -0.632975e0 * t133 - 0.29896666666666666667e0 * t135 - 0.1023875e0 * t139 - 0.82156666666666666667e-1 * t142;
  t145 = 0.1e1 / t57;
  t146 = t144 * t145;
  t149 = t70 * t31;
  t154 = t70 * t72;
  t155 = t77 * t77;
  t156 = 0.1e1 / t155;
  t161 = -0.86308333333333333334e0 * t133 - 0.301925e0 * t135 - 0.5501625e-1 * t139 - 0.82785e-1 * t142;
  t163 = 0.1e1 / t80;
  t164 = t156 * t161 * t163;
  t167 = 0.11073470983333333333e-2 * t34 * t122 * t58 + 0.1e1 * t128 * t146 - 0.18311447306006545054e-3 * t149 * t131 * t121 * t81 - 0.5848223622634646207e0 * t154 * t164;
  t169 = t23 * t30 * t167;
  t170 = t16 * t169;
  t175 = t114 * params->c * t102;
  t178 = -0.5e1 / 0.9e1 * t104 * t90 + 0.5e2 / 0.81e2 * t111 * t175;
  t179 = t178 * t85;
  t180 = t93 * t167;
  tvrho0 = t89 + t94 + rho[0] * (0.5e1 / 0.9e1 * t105 - 0.5e2 / 0.81e2 * t118 + 0.5e1 / 0.9e1 * t170 + t179 + t180);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t183 = t2 * t10;
  t184 = t183 * t15;
  t185 = t184 * t87;
  t186 = 0.5e1 / 0.72e2 * t185;
  t189 = t111 * t114 * t115 * t10;
  t190 = 0.25e2 / 0.324e3 * t189;
  t191 = t184 * t90;
  t195 = t111 * t114 * params->c * t10;
  t197 = 0.5e1 / 0.72e2 * t191 - 0.25e2 / 0.324e3 * t195;
  t198 = t197 * t85;
  tvsigma0 = rho[0] * (-t186 + t190 + t198);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t200 = t2 * t6;
  t201 = t200 * t15;
  t203 = 0.5e1 / 0.9e1 * t201 * t87;
  t207 = 0.5e2 / 0.81e2 * t111 * t114 * t115 * t6;
  t214 = -0.5e1 / 0.9e1 * t201 * t90 + 0.5e2 / 0.81e2 * t111 * t114 * params->c * t6;
  t215 = t214 * t85;
  tvtau0 = rho[0] * (t203 - t207 + t215);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t8, t10, t13, t14;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t26, t29, t30, t31, t32, t33, t34;
  double t35, t36, t39, t41, t42, t45, t47, t48;
  double t49, t52, t54, t57, t58, t62, t64, t70;
  double t72, t77, t80, t81, t85, t87, t89, t90;
  double t93, t94, tzk0;

  double t97, t99, t102, t103, t104, t105, t107, t109;
  double t110, t111, t112, t113, t114, t115, t117, t118;
  double t121, t122, t126, t127, t128, t130, t131, t132;
  double t133, t135, t137, t138, t139, t142, t144, t145;
  double t146, t149, t154, t155, t156, t161, t163, t164;
  double t167, t169, t170, t175, t178, t179, t180, tvrho0;
  double t183, t184, t185, t186, t189, t190, t191, t195;
  double t197, t198, tvsigma0, tvlapl0, t200, t201, t203, t207;
  double t214, t215, tvtau0;

  double t224, t226, t229, t230, t231, t232, t234, t235;
  double t236, t237, t238, t240, t242, t243, t244, t246;
  double t247, t248, t249, t250, t251, t253, t255, t256;
  double t259, t260, t263, t264, t268, t269, t273, t274;
  double t275, t276, t277, t282, t283, t284, t285, t287;
  double t288, t290, t292, t293, t294, t296, t299, t301;
  double t302, t305, t306, t307, t308, t309, t310, t317;
  double t321, t322, t323, t325, t334, t336, t339, t340;
  double t341, t342, t343, t344, t347, t349, t350, t355;
  double t357, t360, t361, t365, t368, t369, t370, t372;
  double tv2rho20, t375, t376, t377, t379, t380, t382, t384;
  double t385, t386, t387, t389, t393, t397, t399, t401;
  double t404, t408, t410, t411, t412, tv2rhosigma0, tv2rholapl0, t416;
  double t417, t419, t421, t423, t427, t437, t438, t439;
  double tv2rhotau0, t442, t444, t445, t446, t447, t448, t449;
  double t451, t452, t454, t457, t459, t460, tv2sigma20, tv2sigmalapl0;
  double t463, t464, t465, t466, t467, t468, t470, t471;
  double t473, t476, t478, t479, tv2sigmatau0, tv2lapl20, tv2lapltau0, t482;
  double t483, t484, t486, t487, t490, t497, t498, tv2tau20;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t8 = rho[0] * rho[0];
  t10 = 0.1e1 / t4 / t8;
  t13 = tau[0] * t6 - sigma[0] * t10 / 0.8e1;
  t14 = t2 * t13;
  t15 = M_CBRT6;
  t16 = t14 * t15;
  t17 = M_PI * M_PI;
  t18 = POW_1_3(t17);
  t19 = t18 * t18;
  t20 = 0.1e1 / t19;
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t23 = t20 * t22;
  t26 = t15 * t20 * t22;
  t29 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t13 * t26;
  t30 = 0.1e1 / t29;
  t31 = M_CBRT3;
  t32 = 0.1e1 / M_PI;
  t33 = POW_1_3(t32);
  t34 = t31 * t33;
  t35 = M_CBRT4;
  t36 = t35 * t35;
  t39 = t34 * t36 / t3;
  t41 = 0.1e1 + 0.53425e-1 * t39;
  t42 = sqrt(t39);
  t45 = POW_3_2(t39);
  t47 = t31 * t31;
  t48 = t33 * t33;
  t49 = t47 * t48;
  t52 = t49 * t35 / t4;
  t54 = 0.379785e1 * t42 + 0.8969e0 * t39 + 0.204775e0 * t45 + 0.123235e0 * t52;
  t57 = 0.1e1 + 0.16081979498692535067e2 / t54;
  t58 = log(t57);
  t62 = POW_1_3(p->zeta_threshold);
  t64 = my_piecewise3(0.1e1 <= p->zeta_threshold, t62 * p->zeta_threshold, 1);
  t70 = (0.2e1 * t64 - 0.2e1) / (0.2e1 * t21 - 0.2e1);
  t72 = 0.1e1 + 0.278125e-1 * t39;
  t77 = 0.51785e1 * t42 + 0.905775e0 * t39 + 0.1100325e0 * t45 + 0.1241775e0 * t52;
  t80 = 0.1e1 + 0.29608749977793437516e2 / t77;
  t81 = log(t80);
  t85 = -0.621814e-1 * t41 * t58 + 0.19751673498613801407e-1 * t70 * t72 * t81;
  t87 = t23 * t30 * t85;
  t89 = 0.5e1 / 0.9e1 * t16 * t87;
  t90 = t23 * t30;
  t93 = 0.1e1 - 0.5e1 / 0.9e1 * t16 * t90;
  t94 = t93 * t85;
  tzk0 = t89 + t94;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t97 = t8 * rho[0];
  t99 = 0.1e1 / t4 / t97;
  t102 = -0.5e1 / 0.3e1 * tau[0] * t10 + sigma[0] * t99 / 0.3e1;
  t103 = t2 * t102;
  t104 = t103 * t15;
  t105 = t104 * t87;
  t107 = t15 * t15;
  t109 = 0.1e1 / t18 / t17;
  t110 = t107 * t109;
  t111 = t14 * t110;
  t112 = t29 * t29;
  t113 = 0.1e1 / t112;
  t114 = t21 * t113;
  t115 = t85 * params->c;
  t117 = t114 * t115 * t102;
  t118 = t111 * t117;
  t121 = 0.1e1 / t3 / rho[0];
  t122 = t36 * t121;
  t126 = t54 * t54;
  t127 = 0.1e1 / t126;
  t128 = t41 * t127;
  t130 = 0.1e1 / t42 * t31;
  t131 = t33 * t36;
  t132 = t131 * t121;
  t133 = t130 * t132;
  t135 = t34 * t122;
  t137 = sqrt(t39);
  t138 = t137 * t31;
  t139 = t138 * t132;
  t142 = t49 * t35 * t6;
  t144 = -0.632975e0 * t133 - 0.29896666666666666667e0 * t135 - 0.1023875e0 * t139 - 0.82156666666666666667e-1 * t142;
  t145 = 0.1e1 / t57;
  t146 = t144 * t145;
  t149 = t70 * t31;
  t154 = t70 * t72;
  t155 = t77 * t77;
  t156 = 0.1e1 / t155;
  t161 = -0.86308333333333333334e0 * t133 - 0.301925e0 * t135 - 0.5501625e-1 * t139 - 0.82785e-1 * t142;
  t163 = 0.1e1 / t80;
  t164 = t156 * t161 * t163;
  t167 = 0.11073470983333333333e-2 * t34 * t122 * t58 + 0.1e1 * t128 * t146 - 0.18311447306006545054e-3 * t149 * t131 * t121 * t81 - 0.5848223622634646207e0 * t154 * t164;
  t169 = t23 * t30 * t167;
  t170 = t16 * t169;
  t175 = t114 * params->c * t102;
  t178 = -0.5e1 / 0.9e1 * t104 * t90 + 0.5e2 / 0.81e2 * t111 * t175;
  t179 = t178 * t85;
  t180 = t93 * t167;
  tvrho0 = t89 + t94 + rho[0] * (0.5e1 / 0.9e1 * t105 - 0.5e2 / 0.81e2 * t118 + 0.5e1 / 0.9e1 * t170 + t179 + t180);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t183 = t2 * t10;
  t184 = t183 * t15;
  t185 = t184 * t87;
  t186 = 0.5e1 / 0.72e2 * t185;
  t189 = t111 * t114 * t115 * t10;
  t190 = 0.25e2 / 0.324e3 * t189;
  t191 = t184 * t90;
  t195 = t111 * t114 * params->c * t10;
  t197 = 0.5e1 / 0.72e2 * t191 - 0.25e2 / 0.324e3 * t195;
  t198 = t197 * t85;
  tvsigma0 = rho[0] * (-t186 + t190 + t198);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t200 = t2 * t6;
  t201 = t200 * t15;
  t203 = 0.5e1 / 0.9e1 * t201 * t87;
  t207 = 0.5e2 / 0.81e2 * t111 * t114 * t115 * t6;
  t214 = -0.5e1 / 0.9e1 * t201 * t90 + 0.5e2 / 0.81e2 * t111 * t114 * params->c * t6;
  t215 = t214 * t85;
  tvtau0 = rho[0] * (t203 - t207 + t215);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t224 = t8 * t8;
  t226 = 0.1e1 / t4 / t224;
  t229 = 0.4e2 / 0.9e1 * tau[0] * t99 - 0.11e2 / 0.9e1 * sigma[0] * t226;
  t230 = t2 * t229;
  t231 = t230 * t15;
  t232 = t231 * t87;
  t234 = t102 * t102;
  t235 = t2 * t234;
  t236 = t235 * t110;
  t237 = t114 * t115;
  t238 = t236 * t237;
  t240 = t104 * t169;
  t242 = t17 * t17;
  t243 = 0.1e1 / t242;
  t244 = t14 * t243;
  t246 = 0.1e1 / t112 / t29;
  t247 = t246 * t85;
  t248 = params->c * params->c;
  t249 = t248 * t234;
  t250 = t247 * t249;
  t251 = t244 * t250;
  t253 = t167 * params->c;
  t255 = t114 * t253 * t102;
  t256 = t111 * t255;
  t259 = t114 * t115 * t229;
  t260 = t111 * t259;
  t263 = 0.1e1 / t3 / t8;
  t264 = t36 * t263;
  t268 = t34 * t36;
  t269 = t121 * t127;
  t273 = t126 * t54;
  t274 = 0.1e1 / t273;
  t275 = t41 * t274;
  t276 = t144 * t144;
  t277 = t276 * t145;
  t282 = 0.1e1 / t42 / t39 * t47;
  t283 = t48 * t35;
  t284 = t283 * t10;
  t285 = t282 * t284;
  t287 = t131 * t263;
  t288 = t130 * t287;
  t290 = t34 * t264;
  t292 = 0.1e1/sqrt(t39);
  t293 = t292 * t47;
  t294 = t293 * t284;
  t296 = t138 * t287;
  t299 = t49 * t35 * t10;
  t301 = -0.42198333333333333333e0 * t285 + 0.84396666666666666666e0 * t288 + 0.39862222222222222223e0 * t290 + 0.68258333333333333333e-1 * t294 + 0.13651666666666666667e0 * t296 + 0.13692777777777777778e0 * t299;
  t302 = t301 * t145;
  t305 = t126 * t126;
  t306 = 0.1e1 / t305;
  t307 = t41 * t306;
  t308 = t57 * t57;
  t309 = 0.1e1 / t308;
  t310 = t276 * t309;
  t317 = t70 * t34;
  t321 = t155 * t77;
  t322 = 0.1e1 / t321;
  t323 = t161 * t161;
  t325 = t322 * t323 * t163;
  t334 = -0.57538888888888888889e0 * t285 + 0.11507777777777777778e1 * t288 + 0.40256666666666666667e0 * t290 + 0.366775e-1 * t294 + 0.73355e-1 * t296 + 0.137975e0 * t299;
  t336 = t156 * t334 * t163;
  t339 = t155 * t155;
  t340 = 0.1e1 / t339;
  t341 = t340 * t323;
  t342 = t80 * t80;
  t343 = 0.1e1 / t342;
  t344 = t341 * t343;
  t347 = -0.14764627977777777777e-2 * t34 * t264 * t58 - 0.35616666666666666666e-1 * t268 * t269 * t146 - 0.2e1 * t275 * t277 + 0.1e1 * t128 * t302 + 0.16081979498692535067e2 * t307 * t310 + 0.24415263074675393405e-3 * t149 * t131 * t263 * t81 + 0.10843581300301739842e-1 * t317 * t122 * t164 + 0.11696447245269292414e1 * t154 * t325 - 0.5848223622634646207e0 * t154 * t336 - 0.17315859105681463759e2 * t154 * t344;
  t349 = t23 * t30 * t347;
  t350 = t16 * t349;
  t355 = t109 * t21;
  t357 = t355 * t113 * params->c;
  t360 = t246 * t248;
  t361 = t360 * t234;
  t365 = t114 * params->c * t229;
  t368 = -0.5e1 / 0.9e1 * t231 * t90 + 0.1e3 / 0.81e2 * t235 * t107 * t357 - 0.2e4 / 0.243e3 * t244 * t361 + 0.5e2 / 0.81e2 * t111 * t365;
  t369 = t368 * t85;
  t370 = t178 * t167;
  t372 = t93 * t347;
  tv2rho20 = 0.1e2 / 0.9e1 * t105 - 0.1e3 / 0.81e2 * t118 + 0.1e2 / 0.9e1 * t170 + 0.2e1 * t179 + 0.2e1 * t180 + rho[0] * (0.5e1 / 0.9e1 * t232 - 0.1e3 / 0.81e2 * t238 + 0.1e2 / 0.9e1 * t240 + 0.2e4 / 0.243e3 * t251 - 0.1e3 / 0.81e2 * t256 - 0.5e2 / 0.81e2 * t260 + 0.5e1 / 0.9e1 * t350 + t369 + 0.2e1 * t370 + t372);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t375 = t2 * t99;
  t376 = t375 * t15;
  t377 = t376 * t87;
  t379 = t183 * t110;
  t380 = t379 * t117;
  t382 = t184 * t169;
  t384 = t243 * t246;
  t385 = t14 * t384;
  t386 = t85 * t248;
  t387 = t10 * t102;
  t389 = t385 * t386 * t387;
  t393 = t111 * t114 * t253 * t10;
  t397 = t111 * t114 * t115 * t99;
  t399 = t376 * t90;
  t401 = t379 * t175;
  t404 = t244 * t360 * t387;
  t408 = t111 * t114 * params->c * t99;
  t410 = -0.5e1 / 0.27e2 * t399 - 0.25e2 / 0.162e3 * t401 + 0.25e3 / 0.243e3 * t404 + 0.5e2 / 0.243e3 * t408;
  t411 = t410 * t85;
  t412 = t197 * t167;
  tv2rhosigma0 = -t186 + t190 + t198 + rho[0] * (0.5e1 / 0.27e2 * t377 + 0.25e2 / 0.162e3 * t380 - 0.5e1 / 0.72e2 * t382 - 0.25e3 / 0.243e3 * t389 + 0.25e2 / 0.324e3 * t393 - 0.5e2 / 0.243e3 * t397 + t411 + t412);

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t416 = t200 * t110;
  t417 = t416 * t117;
  t419 = t201 * t169;
  t421 = t6 * t102;
  t423 = t385 * t386 * t421;
  t427 = t111 * t114 * t253 * t6;
  t437 = 0.25e2 / 0.27e2 * t191 + 0.1e3 / 0.81e2 * t416 * t175 - 0.2e4 / 0.243e3 * t244 * t360 * t421 - 0.25e3 / 0.243e3 * t195;
  t438 = t437 * t85;
  t439 = t214 * t167;
  tv2rhotau0 = t203 - t207 + t215 + rho[0] * (-0.25e2 / 0.27e2 * t185 - 0.1e3 / 0.81e2 * t417 + 0.5e1 / 0.9e1 * t419 + 0.2e4 / 0.243e3 * t423 - 0.5e2 / 0.81e2 * t427 + 0.25e3 / 0.243e3 * t189 + t438 + t439);

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t442 = t224 * rho[0];
  t444 = 0.1e1 / t3 / t442;
  t445 = t2 * t444;
  t446 = t445 * t110;
  t447 = t446 * t237;
  t448 = 0.25e2 / 0.1296e4 * t447;
  t449 = t248 * t444;
  t451 = t244 * t247 * t449;
  t452 = 0.125e3 / 0.972e3 * t451;
  t454 = t445 * t107 * t357;
  t457 = t244 * t360 * t444;
  t459 = 0.25e2 / 0.1296e4 * t454 - 0.125e3 / 0.972e3 * t457;
  t460 = t459 * t85;
  tv2sigma20 = rho[0] * (-t448 + t452 + t460);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t463 = 0.1e1 / t3 / t224;
  t464 = t2 * t463;
  t465 = t464 * t110;
  t466 = t465 * t237;
  t467 = 0.25e2 / 0.162e3 * t466;
  t468 = t248 * t463;
  t470 = t244 * t247 * t468;
  t471 = 0.25e3 / 0.243e3 * t470;
  t473 = t464 * t107 * t357;
  t476 = t244 * t360 * t463;
  t478 = -0.25e2 / 0.162e3 * t473 + 0.25e3 / 0.243e3 * t476;
  t479 = t478 * t85;
  tv2sigmatau0 = rho[0] * (t467 - t471 + t479);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t482 = 0.1e1 / t3 / t97;
  t483 = t2 * t482;
  t484 = t483 * t110;
  t486 = 0.1e3 / 0.81e2 * t484 * t237;
  t487 = t248 * t482;
  t490 = 0.2e4 / 0.243e3 * t244 * t247 * t487;
  t497 = 0.1e3 / 0.81e2 * t483 * t107 * t357 - 0.2e4 / 0.243e3 * t244 * t360 * t482;
  t498 = t497 * t85;
  tv2tau20 = rho[0] * (-t486 + t490 + t498);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t8, t10, t13, t14;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t26, t29, t30, t31, t32, t33, t34;
  double t35, t36, t39, t41, t42, t45, t47, t48;
  double t49, t52, t54, t57, t58, t62, t64, t70;
  double t72, t77, t80, t81, t85, t87, t89, t90;
  double t93, t94, tzk0;

  double t97, t99, t102, t103, t104, t105, t107, t109;
  double t110, t111, t112, t113, t114, t115, t117, t118;
  double t121, t122, t126, t127, t128, t130, t131, t132;
  double t133, t135, t137, t138, t139, t142, t144, t145;
  double t146, t149, t154, t155, t156, t161, t163, t164;
  double t167, t169, t170, t175, t178, t179, t180, tvrho0;
  double t183, t184, t185, t186, t189, t190, t191, t195;
  double t197, t198, tvsigma0, tvlapl0, t200, t201, t203, t207;
  double t214, t215, tvtau0;

  double t224, t226, t229, t230, t231, t232, t234, t235;
  double t236, t237, t238, t240, t242, t243, t244, t246;
  double t247, t248, t249, t250, t251, t253, t255, t256;
  double t259, t260, t263, t264, t268, t269, t273, t274;
  double t275, t276, t277, t282, t283, t284, t285, t287;
  double t288, t290, t292, t293, t294, t296, t299, t301;
  double t302, t305, t306, t307, t308, t309, t310, t317;
  double t321, t322, t323, t325, t334, t336, t339, t340;
  double t341, t342, t343, t344, t347, t349, t350, t355;
  double t357, t360, t361, t365, t368, t369, t370, t372;
  double tv2rho20, t375, t376, t377, t379, t380, t382, t384;
  double t385, t386, t387, t389, t393, t397, t399, t401;
  double t404, t408, t410, t411, t412, tv2rhosigma0, tv2rholapl0, t416;
  double t417, t419, t421, t423, t427, t437, t438, t439;
  double tv2rhotau0, t442, t444, t445, t446, t447, t448, t449;
  double t451, t452, t454, t457, t459, t460, tv2sigma20, tv2sigmalapl0;
  double t463, t464, t465, t466, t467, t468, t470, t471;
  double t473, t476, t478, t479, tv2sigmatau0, tv2lapl20, tv2lapltau0, t482;
  double t483, t484, t486, t487, t490, t497, t498, tv2tau20;

  double t501, t502, t503, t505, t506, t510, t511, t512;
  double t518, t519, t520, t522, t523, t525, t526, t528;
  double t529, t531, t532, t533, t535, t537, t540, t542;
  double t543, t547, t548, t551, t552, t563, t565, t569;
  double t571, t581, t588, t592, t594, t598, t602, t606;
  double t633, t634, t635, t636, t641, t644, t645, t646;
  double t649, t652, t653, t654, t657, t658, t659, t660;
  double t661, t663, t666, t667, t671, t674, t675, t676;
  double t678, t679, t680, t683, t684, t686, t687, t688;
  double t690, t692, t694, t696, t697, t699, t700, t702;
  double t703, t704, t707, t708, t711, t712, t714, t716;
  double t718, t719, t721, tv3rho30, t741, t742, t743, t744;
  double t746, t747, t749, t750, t752, t755, t758, t760;
  double t762, t764, t766, t770, t772, t773, t774, t776;
  double t778, t780, t784, t785, t787, t789, t792, t794;
  double t798, t802, t804, t806, t809, t813, t815, t817;
  double tv3rho2sigma0, tv3rho2lapl0, t827, t829, t832, t842, t847, t848;
  double t850, t852, t853, t855, t857, t861, t862, t868;
  double t870, t872, t878, tv3rho2tau0, t880, t882, t883, t884;
  double t885, t887, t888, t889, t890, t892, t894, t896;
  double t897, t900, t902, t904, t907, t909, t910, t914;
  double t917, t919, t920, t921, tv3rhosigma20, tv3rhosigmalapl0, t925, t926;
  double t928, t930, t932, t933, t936, t940, t944, t947;
  double t948, t949, tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, t953, t954, t956;
  double t958, t960, t961, t964, t975, t976, t977, tv3rhotau20;
  double t980, t981, t982, t983, t984, t985, t987, t988;
  double t989, t990, t992, t994, t995, tv3sigma30, tv3sigma2lapl0, t997;
  double t998, t999, t1000, t1001, t1002, t1004, t1005, t1006;
  double t1007, t1009, t1011, t1012, tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0, t1014;
  double t1015, t1016, t1017, t1018, t1020, t1021, t1022, t1023;
  double t1025, t1027, t1028, tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20, t1030;
  double t1031, t1032, t1034, t1036, t1038, t1043, t1044, tv3tau30;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t8 = rho[0] * rho[0];
  t10 = 0.1e1 / t4 / t8;
  t13 = tau[0] * t6 - sigma[0] * t10 / 0.8e1;
  t14 = t2 * t13;
  t15 = M_CBRT6;
  t16 = t14 * t15;
  t17 = M_PI * M_PI;
  t18 = POW_1_3(t17);
  t19 = t18 * t18;
  t20 = 0.1e1 / t19;
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t23 = t20 * t22;
  t26 = t15 * t20 * t22;
  t29 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t13 * t26;
  t30 = 0.1e1 / t29;
  t31 = M_CBRT3;
  t32 = 0.1e1 / M_PI;
  t33 = POW_1_3(t32);
  t34 = t31 * t33;
  t35 = M_CBRT4;
  t36 = t35 * t35;
  t39 = t34 * t36 / t3;
  t41 = 0.1e1 + 0.53425e-1 * t39;
  t42 = sqrt(t39);
  t45 = POW_3_2(t39);
  t47 = t31 * t31;
  t48 = t33 * t33;
  t49 = t47 * t48;
  t52 = t49 * t35 / t4;
  t54 = 0.379785e1 * t42 + 0.8969e0 * t39 + 0.204775e0 * t45 + 0.123235e0 * t52;
  t57 = 0.1e1 + 0.16081979498692535067e2 / t54;
  t58 = log(t57);
  t62 = POW_1_3(p->zeta_threshold);
  t64 = my_piecewise3(0.1e1 <= p->zeta_threshold, t62 * p->zeta_threshold, 1);
  t70 = (0.2e1 * t64 - 0.2e1) / (0.2e1 * t21 - 0.2e1);
  t72 = 0.1e1 + 0.278125e-1 * t39;
  t77 = 0.51785e1 * t42 + 0.905775e0 * t39 + 0.1100325e0 * t45 + 0.1241775e0 * t52;
  t80 = 0.1e1 + 0.29608749977793437516e2 / t77;
  t81 = log(t80);
  t85 = -0.621814e-1 * t41 * t58 + 0.19751673498613801407e-1 * t70 * t72 * t81;
  t87 = t23 * t30 * t85;
  t89 = 0.5e1 / 0.9e1 * t16 * t87;
  t90 = t23 * t30;
  t93 = 0.1e1 - 0.5e1 / 0.9e1 * t16 * t90;
  t94 = t93 * t85;
  tzk0 = t89 + t94;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t97 = t8 * rho[0];
  t99 = 0.1e1 / t4 / t97;
  t102 = -0.5e1 / 0.3e1 * tau[0] * t10 + sigma[0] * t99 / 0.3e1;
  t103 = t2 * t102;
  t104 = t103 * t15;
  t105 = t104 * t87;
  t107 = t15 * t15;
  t109 = 0.1e1 / t18 / t17;
  t110 = t107 * t109;
  t111 = t14 * t110;
  t112 = t29 * t29;
  t113 = 0.1e1 / t112;
  t114 = t21 * t113;
  t115 = t85 * params->c;
  t117 = t114 * t115 * t102;
  t118 = t111 * t117;
  t121 = 0.1e1 / t3 / rho[0];
  t122 = t36 * t121;
  t126 = t54 * t54;
  t127 = 0.1e1 / t126;
  t128 = t41 * t127;
  t130 = 0.1e1 / t42 * t31;
  t131 = t33 * t36;
  t132 = t131 * t121;
  t133 = t130 * t132;
  t135 = t34 * t122;
  t137 = sqrt(t39);
  t138 = t137 * t31;
  t139 = t138 * t132;
  t142 = t49 * t35 * t6;
  t144 = -0.632975e0 * t133 - 0.29896666666666666667e0 * t135 - 0.1023875e0 * t139 - 0.82156666666666666667e-1 * t142;
  t145 = 0.1e1 / t57;
  t146 = t144 * t145;
  t149 = t70 * t31;
  t154 = t70 * t72;
  t155 = t77 * t77;
  t156 = 0.1e1 / t155;
  t161 = -0.86308333333333333334e0 * t133 - 0.301925e0 * t135 - 0.5501625e-1 * t139 - 0.82785e-1 * t142;
  t163 = 0.1e1 / t80;
  t164 = t156 * t161 * t163;
  t167 = 0.11073470983333333333e-2 * t34 * t122 * t58 + 0.1e1 * t128 * t146 - 0.18311447306006545054e-3 * t149 * t131 * t121 * t81 - 0.5848223622634646207e0 * t154 * t164;
  t169 = t23 * t30 * t167;
  t170 = t16 * t169;
  t175 = t114 * params->c * t102;
  t178 = -0.5e1 / 0.9e1 * t104 * t90 + 0.5e2 / 0.81e2 * t111 * t175;
  t179 = t178 * t85;
  t180 = t93 * t167;
  tvrho0 = t89 + t94 + rho[0] * (0.5e1 / 0.9e1 * t105 - 0.5e2 / 0.81e2 * t118 + 0.5e1 / 0.9e1 * t170 + t179 + t180);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t183 = t2 * t10;
  t184 = t183 * t15;
  t185 = t184 * t87;
  t186 = 0.5e1 / 0.72e2 * t185;
  t189 = t111 * t114 * t115 * t10;
  t190 = 0.25e2 / 0.324e3 * t189;
  t191 = t184 * t90;
  t195 = t111 * t114 * params->c * t10;
  t197 = 0.5e1 / 0.72e2 * t191 - 0.25e2 / 0.324e3 * t195;
  t198 = t197 * t85;
  tvsigma0 = rho[0] * (-t186 + t190 + t198);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t200 = t2 * t6;
  t201 = t200 * t15;
  t203 = 0.5e1 / 0.9e1 * t201 * t87;
  t207 = 0.5e2 / 0.81e2 * t111 * t114 * t115 * t6;
  t214 = -0.5e1 / 0.9e1 * t201 * t90 + 0.5e2 / 0.81e2 * t111 * t114 * params->c * t6;
  t215 = t214 * t85;
  tvtau0 = rho[0] * (t203 - t207 + t215);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t224 = t8 * t8;
  t226 = 0.1e1 / t4 / t224;
  t229 = 0.4e2 / 0.9e1 * tau[0] * t99 - 0.11e2 / 0.9e1 * sigma[0] * t226;
  t230 = t2 * t229;
  t231 = t230 * t15;
  t232 = t231 * t87;
  t234 = t102 * t102;
  t235 = t2 * t234;
  t236 = t235 * t110;
  t237 = t114 * t115;
  t238 = t236 * t237;
  t240 = t104 * t169;
  t242 = t17 * t17;
  t243 = 0.1e1 / t242;
  t244 = t14 * t243;
  t246 = 0.1e1 / t112 / t29;
  t247 = t246 * t85;
  t248 = params->c * params->c;
  t249 = t248 * t234;
  t250 = t247 * t249;
  t251 = t244 * t250;
  t253 = t167 * params->c;
  t255 = t114 * t253 * t102;
  t256 = t111 * t255;
  t259 = t114 * t115 * t229;
  t260 = t111 * t259;
  t263 = 0.1e1 / t3 / t8;
  t264 = t36 * t263;
  t268 = t34 * t36;
  t269 = t121 * t127;
  t273 = t126 * t54;
  t274 = 0.1e1 / t273;
  t275 = t41 * t274;
  t276 = t144 * t144;
  t277 = t276 * t145;
  t282 = 0.1e1 / t42 / t39 * t47;
  t283 = t48 * t35;
  t284 = t283 * t10;
  t285 = t282 * t284;
  t287 = t131 * t263;
  t288 = t130 * t287;
  t290 = t34 * t264;
  t292 = 0.1e1/sqrt(t39);
  t293 = t292 * t47;
  t294 = t293 * t284;
  t296 = t138 * t287;
  t299 = t49 * t35 * t10;
  t301 = -0.42198333333333333333e0 * t285 + 0.84396666666666666666e0 * t288 + 0.39862222222222222223e0 * t290 + 0.68258333333333333333e-1 * t294 + 0.13651666666666666667e0 * t296 + 0.13692777777777777778e0 * t299;
  t302 = t301 * t145;
  t305 = t126 * t126;
  t306 = 0.1e1 / t305;
  t307 = t41 * t306;
  t308 = t57 * t57;
  t309 = 0.1e1 / t308;
  t310 = t276 * t309;
  t317 = t70 * t34;
  t321 = t155 * t77;
  t322 = 0.1e1 / t321;
  t323 = t161 * t161;
  t325 = t322 * t323 * t163;
  t334 = -0.57538888888888888889e0 * t285 + 0.11507777777777777778e1 * t288 + 0.40256666666666666667e0 * t290 + 0.366775e-1 * t294 + 0.73355e-1 * t296 + 0.137975e0 * t299;
  t336 = t156 * t334 * t163;
  t339 = t155 * t155;
  t340 = 0.1e1 / t339;
  t341 = t340 * t323;
  t342 = t80 * t80;
  t343 = 0.1e1 / t342;
  t344 = t341 * t343;
  t347 = -0.14764627977777777777e-2 * t34 * t264 * t58 - 0.35616666666666666666e-1 * t268 * t269 * t146 - 0.2e1 * t275 * t277 + 0.1e1 * t128 * t302 + 0.16081979498692535067e2 * t307 * t310 + 0.24415263074675393405e-3 * t149 * t131 * t263 * t81 + 0.10843581300301739842e-1 * t317 * t122 * t164 + 0.11696447245269292414e1 * t154 * t325 - 0.5848223622634646207e0 * t154 * t336 - 0.17315859105681463759e2 * t154 * t344;
  t349 = t23 * t30 * t347;
  t350 = t16 * t349;
  t355 = t109 * t21;
  t357 = t355 * t113 * params->c;
  t360 = t246 * t248;
  t361 = t360 * t234;
  t365 = t114 * params->c * t229;
  t368 = -0.5e1 / 0.9e1 * t231 * t90 + 0.1e3 / 0.81e2 * t235 * t107 * t357 - 0.2e4 / 0.243e3 * t244 * t361 + 0.5e2 / 0.81e2 * t111 * t365;
  t369 = t368 * t85;
  t370 = t178 * t167;
  t372 = t93 * t347;
  tv2rho20 = 0.1e2 / 0.9e1 * t105 - 0.1e3 / 0.81e2 * t118 + 0.1e2 / 0.9e1 * t170 + 0.2e1 * t179 + 0.2e1 * t180 + rho[0] * (0.5e1 / 0.9e1 * t232 - 0.1e3 / 0.81e2 * t238 + 0.1e2 / 0.9e1 * t240 + 0.2e4 / 0.243e3 * t251 - 0.1e3 / 0.81e2 * t256 - 0.5e2 / 0.81e2 * t260 + 0.5e1 / 0.9e1 * t350 + t369 + 0.2e1 * t370 + t372);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t375 = t2 * t99;
  t376 = t375 * t15;
  t377 = t376 * t87;
  t379 = t183 * t110;
  t380 = t379 * t117;
  t382 = t184 * t169;
  t384 = t243 * t246;
  t385 = t14 * t384;
  t386 = t85 * t248;
  t387 = t10 * t102;
  t389 = t385 * t386 * t387;
  t393 = t111 * t114 * t253 * t10;
  t397 = t111 * t114 * t115 * t99;
  t399 = t376 * t90;
  t401 = t379 * t175;
  t404 = t244 * t360 * t387;
  t408 = t111 * t114 * params->c * t99;
  t410 = -0.5e1 / 0.27e2 * t399 - 0.25e2 / 0.162e3 * t401 + 0.25e3 / 0.243e3 * t404 + 0.5e2 / 0.243e3 * t408;
  t411 = t410 * t85;
  t412 = t197 * t167;
  tv2rhosigma0 = -t186 + t190 + t198 + rho[0] * (0.5e1 / 0.27e2 * t377 + 0.25e2 / 0.162e3 * t380 - 0.5e1 / 0.72e2 * t382 - 0.25e3 / 0.243e3 * t389 + 0.25e2 / 0.324e3 * t393 - 0.5e2 / 0.243e3 * t397 + t411 + t412);

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t416 = t200 * t110;
  t417 = t416 * t117;
  t419 = t201 * t169;
  t421 = t6 * t102;
  t423 = t385 * t386 * t421;
  t427 = t111 * t114 * t253 * t6;
  t437 = 0.25e2 / 0.27e2 * t191 + 0.1e3 / 0.81e2 * t416 * t175 - 0.2e4 / 0.243e3 * t244 * t360 * t421 - 0.25e3 / 0.243e3 * t195;
  t438 = t437 * t85;
  t439 = t214 * t167;
  tv2rhotau0 = t203 - t207 + t215 + rho[0] * (-0.25e2 / 0.27e2 * t185 - 0.1e3 / 0.81e2 * t417 + 0.5e1 / 0.9e1 * t419 + 0.2e4 / 0.243e3 * t423 - 0.5e2 / 0.81e2 * t427 + 0.25e3 / 0.243e3 * t189 + t438 + t439);

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t442 = t224 * rho[0];
  t444 = 0.1e1 / t3 / t442;
  t445 = t2 * t444;
  t446 = t445 * t110;
  t447 = t446 * t237;
  t448 = 0.25e2 / 0.1296e4 * t447;
  t449 = t248 * t444;
  t451 = t244 * t247 * t449;
  t452 = 0.125e3 / 0.972e3 * t451;
  t454 = t445 * t107 * t357;
  t457 = t244 * t360 * t444;
  t459 = 0.25e2 / 0.1296e4 * t454 - 0.125e3 / 0.972e3 * t457;
  t460 = t459 * t85;
  tv2sigma20 = rho[0] * (-t448 + t452 + t460);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t463 = 0.1e1 / t3 / t224;
  t464 = t2 * t463;
  t465 = t464 * t110;
  t466 = t465 * t237;
  t467 = 0.25e2 / 0.162e3 * t466;
  t468 = t248 * t463;
  t470 = t244 * t247 * t468;
  t471 = 0.25e3 / 0.243e3 * t470;
  t473 = t464 * t107 * t357;
  t476 = t244 * t360 * t463;
  t478 = -0.25e2 / 0.162e3 * t473 + 0.25e3 / 0.243e3 * t476;
  t479 = t478 * t85;
  tv2sigmatau0 = rho[0] * (t467 - t471 + t479);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t482 = 0.1e1 / t3 / t97;
  t483 = t2 * t482;
  t484 = t483 * t110;
  t486 = 0.1e3 / 0.81e2 * t484 * t237;
  t487 = t248 * t482;
  t490 = 0.2e4 / 0.243e3 * t244 * t247 * t487;
  t497 = 0.1e3 / 0.81e2 * t483 * t107 * t357 - 0.2e4 / 0.243e3 * t244 * t360 * t482;
  t498 = t497 * t85;
  tv2tau20 = rho[0] * (-t486 + t490 + t498);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t501 = 0.1e1 / t305 / t126;
  t502 = t41 * t501;
  t503 = t276 * t144;
  t505 = 0.1e1 / t308 / t57;
  t506 = t503 * t505;
  t510 = 0.1e1 / t305 / t54;
  t511 = t41 * t510;
  t512 = t503 * t309;
  t518 = 0.1e1 / t42 / t52 * t32 / 0.4e1;
  t519 = 0.1e1 / t224;
  t520 = t518 * t519;
  t522 = t283 * t99;
  t523 = t282 * t522;
  t525 = t131 * t482;
  t526 = t130 * t525;
  t528 = t36 * t482;
  t529 = t34 * t528;
  t531 = 0.1e1/POW_3_2(t39);
  t532 = t531 * t32;
  t533 = t532 * t519;
  t535 = t293 * t522;
  t537 = t138 * t525;
  t540 = t49 * t35 * t99;
  t542 = -0.25319e1 * t520 + 0.16879333333333333333e1 * t523 - 0.19692555555555555555e1 * t526 - 0.93011851851851851854e0 * t529 + 0.13651666666666666667e0 * t533 - 0.27303333333333333333e0 * t535 - 0.3185388888888888889e0 * t537 - 0.36514074074074074075e0 * t540;
  t543 = t542 * t145;
  t547 = 0.1e1 / t339 / t155;
  t548 = t323 * t161;
  t551 = 0.1e1 / t342 / t80;
  t552 = t547 * t548 * t551;
  t563 = -0.34523333333333333333e1 * t520 + 0.23015555555555555556e1 * t523 - 0.26851481481481481482e1 * t526 - 0.93932222222222222223e0 * t529 + 0.73355e-1 * t533 - 0.14671e0 * t535 - 0.17116166666666666667e0 * t537 - 0.36793333333333333333e0 * t540;
  t565 = t156 * t563 * t163;
  t569 = 0.1e1 / t339 / t77;
  t571 = t569 * t548 * t343;
  t581 = t503 * t145;
  t588 = t343 * t161;
  t592 = 0.51726012919273400301e3 * t502 * t506 - 0.96491876992155210402e2 * t511 * t512 + 0.1e1 * t128 * t543 - 0.10254018858216406658e4 * t154 * t552 - 0.5848223622634646207e0 * t154 * t565 + 0.10389515463408878255e3 * t154 * t571 + 0.34450798614814814813e-2 * t34 * t528 * t58 + 0.48245938496077605201e2 * t307 * t301 * t309 * t144 + 0.6e1 * t307 * t581 - 0.6e1 * t275 * t146 * t301 - 0.51947577317044391277e2 * t154 * t340 * t334 * t588;
  t594 = t340 * t548 * t163;
  t598 = t163 * t334;
  t602 = t121 * t306;
  t606 = t263 * t127;
  t633 = -0.35089341735807877242e1 * t154 * t594 + 0.35089341735807877242e1 * t154 * t322 * t161 * t598 - 0.85917975471764868594e0 * t268 * t602 * t310 + 0.71233333333333333332e-1 * t268 * t606 * t146 - 0.53424999999999999999e-1 * t268 * t269 * t302 + 0.10685e0 * t268 * t121 * t274 * t277 - 0.56968947174242584612e-3 * t149 * t131 * t482 * t81 - 0.32530743900905219526e-1 * t317 * t122 * t325 - 0.21687162600603479684e-1 * t317 * t264 * t164 + 0.16265371950452609763e-1 * t317 * t122 * t336 + 0.48159733137676571078e0 * t317 * t122 * t344;
  t634 = t592 + t633;
  t635 = t93 * t634;
  t636 = t178 * t347;
  t641 = 0.1e1 / t4 / t442;
  t644 = -0.44e3 / 0.27e2 * tau[0] * t226 + 0.154e3 / 0.27e2 * sigma[0] * t641;
  t645 = t2 * t644;
  t646 = t645 * t15;
  t649 = t230 * t110;
  t652 = t234 * t102;
  t653 = t2 * t652;
  t654 = t384 * t248;
  t657 = t112 * t112;
  t658 = 0.1e1 / t657;
  t659 = t243 * t658;
  t660 = t14 * t659;
  t661 = t248 * params->c;
  t663 = t661 * t652 * t26;
  t666 = t102 * t229;
  t667 = t360 * t666;
  t671 = t114 * params->c * t644;
  t674 = -0.5e1 / 0.9e1 * t646 * t90 + 0.1e3 / 0.27e2 * t649 * t175 - 0.2e4 / 0.81e2 * t653 * t654 + 0.1e5 / 0.729e3 * t660 * t663 - 0.2e4 / 0.81e2 * t244 * t667 + 0.5e2 / 0.81e2 * t111 * t671;
  t675 = t674 * t85;
  t676 = t368 * t167;
  t678 = t653 * t243;
  t679 = t247 * t248;
  t680 = t678 * t679;
  t683 = t23 * t30 * t634;
  t684 = t16 * t683;
  t686 = t246 * t167;
  t687 = t686 * t249;
  t688 = t244 * t687;
  t690 = t646 * t87;
  t692 = t231 * t169;
  t694 = t104 * t349;
  t696 = t114 * t253;
  t697 = t236 * t696;
  t699 = t386 * t666;
  t700 = t385 * t699;
  t702 = t659 * t85;
  t703 = t14 * t702;
  t704 = t703 * t663;
  t707 = t114 * t253 * t229;
  t708 = t111 * t707;
  t711 = t114 * t115 * t644;
  t712 = t111 * t711;
  t714 = t649 * t117;
  t716 = t347 * params->c;
  t718 = t114 * t716 * t102;
  t719 = t111 * t718;
  t721 = t635 + 0.3e1 * t636 + t675 + 0.3e1 * t676 + 0.2e4 / 0.81e2 * t680 + 0.5e1 / 0.9e1 * t684 + 0.2e4 / 0.81e2 * t688 + 0.5e1 / 0.9e1 * t690 + 0.5e1 / 0.3e1 * t692 + 0.5e1 / 0.3e1 * t694 - 0.1e3 / 0.27e2 * t697 + 0.2e4 / 0.81e2 * t700 - 0.1e5 / 0.729e3 * t704 - 0.5e2 / 0.27e2 * t708 - 0.5e2 / 0.81e2 * t712 - 0.1e3 / 0.27e2 * t714 - 0.5e2 / 0.27e2 * t719;
  tv3rho30 = rho[0] * t721 - 0.1e3 / 0.27e2 * t256 - 0.5e2 / 0.27e2 * t260 + 0.3e1 * t372 + 0.3e1 * t369 + 0.6e1 * t370 + 0.5e1 / 0.3e1 * t232 + 0.1e2 / 0.3e1 * t240 + 0.2e4 / 0.81e2 * t251 + 0.5e1 / 0.3e1 * t350 - 0.1e3 / 0.27e2 * t238;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t741 = t197 * t347;
  t742 = t2 * t226;
  t743 = t742 * t15;
  t744 = t743 * t90;
  t746 = t375 * t110;
  t747 = t746 * t175;
  t749 = t183 * t243;
  t750 = t749 * t361;
  t752 = t379 * t365;
  t755 = t14 * t659 * t661;
  t758 = t755 * t10 * t234 * t26;
  t760 = t99 * t102;
  t762 = t244 * t360 * t760;
  t764 = t10 * t229;
  t766 = t244 * t360 * t764;
  t770 = t111 * t114 * params->c * t226;
  t772 = 0.55e2 / 0.81e2 * t744 + 0.2e3 / 0.243e3 * t747 + 0.25e3 / 0.81e2 * t750 - 0.25e2 / 0.162e3 * t752 - 0.125e4 / 0.729e3 * t758 - 0.4e4 / 0.729e3 * t762 + 0.25e3 / 0.243e3 * t766 - 0.55e3 / 0.729e3 * t770;
  t773 = t772 * t85;
  t774 = t410 * t167;
  t776 = t376 * t169;
  t778 = t749 * t250;
  t780 = t184 * t349;
  t784 = t661 * t10 * t234 * t26;
  t785 = t703 * t784;
  t787 = t167 * t248;
  t789 = t385 * t787 * t387;
  t792 = t385 * t386 * t764;
  t794 = t743 * t87;
  t798 = t111 * t114 * t253 * t99;
  t802 = t111 * t114 * t115 * t226;
  t804 = t379 * t255;
  t806 = t379 * t259;
  t809 = t385 * t386 * t760;
  t813 = t111 * t114 * t716 * t10;
  t815 = t746 * t117;
  t817 = t741 + t773 + 0.2e1 * t774 + 0.1e2 / 0.27e2 * t776 - 0.25e3 / 0.81e2 * t778 - 0.5e1 / 0.72e2 * t780 + 0.125e4 / 0.729e3 * t785 - 0.5e3 / 0.243e3 * t789 - 0.25e3 / 0.243e3 * t792 - 0.55e2 / 0.81e2 * t794 - 0.1e3 / 0.243e3 * t798 + 0.55e3 / 0.729e3 * t802 + 0.25e2 / 0.81e2 * t804 + 0.25e2 / 0.162e3 * t806 + 0.4e4 / 0.729e3 * t809 + 0.25e2 / 0.324e3 * t813 - 0.2e3 / 0.243e3 * t815;
  tv3rho2sigma0 = 0.1e2 / 0.27e2 * t377 + 0.25e2 / 0.81e2 * t380 - 0.5e1 / 0.36e2 * t382 - 0.5e3 / 0.243e3 * t389 + 0.25e2 / 0.162e3 * t393 - 0.1e3 / 0.243e3 * t397 + 0.2e1 * t411 + 0.2e1 * t412 + rho[0] * t817;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t827 = t437 * t167;
  t829 = t214 * t347;
  t832 = t200 * t243;
  t842 = t6 * t229;
  t847 = -0.2e3 / 0.81e2 * t399 - 0.1e4 / 0.243e3 * t401 - 0.2e4 / 0.81e2 * t832 * t361 + 0.1e3 / 0.81e2 * t416 * t365 + 0.1e5 / 0.729e3 * t755 * t6 * t234 * t26 + 0.2e5 / 0.729e3 * t404 - 0.2e4 / 0.243e3 * t244 * t360 * t842 + 0.2e4 / 0.729e3 * t408;
  t848 = t847 * t85;
  t850 = t385 * t787 * t421;
  t852 = t386 * t842;
  t853 = t385 * t852;
  t855 = t832 * t250;
  t857 = t201 * t349;
  t861 = t661 * t6 * t234 * t26;
  t862 = t703 * t861;
  t868 = t111 * t114 * t716 * t6;
  t870 = t416 * t255;
  t872 = t416 * t259;
  t878 = 0.2e1 * t827 + t829 + t848 + 0.4e4 / 0.243e3 * t850 + 0.2e4 / 0.243e3 * t853 + 0.2e4 / 0.81e2 * t855 + 0.5e1 / 0.9e1 * t857 - 0.1e5 / 0.729e3 * t862 - 0.2e5 / 0.729e3 * t389 - 0.2e4 / 0.729e3 * t397 - 0.5e2 / 0.81e2 * t868 - 0.2e3 / 0.81e2 * t870 - 0.1e3 / 0.81e2 * t872 + 0.1e4 / 0.243e3 * t380 + 0.5e3 / 0.243e3 * t393 - 0.5e2 / 0.27e2 * t382 + 0.2e3 / 0.81e2 * t377;
  tv3rho2tau0 = -0.5e2 / 0.27e2 * t185 - 0.2e3 / 0.81e2 * t417 + 0.1e2 / 0.9e1 * t419 + 0.4e4 / 0.243e3 * t423 - 0.1e3 / 0.81e2 * t427 + 0.5e3 / 0.243e3 * t189 + 0.2e1 * t438 + 0.2e1 * t439 + rho[0] * t878;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t880 = t224 * t8;
  t882 = 0.1e1 / t3 / t880;
  t883 = t2 * t882;
  t884 = t883 * t110;
  t885 = t884 * t237;
  t887 = t445 * t243;
  t888 = t248 * t102;
  t889 = t247 * t888;
  t890 = t887 * t889;
  t892 = t446 * t696;
  t894 = t661 * t444;
  t896 = t894 * t102 * t26;
  t897 = t703 * t896;
  t900 = t244 * t686 * t449;
  t902 = t248 * t882;
  t904 = t244 * t247 * t902;
  t907 = t883 * t107 * t357;
  t909 = t360 * t102;
  t910 = t887 * t909;
  t914 = t755 * t444 * t102 * t26;
  t917 = t244 * t360 * t882;
  t919 = -0.25e2 / 0.243e3 * t907 - 0.125e3 / 0.324e3 * t910 + 0.625e3 / 0.2916e4 * t914 + 0.5e3 / 0.729e3 * t917;
  t920 = t919 * t85;
  t921 = t459 * t167;
  tv3rhosigma20 = -t448 + t452 + t460 + rho[0] * (0.25e2 / 0.243e3 * t885 + 0.125e3 / 0.324e3 * t890 - 0.25e2 / 0.1296e4 * t892 - 0.625e3 / 0.2916e4 * t897 + 0.125e3 / 0.972e3 * t900 - 0.5e3 / 0.729e3 * t904 + t920 + t921);

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t925 = t464 * t243;
  t926 = t925 * t889;
  t928 = t465 * t696;
  t930 = t661 * t463;
  t932 = t930 * t102 * t26;
  t933 = t703 * t932;
  t936 = t244 * t686 * t468;
  t940 = t925 * t909;
  t944 = t755 * t463 * t102 * t26;
  t947 = 0.325e3 / 0.486e3 * t454 + 0.25e3 / 0.81e2 * t940 - 0.125e4 / 0.729e3 * t944 - 0.325e4 / 0.729e3 * t457;
  t948 = t947 * t85;
  t949 = t478 * t167;
  tv3rhosigmatau0 = t467 - t471 + t479 + rho[0] * (-0.325e3 / 0.486e3 * t447 - 0.25e3 / 0.81e2 * t926 + 0.25e2 / 0.162e3 * t928 + 0.125e4 / 0.729e3 * t933 - 0.25e3 / 0.243e3 * t936 + 0.325e4 / 0.729e3 * t451 + t948 + t949);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t953 = t483 * t243;
  t954 = t953 * t889;
  t956 = t484 * t696;
  t958 = t661 * t482;
  t960 = t958 * t102 * t26;
  t961 = t703 * t960;
  t964 = t244 * t686 * t487;
  t975 = -0.1e4 / 0.243e3 * t473 - 0.2e4 / 0.81e2 * t953 * t909 + 0.1e5 / 0.729e3 * t755 * t482 * t102 * t26 + 0.2e5 / 0.729e3 * t476;
  t976 = t975 * t85;
  t977 = t497 * t167;
  tv3rhotau20 = -t486 + t490 + t498 + rho[0] * (0.1e4 / 0.243e3 * t466 + 0.2e4 / 0.81e2 * t954 - 0.1e3 / 0.81e2 * t956 - 0.1e5 / 0.729e3 * t961 + 0.2e4 / 0.243e3 * t964 - 0.2e5 / 0.729e3 * t470 + t976 + t977);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t980 = t224 * t224;
  t981 = 0.1e1 / t980;
  t982 = t2 * t981;
  t983 = t982 * t243;
  t984 = t983 * t679;
  t985 = 0.125e3 / 0.2592e4 * t984;
  t987 = t661 * t981 * t26;
  t988 = t703 * t987;
  t989 = 0.625e3 / 0.23328e5 * t988;
  t990 = t982 * t654;
  t992 = t660 * t987;
  t994 = 0.125e3 / 0.2592e4 * t990 - 0.625e3 / 0.23328e5 * t992;
  t995 = t994 * t85;
  tv3sigma30 = rho[0] * (-t985 + t989 + t995);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t997 = t224 * t97;
  t998 = 0.1e1 / t997;
  t999 = t2 * t998;
  t1000 = t999 * t243;
  t1001 = t1000 * t679;
  t1002 = 0.125e3 / 0.324e3 * t1001;
  t1004 = t661 * t998 * t26;
  t1005 = t703 * t1004;
  t1006 = 0.625e3 / 0.2916e4 * t1005;
  t1007 = t999 * t654;
  t1009 = t660 * t1004;
  t1011 = -0.125e3 / 0.324e3 * t1007 + 0.625e3 / 0.2916e4 * t1009;
  t1012 = t1011 * t85;
  tv3sigma2tau0 = rho[0] * (t1002 - t1006 + t1012);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1014 = 0.1e1 / t880;
  t1015 = t2 * t1014;
  t1016 = t1015 * t243;
  t1017 = t1016 * t679;
  t1018 = 0.25e3 / 0.81e2 * t1017;
  t1020 = t661 * t1014 * t26;
  t1021 = t703 * t1020;
  t1022 = 0.125e4 / 0.729e3 * t1021;
  t1023 = t1015 * t654;
  t1025 = t660 * t1020;
  t1027 = 0.25e3 / 0.81e2 * t1023 - 0.125e4 / 0.729e3 * t1025;
  t1028 = t1027 * t85;
  tv3sigmatau20 = rho[0] * (-t1018 + t1022 + t1028);

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1030 = 0.1e1 / t442;
  t1031 = t2 * t1030;
  t1032 = t1031 * t243;
  t1034 = 0.2e4 / 0.81e2 * t1032 * t679;
  t1036 = t661 * t1030 * t26;
  t1038 = 0.1e5 / 0.729e3 * t703 * t1036;
  t1043 = -0.2e4 / 0.81e2 * t1031 * t654 + 0.1e5 / 0.729e3 * t660 * t1036;
  t1044 = t1043 * t85;
  tv3tau30 = rho[0] * (t1034 - t1038 + t1044);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t8, t10, t13, t14;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t26, t29, t30, t31, t32, t33, t34;
  double t35, t36, t39, t41, t42, t45, t47, t48;
  double t49, t52, t54, t57, t58, t62, t64, t70;
  double t72, t77, t80, t81, t85, t87, t89, t90;
  double t93, t94, tzk0;

  double t97, t99, t102, t103, t104, t105, t107, t109;
  double t110, t111, t112, t113, t114, t115, t117, t118;
  double t121, t122, t126, t127, t128, t130, t131, t132;
  double t133, t135, t137, t138, t139, t142, t144, t145;
  double t146, t149, t154, t155, t156, t161, t163, t164;
  double t167, t169, t170, t175, t178, t179, t180, tvrho0;
  double t183, t184, t185, t186, t189, t190, t191, t195;
  double t197, t198, tvsigma0, tvlapl0, t200, t201, t203, t207;
  double t214, t215, tvtau0;

  double t224, t226, t229, t230, t231, t232, t234, t235;
  double t236, t237, t238, t240, t242, t243, t244, t246;
  double t247, t248, t249, t250, t251, t253, t255, t256;
  double t259, t260, t263, t264, t268, t269, t273, t274;
  double t275, t276, t277, t282, t283, t284, t285, t287;
  double t288, t290, t292, t293, t294, t296, t299, t301;
  double t302, t305, t306, t307, t308, t309, t310, t317;
  double t321, t322, t323, t325, t334, t336, t339, t340;
  double t341, t342, t343, t344, t347, t349, t350, t355;
  double t357, t360, t361, t365, t368, t369, t370, t372;
  double tv2rho20, t375, t376, t377, t379, t380, t382, t384;
  double t385, t386, t387, t389, t393, t397, t399, t401;
  double t404, t408, t410, t411, t412, tv2rhosigma0, tv2rholapl0, t416;
  double t417, t419, t421, t423, t427, t437, t438, t439;
  double tv2rhotau0, t442, t444, t445, t446, t447, t448, t449;
  double t451, t452, t454, t457, t459, t460, tv2sigma20, tv2sigmalapl0;
  double t463, t464, t465, t466, t467, t468, t470, t471;
  double t473, t476, t478, t479, tv2sigmatau0, tv2lapl20, tv2lapltau0, t482;
  double t483, t484, t486, t487, t490, t497, t498, tv2tau20;

  double t501, t502, t503, t505, t506, t510, t511, t512;
  double t518, t519, t520, t522, t523, t525, t526, t528;
  double t529, t531, t532, t533, t535, t537, t540, t542;
  double t543, t547, t548, t551, t552, t563, t565, t569;
  double t571, t581, t588, t592, t594, t598, t602, t606;
  double t633, t634, t635, t636, t641, t644, t645, t646;
  double t649, t652, t653, t654, t657, t658, t659, t660;
  double t661, t663, t666, t667, t671, t674, t675, t676;
  double t678, t679, t680, t683, t684, t686, t687, t688;
  double t690, t692, t694, t696, t697, t699, t700, t702;
  double t703, t704, t707, t708, t711, t712, t714, t716;
  double t718, t719, t721, tv3rho30, t741, t742, t743, t744;
  double t746, t747, t749, t750, t752, t755, t758, t760;
  double t762, t764, t766, t770, t772, t773, t774, t776;
  double t778, t780, t784, t785, t787, t789, t792, t794;
  double t798, t802, t804, t806, t809, t813, t815, t817;
  double tv3rho2sigma0, tv3rho2lapl0, t827, t829, t832, t842, t847, t848;
  double t850, t852, t853, t855, t857, t861, t862, t868;
  double t870, t872, t878, tv3rho2tau0, t880, t882, t883, t884;
  double t885, t887, t888, t889, t890, t892, t894, t896;
  double t897, t900, t902, t904, t907, t909, t910, t914;
  double t917, t919, t920, t921, tv3rhosigma20, tv3rhosigmalapl0, t925, t926;
  double t928, t930, t932, t933, t936, t940, t944, t947;
  double t948, t949, tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, t953, t954, t956;
  double t958, t960, t961, t964, t975, t976, t977, tv3rhotau20;
  double t980, t981, t982, t983, t984, t985, t987, t988;
  double t989, t990, t992, t994, t995, tv3sigma30, tv3sigma2lapl0, t997;
  double t998, t999, t1000, t1001, t1002, t1004, t1005, t1006;
  double t1007, t1009, t1011, t1012, tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0, t1014;
  double t1015, t1016, t1017, t1018, t1020, t1021, t1022, t1023;
  double t1025, t1027, t1028, tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20, t1030;
  double t1031, t1032, t1034, t1036, t1038, t1043, t1044, tv3tau30;

  double t1058, t1060, t1061, t1062, t1064, t1065, t1069, t1077;
  double t1081, t1103, t1105, t1107, t1108, t1110, t1111, t1113;
  double t1114, t1116, t1119, t1121, t1123, t1125, t1128, t1135;
  double t1137, t1139, t1144, t1146, t1152, t1171, t1182, t1222;
  double t1255, t1262, t1266, t1290, t1293, t1322, t1324, t1326;
  double t1339, t1343, t1344, t1346, t1352, t1355, t1357, t1360;
  double t1369, t1375, t1380, t1382, t1385, t1389, t1405, t1423;
  double t1431, t1438, tv4rho40, t1457, t1467, t1471, t1478, t1492;
  double t1496, t1501, t1503, t1506, t1507, t1536, t1548, t1593;
  double tv4rho3sigma0, tv4rho3lapl0, t1626, t1649, t1662, t1677, t1703, tv4rho3tau0;
  double t1725, t1729, t1730, t1749, t1755, t1782, t1803, tv4rho2sigma20;
  double tv4rho2sigmalapl0, t1864, tv4rho2sigmatau0, tv4rho2lapl20, tv4rho2lapltau0, t1925, tv4rho2tau20, t1927;
  double t1928, t1929, t1935, t1942, t1949, tv4rhosigma30, tv4rhosigma2lapl0, tv4rhosigma2tau0;
  double tv4rhosigmalapl20, tv4rhosigmalapltau0, tv4rhosigmatau20, tv4rholapl30, tv4rholapl2tau0, tv4rholapltau20, tv4rhotau30, t2054;
  double t2056, t2060, tv4sigma40, tv4sigma3lapl0, t2071, t2073, t2077, tv4sigma3tau0;
  double tv4sigma2lapl20, tv4sigma2lapltau0, t2088, t2090, t2094, tv4sigma2tau20, tv4sigmalapl30, tv4sigmalapl2tau0;
  double tv4sigmalapltau20, t2105, t2107, t2111, tv4sigmatau30, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20;
  double tv4lapltau30, t2122, t2126, tv4tau40;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t8 = rho[0] * rho[0];
  t10 = 0.1e1 / t4 / t8;
  t13 = tau[0] * t6 - sigma[0] * t10 / 0.8e1;
  t14 = t2 * t13;
  t15 = M_CBRT6;
  t16 = t14 * t15;
  t17 = M_PI * M_PI;
  t18 = POW_1_3(t17);
  t19 = t18 * t18;
  t20 = 0.1e1 / t19;
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t23 = t20 * t22;
  t26 = t15 * t20 * t22;
  t29 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t13 * t26;
  t30 = 0.1e1 / t29;
  t31 = M_CBRT3;
  t32 = 0.1e1 / M_PI;
  t33 = POW_1_3(t32);
  t34 = t31 * t33;
  t35 = M_CBRT4;
  t36 = t35 * t35;
  t39 = t34 * t36 / t3;
  t41 = 0.1e1 + 0.53425e-1 * t39;
  t42 = sqrt(t39);
  t45 = POW_3_2(t39);
  t47 = t31 * t31;
  t48 = t33 * t33;
  t49 = t47 * t48;
  t52 = t49 * t35 / t4;
  t54 = 0.379785e1 * t42 + 0.8969e0 * t39 + 0.204775e0 * t45 + 0.123235e0 * t52;
  t57 = 0.1e1 + 0.16081979498692535067e2 / t54;
  t58 = log(t57);
  t62 = POW_1_3(p->zeta_threshold);
  t64 = my_piecewise3(0.1e1 <= p->zeta_threshold, t62 * p->zeta_threshold, 1);
  t70 = (0.2e1 * t64 - 0.2e1) / (0.2e1 * t21 - 0.2e1);
  t72 = 0.1e1 + 0.278125e-1 * t39;
  t77 = 0.51785e1 * t42 + 0.905775e0 * t39 + 0.1100325e0 * t45 + 0.1241775e0 * t52;
  t80 = 0.1e1 + 0.29608749977793437516e2 / t77;
  t81 = log(t80);
  t85 = -0.621814e-1 * t41 * t58 + 0.19751673498613801407e-1 * t70 * t72 * t81;
  t87 = t23 * t30 * t85;
  t89 = 0.5e1 / 0.9e1 * t16 * t87;
  t90 = t23 * t30;
  t93 = 0.1e1 - 0.5e1 / 0.9e1 * t16 * t90;
  t94 = t93 * t85;
  tzk0 = t89 + t94;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t97 = t8 * rho[0];
  t99 = 0.1e1 / t4 / t97;
  t102 = -0.5e1 / 0.3e1 * tau[0] * t10 + sigma[0] * t99 / 0.3e1;
  t103 = t2 * t102;
  t104 = t103 * t15;
  t105 = t104 * t87;
  t107 = t15 * t15;
  t109 = 0.1e1 / t18 / t17;
  t110 = t107 * t109;
  t111 = t14 * t110;
  t112 = t29 * t29;
  t113 = 0.1e1 / t112;
  t114 = t21 * t113;
  t115 = t85 * params->c;
  t117 = t114 * t115 * t102;
  t118 = t111 * t117;
  t121 = 0.1e1 / t3 / rho[0];
  t122 = t36 * t121;
  t126 = t54 * t54;
  t127 = 0.1e1 / t126;
  t128 = t41 * t127;
  t130 = 0.1e1 / t42 * t31;
  t131 = t33 * t36;
  t132 = t131 * t121;
  t133 = t130 * t132;
  t135 = t34 * t122;
  t137 = sqrt(t39);
  t138 = t137 * t31;
  t139 = t138 * t132;
  t142 = t49 * t35 * t6;
  t144 = -0.632975e0 * t133 - 0.29896666666666666667e0 * t135 - 0.1023875e0 * t139 - 0.82156666666666666667e-1 * t142;
  t145 = 0.1e1 / t57;
  t146 = t144 * t145;
  t149 = t70 * t31;
  t154 = t70 * t72;
  t155 = t77 * t77;
  t156 = 0.1e1 / t155;
  t161 = -0.86308333333333333334e0 * t133 - 0.301925e0 * t135 - 0.5501625e-1 * t139 - 0.82785e-1 * t142;
  t163 = 0.1e1 / t80;
  t164 = t156 * t161 * t163;
  t167 = 0.11073470983333333333e-2 * t34 * t122 * t58 + 0.1e1 * t128 * t146 - 0.18311447306006545054e-3 * t149 * t131 * t121 * t81 - 0.5848223622634646207e0 * t154 * t164;
  t169 = t23 * t30 * t167;
  t170 = t16 * t169;
  t175 = t114 * params->c * t102;
  t178 = -0.5e1 / 0.9e1 * t104 * t90 + 0.5e2 / 0.81e2 * t111 * t175;
  t179 = t178 * t85;
  t180 = t93 * t167;
  tvrho0 = t89 + t94 + rho[0] * (0.5e1 / 0.9e1 * t105 - 0.5e2 / 0.81e2 * t118 + 0.5e1 / 0.9e1 * t170 + t179 + t180);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t183 = t2 * t10;
  t184 = t183 * t15;
  t185 = t184 * t87;
  t186 = 0.5e1 / 0.72e2 * t185;
  t189 = t111 * t114 * t115 * t10;
  t190 = 0.25e2 / 0.324e3 * t189;
  t191 = t184 * t90;
  t195 = t111 * t114 * params->c * t10;
  t197 = 0.5e1 / 0.72e2 * t191 - 0.25e2 / 0.324e3 * t195;
  t198 = t197 * t85;
  tvsigma0 = rho[0] * (-t186 + t190 + t198);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t200 = t2 * t6;
  t201 = t200 * t15;
  t203 = 0.5e1 / 0.9e1 * t201 * t87;
  t207 = 0.5e2 / 0.81e2 * t111 * t114 * t115 * t6;
  t214 = -0.5e1 / 0.9e1 * t201 * t90 + 0.5e2 / 0.81e2 * t111 * t114 * params->c * t6;
  t215 = t214 * t85;
  tvtau0 = rho[0] * (t203 - t207 + t215);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t224 = t8 * t8;
  t226 = 0.1e1 / t4 / t224;
  t229 = 0.4e2 / 0.9e1 * tau[0] * t99 - 0.11e2 / 0.9e1 * sigma[0] * t226;
  t230 = t2 * t229;
  t231 = t230 * t15;
  t232 = t231 * t87;
  t234 = t102 * t102;
  t235 = t2 * t234;
  t236 = t235 * t110;
  t237 = t114 * t115;
  t238 = t236 * t237;
  t240 = t104 * t169;
  t242 = t17 * t17;
  t243 = 0.1e1 / t242;
  t244 = t14 * t243;
  t246 = 0.1e1 / t112 / t29;
  t247 = t246 * t85;
  t248 = params->c * params->c;
  t249 = t248 * t234;
  t250 = t247 * t249;
  t251 = t244 * t250;
  t253 = t167 * params->c;
  t255 = t114 * t253 * t102;
  t256 = t111 * t255;
  t259 = t114 * t115 * t229;
  t260 = t111 * t259;
  t263 = 0.1e1 / t3 / t8;
  t264 = t36 * t263;
  t268 = t34 * t36;
  t269 = t121 * t127;
  t273 = t126 * t54;
  t274 = 0.1e1 / t273;
  t275 = t41 * t274;
  t276 = t144 * t144;
  t277 = t276 * t145;
  t282 = 0.1e1 / t42 / t39 * t47;
  t283 = t48 * t35;
  t284 = t283 * t10;
  t285 = t282 * t284;
  t287 = t131 * t263;
  t288 = t130 * t287;
  t290 = t34 * t264;
  t292 = 0.1e1/sqrt(t39);
  t293 = t292 * t47;
  t294 = t293 * t284;
  t296 = t138 * t287;
  t299 = t49 * t35 * t10;
  t301 = -0.42198333333333333333e0 * t285 + 0.84396666666666666666e0 * t288 + 0.39862222222222222223e0 * t290 + 0.68258333333333333333e-1 * t294 + 0.13651666666666666667e0 * t296 + 0.13692777777777777778e0 * t299;
  t302 = t301 * t145;
  t305 = t126 * t126;
  t306 = 0.1e1 / t305;
  t307 = t41 * t306;
  t308 = t57 * t57;
  t309 = 0.1e1 / t308;
  t310 = t276 * t309;
  t317 = t70 * t34;
  t321 = t155 * t77;
  t322 = 0.1e1 / t321;
  t323 = t161 * t161;
  t325 = t322 * t323 * t163;
  t334 = -0.57538888888888888889e0 * t285 + 0.11507777777777777778e1 * t288 + 0.40256666666666666667e0 * t290 + 0.366775e-1 * t294 + 0.73355e-1 * t296 + 0.137975e0 * t299;
  t336 = t156 * t334 * t163;
  t339 = t155 * t155;
  t340 = 0.1e1 / t339;
  t341 = t340 * t323;
  t342 = t80 * t80;
  t343 = 0.1e1 / t342;
  t344 = t341 * t343;
  t347 = -0.14764627977777777777e-2 * t34 * t264 * t58 - 0.35616666666666666666e-1 * t268 * t269 * t146 - 0.2e1 * t275 * t277 + 0.1e1 * t128 * t302 + 0.16081979498692535067e2 * t307 * t310 + 0.24415263074675393405e-3 * t149 * t131 * t263 * t81 + 0.10843581300301739842e-1 * t317 * t122 * t164 + 0.11696447245269292414e1 * t154 * t325 - 0.5848223622634646207e0 * t154 * t336 - 0.17315859105681463759e2 * t154 * t344;
  t349 = t23 * t30 * t347;
  t350 = t16 * t349;
  t355 = t109 * t21;
  t357 = t355 * t113 * params->c;
  t360 = t246 * t248;
  t361 = t360 * t234;
  t365 = t114 * params->c * t229;
  t368 = -0.5e1 / 0.9e1 * t231 * t90 + 0.1e3 / 0.81e2 * t235 * t107 * t357 - 0.2e4 / 0.243e3 * t244 * t361 + 0.5e2 / 0.81e2 * t111 * t365;
  t369 = t368 * t85;
  t370 = t178 * t167;
  t372 = t93 * t347;
  tv2rho20 = 0.1e2 / 0.9e1 * t105 - 0.1e3 / 0.81e2 * t118 + 0.1e2 / 0.9e1 * t170 + 0.2e1 * t179 + 0.2e1 * t180 + rho[0] * (0.5e1 / 0.9e1 * t232 - 0.1e3 / 0.81e2 * t238 + 0.1e2 / 0.9e1 * t240 + 0.2e4 / 0.243e3 * t251 - 0.1e3 / 0.81e2 * t256 - 0.5e2 / 0.81e2 * t260 + 0.5e1 / 0.9e1 * t350 + t369 + 0.2e1 * t370 + t372);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t375 = t2 * t99;
  t376 = t375 * t15;
  t377 = t376 * t87;
  t379 = t183 * t110;
  t380 = t379 * t117;
  t382 = t184 * t169;
  t384 = t243 * t246;
  t385 = t14 * t384;
  t386 = t85 * t248;
  t387 = t10 * t102;
  t389 = t385 * t386 * t387;
  t393 = t111 * t114 * t253 * t10;
  t397 = t111 * t114 * t115 * t99;
  t399 = t376 * t90;
  t401 = t379 * t175;
  t404 = t244 * t360 * t387;
  t408 = t111 * t114 * params->c * t99;
  t410 = -0.5e1 / 0.27e2 * t399 - 0.25e2 / 0.162e3 * t401 + 0.25e3 / 0.243e3 * t404 + 0.5e2 / 0.243e3 * t408;
  t411 = t410 * t85;
  t412 = t197 * t167;
  tv2rhosigma0 = -t186 + t190 + t198 + rho[0] * (0.5e1 / 0.27e2 * t377 + 0.25e2 / 0.162e3 * t380 - 0.5e1 / 0.72e2 * t382 - 0.25e3 / 0.243e3 * t389 + 0.25e2 / 0.324e3 * t393 - 0.5e2 / 0.243e3 * t397 + t411 + t412);

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t416 = t200 * t110;
  t417 = t416 * t117;
  t419 = t201 * t169;
  t421 = t6 * t102;
  t423 = t385 * t386 * t421;
  t427 = t111 * t114 * t253 * t6;
  t437 = 0.25e2 / 0.27e2 * t191 + 0.1e3 / 0.81e2 * t416 * t175 - 0.2e4 / 0.243e3 * t244 * t360 * t421 - 0.25e3 / 0.243e3 * t195;
  t438 = t437 * t85;
  t439 = t214 * t167;
  tv2rhotau0 = t203 - t207 + t215 + rho[0] * (-0.25e2 / 0.27e2 * t185 - 0.1e3 / 0.81e2 * t417 + 0.5e1 / 0.9e1 * t419 + 0.2e4 / 0.243e3 * t423 - 0.5e2 / 0.81e2 * t427 + 0.25e3 / 0.243e3 * t189 + t438 + t439);

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t442 = t224 * rho[0];
  t444 = 0.1e1 / t3 / t442;
  t445 = t2 * t444;
  t446 = t445 * t110;
  t447 = t446 * t237;
  t448 = 0.25e2 / 0.1296e4 * t447;
  t449 = t248 * t444;
  t451 = t244 * t247 * t449;
  t452 = 0.125e3 / 0.972e3 * t451;
  t454 = t445 * t107 * t357;
  t457 = t244 * t360 * t444;
  t459 = 0.25e2 / 0.1296e4 * t454 - 0.125e3 / 0.972e3 * t457;
  t460 = t459 * t85;
  tv2sigma20 = rho[0] * (-t448 + t452 + t460);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t463 = 0.1e1 / t3 / t224;
  t464 = t2 * t463;
  t465 = t464 * t110;
  t466 = t465 * t237;
  t467 = 0.25e2 / 0.162e3 * t466;
  t468 = t248 * t463;
  t470 = t244 * t247 * t468;
  t471 = 0.25e3 / 0.243e3 * t470;
  t473 = t464 * t107 * t357;
  t476 = t244 * t360 * t463;
  t478 = -0.25e2 / 0.162e3 * t473 + 0.25e3 / 0.243e3 * t476;
  t479 = t478 * t85;
  tv2sigmatau0 = rho[0] * (t467 - t471 + t479);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t482 = 0.1e1 / t3 / t97;
  t483 = t2 * t482;
  t484 = t483 * t110;
  t486 = 0.1e3 / 0.81e2 * t484 * t237;
  t487 = t248 * t482;
  t490 = 0.2e4 / 0.243e3 * t244 * t247 * t487;
  t497 = 0.1e3 / 0.81e2 * t483 * t107 * t357 - 0.2e4 / 0.243e3 * t244 * t360 * t482;
  t498 = t497 * t85;
  tv2tau20 = rho[0] * (-t486 + t490 + t498);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t501 = 0.1e1 / t305 / t126;
  t502 = t41 * t501;
  t503 = t276 * t144;
  t505 = 0.1e1 / t308 / t57;
  t506 = t503 * t505;
  t510 = 0.1e1 / t305 / t54;
  t511 = t41 * t510;
  t512 = t503 * t309;
  t518 = 0.1e1 / t42 / t52 * t32 / 0.4e1;
  t519 = 0.1e1 / t224;
  t520 = t518 * t519;
  t522 = t283 * t99;
  t523 = t282 * t522;
  t525 = t131 * t482;
  t526 = t130 * t525;
  t528 = t36 * t482;
  t529 = t34 * t528;
  t531 = 0.1e1/POW_3_2(t39);
  t532 = t531 * t32;
  t533 = t532 * t519;
  t535 = t293 * t522;
  t537 = t138 * t525;
  t540 = t49 * t35 * t99;
  t542 = -0.25319e1 * t520 + 0.16879333333333333333e1 * t523 - 0.19692555555555555555e1 * t526 - 0.93011851851851851854e0 * t529 + 0.13651666666666666667e0 * t533 - 0.27303333333333333333e0 * t535 - 0.3185388888888888889e0 * t537 - 0.36514074074074074075e0 * t540;
  t543 = t542 * t145;
  t547 = 0.1e1 / t339 / t155;
  t548 = t323 * t161;
  t551 = 0.1e1 / t342 / t80;
  t552 = t547 * t548 * t551;
  t563 = -0.34523333333333333333e1 * t520 + 0.23015555555555555556e1 * t523 - 0.26851481481481481482e1 * t526 - 0.93932222222222222223e0 * t529 + 0.73355e-1 * t533 - 0.14671e0 * t535 - 0.17116166666666666667e0 * t537 - 0.36793333333333333333e0 * t540;
  t565 = t156 * t563 * t163;
  t569 = 0.1e1 / t339 / t77;
  t571 = t569 * t548 * t343;
  t581 = t503 * t145;
  t588 = t343 * t161;
  t592 = 0.51726012919273400301e3 * t502 * t506 - 0.96491876992155210402e2 * t511 * t512 + 0.1e1 * t128 * t543 - 0.10254018858216406658e4 * t154 * t552 - 0.5848223622634646207e0 * t154 * t565 + 0.10389515463408878255e3 * t154 * t571 + 0.34450798614814814813e-2 * t34 * t528 * t58 + 0.48245938496077605201e2 * t307 * t301 * t309 * t144 + 0.6e1 * t307 * t581 - 0.6e1 * t275 * t146 * t301 - 0.51947577317044391277e2 * t154 * t340 * t334 * t588;
  t594 = t340 * t548 * t163;
  t598 = t163 * t334;
  t602 = t121 * t306;
  t606 = t263 * t127;
  t633 = -0.35089341735807877242e1 * t154 * t594 + 0.35089341735807877242e1 * t154 * t322 * t161 * t598 - 0.85917975471764868594e0 * t268 * t602 * t310 + 0.71233333333333333332e-1 * t268 * t606 * t146 - 0.53424999999999999999e-1 * t268 * t269 * t302 + 0.10685e0 * t268 * t121 * t274 * t277 - 0.56968947174242584612e-3 * t149 * t131 * t482 * t81 - 0.32530743900905219526e-1 * t317 * t122 * t325 - 0.21687162600603479684e-1 * t317 * t264 * t164 + 0.16265371950452609763e-1 * t317 * t122 * t336 + 0.48159733137676571078e0 * t317 * t122 * t344;
  t634 = t592 + t633;
  t635 = t93 * t634;
  t636 = t178 * t347;
  t641 = 0.1e1 / t4 / t442;
  t644 = -0.44e3 / 0.27e2 * tau[0] * t226 + 0.154e3 / 0.27e2 * sigma[0] * t641;
  t645 = t2 * t644;
  t646 = t645 * t15;
  t649 = t230 * t110;
  t652 = t234 * t102;
  t653 = t2 * t652;
  t654 = t384 * t248;
  t657 = t112 * t112;
  t658 = 0.1e1 / t657;
  t659 = t243 * t658;
  t660 = t14 * t659;
  t661 = t248 * params->c;
  t663 = t661 * t652 * t26;
  t666 = t102 * t229;
  t667 = t360 * t666;
  t671 = t114 * params->c * t644;
  t674 = -0.5e1 / 0.9e1 * t646 * t90 + 0.1e3 / 0.27e2 * t649 * t175 - 0.2e4 / 0.81e2 * t653 * t654 + 0.1e5 / 0.729e3 * t660 * t663 - 0.2e4 / 0.81e2 * t244 * t667 + 0.5e2 / 0.81e2 * t111 * t671;
  t675 = t674 * t85;
  t676 = t368 * t167;
  t678 = t653 * t243;
  t679 = t247 * t248;
  t680 = t678 * t679;
  t683 = t23 * t30 * t634;
  t684 = t16 * t683;
  t686 = t246 * t167;
  t687 = t686 * t249;
  t688 = t244 * t687;
  t690 = t646 * t87;
  t692 = t231 * t169;
  t694 = t104 * t349;
  t696 = t114 * t253;
  t697 = t236 * t696;
  t699 = t386 * t666;
  t700 = t385 * t699;
  t702 = t659 * t85;
  t703 = t14 * t702;
  t704 = t703 * t663;
  t707 = t114 * t253 * t229;
  t708 = t111 * t707;
  t711 = t114 * t115 * t644;
  t712 = t111 * t711;
  t714 = t649 * t117;
  t716 = t347 * params->c;
  t718 = t114 * t716 * t102;
  t719 = t111 * t718;
  t721 = t635 + 0.3e1 * t636 + t675 + 0.3e1 * t676 + 0.2e4 / 0.81e2 * t680 + 0.5e1 / 0.9e1 * t684 + 0.2e4 / 0.81e2 * t688 + 0.5e1 / 0.9e1 * t690 + 0.5e1 / 0.3e1 * t692 + 0.5e1 / 0.3e1 * t694 - 0.1e3 / 0.27e2 * t697 + 0.2e4 / 0.81e2 * t700 - 0.1e5 / 0.729e3 * t704 - 0.5e2 / 0.27e2 * t708 - 0.5e2 / 0.81e2 * t712 - 0.1e3 / 0.27e2 * t714 - 0.5e2 / 0.27e2 * t719;
  tv3rho30 = rho[0] * t721 - 0.1e3 / 0.27e2 * t256 - 0.5e2 / 0.27e2 * t260 + 0.3e1 * t372 + 0.3e1 * t369 + 0.6e1 * t370 + 0.5e1 / 0.3e1 * t232 + 0.1e2 / 0.3e1 * t240 + 0.2e4 / 0.81e2 * t251 + 0.5e1 / 0.3e1 * t350 - 0.1e3 / 0.27e2 * t238;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t741 = t197 * t347;
  t742 = t2 * t226;
  t743 = t742 * t15;
  t744 = t743 * t90;
  t746 = t375 * t110;
  t747 = t746 * t175;
  t749 = t183 * t243;
  t750 = t749 * t361;
  t752 = t379 * t365;
  t755 = t14 * t659 * t661;
  t758 = t755 * t10 * t234 * t26;
  t760 = t99 * t102;
  t762 = t244 * t360 * t760;
  t764 = t10 * t229;
  t766 = t244 * t360 * t764;
  t770 = t111 * t114 * params->c * t226;
  t772 = 0.55e2 / 0.81e2 * t744 + 0.2e3 / 0.243e3 * t747 + 0.25e3 / 0.81e2 * t750 - 0.25e2 / 0.162e3 * t752 - 0.125e4 / 0.729e3 * t758 - 0.4e4 / 0.729e3 * t762 + 0.25e3 / 0.243e3 * t766 - 0.55e3 / 0.729e3 * t770;
  t773 = t772 * t85;
  t774 = t410 * t167;
  t776 = t376 * t169;
  t778 = t749 * t250;
  t780 = t184 * t349;
  t784 = t661 * t10 * t234 * t26;
  t785 = t703 * t784;
  t787 = t167 * t248;
  t789 = t385 * t787 * t387;
  t792 = t385 * t386 * t764;
  t794 = t743 * t87;
  t798 = t111 * t114 * t253 * t99;
  t802 = t111 * t114 * t115 * t226;
  t804 = t379 * t255;
  t806 = t379 * t259;
  t809 = t385 * t386 * t760;
  t813 = t111 * t114 * t716 * t10;
  t815 = t746 * t117;
  t817 = t741 + t773 + 0.2e1 * t774 + 0.1e2 / 0.27e2 * t776 - 0.25e3 / 0.81e2 * t778 - 0.5e1 / 0.72e2 * t780 + 0.125e4 / 0.729e3 * t785 - 0.5e3 / 0.243e3 * t789 - 0.25e3 / 0.243e3 * t792 - 0.55e2 / 0.81e2 * t794 - 0.1e3 / 0.243e3 * t798 + 0.55e3 / 0.729e3 * t802 + 0.25e2 / 0.81e2 * t804 + 0.25e2 / 0.162e3 * t806 + 0.4e4 / 0.729e3 * t809 + 0.25e2 / 0.324e3 * t813 - 0.2e3 / 0.243e3 * t815;
  tv3rho2sigma0 = 0.1e2 / 0.27e2 * t377 + 0.25e2 / 0.81e2 * t380 - 0.5e1 / 0.36e2 * t382 - 0.5e3 / 0.243e3 * t389 + 0.25e2 / 0.162e3 * t393 - 0.1e3 / 0.243e3 * t397 + 0.2e1 * t411 + 0.2e1 * t412 + rho[0] * t817;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t827 = t437 * t167;
  t829 = t214 * t347;
  t832 = t200 * t243;
  t842 = t6 * t229;
  t847 = -0.2e3 / 0.81e2 * t399 - 0.1e4 / 0.243e3 * t401 - 0.2e4 / 0.81e2 * t832 * t361 + 0.1e3 / 0.81e2 * t416 * t365 + 0.1e5 / 0.729e3 * t755 * t6 * t234 * t26 + 0.2e5 / 0.729e3 * t404 - 0.2e4 / 0.243e3 * t244 * t360 * t842 + 0.2e4 / 0.729e3 * t408;
  t848 = t847 * t85;
  t850 = t385 * t787 * t421;
  t852 = t386 * t842;
  t853 = t385 * t852;
  t855 = t832 * t250;
  t857 = t201 * t349;
  t861 = t661 * t6 * t234 * t26;
  t862 = t703 * t861;
  t868 = t111 * t114 * t716 * t6;
  t870 = t416 * t255;
  t872 = t416 * t259;
  t878 = 0.2e1 * t827 + t829 + t848 + 0.4e4 / 0.243e3 * t850 + 0.2e4 / 0.243e3 * t853 + 0.2e4 / 0.81e2 * t855 + 0.5e1 / 0.9e1 * t857 - 0.1e5 / 0.729e3 * t862 - 0.2e5 / 0.729e3 * t389 - 0.2e4 / 0.729e3 * t397 - 0.5e2 / 0.81e2 * t868 - 0.2e3 / 0.81e2 * t870 - 0.1e3 / 0.81e2 * t872 + 0.1e4 / 0.243e3 * t380 + 0.5e3 / 0.243e3 * t393 - 0.5e2 / 0.27e2 * t382 + 0.2e3 / 0.81e2 * t377;
  tv3rho2tau0 = -0.5e2 / 0.27e2 * t185 - 0.2e3 / 0.81e2 * t417 + 0.1e2 / 0.9e1 * t419 + 0.4e4 / 0.243e3 * t423 - 0.1e3 / 0.81e2 * t427 + 0.5e3 / 0.243e3 * t189 + 0.2e1 * t438 + 0.2e1 * t439 + rho[0] * t878;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t880 = t224 * t8;
  t882 = 0.1e1 / t3 / t880;
  t883 = t2 * t882;
  t884 = t883 * t110;
  t885 = t884 * t237;
  t887 = t445 * t243;
  t888 = t248 * t102;
  t889 = t247 * t888;
  t890 = t887 * t889;
  t892 = t446 * t696;
  t894 = t661 * t444;
  t896 = t894 * t102 * t26;
  t897 = t703 * t896;
  t900 = t244 * t686 * t449;
  t902 = t248 * t882;
  t904 = t244 * t247 * t902;
  t907 = t883 * t107 * t357;
  t909 = t360 * t102;
  t910 = t887 * t909;
  t914 = t755 * t444 * t102 * t26;
  t917 = t244 * t360 * t882;
  t919 = -0.25e2 / 0.243e3 * t907 - 0.125e3 / 0.324e3 * t910 + 0.625e3 / 0.2916e4 * t914 + 0.5e3 / 0.729e3 * t917;
  t920 = t919 * t85;
  t921 = t459 * t167;
  tv3rhosigma20 = -t448 + t452 + t460 + rho[0] * (0.25e2 / 0.243e3 * t885 + 0.125e3 / 0.324e3 * t890 - 0.25e2 / 0.1296e4 * t892 - 0.625e3 / 0.2916e4 * t897 + 0.125e3 / 0.972e3 * t900 - 0.5e3 / 0.729e3 * t904 + t920 + t921);

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t925 = t464 * t243;
  t926 = t925 * t889;
  t928 = t465 * t696;
  t930 = t661 * t463;
  t932 = t930 * t102 * t26;
  t933 = t703 * t932;
  t936 = t244 * t686 * t468;
  t940 = t925 * t909;
  t944 = t755 * t463 * t102 * t26;
  t947 = 0.325e3 / 0.486e3 * t454 + 0.25e3 / 0.81e2 * t940 - 0.125e4 / 0.729e3 * t944 - 0.325e4 / 0.729e3 * t457;
  t948 = t947 * t85;
  t949 = t478 * t167;
  tv3rhosigmatau0 = t467 - t471 + t479 + rho[0] * (-0.325e3 / 0.486e3 * t447 - 0.25e3 / 0.81e2 * t926 + 0.25e2 / 0.162e3 * t928 + 0.125e4 / 0.729e3 * t933 - 0.25e3 / 0.243e3 * t936 + 0.325e4 / 0.729e3 * t451 + t948 + t949);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t953 = t483 * t243;
  t954 = t953 * t889;
  t956 = t484 * t696;
  t958 = t661 * t482;
  t960 = t958 * t102 * t26;
  t961 = t703 * t960;
  t964 = t244 * t686 * t487;
  t975 = -0.1e4 / 0.243e3 * t473 - 0.2e4 / 0.81e2 * t953 * t909 + 0.1e5 / 0.729e3 * t755 * t482 * t102 * t26 + 0.2e5 / 0.729e3 * t476;
  t976 = t975 * t85;
  t977 = t497 * t167;
  tv3rhotau20 = -t486 + t490 + t498 + rho[0] * (0.1e4 / 0.243e3 * t466 + 0.2e4 / 0.81e2 * t954 - 0.1e3 / 0.81e2 * t956 - 0.1e5 / 0.729e3 * t961 + 0.2e4 / 0.243e3 * t964 - 0.2e5 / 0.729e3 * t470 + t976 + t977);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t980 = t224 * t224;
  t981 = 0.1e1 / t980;
  t982 = t2 * t981;
  t983 = t982 * t243;
  t984 = t983 * t679;
  t985 = 0.125e3 / 0.2592e4 * t984;
  t987 = t661 * t981 * t26;
  t988 = t703 * t987;
  t989 = 0.625e3 / 0.23328e5 * t988;
  t990 = t982 * t654;
  t992 = t660 * t987;
  t994 = 0.125e3 / 0.2592e4 * t990 - 0.625e3 / 0.23328e5 * t992;
  t995 = t994 * t85;
  tv3sigma30 = rho[0] * (-t985 + t989 + t995);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t997 = t224 * t97;
  t998 = 0.1e1 / t997;
  t999 = t2 * t998;
  t1000 = t999 * t243;
  t1001 = t1000 * t679;
  t1002 = 0.125e3 / 0.324e3 * t1001;
  t1004 = t661 * t998 * t26;
  t1005 = t703 * t1004;
  t1006 = 0.625e3 / 0.2916e4 * t1005;
  t1007 = t999 * t654;
  t1009 = t660 * t1004;
  t1011 = -0.125e3 / 0.324e3 * t1007 + 0.625e3 / 0.2916e4 * t1009;
  t1012 = t1011 * t85;
  tv3sigma2tau0 = rho[0] * (t1002 - t1006 + t1012);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1014 = 0.1e1 / t880;
  t1015 = t2 * t1014;
  t1016 = t1015 * t243;
  t1017 = t1016 * t679;
  t1018 = 0.25e3 / 0.81e2 * t1017;
  t1020 = t661 * t1014 * t26;
  t1021 = t703 * t1020;
  t1022 = 0.125e4 / 0.729e3 * t1021;
  t1023 = t1015 * t654;
  t1025 = t660 * t1020;
  t1027 = 0.25e3 / 0.81e2 * t1023 - 0.125e4 / 0.729e3 * t1025;
  t1028 = t1027 * t85;
  tv3sigmatau20 = rho[0] * (-t1018 + t1022 + t1028);

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1030 = 0.1e1 / t442;
  t1031 = t2 * t1030;
  t1032 = t1031 * t243;
  t1034 = 0.2e4 / 0.81e2 * t1032 * t679;
  t1036 = t661 * t1030 * t26;
  t1038 = 0.1e5 / 0.729e3 * t703 * t1036;
  t1043 = -0.2e4 / 0.81e2 * t1031 * t654 + 0.1e5 / 0.729e3 * t660 * t1036;
  t1044 = t1043 * t85;
  tv3tau30 = rho[0] * (t1034 - t1038 + t1044);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t1058 = t243 / t657 / t29;
  t1060 = t14 * t1058 * t85;
  t1061 = t248 * t248;
  t1062 = t234 * t234;
  t1064 = t110 * t21;
  t1065 = t1061 * t1062 * t1064;
  t1069 = t14 * t659 * t167;
  t1077 = t102 * t644;
  t1081 = t114 * t716;
  t1103 = 0.1e1 / t42 * rho[0] * t444 * t268 / 0.48e2;
  t1105 = t518 * t1030;
  t1107 = t283 * t226;
  t1108 = t282 * t1107;
  t1110 = t131 * t463;
  t1111 = t130 * t1110;
  t1113 = t36 * t463;
  t1114 = t34 * t1113;
  t1116 = pow(t39, -0.25e1);
  t1119 = t1116 * t32 * t444 * t268;
  t1121 = t532 * t1030;
  t1123 = t293 * t1107;
  t1125 = t138 * t1110;
  t1128 = t49 * t35 * t226;
  t1135 = t339 * t339;
  t1137 = t323 * t323;
  t1139 = t342 * t342;
  t1144 = t70 * t268;
  t1146 = t334 * t343;
  t1152 = t161 * t163;
  t1171 = 0.36e2 * t307 * t277 * t301 + 0.64327917994770140268e2 * t307 * t542 * t309 * t144 - 0.57895126195293126241e3 * t511 * t310 * t301 - 0.5848223622634646207e0 * t154 * t156 * (-0.28769444444444444444e1 * t1103 + 0.27618666666666666667e2 * t1105 - 0.10229135802469135803e2 * t1108 + 0.89504938271604938273e1 * t1111 + 0.31310740740740740741e1 * t1114 + 0.366775e-1 * t1119 - 0.58684e0 * t1121 + 0.65204444444444444445e0 * t1123 + 0.5705388888888888889e0 * t1125 + 0.13490888888888888889e1 * t1128) * t163 - 0.91082604192152556044e5 * t154 / t1135 * t1137 / t1139 + 0.19263893255070628431e1 * t1144 * t121 * t340 * t1146 * t161 - 0.1301229756036208781e0 * t1144 * t121 * t322 * t1152 * t334 - 0.8e1 * t275 * t543 * t144 + 0.3103560775156404018e4 * t502 * t276 * t505 * t301 - 0.11483599538271604938e-1 * t34 * t1113 * t58 - 0.6233709278045326953e3 * t154 * t547 * t1137 * t343;
  t1182 = t334 * t334;
  t1222 = 0.12304822629859687989e5 * t154 / t339 / t321 * t1137 * t551 + 0.14035736694323150897e2 * t154 * t569 * t1137 * t163 + 0.35089341735807877242e1 * t154 * t322 * t1182 * t163 - 0.51947577317044391277e2 * t154 * t340 * t1182 * t343 - 0.34367190188705947437e1 * t135 * t306 * t301 * t309 * t144 + 0.4274e0 * t135 * t274 * t144 * t302 + 0.14246666666666666666e0 * t268 * t606 * t302 - 0.21053605041484726346e2 * t154 * t341 * t598 - 0.4274e0 * t268 * t602 * t581 + 0.62337092780453269531e3 * t154 * t569 * t323 * t1146 - 0.22161481481481481481e0 * t268 * t482 * t127 * t146 - 0.61524113149298439947e4 * t154 * t547 * t323 * t551 * t334;
  t1255 = t301 * t301;
  t1262 = t276 * t276;
  t1266 = 0.46785788981077169656e1 * t154 * t322 * t563 * t1152 - 0.69263436422725855036e2 * t154 * t340 * t563 * t588 - 0.3684616320282908548e2 * t268 * t121 * t501 * t506 + 0.68734380377411894876e1 * t268 * t121 * t510 * t512 - 0.71233333333333333332e-1 * t268 * t269 * t543 + 0.22911460125803964958e1 * t268 * t263 * t306 * t310 - 0.28493333333333333333e0 * t268 * t263 * t274 * t277 + 0.18989649058080861537e-2 * t149 * t131 * t463 * t81 - 0.6e1 * t275 * t1255 * t145 + 0.48245938496077605201e2 * t307 * t1255 * t309 - 0.24e2 * t511 * t1262 * t145;
  t1290 = t305 * t305;
  t1293 = t308 * t308;
  t1322 = -0.62071215503128080361e4 * t41 / t305 / t273 * t1262 * t505 + 0.57895126195293126241e3 * t502 * t1262 * t309 + 0.1e1 * t128 * (-0.21099166666666666667e1 * t1103 + 0.202552e2 * t1105 - 0.75019259259259259258e1 * t1108 + 0.6564185185185185185e1 * t1111 + 0.31003950617283950618e1 * t1114 + 0.68258333333333333335e-1 * t1119 - 0.10921333333333333333e1 * t1121 + 0.12134814814814814815e1 * t1123 + 0.10617962962962962963e1 * t1125 + 0.13388493827160493828e1 * t1128) * t145 + 0.24955700379505800916e5 * t41 / t1290 * t1262 / t1293 + 0.1301229756036208781e0 * t317 * t122 * t594 + 0.67471172535210825684e-1 * t317 * t528 * t164 + 0.38025319932552508021e2 * t317 * t122 * t552 + 0.21687162600603479684e-1 * t317 * t122 * t565 - 0.38527786510141256862e1 * t317 * t122 * t571 + 0.86748650402413918736e-1 * t317 * t264 * t325 - 0.43374325201206959368e-1 * t317 * t264 * t336 - 0.12842595503380418954e1 * t317 * t264 * t344;
  t1324 = t1171 + t1222 + t1266 + t1322;
  t1326 = t686 * t248;
  t1339 = t246 * t347;
  t1343 = 0.4e6 / 0.6561e4 * t1060 * t1065 - 0.4e5 / 0.729e3 * t1069 * t663 + 0.4e1 * t178 * t634 + 0.8e4 / 0.81e2 * t385 * t787 * t666 + 0.8e4 / 0.243e3 * t385 * t386 * t1077 - 0.2e3 / 0.27e2 * t236 * t1081 + 0.6e1 * t368 * t347 + t93 * t1324 + 0.8e4 / 0.81e2 * t678 * t1326 + 0.2e2 / 0.9e1 * t104 * t683 + 0.5e1 / 0.9e1 * t16 * t23 * t30 * t1324 + 0.2e2 / 0.9e1 * t646 * t169 + 0.1e2 / 0.3e1 * t231 * t349 + 0.4e4 / 0.81e2 * t244 * t1339 * t249;
  t1344 = t235 * t243;
  t1346 = t247 * t248 * t229;
  t1352 = 0.1e1 / t4 / t880;
  t1355 = 0.616e4 / 0.81e2 * tau[0] * t641 - 0.2618e4 / 0.81e2 * sigma[0] * t1352;
  t1357 = t2 * t1355 * t15;
  t1360 = t229 * t229;
  t1369 = t645 * t110;
  t1375 = t2 * t1360;
  t1380 = t2 * t1062 * t659;
  t1382 = t661 * t15 * t23;
  t1385 = t14 * t1058;
  t1389 = t23 * t229;
  t1405 = t661 * t234;
  t1423 = t634 * params->c;
  t1431 = t85 * t661 * t26;
  t1438 = 0.4e4 / 0.27e2 * t1344 * t1346 + 0.5e1 / 0.9e1 * t1357 * t87 + 0.2e4 / 0.81e2 * t244 * t247 * t248 * t1360 + 0.4e1 * t674 * t167 + (-0.5e1 / 0.9e1 * t1357 * t90 + 0.4e3 / 0.81e2 * t1369 * t175 - 0.4e4 / 0.27e2 * t230 * t243 * t361 + 0.1e3 / 0.27e2 * t1375 * t107 * t357 + 0.4e5 / 0.729e3 * t1380 * t1382 - 0.4e6 / 0.6561e4 * t1385 * t1065 + 0.2e5 / 0.243e3 * t755 * t234 * t15 * t1389 - 0.2e4 / 0.81e2 * t244 * t360 * t1360 - 0.8e4 / 0.243e3 * t244 * t360 * t1077 + 0.5e2 / 0.81e2 * t111 * t114 * params->c * t1355) * t85 - 0.2e5 / 0.243e3 * t703 * t1405 * t229 * t26 - 0.1e3 / 0.27e2 * t1375 * t110 * t237 - 0.1e3 / 0.27e2 * t111 * t114 * t716 * t229 - 0.2e3 / 0.81e2 * t111 * t114 * t253 * t644 - 0.4e3 / 0.27e2 * t649 * t255 - 0.2e3 / 0.81e2 * t111 * t114 * t1423 * t102 - 0.4e3 / 0.81e2 * t1369 * t117 - 0.4e5 / 0.729e3 * t1380 * t1431 - 0.5e2 / 0.81e2 * t111 * t114 * t115 * t1355;
  tv4rho40 = 0.4e1 * t635 + 0.12e2 * t636 + 0.4e1 * t675 + 0.12e2 * t676 + 0.8e4 / 0.81e2 * t680 + 0.2e2 / 0.9e1 * t684 + 0.8e4 / 0.81e2 * t688 + 0.2e2 / 0.9e1 * t690 + 0.2e2 / 0.3e1 * t692 + 0.2e2 / 0.3e1 * t694 + rho[0] * (t1343 + t1438) - 0.4e3 / 0.27e2 * t697 + 0.8e4 / 0.81e2 * t700 - 0.4e5 / 0.729e3 * t704 - 0.2e3 / 0.27e2 * t708 - 0.2e3 / 0.81e2 * t712 - 0.4e3 / 0.27e2 * t714 - 0.2e3 / 0.27e2 * t719;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1457 = t99 * t229;
  t1467 = t226 * t102;
  t1471 = t347 * t248;
  t1478 = t10 * t644;
  t1492 = t375 * t243;
  t1496 = t2 * t641 * t15;
  t1501 = t244 * t658 * t85 * t661;
  t1503 = t387 * t15 * t1389;
  t1506 = 0.5e4 / 0.729e3 * t183 * t702 * t663 + 0.2e4 / 0.243e3 * t385 * t386 * t1457 + 0.4e4 / 0.243e3 * t385 * t787 * t760 - 0.25e3 / 0.27e2 * t183 * t384 * t699 - 0.22e5 / 0.729e3 * t385 * t386 * t1467 - 0.25e3 / 0.81e2 * t385 * t1471 * t387 - 0.25e3 / 0.81e2 * t385 * t787 * t764 - 0.25e3 / 0.243e3 * t385 * t386 * t1478 + 0.3e1 * t772 * t167 - 0.25e3 / 0.27e2 * t749 * t687 - 0.5e1 / 0.72e2 * t184 * t683 + 0.5e1 / 0.9e1 * t376 * t349 - 0.55e2 / 0.27e2 * t743 * t169 + 0.2e4 / 0.81e2 * t1492 * t250 + 0.77e3 / 0.243e3 * t1496 * t87 + 0.125e4 / 0.243e3 * t1501 * t1503;
  t1507 = t742 * t110;
  t1536 = t14 * t1058 * t1061;
  t1548 = -0.11e4 / 0.243e3 * t1507 * t175 + 0.1e3 / 0.81e2 * t746 * t365 - 0.25e2 / 0.162e3 * t379 * t671 + 0.22e5 / 0.729e3 * t244 * t360 * t1467 - 0.2e4 / 0.81e2 * t1492 * t361 + 0.25e3 / 0.243e3 * t244 * t360 * t1478 - 0.77e3 / 0.243e3 * t1496 * t90 + 0.25e3 / 0.27e2 * t749 * t667 - 0.2e4 / 0.243e3 * t244 * t360 * t1457 + 0.1e5 / 0.729e3 * t755 * t99 * t234 * t26 - 0.125e4 / 0.243e3 * t755 * t1503 + 0.5e5 / 0.6561e4 * t1536 * t10 * t652 * t1064 - 0.5e4 / 0.729e3 * t183 * t659 * t663 + 0.77e4 / 0.2187e4 * t111 * t114 * params->c * t641;
  t1593 = t1548 * t85 + 0.3e1 * t410 * t347 + t197 * t634 - 0.1e5 / 0.729e3 * t703 * t661 * t99 * t234 * t26 + 0.125e4 / 0.243e3 * t1069 * t784 - 0.5e5 / 0.6561e4 * t1060 * t1061 * t10 * t652 * t1064 + 0.25e2 / 0.54e2 * t379 * t707 + 0.25e2 / 0.162e3 * t379 * t711 + 0.25e2 / 0.324e3 * t111 * t114 * t1423 * t10 + 0.11e4 / 0.243e3 * t1507 * t117 - 0.5e2 / 0.81e2 * t111 * t114 * t716 * t99 + 0.25e2 / 0.54e2 * t379 * t718 - 0.2e3 / 0.81e2 * t746 * t255 + 0.55e3 / 0.243e3 * t111 * t114 * t253 * t226 - 0.77e4 / 0.2187e4 * t111 * t114 * t115 * t641 - 0.1e3 / 0.81e2 * t746 * t259;
  tv4rho3sigma0 = 0.3e1 * t741 + 0.3e1 * t773 + 0.6e1 * t774 + 0.1e2 / 0.9e1 * t776 - 0.25e3 / 0.27e2 * t778 - 0.5e1 / 0.24e2 * t780 + rho[0] * (t1506 + t1593) + 0.125e4 / 0.243e3 * t785 - 0.5e3 / 0.81e2 * t789 - 0.25e3 / 0.81e2 * t792 - 0.55e2 / 0.27e2 * t794 - 0.1e3 / 0.81e2 * t798 + 0.55e3 / 0.243e3 * t802 + 0.25e2 / 0.27e2 * t804 + 0.25e2 / 0.54e2 * t806 + 0.4e4 / 0.243e3 * t809 + 0.25e2 / 0.108e3 * t813 - 0.2e3 / 0.81e2 * t815;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t1626 = t6 * t644;
  t1649 = t421 * t15 * t1389;
  t1662 = 0.1e3 / 0.81e2 * t416 * t671 - 0.5e3 / 0.81e2 * t752 - 0.8e5 / 0.729e3 * t762 + 0.1e5 / 0.81e2 * t750 + 0.22e4 / 0.243e3 * t744 + 0.1e5 / 0.243e3 * t766 - 0.2e4 / 0.243e3 * t244 * t360 * t1626 - 0.2e4 / 0.27e2 * t832 * t667 + 0.1e5 / 0.243e3 * t755 * t1649 - 0.4e6 / 0.6561e4 * t1536 * t6 * t652 * t1064 + 0.4e4 / 0.243e3 * t747 - 0.5e5 / 0.729e3 * t758 - 0.22e5 / 0.2187e4 * t770 + 0.4e5 / 0.729e3 * t200 * t659 * t663;
  t1677 = 0.5e1 / 0.9e1 * t201 * t683 + t214 * t634 + 0.2e4 / 0.81e2 * t385 * t1471 * t421 + 0.2e4 / 0.81e2 * t385 * t787 * t842 + 0.2e4 / 0.27e2 * t103 * t384 * t852 + 0.2e4 / 0.243e3 * t385 * t386 * t1626 + 0.2e3 / 0.27e2 * t776 - 0.1e5 / 0.81e2 * t778 - 0.25e2 / 0.9e1 * t780 - 0.22e4 / 0.243e3 * t794 + 0.3e1 * t847 * t167 + t1662 * t85 - 0.1e5 / 0.243e3 * t1501 * t1649 + 0.2e4 / 0.27e2 * t1344 * t686 * t248 * t6 - 0.1e5 / 0.243e3 * t1069 * t861 + 0.4e6 / 0.6561e4 * t1060 * t1061 * t6 * t652 * t1064;
  t1703 = 0.5e5 / 0.729e3 * t785 - 0.2e4 / 0.243e3 * t798 + 0.22e5 / 0.2187e4 * t802 + 0.1e4 / 0.81e2 * t804 + 0.5e3 / 0.81e2 * t806 + 0.25e3 / 0.81e2 * t813 - 0.4e4 / 0.243e3 * t815 - 0.2e5 / 0.243e3 * t789 - 0.1e5 / 0.243e3 * t792 + 0.8e5 / 0.729e3 * t809 - 0.4e5 / 0.729e3 * t200 * t702 * t663 - 0.5e2 / 0.81e2 * t111 * t114 * t1423 * t6 - 0.1e3 / 0.27e2 * t416 * t707 - 0.1e3 / 0.81e2 * t416 * t711 - 0.1e3 / 0.27e2 * t416 * t718 + 0.3e1 * t437 * t347;
  tv4rho3tau0 = 0.6e1 * t827 + 0.3e1 * t829 + 0.3e1 * t848 + 0.4e4 / 0.81e2 * t850 + 0.2e4 / 0.81e2 * t853 + 0.2e4 / 0.27e2 * t855 + 0.5e1 / 0.3e1 * t857 + rho[0] * (t1677 + t1703) - 0.1e5 / 0.243e3 * t862 - 0.2e5 / 0.243e3 * t389 - 0.2e4 / 0.243e3 * t397 - 0.5e2 / 0.27e2 * t868 - 0.2e3 / 0.27e2 * t870 - 0.1e3 / 0.27e2 * t872 + 0.1e4 / 0.81e2 * t380 + 0.5e3 / 0.81e2 * t393 - 0.5e2 / 0.9e1 * t382 + 0.2e3 / 0.27e2 * t377;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t1725 = t1405 * t26;
  t1729 = 0.1e1 / t3 / t997;
  t1730 = t2 * t1729;
  t1749 = t883 * t243;
  t1755 = t360 * t229;
  t1782 = t686 * t888;
  t1803 = -0.625e3 / 0.729e3 * t445 * t702 * t1725 - 0.475e3 / 0.729e3 * t1730 * t110 * t237 - 0.1e4 / 0.729e3 * t244 * t686 * t902 + 0.95e4 / 0.2187e4 * t244 * t247 * t248 * t1729 + 0.5e2 / 0.243e3 * t884 * t696 - 0.25e2 / 0.1296e4 * t446 * t1081 + t459 * t347 + (0.475e3 / 0.729e3 * t1730 * t107 * t357 + 0.1e4 / 0.243e3 * t1749 * t909 + 0.625e3 / 0.729e3 * t445 * t659 * t1725 - 0.125e3 / 0.324e3 * t887 * t1755 - 0.625e4 / 0.6561e4 * t1536 * t444 * t234 * t1064 - 0.5e4 / 0.2187e4 * t755 * t882 * t102 * t26 + 0.625e3 / 0.2916e4 * t755 * t444 * t229 * t26 - 0.95e4 / 0.2187e4 * t244 * t360 * t1729) * t85 + 0.2e1 * t919 * t167 + 0.125e3 / 0.972e3 * t244 * t1339 * t449 - 0.1e4 / 0.243e3 * t1749 * t889 + 0.125e3 / 0.162e3 * t887 * t1782 + 0.125e3 / 0.324e3 * t887 * t1346 + 0.5e4 / 0.2187e4 * t703 * t661 * t882 * t102 * t26 - 0.625e3 / 0.1458e4 * t1069 * t896 - 0.625e3 / 0.2916e4 * t703 * t894 * t229 * t26 + 0.625e4 / 0.6561e4 * t1060 * t1061 * t444 * t234 * t1064;
  tv4rho2sigma20 = 0.5e2 / 0.243e3 * t885 + 0.125e3 / 0.162e3 * t890 - 0.25e2 / 0.648e3 * t892 - 0.625e3 / 0.1458e4 * t897 + 0.125e3 / 0.486e3 * t900 - 0.1e4 / 0.729e3 * t904 + 0.2e1 * t920 + 0.2e1 * t921 + rho[0] * t1803;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  t1864 = 0.5e4 / 0.729e3 * t464 * t702 * t1725 + 0.26e4 / 0.729e3 * t885 + 0.25e2 / 0.162e3 * t465 * t1081 - 0.325e3 / 0.243e3 * t892 - 0.52e5 / 0.2187e4 * t904 + 0.65e4 / 0.243e3 * t890 + 0.65e4 / 0.729e3 * t900 - 0.25e3 / 0.243e3 * t244 * t1339 * t468 - 0.5e3 / 0.81e2 * t925 * t1782 - 0.25e3 / 0.81e2 * t925 * t1346 + t478 * t347 + (-0.26e4 / 0.729e3 * t907 - 0.65e4 / 0.243e3 * t910 - 0.5e4 / 0.729e3 * t464 * t659 * t1725 + 0.25e3 / 0.81e2 * t925 * t1755 + 0.5e5 / 0.6561e4 * t1536 * t463 * t234 * t1064 + 0.325e5 / 0.2187e4 * t914 - 0.125e4 / 0.729e3 * t755 * t463 * t229 * t26 + 0.52e5 / 0.2187e4 * t917) * t85 + 0.2e1 * t947 * t167 + 0.25e4 / 0.729e3 * t1069 * t932 + 0.125e4 / 0.729e3 * t703 * t930 * t229 * t26 - 0.5e5 / 0.6561e4 * t1060 * t1061 * t463 * t234 * t1064 - 0.325e5 / 0.2187e4 * t897;
  tv4rho2sigmatau0 = -0.325e3 / 0.243e3 * t447 - 0.5e3 / 0.81e2 * t926 + 0.25e2 / 0.81e2 * t928 + 0.25e4 / 0.729e3 * t933 - 0.5e3 / 0.243e3 * t936 + 0.65e4 / 0.729e3 * t451 + 0.2e1 * t948 + 0.2e1 * t949 + rho[0] * t1864;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  t1925 = t497 * t347 + (0.13e5 / 0.729e3 * t454 + 0.4e5 / 0.243e3 * t940 + 0.4e5 / 0.729e3 * t483 * t659 * t1725 - 0.2e4 / 0.81e2 * t953 * t1755 - 0.4e6 / 0.6561e4 * t1536 * t482 * t234 * t1064 - 0.2e6 / 0.2187e4 * t944 + 0.1e5 / 0.729e3 * t755 * t482 * t229 * t26 - 0.26e6 / 0.2187e4 * t457) * t85 + 0.2e1 * t975 * t167 - 0.4e5 / 0.729e3 * t483 * t702 * t1725 - 0.1e3 / 0.81e2 * t484 * t1081 - 0.4e5 / 0.729e3 * t936 - 0.4e5 / 0.243e3 * t926 + 0.2e4 / 0.243e3 * t928 + 0.2e4 / 0.243e3 * t244 * t1339 * t487 + 0.4e4 / 0.81e2 * t953 * t1782 + 0.2e4 / 0.81e2 * t953 * t1346 + 0.2e6 / 0.2187e4 * t933 - 0.13e5 / 0.729e3 * t447 + 0.26e6 / 0.2187e4 * t451 - 0.2e5 / 0.729e3 * t1069 * t960 - 0.1e5 / 0.729e3 * t703 * t958 * t229 * t26 + 0.4e6 / 0.6561e4 * t1060 * t1061 * t482 * t234 * t1064;
  tv4rho2tau20 = 0.2e4 / 0.243e3 * t466 + 0.4e4 / 0.81e2 * t954 - 0.2e3 / 0.81e2 * t956 - 0.2e5 / 0.729e3 * t961 + 0.4e4 / 0.243e3 * t964 - 0.4e5 / 0.729e3 * t470 + 0.2e1 * t976 + 0.2e1 * t977 + rho[0] * t1925;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t1927 = t980 * rho[0];
  t1928 = 0.1e1 / t1927;
  t1929 = t2 * t1928;
  t1935 = t661 * t102 * t26;
  t1942 = t355 * t102;
  t1949 = t661 * t1928 * t26;
  tv4rhosigma30 = -t985 + t989 + t995 + rho[0] * (0.125e3 / 0.324e3 * t1929 * t243 * t679 + 0.625e3 / 0.5832e4 * t982 * t702 * t1935 - 0.125e3 / 0.2592e4 * t983 * t1326 - 0.3125e4 / 0.26244e5 * t1060 * t1061 * t981 * t107 * t1942 + 0.625e3 / 0.23328e5 * t1069 * t987 - 0.625e3 / 0.2916e4 * t703 * t1949 + (-0.125e3 / 0.324e3 * t1929 * t654 - 0.625e3 / 0.5832e4 * t982 * t659 * t1935 + 0.3125e4 / 0.26244e5 * t1536 * t981 * t107 * t1942 + 0.625e3 / 0.2916e4 * t660 * t1949) * t85 + t994 * t167);

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2tau0 = t1002 - t1006 + t1012 + rho[0] * (-0.875e3 / 0.324e3 * t984 - 0.625e3 / 0.729e3 * t999 * t702 * t1935 + 0.125e3 / 0.324e3 * t1000 * t1326 + 0.625e4 / 0.6561e4 * t1060 * t1061 * t998 * t107 * t1942 - 0.625e3 / 0.2916e4 * t1069 * t1004 + 0.4375e4 / 0.2916e4 * t988 + (0.875e3 / 0.324e3 * t990 + 0.625e3 / 0.729e3 * t999 * t659 * t1935 - 0.625e4 / 0.6561e4 * t1536 * t998 * t107 * t1942 - 0.4375e4 / 0.2916e4 * t992) * t85 + t1011 * t167);

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmatau20 = -t1018 + t1022 + t1028 + rho[0] * (0.5e3 / 0.27e2 * t1001 + 0.5e4 / 0.729e3 * t1015 * t702 * t1935 - 0.25e3 / 0.81e2 * t1016 * t1326 - 0.5e5 / 0.6561e4 * t1060 * t1061 * t1014 * t107 * t1942 + 0.125e4 / 0.729e3 * t1069 * t1020 - 0.25e4 / 0.243e3 * t1005 + (-0.5e3 / 0.27e2 * t1007 - 0.5e4 / 0.729e3 * t1015 * t659 * t1935 + 0.5e5 / 0.6561e4 * t1536 * t1014 * t107 * t1942 + 0.25e4 / 0.243e3 * t1009) * t85 + t1027 * t167);

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rholapl30 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rhotau30 = t1034 - t1038 + t1044 + rho[0] * (-0.1e5 / 0.81e2 * t1017 - 0.4e5 / 0.729e3 * t1031 * t702 * t1935 + 0.2e4 / 0.81e2 * t1032 * t1326 + 0.4e6 / 0.6561e4 * t1060 * t1061 * t1030 * t107 * t1942 - 0.1e5 / 0.729e3 * t1069 * t1036 + 0.5e5 / 0.729e3 * t1021 + (0.1e5 / 0.81e2 * t1023 + 0.4e5 / 0.729e3 * t1031 * t659 * t1935 - 0.4e6 / 0.6561e4 * t1536 * t1030 * t107 * t1942 - 0.5e5 / 0.729e3 * t1025) * t85 + t1043 * t167);

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t2054 = 0.1e1 / t4 / t980 / t8;
  t2056 = t2 * t2054 * t659;
  t2060 = t1061 * t2054 * t1064;
  tv4sigma40 = rho[0] * (-0.625e3 / 0.46656e5 * t2056 * t1431 + 0.3125e4 / 0.209952e6 * t1060 * t2060 + (0.625e3 / 0.46656e5 * t2056 * t1382 - 0.3125e4 / 0.209952e6 * t1385 * t2060) * t85);

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  t2071 = 0.1e1 / t4 / t1927;
  t2073 = t2 * t2071 * t659;
  t2077 = t1061 * t2071 * t1064;
  tv4sigma3tau0 = rho[0] * (0.625e3 / 0.5832e4 * t2073 * t1431 - 0.3125e4 / 0.26244e5 * t1060 * t2077 + (-0.625e3 / 0.5832e4 * t2073 * t1382 + 0.3125e4 / 0.26244e5 * t1385 * t2077) * t85);

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  t2088 = 0.1e1 / t4 / t980;
  t2090 = t2 * t2088 * t659;
  t2094 = t1061 * t2088 * t1064;
  tv4sigma2tau20 = rho[0] * (-0.625e3 / 0.729e3 * t2090 * t1431 + 0.625e4 / 0.6561e4 * t1060 * t2094 + (0.625e3 / 0.729e3 * t2090 * t1382 - 0.625e4 / 0.6561e4 * t1385 * t2094) * t85);

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigmalapl30 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  t2105 = 0.1e1 / t4 / t997;
  t2107 = t2 * t2105 * t659;
  t2111 = t1061 * t2105 * t1064;
  tv4sigmatau30 = rho[0] * (0.5e4 / 0.729e3 * t2107 * t1431 - 0.5e5 / 0.6561e4 * t1060 * t2111 + (-0.5e4 / 0.729e3 * t2107 * t1382 + 0.5e5 / 0.6561e4 * t1385 * t2111) * t85);

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4lapl40 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  t2122 = t2 * t1352 * t659;
  t2126 = t1061 * t1352 * t1064;
  tv4tau40 = rho[0] * (-0.4e5 / 0.729e3 * t2122 * t1431 + 0.4e6 / 0.6561e4 * t1060 * t2126 + (0.4e5 / 0.729e3 * t2122 * t1382 - 0.4e6 / 0.6561e4 * t1385 * t2126) * t85);

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t9, t10;
  double t11, t12, t13, t14, t15, t16, t17, t18;
  double t19, t21, t22, t23, t24, t25, t26, t27;
  double t28, t30, t31, t32, t33, t35, t38, t39;
  double t40, t41, t42, t43, t44, t45, t46, t47;
  double t48, t50, t53, t54, t55, t56, t58, t59;
  double t60, t61, t62, t63, t66, t67, t68, t69;
  double t70, t71, t72, t75, t77, t78, t81, t83;
  double t84, t85, t88, t90, t93, t94, t96, t97;
  double t98, t99, t100, t101, t102, t103, t105, t106;
  double t107, t109, t110, t113, t114, t116, t121, t124;
  double t125, t129, t134, t137, t138, t139, t141, t142;
  double t146, t147, t148, t150, t151, t152, t153, t154;
  double t156, t157, tzk0;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t7 = tau[0] * t6;
  t8 = rho[0] - rho[1];
  t9 = rho[0] + rho[1];
  t10 = 0.1e1 / t9;
  t11 = t8 * t10;
  t12 = 0.1e1 + t11;
  t13 = t12 / 0.2e1;
  t14 = POW_1_3(t13);
  t15 = t14 * t14;
  t16 = t15 * t13;
  t17 = t7 * t16;
  t18 = POW_1_3(rho[1]);
  t19 = t18 * t18;
  t21 = 0.1e1 / t19 / rho[1];
  t22 = tau[1] * t21;
  t23 = 0.1e1 - t11;
  t24 = t23 / 0.2e1;
  t25 = POW_1_3(t24);
  t26 = t25 * t25;
  t27 = t26 * t24;
  t28 = t22 * t27;
  t30 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t31 = t9 * t9;
  t32 = POW_1_3(t9);
  t33 = t32 * t32;
  t35 = 0.1e1 / t33 / t31;
  t38 = t17 + t28 - t30 * t35 / 0.8e1;
  t39 = t2 * t38;
  t40 = M_CBRT6;
  t41 = M_PI * M_PI;
  t42 = POW_1_3(t41);
  t43 = t42 * t42;
  t44 = 0.1e1 / t43;
  t45 = t40 * t44;
  t46 = t39 * t45;
  t47 = M_CBRT2;
  t48 = t47 * t47;
  t50 = t45 * t48;
  t53 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t38 * t50;
  t54 = 0.1e1 / t53;
  t55 = t48 * t54;
  t56 = t31 * t31;
  t58 = 0.1e1 / t33 / t56;
  t59 = t30 * t58;
  t60 = t17 + t28;
  t61 = 0.1e1 / t60;
  t62 = t8 * t8;
  t63 = t61 * t62;
  t66 = 0.1e1 - t59 * t63 / 0.8e1;
  t67 = M_CBRT3;
  t68 = 0.1e1 / M_PI;
  t69 = POW_1_3(t68);
  t70 = t67 * t69;
  t71 = M_CBRT4;
  t72 = t71 * t71;
  t75 = t70 * t72 / t32;
  t77 = 0.1e1 + 0.53425e-1 * t75;
  t78 = sqrt(t75);
  t81 = POW_3_2(t75);
  t83 = t67 * t67;
  t84 = t69 * t69;
  t85 = t83 * t84;
  t88 = t85 * t71 / t33;
  t90 = 0.379785e1 * t78 + 0.8969e0 * t75 + 0.204775e0 * t81 + 0.123235e0 * t88;
  t93 = 0.1e1 + 0.16081979498692535067e2 / t90;
  t94 = log(t93);
  t96 = 0.621814e-1 * t77 * t94;
  t97 = t62 * t62;
  t98 = 0.1e1 / t56;
  t99 = t97 * t98;
  t100 = t12 <= p->zeta_threshold;
  t101 = POW_1_3(p->zeta_threshold);
  t102 = t101 * p->zeta_threshold;
  t103 = POW_1_3(t12);
  t105 = my_piecewise3(t100, t102, t103 * t12);
  t106 = t23 <= p->zeta_threshold;
  t107 = POW_1_3(t23);
  t109 = my_piecewise3(t106, t102, t107 * t23);
  t110 = t105 + t109 - 0.2e1;
  t113 = 0.1e1 / (0.2e1 * t47 - 0.2e1);
  t114 = t110 * t113;
  t116 = 0.1e1 + 0.5137e-1 * t75;
  t121 = 0.705945e1 * t78 + 0.1549425e1 * t75 + 0.420775e0 * t81 + 0.1562925e0 * t88;
  t124 = 0.1e1 + 0.32163958997385070134e2 / t121;
  t125 = log(t124);
  t129 = 0.1e1 + 0.278125e-1 * t75;
  t134 = 0.51785e1 * t78 + 0.905775e0 * t75 + 0.1100325e0 * t81 + 0.1241775e0 * t88;
  t137 = 0.1e1 + 0.29608749977793437516e2 / t134;
  t138 = log(t137);
  t139 = t129 * t138;
  t141 = -0.310907e-1 * t116 * t125 + t96 - 0.19751673498613801407e-1 * t139;
  t142 = t114 * t141;
  t146 = -t96 + t99 * t142 + 0.19751673498613801407e-1 * t114 * t139;
  t147 = t66 * t146;
  t148 = t55 * t147;
  t150 = 0.5e1 / 0.9e1 * t46 * t148;
  t151 = t39 * t40;
  t152 = t44 * t48;
  t153 = t152 * t54;
  t154 = t151 * t153;
  t156 = 0.1e1 - 0.5e1 / 0.9e1 * t154;
  t157 = t156 * t146;
  tzk0 = t150 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t9, t10;
  double t11, t12, t13, t14, t15, t16, t17, t18;
  double t19, t21, t22, t23, t24, t25, t26, t27;
  double t28, t30, t31, t32, t33, t35, t38, t39;
  double t40, t41, t42, t43, t44, t45, t46, t47;
  double t48, t50, t53, t54, t55, t56, t58, t59;
  double t60, t61, t62, t63, t66, t67, t68, t69;
  double t70, t71, t72, t75, t77, t78, t81, t83;
  double t84, t85, t88, t90, t93, t94, t96, t97;
  double t98, t99, t100, t101, t102, t103, t105, t106;
  double t107, t109, t110, t113, t114, t116, t121, t124;
  double t125, t129, t134, t137, t138, t139, t141, t142;
  double t146, t147, t148, t150, t151, t152, t153, t154;
  double t156, t157, tzk0;

  double t158, t160, t161, t162, t164, t165, t166, t167;
  double t168, t169, t171, t172, t173, t175, t177, t179;
  double t180, t181, t182, t183, t184, t185, t187, t188;
  double t189, t190, t191, t192, t193, t194, t195, t196;
  double t197, t198, t199, t201, t202, t204, t205, t206;
  double t207, t209, t210, t213, t215, t216, t217, t218;
  double t219, t220, t222, t223, t226, t227, t228, t229;
  double t231, t232, t233, t234, t236, t238, t239, t240;
  double t245, t247, t248, t249, t251, t252, t253, t255;
  double t256, t257, t259, t262, t263, t266, t268, t269;
  double t274, t275, t276, t281, t282, t283, t289, t290;
  double t291, t296, t297, t298, t301, t302, t303, t306;
  double t308, t310, t311, t313, t315, t316, t317, t318;
  double t319, t320, t321, t322, t324, t325, t326, t327;
  double t330, t331, t332, tvrho0, t335, t336, t337, t338;
  double t340, t342, t343, t344, t346, t347, t348, t350;
  double t351, t352, t353, t354, t355, t356, t357, t358;
  double t360, t361, t364, t365, t366, t367, t368, t371;
  double t372, t375, t377, t378, t382, t383, t384, t385;
  double t386, t387, t388, t390, t391, t394, t395, t396;
  double tvrho1, t399, t400, t401, t402, t403, t405, t406;
  double t407, t408, t409, t410, t411, t412, t414, t416;
  double t418, t420, t421, tvsigma0, t423, t424, t425, t428;
  double t429, tvsigma1, tvsigma2, tvlapl0, tvlapl1, t431, t432, t433;
  double t434, t435, t436, t438, t439, t440, t441, t442;
  double t444, t445, t446, t447, t448, t449, t451, t452;
  double t453, t456, t459, t460, tvtau0, t462, t463, t464;
  double t466, t467, t468, t471, t472, t473, t474, t475;
  double t477, t478, t479, t484, t485, tvtau1;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t7 = tau[0] * t6;
  t8 = rho[0] - rho[1];
  t9 = rho[0] + rho[1];
  t10 = 0.1e1 / t9;
  t11 = t8 * t10;
  t12 = 0.1e1 + t11;
  t13 = t12 / 0.2e1;
  t14 = POW_1_3(t13);
  t15 = t14 * t14;
  t16 = t15 * t13;
  t17 = t7 * t16;
  t18 = POW_1_3(rho[1]);
  t19 = t18 * t18;
  t21 = 0.1e1 / t19 / rho[1];
  t22 = tau[1] * t21;
  t23 = 0.1e1 - t11;
  t24 = t23 / 0.2e1;
  t25 = POW_1_3(t24);
  t26 = t25 * t25;
  t27 = t26 * t24;
  t28 = t22 * t27;
  t30 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t31 = t9 * t9;
  t32 = POW_1_3(t9);
  t33 = t32 * t32;
  t35 = 0.1e1 / t33 / t31;
  t38 = t17 + t28 - t30 * t35 / 0.8e1;
  t39 = t2 * t38;
  t40 = M_CBRT6;
  t41 = M_PI * M_PI;
  t42 = POW_1_3(t41);
  t43 = t42 * t42;
  t44 = 0.1e1 / t43;
  t45 = t40 * t44;
  t46 = t39 * t45;
  t47 = M_CBRT2;
  t48 = t47 * t47;
  t50 = t45 * t48;
  t53 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t38 * t50;
  t54 = 0.1e1 / t53;
  t55 = t48 * t54;
  t56 = t31 * t31;
  t58 = 0.1e1 / t33 / t56;
  t59 = t30 * t58;
  t60 = t17 + t28;
  t61 = 0.1e1 / t60;
  t62 = t8 * t8;
  t63 = t61 * t62;
  t66 = 0.1e1 - t59 * t63 / 0.8e1;
  t67 = M_CBRT3;
  t68 = 0.1e1 / M_PI;
  t69 = POW_1_3(t68);
  t70 = t67 * t69;
  t71 = M_CBRT4;
  t72 = t71 * t71;
  t75 = t70 * t72 / t32;
  t77 = 0.1e1 + 0.53425e-1 * t75;
  t78 = sqrt(t75);
  t81 = POW_3_2(t75);
  t83 = t67 * t67;
  t84 = t69 * t69;
  t85 = t83 * t84;
  t88 = t85 * t71 / t33;
  t90 = 0.379785e1 * t78 + 0.8969e0 * t75 + 0.204775e0 * t81 + 0.123235e0 * t88;
  t93 = 0.1e1 + 0.16081979498692535067e2 / t90;
  t94 = log(t93);
  t96 = 0.621814e-1 * t77 * t94;
  t97 = t62 * t62;
  t98 = 0.1e1 / t56;
  t99 = t97 * t98;
  t100 = t12 <= p->zeta_threshold;
  t101 = POW_1_3(p->zeta_threshold);
  t102 = t101 * p->zeta_threshold;
  t103 = POW_1_3(t12);
  t105 = my_piecewise3(t100, t102, t103 * t12);
  t106 = t23 <= p->zeta_threshold;
  t107 = POW_1_3(t23);
  t109 = my_piecewise3(t106, t102, t107 * t23);
  t110 = t105 + t109 - 0.2e1;
  t113 = 0.1e1 / (0.2e1 * t47 - 0.2e1);
  t114 = t110 * t113;
  t116 = 0.1e1 + 0.5137e-1 * t75;
  t121 = 0.705945e1 * t78 + 0.1549425e1 * t75 + 0.420775e0 * t81 + 0.1562925e0 * t88;
  t124 = 0.1e1 + 0.32163958997385070134e2 / t121;
  t125 = log(t124);
  t129 = 0.1e1 + 0.278125e-1 * t75;
  t134 = 0.51785e1 * t78 + 0.905775e0 * t75 + 0.1100325e0 * t81 + 0.1241775e0 * t88;
  t137 = 0.1e1 + 0.29608749977793437516e2 / t134;
  t138 = log(t137);
  t139 = t129 * t138;
  t141 = -0.310907e-1 * t116 * t125 + t96 - 0.19751673498613801407e-1 * t139;
  t142 = t114 * t141;
  t146 = -t96 + t99 * t142 + 0.19751673498613801407e-1 * t114 * t139;
  t147 = t66 * t146;
  t148 = t55 * t147;
  t150 = 0.5e1 / 0.9e1 * t46 * t148;
  t151 = t39 * t40;
  t152 = t44 * t48;
  t153 = t152 * t54;
  t154 = t151 * t153;
  t156 = 0.1e1 - 0.5e1 / 0.9e1 * t154;
  t157 = t156 * t146;
  tzk0 = t150 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = rho[0] * rho[0];
  t160 = 0.1e1 / t4 / t158;
  t161 = tau[0] * t160;
  t162 = t161 * t16;
  t164 = 0.1e1 / t31;
  t165 = t8 * t164;
  t166 = t10 - t165;
  t167 = t166 / 0.2e1;
  t168 = t15 * t167;
  t169 = t7 * t168;
  t171 = -t167;
  t172 = t26 * t171;
  t173 = t22 * t172;
  t175 = t31 * t9;
  t177 = 0.1e1 / t33 / t175;
  t179 = t30 * t177 / 0.3e1;
  t180 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173 + t179;
  t181 = t2 * t180;
  t182 = t181 * t45;
  t183 = t182 * t148;
  t184 = 0.5e1 / 0.9e1 * t183;
  t185 = t40 * t40;
  t187 = 0.1e1 / t42 / t41;
  t188 = t185 * t187;
  t189 = t188 * t47;
  t190 = t39 * t189;
  t191 = t53 * t53;
  t192 = 0.1e1 / t191;
  t193 = t192 * t66;
  t194 = t146 * params->c;
  t195 = t194 * t180;
  t196 = t193 * t195;
  t197 = t190 * t196;
  t198 = 0.5e2 / 0.81e2 * t197;
  t199 = t56 * t9;
  t201 = 0.1e1 / t33 / t199;
  t202 = t30 * t201;
  t204 = 0.7e1 / 0.12e2 * t202 * t63;
  t205 = t60 * t60;
  t206 = 0.1e1 / t205;
  t207 = t206 * t62;
  t209 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173;
  t210 = t207 * t209;
  t213 = t61 * t8;
  t215 = t59 * t213 / 0.4e1;
  t216 = t204 + t59 * t210 / 0.8e1 - t215;
  t217 = t216 * t146;
  t218 = t55 * t217;
  t219 = t46 * t218;
  t220 = 0.5e1 / 0.9e1 * t219;
  t222 = 0.1e1 / t32 / t9;
  t223 = t72 * t222;
  t226 = 0.11073470983333333333e-2 * t70 * t223 * t94;
  t227 = t90 * t90;
  t228 = 0.1e1 / t227;
  t229 = t77 * t228;
  t231 = 0.1e1 / t78 * t67;
  t232 = t69 * t72;
  t233 = t232 * t222;
  t234 = t231 * t233;
  t236 = t70 * t223;
  t238 = sqrt(t75);
  t239 = t238 * t67;
  t240 = t239 * t233;
  t245 = t85 * t71 / t33 / t9;
  t247 = -0.632975e0 * t234 - 0.29896666666666666667e0 * t236 - 0.1023875e0 * t240 - 0.82156666666666666667e-1 * t245;
  t248 = 0.1e1 / t93;
  t249 = t247 * t248;
  t251 = 0.1e1 * t229 * t249;
  t252 = t62 * t8;
  t253 = t252 * t98;
  t255 = 0.4e1 * t253 * t142;
  t256 = 0.1e1 / t199;
  t257 = t97 * t256;
  t259 = 0.4e1 * t257 * t142;
  t262 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t166);
  t263 = -t166;
  t266 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t263);
  t268 = (t262 + t266) * t113;
  t269 = t268 * t141;
  t274 = t121 * t121;
  t275 = 0.1e1 / t274;
  t276 = t116 * t275;
  t281 = -0.1176575e1 * t234 - 0.516475e0 * t236 - 0.2103875e0 * t240 - 0.104195e0 * t245;
  t282 = 0.1e1 / t124;
  t283 = t281 * t282;
  t289 = t134 * t134;
  t290 = 0.1e1 / t289;
  t291 = t129 * t290;
  t296 = -0.86308333333333333334e0 * t234 - 0.301925e0 * t236 - 0.5501625e-1 * t240 - 0.82785e-1 * t245;
  t297 = 0.1e1 / t137;
  t298 = t296 * t297;
  t301 = 0.53237641966666666666e-3 * t70 * t223 * t125 + 0.1e1 * t276 * t283 - t226 - t251 + 0.18311447306006545054e-3 * t70 * t223 * t138 + 0.5848223622634646207e0 * t291 * t298;
  t302 = t114 * t301;
  t303 = t99 * t302;
  t306 = t114 * t67;
  t308 = t232 * t222 * t138;
  t310 = 0.18311447306006545054e-3 * t306 * t308;
  t311 = t114 * t129;
  t313 = t290 * t296 * t297;
  t315 = 0.5848223622634646207e0 * t311 * t313;
  t316 = t226 + t251 + t255 - t259 + t99 * t269 + t303 + 0.19751673498613801407e-1 * t268 * t139 - t310 - t315;
  t317 = t66 * t316;
  t318 = t55 * t317;
  t319 = t46 * t318;
  t320 = 0.5e1 / 0.9e1 * t319;
  t321 = t181 * t40;
  t322 = t321 * t153;
  t324 = t39 * t188;
  t325 = t47 * t192;
  t326 = params->c * t180;
  t327 = t325 * t326;
  t330 = -0.5e1 / 0.9e1 * t322 + 0.5e2 / 0.81e2 * t324 * t327;
  t331 = t330 * t146;
  t332 = t156 * t316;
  tvrho0 = t150 + t157 + t9 * (t184 - t198 + t220 + t320 + t331 + t332);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t335 = -t10 - t165;
  t336 = t335 / 0.2e1;
  t337 = t15 * t336;
  t338 = t7 * t337;
  t340 = rho[1] * rho[1];
  t342 = 0.1e1 / t19 / t340;
  t343 = tau[1] * t342;
  t344 = t343 * t27;
  t346 = -t336;
  t347 = t26 * t346;
  t348 = t22 * t347;
  t350 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348 + t179;
  t351 = t2 * t350;
  t352 = t351 * t45;
  t353 = t352 * t148;
  t354 = 0.5e1 / 0.9e1 * t353;
  t355 = t194 * t350;
  t356 = t193 * t355;
  t357 = t190 * t356;
  t358 = 0.5e2 / 0.81e2 * t357;
  t360 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348;
  t361 = t207 * t360;
  t364 = t204 + t59 * t361 / 0.8e1 + t215;
  t365 = t364 * t146;
  t366 = t55 * t365;
  t367 = t46 * t366;
  t368 = 0.5e1 / 0.9e1 * t367;
  t371 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t335);
  t372 = -t335;
  t375 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t372);
  t377 = (t371 + t375) * t113;
  t378 = t377 * t141;
  t382 = t226 + t251 - t255 - t259 + t99 * t378 + t303 + 0.19751673498613801407e-1 * t377 * t139 - t310 - t315;
  t383 = t66 * t382;
  t384 = t55 * t383;
  t385 = t46 * t384;
  t386 = 0.5e1 / 0.9e1 * t385;
  t387 = t351 * t40;
  t388 = t387 * t153;
  t390 = params->c * t350;
  t391 = t325 * t390;
  t394 = -0.5e1 / 0.9e1 * t388 + 0.5e2 / 0.81e2 * t324 * t391;
  t395 = t394 * t146;
  t396 = t156 * t382;
  tvrho1 = t150 + t157 + t9 * (t354 - t358 + t368 + t386 + t395 + t396);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t399 = t2 * t35;
  t400 = t399 * t45;
  t401 = t400 * t148;
  t402 = 0.5e1 / 0.72e2 * t401;
  t403 = t194 * t35;
  t405 = t190 * t193 * t403;
  t406 = 0.25e2 / 0.324e3 * t405;
  t407 = t39 * t50;
  t408 = t54 * t58;
  t409 = t63 * t146;
  t410 = t408 * t409;
  t411 = t407 * t410;
  t412 = 0.5e1 / 0.72e2 * t411;
  t414 = t399 * t40 * t153;
  t416 = params->c * t35;
  t418 = t324 * t325 * t416;
  t420 = 0.5e1 / 0.72e2 * t414 - 0.25e2 / 0.324e3 * t418;
  t421 = t420 * t146;
  tvsigma0 = t9 * (-t402 + t406 - t412 + t421);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t423 = 0.5e1 / 0.36e2 * t401;
  t424 = 0.25e2 / 0.162e3 * t405;
  t425 = 0.5e1 / 0.36e2 * t411;
  t428 = 0.5e1 / 0.36e2 * t414 - 0.25e2 / 0.162e3 * t418;
  t429 = t428 * t146;
  tvsigma1 = t9 * (-t423 + t424 - t425 + t429);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t431 = t2 * t6;
  t432 = t16 * t40;
  t433 = t431 * t432;
  t434 = t54 * t66;
  t435 = t434 * t146;
  t436 = t152 * t435;
  t438 = 0.5e1 / 0.9e1 * t433 * t436;
  t439 = t193 * t146;
  t440 = params->c * t6;
  t441 = t440 * t16;
  t442 = t439 * t441;
  t444 = 0.5e2 / 0.81e2 * t190 * t442;
  t445 = t59 * t206;
  t446 = t62 * t6;
  t447 = t16 * t146;
  t448 = t446 * t447;
  t449 = t445 * t448;
  t451 = 0.5e1 / 0.72e2 * t154 * t449;
  t452 = t431 * t16;
  t453 = t45 * t55;
  t456 = t325 * t441;
  t459 = -0.5e1 / 0.9e1 * t452 * t453 + 0.5e2 / 0.81e2 * t324 * t456;
  t460 = t459 * t146;
  tvtau0 = t9 * (t438 - t444 + t451 + t460);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t462 = t2 * t21;
  t463 = t27 * t40;
  t464 = t462 * t463;
  t466 = 0.5e1 / 0.9e1 * t464 * t436;
  t467 = params->c * t21;
  t468 = t467 * t27;
  t471 = 0.5e2 / 0.81e2 * t190 * t439 * t468;
  t472 = t62 * t21;
  t473 = t27 * t146;
  t474 = t472 * t473;
  t475 = t445 * t474;
  t477 = 0.5e1 / 0.72e2 * t154 * t475;
  t478 = t462 * t27;
  t479 = t478 * t453;
  t484 = -0.5e1 / 0.9e1 * t479 + 0.5e2 / 0.81e2 * t324 * t325 * t468;
  t485 = t484 * t146;
  tvtau1 = t9 * (t466 - t471 + t477 + t485);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t9, t10;
  double t11, t12, t13, t14, t15, t16, t17, t18;
  double t19, t21, t22, t23, t24, t25, t26, t27;
  double t28, t30, t31, t32, t33, t35, t38, t39;
  double t40, t41, t42, t43, t44, t45, t46, t47;
  double t48, t50, t53, t54, t55, t56, t58, t59;
  double t60, t61, t62, t63, t66, t67, t68, t69;
  double t70, t71, t72, t75, t77, t78, t81, t83;
  double t84, t85, t88, t90, t93, t94, t96, t97;
  double t98, t99, t100, t101, t102, t103, t105, t106;
  double t107, t109, t110, t113, t114, t116, t121, t124;
  double t125, t129, t134, t137, t138, t139, t141, t142;
  double t146, t147, t148, t150, t151, t152, t153, t154;
  double t156, t157, tzk0;

  double t158, t160, t161, t162, t164, t165, t166, t167;
  double t168, t169, t171, t172, t173, t175, t177, t179;
  double t180, t181, t182, t183, t184, t185, t187, t188;
  double t189, t190, t191, t192, t193, t194, t195, t196;
  double t197, t198, t199, t201, t202, t204, t205, t206;
  double t207, t209, t210, t213, t215, t216, t217, t218;
  double t219, t220, t222, t223, t226, t227, t228, t229;
  double t231, t232, t233, t234, t236, t238, t239, t240;
  double t245, t247, t248, t249, t251, t252, t253, t255;
  double t256, t257, t259, t262, t263, t266, t268, t269;
  double t274, t275, t276, t281, t282, t283, t289, t290;
  double t291, t296, t297, t298, t301, t302, t303, t306;
  double t308, t310, t311, t313, t315, t316, t317, t318;
  double t319, t320, t321, t322, t324, t325, t326, t327;
  double t330, t331, t332, tvrho0, t335, t336, t337, t338;
  double t340, t342, t343, t344, t346, t347, t348, t350;
  double t351, t352, t353, t354, t355, t356, t357, t358;
  double t360, t361, t364, t365, t366, t367, t368, t371;
  double t372, t375, t377, t378, t382, t383, t384, t385;
  double t386, t387, t388, t390, t391, t394, t395, t396;
  double tvrho1, t399, t400, t401, t402, t403, t405, t406;
  double t407, t408, t409, t410, t411, t412, t414, t416;
  double t418, t420, t421, tvsigma0, t423, t424, t425, t428;
  double t429, tvsigma1, tvsigma2, tvlapl0, tvlapl1, t431, t432, t433;
  double t434, t435, t436, t438, t439, t440, t441, t442;
  double t444, t445, t446, t447, t448, t449, t451, t452;
  double t453, t456, t459, t460, tvtau0, t462, t463, t464;
  double t466, t467, t468, t471, t472, t473, t474, t475;
  double t477, t478, t479, t484, t485, tvtau1;

  double t493, t495, t496, t498, t500, t501, t502, t503;
  double t505, t506, t507, t508, t509, t511, t512, t513;
  double t514, t516, t517, t518, t520, t521, t522, t523;
  double t524, t525, t526, t527, t528, t529, t530, t531;
  double t532, t533, t534, t535, t536, t537, t538, t539;
  double t541, t542, t543, t544, t545, t546, t547, t548;
  double t549, t550, t551, t552, t553, t554, t555, t556;
  double t557, t558, t559, t560, t561, t562, t564, t565;
  double t567, t568, t571, t573, t574, t575, t576, t579;
  double t580, t581, t583, t584, t588, t589, t590, t591;
  double t592, t593, t594, t595, t596, t597, t598, t599;
  double t600, t601, t602, t603, t604, t606, t607, t608;
  double t612, t613, t614, t615, t618, t619, t620, t622;
  double t623, t625, t626, t627, t629, t632, t634, t636;
  double t638, t639, t640, t641, t644, t648, t649, t650;
  double t651, t654, t658, t660, t669, t670, t672, t673;
  double t674, t675, t676, t677, t678, t679, t681, t685;
  double t686, t690, t691, t692, t693, t694, t703, t704;
  double t707, t708, t709, t710, t711, t712, t717, t718;
  double t721, t722, t723, t724, t725, t727, t731, t735;
  double t736, t737, t738, t741, t744, t745, t748, t749;
  double t750, t751, t753, t754, t756, t759, t760, t761;
  double t764, t766, t768, t769, t770, t772, t773, t775;
  double t776, t778, t779, t780, t782, t783, t784, t787;
  double t789, t790, t791, t792, t793, t794, t795, t796;
  double t797, t799, t800, t801, t802, t805, t806, t807;
  double t810, t811, t814, t815, t816, t817, t818, t819;
  double tv2rho20, t822, t823, t824, t826, t827, t828, t830;
  double t832, t833, t834, t836, t837, t838, t840, t841;
  double t842, t843, t844, t846, t847, t849, t851, t853;
  double t854, t855, t856, t858, t859, t861, t862, t863;
  double t865, t866, t867, t869, t871, t872, t873, t876;
  double t878, t879, t880, t883, t884, t886, t887, t891;
  double t892, t893, t894, t896, t897, t898, t900, t902;
  double t903, t904, t905, t907, t908, t909, t911, t913;
  double t915, t918, t922, t923, t926, t930, t932, t933;
  double t935, t936, t937, t938, t941, t945, t946, t950;
  double t951, t952, t953, t954, t956, t957, t959, t962;
  double t963, t966, t967, t970, t971, t972, t973, t974;
  double t975, tv2rho21, t983, t984, t986, t987, t988, t990;
  double t991, t993, t994, t996, t998, t999, t1000, t1002;
  double t1003, t1004, t1006, t1007, t1008, t1009, t1010, t1011;
  double t1012, t1013, t1014, t1015, t1016, t1017, t1018, t1019;
  double t1020, t1021, t1022, t1023, t1024, t1025, t1026, t1027;
  double t1028, t1029, t1030, t1031, t1032, t1033, t1034, t1035;
  double t1037, t1038, t1042, t1043, t1046, t1047, t1048, t1049;
  double t1050, t1051, t1052, t1053, t1054, t1055, t1058, t1062;
  double t1063, t1066, t1070, t1072, t1073, t1081, t1083, t1084;
  double t1085, t1086, t1087, t1088, t1089, t1090, t1092, t1095;
  double t1098, t1099, t1102, t1103, t1104, t1105, t1106, t1107;
  double tv2rho22, t1109, t1110, t1111, t1112, t1113, t1114, t1115;
  double t1116, t1117, t1118, t1119, t1120, t1121, t1122, t1123;
  double t1124, t1126, t1127, t1128, t1130, t1131, t1132, t1134;
  double t1135, t1136, t1137, t1138, t1139, t1140, t1141, t1142;
  double t1143, t1144, t1145, t1146, t1147, t1148, t1149, t1150;
  double t1151, t1152, t1153, t1154, t1155, t1156, t1157, t1158;
  double t1159, t1160, t1161, t1162, t1163, t1164, t1166, t1167;
  double t1168, t1169, t1171, t1172, t1173, t1175, t1177, t1178;
  double t1179, t1180, t1181, t1182, tv2rhosigma0, t1184, t1185, t1186;
  double t1187, t1188, t1189, t1190, t1191, t1192, t1193, t1194;
  double t1195, t1196, t1197, t1198, t1201, t1202, t1203, t1204;
  double t1205, tv2rhosigma1, tv2rhosigma2, t1207, t1208, t1209, t1210, t1211;
  double t1212, t1213, t1214, t1215, t1216, t1218, t1219, t1220;
  double t1222, t1223, t1224, t1225, t1226, t1227, t1228, t1229;
  double t1230, t1231, t1232, t1233, t1234, t1235, t1236, t1237;
  double t1238, t1240, t1241, t1242, t1244, t1245, t1246, t1247;
  double tv2rhosigma3, t1249, t1250, t1251, t1252, t1253, t1254, t1255;
  double t1256, t1257, t1258, t1261, t1262, t1263, t1264, tv2rhosigma4;
  double tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3, t1266, t1267, t1268;
  double t1269, t1270, t1271, t1272, t1274, t1275, t1276, t1277;
  double t1278, t1279, t1280, t1281, t1282, t1283, t1284, t1286;
  double t1287, t1288, t1290, t1291, t1292, t1293, t1294, t1295;
  double t1296, t1297, t1298, t1299, t1300, t1301, t1302, t1303;
  double t1304, t1305, t1306, t1307, t1308, t1309, t1310, t1311;
  double t1312, t1313, t1314, t1315, t1317, t1318, t1319, t1320;
  double t1321, t1322, t1323, t1324, t1325, t1326, t1327, t1328;
  double t1329, t1330, t1331, t1332, t1333, t1334, t1335, t1336;
  double t1337, t1338, t1339, t1340, t1341, t1342, t1343, t1344;
  double t1345, t1346, t1347, t1348, t1349, t1350, t1351, t1352;
  double t1353, t1354, t1355, t1356, t1357, t1358, t1359, t1360;
  double t1361, t1362, t1363, t1364, t1365, t1368, t1369, t1370;
  double t1373, t1375, t1378, t1379, t1380, t1383, t1389, t1390;
  double t1391, t1392, tv2rhotau0, t1394, t1395, t1396, t1398, t1399;
  double t1400, t1401, t1402, t1403, t1404, t1405, t1406, t1407;
  double t1408, t1409, t1410, t1411, t1412, t1413, t1414, t1416;
  double t1417, t1419, t1420, t1421, t1422, t1424, t1425, t1426;
  double t1427, t1428, t1429, t1430, t1431, t1432, t1433, t1434;
  double t1435, t1436, t1437, t1438, t1439, t1440, t1441, t1442;
  double t1443, t1444, t1445, t1446, t1447, t1448, t1449, t1450;
  double t1451, t1452, t1453, t1454, t1455, t1456, t1457, t1460;
  double t1463, t1464, t1465, t1471, t1472, t1473, t1474, tv2rhotau1;
  double t1477, t1478, t1479, t1480, t1481, t1482, t1483, t1485;
  double t1486, t1487, t1489, t1490, t1491, t1492, t1493, t1494;
  double t1495, t1496, t1497, t1498, t1499, t1500, t1501, t1502;
  double t1503, t1504, t1506, t1507, t1508, t1509, t1510, t1511;
  double t1512, t1513, t1514, t1515, t1516, t1517, t1518, t1519;
  double t1520, t1521, t1522, t1523, t1524, t1525, t1526, t1527;
  double t1528, t1529, t1530, t1534, t1537, t1538, t1544, t1545;
  double t1546, t1547, tv2rhotau2, t1549, t1550, t1551, t1552, t1554;
  double t1555, t1556, t1557, t1558, t1559, t1560, t1561, t1562;
  double t1563, t1564, t1565, t1566, t1568, t1569, t1571, t1572;
  double t1573, t1574, t1576, t1577, t1578, t1580, t1581, t1582;
  double t1583, t1584, t1585, t1586, t1587, t1588, t1589, t1590;
  double t1591, t1592, t1593, t1594, t1595, t1596, t1597, t1598;
  double t1599, t1600, t1601, t1602, t1603, t1604, t1605, t1606;
  double t1607, t1608, t1610, t1611, t1616, t1617, t1626, t1627;
  double t1628, t1629, tv2rhotau3, t1632, t1633, t1634, t1635, t1636;
  double t1637, t1639, t1640, t1641, t1642, t1643, t1644, t1645;
  double t1647, t1648, t1649, t1650, t1651, t1652, t1653, t1654;
  double t1656, t1659, t1661, t1662, tv2sigma20, t1664, t1665, t1666;
  double t1667, t1670, t1671, tv2sigma21, tv2sigma22, t1673, t1674, t1675;
  double t1676, t1679, t1680, tv2sigma23, tv2sigma24, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1;
  double tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t1682, t1683, t1684, t1685;
  double t1686, t1687, t1688, t1689, t1690, t1691, t1692, t1693;
  double t1694, t1695, t1696, t1697, t1698, t1699, t1700, t1701;
  double t1702, t1703, t1704, t1705, t1706, t1707, t1708, t1709;
  double t1710, t1711, t1712, t1713, t1714, t1716, t1717, t1719;
  double t1721, t1723, t1724, tv2sigmatau0, t1726, t1727, t1728, t1729;
  double t1730, t1731, t1732, t1733, t1734, t1735, t1736, t1738;
  double t1739, t1740, t1741, t1742, t1743, t1744, t1745, t1746;
  double t1747, t1748, t1749, t1750, t1752, t1754, t1756, t1757;
  double tv2sigmatau1, t1759, t1760, t1761, t1762, t1763, t1764, t1765;
  double t1768, t1769, tv2sigmatau2, t1771, t1772, t1773, t1774, t1775;
  double t1776, t1777, t1780, t1781, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, tv2lapl20;
  double tv2lapl21, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, t1784, t1785;
  double t1786, t1788, t1789, t1790, t1791, t1793, t1794, t1795;
  double t1796, t1797, t1798, t1800, t1801, t1802, t1803, t1805;
  double t1806, t1807, t1808, t1810, t1811, t1812, t1813, t1814;
  double t1816, t1820, t1823, t1824, tv2tau20, t1826, t1828, t1830;
  double t1831, t1832, t1833, t1834, t1836, t1837, t1838, t1839;
  double t1840, t1842, t1843, t1844, t1845, t1847, t1853, t1854;
  double tv2tau21, t1857, t1858, t1859, t1861, t1862, t1863, t1864;
  double t1866, t1867, t1868, t1870, t1871, t1872, t1875, t1876;
  double t1877, t1878, t1880, t1881, t1882, t1883, t1884, t1886;
  double t1887, t1893, t1894, tv2tau22;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t7 = tau[0] * t6;
  t8 = rho[0] - rho[1];
  t9 = rho[0] + rho[1];
  t10 = 0.1e1 / t9;
  t11 = t8 * t10;
  t12 = 0.1e1 + t11;
  t13 = t12 / 0.2e1;
  t14 = POW_1_3(t13);
  t15 = t14 * t14;
  t16 = t15 * t13;
  t17 = t7 * t16;
  t18 = POW_1_3(rho[1]);
  t19 = t18 * t18;
  t21 = 0.1e1 / t19 / rho[1];
  t22 = tau[1] * t21;
  t23 = 0.1e1 - t11;
  t24 = t23 / 0.2e1;
  t25 = POW_1_3(t24);
  t26 = t25 * t25;
  t27 = t26 * t24;
  t28 = t22 * t27;
  t30 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t31 = t9 * t9;
  t32 = POW_1_3(t9);
  t33 = t32 * t32;
  t35 = 0.1e1 / t33 / t31;
  t38 = t17 + t28 - t30 * t35 / 0.8e1;
  t39 = t2 * t38;
  t40 = M_CBRT6;
  t41 = M_PI * M_PI;
  t42 = POW_1_3(t41);
  t43 = t42 * t42;
  t44 = 0.1e1 / t43;
  t45 = t40 * t44;
  t46 = t39 * t45;
  t47 = M_CBRT2;
  t48 = t47 * t47;
  t50 = t45 * t48;
  t53 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t38 * t50;
  t54 = 0.1e1 / t53;
  t55 = t48 * t54;
  t56 = t31 * t31;
  t58 = 0.1e1 / t33 / t56;
  t59 = t30 * t58;
  t60 = t17 + t28;
  t61 = 0.1e1 / t60;
  t62 = t8 * t8;
  t63 = t61 * t62;
  t66 = 0.1e1 - t59 * t63 / 0.8e1;
  t67 = M_CBRT3;
  t68 = 0.1e1 / M_PI;
  t69 = POW_1_3(t68);
  t70 = t67 * t69;
  t71 = M_CBRT4;
  t72 = t71 * t71;
  t75 = t70 * t72 / t32;
  t77 = 0.1e1 + 0.53425e-1 * t75;
  t78 = sqrt(t75);
  t81 = POW_3_2(t75);
  t83 = t67 * t67;
  t84 = t69 * t69;
  t85 = t83 * t84;
  t88 = t85 * t71 / t33;
  t90 = 0.379785e1 * t78 + 0.8969e0 * t75 + 0.204775e0 * t81 + 0.123235e0 * t88;
  t93 = 0.1e1 + 0.16081979498692535067e2 / t90;
  t94 = log(t93);
  t96 = 0.621814e-1 * t77 * t94;
  t97 = t62 * t62;
  t98 = 0.1e1 / t56;
  t99 = t97 * t98;
  t100 = t12 <= p->zeta_threshold;
  t101 = POW_1_3(p->zeta_threshold);
  t102 = t101 * p->zeta_threshold;
  t103 = POW_1_3(t12);
  t105 = my_piecewise3(t100, t102, t103 * t12);
  t106 = t23 <= p->zeta_threshold;
  t107 = POW_1_3(t23);
  t109 = my_piecewise3(t106, t102, t107 * t23);
  t110 = t105 + t109 - 0.2e1;
  t113 = 0.1e1 / (0.2e1 * t47 - 0.2e1);
  t114 = t110 * t113;
  t116 = 0.1e1 + 0.5137e-1 * t75;
  t121 = 0.705945e1 * t78 + 0.1549425e1 * t75 + 0.420775e0 * t81 + 0.1562925e0 * t88;
  t124 = 0.1e1 + 0.32163958997385070134e2 / t121;
  t125 = log(t124);
  t129 = 0.1e1 + 0.278125e-1 * t75;
  t134 = 0.51785e1 * t78 + 0.905775e0 * t75 + 0.1100325e0 * t81 + 0.1241775e0 * t88;
  t137 = 0.1e1 + 0.29608749977793437516e2 / t134;
  t138 = log(t137);
  t139 = t129 * t138;
  t141 = -0.310907e-1 * t116 * t125 + t96 - 0.19751673498613801407e-1 * t139;
  t142 = t114 * t141;
  t146 = -t96 + t99 * t142 + 0.19751673498613801407e-1 * t114 * t139;
  t147 = t66 * t146;
  t148 = t55 * t147;
  t150 = 0.5e1 / 0.9e1 * t46 * t148;
  t151 = t39 * t40;
  t152 = t44 * t48;
  t153 = t152 * t54;
  t154 = t151 * t153;
  t156 = 0.1e1 - 0.5e1 / 0.9e1 * t154;
  t157 = t156 * t146;
  tzk0 = t150 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = rho[0] * rho[0];
  t160 = 0.1e1 / t4 / t158;
  t161 = tau[0] * t160;
  t162 = t161 * t16;
  t164 = 0.1e1 / t31;
  t165 = t8 * t164;
  t166 = t10 - t165;
  t167 = t166 / 0.2e1;
  t168 = t15 * t167;
  t169 = t7 * t168;
  t171 = -t167;
  t172 = t26 * t171;
  t173 = t22 * t172;
  t175 = t31 * t9;
  t177 = 0.1e1 / t33 / t175;
  t179 = t30 * t177 / 0.3e1;
  t180 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173 + t179;
  t181 = t2 * t180;
  t182 = t181 * t45;
  t183 = t182 * t148;
  t184 = 0.5e1 / 0.9e1 * t183;
  t185 = t40 * t40;
  t187 = 0.1e1 / t42 / t41;
  t188 = t185 * t187;
  t189 = t188 * t47;
  t190 = t39 * t189;
  t191 = t53 * t53;
  t192 = 0.1e1 / t191;
  t193 = t192 * t66;
  t194 = t146 * params->c;
  t195 = t194 * t180;
  t196 = t193 * t195;
  t197 = t190 * t196;
  t198 = 0.5e2 / 0.81e2 * t197;
  t199 = t56 * t9;
  t201 = 0.1e1 / t33 / t199;
  t202 = t30 * t201;
  t204 = 0.7e1 / 0.12e2 * t202 * t63;
  t205 = t60 * t60;
  t206 = 0.1e1 / t205;
  t207 = t206 * t62;
  t209 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173;
  t210 = t207 * t209;
  t213 = t61 * t8;
  t215 = t59 * t213 / 0.4e1;
  t216 = t204 + t59 * t210 / 0.8e1 - t215;
  t217 = t216 * t146;
  t218 = t55 * t217;
  t219 = t46 * t218;
  t220 = 0.5e1 / 0.9e1 * t219;
  t222 = 0.1e1 / t32 / t9;
  t223 = t72 * t222;
  t226 = 0.11073470983333333333e-2 * t70 * t223 * t94;
  t227 = t90 * t90;
  t228 = 0.1e1 / t227;
  t229 = t77 * t228;
  t231 = 0.1e1 / t78 * t67;
  t232 = t69 * t72;
  t233 = t232 * t222;
  t234 = t231 * t233;
  t236 = t70 * t223;
  t238 = sqrt(t75);
  t239 = t238 * t67;
  t240 = t239 * t233;
  t245 = t85 * t71 / t33 / t9;
  t247 = -0.632975e0 * t234 - 0.29896666666666666667e0 * t236 - 0.1023875e0 * t240 - 0.82156666666666666667e-1 * t245;
  t248 = 0.1e1 / t93;
  t249 = t247 * t248;
  t251 = 0.1e1 * t229 * t249;
  t252 = t62 * t8;
  t253 = t252 * t98;
  t255 = 0.4e1 * t253 * t142;
  t256 = 0.1e1 / t199;
  t257 = t97 * t256;
  t259 = 0.4e1 * t257 * t142;
  t262 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t166);
  t263 = -t166;
  t266 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t263);
  t268 = (t262 + t266) * t113;
  t269 = t268 * t141;
  t274 = t121 * t121;
  t275 = 0.1e1 / t274;
  t276 = t116 * t275;
  t281 = -0.1176575e1 * t234 - 0.516475e0 * t236 - 0.2103875e0 * t240 - 0.104195e0 * t245;
  t282 = 0.1e1 / t124;
  t283 = t281 * t282;
  t289 = t134 * t134;
  t290 = 0.1e1 / t289;
  t291 = t129 * t290;
  t296 = -0.86308333333333333334e0 * t234 - 0.301925e0 * t236 - 0.5501625e-1 * t240 - 0.82785e-1 * t245;
  t297 = 0.1e1 / t137;
  t298 = t296 * t297;
  t301 = 0.53237641966666666666e-3 * t70 * t223 * t125 + 0.1e1 * t276 * t283 - t226 - t251 + 0.18311447306006545054e-3 * t70 * t223 * t138 + 0.5848223622634646207e0 * t291 * t298;
  t302 = t114 * t301;
  t303 = t99 * t302;
  t306 = t114 * t67;
  t308 = t232 * t222 * t138;
  t310 = 0.18311447306006545054e-3 * t306 * t308;
  t311 = t114 * t129;
  t313 = t290 * t296 * t297;
  t315 = 0.5848223622634646207e0 * t311 * t313;
  t316 = t226 + t251 + t255 - t259 + t99 * t269 + t303 + 0.19751673498613801407e-1 * t268 * t139 - t310 - t315;
  t317 = t66 * t316;
  t318 = t55 * t317;
  t319 = t46 * t318;
  t320 = 0.5e1 / 0.9e1 * t319;
  t321 = t181 * t40;
  t322 = t321 * t153;
  t324 = t39 * t188;
  t325 = t47 * t192;
  t326 = params->c * t180;
  t327 = t325 * t326;
  t330 = -0.5e1 / 0.9e1 * t322 + 0.5e2 / 0.81e2 * t324 * t327;
  t331 = t330 * t146;
  t332 = t156 * t316;
  tvrho0 = t150 + t157 + t9 * (t184 - t198 + t220 + t320 + t331 + t332);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t335 = -t10 - t165;
  t336 = t335 / 0.2e1;
  t337 = t15 * t336;
  t338 = t7 * t337;
  t340 = rho[1] * rho[1];
  t342 = 0.1e1 / t19 / t340;
  t343 = tau[1] * t342;
  t344 = t343 * t27;
  t346 = -t336;
  t347 = t26 * t346;
  t348 = t22 * t347;
  t350 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348 + t179;
  t351 = t2 * t350;
  t352 = t351 * t45;
  t353 = t352 * t148;
  t354 = 0.5e1 / 0.9e1 * t353;
  t355 = t194 * t350;
  t356 = t193 * t355;
  t357 = t190 * t356;
  t358 = 0.5e2 / 0.81e2 * t357;
  t360 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348;
  t361 = t207 * t360;
  t364 = t204 + t59 * t361 / 0.8e1 + t215;
  t365 = t364 * t146;
  t366 = t55 * t365;
  t367 = t46 * t366;
  t368 = 0.5e1 / 0.9e1 * t367;
  t371 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t335);
  t372 = -t335;
  t375 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t372);
  t377 = (t371 + t375) * t113;
  t378 = t377 * t141;
  t382 = t226 + t251 - t255 - t259 + t99 * t378 + t303 + 0.19751673498613801407e-1 * t377 * t139 - t310 - t315;
  t383 = t66 * t382;
  t384 = t55 * t383;
  t385 = t46 * t384;
  t386 = 0.5e1 / 0.9e1 * t385;
  t387 = t351 * t40;
  t388 = t387 * t153;
  t390 = params->c * t350;
  t391 = t325 * t390;
  t394 = -0.5e1 / 0.9e1 * t388 + 0.5e2 / 0.81e2 * t324 * t391;
  t395 = t394 * t146;
  t396 = t156 * t382;
  tvrho1 = t150 + t157 + t9 * (t354 - t358 + t368 + t386 + t395 + t396);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t399 = t2 * t35;
  t400 = t399 * t45;
  t401 = t400 * t148;
  t402 = 0.5e1 / 0.72e2 * t401;
  t403 = t194 * t35;
  t405 = t190 * t193 * t403;
  t406 = 0.25e2 / 0.324e3 * t405;
  t407 = t39 * t50;
  t408 = t54 * t58;
  t409 = t63 * t146;
  t410 = t408 * t409;
  t411 = t407 * t410;
  t412 = 0.5e1 / 0.72e2 * t411;
  t414 = t399 * t40 * t153;
  t416 = params->c * t35;
  t418 = t324 * t325 * t416;
  t420 = 0.5e1 / 0.72e2 * t414 - 0.25e2 / 0.324e3 * t418;
  t421 = t420 * t146;
  tvsigma0 = t9 * (-t402 + t406 - t412 + t421);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t423 = 0.5e1 / 0.36e2 * t401;
  t424 = 0.25e2 / 0.162e3 * t405;
  t425 = 0.5e1 / 0.36e2 * t411;
  t428 = 0.5e1 / 0.36e2 * t414 - 0.25e2 / 0.162e3 * t418;
  t429 = t428 * t146;
  tvsigma1 = t9 * (-t423 + t424 - t425 + t429);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t431 = t2 * t6;
  t432 = t16 * t40;
  t433 = t431 * t432;
  t434 = t54 * t66;
  t435 = t434 * t146;
  t436 = t152 * t435;
  t438 = 0.5e1 / 0.9e1 * t433 * t436;
  t439 = t193 * t146;
  t440 = params->c * t6;
  t441 = t440 * t16;
  t442 = t439 * t441;
  t444 = 0.5e2 / 0.81e2 * t190 * t442;
  t445 = t59 * t206;
  t446 = t62 * t6;
  t447 = t16 * t146;
  t448 = t446 * t447;
  t449 = t445 * t448;
  t451 = 0.5e1 / 0.72e2 * t154 * t449;
  t452 = t431 * t16;
  t453 = t45 * t55;
  t456 = t325 * t441;
  t459 = -0.5e1 / 0.9e1 * t452 * t453 + 0.5e2 / 0.81e2 * t324 * t456;
  t460 = t459 * t146;
  tvtau0 = t9 * (t438 - t444 + t451 + t460);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t462 = t2 * t21;
  t463 = t27 * t40;
  t464 = t462 * t463;
  t466 = 0.5e1 / 0.9e1 * t464 * t436;
  t467 = params->c * t21;
  t468 = t467 * t27;
  t471 = 0.5e2 / 0.81e2 * t190 * t439 * t468;
  t472 = t62 * t21;
  t473 = t27 * t146;
  t474 = t472 * t473;
  t475 = t445 * t474;
  t477 = 0.5e1 / 0.72e2 * t154 * t475;
  t478 = t462 * t27;
  t479 = t478 * t453;
  t484 = -0.5e1 / 0.9e1 * t479 + 0.5e2 / 0.81e2 * t324 * t325 * t468;
  t485 = t484 * t146;
  tvtau1 = t9 * (t466 - t471 + t477 + t485);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t493 = t158 * rho[0];
  t495 = 0.1e1 / t4 / t493;
  t496 = tau[0] * t495;
  t498 = 0.4e2 / 0.9e1 * t496 * t16;
  t500 = 0.5e2 / 0.9e1 * t161 * t168;
  t501 = 0.1e1 / t14;
  t502 = t167 * t167;
  t503 = t501 * t502;
  t505 = 0.1e2 / 0.9e1 * t7 * t503;
  t506 = 0.1e1 / t175;
  t507 = t8 * t506;
  t508 = -t164 + t507;
  t509 = t15 * t508;
  t511 = 0.5e1 / 0.3e1 * t7 * t509;
  t512 = 0.1e1 / t25;
  t513 = t171 * t171;
  t514 = t512 * t513;
  t516 = 0.1e2 / 0.9e1 * t22 * t514;
  t517 = -t508;
  t518 = t26 * t517;
  t520 = 0.5e1 / 0.3e1 * t22 * t518;
  t521 = 0.11e2 / 0.9e1 * t59;
  t522 = t498 - t500 + t505 + t511 + t516 + t520 - t521;
  t523 = t2 * t522;
  t524 = t523 * t45;
  t525 = t524 * t148;
  t526 = 0.5e1 / 0.9e1 * t525;
  t527 = t180 * t180;
  t528 = t2 * t527;
  t529 = t528 * t188;
  t530 = t147 * params->c;
  t531 = t325 * t530;
  t532 = t529 * t531;
  t533 = 0.1e3 / 0.81e2 * t532;
  t534 = t182 * t218;
  t535 = 0.1e2 / 0.9e1 * t534;
  t536 = t182 * t318;
  t537 = 0.1e2 / 0.9e1 * t536;
  t538 = t41 * t41;
  t539 = 0.1e1 / t538;
  t541 = 0.1e1 / t191 / t53;
  t542 = t539 * t541;
  t543 = t39 * t542;
  t544 = params->c * params->c;
  t545 = t544 * t527;
  t546 = t147 * t545;
  t547 = t543 * t546;
  t548 = 0.2e4 / 0.243e3 * t547;
  t549 = t192 * t216;
  t550 = t549 * t195;
  t551 = t190 * t550;
  t552 = 0.1e3 / 0.81e2 * t551;
  t553 = t316 * params->c;
  t554 = t553 * t180;
  t555 = t193 * t554;
  t556 = t190 * t555;
  t557 = 0.1e3 / 0.81e2 * t556;
  t558 = t194 * t522;
  t559 = t193 * t558;
  t560 = t190 * t559;
  t561 = 0.5e2 / 0.81e2 * t560;
  t562 = t56 * t31;
  t564 = 0.1e1 / t33 / t562;
  t565 = t30 * t564;
  t567 = 0.119e3 / 0.36e2 * t565 * t63;
  t568 = t202 * t210;
  t571 = 0.7e1 / 0.3e1 * t202 * t213;
  t573 = 0.1e1 / t205 / t60;
  t574 = t573 * t62;
  t575 = t209 * t209;
  t576 = t574 * t575;
  t579 = t206 * t8;
  t580 = t579 * t209;
  t581 = t59 * t580;
  t583 = t498 - t500 + t505 + t511 + t516 + t520;
  t584 = t207 * t583;
  t588 = t59 * t61 / 0.4e1;
  t589 = -t567 - 0.7e1 / 0.6e1 * t568 + t571 - t59 * t576 / 0.4e1 + t581 / 0.2e1 + t59 * t584 / 0.8e1 - t588;
  t590 = t589 * t146;
  t591 = t55 * t590;
  t592 = t46 * t591;
  t593 = 0.5e1 / 0.9e1 * t592;
  t594 = t216 * t316;
  t595 = t55 * t594;
  t596 = t46 * t595;
  t597 = 0.1e2 / 0.9e1 * t596;
  t598 = t289 * t289;
  t599 = 0.1e1 / t598;
  t600 = t296 * t296;
  t601 = t599 * t600;
  t602 = t137 * t137;
  t603 = 0.1e1 / t602;
  t604 = t601 * t603;
  t606 = 0.17315859105681463759e2 * t311 * t604;
  t607 = t268 * t129;
  t608 = t607 * t313;
  t612 = 0.1e1 / t78 / t75 * t83;
  t613 = t84 * t71;
  t614 = t613 * t35;
  t615 = t612 * t614;
  t618 = 0.1e1 / t32 / t31;
  t619 = t232 * t618;
  t620 = t231 * t619;
  t622 = t72 * t618;
  t623 = t70 * t622;
  t625 = 0.1e1/sqrt(t75);
  t626 = t625 * t83;
  t627 = t626 * t614;
  t629 = t239 * t619;
  t632 = t85 * t71 * t35;
  t634 = -0.57538888888888888889e0 * t615 + 0.11507777777777777778e1 * t620 + 0.40256666666666666667e0 * t623 + 0.366775e-1 * t627 + 0.73355e-1 * t629 + 0.137975e0 * t632;
  t636 = t290 * t634 * t297;
  t638 = 0.5848223622634646207e0 * t311 * t636;
  t639 = t103 * t103;
  t640 = 0.1e1 / t639;
  t641 = t166 * t166;
  t644 = 0.2e1 * t508;
  t648 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t640 * t641 + 0.4e1 / 0.3e1 * t103 * t644);
  t649 = t107 * t107;
  t650 = 0.1e1 / t649;
  t651 = t263 * t263;
  t654 = -t644;
  t658 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t650 * t651 + 0.4e1 / 0.3e1 * t107 * t654);
  t660 = (t648 + t658) * t113;
  t669 = -0.42198333333333333333e0 * t615 + 0.84396666666666666666e0 * t620 + 0.39862222222222222223e0 * t623 + 0.68258333333333333333e-1 * t627 + 0.13651666666666666667e0 * t629 + 0.13692777777777777778e0 * t632;
  t670 = t669 * t248;
  t672 = 0.1e1 * t229 * t670;
  t673 = t227 * t227;
  t674 = 0.1e1 / t673;
  t675 = t77 * t674;
  t676 = t247 * t247;
  t677 = t93 * t93;
  t678 = 0.1e1 / t677;
  t679 = t676 * t678;
  t681 = 0.16081979498692535067e2 * t675 * t679;
  t685 = t70 * t72;
  t686 = t222 * t275;
  t690 = t274 * t121;
  t691 = 0.1e1 / t690;
  t692 = t116 * t691;
  t693 = t281 * t281;
  t694 = t693 * t282;
  t703 = -0.78438333333333333333e0 * t615 + 0.15687666666666666667e1 * t620 + 0.68863333333333333333e0 * t623 + 0.14025833333333333333e0 * t627 + 0.28051666666666666667e0 * t629 + 0.17365833333333333333e0 * t632;
  t704 = t703 * t282;
  t707 = t274 * t274;
  t708 = 0.1e1 / t707;
  t709 = t116 * t708;
  t710 = t124 * t124;
  t711 = 0.1e1 / t710;
  t712 = t693 * t711;
  t717 = 0.14764627977777777777e-2 * t70 * t622 * t94;
  t718 = t222 * t228;
  t721 = 0.35616666666666666666e-1 * t685 * t718 * t249;
  t722 = t227 * t90;
  t723 = 0.1e1 / t722;
  t724 = t77 * t723;
  t725 = t676 * t248;
  t727 = 0.2e1 * t724 * t725;
  t731 = t222 * t290;
  t735 = t289 * t134;
  t736 = 0.1e1 / t735;
  t737 = t129 * t736;
  t738 = t600 * t297;
  t741 = t634 * t297;
  t744 = t129 * t599;
  t745 = t600 * t603;
  t748 = -0.70983522622222222221e-3 * t70 * t622 * t125 - 0.34246666666666666666e-1 * t685 * t686 * t283 - 0.2e1 * t692 * t694 + 0.1e1 * t276 * t704 + 0.32163958997385070134e2 * t709 * t712 + t717 + t721 + t727 - t672 - t681 - 0.24415263074675393405e-3 * t70 * t622 * t138 - 0.10843581300301739842e-1 * t685 * t731 * t298 - 0.11696447245269292414e1 * t737 * t738 + 0.5848223622634646207e0 * t291 * t741 + 0.17315859105681463759e2 * t744 * t745;
  t749 = t114 * t748;
  t750 = t99 * t749;
  t751 = t660 * t141;
  t753 = t268 * t301;
  t754 = t99 * t753;
  t756 = t257 * t269;
  t759 = 0.8e1 * t257 * t302;
  t760 = -t606 - 0.11696447245269292414e1 * t608 - t638 + 0.19751673498613801407e-1 * t660 * t139 + t672 + t681 + t750 + t99 * t751 + 0.2e1 * t754 - 0.8e1 * t756 - t759;
  t761 = t253 * t269;
  t764 = 0.8e1 * t253 * t302;
  t766 = t232 * t618 * t138;
  t768 = 0.24415263074675393405e-3 * t306 * t766;
  t769 = 0.1e1 / t562;
  t770 = t97 * t769;
  t772 = 0.2e2 * t770 * t142;
  t773 = t62 * t98;
  t775 = 0.12e2 * t773 * t142;
  t776 = t252 * t256;
  t778 = 0.32e2 * t776 * t142;
  t779 = t114 * t70;
  t780 = t223 * t313;
  t782 = 0.10843581300301739842e-1 * t779 * t780;
  t783 = t268 * t67;
  t784 = t783 * t308;
  t787 = t736 * t600 * t297;
  t789 = 0.11696447245269292414e1 * t311 * t787;
  t790 = 0.8e1 * t761 + t764 - t727 + t768 + t772 + t775 - t778 - t717 + t782 - 0.36622894612013090108e-3 * t784 + t789 - t721;
  t791 = t760 + t790;
  t792 = t66 * t791;
  t793 = t55 * t792;
  t794 = t46 * t793;
  t795 = 0.5e1 / 0.9e1 * t794;
  t796 = t523 * t40;
  t797 = t796 * t153;
  t799 = t528 * t185;
  t800 = t187 * t47;
  t801 = t192 * params->c;
  t802 = t800 * t801;
  t805 = t39 * t539;
  t806 = t541 * t544;
  t807 = t806 * t527;
  t810 = params->c * t522;
  t811 = t325 * t810;
  t814 = -0.5e1 / 0.9e1 * t797 + 0.1e3 / 0.81e2 * t799 * t802 - 0.2e4 / 0.243e3 * t805 * t807 + 0.5e2 / 0.81e2 * t324 * t811;
  t815 = t814 * t146;
  t816 = t330 * t316;
  t817 = 0.2e1 * t816;
  t818 = t156 * t791;
  t819 = t526 - t533 + t535 + t537 + t548 - t552 - t557 - t561 + t593 + t597 + t795 + t815 + t817 + t818;
  tv2rho20 = 0.1e2 / 0.9e1 * t183 - 0.1e3 / 0.81e2 * t197 + 0.1e2 / 0.9e1 * t219 + 0.1e2 / 0.9e1 * t319 + 0.2e1 * t331 + 0.2e1 * t332 + t9 * t819;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t822 = 0.25e2 / 0.9e1 * t161 * t337;
  t823 = t501 * t336;
  t824 = t823 * t167;
  t826 = 0.1e2 / 0.9e1 * t7 * t824;
  t827 = t15 * t8;
  t828 = t827 * t506;
  t830 = 0.5e1 / 0.3e1 * t7 * t828;
  t832 = 0.25e2 / 0.9e1 * t343 * t172;
  t833 = t512 * t346;
  t834 = t833 * t171;
  t836 = 0.1e2 / 0.9e1 * t22 * t834;
  t837 = t26 * t8;
  t838 = t837 * t506;
  t840 = 0.5e1 / 0.3e1 * t22 * t838;
  t841 = -t822 + t826 + t830 - t832 + t836 - t840 - t521;
  t842 = t2 * t841;
  t843 = t842 * t45;
  t844 = t843 * t148;
  t846 = t351 * t189;
  t847 = t846 * t196;
  t849 = t352 * t218;
  t851 = t352 * t318;
  t853 = t544 * t350;
  t854 = t853 * t180;
  t855 = t147 * t854;
  t856 = t543 * t855;
  t858 = t549 * t355;
  t859 = t190 * t858;
  t861 = t553 * t350;
  t862 = t193 * t861;
  t863 = t190 * t862;
  t865 = t194 * t841;
  t866 = t193 * t865;
  t867 = t190 * t866;
  t869 = t182 * t366;
  t871 = t192 * t364;
  t872 = t871 * t195;
  t873 = t190 * t872;
  t876 = t202 * t361;
  t878 = t59 * t573;
  t879 = t62 * t360;
  t880 = t879 * t209;
  t883 = t579 * t360;
  t884 = t59 * t883;
  t886 = -t822 + t826 + t830 - t832 + t836 - t840;
  t887 = t207 * t886;
  t891 = -t567 - 0.7e1 / 0.12e2 * t568 - 0.7e1 / 0.12e2 * t876 - t878 * t880 / 0.4e1 + t884 / 0.4e1 + t59 * t887 / 0.8e1 - t581 / 0.4e1 + t588;
  t892 = t891 * t146;
  t893 = t55 * t892;
  t894 = t46 * t893;
  t896 = t364 * t316;
  t897 = t55 * t896;
  t898 = t46 * t897;
  t900 = t182 * t384;
  t902 = t382 * params->c;
  t903 = t902 * t180;
  t904 = t193 * t903;
  t905 = t190 * t904;
  t907 = t216 * t382;
  t908 = t55 * t907;
  t909 = t46 * t908;
  t911 = t257 * t378;
  t913 = t253 * t378;
  t915 = t640 * t335;
  t918 = t103 * t8;
  t922 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t915 * t166 + 0.8e1 / 0.3e1 * t918 * t506);
  t923 = t650 * t372;
  t926 = t107 * t8;
  t930 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t923 * t263 - 0.8e1 / 0.3e1 * t926 * t506);
  t932 = (t922 + t930) * t113;
  t933 = t932 * t141;
  t935 = t377 * t301;
  t936 = t99 * t935;
  t937 = t377 * t67;
  t938 = t937 * t308;
  t941 = t789 - 0.4e1 * t911 + 0.4e1 * t913 + t99 * t933 + t936 + t782 - 0.18311447306006545054e-3 * t938 - t721 + t768 - 0.18311447306006545054e-3 * t784 + t772 - t775 - t759;
  t945 = t377 * t129;
  t946 = t945 * t313;
  t950 = -0.4e1 * t761 + t754 - 0.4e1 * t756 - t727 - t606 - 0.5848223622634646207e0 * t608 - t638 - t717 + t750 + t672 + t681 - 0.5848223622634646207e0 * t946 + 0.19751673498613801407e-1 * t932 * t139;
  t951 = t941 + t950;
  t952 = t66 * t951;
  t953 = t55 * t952;
  t954 = t46 * t953;
  t956 = t842 * t40;
  t957 = t956 * t153;
  t959 = t351 * t188;
  t962 = t350 * t180;
  t963 = t806 * t962;
  t966 = params->c * t841;
  t967 = t325 * t966;
  t970 = -0.5e1 / 0.9e1 * t957 + 0.1e3 / 0.81e2 * t959 * t327 - 0.2e4 / 0.243e3 * t805 * t963 + 0.5e2 / 0.81e2 * t324 * t967;
  t971 = t970 * t146;
  t972 = t394 * t316;
  t973 = t330 * t382;
  t974 = t156 * t951;
  t975 = 0.5e1 / 0.9e1 * t844 - 0.1e3 / 0.81e2 * t847 + 0.5e1 / 0.9e1 * t849 + 0.5e1 / 0.9e1 * t851 + 0.2e4 / 0.243e3 * t856 - 0.5e2 / 0.81e2 * t859 - 0.5e2 / 0.81e2 * t863 - 0.5e2 / 0.81e2 * t867 + 0.5e1 / 0.9e1 * t869 - 0.5e2 / 0.81e2 * t873 + 0.5e1 / 0.9e1 * t894 + 0.5e1 / 0.9e1 * t898 + 0.5e1 / 0.9e1 * t900 - 0.5e2 / 0.81e2 * t905 + 0.5e1 / 0.9e1 * t909 + 0.5e1 / 0.9e1 * t954 + t971 + t972 + t973 + t974;
  tv2rho21 = t9 * t975 + t184 - t198 + t220 + t320 + t331 + t332 + t354 - t358 + t368 + t386 + t395 + t396;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t983 = t336 * t336;
  t984 = t501 * t983;
  t986 = 0.1e2 / 0.9e1 * t7 * t984;
  t987 = t164 + t507;
  t988 = t15 * t987;
  t990 = 0.5e1 / 0.3e1 * t7 * t988;
  t991 = t340 * rho[1];
  t993 = 0.1e1 / t19 / t991;
  t994 = tau[1] * t993;
  t996 = 0.4e2 / 0.9e1 * t994 * t27;
  t998 = 0.5e2 / 0.9e1 * t343 * t347;
  t999 = t346 * t346;
  t1000 = t512 * t999;
  t1002 = 0.1e2 / 0.9e1 * t22 * t1000;
  t1003 = -t987;
  t1004 = t26 * t1003;
  t1006 = 0.5e1 / 0.3e1 * t22 * t1004;
  t1007 = t986 + t990 + t996 - t998 + t1002 + t1006 - t521;
  t1008 = t2 * t1007;
  t1009 = t1008 * t45;
  t1010 = t1009 * t148;
  t1011 = 0.5e1 / 0.9e1 * t1010;
  t1012 = t350 * t350;
  t1013 = t2 * t1012;
  t1014 = t1013 * t188;
  t1015 = t1014 * t531;
  t1016 = 0.1e3 / 0.81e2 * t1015;
  t1017 = t352 * t366;
  t1018 = 0.1e2 / 0.9e1 * t1017;
  t1019 = t352 * t384;
  t1020 = 0.1e2 / 0.9e1 * t1019;
  t1021 = t544 * t1012;
  t1022 = t147 * t1021;
  t1023 = t543 * t1022;
  t1024 = 0.2e4 / 0.243e3 * t1023;
  t1025 = t871 * t355;
  t1026 = t190 * t1025;
  t1027 = 0.1e3 / 0.81e2 * t1026;
  t1028 = t902 * t350;
  t1029 = t193 * t1028;
  t1030 = t190 * t1029;
  t1031 = 0.1e3 / 0.81e2 * t1030;
  t1032 = t194 * t1007;
  t1033 = t193 * t1032;
  t1034 = t190 * t1033;
  t1035 = 0.5e2 / 0.81e2 * t1034;
  t1037 = t360 * t360;
  t1038 = t574 * t1037;
  t1042 = t986 + t990 + t996 - t998 + t1002 + t1006;
  t1043 = t207 * t1042;
  t1046 = -t567 - 0.7e1 / 0.6e1 * t876 - t571 - t59 * t1038 / 0.4e1 - t884 / 0.2e1 + t59 * t1043 / 0.8e1 - t588;
  t1047 = t1046 * t146;
  t1048 = t55 * t1047;
  t1049 = t46 * t1048;
  t1050 = 0.5e1 / 0.9e1 * t1049;
  t1051 = t364 * t382;
  t1052 = t55 * t1051;
  t1053 = t46 * t1052;
  t1054 = 0.1e2 / 0.9e1 * t1053;
  t1055 = t335 * t335;
  t1058 = 0.2e1 * t987;
  t1062 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t640 * t1055 + 0.4e1 / 0.3e1 * t103 * t1058);
  t1063 = t372 * t372;
  t1066 = -t1058;
  t1070 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t650 * t1063 + 0.4e1 / 0.3e1 * t107 * t1066);
  t1072 = (t1062 + t1070) * t113;
  t1073 = t1072 * t141;
  t1081 = t99 * t1073 + 0.19751673498613801407e-1 * t1072 * t139 - 0.11696447245269292414e1 * t946 - 0.8e1 * t911 - 0.8e1 * t913 + 0.2e1 * t936 - t606 - t638 + t672 + t681 + t750;
  t1083 = -t759 - t764 - t727 + t768 + t772 + t775 + t778 - t717 + t782 - 0.36622894612013090108e-3 * t938 + t789 - t721;
  t1084 = t1081 + t1083;
  t1085 = t66 * t1084;
  t1086 = t55 * t1085;
  t1087 = t46 * t1086;
  t1088 = 0.5e1 / 0.9e1 * t1087;
  t1089 = t1008 * t40;
  t1090 = t1089 * t153;
  t1092 = t1013 * t185;
  t1095 = t806 * t1012;
  t1098 = params->c * t1007;
  t1099 = t325 * t1098;
  t1102 = -0.5e1 / 0.9e1 * t1090 + 0.1e3 / 0.81e2 * t1092 * t802 - 0.2e4 / 0.243e3 * t805 * t1095 + 0.5e2 / 0.81e2 * t324 * t1099;
  t1103 = t1102 * t146;
  t1104 = t394 * t382;
  t1105 = 0.2e1 * t1104;
  t1106 = t156 * t1084;
  t1107 = t1011 - t1016 + t1018 + t1020 + t1024 - t1027 - t1031 - t1035 + t1050 + t1054 + t1088 + t1103 + t1105 + t1106;
  tv2rho22 = 0.1e2 / 0.9e1 * t353 - 0.1e3 / 0.81e2 * t357 + 0.1e2 / 0.9e1 * t367 + 0.1e2 / 0.9e1 * t385 + 0.2e1 * t395 + 0.2e1 * t396 + t9 * t1107;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t1109 = t2 * t177;
  t1110 = t1109 * t45;
  t1111 = t1110 * t148;
  t1112 = 0.5e1 / 0.27e2 * t1111;
  t1113 = t399 * t189;
  t1114 = t1113 * t196;
  t1115 = 0.25e2 / 0.162e3 * t1114;
  t1116 = t400 * t218;
  t1117 = 0.5e1 / 0.72e2 * t1116;
  t1118 = t400 * t318;
  t1119 = 0.5e1 / 0.72e2 * t1118;
  t1120 = t544 * t35;
  t1121 = t1120 * t180;
  t1122 = t147 * t1121;
  t1123 = t543 * t1122;
  t1124 = 0.25e3 / 0.243e3 * t1123;
  t1126 = t190 * t549 * t403;
  t1127 = 0.25e2 / 0.324e3 * t1126;
  t1128 = t553 * t35;
  t1130 = t190 * t193 * t1128;
  t1131 = 0.25e2 / 0.324e3 * t1130;
  t1132 = t194 * t177;
  t1134 = t190 * t193 * t1132;
  t1135 = 0.5e2 / 0.243e3 * t1134;
  t1136 = t181 * t50;
  t1137 = t1136 * t410;
  t1138 = 0.5e1 / 0.72e2 * t1137;
  t1139 = t39 * t185;
  t1140 = t800 * t192;
  t1141 = t1139 * t1140;
  t1142 = t58 * t61;
  t1143 = t1142 * t62;
  t1144 = t1143 * t195;
  t1145 = t1141 * t1144;
  t1146 = 0.25e2 / 0.324e3 * t1145;
  t1147 = t54 * t201;
  t1148 = t1147 * t409;
  t1149 = t407 * t1148;
  t1150 = 0.35e2 / 0.108e3 * t1149;
  t1151 = t408 * t206;
  t1152 = t62 * t146;
  t1153 = t1152 * t209;
  t1154 = t1151 * t1153;
  t1155 = t407 * t1154;
  t1156 = 0.5e1 / 0.72e2 * t1155;
  t1157 = t213 * t146;
  t1158 = t408 * t1157;
  t1159 = t407 * t1158;
  t1160 = 0.5e1 / 0.36e2 * t1159;
  t1161 = t63 * t316;
  t1162 = t408 * t1161;
  t1163 = t407 * t1162;
  t1164 = 0.5e1 / 0.72e2 * t1163;
  t1166 = t1109 * t40 * t153;
  t1167 = 0.5e1 / 0.27e2 * t1166;
  t1168 = t399 * t188;
  t1169 = t1168 * t327;
  t1171 = t35 * t180;
  t1172 = t806 * t1171;
  t1173 = t805 * t1172;
  t1175 = params->c * t177;
  t1177 = t324 * t325 * t1175;
  t1178 = 0.5e2 / 0.243e3 * t1177;
  t1179 = -t1167 - 0.25e2 / 0.162e3 * t1169 + 0.25e3 / 0.243e3 * t1173 + t1178;
  t1180 = t1179 * t146;
  t1181 = t420 * t316;
  t1182 = t1112 + t1115 - t1117 - t1119 - t1124 + t1127 + t1131 - t1135 - t1138 + t1146 + t1150 + t1156 - t1160 - t1164 + t1180 + t1181;
  tv2rhosigma0 = t9 * t1182 - t402 + t406 - t412 + t421;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t1184 = 0.1e2 / 0.27e2 * t1111;
  t1185 = 0.25e2 / 0.81e2 * t1114;
  t1186 = 0.5e1 / 0.36e2 * t1116;
  t1187 = 0.5e1 / 0.36e2 * t1118;
  t1188 = 0.5e3 / 0.243e3 * t1123;
  t1189 = 0.25e2 / 0.162e3 * t1126;
  t1190 = 0.25e2 / 0.162e3 * t1130;
  t1191 = 0.1e3 / 0.243e3 * t1134;
  t1192 = 0.5e1 / 0.36e2 * t1137;
  t1193 = 0.25e2 / 0.162e3 * t1145;
  t1194 = 0.35e2 / 0.54e2 * t1149;
  t1195 = 0.5e1 / 0.36e2 * t1155;
  t1196 = 0.5e1 / 0.18e2 * t1159;
  t1197 = 0.5e1 / 0.36e2 * t1163;
  t1198 = 0.1e2 / 0.27e2 * t1166;
  t1201 = 0.1e3 / 0.243e3 * t1177;
  t1202 = -t1198 - 0.25e2 / 0.81e2 * t1169 + 0.5e3 / 0.243e3 * t1173 + t1201;
  t1203 = t1202 * t146;
  t1204 = t428 * t316;
  t1205 = t1184 + t1185 - t1186 - t1187 - t1188 + t1189 + t1190 - t1191 - t1192 + t1193 + t1194 + t1195 - t1196 - t1197 + t1203 + t1204;
  tv2rhosigma1 = t9 * t1205 - t423 + t424 - t425 + t429;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t1207 = t1113 * t356;
  t1208 = 0.25e2 / 0.162e3 * t1207;
  t1209 = t400 * t366;
  t1210 = 0.5e1 / 0.72e2 * t1209;
  t1211 = t400 * t384;
  t1212 = 0.5e1 / 0.72e2 * t1211;
  t1213 = t1120 * t350;
  t1214 = t147 * t1213;
  t1215 = t543 * t1214;
  t1216 = 0.25e3 / 0.243e3 * t1215;
  t1218 = t190 * t871 * t403;
  t1219 = 0.25e2 / 0.324e3 * t1218;
  t1220 = t902 * t35;
  t1222 = t190 * t193 * t1220;
  t1223 = 0.25e2 / 0.324e3 * t1222;
  t1224 = t351 * t50;
  t1225 = t1224 * t410;
  t1226 = 0.5e1 / 0.72e2 * t1225;
  t1227 = t1143 * t355;
  t1228 = t1141 * t1227;
  t1229 = 0.25e2 / 0.324e3 * t1228;
  t1230 = t1152 * t360;
  t1231 = t1151 * t1230;
  t1232 = t407 * t1231;
  t1233 = 0.5e1 / 0.72e2 * t1232;
  t1234 = t63 * t382;
  t1235 = t408 * t1234;
  t1236 = t407 * t1235;
  t1237 = 0.5e1 / 0.72e2 * t1236;
  t1238 = t1168 * t391;
  t1240 = t35 * t350;
  t1241 = t806 * t1240;
  t1242 = t805 * t1241;
  t1244 = -t1167 - 0.25e2 / 0.162e3 * t1238 + 0.25e3 / 0.243e3 * t1242 + t1178;
  t1245 = t1244 * t146;
  t1246 = t420 * t382;
  t1247 = t1112 + t1208 - t1210 - t1212 - t1216 + t1219 + t1223 - t1135 - t1226 + t1229 + t1150 + t1233 + t1160 - t1237 + t1245 + t1246;
  tv2rhosigma3 = t9 * t1247 - t402 + t406 - t412 + t421;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  t1249 = 0.25e2 / 0.81e2 * t1207;
  t1250 = 0.5e1 / 0.36e2 * t1209;
  t1251 = 0.5e1 / 0.36e2 * t1211;
  t1252 = 0.5e3 / 0.243e3 * t1215;
  t1253 = 0.25e2 / 0.162e3 * t1218;
  t1254 = 0.25e2 / 0.162e3 * t1222;
  t1255 = 0.5e1 / 0.36e2 * t1225;
  t1256 = 0.25e2 / 0.162e3 * t1228;
  t1257 = 0.5e1 / 0.36e2 * t1232;
  t1258 = 0.5e1 / 0.36e2 * t1236;
  t1261 = -t1198 - 0.25e2 / 0.81e2 * t1238 + 0.5e3 / 0.243e3 * t1242 + t1201;
  t1262 = t1261 * t146;
  t1263 = t428 * t382;
  t1264 = t1184 + t1249 - t1250 - t1251 - t1252 + t1253 + t1254 - t1191 - t1255 + t1256 + t1194 + t1257 + t1196 - t1258 + t1262 + t1263;
  tv2rhosigma4 = t9 * t1264 - t423 + t424 - t425 + t429;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t1266 = t2 * t160;
  t1267 = t1266 * t432;
  t1268 = t1267 * t436;
  t1269 = 0.25e2 / 0.27e2 * t1268;
  t1270 = t15 * t40;
  t1271 = t1270 * t44;
  t1272 = t431 * t1271;
  t1274 = t55 * t147 * t167;
  t1275 = t1272 * t1274;
  t1276 = 0.25e2 / 0.27e2 * t1275;
  t1277 = t16 * t185;
  t1278 = t1277 * t187;
  t1279 = t431 * t1278;
  t1280 = t325 * t66;
  t1281 = t1280 * t195;
  t1282 = t1279 * t1281;
  t1283 = 0.1e3 / 0.81e2 * t1282;
  t1284 = t54 * t216;
  t1286 = t152 * t1284 * t146;
  t1287 = t433 * t1286;
  t1288 = 0.5e1 / 0.9e1 * t1287;
  t1290 = t152 * t434 * t316;
  t1291 = t433 * t1290;
  t1292 = 0.5e1 / 0.9e1 * t1291;
  t1293 = t542 * t66;
  t1294 = t39 * t1293;
  t1295 = t146 * t544;
  t1296 = t6 * t16;
  t1297 = t1296 * t180;
  t1298 = t1295 * t1297;
  t1299 = t1294 * t1298;
  t1300 = 0.2e4 / 0.243e3 * t1299;
  t1301 = t549 * t146;
  t1302 = t1301 * t441;
  t1303 = t190 * t1302;
  t1304 = 0.5e2 / 0.81e2 * t1303;
  t1305 = t193 * t316;
  t1306 = t1305 * t441;
  t1307 = t190 * t1306;
  t1308 = 0.5e2 / 0.81e2 * t1307;
  t1309 = params->c * t160;
  t1310 = t1309 * t16;
  t1311 = t439 * t1310;
  t1312 = t190 * t1311;
  t1313 = 0.25e3 / 0.243e3 * t1312;
  t1314 = t6 * t15;
  t1315 = t1314 * t167;
  t1317 = t1141 * t530 * t1315;
  t1318 = 0.25e3 / 0.243e3 * t1317;
  t1319 = t322 * t449;
  t1320 = 0.5e1 / 0.72e2 * t1319;
  t1321 = t192 * t30;
  t1322 = t800 * t1321;
  t1323 = t1139 * t1322;
  t1324 = t58 * t206;
  t1325 = t1324 * t446;
  t1326 = t447 * t326;
  t1327 = t1325 * t1326;
  t1328 = t1323 * t1327;
  t1329 = 0.25e2 / 0.324e3 * t1328;
  t1330 = t202 * t206;
  t1331 = t1330 * t448;
  t1332 = t154 * t1331;
  t1333 = 0.35e2 / 0.108e3 * t1332;
  t1334 = t54 * t30;
  t1335 = t152 * t1334;
  t1336 = t151 * t1335;
  t1337 = t58 * t573;
  t1338 = t1337 * t62;
  t1339 = t146 * t209;
  t1340 = t1296 * t1339;
  t1341 = t1338 * t1340;
  t1342 = t1336 * t1341;
  t1343 = 0.5e1 / 0.36e2 * t1342;
  t1344 = t8 * t6;
  t1345 = t1344 * t447;
  t1346 = t445 * t1345;
  t1347 = t154 * t1346;
  t1348 = 0.5e1 / 0.36e2 * t1347;
  t1349 = t62 * t160;
  t1350 = t1349 * t447;
  t1351 = t445 * t1350;
  t1352 = t154 * t1351;
  t1353 = 0.25e2 / 0.216e3 * t1352;
  t1354 = t1324 * t62;
  t1355 = t146 * t167;
  t1356 = t1314 * t1355;
  t1357 = t1354 * t1356;
  t1358 = t1336 * t1357;
  t1359 = 0.25e2 / 0.216e3 * t1358;
  t1360 = t16 * t316;
  t1361 = t446 * t1360;
  t1362 = t445 * t1361;
  t1363 = t154 * t1362;
  t1364 = 0.5e1 / 0.72e2 * t1363;
  t1365 = t1266 * t16;
  t1368 = t431 * t1270;
  t1369 = t54 * t167;
  t1370 = t152 * t1369;
  t1373 = t431 * t1277;
  t1375 = t800 * t801 * t180;
  t1378 = t544 * t6;
  t1379 = t16 * t180;
  t1380 = t1378 * t1379;
  t1383 = t325 * t1310;
  t1389 = 0.25e2 / 0.27e2 * t1365 * t453 - 0.25e2 / 0.27e2 * t1368 * t1370 + 0.1e3 / 0.81e2 * t1373 * t1375 - 0.2e4 / 0.243e3 * t543 * t1380 - 0.25e3 / 0.243e3 * t324 * t1383 + 0.25e3 / 0.243e3 * t190 * t801 * t1315;
  t1390 = t1389 * t146;
  t1391 = t459 * t316;
  t1392 = -t1269 + t1276 - t1283 + t1288 + t1292 + t1300 - t1304 - t1308 + t1313 - t1318 + t1320 - t1329 - t1333 - t1343 + t1348 - t1353 + t1359 + t1364 + t1390 + t1391;
  tv2rhotau0 = t9 * t1392 + t438 - t444 + t451 + t460;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t1394 = t26 * t40;
  t1395 = t1394 * t44;
  t1396 = t462 * t1395;
  t1398 = t55 * t147 * t171;
  t1399 = t1396 * t1398;
  t1400 = 0.25e2 / 0.27e2 * t1399;
  t1401 = t27 * t185;
  t1402 = t1401 * t187;
  t1403 = t462 * t1402;
  t1404 = t1403 * t1281;
  t1405 = 0.1e3 / 0.81e2 * t1404;
  t1406 = t464 * t1286;
  t1407 = 0.5e1 / 0.9e1 * t1406;
  t1408 = t464 * t1290;
  t1409 = 0.5e1 / 0.9e1 * t1408;
  t1410 = t21 * t27;
  t1411 = t1410 * t180;
  t1412 = t1295 * t1411;
  t1413 = t1294 * t1412;
  t1414 = 0.2e4 / 0.243e3 * t1413;
  t1416 = t190 * t1301 * t468;
  t1417 = 0.5e2 / 0.81e2 * t1416;
  t1419 = t190 * t1305 * t468;
  t1420 = 0.5e2 / 0.81e2 * t1419;
  t1421 = t21 * t26;
  t1422 = t1421 * t171;
  t1424 = t1141 * t530 * t1422;
  t1425 = 0.25e3 / 0.243e3 * t1424;
  t1426 = t322 * t475;
  t1427 = 0.5e1 / 0.72e2 * t1426;
  t1428 = t1324 * t472;
  t1429 = t473 * t326;
  t1430 = t1428 * t1429;
  t1431 = t1323 * t1430;
  t1432 = 0.25e2 / 0.324e3 * t1431;
  t1433 = t1330 * t474;
  t1434 = t154 * t1433;
  t1435 = 0.35e2 / 0.108e3 * t1434;
  t1436 = t1410 * t1339;
  t1437 = t1338 * t1436;
  t1438 = t1336 * t1437;
  t1439 = 0.5e1 / 0.36e2 * t1438;
  t1440 = t8 * t21;
  t1441 = t1440 * t473;
  t1442 = t445 * t1441;
  t1443 = t154 * t1442;
  t1444 = 0.5e1 / 0.36e2 * t1443;
  t1445 = t146 * t171;
  t1446 = t1421 * t1445;
  t1447 = t1354 * t1446;
  t1448 = t1336 * t1447;
  t1449 = 0.25e2 / 0.216e3 * t1448;
  t1450 = t27 * t316;
  t1451 = t472 * t1450;
  t1452 = t445 * t1451;
  t1453 = t154 * t1452;
  t1454 = 0.5e1 / 0.72e2 * t1453;
  t1455 = t462 * t1394;
  t1456 = t54 * t171;
  t1457 = t152 * t1456;
  t1460 = t462 * t1401;
  t1463 = t544 * t21;
  t1464 = t27 * t180;
  t1465 = t1463 * t1464;
  t1471 = -0.25e2 / 0.27e2 * t1455 * t1457 + 0.1e3 / 0.81e2 * t1460 * t1375 - 0.2e4 / 0.243e3 * t543 * t1465 + 0.25e3 / 0.243e3 * t190 * t801 * t1422;
  t1472 = t1471 * t146;
  t1473 = t484 * t316;
  t1474 = t1400 - t1405 + t1407 + t1409 + t1414 - t1417 - t1420 - t1425 + t1427 - t1432 - t1435 - t1439 + t1444 + t1449 + t1454 + t1472 + t1473;
  tv2rhotau1 = t9 * t1474 + t466 - t471 + t477 + t485;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1477 = t55 * t147 * t336;
  t1478 = t1272 * t1477;
  t1479 = 0.25e2 / 0.27e2 * t1478;
  t1480 = t1280 * t355;
  t1481 = t1279 * t1480;
  t1482 = 0.1e3 / 0.81e2 * t1481;
  t1483 = t54 * t364;
  t1485 = t152 * t1483 * t146;
  t1486 = t433 * t1485;
  t1487 = 0.5e1 / 0.9e1 * t1486;
  t1489 = t152 * t434 * t382;
  t1490 = t433 * t1489;
  t1491 = 0.5e1 / 0.9e1 * t1490;
  t1492 = t1296 * t350;
  t1493 = t1295 * t1492;
  t1494 = t1294 * t1493;
  t1495 = 0.2e4 / 0.243e3 * t1494;
  t1496 = t871 * t146;
  t1497 = t1496 * t441;
  t1498 = t190 * t1497;
  t1499 = 0.5e2 / 0.81e2 * t1498;
  t1500 = t193 * t382;
  t1501 = t1500 * t441;
  t1502 = t190 * t1501;
  t1503 = 0.5e2 / 0.81e2 * t1502;
  t1504 = t1314 * t336;
  t1506 = t1141 * t530 * t1504;
  t1507 = 0.25e3 / 0.243e3 * t1506;
  t1508 = t388 * t449;
  t1509 = 0.5e1 / 0.72e2 * t1508;
  t1510 = t447 * t390;
  t1511 = t1325 * t1510;
  t1512 = t1323 * t1511;
  t1513 = 0.25e2 / 0.324e3 * t1512;
  t1514 = t146 * t360;
  t1515 = t1296 * t1514;
  t1516 = t1338 * t1515;
  t1517 = t1336 * t1516;
  t1518 = 0.5e1 / 0.36e2 * t1517;
  t1519 = t146 * t336;
  t1520 = t1314 * t1519;
  t1521 = t1354 * t1520;
  t1522 = t1336 * t1521;
  t1523 = 0.25e2 / 0.216e3 * t1522;
  t1524 = t16 * t382;
  t1525 = t446 * t1524;
  t1526 = t445 * t1525;
  t1527 = t154 * t1526;
  t1528 = 0.5e1 / 0.72e2 * t1527;
  t1529 = t54 * t336;
  t1530 = t152 * t1529;
  t1534 = t800 * t801 * t350;
  t1537 = t16 * t350;
  t1538 = t1378 * t1537;
  t1544 = -0.25e2 / 0.27e2 * t1368 * t1530 + 0.1e3 / 0.81e2 * t1373 * t1534 - 0.2e4 / 0.243e3 * t543 * t1538 + 0.25e3 / 0.243e3 * t190 * t801 * t1504;
  t1545 = t1544 * t146;
  t1546 = t459 * t382;
  t1547 = t1479 - t1482 + t1487 + t1491 + t1495 - t1499 - t1503 - t1507 + t1509 - t1513 - t1333 - t1518 - t1348 + t1523 + t1528 + t1545 + t1546;
  tv2rhotau2 = t9 * t1547 + t438 - t444 + t451 + t460;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1549 = t2 * t342;
  t1550 = t1549 * t463;
  t1551 = t1550 * t436;
  t1552 = 0.25e2 / 0.27e2 * t1551;
  t1554 = t55 * t147 * t346;
  t1555 = t1396 * t1554;
  t1556 = 0.25e2 / 0.27e2 * t1555;
  t1557 = t1403 * t1480;
  t1558 = 0.1e3 / 0.81e2 * t1557;
  t1559 = t464 * t1485;
  t1560 = 0.5e1 / 0.9e1 * t1559;
  t1561 = t464 * t1489;
  t1562 = 0.5e1 / 0.9e1 * t1561;
  t1563 = t1410 * t350;
  t1564 = t1295 * t1563;
  t1565 = t1294 * t1564;
  t1566 = 0.2e4 / 0.243e3 * t1565;
  t1568 = t190 * t1496 * t468;
  t1569 = 0.5e2 / 0.81e2 * t1568;
  t1571 = t190 * t1500 * t468;
  t1572 = 0.5e2 / 0.81e2 * t1571;
  t1573 = params->c * t342;
  t1574 = t1573 * t27;
  t1576 = t190 * t439 * t1574;
  t1577 = 0.25e3 / 0.243e3 * t1576;
  t1578 = t1421 * t346;
  t1580 = t1141 * t530 * t1578;
  t1581 = 0.25e3 / 0.243e3 * t1580;
  t1582 = t388 * t475;
  t1583 = 0.5e1 / 0.72e2 * t1582;
  t1584 = t473 * t390;
  t1585 = t1428 * t1584;
  t1586 = t1323 * t1585;
  t1587 = 0.25e2 / 0.324e3 * t1586;
  t1588 = t1410 * t1514;
  t1589 = t1338 * t1588;
  t1590 = t1336 * t1589;
  t1591 = 0.5e1 / 0.36e2 * t1590;
  t1592 = t62 * t342;
  t1593 = t1592 * t473;
  t1594 = t445 * t1593;
  t1595 = t154 * t1594;
  t1596 = 0.25e2 / 0.216e3 * t1595;
  t1597 = t146 * t346;
  t1598 = t1421 * t1597;
  t1599 = t1354 * t1598;
  t1600 = t1336 * t1599;
  t1601 = 0.25e2 / 0.216e3 * t1600;
  t1602 = t27 * t382;
  t1603 = t472 * t1602;
  t1604 = t445 * t1603;
  t1605 = t154 * t1604;
  t1606 = 0.5e1 / 0.72e2 * t1605;
  t1607 = t1549 * t27;
  t1608 = t1607 * t453;
  t1610 = t54 * t346;
  t1611 = t152 * t1610;
  t1616 = t27 * t350;
  t1617 = t1463 * t1616;
  t1626 = 0.25e2 / 0.27e2 * t1608 - 0.25e2 / 0.27e2 * t1455 * t1611 + 0.1e3 / 0.81e2 * t1460 * t1534 - 0.2e4 / 0.243e3 * t543 * t1617 - 0.25e3 / 0.243e3 * t324 * t325 * t1574 + 0.25e3 / 0.243e3 * t190 * t801 * t1578;
  t1627 = t1626 * t146;
  t1628 = t484 * t382;
  t1629 = -t1552 + t1556 - t1558 + t1560 + t1562 + t1566 - t1569 - t1572 + t1577 - t1581 + t1583 - t1587 - t1435 - t1591 - t1444 - t1596 + t1601 + t1606 + t1627 + t1628;
  tv2rhotau3 = t9 * t1629 + t466 - t471 + t477 + t485;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1632 = 0.1e1 / t32 / t199;
  t1633 = t2 * t1632;
  t1634 = t1633 * t188;
  t1635 = t1634 * t531;
  t1636 = 0.25e2 / 0.1296e4 * t1635;
  t1637 = t56 * t175;
  t1639 = 0.1e1 / t32 / t1637;
  t1640 = t2 * t1639;
  t1641 = t1640 * t45;
  t1642 = t55 * t409;
  t1643 = t1641 * t1642;
  t1644 = 0.5e1 / 0.288e3 * t1643;
  t1645 = t544 * t1632;
  t1647 = t543 * t147 * t1645;
  t1648 = 0.125e3 / 0.972e3 * t1647;
  t1649 = t192 * t1639;
  t1650 = t1649 * t61;
  t1651 = t1152 * params->c;
  t1652 = t1650 * t1651;
  t1653 = t190 * t1652;
  t1654 = 0.25e2 / 0.1296e4 * t1653;
  t1656 = t1633 * t185 * t802;
  t1659 = t805 * t806 * t1632;
  t1661 = 0.25e2 / 0.1296e4 * t1656 - 0.125e3 / 0.972e3 * t1659;
  t1662 = t1661 * t146;
  tv2sigma20 = t9 * (-t1636 + t1644 + t1648 - t1654 + t1662);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t1664 = 0.25e2 / 0.648e3 * t1635;
  t1665 = 0.5e1 / 0.144e3 * t1643;
  t1666 = 0.125e3 / 0.486e3 * t1647;
  t1667 = 0.25e2 / 0.648e3 * t1653;
  t1670 = 0.25e2 / 0.648e3 * t1656 - 0.125e3 / 0.486e3 * t1659;
  t1671 = t1670 * t146;
  tv2sigma21 = t9 * (-t1664 + t1665 + t1666 - t1667 + t1671);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = tv2sigma20;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  t1673 = 0.25e2 / 0.324e3 * t1635;
  t1674 = 0.5e1 / 0.72e2 * t1643;
  t1675 = 0.125e3 / 0.243e3 * t1647;
  t1676 = 0.25e2 / 0.324e3 * t1653;
  t1679 = 0.25e2 / 0.324e3 * t1656 - 0.125e3 / 0.243e3 * t1659;
  t1680 = t1679 * t146;
  tv2sigma23 = t9 * (-t1673 + t1674 + t1675 - t1676 + t1680);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = tv2sigma21;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = tv2sigma22;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1682 = t1280 * t403;
  t1683 = t1279 * t1682;
  t1684 = 0.25e2 / 0.162e3 * t1683;
  t1685 = t432 * t44;
  t1686 = t431 * t1685;
  t1687 = t55 * t58;
  t1688 = t1687 * t409;
  t1689 = t1686 * t1688;
  t1690 = 0.5e1 / 0.72e2 * t1689;
  t1691 = t1296 * t35;
  t1692 = t1295 * t1691;
  t1693 = t1294 * t1692;
  t1694 = 0.25e3 / 0.243e3 * t1693;
  t1695 = t194 * t1296;
  t1696 = t1143 * t1695;
  t1697 = t1141 * t1696;
  t1698 = 0.25e2 / 0.324e3 * t1697;
  t1699 = t1640 * t40;
  t1700 = t1699 * t153;
  t1701 = t30 * t206;
  t1702 = t1701 * t62;
  t1703 = t1296 * t146;
  t1704 = t1702 * t1703;
  t1705 = t1700 * t1704;
  t1706 = 0.5e1 / 0.576e3 * t1705;
  t1707 = t1639 * t206;
  t1708 = t1707 * t62;
  t1709 = t1708 * t1695;
  t1710 = t1323 * t1709;
  t1711 = 0.25e2 / 0.2592e4 * t1710;
  t1712 = t1354 * t1703;
  t1713 = t154 * t1712;
  t1714 = 0.5e1 / 0.72e2 * t1713;
  t1716 = t800 * t801 * t35;
  t1717 = t1373 * t1716;
  t1719 = t16 * t35;
  t1721 = t543 * t1378 * t1719;
  t1723 = -0.25e2 / 0.162e3 * t1717 + 0.25e3 / 0.243e3 * t1721;
  t1724 = t1723 * t146;
  tv2sigmatau0 = t9 * (t1684 - t1690 - t1694 + t1698 - t1706 + t1711 + t1714 + t1724);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t1726 = t1403 * t1682;
  t1727 = 0.25e2 / 0.162e3 * t1726;
  t1728 = t463 * t44;
  t1729 = t462 * t1728;
  t1730 = t1729 * t1688;
  t1731 = 0.5e1 / 0.72e2 * t1730;
  t1732 = t1410 * t35;
  t1733 = t1295 * t1732;
  t1734 = t1294 * t1733;
  t1735 = 0.25e3 / 0.243e3 * t1734;
  t1736 = t194 * t1410;
  t1738 = t1141 * t1143 * t1736;
  t1739 = 0.25e2 / 0.324e3 * t1738;
  t1740 = t1410 * t146;
  t1741 = t1702 * t1740;
  t1742 = t1700 * t1741;
  t1743 = 0.5e1 / 0.576e3 * t1742;
  t1744 = t1708 * t1736;
  t1745 = t1323 * t1744;
  t1746 = 0.25e2 / 0.2592e4 * t1745;
  t1747 = t1354 * t1740;
  t1748 = t154 * t1747;
  t1749 = 0.5e1 / 0.72e2 * t1748;
  t1750 = t1460 * t1716;
  t1752 = t27 * t35;
  t1754 = t543 * t1463 * t1752;
  t1756 = -0.25e2 / 0.162e3 * t1750 + 0.25e3 / 0.243e3 * t1754;
  t1757 = t1756 * t146;
  tv2sigmatau1 = t9 * (t1727 - t1731 - t1735 + t1739 - t1743 + t1746 + t1749 + t1757);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  t1759 = 0.25e2 / 0.81e2 * t1683;
  t1760 = 0.5e1 / 0.36e2 * t1689;
  t1761 = 0.5e3 / 0.243e3 * t1693;
  t1762 = 0.25e2 / 0.162e3 * t1697;
  t1763 = 0.5e1 / 0.288e3 * t1705;
  t1764 = 0.25e2 / 0.1296e4 * t1710;
  t1765 = 0.5e1 / 0.36e2 * t1713;
  t1768 = -0.25e2 / 0.81e2 * t1717 + 0.5e3 / 0.243e3 * t1721;
  t1769 = t1768 * t146;
  tv2sigmatau2 = t9 * (t1759 - t1760 - t1761 + t1762 - t1763 + t1764 + t1765 + t1769);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  t1771 = 0.25e2 / 0.81e2 * t1726;
  t1772 = 0.5e1 / 0.36e2 * t1730;
  t1773 = 0.5e3 / 0.243e3 * t1734;
  t1774 = 0.25e2 / 0.162e3 * t1738;
  t1775 = 0.5e1 / 0.288e3 * t1742;
  t1776 = 0.25e2 / 0.1296e4 * t1745;
  t1777 = 0.5e1 / 0.36e2 * t1748;
  t1780 = -0.25e2 / 0.81e2 * t1750 + 0.5e3 / 0.243e3 * t1754;
  t1781 = t1780 * t146;
  tv2sigmatau3 = t9 * (t1771 - t1772 - t1773 + t1774 - t1775 + t1776 + t1777 + t1781);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = tv2sigmatau0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = tv2sigmatau1;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1784 = 0.1e1 / t3 / t493;
  t1785 = t2 * t1784;
  t1786 = t13 * t13;
  t1788 = t14 * t1786 * t13;
  t1789 = t1788 * t185;
  t1790 = t1789 * t187;
  t1791 = t1785 * t1790;
  t1793 = 0.1e3 / 0.81e2 * t1791 * t531;
  t1794 = t1785 * t1788;
  t1795 = t1794 * t50;
  t1796 = t1334 * t58;
  t1797 = t207 * t146;
  t1798 = t1796 * t1797;
  t1800 = 0.5e1 / 0.36e2 * t1795 * t1798;
  t1801 = t544 * t1784;
  t1802 = t1801 * t1788;
  t1803 = t147 * t1802;
  t1805 = 0.2e4 / 0.243e3 * t543 * t1803;
  t1806 = t1784 * t1788;
  t1807 = t1806 * t194;
  t1808 = t1354 * t1807;
  t1810 = 0.25e2 / 0.162e3 * t1323 * t1808;
  t1811 = t62 * t1784;
  t1812 = t1788 * t146;
  t1813 = t1811 * t1812;
  t1814 = t878 * t1813;
  t1816 = 0.5e1 / 0.36e2 * t154 * t1814;
  t1820 = t806 * t1806;
  t1823 = 0.1e3 / 0.81e2 * t1785 * t1789 * t802 - 0.2e4 / 0.243e3 * t805 * t1820;
  t1824 = t1823 * t146;
  tv2tau20 = t9 * (-t1793 + t1800 + t1805 - t1810 - t1816 + t1824);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t1826 = t478 * t189;
  t1828 = 0.1e3 / 0.81e2 * t1826 * t442;
  t1830 = 0.5e1 / 0.36e2 * t479 * t449;
  t1831 = t1295 * t21;
  t1832 = t27 * t6;
  t1833 = t1832 * t16;
  t1834 = t1831 * t1833;
  t1836 = 0.2e4 / 0.243e3 * t1294 * t1834;
  t1837 = t325 * t59;
  t1838 = t324 * t1837;
  t1839 = t207 * t1296;
  t1840 = t1839 * t1736;
  t1842 = 0.25e2 / 0.162e3 * t1838 * t1840;
  t1843 = t1337 * t472;
  t1844 = t473 * t1296;
  t1845 = t1843 * t1844;
  t1847 = 0.5e1 / 0.36e2 * t1336 * t1845;
  t1853 = 0.1e3 / 0.81e2 * t1403 * t456 - 0.2e4 / 0.243e3 * t543 * t1463 * t1833;
  t1854 = t1853 * t146;
  tv2tau21 = t9 * (-t1828 + t1830 + t1836 - t1842 - t1847 + t1854);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1857 = 0.1e1 / t18 / t991;
  t1858 = t2 * t1857;
  t1859 = t24 * t24;
  t1861 = t25 * t1859 * t24;
  t1862 = t1861 * t185;
  t1863 = t1862 * t187;
  t1864 = t1858 * t1863;
  t1866 = 0.1e3 / 0.81e2 * t1864 * t531;
  t1867 = t1858 * t1861;
  t1868 = t1867 * t50;
  t1870 = 0.5e1 / 0.36e2 * t1868 * t1798;
  t1871 = t544 * t1857;
  t1872 = t1871 * t1861;
  t1875 = 0.2e4 / 0.243e3 * t543 * t147 * t1872;
  t1876 = t1857 * t1861;
  t1877 = t1876 * t194;
  t1878 = t1354 * t1877;
  t1880 = 0.25e2 / 0.162e3 * t1323 * t1878;
  t1881 = t62 * t1857;
  t1882 = t1861 * t146;
  t1883 = t1881 * t1882;
  t1884 = t878 * t1883;
  t1886 = 0.5e1 / 0.36e2 * t154 * t1884;
  t1887 = t1858 * t1862;
  t1893 = 0.1e3 / 0.81e2 * t1887 * t802 - 0.2e4 / 0.243e3 * t805 * t806 * t1876;
  t1894 = t1893 * t146;
  tv2tau22 = t9 * (-t1866 + t1870 + t1875 - t1880 - t1886 + t1894);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t9, t10;
  double t11, t12, t13, t14, t15, t16, t17, t18;
  double t19, t21, t22, t23, t24, t25, t26, t27;
  double t28, t30, t31, t32, t33, t35, t38, t39;
  double t40, t41, t42, t43, t44, t45, t46, t47;
  double t48, t50, t53, t54, t55, t56, t58, t59;
  double t60, t61, t62, t63, t66, t67, t68, t69;
  double t70, t71, t72, t75, t77, t78, t81, t83;
  double t84, t85, t88, t90, t93, t94, t96, t97;
  double t98, t99, t100, t101, t102, t103, t105, t106;
  double t107, t109, t110, t113, t114, t116, t121, t124;
  double t125, t129, t134, t137, t138, t139, t141, t142;
  double t146, t147, t148, t150, t151, t152, t153, t154;
  double t156, t157, tzk0;

  double t158, t160, t161, t162, t164, t165, t166, t167;
  double t168, t169, t171, t172, t173, t175, t177, t179;
  double t180, t181, t182, t183, t184, t185, t187, t188;
  double t189, t190, t191, t192, t193, t194, t195, t196;
  double t197, t198, t199, t201, t202, t204, t205, t206;
  double t207, t209, t210, t213, t215, t216, t217, t218;
  double t219, t220, t222, t223, t226, t227, t228, t229;
  double t231, t232, t233, t234, t236, t238, t239, t240;
  double t245, t247, t248, t249, t251, t252, t253, t255;
  double t256, t257, t259, t262, t263, t266, t268, t269;
  double t274, t275, t276, t281, t282, t283, t289, t290;
  double t291, t296, t297, t298, t301, t302, t303, t306;
  double t308, t310, t311, t313, t315, t316, t317, t318;
  double t319, t320, t321, t322, t324, t325, t326, t327;
  double t330, t331, t332, tvrho0, t335, t336, t337, t338;
  double t340, t342, t343, t344, t346, t347, t348, t350;
  double t351, t352, t353, t354, t355, t356, t357, t358;
  double t360, t361, t364, t365, t366, t367, t368, t371;
  double t372, t375, t377, t378, t382, t383, t384, t385;
  double t386, t387, t388, t390, t391, t394, t395, t396;
  double tvrho1, t399, t400, t401, t402, t403, t405, t406;
  double t407, t408, t409, t410, t411, t412, t414, t416;
  double t418, t420, t421, tvsigma0, t423, t424, t425, t428;
  double t429, tvsigma1, tvsigma2, tvlapl0, tvlapl1, t431, t432, t433;
  double t434, t435, t436, t438, t439, t440, t441, t442;
  double t444, t445, t446, t447, t448, t449, t451, t452;
  double t453, t456, t459, t460, tvtau0, t462, t463, t464;
  double t466, t467, t468, t471, t472, t473, t474, t475;
  double t477, t478, t479, t484, t485, tvtau1;

  double t493, t495, t496, t498, t500, t501, t502, t503;
  double t505, t506, t507, t508, t509, t511, t512, t513;
  double t514, t516, t517, t518, t520, t521, t522, t523;
  double t524, t525, t526, t527, t528, t529, t530, t531;
  double t532, t533, t534, t535, t536, t537, t538, t539;
  double t541, t542, t543, t544, t545, t546, t547, t548;
  double t549, t550, t551, t552, t553, t554, t555, t556;
  double t557, t558, t559, t560, t561, t562, t564, t565;
  double t567, t568, t571, t573, t574, t575, t576, t579;
  double t580, t581, t583, t584, t588, t589, t590, t591;
  double t592, t593, t594, t595, t596, t597, t598, t599;
  double t600, t601, t602, t603, t604, t606, t607, t608;
  double t612, t613, t614, t615, t618, t619, t620, t622;
  double t623, t625, t626, t627, t629, t632, t634, t636;
  double t638, t639, t640, t641, t644, t648, t649, t650;
  double t651, t654, t658, t660, t669, t670, t672, t673;
  double t674, t675, t676, t677, t678, t679, t681, t685;
  double t686, t690, t691, t692, t693, t694, t703, t704;
  double t707, t708, t709, t710, t711, t712, t717, t718;
  double t721, t722, t723, t724, t725, t727, t731, t735;
  double t736, t737, t738, t741, t744, t745, t748, t749;
  double t750, t751, t753, t754, t756, t759, t760, t761;
  double t764, t766, t768, t769, t770, t772, t773, t775;
  double t776, t778, t779, t780, t782, t783, t784, t787;
  double t789, t790, t791, t792, t793, t794, t795, t796;
  double t797, t799, t800, t801, t802, t805, t806, t807;
  double t810, t811, t814, t815, t816, t817, t818, t819;
  double tv2rho20, t822, t823, t824, t826, t827, t828, t830;
  double t832, t833, t834, t836, t837, t838, t840, t841;
  double t842, t843, t844, t846, t847, t849, t851, t853;
  double t854, t855, t856, t858, t859, t861, t862, t863;
  double t865, t866, t867, t869, t871, t872, t873, t876;
  double t878, t879, t880, t883, t884, t886, t887, t891;
  double t892, t893, t894, t896, t897, t898, t900, t902;
  double t903, t904, t905, t907, t908, t909, t911, t913;
  double t915, t918, t922, t923, t926, t930, t932, t933;
  double t935, t936, t937, t938, t941, t945, t946, t950;
  double t951, t952, t953, t954, t956, t957, t959, t962;
  double t963, t966, t967, t970, t971, t972, t973, t974;
  double t975, tv2rho21, t983, t984, t986, t987, t988, t990;
  double t991, t993, t994, t996, t998, t999, t1000, t1002;
  double t1003, t1004, t1006, t1007, t1008, t1009, t1010, t1011;
  double t1012, t1013, t1014, t1015, t1016, t1017, t1018, t1019;
  double t1020, t1021, t1022, t1023, t1024, t1025, t1026, t1027;
  double t1028, t1029, t1030, t1031, t1032, t1033, t1034, t1035;
  double t1037, t1038, t1042, t1043, t1046, t1047, t1048, t1049;
  double t1050, t1051, t1052, t1053, t1054, t1055, t1058, t1062;
  double t1063, t1066, t1070, t1072, t1073, t1081, t1083, t1084;
  double t1085, t1086, t1087, t1088, t1089, t1090, t1092, t1095;
  double t1098, t1099, t1102, t1103, t1104, t1105, t1106, t1107;
  double tv2rho22, t1109, t1110, t1111, t1112, t1113, t1114, t1115;
  double t1116, t1117, t1118, t1119, t1120, t1121, t1122, t1123;
  double t1124, t1126, t1127, t1128, t1130, t1131, t1132, t1134;
  double t1135, t1136, t1137, t1138, t1139, t1140, t1141, t1142;
  double t1143, t1144, t1145, t1146, t1147, t1148, t1149, t1150;
  double t1151, t1152, t1153, t1154, t1155, t1156, t1157, t1158;
  double t1159, t1160, t1161, t1162, t1163, t1164, t1166, t1167;
  double t1168, t1169, t1171, t1172, t1173, t1175, t1177, t1178;
  double t1179, t1180, t1181, t1182, tv2rhosigma0, t1184, t1185, t1186;
  double t1187, t1188, t1189, t1190, t1191, t1192, t1193, t1194;
  double t1195, t1196, t1197, t1198, t1201, t1202, t1203, t1204;
  double t1205, tv2rhosigma1, tv2rhosigma2, t1207, t1208, t1209, t1210, t1211;
  double t1212, t1213, t1214, t1215, t1216, t1218, t1219, t1220;
  double t1222, t1223, t1224, t1225, t1226, t1227, t1228, t1229;
  double t1230, t1231, t1232, t1233, t1234, t1235, t1236, t1237;
  double t1238, t1240, t1241, t1242, t1244, t1245, t1246, t1247;
  double tv2rhosigma3, t1249, t1250, t1251, t1252, t1253, t1254, t1255;
  double t1256, t1257, t1258, t1261, t1262, t1263, t1264, tv2rhosigma4;
  double tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3, t1266, t1267, t1268;
  double t1269, t1270, t1271, t1272, t1274, t1275, t1276, t1277;
  double t1278, t1279, t1280, t1281, t1282, t1283, t1284, t1286;
  double t1287, t1288, t1290, t1291, t1292, t1293, t1294, t1295;
  double t1296, t1297, t1298, t1299, t1300, t1301, t1302, t1303;
  double t1304, t1305, t1306, t1307, t1308, t1309, t1310, t1311;
  double t1312, t1313, t1314, t1315, t1317, t1318, t1319, t1320;
  double t1321, t1322, t1323, t1324, t1325, t1326, t1327, t1328;
  double t1329, t1330, t1331, t1332, t1333, t1334, t1335, t1336;
  double t1337, t1338, t1339, t1340, t1341, t1342, t1343, t1344;
  double t1345, t1346, t1347, t1348, t1349, t1350, t1351, t1352;
  double t1353, t1354, t1355, t1356, t1357, t1358, t1359, t1360;
  double t1361, t1362, t1363, t1364, t1365, t1368, t1369, t1370;
  double t1373, t1375, t1378, t1379, t1380, t1383, t1389, t1390;
  double t1391, t1392, tv2rhotau0, t1394, t1395, t1396, t1398, t1399;
  double t1400, t1401, t1402, t1403, t1404, t1405, t1406, t1407;
  double t1408, t1409, t1410, t1411, t1412, t1413, t1414, t1416;
  double t1417, t1419, t1420, t1421, t1422, t1424, t1425, t1426;
  double t1427, t1428, t1429, t1430, t1431, t1432, t1433, t1434;
  double t1435, t1436, t1437, t1438, t1439, t1440, t1441, t1442;
  double t1443, t1444, t1445, t1446, t1447, t1448, t1449, t1450;
  double t1451, t1452, t1453, t1454, t1455, t1456, t1457, t1460;
  double t1463, t1464, t1465, t1471, t1472, t1473, t1474, tv2rhotau1;
  double t1477, t1478, t1479, t1480, t1481, t1482, t1483, t1485;
  double t1486, t1487, t1489, t1490, t1491, t1492, t1493, t1494;
  double t1495, t1496, t1497, t1498, t1499, t1500, t1501, t1502;
  double t1503, t1504, t1506, t1507, t1508, t1509, t1510, t1511;
  double t1512, t1513, t1514, t1515, t1516, t1517, t1518, t1519;
  double t1520, t1521, t1522, t1523, t1524, t1525, t1526, t1527;
  double t1528, t1529, t1530, t1534, t1537, t1538, t1544, t1545;
  double t1546, t1547, tv2rhotau2, t1549, t1550, t1551, t1552, t1554;
  double t1555, t1556, t1557, t1558, t1559, t1560, t1561, t1562;
  double t1563, t1564, t1565, t1566, t1568, t1569, t1571, t1572;
  double t1573, t1574, t1576, t1577, t1578, t1580, t1581, t1582;
  double t1583, t1584, t1585, t1586, t1587, t1588, t1589, t1590;
  double t1591, t1592, t1593, t1594, t1595, t1596, t1597, t1598;
  double t1599, t1600, t1601, t1602, t1603, t1604, t1605, t1606;
  double t1607, t1608, t1610, t1611, t1616, t1617, t1626, t1627;
  double t1628, t1629, tv2rhotau3, t1632, t1633, t1634, t1635, t1636;
  double t1637, t1639, t1640, t1641, t1642, t1643, t1644, t1645;
  double t1647, t1648, t1649, t1650, t1651, t1652, t1653, t1654;
  double t1656, t1659, t1661, t1662, tv2sigma20, t1664, t1665, t1666;
  double t1667, t1670, t1671, tv2sigma21, tv2sigma22, t1673, t1674, t1675;
  double t1676, t1679, t1680, tv2sigma23, tv2sigma24, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1;
  double tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t1682, t1683, t1684, t1685;
  double t1686, t1687, t1688, t1689, t1690, t1691, t1692, t1693;
  double t1694, t1695, t1696, t1697, t1698, t1699, t1700, t1701;
  double t1702, t1703, t1704, t1705, t1706, t1707, t1708, t1709;
  double t1710, t1711, t1712, t1713, t1714, t1716, t1717, t1719;
  double t1721, t1723, t1724, tv2sigmatau0, t1726, t1727, t1728, t1729;
  double t1730, t1731, t1732, t1733, t1734, t1735, t1736, t1738;
  double t1739, t1740, t1741, t1742, t1743, t1744, t1745, t1746;
  double t1747, t1748, t1749, t1750, t1752, t1754, t1756, t1757;
  double tv2sigmatau1, t1759, t1760, t1761, t1762, t1763, t1764, t1765;
  double t1768, t1769, tv2sigmatau2, t1771, t1772, t1773, t1774, t1775;
  double t1776, t1777, t1780, t1781, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, tv2lapl20;
  double tv2lapl21, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, t1784, t1785;
  double t1786, t1788, t1789, t1790, t1791, t1793, t1794, t1795;
  double t1796, t1797, t1798, t1800, t1801, t1802, t1803, t1805;
  double t1806, t1807, t1808, t1810, t1811, t1812, t1813, t1814;
  double t1816, t1820, t1823, t1824, tv2tau20, t1826, t1828, t1830;
  double t1831, t1832, t1833, t1834, t1836, t1837, t1838, t1839;
  double t1840, t1842, t1843, t1844, t1845, t1847, t1853, t1854;
  double tv2tau21, t1857, t1858, t1859, t1861, t1862, t1863, t1864;
  double t1866, t1867, t1868, t1870, t1871, t1872, t1875, t1876;
  double t1877, t1878, t1880, t1881, t1882, t1883, t1884, t1886;
  double t1887, t1893, t1894, tv2tau22;

  double t1896, t1897, t1898, t1900, t1901, t1903, t1905, t1907;
  double t1909, t1910, t1911, t1912, t1913, t1915, t1916, t1917;
  double t1919, t1920, t1921, t1922, t1923, t1925, t1926, t1927;
  double t1928, t1929, t1931, t1932, t1933, t1935, t1936, t1937;
  double t1939, t1940, t1941, t1942, t1944, t1949, t1950, t1951;
  double t1954, t1955, t1956, t1957, t1958, t1960, t1963, t1964;
  double t1967, t1968, t1971, t1972, t1973, t1974, t1975, t1976;
  double t1977, t1978, t1979, t1980, t1981, t1982, t1983, t1984;
  double t1985, t1986, t1987, t1988, t1989, t1990, t1992, t1993;
  double t1994, t1995, t1998, t1999, t2001, t2003, t2004, t2006;
  double t2007, t2008, t2010, t2011, t2012, t2013, t2014, t2017;
  double t2018, t2021, t2024, t2028, t2030, t2031, t2034, t2037;
  double t2041, t2043, t2044, t2047, t2048, t2050, t2052, t2053;
  double t2055, t2057, t2058, t2060, t2064, t2065, t2068, t2071;
  double t2072, t2075, t2077, t2079, t2081, t2083, t2085, t2086;
  double t2087, t2092, t2093, t2095, t2096, t2098, t2099, t2101;
  double t2102, t2104, t2105, t2106, t2108, t2110, t2113, t2115;
  double t2117, t2119, t2121, t2124, t2125, t2127, t2128, t2129;
  double t2131, t2133, t2135, t2137, t2138, t2140, t2147, t2151;
  double t2159, t2166, t2170, t2171, t2174, t2177, t2180, t2181;
  double t2184, t2186, t2187, t2189, t2190, t2192, t2201, t2202;
  double t2205, t2208, t2209, t2213, t2214, t2216, t2217, t2221;
  double t2222, t2223, t2238, t2242, t2245, t2246, t2249, t2253;
  double t2254, t2255, t2257, t2266, t2267, t2269, t2270, t2271;
  double t2272, t2273, t2275, t2276, t2277, t2278, t2279, t2280;
  double t2282, t2283, t2284, t2285, t2287, t2289, t2291, t2292;
  double t2293, t2294, t2295, t2297, t2299, t2301, t2303, t2304;
  double t2306, t2307, t2309, t2310, t2311, t2313, t2315, t2316;
  double t2320, t2322, t2323, t2324, t2325, t2326, t2327, t2328;
  double t2329, t2330, t2331, t2332, t2333, t2334, t2335, t2336;
  double t2337, t2339, t2340, t2342, t2343, t2344, t2345, t2346;
  double t2347, t2348, t2349, t2351, t2352, t2353, t2354, t2355;
  double t2357, t2358, t2359, t2361, t2362, t2364, t2365, t2367;
  double t2368, t2369, t2371, t2373, t2375, t2376, t2377, t2378;
  double t2379, t2380, t2381, t2384, t2385, t2386, t2388, t2389;
  double t2392, t2393, t2395, t2396, t2398, t2399, t2402, t2404;
  double t2405, t2406, t2408, t2409, t2410, t2412, t2413, t2414;
  double t2415, t2416, t2417, t2418, t2419, t2420, t2421, t2422;
  double t2423, t2424, t2425, t2426, t2427, t2428, t2429, t2430;
  double t2431, t2432, t2433, t2434, tv3rho30, t2451, t2452, t2453;
  double t2454, t2455, t2456, t2457, t2458, t2459, t2460, t2461;
  double t2462, t2463, t2464, t2465, t2466, t2467, t2468, t2469;
  double t2470, t2471, t2473, t2474, t2475, t2478, t2480, t2482;
  double t2484, t2486, t2487, t2488, t2490, t2491, t2493, t2494;
  double t2496, t2497, t2499, t2501, t2503, t2505, t2507, t2508;
  double t2509, t2511, t2512, t2514, t2515, t2517, t2518, t2520;
  double t2521, t2522, t2524, t2526, t2529, t2534, t2535, t2537;
  double t2540, t2541, t2544, t2545, t2548, t2549, t2552, t2553;
  double t2554, t2555, t2556, t2557, t2559, t2560, t2562, t2563;
  double t2564, t2566, t2567, t2569, t2570, t2571, t2572, t2574;
  double t2575, t2577, t2578, t2579, t2581, t2582, t2583, t2585;
  double t2586, t2587, t2588, t2590, t2591, t2593, t2594, t2596;
  double t2597, t2599, t2600, t2602, t2603, t2604, t2606, t2608;
  double t2610, t2612, t2613, t2615, t2616, t2617, t2619, t2620;
  double t2622, t2623, t2625, t2627, t2628, t2629, t2630, t2632;
  double t2633, t2634, t2636, t2637, t2638, t2642, t2644, t2646;
  double t2647, t2648, t2649, t2651, t2654, t2659, t2661, t2663;
  double t2665, t2666, t2668, t2670, t2671, t2674, t2676, t2677;
  double t2678, t2681, t2692, t2693, t2696, t2707, t2709, t2710;
  double t2712, t2715, t2716, t2717, t2718, t2719, t2721, t2723;
  double t2725, t2726, t2734, t2736, t2737, t2739, t2740, t2742;
  double t2743, t2746, t2747, t2750, t2751, t2753, t2755, t2757;
  double t2759, t2761, t2762, t2764, t2766, t2767, t2769, t2772;
  double t2774, t2776, t2777, t2779, t2780, t2783, t2784, t2788;
  double t2789, t2790, t2792, t2794, t2795, t2796, t2799, t2800;
  double t2801, t2805, t2809, t2810, t2812, t2813, t2816, t2817;
  double t2820, t2821, t2823, t2824, t2826, t2828, t2830, t2831;
  double t2833, t2835, t2837, t2839, t2843, t2844, tv3rho31, t2846;
  double t2847, t2848, t2850, t2851, t2852, t2854, t2856, t2857;
  double t2858, t2860, t2862, t2863, t2865, t2867, t2869, t2871;
  double t2872, t2873, t2875, t2876, t2877, t2879, t2880, t2881;
  double t2883, t2884, t2885, t2887, t2888, t2889, t2891, t2893;
  double t2898, t2899, t2903, t2906, t2907, t2910, t2911, t2914;
  double t2915, t2918, t2919, t2920, t2922, t2931, t2934, t2935;
  double t2940, t2942, t2944, t2946, t2951, t2956, t2960, t2961;
  double t2966, t2969, t2973, t2975, t2976, t2978, t2979, t2980;
  double t2987, t2988, t2992, t2994, t2995, t2996, t2998, t2999;
  double t3002, t3003, t3005, t3008, t3009, t3012, t3013, t3015;
  double t3017, t3018, t3020, t3021, t3023, t3024, t3029, t3031;
  double t3032, t3035, t3036, t3038, t3042, t3044, t3045, t3048;
  double t3049, t3051, t3052, t3056, t3058, t3059, t3062, t3063;
  double t3065, t3068, t3069, t3071, t3072, t3074, t3076, t3078;
  double t3079, t3080, t3082, t3084, t3086, t3088, t3090, t3092;
  double t3094, t3096, t3097, t3098, t3100, t3101, t3102, t3104;
  double t3106, t3107, t3109, t3110, t3112, t3113, t3115, t3116;
  double t3118, t3120, t3122, t3123, t3124, t3125, t3126, t3128;
  double t3129, t3130, t3132, t3133, t3134, t3136, t3137, t3139;
  double t3140, t3142, t3143, t3144, t3146, t3147, t3148, t3150;
  double t3153, t3155, t3156, t3158, t3160, t3162, t3163, t3164;
  double t3167, t3169, t3173, t3174, tv3rho32, t3175, t3176, t3177;
  double t3178, t3180, t3181, t3183, t3184, t3185, t3186, t3188;
  double t3189, t3191, t3192, t3194, t3196, t3198, t3200, t3201;
  double t3202, t3204, t3205, t3207, t3208, t3209, t3211, t3212;
  double t3213, t3215, t3219, t3220, t3224, t3227, t3228, t3231;
  double t3232, t3235, t3236, t3237, t3238, t3240, t3241, t3242;
  double t3243, t3244, t3245, t3250, t3255, t3259, t3260, t3265;
  double t3269, t3271, t3272, t3274, t3281, t3287, t3292, t3294;
  double t3295, t3296, t3297, t3298, t3299, t3300, t3301, t3302;
  double t3303, t3304, t3305, t3306, t3307, t3308, t3309, t3310;
  double t3311, t3312, t3313, t3314, t3315, t3316, t3317, t3318;
  double t3319, t3320, t3322, t3323, t3324, t3329, t3330, t3334;
  double t3339, t3340, t3343, t3345, t3346, t3347, t3349, t3350;
  double t3351, t3353, t3354, t3355, t3356, t3357, t3358, t3359;
  double t3360, t3361, t3362, t3363, t3364, t3365, t3366, t3368;
  double t3369, t3371, t3372, t3373, t3374, t3375, t3376, t3378;
  double t3379, t3380, t3381, t3382, tv3rho33, t3399, t3400, t3402;
  double t3403, t3404, t3406, t3407, t3408, t3409, t3410, t3411;
  double t3412, t3413, t3414, t3415, t3416, t3417, t3418, t3419;
  double t3420, t3421, t3422, t3423, t3424, t3425, t3426, t3427;
  double t3428, t3429, t3430, t3431, t3432, t3433, t3434, t3435;
  double t3436, t3437, t3438, t3439, t3440, t3441, t3442, t3443;
  double t3444, t3445, t3446, t3447, t3448, t3449, t3451, t3452;
  double t3453, t3454, t3455, t3456, t3457, t3459, t3460, t3461;
  double t3462, t3463, t3464, t3465, t3467, t3471, t3474, t3475;
  double t3476, t3478, t3479, t3483, t3484, t3485, t3486, t3487;
  double t3488, t3490, t3491, t3492, t3493, t3494, t3495, t3496;
  double t3497, t3498, t3499, t3500, t3501, t3502, t3503, t3504;
  double t3505, t3507, t3508, t3509, t3510, t3511, t3512, t3513;
  double t3514, t3515, t3517, t3518, t3519, t3521, t3522, t3523;
  double t3525, t3526, t3527, t3528, t3529, t3530, t3531, t3532;
  double t3533, t3534, t3535, t3536, t3537, t3538, t3539, t3540;
  double t3541, t3542, t3543, t3544, t3545, t3546, t3547, t3548;
  double t3549, t3550, t3551, t3552, t3553, t3554, t3555, t3556;
  double t3557, t3558, t3559, t3560, t3561, t3562, t3563, t3564;
  double t3565, t3566, t3567, t3568, t3569, t3570, t3571, t3572;
  double t3573, t3574, t3575, t3576, t3577, t3578, t3579, t3580;
  double t3581, t3582, t3583, t3584, t3585, t3586, t3587, t3588;
  double t3589, t3590, tv3rho2sigma0, t3598, t3599, t3601, t3610, t3612;
  double t3613, t3614, t3621, t3622, t3623, t3624, t3625, t3626;
  double t3627, t3628, t3629, t3630, t3631, t3632, t3633, t3634;
  double t3635, t3636, t3637, t3638, t3639, t3640, t3641, t3642;
  double t3643, t3644, t3645, t3646, t3647, t3649, t3650, t3651;
  double t3652, t3653, t3654, t3655, t3656, t3657, t3658, t3659;
  double t3660, t3661, t3662, t3663, t3664, t3665, t3666, t3667;
  double t3668, t3669, t3670, t3671, t3672, t3673, t3674, tv3rho2sigma1;
  double tv3rho2sigma2, t3678, t3679, t3680, t3681, t3683, t3684, t3686;
  double t3687, t3688, t3690, t3692, t3694, t3696, t3698, t3700;
  double t3702, t3703, t3704, t3705, t3707, t3708, t3710, t3711;
  double t3713, t3715, t3716, t3718, t3719, t3722, t3724, t3726;
  double t3729, t3730, t3732, t3733, t3734, t3736, t3737, t3738;
  double t3741, t3742, t3743, t3744, t3749, t3751, t3754, t3756;
  double t3758, t3761, t3764, t3767, t3769, t3771, t3773, t3775;
  double t3777, t3779, t3781, t3783, t3784, t3786, t3787, t3788;
  double t3790, t3792, t3794, t3795, t3796, t3798, t3799, t3801;
  double t3803, t3806, t3807, t3809, t3810, t3811, t3813, t3814;
  double t3816, t3817, t3818, t3821, t3823, t3824, t3826, t3827;
  double t3828, t3830, t3831, t3832, t3834, t3835, t3836, t3837;
  double t3838, t3840, t3842, t3843, t3845, t3847, t3848, t3849;
  double t3851, t3853, t3854, t3855, t3857, t3858, t3859, t3860;
  double t3862, t3863, t3864, t3875, t3879, tv3rho2sigma3, t3880, t3881;
  double t3882, t3883, t3884, t3885, t3886, t3887, t3888, t3889;
  double t3890, t3891, t3892, t3893, t3894, t3895, t3896, t3897;
  double t3898, t3899, t3900, t3901, t3902, t3903, t3904, t3905;
  double t3906, t3907, t3908, t3909, t3910, t3911, t3912, t3913;
  double t3915, t3916, t3917, t3918, t3919, t3920, t3921, t3922;
  double t3926, t3928, t3929, t3930, t3931, t3932, t3933, t3934;
  double t3935, t3936, t3937, t3938, t3939, t3940, t3941, t3942;
  double t3943, t3944, t3945, t3946, t3947, t3951, tv3rho2sigma4, tv3rho2sigma5;
  double t3952, t3953, t3954, t3955, t3956, t3957, t3958, t3959;
  double t3960, t3961, t3962, t3963, t3964, t3965, t3966, t3967;
  double t3968, t3969, t3970, t3971, t3972, t3973, t3974, t3975;
  double t3976, t3977, t3978, t3979, t3980, t3981, t3982, t3983;
  double t3984, t3985, t3986, t3987, t3988, t3989, t3990, t3991;
  double t3992, t3993, t3994, t3995, t3996, t3997, t3998, t3999;
  double t4000, t4001, t4002, t4003, t4004, t4005, t4006, t4007;
  double t4008, t4010, t4011, t4012, t4013, t4014, t4015, t4016;
  double t4017, t4018, t4019, t4021, t4022, t4024, t4025, t4026;
  double t4028, t4029, t4030, t4031, t4032, t4033, t4034, t4035;
  double t4036, t4037, t4038, t4040, t4042, t4044, t4046, t4047;
  double t4048, t4050, t4051, t4052, tv3rho2sigma6, t4070, t4071, t4072;
  double t4073, t4074, t4075, t4076, t4077, t4078, t4079, t4080;
  double t4081, t4082, t4083, t4084, t4085, t4086, t4087, t4088;
  double t4089, t4090, t4091, t4092, t4093, t4094, t4096, t4097;
  double t4098, t4099, t4100, t4101, t4102, t4103, t4104, t4105;
  double t4106, t4107, t4108, t4109, t4116, t4117, t4118, t4119;
  double t4120, t4121, t4122, t4123, t4124, t4125, tv3rho2sigma7, tv3rho2sigma8;
  double tv3rho2lapl0, tv3rho2lapl1, tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4, tv3rho2lapl5, t4129, t4130;
  double t4131, t4132, t4133, t4134, t4135, t4136, t4137, t4138;
  double t4139, t4140, t4141, t4142, t4143, t4144, t4145, t4146;
  double t4147, t4148, t4149, t4150, t4151, t4152, t4153, t4154;
  double t4155, t4156, t4157, t4158, t4159, t4160, t4161, t4162;
  double t4163, t4164, t4165, t4166, t4167, t4168, t4169, t4170;
  double t4171, t4172, t4173, t4174, t4175, t4176, t4177, t4178;
  double t4179, t4180, t4181, t4182, t4183, t4184, t4185, t4186;
  double t4187, t4188, t4189, t4190, t4191, t4192, t4193, t4194;
  double t4195, t4196, t4197, t4198, t4199, t4200, t4201, t4202;
  double t4203, t4204, t4205, t4206, t4207, t4208, t4209, t4210;
  double t4211, t4212, t4213, t4214, t4215, t4216, t4217, t4218;
  double t4219, t4220, t4221, t4222, t4223, t4224, t4225, t4226;
  double t4227, t4228, t4229, t4230, t4231, t4232, t4233, t4234;
  double t4235, t4236, t4237, t4238, t4239, t4240, t4241, t4242;
  double t4243, t4244, t4245, t4246, t4247, t4248, t4249, t4250;
  double t4251, t4252, t4253, t4254, t4255, t4256, t4257, t4258;
  double t4259, t4260, t4261, t4262, t4263, t4264, t4265, t4266;
  double t4267, t4268, t4269, t4271, t4272, t4273, t4274, t4275;
  double t4276, t4277, t4278, t4279, t4280, t4281, t4282, t4283;
  double t4284, t4285, t4286, t4287, t4288, t4289, t4290, t4291;
  double t4292, t4295, t4296, t4297, t4299, t4300, t4301, t4303;
  double t4304, t4305, t4306, t4307, t4308, t4309, t4310, t4311;
  double t4312, t4313, t4314, t4315, t4316, t4317, t4318, t4320;
  double t4321, t4322, t4323, t4324, t4325, t4326, t4327, t4328;
  double t4329, t4330, t4331, t4332, t4333, t4334, t4335, t4336;
  double t4337, t4338, t4339, t4340, t4341, t4342, t4343, t4344;
  double t4345, t4346, t4347, t4349, t4350, t4351, t4352, t4353;
  double t4354, t4355, t4356, t4357, t4358, t4359, t4360, t4361;
  double t4363, t4364, t4365, t4366, t4368, t4369, t4370, t4371;
  double t4372, t4373, t4374, t4375, t4376, t4377, t4378, t4380;
  double t4381, t4382, t4384, t4385, t4387, t4388, t4390, t4391;
  double t4392, t4393, t4394, t4395, t4396, t4397, t4398, t4399;
  double t4402, t4406, t4407, t4408, t4411, t4421, t4424, t4428;
  double t4431, t4434, t4436, t4440, t4446, t4450, t4453, t4457;
  double t4458, t4459, t4460, t4461, t4462, t4463, t4464, t4465;
  double t4466, t4467, t4468, t4469, t4470, t4471, t4472, t4473;
  double t4474, t4475, t4476, t4477, t4478, t4479, t4480, t4481;
  double t4482, t4483, t4484, t4485, t4486, t4487, t4488, t4489;
  double t4490, t4491, t4492, t4493, t4494, t4495, t4496, t4497;
  double t4498, t4518, t4520, t4523, tv3rho2tau0, t4524, t4525, t4526;
  double t4527, t4528, t4529, t4530, t4531, t4532, t4533, t4534;
  double t4535, t4536, t4538, t4539, t4540, t4541, t4542, t4543;
  double t4544, t4546, t4547, t4548, t4550, t4551, t4552, t4554;
  double t4555, t4556, t4557, t4558, t4559, t4560, t4561, t4562;
  double t4563, t4564, t4565, t4566, t4567, t4568, t4569, t4570;
  double t4571, t4572, t4573, t4574, t4575, t4576, t4577, t4578;
  double t4579, t4580, t4581, t4582, t4583, t4584, t4585, t4586;
  double t4587, t4588, t4589, t4590, t4591, t4592, t4593, t4594;
  double t4595, t4596, t4597, t4598, t4599, t4600, t4601, t4602;
  double t4603, t4604, t4606, t4607, t4609, t4610, t4612, t4613;
  double t4614, t4615, t4616, t4617, t4618, t4619, t4620, t4622;
  double t4625, t4626, t4627, t4628, t4629, t4630, t4634, t4648;
  double t4649, t4652, t4653, t4657, t4661, t4662, t4663, t4665;
  double t4666, t4667, t4668, t4669, t4670, t4671, t4672, t4673;
  double t4674, t4675, t4676, t4677, t4678, t4679, t4680, t4681;
  double t4682, t4683, t4684, t4685, t4686, t4687, t4688, t4689;
  double t4690, t4691, t4692, t4693, t4694, t4695, t4696, t4697;
  double t4698, t4699, t4700, t4701, t4702, t4703, t4704, t4705;
  double t4706, t4707, t4708, t4709, t4710, t4712, t4713, t4714;
  double t4716, t4717, t4718, t4719, t4720, t4721, t4722, t4723;
  double t4724, t4725, t4726, t4727, t4728, t4730, t4731, t4732;
  double t4733, t4734, t4735, t4736, t4737, t4738, t4739, t4740;
  double t4741, t4742, t4743, t4744, t4745, t4746, t4747, t4748;
  double t4749, t4750, t4751, t4752, t4753, t4754, t4755, t4756;
  double t4757, t4758, t4759, t4760, t4761, t4762, t4763, t4764;
  double t4765, t4766, t4783, t4785, tv3rho2tau1, t4787, t4788, t4789;
  double t4792, t4793, t4794, t4795, t4796, t4798, t4799, t4800;
  double t4801, t4803, t4804, t4806, t4807, t4809, t4810, t4811;
  double t4813, t4814, t4816, t4817, t4819, t4820, t4821, t4823;
  double t4824, t4825, t4826, t4828, t4829, t4831, t4832, t4834;
  double t4835, t4836, t4837, t4839, t4840, t4841, t4842, t4844;
  double t4846, t4847, t4849, t4850, t4851, t4853, t4854, t4855;
  double t4858, t4859, t4861, t4862, t4863, t4864, t4866, t4870;
  double t4871, t4872, t4873, t4874, t4876, t4878, t4880, t4881;
  double t4882, t4883, t4885, t4887, t4889, t4890, t4891, t4892;
  double t4894, t4895, t4896, t4898, t4899, t4903, t4905, t4907;
  double t4909, t4910, t4911, t4912, t4913, t4915, t4917, t4918;
  double t4919, t4920, t4922, t4923, t4924, t4925, t4927, t4929;
  double t4930, t4931, t4932, t4934, t4935, t4936, t4937, t4941;
  double t4942, t4943, t4945, t4946, t4947, t4949, t4950, t4951;
  double t4953, t4954, t4955, t4957, t4960, t4961, t4962, t4964;
  double t4965, t4967, t4968, t4969, t4970, t4972, t4973, t4974;
  double t4976, t4977, t4978, t4980, t4983, t4984, t4986, t4987;
  double t4988, t4991, t4992, t4995, t4996, t4998, t4999, t5001;
  double t5002, t5004, t5005, t5007, t5008, t5009, t5010, t5012;
  double t5013, t5014, t5015, t5017, t5018, t5020, t5021, t5022;
  double t5024, t5025, t5026, t5027, t5029, t5030, t5031, t5033;
  double t5034, t5036, t5037, t5039, t5040, t5042, t5043, t5045;
  double t5046, t5048, t5051, t5052, t5054, t5057, t5058, t5060;
  double t5062, t5063, t5066, t5067, t5069, t5071, t5073, t5074;
  double t5075, t5077, t5078, t5079, t5081, t5086, t5089, t5090;
  double t5091, t5094, t5096, t5101, t5102, t5108, t5111, t5113;
  double t5115, t5121, t5124, t5128, t5131, t5135, t5136, t5139;
  double t5142, t5143, t5145, t5146, t5149, t5152, t5154, t5155;
  double t5156, t5159, t5162, t5165, t5171, t5172, t5173, t5174;
  double t5175, t5177, t5178, t5179, t5181, t5182, t5183, t5184;
  double t5185, t5187, t5192, tv3rho2tau2, t5193, t5194, t5196, t5198;
  double t5200, t5201, t5202, t5204, t5206, t5207, t5208, t5210;
  double t5211, t5212, t5214, t5215, t5216, t5217, t5219, t5220;
  double t5222, t5223, t5225, t5226, t5228, t5229, t5231, t5236;
  double t5238, t5240, t5241, t5243, t5244, t5245, t5247, t5248;
  double t5249, t5250, t5252, t5254, t5255, t5256, t5258, t5259;
  double t5260, t5261, t5263, t5265, t5267, t5268, t5269, t5270;
  double t5272, t5273, t5274, t5276, t5278, t5280, t5281, t5283;
  double t5284, t5285, t5286, t5288, t5289, t5290, t5291, t5294;
  double t5297, t5300, t5303, t5306, t5309, t5311, t5312, t5313;
  double t5314, t5316, t5318, t5320, t5322, t5325, t5328, t5330;
  double t5331, t5333, t5334, t5335, t5337, t5338, t5339, t5340;
  double t5342, t5344, t5345, t5346, t5347, t5349, t5350, t5351;
  double t5353, t5356, t5357, t5358, t5359, t5361, t5363, t5365;
  double t5366, t5367, t5369, t5370, t5371, t5372, t5374, t5376;
  double t5377, t5378, t5379, t5381, t5382, t5383, t5385, t5386;
  double t5387, t5388, t5390, t5392, t5394, t5395, t5396, t5397;
  double t5399, t5401, t5403, t5405, t5406, t5408, t5410, t5412;
  double t5413, t5415, t5416, t5417, t5419, t5421, t5422, t5424;
  double t5425, t5426, t5428, t5431, t5432, t5435, t5436, t5438;
  double t5439, t5442, t5443, t5445, t5448, t5449, t5451, t5452;
  double t5453, t5455, t5456, t5457, t5460, t5463, t5465, t5467;
  double t5470, t5473, t5475, t5476, t5477, t5478, t5484, t5487;
  double t5490, t5494, t5502, t5510, t5512, t5518, t5519, t5522;
  double t5523, t5532, t5539, t5540, t5541, t5542, t5544, t5546;
  double t5547, t5549, t5550, t5551, t5552, t5554, t5555, t5557;
  double t5558, t5559, t5561, t5562, t5563, t5568, t5569, tv3rho2tau3;
  double t5570, t5571, t5572, t5573, t5574, t5575, t5576, t5577;
  double t5578, t5579, t5580, t5581, t5582, t5583, t5584, t5585;
  double t5586, t5587, t5588, t5589, t5592, t5593, t5596, t5597;
  double t5600, t5604, t5607, t5608, t5611, t5612, t5615, t5619;
  double t5623, t5627, t5628, t5629, t5631, t5632, t5633, t5634;
  double t5635, t5636, t5637, t5638, t5639, t5640, t5641, t5642;
  double t5644, t5645, t5646, t5648, t5649, t5650, t5652, t5653;
  double t5654, t5655, t5656, t5657, t5658, t5659, t5660, t5661;
  double t5662, t5663, t5664, t5665, t5666, t5667, t5668, t5669;
  double t5670, t5671, t5672, t5673, t5674, t5675, t5677, t5678;
  double t5679, t5682, t5683, t5685, t5686, t5687, t5688, t5689;
  double t5690, t5691, t5692, t5693, t5694, t5695, t5696, t5697;
  double t5698, t5699, t5700, t5701, t5702, t5703, t5704, t5705;
  double t5706, t5707, t5708, t5709, t5710, t5711, t5713, t5714;
  double t5715, t5717, t5718, t5719, t5721, t5722, t5723, t5724;
  double t5725, t5726, t5727, t5728, t5729, t5730, t5731, t5732;
  double t5733, t5734, t5735, t5736, t5737, t5738, t5739, t5740;
  double t5741, t5742, t5743, t5744, t5745, t5746, t5747, t5748;
  double t5749, t5750, t5751, t5752, t5753, t5754, t5755, t5756;
  double t5757, t5758, t5759, t5760, t5761, t5762, t5763, t5764;
  double t5765, t5766, t5767, t5768, t5769, t5770, t5771, t5772;
  double t5773, t5774, t5775, t5776, t5777, t5778, t5779, t5780;
  double t5781, t5782, t5783, t5784, tv3rho2tau4, t5803, t5804, t5805;
  double t5808, t5809, t5814, t5817, t5818, t5821, t5822, t5826;
  double t5827, t5830, t5831, t5834, t5835, t5842, t5843, t5846;
  double t5847, t5850, t5851, t5852, t5854, t5858, t5862, t5863;
  double t5864, t5865, t5866, t5867, t5868, t5869, t5870, t5871;
  double t5872, t5873, t5874, t5875, t5876, t5877, t5878, t5879;
  double t5880, t5881, t5883, t5884, t5885, t5887, t5888, t5889;
  double t5890, t5891, t5893, t5894, t5895, t5897, t5898, t5899;
  double t5900, t5901, t5902, t5903, t5905, t5906, t5907, t5908;
  double t5909, t5910, t5911, t5912, t5913, t5914, t5915, t5916;
  double t5917, t5918, t5919, t5921, t5922, t5923, t5924, t5925;
  double t5926, t5927, t5928, t5929, t5930, t5931, t5932, t5933;
  double t5934, t5935, t5936, t5937, t5938, t5939, t5940, t5941;
  double t5942, t5943, t5944, t5945, t5946, t5948, t5949, t5951;
  double t5952, t5954, t5955, t5956, t5957, t5958, t5959, t5960;
  double t5962, t5963, t5964, t5965, t5967, t5968, t5970, t5971;
  double t5973, t5974, t5975, t5976, t5977, t5978, t5979, t5980;
  double t5981, t5982, t5983, t5984, t5985, t5986, t5987, t5988;
  double t5989, t5990, t5991, t5992, t5993, t5994, t5995, t5996;
  double t5997, t5998, t5999, t6000, t6001, t6002, t6003, t6004;
  double t6005, t6006, t6007, t6008, t6009, t6010, t6011, t6012;
  double t6013, t6014, t6015, t6016, t6017, t6018, t6020, t6021;
  double t6023, t6024, t6025, t6027, t6028, t6030, t6031, t6032;
  double t6033, t6034, t6035, t6036, t6037, t6038, t6039, t6040;
  double t6041, t6042, t6043, t6044, t6045, t6046, t6047, t6048;
  double t6049, t6050, t6051, t6052, t6053, t6054, t6055, t6056;
  double t6057, t6058, t6059, t6060, t6061, t6062, t6063, t6064;
  double t6065, t6088, tv3rho2tau5, t6090, t6091, t6092, t6093, t6094;
  double t6095, t6096, t6097, t6098, t6099, t6100, t6101, t6102;
  double t6104, t6105, t6106, t6107, t6108, t6109, t6110, t6111;
  double t6112, t6113, t6114, t6115, t6116, t6117, t6118, t6119;
  double t6120, t6121, t6122, t6123, t6124, t6125, t6126, t6128;
  double t6129, t6130, t6132, t6133, t6135, t6136, t6137, t6139;
  double t6140, t6141, t6142, t6143, t6144, t6145, t6146, t6148;
  double t6149, t6150, t6151, t6152, t6154, t6155, t6156, t6157;
  double t6158, t6159, t6160, t6161, t6162, t6163, t6165, t6166;
  double t6167, t6168, t6172, t6175, t6176, t6177, t6178, t6179;
  double t6180, tv3rhosigma20, t6182, t6183, t6184, t6185, t6186, t6187;
  double t6188, t6189, t6190, t6191, t6192, t6193, t6194, t6195;
  double t6196, t6197, t6198, t6199, t6200, t6203, t6204, t6205;
  double t6206, t6207, tv3rhosigma21, tv3rhosigma22, t6209, t6210, t6211, t6212;
  double t6213, t6214, t6215, t6216, t6217, t6218, t6219, t6220;
  double t6221, t6222, t6223, t6224, t6225, t6226, t6227, t6230;
  double t6231, t6232, t6233, t6234, tv3rhosigma23, tv3rhosigma24, tv3rhosigma25, t6236;
  double t6237, t6238, t6239, t6240, t6241, t6242, t6243, t6244;
  double t6245, t6246, t6247, t6248, t6249, t6250, t6251, t6253;
  double t6254, t6255, t6257, t6258, t6260, t6261, t6262, t6263;
  double t6264, t6265, t6266, t6268, t6269, t6270, t6271, t6272;
  double t6273, t6274, t6275, t6277, t6279, t6281, t6282, t6283;
  double t6284, tv3rhosigma26, t6286, t6287, t6288, t6289, t6290, t6291;
  double t6292, t6293, t6294, t6295, t6296, t6297, t6300, t6301;
  double t6302, t6303, tv3rhosigma27, tv3rhosigma28, t6305, t6306, t6307, t6308;
  double t6309, t6310, t6311, t6312, t6313, t6314, t6315, t6316;
  double t6319, t6320, t6321, t6322, tv3rhosigma29, tv3rhosigma210, tv3rhosigma211, tv3rhosigmalapl0;
  double tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8;
  double tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, t6324, t6325, t6326, t6327, t6328;
  double t6329, t6330, t6331, t6332, t6333, t6334, t6335, t6336;
  double t6337, t6338, t6339, t6340, t6341, t6342, t6343, t6344;
  double t6345, t6346, t6347, t6348, t6349, t6350, t6351, t6352;
  double t6353, t6354, t6355, t6356, t6357, t6358, t6359, t6360;
  double t6361, t6362, t6363, t6364, t6365, t6366, t6367, t6368;
  double t6369, t6370, t6371, t6372, t6373, t6374, t6375, t6376;
  double t6377, t6378, t6379, t6380, t6381, t6382, t6383, t6384;
  double t6385, t6386, t6387, t6388, t6389, t6390, t6391, t6392;
  double t6393, t6394, t6395, t6396, t6397, t6398, t6399, t6400;
  double t6401, t6402, t6403, t6404, t6405, t6406, t6407, t6408;
  double t6409, t6410, t6411, t6412, t6413, t6414, t6415, t6416;
  double t6417, t6418, t6419, t6420, t6422, t6423, t6424, t6425;
  double t6426, t6427, t6428, t6429, t6430, t6431, t6432, t6433;
  double t6434, t6435, t6436, t6437, t6438, t6439, t6440, t6441;
  double t6442, t6443, t6444, t6445, t6446, t6447, t6448, t6449;
  double t6450, t6451, t6452, t6453, t6454, t6455, t6456, t6457;
  double t6458, t6459, t6460, t6461, t6462, t6463, t6464, t6465;
  double t6466, t6467, t6468, t6469, t6470, t6471, t6472, t6474;
  double t6475, t6477, t6480, t6481, t6482, t6484, t6485, t6488;
  double t6490, t6491, t6493, t6495, t6496, t6497, t6498, t6499;
  double t6500, t6501, t6502, t6503, t6504, t6505, t6506, t6507;
  double t6508, t6509, t6510, t6511, t6512, t6513, t6514, t6515;
  double t6516, t6517, t6518, t6519, t6520, t6521, t6522, t6523;
  double t6524, t6525, t6526, t6527, t6528, t6529, t6530, t6531;
  double t6532, t6533, t6534, t6535, tv3rhosigmatau0, t6539, t6540, t6541;
  double t6542, t6543, t6544, t6545, t6546, t6547, t6548, t6549;
  double t6550, t6551, t6552, t6553, t6554, t6555, t6556, t6557;
  double t6558, t6559, t6560, t6561, t6562, t6563, t6564, t6566;
  double t6567, t6568, t6569, t6571, t6572, t6573, t6574, t6576;
  double t6577, t6578, t6579, t6580, t6581, t6582, t6583, t6584;
  double t6585, t6586, t6587, t6588, t6589, t6590, t6591, t6592;
  double t6593, t6594, t6595, t6596, t6597, t6598, t6599, t6600;
  double t6601, t6602, t6603, t6604, t6605, t6607, t6608, t6610;
  double t6612, t6613, t6615, t6616, t6619, t6621, t6623, t6624;
  double t6625, t6626, t6627, t6628, t6629, t6630, t6631, t6632;
  double t6633, t6634, t6635, t6636, t6637, t6638, t6640, t6641;
  double t6643, t6644, t6645, t6646, t6647, t6648, t6649, t6650;
  double t6651, t6653, t6654, t6655, t6656, t6657, t6658, t6659;
  double t6660, t6661, t6662, t6663, t6664, t6665, t6666, t6667;
  double t6668, t6669, t6670, t6671, t6672, t6673, t6674, t6675;
  double t6676, t6677, t6678, t6679, t6680, t6681, t6682, t6683;
  double t6684, t6685, t6686, t6687, t6688, t6689, tv3rhosigmatau1, t6693;
  double t6694, t6695, t6696, t6697, t6698, t6699, t6700, t6701;
  double t6702, t6703, t6704, t6705, t6706, t6710, t6714, t6715;
  double t6716, t6717, t6718, t6719, t6720, t6721, t6722, t6723;
  double t6724, t6725, t6726, t6727, t6728, t6730, t6731, t6732;
  double t6733, t6734, t6735, t6736, t6737, t6738, t6739, t6740;
  double t6741, t6742, t6743, t6744, t6745, t6746, t6747, t6748;
  double t6749, t6750, t6751, t6752, t6753, t6754, t6755, t6756;
  double tv3rhosigmatau2, t6760, t6761, t6762, t6763, t6764, t6765, t6766;
  double t6767, t6768, t6769, t6771, t6772, t6773, t6774, t6775;
  double t6776, t6777, t6778, t6779, t6780, t6781, t6782, t6784;
  double t6787, t6790, t6791, t6792, t6793, t6794, t6795, t6796;
  double t6797, t6798, t6799, t6800, t6801, t6802, t6803, t6804;
  double t6805, t6806, t6807, t6808, t6809, t6810, t6811, t6812;
  double t6813, t6814, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, t6818, t6819, t6820;
  double t6821, t6822, t6823, t6824, t6825, t6826, t6827, t6828;
  double t6829, t6830, t6831, t6832, t6833, t6834, t6835, t6836;
  double t6837, t6838, t6839, t6840, t6841, t6842, t6843, t6844;
  double t6845, t6846, t6848, t6849, t6850, t6851, t6852, t6853;
  double t6854, t6855, t6856, t6857, t6858, t6860, t6862, t6863;
  double t6864, t6866, t6867, t6868, t6870, t6871, t6872, t6873;
  double t6874, t6875, t6876, t6877, t6878, t6879, t6880, t6881;
  double t6882, t6883, t6884, t6885, t6886, t6887, t6889, t6890;
  double t6891, t6892, t6893, t6894, t6895, t6896, t6897, t6898;
  double t6900, t6901, t6902, t6903, t6904, t6905, t6906, t6907;
  double t6908, t6909, t6910, t6911, t6912, t6913, t6914, t6915;
  double t6916, t6917, t6918, t6919, t6920, t6921, t6922, t6923;
  double t6924, t6925, t6926, t6927, t6928, t6929, t6930, t6931;
  double t6932, tv3rhosigmatau6, t6936, t6937, t6938, t6939, t6940, t6941;
  double t6942, t6943, t6944, t6945, t6946, t6947, t6948, t6949;
  double t6950, t6951, t6952, t6953, t6955, t6956, t6957, t6958;
  double t6959, t6960, t6961, t6962, t6963, t6964, t6965, t6966;
  double t6967, t6968, t6969, t6970, t6971, t6972, t6973, t6974;
  double t6975, t6976, t6977, t6978, t6979, t6980, t6981, t6982;
  double t6983, t6984, t6985, t6986, t6987, t6988, t6989, t6990;
  double t6991, t6992, t6993, t6994, t6995, t6996, t6997, t6998;
  double t6999, t7000, t7001, t7002, t7003, t7004, t7005, t7006;
  double t7007, t7008, t7009, t7010, t7011, t7013, t7014, t7015;
  double t7016, t7017, t7018, t7019, t7020, t7021, t7022, t7023;
  double t7024, t7025, t7026, t7027, t7028, t7029, t7030, t7031;
  double t7032, t7033, t7034, t7035, t7036, t7037, t7038, t7039;
  double t7040, t7041, t7042, t7043, t7044, t7045, t7047, t7048;
  double t7050, t7052, t7053, t7054, t7057, t7060, t7062, t7063;
  double t7064, t7065, t7066, t7067, t7068, t7069, t7070, tv3rhosigmatau7;
  double t7074, t7075, t7076, t7077, t7078, t7079, t7080, t7081;
  double t7082, t7083, t7085, t7086, t7087, t7088, t7089, t7090;
  double t7091, t7092, t7098, t7099, t7100, t7101, t7102, t7103;
  double t7104, t7105, t7106, t7107, t7108, t7109, t7110, t7111;
  double t7112, t7113, t7114, tv3rhosigmatau8, t7118, t7119, t7120, t7121;
  double t7122, t7123, t7124, t7125, t7126, t7127, t7128, t7129;
  double t7130, t7131, t7132, t7133, t7134, t7135, t7142, t7143;
  double t7144, t7145, t7146, t7147, t7148, t7149, t7150, t7151;
  double t7153, t7154, t7155, t7156, t7157, t7158, t7159, t7160;
  double t7161, t7162, t7163, t7164, t7165, t7166, t7167, tv3rhosigmatau9;
  double tv3rhosigmatau10, tv3rhosigmatau11, tv3rholapl20, tv3rholapl21, tv3rholapl22, tv3rholapl23, tv3rholapl24, tv3rholapl25;
  double tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7;
  double t7171, t7172, t7173, t7174, t7175, t7176, t7177, t7178;
  double t7179, t7180, t7181, t7183, t7184, t7185, t7186, t7187;
  double t7188, t7189, t7190, t7191, t7192, t7193, t7194, t7195;
  double t7196, t7197, t7198, t7199, t7200, t7201, t7202, t7203;
  double t7204, t7205, t7206, t7207, t7208, t7209, t7210, t7211;
  double t7212, t7213, t7214, t7215, t7216, t7217, t7218, t7219;
  double t7220, t7221, t7222, t7223, t7224, t7225, t7226, t7227;
  double t7228, t7229, t7230, t7231, t7235, t7236, t7238, t7241;
  double t7245, t7248, t7249, t7252, t7256, t7257, t7258, t7259;
  double t7260, t7261, t7262, t7263, t7264, t7265, t7266, t7267;
  double t7268, t7269, t7270, t7271, t7272, t7273, t7274, t7276;
  double t7277, t7278, t7279, t7280, t7281, t7282, t7283, t7284;
  double t7285, t7286, t7287, t7288, t7289, t7290, t7291, t7292;
  double t7293, t7294, t7295, t7296, t7297, t7298, t7299, t7300;
  double t7301, t7302, t7303, t7304, t7305, t7306, t7307, t7308;
  double t7309, t7310, t7311, t7312, t7313, t7314, t7315, t7316;
  double t7317, t7318, t7319, t7320, t7321, t7322, t7323, t7324;
  double t7325, t7326, t7327, t7328, t7329, t7330, t7331, t7332;
  double t7333, t7334, t7335, tv3rhotau20, t7338, t7339, t7340, t7341;
  double t7342, t7343, t7344, t7345, t7346, t7347, t7348, t7349;
  double t7350, t7351, t7352, t7353, t7354, t7355, t7356, t7357;
  double t7358, t7359, t7360, t7361, t7362, t7363, t7364, t7365;
  double t7366, t7367, t7368, t7370, t7371, t7372, t7373, t7374;
  double t7375, t7376, t7377, t7378, t7379, t7380, t7381, t7382;
  double t7383, t7384, t7385, t7386, t7387, t7388, t7389, t7390;
  double t7391, t7392, t7393, t7394, t7395, t7396, t7397, t7398;
  double t7399, t7400, t7401, t7402, t7403, t7404, t7406, t7407;
  double t7408, t7409, t7410, t7411, t7412, t7413, t7416, t7421;
  double t7424, t7427, t7437, t7438, t7439, t7440, t7441, t7442;
  double t7443, t7444, t7445, t7446, t7447, t7448, t7449, t7450;
  double t7451, t7452, t7453, t7454, t7455, t7456, t7457, t7458;
  double t7459, t7460, t7461, t7462, t7463, t7464, t7465, t7466;
  double t7467, t7468, t7469, t7470, t7471, t7472, t7473, t7474;
  double t7475, t7476, t7477, t7478, t7479, t7480, t7481, t7482;
  double t7483, t7484, t7485, t7486, t7487, t7488, t7489, t7490;
  double t7492, t7493, t7494, t7495, t7496, t7497, t7498, t7499;
  double t7500, t7501, t7502, t7503, t7504, t7505, tv3rhotau21, t7508;
  double t7509, t7510, t7511, t7513, t7514, t7515, t7516, t7517;
  double t7518, t7519, t7520, t7521, t7522, t7523, t7524, t7525;
  double t7526, t7527, t7528, t7529, t7530, t7531, t7532, t7533;
  double t7534, t7535, t7536, t7537, t7538, t7539, t7540, t7541;
  double t7542, t7543, t7544, t7545, t7546, t7547, t7548, t7549;
  double t7550, t7551, t7552, t7553, t7555, t7556, t7557, t7558;
  double t7559, t7560, t7561, t7562, t7564, t7565, t7566, t7568;
  double t7569, t7570, t7571, t7572, t7573, t7574, t7575, t7577;
  double t7586, t7587, t7590, t7591, t7592, t7593, t7594, t7595;
  double t7596, t7597, t7598, t7599, t7600, t7601, t7602, t7603;
  double t7604, t7605, t7606, t7607, t7608, t7609, t7610, t7611;
  double t7612, t7613, t7614, t7615, t7616, t7617, t7618, t7619;
  double t7620, t7621, t7622, t7623, t7624, t7625, t7626, t7627;
  double t7628, t7629, tv3rhotau22, t7632, t7633, t7634, t7635, t7636;
  double t7637, t7638, t7639, t7640, t7641, t7642, t7643, t7644;
  double t7645, t7646, t7647, t7648, t7649, t7650, t7651, t7652;
  double t7653, t7654, t7655, t7656, t7657, t7658, t7659, t7660;
  double t7661, t7662, t7663, t7664, t7665, t7666, t7667, t7668;
  double t7669, t7670, t7672, t7675, t7678, t7679, t7682, t7686;
  double t7687, t7688, t7689, t7690, t7691, t7692, t7693, t7694;
  double t7695, t7696, t7697, t7698, t7699, t7700, t7701, t7702;
  double t7703, t7704, t7705, t7706, t7707, t7708, t7709, t7710;
  double t7711, t7712, t7713, t7714, t7715, t7716, t7717, t7718;
  double t7719, t7720, t7721, t7722, t7723, t7724, t7725, tv3rhotau23;
  double t7728, t7729, t7730, t7731, t7732, t7733, t7734, t7735;
  double t7736, t7737, t7738, t7739, t7740, t7741, t7742, t7743;
  double t7744, t7745, t7746, t7747, t7748, t7749, t7750, t7753;
  double t7754, t7757, t7760, t7763, t7775, t7776, t7777, t7778;
  double t7779, t7780, t7781, t7782, t7783, t7784, t7785, t7786;
  double t7787, t7788, t7789, t7790, t7791, t7792, t7793, t7794;
  double t7795, t7796, t7797, t7798, t7799, t7800, t7801, t7802;
  double t7803, t7804, t7805, t7806, t7807, t7808, t7809, t7810;
  double t7811, t7812, t7813, t7814, t7815, t7816, t7817, t7818;
  double t7819, t7820, t7821, t7822, t7823, t7824, t7825, t7826;
  double t7827, t7828, t7829, t7830, t7831, t7832, t7833, t7834;
  double t7835, t7836, t7837, t7838, t7839, t7840, t7841, t7842;
  double t7843, t7844, t7845, t7846, t7847, t7848, t7849, t7850;
  double t7851, t7852, t7853, t7854, t7855, t7856, tv3rhotau24, t7859;
  double t7861, t7862, t7863, t7865, t7866, t7868, t7869, t7870;
  double t7871, t7872, t7873, t7875, t7876, t7877, t7878, t7879;
  double t7880, t7881, t7882, t7883, t7884, t7885, t7886, t7887;
  double t7888, t7889, t7890, t7891, t7892, t7893, t7894, t7895;
  double t7896, t7897, t7898, t7899, t7900, t7901, t7902, t7903;
  double t7904, t7905, t7906, t7907, t7908, t7909, t7914, t7919;
  double t7926, t7927, t7930, t7931, t7932, t7933, t7934, t7935;
  double t7936, t7937, t7938, t7939, t7940, t7941, t7942, t7943;
  double t7944, t7945, t7946, t7947, t7948, t7949, t7950, t7951;
  double t7952, t7953, t7954, t7955, t7956, t7957, t7958, t7959;
  double t7960, t7961, t7962, t7963, t7964, t7965, t7966, t7967;
  double t7968, t7969, t7971, t7972, t7974, t7975, t7976, tv3rhotau25;
  double t7979, t7980, t7981, t7982, t7983, t7984, t7985, t7986;
  double t7987, t7988, t7989, t7990, t7992, t7993, t7994, t7995;
  double t7996, t7997, t7998, t7999, t8002, t8003, t8005, t8006;
  double tv3sigma30, t8008, t8009, t8010, t8011, t8014, t8015, tv3sigma31;
  double tv3sigma32, t8017, t8018, t8019, t8020, t8023, t8024, tv3sigma33;
  double tv3sigma34, tv3sigma35, t8026, t8027, t8028, t8029, t8032, t8033;
  double tv3sigma36, tv3sigma37, tv3sigma38, tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3;
  double tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11;
  double t8035, t8036, t8037, t8038, t8039, t8040, t8042, t8043;
  double t8044, t8045, t8046, t8047, t8048, t8049, t8050, t8051;
  double t8052, t8053, t8054, t8055, t8056, t8057, t8058, t8060;
  double t8061, t8062, t8063, t8064, t8065, t8066, t8067, t8068;
  double t8070, t8071, t8072, t8074, t8075, tv3sigma2tau0, t8077, t8078;
  double t8079, t8080, t8081, t8082, t8083, t8084, t8085, t8086;
  double t8087, t8088, t8089, t8090, t8091, t8092, t8093, t8094;
  double t8095, t8096, t8097, t8098, t8099, t8101, t8103, t8105;
  double t8106, tv3sigma2tau1, t8108, t8109, t8110, t8111, t8112, t8113;
  double t8114, t8115, t8118, t8119, tv3sigma2tau2, t8121, t8122, t8123;
  double t8124, t8125, t8126, t8127, t8128, t8131, t8132, tv3sigma2tau3;
  double tv3sigma2tau4, tv3sigma2tau5, t8134, t8135, t8136, t8137, t8138, t8139;
  double t8140, t8141, t8144, t8145, tv3sigma2tau6, t8147, t8148, t8149;
  double t8150, t8151, t8152, t8153, t8154, t8157, t8158, tv3sigma2tau7;
  double tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23;
  double tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2;
  double tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10;
  double tv3sigmalapltau11, t8160, t8161, t8162, t8163, t8164, t8165, t8166;
  double t8167, t8168, t8169, t8170, t8171, t8172, t8173, t8174;
  double t8175, t8176, t8177, t8179, t8180, t8181, t8182, t8183;
  double t8184, t8185, t8186, t8187, t8188, t8189, t8190, t8191;
  double t8192, t8193, t8194, t8195, t8196, t8197, t8198, t8199;
  double t8200, t8201, t8202, t8203, t8204, t8206, t8207, t8208;
  double t8210, t8211, t8212, tv3sigmatau20, t8213, t8214, t8215, t8216;
  double t8217, t8218, t8219, t8220, t8221, t8222, t8223, t8224;
  double t8225, t8226, t8227, t8228, t8229, t8230, t8231, t8232;
  double t8234, t8235, t8236, t8237, t8238, t8239, t8240, t8241;
  double t8242, t8243, t8245, t8246, t8247, t8248, t8249, t8250;
  double t8251, t8252, t8253, t8254, t8256, t8257, t8259, t8260;
  double t8261, tv3sigmatau21, t8262, t8263, t8264, t8265, t8266, t8267;
  double t8268, t8269, t8270, t8271, t8272, t8273, t8274, t8275;
  double t8276, t8277, t8278, t8279, t8280, t8281, t8282, t8283;
  double t8284, t8285, t8286, t8287, t8288, t8289, t8290, t8291;
  double t8292, t8293, t8294, t8295, t8296, t8298, t8300, t8302;
  double t8303, t8304, tv3sigmatau22, t8305, t8306, t8307, t8308, t8309;
  double t8310, t8311, t8312, t8313, t8314, t8315, t8318, t8319;
  double t8320, tv3sigmatau23, t8321, t8322, t8323, t8324, t8325, t8326;
  double t8327, t8328, t8329, t8330, t8331, t8334, t8335, t8336;
  double tv3sigmatau24, t8337, t8338, t8339, t8340, t8341, t8342, t8343;
  double t8344, t8345, t8346, t8347, t8350, t8351, t8352, tv3sigmatau25;
  double tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, tv3lapl30, tv3lapl31, tv3lapl32, tv3lapl33, tv3lapl2tau0;
  double tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22;
  double tv3lapltau23, tv3lapltau24, tv3lapltau25, t8353, t8354, t8355, t8356, t8357;
  double t8358, t8359, t8361, t8362, t8363, t8364, t8365, t8367;
  double t8368, t8369, t8370, t8372, t8373, t8375, t8377, t8378;
  double t8379, t8380, t8381, t8383, t8384, t8385, t8386, t8388;
  double t8389, t8390, t8391, t8393, t8399, t8400, tv3tau30, t8403;
  double t8404, t8406, t8408, t8410, t8411, t8413, t8414, t8415;
  double t8416, t8418, t8419, t8420, t8422, t8423, t8424, t8426;
  double t8429, t8430, t8431, t8434, t8435, tv3tau31, t8437, t8438;
  double t8439, t8441, t8442, t8444, t8445, t8446, t8448, t8450;
  double t8451, t8453, t8454, t8455, t8457, t8458, t8459, t8461;
  double t8462, t8463, t8464, t8466, t8467, t8471, t8472, t8473;
  double t8474, t8477, t8478, tv3tau32, t8480, t8481, t8482, t8483;
  double t8484, t8485, t8486, t8488, t8489, t8490, t8492, t8493;
  double t8495, t8496, t8498, t8500, t8501, t8502, t8503, t8504;
  double t8506, t8507, t8508, t8509, t8511, t8512, t8513, t8514;
  double t8516, t8519, t8522, t8523, tv3tau33;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t7 = tau[0] * t6;
  t8 = rho[0] - rho[1];
  t9 = rho[0] + rho[1];
  t10 = 0.1e1 / t9;
  t11 = t8 * t10;
  t12 = 0.1e1 + t11;
  t13 = t12 / 0.2e1;
  t14 = POW_1_3(t13);
  t15 = t14 * t14;
  t16 = t15 * t13;
  t17 = t7 * t16;
  t18 = POW_1_3(rho[1]);
  t19 = t18 * t18;
  t21 = 0.1e1 / t19 / rho[1];
  t22 = tau[1] * t21;
  t23 = 0.1e1 - t11;
  t24 = t23 / 0.2e1;
  t25 = POW_1_3(t24);
  t26 = t25 * t25;
  t27 = t26 * t24;
  t28 = t22 * t27;
  t30 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t31 = t9 * t9;
  t32 = POW_1_3(t9);
  t33 = t32 * t32;
  t35 = 0.1e1 / t33 / t31;
  t38 = t17 + t28 - t30 * t35 / 0.8e1;
  t39 = t2 * t38;
  t40 = M_CBRT6;
  t41 = M_PI * M_PI;
  t42 = POW_1_3(t41);
  t43 = t42 * t42;
  t44 = 0.1e1 / t43;
  t45 = t40 * t44;
  t46 = t39 * t45;
  t47 = M_CBRT2;
  t48 = t47 * t47;
  t50 = t45 * t48;
  t53 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t38 * t50;
  t54 = 0.1e1 / t53;
  t55 = t48 * t54;
  t56 = t31 * t31;
  t58 = 0.1e1 / t33 / t56;
  t59 = t30 * t58;
  t60 = t17 + t28;
  t61 = 0.1e1 / t60;
  t62 = t8 * t8;
  t63 = t61 * t62;
  t66 = 0.1e1 - t59 * t63 / 0.8e1;
  t67 = M_CBRT3;
  t68 = 0.1e1 / M_PI;
  t69 = POW_1_3(t68);
  t70 = t67 * t69;
  t71 = M_CBRT4;
  t72 = t71 * t71;
  t75 = t70 * t72 / t32;
  t77 = 0.1e1 + 0.53425e-1 * t75;
  t78 = sqrt(t75);
  t81 = POW_3_2(t75);
  t83 = t67 * t67;
  t84 = t69 * t69;
  t85 = t83 * t84;
  t88 = t85 * t71 / t33;
  t90 = 0.379785e1 * t78 + 0.8969e0 * t75 + 0.204775e0 * t81 + 0.123235e0 * t88;
  t93 = 0.1e1 + 0.16081979498692535067e2 / t90;
  t94 = log(t93);
  t96 = 0.621814e-1 * t77 * t94;
  t97 = t62 * t62;
  t98 = 0.1e1 / t56;
  t99 = t97 * t98;
  t100 = t12 <= p->zeta_threshold;
  t101 = POW_1_3(p->zeta_threshold);
  t102 = t101 * p->zeta_threshold;
  t103 = POW_1_3(t12);
  t105 = my_piecewise3(t100, t102, t103 * t12);
  t106 = t23 <= p->zeta_threshold;
  t107 = POW_1_3(t23);
  t109 = my_piecewise3(t106, t102, t107 * t23);
  t110 = t105 + t109 - 0.2e1;
  t113 = 0.1e1 / (0.2e1 * t47 - 0.2e1);
  t114 = t110 * t113;
  t116 = 0.1e1 + 0.5137e-1 * t75;
  t121 = 0.705945e1 * t78 + 0.1549425e1 * t75 + 0.420775e0 * t81 + 0.1562925e0 * t88;
  t124 = 0.1e1 + 0.32163958997385070134e2 / t121;
  t125 = log(t124);
  t129 = 0.1e1 + 0.278125e-1 * t75;
  t134 = 0.51785e1 * t78 + 0.905775e0 * t75 + 0.1100325e0 * t81 + 0.1241775e0 * t88;
  t137 = 0.1e1 + 0.29608749977793437516e2 / t134;
  t138 = log(t137);
  t139 = t129 * t138;
  t141 = -0.310907e-1 * t116 * t125 + t96 - 0.19751673498613801407e-1 * t139;
  t142 = t114 * t141;
  t146 = -t96 + t99 * t142 + 0.19751673498613801407e-1 * t114 * t139;
  t147 = t66 * t146;
  t148 = t55 * t147;
  t150 = 0.5e1 / 0.9e1 * t46 * t148;
  t151 = t39 * t40;
  t152 = t44 * t48;
  t153 = t152 * t54;
  t154 = t151 * t153;
  t156 = 0.1e1 - 0.5e1 / 0.9e1 * t154;
  t157 = t156 * t146;
  tzk0 = t150 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = rho[0] * rho[0];
  t160 = 0.1e1 / t4 / t158;
  t161 = tau[0] * t160;
  t162 = t161 * t16;
  t164 = 0.1e1 / t31;
  t165 = t8 * t164;
  t166 = t10 - t165;
  t167 = t166 / 0.2e1;
  t168 = t15 * t167;
  t169 = t7 * t168;
  t171 = -t167;
  t172 = t26 * t171;
  t173 = t22 * t172;
  t175 = t31 * t9;
  t177 = 0.1e1 / t33 / t175;
  t179 = t30 * t177 / 0.3e1;
  t180 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173 + t179;
  t181 = t2 * t180;
  t182 = t181 * t45;
  t183 = t182 * t148;
  t184 = 0.5e1 / 0.9e1 * t183;
  t185 = t40 * t40;
  t187 = 0.1e1 / t42 / t41;
  t188 = t185 * t187;
  t189 = t188 * t47;
  t190 = t39 * t189;
  t191 = t53 * t53;
  t192 = 0.1e1 / t191;
  t193 = t192 * t66;
  t194 = t146 * params->c;
  t195 = t194 * t180;
  t196 = t193 * t195;
  t197 = t190 * t196;
  t198 = 0.5e2 / 0.81e2 * t197;
  t199 = t56 * t9;
  t201 = 0.1e1 / t33 / t199;
  t202 = t30 * t201;
  t204 = 0.7e1 / 0.12e2 * t202 * t63;
  t205 = t60 * t60;
  t206 = 0.1e1 / t205;
  t207 = t206 * t62;
  t209 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173;
  t210 = t207 * t209;
  t213 = t61 * t8;
  t215 = t59 * t213 / 0.4e1;
  t216 = t204 + t59 * t210 / 0.8e1 - t215;
  t217 = t216 * t146;
  t218 = t55 * t217;
  t219 = t46 * t218;
  t220 = 0.5e1 / 0.9e1 * t219;
  t222 = 0.1e1 / t32 / t9;
  t223 = t72 * t222;
  t226 = 0.11073470983333333333e-2 * t70 * t223 * t94;
  t227 = t90 * t90;
  t228 = 0.1e1 / t227;
  t229 = t77 * t228;
  t231 = 0.1e1 / t78 * t67;
  t232 = t69 * t72;
  t233 = t232 * t222;
  t234 = t231 * t233;
  t236 = t70 * t223;
  t238 = sqrt(t75);
  t239 = t238 * t67;
  t240 = t239 * t233;
  t245 = t85 * t71 / t33 / t9;
  t247 = -0.632975e0 * t234 - 0.29896666666666666667e0 * t236 - 0.1023875e0 * t240 - 0.82156666666666666667e-1 * t245;
  t248 = 0.1e1 / t93;
  t249 = t247 * t248;
  t251 = 0.1e1 * t229 * t249;
  t252 = t62 * t8;
  t253 = t252 * t98;
  t255 = 0.4e1 * t253 * t142;
  t256 = 0.1e1 / t199;
  t257 = t97 * t256;
  t259 = 0.4e1 * t257 * t142;
  t262 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t166);
  t263 = -t166;
  t266 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t263);
  t268 = (t262 + t266) * t113;
  t269 = t268 * t141;
  t274 = t121 * t121;
  t275 = 0.1e1 / t274;
  t276 = t116 * t275;
  t281 = -0.1176575e1 * t234 - 0.516475e0 * t236 - 0.2103875e0 * t240 - 0.104195e0 * t245;
  t282 = 0.1e1 / t124;
  t283 = t281 * t282;
  t289 = t134 * t134;
  t290 = 0.1e1 / t289;
  t291 = t129 * t290;
  t296 = -0.86308333333333333334e0 * t234 - 0.301925e0 * t236 - 0.5501625e-1 * t240 - 0.82785e-1 * t245;
  t297 = 0.1e1 / t137;
  t298 = t296 * t297;
  t301 = 0.53237641966666666666e-3 * t70 * t223 * t125 + 0.1e1 * t276 * t283 - t226 - t251 + 0.18311447306006545054e-3 * t70 * t223 * t138 + 0.5848223622634646207e0 * t291 * t298;
  t302 = t114 * t301;
  t303 = t99 * t302;
  t306 = t114 * t67;
  t308 = t232 * t222 * t138;
  t310 = 0.18311447306006545054e-3 * t306 * t308;
  t311 = t114 * t129;
  t313 = t290 * t296 * t297;
  t315 = 0.5848223622634646207e0 * t311 * t313;
  t316 = t226 + t251 + t255 - t259 + t99 * t269 + t303 + 0.19751673498613801407e-1 * t268 * t139 - t310 - t315;
  t317 = t66 * t316;
  t318 = t55 * t317;
  t319 = t46 * t318;
  t320 = 0.5e1 / 0.9e1 * t319;
  t321 = t181 * t40;
  t322 = t321 * t153;
  t324 = t39 * t188;
  t325 = t47 * t192;
  t326 = params->c * t180;
  t327 = t325 * t326;
  t330 = -0.5e1 / 0.9e1 * t322 + 0.5e2 / 0.81e2 * t324 * t327;
  t331 = t330 * t146;
  t332 = t156 * t316;
  tvrho0 = t150 + t157 + t9 * (t184 - t198 + t220 + t320 + t331 + t332);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t335 = -t10 - t165;
  t336 = t335 / 0.2e1;
  t337 = t15 * t336;
  t338 = t7 * t337;
  t340 = rho[1] * rho[1];
  t342 = 0.1e1 / t19 / t340;
  t343 = tau[1] * t342;
  t344 = t343 * t27;
  t346 = -t336;
  t347 = t26 * t346;
  t348 = t22 * t347;
  t350 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348 + t179;
  t351 = t2 * t350;
  t352 = t351 * t45;
  t353 = t352 * t148;
  t354 = 0.5e1 / 0.9e1 * t353;
  t355 = t194 * t350;
  t356 = t193 * t355;
  t357 = t190 * t356;
  t358 = 0.5e2 / 0.81e2 * t357;
  t360 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348;
  t361 = t207 * t360;
  t364 = t204 + t59 * t361 / 0.8e1 + t215;
  t365 = t364 * t146;
  t366 = t55 * t365;
  t367 = t46 * t366;
  t368 = 0.5e1 / 0.9e1 * t367;
  t371 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t335);
  t372 = -t335;
  t375 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t372);
  t377 = (t371 + t375) * t113;
  t378 = t377 * t141;
  t382 = t226 + t251 - t255 - t259 + t99 * t378 + t303 + 0.19751673498613801407e-1 * t377 * t139 - t310 - t315;
  t383 = t66 * t382;
  t384 = t55 * t383;
  t385 = t46 * t384;
  t386 = 0.5e1 / 0.9e1 * t385;
  t387 = t351 * t40;
  t388 = t387 * t153;
  t390 = params->c * t350;
  t391 = t325 * t390;
  t394 = -0.5e1 / 0.9e1 * t388 + 0.5e2 / 0.81e2 * t324 * t391;
  t395 = t394 * t146;
  t396 = t156 * t382;
  tvrho1 = t150 + t157 + t9 * (t354 - t358 + t368 + t386 + t395 + t396);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t399 = t2 * t35;
  t400 = t399 * t45;
  t401 = t400 * t148;
  t402 = 0.5e1 / 0.72e2 * t401;
  t403 = t194 * t35;
  t405 = t190 * t193 * t403;
  t406 = 0.25e2 / 0.324e3 * t405;
  t407 = t39 * t50;
  t408 = t54 * t58;
  t409 = t63 * t146;
  t410 = t408 * t409;
  t411 = t407 * t410;
  t412 = 0.5e1 / 0.72e2 * t411;
  t414 = t399 * t40 * t153;
  t416 = params->c * t35;
  t418 = t324 * t325 * t416;
  t420 = 0.5e1 / 0.72e2 * t414 - 0.25e2 / 0.324e3 * t418;
  t421 = t420 * t146;
  tvsigma0 = t9 * (-t402 + t406 - t412 + t421);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t423 = 0.5e1 / 0.36e2 * t401;
  t424 = 0.25e2 / 0.162e3 * t405;
  t425 = 0.5e1 / 0.36e2 * t411;
  t428 = 0.5e1 / 0.36e2 * t414 - 0.25e2 / 0.162e3 * t418;
  t429 = t428 * t146;
  tvsigma1 = t9 * (-t423 + t424 - t425 + t429);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t431 = t2 * t6;
  t432 = t16 * t40;
  t433 = t431 * t432;
  t434 = t54 * t66;
  t435 = t434 * t146;
  t436 = t152 * t435;
  t438 = 0.5e1 / 0.9e1 * t433 * t436;
  t439 = t193 * t146;
  t440 = params->c * t6;
  t441 = t440 * t16;
  t442 = t439 * t441;
  t444 = 0.5e2 / 0.81e2 * t190 * t442;
  t445 = t59 * t206;
  t446 = t62 * t6;
  t447 = t16 * t146;
  t448 = t446 * t447;
  t449 = t445 * t448;
  t451 = 0.5e1 / 0.72e2 * t154 * t449;
  t452 = t431 * t16;
  t453 = t45 * t55;
  t456 = t325 * t441;
  t459 = -0.5e1 / 0.9e1 * t452 * t453 + 0.5e2 / 0.81e2 * t324 * t456;
  t460 = t459 * t146;
  tvtau0 = t9 * (t438 - t444 + t451 + t460);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t462 = t2 * t21;
  t463 = t27 * t40;
  t464 = t462 * t463;
  t466 = 0.5e1 / 0.9e1 * t464 * t436;
  t467 = params->c * t21;
  t468 = t467 * t27;
  t471 = 0.5e2 / 0.81e2 * t190 * t439 * t468;
  t472 = t62 * t21;
  t473 = t27 * t146;
  t474 = t472 * t473;
  t475 = t445 * t474;
  t477 = 0.5e1 / 0.72e2 * t154 * t475;
  t478 = t462 * t27;
  t479 = t478 * t453;
  t484 = -0.5e1 / 0.9e1 * t479 + 0.5e2 / 0.81e2 * t324 * t325 * t468;
  t485 = t484 * t146;
  tvtau1 = t9 * (t466 - t471 + t477 + t485);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t493 = t158 * rho[0];
  t495 = 0.1e1 / t4 / t493;
  t496 = tau[0] * t495;
  t498 = 0.4e2 / 0.9e1 * t496 * t16;
  t500 = 0.5e2 / 0.9e1 * t161 * t168;
  t501 = 0.1e1 / t14;
  t502 = t167 * t167;
  t503 = t501 * t502;
  t505 = 0.1e2 / 0.9e1 * t7 * t503;
  t506 = 0.1e1 / t175;
  t507 = t8 * t506;
  t508 = -t164 + t507;
  t509 = t15 * t508;
  t511 = 0.5e1 / 0.3e1 * t7 * t509;
  t512 = 0.1e1 / t25;
  t513 = t171 * t171;
  t514 = t512 * t513;
  t516 = 0.1e2 / 0.9e1 * t22 * t514;
  t517 = -t508;
  t518 = t26 * t517;
  t520 = 0.5e1 / 0.3e1 * t22 * t518;
  t521 = 0.11e2 / 0.9e1 * t59;
  t522 = t498 - t500 + t505 + t511 + t516 + t520 - t521;
  t523 = t2 * t522;
  t524 = t523 * t45;
  t525 = t524 * t148;
  t526 = 0.5e1 / 0.9e1 * t525;
  t527 = t180 * t180;
  t528 = t2 * t527;
  t529 = t528 * t188;
  t530 = t147 * params->c;
  t531 = t325 * t530;
  t532 = t529 * t531;
  t533 = 0.1e3 / 0.81e2 * t532;
  t534 = t182 * t218;
  t535 = 0.1e2 / 0.9e1 * t534;
  t536 = t182 * t318;
  t537 = 0.1e2 / 0.9e1 * t536;
  t538 = t41 * t41;
  t539 = 0.1e1 / t538;
  t541 = 0.1e1 / t191 / t53;
  t542 = t539 * t541;
  t543 = t39 * t542;
  t544 = params->c * params->c;
  t545 = t544 * t527;
  t546 = t147 * t545;
  t547 = t543 * t546;
  t548 = 0.2e4 / 0.243e3 * t547;
  t549 = t192 * t216;
  t550 = t549 * t195;
  t551 = t190 * t550;
  t552 = 0.1e3 / 0.81e2 * t551;
  t553 = t316 * params->c;
  t554 = t553 * t180;
  t555 = t193 * t554;
  t556 = t190 * t555;
  t557 = 0.1e3 / 0.81e2 * t556;
  t558 = t194 * t522;
  t559 = t193 * t558;
  t560 = t190 * t559;
  t561 = 0.5e2 / 0.81e2 * t560;
  t562 = t56 * t31;
  t564 = 0.1e1 / t33 / t562;
  t565 = t30 * t564;
  t567 = 0.119e3 / 0.36e2 * t565 * t63;
  t568 = t202 * t210;
  t571 = 0.7e1 / 0.3e1 * t202 * t213;
  t573 = 0.1e1 / t205 / t60;
  t574 = t573 * t62;
  t575 = t209 * t209;
  t576 = t574 * t575;
  t579 = t206 * t8;
  t580 = t579 * t209;
  t581 = t59 * t580;
  t583 = t498 - t500 + t505 + t511 + t516 + t520;
  t584 = t207 * t583;
  t588 = t59 * t61 / 0.4e1;
  t589 = -t567 - 0.7e1 / 0.6e1 * t568 + t571 - t59 * t576 / 0.4e1 + t581 / 0.2e1 + t59 * t584 / 0.8e1 - t588;
  t590 = t589 * t146;
  t591 = t55 * t590;
  t592 = t46 * t591;
  t593 = 0.5e1 / 0.9e1 * t592;
  t594 = t216 * t316;
  t595 = t55 * t594;
  t596 = t46 * t595;
  t597 = 0.1e2 / 0.9e1 * t596;
  t598 = t289 * t289;
  t599 = 0.1e1 / t598;
  t600 = t296 * t296;
  t601 = t599 * t600;
  t602 = t137 * t137;
  t603 = 0.1e1 / t602;
  t604 = t601 * t603;
  t606 = 0.17315859105681463759e2 * t311 * t604;
  t607 = t268 * t129;
  t608 = t607 * t313;
  t612 = 0.1e1 / t78 / t75 * t83;
  t613 = t84 * t71;
  t614 = t613 * t35;
  t615 = t612 * t614;
  t618 = 0.1e1 / t32 / t31;
  t619 = t232 * t618;
  t620 = t231 * t619;
  t622 = t72 * t618;
  t623 = t70 * t622;
  t625 = 0.1e1/sqrt(t75);
  t626 = t625 * t83;
  t627 = t626 * t614;
  t629 = t239 * t619;
  t632 = t85 * t71 * t35;
  t634 = -0.57538888888888888889e0 * t615 + 0.11507777777777777778e1 * t620 + 0.40256666666666666667e0 * t623 + 0.366775e-1 * t627 + 0.73355e-1 * t629 + 0.137975e0 * t632;
  t636 = t290 * t634 * t297;
  t638 = 0.5848223622634646207e0 * t311 * t636;
  t639 = t103 * t103;
  t640 = 0.1e1 / t639;
  t641 = t166 * t166;
  t644 = 0.2e1 * t508;
  t648 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t640 * t641 + 0.4e1 / 0.3e1 * t103 * t644);
  t649 = t107 * t107;
  t650 = 0.1e1 / t649;
  t651 = t263 * t263;
  t654 = -t644;
  t658 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t650 * t651 + 0.4e1 / 0.3e1 * t107 * t654);
  t660 = (t648 + t658) * t113;
  t669 = -0.42198333333333333333e0 * t615 + 0.84396666666666666666e0 * t620 + 0.39862222222222222223e0 * t623 + 0.68258333333333333333e-1 * t627 + 0.13651666666666666667e0 * t629 + 0.13692777777777777778e0 * t632;
  t670 = t669 * t248;
  t672 = 0.1e1 * t229 * t670;
  t673 = t227 * t227;
  t674 = 0.1e1 / t673;
  t675 = t77 * t674;
  t676 = t247 * t247;
  t677 = t93 * t93;
  t678 = 0.1e1 / t677;
  t679 = t676 * t678;
  t681 = 0.16081979498692535067e2 * t675 * t679;
  t685 = t70 * t72;
  t686 = t222 * t275;
  t690 = t274 * t121;
  t691 = 0.1e1 / t690;
  t692 = t116 * t691;
  t693 = t281 * t281;
  t694 = t693 * t282;
  t703 = -0.78438333333333333333e0 * t615 + 0.15687666666666666667e1 * t620 + 0.68863333333333333333e0 * t623 + 0.14025833333333333333e0 * t627 + 0.28051666666666666667e0 * t629 + 0.17365833333333333333e0 * t632;
  t704 = t703 * t282;
  t707 = t274 * t274;
  t708 = 0.1e1 / t707;
  t709 = t116 * t708;
  t710 = t124 * t124;
  t711 = 0.1e1 / t710;
  t712 = t693 * t711;
  t717 = 0.14764627977777777777e-2 * t70 * t622 * t94;
  t718 = t222 * t228;
  t721 = 0.35616666666666666666e-1 * t685 * t718 * t249;
  t722 = t227 * t90;
  t723 = 0.1e1 / t722;
  t724 = t77 * t723;
  t725 = t676 * t248;
  t727 = 0.2e1 * t724 * t725;
  t731 = t222 * t290;
  t735 = t289 * t134;
  t736 = 0.1e1 / t735;
  t737 = t129 * t736;
  t738 = t600 * t297;
  t741 = t634 * t297;
  t744 = t129 * t599;
  t745 = t600 * t603;
  t748 = -0.70983522622222222221e-3 * t70 * t622 * t125 - 0.34246666666666666666e-1 * t685 * t686 * t283 - 0.2e1 * t692 * t694 + 0.1e1 * t276 * t704 + 0.32163958997385070134e2 * t709 * t712 + t717 + t721 + t727 - t672 - t681 - 0.24415263074675393405e-3 * t70 * t622 * t138 - 0.10843581300301739842e-1 * t685 * t731 * t298 - 0.11696447245269292414e1 * t737 * t738 + 0.5848223622634646207e0 * t291 * t741 + 0.17315859105681463759e2 * t744 * t745;
  t749 = t114 * t748;
  t750 = t99 * t749;
  t751 = t660 * t141;
  t753 = t268 * t301;
  t754 = t99 * t753;
  t756 = t257 * t269;
  t759 = 0.8e1 * t257 * t302;
  t760 = -t606 - 0.11696447245269292414e1 * t608 - t638 + 0.19751673498613801407e-1 * t660 * t139 + t672 + t681 + t750 + t99 * t751 + 0.2e1 * t754 - 0.8e1 * t756 - t759;
  t761 = t253 * t269;
  t764 = 0.8e1 * t253 * t302;
  t766 = t232 * t618 * t138;
  t768 = 0.24415263074675393405e-3 * t306 * t766;
  t769 = 0.1e1 / t562;
  t770 = t97 * t769;
  t772 = 0.2e2 * t770 * t142;
  t773 = t62 * t98;
  t775 = 0.12e2 * t773 * t142;
  t776 = t252 * t256;
  t778 = 0.32e2 * t776 * t142;
  t779 = t114 * t70;
  t780 = t223 * t313;
  t782 = 0.10843581300301739842e-1 * t779 * t780;
  t783 = t268 * t67;
  t784 = t783 * t308;
  t787 = t736 * t600 * t297;
  t789 = 0.11696447245269292414e1 * t311 * t787;
  t790 = 0.8e1 * t761 + t764 - t727 + t768 + t772 + t775 - t778 - t717 + t782 - 0.36622894612013090108e-3 * t784 + t789 - t721;
  t791 = t760 + t790;
  t792 = t66 * t791;
  t793 = t55 * t792;
  t794 = t46 * t793;
  t795 = 0.5e1 / 0.9e1 * t794;
  t796 = t523 * t40;
  t797 = t796 * t153;
  t799 = t528 * t185;
  t800 = t187 * t47;
  t801 = t192 * params->c;
  t802 = t800 * t801;
  t805 = t39 * t539;
  t806 = t541 * t544;
  t807 = t806 * t527;
  t810 = params->c * t522;
  t811 = t325 * t810;
  t814 = -0.5e1 / 0.9e1 * t797 + 0.1e3 / 0.81e2 * t799 * t802 - 0.2e4 / 0.243e3 * t805 * t807 + 0.5e2 / 0.81e2 * t324 * t811;
  t815 = t814 * t146;
  t816 = t330 * t316;
  t817 = 0.2e1 * t816;
  t818 = t156 * t791;
  t819 = t526 - t533 + t535 + t537 + t548 - t552 - t557 - t561 + t593 + t597 + t795 + t815 + t817 + t818;
  tv2rho20 = 0.1e2 / 0.9e1 * t183 - 0.1e3 / 0.81e2 * t197 + 0.1e2 / 0.9e1 * t219 + 0.1e2 / 0.9e1 * t319 + 0.2e1 * t331 + 0.2e1 * t332 + t9 * t819;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t822 = 0.25e2 / 0.9e1 * t161 * t337;
  t823 = t501 * t336;
  t824 = t823 * t167;
  t826 = 0.1e2 / 0.9e1 * t7 * t824;
  t827 = t15 * t8;
  t828 = t827 * t506;
  t830 = 0.5e1 / 0.3e1 * t7 * t828;
  t832 = 0.25e2 / 0.9e1 * t343 * t172;
  t833 = t512 * t346;
  t834 = t833 * t171;
  t836 = 0.1e2 / 0.9e1 * t22 * t834;
  t837 = t26 * t8;
  t838 = t837 * t506;
  t840 = 0.5e1 / 0.3e1 * t22 * t838;
  t841 = -t822 + t826 + t830 - t832 + t836 - t840 - t521;
  t842 = t2 * t841;
  t843 = t842 * t45;
  t844 = t843 * t148;
  t846 = t351 * t189;
  t847 = t846 * t196;
  t849 = t352 * t218;
  t851 = t352 * t318;
  t853 = t544 * t350;
  t854 = t853 * t180;
  t855 = t147 * t854;
  t856 = t543 * t855;
  t858 = t549 * t355;
  t859 = t190 * t858;
  t861 = t553 * t350;
  t862 = t193 * t861;
  t863 = t190 * t862;
  t865 = t194 * t841;
  t866 = t193 * t865;
  t867 = t190 * t866;
  t869 = t182 * t366;
  t871 = t192 * t364;
  t872 = t871 * t195;
  t873 = t190 * t872;
  t876 = t202 * t361;
  t878 = t59 * t573;
  t879 = t62 * t360;
  t880 = t879 * t209;
  t883 = t579 * t360;
  t884 = t59 * t883;
  t886 = -t822 + t826 + t830 - t832 + t836 - t840;
  t887 = t207 * t886;
  t891 = -t567 - 0.7e1 / 0.12e2 * t568 - 0.7e1 / 0.12e2 * t876 - t878 * t880 / 0.4e1 + t884 / 0.4e1 + t59 * t887 / 0.8e1 - t581 / 0.4e1 + t588;
  t892 = t891 * t146;
  t893 = t55 * t892;
  t894 = t46 * t893;
  t896 = t364 * t316;
  t897 = t55 * t896;
  t898 = t46 * t897;
  t900 = t182 * t384;
  t902 = t382 * params->c;
  t903 = t902 * t180;
  t904 = t193 * t903;
  t905 = t190 * t904;
  t907 = t216 * t382;
  t908 = t55 * t907;
  t909 = t46 * t908;
  t911 = t257 * t378;
  t913 = t253 * t378;
  t915 = t640 * t335;
  t918 = t103 * t8;
  t922 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t915 * t166 + 0.8e1 / 0.3e1 * t918 * t506);
  t923 = t650 * t372;
  t926 = t107 * t8;
  t930 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t923 * t263 - 0.8e1 / 0.3e1 * t926 * t506);
  t932 = (t922 + t930) * t113;
  t933 = t932 * t141;
  t935 = t377 * t301;
  t936 = t99 * t935;
  t937 = t377 * t67;
  t938 = t937 * t308;
  t941 = t789 - 0.4e1 * t911 + 0.4e1 * t913 + t99 * t933 + t936 + t782 - 0.18311447306006545054e-3 * t938 - t721 + t768 - 0.18311447306006545054e-3 * t784 + t772 - t775 - t759;
  t945 = t377 * t129;
  t946 = t945 * t313;
  t950 = -0.4e1 * t761 + t754 - 0.4e1 * t756 - t727 - t606 - 0.5848223622634646207e0 * t608 - t638 - t717 + t750 + t672 + t681 - 0.5848223622634646207e0 * t946 + 0.19751673498613801407e-1 * t932 * t139;
  t951 = t941 + t950;
  t952 = t66 * t951;
  t953 = t55 * t952;
  t954 = t46 * t953;
  t956 = t842 * t40;
  t957 = t956 * t153;
  t959 = t351 * t188;
  t962 = t350 * t180;
  t963 = t806 * t962;
  t966 = params->c * t841;
  t967 = t325 * t966;
  t970 = -0.5e1 / 0.9e1 * t957 + 0.1e3 / 0.81e2 * t959 * t327 - 0.2e4 / 0.243e3 * t805 * t963 + 0.5e2 / 0.81e2 * t324 * t967;
  t971 = t970 * t146;
  t972 = t394 * t316;
  t973 = t330 * t382;
  t974 = t156 * t951;
  t975 = 0.5e1 / 0.9e1 * t844 - 0.1e3 / 0.81e2 * t847 + 0.5e1 / 0.9e1 * t849 + 0.5e1 / 0.9e1 * t851 + 0.2e4 / 0.243e3 * t856 - 0.5e2 / 0.81e2 * t859 - 0.5e2 / 0.81e2 * t863 - 0.5e2 / 0.81e2 * t867 + 0.5e1 / 0.9e1 * t869 - 0.5e2 / 0.81e2 * t873 + 0.5e1 / 0.9e1 * t894 + 0.5e1 / 0.9e1 * t898 + 0.5e1 / 0.9e1 * t900 - 0.5e2 / 0.81e2 * t905 + 0.5e1 / 0.9e1 * t909 + 0.5e1 / 0.9e1 * t954 + t971 + t972 + t973 + t974;
  tv2rho21 = t9 * t975 + t184 - t198 + t220 + t320 + t331 + t332 + t354 - t358 + t368 + t386 + t395 + t396;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t983 = t336 * t336;
  t984 = t501 * t983;
  t986 = 0.1e2 / 0.9e1 * t7 * t984;
  t987 = t164 + t507;
  t988 = t15 * t987;
  t990 = 0.5e1 / 0.3e1 * t7 * t988;
  t991 = t340 * rho[1];
  t993 = 0.1e1 / t19 / t991;
  t994 = tau[1] * t993;
  t996 = 0.4e2 / 0.9e1 * t994 * t27;
  t998 = 0.5e2 / 0.9e1 * t343 * t347;
  t999 = t346 * t346;
  t1000 = t512 * t999;
  t1002 = 0.1e2 / 0.9e1 * t22 * t1000;
  t1003 = -t987;
  t1004 = t26 * t1003;
  t1006 = 0.5e1 / 0.3e1 * t22 * t1004;
  t1007 = t986 + t990 + t996 - t998 + t1002 + t1006 - t521;
  t1008 = t2 * t1007;
  t1009 = t1008 * t45;
  t1010 = t1009 * t148;
  t1011 = 0.5e1 / 0.9e1 * t1010;
  t1012 = t350 * t350;
  t1013 = t2 * t1012;
  t1014 = t1013 * t188;
  t1015 = t1014 * t531;
  t1016 = 0.1e3 / 0.81e2 * t1015;
  t1017 = t352 * t366;
  t1018 = 0.1e2 / 0.9e1 * t1017;
  t1019 = t352 * t384;
  t1020 = 0.1e2 / 0.9e1 * t1019;
  t1021 = t544 * t1012;
  t1022 = t147 * t1021;
  t1023 = t543 * t1022;
  t1024 = 0.2e4 / 0.243e3 * t1023;
  t1025 = t871 * t355;
  t1026 = t190 * t1025;
  t1027 = 0.1e3 / 0.81e2 * t1026;
  t1028 = t902 * t350;
  t1029 = t193 * t1028;
  t1030 = t190 * t1029;
  t1031 = 0.1e3 / 0.81e2 * t1030;
  t1032 = t194 * t1007;
  t1033 = t193 * t1032;
  t1034 = t190 * t1033;
  t1035 = 0.5e2 / 0.81e2 * t1034;
  t1037 = t360 * t360;
  t1038 = t574 * t1037;
  t1042 = t986 + t990 + t996 - t998 + t1002 + t1006;
  t1043 = t207 * t1042;
  t1046 = -t567 - 0.7e1 / 0.6e1 * t876 - t571 - t59 * t1038 / 0.4e1 - t884 / 0.2e1 + t59 * t1043 / 0.8e1 - t588;
  t1047 = t1046 * t146;
  t1048 = t55 * t1047;
  t1049 = t46 * t1048;
  t1050 = 0.5e1 / 0.9e1 * t1049;
  t1051 = t364 * t382;
  t1052 = t55 * t1051;
  t1053 = t46 * t1052;
  t1054 = 0.1e2 / 0.9e1 * t1053;
  t1055 = t335 * t335;
  t1058 = 0.2e1 * t987;
  t1062 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t640 * t1055 + 0.4e1 / 0.3e1 * t103 * t1058);
  t1063 = t372 * t372;
  t1066 = -t1058;
  t1070 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t650 * t1063 + 0.4e1 / 0.3e1 * t107 * t1066);
  t1072 = (t1062 + t1070) * t113;
  t1073 = t1072 * t141;
  t1081 = t99 * t1073 + 0.19751673498613801407e-1 * t1072 * t139 - 0.11696447245269292414e1 * t946 - 0.8e1 * t911 - 0.8e1 * t913 + 0.2e1 * t936 - t606 - t638 + t672 + t681 + t750;
  t1083 = -t759 - t764 - t727 + t768 + t772 + t775 + t778 - t717 + t782 - 0.36622894612013090108e-3 * t938 + t789 - t721;
  t1084 = t1081 + t1083;
  t1085 = t66 * t1084;
  t1086 = t55 * t1085;
  t1087 = t46 * t1086;
  t1088 = 0.5e1 / 0.9e1 * t1087;
  t1089 = t1008 * t40;
  t1090 = t1089 * t153;
  t1092 = t1013 * t185;
  t1095 = t806 * t1012;
  t1098 = params->c * t1007;
  t1099 = t325 * t1098;
  t1102 = -0.5e1 / 0.9e1 * t1090 + 0.1e3 / 0.81e2 * t1092 * t802 - 0.2e4 / 0.243e3 * t805 * t1095 + 0.5e2 / 0.81e2 * t324 * t1099;
  t1103 = t1102 * t146;
  t1104 = t394 * t382;
  t1105 = 0.2e1 * t1104;
  t1106 = t156 * t1084;
  t1107 = t1011 - t1016 + t1018 + t1020 + t1024 - t1027 - t1031 - t1035 + t1050 + t1054 + t1088 + t1103 + t1105 + t1106;
  tv2rho22 = 0.1e2 / 0.9e1 * t353 - 0.1e3 / 0.81e2 * t357 + 0.1e2 / 0.9e1 * t367 + 0.1e2 / 0.9e1 * t385 + 0.2e1 * t395 + 0.2e1 * t396 + t9 * t1107;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t1109 = t2 * t177;
  t1110 = t1109 * t45;
  t1111 = t1110 * t148;
  t1112 = 0.5e1 / 0.27e2 * t1111;
  t1113 = t399 * t189;
  t1114 = t1113 * t196;
  t1115 = 0.25e2 / 0.162e3 * t1114;
  t1116 = t400 * t218;
  t1117 = 0.5e1 / 0.72e2 * t1116;
  t1118 = t400 * t318;
  t1119 = 0.5e1 / 0.72e2 * t1118;
  t1120 = t544 * t35;
  t1121 = t1120 * t180;
  t1122 = t147 * t1121;
  t1123 = t543 * t1122;
  t1124 = 0.25e3 / 0.243e3 * t1123;
  t1126 = t190 * t549 * t403;
  t1127 = 0.25e2 / 0.324e3 * t1126;
  t1128 = t553 * t35;
  t1130 = t190 * t193 * t1128;
  t1131 = 0.25e2 / 0.324e3 * t1130;
  t1132 = t194 * t177;
  t1134 = t190 * t193 * t1132;
  t1135 = 0.5e2 / 0.243e3 * t1134;
  t1136 = t181 * t50;
  t1137 = t1136 * t410;
  t1138 = 0.5e1 / 0.72e2 * t1137;
  t1139 = t39 * t185;
  t1140 = t800 * t192;
  t1141 = t1139 * t1140;
  t1142 = t58 * t61;
  t1143 = t1142 * t62;
  t1144 = t1143 * t195;
  t1145 = t1141 * t1144;
  t1146 = 0.25e2 / 0.324e3 * t1145;
  t1147 = t54 * t201;
  t1148 = t1147 * t409;
  t1149 = t407 * t1148;
  t1150 = 0.35e2 / 0.108e3 * t1149;
  t1151 = t408 * t206;
  t1152 = t62 * t146;
  t1153 = t1152 * t209;
  t1154 = t1151 * t1153;
  t1155 = t407 * t1154;
  t1156 = 0.5e1 / 0.72e2 * t1155;
  t1157 = t213 * t146;
  t1158 = t408 * t1157;
  t1159 = t407 * t1158;
  t1160 = 0.5e1 / 0.36e2 * t1159;
  t1161 = t63 * t316;
  t1162 = t408 * t1161;
  t1163 = t407 * t1162;
  t1164 = 0.5e1 / 0.72e2 * t1163;
  t1166 = t1109 * t40 * t153;
  t1167 = 0.5e1 / 0.27e2 * t1166;
  t1168 = t399 * t188;
  t1169 = t1168 * t327;
  t1171 = t35 * t180;
  t1172 = t806 * t1171;
  t1173 = t805 * t1172;
  t1175 = params->c * t177;
  t1177 = t324 * t325 * t1175;
  t1178 = 0.5e2 / 0.243e3 * t1177;
  t1179 = -t1167 - 0.25e2 / 0.162e3 * t1169 + 0.25e3 / 0.243e3 * t1173 + t1178;
  t1180 = t1179 * t146;
  t1181 = t420 * t316;
  t1182 = t1112 + t1115 - t1117 - t1119 - t1124 + t1127 + t1131 - t1135 - t1138 + t1146 + t1150 + t1156 - t1160 - t1164 + t1180 + t1181;
  tv2rhosigma0 = t9 * t1182 - t402 + t406 - t412 + t421;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t1184 = 0.1e2 / 0.27e2 * t1111;
  t1185 = 0.25e2 / 0.81e2 * t1114;
  t1186 = 0.5e1 / 0.36e2 * t1116;
  t1187 = 0.5e1 / 0.36e2 * t1118;
  t1188 = 0.5e3 / 0.243e3 * t1123;
  t1189 = 0.25e2 / 0.162e3 * t1126;
  t1190 = 0.25e2 / 0.162e3 * t1130;
  t1191 = 0.1e3 / 0.243e3 * t1134;
  t1192 = 0.5e1 / 0.36e2 * t1137;
  t1193 = 0.25e2 / 0.162e3 * t1145;
  t1194 = 0.35e2 / 0.54e2 * t1149;
  t1195 = 0.5e1 / 0.36e2 * t1155;
  t1196 = 0.5e1 / 0.18e2 * t1159;
  t1197 = 0.5e1 / 0.36e2 * t1163;
  t1198 = 0.1e2 / 0.27e2 * t1166;
  t1201 = 0.1e3 / 0.243e3 * t1177;
  t1202 = -t1198 - 0.25e2 / 0.81e2 * t1169 + 0.5e3 / 0.243e3 * t1173 + t1201;
  t1203 = t1202 * t146;
  t1204 = t428 * t316;
  t1205 = t1184 + t1185 - t1186 - t1187 - t1188 + t1189 + t1190 - t1191 - t1192 + t1193 + t1194 + t1195 - t1196 - t1197 + t1203 + t1204;
  tv2rhosigma1 = t9 * t1205 - t423 + t424 - t425 + t429;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t1207 = t1113 * t356;
  t1208 = 0.25e2 / 0.162e3 * t1207;
  t1209 = t400 * t366;
  t1210 = 0.5e1 / 0.72e2 * t1209;
  t1211 = t400 * t384;
  t1212 = 0.5e1 / 0.72e2 * t1211;
  t1213 = t1120 * t350;
  t1214 = t147 * t1213;
  t1215 = t543 * t1214;
  t1216 = 0.25e3 / 0.243e3 * t1215;
  t1218 = t190 * t871 * t403;
  t1219 = 0.25e2 / 0.324e3 * t1218;
  t1220 = t902 * t35;
  t1222 = t190 * t193 * t1220;
  t1223 = 0.25e2 / 0.324e3 * t1222;
  t1224 = t351 * t50;
  t1225 = t1224 * t410;
  t1226 = 0.5e1 / 0.72e2 * t1225;
  t1227 = t1143 * t355;
  t1228 = t1141 * t1227;
  t1229 = 0.25e2 / 0.324e3 * t1228;
  t1230 = t1152 * t360;
  t1231 = t1151 * t1230;
  t1232 = t407 * t1231;
  t1233 = 0.5e1 / 0.72e2 * t1232;
  t1234 = t63 * t382;
  t1235 = t408 * t1234;
  t1236 = t407 * t1235;
  t1237 = 0.5e1 / 0.72e2 * t1236;
  t1238 = t1168 * t391;
  t1240 = t35 * t350;
  t1241 = t806 * t1240;
  t1242 = t805 * t1241;
  t1244 = -t1167 - 0.25e2 / 0.162e3 * t1238 + 0.25e3 / 0.243e3 * t1242 + t1178;
  t1245 = t1244 * t146;
  t1246 = t420 * t382;
  t1247 = t1112 + t1208 - t1210 - t1212 - t1216 + t1219 + t1223 - t1135 - t1226 + t1229 + t1150 + t1233 + t1160 - t1237 + t1245 + t1246;
  tv2rhosigma3 = t9 * t1247 - t402 + t406 - t412 + t421;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  t1249 = 0.25e2 / 0.81e2 * t1207;
  t1250 = 0.5e1 / 0.36e2 * t1209;
  t1251 = 0.5e1 / 0.36e2 * t1211;
  t1252 = 0.5e3 / 0.243e3 * t1215;
  t1253 = 0.25e2 / 0.162e3 * t1218;
  t1254 = 0.25e2 / 0.162e3 * t1222;
  t1255 = 0.5e1 / 0.36e2 * t1225;
  t1256 = 0.25e2 / 0.162e3 * t1228;
  t1257 = 0.5e1 / 0.36e2 * t1232;
  t1258 = 0.5e1 / 0.36e2 * t1236;
  t1261 = -t1198 - 0.25e2 / 0.81e2 * t1238 + 0.5e3 / 0.243e3 * t1242 + t1201;
  t1262 = t1261 * t146;
  t1263 = t428 * t382;
  t1264 = t1184 + t1249 - t1250 - t1251 - t1252 + t1253 + t1254 - t1191 - t1255 + t1256 + t1194 + t1257 + t1196 - t1258 + t1262 + t1263;
  tv2rhosigma4 = t9 * t1264 - t423 + t424 - t425 + t429;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t1266 = t2 * t160;
  t1267 = t1266 * t432;
  t1268 = t1267 * t436;
  t1269 = 0.25e2 / 0.27e2 * t1268;
  t1270 = t15 * t40;
  t1271 = t1270 * t44;
  t1272 = t431 * t1271;
  t1274 = t55 * t147 * t167;
  t1275 = t1272 * t1274;
  t1276 = 0.25e2 / 0.27e2 * t1275;
  t1277 = t16 * t185;
  t1278 = t1277 * t187;
  t1279 = t431 * t1278;
  t1280 = t325 * t66;
  t1281 = t1280 * t195;
  t1282 = t1279 * t1281;
  t1283 = 0.1e3 / 0.81e2 * t1282;
  t1284 = t54 * t216;
  t1286 = t152 * t1284 * t146;
  t1287 = t433 * t1286;
  t1288 = 0.5e1 / 0.9e1 * t1287;
  t1290 = t152 * t434 * t316;
  t1291 = t433 * t1290;
  t1292 = 0.5e1 / 0.9e1 * t1291;
  t1293 = t542 * t66;
  t1294 = t39 * t1293;
  t1295 = t146 * t544;
  t1296 = t6 * t16;
  t1297 = t1296 * t180;
  t1298 = t1295 * t1297;
  t1299 = t1294 * t1298;
  t1300 = 0.2e4 / 0.243e3 * t1299;
  t1301 = t549 * t146;
  t1302 = t1301 * t441;
  t1303 = t190 * t1302;
  t1304 = 0.5e2 / 0.81e2 * t1303;
  t1305 = t193 * t316;
  t1306 = t1305 * t441;
  t1307 = t190 * t1306;
  t1308 = 0.5e2 / 0.81e2 * t1307;
  t1309 = params->c * t160;
  t1310 = t1309 * t16;
  t1311 = t439 * t1310;
  t1312 = t190 * t1311;
  t1313 = 0.25e3 / 0.243e3 * t1312;
  t1314 = t6 * t15;
  t1315 = t1314 * t167;
  t1317 = t1141 * t530 * t1315;
  t1318 = 0.25e3 / 0.243e3 * t1317;
  t1319 = t322 * t449;
  t1320 = 0.5e1 / 0.72e2 * t1319;
  t1321 = t192 * t30;
  t1322 = t800 * t1321;
  t1323 = t1139 * t1322;
  t1324 = t58 * t206;
  t1325 = t1324 * t446;
  t1326 = t447 * t326;
  t1327 = t1325 * t1326;
  t1328 = t1323 * t1327;
  t1329 = 0.25e2 / 0.324e3 * t1328;
  t1330 = t202 * t206;
  t1331 = t1330 * t448;
  t1332 = t154 * t1331;
  t1333 = 0.35e2 / 0.108e3 * t1332;
  t1334 = t54 * t30;
  t1335 = t152 * t1334;
  t1336 = t151 * t1335;
  t1337 = t58 * t573;
  t1338 = t1337 * t62;
  t1339 = t146 * t209;
  t1340 = t1296 * t1339;
  t1341 = t1338 * t1340;
  t1342 = t1336 * t1341;
  t1343 = 0.5e1 / 0.36e2 * t1342;
  t1344 = t8 * t6;
  t1345 = t1344 * t447;
  t1346 = t445 * t1345;
  t1347 = t154 * t1346;
  t1348 = 0.5e1 / 0.36e2 * t1347;
  t1349 = t62 * t160;
  t1350 = t1349 * t447;
  t1351 = t445 * t1350;
  t1352 = t154 * t1351;
  t1353 = 0.25e2 / 0.216e3 * t1352;
  t1354 = t1324 * t62;
  t1355 = t146 * t167;
  t1356 = t1314 * t1355;
  t1357 = t1354 * t1356;
  t1358 = t1336 * t1357;
  t1359 = 0.25e2 / 0.216e3 * t1358;
  t1360 = t16 * t316;
  t1361 = t446 * t1360;
  t1362 = t445 * t1361;
  t1363 = t154 * t1362;
  t1364 = 0.5e1 / 0.72e2 * t1363;
  t1365 = t1266 * t16;
  t1368 = t431 * t1270;
  t1369 = t54 * t167;
  t1370 = t152 * t1369;
  t1373 = t431 * t1277;
  t1375 = t800 * t801 * t180;
  t1378 = t544 * t6;
  t1379 = t16 * t180;
  t1380 = t1378 * t1379;
  t1383 = t325 * t1310;
  t1389 = 0.25e2 / 0.27e2 * t1365 * t453 - 0.25e2 / 0.27e2 * t1368 * t1370 + 0.1e3 / 0.81e2 * t1373 * t1375 - 0.2e4 / 0.243e3 * t543 * t1380 - 0.25e3 / 0.243e3 * t324 * t1383 + 0.25e3 / 0.243e3 * t190 * t801 * t1315;
  t1390 = t1389 * t146;
  t1391 = t459 * t316;
  t1392 = -t1269 + t1276 - t1283 + t1288 + t1292 + t1300 - t1304 - t1308 + t1313 - t1318 + t1320 - t1329 - t1333 - t1343 + t1348 - t1353 + t1359 + t1364 + t1390 + t1391;
  tv2rhotau0 = t9 * t1392 + t438 - t444 + t451 + t460;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t1394 = t26 * t40;
  t1395 = t1394 * t44;
  t1396 = t462 * t1395;
  t1398 = t55 * t147 * t171;
  t1399 = t1396 * t1398;
  t1400 = 0.25e2 / 0.27e2 * t1399;
  t1401 = t27 * t185;
  t1402 = t1401 * t187;
  t1403 = t462 * t1402;
  t1404 = t1403 * t1281;
  t1405 = 0.1e3 / 0.81e2 * t1404;
  t1406 = t464 * t1286;
  t1407 = 0.5e1 / 0.9e1 * t1406;
  t1408 = t464 * t1290;
  t1409 = 0.5e1 / 0.9e1 * t1408;
  t1410 = t21 * t27;
  t1411 = t1410 * t180;
  t1412 = t1295 * t1411;
  t1413 = t1294 * t1412;
  t1414 = 0.2e4 / 0.243e3 * t1413;
  t1416 = t190 * t1301 * t468;
  t1417 = 0.5e2 / 0.81e2 * t1416;
  t1419 = t190 * t1305 * t468;
  t1420 = 0.5e2 / 0.81e2 * t1419;
  t1421 = t21 * t26;
  t1422 = t1421 * t171;
  t1424 = t1141 * t530 * t1422;
  t1425 = 0.25e3 / 0.243e3 * t1424;
  t1426 = t322 * t475;
  t1427 = 0.5e1 / 0.72e2 * t1426;
  t1428 = t1324 * t472;
  t1429 = t473 * t326;
  t1430 = t1428 * t1429;
  t1431 = t1323 * t1430;
  t1432 = 0.25e2 / 0.324e3 * t1431;
  t1433 = t1330 * t474;
  t1434 = t154 * t1433;
  t1435 = 0.35e2 / 0.108e3 * t1434;
  t1436 = t1410 * t1339;
  t1437 = t1338 * t1436;
  t1438 = t1336 * t1437;
  t1439 = 0.5e1 / 0.36e2 * t1438;
  t1440 = t8 * t21;
  t1441 = t1440 * t473;
  t1442 = t445 * t1441;
  t1443 = t154 * t1442;
  t1444 = 0.5e1 / 0.36e2 * t1443;
  t1445 = t146 * t171;
  t1446 = t1421 * t1445;
  t1447 = t1354 * t1446;
  t1448 = t1336 * t1447;
  t1449 = 0.25e2 / 0.216e3 * t1448;
  t1450 = t27 * t316;
  t1451 = t472 * t1450;
  t1452 = t445 * t1451;
  t1453 = t154 * t1452;
  t1454 = 0.5e1 / 0.72e2 * t1453;
  t1455 = t462 * t1394;
  t1456 = t54 * t171;
  t1457 = t152 * t1456;
  t1460 = t462 * t1401;
  t1463 = t544 * t21;
  t1464 = t27 * t180;
  t1465 = t1463 * t1464;
  t1471 = -0.25e2 / 0.27e2 * t1455 * t1457 + 0.1e3 / 0.81e2 * t1460 * t1375 - 0.2e4 / 0.243e3 * t543 * t1465 + 0.25e3 / 0.243e3 * t190 * t801 * t1422;
  t1472 = t1471 * t146;
  t1473 = t484 * t316;
  t1474 = t1400 - t1405 + t1407 + t1409 + t1414 - t1417 - t1420 - t1425 + t1427 - t1432 - t1435 - t1439 + t1444 + t1449 + t1454 + t1472 + t1473;
  tv2rhotau1 = t9 * t1474 + t466 - t471 + t477 + t485;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1477 = t55 * t147 * t336;
  t1478 = t1272 * t1477;
  t1479 = 0.25e2 / 0.27e2 * t1478;
  t1480 = t1280 * t355;
  t1481 = t1279 * t1480;
  t1482 = 0.1e3 / 0.81e2 * t1481;
  t1483 = t54 * t364;
  t1485 = t152 * t1483 * t146;
  t1486 = t433 * t1485;
  t1487 = 0.5e1 / 0.9e1 * t1486;
  t1489 = t152 * t434 * t382;
  t1490 = t433 * t1489;
  t1491 = 0.5e1 / 0.9e1 * t1490;
  t1492 = t1296 * t350;
  t1493 = t1295 * t1492;
  t1494 = t1294 * t1493;
  t1495 = 0.2e4 / 0.243e3 * t1494;
  t1496 = t871 * t146;
  t1497 = t1496 * t441;
  t1498 = t190 * t1497;
  t1499 = 0.5e2 / 0.81e2 * t1498;
  t1500 = t193 * t382;
  t1501 = t1500 * t441;
  t1502 = t190 * t1501;
  t1503 = 0.5e2 / 0.81e2 * t1502;
  t1504 = t1314 * t336;
  t1506 = t1141 * t530 * t1504;
  t1507 = 0.25e3 / 0.243e3 * t1506;
  t1508 = t388 * t449;
  t1509 = 0.5e1 / 0.72e2 * t1508;
  t1510 = t447 * t390;
  t1511 = t1325 * t1510;
  t1512 = t1323 * t1511;
  t1513 = 0.25e2 / 0.324e3 * t1512;
  t1514 = t146 * t360;
  t1515 = t1296 * t1514;
  t1516 = t1338 * t1515;
  t1517 = t1336 * t1516;
  t1518 = 0.5e1 / 0.36e2 * t1517;
  t1519 = t146 * t336;
  t1520 = t1314 * t1519;
  t1521 = t1354 * t1520;
  t1522 = t1336 * t1521;
  t1523 = 0.25e2 / 0.216e3 * t1522;
  t1524 = t16 * t382;
  t1525 = t446 * t1524;
  t1526 = t445 * t1525;
  t1527 = t154 * t1526;
  t1528 = 0.5e1 / 0.72e2 * t1527;
  t1529 = t54 * t336;
  t1530 = t152 * t1529;
  t1534 = t800 * t801 * t350;
  t1537 = t16 * t350;
  t1538 = t1378 * t1537;
  t1544 = -0.25e2 / 0.27e2 * t1368 * t1530 + 0.1e3 / 0.81e2 * t1373 * t1534 - 0.2e4 / 0.243e3 * t543 * t1538 + 0.25e3 / 0.243e3 * t190 * t801 * t1504;
  t1545 = t1544 * t146;
  t1546 = t459 * t382;
  t1547 = t1479 - t1482 + t1487 + t1491 + t1495 - t1499 - t1503 - t1507 + t1509 - t1513 - t1333 - t1518 - t1348 + t1523 + t1528 + t1545 + t1546;
  tv2rhotau2 = t9 * t1547 + t438 - t444 + t451 + t460;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1549 = t2 * t342;
  t1550 = t1549 * t463;
  t1551 = t1550 * t436;
  t1552 = 0.25e2 / 0.27e2 * t1551;
  t1554 = t55 * t147 * t346;
  t1555 = t1396 * t1554;
  t1556 = 0.25e2 / 0.27e2 * t1555;
  t1557 = t1403 * t1480;
  t1558 = 0.1e3 / 0.81e2 * t1557;
  t1559 = t464 * t1485;
  t1560 = 0.5e1 / 0.9e1 * t1559;
  t1561 = t464 * t1489;
  t1562 = 0.5e1 / 0.9e1 * t1561;
  t1563 = t1410 * t350;
  t1564 = t1295 * t1563;
  t1565 = t1294 * t1564;
  t1566 = 0.2e4 / 0.243e3 * t1565;
  t1568 = t190 * t1496 * t468;
  t1569 = 0.5e2 / 0.81e2 * t1568;
  t1571 = t190 * t1500 * t468;
  t1572 = 0.5e2 / 0.81e2 * t1571;
  t1573 = params->c * t342;
  t1574 = t1573 * t27;
  t1576 = t190 * t439 * t1574;
  t1577 = 0.25e3 / 0.243e3 * t1576;
  t1578 = t1421 * t346;
  t1580 = t1141 * t530 * t1578;
  t1581 = 0.25e3 / 0.243e3 * t1580;
  t1582 = t388 * t475;
  t1583 = 0.5e1 / 0.72e2 * t1582;
  t1584 = t473 * t390;
  t1585 = t1428 * t1584;
  t1586 = t1323 * t1585;
  t1587 = 0.25e2 / 0.324e3 * t1586;
  t1588 = t1410 * t1514;
  t1589 = t1338 * t1588;
  t1590 = t1336 * t1589;
  t1591 = 0.5e1 / 0.36e2 * t1590;
  t1592 = t62 * t342;
  t1593 = t1592 * t473;
  t1594 = t445 * t1593;
  t1595 = t154 * t1594;
  t1596 = 0.25e2 / 0.216e3 * t1595;
  t1597 = t146 * t346;
  t1598 = t1421 * t1597;
  t1599 = t1354 * t1598;
  t1600 = t1336 * t1599;
  t1601 = 0.25e2 / 0.216e3 * t1600;
  t1602 = t27 * t382;
  t1603 = t472 * t1602;
  t1604 = t445 * t1603;
  t1605 = t154 * t1604;
  t1606 = 0.5e1 / 0.72e2 * t1605;
  t1607 = t1549 * t27;
  t1608 = t1607 * t453;
  t1610 = t54 * t346;
  t1611 = t152 * t1610;
  t1616 = t27 * t350;
  t1617 = t1463 * t1616;
  t1626 = 0.25e2 / 0.27e2 * t1608 - 0.25e2 / 0.27e2 * t1455 * t1611 + 0.1e3 / 0.81e2 * t1460 * t1534 - 0.2e4 / 0.243e3 * t543 * t1617 - 0.25e3 / 0.243e3 * t324 * t325 * t1574 + 0.25e3 / 0.243e3 * t190 * t801 * t1578;
  t1627 = t1626 * t146;
  t1628 = t484 * t382;
  t1629 = -t1552 + t1556 - t1558 + t1560 + t1562 + t1566 - t1569 - t1572 + t1577 - t1581 + t1583 - t1587 - t1435 - t1591 - t1444 - t1596 + t1601 + t1606 + t1627 + t1628;
  tv2rhotau3 = t9 * t1629 + t466 - t471 + t477 + t485;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1632 = 0.1e1 / t32 / t199;
  t1633 = t2 * t1632;
  t1634 = t1633 * t188;
  t1635 = t1634 * t531;
  t1636 = 0.25e2 / 0.1296e4 * t1635;
  t1637 = t56 * t175;
  t1639 = 0.1e1 / t32 / t1637;
  t1640 = t2 * t1639;
  t1641 = t1640 * t45;
  t1642 = t55 * t409;
  t1643 = t1641 * t1642;
  t1644 = 0.5e1 / 0.288e3 * t1643;
  t1645 = t544 * t1632;
  t1647 = t543 * t147 * t1645;
  t1648 = 0.125e3 / 0.972e3 * t1647;
  t1649 = t192 * t1639;
  t1650 = t1649 * t61;
  t1651 = t1152 * params->c;
  t1652 = t1650 * t1651;
  t1653 = t190 * t1652;
  t1654 = 0.25e2 / 0.1296e4 * t1653;
  t1656 = t1633 * t185 * t802;
  t1659 = t805 * t806 * t1632;
  t1661 = 0.25e2 / 0.1296e4 * t1656 - 0.125e3 / 0.972e3 * t1659;
  t1662 = t1661 * t146;
  tv2sigma20 = t9 * (-t1636 + t1644 + t1648 - t1654 + t1662);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t1664 = 0.25e2 / 0.648e3 * t1635;
  t1665 = 0.5e1 / 0.144e3 * t1643;
  t1666 = 0.125e3 / 0.486e3 * t1647;
  t1667 = 0.25e2 / 0.648e3 * t1653;
  t1670 = 0.25e2 / 0.648e3 * t1656 - 0.125e3 / 0.486e3 * t1659;
  t1671 = t1670 * t146;
  tv2sigma21 = t9 * (-t1664 + t1665 + t1666 - t1667 + t1671);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = tv2sigma20;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  t1673 = 0.25e2 / 0.324e3 * t1635;
  t1674 = 0.5e1 / 0.72e2 * t1643;
  t1675 = 0.125e3 / 0.243e3 * t1647;
  t1676 = 0.25e2 / 0.324e3 * t1653;
  t1679 = 0.25e2 / 0.324e3 * t1656 - 0.125e3 / 0.243e3 * t1659;
  t1680 = t1679 * t146;
  tv2sigma23 = t9 * (-t1673 + t1674 + t1675 - t1676 + t1680);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = tv2sigma21;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = tv2sigma22;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1682 = t1280 * t403;
  t1683 = t1279 * t1682;
  t1684 = 0.25e2 / 0.162e3 * t1683;
  t1685 = t432 * t44;
  t1686 = t431 * t1685;
  t1687 = t55 * t58;
  t1688 = t1687 * t409;
  t1689 = t1686 * t1688;
  t1690 = 0.5e1 / 0.72e2 * t1689;
  t1691 = t1296 * t35;
  t1692 = t1295 * t1691;
  t1693 = t1294 * t1692;
  t1694 = 0.25e3 / 0.243e3 * t1693;
  t1695 = t194 * t1296;
  t1696 = t1143 * t1695;
  t1697 = t1141 * t1696;
  t1698 = 0.25e2 / 0.324e3 * t1697;
  t1699 = t1640 * t40;
  t1700 = t1699 * t153;
  t1701 = t30 * t206;
  t1702 = t1701 * t62;
  t1703 = t1296 * t146;
  t1704 = t1702 * t1703;
  t1705 = t1700 * t1704;
  t1706 = 0.5e1 / 0.576e3 * t1705;
  t1707 = t1639 * t206;
  t1708 = t1707 * t62;
  t1709 = t1708 * t1695;
  t1710 = t1323 * t1709;
  t1711 = 0.25e2 / 0.2592e4 * t1710;
  t1712 = t1354 * t1703;
  t1713 = t154 * t1712;
  t1714 = 0.5e1 / 0.72e2 * t1713;
  t1716 = t800 * t801 * t35;
  t1717 = t1373 * t1716;
  t1719 = t16 * t35;
  t1721 = t543 * t1378 * t1719;
  t1723 = -0.25e2 / 0.162e3 * t1717 + 0.25e3 / 0.243e3 * t1721;
  t1724 = t1723 * t146;
  tv2sigmatau0 = t9 * (t1684 - t1690 - t1694 + t1698 - t1706 + t1711 + t1714 + t1724);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t1726 = t1403 * t1682;
  t1727 = 0.25e2 / 0.162e3 * t1726;
  t1728 = t463 * t44;
  t1729 = t462 * t1728;
  t1730 = t1729 * t1688;
  t1731 = 0.5e1 / 0.72e2 * t1730;
  t1732 = t1410 * t35;
  t1733 = t1295 * t1732;
  t1734 = t1294 * t1733;
  t1735 = 0.25e3 / 0.243e3 * t1734;
  t1736 = t194 * t1410;
  t1738 = t1141 * t1143 * t1736;
  t1739 = 0.25e2 / 0.324e3 * t1738;
  t1740 = t1410 * t146;
  t1741 = t1702 * t1740;
  t1742 = t1700 * t1741;
  t1743 = 0.5e1 / 0.576e3 * t1742;
  t1744 = t1708 * t1736;
  t1745 = t1323 * t1744;
  t1746 = 0.25e2 / 0.2592e4 * t1745;
  t1747 = t1354 * t1740;
  t1748 = t154 * t1747;
  t1749 = 0.5e1 / 0.72e2 * t1748;
  t1750 = t1460 * t1716;
  t1752 = t27 * t35;
  t1754 = t543 * t1463 * t1752;
  t1756 = -0.25e2 / 0.162e3 * t1750 + 0.25e3 / 0.243e3 * t1754;
  t1757 = t1756 * t146;
  tv2sigmatau1 = t9 * (t1727 - t1731 - t1735 + t1739 - t1743 + t1746 + t1749 + t1757);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  t1759 = 0.25e2 / 0.81e2 * t1683;
  t1760 = 0.5e1 / 0.36e2 * t1689;
  t1761 = 0.5e3 / 0.243e3 * t1693;
  t1762 = 0.25e2 / 0.162e3 * t1697;
  t1763 = 0.5e1 / 0.288e3 * t1705;
  t1764 = 0.25e2 / 0.1296e4 * t1710;
  t1765 = 0.5e1 / 0.36e2 * t1713;
  t1768 = -0.25e2 / 0.81e2 * t1717 + 0.5e3 / 0.243e3 * t1721;
  t1769 = t1768 * t146;
  tv2sigmatau2 = t9 * (t1759 - t1760 - t1761 + t1762 - t1763 + t1764 + t1765 + t1769);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  t1771 = 0.25e2 / 0.81e2 * t1726;
  t1772 = 0.5e1 / 0.36e2 * t1730;
  t1773 = 0.5e3 / 0.243e3 * t1734;
  t1774 = 0.25e2 / 0.162e3 * t1738;
  t1775 = 0.5e1 / 0.288e3 * t1742;
  t1776 = 0.25e2 / 0.1296e4 * t1745;
  t1777 = 0.5e1 / 0.36e2 * t1748;
  t1780 = -0.25e2 / 0.81e2 * t1750 + 0.5e3 / 0.243e3 * t1754;
  t1781 = t1780 * t146;
  tv2sigmatau3 = t9 * (t1771 - t1772 - t1773 + t1774 - t1775 + t1776 + t1777 + t1781);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = tv2sigmatau0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = tv2sigmatau1;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1784 = 0.1e1 / t3 / t493;
  t1785 = t2 * t1784;
  t1786 = t13 * t13;
  t1788 = t14 * t1786 * t13;
  t1789 = t1788 * t185;
  t1790 = t1789 * t187;
  t1791 = t1785 * t1790;
  t1793 = 0.1e3 / 0.81e2 * t1791 * t531;
  t1794 = t1785 * t1788;
  t1795 = t1794 * t50;
  t1796 = t1334 * t58;
  t1797 = t207 * t146;
  t1798 = t1796 * t1797;
  t1800 = 0.5e1 / 0.36e2 * t1795 * t1798;
  t1801 = t544 * t1784;
  t1802 = t1801 * t1788;
  t1803 = t147 * t1802;
  t1805 = 0.2e4 / 0.243e3 * t543 * t1803;
  t1806 = t1784 * t1788;
  t1807 = t1806 * t194;
  t1808 = t1354 * t1807;
  t1810 = 0.25e2 / 0.162e3 * t1323 * t1808;
  t1811 = t62 * t1784;
  t1812 = t1788 * t146;
  t1813 = t1811 * t1812;
  t1814 = t878 * t1813;
  t1816 = 0.5e1 / 0.36e2 * t154 * t1814;
  t1820 = t806 * t1806;
  t1823 = 0.1e3 / 0.81e2 * t1785 * t1789 * t802 - 0.2e4 / 0.243e3 * t805 * t1820;
  t1824 = t1823 * t146;
  tv2tau20 = t9 * (-t1793 + t1800 + t1805 - t1810 - t1816 + t1824);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t1826 = t478 * t189;
  t1828 = 0.1e3 / 0.81e2 * t1826 * t442;
  t1830 = 0.5e1 / 0.36e2 * t479 * t449;
  t1831 = t1295 * t21;
  t1832 = t27 * t6;
  t1833 = t1832 * t16;
  t1834 = t1831 * t1833;
  t1836 = 0.2e4 / 0.243e3 * t1294 * t1834;
  t1837 = t325 * t59;
  t1838 = t324 * t1837;
  t1839 = t207 * t1296;
  t1840 = t1839 * t1736;
  t1842 = 0.25e2 / 0.162e3 * t1838 * t1840;
  t1843 = t1337 * t472;
  t1844 = t473 * t1296;
  t1845 = t1843 * t1844;
  t1847 = 0.5e1 / 0.36e2 * t1336 * t1845;
  t1853 = 0.1e3 / 0.81e2 * t1403 * t456 - 0.2e4 / 0.243e3 * t543 * t1463 * t1833;
  t1854 = t1853 * t146;
  tv2tau21 = t9 * (-t1828 + t1830 + t1836 - t1842 - t1847 + t1854);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1857 = 0.1e1 / t18 / t991;
  t1858 = t2 * t1857;
  t1859 = t24 * t24;
  t1861 = t25 * t1859 * t24;
  t1862 = t1861 * t185;
  t1863 = t1862 * t187;
  t1864 = t1858 * t1863;
  t1866 = 0.1e3 / 0.81e2 * t1864 * t531;
  t1867 = t1858 * t1861;
  t1868 = t1867 * t50;
  t1870 = 0.5e1 / 0.36e2 * t1868 * t1798;
  t1871 = t544 * t1857;
  t1872 = t1871 * t1861;
  t1875 = 0.2e4 / 0.243e3 * t543 * t147 * t1872;
  t1876 = t1857 * t1861;
  t1877 = t1876 * t194;
  t1878 = t1354 * t1877;
  t1880 = 0.25e2 / 0.162e3 * t1323 * t1878;
  t1881 = t62 * t1857;
  t1882 = t1861 * t146;
  t1883 = t1881 * t1882;
  t1884 = t878 * t1883;
  t1886 = 0.5e1 / 0.36e2 * t154 * t1884;
  t1887 = t1858 * t1862;
  t1893 = 0.1e3 / 0.81e2 * t1887 * t802 - 0.2e4 / 0.243e3 * t805 * t806 * t1876;
  t1894 = t1893 * t146;
  tv2tau22 = t9 * (-t1866 + t1870 + t1875 - t1880 - t1886 + t1894);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1896 = t814 * t316;
  t1897 = 0.3e1 * t1896;
  t1898 = t158 * t158;
  t1900 = 0.1e1 / t4 / t1898;
  t1901 = tau[0] * t1900;
  t1903 = 0.44e3 / 0.27e2 * t1901 * t16;
  t1905 = 0.2e3 / 0.9e1 * t496 * t168;
  t1907 = 0.5e2 / 0.9e1 * t161 * t503;
  t1909 = 0.25e2 / 0.3e1 * t161 * t509;
  t1910 = t14 * t13;
  t1911 = 0.1e1 / t1910;
  t1912 = t502 * t167;
  t1913 = t1911 * t1912;
  t1915 = 0.1e2 / 0.27e2 * t7 * t1913;
  t1916 = t501 * t167;
  t1917 = t1916 * t508;
  t1919 = 0.1e2 / 0.3e1 * t7 * t1917;
  t1920 = t8 * t98;
  t1921 = t506 - t1920;
  t1922 = 0.3e1 * t1921;
  t1923 = t15 * t1922;
  t1925 = 0.5e1 / 0.3e1 * t7 * t1923;
  t1926 = t25 * t24;
  t1927 = 0.1e1 / t1926;
  t1928 = t513 * t171;
  t1929 = t1927 * t1928;
  t1931 = 0.1e2 / 0.27e2 * t22 * t1929;
  t1932 = t512 * t171;
  t1933 = t1932 * t517;
  t1935 = 0.1e2 / 0.3e1 * t22 * t1933;
  t1936 = -t1922;
  t1937 = t26 * t1936;
  t1939 = 0.5e1 / 0.3e1 * t22 * t1937;
  t1940 = 0.154e3 / 0.27e2 * t202;
  t1941 = -t1903 + t1905 - t1907 - t1909 - t1915 + t1919 + t1925 - t1931 + t1935 + t1939 + t1940;
  t1942 = t2 * t1941;
  t1944 = t1942 * t40 * t153;
  t1949 = t527 * t180;
  t1950 = t2 * t1949;
  t1951 = t542 * t544;
  t1954 = t191 * t191;
  t1955 = 0.1e1 / t1954;
  t1956 = t539 * t1955;
  t1957 = t39 * t1956;
  t1958 = t544 * params->c;
  t1960 = t1958 * t1949 * t50;
  t1963 = t180 * t522;
  t1964 = t806 * t1963;
  t1967 = params->c * t1941;
  t1968 = t325 * t1967;
  t1971 = -0.5e1 / 0.9e1 * t1944 + 0.1e3 / 0.27e2 * t523 * t188 * t327 - 0.2e4 / 0.81e2 * t1950 * t1951 + 0.1e5 / 0.729e3 * t1957 * t1960 - 0.2e4 / 0.81e2 * t805 * t1964 + 0.5e2 / 0.81e2 * t324 * t1968;
  t1972 = t1971 * t146;
  t1973 = t330 * t791;
  t1974 = 0.3e1 * t1973;
  t1975 = t544 * t180;
  t1976 = t1975 * t522;
  t1977 = t147 * t1976;
  t1978 = t543 * t1977;
  t1979 = 0.2e4 / 0.81e2 * t1978;
  t1980 = t217 * params->c;
  t1981 = t325 * t1980;
  t1982 = t529 * t1981;
  t1983 = 0.1e3 / 0.27e2 * t1982;
  t1984 = t317 * params->c;
  t1985 = t325 * t1984;
  t1986 = t529 * t1985;
  t1987 = 0.1e3 / 0.27e2 * t1986;
  t1988 = t1956 * t66;
  t1989 = t39 * t1988;
  t1990 = t146 * t1958;
  t1992 = t1990 * t1949 * t50;
  t1993 = t1989 * t1992;
  t1994 = 0.1e5 / 0.729e3 * t1993;
  t1995 = t257 * t753;
  t1998 = 0.6e2 * t770 * t302;
  t1999 = t776 * t269;
  t2001 = t770 * t269;
  t2003 = t676 * t247;
  t2004 = t2003 * t248;
  t2006 = 0.6e1 * t675 * t2004;
  t2007 = t660 * t301;
  t2008 = t99 * t2007;
  t2010 = t776 * t302;
  t2011 = 0.96e2 * t2010;
  t2012 = t773 * t302;
  t2013 = 0.36e2 * t2012;
  t2014 = t773 * t269;
  t2017 = 0.1e1 / t639 / t12;
  t2018 = t641 * t166;
  t2021 = t640 * t166;
  t2024 = 0.6e1 * t1921;
  t2028 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t2017 * t2018 + 0.4e1 / 0.3e1 * t2021 * t644 + 0.4e1 / 0.3e1 * t103 * t2024);
  t2030 = 0.1e1 / t649 / t23;
  t2031 = t651 * t263;
  t2034 = t650 * t263;
  t2037 = -t2024;
  t2041 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2030 * t2031 + 0.4e1 / 0.3e1 * t2034 * t654 + 0.4e1 / 0.3e1 * t107 * t2037);
  t2043 = (t2028 + t2041) * t113;
  t2044 = t2043 * t141;
  t2047 = 0.1e1 / t598 / t134;
  t2048 = t600 * t296;
  t2050 = t2047 * t2048 * t603;
  t2052 = 0.10389515463408878255e3 * t311 * t2050;
  t2053 = t607 * t787;
  t2055 = -0.24e2 * t1995 + t1998 - 0.96e2 * t1999 + 0.6e2 * t2001 + t2006 + 0.3e1 * t2008 - t2011 + t2013 + 0.36e2 * t2014 + t99 * t2044 + t2052 + 0.35089341735807877242e1 * t2053;
  t2057 = t603 * t634;
  t2058 = t599 * t296 * t2057;
  t2060 = 0.51947577317044391277e2 * t311 * t2058;
  t2064 = 0.10685e0 * t685 * t222 * t723 * t725;
  t2065 = t618 * t228;
  t2068 = 0.71233333333333333332e-1 * t685 * t2065 * t249;
  t2071 = 0.53424999999999999999e-1 * t685 * t718 * t670;
  t2072 = t222 * t674;
  t2075 = 0.85917975471764868594e0 * t685 * t2072 * t679;
  t2077 = 0.1e1 / t32 / t175;
  t2079 = t232 * t2077 * t138;
  t2081 = 0.56968947174242584612e-3 * t306 * t2079;
  t2083 = t736 * t634 * t298;
  t2085 = 0.35089341735807877242e1 * t311 * t2083;
  t2086 = t660 * t67;
  t2087 = t2086 * t308;
  t2092 = 0.1e1 / t78 / t88 * t68 / 0.4e1;
  t2093 = t2092 * t98;
  t2095 = t613 * t177;
  t2096 = t612 * t2095;
  t2098 = t232 * t2077;
  t2099 = t231 * t2098;
  t2101 = t72 * t2077;
  t2102 = t70 * t2101;
  t2104 = 0.1e1/POW_3_2(t75);
  t2105 = t2104 * t68;
  t2106 = t2105 * t98;
  t2108 = t626 * t2095;
  t2110 = t239 * t2098;
  t2113 = t85 * t71 * t177;
  t2115 = -0.34523333333333333333e1 * t2093 + 0.23015555555555555556e1 * t2096 - 0.26851481481481481482e1 * t2099 - 0.93932222222222222223e0 * t2102 + 0.73355e-1 * t2106 - 0.14671e0 * t2108 - 0.17116166666666666667e0 * t2110 - 0.36793333333333333333e0 * t2113;
  t2117 = t290 * t2115 * t297;
  t2119 = 0.5848223622634646207e0 * t311 * t2117;
  t2121 = 0.1e1 / t598 / t289;
  t2124 = 0.1e1 / t602 / t137;
  t2125 = t2121 * t2048 * t2124;
  t2127 = 0.10254018858216406658e4 * t311 * t2125;
  t2128 = t660 * t129;
  t2129 = t2128 * t313;
  t2131 = t607 * t636;
  t2133 = t607 * t604;
  t2135 = -t2060 + t2064 + t2068 - t2071 - t2075 - t2081 + t2085 - 0.54934341918019635162e-3 * t2087 - t2119 - t2127 - 0.17544670867903938621e1 * t2129 - 0.17544670867903938621e1 * t2131 - 0.51947577317044391276e2 * t2133;
  t2137 = t268 * t748;
  t2138 = t99 * t2137;
  t2140 = t618 * t290;
  t2147 = t222 * t599;
  t2151 = t222 * t736;
  t2159 = t618 * t275;
  t2166 = t222 * t708;
  t2170 = t693 * t281;
  t2171 = t2170 * t282;
  t2174 = t2057 * t296;
  t2177 = t669 * t678;
  t2180 = 0.48245938496077605201e2 * t675 * t2177 * t247;
  t2181 = -t2006 + 0.21687162600603479684e-1 * t685 * t2140 * t298 - 0.16265371950452609763e-1 * t685 * t731 * t741 - 0.48159733137676571078e0 * t685 * t2147 * t745 + 0.32530743900905219526e-1 * t685 * t2151 * t738 + 0.10274e0 * t685 * t222 * t691 * t694 - t2064 - t2068 + t2071 + t2075 + 0.68493333333333333332e-1 * t685 * t2159 * t283 - 0.51369999999999999999e-1 * t685 * t686 * t704 - 0.16522625736956710527e1 * t685 * t2166 * t712 + 0.6e1 * t709 * t2171 + 0.51947577317044391277e2 * t744 * t2174 - t2180;
  t2184 = 0.6e1 * t724 * t670 * t247;
  t2186 = 0.1e1 / t673 / t227;
  t2187 = t77 * t2186;
  t2189 = 0.1e1 / t677 / t93;
  t2190 = t2003 * t2189;
  t2192 = 0.51726012919273400301e3 * t2187 * t2190;
  t2201 = -0.47063e1 * t2093 + 0.31375333333333333334e1 * t2096 - 0.36604555555555555556e1 * t2099 - 0.16068111111111111111e1 * t2102 + 0.28051666666666666666e0 * t2106 - 0.56103333333333333332e0 * t2108 - 0.6545388888888888889e0 * t2110 - 0.46308888888888888888e0 * t2113;
  t2202 = t2201 * t282;
  t2205 = t2048 * t297;
  t2208 = t129 * t2121;
  t2209 = t2048 * t2124;
  t2213 = 0.1e1 / t707 / t274;
  t2214 = t116 * t2213;
  t2216 = 0.1e1 / t710 / t124;
  t2217 = t2170 * t2216;
  t2221 = 0.1e1 / t707 / t121;
  t2222 = t116 * t2221;
  t2223 = t2170 * t711;
  t2238 = 0.34450798614814814813e-2 * t70 * t2101 * t94;
  t2242 = t298 * t634;
  t2245 = t129 * t2047;
  t2246 = t2048 * t603;
  t2249 = t2115 * t297;
  t2253 = 0.1e1 / t673 / t90;
  t2254 = t77 * t2253;
  t2255 = t2003 * t678;
  t2257 = 0.96491876992155210402e2 * t2254 * t2255;
  t2266 = -0.25319e1 * t2093 + 0.16879333333333333333e1 * t2096 - 0.19692555555555555555e1 * t2099 - 0.93011851851851851854e0 * t2102 + 0.13651666666666666667e0 * t2106 - 0.27303333333333333333e0 * t2108 - 0.3185388888888888889e0 * t2110 - 0.36514074074074074075e0 * t2113;
  t2267 = t2266 * t248;
  t2269 = 0.1e1 * t229 * t2267;
  t2270 = t2184 - t2192 + 0.1e1 * t276 * t2202 + 0.35089341735807877242e1 * t744 * t2205 + 0.10254018858216406658e4 * t2208 * t2209 + 0.2069040516770936012e4 * t2214 * t2217 - 0.19298375398431042081e3 * t2222 * t2223 + 0.96491876992155210402e2 * t709 * t703 * t711 * t281 - 0.6e1 * t692 * t283 * t703 + 0.56968947174242584612e-3 * t70 * t2101 * t138 - t2238 + 0.16562821945185185185e-2 * t70 * t2101 * t125 - 0.35089341735807877242e1 * t737 * t2242 - 0.10389515463408878255e3 * t2245 * t2246 + 0.5848223622634646207e0 * t291 * t2249 + t2257 - t2269;
  t2271 = t2181 + t2270;
  t2272 = t114 * t2271;
  t2273 = t99 * t2272;
  t2275 = 0.24e2 * t1920 * t142;
  t2276 = t62 * t256;
  t2277 = t2276 * t142;
  t2278 = 0.144e3 * t2277;
  t2279 = 0.1e1 / t1637;
  t2280 = t97 * t2279;
  t2282 = 0.12e3 * t2280 * t142;
  t2283 = t252 * t769;
  t2284 = t2283 * t142;
  t2285 = 0.24e3 * t2284;
  t2287 = t599 * t2048 * t297;
  t2289 = 0.35089341735807877242e1 * t311 * t2287;
  t2291 = 0.12e2 * t257 * t749;
  t2292 = t253 * t749;
  t2293 = 0.12e2 * t2292;
  t2294 = 0.3e1 * t2138 + t2273 + t2275 - t2278 - t2282 + t2285 + t2180 - t2184 + t2192 - t2289 - t2291 + t2293;
  t2295 = t253 * t753;
  t2297 = t253 * t751;
  t2299 = t257 * t751;
  t2301 = t223 * t787;
  t2303 = 0.32530743900905219526e-1 * t779 * t2301;
  t2304 = t622 * t313;
  t2306 = 0.21687162600603479684e-1 * t779 * t2304;
  t2307 = t223 * t604;
  t2309 = 0.48159733137676571078e0 * t779 * t2307;
  t2310 = t268 * t70;
  t2311 = t2310 * t780;
  t2313 = t223 * t636;
  t2315 = 0.16265371950452609763e-1 * t779 * t2313;
  t2316 = t783 * t766;
  t2320 = t2238 + 0.24e2 * t2295 + 0.12e2 * t2297 - 0.12e2 * t2299 - t2303 - t2306 + t2309 + 0.32530743900905219526e-1 * t2311 + t2315 + 0.73245789224026180216e-3 * t2316 - t2257 + t2269 + 0.19751673498613801407e-1 * t2043 * t139;
  t2322 = t2055 + t2135 + t2294 + t2320;
  t2323 = t156 * t2322;
  t2324 = t1950 * t539;
  t2325 = t541 * t66;
  t2326 = t2325 * t1295;
  t2327 = t2324 * t2326;
  t2328 = 0.2e4 / 0.81e2 * t2327;
  t2329 = t553 * t522;
  t2330 = t193 * t2329;
  t2331 = t190 * t2330;
  t2332 = 0.5e2 / 0.27e2 * t2331;
  t2333 = t194 * t1941;
  t2334 = t193 * t2333;
  t2335 = t190 * t2334;
  t2336 = 0.5e2 / 0.81e2 * t2335;
  t2337 = t192 * t589;
  t2339 = t190 * t2337 * t195;
  t2340 = 0.5e2 / 0.27e2 * t2339;
  t2342 = t190 * t549 * t554;
  t2343 = 0.1e3 / 0.27e2 * t2342;
  t2344 = t549 * t558;
  t2345 = t190 * t2344;
  t2346 = 0.5e2 / 0.27e2 * t2345;
  t2347 = t1897 + t1972 + t1974 + t1979 - t1983 - t1987 - t1994 + t2323 + t2328 - t2332 - t2336 - t2340 - t2343 - t2346;
  t2348 = t791 * params->c;
  t2349 = t2348 * t180;
  t2351 = t190 * t193 * t2349;
  t2352 = 0.5e2 / 0.27e2 * t2351;
  t2353 = t523 * t189;
  t2354 = t2353 * t196;
  t2355 = 0.1e3 / 0.27e2 * t2354;
  t2357 = t55 * t66 * t2322;
  t2358 = t46 * t2357;
  t2359 = 0.5e1 / 0.9e1 * t2358;
  t2361 = 0.1e1 / t33 / t1637;
  t2362 = t30 * t2361;
  t2364 = 0.595e3 / 0.27e2 * t2362 * t63;
  t2365 = t565 * t210;
  t2367 = t565 * t213;
  t2368 = 0.119e3 / 0.6e1 * t2367;
  t2369 = t202 * t576;
  t2371 = t202 * t580;
  t2373 = t202 * t584;
  t2375 = t202 * t61;
  t2376 = 0.7e1 / 0.2e1 * t2375;
  t2377 = t205 * t205;
  t2378 = 0.1e1 / t2377;
  t2379 = t2378 * t62;
  t2380 = t575 * t209;
  t2381 = t2379 * t2380;
  t2384 = t573 * t8;
  t2385 = t2384 * t575;
  t2386 = t59 * t2385;
  t2388 = t62 * t209;
  t2389 = t2388 * t583;
  t2392 = t206 * t209;
  t2393 = t59 * t2392;
  t2395 = t579 * t583;
  t2396 = t59 * t2395;
  t2398 = -t1903 + t1905 - t1907 - t1909 - t1915 + t1919 + t1925 - t1931 + t1935 + t1939;
  t2399 = t207 * t2398;
  t2402 = t2364 + 0.119e3 / 0.12e2 * t2365 - t2368 + 0.7e1 / 0.2e1 * t2369 - 0.7e1 * t2371 - 0.7e1 / 0.4e1 * t2373 + t2376 + 0.3e1 / 0.4e1 * t59 * t2381 - 0.3e1 / 0.2e1 * t2386 - 0.3e1 / 0.4e1 * t878 * t2389 + 0.3e1 / 0.4e1 * t2393 + 0.3e1 / 0.4e1 * t2396 + t59 * t2399 / 0.8e1;
  t2404 = t55 * t2402 * t146;
  t2405 = t46 * t2404;
  t2406 = 0.5e1 / 0.9e1 * t2405;
  t2408 = t55 * t589 * t316;
  t2409 = t46 * t2408;
  t2410 = 0.5e1 / 0.3e1 * t2409;
  t2412 = t55 * t216 * t791;
  t2413 = t46 * t2412;
  t2414 = 0.5e1 / 0.3e1 * t2413;
  t2415 = t217 * t545;
  t2416 = t543 * t2415;
  t2417 = 0.2e4 / 0.81e2 * t2416;
  t2418 = t317 * t545;
  t2419 = t543 * t2418;
  t2420 = 0.2e4 / 0.81e2 * t2419;
  t2421 = t182 * t591;
  t2422 = 0.5e1 / 0.3e1 * t2421;
  t2423 = t182 * t595;
  t2424 = 0.1e2 / 0.3e1 * t2423;
  t2425 = t182 * t793;
  t2426 = 0.5e1 / 0.3e1 * t2425;
  t2427 = t1942 * t45;
  t2428 = t2427 * t148;
  t2429 = 0.5e1 / 0.9e1 * t2428;
  t2430 = t524 * t218;
  t2431 = 0.5e1 / 0.3e1 * t2430;
  t2432 = t524 * t318;
  t2433 = 0.5e1 / 0.3e1 * t2432;
  t2434 = -t2352 - t2355 + t2359 + t2406 + t2410 + t2414 + t2417 + t2420 + t2422 + t2424 + t2426 + t2429 + t2431 + t2433;
  tv3rho30 = t9 * (t2347 + t2434) + 0.3e1 * t818 + 0.3e1 * t815 + 0.6e1 * t816 + 0.5e1 / 0.3e1 * t525 + 0.1e2 / 0.3e1 * t534 + 0.1e2 / 0.3e1 * t536 + 0.2e4 / 0.81e2 * t547 + 0.5e1 / 0.3e1 * t592 + 0.1e2 / 0.3e1 * t596 + 0.5e1 / 0.3e1 * t794 - 0.1e3 / 0.27e2 * t551 - 0.1e3 / 0.27e2 * t556 - 0.5e2 / 0.27e2 * t560 - 0.1e3 / 0.27e2 * t532;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t2451 = 0.2e1 * t971;
  t2452 = 0.4e4 / 0.243e3 * t856;
  t2453 = 0.2e3 / 0.81e2 * t847;
  t2454 = 0.1e3 / 0.81e2 * t859;
  t2455 = 0.1e3 / 0.81e2 * t863;
  t2456 = 0.1e3 / 0.81e2 * t867;
  t2457 = 0.1e3 / 0.81e2 * t873;
  t2458 = 0.1e3 / 0.81e2 * t905;
  t2459 = 0.2e1 * t974;
  t2460 = 0.2e1 * t973;
  t2461 = 0.1e2 / 0.9e1 * t954;
  t2462 = -t533 + t2451 + t2452 - t557 - t561 - t2453 - t2454 - t2455 - t2456 - t2457 - t2458 + t817 + t818 + t2459 + t815 + t2460 + t2461;
  t2463 = 0.1e2 / 0.9e1 * t844;
  t2464 = 0.1e2 / 0.9e1 * t849;
  t2465 = 0.1e2 / 0.9e1 * t851;
  t2466 = 0.1e2 / 0.9e1 * t869;
  t2467 = 0.1e2 / 0.9e1 * t894;
  t2468 = 0.1e2 / 0.9e1 * t898;
  t2469 = 0.1e2 / 0.9e1 * t900;
  t2470 = 0.1e2 / 0.9e1 * t909;
  t2471 = t330 * t951;
  t2473 = t814 * t382;
  t2474 = t394 * t791;
  t2475 = t970 * t316;
  t2478 = 0.2e3 / 0.27e2 * t496 * t337;
  t2480 = 0.1e3 / 0.27e2 * t161 * t824;
  t2482 = 0.5e2 / 0.9e1 * t161 * t828;
  t2484 = t1911 * t336 * t502;
  t2486 = 0.1e2 / 0.27e2 * t7 * t2484;
  t2487 = t7 * t501;
  t2488 = t507 * t167;
  t2490 = 0.2e2 / 0.9e1 * t2487 * t2488;
  t2491 = t823 * t508;
  t2493 = 0.1e2 / 0.9e1 * t7 * t2491;
  t2494 = t15 * t506;
  t2496 = 0.5e1 / 0.3e1 * t7 * t2494;
  t2497 = t827 * t98;
  t2499 = 0.5e1 * t7 * t2497;
  t2501 = 0.5e2 / 0.27e2 * t343 * t514;
  t2503 = 0.25e2 / 0.9e1 * t343 * t518;
  t2505 = t1927 * t346 * t513;
  t2507 = 0.1e2 / 0.27e2 * t22 * t2505;
  t2508 = t22 * t512;
  t2509 = t507 * t171;
  t2511 = 0.2e2 / 0.9e1 * t2508 * t2509;
  t2512 = t833 * t517;
  t2514 = 0.1e2 / 0.9e1 * t22 * t2512;
  t2515 = t26 * t506;
  t2517 = 0.5e1 / 0.3e1 * t22 * t2515;
  t2518 = t837 * t98;
  t2520 = 0.5e1 * t22 * t2518;
  t2521 = t2478 - t2480 - t2482 - t2486 + t2490 + t2493 + t2496 - t2499 - t2501 - t2503 - t2507 - t2511 + t2514 - t2517 + t2520 + t1940;
  t2522 = t2 * t2521;
  t2524 = t2522 * t40 * t153;
  t2526 = t842 * t188;
  t2529 = t351 * t539;
  t2534 = t1956 * t1958;
  t2535 = t39 * t2534;
  t2537 = t350 * t527 * t50;
  t2540 = t841 * t180;
  t2541 = t806 * t2540;
  t2544 = t350 * t522;
  t2545 = t806 * t2544;
  t2548 = params->c * t2521;
  t2549 = t325 * t2548;
  t2552 = -0.5e1 / 0.9e1 * t2524 + 0.2e3 / 0.81e2 * t2526 * t327 - 0.2e4 / 0.81e2 * t2529 * t807 + 0.1e3 / 0.81e2 * t959 * t811 + 0.1e5 / 0.729e3 * t2535 * t2537 - 0.4e4 / 0.243e3 * t805 * t2541 - 0.2e4 / 0.243e3 * t805 * t2545 + 0.5e2 / 0.81e2 * t324 * t2549;
  t2553 = t2552 * t146;
  t2554 = t1955 * t66;
  t2555 = t2554 * t146;
  t2556 = t805 * t2555;
  t2557 = t1958 * t350;
  t2559 = t2557 * t527 * t50;
  t2560 = t2556 * t2559;
  t2562 = t902 * t522;
  t2563 = t193 * t2562;
  t2564 = t190 * t2563;
  t2566 = t549 * t903;
  t2567 = t190 * t2566;
  t2569 = t951 * params->c;
  t2570 = t2569 * t180;
  t2571 = t193 * t2570;
  t2572 = t190 * t2571;
  t2574 = t871 * t558;
  t2575 = t190 * t2574;
  t2577 = t553 * t841;
  t2578 = t193 * t2577;
  t2579 = t190 * t2578;
  t2581 = t194 * t2521;
  t2582 = t193 * t2581;
  t2583 = t190 * t2582;
  t2585 = 0.2e1 * t2471 + t2473 + t2474 + 0.2e1 * t2475 + t2553 - 0.1e5 / 0.729e3 * t2560 - 0.5e2 / 0.81e2 * t2564 - 0.1e3 / 0.81e2 * t2567 - 0.1e3 / 0.81e2 * t2572 - 0.5e2 / 0.81e2 * t2575 - 0.1e3 / 0.81e2 * t2579 - 0.5e2 / 0.81e2 * t2583;
  t2586 = t192 * t891;
  t2587 = t2586 * t195;
  t2588 = t190 * t2587;
  t2590 = t871 * t554;
  t2591 = t190 * t2590;
  t2593 = t2337 * t355;
  t2594 = t190 * t2593;
  t2596 = t549 * t861;
  t2597 = t190 * t2596;
  t2599 = t549 * t865;
  t2600 = t190 * t2599;
  t2602 = t2348 * t350;
  t2603 = t193 * t2602;
  t2604 = t190 * t2603;
  t2606 = t846 * t550;
  t2608 = t846 * t555;
  t2610 = t846 * t559;
  t2612 = t842 * t189;
  t2613 = t2612 * t196;
  t2615 = t383 * params->c;
  t2616 = t325 * t2615;
  t2617 = t529 * t2616;
  t2619 = t217 * t854;
  t2620 = t543 * t2619;
  t2622 = t317 * t854;
  t2623 = t543 * t2622;
  t2625 = -0.1e3 / 0.81e2 * t2588 - 0.1e3 / 0.81e2 * t2591 - 0.5e2 / 0.81e2 * t2594 - 0.1e3 / 0.81e2 * t2597 - 0.1e3 / 0.81e2 * t2600 - 0.5e2 / 0.81e2 * t2604 - 0.2e3 / 0.81e2 * t2606 - 0.2e3 / 0.81e2 * t2608 - 0.1e3 / 0.81e2 * t2610 - 0.2e3 / 0.81e2 * t2613 - 0.1e3 / 0.81e2 * t2617 + 0.4e4 / 0.243e3 * t2620 + 0.4e4 / 0.243e3 * t2623;
  t2627 = t544 * t841;
  t2628 = t2627 * t180;
  t2629 = t147 * t2628;
  t2630 = t543 * t2629;
  t2632 = t853 * t522;
  t2633 = t147 * t2632;
  t2634 = t543 * t2633;
  t2636 = t365 * params->c;
  t2637 = t325 * t2636;
  t2638 = t529 * t2637;
  t2642 = t776 * t378;
  t2644 = t770 * t378;
  t2646 = t377 * t748;
  t2647 = t99 * t2646;
  t2648 = 0.32e2 * t2010;
  t2649 = 0.12e2 * t2012;
  t2651 = t257 * t935;
  t2654 = -0.16e2 * t1995 + t1998 + 0.4e2 * t2001 + t2006 - 0.32e2 * t2642 + 0.2e2 * t2644 + t2647 + t2008 - t2648 - t2649 - 0.24e2 * t2014 - 0.8e1 * t2651 + t2052 + 0.23392894490538584828e1 * t2053 - t2060 + t2064;
  t2659 = t945 * t787;
  t2661 = t945 * t604;
  t2663 = t932 * t129;
  t2665 = 0.11696447245269292414e1 * t2663 * t313;
  t2666 = t945 * t636;
  t2668 = t932 * t301;
  t2670 = 0.2e1 * t99 * t2668;
  t2671 = t2068 - t2071 - t2075 - t2081 + t2085 - 0.18311447306006545054e-3 * t2087 - t2119 - t2127 - 0.5848223622634646207e0 * t2129 - 0.11696447245269292414e1 * t2131 - 0.34631718211362927518e2 * t2133 + 0.11696447245269292414e1 * t2659 - 0.17315859105681463759e2 * t2661 - t2665 - 0.5848223622634646207e0 * t2666 + t2670;
  t2674 = 0.8e1 * t253 * t933;
  t2676 = 0.48e2 * t2277;
  t2677 = 0.8e2 * t2284;
  t2678 = t2017 * t335;
  t2681 = t640 * t8;
  t2692 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t2678 * t641 + 0.16e2 / 0.9e1 * t2681 * t506 * t166 + 0.4e1 / 0.9e1 * t915 * t644 + 0.8e1 / 0.3e1 * t103 * t506 - 0.8e1 * t918 * t98);
  t2693 = t2030 * t372;
  t2696 = t650 * t8;
  t2707 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2693 * t651 - 0.16e2 / 0.9e1 * t2696 * t506 * t263 + 0.4e1 / 0.9e1 * t923 * t654 - 0.8e1 / 0.3e1 * t107 * t506 + 0.8e1 * t926 * t98);
  t2709 = (t2692 + t2707) * t113;
  t2710 = t2709 * t141;
  t2712 = t253 * t935;
  t2715 = 0.8e1 * t257 * t933;
  t2716 = 0.4e1 * t2292;
  t2717 = t99 * t2710 + 0.2e1 * t2138 + t2180 - t2184 + t2192 + t2273 - t2275 - t2282 - t2289 - t2291 + t2674 + t2676 + t2677 + 0.8e1 * t2712 - t2715 + t2716;
  t2718 = t377 * t70;
  t2719 = t2718 * t780;
  t2721 = t773 * t378;
  t2723 = t932 * t67;
  t2725 = 0.36622894612013090108e-3 * t2723 * t308;
  t2726 = t937 * t766;
  t2734 = 0.10843581300301739842e-1 * t2719 + 0.12e2 * t2721 - t2725 + 0.24415263074675393405e-3 * t2726 + t2238 - 0.4e1 * t2297 - 0.4e1 * t2299 - t2303 - t2306 + t2309 + 0.21687162600603479684e-1 * t2311 + t2315 + 0.4883052614935078681e-3 * t2316 - t2257 + t2269 + 0.19751673498613801407e-1 * t2709 * t139;
  t2736 = t2654 + t2671 + t2717 + t2734;
  t2737 = t156 * t2736;
  t2739 = t55 * t66 * t2736;
  t2740 = t46 * t2739;
  t2742 = t383 * t545;
  t2743 = t543 * t2742;
  t2746 = t55 * t589 * t382;
  t2747 = t46 * t2746;
  t2750 = t55 * t216 * t951;
  t2751 = t46 * t2750;
  t2753 = t524 * t384;
  t2755 = t182 * t908;
  t2757 = t182 * t953;
  t2759 = t524 * t366;
  t2761 = 0.4e4 / 0.243e3 * t2630 + 0.2e4 / 0.243e3 * t2634 - 0.1e3 / 0.81e2 * t2638 + t2737 + 0.5e1 / 0.9e1 * t2740 + 0.2e4 / 0.243e3 * t2743 + 0.5e1 / 0.9e1 * t2747 + 0.1e2 / 0.9e1 * t2751 + 0.5e1 / 0.9e1 * t2753 + 0.1e2 / 0.9e1 * t2755 + 0.1e2 / 0.9e1 * t2757 + 0.5e1 / 0.9e1 * t2759;
  t2762 = t182 * t893;
  t2764 = t182 * t897;
  t2766 = t365 * t545;
  t2767 = t543 * t2766;
  t2769 = t879 * t583;
  t2772 = t565 * t361;
  t2774 = t202 * t573;
  t2776 = 0.7e1 / 0.3e1 * t2774 * t880;
  t2777 = t202 * t883;
  t2779 = t62 * t886;
  t2780 = t2779 * t209;
  t2783 = t2478 - t2480 - t2482 - t2486 + t2490 + t2493 + t2496 - t2499 - t2501 - t2503 - t2507 - t2511 + t2514 - t2517 + t2520;
  t2784 = t207 * t2783;
  t2788 = 0.7e1 / 0.6e1 * t202 * t887;
  t2789 = t206 * t360;
  t2790 = t59 * t2789;
  t2792 = t579 * t886;
  t2794 = t59 * t2792 / 0.2e1;
  t2795 = t59 * t2378;
  t2796 = t879 * t575;
  t2799 = t8 * t360;
  t2800 = t2799 * t209;
  t2801 = t878 * t2800;
  t2805 = 0.119e3 / 0.18e2 * t2367;
  t2809 = 0.7e1 / 0.6e1 * t2375;
  t2810 = -t878 * t2769 / 0.4e1 + 0.119e3 / 0.36e2 * t2772 + t2776 - 0.7e1 / 0.3e1 * t2777 - t878 * t2780 / 0.2e1 + t59 * t2784 / 0.8e1 - t2788 + t2790 / 0.4e1 + t2794 + 0.3e1 / 0.4e1 * t2795 * t2796 - t2801 + 0.7e1 / 0.6e1 * t2369 + t2386 / 0.2e1 + t2364 + 0.119e3 / 0.18e2 * t2365 - t2805 - 0.7e1 / 0.12e2 * t2373 - t2393 / 0.2e1 - t2396 / 0.4e1 - t2809;
  t2812 = t55 * t2810 * t146;
  t2813 = t46 * t2812;
  t2816 = t55 * t891 * t316;
  t2817 = t46 * t2816;
  t2820 = t55 * t364 * t791;
  t2821 = t46 * t2820;
  t2823 = t2522 * t45;
  t2824 = t2823 * t148;
  t2826 = t843 * t218;
  t2828 = t843 * t318;
  t2830 = t351 * t542;
  t2831 = t2830 * t546;
  t2833 = t352 * t591;
  t2835 = t352 * t595;
  t2837 = t352 * t793;
  t2839 = 0.1e2 / 0.9e1 * t2762 + 0.1e2 / 0.9e1 * t2764 + 0.2e4 / 0.243e3 * t2767 + 0.5e1 / 0.9e1 * t2813 + 0.1e2 / 0.9e1 * t2817 + 0.5e1 / 0.9e1 * t2821 + 0.5e1 / 0.9e1 * t2824 + 0.1e2 / 0.9e1 * t2826 + 0.1e2 / 0.9e1 * t2828 + 0.2e4 / 0.81e2 * t2831 + 0.5e1 / 0.9e1 * t2833 + 0.1e2 / 0.9e1 * t2835 + 0.5e1 / 0.9e1 * t2837;
  t2843 = 0.2e1 * t972;
  t2844 = t2463 + t2464 + t2465 + t2466 + t2467 + t2468 + t2469 + t2470 + t537 + t548 + t593 + t597 + t795 + t526 + t535 + t9 * (t2585 + t2625 + t2761 + t2839) + t2843 - t552;
  tv3rho31 = t2462 + t2844;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t2846 = 0.5e2 / 0.27e2 * t161 * t984;
  t2847 = t1911 * t983;
  t2848 = t2847 * t167;
  t2850 = 0.1e2 / 0.27e2 * t7 * t2848;
  t2851 = t336 * t8;
  t2852 = t2851 * t506;
  t2854 = 0.2e2 / 0.9e1 * t2487 * t2852;
  t2856 = 0.25e2 / 0.9e1 * t161 * t988;
  t2857 = t501 * t987;
  t2858 = t2857 * t167;
  t2860 = 0.1e2 / 0.9e1 * t7 * t2858;
  t2862 = -t506 - 0.3e1 * t1920;
  t2863 = t15 * t2862;
  t2865 = 0.5e1 / 0.3e1 * t7 * t2863;
  t2867 = 0.2e3 / 0.27e2 * t994 * t172;
  t2869 = 0.1e3 / 0.27e2 * t343 * t834;
  t2871 = 0.5e2 / 0.9e1 * t343 * t838;
  t2872 = t1927 * t999;
  t2873 = t2872 * t171;
  t2875 = 0.1e2 / 0.27e2 * t22 * t2873;
  t2876 = t346 * t8;
  t2877 = t2876 * t506;
  t2879 = 0.2e2 / 0.9e1 * t2508 * t2877;
  t2880 = t512 * t1003;
  t2881 = t2880 * t171;
  t2883 = 0.1e2 / 0.9e1 * t22 * t2881;
  t2884 = -t2862;
  t2885 = t26 * t2884;
  t2887 = 0.5e1 / 0.3e1 * t22 * t2885;
  t2888 = -t2846 - t2850 + t2854 - t2856 + t2860 + t2865 + t2867 - t2869 + t2871 - t2875 - t2879 + t2883 + t2887 + t1940;
  t2889 = t2 * t2888;
  t2891 = t2889 * t40 * t153;
  t2893 = t1008 * t188;
  t2898 = t1013 * t539;
  t2899 = t806 * t180;
  t2903 = t1012 * t180 * t50;
  t2906 = t350 * t841;
  t2907 = t806 * t2906;
  t2910 = t1007 * t180;
  t2911 = t806 * t2910;
  t2914 = params->c * t2888;
  t2915 = t325 * t2914;
  t2918 = -0.5e1 / 0.9e1 * t2891 + 0.1e3 / 0.81e2 * t2893 * t327 + 0.2e3 / 0.81e2 * t959 * t967 - 0.2e4 / 0.81e2 * t2898 * t2899 + 0.1e5 / 0.729e3 * t2535 * t2903 - 0.4e4 / 0.243e3 * t805 * t2907 - 0.2e4 / 0.243e3 * t805 * t2911 + 0.5e2 / 0.81e2 * t324 * t2915;
  t2919 = t2918 * t146;
  t2920 = t970 * t382;
  t2922 = t330 * t1084;
  t2931 = -0.8e1 * t1995 + t1998 + 0.32e2 * t1999 + 0.2e2 * t2001 + t2006 + 0.4e2 * t2644 + 0.2e1 * t2647 + t2648 - t2649 + 0.12e2 * t2014 - 0.16e2 * t2651 + t2052 + 0.11696447245269292414e1 * t2053 - t2060 + t2064 + t2068;
  t2934 = t1072 * t129;
  t2935 = t2934 * t313;
  t2940 = -t2071 - t2075 - t2081 + t2085 - t2119 - t2127 - 0.5848223622634646207e0 * t2131 - 0.17315859105681463759e2 * t2133 - 0.5848223622634646207e0 * t2935 + 0.23392894490538584828e1 * t2659 - 0.34631718211362927517e2 * t2661 - t2665 - 0.11696447245269292414e1 * t2666 + t2670 - t2674 + t2138;
  t2942 = t253 * t1073;
  t2944 = t257 * t1073;
  t2946 = t2017 * t1055;
  t2951 = t640 * t1058;
  t2956 = -0.2e1 * t506 - 0.6e1 * t1920;
  t2960 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t2946 * t166 + 0.16e2 / 0.9e1 * t915 * t507 + 0.4e1 / 0.9e1 * t2951 * t166 + 0.4e1 / 0.3e1 * t103 * t2956);
  t2961 = t2030 * t1063;
  t2966 = t650 * t1066;
  t2969 = -t2956;
  t2973 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2961 * t263 - 0.16e2 / 0.9e1 * t923 * t507 + 0.4e1 / 0.9e1 * t2966 * t263 + 0.4e1 / 0.3e1 * t107 * t2969);
  t2975 = (t2960 + t2973) * t113;
  t2976 = t2975 * t141;
  t2978 = t1072 * t301;
  t2979 = t99 * t2978;
  t2980 = t99 * t2976 + t2180 - t2184 + t2192 + t2273 + t2275 - t2282 - t2289 - t2291 + t2676 - t2677 - t2715 - t2716 + 0.4e1 * t2942 - 0.4e1 * t2944 + t2979;
  t2987 = t1072 * t67;
  t2988 = t2987 * t308;
  t2992 = 0.21687162600603479684e-1 * t2719 - 0.24e2 * t2721 - t2725 + 0.48830526149350786811e-3 * t2726 + t2238 - 0.8e1 * t2295 - t2303 - t2306 + t2309 + 0.10843581300301739842e-1 * t2311 + t2315 + 0.24415263074675393405e-3 * t2316 - 0.18311447306006545054e-3 * t2988 - t2257 + t2269 + 0.19751673498613801407e-1 * t2975 * t139;
  t2994 = t2931 + t2940 + t2980 + t2992;
  t2995 = t156 * t2994;
  t2996 = t1958 * t1012;
  t2998 = t2996 * t180 * t50;
  t2999 = t2556 * t2998;
  t3002 = t55 * t66 * t2994;
  t3003 = t46 * t3002;
  t3005 = t182 * t1086;
  t3008 = t55 * t216 * t1084;
  t3009 = t46 * t3008;
  t3012 = t55 * t364 * t951;
  t3013 = t46 * t3012;
  t3015 = t352 * t953;
  t3017 = t217 * t1021;
  t3018 = t543 * t3017;
  t3020 = t317 * t1021;
  t3021 = t543 * t3020;
  t3023 = t2919 + 0.2e1 * t2920 + t2922 + t2995 - 0.1e5 / 0.729e3 * t2999 + 0.5e1 / 0.9e1 * t3003 + 0.5e1 / 0.9e1 * t3005 + 0.5e1 / 0.9e1 * t3009 + 0.1e2 / 0.9e1 * t3013 + 0.1e2 / 0.9e1 * t3015 + 0.2e4 / 0.243e3 * t3018 + 0.2e4 / 0.243e3 * t3021;
  t3024 = t182 * t1048;
  t3029 = t202 * t1038;
  t3031 = t62 * t1037;
  t3032 = t3031 * t209;
  t3035 = t2384 * t1037;
  t3036 = t59 * t3035;
  t3038 = t879 * t886;
  t3042 = t202 * t1043;
  t3044 = t62 * t1042;
  t3045 = t3044 * t209;
  t3048 = t579 * t1042;
  t3049 = t59 * t3048;
  t3051 = -t2846 - t2850 + t2854 - t2856 + t2860 + t2865 + t2867 - t2869 + t2871 - t2875 - t2879 + t2883 + t2887;
  t3052 = t207 * t3051;
  t3056 = t2364 + 0.119e3 / 0.36e2 * t2365 + t2805 + 0.119e3 / 0.18e2 * t2772 + t2776 - t2788 + 0.7e1 / 0.3e1 * t2371 - t2809 + 0.7e1 / 0.6e1 * t3029 + 0.3e1 / 0.4e1 * t2795 * t3032 - t3036 / 0.2e1 - t878 * t3038 / 0.2e1 + t2801 - t2790 / 0.2e1 - t2794 - 0.7e1 / 0.12e2 * t3042 - t878 * t3045 / 0.4e1 + t3049 / 0.4e1 + t59 * t3052 / 0.8e1 + t2393 / 0.4e1;
  t3058 = t55 * t3056 * t146;
  t3059 = t46 * t3058;
  t3062 = t55 * t1046 * t316;
  t3063 = t46 * t3062;
  t3065 = t182 * t1052;
  t3068 = t55 * t891 * t382;
  t3069 = t46 * t3068;
  t3071 = t2889 * t45;
  t3072 = t3071 * t148;
  t3074 = t1009 * t218;
  t3076 = t1009 * t318;
  t3078 = t1013 * t542;
  t3079 = t147 * t1975;
  t3080 = t3078 * t3079;
  t3082 = t843 * t366;
  t3084 = t352 * t893;
  t3086 = t352 * t897;
  t3088 = t843 * t384;
  t3090 = 0.5e1 / 0.9e1 * t3024 + 0.5e1 / 0.9e1 * t3059 + 0.5e1 / 0.9e1 * t3063 + 0.1e2 / 0.9e1 * t3065 + 0.1e2 / 0.9e1 * t3069 + 0.5e1 / 0.9e1 * t3072 + 0.5e1 / 0.9e1 * t3074 + 0.5e1 / 0.9e1 * t3076 + 0.2e4 / 0.81e2 * t3080 + 0.1e2 / 0.9e1 * t3082 + 0.1e2 / 0.9e1 * t3084 + 0.1e2 / 0.9e1 * t3086 + 0.1e2 / 0.9e1 * t3088;
  t3092 = t352 * t908;
  t3094 = t394 * t951;
  t3096 = t1102 * t316;
  t3097 = t549 * t1032;
  t3098 = t190 * t3097;
  t3100 = t553 * t1007;
  t3101 = t193 * t3100;
  t3102 = t190 * t3101;
  t3104 = t846 * t904;
  t3106 = t2586 * t355;
  t3107 = t190 * t3106;
  t3109 = t871 * t861;
  t3110 = t190 * t3109;
  t3112 = t871 * t865;
  t3113 = t190 * t3112;
  t3115 = t1008 * t189;
  t3116 = t3115 * t196;
  t3118 = t846 * t866;
  t3120 = t846 * t872;
  t3122 = 0.1e2 / 0.9e1 * t3092 + 0.2e1 * t3094 + t3096 - 0.5e2 / 0.81e2 * t3098 - 0.5e2 / 0.81e2 * t3102 - 0.2e3 / 0.81e2 * t3104 - 0.1e3 / 0.81e2 * t3107 - 0.1e3 / 0.81e2 * t3110 - 0.1e3 / 0.81e2 * t3113 - 0.1e3 / 0.81e2 * t3116 - 0.2e3 / 0.81e2 * t3118 - 0.2e3 / 0.81e2 * t3120;
  t3123 = t1084 * params->c;
  t3124 = t3123 * t180;
  t3125 = t193 * t3124;
  t3126 = t190 * t3125;
  t3128 = t194 * t2888;
  t3129 = t193 * t3128;
  t3130 = t190 * t3129;
  t3132 = t192 * t1046;
  t3133 = t3132 * t195;
  t3134 = t190 * t3133;
  t3136 = t871 * t903;
  t3137 = t190 * t3136;
  t3139 = t549 * t1028;
  t3140 = t190 * t3139;
  t3142 = t2569 * t350;
  t3143 = t193 * t3142;
  t3144 = t190 * t3143;
  t3146 = t902 * t841;
  t3147 = t193 * t3146;
  t3148 = t190 * t3147;
  t3150 = t1014 * t1981;
  t3153 = t543 * t383 * t854;
  t3155 = t544 * t1007;
  t3156 = t3155 * t180;
  t3158 = t543 * t147 * t3156;
  t3160 = t1014 * t1985;
  t3162 = t853 * t841;
  t3163 = t147 * t3162;
  t3164 = t543 * t3163;
  t3167 = t543 * t365 * t854;
  t3169 = -0.5e2 / 0.81e2 * t3126 - 0.5e2 / 0.81e2 * t3130 - 0.5e2 / 0.81e2 * t3134 - 0.1e3 / 0.81e2 * t3137 - 0.1e3 / 0.81e2 * t3140 - 0.1e3 / 0.81e2 * t3144 - 0.1e3 / 0.81e2 * t3148 - 0.1e3 / 0.81e2 * t3150 + 0.4e4 / 0.243e3 * t3153 + 0.2e4 / 0.243e3 * t3158 - 0.1e3 / 0.81e2 * t3160 + 0.4e4 / 0.243e3 * t3164 + 0.4e4 / 0.243e3 * t3167;
  t3173 = -t1016 + t9 * (t3023 + t3090 + t3122 + t3169) - t1027 - t1031 - t1035 + t1105 + t1106 + t2451 + t2452 - t2453 - t2454 - t2455 - t2456 - t2457 - t2458 + t2459 + t2460;
  t3174 = t1011 + t1018 + t1020 + t1024 + t1050 + t1054 + t1088 + t2461 + t2463 + t2464 + t2465 + t2466 + t2467 + t2468 + t2469 + t2470 + t2843 + t1103;
  tv3rho32 = t3173 + t3174;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t3175 = t1102 * t382;
  t3176 = 0.3e1 * t3175;
  t3177 = t983 * t336;
  t3178 = t1911 * t3177;
  t3180 = 0.1e2 / 0.27e2 * t7 * t3178;
  t3181 = t823 * t987;
  t3183 = 0.1e2 / 0.3e1 * t7 * t3181;
  t3184 = -t506 - t1920;
  t3185 = 0.3e1 * t3184;
  t3186 = t15 * t3185;
  t3188 = 0.5e1 / 0.3e1 * t7 * t3186;
  t3189 = t340 * t340;
  t3191 = 0.1e1 / t19 / t3189;
  t3192 = tau[1] * t3191;
  t3194 = 0.44e3 / 0.27e2 * t3192 * t27;
  t3196 = 0.2e3 / 0.9e1 * t994 * t347;
  t3198 = 0.5e2 / 0.9e1 * t343 * t1000;
  t3200 = 0.25e2 / 0.3e1 * t343 * t1004;
  t3201 = t999 * t346;
  t3202 = t1927 * t3201;
  t3204 = 0.1e2 / 0.27e2 * t22 * t3202;
  t3205 = t833 * t1003;
  t3207 = 0.1e2 / 0.3e1 * t22 * t3205;
  t3208 = -t3185;
  t3209 = t26 * t3208;
  t3211 = 0.5e1 / 0.3e1 * t22 * t3209;
  t3212 = -t3180 + t3183 + t3188 - t3194 + t3196 - t3198 - t3200 - t3204 + t3207 + t3211 + t1940;
  t3213 = t2 * t3212;
  t3215 = t3213 * t40 * t153;
  t3219 = t1012 * t350;
  t3220 = t2 * t3219;
  t3224 = t1958 * t3219 * t50;
  t3227 = t350 * t1007;
  t3228 = t806 * t3227;
  t3231 = params->c * t3212;
  t3232 = t325 * t3231;
  t3235 = -0.5e1 / 0.9e1 * t3215 + 0.1e3 / 0.27e2 * t2893 * t391 - 0.2e4 / 0.81e2 * t3220 * t1951 + 0.1e5 / 0.729e3 * t1957 * t3224 - 0.2e4 / 0.81e2 * t805 * t3228 + 0.5e2 / 0.81e2 * t324 * t3232;
  t3236 = t3235 * t146;
  t3237 = t394 * t1084;
  t3238 = 0.3e1 * t3237;
  t3240 = t1990 * t3219 * t50;
  t3241 = t1989 * t3240;
  t3242 = 0.1e5 / 0.729e3 * t3241;
  t3243 = t3220 * t539;
  t3244 = t3243 * t2326;
  t3245 = 0.2e4 / 0.81e2 * t3244;
  t3250 = t1055 * t335;
  t3255 = 0.6e1 * t3184;
  t3259 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t2017 * t3250 + 0.4e1 / 0.3e1 * t915 * t1058 + 0.4e1 / 0.3e1 * t103 * t3255);
  t3260 = t1063 * t372;
  t3265 = -t3255;
  t3269 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2030 * t3260 + 0.4e1 / 0.3e1 * t923 * t1066 + 0.4e1 / 0.3e1 * t107 * t3265);
  t3271 = (t3259 + t3269) * t113;
  t3272 = t3271 * t141;
  t3274 = t99 * t3272 + t1998 + t2006 + t2011 + t2013 + t2052 - t2060 + t2064 + 0.96e2 * t2642 + 0.6e2 * t2644 + 0.3e1 * t2647 - 0.24e2 * t2651;
  t3281 = t2068 - t2071 - t2075 - t2081 + t2085 - t2119 - t2127 - 0.17544670867903938621e1 * t2935 + 0.35089341735807877242e1 * t2659 - 0.51947577317044391276e2 * t2661 - 0.17544670867903938621e1 * t2666 + 0.19751673498613801407e-1 * t3271 * t139 + t2273;
  t3287 = -t2275 - t2278 - t2282 - t2285 + t2180 - t2184 + t2192 - t2289 - 0.12e2 * t2942 - 0.12e2 * t2944 - 0.24e2 * t2712 + 0.3e1 * t2979;
  t3292 = -t2291 - t2293 + 0.32530743900905219526e-1 * t2719 + 0.36e2 * t2721 + 0.73245789224026180216e-3 * t2726 + t2238 - t2303 - t2306 + t2309 + t2315 - 0.54934341918019635162e-3 * t2988 - t2257 + t2269;
  t3294 = t3274 + t3281 + t3287 + t3292;
  t3295 = t156 * t3294;
  t3296 = t853 * t1007;
  t3297 = t147 * t3296;
  t3298 = t543 * t3297;
  t3299 = 0.2e4 / 0.81e2 * t3298;
  t3300 = t1014 * t2637;
  t3301 = 0.1e3 / 0.27e2 * t3300;
  t3302 = t1014 * t2616;
  t3303 = 0.1e3 / 0.27e2 * t3302;
  t3304 = t352 * t1086;
  t3305 = 0.5e1 / 0.3e1 * t3304;
  t3306 = t365 * t1021;
  t3307 = t543 * t3306;
  t3308 = 0.2e4 / 0.81e2 * t3307;
  t3309 = t3213 * t45;
  t3310 = t3309 * t148;
  t3311 = 0.5e1 / 0.9e1 * t3310;
  t3312 = t1009 * t366;
  t3313 = 0.5e1 / 0.3e1 * t3312;
  t3314 = t1009 * t384;
  t3315 = 0.5e1 / 0.3e1 * t3314;
  t3316 = t3176 + t3236 + t3238 - t3242 + t3245 + t3295 + t3299 - t3301 - t3303 + t3305 + t3308 + t3311 + t3313 + t3315;
  t3317 = t352 * t1048;
  t3318 = 0.5e1 / 0.3e1 * t3317;
  t3319 = t352 * t1052;
  t3320 = 0.1e2 / 0.3e1 * t3319;
  t3322 = t55 * t66 * t3294;
  t3323 = t46 * t3322;
  t3324 = 0.5e1 / 0.9e1 * t3323;
  t3329 = t1037 * t360;
  t3330 = t2379 * t3329;
  t3334 = t879 * t1042;
  t3339 = -t3180 + t3183 + t3188 - t3194 + t3196 - t3198 - t3200 - t3204 + t3207 + t3211;
  t3340 = t207 * t3339;
  t3343 = t2364 + 0.119e3 / 0.12e2 * t2772 + t2368 + 0.7e1 / 0.2e1 * t3029 + 0.7e1 * t2777 - 0.7e1 / 0.4e1 * t3042 + t2376 + 0.3e1 / 0.4e1 * t59 * t3330 + 0.3e1 / 0.2e1 * t3036 - 0.3e1 / 0.4e1 * t878 * t3334 + 0.3e1 / 0.4e1 * t2790 - 0.3e1 / 0.4e1 * t3049 + t59 * t3340 / 0.8e1;
  t3345 = t55 * t3343 * t146;
  t3346 = t46 * t3345;
  t3347 = 0.5e1 / 0.9e1 * t3346;
  t3349 = t55 * t1046 * t382;
  t3350 = t46 * t3349;
  t3351 = 0.5e1 / 0.3e1 * t3350;
  t3353 = t55 * t364 * t1084;
  t3354 = t46 * t3353;
  t3355 = 0.5e1 / 0.3e1 * t3354;
  t3356 = t383 * t1021;
  t3357 = t543 * t3356;
  t3358 = 0.2e4 / 0.81e2 * t3357;
  t3359 = t902 * t1007;
  t3360 = t193 * t3359;
  t3361 = t190 * t3360;
  t3362 = 0.5e2 / 0.27e2 * t3361;
  t3363 = t194 * t3212;
  t3364 = t193 * t3363;
  t3365 = t190 * t3364;
  t3366 = 0.5e2 / 0.81e2 * t3365;
  t3368 = t190 * t3132 * t355;
  t3369 = 0.5e2 / 0.27e2 * t3368;
  t3371 = t190 * t871 * t1028;
  t3372 = 0.1e3 / 0.27e2 * t3371;
  t3373 = t871 * t1032;
  t3374 = t190 * t3373;
  t3375 = 0.5e2 / 0.27e2 * t3374;
  t3376 = t3123 * t350;
  t3378 = t190 * t193 * t3376;
  t3379 = 0.5e2 / 0.27e2 * t3378;
  t3380 = t3115 * t356;
  t3381 = 0.1e3 / 0.27e2 * t3380;
  t3382 = t3318 + t3320 + t3324 + t3347 + t3351 + t3355 + t3358 - t3362 - t3366 - t3369 - t3372 - t3375 - t3379 - t3381;
  tv3rho33 = t9 * (t3316 + t3382) + 0.3e1 * t1106 + 0.3e1 * t1103 + 0.6e1 * t1104 + 0.5e1 / 0.3e1 * t1010 + 0.1e2 / 0.3e1 * t1017 + 0.1e2 / 0.3e1 * t1019 + 0.2e4 / 0.81e2 * t1023 + 0.5e1 / 0.3e1 * t1049 + 0.1e2 / 0.3e1 * t1053 + 0.5e1 / 0.3e1 * t1087 - 0.1e3 / 0.27e2 * t1026 - 0.1e3 / 0.27e2 * t1030 - 0.5e2 / 0.27e2 * t1034 - 0.1e3 / 0.27e2 * t1015;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t3399 = t201 * t61;
  t3400 = t3399 * t62;
  t3402 = t1141 * t3400 * t195;
  t3403 = 0.175e3 / 0.243e3 * t3402;
  t3404 = t1142 * t8;
  t3406 = t1141 * t3404 * t195;
  t3407 = 0.25e2 / 0.81e2 * t3406;
  t3408 = t1143 * t554;
  t3409 = t1141 * t3408;
  t3410 = 0.25e2 / 0.162e3 * t3409;
  t3411 = t1143 * t558;
  t3412 = t1141 * t3411;
  t3413 = 0.25e2 / 0.324e3 * t3412;
  t3414 = t400 * t793;
  t3415 = 0.5e1 / 0.72e2 * t3414;
  t3416 = t1110 * t218;
  t3417 = 0.1e2 / 0.27e2 * t3416;
  t3418 = t1110 * t318;
  t3419 = 0.1e2 / 0.27e2 * t3418;
  t3420 = t399 * t542;
  t3421 = t3420 * t546;
  t3422 = 0.25e3 / 0.81e2 * t3421;
  t3423 = t2 * t58;
  t3424 = t3423 * t45;
  t3425 = t3424 * t148;
  t3426 = 0.55e2 / 0.81e2 * t3425;
  t3427 = t400 * t591;
  t3428 = 0.5e1 / 0.72e2 * t3427;
  t3429 = t400 * t595;
  t3430 = 0.5e1 / 0.36e2 * t3429;
  t3431 = t1179 * t316;
  t3432 = 0.2e1 * t3431;
  t3433 = -t3403 + t3407 + t3410 + t3413 - t3415 + t3417 + t3419 - t3422 - t3426 - t3428 - t3430 + t3432;
  t3434 = t317 * t1121;
  t3435 = t543 * t3434;
  t3436 = 0.5e3 / 0.243e3 * t3435;
  t3437 = t1120 * t522;
  t3438 = t147 * t3437;
  t3439 = t543 * t3438;
  t3440 = 0.25e3 / 0.243e3 * t3439;
  t3441 = t217 * t1121;
  t3442 = t543 * t3441;
  t3443 = 0.5e3 / 0.243e3 * t3442;
  t3444 = t1142 * t146;
  t3445 = t55 * t3444;
  t3446 = t46 * t3445;
  t3447 = 0.5e1 / 0.36e2 * t3446;
  t3448 = t544 * t177;
  t3449 = t3448 * t180;
  t3451 = t543 * t147 * t3449;
  t3452 = 0.4e4 / 0.729e3 * t3451;
  t3453 = t180 * t209;
  t3454 = t194 * t3453;
  t3455 = t1354 * t3454;
  t3456 = t1141 * t3455;
  t3457 = 0.25e2 / 0.162e3 * t3456;
  t3459 = t3423 * t40 * t153;
  t3460 = 0.55e2 / 0.81e2 * t3459;
  t3461 = t1109 * t188;
  t3462 = t3461 * t327;
  t3463 = 0.2e3 / 0.243e3 * t3462;
  t3464 = t399 * t539;
  t3465 = t3464 * t807;
  t3467 = t1168 * t811;
  t3471 = t2535 * t35 * t527 * t50;
  t3474 = t806 * t177 * t180;
  t3475 = t805 * t3474;
  t3476 = 0.4e4 / 0.729e3 * t3475;
  t3478 = t806 * t35 * t522;
  t3479 = t805 * t3478;
  t3483 = t324 * t325 * params->c * t58;
  t3484 = 0.55e3 / 0.729e3 * t3483;
  t3485 = t3460 + t3463 + 0.25e3 / 0.81e2 * t3465 - 0.25e2 / 0.162e3 * t3467 - 0.125e4 / 0.729e3 * t3471 - t3476 + 0.25e3 / 0.243e3 * t3479 - t3484;
  t3486 = t3485 * t146;
  t3487 = t420 * t791;
  t3488 = t1958 * t35;
  t3490 = t3488 * t527 * t50;
  t3491 = t2556 * t3490;
  t3492 = 0.125e4 / 0.729e3 * t3491;
  t3493 = t8 * t146;
  t3494 = t3493 * t209;
  t3495 = t1151 * t3494;
  t3496 = t407 * t3495;
  t3497 = 0.5e1 / 0.18e2 * t3496;
  t3498 = t1136 * t1154;
  t3499 = 0.5e1 / 0.36e2 * t3498;
  t3500 = t408 * t573;
  t3501 = t1152 * t575;
  t3502 = t3500 * t3501;
  t3503 = t407 * t3502;
  t3504 = 0.5e1 / 0.36e2 * t3503;
  t3505 = -t3436 - t3440 - t3443 - t3447 + t3452 - t3457 + t3486 + t3487 + t3492 + t3497 + t3499 - t3504;
  t3507 = t1136 * t1158;
  t3508 = 0.5e1 / 0.18e2 * t3507;
  t3509 = t54 * t564;
  t3510 = t3509 * t409;
  t3511 = t407 * t3510;
  t3512 = 0.595e3 / 0.324e3 * t3511;
  t3513 = t1147 * t1157;
  t3514 = t407 * t3513;
  t3515 = 0.35e2 / 0.27e2 * t3514;
  t3517 = t190 * t549 * t1132;
  t3518 = 0.1e3 / 0.243e3 * t3517;
  t3519 = t553 * t177;
  t3521 = t190 * t193 * t3519;
  t3522 = 0.1e3 / 0.243e3 * t3521;
  t3523 = t194 * t58;
  t3525 = t190 * t193 * t3523;
  t3526 = 0.55e3 / 0.729e3 * t3525;
  t3527 = t1136 * t1148;
  t3528 = 0.35e2 / 0.54e2 * t3527;
  t3529 = t2337 * t403;
  t3530 = t190 * t3529;
  t3531 = 0.25e2 / 0.324e3 * t3530;
  t3532 = t549 * t1128;
  t3533 = t190 * t3532;
  t3534 = 0.25e2 / 0.162e3 * t3533;
  t3535 = t2348 * t35;
  t3536 = t193 * t3535;
  t3537 = t190 * t3536;
  t3538 = 0.25e2 / 0.324e3 * t3537;
  t3539 = t1113 * t550;
  t3540 = 0.25e2 / 0.81e2 * t3539;
  t3541 = t1113 * t555;
  t3542 = 0.25e2 / 0.81e2 * t3541;
  t3543 = -t3508 - t3512 + t3515 - t3518 - t3522 + t3526 + t3528 + t3531 + t3534 + t3538 + t3540 + t3542;
  t3544 = t1113 * t559;
  t3545 = 0.25e2 / 0.162e3 * t3544;
  t3546 = t1109 * t189;
  t3547 = t3546 * t196;
  t3548 = 0.2e3 / 0.243e3 * t3547;
  t3549 = t523 * t50;
  t3550 = t3549 * t410;
  t3551 = 0.5e1 / 0.72e2 * t3550;
  t3552 = t1136 * t1162;
  t3553 = 0.5e1 / 0.36e2 * t3552;
  t3554 = t542 * t58;
  t3555 = t39 * t3554;
  t3556 = t1295 * t527;
  t3557 = t63 * t3556;
  t3558 = t3555 * t3557;
  t3559 = 0.25e3 / 0.243e3 * t3558;
  t3560 = t1147 * t1161;
  t3561 = t407 * t3560;
  t3562 = 0.35e2 / 0.54e2 * t3561;
  t3563 = t213 * t316;
  t3564 = t408 * t3563;
  t3565 = t407 * t3564;
  t3566 = 0.5e1 / 0.18e2 * t3565;
  t3567 = t63 * t791;
  t3568 = t408 * t3567;
  t3569 = t407 * t3568;
  t3570 = 0.5e1 / 0.72e2 * t3569;
  t3571 = t528 * t189;
  t3572 = t192 * t58;
  t3573 = t3572 * t61;
  t3574 = t3573 * t1651;
  t3575 = t3571 * t3574;
  t3576 = 0.25e2 / 0.162e3 * t3575;
  t3577 = t1147 * t206;
  t3578 = t3577 * t1153;
  t3579 = t407 * t3578;
  t3580 = 0.35e2 / 0.54e2 * t3579;
  t3581 = t62 * t316;
  t3582 = t3581 * t209;
  t3583 = t1151 * t3582;
  t3584 = t407 * t3583;
  t3585 = 0.5e1 / 0.36e2 * t3584;
  t3586 = t1152 * t583;
  t3587 = t1151 * t3586;
  t3588 = t407 * t3587;
  t3589 = 0.5e1 / 0.72e2 * t3588;
  t3590 = t3545 - t3548 - t3551 - t3553 - t3559 + t3562 - t3566 - t3570 + t3576 - t3580 + t3585 + t3589;
  tv3rho2sigma0 = t9 * (t3433 + t3505 + t3543 + t3590) + 0.2e1 * t1180 + 0.2e1 * t1181 - t1191 + t1194 + t1195 - t1196 + t1193 - t1186 - t1187 + t1185 + t1189 + t1190 - t1192 - t1197 + t1184 - t1188;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t3598 = 0.2e3 / 0.243e3 * t1134;
  t3599 = 0.35e2 / 0.27e2 * t1149;
  t3601 = 0.5e1 / 0.9e1 * t1159;
  t3610 = 0.2e2 / 0.27e2 * t1111;
  t3612 = t1202 * t316;
  t3613 = 0.2e1 * t3612;
  t3614 = 0.11e3 / 0.81e2 * t3459;
  t3621 = 0.11e4 / 0.729e3 * t3483;
  t3622 = t3614 + 0.4e3 / 0.243e3 * t3462 + 0.5e3 / 0.81e2 * t3465 - 0.25e2 / 0.81e2 * t3467 - 0.25e4 / 0.729e3 * t3471 - 0.8e4 / 0.729e3 * t3475 + 0.5e3 / 0.243e3 * t3479 - t3621;
  t3623 = t3622 * t146;
  t3624 = 0.35e3 / 0.243e3 * t3402;
  t3625 = 0.5e2 / 0.81e2 * t3406;
  t3626 = 0.25e2 / 0.81e2 * t3409;
  t3627 = 0.25e2 / 0.162e3 * t3412;
  t3628 = 0.5e1 / 0.36e2 * t3414;
  t3629 = 0.2e2 / 0.27e2 * t3416;
  t3630 = 0.2e2 / 0.27e2 * t3418;
  t3631 = 0.5e3 / 0.81e2 * t3421;
  t3632 = 0.11e3 / 0.81e2 * t3425;
  t3633 = 0.5e1 / 0.36e2 * t3427;
  t3634 = t3613 + t3623 - t3624 + t3625 + t3626 + t3627 - t3628 + t3629 + t3630 - t3631 - t3632 - t3633;
  t3635 = 0.5e1 / 0.18e2 * t3429;
  t3636 = 0.1e4 / 0.243e3 * t3435;
  t3637 = 0.5e3 / 0.243e3 * t3439;
  t3638 = 0.1e4 / 0.243e3 * t3442;
  t3639 = 0.5e1 / 0.18e2 * t3446;
  t3640 = 0.8e4 / 0.729e3 * t3451;
  t3641 = 0.25e2 / 0.81e2 * t3456;
  t3642 = t428 * t791;
  t3643 = 0.25e4 / 0.729e3 * t3491;
  t3644 = 0.5e1 / 0.9e1 * t3496;
  t3645 = 0.5e1 / 0.18e2 * t3498;
  t3646 = 0.5e1 / 0.18e2 * t3503;
  t3647 = -t3635 - t3636 - t3637 - t3638 - t3639 + t3640 - t3641 + t3642 + t3643 + t3644 + t3645 - t3646;
  t3649 = 0.5e1 / 0.9e1 * t3507;
  t3650 = 0.595e3 / 0.162e3 * t3511;
  t3651 = 0.7e2 / 0.27e2 * t3514;
  t3652 = 0.2e3 / 0.243e3 * t3517;
  t3653 = 0.2e3 / 0.243e3 * t3521;
  t3654 = 0.11e4 / 0.729e3 * t3525;
  t3655 = 0.35e2 / 0.27e2 * t3527;
  t3656 = 0.25e2 / 0.162e3 * t3530;
  t3657 = 0.25e2 / 0.81e2 * t3533;
  t3658 = 0.25e2 / 0.162e3 * t3537;
  t3659 = 0.5e2 / 0.81e2 * t3539;
  t3660 = 0.5e2 / 0.81e2 * t3541;
  t3661 = -t3649 - t3650 + t3651 - t3652 - t3653 + t3654 + t3655 + t3656 + t3657 + t3658 + t3659 + t3660;
  t3662 = 0.25e2 / 0.81e2 * t3544;
  t3663 = 0.4e3 / 0.243e3 * t3547;
  t3664 = 0.5e1 / 0.36e2 * t3550;
  t3665 = 0.5e1 / 0.18e2 * t3552;
  t3666 = 0.5e3 / 0.243e3 * t3558;
  t3667 = 0.35e2 / 0.27e2 * t3561;
  t3668 = 0.5e1 / 0.9e1 * t3565;
  t3669 = 0.5e1 / 0.36e2 * t3569;
  t3670 = 0.25e2 / 0.81e2 * t3575;
  t3671 = 0.35e2 / 0.27e2 * t3579;
  t3672 = 0.5e1 / 0.18e2 * t3584;
  t3673 = 0.5e1 / 0.36e2 * t3588;
  t3674 = t3662 - t3663 - t3664 - t3665 - t3666 + t3667 - t3668 - t3669 + t3670 - t3671 + t3672 + t3673;
  tv3rho2sigma1 = 0.2e1 * t1203 + 0.2e1 * t1204 - t3598 + t3599 + 0.5e1 / 0.18e2 * t1155 - t3601 + 0.25e2 / 0.81e2 * t1145 - 0.5e1 / 0.18e2 * t1116 - 0.5e1 / 0.18e2 * t1118 + 0.5e2 / 0.81e2 * t1114 + 0.25e2 / 0.81e2 * t1126 + 0.25e2 / 0.81e2 * t1130 - 0.5e1 / 0.18e2 * t1137 - 0.5e1 / 0.18e2 * t1163 + t3610 - 0.1e4 / 0.243e3 * t1123 + t9 * (t3634 + t3647 + t3661 + t3674);

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  tv3rho2sigma2 = tv3rho2sigma0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t3678 = -t1124 + t1246 + t1194 - t1164 + t1180 + t1208 + t1219 + t1223 - t1226 - t1237 + t1233 + t1115 + t1127 + t1131;
  t3679 = t420 * t951;
  t3680 = t3400 * t355;
  t3681 = t1141 * t3680;
  t3683 = t3404 * t355;
  t3684 = t1141 * t3683;
  t3686 = t3448 * t350;
  t3687 = t147 * t3686;
  t3688 = t543 * t3687;
  t3690 = t400 * t908;
  t3692 = t400 * t953;
  t3694 = t400 * t893;
  t3696 = t400 * t897;
  t3698 = t1110 * t366;
  t3700 = t1110 * t384;
  t3702 = t1179 * t382;
  t3703 = t1120 * t841;
  t3704 = t147 * t3703;
  t3705 = t543 * t3704;
  t3707 = t365 * t1121;
  t3708 = t543 * t3707;
  t3710 = t383 * t1121;
  t3711 = t543 * t3710;
  t3713 = t3420 * t855;
  t3715 = t217 * t1213;
  t3716 = t543 * t3715;
  t3718 = t317 * t1213;
  t3719 = t543 * t3718;
  t3722 = t3461 * t391;
  t3724 = t3464 * t963;
  t3726 = t1168 * t967;
  t3729 = t1240 * t180 * t50;
  t3730 = t2535 * t3729;
  t3732 = t177 * t350;
  t3733 = t806 * t3732;
  t3734 = t805 * t3733;
  t3736 = t35 * t841;
  t3737 = t806 * t3736;
  t3738 = t805 * t3737;
  t3741 = t3460 + 0.1e3 / 0.243e3 * t3462 + 0.1e3 / 0.243e3 * t3722 + 0.25e3 / 0.81e2 * t3724 - 0.25e2 / 0.162e3 * t3726 - 0.125e4 / 0.729e3 * t3730 - 0.2e4 / 0.729e3 * t3734 + 0.25e3 / 0.243e3 * t3738 - 0.2e4 / 0.729e3 * t3475 - t3484;
  t3742 = t3741 * t146;
  t3743 = t3679 - 0.175e3 / 0.486e3 * t3681 + 0.25e2 / 0.162e3 * t3684 + 0.2e4 / 0.729e3 * t3688 - 0.5e1 / 0.72e2 * t3690 - 0.5e1 / 0.72e2 * t3692 - 0.5e1 / 0.72e2 * t3694 - 0.5e1 / 0.72e2 * t3696 + 0.5e1 / 0.27e2 * t3698 + 0.5e1 / 0.27e2 * t3700 + t3702 - 0.25e3 / 0.243e3 * t3705 - 0.25e3 / 0.243e3 * t3708 - 0.25e3 / 0.243e3 * t3711 - 0.25e3 / 0.81e2 * t3713 - 0.25e3 / 0.243e3 * t3716 - 0.25e3 / 0.243e3 * t3719 + t3742;
  t3744 = t1244 * t316;
  t3749 = t1224 * t1158;
  t3751 = t3546 * t356;
  t3754 = t190 * t871 * t1132;
  t3756 = t902 * t177;
  t3758 = t190 * t193 * t3756;
  t3761 = t190 * t2586 * t403;
  t3764 = t190 * t871 * t1128;
  t3767 = t190 * t549 * t1220;
  t3769 = t2569 * t35;
  t3771 = t190 * t193 * t3769;
  t3773 = t1113 * t858;
  t3775 = t1113 * t862;
  t3777 = t1113 * t866;
  t3779 = t1113 * t872;
  t3781 = t3744 - 0.175e3 / 0.486e3 * t3402 - 0.25e2 / 0.162e3 * t3406 + 0.5e1 / 0.27e2 * t3416 + 0.5e1 / 0.27e2 * t3418 - t3426 - 0.5e1 / 0.36e2 * t3749 - 0.1e3 / 0.243e3 * t3751 - 0.5e2 / 0.243e3 * t3754 - 0.5e2 / 0.243e3 * t3758 + 0.25e2 / 0.324e3 * t3761 + 0.25e2 / 0.324e3 * t3764 + 0.25e2 / 0.324e3 * t3767 + 0.25e2 / 0.324e3 * t3771 + 0.25e2 / 0.162e3 * t3773 + 0.25e2 / 0.162e3 * t3775 + 0.25e2 / 0.162e3 * t3777 + 0.25e2 / 0.162e3 * t3779;
  t3783 = t1147 * t1234;
  t3784 = t407 * t3783;
  t3786 = t213 * t382;
  t3787 = t408 * t3786;
  t3788 = t407 * t3787;
  t3790 = t1224 * t1148;
  t3792 = t1136 * t1235;
  t3794 = t63 * t951;
  t3795 = t408 * t3794;
  t3796 = t407 * t3795;
  t3798 = t842 * t50;
  t3799 = t3798 * t410;
  t3801 = t1224 * t1162;
  t3803 = t1113 * t904;
  t3806 = t1143 * t865;
  t3807 = t1141 * t3806;
  t3809 = t1514 * t209;
  t3810 = t1338 * t3809;
  t3811 = t154 * t3810;
  t3813 = t1143 * t903;
  t3814 = t1141 * t3813;
  t3816 = t351 * t185;
  t3817 = t3816 * t1140;
  t3818 = t3817 * t1144;
  t3821 = t1141 * t1143 * t861;
  t3823 = t3577 * t1230;
  t3824 = t407 * t3823;
  t3826 = t3493 * t360;
  t3827 = t1151 * t3826;
  t3828 = t407 * t3827;
  t3830 = t1152 * t886;
  t3831 = t1151 * t3830;
  t3832 = t407 * t3831;
  t3834 = 0.35e2 / 0.108e3 * t3784 - 0.5e1 / 0.36e2 * t3788 + 0.35e2 / 0.108e3 * t3790 - 0.5e1 / 0.72e2 * t3792 - 0.5e1 / 0.72e2 * t3796 - 0.5e1 / 0.72e2 * t3799 - 0.5e1 / 0.72e2 * t3801 + 0.25e2 / 0.162e3 * t3803 + t3447 + 0.2e4 / 0.729e3 * t3451 + 0.25e2 / 0.324e3 * t3807 - 0.5e1 / 0.36e2 * t3811 + 0.25e2 / 0.324e3 * t3814 + 0.25e2 / 0.162e3 * t3818 + 0.25e2 / 0.324e3 * t3821 - 0.35e2 / 0.108e3 * t3824 + 0.5e1 / 0.36e2 * t3828 + 0.5e1 / 0.72e2 * t3832;
  t3835 = t62 * t382;
  t3836 = t3835 * t209;
  t3837 = t1151 * t3836;
  t3838 = t407 * t3837;
  t3840 = t1224 * t1154;
  t3842 = t409 * t854;
  t3843 = t3555 * t3842;
  t3845 = t1136 * t1231;
  t3847 = t3581 * t360;
  t3848 = t1151 * t3847;
  t3849 = t407 * t3848;
  t3851 = t3488 * t350;
  t3853 = t180 * t40 * t152;
  t3854 = t3851 * t3853;
  t3855 = t2556 * t3854;
  t3857 = t350 * t209;
  t3858 = t194 * t3857;
  t3859 = t1354 * t3858;
  t3860 = t1141 * t3859;
  t3862 = t1514 * t326;
  t3863 = t1354 * t3862;
  t3864 = t1141 * t3863;
  t3875 = 0.5e1 / 0.72e2 * t3838 + 0.5e1 / 0.72e2 * t3840 - 0.25e3 / 0.243e3 * t3843 + 0.5e1 / 0.72e2 * t3845 + 0.5e1 / 0.72e2 * t3849 + 0.125e4 / 0.729e3 * t3855 - 0.25e2 / 0.324e3 * t3860 - 0.25e2 / 0.324e3 * t3864 - 0.5e1 / 0.36e2 * t3496 + 0.5e1 / 0.36e2 * t3507 - t3512 - 0.5e2 / 0.243e3 * t3517 - 0.5e2 / 0.243e3 * t3521 + t3526 + 0.35e2 / 0.108e3 * t3527 - 0.1e3 / 0.243e3 * t3547 + 0.35e2 / 0.108e3 * t3561 + 0.5e1 / 0.36e2 * t3565 - 0.35e2 / 0.108e3 * t3579;
  t3879 = -t1191 - t1138 + t1181 - t1210 - t1212 + t1245 + t1184 - t1117 - t1119 + t1156 + t1146 + t1229 - t1216 + t9 * (t3743 + t3781 + t3834 + t3875);
  tv3rho2sigma3 = t3678 + t3879;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  t3880 = -t1188 + t3599 - t1197 + t1263 + t1249 + t1253 + t1254 - t1255 - t1258 + t1257 + t1185 + t1189 + t1190 - t3598;
  t3881 = t1202 * t382;
  t3882 = 0.175e3 / 0.243e3 * t3681;
  t3883 = 0.25e2 / 0.81e2 * t3684;
  t3884 = 0.4e4 / 0.729e3 * t3688;
  t3885 = 0.5e1 / 0.36e2 * t3690;
  t3886 = 0.5e1 / 0.36e2 * t3692;
  t3887 = 0.5e1 / 0.36e2 * t3694;
  t3888 = 0.5e1 / 0.36e2 * t3696;
  t3889 = 0.1e2 / 0.27e2 * t3698;
  t3890 = 0.1e2 / 0.27e2 * t3700;
  t3891 = t428 * t951;
  t3892 = 0.5e3 / 0.243e3 * t3705;
  t3893 = 0.5e3 / 0.243e3 * t3708;
  t3894 = 0.5e3 / 0.243e3 * t3711;
  t3895 = 0.5e3 / 0.81e2 * t3713;
  t3896 = 0.5e3 / 0.243e3 * t3716;
  t3897 = 0.5e3 / 0.243e3 * t3719;
  t3898 = t3881 - t3882 + t3883 + t3884 - t3885 - t3886 - t3887 - t3888 + t3889 + t3890 + t3891 - t3892 - t3893 - t3894 - t3895 - t3896 - t3897 - t3403;
  t3899 = t1261 * t316;
  t3900 = 0.5e1 / 0.18e2 * t3749;
  t3901 = 0.2e3 / 0.243e3 * t3751;
  t3902 = 0.1e3 / 0.243e3 * t3754;
  t3903 = 0.1e3 / 0.243e3 * t3758;
  t3904 = 0.25e2 / 0.162e3 * t3761;
  t3905 = 0.25e2 / 0.162e3 * t3764;
  t3906 = 0.25e2 / 0.162e3 * t3767;
  t3907 = 0.25e2 / 0.162e3 * t3771;
  t3908 = 0.25e2 / 0.81e2 * t3773;
  t3909 = 0.25e2 / 0.81e2 * t3775;
  t3910 = 0.25e2 / 0.81e2 * t3777;
  t3911 = 0.25e2 / 0.81e2 * t3779;
  t3912 = 0.35e2 / 0.54e2 * t3784;
  t3913 = -t3407 + t3417 + t3419 - t3632 + t3899 - t3900 - t3901 - t3902 - t3903 + t3904 + t3905 + t3906 + t3907 + t3908 + t3909 + t3910 + t3911 + t3912;
  t3915 = 0.5e1 / 0.18e2 * t3788;
  t3916 = 0.35e2 / 0.54e2 * t3790;
  t3917 = 0.5e1 / 0.36e2 * t3792;
  t3918 = 0.5e1 / 0.36e2 * t3796;
  t3919 = 0.5e1 / 0.36e2 * t3799;
  t3920 = 0.5e1 / 0.36e2 * t3801;
  t3921 = 0.25e2 / 0.81e2 * t3803;
  t3922 = 0.2e3 / 0.243e3 * t3722;
  t3926 = 0.4e4 / 0.729e3 * t3734;
  t3928 = t3614 + t3463 + t3922 + 0.5e3 / 0.81e2 * t3724 - 0.25e2 / 0.81e2 * t3726 - 0.25e4 / 0.729e3 * t3730 - t3926 + 0.5e3 / 0.243e3 * t3738 - t3476 - t3621;
  t3929 = t3928 * t146;
  t3930 = 0.25e2 / 0.162e3 * t3807;
  t3931 = 0.5e1 / 0.18e2 * t3811;
  t3932 = 0.25e2 / 0.162e3 * t3814;
  t3933 = 0.25e2 / 0.81e2 * t3818;
  t3934 = 0.25e2 / 0.162e3 * t3821;
  t3935 = 0.35e2 / 0.54e2 * t3824;
  t3936 = 0.5e1 / 0.18e2 * t3828;
  t3937 = 0.5e1 / 0.36e2 * t3832;
  t3938 = -t3915 + t3916 - t3917 - t3918 - t3919 - t3920 + t3921 + t3929 + t3639 + t3452 + t3930 - t3931 + t3932 + t3933 + t3934 - t3935 + t3936 + t3937;
  t3939 = 0.5e1 / 0.36e2 * t3838;
  t3940 = 0.5e1 / 0.36e2 * t3840;
  t3941 = 0.5e3 / 0.243e3 * t3843;
  t3942 = 0.5e1 / 0.36e2 * t3845;
  t3943 = 0.5e1 / 0.36e2 * t3849;
  t3944 = 0.25e4 / 0.729e3 * t3855;
  t3945 = 0.25e2 / 0.162e3 * t3860;
  t3946 = 0.25e2 / 0.162e3 * t3864;
  t3947 = t3939 + t3940 - t3941 + t3942 + t3943 + t3944 - t3945 - t3946 - t3497 + t3508 - t3650 - t3518 - t3522 + t3654 + t3528 - t3548 + t3562 + t3566 - t3580;
  t3951 = -t1192 + t1262 - t1250 - t1251 + t1203 + t3610 - t1186 - t1187 + t9 * (t3898 + t3913 + t3938 + t3947) + t1195 + t1204 + t1193 + t1256 - t1252;
  tv3rho2sigma4 = t3880 + t3951;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  tv3rho2sigma5 = tv3rho2sigma3;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t3952 = t1008 * t50;
  t3953 = t3952 * t410;
  t3954 = 0.5e1 / 0.72e2 * t3953;
  t3955 = t1224 * t1235;
  t3956 = 0.5e1 / 0.36e2 * t3955;
  t3957 = t1295 * t1012;
  t3958 = t63 * t3957;
  t3959 = t3555 * t3958;
  t3960 = 0.25e3 / 0.243e3 * t3959;
  t3961 = t63 * t1084;
  t3962 = t408 * t3961;
  t3963 = t407 * t3962;
  t3964 = 0.5e1 / 0.72e2 * t3963;
  t3965 = t871 * t1220;
  t3966 = t190 * t3965;
  t3967 = 0.25e2 / 0.162e3 * t3966;
  t3968 = t3123 * t35;
  t3969 = t193 * t3968;
  t3970 = t190 * t3969;
  t3971 = 0.25e2 / 0.324e3 * t3970;
  t3972 = t3132 * t403;
  t3973 = t190 * t3972;
  t3974 = 0.25e2 / 0.324e3 * t3973;
  t3975 = t1113 * t1025;
  t3976 = 0.25e2 / 0.81e2 * t3975;
  t3977 = t1113 * t1029;
  t3978 = 0.25e2 / 0.81e2 * t3977;
  t3979 = -t3954 - t3956 - t3960 - t3964 + t3967 + t3971 + t3974 + t3976 + t3978 - t3882 - t3883 + t3884;
  t3980 = t365 * t1213;
  t3981 = t543 * t3980;
  t3982 = 0.5e3 / 0.243e3 * t3981;
  t3983 = t383 * t1213;
  t3984 = t543 * t3983;
  t3985 = 0.5e3 / 0.243e3 * t3984;
  t3986 = t1120 * t1007;
  t3987 = t147 * t3986;
  t3988 = t543 * t3987;
  t3989 = 0.25e3 / 0.243e3 * t3988;
  t3990 = t420 * t1084;
  t3991 = t1152 * t1037;
  t3992 = t3500 * t3991;
  t3993 = t407 * t3992;
  t3994 = 0.5e1 / 0.36e2 * t3993;
  t3995 = t1224 * t1231;
  t3996 = 0.5e1 / 0.36e2 * t3995;
  t3997 = t1013 * t189;
  t3998 = t3997 * t3574;
  t3999 = 0.25e2 / 0.162e3 * t3998;
  t4000 = t3835 * t360;
  t4001 = t1151 * t4000;
  t4002 = t407 * t4001;
  t4003 = 0.5e1 / 0.36e2 * t4002;
  t4004 = t1152 * t1042;
  t4005 = t1151 * t4004;
  t4006 = t407 * t4005;
  t4007 = 0.5e1 / 0.72e2 * t4006;
  t4008 = -t3982 - t3985 - t3989 + t3889 + t3890 + t3990 - t3426 - t3994 + t3996 + t3999 + t4003 + t4007;
  t4010 = t1113 * t1033;
  t4011 = 0.25e2 / 0.162e3 * t4010;
  t4012 = t400 * t1086;
  t4013 = 0.5e1 / 0.72e2 * t4012;
  t4014 = t350 * t360;
  t4015 = t194 * t4014;
  t4016 = t1354 * t4015;
  t4017 = t1141 * t4016;
  t4018 = 0.25e2 / 0.162e3 * t4017;
  t4019 = t4011 - t4013 + t3900 - t3901 - t3902 - t3903 + t3912 + t3915 + t3916 - t3447 - t4018 - t3935;
  t4021 = t1141 * t1143 * t1032;
  t4022 = 0.25e2 / 0.324e3 * t4021;
  t4024 = t3488 * t1012 * t50;
  t4025 = t2556 * t4024;
  t4026 = 0.125e4 / 0.729e3 * t4025;
  t4028 = t1141 * t1143 * t1028;
  t4029 = 0.25e2 / 0.162e3 * t4028;
  t4030 = t3420 * t1022;
  t4031 = 0.25e3 / 0.81e2 * t4030;
  t4032 = t400 * t1048;
  t4033 = 0.5e1 / 0.72e2 * t4032;
  t4034 = t400 * t1052;
  t4035 = 0.5e1 / 0.36e2 * t4034;
  t4036 = t1244 * t382;
  t4037 = 0.2e1 * t4036;
  t4038 = t3464 * t1095;
  t4040 = t1168 * t1099;
  t4042 = t35 * t1012;
  t4044 = t2535 * t4042 * t50;
  t4046 = t35 * t1007;
  t4047 = t806 * t4046;
  t4048 = t805 * t4047;
  t4050 = t3460 + t3922 + 0.25e3 / 0.81e2 * t4038 - 0.25e2 / 0.162e3 * t4040 - 0.125e4 / 0.729e3 * t4044 - t3926 + 0.25e3 / 0.243e3 * t4048 - t3484;
  t4051 = t4050 * t146;
  t4052 = -t3936 + t4022 + t4026 + t4029 - t4031 - t4033 - t4035 + t4037 + t4051 - t3512 - t3515 + t3526;
  tv3rho2sigma6 = t9 * (t3979 + t4008 + t4019 + t4052) + 0.2e1 * t1245 + 0.2e1 * t1246 + t1257 - t1191 + t1194 + t1196 + t1256 - t1250 - t1251 + t1249 + t1253 + t1254 - t1255 - t1258 - t1252 + t1184;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  t4070 = 0.5e1 / 0.36e2 * t3953;
  t4071 = 0.5e1 / 0.18e2 * t3955;
  t4072 = 0.5e3 / 0.243e3 * t3959;
  t4073 = 0.5e1 / 0.36e2 * t3963;
  t4074 = 0.25e2 / 0.81e2 * t3966;
  t4075 = 0.25e2 / 0.162e3 * t3970;
  t4076 = 0.25e2 / 0.162e3 * t3973;
  t4077 = 0.5e2 / 0.81e2 * t3975;
  t4078 = 0.5e2 / 0.81e2 * t3977;
  t4079 = 0.35e3 / 0.243e3 * t3681;
  t4080 = 0.5e2 / 0.81e2 * t3684;
  t4081 = 0.8e4 / 0.729e3 * t3688;
  t4082 = -t4070 - t4071 - t4072 - t4073 + t4074 + t4075 + t4076 + t4077 + t4078 - t4079 - t4080 + t4081;
  t4083 = 0.1e4 / 0.243e3 * t3981;
  t4084 = 0.1e4 / 0.243e3 * t3984;
  t4085 = 0.5e3 / 0.243e3 * t3988;
  t4086 = 0.2e2 / 0.27e2 * t3698;
  t4087 = 0.2e2 / 0.27e2 * t3700;
  t4088 = 0.5e1 / 0.18e2 * t3993;
  t4089 = 0.5e1 / 0.18e2 * t3995;
  t4090 = 0.25e2 / 0.81e2 * t3998;
  t4091 = 0.5e1 / 0.18e2 * t4002;
  t4092 = 0.5e1 / 0.36e2 * t4006;
  t4093 = 0.25e2 / 0.81e2 * t4010;
  t4094 = -t4083 - t4084 - t4085 + t4086 + t4087 - t3632 - t4088 + t4089 + t4090 + t4091 + t4092 + t4093;
  t4096 = 0.5e1 / 0.36e2 * t4012;
  t4097 = 0.5e1 / 0.9e1 * t3749;
  t4098 = 0.4e3 / 0.243e3 * t3751;
  t4099 = 0.2e3 / 0.243e3 * t3754;
  t4100 = 0.2e3 / 0.243e3 * t3758;
  t4101 = 0.35e2 / 0.27e2 * t3784;
  t4102 = 0.5e1 / 0.9e1 * t3788;
  t4103 = 0.35e2 / 0.27e2 * t3790;
  t4104 = 0.25e2 / 0.81e2 * t4017;
  t4105 = 0.35e2 / 0.27e2 * t3824;
  t4106 = 0.5e1 / 0.9e1 * t3828;
  t4107 = -t4096 + t4097 - t4098 - t4099 - t4100 + t4101 + t4102 + t4103 - t3639 - t4104 - t4105 - t4106;
  t4108 = t1261 * t382;
  t4109 = 0.2e1 * t4108;
  t4116 = t3614 + 0.4e3 / 0.243e3 * t3722 + 0.5e3 / 0.81e2 * t4038 - 0.25e2 / 0.81e2 * t4040 - 0.25e4 / 0.729e3 * t4044 - 0.8e4 / 0.729e3 * t3734 + 0.5e3 / 0.243e3 * t4048 - t3621;
  t4117 = t4116 * t146;
  t4118 = 0.25e2 / 0.162e3 * t4021;
  t4119 = 0.25e4 / 0.729e3 * t4025;
  t4120 = 0.25e2 / 0.81e2 * t4028;
  t4121 = 0.5e3 / 0.81e2 * t4030;
  t4122 = 0.5e1 / 0.36e2 * t4032;
  t4123 = 0.5e1 / 0.18e2 * t4034;
  t4124 = t428 * t1084;
  t4125 = t4109 + t4117 + t4118 + t4119 + t4120 - t4121 - t4122 - t4123 + t4124 - t3650 - t3651 + t3654;
  tv3rho2sigma7 = 0.2e1 * t1262 + 0.2e1 * t1263 + 0.5e1 / 0.18e2 * t1232 - t3598 + t3599 + t3601 + 0.25e2 / 0.81e2 * t1228 - 0.5e1 / 0.18e2 * t1209 - 0.5e1 / 0.18e2 * t1211 + 0.5e2 / 0.81e2 * t1207 + 0.25e2 / 0.81e2 * t1218 + 0.25e2 / 0.81e2 * t1222 - 0.5e1 / 0.18e2 * t1225 - 0.5e1 / 0.18e2 * t1236 - 0.1e4 / 0.243e3 * t1215 + t3610 + t9 * (t4082 + t4094 + t4107 + t4125);

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  tv3rho2sigma8 = tv3rho2sigma6;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t4129 = t207 * t1314;
  t4130 = t180 * t167;
  t4131 = t194 * t4130;
  t4132 = t4129 * t4131;
  t4133 = t1838 * t4132;
  t4134 = 0.125e3 / 0.486e3 * t4133;
  t4135 = t574 * t1296;
  t4136 = t4135 * t3454;
  t4137 = t1838 * t4136;
  t4138 = 0.25e2 / 0.81e2 * t4137;
  t4139 = t1324 * t8;
  t4140 = t4139 * t1356;
  t4141 = t1336 * t4140;
  t4142 = 0.25e2 / 0.54e2 * t4141;
  t4143 = t321 * t1335;
  t4144 = t4143 * t1357;
  t4145 = 0.25e2 / 0.108e3 * t4144;
  t4146 = t799 * t1322;
  t4147 = t1354 * t1695;
  t4148 = t4146 * t4147;
  t4149 = 0.25e2 / 0.162e3 * t4148;
  t4150 = t201 * t573;
  t4151 = t4150 * t62;
  t4152 = t4151 * t1340;
  t4153 = t1336 * t4152;
  t4154 = 0.35e2 / 0.27e2 * t4153;
  t4155 = t201 * t206;
  t4156 = t4155 * t62;
  t4157 = t4156 * t1356;
  t4158 = t1336 * t4157;
  t4159 = 0.175e3 / 0.162e3 * t4158;
  t4160 = t316 * t209;
  t4161 = t1296 * t4160;
  t4162 = t1338 * t4161;
  t4163 = t1336 * t4162;
  t4164 = 0.5e1 / 0.18e2 * t4163;
  t4165 = t4143 * t1341;
  t4166 = 0.5e1 / 0.18e2 * t4165;
  t4167 = t6 * t501;
  t4168 = t146 * t502;
  t4169 = t4167 * t4168;
  t4170 = t1354 * t4169;
  t4171 = t1336 * t4170;
  t4172 = 0.25e2 / 0.324e3 * t4171;
  t4173 = t58 * t2378;
  t4174 = t4173 * t62;
  t4175 = t146 * t575;
  t4176 = t1296 * t4175;
  t4177 = t4174 * t4176;
  t4178 = t1336 * t4177;
  t4179 = 0.5e1 / 0.12e2 * t4178;
  t4180 = t549 * t316;
  t4181 = t4180 * t441;
  t4182 = t190 * t4181;
  t4183 = 0.1e3 / 0.81e2 * t4182;
  t4184 = t193 * t791;
  t4185 = t4184 * t441;
  t4186 = t190 * t4185;
  t4187 = 0.5e2 / 0.81e2 * t4186;
  t4188 = t325 * t216;
  t4189 = t4188 * t195;
  t4190 = t1279 * t4189;
  t4191 = 0.2e3 / 0.81e2 * t4190;
  t4192 = t1280 * t554;
  t4193 = t1279 * t4192;
  t4194 = 0.2e3 / 0.81e2 * t4193;
  t4195 = t1280 * t558;
  t4196 = t1279 * t4195;
  t4197 = 0.1e3 / 0.81e2 * t4196;
  t4198 = t160 * t15;
  t4199 = t4198 * t1355;
  t4200 = t1354 * t4199;
  t4201 = t1336 * t4200;
  t4202 = 0.125e3 / 0.324e3 * t4201;
  t4203 = t316 * t167;
  t4204 = t1314 * t4203;
  t4205 = t1354 * t4204;
  t4206 = t1336 * t4205;
  t4207 = 0.25e2 / 0.108e3 * t4206;
  t4208 = t146 * t508;
  t4209 = t1314 * t4208;
  t4210 = t1354 * t4209;
  t4211 = t1336 * t4210;
  t4212 = 0.25e2 / 0.216e3 * t4211;
  t4213 = -t4134 + t4138 + t4142 + t4145 - t4149 + t4154 - t4159 - t4164 - t4166 + t4172 + t4179 - t4183 - t4187 - t4191 - t4194 - t4197 - t4202 + t4207 + t4212;
  t4214 = t146 * t583;
  t4215 = t1296 * t4214;
  t4216 = t1338 * t4215;
  t4217 = t1336 * t4216;
  t4218 = 0.5e1 / 0.36e2 * t4217;
  t4219 = t2 * t495;
  t4220 = t4219 * t432;
  t4221 = t4220 * t436;
  t4222 = 0.2e3 / 0.81e2 * t4221;
  t4223 = t1389 * t316;
  t4224 = 0.2e1 * t4223;
  t4225 = t8 * t160;
  t4226 = t4225 * t447;
  t4227 = t445 * t4226;
  t4228 = t154 * t4227;
  t4229 = 0.25e2 / 0.54e2 * t4228;
  t4230 = t62 * t495;
  t4231 = t4230 * t447;
  t4232 = t445 * t4231;
  t4233 = t154 * t4232;
  t4234 = 0.25e2 / 0.81e2 * t4233;
  t4235 = t322 * t1351;
  t4236 = 0.25e2 / 0.108e3 * t4235;
  t4237 = t565 * t206;
  t4238 = t4237 * t448;
  t4239 = t154 * t4238;
  t4240 = 0.595e3 / 0.324e3 * t4239;
  t4241 = t1330 * t1345;
  t4242 = t154 * t4241;
  t4243 = 0.35e2 / 0.27e2 * t4242;
  t4244 = t1330 * t1350;
  t4245 = t154 * t4244;
  t4246 = 0.175e3 / 0.162e3 * t4245;
  t4247 = t1337 * t446;
  t4248 = t15 * t146;
  t4249 = t209 * t167;
  t4250 = t4248 * t4249;
  t4251 = t4247 * t4250;
  t4252 = t1336 * t4251;
  t4253 = 0.25e2 / 0.54e2 * t4252;
  t4254 = t1360 * t326;
  t4255 = t1325 * t4254;
  t4256 = t1323 * t4255;
  t4257 = 0.25e2 / 0.162e3 * t4256;
  t4258 = t447 * t810;
  t4259 = t1325 * t4258;
  t4260 = t1323 * t4259;
  t4261 = 0.25e2 / 0.324e3 * t4260;
  t4262 = t160 * t16;
  t4263 = t4262 * t180;
  t4264 = t1295 * t4263;
  t4265 = t1294 * t4264;
  t4266 = 0.2e5 / 0.729e3 * t4265;
  t4267 = t501 * t40;
  t4268 = t4267 * t44;
  t4269 = t431 * t4268;
  t4271 = t55 * t147 * t502;
  t4272 = t4269 * t4271;
  t4273 = 0.5e2 / 0.81e2 * t4272;
  t4274 = t4155 * t446;
  t4275 = t4274 * t1326;
  t4276 = t1323 * t4275;
  t4277 = 0.175e3 / 0.243e3 * t4276;
  t4278 = t1324 * t1344;
  t4279 = t4278 * t1326;
  t4280 = t1323 * t4279;
  t4281 = 0.25e2 / 0.81e2 * t4280;
  t4282 = t1324 * t1349;
  t4283 = t4282 * t1326;
  t4284 = t1323 * t4283;
  t4285 = 0.125e3 / 0.486e3 * t4284;
  t4286 = t1266 * t1278;
  t4287 = t4286 * t1281;
  t4288 = 0.1e4 / 0.243e3 * t4287;
  t4289 = t1266 * t1271;
  t4290 = t4289 * t1274;
  t4291 = 0.25e3 / 0.81e2 * t4290;
  t4292 = -t4218 + t4222 + t4224 - t4229 + t4234 - t4236 + t4240 - t4243 + t4246 - t4253 - t4257 - t4261 - t4266 + t4273 + t4277 - t4281 + t4285 + t4288 - t4291;
  t4295 = t55 * t217 * t167;
  t4296 = t1272 * t4295;
  t4297 = 0.5e2 / 0.27e2 * t4296;
  t4299 = t55 * t317 * t167;
  t4300 = t1272 * t4299;
  t4301 = 0.5e2 / 0.27e2 * t4300;
  t4303 = t55 * t147 * t508;
  t4304 = t1272 * t4303;
  t4305 = 0.25e2 / 0.27e2 * t4304;
  t4306 = t542 * t216;
  t4307 = t39 * t4306;
  t4308 = t4307 * t1298;
  t4309 = 0.4e4 / 0.243e3 * t4308;
  t4310 = t316 * t544;
  t4311 = t4310 * t1297;
  t4312 = t1294 * t4311;
  t4313 = 0.4e4 / 0.243e3 * t4312;
  t4314 = t1296 * t522;
  t4315 = t1295 * t4314;
  t4316 = t1294 * t4315;
  t4317 = 0.2e4 / 0.243e3 * t4316;
  t4318 = t459 * t791;
  t4320 = params->c * t495 * t16;
  t4321 = t439 * t4320;
  t4322 = t190 * t4321;
  t4323 = 0.2e4 / 0.729e3 * t4322;
  t4324 = t1301 * t1310;
  t4325 = t190 * t4324;
  t4326 = 0.5e3 / 0.243e3 * t4325;
  t4327 = t1305 * t1310;
  t4328 = t190 * t4327;
  t4329 = 0.5e3 / 0.243e3 * t4328;
  t4330 = t1295 * t6;
  t4331 = t15 * t180;
  t4332 = t4331 * t167;
  t4333 = t4330 * t4332;
  t4334 = t1294 * t4333;
  t4335 = 0.2e5 / 0.729e3 * t4334;
  t4336 = t2337 * t146;
  t4337 = t4336 * t441;
  t4338 = t190 * t4337;
  t4339 = 0.5e2 / 0.81e2 * t4338;
  t4340 = t1337 * t8;
  t4341 = t4340 * t1340;
  t4342 = t1336 * t4341;
  t4343 = 0.5e1 / 0.9e1 * t4342;
  t4344 = t4262 * t1339;
  t4345 = t1338 * t4344;
  t4346 = t1336 * t4345;
  t4347 = 0.25e2 / 0.54e2 * t4346;
  t4349 = t152 * t434 * t791;
  t4350 = t433 * t4349;
  t4351 = 0.5e1 / 0.9e1 * t4350;
  t4352 = t1267 * t1286;
  t4353 = 0.5e2 / 0.27e2 * t4352;
  t4354 = t1267 * t1290;
  t4355 = 0.5e2 / 0.27e2 * t4354;
  t4356 = t16 * t539;
  t4357 = t431 * t4356;
  t4358 = t2325 * t3556;
  t4359 = t4357 * t4358;
  t4360 = 0.2e4 / 0.81e2 * t4359;
  t4361 = t54 * t589;
  t4363 = t152 * t4361 * t146;
  t4364 = t433 * t4363;
  t4365 = 0.5e1 / 0.9e1 * t4364;
  t4366 = t4297 + t4301 + t4305 + t4309 + t4313 + t4317 + t4318 - t4323 + t4326 + t4329 + t4335 - t4339 - t4343 + t4347 + t4351 - t4353 - t4355 + t4360 + t4365;
  t4368 = t152 * t1284 * t316;
  t4369 = t433 * t4368;
  t4370 = 0.1e2 / 0.9e1 * t4369;
  t4371 = t445 * t1703;
  t4372 = t154 * t4371;
  t4373 = 0.5e1 / 0.36e2 * t4372;
  t4374 = t4167 * t502;
  t4375 = t530 * t4374;
  t4376 = t1141 * t4375;
  t4377 = 0.5e3 / 0.729e3 * t4376;
  t4378 = t4198 * t167;
  t4380 = t1141 * t530 * t4378;
  t4381 = 0.25e4 / 0.729e3 * t4380;
  t4382 = t1314 * t508;
  t4384 = t1141 * t530 * t4382;
  t4385 = 0.25e3 / 0.243e3 * t4384;
  t4387 = t1141 * t1980 * t1315;
  t4388 = 0.5e3 / 0.243e3 * t4387;
  t4390 = t1141 * t1984 * t1315;
  t4391 = 0.5e3 / 0.243e3 * t4390;
  t4392 = t431 * t15;
  t4393 = t4392 * t189;
  t4394 = t167 * params->c;
  t4395 = t4394 * t180;
  t4396 = t439 * t4395;
  t4397 = t4393 * t4396;
  t4398 = 0.1e4 / 0.243e3 * t4397;
  t4399 = t542 * t545;
  t4402 = t801 * t4382;
  t4406 = t15 * t185 * t187;
  t4407 = t431 * t4406;
  t4408 = t325 * t4395;
  t4411 = t325 * t4320;
  t4421 = t1296 * t527 * t50;
  t4424 = t544 * t160;
  t4428 = t1378 * t4332;
  t4431 = t1266 * t1277;
  t4434 = t431 * t4267;
  t4436 = t152 * t54 * t502;
  t4440 = t800 * t801 * t522;
  t4446 = t1266 * t1270;
  t4450 = t152 * t54 * t508;
  t4453 = t16 * t522;
  t4457 = -0.2e4 / 0.81e2 * t452 * t4399 + 0.25e3 / 0.243e3 * t190 * t4402 + 0.1e4 / 0.243e3 * t4407 * t4408 + 0.2e4 / 0.729e3 * t324 * t4411 - 0.25e4 / 0.729e3 * t190 * t801 * t4378 + 0.5e3 / 0.729e3 * t190 * t801 * t4374 + 0.1e5 / 0.729e3 * t2535 * t4421 + 0.2e5 / 0.729e3 * t543 * t4424 * t1379 - 0.2e5 / 0.729e3 * t543 * t4428 - 0.1e4 / 0.243e3 * t4431 * t1375 - 0.5e2 / 0.81e2 * t4434 * t4436 + 0.1e3 / 0.81e2 * t1373 * t4440 - 0.2e3 / 0.81e2 * t4219 * t16 * t453 + 0.25e3 / 0.81e2 * t4446 * t1370 - 0.25e2 / 0.27e2 * t1368 * t4450 - 0.2e4 / 0.243e3 * t543 * t1378 * t4453;
  t4458 = t4457 * t146;
  t4459 = t322 * t1331;
  t4460 = 0.35e2 / 0.54e2 * t4459;
  t4461 = t322 * t1346;
  t4462 = 0.5e1 / 0.18e2 * t4461;
  t4463 = t1344 * t1360;
  t4464 = t445 * t4463;
  t4465 = t154 * t4464;
  t4466 = 0.5e1 / 0.18e2 * t4465;
  t4467 = t1349 * t1360;
  t4468 = t445 * t4467;
  t4469 = t154 * t4468;
  t4470 = 0.25e2 / 0.108e3 * t4469;
  t4471 = t16 * t791;
  t4472 = t446 * t4471;
  t4473 = t445 * t4472;
  t4474 = t154 * t4473;
  t4475 = 0.5e1 / 0.72e2 * t4474;
  t4476 = t797 * t449;
  t4477 = 0.5e1 / 0.72e2 * t4476;
  t4478 = t322 * t1362;
  t4479 = 0.5e1 / 0.36e2 * t4478;
  t4480 = t541 * t30;
  t4481 = t4480 * t58;
  t4482 = t805 * t4481;
  t4483 = t207 * t6;
  t4484 = t447 * t545;
  t4485 = t4483 * t4484;
  t4486 = t4482 * t4485;
  t4487 = 0.25e3 / 0.243e3 * t4486;
  t4488 = t1330 * t1361;
  t4489 = t154 * t4488;
  t4490 = 0.35e2 / 0.54e2 * t4489;
  t4491 = t1958 * t6;
  t4492 = t4491 * t16;
  t4493 = t527 * t40;
  t4494 = t4493 * t152;
  t4495 = t4492 * t4494;
  t4496 = t2556 * t4495;
  t4497 = 0.1e5 / 0.729e3 * t4496;
  t4498 = t4370 + t4373 - t4377 + t4381 - t4385 - t4388 - t4391 - t4398 + t4458 - t4460 + t4462 + t4466 - t4470 + t4475 + t4477 + t4479 + t4487 - t4490 - t4497;
  t4518 = 0.35e2 / 0.54e2 * t1332;
  t4520 = 0.5e1 / 0.18e2 * t1347;
  t4523 = -0.5e2 / 0.27e2 * t1268 + 0.5e2 / 0.27e2 * t1275 + 0.4e4 / 0.243e3 * t1299 + 0.1e2 / 0.9e1 * t1287 + 0.1e2 / 0.9e1 * t1291 - 0.25e2 / 0.162e3 * t1328 - t4518 - 0.5e1 / 0.18e2 * t1342 + t4520 - 0.25e2 / 0.108e3 * t1352 + 0.25e2 / 0.108e3 * t1358;
  tv3rho2tau0 = t9 * (t4213 + t4292 + t4366 + t4498) + 0.5e1 / 0.36e2 * t1319 + 0.5e1 / 0.36e2 * t1363 + 0.2e1 * t1390 + 0.2e1 * t1391 - 0.1e3 / 0.81e2 * t1303 - 0.1e3 / 0.81e2 * t1307 - 0.2e3 / 0.81e2 * t1282 + 0.5e3 / 0.243e3 * t1312 - 0.5e3 / 0.243e3 * t1317 + t4523;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t4524 = t574 * t1410;
  t4525 = t4524 * t3454;
  t4526 = t1838 * t4525;
  t4527 = 0.25e2 / 0.81e2 * t4526;
  t4528 = t207 * t1421;
  t4529 = t180 * t171;
  t4530 = t194 * t4529;
  t4531 = t4528 * t4530;
  t4532 = t1838 * t4531;
  t4533 = 0.125e3 / 0.486e3 * t4532;
  t4534 = t512 * t40;
  t4535 = t4534 * t44;
  t4536 = t462 * t4535;
  t4538 = t55 * t147 * t513;
  t4539 = t4536 * t4538;
  t4540 = 0.5e2 / 0.81e2 * t4539;
  t4541 = t1410 * t522;
  t4542 = t1295 * t4541;
  t4543 = t1294 * t4542;
  t4544 = 0.2e4 / 0.243e3 * t4543;
  t4546 = t55 * t217 * t171;
  t4547 = t1396 * t4546;
  t4548 = 0.5e2 / 0.27e2 * t4547;
  t4550 = t55 * t317 * t171;
  t4551 = t1396 * t4550;
  t4552 = 0.5e2 / 0.27e2 * t4551;
  t4554 = t55 * t147 * t517;
  t4555 = t1396 * t4554;
  t4556 = 0.25e2 / 0.27e2 * t4555;
  t4557 = t484 * t791;
  t4558 = t4307 * t1412;
  t4559 = 0.4e4 / 0.243e3 * t4558;
  t4560 = t4310 * t1411;
  t4561 = t1294 * t4560;
  t4562 = 0.4e4 / 0.243e3 * t4561;
  t4563 = t4237 * t474;
  t4564 = t154 * t4563;
  t4565 = 0.595e3 / 0.324e3 * t4564;
  t4566 = t1330 * t1441;
  t4567 = t154 * t4566;
  t4568 = 0.35e2 / 0.27e2 * t4567;
  t4569 = t322 * t1433;
  t4570 = 0.35e2 / 0.54e2 * t4569;
  t4571 = t322 * t1442;
  t4572 = 0.5e1 / 0.18e2 * t4571;
  t4573 = t4527 - t4533 + t4540 + t4544 + t4548 + t4552 + t4556 + t4557 + t4559 + t4562 + t4565 - t4568 - t4570 + t4572;
  t4574 = t27 * t791;
  t4575 = t472 * t4574;
  t4576 = t445 * t4575;
  t4577 = t154 * t4576;
  t4578 = 0.5e1 / 0.72e2 * t4577;
  t4579 = t797 * t475;
  t4580 = 0.5e1 / 0.72e2 * t4579;
  t4581 = t322 * t1452;
  t4582 = 0.5e1 / 0.36e2 * t4581;
  t4583 = t207 * t21;
  t4584 = t473 * t545;
  t4585 = t4583 * t4584;
  t4586 = t4482 * t4585;
  t4587 = 0.25e3 / 0.243e3 * t4586;
  t4588 = t1330 * t1451;
  t4589 = t154 * t4588;
  t4590 = 0.35e2 / 0.54e2 * t4589;
  t4591 = t1440 * t1450;
  t4592 = t445 * t4591;
  t4593 = t154 * t4592;
  t4594 = 0.5e1 / 0.18e2 * t4593;
  t4595 = t1958 * t21;
  t4596 = t4595 * t27;
  t4597 = t4596 * t4494;
  t4598 = t2556 * t4597;
  t4599 = 0.1e5 / 0.729e3 * t4598;
  t4600 = t26 * t180;
  t4601 = t4600 * t171;
  t4602 = t1831 * t4601;
  t4603 = t1294 * t4602;
  t4604 = 0.2e5 / 0.729e3 * t4603;
  t4606 = t190 * t4336 * t468;
  t4607 = 0.5e2 / 0.81e2 * t4606;
  t4609 = t190 * t4180 * t468;
  t4610 = 0.1e3 / 0.81e2 * t4609;
  t4612 = t190 * t4184 * t468;
  t4613 = 0.5e2 / 0.81e2 * t4612;
  t4614 = t1403 * t4189;
  t4615 = 0.2e3 / 0.81e2 * t4614;
  t4616 = t1403 * t4192;
  t4617 = 0.2e3 / 0.81e2 * t4616;
  t4618 = t1403 * t4195;
  t4619 = 0.1e3 / 0.81e2 * t4618;
  t4620 = t462 * t4534;
  t4622 = t152 * t54 * t513;
  t4625 = t26 * t185;
  t4626 = t4625 * t187;
  t4627 = t462 * t4626;
  t4628 = t171 * params->c;
  t4629 = t4628 * t180;
  t4630 = t325 * t4629;
  t4634 = t152 * t54 * t517;
  t4648 = t27 * t522;
  t4649 = t1463 * t4648;
  t4652 = t21 * t512;
  t4653 = t4652 * t513;
  t4657 = t1421 * t517;
  t4661 = -0.5e2 / 0.81e2 * t4620 * t4622 + 0.1e4 / 0.243e3 * t4627 * t4630 - 0.25e2 / 0.27e2 * t1455 * t4634 - 0.2e4 / 0.81e2 * t478 * t4399 + 0.1e3 / 0.81e2 * t1460 * t4440 + 0.1e5 / 0.729e3 * t2535 * t1410 * t527 * t50 - 0.2e5 / 0.729e3 * t543 * t1463 * t4601 - 0.2e4 / 0.243e3 * t543 * t4649 + 0.5e3 / 0.729e3 * t190 * t801 * t4653 + 0.25e3 / 0.243e3 * t190 * t801 * t4657;
  t4662 = t4661 * t146;
  t4663 = t4578 + t4580 + t4582 + t4587 - t4590 + t4594 - t4599 + t4604 - t4607 - t4610 - t4613 - t4615 - t4617 - t4619 + t4662;
  t4665 = t4139 * t1446;
  t4666 = t1336 * t4665;
  t4667 = 0.25e2 / 0.54e2 * t4666;
  t4668 = t316 * t171;
  t4669 = t1421 * t4668;
  t4670 = t1354 * t4669;
  t4671 = t1336 * t4670;
  t4672 = 0.25e2 / 0.108e3 * t4671;
  t4673 = t146 * t517;
  t4674 = t1421 * t4673;
  t4675 = t1354 * t4674;
  t4676 = t1336 * t4675;
  t4677 = 0.25e2 / 0.216e3 * t4676;
  t4678 = t4151 * t1436;
  t4679 = t1336 * t4678;
  t4680 = 0.35e2 / 0.27e2 * t4679;
  t4681 = t4156 * t1446;
  t4682 = t1336 * t4681;
  t4683 = 0.175e3 / 0.162e3 * t4682;
  t4684 = t1410 * t4160;
  t4685 = t1338 * t4684;
  t4686 = t1336 * t4685;
  t4687 = 0.5e1 / 0.18e2 * t4686;
  t4688 = t1410 * t4214;
  t4689 = t1338 * t4688;
  t4690 = t1336 * t4689;
  t4691 = 0.5e1 / 0.36e2 * t4690;
  t4692 = t4143 * t1437;
  t4693 = 0.5e1 / 0.18e2 * t4692;
  t4694 = t4143 * t1447;
  t4695 = 0.25e2 / 0.108e3 * t4694;
  t4696 = t1354 * t1736;
  t4697 = t4146 * t4696;
  t4698 = 0.25e2 / 0.162e3 * t4697;
  t4699 = t4340 * t1436;
  t4700 = t1336 * t4699;
  t4701 = 0.5e1 / 0.9e1 * t4700;
  t4702 = t146 * t513;
  t4703 = t4652 * t4702;
  t4704 = t1354 * t4703;
  t4705 = t1336 * t4704;
  t4706 = 0.25e2 / 0.324e3 * t4705;
  t4707 = t1410 * t4175;
  t4708 = t4174 * t4707;
  t4709 = t1336 * t4708;
  t4710 = 0.5e1 / 0.12e2 * t4709;
  t4712 = t1141 * t1984 * t1422;
  t4713 = 0.5e3 / 0.243e3 * t4712;
  t4714 = t4667 + t4672 + t4677 + t4680 - t4683 - t4687 - t4691 - t4693 + t4695 - t4698 - t4701 + t4706 + t4710 - t4713;
  t4716 = t1141 * t530 * t4657;
  t4717 = 0.25e3 / 0.243e3 * t4716;
  t4718 = t462 * t26;
  t4719 = t4718 * t189;
  t4720 = t439 * t4629;
  t4721 = t4719 * t4720;
  t4722 = 0.1e4 / 0.243e3 * t4721;
  t4723 = t530 * t4653;
  t4724 = t1141 * t4723;
  t4725 = 0.5e3 / 0.729e3 * t4724;
  t4726 = t445 * t1740;
  t4727 = t154 * t4726;
  t4728 = 0.5e1 / 0.36e2 * t4727;
  t4730 = t1141 * t1980 * t1422;
  t4731 = 0.5e3 / 0.243e3 * t4730;
  t4732 = t464 * t4363;
  t4733 = 0.5e1 / 0.9e1 * t4732;
  t4734 = t464 * t4368;
  t4735 = 0.1e2 / 0.9e1 * t4734;
  t4736 = t464 * t4349;
  t4737 = 0.5e1 / 0.9e1 * t4736;
  t4738 = t27 * t539;
  t4739 = t462 * t4738;
  t4740 = t4739 * t4358;
  t4741 = 0.2e4 / 0.81e2 * t4740;
  t4742 = t26 * t146;
  t4743 = t209 * t171;
  t4744 = t4742 * t4743;
  t4745 = t1843 * t4744;
  t4746 = t1336 * t4745;
  t4747 = 0.25e2 / 0.54e2 * t4746;
  t4748 = t1450 * t326;
  t4749 = t1428 * t4748;
  t4750 = t1323 * t4749;
  t4751 = 0.25e2 / 0.162e3 * t4750;
  t4752 = t473 * t810;
  t4753 = t1428 * t4752;
  t4754 = t1323 * t4753;
  t4755 = 0.25e2 / 0.324e3 * t4754;
  t4756 = t4155 * t472;
  t4757 = t4756 * t1429;
  t4758 = t1323 * t4757;
  t4759 = 0.175e3 / 0.243e3 * t4758;
  t4760 = t1324 * t1440;
  t4761 = t4760 * t1429;
  t4762 = t1323 * t4761;
  t4763 = 0.25e2 / 0.81e2 * t4762;
  t4764 = t1471 * t316;
  t4765 = 0.2e1 * t4764;
  t4766 = -t4717 - t4722 - t4725 + t4728 - t4731 + t4733 + t4735 + t4737 + t4741 - t4747 - t4751 - t4755 + t4759 - t4763 + t4765;
  t4783 = 0.35e2 / 0.54e2 * t1434;
  t4785 = 0.5e1 / 0.18e2 * t1443;
  tv3rho2tau1 = t9 * (t4573 + t4663 + t4714 + t4766) + 0.2e1 * t1473 + 0.2e1 * t1472 + 0.5e1 / 0.36e2 * t1426 + 0.5e1 / 0.36e2 * t1453 - 0.2e3 / 0.81e2 * t1404 - 0.1e3 / 0.81e2 * t1416 - 0.1e3 / 0.81e2 * t1419 - 0.5e3 / 0.243e3 * t1424 + 0.5e2 / 0.27e2 * t1399 + 0.4e4 / 0.243e3 * t1413 + 0.1e2 / 0.9e1 * t1406 + 0.1e2 / 0.9e1 * t1408 - 0.25e2 / 0.162e3 * t1431 - t4783 - 0.5e1 / 0.18e2 * t1438 + t4785 + 0.25e2 / 0.108e3 * t1448;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t4787 = t1320 - t4518 - t1353 + t1364 + t1509 + t1546 - t1269 + t1288 + t1292 - t1283 - t1304 - t1308 + t1313 - t1482 + t1528 - t1329 - t1513;
  t4788 = t387 * t1335;
  t4789 = t4788 * t1357;
  t4792 = t805 * t4480 * t1324;
  t4793 = t446 * t16;
  t4794 = t1295 * t962;
  t4795 = t4793 * t4794;
  t4796 = t4792 * t4795;
  t4798 = t2554 * t1990;
  t4799 = t805 * t4798;
  t4800 = t1492 * t3853;
  t4801 = t4799 * t4800;
  t4803 = t4156 * t1520;
  t4804 = t1336 * t4803;
  t4806 = t4139 * t1520;
  t4807 = t1336 * t4806;
  t4809 = t4198 * t1519;
  t4810 = t1354 * t4809;
  t4811 = t1336 * t4810;
  t4813 = t4151 * t1515;
  t4814 = t1336 * t4813;
  t4816 = t4340 * t1515;
  t4817 = t1336 * t4816;
  t4819 = t1519 * t326;
  t4820 = t4129 * t4819;
  t4821 = t1838 * t4820;
  t4823 = t350 * t167;
  t4824 = t194 * t4823;
  t4825 = t4129 * t4824;
  t4826 = t1838 * t4825;
  t4828 = t4135 * t3862;
  t4829 = t1838 * t4828;
  t4831 = t4135 * t3858;
  t4832 = t1838 * t4831;
  t4834 = t336 * t209;
  t4835 = t4248 * t4834;
  t4836 = t4247 * t4835;
  t4837 = t1336 * t4836;
  t4839 = 0.25e2 / 0.216e3 * t4789 + 0.25e3 / 0.243e3 * t4796 - 0.1e5 / 0.729e3 * t4801 - 0.175e3 / 0.324e3 * t4804 + 0.25e2 / 0.108e3 * t4807 - 0.125e3 / 0.648e3 * t4811 + 0.35e2 / 0.54e2 * t4814 - 0.5e1 / 0.18e2 * t4817 - 0.125e3 / 0.972e3 * t4821 - 0.125e3 / 0.972e3 * t4826 + 0.25e2 / 0.162e3 * t4829 + 0.25e2 / 0.162e3 * t4832 - 0.25e2 / 0.108e3 * t4837;
  t4840 = t382 * t544;
  t4841 = t4840 * t1297;
  t4842 = t1294 * t4841;
  t4844 = t4307 * t1493;
  t4846 = t4310 * t1492;
  t4847 = t1294 * t4846;
  t4849 = t1296 * t841;
  t4850 = t1295 * t4849;
  t4851 = t1294 * t4850;
  t4853 = t542 * t364;
  t4854 = t39 * t4853;
  t4855 = t4854 * t1298;
  t4858 = t55 * t217 * t336;
  t4859 = t1272 * t4858;
  t4861 = t382 * t167;
  t4862 = t1314 * t4861;
  t4863 = t1354 * t4862;
  t4864 = t1336 * t4863;
  t4866 = t459 * t951;
  t4870 = t2362 * t206;
  t4871 = t252 * t6;
  t4872 = t4871 * t4248;
  t4873 = t4870 * t4872;
  t4874 = t154 * t4873;
  t4876 = t322 * t1526;
  t4878 = 0.2e4 / 0.243e3 * t4842 + 0.2e4 / 0.243e3 * t4844 + 0.2e4 / 0.243e3 * t4847 + 0.2e4 / 0.243e3 * t4851 + 0.2e4 / 0.243e3 * t4855 + 0.25e2 / 0.27e2 * t4859 + 0.25e2 / 0.216e3 * t4864 + t4866 - 0.25e2 / 0.108e3 * t4141 + 0.35e2 / 0.54e2 * t4153 - 0.175e3 / 0.324e3 * t4158 + 0.25e2 / 0.216e3 * t4874 + 0.5e1 / 0.72e2 * t4876;
  t4880 = t16 * t951;
  t4881 = t446 * t4880;
  t4882 = t445 * t4881;
  t4883 = t154 * t4882;
  t4885 = t957 * t449;
  t4887 = t388 * t1362;
  t4889 = t336 * t167;
  t4890 = t4167 * t4889;
  t4891 = t530 * t4890;
  t4892 = t1141 * t4891;
  t4894 = t1314 * t507;
  t4895 = t530 * t4894;
  t4896 = t1141 * t4895;
  t4898 = t1330 * t1525;
  t4899 = t154 * t4898;
  t4903 = t388 * t1331;
  t4905 = t388 * t1346;
  t4907 = t388 * t1351;
  t4909 = t1389 * t382;
  t4910 = 0.5e1 / 0.72e2 * t4883 + 0.5e1 / 0.72e2 * t4885 + 0.5e1 / 0.72e2 * t4887 - 0.5e3 / 0.729e3 * t4892 - 0.25e3 / 0.243e3 * t4896 - 0.35e2 / 0.108e3 * t4899 + 0.25e2 / 0.108e3 * t4228 + t4240 + 0.175e3 / 0.324e3 * t4245 - 0.35e2 / 0.108e3 * t4903 + 0.5e1 / 0.36e2 * t4905 - 0.25e2 / 0.216e3 * t4907 + t4909;
  t4911 = t4262 * t1514;
  t4912 = t1338 * t4911;
  t4913 = t1336 * t4912;
  t4915 = t4143 * t1516;
  t4917 = t316 * t360;
  t4918 = t1296 * t4917;
  t4919 = t1338 * t4918;
  t4920 = t1336 * t4919;
  t4922 = t146 * t886;
  t4923 = t1296 * t4922;
  t4924 = t1338 * t4923;
  t4925 = t1336 * t4924;
  t4927 = t4143 * t1521;
  t4929 = t316 * t336;
  t4930 = t1314 * t4929;
  t4931 = t1354 * t4930;
  t4932 = t1336 * t4931;
  t4934 = t382 * t209;
  t4935 = t1296 * t4934;
  t4936 = t1338 * t4935;
  t4937 = t1336 * t4936;
  t4941 = t871 * t316;
  t4942 = t4941 * t441;
  t4943 = t190 * t4942;
  t4945 = t549 * t382;
  t4946 = t4945 * t441;
  t4947 = t190 * t4946;
  t4949 = t193 * t951;
  t4950 = t4949 * t441;
  t4951 = t190 * t4950;
  t4953 = t337 * t180;
  t4954 = t4330 * t4953;
  t4955 = t1294 * t4954;
  t4957 = 0.25e2 / 0.108e3 * t4913 - 0.5e1 / 0.36e2 * t4915 - 0.5e1 / 0.36e2 * t4920 - 0.5e1 / 0.36e2 * t4925 + 0.25e2 / 0.216e3 * t4927 + 0.25e2 / 0.216e3 * t4932 - 0.5e1 / 0.36e2 * t4937 + 0.175e3 / 0.486e3 * t4276 + 0.25e2 / 0.162e3 * t4280 - 0.5e2 / 0.81e2 * t4943 - 0.5e2 / 0.81e2 * t4947 - 0.5e2 / 0.81e2 * t4951 + 0.1e5 / 0.729e3 * t4955;
  t4960 = t325 * t364;
  t4961 = t4960 * t195;
  t4962 = t1279 * t4961;
  t4964 = t1280 * t903;
  t4965 = t1279 * t4964;
  t4967 = t15 * t350;
  t4968 = t4967 * t167;
  t4969 = t4330 * t4968;
  t4970 = t1294 * t4969;
  t4972 = t2586 * t146;
  t4973 = t4972 * t441;
  t4974 = t190 * t4973;
  t4976 = t4262 * t350;
  t4977 = t1295 * t4976;
  t4978 = t1294 * t4977;
  t4980 = t4289 * t1477;
  t4983 = t55 * t317 * t336;
  t4984 = t1272 * t4983;
  t4986 = t4356 * t541;
  t4987 = t431 * t4986;
  t4988 = t4987 * t855;
  t4991 = t55 * t365 * t167;
  t4992 = t1272 * t4991;
  t4995 = t55 * t383 * t167;
  t4996 = t1272 * t4995;
  t4998 = t4274 * t1510;
  t4999 = t1323 * t4998;
  t5001 = t4278 * t1510;
  t5002 = t1323 * t5001;
  t5004 = t4282 * t1510;
  t5005 = t1323 * t5004;
  t5007 = -0.1e3 / 0.81e2 * t4962 - 0.1e3 / 0.81e2 * t4965 + 0.1e5 / 0.729e3 * t4970 - 0.5e2 / 0.81e2 * t4974 - 0.1e5 / 0.729e3 * t4978 - 0.125e3 / 0.81e2 * t4980 + 0.25e2 / 0.27e2 * t4984 + 0.2e4 / 0.81e2 * t4988 + 0.25e2 / 0.27e2 * t4992 + 0.25e2 / 0.27e2 * t4996 + 0.175e3 / 0.486e3 * t4999 - 0.25e2 / 0.162e3 * t5002 + 0.125e3 / 0.972e3 * t5005;
  t5008 = t447 * t966;
  t5009 = t1325 * t5008;
  t5010 = t1323 * t5009;
  t5012 = t360 * t167;
  t5013 = t4248 * t5012;
  t5014 = t4247 * t5013;
  t5015 = t1336 * t5014;
  t5017 = t3816 * t1322;
  t5018 = t5017 * t1327;
  t5020 = t1360 * t390;
  t5021 = t1325 * t5020;
  t5022 = t1323 * t5021;
  t5024 = t55 * t66;
  t5025 = t1519 * t167;
  t5026 = t5024 * t5025;
  t5027 = t4269 * t5026;
  t5029 = t3493 * t506;
  t5030 = t5024 * t5029;
  t5031 = t1272 * t5030;
  t5033 = t4188 * t355;
  t5034 = t1279 * t5033;
  t5036 = t1280 * t861;
  t5037 = t1279 * t5036;
  t5039 = t1280 * t865;
  t5040 = t1279 * t5039;
  t5042 = t1496 * t1310;
  t5043 = t190 * t5042;
  t5045 = t1500 * t1310;
  t5046 = t190 * t5045;
  t5048 = t4286 * t1480;
  t5051 = t152 * t1284 * t382;
  t5052 = t433 * t5051;
  t5054 = -0.25e2 / 0.324e3 * t5010 - 0.25e2 / 0.108e3 * t5015 - 0.25e2 / 0.162e3 * t5018 - 0.25e2 / 0.324e3 * t5022 + 0.5e2 / 0.81e2 * t5027 + 0.25e2 / 0.27e2 * t5031 - 0.1e3 / 0.81e2 * t5034 - 0.1e3 / 0.81e2 * t5037 - 0.1e3 / 0.81e2 * t5040 + 0.25e3 / 0.243e3 * t5043 + 0.25e3 / 0.243e3 * t5046 + 0.5e3 / 0.243e3 * t5048 + 0.5e1 / 0.9e1 * t5052;
  t5057 = t152 * t434 * t951;
  t5058 = t433 * t5057;
  t5060 = t54 * t891;
  t5062 = t152 * t5060 * t146;
  t5063 = t433 * t5062;
  t5066 = t152 * t1483 * t316;
  t5067 = t433 * t5066;
  t5069 = t1267 * t1485;
  t5071 = t1267 * t1489;
  t5073 = t1344 * t1524;
  t5074 = t445 * t5073;
  t5075 = t154 * t5074;
  t5077 = t1349 * t1524;
  t5078 = t445 * t5077;
  t5079 = t154 * t5078;
  t5081 = t4788 * t1341;
  t5086 = t152 * t1529 * t167;
  t5089 = t336 * params->c;
  t5090 = t5089 * t180;
  t5091 = t325 * t5090;
  t5094 = t54 * t8;
  t5096 = t152 * t5094 * t506;
  t5101 = t390 * t167;
  t5102 = t325 * t5101;
  t5108 = t800 * t801 * t841;
  t5111 = t1955 * t1958;
  t5113 = t805 * t5111 * t6;
  t5115 = t1537 * t180 * t50;
  t5121 = t1378 * t4968;
  t5124 = t16 * t841;
  t5128 = t1378 * t4953;
  t5131 = t4198 * t336;
  t5135 = t801 * t6;
  t5136 = t5135 * t824;
  t5139 = t5135 * t828;
  t5142 = 0.125e3 / 0.81e2 * t4446 * t1530 - 0.5e2 / 0.81e2 * t4434 * t5086 + 0.5e3 / 0.243e3 * t4407 * t5091 - 0.25e2 / 0.27e2 * t1368 * t5096 - 0.5e3 / 0.243e3 * t4431 * t1534 + 0.5e3 / 0.243e3 * t4407 * t5102 - 0.2e4 / 0.81e2 * t4357 * t963 + 0.1e3 / 0.81e2 * t1373 * t5108 + 0.1e5 / 0.729e3 * t5113 * t5115 + 0.1e5 / 0.729e3 * t543 * t4424 * t1537 - 0.1e5 / 0.729e3 * t543 * t5121 - 0.2e4 / 0.243e3 * t543 * t1378 * t5124 - 0.1e5 / 0.729e3 * t543 * t5128 - 0.125e4 / 0.729e3 * t190 * t801 * t5131 + 0.5e3 / 0.729e3 * t190 * t5136 + 0.25e3 / 0.243e3 * t190 * t5139;
  t5143 = t5142 * t146;
  t5145 = t439 * t5101;
  t5146 = t4393 * t5145;
  t5149 = t1141 * t530 * t5131;
  t5152 = t1141 * t1984 * t1504;
  t5154 = 0.5e1 / 0.9e1 * t5058 + 0.5e1 / 0.9e1 * t5063 + 0.5e1 / 0.9e1 * t5067 - 0.25e2 / 0.27e2 * t5069 - 0.25e2 / 0.27e2 * t5071 + 0.5e1 / 0.36e2 * t5075 - 0.25e2 / 0.216e3 * t5079 - 0.5e1 / 0.36e2 * t5081 + t5143 + 0.5e1 / 0.18e2 * t4342 - 0.5e3 / 0.243e3 * t5146 + 0.125e4 / 0.729e3 * t5149 - 0.25e3 / 0.243e3 * t5152;
  t5155 = t439 * t5090;
  t5156 = t4393 * t5155;
  t5159 = t1141 * t2615 * t1315;
  t5162 = t1141 * t1980 * t1504;
  t5165 = t1141 * t2636 * t1315;
  t5171 = t1544 * t316;
  t5172 = t501 * t146;
  t5173 = t5172 * t4889;
  t5174 = t1325 * t5173;
  t5175 = t1336 * t5174;
  t5177 = t1524 * t326;
  t5178 = t1325 * t5177;
  t5179 = t1323 * t5178;
  t5181 = t4173 * t446;
  t5182 = t360 * t209;
  t5183 = t447 * t5182;
  t5184 = t5181 * t5183;
  t5185 = t1336 * t5184;
  t5187 = -0.5e3 / 0.243e3 * t5156 - 0.25e3 / 0.243e3 * t5159 - 0.25e3 / 0.243e3 * t5162 - 0.25e3 / 0.243e3 * t5165 - t4373 - 0.35e2 / 0.108e3 * t4459 - 0.5e1 / 0.36e2 * t4461 - 0.5e1 / 0.36e2 * t4465 - 0.35e2 / 0.108e3 * t4489 + t5171 + 0.25e2 / 0.324e3 * t5175 - 0.25e2 / 0.324e3 * t5179 + 0.5e1 / 0.12e2 * t5185;
  t5192 = t1545 + t1391 + t1390 + t1276 + t1300 - t1318 - t1507 - t1499 - t1503 + t9 * (t4839 + t4878 + t4910 + t4957 + t5007 + t5054 + t5154 + t5187) + t1523 - t1343 + t1359 - t1518 + t1479 + t1495 + t1487 + t1491;
  tv3rho2tau2 = t4787 + t5192;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t5193 = t1563 * t3853;
  t5194 = t4799 * t5193;
  t5196 = t4788 * t1437;
  t5198 = t4788 * t1447;
  t5200 = t472 * t27;
  t5201 = t5200 * t4794;
  t5202 = t4792 * t5201;
  t5204 = t4143 * t1589;
  t5206 = t1410 * t4917;
  t5207 = t1338 * t5206;
  t5208 = t1336 * t5207;
  t5210 = t1410 * t4922;
  t5211 = t1338 * t5210;
  t5212 = t1336 * t5211;
  t5214 = t342 * t27;
  t5215 = t5214 * t1339;
  t5216 = t1338 * t5215;
  t5217 = t1336 * t5216;
  t5219 = t4156 * t1598;
  t5220 = t1336 * t5219;
  t5222 = t4139 * t1598;
  t5223 = t1336 * t5222;
  t5225 = t4151 * t1588;
  t5226 = t1336 * t5225;
  t5228 = t4340 * t1588;
  t5229 = t1336 * t5228;
  t5231 = -0.1e5 / 0.729e3 * t5194 - 0.5e1 / 0.36e2 * t5196 + 0.25e2 / 0.216e3 * t5198 + 0.25e3 / 0.243e3 * t5202 - 0.5e1 / 0.36e2 * t5204 - 0.5e1 / 0.36e2 * t5208 - 0.5e1 / 0.36e2 * t5212 + 0.25e2 / 0.108e3 * t5217 - 0.175e3 / 0.324e3 * t5220 + 0.25e2 / 0.108e3 * t5223 + 0.35e2 / 0.54e2 * t5226 - 0.5e1 / 0.18e2 * t5229 + t4565;
  t5236 = t1403 * t4961;
  t5238 = t1403 * t4964;
  t5240 = t1549 * t1402;
  t5241 = t5240 * t1281;
  t5243 = t1597 * t171;
  t5244 = t5024 * t5243;
  t5245 = t4536 * t5244;
  t5247 = t27 * t951;
  t5248 = t472 * t5247;
  t5249 = t445 * t5248;
  t5250 = t154 * t5249;
  t5252 = t322 * t1594;
  t5254 = t1592 * t1450;
  t5255 = t445 * t5254;
  t5256 = t154 * t5255;
  t5258 = t252 * t21;
  t5259 = t5258 * t4742;
  t5260 = t4870 * t5259;
  t5261 = t154 * t5260;
  t5263 = t322 * t1604;
  t5265 = -0.35e2 / 0.108e3 * t4569 - 0.5e1 / 0.36e2 * t4571 - 0.35e2 / 0.108e3 * t4589 - 0.5e1 / 0.36e2 * t4593 - 0.1e3 / 0.81e2 * t5236 - 0.1e3 / 0.81e2 * t5238 + 0.5e3 / 0.243e3 * t5241 + 0.5e2 / 0.81e2 * t5245 + 0.5e1 / 0.72e2 * t5250 - 0.25e2 / 0.216e3 * t5252 - 0.25e2 / 0.216e3 * t5256 - 0.25e2 / 0.216e3 * t5261 + 0.5e1 / 0.72e2 * t5263;
  t5267 = t346 * t171;
  t5268 = t4652 * t5267;
  t5269 = t530 * t5268;
  t5270 = t1141 * t5269;
  t5272 = t1421 * t507;
  t5273 = t530 * t5272;
  t5274 = t1141 * t5273;
  t5276 = t957 * t475;
  t5278 = t388 * t1452;
  t5280 = t4524 * t3858;
  t5281 = t1838 * t5280;
  t5283 = t350 * t171;
  t5284 = t194 * t5283;
  t5285 = t4528 * t5284;
  t5286 = t1838 * t5285;
  t5288 = t26 * t350;
  t5289 = t5288 * t171;
  t5290 = t1831 * t5289;
  t5291 = t1294 * t5290;
  t5294 = t190 * t4972 * t468;
  t5297 = t190 * t4941 * t468;
  t5300 = t190 * t4945 * t468;
  t5303 = t190 * t4949 * t468;
  t5306 = t190 * t1301 * t1574;
  t5309 = t190 * t1305 * t1574;
  t5311 = -0.5e3 / 0.729e3 * t5270 + 0.25e3 / 0.243e3 * t5274 + 0.5e1 / 0.72e2 * t5276 + 0.5e1 / 0.72e2 * t5278 + 0.25e2 / 0.162e3 * t5281 - 0.125e3 / 0.972e3 * t5286 + 0.1e5 / 0.729e3 * t5291 - 0.5e2 / 0.81e2 * t5294 - 0.5e2 / 0.81e2 * t5297 - 0.5e2 / 0.81e2 * t5300 - 0.5e2 / 0.81e2 * t5303 + 0.25e3 / 0.243e3 * t5306 + 0.25e3 / 0.243e3 * t5309;
  t5312 = t347 * t180;
  t5313 = t1831 * t5312;
  t5314 = t1294 * t5313;
  t5316 = t1396 * t5030;
  t5318 = t1403 * t5033;
  t5320 = t1403 * t5036;
  t5322 = t1403 * t5039;
  t5325 = t1323 * t4756 * t1584;
  t5328 = t1323 * t4760 * t1584;
  t5330 = t4524 * t3862;
  t5331 = t1838 * t5330;
  t5333 = t1597 * t326;
  t5334 = t4528 * t5333;
  t5335 = t1838 * t5334;
  t5337 = t342 * t26;
  t5338 = t5337 * t1445;
  t5339 = t1354 * t5338;
  t5340 = t1336 * t5339;
  t5342 = t4143 * t1599;
  t5344 = t316 * t346;
  t5345 = t1421 * t5344;
  t5346 = t1354 * t5345;
  t5347 = t1336 * t5346;
  t5349 = t1410 * t4934;
  t5350 = t1338 * t5349;
  t5351 = t1336 * t5350;
  t5353 = 0.1e5 / 0.729e3 * t5314 - 0.25e2 / 0.27e2 * t5316 - 0.1e3 / 0.81e2 * t5318 - 0.1e3 / 0.81e2 * t5320 - 0.1e3 / 0.81e2 * t5322 + 0.175e3 / 0.486e3 * t5325 - 0.25e2 / 0.162e3 * t5328 + 0.25e2 / 0.162e3 * t5331 - 0.125e3 / 0.972e3 * t5335 - 0.125e3 / 0.648e3 * t5340 + 0.25e2 / 0.216e3 * t5342 + 0.25e2 / 0.216e3 * t5347 - 0.5e1 / 0.36e2 * t5351;
  t5356 = t382 * t171;
  t5357 = t1421 * t5356;
  t5358 = t1354 * t5357;
  t5359 = t1336 * t5358;
  t5361 = t1450 * t390;
  t5363 = t1323 * t1428 * t5361;
  t5365 = t473 * t966;
  t5366 = t1428 * t5365;
  t5367 = t1323 * t5366;
  t5369 = t360 * t171;
  t5370 = t4742 * t5369;
  t5371 = t1843 * t5370;
  t5372 = t1336 * t5371;
  t5374 = t5017 * t1430;
  t5376 = t512 * t146;
  t5377 = t5376 * t5267;
  t5378 = t1428 * t5377;
  t5379 = t1336 * t5378;
  t5381 = t1602 * t326;
  t5382 = t1428 * t5381;
  t5383 = t1323 * t5382;
  t5385 = t4173 * t472;
  t5386 = t473 * t5182;
  t5387 = t5385 * t5386;
  t5388 = t1336 * t5387;
  t5390 = t1324 * t1592;
  t5392 = t1323 * t5390 * t1429;
  t5394 = t346 * t209;
  t5395 = t4742 * t5394;
  t5396 = t1843 * t5395;
  t5397 = t1336 * t5396;
  t5399 = t1550 * t1286;
  t5401 = t1550 * t1290;
  t5403 = t464 * t5062;
  t5405 = 0.25e2 / 0.216e3 * t5359 - 0.25e2 / 0.324e3 * t5363 - 0.25e2 / 0.324e3 * t5367 - 0.25e2 / 0.108e3 * t5372 - 0.25e2 / 0.162e3 * t5374 + 0.25e2 / 0.324e3 * t5379 - 0.25e2 / 0.324e3 * t5383 + 0.5e1 / 0.12e2 * t5388 + 0.125e3 / 0.972e3 * t5392 - 0.25e2 / 0.108e3 * t5397 - 0.25e2 / 0.27e2 * t5399 - 0.25e2 / 0.27e2 * t5401 + 0.5e1 / 0.9e1 * t5403;
  t5406 = t464 * t5066;
  t5408 = t464 * t5051;
  t5410 = t464 * t5057;
  t5412 = t4840 * t1411;
  t5413 = t1294 * t5412;
  t5415 = t5214 * t180;
  t5416 = t1295 * t5415;
  t5417 = t1294 * t5416;
  t5419 = t4307 * t1564;
  t5421 = t4310 * t1563;
  t5422 = t1294 * t5421;
  t5424 = t1410 * t841;
  t5425 = t1295 * t5424;
  t5426 = t1294 * t5425;
  t5428 = t4854 * t1412;
  t5431 = t55 * t365 * t171;
  t5432 = t1396 * t5431;
  t5435 = t55 * t383 * t171;
  t5436 = t1396 * t5435;
  t5438 = t1549 * t1395;
  t5439 = t5438 * t1398;
  t5442 = t55 * t217 * t346;
  t5443 = t1396 * t5442;
  t5445 = 0.5e1 / 0.9e1 * t5406 + 0.5e1 / 0.9e1 * t5408 + 0.5e1 / 0.9e1 * t5410 + 0.2e4 / 0.243e3 * t5413 - 0.1e5 / 0.729e3 * t5417 + 0.2e4 / 0.243e3 * t5419 + 0.2e4 / 0.243e3 * t5422 + 0.2e4 / 0.243e3 * t5426 + 0.2e4 / 0.243e3 * t5428 + 0.25e2 / 0.27e2 * t5432 + 0.25e2 / 0.27e2 * t5436 - 0.125e3 / 0.81e2 * t5439 + 0.25e2 / 0.27e2 * t5443;
  t5448 = t55 * t317 * t346;
  t5449 = t1396 * t5448;
  t5451 = t4738 * t541;
  t5452 = t462 * t5451;
  t5453 = t5452 * t855;
  t5455 = t390 * t171;
  t5456 = t439 * t5455;
  t5457 = t4719 * t5456;
  t5460 = t1141 * t2636 * t1422;
  t5463 = t1141 * t2615 * t1422;
  t5465 = t5337 * t171;
  t5467 = t1141 * t530 * t5465;
  t5470 = t1141 * t1980 * t1578;
  t5473 = t1141 * t1984 * t1578;
  t5475 = t346 * params->c;
  t5476 = t5475 * t180;
  t5477 = t439 * t5476;
  t5478 = t4719 * t5477;
  t5484 = 0.25e2 / 0.27e2 * t5449 + 0.2e4 / 0.81e2 * t5453 - 0.5e3 / 0.243e3 * t5457 - 0.25e3 / 0.243e3 * t5460 - 0.25e3 / 0.243e3 * t5463 + 0.125e4 / 0.729e3 * t5467 - 0.25e3 / 0.243e3 * t5470 - 0.25e3 / 0.243e3 * t5473 - 0.5e3 / 0.243e3 * t5478 - 0.25e2 / 0.108e3 * t4666 + 0.35e2 / 0.54e2 * t4679 - 0.175e3 / 0.324e3 * t4682 + 0.5e1 / 0.18e2 * t4700;
  t5487 = t1549 * t1394;
  t5490 = t1549 * t1401;
  t5494 = t152 * t1610 * t171;
  t5502 = t325 * t5455;
  t5510 = t805 * t5111 * t21;
  t5512 = t1616 * t180 * t50;
  t5518 = t27 * t841;
  t5519 = t1463 * t5518;
  t5522 = t544 * t342;
  t5523 = t5522 * t1464;
  t5532 = t801 * t21;
  t5539 = 0.125e3 / 0.81e2 * t5487 * t1457 - 0.5e3 / 0.243e3 * t5490 * t1375 - 0.5e2 / 0.81e2 * t4620 * t5494 + 0.5e3 / 0.243e3 * t4627 * t325 * t5476 + 0.25e2 / 0.27e2 * t1455 * t5096 + 0.5e3 / 0.243e3 * t4627 * t5502 - 0.2e4 / 0.81e2 * t4739 * t963 + 0.1e3 / 0.81e2 * t1460 * t5108 + 0.1e5 / 0.729e3 * t5510 * t5512 - 0.1e5 / 0.729e3 * t543 * t1463 * t5289 - 0.2e4 / 0.243e3 * t543 * t5519 + 0.1e5 / 0.729e3 * t543 * t5523 - 0.125e4 / 0.729e3 * t190 * t801 * t5465 - 0.1e5 / 0.729e3 * t543 * t1463 * t5312 + 0.5e3 / 0.729e3 * t190 * t5532 * t834 - 0.25e3 / 0.243e3 * t190 * t5532 * t838;
  t5540 = t5539 * t146;
  t5541 = t1626 * t316;
  t5542 = t388 * t1433;
  t5544 = t388 * t1442;
  t5546 = t1330 * t1593;
  t5547 = t154 * t5546;
  t5549 = t8 * t342;
  t5550 = t5549 * t473;
  t5551 = t445 * t5550;
  t5552 = t154 * t5551;
  t5554 = t1330 * t1603;
  t5555 = t154 * t5554;
  t5557 = t1440 * t1602;
  t5558 = t445 * t5557;
  t5559 = t154 * t5558;
  t5561 = t1471 * t382;
  t5562 = t484 * t951;
  t5563 = -t4728 + 0.175e3 / 0.486e3 * t4758 + 0.25e2 / 0.162e3 * t4762 + t5540 + t5541 - 0.35e2 / 0.108e3 * t5542 + 0.5e1 / 0.36e2 * t5544 + 0.175e3 / 0.324e3 * t5547 - 0.25e2 / 0.108e3 * t5552 - 0.35e2 / 0.108e3 * t5555 + 0.5e1 / 0.36e2 * t5559 + t5561 + t5562;
  t5568 = t1427 - t4783 + t1454 + t1628 + t1627 + t1407 + t1409 - t1405 - t1417 - t1420 + t1583 - t1596 + t1606 - t1587 - t1432 + t9 * (t5231 + t5265 + t5311 + t5353 + t5405 + t5445 + t5484 + t5563) + t1473;
  t5569 = -t1425 - t1581 - t1558 - t1569 - t1572 + t1577 + t1556 + t1566 - t1591 + t1601 - t1439 + t1449 + t1400 + t1414 - t1552 + t1560 + t1562 + t1472;
  tv3rho2tau3 = t5568 + t5569;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t5570 = 0.175e3 / 0.162e3 * t4804;
  t5571 = 0.25e2 / 0.54e2 * t4807;
  t5572 = 0.35e2 / 0.27e2 * t4814;
  t5573 = 0.5e1 / 0.9e1 * t4817;
  t5574 = 0.35e2 / 0.54e2 * t4899;
  t5575 = t4135 * t4015;
  t5576 = t1838 * t5575;
  t5577 = 0.25e2 / 0.81e2 * t5576;
  t5578 = t350 * t336;
  t5579 = t194 * t5578;
  t5580 = t4129 * t5579;
  t5581 = t1838 * t5580;
  t5582 = 0.125e3 / 0.486e3 * t5581;
  t5583 = 0.35e2 / 0.54e2 * t4903;
  t5584 = 0.5e1 / 0.18e2 * t4905;
  t5585 = t459 * t1084;
  t5586 = t1544 * t382;
  t5587 = 0.2e1 * t5586;
  t5588 = t54 * t983;
  t5589 = t152 * t5588;
  t5592 = t5089 * t350;
  t5593 = t325 * t5592;
  t5596 = t54 * t987;
  t5597 = t152 * t5596;
  t5600 = t542 * t1021;
  t5604 = t800 * t801 * t1007;
  t5607 = t1296 * t1012;
  t5608 = t5607 * t50;
  t5611 = t4967 * t336;
  t5612 = t1378 * t5611;
  t5615 = t16 * t1007;
  t5619 = t4167 * t983;
  t5623 = t1314 * t987;
  t5627 = -0.5e2 / 0.81e2 * t4434 * t5589 + 0.1e4 / 0.243e3 * t4407 * t5593 - 0.25e2 / 0.27e2 * t1368 * t5597 - 0.2e4 / 0.81e2 * t452 * t5600 + 0.1e3 / 0.81e2 * t1373 * t5604 + 0.1e5 / 0.729e3 * t2535 * t5608 - 0.2e5 / 0.729e3 * t543 * t5612 - 0.2e4 / 0.243e3 * t543 * t1378 * t5615 + 0.5e3 / 0.729e3 * t190 * t801 * t5619 + 0.25e3 / 0.243e3 * t190 * t801 * t5623;
  t5628 = t5627 * t146;
  t5629 = -t5570 - t5571 + t5572 + t5573 - t5574 + t4240 + t4243 + t5577 - t5582 - t5583 - t5584 + t5585 + t5587 + t5628;
  t5631 = t55 * t147 * t983;
  t5632 = t4269 * t5631;
  t5633 = 0.5e2 / 0.81e2 * t5632;
  t5634 = t4854 * t1493;
  t5635 = 0.4e4 / 0.243e3 * t5634;
  t5636 = t4840 * t1492;
  t5637 = t1294 * t5636;
  t5638 = 0.4e4 / 0.243e3 * t5637;
  t5639 = t1296 * t1007;
  t5640 = t1295 * t5639;
  t5641 = t1294 * t5640;
  t5642 = 0.2e4 / 0.243e3 * t5641;
  t5644 = t55 * t365 * t336;
  t5645 = t1272 * t5644;
  t5646 = 0.5e2 / 0.27e2 * t5645;
  t5648 = t55 * t383 * t336;
  t5649 = t1272 * t5648;
  t5650 = 0.5e2 / 0.27e2 * t5649;
  t5652 = t55 * t147 * t987;
  t5653 = t1272 * t5652;
  t5654 = 0.25e2 / 0.27e2 * t5653;
  t5655 = t447 * t1098;
  t5656 = t1325 * t5655;
  t5657 = t1323 * t5656;
  t5658 = 0.25e2 / 0.324e3 * t5657;
  t5659 = t360 * t336;
  t5660 = t4248 * t5659;
  t5661 = t4247 * t5660;
  t5662 = t1336 * t5661;
  t5663 = 0.25e2 / 0.54e2 * t5662;
  t5664 = t1524 * t390;
  t5665 = t1325 * t5664;
  t5666 = t1323 * t5665;
  t5667 = 0.25e2 / 0.162e3 * t5666;
  t5668 = t1012 * t40;
  t5669 = t5668 * t152;
  t5670 = t4492 * t5669;
  t5671 = t2556 * t5670;
  t5672 = 0.1e5 / 0.729e3 * t5671;
  t5673 = 0.175e3 / 0.243e3 * t4999;
  t5674 = 0.25e2 / 0.81e2 * t5002;
  t5675 = 0.5e1 / 0.18e2 * t5075;
  t5677 = t1141 * t2636 * t1504;
  t5678 = 0.5e3 / 0.243e3 * t5677;
  t5679 = t5633 + t5635 + t5638 + t5642 + t5646 + t5650 + t5654 - t5658 - t5663 - t5667 - t5672 + t5673 + t5674 - t5675 - t5678;
  t5682 = t1141 * t2615 * t1504;
  t5683 = 0.5e3 / 0.243e3 * t5682;
  t5685 = t1141 * t530 * t5623;
  t5686 = 0.25e3 / 0.243e3 * t5685;
  t5687 = t439 * t5592;
  t5688 = t4393 * t5687;
  t5689 = 0.1e4 / 0.243e3 * t5688;
  t5690 = t530 * t5619;
  t5691 = t1141 * t5690;
  t5692 = 0.5e3 / 0.729e3 * t5691;
  t5693 = t4330 * t5611;
  t5694 = t1294 * t5693;
  t5695 = 0.2e5 / 0.729e3 * t5694;
  t5696 = t3132 * t146;
  t5697 = t5696 * t441;
  t5698 = t190 * t5697;
  t5699 = 0.5e2 / 0.81e2 * t5698;
  t5700 = t871 * t382;
  t5701 = t5700 * t441;
  t5702 = t190 * t5701;
  t5703 = 0.1e3 / 0.81e2 * t5702;
  t5704 = t193 * t1084;
  t5705 = t5704 * t441;
  t5706 = t190 * t5705;
  t5707 = 0.5e2 / 0.81e2 * t5706;
  t5708 = t2325 * t3957;
  t5709 = t4357 * t5708;
  t5710 = 0.2e4 / 0.81e2 * t5709;
  t5711 = t54 * t1046;
  t5713 = t152 * t5711 * t146;
  t5714 = t433 * t5713;
  t5715 = 0.5e1 / 0.9e1 * t5714;
  t5717 = t152 * t1483 * t382;
  t5718 = t433 * t5717;
  t5719 = 0.1e2 / 0.9e1 * t5718;
  t5721 = t152 * t434 * t1084;
  t5722 = t433 * t5721;
  t5723 = 0.5e1 / 0.9e1 * t5722;
  t5724 = t4960 * t355;
  t5725 = t1279 * t5724;
  t5726 = 0.2e3 / 0.81e2 * t5725;
  t5727 = -t5683 - t5686 - t5689 - t5692 + t5695 - t5699 - t5703 - t5707 + t5710 + t5715 + t5719 + t5723 + t4373 - t5726;
  t5728 = t1280 * t1028;
  t5729 = t1279 * t5728;
  t5730 = 0.2e3 / 0.81e2 * t5729;
  t5731 = t1280 * t1032;
  t5732 = t1279 * t5731;
  t5733 = 0.1e3 / 0.81e2 * t5732;
  t5734 = t1092 * t1322;
  t5735 = t5734 * t4147;
  t5736 = 0.25e2 / 0.162e3 * t5735;
  t5737 = t382 * t360;
  t5738 = t1296 * t5737;
  t5739 = t1338 * t5738;
  t5740 = t1336 * t5739;
  t5741 = 0.5e1 / 0.18e2 * t5740;
  t5742 = t146 * t1042;
  t5743 = t1296 * t5742;
  t5744 = t1338 * t5743;
  t5745 = t1336 * t5744;
  t5746 = 0.5e1 / 0.36e2 * t5745;
  t5747 = t4788 * t1516;
  t5748 = 0.5e1 / 0.18e2 * t5747;
  t5749 = t4788 * t1521;
  t5750 = 0.25e2 / 0.108e3 * t5749;
  t5751 = t382 * t336;
  t5752 = t1314 * t5751;
  t5753 = t1354 * t5752;
  t5754 = t1336 * t5753;
  t5755 = 0.25e2 / 0.108e3 * t5754;
  t5756 = t146 * t987;
  t5757 = t1314 * t5756;
  t5758 = t1354 * t5757;
  t5759 = t1336 * t5758;
  t5760 = 0.25e2 / 0.216e3 * t5759;
  t5761 = t146 * t983;
  t5762 = t4167 * t5761;
  t5763 = t1354 * t5762;
  t5764 = t1336 * t5763;
  t5765 = 0.25e2 / 0.324e3 * t5764;
  t5766 = t146 * t1037;
  t5767 = t1296 * t5766;
  t5768 = t4174 * t5767;
  t5769 = t1336 * t5768;
  t5770 = 0.5e1 / 0.12e2 * t5769;
  t5771 = t16 * t1084;
  t5772 = t446 * t5771;
  t5773 = t445 * t5772;
  t5774 = t154 * t5773;
  t5775 = 0.5e1 / 0.72e2 * t5774;
  t5776 = t1090 * t449;
  t5777 = 0.5e1 / 0.72e2 * t5776;
  t5778 = t388 * t1526;
  t5779 = 0.5e1 / 0.36e2 * t5778;
  t5780 = t447 * t1021;
  t5781 = t4483 * t5780;
  t5782 = t4482 * t5781;
  t5783 = 0.25e3 / 0.243e3 * t5782;
  t5784 = -t5730 - t5733 - t5736 - t5741 - t5746 - t5748 + t5750 + t5755 + t5760 + t5765 + t5770 + t5775 + t5777 + t5779 + t5783;
  tv3rho2tau4 = t9 * (t5629 + t5679 + t5727 + t5784) + 0.2e1 * t1545 + 0.2e1 * t1546 - 0.25e2 / 0.162e3 * t1512 + 0.5e1 / 0.36e2 * t1508 + 0.5e1 / 0.36e2 * t1527 - 0.2e3 / 0.81e2 * t1481 - 0.1e3 / 0.81e2 * t1498 - 0.1e3 / 0.81e2 * t1502 - 0.5e3 / 0.243e3 * t1506 + 0.5e2 / 0.27e2 * t1478 + 0.4e4 / 0.243e3 * t1494 + 0.1e2 / 0.9e1 * t1486 + 0.1e2 / 0.9e1 * t1490 - t4518 - t4520 - 0.5e1 / 0.18e2 * t1517 + 0.25e2 / 0.108e3 * t1522;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t5803 = t484 * t1084;
  t5804 = t1626 * t382;
  t5805 = 0.2e1 * t5804;
  t5808 = t54 * t999;
  t5809 = t152 * t5808;
  t5814 = t5522 * t1616;
  t5817 = t5288 * t346;
  t5818 = t1463 * t5817;
  t5821 = t5475 * t350;
  t5822 = t325 * t5821;
  t5826 = params->c * t993 * t27;
  t5827 = t325 * t5826;
  t5830 = t5337 * t346;
  t5831 = t801 * t5830;
  t5834 = t1421 * t1003;
  t5835 = t801 * t5834;
  t5842 = t54 * t1003;
  t5843 = t152 * t5842;
  t5846 = t27 * t1007;
  t5847 = t1463 * t5846;
  t5850 = t2 * t993;
  t5851 = t5850 * t27;
  t5852 = t5851 * t453;
  t5854 = t1410 * t1012;
  t5858 = t4652 * t999;
  t5862 = -0.1e4 / 0.243e3 * t5490 * t1534 - 0.5e2 / 0.81e2 * t4620 * t5809 + 0.1e3 / 0.81e2 * t1460 * t5604 + 0.2e5 / 0.729e3 * t543 * t5814 - 0.2e5 / 0.729e3 * t543 * t5818 + 0.1e4 / 0.243e3 * t4627 * t5822 + 0.2e4 / 0.729e3 * t324 * t5827 - 0.25e4 / 0.729e3 * t190 * t5831 + 0.25e3 / 0.243e3 * t190 * t5835 - 0.2e4 / 0.81e2 * t478 * t5600 + 0.25e3 / 0.81e2 * t5487 * t1611 - 0.25e2 / 0.27e2 * t1455 * t5843 - 0.2e4 / 0.243e3 * t543 * t5847 - 0.2e3 / 0.81e2 * t5852 + 0.1e5 / 0.729e3 * t2535 * t5854 * t50 + 0.5e3 / 0.729e3 * t190 * t801 * t5858;
  t5863 = t5862 * t146;
  t5864 = 0.175e3 / 0.162e3 * t5220;
  t5865 = 0.25e2 / 0.54e2 * t5223;
  t5866 = 0.35e2 / 0.27e2 * t5226;
  t5867 = 0.5e1 / 0.9e1 * t5229;
  t5868 = t4524 * t4015;
  t5869 = t1838 * t5868;
  t5870 = 0.25e2 / 0.81e2 * t5869;
  t5871 = t350 * t346;
  t5872 = t194 * t5871;
  t5873 = t4528 * t5872;
  t5874 = t1838 * t5873;
  t5875 = 0.125e3 / 0.486e3 * t5874;
  t5876 = t360 * t346;
  t5877 = t4742 * t5876;
  t5878 = t1843 * t5877;
  t5879 = t1336 * t5878;
  t5880 = 0.25e2 / 0.54e2 * t5879;
  t5881 = t1602 * t390;
  t5883 = t1323 * t1428 * t5881;
  t5884 = 0.25e2 / 0.162e3 * t5883;
  t5885 = t473 * t1098;
  t5887 = t1323 * t1428 * t5885;
  t5888 = 0.25e2 / 0.324e3 * t5887;
  t5889 = t5390 * t1584;
  t5890 = t1323 * t5889;
  t5891 = 0.125e3 / 0.486e3 * t5890;
  t5893 = t55 * t383 * t346;
  t5894 = t1396 * t5893;
  t5895 = 0.5e2 / 0.27e2 * t5894;
  t5897 = t55 * t147 * t1003;
  t5898 = t1396 * t5897;
  t5899 = 0.25e2 / 0.27e2 * t5898;
  t5900 = t5214 * t350;
  t5901 = t1295 * t5900;
  t5902 = t1294 * t5901;
  t5903 = 0.2e5 / 0.729e3 * t5902;
  t5905 = t55 * t147 * t999;
  t5906 = t4536 * t5905;
  t5907 = 0.5e2 / 0.81e2 * t5906;
  t5908 = t5803 + t5805 + t5863 - t5864 - t5865 + t5866 + t5867 + t5870 - t5875 + t4565 + t4568 - t5880 - t5884 - t5888 + t5891 + t5895 + t5899 - t5903 + t5907;
  t5909 = t4840 * t1563;
  t5910 = t1294 * t5909;
  t5911 = 0.4e4 / 0.243e3 * t5910;
  t5912 = t1410 * t1007;
  t5913 = t1295 * t5912;
  t5914 = t1294 * t5913;
  t5915 = 0.2e4 / 0.243e3 * t5914;
  t5916 = t4854 * t1564;
  t5917 = 0.4e4 / 0.243e3 * t5916;
  t5918 = t5438 * t1554;
  t5919 = 0.25e3 / 0.81e2 * t5918;
  t5921 = t55 * t365 * t346;
  t5922 = t1396 * t5921;
  t5923 = 0.5e2 / 0.27e2 * t5922;
  t5924 = t464 * t5717;
  t5925 = 0.1e2 / 0.9e1 * t5924;
  t5926 = t5850 * t463;
  t5927 = t5926 * t436;
  t5928 = 0.2e3 / 0.81e2 * t5927;
  t5929 = t464 * t5721;
  t5930 = 0.5e1 / 0.9e1 * t5929;
  t5931 = t1592 * t1602;
  t5932 = t445 * t5931;
  t5933 = t154 * t5932;
  t5934 = 0.25e2 / 0.108e3 * t5933;
  t5935 = t27 * t1084;
  t5936 = t472 * t5935;
  t5937 = t445 * t5936;
  t5938 = t154 * t5937;
  t5939 = 0.5e1 / 0.72e2 * t5938;
  t5940 = t1090 * t475;
  t5941 = 0.5e1 / 0.72e2 * t5940;
  t5942 = 0.175e3 / 0.243e3 * t5325;
  t5943 = 0.25e2 / 0.81e2 * t5328;
  t5944 = t1831 * t5817;
  t5945 = t1294 * t5944;
  t5946 = 0.2e5 / 0.729e3 * t5945;
  t5948 = t190 * t5696 * t468;
  t5949 = 0.5e2 / 0.81e2 * t5948;
  t5951 = t190 * t5700 * t468;
  t5952 = 0.1e3 / 0.81e2 * t5951;
  t5954 = t190 * t5704 * t468;
  t5955 = 0.5e2 / 0.81e2 * t5954;
  t5956 = t5240 * t1480;
  t5957 = 0.1e4 / 0.243e3 * t5956;
  t5958 = t1403 * t5724;
  t5959 = 0.2e3 / 0.81e2 * t5958;
  t5960 = t5911 + t5915 + t5917 - t5919 + t5923 + t5925 + t5928 + t5930 - t5934 + t5939 + t5941 + t5942 + t5943 + t5946 - t5949 - t5952 - t5955 + t5957 - t5959;
  t5962 = t1403 * t5728;
  t5963 = 0.2e3 / 0.81e2 * t5962;
  t5964 = t1403 * t5731;
  t5965 = 0.1e3 / 0.81e2 * t5964;
  t5967 = t190 * t439 * t5826;
  t5968 = 0.2e4 / 0.729e3 * t5967;
  t5970 = t190 * t1496 * t1574;
  t5971 = 0.5e3 / 0.243e3 * t5970;
  t5973 = t190 * t1500 * t1574;
  t5974 = 0.5e3 / 0.243e3 * t5973;
  t5975 = t5337 * t1597;
  t5976 = t1354 * t5975;
  t5977 = t1336 * t5976;
  t5978 = 0.125e3 / 0.324e3 * t5977;
  t5979 = t382 * t346;
  t5980 = t1421 * t5979;
  t5981 = t1354 * t5980;
  t5982 = t1336 * t5981;
  t5983 = 0.25e2 / 0.108e3 * t5982;
  t5984 = t146 * t1003;
  t5985 = t1421 * t5984;
  t5986 = t1354 * t5985;
  t5987 = t1336 * t5986;
  t5988 = 0.25e2 / 0.216e3 * t5987;
  t5989 = t1410 * t5737;
  t5990 = t1338 * t5989;
  t5991 = t1336 * t5990;
  t5992 = 0.5e1 / 0.18e2 * t5991;
  t5993 = t1410 * t5742;
  t5994 = t1338 * t5993;
  t5995 = t1336 * t5994;
  t5996 = 0.5e1 / 0.36e2 * t5995;
  t5997 = t4788 * t1589;
  t5998 = 0.5e1 / 0.18e2 * t5997;
  t5999 = t4788 * t1599;
  t6000 = 0.25e2 / 0.108e3 * t5999;
  t6001 = t5734 * t4696;
  t6002 = 0.25e2 / 0.162e3 * t6001;
  t6003 = t146 * t999;
  t6004 = t4652 * t6003;
  t6005 = t1354 * t6004;
  t6006 = t1336 * t6005;
  t6007 = 0.25e2 / 0.324e3 * t6006;
  t6008 = t1410 * t5766;
  t6009 = t4174 * t6008;
  t6010 = t1336 * t6009;
  t6011 = 0.5e1 / 0.12e2 * t6010;
  t6012 = t5214 * t1514;
  t6013 = t1338 * t6012;
  t6014 = t1336 * t6013;
  t6015 = 0.25e2 / 0.54e2 * t6014;
  t6016 = t530 * t5858;
  t6017 = t1141 * t6016;
  t6018 = 0.5e3 / 0.729e3 * t6017;
  t6020 = t1141 * t530 * t5830;
  t6021 = 0.25e4 / 0.729e3 * t6020;
  t6023 = t1141 * t530 * t5834;
  t6024 = 0.25e3 / 0.243e3 * t6023;
  t6025 = -t5963 - t5965 - t5968 + t5971 + t5974 - t5978 + t5983 + t5988 - t5992 - t5996 - t5998 + t6000 - t6002 + t6007 + t6011 + t6015 - t6018 + t6021 - t6024;
  t6027 = t1141 * t2636 * t1578;
  t6028 = 0.5e3 / 0.243e3 * t6027;
  t6030 = t1141 * t2615 * t1578;
  t6031 = 0.5e3 / 0.243e3 * t6030;
  t6032 = t439 * t5821;
  t6033 = t4719 * t6032;
  t6034 = 0.1e4 / 0.243e3 * t6033;
  t6035 = t1550 * t1485;
  t6036 = 0.5e2 / 0.27e2 * t6035;
  t6037 = t1550 * t1489;
  t6038 = 0.5e2 / 0.27e2 * t6037;
  t6039 = t4739 * t5708;
  t6040 = 0.2e4 / 0.81e2 * t6039;
  t6041 = t464 * t5713;
  t6042 = 0.5e1 / 0.9e1 * t6041;
  t6043 = t388 * t1604;
  t6044 = 0.5e1 / 0.36e2 * t6043;
  t6045 = t473 * t1021;
  t6046 = t4583 * t6045;
  t6047 = t4482 * t6046;
  t6048 = 0.25e3 / 0.243e3 * t6047;
  t6049 = t4596 * t5669;
  t6050 = t2556 * t6049;
  t6051 = 0.1e5 / 0.729e3 * t6050;
  t6052 = t62 * t993;
  t6053 = t6052 * t473;
  t6054 = t445 * t6053;
  t6055 = t154 * t6054;
  t6056 = 0.25e2 / 0.81e2 * t6055;
  t6057 = t388 * t1594;
  t6058 = 0.25e2 / 0.108e3 * t6057;
  t6059 = 0.35e2 / 0.54e2 * t5542;
  t6060 = 0.5e1 / 0.18e2 * t5544;
  t6061 = 0.175e3 / 0.162e3 * t5547;
  t6062 = 0.25e2 / 0.54e2 * t5552;
  t6063 = 0.35e2 / 0.54e2 * t5555;
  t6064 = 0.5e1 / 0.18e2 * t5559;
  t6065 = -t6028 - t6031 - t6034 - t6036 - t6038 + t6040 + t6042 + t4728 + t6044 + t6048 - t6051 + t6056 - t6058 - t6059 - t6060 + t6061 + t6062 - t6063 - t6064;
  t6088 = -0.5e3 / 0.243e3 * t1580 - 0.5e2 / 0.27e2 * t1551 + 0.5e2 / 0.27e2 * t1555 + 0.4e4 / 0.243e3 * t1565 + 0.1e2 / 0.9e1 * t1559 + 0.1e2 / 0.9e1 * t1561 - t4783 - t4785 - 0.5e1 / 0.18e2 * t1590 - 0.25e2 / 0.108e3 * t1595 + 0.25e2 / 0.108e3 * t1600;
  tv3rho2tau5 = t9 * (t5908 + t5960 + t6025 + t6065) + 0.2e1 * t1627 + 0.2e1 * t1628 - 0.25e2 / 0.162e3 * t1586 + 0.5e1 / 0.36e2 * t1582 + 0.5e1 / 0.36e2 * t1605 - 0.2e3 / 0.81e2 * t1557 - 0.1e3 / 0.81e2 * t1568 - 0.1e3 / 0.81e2 * t1571 + 0.5e3 / 0.243e3 * t1576 + t6088;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t6090 = 0.1e1 / t32 / t562;
  t6091 = t2 * t6090;
  t6092 = t6091 * t188;
  t6093 = t6092 * t531;
  t6094 = 0.25e2 / 0.243e3 * t6093;
  t6095 = t1633 * t542;
  t6096 = t6095 * t3079;
  t6097 = 0.125e3 / 0.324e3 * t6096;
  t6098 = t1634 * t1981;
  t6099 = 0.25e2 / 0.1296e4 * t6098;
  t6100 = t1634 * t1985;
  t6101 = 0.25e2 / 0.1296e4 * t6100;
  t6102 = t56 * t56;
  t6104 = 0.1e1 / t32 / t6102;
  t6105 = t2 * t6104;
  t6106 = t6105 * t45;
  t6107 = t6106 * t1642;
  t6108 = 0.55e2 / 0.432e3 * t6107;
  t6109 = t1640 * t189;
  t6110 = t192 * t61;
  t6111 = t6110 * t62;
  t6112 = t6111 * t195;
  t6113 = t6109 * t6112;
  t6114 = 0.25e2 / 0.648e3 * t6113;
  t6115 = t1640 * t50;
  t6116 = t54 * t206;
  t6117 = t6116 * t1153;
  t6118 = t6115 * t6117;
  t6119 = 0.5e1 / 0.288e3 * t6118;
  t6120 = t55 * t1157;
  t6121 = t1641 * t6120;
  t6122 = 0.5e1 / 0.144e3 * t6121;
  t6123 = t55 * t1161;
  t6124 = t1641 * t6123;
  t6125 = 0.5e1 / 0.288e3 * t6124;
  t6126 = t1958 * t1632;
  t6128 = t6126 * t180 * t50;
  t6129 = t2556 * t6128;
  t6130 = 0.625e3 / 0.2916e4 * t6129;
  t6132 = t543 * t217 * t1645;
  t6133 = 0.125e3 / 0.972e3 * t6132;
  t6135 = t543 * t317 * t1645;
  t6136 = 0.125e3 / 0.972e3 * t6135;
  t6137 = t544 * t6090;
  t6139 = t543 * t147 * t6137;
  t6140 = 0.5e3 / 0.729e3 * t6139;
  t6141 = t542 * t1639;
  t6142 = t39 * t6141;
  t6143 = t1295 * t180;
  t6144 = t63 * t6143;
  t6145 = t6142 * t6144;
  t6146 = 0.125e3 / 0.486e3 * t6145;
  t6148 = t192 * t6104 * t61;
  t6149 = t6148 * t1651;
  t6150 = t190 * t6149;
  t6151 = 0.275e3 / 0.1944e4 * t6150;
  t6152 = t194 * t209;
  t6154 = t1141 * t1708 * t6152;
  t6155 = 0.25e2 / 0.1296e4 * t6154;
  t6156 = t3493 * params->c;
  t6157 = t1650 * t6156;
  t6158 = t190 * t6157;
  t6159 = 0.25e2 / 0.648e3 * t6158;
  t6160 = t3581 * params->c;
  t6161 = t1650 * t6160;
  t6162 = t190 * t6161;
  t6163 = 0.25e2 / 0.1296e4 * t6162;
  t6165 = t6091 * t185 * t802;
  t6166 = 0.25e2 / 0.243e3 * t6165;
  t6167 = t1633 * t539;
  t6168 = t6167 * t2899;
  t6172 = t2535 * t1632 * t180 * t50;
  t6175 = t805 * t806 * t6090;
  t6176 = 0.5e3 / 0.729e3 * t6175;
  t6177 = -t6166 - 0.125e3 / 0.324e3 * t6168 + 0.625e3 / 0.2916e4 * t6172 + t6176;
  t6178 = t6177 * t146;
  t6179 = t1661 * t316;
  t6180 = t6094 + t6097 - t6099 - t6101 - t6108 - t6114 - t6119 + t6122 + t6125 - t6130 + t6133 + t6136 - t6140 + t6146 + t6151 + t6155 - t6159 - t6163 + t6178 + t6179;
  tv3rhosigma20 = t9 * t6180 - t1636 + t1644 + t1648 - t1654 + t1662;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t6182 = 0.5e2 / 0.243e3 * t6093;
  t6183 = 0.125e3 / 0.162e3 * t6096;
  t6184 = 0.25e2 / 0.648e3 * t6098;
  t6185 = 0.25e2 / 0.648e3 * t6100;
  t6186 = 0.55e2 / 0.216e3 * t6107;
  t6187 = 0.25e2 / 0.324e3 * t6113;
  t6188 = 0.5e1 / 0.144e3 * t6118;
  t6189 = 0.5e1 / 0.72e2 * t6121;
  t6190 = 0.5e1 / 0.144e3 * t6124;
  t6191 = 0.625e3 / 0.1458e4 * t6129;
  t6192 = 0.125e3 / 0.486e3 * t6132;
  t6193 = 0.125e3 / 0.486e3 * t6135;
  t6194 = 0.1e4 / 0.729e3 * t6139;
  t6195 = 0.125e3 / 0.243e3 * t6145;
  t6196 = 0.275e3 / 0.972e3 * t6150;
  t6197 = 0.25e2 / 0.648e3 * t6154;
  t6198 = 0.25e2 / 0.324e3 * t6158;
  t6199 = 0.25e2 / 0.648e3 * t6162;
  t6200 = 0.5e2 / 0.243e3 * t6165;
  t6203 = 0.1e4 / 0.729e3 * t6175;
  t6204 = -t6200 - 0.125e3 / 0.162e3 * t6168 + 0.625e3 / 0.1458e4 * t6172 + t6203;
  t6205 = t6204 * t146;
  t6206 = t1670 * t316;
  t6207 = t6182 + t6183 - t6184 - t6185 - t6186 - t6187 - t6188 + t6189 + t6190 - t6191 + t6192 + t6193 - t6194 + t6195 + t6196 + t6197 - t6198 - t6199 + t6205 + t6206;
  tv3rhosigma21 = t9 * t6207 - t1664 + t1665 + t1666 - t1667 + t1671;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = tv3rhosigma20;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  t6209 = 0.1e3 / 0.243e3 * t6093;
  t6210 = 0.125e3 / 0.81e2 * t6096;
  t6211 = 0.25e2 / 0.324e3 * t6098;
  t6212 = 0.25e2 / 0.324e3 * t6100;
  t6213 = 0.55e2 / 0.108e3 * t6107;
  t6214 = 0.25e2 / 0.162e3 * t6113;
  t6215 = 0.5e1 / 0.72e2 * t6118;
  t6216 = 0.5e1 / 0.36e2 * t6121;
  t6217 = 0.5e1 / 0.72e2 * t6124;
  t6218 = 0.625e3 / 0.729e3 * t6129;
  t6219 = 0.125e3 / 0.243e3 * t6132;
  t6220 = 0.125e3 / 0.243e3 * t6135;
  t6221 = 0.2e4 / 0.729e3 * t6139;
  t6222 = 0.25e3 / 0.243e3 * t6145;
  t6223 = 0.275e3 / 0.486e3 * t6150;
  t6224 = 0.25e2 / 0.324e3 * t6154;
  t6225 = 0.25e2 / 0.162e3 * t6158;
  t6226 = 0.25e2 / 0.324e3 * t6162;
  t6227 = 0.1e3 / 0.243e3 * t6165;
  t6230 = 0.2e4 / 0.729e3 * t6175;
  t6231 = -t6227 - 0.125e3 / 0.81e2 * t6168 + 0.625e3 / 0.729e3 * t6172 + t6230;
  t6232 = t6231 * t146;
  t6233 = t1679 * t316;
  t6234 = t6209 + t6210 - t6211 - t6212 - t6213 - t6214 - t6215 + t6216 + t6217 - t6218 + t6219 + t6220 - t6221 + t6222 + t6223 + t6224 - t6225 - t6226 + t6232 + t6233;
  tv3rhosigma23 = t9 * t6234 - t1673 + t1674 + t1675 - t1676 + t1680;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = tv3rhosigma21;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = tv3rhosigma22;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t6236 = t147 * t853;
  t6237 = t6095 * t6236;
  t6238 = 0.125e3 / 0.324e3 * t6237;
  t6239 = t1634 * t2637;
  t6240 = 0.25e2 / 0.1296e4 * t6239;
  t6241 = t1634 * t2616;
  t6242 = 0.25e2 / 0.1296e4 * t6241;
  t6243 = t6111 * t355;
  t6244 = t6109 * t6243;
  t6245 = 0.25e2 / 0.648e3 * t6244;
  t6246 = t6116 * t1230;
  t6247 = t6115 * t6246;
  t6248 = 0.5e1 / 0.288e3 * t6247;
  t6249 = t55 * t1234;
  t6250 = t1641 * t6249;
  t6251 = 0.5e1 / 0.288e3 * t6250;
  t6253 = t6126 * t350 * t50;
  t6254 = t2556 * t6253;
  t6255 = 0.625e3 / 0.2916e4 * t6254;
  t6257 = t543 * t365 * t1645;
  t6258 = 0.125e3 / 0.972e3 * t6257;
  t6260 = t543 * t383 * t1645;
  t6261 = 0.125e3 / 0.972e3 * t6260;
  t6262 = t1295 * t350;
  t6263 = t63 * t6262;
  t6264 = t6142 * t6263;
  t6265 = 0.125e3 / 0.486e3 * t6264;
  t6266 = t194 * t360;
  t6268 = t1141 * t1708 * t6266;
  t6269 = 0.25e2 / 0.1296e4 * t6268;
  t6270 = t3835 * params->c;
  t6271 = t1650 * t6270;
  t6272 = t190 * t6271;
  t6273 = 0.25e2 / 0.1296e4 * t6272;
  t6274 = t806 * t350;
  t6275 = t6167 * t6274;
  t6277 = t1632 * t350;
  t6279 = t2535 * t6277 * t50;
  t6281 = -t6166 - 0.125e3 / 0.324e3 * t6275 + 0.625e3 / 0.2916e4 * t6279 + t6176;
  t6282 = t6281 * t146;
  t6283 = t1661 * t382;
  t6284 = t6094 + t6238 - t6240 - t6242 - t6108 - t6245 - t6248 - t6122 + t6251 - t6255 + t6258 + t6261 - t6140 + t6265 + t6151 + t6269 + t6159 - t6273 + t6282 + t6283;
  tv3rhosigma26 = t9 * t6284 - t1636 + t1644 + t1648 - t1654 + t1662;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  t6286 = 0.125e3 / 0.162e3 * t6237;
  t6287 = 0.25e2 / 0.648e3 * t6239;
  t6288 = 0.25e2 / 0.648e3 * t6241;
  t6289 = 0.25e2 / 0.324e3 * t6244;
  t6290 = 0.5e1 / 0.144e3 * t6247;
  t6291 = 0.5e1 / 0.144e3 * t6250;
  t6292 = 0.625e3 / 0.1458e4 * t6254;
  t6293 = 0.125e3 / 0.486e3 * t6257;
  t6294 = 0.125e3 / 0.486e3 * t6260;
  t6295 = 0.125e3 / 0.243e3 * t6264;
  t6296 = 0.25e2 / 0.648e3 * t6268;
  t6297 = 0.25e2 / 0.648e3 * t6272;
  t6300 = -t6200 - 0.125e3 / 0.162e3 * t6275 + 0.625e3 / 0.1458e4 * t6279 + t6203;
  t6301 = t6300 * t146;
  t6302 = t1670 * t382;
  t6303 = t6182 + t6286 - t6287 - t6288 - t6186 - t6289 - t6290 - t6189 + t6291 - t6292 + t6293 + t6294 - t6194 + t6295 + t6196 + t6296 + t6198 - t6297 + t6301 + t6302;
  tv3rhosigma27 = t9 * t6303 - t1664 + t1665 + t1666 - t1667 + t1671;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = tv3rhosigma26;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  t6305 = 0.125e3 / 0.81e2 * t6237;
  t6306 = 0.25e2 / 0.324e3 * t6239;
  t6307 = 0.25e2 / 0.324e3 * t6241;
  t6308 = 0.25e2 / 0.162e3 * t6244;
  t6309 = 0.5e1 / 0.72e2 * t6247;
  t6310 = 0.5e1 / 0.72e2 * t6250;
  t6311 = 0.625e3 / 0.729e3 * t6254;
  t6312 = 0.125e3 / 0.243e3 * t6257;
  t6313 = 0.125e3 / 0.243e3 * t6260;
  t6314 = 0.25e3 / 0.243e3 * t6264;
  t6315 = 0.25e2 / 0.324e3 * t6268;
  t6316 = 0.25e2 / 0.324e3 * t6272;
  t6319 = -t6227 - 0.125e3 / 0.81e2 * t6275 + 0.625e3 / 0.729e3 * t6279 + t6230;
  t6320 = t6319 * t146;
  t6321 = t1679 * t382;
  t6322 = t6209 + t6305 - t6306 - t6307 - t6213 - t6308 - t6309 - t6216 + t6310 - t6311 + t6312 + t6313 - t6221 + t6314 + t6223 + t6315 + t6225 - t6316 + t6320 + t6321;
  tv3rhosigma29 = t9 * t6322 - t1673 + t1674 + t1675 - t1676 + t1680;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = tv3rhosigma27;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = tv3rhosigma28;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t6324 = t1296 * t316;
  t6325 = t1702 * t6324;
  t6326 = t1700 * t6325;
  t6327 = 0.5e1 / 0.576e3 * t6326;
  t6328 = t322 * t1712;
  t6329 = 0.5e1 / 0.72e2 * t6328;
  t6330 = t1354 * t6324;
  t6331 = t154 * t6330;
  t6332 = 0.5e1 / 0.72e2 * t6331;
  t6333 = t416 * t167;
  t6334 = t439 * t6333;
  t6335 = t4393 * t6334;
  t6336 = 0.125e3 / 0.486e3 * t6335;
  t6337 = t4392 * t50;
  t6338 = t408 * t61;
  t6339 = t1152 * t167;
  t6340 = t6338 * t6339;
  t6341 = t6337 * t6340;
  t6342 = 0.25e2 / 0.216e3 * t6341;
  t6343 = t452 * t50;
  t6344 = t6343 * t1154;
  t6345 = 0.5e1 / 0.72e2 * t6344;
  t6346 = t541 * t58;
  t6347 = t6346 * t61;
  t6348 = t805 * t6347;
  t6349 = t1152 * t544;
  t6350 = t6349 * t1297;
  t6351 = t6348 * t6350;
  t6352 = 0.25e3 / 0.243e3 * t6351;
  t6353 = t4139 * t1703;
  t6354 = t154 * t6353;
  t6355 = 0.5e1 / 0.36e2 * t6354;
  t6356 = t4262 * t146;
  t6357 = t1354 * t6356;
  t6358 = t154 * t6357;
  t6359 = 0.25e2 / 0.216e3 * t6358;
  t6360 = t6105 * t40;
  t6361 = t6360 * t153;
  t6362 = t6361 * t1704;
  t6363 = 0.55e2 / 0.864e3 * t6362;
  t6364 = t1701 * t8;
  t6365 = t6364 * t1703;
  t6366 = t1700 * t6365;
  t6367 = 0.5e1 / 0.288e3 * t6366;
  t6368 = t1702 * t6356;
  t6369 = t1700 * t6368;
  t6370 = 0.25e2 / 0.1728e4 * t6369;
  t6371 = -t6327 + t6329 + t6332 + t6336 - t6342 + t6345 - t6352 + t6355 - t6359 + t6363 - t6367 + t6370;
  t6372 = t4156 * t1703;
  t6373 = t154 * t6372;
  t6374 = 0.35e2 / 0.108e3 * t6373;
  t6375 = t1639 * t573;
  t6376 = t6375 * t446;
  t6377 = params->c * t209;
  t6378 = t447 * t6377;
  t6379 = t6376 * t6378;
  t6380 = t1323 * t6379;
  t6381 = 0.25e2 / 0.1296e4 * t6380;
  t6382 = t1707 * t446;
  t6383 = t4248 * t4394;
  t6384 = t6382 * t6383;
  t6385 = t1323 * t6384;
  t6386 = 0.125e3 / 0.7776e4 * t6385;
  t6387 = t15 * t35;
  t6388 = t6387 * t167;
  t6389 = t4330 * t6388;
  t6390 = t1294 * t6389;
  t6391 = 0.125e4 / 0.729e3 * t6390;
  t6392 = t4188 * t403;
  t6393 = t1279 * t6392;
  t6394 = 0.25e2 / 0.162e3 * t6393;
  t6395 = t1280 * t1128;
  t6396 = t1279 * t6395;
  t6397 = 0.25e2 / 0.162e3 * t6396;
  t6398 = t1687 * t1161;
  t6399 = t1686 * t6398;
  t6400 = 0.5e1 / 0.72e2 * t6399;
  t6401 = t55 * t201;
  t6402 = t6401 * t409;
  t6403 = t1686 * t6402;
  t6404 = 0.35e2 / 0.108e3 * t6403;
  t6405 = t1687 * t1157;
  t6406 = t1686 * t6405;
  t6407 = 0.5e1 / 0.36e2 * t6406;
  t6408 = t4286 * t1682;
  t6409 = 0.125e3 / 0.486e3 * t6408;
  t6410 = t1280 * t1132;
  t6411 = t1279 * t6410;
  t6412 = 0.1e3 / 0.243e3 * t6411;
  t6413 = t1266 * t1685;
  t6414 = t6413 * t1688;
  t6415 = 0.25e2 / 0.216e3 * t6414;
  t6416 = t4262 * t35;
  t6417 = t1295 * t6416;
  t6418 = t1294 * t6417;
  t6419 = 0.125e4 / 0.729e3 * t6418;
  t6420 = -t6374 - t6381 + t6386 - t6391 + t6394 + t6397 - t6400 + t6404 - t6407 - t6409 - t6412 + t6415 + t6419;
  t6422 = t1296 * t177;
  t6423 = t1295 * t6422;
  t6424 = t1294 * t6423;
  t6425 = 0.2e4 / 0.729e3 * t6424;
  t6426 = t4987 * t1122;
  t6427 = 0.25e3 / 0.81e2 * t6426;
  t6428 = t4307 * t1692;
  t6429 = 0.25e3 / 0.243e3 * t6428;
  t6430 = t4310 * t1691;
  t6431 = t1294 * t6430;
  t6432 = 0.25e3 / 0.243e3 * t6431;
  t6433 = t30 * t573;
  t6434 = t6433 * t62;
  t6435 = t6434 * t1340;
  t6436 = t1700 * t6435;
  t6437 = 0.5e1 / 0.288e3 * t6436;
  t6438 = t1702 * t1356;
  t6439 = t1700 * t6438;
  t6440 = 0.25e2 / 0.1728e4 * t6439;
  t6441 = t4480 * t1639;
  t6442 = t805 * t6441;
  t6443 = t447 * t1975;
  t6444 = t4483 * t6443;
  t6445 = t6442 * t6444;
  t6446 = 0.125e3 / 0.972e3 * t6445;
  t6447 = t154 * t1341;
  t6448 = 0.5e1 / 0.36e2 * t6447;
  t6449 = t154 * t1357;
  t6450 = 0.25e2 / 0.216e3 * t6449;
  t6451 = t452 * t189;
  t6452 = t1152 * t326;
  t6453 = t3573 * t6452;
  t6454 = t6451 * t6453;
  t6455 = 0.25e2 / 0.162e3 * t6454;
  t6456 = t553 * t1296;
  t6457 = t1143 * t6456;
  t6458 = t1141 * t6457;
  t6459 = 0.25e2 / 0.324e3 * t6458;
  t6460 = t3400 * t1695;
  t6461 = t1141 * t6460;
  t6462 = 0.175e3 / 0.486e3 * t6461;
  t6463 = t6425 - t6427 - t6429 - t6432 + t6437 - t6440 - t6446 - t6448 + t6450 + t6455 + t6459 - t6462;
  t6464 = t3404 * t1695;
  t6465 = t1141 * t6464;
  t6466 = 0.25e2 / 0.162e3 * t6465;
  t6467 = t194 * t4262;
  t6468 = t1143 * t6467;
  t6469 = t1141 * t6468;
  t6470 = 0.125e3 / 0.972e3 * t6469;
  t6471 = t1723 * t316;
  t6472 = t4431 * t1716;
  t6474 = t325 * t6333;
  t6475 = t4407 * t6474;
  t6477 = t4357 * t1172;
  t6480 = t800 * t801 * t177;
  t6481 = t1373 * t6480;
  t6482 = 0.1e3 / 0.243e3 * t6481;
  t6484 = t1719 * t180 * t50;
  t6485 = t5113 * t6484;
  t6488 = t543 * t4424 * t1719;
  t6490 = t1378 * t6388;
  t6491 = t543 * t6490;
  t6493 = t16 * t177;
  t6495 = t543 * t1378 * t6493;
  t6496 = 0.2e4 / 0.729e3 * t6495;
  t6497 = 0.125e3 / 0.486e3 * t6472 - 0.125e3 / 0.486e3 * t6475 + 0.25e3 / 0.81e2 * t6477 + t6482 - 0.125e4 / 0.729e3 * t6485 - 0.125e4 / 0.729e3 * t6488 + 0.125e4 / 0.729e3 * t6491 - t6496;
  t6498 = t6497 * t146;
  t6499 = t1708 * t6456;
  t6500 = t1323 * t6499;
  t6501 = 0.25e2 / 0.2592e4 * t6500;
  t6502 = t800 * t3572;
  t6503 = t1139 * t6502;
  t6504 = t4483 * t1326;
  t6505 = t6503 * t6504;
  t6506 = 0.25e2 / 0.324e3 * t6505;
  t6507 = t1691 * t3853;
  t6508 = t4799 * t6507;
  t6509 = 0.125e4 / 0.729e3 * t6508;
  t6510 = t16 * t209;
  t6511 = t440 * t6510;
  t6512 = t1797 * t6511;
  t6513 = t6503 * t6512;
  t6514 = 0.25e2 / 0.324e3 * t6513;
  t6515 = t440 * t168;
  t6516 = t409 * t6515;
  t6517 = t6503 * t6516;
  t6518 = 0.125e3 / 0.972e3 * t6517;
  t6519 = t1640 * t185;
  t6520 = t6519 * t1322;
  t6521 = t6520 * t6504;
  t6522 = 0.25e2 / 0.1296e4 * t6521;
  t6523 = t6104 * t206;
  t6524 = t6523 * t62;
  t6525 = t6524 * t1695;
  t6526 = t1323 * t6525;
  t6527 = 0.275e3 / 0.3888e4 * t6526;
  t6528 = t1707 * t8;
  t6529 = t6528 * t1695;
  t6530 = t1323 * t6529;
  t6531 = 0.25e2 / 0.1296e4 * t6530;
  t6532 = t1708 * t6467;
  t6533 = t1323 * t6532;
  t6534 = 0.125e3 / 0.7776e4 * t6533;
  t6535 = t6466 - t6470 + t6471 + t6498 + t6501 - t6506 + t6509 - t6514 + t6518 + t6522 - t6527 + t6531 - t6534;
  tv3rhosigmatau0 = t1684 - t1690 - t1694 + t1698 - t1706 + t1711 + t1714 + t1724 + t9 * (t6371 + t6420 + t6463 + t6535);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t6539 = t1410 * t316;
  t6540 = t1354 * t6539;
  t6541 = t154 * t6540;
  t6542 = 0.5e1 / 0.72e2 * t6541;
  t6543 = t416 * t171;
  t6544 = t439 * t6543;
  t6545 = t4719 * t6544;
  t6546 = 0.125e3 / 0.486e3 * t6545;
  t6547 = t4718 * t50;
  t6548 = t1152 * t171;
  t6549 = t6338 * t6548;
  t6550 = t6547 * t6549;
  t6551 = 0.25e2 / 0.216e3 * t6550;
  t6552 = t478 * t50;
  t6553 = t6552 * t1154;
  t6554 = 0.5e1 / 0.72e2 * t6553;
  t6555 = t6349 * t1411;
  t6556 = t6348 * t6555;
  t6557 = 0.25e3 / 0.243e3 * t6556;
  t6558 = t1702 * t6539;
  t6559 = t1700 * t6558;
  t6560 = 0.5e1 / 0.576e3 * t6559;
  t6561 = t322 * t1747;
  t6562 = 0.5e1 / 0.72e2 * t6561;
  t6563 = t6375 * t472;
  t6564 = t473 * t6377;
  t6566 = t1323 * t6563 * t6564;
  t6567 = 0.25e2 / 0.1296e4 * t6566;
  t6568 = t1707 * t472;
  t6569 = t4742 * t4628;
  t6571 = t1323 * t6568 * t6569;
  t6572 = 0.125e3 / 0.7776e4 * t6571;
  t6573 = t1403 * t6392;
  t6574 = 0.25e2 / 0.162e3 * t6573;
  t6576 = t1403 * t6395;
  t6577 = 0.25e2 / 0.162e3 * t6576;
  t6578 = t1729 * t6398;
  t6579 = 0.5e1 / 0.72e2 * t6578;
  t6580 = t26 * t35;
  t6581 = t6580 * t171;
  t6582 = t1831 * t6581;
  t6583 = t1294 * t6582;
  t6584 = 0.125e4 / 0.729e3 * t6583;
  t6585 = t1729 * t6402;
  t6586 = 0.35e2 / 0.108e3 * t6585;
  t6587 = t1729 * t6405;
  t6588 = 0.5e1 / 0.36e2 * t6587;
  t6589 = t1403 * t6410;
  t6590 = 0.1e3 / 0.243e3 * t6589;
  t6591 = t6364 * t1740;
  t6592 = t1700 * t6591;
  t6593 = 0.5e1 / 0.288e3 * t6592;
  t6594 = t1410 * t177;
  t6595 = t1295 * t6594;
  t6596 = t1294 * t6595;
  t6597 = 0.2e4 / 0.729e3 * t6596;
  t6598 = t5452 * t1122;
  t6599 = 0.25e3 / 0.81e2 * t6598;
  t6600 = t4307 * t1733;
  t6601 = 0.25e3 / 0.243e3 * t6600;
  t6602 = t4310 * t1732;
  t6603 = t1294 * t6602;
  t6604 = 0.25e3 / 0.243e3 * t6603;
  t6605 = t6577 - t6579 - t6584 + t6586 - t6588 - t6590 - t6593 + t6597 - t6599 - t6601 - t6604;
  t6607 = t325 * t6543;
  t6608 = t4627 * t6607;
  t6610 = t4739 * t1172;
  t6612 = t1460 * t6480;
  t6613 = 0.1e3 / 0.243e3 * t6612;
  t6615 = t1752 * t180 * t50;
  t6616 = t5510 * t6615;
  t6619 = t543 * t1463 * t6581;
  t6621 = t27 * t177;
  t6623 = t543 * t1463 * t6621;
  t6624 = 0.2e4 / 0.729e3 * t6623;
  t6625 = -0.125e3 / 0.486e3 * t6608 + 0.25e3 / 0.81e2 * t6610 + t6613 - 0.125e4 / 0.729e3 * t6616 + 0.125e4 / 0.729e3 * t6619 - t6624;
  t6626 = t6625 * t146;
  t6627 = t4156 * t1740;
  t6628 = t154 * t6627;
  t6629 = 0.35e2 / 0.108e3 * t6628;
  t6630 = t4139 * t1740;
  t6631 = t154 * t6630;
  t6632 = 0.5e1 / 0.36e2 * t6631;
  t6633 = t6361 * t1741;
  t6634 = 0.55e2 / 0.864e3 * t6633;
  t6635 = t473 * t1975;
  t6636 = t4583 * t6635;
  t6637 = t6442 * t6636;
  t6638 = 0.125e3 / 0.972e3 * t6637;
  t6640 = t1141 * t3400 * t1736;
  t6641 = 0.175e3 / 0.486e3 * t6640;
  t6643 = t1141 * t3404 * t1736;
  t6644 = 0.25e2 / 0.162e3 * t6643;
  t6645 = t154 * t1437;
  t6646 = 0.5e1 / 0.36e2 * t6645;
  t6647 = t154 * t1447;
  t6648 = 0.25e2 / 0.216e3 * t6647;
  t6649 = t1826 * t6453;
  t6650 = 0.25e2 / 0.162e3 * t6649;
  t6651 = t553 * t1410;
  t6653 = t1141 * t1143 * t6651;
  t6654 = 0.25e2 / 0.324e3 * t6653;
  t6655 = t6626 - t6629 + t6632 + t6634 - t6638 - t6641 + t6644 - t6646 + t6648 + t6650 + t6654;
  t6656 = t6434 * t1436;
  t6657 = t1700 * t6656;
  t6658 = 0.5e1 / 0.288e3 * t6657;
  t6659 = t1702 * t1446;
  t6660 = t1700 * t6659;
  t6661 = 0.25e2 / 0.1728e4 * t6660;
  t6662 = t1756 * t316;
  t6663 = t4583 * t1429;
  t6664 = t6520 * t6663;
  t6665 = 0.25e2 / 0.1296e4 * t6664;
  t6666 = t1708 * t6651;
  t6667 = t1323 * t6666;
  t6668 = 0.25e2 / 0.2592e4 * t6667;
  t6669 = t6503 * t6663;
  t6670 = 0.25e2 / 0.324e3 * t6669;
  t6671 = t1732 * t3853;
  t6672 = t4799 * t6671;
  t6673 = 0.125e4 / 0.729e3 * t6672;
  t6674 = t27 * t209;
  t6675 = t467 * t6674;
  t6676 = t1797 * t6675;
  t6677 = t6503 * t6676;
  t6678 = 0.25e2 / 0.324e3 * t6677;
  t6679 = t467 * t172;
  t6680 = t409 * t6679;
  t6681 = t6503 * t6680;
  t6682 = 0.125e3 / 0.972e3 * t6681;
  t6683 = t6524 * t1736;
  t6684 = t1323 * t6683;
  t6685 = 0.275e3 / 0.3888e4 * t6684;
  t6686 = t6528 * t1736;
  t6687 = t1323 * t6686;
  t6688 = 0.25e2 / 0.1296e4 * t6687;
  t6689 = t6658 - t6661 + t6662 + t6665 + t6668 - t6670 + t6673 - t6678 + t6682 - t6685 + t6688;
  tv3rhosigmatau1 = t1727 - t1731 - t1735 + t1739 - t1743 + t1746 + t1749 + t1757 + t9 * (t6542 + t6546 - t6551 + t6554 - t6557 - t6560 + t6562 - t6567 + t6572 + t6574 + t6605 + t6655 + t6689);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  t6693 = 0.5e1 / 0.288e3 * t6326;
  t6694 = 0.5e1 / 0.36e2 * t6328;
  t6695 = 0.5e1 / 0.36e2 * t6331;
  t6696 = 0.125e3 / 0.243e3 * t6335;
  t6697 = 0.25e2 / 0.108e3 * t6341;
  t6698 = 0.5e1 / 0.36e2 * t6344;
  t6699 = 0.5e3 / 0.243e3 * t6351;
  t6700 = 0.5e1 / 0.18e2 * t6354;
  t6701 = 0.25e2 / 0.108e3 * t6358;
  t6702 = 0.55e2 / 0.432e3 * t6362;
  t6703 = 0.5e1 / 0.144e3 * t6366;
  t6704 = 0.25e2 / 0.864e3 * t6369;
  t6705 = -t6693 + t6694 + t6695 + t6696 - t6697 + t6698 - t6699 + t6700 - t6701 + t6702 - t6703 + t6704;
  t6706 = 0.35e2 / 0.54e2 * t6373;
  t6710 = 0.2e3 / 0.243e3 * t6481;
  t6714 = 0.4e4 / 0.729e3 * t6495;
  t6715 = 0.125e3 / 0.243e3 * t6472 - 0.125e3 / 0.243e3 * t6475 + 0.5e3 / 0.81e2 * t6477 + t6710 - 0.25e4 / 0.729e3 * t6485 - 0.25e4 / 0.729e3 * t6488 + 0.25e4 / 0.729e3 * t6491 - t6714;
  t6716 = t6715 * t146;
  t6717 = 0.25e2 / 0.648e3 * t6380;
  t6718 = 0.125e3 / 0.3888e4 * t6385;
  t6719 = 0.25e4 / 0.729e3 * t6390;
  t6720 = 0.25e2 / 0.81e2 * t6393;
  t6721 = 0.25e2 / 0.81e2 * t6396;
  t6722 = 0.5e1 / 0.36e2 * t6399;
  t6723 = 0.35e2 / 0.54e2 * t6403;
  t6724 = 0.5e1 / 0.18e2 * t6406;
  t6725 = 0.125e3 / 0.243e3 * t6408;
  t6726 = 0.2e3 / 0.243e3 * t6411;
  t6727 = 0.25e2 / 0.108e3 * t6414;
  t6728 = -t6706 + t6716 - t6717 + t6718 - t6719 + t6720 + t6721 - t6722 + t6723 - t6724 - t6725 - t6726 + t6727;
  t6730 = t1768 * t316;
  t6731 = 0.25e4 / 0.729e3 * t6418;
  t6732 = 0.4e4 / 0.729e3 * t6424;
  t6733 = 0.5e3 / 0.81e2 * t6426;
  t6734 = 0.5e3 / 0.243e3 * t6428;
  t6735 = 0.5e3 / 0.243e3 * t6431;
  t6736 = 0.5e1 / 0.144e3 * t6436;
  t6737 = 0.25e2 / 0.864e3 * t6439;
  t6738 = 0.125e3 / 0.486e3 * t6445;
  t6739 = 0.5e1 / 0.18e2 * t6447;
  t6740 = 0.25e2 / 0.108e3 * t6449;
  t6741 = 0.25e2 / 0.81e2 * t6454;
  t6742 = t6730 + t6731 + t6732 - t6733 - t6734 - t6735 + t6736 - t6737 - t6738 - t6739 + t6740 + t6741;
  t6743 = 0.25e2 / 0.162e3 * t6458;
  t6744 = 0.175e3 / 0.243e3 * t6461;
  t6745 = 0.25e2 / 0.81e2 * t6465;
  t6746 = 0.125e3 / 0.486e3 * t6469;
  t6747 = 0.25e2 / 0.1296e4 * t6500;
  t6748 = 0.25e2 / 0.162e3 * t6505;
  t6749 = 0.25e4 / 0.729e3 * t6508;
  t6750 = 0.25e2 / 0.162e3 * t6513;
  t6751 = 0.125e3 / 0.486e3 * t6517;
  t6752 = 0.25e2 / 0.648e3 * t6521;
  t6753 = 0.275e3 / 0.1944e4 * t6526;
  t6754 = 0.25e2 / 0.648e3 * t6530;
  t6755 = 0.125e3 / 0.3888e4 * t6533;
  t6756 = t6743 - t6744 + t6745 - t6746 + t6747 - t6748 + t6749 - t6750 + t6751 + t6752 - t6753 + t6754 - t6755;
  tv3rhosigmatau2 = t1759 - t1760 - t1761 + t1762 - t1763 + t1764 + t1765 + t1769 + t9 * (t6705 + t6728 + t6742 + t6756);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  t6760 = 0.5e1 / 0.36e2 * t6541;
  t6761 = 0.125e3 / 0.243e3 * t6545;
  t6762 = 0.25e2 / 0.108e3 * t6550;
  t6763 = 0.5e1 / 0.36e2 * t6553;
  t6764 = 0.5e3 / 0.243e3 * t6556;
  t6765 = 0.5e1 / 0.288e3 * t6559;
  t6766 = 0.5e1 / 0.36e2 * t6561;
  t6767 = t1780 * t316;
  t6768 = 0.25e2 / 0.648e3 * t6566;
  t6769 = 0.125e3 / 0.3888e4 * t6571;
  t6771 = 0.25e2 / 0.81e2 * t6573;
  t6772 = 0.25e2 / 0.81e2 * t6576;
  t6773 = 0.5e1 / 0.36e2 * t6578;
  t6774 = 0.25e4 / 0.729e3 * t6583;
  t6775 = 0.35e2 / 0.54e2 * t6585;
  t6776 = 0.5e1 / 0.18e2 * t6587;
  t6777 = 0.2e3 / 0.243e3 * t6589;
  t6778 = 0.5e1 / 0.144e3 * t6592;
  t6779 = 0.4e4 / 0.729e3 * t6596;
  t6780 = 0.5e3 / 0.81e2 * t6598;
  t6781 = 0.5e3 / 0.243e3 * t6600;
  t6782 = t6771 + t6772 - t6773 - t6774 + t6775 - t6776 - t6777 - t6778 + t6779 - t6780 - t6781;
  t6784 = 0.5e3 / 0.243e3 * t6603;
  t6787 = 0.2e3 / 0.243e3 * t6612;
  t6790 = 0.4e4 / 0.729e3 * t6623;
  t6791 = -0.125e3 / 0.243e3 * t6608 + 0.5e3 / 0.81e2 * t6610 + t6787 - 0.25e4 / 0.729e3 * t6616 + 0.25e4 / 0.729e3 * t6619 - t6790;
  t6792 = t6791 * t146;
  t6793 = 0.35e2 / 0.54e2 * t6628;
  t6794 = 0.5e1 / 0.18e2 * t6631;
  t6795 = 0.55e2 / 0.432e3 * t6633;
  t6796 = 0.125e3 / 0.486e3 * t6637;
  t6797 = 0.175e3 / 0.243e3 * t6640;
  t6798 = 0.25e2 / 0.81e2 * t6643;
  t6799 = 0.5e1 / 0.18e2 * t6645;
  t6800 = 0.25e2 / 0.108e3 * t6647;
  t6801 = 0.25e2 / 0.81e2 * t6649;
  t6802 = -t6784 + t6792 - t6793 + t6794 + t6795 - t6796 - t6797 + t6798 - t6799 + t6800 + t6801;
  t6803 = 0.25e2 / 0.162e3 * t6653;
  t6804 = 0.5e1 / 0.144e3 * t6657;
  t6805 = 0.25e2 / 0.864e3 * t6660;
  t6806 = 0.25e2 / 0.648e3 * t6664;
  t6807 = 0.25e2 / 0.1296e4 * t6667;
  t6808 = 0.25e2 / 0.162e3 * t6669;
  t6809 = 0.25e4 / 0.729e3 * t6672;
  t6810 = 0.25e2 / 0.162e3 * t6677;
  t6811 = 0.125e3 / 0.486e3 * t6681;
  t6812 = 0.275e3 / 0.1944e4 * t6684;
  t6813 = 0.25e2 / 0.648e3 * t6687;
  t6814 = t6803 + t6804 - t6805 + t6806 + t6807 - t6808 + t6809 - t6810 + t6811 - t6812 + t6813;
  tv3rhosigmatau3 = t1771 - t1772 - t1773 + t1774 - t1775 + t1776 + t1777 + t1781 + t9 * (t6760 + t6761 - t6762 + t6763 - t6764 - t6765 + t6766 + t6767 - t6768 + t6769 + t6782 + t6802 + t6814);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = tv3rhosigmatau0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = tv3rhosigmatau1;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t6818 = t1296 * t382;
  t6819 = t1354 * t6818;
  t6820 = t154 * t6819;
  t6821 = 0.5e1 / 0.72e2 * t6820;
  t6822 = t1152 * t336;
  t6823 = t6338 * t6822;
  t6824 = t6337 * t6823;
  t6825 = 0.25e2 / 0.216e3 * t6824;
  t6826 = t6343 * t1231;
  t6827 = 0.5e1 / 0.72e2 * t6826;
  t6828 = t6349 * t1492;
  t6829 = t6348 * t6828;
  t6830 = 0.25e3 / 0.243e3 * t6829;
  t6831 = t1702 * t6818;
  t6832 = t1700 * t6831;
  t6833 = 0.5e1 / 0.576e3 * t6832;
  t6834 = t388 * t1712;
  t6835 = 0.5e1 / 0.72e2 * t6834;
  t6836 = t416 * t336;
  t6837 = t439 * t6836;
  t6838 = t4393 * t6837;
  t6839 = 0.125e3 / 0.486e3 * t6838;
  t6840 = t6434 * t1515;
  t6841 = t1700 * t6840;
  t6842 = 0.5e1 / 0.288e3 * t6841;
  t6843 = t154 * t1516;
  t6844 = 0.5e1 / 0.36e2 * t6843;
  t6845 = t154 * t1521;
  t6846 = 0.25e2 / 0.216e3 * t6845;
  t6848 = t4248 * t5089;
  t6849 = t6382 * t6848;
  t6850 = t1323 * t6849;
  t6851 = 0.125e3 / 0.7776e4 * t6850;
  t6852 = params->c * t360;
  t6853 = t447 * t6852;
  t6854 = t6376 * t6853;
  t6855 = t1323 * t6854;
  t6856 = 0.25e2 / 0.1296e4 * t6855;
  t6857 = t325 * t6836;
  t6858 = t4407 * t6857;
  t6860 = t4357 * t1241;
  t6862 = t1719 * t350;
  t6863 = t6862 * t50;
  t6864 = t5113 * t6863;
  t6866 = t6387 * t336;
  t6867 = t1378 * t6866;
  t6868 = t543 * t6867;
  t6870 = -0.125e3 / 0.486e3 * t6858 + 0.25e3 / 0.81e2 * t6860 + t6482 - 0.125e4 / 0.729e3 * t6864 + 0.125e4 / 0.729e3 * t6868 - t6496;
  t6871 = t6870 * t146;
  t6872 = t1702 * t1520;
  t6873 = t1700 * t6872;
  t6874 = 0.25e2 / 0.1728e4 * t6873;
  t6875 = t447 * t853;
  t6876 = t4483 * t6875;
  t6877 = t6442 * t6876;
  t6878 = 0.125e3 / 0.972e3 * t6877;
  t6879 = t1152 * t390;
  t6880 = t3573 * t6879;
  t6881 = t6451 * t6880;
  t6882 = 0.25e2 / 0.162e3 * t6881;
  t6883 = t902 * t1296;
  t6884 = t1143 * t6883;
  t6885 = t1141 * t6884;
  t6886 = 0.25e2 / 0.324e3 * t6885;
  t6887 = t6851 - t6856 - t6355 + t6363 + t6367 - t6374 + t6871 - t6874 - t6878 + t6882 + t6886;
  t6889 = t4987 * t1214;
  t6890 = 0.25e3 / 0.81e2 * t6889;
  t6891 = t4854 * t1692;
  t6892 = 0.25e3 / 0.243e3 * t6891;
  t6893 = t4840 * t1691;
  t6894 = t1294 * t6893;
  t6895 = 0.25e3 / 0.243e3 * t6894;
  t6896 = t4483 * t1510;
  t6897 = t6503 * t6896;
  t6898 = 0.25e2 / 0.324e3 * t6897;
  t6900 = t350 * t40 * t152;
  t6901 = t1691 * t6900;
  t6902 = t4799 * t6901;
  t6903 = 0.125e4 / 0.729e3 * t6902;
  t6904 = t16 * t360;
  t6905 = t440 * t6904;
  t6906 = t1797 * t6905;
  t6907 = t6503 * t6906;
  t6908 = 0.25e2 / 0.324e3 * t6907;
  t6909 = t1708 * t6883;
  t6910 = t1323 * t6909;
  t6911 = 0.25e2 / 0.2592e4 * t6910;
  t6912 = t6520 * t6896;
  t6913 = 0.25e2 / 0.1296e4 * t6912;
  t6914 = t4960 * t403;
  t6915 = t1279 * t6914;
  t6916 = 0.25e2 / 0.162e3 * t6915;
  t6917 = t1280 * t1220;
  t6918 = t1279 * t6917;
  t6919 = 0.25e2 / 0.162e3 * t6918;
  t6920 = t1687 * t1234;
  t6921 = t1686 * t6920;
  t6922 = 0.5e1 / 0.72e2 * t6921;
  t6923 = -t6890 - t6892 - t6895 - t6898 + t6903 - t6908 + t6911 + t6913 + t6916 + t6919 - t6922;
  t6924 = t4330 * t6866;
  t6925 = t1294 * t6924;
  t6926 = 0.125e4 / 0.729e3 * t6925;
  t6927 = t440 * t337;
  t6928 = t409 * t6927;
  t6929 = t6503 * t6928;
  t6930 = 0.125e3 / 0.972e3 * t6929;
  t6931 = t1723 * t382;
  t6932 = -t6926 + t6404 + t6407 - t6412 + t6930 + t6425 + t6931 - t6462 - t6466 - t6527 - t6531;
  tv3rhosigmatau6 = t1684 - t1690 - t1694 + t1698 - t1706 + t1711 + t1714 + t1724 + t9 * (t6821 - t6825 + t6827 - t6830 - t6833 + t6835 + t6839 + t6842 - t6844 + t6846 + t6887 + t6923 + t6932);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  t6936 = t1152 * t346;
  t6937 = t6338 * t6936;
  t6938 = t6547 * t6937;
  t6939 = 0.25e2 / 0.216e3 * t6938;
  t6940 = t6552 * t1231;
  t6941 = 0.5e1 / 0.72e2 * t6940;
  t6942 = t6349 * t1563;
  t6943 = t6348 * t6942;
  t6944 = 0.25e3 / 0.243e3 * t6943;
  t6945 = t1410 * t382;
  t6946 = t1702 * t6945;
  t6947 = t1700 * t6946;
  t6948 = 0.5e1 / 0.576e3 * t6947;
  t6949 = t154 * t1599;
  t6950 = 0.25e2 / 0.216e3 * t6949;
  t6951 = t1826 * t6880;
  t6952 = 0.25e2 / 0.162e3 * t6951;
  t6953 = t902 * t1410;
  t6955 = t1141 * t1143 * t6953;
  t6956 = 0.25e2 / 0.324e3 * t6955;
  t6957 = t6434 * t1588;
  t6958 = t1700 * t6957;
  t6959 = 0.5e1 / 0.288e3 * t6958;
  t6960 = t1702 * t1598;
  t6961 = t1700 * t6960;
  t6962 = 0.25e2 / 0.1728e4 * t6961;
  t6963 = t473 * t853;
  t6964 = t4583 * t6963;
  t6965 = t6442 * t6964;
  t6966 = 0.125e3 / 0.972e3 * t6965;
  t6967 = t154 * t1589;
  t6968 = 0.5e1 / 0.36e2 * t6967;
  t6969 = t194 * t5214;
  t6970 = t1143 * t6969;
  t6971 = t1141 * t6970;
  t6972 = 0.125e3 / 0.972e3 * t6971;
  t6973 = -t6939 + t6941 - t6944 - t6948 + t6950 + t6952 + t6956 + t6959 - t6962 - t6966 - t6968 - t6972;
  t6974 = t388 * t1747;
  t6975 = 0.5e1 / 0.72e2 * t6974;
  t6976 = t1354 * t6945;
  t6977 = t154 * t6976;
  t6978 = 0.5e1 / 0.72e2 * t6977;
  t6979 = t416 * t346;
  t6980 = t439 * t6979;
  t6981 = t4719 * t6980;
  t6982 = 0.125e3 / 0.486e3 * t6981;
  t6983 = t5214 * t146;
  t6984 = t1702 * t6983;
  t6985 = t1700 * t6984;
  t6986 = 0.25e2 / 0.1728e4 * t6985;
  t6987 = t1354 * t6983;
  t6988 = t154 * t6987;
  t6989 = 0.25e2 / 0.216e3 * t6988;
  t6990 = t1729 * t6920;
  t6991 = 0.5e1 / 0.72e2 * t6990;
  t6992 = t6580 * t346;
  t6993 = t1831 * t6992;
  t6994 = t1294 * t6993;
  t6995 = 0.125e4 / 0.729e3 * t6994;
  t6996 = t1403 * t6914;
  t6997 = 0.25e2 / 0.162e3 * t6996;
  t6998 = t1403 * t6917;
  t6999 = 0.25e2 / 0.162e3 * t6998;
  t7000 = t5214 * t35;
  t7001 = t1295 * t7000;
  t7002 = t1294 * t7001;
  t7003 = 0.125e4 / 0.729e3 * t7002;
  t7004 = t5452 * t1214;
  t7005 = 0.25e3 / 0.81e2 * t7004;
  t7006 = t4854 * t1733;
  t7007 = 0.25e3 / 0.243e3 * t7006;
  t7008 = t4840 * t1732;
  t7009 = t1294 * t7008;
  t7010 = 0.25e3 / 0.243e3 * t7009;
  t7011 = t6975 + t6978 + t6982 + t6986 - t6989 - t6991 - t6995 + t6997 + t6999 + t7003 - t7005 - t7007 - t7010;
  t7013 = t467 * t347;
  t7014 = t409 * t7013;
  t7015 = t6503 * t7014;
  t7016 = 0.125e3 / 0.972e3 * t7015;
  t7017 = t4583 * t1584;
  t7018 = t6520 * t7017;
  t7019 = 0.25e2 / 0.1296e4 * t7018;
  t7020 = t1708 * t6953;
  t7021 = t1323 * t7020;
  t7022 = 0.25e2 / 0.2592e4 * t7021;
  t7023 = t473 * t6852;
  t7024 = t6563 * t7023;
  t7025 = t1323 * t7024;
  t7026 = 0.25e2 / 0.1296e4 * t7025;
  t7027 = t4742 * t5475;
  t7028 = t6568 * t7027;
  t7029 = t1323 * t7028;
  t7030 = 0.125e3 / 0.7776e4 * t7029;
  t7031 = t6503 * t7017;
  t7032 = 0.25e2 / 0.324e3 * t7031;
  t7033 = t27 * t360;
  t7034 = t467 * t7033;
  t7035 = t1797 * t7034;
  t7036 = t6503 * t7035;
  t7037 = 0.25e2 / 0.324e3 * t7036;
  t7038 = t7016 + t7019 + t7022 - t7026 + t7030 - t7032 - t7037 + t6586 + t6588 - t6590 + t6593 + t6597;
  t7039 = t1549 * t1728;
  t7040 = t7039 * t1688;
  t7041 = 0.25e2 / 0.216e3 * t7040;
  t7042 = t5240 * t1682;
  t7043 = 0.125e3 / 0.486e3 * t7042;
  t7044 = t1756 * t382;
  t7045 = t5490 * t1716;
  t7047 = t325 * t6979;
  t7048 = t4627 * t7047;
  t7050 = t4739 * t1241;
  t7052 = t1752 * t350;
  t7053 = t7052 * t50;
  t7054 = t5510 * t7053;
  t7057 = t543 * t5522 * t1752;
  t7060 = t543 * t1463 * t6992;
  t7062 = 0.125e3 / 0.486e3 * t7045 - 0.125e3 / 0.486e3 * t7048 + 0.25e3 / 0.81e2 * t7050 + t6613 - 0.125e4 / 0.729e3 * t7054 - 0.125e4 / 0.729e3 * t7057 + 0.125e4 / 0.729e3 * t7060 - t6624;
  t7063 = t7062 * t146;
  t7064 = t1732 * t6900;
  t7065 = t4799 * t7064;
  t7066 = 0.125e4 / 0.729e3 * t7065;
  t7067 = t1708 * t6969;
  t7068 = t1323 * t7067;
  t7069 = 0.125e3 / 0.7776e4 * t7068;
  t7070 = t7041 - t7043 + t7044 + t7063 - t6629 - t6632 + t6634 + t7066 - t7069 - t6641 - t6644 - t6685 - t6688;
  tv3rhosigmatau7 = t1727 - t1731 - t1735 + t1739 - t1743 + t1746 + t1749 + t1757 + t9 * (t6973 + t7011 + t7038 + t7070);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  t7074 = 0.5e1 / 0.36e2 * t6820;
  t7075 = 0.25e2 / 0.108e3 * t6824;
  t7076 = 0.5e1 / 0.36e2 * t6826;
  t7077 = 0.5e3 / 0.243e3 * t6829;
  t7078 = 0.5e1 / 0.288e3 * t6832;
  t7079 = 0.5e1 / 0.36e2 * t6834;
  t7080 = 0.125e3 / 0.243e3 * t6838;
  t7081 = t1768 * t382;
  t7082 = 0.5e1 / 0.144e3 * t6841;
  t7083 = 0.5e1 / 0.18e2 * t6843;
  t7085 = 0.25e2 / 0.108e3 * t6845;
  t7086 = 0.125e3 / 0.3888e4 * t6850;
  t7087 = 0.25e2 / 0.648e3 * t6855;
  t7088 = 0.25e2 / 0.864e3 * t6873;
  t7089 = 0.125e3 / 0.486e3 * t6877;
  t7090 = 0.25e2 / 0.81e2 * t6881;
  t7091 = 0.25e2 / 0.162e3 * t6885;
  t7092 = t7085 + t7086 - t7087 - t6700 + t6702 + t6703 - t6706 - t7088 - t7089 + t7090 + t7091;
  t7098 = -0.125e3 / 0.243e3 * t6858 + 0.5e3 / 0.81e2 * t6860 + t6710 - 0.25e4 / 0.729e3 * t6864 + 0.25e4 / 0.729e3 * t6868 - t6714;
  t7099 = t7098 * t146;
  t7100 = 0.5e3 / 0.81e2 * t6889;
  t7101 = 0.5e3 / 0.243e3 * t6891;
  t7102 = 0.5e3 / 0.243e3 * t6894;
  t7103 = 0.25e2 / 0.162e3 * t6897;
  t7104 = 0.25e4 / 0.729e3 * t6902;
  t7105 = 0.25e2 / 0.162e3 * t6907;
  t7106 = 0.25e2 / 0.1296e4 * t6910;
  t7107 = 0.25e2 / 0.648e3 * t6912;
  t7108 = 0.25e2 / 0.81e2 * t6915;
  t7109 = 0.25e2 / 0.81e2 * t6918;
  t7110 = t7099 - t7100 - t7101 - t7102 - t7103 + t7104 - t7105 + t7106 + t7107 + t7108 + t7109;
  t7111 = 0.5e1 / 0.36e2 * t6921;
  t7112 = 0.25e4 / 0.729e3 * t6925;
  t7113 = 0.125e3 / 0.486e3 * t6929;
  t7114 = -t7111 - t7112 + t6723 + t6724 - t6726 + t7113 + t6732 - t6744 - t6745 - t6753 - t6754;
  tv3rhosigmatau8 = t1759 - t1760 - t1761 + t1762 - t1763 + t1764 + t1765 + t1769 + t9 * (t7074 - t7075 + t7076 - t7077 - t7078 + t7079 + t7080 + t7081 + t7082 - t7083 + t7092 + t7110 + t7114);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  t7118 = 0.25e2 / 0.108e3 * t6938;
  t7119 = 0.5e1 / 0.36e2 * t6940;
  t7120 = 0.5e3 / 0.243e3 * t6943;
  t7121 = 0.5e1 / 0.288e3 * t6947;
  t7122 = 0.25e2 / 0.108e3 * t6949;
  t7123 = 0.25e2 / 0.81e2 * t6951;
  t7124 = 0.25e2 / 0.162e3 * t6955;
  t7125 = 0.5e1 / 0.144e3 * t6958;
  t7126 = 0.25e2 / 0.864e3 * t6961;
  t7127 = 0.125e3 / 0.486e3 * t6965;
  t7128 = 0.5e1 / 0.18e2 * t6967;
  t7129 = 0.125e3 / 0.486e3 * t6971;
  t7130 = -t7118 + t7119 - t7120 - t7121 + t7122 + t7123 + t7124 + t7125 - t7126 - t7127 - t7128 - t7129;
  t7131 = 0.5e1 / 0.36e2 * t6974;
  t7132 = 0.5e1 / 0.36e2 * t6977;
  t7133 = 0.125e3 / 0.243e3 * t6981;
  t7134 = 0.25e2 / 0.864e3 * t6985;
  t7135 = 0.25e2 / 0.108e3 * t6988;
  t7142 = 0.125e3 / 0.243e3 * t7045 - 0.125e3 / 0.243e3 * t7048 + 0.5e3 / 0.81e2 * t7050 + t6787 - 0.25e4 / 0.729e3 * t7054 - 0.25e4 / 0.729e3 * t7057 + 0.25e4 / 0.729e3 * t7060 - t6790;
  t7143 = t7142 * t146;
  t7144 = 0.5e1 / 0.36e2 * t6990;
  t7145 = 0.25e4 / 0.729e3 * t6994;
  t7146 = 0.25e2 / 0.81e2 * t6996;
  t7147 = 0.25e2 / 0.81e2 * t6998;
  t7148 = 0.25e4 / 0.729e3 * t7002;
  t7149 = 0.5e3 / 0.81e2 * t7004;
  t7150 = 0.5e3 / 0.243e3 * t7006;
  t7151 = t7131 + t7132 + t7133 + t7134 - t7135 + t7143 - t7144 - t7145 + t7146 + t7147 + t7148 - t7149 - t7150;
  t7153 = 0.5e3 / 0.243e3 * t7009;
  t7154 = 0.125e3 / 0.486e3 * t7015;
  t7155 = 0.25e2 / 0.648e3 * t7018;
  t7156 = 0.25e2 / 0.1296e4 * t7021;
  t7157 = 0.25e2 / 0.648e3 * t7025;
  t7158 = 0.125e3 / 0.3888e4 * t7029;
  t7159 = 0.25e2 / 0.162e3 * t7031;
  t7160 = 0.25e2 / 0.162e3 * t7036;
  t7161 = t1780 * t382;
  t7162 = -t7153 + t7154 + t7155 + t7156 - t7157 + t7158 - t7159 - t7160 + t7161 + t6775 + t6776 - t6777;
  t7163 = 0.25e2 / 0.108e3 * t7040;
  t7164 = 0.125e3 / 0.243e3 * t7042;
  t7165 = 0.25e4 / 0.729e3 * t7065;
  t7166 = 0.125e3 / 0.3888e4 * t7068;
  t7167 = t6778 + t6779 + t7163 - t7164 - t6793 - t6794 + t6795 + t7165 - t7166 - t6797 - t6798 - t6812 - t6813;
  tv3rhosigmatau9 = t1771 - t1772 - t1773 + t1774 - t1775 + t1776 + t1777 + t1781 + t9 * (t7130 + t7151 + t7162 + t7167);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = tv3rhosigmatau6;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = tv3rhosigmatau7;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t7171 = t217 * t1802;
  t7172 = t543 * t7171;
  t7173 = 0.2e4 / 0.243e3 * t7172;
  t7174 = t317 * t1802;
  t7175 = t543 * t7174;
  t7176 = 0.2e4 / 0.243e3 * t7175;
  t7177 = t1788 * t539;
  t7178 = t1785 * t7177;
  t7179 = t2325 * t6143;
  t7180 = t7178 * t7179;
  t7181 = 0.2e4 / 0.81e2 * t7180;
  t7183 = 0.1e1 / t3 / t1898;
  t7184 = t544 * t7183;
  t7185 = t7184 * t1788;
  t7186 = t147 * t7185;
  t7187 = t543 * t7186;
  t7188 = 0.2e5 / 0.729e3 * t7187;
  t7189 = t1324 * t1811;
  t7190 = t14 * t1786;
  t7191 = t7190 * t146;
  t7192 = t7191 * t4394;
  t7193 = t7189 * t7192;
  t7194 = t1323 * t7193;
  t7195 = 0.125e3 / 0.243e3 * t7194;
  t7196 = t1823 * t316;
  t7197 = t2774 * t1813;
  t7198 = t154 * t7197;
  t7199 = 0.35e2 / 0.54e2 * t7198;
  t7200 = t1337 * t1811;
  t7201 = t1812 * t6377;
  t7202 = t7200 * t7201;
  t7203 = t1323 * t7202;
  t7204 = 0.25e2 / 0.81e2 * t7203;
  t7205 = t207 * t1784;
  t7206 = t1812 * t1975;
  t7207 = t7205 * t7206;
  t7208 = t4482 * t7207;
  t7209 = 0.5e3 / 0.243e3 * t7208;
  t7210 = t322 * t1814;
  t7211 = 0.5e1 / 0.36e2 * t7210;
  t7212 = t1788 * t316;
  t7213 = t1811 * t7212;
  t7214 = t878 * t7213;
  t7215 = t154 * t7214;
  t7216 = 0.5e1 / 0.36e2 * t7215;
  t7217 = t8 * t1784;
  t7218 = t7217 * t1812;
  t7219 = t878 * t7218;
  t7220 = t154 * t7219;
  t7221 = 0.5e1 / 0.18e2 * t7220;
  t7222 = t62 * t7183;
  t7223 = t7222 * t1812;
  t7224 = t878 * t7223;
  t7225 = t154 * t7224;
  t7226 = 0.25e2 / 0.54e2 * t7225;
  t7227 = t1812 * t326;
  t7228 = t7200 * t7227;
  t7229 = t1323 * t7228;
  t7230 = 0.25e2 / 0.162e3 * t7229;
  t7231 = t2 * t7183;
  t7235 = t7190 * t185;
  t7236 = t1785 * t7235;
  t7238 = t800 * t801 * t167;
  t7241 = t542 * t1975;
  t7245 = t1806 * t180 * t50;
  t7248 = t7183 * t1788;
  t7249 = t806 * t7248;
  t7252 = t7190 * t167;
  t7256 = -0.1e4 / 0.243e3 * t7231 * t1789 * t802 + 0.1e4 / 0.243e3 * t7236 * t7238 - 0.2e4 / 0.81e2 * t1794 * t7241 + 0.1e5 / 0.729e3 * t2535 * t7245 + 0.2e5 / 0.729e3 * t805 * t7249 - 0.2e5 / 0.729e3 * t543 * t1801 * t7252;
  t7257 = t7256 * t146;
  t7258 = t7235 * t187;
  t7259 = t1785 * t7258;
  t7260 = t194 * t167;
  t7261 = t1280 * t7260;
  t7262 = t7259 * t7261;
  t7263 = 0.1e4 / 0.243e3 * t7262;
  t7264 = t1785 * t7190;
  t7265 = t7264 * t50;
  t7266 = t207 * t1355;
  t7267 = t1796 * t7266;
  t7268 = t7265 * t7267;
  t7269 = 0.25e2 / 0.54e2 * t7268;
  t7270 = t7173 + t7176 + t7181 - t7188 - t7195 + t7196 + t7199 + t7204 + t7209 - t7211 - t7216 - t7221 + t7226 + t7230 + t7257 - t7263 + t7269;
  t7271 = t574 * t1339;
  t7272 = t1796 * t7271;
  t7273 = t1795 * t7272;
  t7274 = 0.5e1 / 0.18e2 * t7273;
  t7276 = t1958 * t1784 * t1788;
  t7277 = t7276 * t3853;
  t7278 = t2556 * t7277;
  t7279 = 0.1e5 / 0.729e3 * t7278;
  t7280 = t1334 * t201;
  t7281 = t7280 * t1797;
  t7282 = t1795 * t7281;
  t7283 = 0.35e2 / 0.54e2 * t7282;
  t7284 = t579 * t146;
  t7285 = t1796 * t7284;
  t7286 = t1795 * t7285;
  t7287 = 0.5e1 / 0.18e2 * t7286;
  t7288 = t7231 * t1788;
  t7289 = t7288 * t50;
  t7290 = t7289 * t1798;
  t7291 = 0.25e2 / 0.54e2 * t7290;
  t7292 = t207 * t316;
  t7293 = t1796 * t7292;
  t7294 = t1795 * t7293;
  t7295 = 0.5e1 / 0.36e2 * t7294;
  t7296 = t1784 * t7190;
  t7297 = t7296 * t167;
  t7298 = t1295 * t7297;
  t7299 = t1294 * t7298;
  t7300 = 0.2e5 / 0.729e3 * t7299;
  t7301 = t7231 * t1790;
  t7302 = t7301 * t531;
  t7303 = 0.1e4 / 0.243e3 * t7302;
  t7304 = t1806 * t1339;
  t7305 = t4174 * t7304;
  t7306 = t1336 * t7305;
  t7307 = 0.5e1 / 0.12e2 * t7306;
  t7308 = t7296 * t1355;
  t7309 = t1338 * t7308;
  t7310 = t1336 * t7309;
  t7311 = 0.25e2 / 0.54e2 * t7310;
  t7312 = t188 * t325;
  t7313 = t1794 * t7312;
  t7314 = t445 * t6452;
  t7315 = t7313 * t7314;
  t7316 = 0.25e2 / 0.81e2 * t7315;
  t7317 = t1806 * t553;
  t7318 = t1354 * t7317;
  t7319 = t1323 * t7318;
  t7320 = 0.25e2 / 0.162e3 * t7319;
  t7321 = t4139 * t1807;
  t7322 = t1323 * t7321;
  t7323 = 0.25e2 / 0.81e2 * t7322;
  t7324 = t7248 * t194;
  t7325 = t1354 * t7324;
  t7326 = t1323 * t7325;
  t7327 = 0.125e3 / 0.243e3 * t7326;
  t7328 = t4156 * t1807;
  t7329 = t1323 * t7328;
  t7330 = 0.175e3 / 0.243e3 * t7329;
  t7331 = t1791 * t1981;
  t7332 = 0.1e3 / 0.81e2 * t7331;
  t7333 = t1791 * t1985;
  t7334 = 0.1e3 / 0.81e2 * t7333;
  t7335 = -t7274 - t7279 - t7283 + t7287 - t7291 + t7295 + t7300 + t7303 + t7307 - t7311 - t7316 - t7320 - t7323 + t7327 + t7330 - t7332 - t7334;
  tv3rhotau20 = -t1793 + t1800 + t1805 - t1810 - t1816 + t1824 + t9 * (t7270 + t7335);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t7338 = t4143 * t1845;
  t7339 = 0.5e1 / 0.36e2 * t7338;
  t7340 = t1450 * t1296;
  t7341 = t1843 * t7340;
  t7342 = t1336 * t7341;
  t7343 = 0.5e1 / 0.36e2 * t7342;
  t7344 = t4718 * t453;
  t7345 = t59 * t207;
  t7346 = t1296 * t1445;
  t7347 = t7345 * t7346;
  t7348 = t7344 * t7347;
  t7349 = 0.25e2 / 0.108e3 * t7348;
  t7350 = t55 * t59;
  t7351 = t46 * t7350;
  t7352 = t2379 * t1410;
  t7353 = t7352 * t1340;
  t7354 = t7351 * t7353;
  t7355 = 0.5e1 / 0.12e2 * t7354;
  t7356 = t574 * t1421;
  t7357 = t7356 * t7346;
  t7358 = t7351 * t7357;
  t7359 = 0.25e2 / 0.108e3 * t7358;
  t7360 = t4524 * t1356;
  t7361 = t7351 * t7360;
  t7362 = 0.25e2 / 0.108e3 * t7361;
  t7363 = t1460 * t1322;
  t7364 = t7363 * t1327;
  t7365 = 0.25e2 / 0.81e2 * t7364;
  t7366 = t1839 * t6651;
  t7367 = t1838 * t7366;
  t7368 = 0.25e2 / 0.162e3 * t7367;
  t7370 = t324 * t325 * t202;
  t7371 = t7370 * t1840;
  t7372 = 0.175e3 / 0.243e3 * t7371;
  t7373 = t579 * t1296;
  t7374 = t7373 * t1736;
  t7375 = t1838 * t7374;
  t7376 = 0.25e2 / 0.81e2 * t7375;
  t7377 = t207 * t4262;
  t7378 = t7377 * t1736;
  t7379 = t1838 * t7378;
  t7380 = 0.125e3 / 0.486e3 * t7379;
  t7381 = t1853 * t316;
  t7382 = t439 * t6515;
  t7383 = t1826 * t7382;
  t7384 = 0.5e3 / 0.243e3 * t7383;
  t7385 = t16 * t171;
  t7386 = t440 * t7385;
  t7387 = t439 * t7386;
  t7388 = t4719 * t7387;
  t7389 = 0.5e3 / 0.243e3 * t7388;
  t7390 = t59 * t574;
  t7391 = t7390 * t1340;
  t7392 = t479 * t7391;
  t7393 = 0.5e1 / 0.18e2 * t7392;
  t7394 = t7345 * t1356;
  t7395 = t479 * t7394;
  t7396 = 0.25e2 / 0.108e3 * t7395;
  t7397 = t1410 * t1296;
  t7398 = t7397 * t3853;
  t7399 = t4799 * t7398;
  t7400 = 0.1e5 / 0.729e3 * t7399;
  t7401 = t4310 * t21;
  t7402 = t7401 * t1833;
  t7403 = t1294 * t7402;
  t7404 = 0.2e4 / 0.243e3 * t7403;
  t7406 = t27 * t160 * t16;
  t7407 = t1831 * t7406;
  t7408 = t1294 * t7407;
  t7409 = 0.1e5 / 0.729e3 * t7408;
  t7410 = -t7339 - t7343 + t7349 + t7355 - t7359 - t7362 - t7365 - t7368 + t7372 - t7376 + t7380 + t7381 - t7384 - t7389 - t7393 + t7396 - t7400 + t7404 - t7409;
  t7411 = t325 * params->c;
  t7412 = t1296 * t171;
  t7413 = t7411 * t7412;
  t7416 = t806 * t1297;
  t7421 = t7411 * t1315;
  t7424 = t1833 * t3853;
  t7427 = t39 * t1951;
  t7437 = 0.5e3 / 0.243e3 * t4627 * t7413 - 0.2e4 / 0.81e2 * t4739 * t7416 - 0.5e3 / 0.243e3 * t1403 * t1383 + 0.5e3 / 0.243e3 * t1403 * t7421 + 0.1e5 / 0.729e3 * t5510 * t7424 - 0.1e5 / 0.729e3 * t7427 * t1421 * t7412 + 0.1e5 / 0.729e3 * t543 * t1463 * t7406 - 0.1e5 / 0.729e3 * t7427 * t1410 * t1315;
  t7438 = t7437 * t146;
  t7439 = t147 * t544;
  t7440 = t7439 * t1297;
  t7441 = t5452 * t7440;
  t7442 = 0.2e4 / 0.81e2 * t7441;
  t7443 = t4307 * t1834;
  t7444 = 0.2e4 / 0.243e3 * t7443;
  t7445 = t146 * t6;
  t7446 = t16 * params->c;
  t7447 = t7446 * t180;
  t7448 = t7445 * t7447;
  t7449 = t4524 * t7448;
  t7450 = t1838 * t7449;
  t7451 = 0.25e2 / 0.162e3 * t7450;
  t7452 = t1410 * t209;
  t7453 = t194 * t7452;
  t7454 = t4135 * t7453;
  t7455 = t1838 * t7454;
  t7456 = 0.25e2 / 0.81e2 * t7455;
  t7457 = t1410 * t167;
  t7458 = t194 * t7457;
  t7459 = t4129 * t7458;
  t7460 = t1838 * t7459;
  t7461 = 0.125e3 / 0.486e3 * t7460;
  t7462 = t194 * t1422;
  t7463 = t1839 * t7462;
  t7464 = t1838 * t7463;
  t7465 = 0.125e3 / 0.486e3 * t7464;
  t7466 = t1826 * t1311;
  t7467 = 0.5e3 / 0.243e3 * t7466;
  t7468 = t479 * t1362;
  t7469 = 0.5e1 / 0.36e2 * t7468;
  t7470 = t479 * t1331;
  t7471 = 0.35e2 / 0.54e2 * t7470;
  t7472 = t479 * t1346;
  t7473 = 0.5e1 / 0.18e2 * t7472;
  t7474 = t479 * t1351;
  t7475 = 0.25e2 / 0.108e3 * t7474;
  t7476 = t4150 * t472;
  t7477 = t7476 * t1844;
  t7478 = t1336 * t7477;
  t7479 = 0.35e2 / 0.54e2 * t7478;
  t7480 = t1337 * t1440;
  t7481 = t7480 * t1844;
  t7482 = t1336 * t7481;
  t7483 = 0.5e1 / 0.18e2 * t7482;
  t7484 = t473 * t4262;
  t7485 = t1843 * t7484;
  t7486 = t1336 * t7485;
  t7487 = 0.25e2 / 0.108e3 * t7486;
  t7488 = t448 * t1465;
  t7489 = t4792 * t7488;
  t7490 = 0.5e3 / 0.243e3 * t7489;
  t7492 = t805 * t2325 * t146;
  t7493 = t1463 * t26;
  t7494 = t7493 * t7412;
  t7495 = t7492 * t7494;
  t7496 = 0.1e5 / 0.729e3 * t7495;
  t7497 = t1463 * t27;
  t7498 = t7497 * t1315;
  t7499 = t7492 * t7498;
  t7500 = 0.1e5 / 0.729e3 * t7499;
  t7501 = t1826 * t1302;
  t7502 = 0.1e3 / 0.81e2 * t7501;
  t7503 = t1826 * t1306;
  t7504 = 0.1e3 / 0.81e2 * t7503;
  t7505 = t7438 + t7442 + t7444 + t7451 + t7456 - t7461 - t7465 + t7467 + t7469 - t7471 + t7473 - t7475 + t7479 - t7483 + t7487 + t7490 + t7496 + t7500 - t7502 - t7504;
  tv3rhotau21 = -t1828 + t1830 + t1836 - t1842 - t1847 + t1854 + t9 * (t7410 + t7505);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t7508 = t1861 * t539;
  t7509 = t1858 * t7508;
  t7510 = t7509 * t7179;
  t7511 = 0.2e4 / 0.81e2 * t7510;
  t7513 = t543 * t217 * t1872;
  t7514 = 0.2e4 / 0.243e3 * t7513;
  t7515 = t25 * t1859;
  t7516 = t7515 * t185;
  t7517 = t7516 * t187;
  t7518 = t1858 * t7517;
  t7519 = t194 * t171;
  t7520 = t1280 * t7519;
  t7521 = t7518 * t7520;
  t7522 = 0.1e4 / 0.243e3 * t7521;
  t7523 = t1857 * t7515;
  t7524 = t7523 * t1445;
  t7525 = t1338 * t7524;
  t7526 = t1336 * t7525;
  t7527 = 0.25e2 / 0.54e2 * t7526;
  t7528 = t1867 * t7312;
  t7529 = t7528 * t7314;
  t7530 = 0.25e2 / 0.81e2 * t7529;
  t7531 = t1876 * t553;
  t7532 = t1354 * t7531;
  t7533 = t1323 * t7532;
  t7534 = 0.25e2 / 0.162e3 * t7533;
  t7535 = t4156 * t1877;
  t7536 = t1323 * t7535;
  t7537 = 0.175e3 / 0.243e3 * t7536;
  t7538 = t4139 * t1877;
  t7539 = t1323 * t7538;
  t7540 = 0.25e2 / 0.81e2 * t7539;
  t7541 = t1868 * t7293;
  t7542 = 0.5e1 / 0.36e2 * t7541;
  t7543 = t1864 * t1981;
  t7544 = 0.1e3 / 0.81e2 * t7543;
  t7545 = t1864 * t1985;
  t7546 = 0.1e3 / 0.81e2 * t7545;
  t7547 = t7523 * t171;
  t7548 = t1295 * t7547;
  t7549 = t1294 * t7548;
  t7550 = 0.2e5 / 0.729e3 * t7549;
  t7551 = t1324 * t1881;
  t7552 = t7515 * t146;
  t7553 = t7552 * t4628;
  t7555 = t1323 * t7551 * t7553;
  t7556 = 0.125e3 / 0.243e3 * t7555;
  t7557 = t1337 * t1881;
  t7558 = t1882 * t326;
  t7559 = t7557 * t7558;
  t7560 = t1323 * t7559;
  t7561 = 0.25e2 / 0.162e3 * t7560;
  t7562 = t7511 + t7514 - t7522 - t7527 - t7530 - t7534 + t7537 - t7540 + t7542 - t7544 - t7546 + t7550 - t7556 + t7561;
  t7564 = t543 * t317 * t1872;
  t7565 = 0.2e4 / 0.243e3 * t7564;
  t7566 = t1882 * t6377;
  t7568 = t1323 * t7557 * t7566;
  t7569 = 0.25e2 / 0.81e2 * t7568;
  t7570 = t1868 * t7281;
  t7571 = 0.35e2 / 0.54e2 * t7570;
  t7572 = t1868 * t7285;
  t7573 = 0.5e1 / 0.18e2 * t7572;
  t7574 = t1893 * t316;
  t7575 = t1858 * t7516;
  t7577 = t800 * t801 * t171;
  t7586 = t7515 * t171;
  t7587 = t1871 * t7586;
  t7590 = 0.1e4 / 0.243e3 * t7575 * t7577 - 0.2e4 / 0.81e2 * t1867 * t7241 + 0.1e5 / 0.729e3 * t2535 * t1876 * t180 * t50 - 0.2e5 / 0.729e3 * t543 * t7587;
  t7591 = t7590 * t146;
  t7592 = t1858 * t7515;
  t7593 = t7592 * t50;
  t7594 = t207 * t1445;
  t7595 = t1796 * t7594;
  t7596 = t7593 * t7595;
  t7597 = 0.25e2 / 0.54e2 * t7596;
  t7598 = t1868 * t7272;
  t7599 = 0.5e1 / 0.18e2 * t7598;
  t7600 = t1958 * t1857;
  t7601 = t7600 * t1861;
  t7602 = t7601 * t3853;
  t7603 = t2556 * t7602;
  t7604 = 0.1e5 / 0.729e3 * t7603;
  t7605 = t207 * t1857;
  t7606 = t1882 * t1975;
  t7607 = t7605 * t7606;
  t7608 = t4482 * t7607;
  t7609 = 0.5e3 / 0.243e3 * t7608;
  t7610 = t322 * t1884;
  t7611 = 0.5e1 / 0.36e2 * t7610;
  t7612 = t1861 * t316;
  t7613 = t1881 * t7612;
  t7614 = t878 * t7613;
  t7615 = t154 * t7614;
  t7616 = 0.5e1 / 0.36e2 * t7615;
  t7617 = t2774 * t1883;
  t7618 = t154 * t7617;
  t7619 = 0.35e2 / 0.54e2 * t7618;
  t7620 = t8 * t1857;
  t7621 = t7620 * t1882;
  t7622 = t878 * t7621;
  t7623 = t154 * t7622;
  t7624 = 0.5e1 / 0.18e2 * t7623;
  t7625 = t1876 * t1339;
  t7626 = t4174 * t7625;
  t7627 = t1336 * t7626;
  t7628 = 0.5e1 / 0.12e2 * t7627;
  t7629 = t7565 + t7569 - t7571 + t7573 + t7574 + t7591 + t7597 - t7599 - t7604 + t7609 - t7611 - t7616 + t7619 - t7624 + t7628;
  tv3rhotau22 = -t1866 + t1870 + t1875 - t1880 - t1886 + t1894 + t9 * (t7562 + t7629);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t7632 = t194 * t336;
  t7633 = t1280 * t7632;
  t7634 = t7259 * t7633;
  t7635 = 0.1e4 / 0.243e3 * t7634;
  t7636 = t207 * t382;
  t7637 = t1796 * t7636;
  t7638 = t1795 * t7637;
  t7639 = 0.5e1 / 0.36e2 * t7638;
  t7640 = t1791 * t2637;
  t7641 = 0.1e3 / 0.81e2 * t7640;
  t7642 = t1806 * t1514;
  t7643 = t4174 * t7642;
  t7644 = t1336 * t7643;
  t7645 = 0.5e1 / 0.12e2 * t7644;
  t7646 = t7296 * t1519;
  t7647 = t1338 * t7646;
  t7648 = t1336 * t7647;
  t7649 = 0.25e2 / 0.54e2 * t7648;
  t7650 = t445 * t6879;
  t7651 = t7313 * t7650;
  t7652 = 0.25e2 / 0.81e2 * t7651;
  t7653 = t1806 * t902;
  t7654 = t1354 * t7653;
  t7655 = t1323 * t7654;
  t7656 = 0.25e2 / 0.162e3 * t7655;
  t7657 = t1812 * t6852;
  t7658 = t7200 * t7657;
  t7659 = t1323 * t7658;
  t7660 = 0.25e2 / 0.81e2 * t7659;
  t7661 = t7191 * t5089;
  t7662 = t7189 * t7661;
  t7663 = t1323 * t7662;
  t7664 = 0.125e3 / 0.243e3 * t7663;
  t7665 = t1812 * t390;
  t7666 = t7200 * t7665;
  t7667 = t1323 * t7666;
  t7668 = 0.25e2 / 0.162e3 * t7667;
  t7669 = t7199 - t7635 + t7221 + t7639 - t7641 - t7283 - t7287 + t7645 - t7649 - t7652 - t7656 + t7660 - t7664 + t7668;
  t7670 = t1823 * t382;
  t7672 = t800 * t801 * t336;
  t7675 = t542 * t853;
  t7678 = t1806 * t350;
  t7679 = t7678 * t50;
  t7682 = t7190 * t336;
  t7686 = 0.1e4 / 0.243e3 * t7236 * t7672 - 0.2e4 / 0.81e2 * t1794 * t7675 + 0.1e5 / 0.729e3 * t2535 * t7679 - 0.2e5 / 0.729e3 * t543 * t1801 * t7682;
  t7687 = t7686 * t146;
  t7688 = t1791 * t2616;
  t7689 = 0.1e3 / 0.81e2 * t7688;
  t7690 = t7296 * t336;
  t7691 = t1295 * t7690;
  t7692 = t1294 * t7691;
  t7693 = 0.2e5 / 0.729e3 * t7692;
  t7694 = t2325 * t6262;
  t7695 = t7178 * t7694;
  t7696 = 0.2e4 / 0.81e2 * t7695;
  t7697 = t365 * t1802;
  t7698 = t543 * t7697;
  t7699 = 0.2e4 / 0.243e3 * t7698;
  t7700 = t383 * t1802;
  t7701 = t543 * t7700;
  t7702 = 0.2e4 / 0.243e3 * t7701;
  t7703 = t7276 * t6900;
  t7704 = t2556 * t7703;
  t7705 = 0.1e5 / 0.729e3 * t7704;
  t7706 = t1812 * t853;
  t7707 = t7205 * t7706;
  t7708 = t4482 * t7707;
  t7709 = 0.5e3 / 0.243e3 * t7708;
  t7710 = t388 * t1814;
  t7711 = 0.5e1 / 0.36e2 * t7710;
  t7712 = t1788 * t382;
  t7713 = t1811 * t7712;
  t7714 = t878 * t7713;
  t7715 = t154 * t7714;
  t7716 = 0.5e1 / 0.36e2 * t7715;
  t7717 = t207 * t1519;
  t7718 = t1796 * t7717;
  t7719 = t7265 * t7718;
  t7720 = 0.25e2 / 0.54e2 * t7719;
  t7721 = t574 * t1514;
  t7722 = t1796 * t7721;
  t7723 = t1795 * t7722;
  t7724 = 0.5e1 / 0.18e2 * t7723;
  t7725 = t7670 + t7687 - t7689 + t7693 + t7696 + t7699 + t7702 + t7323 + t7330 - t7705 + t7709 - t7711 - t7716 + t7720 - t7724;
  tv3rhotau23 = -t1793 + t1800 + t1805 - t1810 - t1816 + t1824 + t9 * (t7669 + t7725);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  t7728 = t479 * t1526;
  t7729 = 0.5e1 / 0.36e2 * t7728;
  t7730 = t1608 * t449;
  t7731 = 0.25e2 / 0.108e3 * t7730;
  t7732 = t1839 * t6969;
  t7733 = t1838 * t7732;
  t7734 = 0.125e3 / 0.486e3 * t7733;
  t7735 = t1607 * t189;
  t7736 = t7735 * t442;
  t7737 = 0.5e3 / 0.243e3 * t7736;
  t7738 = t7439 * t1492;
  t7739 = t5452 * t7738;
  t7740 = 0.2e4 / 0.81e2 * t7739;
  t7741 = t4854 * t1834;
  t7742 = 0.2e4 / 0.243e3 * t7741;
  t7743 = t4840 * t21;
  t7744 = t7743 * t1833;
  t7745 = t1294 * t7744;
  t7746 = 0.2e4 / 0.243e3 * t7745;
  t7747 = t1295 * t342;
  t7748 = t7747 * t1833;
  t7749 = t1294 * t7748;
  t7750 = 0.1e5 / 0.729e3 * t7749;
  t7753 = t1296 * t346;
  t7754 = t7411 * t7753;
  t7757 = t806 * t1492;
  t7760 = t7411 * t1504;
  t7763 = t1833 * t6900;
  t7775 = -0.5e3 / 0.243e3 * t5240 * t456 + 0.5e3 / 0.243e3 * t4627 * t7754 - 0.2e4 / 0.81e2 * t4739 * t7757 + 0.5e3 / 0.243e3 * t1403 * t7760 + 0.1e5 / 0.729e3 * t5510 * t7763 + 0.1e5 / 0.729e3 * t543 * t5522 * t1833 - 0.1e5 / 0.729e3 * t7427 * t1421 * t7753 - 0.1e5 / 0.729e3 * t7427 * t1410 * t1504;
  t7776 = t7775 * t146;
  t7777 = t1337 * t1592;
  t7778 = t7777 * t1844;
  t7779 = t1336 * t7778;
  t7780 = 0.25e2 / 0.108e3 * t7779;
  t7781 = t7345 * t1520;
  t7782 = t479 * t7781;
  t7783 = 0.25e2 / 0.108e3 * t7782;
  t7784 = t7397 * t6900;
  t7785 = t4799 * t7784;
  t7786 = 0.1e5 / 0.729e3 * t7785;
  t7787 = t1410 * t336;
  t7788 = t194 * t7787;
  t7789 = t4129 * t7788;
  t7790 = t1838 * t7789;
  t7791 = 0.125e3 / 0.486e3 * t7790;
  t7792 = t194 * t1578;
  t7793 = t1839 * t7792;
  t7794 = t1838 * t7793;
  t7795 = 0.125e3 / 0.486e3 * t7794;
  t7796 = t7446 * t350;
  t7797 = t7445 * t7796;
  t7798 = t4524 * t7797;
  t7799 = t1838 * t7798;
  t7800 = 0.25e2 / 0.162e3 * t7799;
  t7801 = t448 * t1617;
  t7802 = t4792 * t7801;
  t7803 = 0.5e3 / 0.243e3 * t7802;
  t7804 = t4788 * t1845;
  t7805 = 0.5e1 / 0.36e2 * t7804;
  t7806 = t7729 - t7731 + t7734 + t7737 + t7740 + t7742 + t7746 - t7750 + t7372 + t7376 + t7776 + t7780 + t7783 - t7786 - t7791 - t7795 + t7800 + t7803 - t7805;
  t7807 = t1602 * t1296;
  t7808 = t1843 * t7807;
  t7809 = t1336 * t7808;
  t7810 = 0.5e1 / 0.36e2 * t7809;
  t7811 = t1296 * t1597;
  t7812 = t7345 * t7811;
  t7813 = t7344 * t7812;
  t7814 = 0.25e2 / 0.108e3 * t7813;
  t7815 = t7390 * t1515;
  t7816 = t479 * t7815;
  t7817 = 0.5e1 / 0.18e2 * t7816;
  t7818 = t7493 * t7753;
  t7819 = t7492 * t7818;
  t7820 = 0.1e5 / 0.729e3 * t7819;
  t7821 = t7497 * t1504;
  t7822 = t7492 * t7821;
  t7823 = 0.1e5 / 0.729e3 * t7822;
  t7824 = t1826 * t1497;
  t7825 = 0.1e3 / 0.81e2 * t7824;
  t7826 = t1826 * t1501;
  t7827 = 0.1e3 / 0.81e2 * t7826;
  t7828 = t1853 * t382;
  t7829 = t1410 * t360;
  t7830 = t194 * t7829;
  t7831 = t4135 * t7830;
  t7832 = t1838 * t7831;
  t7833 = 0.25e2 / 0.81e2 * t7832;
  t7834 = t7363 * t1511;
  t7835 = 0.25e2 / 0.81e2 * t7834;
  t7836 = t1839 * t6953;
  t7837 = t1838 * t7836;
  t7838 = 0.25e2 / 0.162e3 * t7837;
  t7839 = t7352 * t1515;
  t7840 = t7351 * t7839;
  t7841 = 0.5e1 / 0.12e2 * t7840;
  t7842 = t7356 * t7811;
  t7843 = t7351 * t7842;
  t7844 = 0.25e2 / 0.108e3 * t7843;
  t7845 = t4524 * t1520;
  t7846 = t7351 * t7845;
  t7847 = 0.25e2 / 0.108e3 * t7846;
  t7848 = t16 * t346;
  t7849 = t440 * t7848;
  t7850 = t439 * t7849;
  t7851 = t4719 * t7850;
  t7852 = 0.5e3 / 0.243e3 * t7851;
  t7853 = t439 * t6927;
  t7854 = t1826 * t7853;
  t7855 = 0.5e3 / 0.243e3 * t7854;
  t7856 = -t7810 + t7814 - t7817 + t7820 + t7823 - t7825 - t7827 + t7828 + t7833 - t7835 - t7838 + t7841 - t7844 - t7847 - t7471 - t7473 + t7479 + t7483 - t7852 - t7855;
  tv3rhotau24 = -t1828 + t1830 + t1836 - t1842 - t1847 + t1854 + t9 * (t7806 + t7856);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t7859 = t7552 * t5475;
  t7861 = t1323 * t7551 * t7859;
  t7862 = 0.125e3 / 0.243e3 * t7861;
  t7863 = t1882 * t390;
  t7865 = t1323 * t7557 * t7863;
  t7866 = 0.25e2 / 0.162e3 * t7865;
  t7868 = 0.1e1 / t18 / t3189;
  t7869 = t2 * t7868;
  t7870 = t7869 * t1863;
  t7871 = t7870 * t531;
  t7872 = 0.1e4 / 0.243e3 * t7871;
  t7873 = t1882 * t6852;
  t7875 = t1323 * t7557 * t7873;
  t7876 = 0.25e2 / 0.81e2 * t7875;
  t7877 = t544 * t7868;
  t7878 = t7877 * t1861;
  t7879 = t147 * t7878;
  t7880 = t543 * t7879;
  t7881 = 0.2e5 / 0.729e3 * t7880;
  t7882 = t7509 * t7694;
  t7883 = 0.2e4 / 0.81e2 * t7882;
  t7884 = t1868 * t7637;
  t7885 = 0.5e1 / 0.36e2 * t7884;
  t7886 = t7869 * t1861;
  t7887 = t7886 * t50;
  t7888 = t7887 * t1798;
  t7889 = 0.25e2 / 0.54e2 * t7888;
  t7890 = t1893 * t382;
  t7891 = t1876 * t902;
  t7892 = t1354 * t7891;
  t7893 = t1323 * t7892;
  t7894 = 0.25e2 / 0.162e3 * t7893;
  t7895 = t1876 * t1514;
  t7896 = t4174 * t7895;
  t7897 = t1336 * t7896;
  t7898 = 0.5e1 / 0.12e2 * t7897;
  t7899 = t7523 * t1597;
  t7900 = t1338 * t7899;
  t7901 = t1336 * t7900;
  t7902 = 0.25e2 / 0.54e2 * t7901;
  t7903 = t7528 * t7650;
  t7904 = 0.25e2 / 0.81e2 * t7903;
  t7905 = t7868 * t1861;
  t7906 = t7905 * t194;
  t7907 = t1354 * t7906;
  t7908 = t1323 * t7907;
  t7909 = 0.125e3 / 0.243e3 * t7908;
  t7914 = t800 * t801 * t346;
  t7919 = t1876 * t350;
  t7926 = t7515 * t346;
  t7927 = t1871 * t7926;
  t7930 = -0.1e4 / 0.243e3 * t7869 * t1862 * t802 + 0.1e4 / 0.243e3 * t7575 * t7914 - 0.2e4 / 0.81e2 * t1867 * t7675 + 0.1e5 / 0.729e3 * t2535 * t7919 * t50 + 0.2e5 / 0.729e3 * t805 * t806 * t7905 - 0.2e5 / 0.729e3 * t543 * t7927;
  t7931 = t7930 * t146;
  t7932 = -t7862 + t7866 + t7537 + t7540 + t7872 + t7876 - t7881 + t7883 + t7885 - t7889 + t7890 - t7894 + t7898 - t7902 - t7904 + t7909 + t7931;
  t7933 = t388 * t1884;
  t7934 = 0.5e1 / 0.36e2 * t7933;
  t7935 = t1861 * t382;
  t7936 = t1881 * t7935;
  t7937 = t878 * t7936;
  t7938 = t154 * t7937;
  t7939 = 0.5e1 / 0.36e2 * t7938;
  t7940 = t207 * t1597;
  t7941 = t1796 * t7940;
  t7942 = t7593 * t7941;
  t7943 = 0.25e2 / 0.54e2 * t7942;
  t7944 = t1868 * t7722;
  t7945 = 0.5e1 / 0.18e2 * t7944;
  t7946 = t7601 * t6900;
  t7947 = t2556 * t7946;
  t7948 = 0.1e5 / 0.729e3 * t7947;
  t7949 = t1882 * t853;
  t7950 = t7605 * t7949;
  t7951 = t4482 * t7950;
  t7952 = 0.5e3 / 0.243e3 * t7951;
  t7953 = t62 * t7868;
  t7954 = t7953 * t1882;
  t7955 = t878 * t7954;
  t7956 = t154 * t7955;
  t7957 = 0.25e2 / 0.54e2 * t7956;
  t7958 = t1864 * t2637;
  t7959 = 0.1e3 / 0.81e2 * t7958;
  t7960 = t1864 * t2616;
  t7961 = 0.1e3 / 0.81e2 * t7960;
  t7962 = t7523 * t346;
  t7963 = t1295 * t7962;
  t7964 = t1294 * t7963;
  t7965 = 0.2e5 / 0.729e3 * t7964;
  t7966 = t194 * t346;
  t7967 = t1280 * t7966;
  t7968 = t7518 * t7967;
  t7969 = 0.1e4 / 0.243e3 * t7968;
  t7971 = t543 * t365 * t1872;
  t7972 = 0.2e4 / 0.243e3 * t7971;
  t7974 = t543 * t383 * t1872;
  t7975 = 0.2e4 / 0.243e3 * t7974;
  t7976 = -t7934 - t7939 + t7943 - t7945 - t7948 + t7952 + t7957 - t7959 - t7961 + t7965 - t7571 - t7573 - t7969 + t7972 + t7975 + t7619 + t7624;
  tv3rhotau25 = -t1866 + t1870 + t1875 - t1880 - t1886 + t1894 + t9 * (t7932 + t7976);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t7979 = 0.1e1 / t6102;
  t7980 = t2 * t7979;
  t7981 = t7980 * t539;
  t7982 = t7981 * t2326;
  t7983 = 0.125e3 / 0.2592e4 * t7982;
  t7984 = t6102 * t31;
  t7985 = 0.1e1 / t7984;
  t7986 = t2 * t7985;
  t7987 = t7986 * t189;
  t7988 = t6110 * t1651;
  t7989 = t7987 * t7988;
  t7990 = 0.25e2 / 0.3456e4 * t7989;
  t7992 = t1990 * t7979 * t50;
  t7993 = t1989 * t7992;
  t7994 = 0.625e3 / 0.23328e5 * t7993;
  t7995 = t7985 * t61;
  t7996 = t7995 * t6349;
  t7997 = t543 * t7996;
  t7998 = 0.125e3 / 0.2592e4 * t7997;
  t7999 = t7980 * t1951;
  t8002 = t1958 * t7979 * t50;
  t8003 = t1957 * t8002;
  t8005 = 0.125e3 / 0.2592e4 * t7999 - 0.625e3 / 0.23328e5 * t8003;
  t8006 = t8005 * t146;
  tv3sigma30 = t9 * (-t7983 + t7990 + t7994 - t7998 + t8006);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t8008 = 0.125e3 / 0.1296e4 * t7982;
  t8009 = 0.25e2 / 0.1728e4 * t7989;
  t8010 = 0.625e3 / 0.11664e5 * t7993;
  t8011 = 0.125e3 / 0.1296e4 * t7997;
  t8014 = 0.125e3 / 0.1296e4 * t7999 - 0.625e3 / 0.11664e5 * t8003;
  t8015 = t8014 * t146;
  tv3sigma31 = t9 * (-t8008 + t8009 + t8010 - t8011 + t8015);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = tv3sigma30;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  t8017 = 0.125e3 / 0.648e3 * t7982;
  t8018 = 0.25e2 / 0.864e3 * t7989;
  t8019 = 0.625e3 / 0.5832e4 * t7993;
  t8020 = 0.125e3 / 0.648e3 * t7997;
  t8023 = 0.125e3 / 0.648e3 * t7999 - 0.625e3 / 0.5832e4 * t8003;
  t8024 = t8023 * t146;
  tv3sigma33 = t9 * (-t8017 + t8018 + t8019 - t8020 + t8024);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = tv3sigma31;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = tv3sigma32;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  t8026 = 0.125e3 / 0.324e3 * t7982;
  t8027 = 0.25e2 / 0.432e3 * t7989;
  t8028 = 0.625e3 / 0.2916e4 * t7993;
  t8029 = 0.125e3 / 0.324e3 * t7997;
  t8032 = 0.125e3 / 0.324e3 * t7999 - 0.625e3 / 0.2916e4 * t8003;
  t8033 = t8032 * t146;
  tv3sigma36 = t9 * (-t8026 + t8027 + t8028 - t8029 + t8033);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = tv3sigma33;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = tv3sigma34;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = tv3sigma35;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t8035 = t1295 * t1632;
  t8036 = t2325 * t8035;
  t8037 = t4357 * t8036;
  t8038 = 0.125e3 / 0.324e3 * t8037;
  t8039 = t6451 * t1652;
  t8040 = 0.25e2 / 0.648e3 * t8039;
  t8042 = t1632 * t40 * t152;
  t8043 = t4492 * t8042;
  t8044 = t2556 * t8043;
  t8045 = 0.625e3 / 0.2916e4 * t8044;
  t8046 = t1378 * t16;
  t8047 = t409 * t8046;
  t8048 = t6142 * t8047;
  t8049 = 0.125e3 / 0.486e3 * t8048;
  t8050 = t7986 * t185;
  t8051 = t8050 * t1140;
  t8052 = t1702 * t1695;
  t8053 = t8051 * t8052;
  t8054 = 0.25e2 / 0.10368e5 * t8053;
  t8055 = t6116 * t62;
  t8056 = t8055 * t1703;
  t8057 = t6115 * t8056;
  t8058 = 0.5e1 / 0.288e3 * t8057;
  t8060 = t805 * t4480 * t7985;
  t8061 = t447 * t544;
  t8062 = t4483 * t8061;
  t8063 = t8060 * t8062;
  t8064 = 0.125e3 / 0.7776e4 * t8063;
  t8065 = t1141 * t1709;
  t8066 = 0.25e2 / 0.1296e4 * t8065;
  t8067 = t542 * t1645;
  t8068 = t452 * t8067;
  t8070 = t1296 * t1632;
  t8071 = t8070 * t50;
  t8072 = t2535 * t8071;
  t8074 = -0.125e3 / 0.324e3 * t8068 + 0.625e3 / 0.2916e4 * t8072;
  t8075 = t8074 * t146;
  tv3sigma2tau0 = t9 * (t8038 - t8040 - t8045 + t8049 - t8054 - t8058 + t8064 + t8066 + t8075);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t8077 = t4739 * t8036;
  t8078 = 0.125e3 / 0.324e3 * t8077;
  t8079 = t1826 * t1652;
  t8080 = 0.25e2 / 0.648e3 * t8079;
  t8081 = t4596 * t8042;
  t8082 = t2556 * t8081;
  t8083 = 0.625e3 / 0.2916e4 * t8082;
  t8084 = t409 * t7497;
  t8085 = t6142 * t8084;
  t8086 = 0.125e3 / 0.486e3 * t8085;
  t8087 = t1702 * t1736;
  t8088 = t8051 * t8087;
  t8089 = 0.25e2 / 0.10368e5 * t8088;
  t8090 = t8055 * t1740;
  t8091 = t6115 * t8090;
  t8092 = 0.5e1 / 0.288e3 * t8091;
  t8093 = t473 * t544;
  t8094 = t4583 * t8093;
  t8095 = t8060 * t8094;
  t8096 = 0.125e3 / 0.7776e4 * t8095;
  t8097 = t1141 * t1744;
  t8098 = 0.25e2 / 0.1296e4 * t8097;
  t8099 = t478 * t8067;
  t8101 = t1410 * t1632;
  t8103 = t2535 * t8101 * t50;
  t8105 = -0.125e3 / 0.324e3 * t8099 + 0.625e3 / 0.2916e4 * t8103;
  t8106 = t8105 * t146;
  tv3sigma2tau1 = t9 * (t8078 - t8080 - t8083 + t8086 - t8089 - t8092 + t8096 + t8098 + t8106);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  t8108 = 0.125e3 / 0.162e3 * t8037;
  t8109 = 0.25e2 / 0.324e3 * t8039;
  t8110 = 0.625e3 / 0.1458e4 * t8044;
  t8111 = 0.125e3 / 0.243e3 * t8048;
  t8112 = 0.25e2 / 0.5184e4 * t8053;
  t8113 = 0.5e1 / 0.144e3 * t8057;
  t8114 = 0.125e3 / 0.3888e4 * t8063;
  t8115 = 0.25e2 / 0.648e3 * t8065;
  t8118 = -0.125e3 / 0.162e3 * t8068 + 0.625e3 / 0.1458e4 * t8072;
  t8119 = t8118 * t146;
  tv3sigma2tau2 = t9 * (t8108 - t8109 - t8110 + t8111 - t8112 - t8113 + t8114 + t8115 + t8119);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  t8121 = 0.125e3 / 0.162e3 * t8077;
  t8122 = 0.25e2 / 0.324e3 * t8079;
  t8123 = 0.625e3 / 0.1458e4 * t8082;
  t8124 = 0.125e3 / 0.243e3 * t8085;
  t8125 = 0.25e2 / 0.5184e4 * t8088;
  t8126 = 0.5e1 / 0.144e3 * t8091;
  t8127 = 0.125e3 / 0.3888e4 * t8095;
  t8128 = 0.25e2 / 0.648e3 * t8097;
  t8131 = -0.125e3 / 0.162e3 * t8099 + 0.625e3 / 0.1458e4 * t8103;
  t8132 = t8131 * t146;
  tv3sigma2tau3 = t9 * (t8121 - t8122 - t8123 + t8124 - t8125 - t8126 + t8127 + t8128 + t8132);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = tv3sigma2tau0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = tv3sigma2tau1;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  t8134 = 0.125e3 / 0.81e2 * t8037;
  t8135 = 0.25e2 / 0.162e3 * t8039;
  t8136 = 0.625e3 / 0.729e3 * t8044;
  t8137 = 0.25e3 / 0.243e3 * t8048;
  t8138 = 0.25e2 / 0.2592e4 * t8053;
  t8139 = 0.5e1 / 0.72e2 * t8057;
  t8140 = 0.125e3 / 0.1944e4 * t8063;
  t8141 = 0.25e2 / 0.324e3 * t8065;
  t8144 = -0.125e3 / 0.81e2 * t8068 + 0.625e3 / 0.729e3 * t8072;
  t8145 = t8144 * t146;
  tv3sigma2tau6 = t9 * (t8134 - t8135 - t8136 + t8137 - t8138 - t8139 + t8140 + t8141 + t8145);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  t8147 = 0.125e3 / 0.81e2 * t8077;
  t8148 = 0.25e2 / 0.162e3 * t8079;
  t8149 = 0.625e3 / 0.729e3 * t8082;
  t8150 = 0.25e3 / 0.243e3 * t8085;
  t8151 = 0.25e2 / 0.2592e4 * t8088;
  t8152 = 0.5e1 / 0.72e2 * t8091;
  t8153 = 0.125e3 / 0.1944e4 * t8095;
  t8154 = 0.25e2 / 0.324e3 * t8097;
  t8157 = -0.125e3 / 0.81e2 * t8099 + 0.625e3 / 0.729e3 * t8103;
  t8158 = t8157 * t146;
  tv3sigma2tau7 = t9 * (t8147 - t8148 - t8149 + t8150 - t8151 - t8152 + t8153 + t8154 + t8158);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = tv3sigma2tau2;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = tv3sigma2tau3;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = tv3sigma2tau4;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = tv3sigma2tau5;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t8160 = t1295 * t35;
  t8161 = t2325 * t8160;
  t8162 = t7178 * t8161;
  t8163 = 0.25e3 / 0.81e2 * t8162;
  t8164 = t1794 * t189;
  t8165 = t8164 * t3574;
  t8166 = 0.25e2 / 0.162e3 * t8165;
  t8167 = t1321 * t1639;
  t8168 = t207 * t194;
  t8169 = t8167 * t8168;
  t8170 = t8164 * t8169;
  t8171 = 0.25e2 / 0.648e3 * t8170;
  t8172 = t1788 * t40;
  t8173 = t8172 * t44;
  t8174 = t1785 * t8173;
  t8175 = t1687 * t1797;
  t8176 = t8174 * t8175;
  t8177 = 0.5e1 / 0.36e2 * t8176;
  t8179 = t35 * t40 * t152;
  t8180 = t7276 * t8179;
  t8181 = t2556 * t8180;
  t8182 = 0.125e4 / 0.729e3 * t8181;
  t8183 = t409 * t1802;
  t8184 = t3555 * t8183;
  t8185 = 0.25e3 / 0.243e3 * t8184;
  t8186 = t1812 * t544;
  t8187 = t7205 * t8186;
  t8188 = t6442 * t8187;
  t8189 = 0.125e3 / 0.486e3 * t8188;
  t8190 = t1141 * t1808;
  t8191 = 0.25e2 / 0.162e3 * t8190;
  t8192 = t1806 * t146;
  t8193 = t6434 * t8192;
  t8194 = t1700 * t8193;
  t8195 = 0.5e1 / 0.288e3 * t8194;
  t8196 = t6375 * t62;
  t8197 = t8196 * t1807;
  t8198 = t1323 * t8197;
  t8199 = 0.25e2 / 0.1296e4 * t8198;
  t8200 = t1338 * t8192;
  t8201 = t154 * t8200;
  t8202 = 0.5e1 / 0.36e2 * t8201;
  t8203 = t542 * t1120;
  t8204 = t1794 * t8203;
  t8206 = t1806 * t35;
  t8207 = t8206 * t50;
  t8208 = t2535 * t8207;
  t8210 = 0.25e3 / 0.81e2 * t8204 - 0.125e4 / 0.729e3 * t8208;
  t8211 = t8210 * t146;
  t8212 = -t8163 + t8166 + t8171 + t8177 + t8182 - t8185 - t8189 - t8191 + t8195 - t8199 - t8202 + t8211;
  tv3sigmatau20 = t9 * t8212;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t8213 = t7439 * t1691;
  t8214 = t5452 * t8213;
  t8215 = 0.25e3 / 0.81e2 * t8214;
  t8216 = t478 * t7312;
  t8217 = t8216 * t1696;
  t8218 = 0.25e2 / 0.162e3 * t8217;
  t8219 = t30 * t1639;
  t8220 = t8219 * t207;
  t8221 = t8220 * t1695;
  t8222 = t8216 * t8221;
  t8223 = 0.25e2 / 0.648e3 * t8222;
  t8224 = t1151 * t448;
  t8225 = t6552 * t8224;
  t8226 = 0.5e1 / 0.36e2 * t8225;
  t8227 = t7397 * t8179;
  t8228 = t4799 * t8227;
  t8229 = 0.125e4 / 0.729e3 * t8228;
  t8230 = t6349 * t7397;
  t8231 = t6348 * t8230;
  t8232 = 0.25e3 / 0.243e3 * t8231;
  t8234 = t805 * t4480 * t1707;
  t8235 = t8234 * t8230;
  t8236 = 0.125e3 / 0.486e3 * t8235;
  t8237 = t6503 * t1840;
  t8238 = 0.25e2 / 0.162e3 * t8237;
  t8239 = t1699 * t1335;
  t8240 = t574 * t21;
  t8241 = t8240 * t1844;
  t8242 = t8239 * t8241;
  t8243 = 0.5e1 / 0.288e3 * t8242;
  t8245 = t324 * t325 * t8219;
  t8246 = t4524 * t1695;
  t8247 = t8245 * t8246;
  t8248 = 0.25e2 / 0.1296e4 * t8247;
  t8249 = t152 * t408;
  t8250 = t151 * t8249;
  t8251 = t8250 * t8241;
  t8252 = 0.5e1 / 0.36e2 * t8251;
  t8253 = t806 * t1691;
  t8254 = t4739 * t8253;
  t8256 = t1833 * t8179;
  t8257 = t5510 * t8256;
  t8259 = 0.25e3 / 0.81e2 * t8254 - 0.125e4 / 0.729e3 * t8257;
  t8260 = t8259 * t146;
  t8261 = -t8215 + t8218 + t8223 + t8226 + t8229 - t8232 - t8236 - t8238 + t8243 - t8248 - t8252 + t8260;
  tv3sigmatau21 = t9 * t8261;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  t8262 = t7509 * t8161;
  t8263 = 0.25e3 / 0.81e2 * t8262;
  t8264 = t1867 * t189;
  t8265 = t8264 * t3574;
  t8266 = 0.25e2 / 0.162e3 * t8265;
  t8267 = t8264 * t8169;
  t8268 = 0.25e2 / 0.648e3 * t8267;
  t8269 = t1861 * t40;
  t8270 = t8269 * t44;
  t8271 = t1858 * t8270;
  t8272 = t8271 * t8175;
  t8273 = 0.5e1 / 0.36e2 * t8272;
  t8274 = t7601 * t8179;
  t8275 = t2556 * t8274;
  t8276 = 0.125e4 / 0.729e3 * t8275;
  t8277 = t409 * t1872;
  t8278 = t3555 * t8277;
  t8279 = 0.25e3 / 0.243e3 * t8278;
  t8280 = t1882 * t544;
  t8281 = t7605 * t8280;
  t8282 = t6442 * t8281;
  t8283 = 0.125e3 / 0.486e3 * t8282;
  t8284 = t1141 * t1878;
  t8285 = 0.25e2 / 0.162e3 * t8284;
  t8286 = t1876 * t146;
  t8287 = t6434 * t8286;
  t8288 = t1700 * t8287;
  t8289 = 0.5e1 / 0.288e3 * t8288;
  t8290 = t8196 * t1877;
  t8291 = t1323 * t8290;
  t8292 = 0.25e2 / 0.1296e4 * t8291;
  t8293 = t1338 * t8286;
  t8294 = t154 * t8293;
  t8295 = 0.5e1 / 0.36e2 * t8294;
  t8296 = t1867 * t8203;
  t8298 = t1876 * t35;
  t8300 = t2535 * t8298 * t50;
  t8302 = 0.25e3 / 0.81e2 * t8296 - 0.125e4 / 0.729e3 * t8300;
  t8303 = t8302 * t146;
  t8304 = -t8263 + t8266 + t8268 + t8273 + t8276 - t8279 - t8283 - t8285 + t8289 - t8292 - t8295 + t8303;
  tv3sigmatau22 = t9 * t8304;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  t8305 = 0.5e3 / 0.81e2 * t8162;
  t8306 = 0.25e2 / 0.81e2 * t8165;
  t8307 = 0.25e2 / 0.324e3 * t8170;
  t8308 = 0.5e1 / 0.18e2 * t8176;
  t8309 = 0.25e4 / 0.729e3 * t8181;
  t8310 = 0.5e3 / 0.243e3 * t8184;
  t8311 = 0.125e3 / 0.243e3 * t8188;
  t8312 = 0.25e2 / 0.81e2 * t8190;
  t8313 = 0.5e1 / 0.144e3 * t8194;
  t8314 = 0.25e2 / 0.648e3 * t8198;
  t8315 = 0.5e1 / 0.18e2 * t8201;
  t8318 = 0.5e3 / 0.81e2 * t8204 - 0.25e4 / 0.729e3 * t8208;
  t8319 = t8318 * t146;
  t8320 = -t8305 + t8306 + t8307 + t8308 + t8309 - t8310 - t8311 - t8312 + t8313 - t8314 - t8315 + t8319;
  tv3sigmatau23 = t9 * t8320;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  t8321 = 0.5e3 / 0.81e2 * t8214;
  t8322 = 0.25e2 / 0.81e2 * t8217;
  t8323 = 0.25e2 / 0.324e3 * t8222;
  t8324 = 0.5e1 / 0.18e2 * t8225;
  t8325 = 0.25e4 / 0.729e3 * t8228;
  t8326 = 0.5e3 / 0.243e3 * t8231;
  t8327 = 0.125e3 / 0.243e3 * t8235;
  t8328 = 0.25e2 / 0.81e2 * t8237;
  t8329 = 0.5e1 / 0.144e3 * t8242;
  t8330 = 0.25e2 / 0.648e3 * t8247;
  t8331 = 0.5e1 / 0.18e2 * t8251;
  t8334 = 0.5e3 / 0.81e2 * t8254 - 0.25e4 / 0.729e3 * t8257;
  t8335 = t8334 * t146;
  t8336 = -t8321 + t8322 + t8323 + t8324 + t8325 - t8326 - t8327 - t8328 + t8329 - t8330 - t8331 + t8335;
  tv3sigmatau24 = t9 * t8336;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  t8337 = 0.5e3 / 0.81e2 * t8262;
  t8338 = 0.25e2 / 0.81e2 * t8265;
  t8339 = 0.25e2 / 0.324e3 * t8267;
  t8340 = 0.5e1 / 0.18e2 * t8272;
  t8341 = 0.25e4 / 0.729e3 * t8275;
  t8342 = 0.5e3 / 0.243e3 * t8278;
  t8343 = 0.125e3 / 0.243e3 * t8282;
  t8344 = 0.25e2 / 0.81e2 * t8284;
  t8345 = 0.5e1 / 0.144e3 * t8288;
  t8346 = 0.25e2 / 0.648e3 * t8291;
  t8347 = 0.5e1 / 0.18e2 * t8294;
  t8350 = 0.5e3 / 0.81e2 * t8296 - 0.25e4 / 0.729e3 * t8300;
  t8351 = t8350 * t146;
  t8352 = -t8337 + t8338 + t8339 + t8340 + t8341 - t8342 - t8343 - t8344 + t8345 - t8346 - t8347 + t8351;
  tv3sigmatau25 = t9 * t8352;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = tv3sigmatau20;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = tv3sigmatau21;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = tv3sigmatau22;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t8353 = t1898 * rho[0];
  t8354 = 0.1e1 / t8353;
  t8355 = t2 * t8354;
  t8356 = t1786 * t1786;
  t8357 = t8356 * t13;
  t8358 = t8357 * t539;
  t8359 = t8355 * t8358;
  t8361 = 0.2e4 / 0.81e2 * t8359 * t2326;
  t8362 = t8355 * t8357;
  t8363 = t8362 * t189;
  t8364 = t1321 * t58;
  t8365 = t8364 * t8168;
  t8367 = 0.25e2 / 0.54e2 * t8363 * t8365;
  t8368 = t8362 * t50;
  t8369 = t574 * t146;
  t8370 = t1796 * t8369;
  t8372 = 0.5e1 / 0.12e2 * t8368 * t8370;
  t8373 = t1958 * t8354;
  t8375 = t8373 * t8357 * t50;
  t8377 = 0.1e5 / 0.729e3 * t2556 * t8375;
  t8378 = t207 * t8354;
  t8379 = t8357 * t146;
  t8380 = t8379 * t544;
  t8381 = t8378 * t8380;
  t8383 = 0.25e3 / 0.81e2 * t4482 * t8381;
  t8384 = t8354 * t8357;
  t8385 = t8384 * t194;
  t8386 = t1338 * t8385;
  t8388 = 0.25e2 / 0.54e2 * t1323 * t8386;
  t8389 = t62 * t8354;
  t8390 = t8389 * t8379;
  t8391 = t2795 * t8390;
  t8393 = 0.5e1 / 0.12e2 * t154 * t8391;
  t8399 = -0.2e4 / 0.81e2 * t8362 * t1951 + 0.1e5 / 0.729e3 * t2535 * t8384 * t50;
  t8400 = t8399 * t146;
  tv3tau30 = t9 * (t8361 - t8367 - t8372 - t8377 + t8383 + t8388 + t8393 + t8400);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t8403 = 0.2e4 / 0.81e2 * t5452 * t1803;
  t8404 = t7345 * t1807;
  t8406 = 0.25e2 / 0.54e2 * t8216 * t8404;
  t8408 = 0.5e1 / 0.12e2 * t479 * t1814;
  t8410 = t8172 * t152;
  t8411 = t1410 * t1784 * t8410;
  t8413 = 0.1e5 / 0.729e3 * t4799 * t8411;
  t8414 = t1811 * t1788;
  t8415 = t1295 * t1410;
  t8416 = t8414 * t8415;
  t8418 = 0.25e3 / 0.81e2 * t4792 * t8416;
  t8419 = t574 * t1806;
  t8420 = t8419 * t1736;
  t8422 = 0.25e2 / 0.54e2 * t1838 * t8420;
  t8423 = t473 * t1806;
  t8424 = t5385 * t8423;
  t8426 = 0.5e1 / 0.12e2 * t1336 * t8424;
  t8429 = t27 * t1784;
  t8430 = t8429 * t1788;
  t8431 = t8430 * t50;
  t8434 = -0.2e4 / 0.81e2 * t4739 * t1820 + 0.1e5 / 0.729e3 * t5510 * t8431;
  t8435 = t8434 * t146;
  tv3tau31 = t9 * (t8403 - t8406 - t8408 - t8413 + t8418 + t8422 + t8426 + t8435);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  t8437 = t7508 * t541;
  t8438 = t1858 * t8437;
  t8439 = t147 * t8046;
  t8441 = 0.2e4 / 0.81e2 * t8438 * t8439;
  t8442 = t7345 * t1695;
  t8444 = 0.25e2 / 0.54e2 * t7528 * t8442;
  t8445 = t1867 * t453;
  t8446 = t878 * t448;
  t8448 = 0.5e1 / 0.12e2 * t8445 * t8446;
  t8450 = t432 * t152;
  t8451 = t1876 * t6 * t8450;
  t8453 = 0.1e5 / 0.729e3 * t4799 * t8451;
  t8454 = t1295 * t1876;
  t8455 = t4793 * t8454;
  t8457 = 0.25e3 / 0.81e2 * t4792 * t8455;
  t8458 = t574 * t1876;
  t8459 = t8458 * t1695;
  t8461 = 0.25e2 / 0.54e2 * t1838 * t8459;
  t8462 = t4173 * t1881;
  t8463 = t1882 * t1296;
  t8464 = t8462 * t8463;
  t8466 = 0.5e1 / 0.12e2 * t1336 * t8464;
  t8467 = t806 * t1296;
  t8471 = t805 * t5111 * t1857;
  t8472 = t1861 * t6;
  t8473 = t8472 * t16;
  t8474 = t8473 * t50;
  t8477 = -0.2e4 / 0.81e2 * t7509 * t8467 + 0.1e5 / 0.729e3 * t8471 * t8474;
  t8478 = t8477 * t146;
  tv3tau32 = t9 * (t8441 - t8444 - t8448 - t8453 + t8457 + t8461 + t8466 + t8478);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t8480 = t3189 * rho[1];
  t8481 = 0.1e1 / t8480;
  t8482 = t2 * t8481;
  t8483 = t1859 * t1859;
  t8484 = t8483 * t24;
  t8485 = t8484 * t539;
  t8486 = t8482 * t8485;
  t8488 = 0.2e4 / 0.81e2 * t8486 * t2326;
  t8489 = t8482 * t8484;
  t8490 = t8489 * t189;
  t8492 = 0.25e2 / 0.54e2 * t8490 * t8365;
  t8493 = t8489 * t50;
  t8495 = 0.5e1 / 0.12e2 * t8493 * t8370;
  t8496 = t1958 * t8481;
  t8498 = t8496 * t8484 * t50;
  t8500 = 0.1e5 / 0.729e3 * t2556 * t8498;
  t8501 = t207 * t8481;
  t8502 = t8484 * t146;
  t8503 = t8502 * t544;
  t8504 = t8501 * t8503;
  t8506 = 0.25e3 / 0.81e2 * t4482 * t8504;
  t8507 = t8481 * t8484;
  t8508 = t8507 * t194;
  t8509 = t1338 * t8508;
  t8511 = 0.25e2 / 0.54e2 * t1323 * t8509;
  t8512 = t62 * t8481;
  t8513 = t8512 * t8502;
  t8514 = t2795 * t8513;
  t8516 = 0.5e1 / 0.12e2 * t154 * t8514;
  t8519 = t8507 * t50;
  t8522 = -0.2e4 / 0.81e2 * t8489 * t1951 + 0.1e5 / 0.729e3 * t2535 * t8519;
  t8523 = t8522 * t146;
  tv3tau33 = t9 * (t8488 - t8492 - t8495 - t8500 + t8506 + t8511 + t8516 + t8523);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t9, t10;
  double t11, t12, t13, t14, t15, t16, t17, t18;
  double t19, t21, t22, t23, t24, t25, t26, t27;
  double t28, t30, t31, t32, t33, t35, t38, t39;
  double t40, t41, t42, t43, t44, t45, t46, t47;
  double t48, t50, t53, t54, t55, t56, t58, t59;
  double t60, t61, t62, t63, t66, t67, t68, t69;
  double t70, t71, t72, t75, t77, t78, t81, t83;
  double t84, t85, t88, t90, t93, t94, t96, t97;
  double t98, t99, t100, t101, t102, t103, t105, t106;
  double t107, t109, t110, t113, t114, t116, t121, t124;
  double t125, t129, t134, t137, t138, t139, t141, t142;
  double t146, t147, t148, t150, t151, t152, t153, t154;
  double t156, t157, tzk0;

  double t158, t160, t161, t162, t164, t165, t166, t167;
  double t168, t169, t171, t172, t173, t175, t177, t179;
  double t180, t181, t182, t183, t184, t185, t187, t188;
  double t189, t190, t191, t192, t193, t194, t195, t196;
  double t197, t198, t199, t201, t202, t204, t205, t206;
  double t207, t209, t210, t213, t215, t216, t217, t218;
  double t219, t220, t222, t223, t226, t227, t228, t229;
  double t231, t232, t233, t234, t236, t238, t239, t240;
  double t245, t247, t248, t249, t251, t252, t253, t255;
  double t256, t257, t259, t262, t263, t266, t268, t269;
  double t274, t275, t276, t281, t282, t283, t289, t290;
  double t291, t296, t297, t298, t301, t302, t303, t306;
  double t308, t310, t311, t313, t315, t316, t317, t318;
  double t319, t320, t321, t322, t324, t325, t326, t327;
  double t330, t331, t332, tvrho0, t335, t336, t337, t338;
  double t340, t342, t343, t344, t346, t347, t348, t350;
  double t351, t352, t353, t354, t355, t356, t357, t358;
  double t360, t361, t364, t365, t366, t367, t368, t371;
  double t372, t375, t377, t378, t382, t383, t384, t385;
  double t386, t387, t388, t390, t391, t394, t395, t396;
  double tvrho1, t399, t400, t401, t402, t403, t405, t406;
  double t407, t408, t409, t410, t411, t412, t414, t416;
  double t418, t420, t421, tvsigma0, t423, t424, t425, t428;
  double t429, tvsigma1, tvsigma2, tvlapl0, tvlapl1, t431, t432, t433;
  double t434, t435, t436, t438, t439, t440, t441, t442;
  double t444, t445, t446, t447, t448, t449, t451, t452;
  double t453, t456, t459, t460, tvtau0, t462, t463, t464;
  double t466, t467, t468, t471, t472, t473, t474, t475;
  double t477, t478, t479, t484, t485, tvtau1;

  double t493, t495, t496, t498, t500, t501, t502, t503;
  double t505, t506, t507, t508, t509, t511, t512, t513;
  double t514, t516, t517, t518, t520, t521, t522, t523;
  double t524, t525, t526, t527, t528, t529, t530, t531;
  double t532, t533, t534, t535, t536, t537, t538, t539;
  double t541, t542, t543, t544, t545, t546, t547, t548;
  double t549, t550, t551, t552, t553, t554, t555, t556;
  double t557, t558, t559, t560, t561, t562, t564, t565;
  double t567, t568, t571, t573, t574, t575, t576, t579;
  double t580, t581, t583, t584, t588, t589, t590, t591;
  double t592, t593, t594, t595, t596, t597, t598, t599;
  double t600, t601, t602, t603, t604, t606, t607, t608;
  double t612, t613, t614, t615, t618, t619, t620, t622;
  double t623, t625, t626, t627, t629, t632, t634, t636;
  double t638, t639, t640, t641, t644, t648, t649, t650;
  double t651, t654, t658, t660, t669, t670, t672, t673;
  double t674, t675, t676, t677, t678, t679, t681, t685;
  double t686, t690, t691, t692, t693, t694, t703, t704;
  double t707, t708, t709, t710, t711, t712, t717, t718;
  double t721, t722, t723, t724, t725, t727, t731, t735;
  double t736, t737, t738, t741, t744, t745, t748, t749;
  double t750, t751, t753, t754, t756, t759, t760, t761;
  double t764, t766, t768, t769, t770, t772, t773, t775;
  double t776, t778, t779, t780, t782, t783, t784, t787;
  double t789, t790, t791, t792, t793, t794, t795, t796;
  double t797, t799, t800, t801, t802, t805, t806, t807;
  double t810, t811, t814, t815, t816, t817, t818, t819;
  double tv2rho20, t822, t823, t824, t826, t827, t828, t830;
  double t832, t833, t834, t836, t837, t838, t840, t841;
  double t842, t843, t844, t846, t847, t849, t851, t853;
  double t854, t855, t856, t858, t859, t861, t862, t863;
  double t865, t866, t867, t869, t871, t872, t873, t876;
  double t878, t879, t880, t883, t884, t886, t887, t891;
  double t892, t893, t894, t896, t897, t898, t900, t902;
  double t903, t904, t905, t907, t908, t909, t911, t913;
  double t915, t918, t922, t923, t926, t930, t932, t933;
  double t935, t936, t937, t938, t941, t945, t946, t950;
  double t951, t952, t953, t954, t956, t957, t959, t962;
  double t963, t966, t967, t970, t971, t972, t973, t974;
  double t975, tv2rho21, t983, t984, t986, t987, t988, t990;
  double t991, t993, t994, t996, t998, t999, t1000, t1002;
  double t1003, t1004, t1006, t1007, t1008, t1009, t1010, t1011;
  double t1012, t1013, t1014, t1015, t1016, t1017, t1018, t1019;
  double t1020, t1021, t1022, t1023, t1024, t1025, t1026, t1027;
  double t1028, t1029, t1030, t1031, t1032, t1033, t1034, t1035;
  double t1037, t1038, t1042, t1043, t1046, t1047, t1048, t1049;
  double t1050, t1051, t1052, t1053, t1054, t1055, t1058, t1062;
  double t1063, t1066, t1070, t1072, t1073, t1081, t1083, t1084;
  double t1085, t1086, t1087, t1088, t1089, t1090, t1092, t1095;
  double t1098, t1099, t1102, t1103, t1104, t1105, t1106, t1107;
  double tv2rho22, t1109, t1110, t1111, t1112, t1113, t1114, t1115;
  double t1116, t1117, t1118, t1119, t1120, t1121, t1122, t1123;
  double t1124, t1126, t1127, t1128, t1130, t1131, t1132, t1134;
  double t1135, t1136, t1137, t1138, t1139, t1140, t1141, t1142;
  double t1143, t1144, t1145, t1146, t1147, t1148, t1149, t1150;
  double t1151, t1152, t1153, t1154, t1155, t1156, t1157, t1158;
  double t1159, t1160, t1161, t1162, t1163, t1164, t1166, t1167;
  double t1168, t1169, t1171, t1172, t1173, t1175, t1177, t1178;
  double t1179, t1180, t1181, t1182, tv2rhosigma0, t1184, t1185, t1186;
  double t1187, t1188, t1189, t1190, t1191, t1192, t1193, t1194;
  double t1195, t1196, t1197, t1198, t1201, t1202, t1203, t1204;
  double t1205, tv2rhosigma1, tv2rhosigma2, t1207, t1208, t1209, t1210, t1211;
  double t1212, t1213, t1214, t1215, t1216, t1218, t1219, t1220;
  double t1222, t1223, t1224, t1225, t1226, t1227, t1228, t1229;
  double t1230, t1231, t1232, t1233, t1234, t1235, t1236, t1237;
  double t1238, t1240, t1241, t1242, t1244, t1245, t1246, t1247;
  double tv2rhosigma3, t1249, t1250, t1251, t1252, t1253, t1254, t1255;
  double t1256, t1257, t1258, t1261, t1262, t1263, t1264, tv2rhosigma4;
  double tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3, t1266, t1267, t1268;
  double t1269, t1270, t1271, t1272, t1274, t1275, t1276, t1277;
  double t1278, t1279, t1280, t1281, t1282, t1283, t1284, t1286;
  double t1287, t1288, t1290, t1291, t1292, t1293, t1294, t1295;
  double t1296, t1297, t1298, t1299, t1300, t1301, t1302, t1303;
  double t1304, t1305, t1306, t1307, t1308, t1309, t1310, t1311;
  double t1312, t1313, t1314, t1315, t1317, t1318, t1319, t1320;
  double t1321, t1322, t1323, t1324, t1325, t1326, t1327, t1328;
  double t1329, t1330, t1331, t1332, t1333, t1334, t1335, t1336;
  double t1337, t1338, t1339, t1340, t1341, t1342, t1343, t1344;
  double t1345, t1346, t1347, t1348, t1349, t1350, t1351, t1352;
  double t1353, t1354, t1355, t1356, t1357, t1358, t1359, t1360;
  double t1361, t1362, t1363, t1364, t1365, t1368, t1369, t1370;
  double t1373, t1375, t1378, t1379, t1380, t1383, t1389, t1390;
  double t1391, t1392, tv2rhotau0, t1394, t1395, t1396, t1398, t1399;
  double t1400, t1401, t1402, t1403, t1404, t1405, t1406, t1407;
  double t1408, t1409, t1410, t1411, t1412, t1413, t1414, t1416;
  double t1417, t1419, t1420, t1421, t1422, t1424, t1425, t1426;
  double t1427, t1428, t1429, t1430, t1431, t1432, t1433, t1434;
  double t1435, t1436, t1437, t1438, t1439, t1440, t1441, t1442;
  double t1443, t1444, t1445, t1446, t1447, t1448, t1449, t1450;
  double t1451, t1452, t1453, t1454, t1455, t1456, t1457, t1460;
  double t1463, t1464, t1465, t1471, t1472, t1473, t1474, tv2rhotau1;
  double t1477, t1478, t1479, t1480, t1481, t1482, t1483, t1485;
  double t1486, t1487, t1489, t1490, t1491, t1492, t1493, t1494;
  double t1495, t1496, t1497, t1498, t1499, t1500, t1501, t1502;
  double t1503, t1504, t1506, t1507, t1508, t1509, t1510, t1511;
  double t1512, t1513, t1514, t1515, t1516, t1517, t1518, t1519;
  double t1520, t1521, t1522, t1523, t1524, t1525, t1526, t1527;
  double t1528, t1529, t1530, t1534, t1537, t1538, t1544, t1545;
  double t1546, t1547, tv2rhotau2, t1549, t1550, t1551, t1552, t1554;
  double t1555, t1556, t1557, t1558, t1559, t1560, t1561, t1562;
  double t1563, t1564, t1565, t1566, t1568, t1569, t1571, t1572;
  double t1573, t1574, t1576, t1577, t1578, t1580, t1581, t1582;
  double t1583, t1584, t1585, t1586, t1587, t1588, t1589, t1590;
  double t1591, t1592, t1593, t1594, t1595, t1596, t1597, t1598;
  double t1599, t1600, t1601, t1602, t1603, t1604, t1605, t1606;
  double t1607, t1608, t1610, t1611, t1616, t1617, t1626, t1627;
  double t1628, t1629, tv2rhotau3, t1632, t1633, t1634, t1635, t1636;
  double t1637, t1639, t1640, t1641, t1642, t1643, t1644, t1645;
  double t1647, t1648, t1649, t1650, t1651, t1652, t1653, t1654;
  double t1656, t1659, t1661, t1662, tv2sigma20, t1664, t1665, t1666;
  double t1667, t1670, t1671, tv2sigma21, tv2sigma22, t1673, t1674, t1675;
  double t1676, t1679, t1680, tv2sigma23, tv2sigma24, tv2sigma25, tv2sigmalapl0, tv2sigmalapl1;
  double tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t1682, t1683, t1684, t1685;
  double t1686, t1687, t1688, t1689, t1690, t1691, t1692, t1693;
  double t1694, t1695, t1696, t1697, t1698, t1699, t1700, t1701;
  double t1702, t1703, t1704, t1705, t1706, t1707, t1708, t1709;
  double t1710, t1711, t1712, t1713, t1714, t1716, t1717, t1719;
  double t1721, t1723, t1724, tv2sigmatau0, t1726, t1727, t1728, t1729;
  double t1730, t1731, t1732, t1733, t1734, t1735, t1736, t1738;
  double t1739, t1740, t1741, t1742, t1743, t1744, t1745, t1746;
  double t1747, t1748, t1749, t1750, t1752, t1754, t1756, t1757;
  double tv2sigmatau1, t1759, t1760, t1761, t1762, t1763, t1764, t1765;
  double t1768, t1769, tv2sigmatau2, t1771, t1772, t1773, t1774, t1775;
  double t1776, t1777, t1780, t1781, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, tv2lapl20;
  double tv2lapl21, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, t1784, t1785;
  double t1786, t1788, t1789, t1790, t1791, t1793, t1794, t1795;
  double t1796, t1797, t1798, t1800, t1801, t1802, t1803, t1805;
  double t1806, t1807, t1808, t1810, t1811, t1812, t1813, t1814;
  double t1816, t1820, t1823, t1824, tv2tau20, t1826, t1828, t1830;
  double t1831, t1832, t1833, t1834, t1836, t1837, t1838, t1839;
  double t1840, t1842, t1843, t1844, t1845, t1847, t1853, t1854;
  double tv2tau21, t1857, t1858, t1859, t1861, t1862, t1863, t1864;
  double t1866, t1867, t1868, t1870, t1871, t1872, t1875, t1876;
  double t1877, t1878, t1880, t1881, t1882, t1883, t1884, t1886;
  double t1887, t1893, t1894, tv2tau22;

  double t1896, t1897, t1898, t1900, t1901, t1903, t1905, t1907;
  double t1909, t1910, t1911, t1912, t1913, t1915, t1916, t1917;
  double t1919, t1920, t1921, t1922, t1923, t1925, t1926, t1927;
  double t1928, t1929, t1931, t1932, t1933, t1935, t1936, t1937;
  double t1939, t1940, t1941, t1942, t1944, t1949, t1950, t1951;
  double t1954, t1955, t1956, t1957, t1958, t1960, t1963, t1964;
  double t1967, t1968, t1971, t1972, t1973, t1974, t1975, t1976;
  double t1977, t1978, t1979, t1980, t1981, t1982, t1983, t1984;
  double t1985, t1986, t1987, t1988, t1989, t1990, t1992, t1993;
  double t1994, t1995, t1998, t1999, t2001, t2003, t2004, t2006;
  double t2007, t2008, t2010, t2011, t2012, t2013, t2014, t2017;
  double t2018, t2021, t2024, t2028, t2030, t2031, t2034, t2037;
  double t2041, t2043, t2044, t2047, t2048, t2050, t2052, t2053;
  double t2055, t2057, t2058, t2060, t2064, t2065, t2068, t2071;
  double t2072, t2075, t2077, t2079, t2081, t2083, t2085, t2086;
  double t2087, t2092, t2093, t2095, t2096, t2098, t2099, t2101;
  double t2102, t2104, t2105, t2106, t2108, t2110, t2113, t2115;
  double t2117, t2119, t2121, t2124, t2125, t2127, t2128, t2129;
  double t2131, t2133, t2135, t2137, t2138, t2140, t2147, t2151;
  double t2159, t2166, t2170, t2171, t2174, t2177, t2180, t2181;
  double t2184, t2186, t2187, t2189, t2190, t2192, t2201, t2202;
  double t2205, t2208, t2209, t2213, t2214, t2216, t2217, t2221;
  double t2222, t2223, t2238, t2242, t2245, t2246, t2249, t2253;
  double t2254, t2255, t2257, t2266, t2267, t2269, t2270, t2271;
  double t2272, t2273, t2275, t2276, t2277, t2278, t2279, t2280;
  double t2282, t2283, t2284, t2285, t2287, t2289, t2291, t2292;
  double t2293, t2294, t2295, t2297, t2299, t2301, t2303, t2304;
  double t2306, t2307, t2309, t2310, t2311, t2313, t2315, t2316;
  double t2320, t2322, t2323, t2324, t2325, t2326, t2327, t2328;
  double t2329, t2330, t2331, t2332, t2333, t2334, t2335, t2336;
  double t2337, t2339, t2340, t2342, t2343, t2344, t2345, t2346;
  double t2347, t2348, t2349, t2351, t2352, t2353, t2354, t2355;
  double t2357, t2358, t2359, t2361, t2362, t2364, t2365, t2367;
  double t2368, t2369, t2371, t2373, t2375, t2376, t2377, t2378;
  double t2379, t2380, t2381, t2384, t2385, t2386, t2388, t2389;
  double t2392, t2393, t2395, t2396, t2398, t2399, t2402, t2404;
  double t2405, t2406, t2408, t2409, t2410, t2412, t2413, t2414;
  double t2415, t2416, t2417, t2418, t2419, t2420, t2421, t2422;
  double t2423, t2424, t2425, t2426, t2427, t2428, t2429, t2430;
  double t2431, t2432, t2433, t2434, tv3rho30, t2451, t2452, t2453;
  double t2454, t2455, t2456, t2457, t2458, t2459, t2460, t2461;
  double t2462, t2463, t2464, t2465, t2466, t2467, t2468, t2469;
  double t2470, t2471, t2473, t2474, t2475, t2478, t2480, t2482;
  double t2484, t2486, t2487, t2488, t2490, t2491, t2493, t2494;
  double t2496, t2497, t2499, t2501, t2503, t2505, t2507, t2508;
  double t2509, t2511, t2512, t2514, t2515, t2517, t2518, t2520;
  double t2521, t2522, t2524, t2526, t2529, t2534, t2535, t2537;
  double t2540, t2541, t2544, t2545, t2548, t2549, t2552, t2553;
  double t2554, t2555, t2556, t2557, t2559, t2560, t2562, t2563;
  double t2564, t2566, t2567, t2569, t2570, t2571, t2572, t2574;
  double t2575, t2577, t2578, t2579, t2581, t2582, t2583, t2585;
  double t2586, t2587, t2588, t2590, t2591, t2593, t2594, t2596;
  double t2597, t2599, t2600, t2602, t2603, t2604, t2606, t2608;
  double t2610, t2612, t2613, t2615, t2616, t2617, t2619, t2620;
  double t2622, t2623, t2625, t2627, t2628, t2629, t2630, t2632;
  double t2633, t2634, t2636, t2637, t2638, t2642, t2644, t2646;
  double t2647, t2648, t2649, t2651, t2654, t2659, t2661, t2663;
  double t2665, t2666, t2668, t2670, t2671, t2674, t2676, t2677;
  double t2678, t2681, t2692, t2693, t2696, t2707, t2709, t2710;
  double t2712, t2715, t2716, t2717, t2718, t2719, t2721, t2723;
  double t2725, t2726, t2734, t2736, t2737, t2739, t2740, t2742;
  double t2743, t2746, t2747, t2750, t2751, t2753, t2755, t2757;
  double t2759, t2761, t2762, t2764, t2766, t2767, t2769, t2772;
  double t2774, t2776, t2777, t2779, t2780, t2783, t2784, t2788;
  double t2789, t2790, t2792, t2794, t2795, t2796, t2799, t2800;
  double t2801, t2805, t2809, t2810, t2812, t2813, t2816, t2817;
  double t2820, t2821, t2823, t2824, t2826, t2828, t2830, t2831;
  double t2833, t2835, t2837, t2839, t2843, t2844, tv3rho31, t2846;
  double t2847, t2848, t2850, t2851, t2852, t2854, t2856, t2857;
  double t2858, t2860, t2862, t2863, t2865, t2867, t2869, t2871;
  double t2872, t2873, t2875, t2876, t2877, t2879, t2880, t2881;
  double t2883, t2884, t2885, t2887, t2888, t2889, t2891, t2893;
  double t2898, t2899, t2903, t2906, t2907, t2910, t2911, t2914;
  double t2915, t2918, t2919, t2920, t2922, t2931, t2934, t2935;
  double t2940, t2942, t2944, t2946, t2951, t2956, t2960, t2961;
  double t2966, t2969, t2973, t2975, t2976, t2978, t2979, t2980;
  double t2987, t2988, t2992, t2994, t2995, t2996, t2998, t2999;
  double t3002, t3003, t3005, t3008, t3009, t3012, t3013, t3015;
  double t3017, t3018, t3020, t3021, t3023, t3024, t3029, t3031;
  double t3032, t3035, t3036, t3038, t3042, t3044, t3045, t3048;
  double t3049, t3051, t3052, t3056, t3058, t3059, t3062, t3063;
  double t3065, t3068, t3069, t3071, t3072, t3074, t3076, t3078;
  double t3079, t3080, t3082, t3084, t3086, t3088, t3090, t3092;
  double t3094, t3096, t3097, t3098, t3100, t3101, t3102, t3104;
  double t3106, t3107, t3109, t3110, t3112, t3113, t3115, t3116;
  double t3118, t3120, t3122, t3123, t3124, t3125, t3126, t3128;
  double t3129, t3130, t3132, t3133, t3134, t3136, t3137, t3139;
  double t3140, t3142, t3143, t3144, t3146, t3147, t3148, t3150;
  double t3153, t3155, t3156, t3158, t3160, t3162, t3163, t3164;
  double t3167, t3169, t3173, t3174, tv3rho32, t3175, t3176, t3177;
  double t3178, t3180, t3181, t3183, t3184, t3185, t3186, t3188;
  double t3189, t3191, t3192, t3194, t3196, t3198, t3200, t3201;
  double t3202, t3204, t3205, t3207, t3208, t3209, t3211, t3212;
  double t3213, t3215, t3219, t3220, t3224, t3227, t3228, t3231;
  double t3232, t3235, t3236, t3237, t3238, t3240, t3241, t3242;
  double t3243, t3244, t3245, t3250, t3255, t3259, t3260, t3265;
  double t3269, t3271, t3272, t3274, t3281, t3287, t3292, t3294;
  double t3295, t3296, t3297, t3298, t3299, t3300, t3301, t3302;
  double t3303, t3304, t3305, t3306, t3307, t3308, t3309, t3310;
  double t3311, t3312, t3313, t3314, t3315, t3316, t3317, t3318;
  double t3319, t3320, t3322, t3323, t3324, t3329, t3330, t3334;
  double t3339, t3340, t3343, t3345, t3346, t3347, t3349, t3350;
  double t3351, t3353, t3354, t3355, t3356, t3357, t3358, t3359;
  double t3360, t3361, t3362, t3363, t3364, t3365, t3366, t3368;
  double t3369, t3371, t3372, t3373, t3374, t3375, t3376, t3378;
  double t3379, t3380, t3381, t3382, tv3rho33, t3399, t3400, t3402;
  double t3403, t3404, t3406, t3407, t3408, t3409, t3410, t3411;
  double t3412, t3413, t3414, t3415, t3416, t3417, t3418, t3419;
  double t3420, t3421, t3422, t3423, t3424, t3425, t3426, t3427;
  double t3428, t3429, t3430, t3431, t3432, t3433, t3434, t3435;
  double t3436, t3437, t3438, t3439, t3440, t3441, t3442, t3443;
  double t3444, t3445, t3446, t3447, t3448, t3449, t3451, t3452;
  double t3453, t3454, t3455, t3456, t3457, t3459, t3460, t3461;
  double t3462, t3463, t3464, t3465, t3467, t3471, t3474, t3475;
  double t3476, t3478, t3479, t3483, t3484, t3485, t3486, t3487;
  double t3488, t3490, t3491, t3492, t3493, t3494, t3495, t3496;
  double t3497, t3498, t3499, t3500, t3501, t3502, t3503, t3504;
  double t3505, t3507, t3508, t3509, t3510, t3511, t3512, t3513;
  double t3514, t3515, t3517, t3518, t3519, t3521, t3522, t3523;
  double t3525, t3526, t3527, t3528, t3529, t3530, t3531, t3532;
  double t3533, t3534, t3535, t3536, t3537, t3538, t3539, t3540;
  double t3541, t3542, t3543, t3544, t3545, t3546, t3547, t3548;
  double t3549, t3550, t3551, t3552, t3553, t3554, t3555, t3556;
  double t3557, t3558, t3559, t3560, t3561, t3562, t3563, t3564;
  double t3565, t3566, t3567, t3568, t3569, t3570, t3571, t3572;
  double t3573, t3574, t3575, t3576, t3577, t3578, t3579, t3580;
  double t3581, t3582, t3583, t3584, t3585, t3586, t3587, t3588;
  double t3589, t3590, tv3rho2sigma0, t3598, t3599, t3601, t3610, t3612;
  double t3613, t3614, t3621, t3622, t3623, t3624, t3625, t3626;
  double t3627, t3628, t3629, t3630, t3631, t3632, t3633, t3634;
  double t3635, t3636, t3637, t3638, t3639, t3640, t3641, t3642;
  double t3643, t3644, t3645, t3646, t3647, t3649, t3650, t3651;
  double t3652, t3653, t3654, t3655, t3656, t3657, t3658, t3659;
  double t3660, t3661, t3662, t3663, t3664, t3665, t3666, t3667;
  double t3668, t3669, t3670, t3671, t3672, t3673, t3674, tv3rho2sigma1;
  double tv3rho2sigma2, t3678, t3679, t3680, t3681, t3683, t3684, t3686;
  double t3687, t3688, t3690, t3692, t3694, t3696, t3698, t3700;
  double t3702, t3703, t3704, t3705, t3707, t3708, t3710, t3711;
  double t3713, t3715, t3716, t3718, t3719, t3722, t3724, t3726;
  double t3729, t3730, t3732, t3733, t3734, t3736, t3737, t3738;
  double t3741, t3742, t3743, t3744, t3749, t3751, t3754, t3756;
  double t3758, t3761, t3764, t3767, t3769, t3771, t3773, t3775;
  double t3777, t3779, t3781, t3783, t3784, t3786, t3787, t3788;
  double t3790, t3792, t3794, t3795, t3796, t3798, t3799, t3801;
  double t3803, t3806, t3807, t3809, t3810, t3811, t3813, t3814;
  double t3816, t3817, t3818, t3821, t3823, t3824, t3826, t3827;
  double t3828, t3830, t3831, t3832, t3834, t3835, t3836, t3837;
  double t3838, t3840, t3842, t3843, t3845, t3847, t3848, t3849;
  double t3851, t3853, t3854, t3855, t3857, t3858, t3859, t3860;
  double t3862, t3863, t3864, t3875, t3879, tv3rho2sigma3, t3880, t3881;
  double t3882, t3883, t3884, t3885, t3886, t3887, t3888, t3889;
  double t3890, t3891, t3892, t3893, t3894, t3895, t3896, t3897;
  double t3898, t3899, t3900, t3901, t3902, t3903, t3904, t3905;
  double t3906, t3907, t3908, t3909, t3910, t3911, t3912, t3913;
  double t3915, t3916, t3917, t3918, t3919, t3920, t3921, t3922;
  double t3926, t3928, t3929, t3930, t3931, t3932, t3933, t3934;
  double t3935, t3936, t3937, t3938, t3939, t3940, t3941, t3942;
  double t3943, t3944, t3945, t3946, t3947, t3951, tv3rho2sigma4, tv3rho2sigma5;
  double t3952, t3953, t3954, t3955, t3956, t3957, t3958, t3959;
  double t3960, t3961, t3962, t3963, t3964, t3965, t3966, t3967;
  double t3968, t3969, t3970, t3971, t3972, t3973, t3974, t3975;
  double t3976, t3977, t3978, t3979, t3980, t3981, t3982, t3983;
  double t3984, t3985, t3986, t3987, t3988, t3989, t3990, t3991;
  double t3992, t3993, t3994, t3995, t3996, t3997, t3998, t3999;
  double t4000, t4001, t4002, t4003, t4004, t4005, t4006, t4007;
  double t4008, t4010, t4011, t4012, t4013, t4014, t4015, t4016;
  double t4017, t4018, t4019, t4021, t4022, t4024, t4025, t4026;
  double t4028, t4029, t4030, t4031, t4032, t4033, t4034, t4035;
  double t4036, t4037, t4038, t4040, t4042, t4044, t4046, t4047;
  double t4048, t4050, t4051, t4052, tv3rho2sigma6, t4070, t4071, t4072;
  double t4073, t4074, t4075, t4076, t4077, t4078, t4079, t4080;
  double t4081, t4082, t4083, t4084, t4085, t4086, t4087, t4088;
  double t4089, t4090, t4091, t4092, t4093, t4094, t4096, t4097;
  double t4098, t4099, t4100, t4101, t4102, t4103, t4104, t4105;
  double t4106, t4107, t4108, t4109, t4116, t4117, t4118, t4119;
  double t4120, t4121, t4122, t4123, t4124, t4125, tv3rho2sigma7, tv3rho2sigma8;
  double tv3rho2lapl0, tv3rho2lapl1, tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4, tv3rho2lapl5, t4129, t4130;
  double t4131, t4132, t4133, t4134, t4135, t4136, t4137, t4138;
  double t4139, t4140, t4141, t4142, t4143, t4144, t4145, t4146;
  double t4147, t4148, t4149, t4150, t4151, t4152, t4153, t4154;
  double t4155, t4156, t4157, t4158, t4159, t4160, t4161, t4162;
  double t4163, t4164, t4165, t4166, t4167, t4168, t4169, t4170;
  double t4171, t4172, t4173, t4174, t4175, t4176, t4177, t4178;
  double t4179, t4180, t4181, t4182, t4183, t4184, t4185, t4186;
  double t4187, t4188, t4189, t4190, t4191, t4192, t4193, t4194;
  double t4195, t4196, t4197, t4198, t4199, t4200, t4201, t4202;
  double t4203, t4204, t4205, t4206, t4207, t4208, t4209, t4210;
  double t4211, t4212, t4213, t4214, t4215, t4216, t4217, t4218;
  double t4219, t4220, t4221, t4222, t4223, t4224, t4225, t4226;
  double t4227, t4228, t4229, t4230, t4231, t4232, t4233, t4234;
  double t4235, t4236, t4237, t4238, t4239, t4240, t4241, t4242;
  double t4243, t4244, t4245, t4246, t4247, t4248, t4249, t4250;
  double t4251, t4252, t4253, t4254, t4255, t4256, t4257, t4258;
  double t4259, t4260, t4261, t4262, t4263, t4264, t4265, t4266;
  double t4267, t4268, t4269, t4271, t4272, t4273, t4274, t4275;
  double t4276, t4277, t4278, t4279, t4280, t4281, t4282, t4283;
  double t4284, t4285, t4286, t4287, t4288, t4289, t4290, t4291;
  double t4292, t4295, t4296, t4297, t4299, t4300, t4301, t4303;
  double t4304, t4305, t4306, t4307, t4308, t4309, t4310, t4311;
  double t4312, t4313, t4314, t4315, t4316, t4317, t4318, t4320;
  double t4321, t4322, t4323, t4324, t4325, t4326, t4327, t4328;
  double t4329, t4330, t4331, t4332, t4333, t4334, t4335, t4336;
  double t4337, t4338, t4339, t4340, t4341, t4342, t4343, t4344;
  double t4345, t4346, t4347, t4349, t4350, t4351, t4352, t4353;
  double t4354, t4355, t4356, t4357, t4358, t4359, t4360, t4361;
  double t4363, t4364, t4365, t4366, t4368, t4369, t4370, t4371;
  double t4372, t4373, t4374, t4375, t4376, t4377, t4378, t4380;
  double t4381, t4382, t4384, t4385, t4387, t4388, t4390, t4391;
  double t4392, t4393, t4394, t4395, t4396, t4397, t4398, t4399;
  double t4402, t4406, t4407, t4408, t4411, t4421, t4424, t4428;
  double t4431, t4434, t4436, t4440, t4446, t4450, t4453, t4457;
  double t4458, t4459, t4460, t4461, t4462, t4463, t4464, t4465;
  double t4466, t4467, t4468, t4469, t4470, t4471, t4472, t4473;
  double t4474, t4475, t4476, t4477, t4478, t4479, t4480, t4481;
  double t4482, t4483, t4484, t4485, t4486, t4487, t4488, t4489;
  double t4490, t4491, t4492, t4493, t4494, t4495, t4496, t4497;
  double t4498, t4518, t4520, t4523, tv3rho2tau0, t4524, t4525, t4526;
  double t4527, t4528, t4529, t4530, t4531, t4532, t4533, t4534;
  double t4535, t4536, t4538, t4539, t4540, t4541, t4542, t4543;
  double t4544, t4546, t4547, t4548, t4550, t4551, t4552, t4554;
  double t4555, t4556, t4557, t4558, t4559, t4560, t4561, t4562;
  double t4563, t4564, t4565, t4566, t4567, t4568, t4569, t4570;
  double t4571, t4572, t4573, t4574, t4575, t4576, t4577, t4578;
  double t4579, t4580, t4581, t4582, t4583, t4584, t4585, t4586;
  double t4587, t4588, t4589, t4590, t4591, t4592, t4593, t4594;
  double t4595, t4596, t4597, t4598, t4599, t4600, t4601, t4602;
  double t4603, t4604, t4606, t4607, t4609, t4610, t4612, t4613;
  double t4614, t4615, t4616, t4617, t4618, t4619, t4620, t4622;
  double t4625, t4626, t4627, t4628, t4629, t4630, t4634, t4648;
  double t4649, t4652, t4653, t4657, t4661, t4662, t4663, t4665;
  double t4666, t4667, t4668, t4669, t4670, t4671, t4672, t4673;
  double t4674, t4675, t4676, t4677, t4678, t4679, t4680, t4681;
  double t4682, t4683, t4684, t4685, t4686, t4687, t4688, t4689;
  double t4690, t4691, t4692, t4693, t4694, t4695, t4696, t4697;
  double t4698, t4699, t4700, t4701, t4702, t4703, t4704, t4705;
  double t4706, t4707, t4708, t4709, t4710, t4712, t4713, t4714;
  double t4716, t4717, t4718, t4719, t4720, t4721, t4722, t4723;
  double t4724, t4725, t4726, t4727, t4728, t4730, t4731, t4732;
  double t4733, t4734, t4735, t4736, t4737, t4738, t4739, t4740;
  double t4741, t4742, t4743, t4744, t4745, t4746, t4747, t4748;
  double t4749, t4750, t4751, t4752, t4753, t4754, t4755, t4756;
  double t4757, t4758, t4759, t4760, t4761, t4762, t4763, t4764;
  double t4765, t4766, t4783, t4785, tv3rho2tau1, t4787, t4788, t4789;
  double t4792, t4793, t4794, t4795, t4796, t4798, t4799, t4800;
  double t4801, t4803, t4804, t4806, t4807, t4809, t4810, t4811;
  double t4813, t4814, t4816, t4817, t4819, t4820, t4821, t4823;
  double t4824, t4825, t4826, t4828, t4829, t4831, t4832, t4834;
  double t4835, t4836, t4837, t4839, t4840, t4841, t4842, t4844;
  double t4846, t4847, t4849, t4850, t4851, t4853, t4854, t4855;
  double t4858, t4859, t4861, t4862, t4863, t4864, t4866, t4870;
  double t4871, t4872, t4873, t4874, t4876, t4878, t4880, t4881;
  double t4882, t4883, t4885, t4887, t4889, t4890, t4891, t4892;
  double t4894, t4895, t4896, t4898, t4899, t4903, t4905, t4907;
  double t4909, t4910, t4911, t4912, t4913, t4915, t4917, t4918;
  double t4919, t4920, t4922, t4923, t4924, t4925, t4927, t4929;
  double t4930, t4931, t4932, t4934, t4935, t4936, t4937, t4941;
  double t4942, t4943, t4945, t4946, t4947, t4949, t4950, t4951;
  double t4953, t4954, t4955, t4957, t4960, t4961, t4962, t4964;
  double t4965, t4967, t4968, t4969, t4970, t4972, t4973, t4974;
  double t4976, t4977, t4978, t4980, t4983, t4984, t4986, t4987;
  double t4988, t4991, t4992, t4995, t4996, t4998, t4999, t5001;
  double t5002, t5004, t5005, t5007, t5008, t5009, t5010, t5012;
  double t5013, t5014, t5015, t5017, t5018, t5020, t5021, t5022;
  double t5024, t5025, t5026, t5027, t5029, t5030, t5031, t5033;
  double t5034, t5036, t5037, t5039, t5040, t5042, t5043, t5045;
  double t5046, t5048, t5051, t5052, t5054, t5057, t5058, t5060;
  double t5062, t5063, t5066, t5067, t5069, t5071, t5073, t5074;
  double t5075, t5077, t5078, t5079, t5081, t5086, t5089, t5090;
  double t5091, t5094, t5096, t5101, t5102, t5108, t5111, t5113;
  double t5115, t5121, t5124, t5128, t5131, t5135, t5136, t5139;
  double t5142, t5143, t5145, t5146, t5149, t5152, t5154, t5155;
  double t5156, t5159, t5162, t5165, t5171, t5172, t5173, t5174;
  double t5175, t5177, t5178, t5179, t5181, t5182, t5183, t5184;
  double t5185, t5187, t5192, tv3rho2tau2, t5193, t5194, t5196, t5198;
  double t5200, t5201, t5202, t5204, t5206, t5207, t5208, t5210;
  double t5211, t5212, t5214, t5215, t5216, t5217, t5219, t5220;
  double t5222, t5223, t5225, t5226, t5228, t5229, t5231, t5236;
  double t5238, t5240, t5241, t5243, t5244, t5245, t5247, t5248;
  double t5249, t5250, t5252, t5254, t5255, t5256, t5258, t5259;
  double t5260, t5261, t5263, t5265, t5267, t5268, t5269, t5270;
  double t5272, t5273, t5274, t5276, t5278, t5280, t5281, t5283;
  double t5284, t5285, t5286, t5288, t5289, t5290, t5291, t5294;
  double t5297, t5300, t5303, t5306, t5309, t5311, t5312, t5313;
  double t5314, t5316, t5318, t5320, t5322, t5325, t5328, t5330;
  double t5331, t5333, t5334, t5335, t5337, t5338, t5339, t5340;
  double t5342, t5344, t5345, t5346, t5347, t5349, t5350, t5351;
  double t5353, t5356, t5357, t5358, t5359, t5361, t5363, t5365;
  double t5366, t5367, t5369, t5370, t5371, t5372, t5374, t5376;
  double t5377, t5378, t5379, t5381, t5382, t5383, t5385, t5386;
  double t5387, t5388, t5390, t5392, t5394, t5395, t5396, t5397;
  double t5399, t5401, t5403, t5405, t5406, t5408, t5410, t5412;
  double t5413, t5415, t5416, t5417, t5419, t5421, t5422, t5424;
  double t5425, t5426, t5428, t5431, t5432, t5435, t5436, t5438;
  double t5439, t5442, t5443, t5445, t5448, t5449, t5451, t5452;
  double t5453, t5455, t5456, t5457, t5460, t5463, t5465, t5467;
  double t5470, t5473, t5475, t5476, t5477, t5478, t5484, t5487;
  double t5490, t5494, t5502, t5510, t5512, t5518, t5519, t5522;
  double t5523, t5532, t5539, t5540, t5541, t5542, t5544, t5546;
  double t5547, t5549, t5550, t5551, t5552, t5554, t5555, t5557;
  double t5558, t5559, t5561, t5562, t5563, t5568, t5569, tv3rho2tau3;
  double t5570, t5571, t5572, t5573, t5574, t5575, t5576, t5577;
  double t5578, t5579, t5580, t5581, t5582, t5583, t5584, t5585;
  double t5586, t5587, t5588, t5589, t5592, t5593, t5596, t5597;
  double t5600, t5604, t5607, t5608, t5611, t5612, t5615, t5619;
  double t5623, t5627, t5628, t5629, t5631, t5632, t5633, t5634;
  double t5635, t5636, t5637, t5638, t5639, t5640, t5641, t5642;
  double t5644, t5645, t5646, t5648, t5649, t5650, t5652, t5653;
  double t5654, t5655, t5656, t5657, t5658, t5659, t5660, t5661;
  double t5662, t5663, t5664, t5665, t5666, t5667, t5668, t5669;
  double t5670, t5671, t5672, t5673, t5674, t5675, t5677, t5678;
  double t5679, t5682, t5683, t5685, t5686, t5687, t5688, t5689;
  double t5690, t5691, t5692, t5693, t5694, t5695, t5696, t5697;
  double t5698, t5699, t5700, t5701, t5702, t5703, t5704, t5705;
  double t5706, t5707, t5708, t5709, t5710, t5711, t5713, t5714;
  double t5715, t5717, t5718, t5719, t5721, t5722, t5723, t5724;
  double t5725, t5726, t5727, t5728, t5729, t5730, t5731, t5732;
  double t5733, t5734, t5735, t5736, t5737, t5738, t5739, t5740;
  double t5741, t5742, t5743, t5744, t5745, t5746, t5747, t5748;
  double t5749, t5750, t5751, t5752, t5753, t5754, t5755, t5756;
  double t5757, t5758, t5759, t5760, t5761, t5762, t5763, t5764;
  double t5765, t5766, t5767, t5768, t5769, t5770, t5771, t5772;
  double t5773, t5774, t5775, t5776, t5777, t5778, t5779, t5780;
  double t5781, t5782, t5783, t5784, tv3rho2tau4, t5803, t5804, t5805;
  double t5808, t5809, t5814, t5817, t5818, t5821, t5822, t5826;
  double t5827, t5830, t5831, t5834, t5835, t5842, t5843, t5846;
  double t5847, t5850, t5851, t5852, t5854, t5858, t5862, t5863;
  double t5864, t5865, t5866, t5867, t5868, t5869, t5870, t5871;
  double t5872, t5873, t5874, t5875, t5876, t5877, t5878, t5879;
  double t5880, t5881, t5883, t5884, t5885, t5887, t5888, t5889;
  double t5890, t5891, t5893, t5894, t5895, t5897, t5898, t5899;
  double t5900, t5901, t5902, t5903, t5905, t5906, t5907, t5908;
  double t5909, t5910, t5911, t5912, t5913, t5914, t5915, t5916;
  double t5917, t5918, t5919, t5921, t5922, t5923, t5924, t5925;
  double t5926, t5927, t5928, t5929, t5930, t5931, t5932, t5933;
  double t5934, t5935, t5936, t5937, t5938, t5939, t5940, t5941;
  double t5942, t5943, t5944, t5945, t5946, t5948, t5949, t5951;
  double t5952, t5954, t5955, t5956, t5957, t5958, t5959, t5960;
  double t5962, t5963, t5964, t5965, t5967, t5968, t5970, t5971;
  double t5973, t5974, t5975, t5976, t5977, t5978, t5979, t5980;
  double t5981, t5982, t5983, t5984, t5985, t5986, t5987, t5988;
  double t5989, t5990, t5991, t5992, t5993, t5994, t5995, t5996;
  double t5997, t5998, t5999, t6000, t6001, t6002, t6003, t6004;
  double t6005, t6006, t6007, t6008, t6009, t6010, t6011, t6012;
  double t6013, t6014, t6015, t6016, t6017, t6018, t6020, t6021;
  double t6023, t6024, t6025, t6027, t6028, t6030, t6031, t6032;
  double t6033, t6034, t6035, t6036, t6037, t6038, t6039, t6040;
  double t6041, t6042, t6043, t6044, t6045, t6046, t6047, t6048;
  double t6049, t6050, t6051, t6052, t6053, t6054, t6055, t6056;
  double t6057, t6058, t6059, t6060, t6061, t6062, t6063, t6064;
  double t6065, t6088, tv3rho2tau5, t6090, t6091, t6092, t6093, t6094;
  double t6095, t6096, t6097, t6098, t6099, t6100, t6101, t6102;
  double t6104, t6105, t6106, t6107, t6108, t6109, t6110, t6111;
  double t6112, t6113, t6114, t6115, t6116, t6117, t6118, t6119;
  double t6120, t6121, t6122, t6123, t6124, t6125, t6126, t6128;
  double t6129, t6130, t6132, t6133, t6135, t6136, t6137, t6139;
  double t6140, t6141, t6142, t6143, t6144, t6145, t6146, t6148;
  double t6149, t6150, t6151, t6152, t6154, t6155, t6156, t6157;
  double t6158, t6159, t6160, t6161, t6162, t6163, t6165, t6166;
  double t6167, t6168, t6172, t6175, t6176, t6177, t6178, t6179;
  double t6180, tv3rhosigma20, t6182, t6183, t6184, t6185, t6186, t6187;
  double t6188, t6189, t6190, t6191, t6192, t6193, t6194, t6195;
  double t6196, t6197, t6198, t6199, t6200, t6203, t6204, t6205;
  double t6206, t6207, tv3rhosigma21, tv3rhosigma22, t6209, t6210, t6211, t6212;
  double t6213, t6214, t6215, t6216, t6217, t6218, t6219, t6220;
  double t6221, t6222, t6223, t6224, t6225, t6226, t6227, t6230;
  double t6231, t6232, t6233, t6234, tv3rhosigma23, tv3rhosigma24, tv3rhosigma25, t6236;
  double t6237, t6238, t6239, t6240, t6241, t6242, t6243, t6244;
  double t6245, t6246, t6247, t6248, t6249, t6250, t6251, t6253;
  double t6254, t6255, t6257, t6258, t6260, t6261, t6262, t6263;
  double t6264, t6265, t6266, t6268, t6269, t6270, t6271, t6272;
  double t6273, t6274, t6275, t6277, t6279, t6281, t6282, t6283;
  double t6284, tv3rhosigma26, t6286, t6287, t6288, t6289, t6290, t6291;
  double t6292, t6293, t6294, t6295, t6296, t6297, t6300, t6301;
  double t6302, t6303, tv3rhosigma27, tv3rhosigma28, t6305, t6306, t6307, t6308;
  double t6309, t6310, t6311, t6312, t6313, t6314, t6315, t6316;
  double t6319, t6320, t6321, t6322, tv3rhosigma29, tv3rhosigma210, tv3rhosigma211, tv3rhosigmalapl0;
  double tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8;
  double tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, t6324, t6325, t6326, t6327, t6328;
  double t6329, t6330, t6331, t6332, t6333, t6334, t6335, t6336;
  double t6337, t6338, t6339, t6340, t6341, t6342, t6343, t6344;
  double t6345, t6346, t6347, t6348, t6349, t6350, t6351, t6352;
  double t6353, t6354, t6355, t6356, t6357, t6358, t6359, t6360;
  double t6361, t6362, t6363, t6364, t6365, t6366, t6367, t6368;
  double t6369, t6370, t6371, t6372, t6373, t6374, t6375, t6376;
  double t6377, t6378, t6379, t6380, t6381, t6382, t6383, t6384;
  double t6385, t6386, t6387, t6388, t6389, t6390, t6391, t6392;
  double t6393, t6394, t6395, t6396, t6397, t6398, t6399, t6400;
  double t6401, t6402, t6403, t6404, t6405, t6406, t6407, t6408;
  double t6409, t6410, t6411, t6412, t6413, t6414, t6415, t6416;
  double t6417, t6418, t6419, t6420, t6422, t6423, t6424, t6425;
  double t6426, t6427, t6428, t6429, t6430, t6431, t6432, t6433;
  double t6434, t6435, t6436, t6437, t6438, t6439, t6440, t6441;
  double t6442, t6443, t6444, t6445, t6446, t6447, t6448, t6449;
  double t6450, t6451, t6452, t6453, t6454, t6455, t6456, t6457;
  double t6458, t6459, t6460, t6461, t6462, t6463, t6464, t6465;
  double t6466, t6467, t6468, t6469, t6470, t6471, t6472, t6474;
  double t6475, t6477, t6480, t6481, t6482, t6484, t6485, t6488;
  double t6490, t6491, t6493, t6495, t6496, t6497, t6498, t6499;
  double t6500, t6501, t6502, t6503, t6504, t6505, t6506, t6507;
  double t6508, t6509, t6510, t6511, t6512, t6513, t6514, t6515;
  double t6516, t6517, t6518, t6519, t6520, t6521, t6522, t6523;
  double t6524, t6525, t6526, t6527, t6528, t6529, t6530, t6531;
  double t6532, t6533, t6534, t6535, tv3rhosigmatau0, t6539, t6540, t6541;
  double t6542, t6543, t6544, t6545, t6546, t6547, t6548, t6549;
  double t6550, t6551, t6552, t6553, t6554, t6555, t6556, t6557;
  double t6558, t6559, t6560, t6561, t6562, t6563, t6564, t6566;
  double t6567, t6568, t6569, t6571, t6572, t6573, t6574, t6576;
  double t6577, t6578, t6579, t6580, t6581, t6582, t6583, t6584;
  double t6585, t6586, t6587, t6588, t6589, t6590, t6591, t6592;
  double t6593, t6594, t6595, t6596, t6597, t6598, t6599, t6600;
  double t6601, t6602, t6603, t6604, t6605, t6607, t6608, t6610;
  double t6612, t6613, t6615, t6616, t6619, t6621, t6623, t6624;
  double t6625, t6626, t6627, t6628, t6629, t6630, t6631, t6632;
  double t6633, t6634, t6635, t6636, t6637, t6638, t6640, t6641;
  double t6643, t6644, t6645, t6646, t6647, t6648, t6649, t6650;
  double t6651, t6653, t6654, t6655, t6656, t6657, t6658, t6659;
  double t6660, t6661, t6662, t6663, t6664, t6665, t6666, t6667;
  double t6668, t6669, t6670, t6671, t6672, t6673, t6674, t6675;
  double t6676, t6677, t6678, t6679, t6680, t6681, t6682, t6683;
  double t6684, t6685, t6686, t6687, t6688, t6689, tv3rhosigmatau1, t6693;
  double t6694, t6695, t6696, t6697, t6698, t6699, t6700, t6701;
  double t6702, t6703, t6704, t6705, t6706, t6710, t6714, t6715;
  double t6716, t6717, t6718, t6719, t6720, t6721, t6722, t6723;
  double t6724, t6725, t6726, t6727, t6728, t6730, t6731, t6732;
  double t6733, t6734, t6735, t6736, t6737, t6738, t6739, t6740;
  double t6741, t6742, t6743, t6744, t6745, t6746, t6747, t6748;
  double t6749, t6750, t6751, t6752, t6753, t6754, t6755, t6756;
  double tv3rhosigmatau2, t6760, t6761, t6762, t6763, t6764, t6765, t6766;
  double t6767, t6768, t6769, t6771, t6772, t6773, t6774, t6775;
  double t6776, t6777, t6778, t6779, t6780, t6781, t6782, t6784;
  double t6787, t6790, t6791, t6792, t6793, t6794, t6795, t6796;
  double t6797, t6798, t6799, t6800, t6801, t6802, t6803, t6804;
  double t6805, t6806, t6807, t6808, t6809, t6810, t6811, t6812;
  double t6813, t6814, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, t6818, t6819, t6820;
  double t6821, t6822, t6823, t6824, t6825, t6826, t6827, t6828;
  double t6829, t6830, t6831, t6832, t6833, t6834, t6835, t6836;
  double t6837, t6838, t6839, t6840, t6841, t6842, t6843, t6844;
  double t6845, t6846, t6848, t6849, t6850, t6851, t6852, t6853;
  double t6854, t6855, t6856, t6857, t6858, t6860, t6862, t6863;
  double t6864, t6866, t6867, t6868, t6870, t6871, t6872, t6873;
  double t6874, t6875, t6876, t6877, t6878, t6879, t6880, t6881;
  double t6882, t6883, t6884, t6885, t6886, t6887, t6889, t6890;
  double t6891, t6892, t6893, t6894, t6895, t6896, t6897, t6898;
  double t6900, t6901, t6902, t6903, t6904, t6905, t6906, t6907;
  double t6908, t6909, t6910, t6911, t6912, t6913, t6914, t6915;
  double t6916, t6917, t6918, t6919, t6920, t6921, t6922, t6923;
  double t6924, t6925, t6926, t6927, t6928, t6929, t6930, t6931;
  double t6932, tv3rhosigmatau6, t6936, t6937, t6938, t6939, t6940, t6941;
  double t6942, t6943, t6944, t6945, t6946, t6947, t6948, t6949;
  double t6950, t6951, t6952, t6953, t6955, t6956, t6957, t6958;
  double t6959, t6960, t6961, t6962, t6963, t6964, t6965, t6966;
  double t6967, t6968, t6969, t6970, t6971, t6972, t6973, t6974;
  double t6975, t6976, t6977, t6978, t6979, t6980, t6981, t6982;
  double t6983, t6984, t6985, t6986, t6987, t6988, t6989, t6990;
  double t6991, t6992, t6993, t6994, t6995, t6996, t6997, t6998;
  double t6999, t7000, t7001, t7002, t7003, t7004, t7005, t7006;
  double t7007, t7008, t7009, t7010, t7011, t7013, t7014, t7015;
  double t7016, t7017, t7018, t7019, t7020, t7021, t7022, t7023;
  double t7024, t7025, t7026, t7027, t7028, t7029, t7030, t7031;
  double t7032, t7033, t7034, t7035, t7036, t7037, t7038, t7039;
  double t7040, t7041, t7042, t7043, t7044, t7045, t7047, t7048;
  double t7050, t7052, t7053, t7054, t7057, t7060, t7062, t7063;
  double t7064, t7065, t7066, t7067, t7068, t7069, t7070, tv3rhosigmatau7;
  double t7074, t7075, t7076, t7077, t7078, t7079, t7080, t7081;
  double t7082, t7083, t7085, t7086, t7087, t7088, t7089, t7090;
  double t7091, t7092, t7098, t7099, t7100, t7101, t7102, t7103;
  double t7104, t7105, t7106, t7107, t7108, t7109, t7110, t7111;
  double t7112, t7113, t7114, tv3rhosigmatau8, t7118, t7119, t7120, t7121;
  double t7122, t7123, t7124, t7125, t7126, t7127, t7128, t7129;
  double t7130, t7131, t7132, t7133, t7134, t7135, t7142, t7143;
  double t7144, t7145, t7146, t7147, t7148, t7149, t7150, t7151;
  double t7153, t7154, t7155, t7156, t7157, t7158, t7159, t7160;
  double t7161, t7162, t7163, t7164, t7165, t7166, t7167, tv3rhosigmatau9;
  double tv3rhosigmatau10, tv3rhosigmatau11, tv3rholapl20, tv3rholapl21, tv3rholapl22, tv3rholapl23, tv3rholapl24, tv3rholapl25;
  double tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7;
  double t7171, t7172, t7173, t7174, t7175, t7176, t7177, t7178;
  double t7179, t7180, t7181, t7183, t7184, t7185, t7186, t7187;
  double t7188, t7189, t7190, t7191, t7192, t7193, t7194, t7195;
  double t7196, t7197, t7198, t7199, t7200, t7201, t7202, t7203;
  double t7204, t7205, t7206, t7207, t7208, t7209, t7210, t7211;
  double t7212, t7213, t7214, t7215, t7216, t7217, t7218, t7219;
  double t7220, t7221, t7222, t7223, t7224, t7225, t7226, t7227;
  double t7228, t7229, t7230, t7231, t7235, t7236, t7238, t7241;
  double t7245, t7248, t7249, t7252, t7256, t7257, t7258, t7259;
  double t7260, t7261, t7262, t7263, t7264, t7265, t7266, t7267;
  double t7268, t7269, t7270, t7271, t7272, t7273, t7274, t7276;
  double t7277, t7278, t7279, t7280, t7281, t7282, t7283, t7284;
  double t7285, t7286, t7287, t7288, t7289, t7290, t7291, t7292;
  double t7293, t7294, t7295, t7296, t7297, t7298, t7299, t7300;
  double t7301, t7302, t7303, t7304, t7305, t7306, t7307, t7308;
  double t7309, t7310, t7311, t7312, t7313, t7314, t7315, t7316;
  double t7317, t7318, t7319, t7320, t7321, t7322, t7323, t7324;
  double t7325, t7326, t7327, t7328, t7329, t7330, t7331, t7332;
  double t7333, t7334, t7335, tv3rhotau20, t7338, t7339, t7340, t7341;
  double t7342, t7343, t7344, t7345, t7346, t7347, t7348, t7349;
  double t7350, t7351, t7352, t7353, t7354, t7355, t7356, t7357;
  double t7358, t7359, t7360, t7361, t7362, t7363, t7364, t7365;
  double t7366, t7367, t7368, t7370, t7371, t7372, t7373, t7374;
  double t7375, t7376, t7377, t7378, t7379, t7380, t7381, t7382;
  double t7383, t7384, t7385, t7386, t7387, t7388, t7389, t7390;
  double t7391, t7392, t7393, t7394, t7395, t7396, t7397, t7398;
  double t7399, t7400, t7401, t7402, t7403, t7404, t7406, t7407;
  double t7408, t7409, t7410, t7411, t7412, t7413, t7416, t7421;
  double t7424, t7427, t7437, t7438, t7439, t7440, t7441, t7442;
  double t7443, t7444, t7445, t7446, t7447, t7448, t7449, t7450;
  double t7451, t7452, t7453, t7454, t7455, t7456, t7457, t7458;
  double t7459, t7460, t7461, t7462, t7463, t7464, t7465, t7466;
  double t7467, t7468, t7469, t7470, t7471, t7472, t7473, t7474;
  double t7475, t7476, t7477, t7478, t7479, t7480, t7481, t7482;
  double t7483, t7484, t7485, t7486, t7487, t7488, t7489, t7490;
  double t7492, t7493, t7494, t7495, t7496, t7497, t7498, t7499;
  double t7500, t7501, t7502, t7503, t7504, t7505, tv3rhotau21, t7508;
  double t7509, t7510, t7511, t7513, t7514, t7515, t7516, t7517;
  double t7518, t7519, t7520, t7521, t7522, t7523, t7524, t7525;
  double t7526, t7527, t7528, t7529, t7530, t7531, t7532, t7533;
  double t7534, t7535, t7536, t7537, t7538, t7539, t7540, t7541;
  double t7542, t7543, t7544, t7545, t7546, t7547, t7548, t7549;
  double t7550, t7551, t7552, t7553, t7555, t7556, t7557, t7558;
  double t7559, t7560, t7561, t7562, t7564, t7565, t7566, t7568;
  double t7569, t7570, t7571, t7572, t7573, t7574, t7575, t7577;
  double t7586, t7587, t7590, t7591, t7592, t7593, t7594, t7595;
  double t7596, t7597, t7598, t7599, t7600, t7601, t7602, t7603;
  double t7604, t7605, t7606, t7607, t7608, t7609, t7610, t7611;
  double t7612, t7613, t7614, t7615, t7616, t7617, t7618, t7619;
  double t7620, t7621, t7622, t7623, t7624, t7625, t7626, t7627;
  double t7628, t7629, tv3rhotau22, t7632, t7633, t7634, t7635, t7636;
  double t7637, t7638, t7639, t7640, t7641, t7642, t7643, t7644;
  double t7645, t7646, t7647, t7648, t7649, t7650, t7651, t7652;
  double t7653, t7654, t7655, t7656, t7657, t7658, t7659, t7660;
  double t7661, t7662, t7663, t7664, t7665, t7666, t7667, t7668;
  double t7669, t7670, t7672, t7675, t7678, t7679, t7682, t7686;
  double t7687, t7688, t7689, t7690, t7691, t7692, t7693, t7694;
  double t7695, t7696, t7697, t7698, t7699, t7700, t7701, t7702;
  double t7703, t7704, t7705, t7706, t7707, t7708, t7709, t7710;
  double t7711, t7712, t7713, t7714, t7715, t7716, t7717, t7718;
  double t7719, t7720, t7721, t7722, t7723, t7724, t7725, tv3rhotau23;
  double t7728, t7729, t7730, t7731, t7732, t7733, t7734, t7735;
  double t7736, t7737, t7738, t7739, t7740, t7741, t7742, t7743;
  double t7744, t7745, t7746, t7747, t7748, t7749, t7750, t7753;
  double t7754, t7757, t7760, t7763, t7775, t7776, t7777, t7778;
  double t7779, t7780, t7781, t7782, t7783, t7784, t7785, t7786;
  double t7787, t7788, t7789, t7790, t7791, t7792, t7793, t7794;
  double t7795, t7796, t7797, t7798, t7799, t7800, t7801, t7802;
  double t7803, t7804, t7805, t7806, t7807, t7808, t7809, t7810;
  double t7811, t7812, t7813, t7814, t7815, t7816, t7817, t7818;
  double t7819, t7820, t7821, t7822, t7823, t7824, t7825, t7826;
  double t7827, t7828, t7829, t7830, t7831, t7832, t7833, t7834;
  double t7835, t7836, t7837, t7838, t7839, t7840, t7841, t7842;
  double t7843, t7844, t7845, t7846, t7847, t7848, t7849, t7850;
  double t7851, t7852, t7853, t7854, t7855, t7856, tv3rhotau24, t7859;
  double t7861, t7862, t7863, t7865, t7866, t7868, t7869, t7870;
  double t7871, t7872, t7873, t7875, t7876, t7877, t7878, t7879;
  double t7880, t7881, t7882, t7883, t7884, t7885, t7886, t7887;
  double t7888, t7889, t7890, t7891, t7892, t7893, t7894, t7895;
  double t7896, t7897, t7898, t7899, t7900, t7901, t7902, t7903;
  double t7904, t7905, t7906, t7907, t7908, t7909, t7914, t7919;
  double t7926, t7927, t7930, t7931, t7932, t7933, t7934, t7935;
  double t7936, t7937, t7938, t7939, t7940, t7941, t7942, t7943;
  double t7944, t7945, t7946, t7947, t7948, t7949, t7950, t7951;
  double t7952, t7953, t7954, t7955, t7956, t7957, t7958, t7959;
  double t7960, t7961, t7962, t7963, t7964, t7965, t7966, t7967;
  double t7968, t7969, t7971, t7972, t7974, t7975, t7976, tv3rhotau25;
  double t7979, t7980, t7981, t7982, t7983, t7984, t7985, t7986;
  double t7987, t7988, t7989, t7990, t7992, t7993, t7994, t7995;
  double t7996, t7997, t7998, t7999, t8002, t8003, t8005, t8006;
  double tv3sigma30, t8008, t8009, t8010, t8011, t8014, t8015, tv3sigma31;
  double tv3sigma32, t8017, t8018, t8019, t8020, t8023, t8024, tv3sigma33;
  double tv3sigma34, tv3sigma35, t8026, t8027, t8028, t8029, t8032, t8033;
  double tv3sigma36, tv3sigma37, tv3sigma38, tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3;
  double tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11;
  double t8035, t8036, t8037, t8038, t8039, t8040, t8042, t8043;
  double t8044, t8045, t8046, t8047, t8048, t8049, t8050, t8051;
  double t8052, t8053, t8054, t8055, t8056, t8057, t8058, t8060;
  double t8061, t8062, t8063, t8064, t8065, t8066, t8067, t8068;
  double t8070, t8071, t8072, t8074, t8075, tv3sigma2tau0, t8077, t8078;
  double t8079, t8080, t8081, t8082, t8083, t8084, t8085, t8086;
  double t8087, t8088, t8089, t8090, t8091, t8092, t8093, t8094;
  double t8095, t8096, t8097, t8098, t8099, t8101, t8103, t8105;
  double t8106, tv3sigma2tau1, t8108, t8109, t8110, t8111, t8112, t8113;
  double t8114, t8115, t8118, t8119, tv3sigma2tau2, t8121, t8122, t8123;
  double t8124, t8125, t8126, t8127, t8128, t8131, t8132, tv3sigma2tau3;
  double tv3sigma2tau4, tv3sigma2tau5, t8134, t8135, t8136, t8137, t8138, t8139;
  double t8140, t8141, t8144, t8145, tv3sigma2tau6, t8147, t8148, t8149;
  double t8150, t8151, t8152, t8153, t8154, t8157, t8158, tv3sigma2tau7;
  double tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23;
  double tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2;
  double tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10;
  double tv3sigmalapltau11, t8160, t8161, t8162, t8163, t8164, t8165, t8166;
  double t8167, t8168, t8169, t8170, t8171, t8172, t8173, t8174;
  double t8175, t8176, t8177, t8179, t8180, t8181, t8182, t8183;
  double t8184, t8185, t8186, t8187, t8188, t8189, t8190, t8191;
  double t8192, t8193, t8194, t8195, t8196, t8197, t8198, t8199;
  double t8200, t8201, t8202, t8203, t8204, t8206, t8207, t8208;
  double t8210, t8211, t8212, tv3sigmatau20, t8213, t8214, t8215, t8216;
  double t8217, t8218, t8219, t8220, t8221, t8222, t8223, t8224;
  double t8225, t8226, t8227, t8228, t8229, t8230, t8231, t8232;
  double t8234, t8235, t8236, t8237, t8238, t8239, t8240, t8241;
  double t8242, t8243, t8245, t8246, t8247, t8248, t8249, t8250;
  double t8251, t8252, t8253, t8254, t8256, t8257, t8259, t8260;
  double t8261, tv3sigmatau21, t8262, t8263, t8264, t8265, t8266, t8267;
  double t8268, t8269, t8270, t8271, t8272, t8273, t8274, t8275;
  double t8276, t8277, t8278, t8279, t8280, t8281, t8282, t8283;
  double t8284, t8285, t8286, t8287, t8288, t8289, t8290, t8291;
  double t8292, t8293, t8294, t8295, t8296, t8298, t8300, t8302;
  double t8303, t8304, tv3sigmatau22, t8305, t8306, t8307, t8308, t8309;
  double t8310, t8311, t8312, t8313, t8314, t8315, t8318, t8319;
  double t8320, tv3sigmatau23, t8321, t8322, t8323, t8324, t8325, t8326;
  double t8327, t8328, t8329, t8330, t8331, t8334, t8335, t8336;
  double tv3sigmatau24, t8337, t8338, t8339, t8340, t8341, t8342, t8343;
  double t8344, t8345, t8346, t8347, t8350, t8351, t8352, tv3sigmatau25;
  double tv3sigmatau26, tv3sigmatau27, tv3sigmatau28, tv3lapl30, tv3lapl31, tv3lapl32, tv3lapl33, tv3lapl2tau0;
  double tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22;
  double tv3lapltau23, tv3lapltau24, tv3lapltau25, t8353, t8354, t8355, t8356, t8357;
  double t8358, t8359, t8361, t8362, t8363, t8364, t8365, t8367;
  double t8368, t8369, t8370, t8372, t8373, t8375, t8377, t8378;
  double t8379, t8380, t8381, t8383, t8384, t8385, t8386, t8388;
  double t8389, t8390, t8391, t8393, t8399, t8400, tv3tau30, t8403;
  double t8404, t8406, t8408, t8410, t8411, t8413, t8414, t8415;
  double t8416, t8418, t8419, t8420, t8422, t8423, t8424, t8426;
  double t8429, t8430, t8431, t8434, t8435, tv3tau31, t8437, t8438;
  double t8439, t8441, t8442, t8444, t8445, t8446, t8448, t8450;
  double t8451, t8453, t8454, t8455, t8457, t8458, t8459, t8461;
  double t8462, t8463, t8464, t8466, t8467, t8471, t8472, t8473;
  double t8474, t8477, t8478, tv3tau32, t8480, t8481, t8482, t8483;
  double t8484, t8485, t8486, t8488, t8489, t8490, t8492, t8493;
  double t8495, t8496, t8498, t8500, t8501, t8502, t8503, t8504;
  double t8506, t8507, t8508, t8509, t8511, t8512, t8513, t8514;
  double t8516, t8519, t8522, t8523, tv3tau33;

  double t8527, t8529, t8531, t8533, t8536, t8540, t8544, t8549;
  double t8551, t8554, t8555, t8559, t8563, t8567, t8571, t8572;
  double t8575, t8579, t8580, t8582, t8585, t8589, t8590, t8594;
  double t8598, t8599, t8603, t8604, t8606, t8607, t8611, t8612;
  double t8616, t8620, t8621, t8623, t8624, t8626, t8631, t8635;
  double t8639, t8646, t8648, t8650, t8651, t8653, t8654, t8656;
  double t8657, t8659, t8662, t8664, t8666, t8668, t8671, t8673;
  double t8677, t8678, t8680, t8683, t8684, t8687, t8688, t8689;
  double t8693, t8694, t8695, t8697, t8698, t8701, t8702, t8704;
  double t8707, t8708, t8709, t8712, t8713, t8714, t8718, t8719;
  double t8721, t8724, t8726, t8727, t8728, t8730, t8732, t8734;
  double t8737, t8744, t8758, t8759, t8761, t8762, t8764, t8765;
  double t8768, t8770, t8772, t8773, t8775, t8778, t8782, t8786;
  double t8789, t8793, t8795, t8797, t8799, t8800, t8806, t8811;
  double t8812, t8813, t8817, t8818, t8820, t8821, t8827, t8836;
  double t8838, t8843, t8846, t8849, t8852, t8853, t8855, t8859;
  double t8862, t8863, t8867, t8870, t8872, t8874, t8876, t8880;
  double t8881, t8884, t8887, t8888, t8889, t8890, t8891, t8894;
  double t8897, t8900, t8955, t8981, t8988, t9001, t9033, t9072;
  double t9075, t9082, t9083, t9086, t9090, t9091, t9095, t9096;
  double t9098, t9103, t9105, t9107, t9108, t9109, t9112, t9122;
  double t9124, t9125, t9128, t9130, t9132, t9134, t9136, t9139;
  double t9140, t9141, t9145, t9147, t9153, t9156, t9158, t9163;
  double t9166, t9167, t9168, t9171, t9175, t9176, t9179, t9182;
  double t9184, t9186, t9188, t9189, t9190, t9193, t9197, t9198;
  double t9201, t9204, t9209, t9211, t9213, t9215, t9216, t9219;
  double t9223, t9224, t9228, t9230, t9232, t9234, t9238, t9240;
  double t9241, t9243, t9244, t9245, t9261, t9262, t9263, t9274;
  double t9279, t9280, t9281, t9294, t9295, t9298, t9301, t9308;
  double t9314, t9329, t9330, t9332, t9344, t9349, t9350, t9355;
  double t9356, t9358, t9359, t9360, t9366, t9369, t9374, t9397;
  double t9400, t9405, t9441, t9442, t9445, t9446, t9449, t9450;
  double t9453, t9458, t9475, t9491, tv4rho40, t9508, t9551, t9560;
  double t9576, t9578, t9580, t9583, t9585, t9587, t9589, t9593;
  double t9597, t9600, t9604, t9608, t9611, t9614, t9615, t9633;
  double t9649, t9652, t9659, t9660, t9668, t9686, t9690, t9695;
  double t9696, t9698, t9702, t9704, t9705, t9706, t9709, t9711;
  double t9712, t9713, t9714, t9716, t9717, t9718, t9720, t9721;
  double t9722, t9748, t9750, t9775, t9777, t9779, t9786, t9788;
  double t9789, t9791, t9792, t9793, t9794, t9795, t9796, t9798;
  double t9799, t9800, t9802, t9804, t9806, t9808, t9809, t9810;
  double t9812, t9814, t9817, t9818, t9820, t9821, t9825, t9827;
  double t9828, t9829, t9831, t9833, t9835, t9837, t9841, t9843;
  double t9846, t9847, t9850, t9851, t9856, t9857, t9858, t9859;
  double t9860, t9865, t9873, t9874, t9876, t9877, t9878, t9879;
  double t9883, t9884, t9887, t9900, t9901, t9902, t9903, t9913;
  double t9915, t9918, t9920, t9922, t9923, t9924, t9925, t9926;
  double t9933, t9935, t9940, t9945, t9947, t9950, t9952, t9953;
  double t9956, t9957, t9969, t9970, t9971, t9972, t9976, t9977;
  double t9979, t9982, t9983, t9984, t10009, t10019, t10020, t10026;
  double t10027, t10030, t10031, t10034, t10035, t10050, t10060, t10093;
  double t10099, t10102, t10133, t10144, t10162, t10168, t10171, t10174;
  double t10176, t10199, t10200, t10206, t10210, t10213, t10215, t10221;
  double t10223, t10227, t10256, t10268, t10271, t10292, tv4rho41, t10296;
  double t10333, t10334, t10337, t10338, t10342, t10343, t10346, t10347;
  double t10348, t10365, t10373, t10375, t10394, t10395, t10398, t10404;
  double t10412, t10421, t10424, t10431, t10438, t10440, t10442, t10445;
  double t10448, t10451, t10457, t10460, t10476, t10484, t10513, t10539;
  double t10541, t10544, t10546, t10548, t10551, t10559, t10566, t10569;
  double t10572, t10575, t10585, t10614, t10630, t10668, t10671, t10673;
  double t10675, t10677, t10679, t10681, t10683, t10686, t10689, t10691;
  double t10692, t10694, t10698, t10700, t10701, t10756, t10757, t10758;
  double t10764, t10790, t10792, t10795, t10797, t10799, t10814, t10819;
  double t10821, t10823, t10828, t10838, t10840, t10843, t10845, t10849;
  double t10856, t10863, t10868, t10877, t10880, t10884, t10905, t10948;
  double t10999, t11000, t11020, t11025, t11030, t11033, t11040, t11059;
  double t11086, t11090, t11109, t11123, t11137, t11151, t11165, t11180;
  double t11194, t11209, t11223, tv4rho42, t11241, t11248, t11270, t11274;
  double t11295, t11297, t11304, t11307, t11314, t11324, t11328, t11333;
  double t11340, t11341, t11343, t11348, t11353, t11356, t11361, t11362;
  double t11365, t11368, t11370, t11374, t11375, t11378, t11381, t11383;
  double t11385, t11387, t11389, t11393, t11394, t11397, t11401, t11405;
  double t11408, t11412, t11414, t11416, t11419, t11422, t11424, t11426;
  double t11430, t11432, t11433, t11434, t11435, t11439, t11448, t11453;
  double t11456, t11457, t11484, t11508, t11513, t11519, t11524, t11554;
  double t11571, t11589, t11629, t11667, t11671, t11707, t11710, t11725;
  double t11728, t11731, t11733, t11735, t11736, t11741, t11743, t11754;
  double t11770, t11803, t11833, t11843, t11856, t11871, t11892, tv4rho43;
  double t11908, t11918, t11923, t11928, t11929, t11933, t11934, t11939;
  double t11948, t11950, t11958, t11964, t11972, t11980, t11987, t11993;
  double t11997, t12003, t12006, t12026, t12029, t12034, t12036, t12038;
  double t12040, t12044, t12045, t12048, t12051, t12052, t12055, t12058;
  double t12060, t12062, t12064, t12065, t12068, t12071, t12072, t12075;
  double t12078, t12079, t12080, t12090, t12096, t12103, t12116, t12117;
  double t12121, t12131, t12140, t12204, t12229, t12236, t12242, t12250;
  double t12259, t12279, t12290, tv4rho44, t12296, t12297, t12301, t12305;
  double t12307, t12309, t12310, t12314, t12316, t12318, t12320, t12323;
  double t12325, t12330, t12332, t12334, t12337, t12339, t12341, t12343;
  double t12345, t12347, t12349, t12350, t12352, t12354, t12358, t12360;
  double t12363, t12365, t12367, t12369, t12370, t12374, t12377, t12379;
  double t12381, t12384, t12387, t12389, t12392, t12394, t12396, t12398;
  double t12400, t12402, t12404, t12406, t12408, t12410, t12413, t12415;
  double t12418, t12422, t12426, t12427, t12430, t12431, t12433, t12434;
  double t12436, t12438, t12440, t12443, t12446, t12448, t12450, t12452;
  double t12454, t12457, t12458, t12461, t12463, t12466, t12468, t12471;
  double t12473, t12476, t12479, t12481, t12484, t12486, t12490, t12493;
  double t12495, t12496, t12498, t12502, t12506, t12508, t12510, t12511;
  double t12512, t12514, t12515, t12517, t12519, t12520, t12521, t12522;
  double t12524, t12525, t12529, t12533, t12537, t12539, t12541, t12545;
  double t12547, t12549, t12551, t12554, t12556, t12557, t12558, t12559;
  double t12561, t12562, t12566, t12568, t12571, t12573, t12577, t12581;
  double t12583, t12585, t12586, t12589, t12591, t12594, t12597, t12601;
  double t12604, t12607, t12609, t12611, t12613, t12616, t12617, t12618;
  double t12622, t12623, t12625, t12627, t12630, t12634, t12637, t12640;
  double t12642, t12646, t12651, t12653, t12655, t12657, t12659, t12660;
  double t12661, t12664, t12667, t12669, t12672, t12676, t12679, t12681;
  double t12682, t12684, t12686, t12690, t12694, t12698, t12701, t12705;
  double t12707, t12711, t12713, t12715, t12717, t12720, t12724, t12726;
  double t12729, t12732, t12734, t12743, t12746, t12751, t12759, t12763;
  double t12764, t12767, t12773, t12787, tv4rho3sigma0, t12799, t12801, t12807;
  double t12810, t12819, t12833, t12849, t12862, t12863, t12864, t12866;
  double t12883, t12901, t12916, t12918, t12919, t12936, t12953, t12961;
  double t12968, t12972, t12973, t12976, t12982, t12996, tv4rho3sigma1, tv4rho3sigma2;
  double t12998, t13001, t13004, t13007, t13009, t13012, t13014, t13016;
  double t13017, t13019, t13024, t13025, t13026, t13028, t13030, t13032;
  double t13034, t13036, t13037, t13039, t13041, t13043, t13044, t13045;
  double t13047, t13049, t13052, t13054, t13058, t13060, t13064, t13065;
  double t13067, t13068, t13070, t13071, t13072, t13074, t13078, t13079;
  double t13080, t13083, t13088, t13092, t13096, t13100, t13101, t13102;
  double t13106, t13108, t13109, t13111, t13112, t13116, t13119, t13120;
  double t13123, t13126, t13127, t13128, t13130, t13132, t13135, t13136;
  double t13138, t13141, t13144, t13145, t13146, t13147, t13148, t13150;
  double t13154, t13157, t13160, t13163, t13166, t13169, t13172, t13174;
  double t13176, t13178, t13180, t13182, t13184, t13187, t13190, t13193;
  double t13196, t13200, t13204, t13207, t13208, t13210, t13211, t13212;
  double t13216, t13217, t13219, t13220, t13223, t13227, t13229, t13233;
  double t13234, t13236, t13237, t13240, t13243, t13244, t13246, t13247;
  double t13248, t13249, t13250, t13252, t13253, t13255, t13256, t13258;
  double t13262, t13263, t13264, t13266, t13268, t13270, t13273, t13275;
  double t13277, t13279, t13282, t13284, t13288, t13290, t13293, t13294;
  double t13296, t13297, t13299, t13302, t13310, t13314, t13316, t13317;
  double t13318, t13319, t13320, t13321, t13322, t13323, t13326, t13327;
  double t13328, t13330, t13335, t13336, t13340, t13347, t13349, t13352;
  double t13353, t13355, t13356, t13357, t13358, t13362, t13363, t13364;
  double t13365, t13366, t13370, t13371, t13372, t13373, t13374, t13375;
  double t13377, t13378, t13380, t13381, t13383, t13385, t13387, t13389;
  double t13393, t13396, t13399, t13402, t13403, t13406, t13408, t13410;
  double t13412, t13416, t13419, t13420, t13421, t13424, t13427, t13429;
  double t13431, t13432, t13434, t13435, t13437, t13438, t13440, t13443;
  double t13445, t13446, t13448, t13451, t13453, t13455, t13456, t13458;
  double t13459, t13460, t13463, t13466, t13467, t13470, t13473, t13475;
  double t13476, t13477, t13478, t13481, t13484, t13488, t13492, t13496;
  double t13498, t13500, t13502, t13504, t13507, t13509, t13513, t13514;
  double t13515, t13516, t13517, t13518, t13520, t13521, t13522, t13526;
  double t13527, t13528, t13530, t13534, t13535, t13536, t13537, t13538;
  double t13539, t13540, t13541, t13542, t13543, t13546, t13549, t13551;
  double t13553, t13554, t13558, t13559, t13560, t13561, t13564, t13567;
  double t13571, t13573, t13576, t13578, t13580, t13583, t13586, t13588;
  double t13589, t13590, t13591, t13593, t13594, t13595, t13597, t13601;
  double t13602, t13603, t13605, t13608, t13609, t13611, t13612, t13614;
  double t13616, t13618, t13620, t13624, t13626, t13628, t13629, t13634;
  double t13635, t13637, t13639, t13641, t13643, t13646, t13650, t13656;
  double t13657, t13658, t13659, t13660, t13662, t13663, t13666, t13667;
  double t13669, t13670, tv4rho3sigma3, t13673, t13674, t13675, t13676, t13677;
  double t13678, t13679, t13680, t13681, t13682, t13683, t13684, t13685;
  double t13689, t13691, t13692, t13693, t13694, t13695, t13696, t13697;
  double t13698, t13699, t13700, t13701, t13702, t13703, t13704, t13705;
  double t13706, t13709, t13723, t13725, t13736, t13737, t13738, t13739;
  double t13741, t13744, t13747, t13748, t13758, t13770, t13771, t13772;
  double t13773, t13774, t13778, t13779, t13780, t13781, t13783, t13788;
  double t13791, t13792, t13793, t13800, t13805, t13806, t13809, t13810;
  double t13816, t13818, t13819, t13822, t13828, t13829, t13842, t13843;
  double t13844, t13846, t13848, t13854, t13860, t13862, t13866, t13867;
  double t13869, t13870, t13871, t13872, t13873, t13880, t13881, t13890;
  double t13892, t13893, t13894, t13896, t13898, t13899, t13902, t13903;
  double t13905, t13908, t13913, t13921, t13922, t13923, t13924, t13925;
  double t13928, t13929, t13932, t13933, t13934, t13935, t13943, t13944;
  double t13945, t13946, t13947, t13948, t13949, t13951, t13954, t13955;
  double t13956, t13957, t13958, t13962, t13973, t13974, t13981, t13997;
  double t14003, t14004, t14005, t14006, t14007, t14008, t14009, t14010;
  double t14011, t14012, t14013, t14014, t14015, t14016, t14017, t14018;
  double t14023, t14027, tv4rho3sigma4, tv4rho3sigma5, t14030, t14031, t14033, t14034;
  double t14037, t14041, t14044, t14048, t14050, t14052, t14058, t14060;
  double t14063, t14065, t14067, t14068, t14070, t14072, t14076, t14079;
  double t14081, t14083, t14086, t14089, t14092, t14094, t14096, t14098;
  double t14101, t14104, t14107, t14109, t14111, t14114, t14117, t14121;
  double t14124, t14127, t14132, t14134, t14136, t14139, t14143, t14147;
  double t14149, t14150, t14153, t14155, t14158, t14161, t14165, t14167;
  double t14170, t14173, t14176, t14178, t14182, t14184, t14187, t14189;
  double t14190, t14191, t14196, t14198, t14200, t14204, t14206, t14209;
  double t14211, t14213, t14215, t14217, t14219, t14221, t14223, t14226;
  double t14228, t14231, t14233, t14235, t14237, t14241, t14243, t14246;
  double t14250, t14252, t14255, t14258, t14260, t14262, t14264, t14266;
  double t14270, t14274, t14278, t14280, t14282, t14283, t14286, t14288;
  double t14291, t14295, t14297, t14299, t14301, t14304, t14306, t14310;
  double t14312, t14314, t14318, t14322, t14325, t14327, t14330, t14332;
  double t14334, t14337, t14340, t14342, t14344, t14346, t14348, t14353;
  double t14359, t14362, t14364, t14366, t14368, t14370, t14372, t14375;
  double t14378, t14380, t14382, t14384, t14386, t14388, t14389, t14391;
  double t14394, t14397, t14399, t14401, t14403, t14405, t14407, t14409;
  double t14411, t14413, t14418, t14420, t14424, t14428, t14430, t14432;
  double t14436, t14439, t14442, t14444, t14448, t14451, t14453, t14455;
  double t14459, t14461, t14464, t14468, t14472, t14474, t14476, t14478;
  double t14482, t14484, t14486, t14489, t14493, t14496, t14499, t14501;
  double t14503, t14505, t14507, t14508, t14510, t14512, t14513, t14516;
  double t14519, t14522, t14527, t14531, t14537, t14540, t14541, t14543;
  double t14544, tv4rho3sigma6, t14549, t14552, t14554, t14558, t14563, t14565;
  double t14579, t14595, t14608, t14624, t14633, t14642, t14651, t14664;
  double t14679, t14690, t14707, t14720, t14727, t14743, t14759, t14764;
  double t14772, t14777, t14783, t14784, tv4rho3sigma7, tv4rho3sigma8, t14799, t14805;
  double t14807, t14811, t14815, t14817, t14820, t14824, t14826, t14828;
  double t14832, t14839, t14855, t14858, t14861, t14864, t14867, t14870;
  double t14872, t14876, t14879, t14888, t14891, t14895, t14902, t14905;
  double t14908, t14912, t14914, t14916, t14918, t14920, t14923, t14925;
  double t14928, t14931, t14933, t14935, t14937, t14939, t14942, t14944;
  double t14946, t14949, t14951, t14953, t14955, t14959, t14961, t14967;
  double t14971, t14973, t14975, t14977, t14982, t14988, t14992, t14994;
  double t15005, t15014, t15017, t15019, t15021, t15023, t15025, t15027;
  double t15030, t15032, t15036, t15038, t15041, t15043, t15045, t15058;
  double t15060, t15062, t15064, t15066, t15068, t15078, t15091, t15102;
  double tv4rho3sigma9, t15116, t15142, t15158, t15176, t15189, t15203, t15221;
  double t15238, t15254, t15270, t15275, t15288, t15299, tv4rho3sigma10, tv4rho3sigma11;
  double tv4rho3lapl0, tv4rho3lapl1, tv4rho3lapl2, tv4rho3lapl3, tv4rho3lapl4, tv4rho3lapl5, tv4rho3lapl6, tv4rho3lapl7;
  double t15320, t15327, t15328, t15340, t15355, t15359, t15368, t15378;
  double t15382, t15384, t15385, t15390, t15396, t15399, t15401, t15406;
  double t15411, t15413, t15420, t15422, t15423, t15425, t15426, t15428;
  double t15430, t15432, t15440, t15443, t15444, t15446, t15449, t15451;
  double t15457, t15462, t15468, t15470, t15490, t15496, t15499, t15507;
  double t15510, t15512, t15522, t15526, t15528, t15530, t15534, t15539;
  double t15545, t15552, t15555, t15558, t15578, t15601, t15612, t15614;
  double t15615, t15617, t15619, t15622, t15625, t15632, t15634, t15640;
  double t15646, t15651, t15652, t15654, t15655, t15660, t15662, t15664;
  double t15666, t15668, t15670, t15672, t15673, t15675, t15677, t15684;
  double t15687, t15689, t15695, t15698, t15701, t15703, t15706, t15708;
  double t15712, t15725, t15728, t15731, t15735, t15737, t15744, t15746;
  double t15757, t15759, t15761, t15765, t15770, t15774, t15779, t15783;
  double t15787, t15789, t15791, t15796, t15798, t15800, t15806, t15808;
  double t15810, t15815, t15817, t15821, t15824, t15825, t15827, t15830;
  double t15834, t15840, t15843, t15846, t15848, t15852, t15855, t15857;
  double t15859, t15866, t15875, t15876, t15880, t15884, t15887, t15891;
  double t15897, t15901, t15908, t15911, t15915, t15916, t15918, t15920;
  double t15923, t15925, t15933, t15935, t15937, t15941, t15946, t15966;
  double t15968, t15970, t15973, t15976, t15981, t15985, t15989, t15994;
  double t16000, t16021, t16027, t16029, t16032, t16033, t16039, t16041;
  double t16044, t16054, t16058, t16062, t16066, t16071, t16073, t16077;
  double t16078, t16090, t16094, t16095, t16096, t16101, t16103, t16105;
  double t16111, t16136, t16146, t16156, t16160, t16164, t16167, t16171;
  double t16198, t16204, t16220, t16231, t16241, t16246, t16247, t16257;
  double t16265, t16278, t16284, t16291, t16294, t16299, t16302, t16311;
  double t16339, t16356, t16359, t16377, tv4rho3tau0, t16387, t16392, t16394;
  double t16398, t16417, t16418, t16423, t16426, t16427, t16434, t16435;
  double t16439, t16445, t16448, t16454, t16456, t16462, t16463, t16475;
  double t16481, t16484, t16489, t16507, t16512, t16516, t16522, t16523;
  double t16531, t16542, t16546, t16550, t16551, t16556, t16557, t16572;
  double t16580, t16590, t16593, t16595, t16597, t16600, t16602, t16605;
  double t16608, t16611, t16614, t16620, t16622, t16632, t16635, t16643;
  double t16645, t16648, t16650, t16652, t16667, t16670, t16672, t16676;
  double t16679, t16683, t16685, t16686, t16688, t16690, t16692, t16694;
  double t16700, t16715, t16716, t16722, t16727, t16735, t16745, t16752;
  double t16754, t16759, t16762, t16765, t16768, t16776, t16779, t16795;
  double t16797, t16800, t16803, t16811, t16814, t16828, t16830, t16840;
  double t16841, t16852, t16892, t16898, t16910, t16931, t16940, t16941;
  double t16952, t16964, t16969, t16998, t17000, t17002, t17004, t17039;
  double t17047, t17048, t17050, t17066, t17083, t17087, t17099, tv4rho3tau1;
  double t17101, t17102, t17103, t17104, t17105, t17106, t17107, t17108;
  double t17109, t17110, t17111, t17112, t17113, t17114, t17115, t17116;
  double t17117, t17118, t17121, t17123, t17124, t17125, t17126, t17127;
  double t17128, t17129, t17131, t17132, t17133, t17135, t17138, t17142;
  double t17146, t17150, t17155, t17159, t17173, t17176, t17177, t17182;
  double t17185, t17196, t17203, t17207, t17210, t17215, t17218, t17219;
  double t17221, t17224, t17228, t17240, t17249, t17254, t17258, t17268;
  double t17272, t17273, t17279, t17283, t17296, t17303, t17305, t17314;
  double t17325, t17326, t17330, t17334, t17341, t17353, t17359, t17366;
  double t17370, t17374, t17378, t17387, t17388, t17394, t17399, t17403;
  double t17405, t17409, t17416, t17443, t17450, t17463, t17480, t17488;
  double t17491, t17492, t17495, t17497, t17505, t17516, t17520, t17524;
  double t17526, t17528, t17533, t17538, t17553, t17555, t17557, t17562;
  double t17563, t17571, t17575, t17577, t17581, t17589, t17590, t17608;
  double t17628, t17655, t17658, t17669, t17691, t17698, t17704, t17705;
  double t17715, t17718, t17721, t17724, t17735, t17737, t17739, t17743;
  double t17750, t17753, t17757, t17761, t17779, t17780, t17800, t17805;
  double t17807, t17817, t17818, t17825, t17829, t17841, t17846, t17851;
  double t17857, t17869, t17873, t17881, t17903, t17907, t17911, t17915;
  double t17920, t17924, t17925, t17935, t17946, t17953, t17957, t17960;
  double t17962, t17965, t17966, t17973, t17986, t17989, t17992, t18004;
  double t18007, t18008, t18012, t18014, t18017, t18021, t18027, t18029;
  double t18032, t18056, t18057, t18060, t18063, t18064, t18065, t18071;
  double t18074, t18081, t18083, t18096, t18101, t18106, t18123, t18124;
  double t18127, t18141, t18151, t18156, t18160, t18164, t18170, t18171;
  double t18177, t18183, t18186, t18190, t18222, t18225, t18237, t18238;
  double t18255, t18263, t18277, t18281, t18285, t18300, t18308, t18311;
  double t18312, t18319, t18320, t18325, t18331, t18333, t18334, t18340;
  double t18345, t18350, t18353, t18364, t18365, t18372, t18375, t18379;
  double t18382, t18387, t18388, t18398, t18400, t18401, t18409, t18413;
  double t18416, t18419, t18422, t18425, t18433, t18452, t18470, t18477;
  double t18480, t18483, t18500, t18509, t18523, t18526, t18530, t18541;
  double t18551, t18580, t18599, t18602, t18606, t18630, t18639, t18643;
  double t18647, t18654, t18655, t18656, t18657, t18658, t18659, t18660;
  double t18662, t18663, t18664, t18665, t18666, t18667, t18670, t18671;
  double t18672, t18673, t18674, t18675, t18676, t18677, t18678, t18679;
  double t18680, t18681, t18682, t18683, t18684, t18685, t18686, t18687;
  double t18688, t18689, t18690, t18691, t18692, t18693, t18694, t18695;
  double t18696, t18698, t18699, t18700, t18701, t18702, t18703, t18704;
  double t18705, t18706, t18707, t18708, t18709, t18710, t18711, t18715;
  double t18716, t18717, t18718, t18719, tv4rho3tau2, t18723, t18724, t18725;
  double t18726, t18727, t18728, t18729, t18730, t18761, t18784, t18785;
  double t18787, t18791, t18799, t18803, t18811, t18813, t18817, t18821;
  double t18826, t18828, t18831, t18833, t18837, t18854, t18875, t18883;
  double t18886, t18887, t18888, t18891, t18892, t18901, t18911, t18923;
  double t18930, t18937, t18940, t18952, t18973, t18984, t18991, t18996;
  double t19001, t19008, t19011, t19013, t19014, t19016, t19023, t19025;
  double t19026, t19036, t19043, t19053, t19064, t19074, t19075, t19079;
  double t19080, t19091, t19110, t19114, t19121, t19139, t19143, t19147;
  double t19151, t19155, t19159, t19160, t19161, t19168, t19169, t19173;
  double t19177, t19193, t19197, t19203, t19204, t19208, t19210, t19213;
  double t19214, t19235, t19238, t19247, t19248, t19251, t19253, t19256;
  double t19262, t19264, t19285, t19300, t19303, t19311, t19323, t19331;
  double t19346, t19347, t19352, t19355, t19358, t19361, t19368, t19376;
  double t19378, t19387, t19406, t19420, t19422, t19426, t19433, t19434;
  double t19439, t19451, t19452, t19460, t19467, t19468, t19486, t19487;
  double t19488, t19513, t19535, t19539, t19542, t19544, t19547, t19550;
  double t19553, t19564, t19566, t19568, t19575, t19583, t19598, t19615;
  double t19629, t19653, t19656, t19658, t19660, t19664, t19668, t19686;
  double t19693, t19696, t19697, t19700, t19703, t19705, t19738, t19758;
  double t19760, t19763, t19765, t19769, t19771, t19775, t19778, t19779;
  double t19812, t19845, t19857, t19865, t19878, t19881, t19882, t19891;
  double t19925, t19969, t19977, t19986, t20007, t20010, t20012, t20014;
  double t20043, t20050, t20053, t20054, t20055, t20056, t20057, t20059;
  double t20060, t20061, t20062, t20063, t20064, t20065, t20066, t20067;
  double t20068, t20069, t20070, t20071, t20072, t20073, t20074, t20075;
  double t20076, t20077, t20078, t20079, t20080, t20081, t20082, t20083;
  double t20084, t20085, t20086, t20087, t20088, t20091, t20092, t20093;
  double t20094, t20095, t20096, t20097, t20098, t20099, t20100, t20101;
  double t20102, t20103, t20104, t20105, t20106, t20107, t20108, t20109;
  double t20110, t20111, t20112, t20113, t20114, t20115, t20116, t20117;
  double t20118, t20119, t20120, t20121, t20122, t20123, t20124, t20125;
  double t20126, t20127, t20129, t20132, t20134, t20135, t20136, t20137;
  double t20138, tv4rho3tau3, t20143, t20145, t20148, t20149, t20153, t20163;
  double t20182, t20186, t20187, t20194, t20197, t20208, t20212, t20214;
  double t20216, t20224, t20233, t20234, t20259, t20261, t20267, t20290;
  double t20293, t20299, t20302, t20315, t20320, t20326, t20334, t20340;
  double t20343, t20349, t20356, t20362, t20368, t20372, t20392, t20405;
  double t20409, t20413, t20421, t20435, t20440, t20449, t20455, t20463;
  double t20473, t20496, t20500, t20506, t20509, t20529, t20530, t20534;
  double t20556, t20572, t20583, t20600, t20614, t20635, t20676, t20693;
  double t20697, t20702, t20707, t20714, t20717, t20731, t20736, t20737;
  double t20744, t20748, t20767, t20770, t20773, t20778, t20782, t20786;
  double t20801, t20817, t20820, t20826, t20828, t20830, t20837, t20842;
  double t20855, t20860, t20877, t20881, t20884, t20888, t20928, t20932;
  double t20940, t20958, t20961, t20967, t20968, t20971, t20974, t20976;
  double t20978, t20983, t21002, t21005, t21008, t21011, t21014, t21017;
  double t21020, t21023, t21026, t21029, t21034, t21038, t21042, t21059;
  double t21062, t21081, t21089, t21111, t21115, t21118, t21120, t21127;
  double t21141, t21145, t21146, t21149, t21152, t21155, t21156, t21160;
  double t21168, t21178, t21181, t21183, t21193, t21194, t21207, t21211;
  double t21215, t21245, t21267, t21277, t21294, t21302, t21309, t21313;
  double t21326, t21337, t21345, t21355, t21362, t21364, t21365, tv4rho3tau4;
  double t21370, t21371, t21373, t21375, t21378, t21403, t21416, t21455;
  double t21483, t21486, t21489, t21492, t21494, t21495, t21497, t21508;
  double t21515, t21518, t21525, t21534, t21542, t21546, t21553, t21554;
  double t21558, t21566, t21567, t21580, t21581, t21585, t21594, t21605;
  double t21609, t21617, t21620, t21623, t21631, t21635, t21649, t21665;
  double t21683, t21700, t21714, t21719, t21721, t21724, t21727, t21735;
  double t21739, t21771, t21773, t21775, t21778, t21780, t21781, t21814;
  double t21817, t21820, t21822, t21841, t21880, t21906, t21935, t21940;
  double t21961, t21964, t22006, t22027, t22030, t22046, t22047, t22049;
  double t22052, t22076, t22083, t22098, t22116, t22159, t22175, t22178;
  double t22181, t22184, t22187, t22191, t22193, t22196, t22236, t22241;
  double t22282, t22302, t22343, t22360, t22374, t22378, t22380, t22385;
  double t22389, t22418, t22438, t22466, t22469, t22480, t22513, t22516;
  double t22519, t22521, t22553, t22565, t22587, t22592, t22594, t22596;
  double t22598, t22611, t22614, t22629, t22652, t22660, t22663, t22664;
  double t22666, t22671, tv4rho3tau5, t22708, t22712, t22716, t22720, t22737;
  double t22739, t22742, t22745, t22748, t22752, t22756, t22771, t22779;
  double t22784, t22787, t22790, t22795, t22799, t22802, t22807, t22824;
  double t22829, t22832, t22863, t22878, t22881, t22904, t22912, t22924;
  double t22938, t22947, t22980, t23008, t23019, t23027, t23035, t23046;
  double t23082, t23090, t23113, t23138, t23146, t23148, t23155, t23161;
  double t23187, t23229, t23237, t23253, t23269, t23285, tv4rho3tau6, t23293;
  double t23312, t23334, t23349, t23395, t23401, t23408, t23426, t23469;
  double t23478, t23509, t23553, t23589, t23648, t23652, t23653, t23676;
  double t23709, t23713, t23720, t23724, t23728, t23762, t23776, t23803;
  double t23813, t23831, t23857, t23885, t23908, t23941, t23980, t24030;
  double t24052, t24072, t24093, t24113, tv4rho3tau7, t24117, t24120, t24122;
  double t24124, t24128, t24129, t24131, t24132, t24133, t24135, t24136;
  double t24139, t24143, t24144, t24145, t24146, t24147, t24148, t24151;
  double t24152, t24154, t24155, t24157, t24160, t24163, t24164, t24167;
  double t24168, t24169, t24171, t24172, t24173, t24175, t24177, t24179;
  double t24181, t24184, t24185, t24188, t24191, t24192, t24194, t24196;
  double t24197, t24198, t24199, t24201, t24203, t24205, t24207, t24208;
  double t24209, t24210, t24211, t24212, t24214, t24215, t24216, t24218;
  double t24219, t24222, t24223, t24225, t24228, t24231, t24233, t24235;
  double t24237, t24240, t24243, t24245, t24246, t24247, t24249, t24250;
  double t24252, t24253, t24254, t24256, t24257, t24258, t24260, t24264;
  double t24267, t24268, t24269, t24272, t24274, t24276, t24280, t24282;
  double t24285, t24287, t24289, t24291, t24292, t24293, t24294, t24295;
  double t24297, t24299, t24300, t24303, t24307, t24308, t24309, t24310;
  double t24311, t24312, t24313, t24314, t24315, t24317, t24321, t24325;
  double t24326, t24329, t24332, t24333, t24336, t24343, tv4rho2sigma20, t24346;
  double t24347, t24348, t24350, t24351, t24352, t24353, t24356, t24357;
  double t24358, t24359, t24362, t24364, t24366, t24367, t24371, t24373;
  double t24377, t24381, t24382, t24384, t24386, t24388, t24395, t24396;
  double t24397, t24398, t24402, t24404, t24411, t24412, t24415, t24417;
  double t24418, t24424, tv4rho2sigma21, tv4rho2sigma22, t24426, t24430, t24431, t24438;
  double t24444, t24445, t24446, t24452, t24459, t24467, t24468, t24469;
  double t24486, t24499, t24502, t24506, t24507, t24509, t24520, t24522;
  double t24523, tv4rho2sigma23, tv4rho2sigma24, tv4rho2sigma25, t24527, t24529, t24533, t24535;
  double t24538, t24540, t24543, t24545, t24546, t24548, t24550, t24552;
  double t24554, t24561, t24563, t24565, t24567, t24569, t24571, t24574;
  double t24576, t24578, t24580, t24582, t24585, t24588, t24593, t24595;
  double t24598, t24601, t24602, t24604, t24608, t24612, t24616, t24626;
  double t24629, t24632, t24635, t24637, t24639, t24641, t24643, t24645;
  double t24654, t24658, t24662, t24666, t24670, t24674, t24676, t24677;
  double t24681, t24683, t24685, t24687, t24689, t24691, t24693, t24695;
  double t24697, t24700, t24704, t24705, t24708, t24710, t24713, t24717;
  double t24720, t24724, t24732, t24735, t24737, t24739, t24742, t24745;
  double t24747, t24749, t24751, t24754, t24757, t24760, t24762, t24765;
  double t24770, t24771, tv4rho2sigma26, t24772, t24773, t24774, t24777, t24778;
  double t24779, t24780, t24782, t24783, t24787, t24791, t24792, t24793;
  double t24805, t24813, t24824, t24831, t24832, t24834, t24835, t24836;
  double t24838, t24839, t24840, t24844, t24852, t24853, t24854, t24855;
  double t24860, tv4rho2sigma27, tv4rho2sigma28, t24861, t24862, t24864, t24865, t24866;
  double t24867, t24869, t24870, t24871, t24873, t24886, t24895, t24901;
  double t24905, t24912, t24920, t24921, t24923, t24924, t24926, t24927;
  double t24928, t24929, t24932, t24940, t24941, t24942, t24943, t24948;
  double t24949, tv4rho2sigma29, tv4rho2sigma210, tv4rho2sigma211, t24953, t24955, t24956, t24958;
  double t24960, t24963, t24967, t24968, t24971, t24975, t24979, t24984;
  double t24987, t24989, t24993, t24996, t24999, t25002, t25005, t25008;
  double t25011, t25013, t25015, t25019, t25023, t25025, t25028, t25031;
  double t25033, t25036, t25040, t25042, t25044, t25048, t25052, t25055;
  double t25057, t25059, t25061, t25063, t25066, t25068, t25072, tv4rho2sigma212;
  double t25074, t25088, t25103, t25116, t25123, tv4rho2sigma213, tv4rho2sigma214, t25141;
  double t25162, t25179, t25195, t25206, tv4rho2sigma215, tv4rho2sigma216, tv4rho2sigma217, tv4rho2sigmalapl0;
  double tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3, tv4rho2sigmalapl4, tv4rho2sigmalapl5, tv4rho2sigmalapl6, tv4rho2sigmalapl7, tv4rho2sigmalapl8;
  double tv4rho2sigmalapl9, tv4rho2sigmalapl10, tv4rho2sigmalapl11, tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16;
  double tv4rho2sigmalapl17, t25208, t25210, t25212, t25214, t25215, t25216, t25218;
  double t25219, t25220, t25222, t25224, t25226, t25227, t25229, t25231;
  double t25233, t25235, t25236, t25238, t25240, t25242, t25243, t25245;
  double t25246, t25247, t25250, t25252, t25255, t25256, t25258, t25259;
  double t25260, t25261, t25264, t25265, t25266, t25267, t25269, t25272;
  double t25273, t25274, t25275, t25276, t25277, t25279, t25282, t25283;
  double t25284, t25286, t25287, t25288, t25291, t25292, t25293, t25294;
  double t25295, t25297, t25299, t25301, t25304, t25308, t25310, t25312;
  double t25314, t25315, t25316, t25319, t25321, t25323, t25324, t25327;
  double t25329, t25330, t25332, t25334, t25336, t25337, t25340, t25342;
  double t25344, t25347, t25349, t25351, t25353, t25354, t25356, t25357;
  double t25359, t25360, t25362, t25363, t25365, t25366, t25367, t25369;
  double t25371, t25374, t25376, t25380, t25384, t25388, t25390, t25391;
  double t25393, t25394, t25395, t25396, t25398, t25399, t25402, t25403;
  double t25405, t25407, t25409, t25411, t25413, t25417, t25419, t25422;
  double t25426, t25427, t25430, t25431, t25434, t25436, t25438, t25441;
  double t25443, t25444, t25445, t25446, t25447, t25449, t25452, t25453;
  double t25454, t25456, t25458, t25461, t25464, t25465, t25466, t25468;
  double t25469, t25471, t25473, t25475, t25477, t25478, t25480, t25481;
  double t25482, t25484, t25486, t25488, t25490, t25492, t25493, t25495;
  double t25497, t25500, t25503, t25505, t25507, t25509, t25512, t25513;
  double t25515, t25516, t25517, t25519, t25521, t25522, t25526, t25528;
  double t25530, t25531, t25534, t25537, t25541, t25542, t25543, t25544;
  double t25548, t25550, t25551, t25553, t25555, t25557, t25558, t25559;
  double t25560, t25561, t25562, t25564, t25565, t25567, t25569, t25572;
  double t25573, t25575, t25577, t25578, t25579, t25581, t25583, t25584;
  double t25585, t25586, t25589, t25590, t25592, t25593, t25595, t25596;
  double t25598, t25599, t25600, t25602, t25604, t25605, t25606, t25607;
  double t25610, t25612, t25613, t25614, t25616, t25619, t25621, t25624;
  double t25625, t25626, t25629, t25630, t25631, t25635, t25638, t25641;
  double t25643, t25644, t25645, t25647, t25649, t25651, t25655, t25657;
  double t25660, t25662, t25664, t25666, t25668, t25670, t25671, t25672;
  double t25674, t25676, t25679, t25682, t25685, t25686, t25687, t25691;
  double t25695, t25698, t25701, t25704, t25705, t25707, t25711, t25712;
  double t25715, t25717, t25718, t25719, t25720, t25722, t25724, t25726;
  double t25729, t25730, t25731, t25732, t25733, t25735, t25737, t25738;
  double t25740, t25741, t25742, t25744, t25746, t25747, t25748, t25752;
  double t25756, t25757, t25758, t25761, t25763, t25765, t25766, t25767;
  double t25768, t25770, t25771, t25772, t25773, t25775, t25776, t25777;
  double t25778, t25779, t25780, t25782, t25784, t25788, t25789, t25790;
  double t25792, t25794, t25795, t25797, t25798, t25800, t25802, t25803;
  double t25805, t25806, t25807, t25809, t25812, t25814, t25819, t25822;
  double t25823, t25826, t25828, t25829, t25830, t25832, t25833, t25834;
  double t25836, t25839, t25840, t25842, t25843, t25845, t25847, t25849;
  double t25851, t25852, t25854, t25857, t25860, t25863, t25864, t25865;
  double t25867, t25869, t25872, t25873, t25874, t25875, t25878, t25880;
  double t25883, t25885, t25886, t25889, t25890, t25891, t25893, t25894;
  double t25895, t25896, t25898, t25899, t25900, t25902, t25903, t25905;
  double t25906, t25908, t25909, t25911, t25913, t25914, t25915, t25916;
  double t25917, t25918, t25919, t25920, t25921, t25923, t25924, t25925;
  double t25926, t25927, t25928, t25929, t25931, t25933, t25934, t25936;
  double t25937, t25938, t25939, t25940, t25941, t25942, t25943, t25944;
  double t25945, t25949, t25950, t25952, t25954, t25960, t25962, t25965;
  double tv4rho2sigmatau0, t25967, t25969, t25971, t25973, t25976, t25978, t25980;
  double t25981, t25984, t25986, t25988, t25990, t25992, t25994, t25997;
  double t25999, t26001, t26005, t26006, t26007, t26010, t26012, t26013;
  double t26014, t26015, t26018, t26019, t26020, t26022, t26024, t26026;
  double t26028, t26029, t26030, t26031, t26032, t26033, t26035, t26036;
  double t26037, t26039, t26040, t26041, t26043, t26047, t26049, t26050;
  double t26052, t26054, t26055, t26057, t26059, t26060, t26061, t26062;
  double t26063, t26064, t26067, t26068, t26070, t26071, t26073, t26074;
  double t26077, t26081, t26084, t26087, t26090, t26091, t26092, t26095;
  double t26096, t26097, t26098, t26099, t26100, t26101, t26103, t26105;
  double t26107, t26108, t26109, t26111, t26113, t26117, t26119, t26121;
  double t26123, t26125, t26127, t26128, t26129, t26130, t26131, t26133;
  double t26135, t26136, t26137, t26140, t26142, t26143, t26144, t26145;
  double t26146, t26147, t26149, t26151, t26153, t26156, t26160, t26164;
  double t26166, t26168, t26171, t26175, t26178, t26179, t26181, t26182;
  double t26184, t26186, t26188, t26190, t26192, t26193, t26194, t26196;
  double t26198, t26201, t26202, t26204, t26205, t26207, t26208, t26209;
  double t26213, t26214, t26215, t26217, t26218, t26219, t26220, t26221;
  double t26223, t26225, t26226, t26227, t26229, t26230, t26231, t26234;
  double t26235, t26237, t26240, t26241, t26242, t26243, t26245, t26246;
  double t26247, t26248, t26249, t26252, t26253, t26256, t26258, t26260;
  double t26263, t26264, t26265, t26266, t26267, t26268, t26269, t26273;
  double t26276, t26279, t26280, t26282, t26283, t26284, t26285, t26286;
  double t26287, t26288, t26289, t26290, t26291, t26293, t26294, t26296;
  double t26298, t26299, t26301, t26302, t26303, t26304, t26308, t26311;
  double t26312, t26313, t26316, t26317, t26318, t26320, t26323, t26326;
  double t26327, t26328, t26333, t26335, t26341, t26345, t26348, t26349;
  double t26351, t26354, t26355, t26357, t26359, t26360, t26361, t26365;
  double t26366, t26368, t26370, t26372, t26373, t26374, t26376, t26378;
  double t26380, t26382, t26384, t26385, t26388, t26390, t26392, t26394;
  double t26396, t26399, t26400, t26402, t26404, t26405, t26406, t26407;
  double t26409, t26410, t26411, t26412, t26415, t26419, t26420, t26422;
  double t26423, t26425, t26428, t26431, t26433, t26434, t26437, t26439;
  double t26440, t26442, t26446, t26447, t26450, t26453, t26456, t26457;
  double t26459, t26461, t26462, t26465, t26469, t26470, t26473, t26475;
  double t26478, t26481, t26482, t26483, t26485, t26488, t26489, t26491;
  double t26492, t26493, t26495, t26496, t26497, t26504, tv4rho2sigmatau1, t26513;
  double t26515, t26516, t26518, t26519, t26527, t26528, t26530, t26532;
  double t26536, t26552, t26553, t26556, t26559, t26566, t26567, t26582;
  double t26597, t26613, t26616, t26627, t26635, t26642, t26649, t26650;
  double t26658, t26675, t26679, t26680, t26684, t26689, t26704, t26719;
  double t26723, t26724, t26734, t26737, t26741, t26750, t26762, t26776;
  double t26791, t26795, t26797, t26800, t26801, t26806, t26818, t26820;
  double t26821, t26829, t26830, t26832, tv4rho2sigmatau2, t26848, t26853, t26857;
  double t26862, t26880, t26903, t26904, t26926, t26931, t26939, t26944;
  double t26949, t26950, t26963, t26964, t26965, t26967, t26968, t26971;
  double t26976, t26977, t26978, t26980, t26991, t27014, t27027, t27033;
  double t27037, t27050, t27055, t27056, t27057, t27058, t27059, t27062;
  double t27066, t27067, t27068, t27070, t27071, t27075, t27085, t27086;
  double t27087, tv4rho2sigmatau3, tv4rho2sigmatau4, tv4rho2sigmatau5, t27089, t27090, t27092, t27093;
  double t27096, t27101, t27103, t27106, t27109, t27111, t27112, t27113;
  double t27115, t27117, t27119, t27121, t27123, t27124, t27127, t27130;
  double t27132, t27134, t27136, t27138, t27140, t27141, t27143, t27145;
  double t27146, t27148, t27150, t27151, t27152, t27157, t27158, t27164;
  double t27168, t27170, t27171, t27173, t27177, t27179, t27182, t27186;
  double t27190, t27192, t27194, t27196, t27198, t27201, t27202, t27204;
  double t27205, t27207, t27208, t27210, t27213, t27216, t27218, t27221;
  double t27224, t27226, t27228, t27229, t27231, t27232, t27233, t27236;
  double t27238, t27241, t27244, t27246, t27248, t27251, t27253, t27259;
  double t27262, t27265, t27266, t27268, t27269, t27274, t27276, t27278;
  double t27280, t27282, t27284, t27286, t27288, t27294, t27295, t27298;
  double t27301, t27303, t27305, t27308, t27311, t27312, t27313, t27315;
  double t27325, t27326, t27328, t27329, t27330, t27332, t27334, t27336;
  double t27338, t27340, t27342, t27354, t27356, t27358, t27360, t27362;
  double t27365, t27368, t27375, t27376, t27379, t27380, t27382, t27383;
  double t27384, t27386, t27388, t27391, t27393, t27394, t27396, t27398;
  double t27399, t27401, t27402, t27404, t27408, t27410, t27412, t27416;
  double t27420, t27422, t27425, t27428, t27429, t27431, t27434, t27437;
  double t27440, t27443, t27445, t27448, t27454, t27460, t27463, t27466;
  double t27469, t27472, t27475, t27477, t27480, t27482, t27485, t27489;
  double t27491, t27493, t27494, t27496, t27499, t27501, t27503, t27504;
  double t27505, t27507, t27508, t27510, t27512, t27515, t27517, t27519;
  double t27522, t27527, t27531, t27533, t27535, t27537, t27539, t27541;
  double t27543, t27546, t27548, t27550, t27552, t27554, t27556, t27558;
  double t27562, t27564, t27566, t27568, t27571, t27574, t27576, t27580;
  double t27582, t27585, t27588, t27590, t27592, t27593, t27594, t27596;
  double t27597, t27598, t27599, t27601, t27603, t27605, t27608, t27610;
  double t27612, t27614, t27618, t27621, t27623, t27626, t27629, t27633;
  double t27636, t27639, t27641, t27644, t27646, t27651, t27653, t27655;
  double t27657, t27660, t27662, t27664, t27666, t27668, t27670, t27673;
  double t27674, t27675, t27677, t27679, t27684, t27686, t27690, t27692;
  double t27695, t27697, t27701, t27704, t27707, t27709, t27710, t27712;
  double t27716, t27719, t27723, t27730, t27732, t27734, t27736, t27738;
  double t27740, t27742, t27744, t27747, t27750, t27752, t27754, t27757;
  double t27760, t27762, t27764, t27766, t27769, t27773, t27779, t27782;
  double t27784, t27786, t27789, t27792, t27796, t27798, t27800, t27806;
  double t27809, t27811, t27813, t27814, t27817, t27820, t27823, t27829;
  double t27831, t27834, t27835, t27836, t27840, t27842, t27845, t27846;
  double t27850, t27852, t27854, t27857, t27859, t27861, t27863, t27866;
  double t27868, t27870, t27872, t27874, t27875, t27877, t27879, t27881;
  double t27884, t27886, t27888, t27890, t27892, t27898, t27899, tv4rho2sigmatau6;
  double t27901, t27902, t27904, t27905, t27907, t27909, t27911, t27913;
  double t27914, t27916, t27919, t27923, t27925, t27927, t27929, t27932;
  double t27934, t27936, t27938, t27940, t27943, t27945, t27947, t27949;
  double t27950, t27953, t27955, t27959, t27961, t27962, t27965, t27967;
  double t27968, t27971, t27973, t27974, t27977, t27979, t27981, t27984;
  double t27986, t27988, t27990, t27992, t27995, t27998, t28002, t28007;
  double t28009, t28011, t28015, t28019, t28022, t28024, t28030, t28031;
  double t28038, t28042, t28046, t28048, t28052, t28054, t28058, t28062;
  double t28066, t28068, t28070, t28072, t28074, t28076, t28078, t28081;
  double t28084, t28086, t28089, t28091, t28094, t28096, t28100, t28102;
  double t28104, t28106, t28108, t28110, t28112, t28115, t28117, t28119;
  double t28121, t28123, t28125, t28127, t28129, t28132, t28134, t28136;
  double t28139, t28141, t28142, t28145, t28148, t28151, t28154, t28156;
  double t28157, t28160, t28162, t28164, t28167, t28170, t28173, t28176;
  double t28179, t28181, t28183, t28185, t28187, t28189, t28191, t28193;
  double t28196, t28198, t28199, t28202, t28204, t28206, t28208, t28211;
  double t28213, t28214, t28215, t28217, t28220, t28223, t28227, t28231;
  double t28234, t28237, t28240, t28243, t28245, t28247, t28250, t28252;
  double t28256, t28259, t28262, t28264, t28267, t28269, t28271, t28273;
  double t28275, t28277, t28280, t28283, t28285, t28288, t28290, t28292;
  double t28294, t28299, t28302, t28304, t28307, t28310, t28313, t28314;
  double t28315, t28317, t28319, t28321, t28323, t28324, t28325, t28327;
  double t28329, t28331, t28335, t28337, t28339, t28341, t28343, t28345;
  double t28346, t28348, t28350, t28352, t28356, t28358, t28361, t28363;
  double t28366, t28368, t28372, t28374, t28376, t28378, t28380, t28382;
  double t28387, t28392, t28394, t28396, t28397, t28399, t28401, t28403;
  double t28405, t28407, t28410, t28413, t28416, t28418, t28420, t28424;
  double t28426, t28428, t28434, t28436, t28438, t28440, t28444, t28448;
  double t28450, t28452, t28456, t28458, t28461, t28463, t28465, t28468;
  double t28470, t28472, t28475, t28478, t28480, t28482, t28484, t28486;
  double t28489, t28491, t28493, t28495, t28497, t28500, t28503, t28505;
  double t28507, t28509, t28511, t28516, t28518, t28521, t28523, t28525;
  double t28527, t28528, t28529, t28532, t28534, t28536, t28538, t28541;
  double t28542, t28546, t28548, t28550, t28552, t28558, t28560, t28562;
  double t28564, t28566, t28568, t28571, t28574, t28576, t28578, t28580;
  double t28584, t28589, t28592, t28594, t28603, t28606, t28608, t28610;
  double t28613, t28616, t28618, t28620, t28623, t28626, t28629, t28633;
  double t28635, t28637, t28640, t28642, t28644, t28645, t28649, t28651;
  double t28655, t28658, t28660, t28662, t28665, t28668, t28682, t28686;
  double t28688, t28694, tv4rho2sigmatau7, t28696, t28711, t28713, t28715, t28716;
  double t28727, t28734, t28736, t28737, t28740, t28741, t28742, t28743;
  double t28744, t28747, t28748, t28749, t28751, t28754, t28755, t28756;
  double t28758, t28760, t28764, t28765, t28770, t28777, t28781, t28792;
  double t28803, t28804, t28809, t28813, t28814, t28816, t28817, t28821;
  double t28822, t28824, t28825, t28827, t28843, t28863, t28869, t28870;
  double t28871, t28872, t28874, t28875, t28876, t28881, t28889, t28890;
  double t28891, t28893, t28901, t28914, t28915, t28918, t28920, t28926;
  double t28930, t28932, t28935, t28940, t28941, t28949, t28952, t28963;
  double t28964, t28965, t28967, t28968, t28974, t28976, t28977, tv4rho2sigmatau8;
  double t28985, t28986, t28987, t28988, t28995, t29003, t29004, t29005;
  double t29006, t29007, t29008, t29009, t29010, t29011, t29012, t29013;
  double t29014, t29022, t29024, t29040, t29056, t29057, t29058, t29061;
  double t29073, t29074, t29075, t29076, t29079, t29080, t29082, t29094;
  double t29095, t29100, t29109, t29110, t29111, t29112, t29113, t29114;
  double t29115, t29116, t29117, t29118, t29119, t29120, t29124, t29125;
  double t29126, t29127, t29128, t29129, t29130, t29139, t29145, t29154;
  double t29155, t29156, t29157, t29168, t29170, t29171, t29175, t29178;
  double t29179, t29180, t29183, t29192, t29193, t29194, t29195, t29196;
  double t29197, t29198, t29210, t29219, t29220, t29231, t29244, t29252;
  double t29253, t29256, t29257, t29259, t29260, t29264, t29270, t29271;
  double t29273, t29274, tv4rho2sigmatau9, tv4rho2sigmatau10, tv4rho2sigmatau11, t29276, t29278, t29280;
  double t29282, t29284, t29287, t29291, t29293, t29294, t29295, t29297;
  double t29299, t29300, t29302, t29304, t29306, t29308, t29311, t29316;
  double t29318, t29320, t29322, t29323, t29325, t29328, t29332, t29334;
  double t29336, t29338, t29340, t29344, t29346, t29349, t29353, t29355;
  double t29356, t29358, t29360, t29362, t29363, t29364, t29366, t29367;
  double t29368, t29370, t29372, t29377, t29379, t29381, t29384, t29386;
  double t29387, t29389, t29390, t29392, t29395, t29401, t29402, t29404;
  double t29405, t29408, t29411, t29413, t29414, t29416, t29419, t29421;
  double t29427, t29430, t29432, t29433, t29434, t29436, t29437, t29439;
  double t29441, t29443, t29445, t29448, t29451, t29453, t29457, t29461;
  double t29463, t29466, t29470, t29473, t29475, t29478, t29480, t29482;
  double t29484, t29486, t29488, t29491, t29494, t29497, t29499, t29502;
  double t29506, t29509, t29512, t29514, t29518, t29520, t29521, t29523;
  double t29525, t29528, t29532, t29534, t29536, t29537, t29538, t29540;
  double t29541, t29542, t29544, t29546, t29548, t29550, t29554, t29556;
  double t29558, t29561, t29564, t29566, t29568, t29571, t29573, t29575;
  double t29578, t29580, t29582, t29584, t29587, t29589, t29592, t29594;
  double t29600, t29602, t29604, t29607, t29609, t29611, t29613, t29615;
  double t29621, t29623, t29625, t29627, tv4rho2sigmatau12, t29629, t29631, t29637;
  double t29639, t29641, t29643, t29647, t29649, t29651, t29653, t29656;
  double t29658, t29660, t29661, t29663, t29666, t29668, t29669, t29671;
  double t29672, t29674, t29675, t29679, t29683, t29686, t29690, t29692;
  double t29693, t29695, t29696, t29698, t29700, t29702, t29704, t29706;
  double t29708, t29710, t29713, t29716, t29719, t29721, t29723, t29725;
  double t29727, t29729, t29731, t29733, t29735, t29738, t29740, t29742;
  double t29744, t29745, t29748, t29753, t29756, t29758, t29761, t29763;
  double t29764, t29766, t29769, t29773, t29777, t29780, t29782, t29784;
  double t29787, t29790, t29792, t29794, t29796, t29798, t29800, t29802;
  double t29806, t29808, t29811, t29813, t29816, t29820, t29822, t29825;
  double t29827, t29829, t29831, t29833, t29837, t29840, t29842, t29843;
  double t29845, t29848, t29850, t29853, t29855, t29857, t29859, t29863;
  double t29867, t29871, t29873, t29874, t29877, t29879, t29881, t29886;
  double t29888, t29891, t29893, t29896, t29899, t29901, t29903, t29905;
  double t29907, t29909, t29911, t29913, t29915, t29918, t29920, t29922;
  double t29925, t29927, t29929, t29931, t29934, t29937, t29939, t29940;
  double t29944, t29949, t29953, t29955, t29956, t29959, t29962, t29964;
  double t29966, t29969, t29972, t29975, t29978, t29980, t29983, t29985;
  double t29987, t29990, t29993, t29996, t29999, t30002, t30004, t30005;
  double t30007, t30009, t30012, t30014, t30016, t30018, t30020, t30024;
  double t30026, t30027, t30030, t30032, t30034, t30036, t30038, t30040;
  double t30043, t30047, t30049, t30050, t30052, t30054, t30056, t30059;
  double t30063, t30065, t30067, t30070, t30072, t30074, t30076, t30082;
  double t30085, tv4rho2sigmatau13, t30098, t30106, t30119, t30139, t30161, t30179;
  double t30204, t30214, t30238, t30261, t30283, t30303, t30309, tv4rho2sigmatau14;
  double t30323, t30336, t30349, t30363, t30378, t30394, t30408, t30423;
  double t30439, t30455, t30467, t30482, t30497, t30508, t30518, t30533;
  double t30547, t30560, t30571, t30589, t30601, t30606, tv4rho2sigmatau15, tv4rho2sigmatau16;
  double tv4rho2sigmatau17, tv4rho2lapl20, tv4rho2lapl21, tv4rho2lapl22, tv4rho2lapl23, tv4rho2lapl24, tv4rho2lapl25, tv4rho2lapl26;
  double tv4rho2lapl27, tv4rho2lapl28, tv4rho2lapltau0, tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4, tv4rho2lapltau5;
  double tv4rho2lapltau6, tv4rho2lapltau7, tv4rho2lapltau8, tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11, t30614, t30619;
  double t30625, t30628, t30629, t30634, t30645, t30653, t30655, t30656;
  double t30660, t30664, t30679, t30680, t30683, t30690, t30693, t30702;
  double t30703, t30711, t30716, t30720, t30722, t30724, t30726, t30728;
  double t30733, t30752, t30754, t30757, t30760, t30762, t30763, t30769;
  double t30786, t30789, t30793, t30797, t30798, t30802, t30804, t30808;
  double t30815, t30823, t30828, t30829, t30834, t30841, t30843, t30850;
  double t30856, t30859, t30860, t30866, t30870, t30874, t30877, t30880;
  double t30885, t30888, t30889, t30891, t30896, t30898, t30900, t30904;
  double t30907, t30911, t30912, t30922, t30925, t30929, t30939, t30944;
  double t30946, t30949, t30951, t30956, t30962, t30976, t30981, t30997;
  double t31003, t31004, t31008, t31019, t31033, t31041, t31044, t31052;
  double t31061, t31069, t31076, t31080, t31086, t31088, t31090, t31092;
  double t31096, t31098, t31101, t31124, t31126, t31136, t31137, t31140;
  double t31143, t31146, t31149, t31170, t31172, t31174, t31178, t31179;
  double t31183, t31192, t31194, t31197, tv4rho2tau20, t31206, t31207, t31218;
  double t31221, t31238, t31241, t31242, t31250, t31254, t31255, t31259;
  double t31261, t31266, t31267, t31269, t31270, t31274, t31276, t31279;
  double t31284, t31291, t31306, t31308, t31313, t31317, t31319, t31324;
  double t31329, t31342, t31343, t31347, t31348, t31350, t31352, t31354;
  double t31356, t31368, t31369, t31375, t31376, t31392, t31398, t31403;
  double t31407, t31412, t31416, t31421, t31426, t31434, t31435, t31437;
  double t31442, t31446, t31447, t31453, t31455, t31459, t31466, t31468;
  double t31479, t31483, t31495, t31497, t31498, t31500, t31504, t31516;
  double t31518, t31522, t31527, t31538, t31571, t31577, t31586, t31611;
  double t31623, t31625, t31628, t31629, t31637, t31638, t31646, t31651;
  double t31654, t31656, t31659, t31663, t31668, t31696, t31703, t31710;
  double t31715, t31731, t31733, t31735, t31737, t31775, t31777, t31794;
  double t31799, t31820, t31823, t31825, t31828, t31841, t31842, t31846;
  double t31857, t31867, t31875, t31877, t31881, t31883, t31886, t31889;
  double t31902, t31904, t31911, t31921, t31932, t31938, t31940, t31952;
  double t31953, t31955, t31956, t31963, tv4rho2tau21, t31980, t31983, t32002;
  double t32003, t32007, t32020, t32024, t32028, t32031, t32034, t32039;
  double t32049, t32061, t32068, t32070, t32074, t32090, t32096, t32101;
  double t32108, t32112, t32116, t32125, t32129, t32131, t32137, t32139;
  double t32141, t32145, t32155, t32157, t32163, t32172, t32178, t32180;
  double t32182, t32187, t32192, t32193, t32198, t32199, t32204, t32206;
  double t32208, t32210, t32212, t32214, t32216, t32220, t32223, t32227;
  double t32230, t32235, t32238, t32260, t32262, t32268, t32275, t32276;
  double t32284, t32286, t32291, t32292, t32301, t32343, t32345, t32347;
  double t32350, t32352, t32354, t32363, t32364, t32371, t32374, t32375;
  double t32384, t32385, t32387, tv4rho2tau22, t32388, t32389, t32392, t32418;
  double t32426, t32427, t32437, t32441, t32452, t32468, t32473, t32477;
  double t32483, t32484, t32516, t32525, t32530, t32533, t32542, t32544;
  double t32545, t32547, t32560, t32563, t32570, t32589, t32590, t32592;
  double t32593, t32605, t32607, t32610, t32629, t32632, t32638, t32641;
  double t32647, t32668, t32671, t32673, t32685, t32708, t32715, t32734;
  double t32736, t32741, t32743, t32746, t32755, t32759, t32763, t32764;
  double t32768, t32778, t32790, t32797, t32814, t32817, t32838, t32868;
  double t32871, t32872, t32882, t32883, t32885, t32888, t32897, t32907;
  double t32913, t32916, t32919, t32929, t32935, t32941, t32945, t32946;
  double t32947, t32950, t32951, t32954, t32956, t32977, t32980, t32988;
  double t32994, t32995, tv4rho2tau23, t32997, t32998, t33001, t33042, t33044;
  double t33046, t33049, t33061, t33062, t33066, t33070, t33071, t33078;
  double t33088, t33100, t33112, t33114, t33118, t33121, t33149, t33158;
  double t33162, t33163, t33168, t33172, t33181, t33186, t33190, t33213;
  double t33239, t33251, t33268, t33317, t33338, t33343, t33346, t33351;
  double t33352, t33359, t33363, t33375, t33379, t33407, t33410, t33415;
  double t33427, t33473, t33480, t33483, t33485, t33487, t33489, t33492;
  double t33501, t33512, t33516, t33524, t33540, t33554, t33567, t33577;
  double t33585, t33588, t33603, t33609, t33617, t33619, t33622, t33624;
  double t33632, t33636, t33639, t33657, t33665, t33671, t33680, t33685;
  double t33688, t33696, t33698, t33709, t33711, t33718, t33723, t33752;
  double t33767, t33771, t33796, t33799, t33804, t33807, t33823, t33837;
  double t33872, t33892, t33919, t33954, t33965, t33973, t33979, t33980;
  double tv4rho2tau24, t33982, t33986, t33992, t33995, t33998, t34012, t34014;
  double t34017, t34047, t34050, t34056, t34058, t34062, t34077, t34079;
  double t34084, t34091, t34109, t34112, t34114, t34116, t34119, t34122;
  double t34124, t34131, t34133, t34143, t34151, t34160, t34163, t34165;
  double t34167, t34168, t34170, t34173, t34177, t34180, t34184, t34186;
  double t34200, t34203, t34206, t34210, t34231, t34247, t34253, t34257;
  double t34278, t34301, t34303, t34305, t34326, t34327, t34333, t34353;
  double t34360, t34364, t34376, t34397, t34422, t34453, t34465, t34478;
  double t34486, t34500, t34509, t34524, t34539, t34544, t34564, t34570;
  double t34572, t34573, tv4rho2tau25, t34611, t34636, t34639, t34644, t34647;
  double t34650, t34653, t34688, t34699, t34706, t34743, t34765, t34772;
  double t34806, t34822, t34847, t34851, t34855, t34877, t34891, t34905;
  double tv4rho2tau26, t34927, t34953, t34982, t35001, t35019, t35028, t35050;
  double t35057, t35079, t35099, t35110, t35134, t35138, t35174, t35182;
  double t35194, t35219, t35236, t35261, t35273, t35292, t35315, t35355;
  double t35359, t35363, t35387, t35407, t35441, t35479, t35490, t35507;
  double tv4rho2tau27, t35525, t35526, t35557, t35578, t35610, t35656, t35698;
  double t35730, t35805, t35809, t35828, t35875, t35904, t35921, t35936;
  double tv4rho2tau28, t35937, t35938, t35940, t35941, t35942, t35944, t35945;
  double t35947, t35949, t35952, t35953, t35955, t35956, t35957, t35958;
  double t35961, t35963, t35966, t35967, t35969, t35972, t35974, t35976;
  double t35980, t35984, t35985, t35986, t35988, t35990, t35994, t35995;
  double t35997, t36000, t36003, t36004, t36006, t36008, t36009, t36010;
  double t36011, t36013, t36015, t36019, t36020, t36024, tv4rhosigma30, t36026;
  double t36030, t36033, t36038, t36040, t36042, t36044, t36047, t36051;
  double tv4rhosigma31, tv4rhosigma32, t36053, t36057, t36060, t36065, t36067, t36069;
  double t36071, t36074, t36078, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, t36080, t36084;
  double t36087, t36092, t36094, t36096, t36098, t36101, t36105, tv4rhosigma36;
  double tv4rhosigma37, tv4rhosigma38, tv4rhosigma39, t36107, t36108, t36110, t36112, t36114;
  double t36117, t36120, t36122, t36124, t36126, t36130, t36133, t36137;
  double t36140, t36142, t36143, t36146, t36151, tv4rhosigma310, t36170, tv4rhosigma311;
  double tv4rhosigma312, t36189, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, t36208, tv4rhosigma316, tv4rhosigma317;
  double tv4rhosigma318, tv4rhosigma319, tv4rhosigma2lapl0, tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5;
  double tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8, tv4rhosigma2lapl9, tv4rhosigma2lapl10, tv4rhosigma2lapl11, tv4rhosigma2lapl12, tv4rhosigma2lapl13;
  double tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19, tv4rhosigma2lapl20, tv4rhosigma2lapl21;
  double tv4rhosigma2lapl22, tv4rhosigma2lapl23, t36210, t36212, t36214, t36217, t36218, t36221;
  double t36222, t36223, t36227, t36229, t36230, t36231, t36232, t36233;
  double t36237, t36239, t36241, t36242, t36243, t36245, t36249, t36251;
  double t36254, t36257, t36258, t36259, t36261, t36262, t36263, t36265;
  double t36268, t36269, t36270, t36272, t36273, t36275, t36277, t36278;
  double t36280, t36281, t36285, t36287, t36288, t36289, t36290, t36292;
  double t36293, t36294, t36296, t36298, t36300, t36301, t36302, t36304;
  double t36307, t36309, t36311, t36313, t36315, t36319, t36321, t36323;
  double t36324, t36325, t36327, t36329, t36333, t36336, t36338, t36342;
  double t36343, t36348, t36350, t36354, t36356, t36358, t36361, t36363;
  double t36364, t36365, t36367, t36369, t36371, t36374, t36375, t36376;
  double t36377, t36378, t36380, t36382, t36383, t36385, t36389, t36392;
  double t36394, t36395, t36397, t36400, t36402, t36404, t36405, t36407;
  double t36409, t36410, t36412, t36413, t36415, t36417, t36418, t36419;
  double t36420, t36421, t36422, t36424, tv4rhosigma2tau0, t36428, t36429, t36431;
  double t36432, t36433, t36436, t36439, t36441, t36442, t36444, t36445;
  double t36446, t36448, t36452, t36454, t36455, t36456, t36457, t36458;
  double t36460, t36461, t36464, t36467, t36469, t36470, t36471, t36472;
  double t36475, t36477, t36479, t36481, t36482, t36483, t36486, t36487;
  double t36488, t36490, t36493, t36495, t36496, t36498, t36499, t36501;
  double t36502, t36505, t36507, t36510, t36512, t36514, t36516, t36518;
  double t36520, t36521, t36522, t36525, t36527, t36528, t36530, t36532;
  double t36534, t36535, t36537, t36539, t36542, t36544, t36546, t36548;
  double t36550, t36554, t36558, t36560, t36562, t36563, t36565, t36567;
  double t36570, t36572, t36576, t36577, t36580, tv4rhosigma2tau1, t36588, t36589;
  double t36596, t36597, t36598, t36600, t36601, t36603, t36609, t36613;
  double t36626, t36629, t36633, t36636, t36638, t36639, t36641, t36646;
  double t36650, t36653, tv4rhosigma2tau2, t36657, t36658, t36662, t36663, t36667;
  double t36668, t36669, t36670, t36673, t36679, t36682, t36685, t36689;
  double t36691, t36694, t36695, t36696, t36703, t36704, t36716, tv4rhosigma2tau3;
  double tv4rhosigma2tau4, tv4rhosigma2tau5, t36723, t36727, t36734, t36735, t36742, t36743;
  double t36744, t36746, t36747, t36749, t36756, t36758, t36773, t36774;
  double t36779, t36782, t36784, t36785, t36787, t36789, tv4rhosigma2tau6, t36793;
  double t36794, t36798, t36799, t36803, t36804, t36805, t36806, t36809;
  double t36814, t36816, t36818, t36821, t36822, t36823, t36830, t36833;
  double t36836, t36839, t36852, tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, tv4rhosigma2tau11;
  double t36856, t36857, t36860, t36863, t36865, t36868, t36869, t36873;
  double t36877, t36880, t36882, t36886, t36888, t36889, t36891, t36893;
  double t36895, t36896, t36898, t36900, t36903, t36905, t36907, t36908;
  double t36910, t36912, t36914, t36915, t36916, t36918, t36920, t36922;
  double t36924, t36927, t36929, t36933, t36935, t36938, t36940, t36942;
  double t36945, t36947, t36950, t36953, t36957, t36958, t36961, t36962;
  double t36966, t36968, t36972, t36974, tv4rhosigma2tau12, t36979, t36982, t36984;
  double t36987, t36989, t36993, t36995, t36998, t37000, t37002, t37004;
  double t37006, t37007, t37009, t37010, t37012, t37015, t37018, t37020;
  double t37024, t37028, t37032, t37034, t37037, t37039, t37041, t37045;
  double t37048, t37051, t37054, t37058, t37060, t37062, t37064, t37066;
  double t37068, t37070, t37072, t37073, t37074, t37076, t37077, t37079;
  double t37081, t37084, t37087, t37089, t37091, t37095, t37097, t37100;
  double t37104, t37107, t37111, t37113, tv4rhosigma2tau13, t37128, t37140, t37154;
  double t37160, tv4rhosigma2tau14, t37174, t37186, t37199, t37217, tv4rhosigma2tau15, tv4rhosigma2tau16;
  double tv4rhosigma2tau17, t37232, t37249, t37258, t37264, tv4rhosigma2tau18, t37278, t37290;
  double t37311, t37321, tv4rhosigma2tau19, tv4rhosigma2tau20, tv4rhosigma2tau21, tv4rhosigma2tau22, tv4rhosigma2tau23, tv4rhosigmalapl20;
  double tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24, tv4rhosigmalapl25, tv4rhosigmalapl26, tv4rhosigmalapl27, tv4rhosigmalapl28;
  double tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212, tv4rhosigmalapl213, tv4rhosigmalapl214, tv4rhosigmalapl215, tv4rhosigmalapl216;
  double tv4rhosigmalapl217, tv4rhosigmalapltau0, tv4rhosigmalapltau1, tv4rhosigmalapltau2, tv4rhosigmalapltau3, tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6;
  double tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9, tv4rhosigmalapltau10, tv4rhosigmalapltau11, tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14;
  double tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17, tv4rhosigmalapltau18, tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22;
  double tv4rhosigmalapltau23, t37325, t37326, t37330, t37332, t37336, t37340, t37342;
  double t37345, t37347, t37348, t37350, t37351, t37352, t37354, t37357;
  double t37359, t37361, t37364, t37367, t37369, t37371, t37374, t37377;
  double t37378, t37380, t37381, t37382, t37384, t37386, t37390, t37393;
  double t37395, t37399, t37400, t37403, t37404, t37405, t37406, t37407;
  double t37408, t37409, t37411, t37412, t37413, t37414, t37416, t37417;
  double t37418, t37420, t37423, t37424, t37425, t37427, t37429, t37430;
  double t37432, t37433, t37436, t37439, t37441, t37442, t37444, t37447;
  double t37449, t37450, t37453, t37456, t37458, t37459, t37460, t37461;
  double t37462, t37463, t37464, t37465, t37467, t37468, t37469, t37471;
  double t37473, t37475, t37476, t37479, t37481, t37484, t37485, t37486;
  double t37487, t37488, t37491, t37492, t37496, t37499, t37501, t37503;
  double t37505, t37508, t37510, t37511, t37514, t37517, t37518, t37519;
  double t37521, t37522, t37524, t37526, t37527, t37528, t37529, t37530;
  double t37533, t37535, t37536, t37538, t37541, t37542, t37544, t37545;
  double t37547, t37550, t37553, t37554, t37555, t37557, t37558, t37561;
  double t37564, t37566, t37569, t37571, t37572, t37573, t37576, t37578;
  double t37580, t37581, t37582, t37584, t37585, t37586, t37588, t37589;
  double t37590, t37592, t37593, t37594, t37595, t37597, tv4rhosigmatau20, t37601;
  double t37602, t37603, t37604, t37605, t37608, t37609, t37611, t37613;
  double t37615, t37617, t37619, t37621, t37623, t37625, t37627, t37628;
  double t37630, t37632, t37634, t37636, t37638, t37640, t37643, t37644;
  double t37646, t37648, t37649, t37650, t37652, t37654, t37657, t37660;
  double t37662, t37663, t37664, t37667, t37669, t37671, t37674, t37676;
  double t37679, t37681, t37683, t37684, t37687, t37689, t37692, t37693;
  double t37696, t37699, t37702, t37703, t37704, t37705, t37707, t37709;
  double t37712, t37714, t37716, t37718, t37720, t37721, t37722, t37723;
  double t37724, t37726, t37728, t37729, t37731, t37734, t37737, t37738;
  double t37739, t37740, t37741, t37743, t37746, t37748, t37751, t37753;
  double t37755, t37758, t37759, t37761, t37762, t37764, t37766, t37768;
  double t37770, t37773, t37775, t37778, t37779, t37781, t37784, t37787;
  double t37789, t37791, t37794, t37795, t37798, t37800, t37802, t37804;
  double t37806, t37808, t37811, t37814, t37816, t37818, t37819, t37821;
  double t37823, t37825, t37828, t37832, t37833, t37834, t37836, t37839;
  double t37841, t37844, t37846, t37850, t37851, t37853, t37854, t37855;
  double t37856, t37858, t37859, t37860, t37861, t37865, t37866, t37867;
  double t37870, t37873, t37876, t37877, t37880, t37884, t37886, t37889;
  double t37890, t37892, t37894, t37898, t37899, t37900, t37902, t37903;
  double t37905, t37907, t37910, t37912, t37915, t37916, t37918, t37919;
  double t37920, t37921, t37922, t37924, tv4rhosigmatau21, t37930, t37932, t37934;
  double t37937, t37941, t37944, t37946, t37948, t37949, t37951, t37955;
  double t37957, t37958, t37960, t37962, t37964, t37966, t37968, t37971;
  double t37974, t37976, t37977, t37979, t37980, t37982, t37985, t37988;
  double t37991, t37994, t37996, t37997, t37998, t38000, t38002, t38003;
  double t38005, t38006, t38007, t38008, t38009, t38010, t38012, t38014;
  double t38016, t38017, t38019, t38021, t38024, t38026, t38030, t38031;
  double t38034, t38036, t38038, t38040, t38044, t38048, t38050, t38051;
  double t38052, t38053, t38054, t38055, t38057, t38060, t38062, t38063;
  double t38065, t38066, t38067, t38068, t38069, t38070, t38072, t38073;
  double t38075, t38076, t38078, t38079, t38080, t38081, t38082, t38083;
  double t38085, t38086, t38087, t38088, t38090, t38093, t38095, t38097;
  double t38099, t38101, t38104, t38106, t38108, t38110, t38112, t38114;
  double t38116, t38117, t38120, t38122, t38125, t38126, t38129, t38131;
  double tv4rhosigmatau22, t38143, t38150, t38151, t38154, t38157, t38159, t38160;
  double t38163, t38165, t38169, t38170, t38171, t38172, t38176, t38180;
  double t38184, t38189, t38202, t38205, t38207, t38208, t38211, t38220;
  double t38221, t38223, t38226, tv4rhosigmatau23, t38230, t38232, t38241, t38247;
  double t38253, t38266, t38268, t38269, t38272, t38275, t38278, t38282;
  double t38283, t38291, t38296, t38303, t38307, t38312, t38313, t38314;
  double t38315, t38318, t38323, t38328, t38330, t38332, t38337, t38338;
  double t38339, t38341, tv4rhosigmatau24, t38362, t38365, t38369, t38371, t38372;
  double t38378, t38381, t38382, t38383, t38384, t38387, t38391, t38392;
  double t38393, t38397, t38398, t38399, t38400, t38401, t38402, t38403;
  double t38404, t38405, t38406, t38422, t38424, tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27;
  double tv4rhosigmatau28, t38429, t38431, t38432, t38435, t38438, t38444, t38447;
  double t38448, t38450, t38451, t38454, t38457, t38459, t38460, t38464;
  double t38467, t38469, t38471, t38474, t38476, t38479, t38481, t38483;
  double t38484, t38485, t38489, t38492, t38495, t38497, t38498, t38500;
  double t38501, t38504, t38506, t38507, t38510, t38512, t38515, t38517;
  double t38519, t38522, t38524, t38526, t38527, t38529, t38530, t38531;
  double t38533, t38534, t38537, t38540, t38543, t38546, t38548, t38550;
  double t38552, t38554, t38558, t38562, t38564, t38566, t38567, t38570;
  double t38572, t38573, t38576, t38577, t38579, t38581, tv4rhosigmatau29, t38587;
  double t38590, t38592, t38595, t38597, t38600, t38602, t38603, t38604;
  double t38606, t38609, t38612, t38614, t38615, t38616, t38618, t38620;
  double t38622, t38624, t38626, t38628, t38630, t38632, t38633, t38634;
  double t38637, t38640, t38642, t38645, t38646, t38648, t38650, t38652;
  double t38654, t38657, t38659, t38661, t38664, t38666, t38669, t38672;
  double t38678, t38681, t38684, t38686, t38687, t38689, t38690, t38692;
  double t38694, t38696, t38698, t38701, t38703, t38706, t38708, t38710;
  double t38711, t38713, t38715, t38717, t38719, t38722, t38724, t38727;
  double t38729, t38731, t38733, t38735, t38739, t38742, t38744, t38746;
  double t38749, t38753, t38755, t38757, t38759, t38761, t38763, t38765;
  double t38767, t38770, t38772, t38774, t38777, t38779, t38781, t38784;
  double t38786, t38789, t38792, t38794, t38796, t38799, t38801, t38804;
  double t38807, t38809, t38811, tv4rhosigmatau210, t38817, t38819, t38821, t38823;
  double t38826, t38828, t38830, t38832, t38834, t38835, t38837, t38839;
  double t38843, t38847, t38849, t38851, t38853, t38855, t38859, t38862;
  double t38864, t38866, t38870, t38872, t38873, t38876, t38878, t38881;
  double t38884, t38886, t38889, t38891, t38893, t38894, t38897, t38899;
  double t38901, t38903, t38905, t38906, t38908, t38910, t38913, t38916;
  double t38920, t38922, t38925, t38927, t38930, t38934, t38937, t38942;
  double t38944, t38945, t38948, t38950, t38952, t38955, t38958, t38961;
  double t38964, t38967, t38969, t38972, t38976, t38978, t38980, t38983;
  double t38985, t38988, t38991, t38993, tv4rhosigmatau211, t39012, t39024, t39041;
  double t39053, tv4rhosigmatau212, t39066, t39075, t39084, t39096, t39109, t39121;
  double t39129, t39146, tv4rhosigmatau213, t39169, t39184, t39202, t39220, tv4rhosigmatau214;
  double tv4rhosigmatau215, tv4rhosigmatau216, tv4rhosigmatau217, tv4rholapl30, tv4rholapl31, tv4rholapl32, tv4rholapl33, tv4rholapl34;
  double tv4rholapl35, tv4rholapl36, tv4rholapl37, tv4rholapl2tau0, tv4rholapl2tau1, tv4rholapl2tau2, tv4rholapl2tau3, tv4rholapl2tau4;
  double tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8, tv4rholapl2tau9, tv4rholapl2tau10, tv4rholapl2tau11, tv4rholapltau20;
  double tv4rholapltau21, tv4rholapltau22, tv4rholapltau23, tv4rholapltau24, tv4rholapltau25, tv4rholapltau26, tv4rholapltau27, tv4rholapltau28;
  double tv4rholapltau29, tv4rholapltau210, tv4rholapltau211, t39226, t39229, t39235, t39240, t39243;
  double t39247, t39248, t39254, t39257, t39259, t39261, t39263, t39264;
  double t39265, t39268, t39271, t39272, t39277, t39286, t39288, t39289;
  double t39294, t39301, t39302, t39303, t39304, t39310, t39315, t39321;
  double t39326, t39334, t39337, t39344, t39345, t39355, t39358, t39359;
  double t39363, t39370, t39381, t39385, t39390, t39394, t39410, t39412;
  double t39418, t39423, t39431, tv4rhotau30, t39440, t39444, t39453, t39455;
  double t39463, t39464, t39470, t39473, t39478, t39488, t39501, t39519;
  double t39528, t39543, t39552, t39569, t39573, t39577, t39589, t39599;
  double t39612, t39616, t39620, t39626, t39629, t39633, tv4rhotau31, t39637;
  double t39641, t39646, t39651, t39656, t39660, t39664, t39670, t39675;
  double t39679, t39688, t39692, t39696, t39703, t39726, t39738, t39752;
  double t39761, t39781, t39784, t39791, t39795, t39805, t39815, t39821;
  double t39830, t39845, t39846, tv4rhotau32, t39851, t39853, t39855, t39859;
  double t39866, t39873, t39876, t39877, t39878, t39882, t39888, t39893;
  double t39896, t39899, t39905, t39912, t39913, t39918, t39919, t39933;
  double t39941, t39947, t39952, t39957, t39963, t39965, t39974, t39977;
  double t39981, t39982, t40004, tv4rhotau33, t40009, t40016, t40023, t40034;
  double t40042, t40049, t40063, t40076, t40121, tv4rhotau34, t40156, t40160;
  double t40169, t40209, t40245, t40275, tv4rhotau35, t40305, t40369, t40416;
  double t40441, tv4rhotau36, t40447, t40452, t40453, t40454, t40455, t40482;
  double t40508, t40547, t40560, t40589, tv4rhotau37, t40594, t40595, t40597;
  double t40601, t40602, t40605, t40609, t40615, t40618, t40622, tv4sigma40;
  double tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48;
  double tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, tv4sigma414, tv4sigma3lapl0, tv4sigma3lapl1;
  double tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4, tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7, tv4sigma3lapl8, tv4sigma3lapl9;
  double tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12, tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15, tv4sigma3lapl16, tv4sigma3lapl17;
  double tv4sigma3lapl18, tv4sigma3lapl19, t40663, t40665, t40667, t40669, t40672, t40674;
  double t40675, t40677, t40678, t40682, t40684, t40687, t40689, t40691;
  double t40693, t40697, tv4sigma3tau0, t40702, t40704, t40707, t40712, t40714;
  double t40718, t40721, t40723, t40725, t40729, tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3;
  double tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8, tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11;
  double tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16, tv4sigma3tau17, tv4sigma3tau18, tv4sigma3tau19;
  double tv4sigma2lapl20, tv4sigma2lapl21, tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27;
  double tv4sigma2lapl28, tv4sigma2lapl29, tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215;
  double tv4sigma2lapl216, tv4sigma2lapl217, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5;
  double tv4sigma2lapltau6, tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13;
  double tv4sigma2lapltau14, tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21;
  double tv4sigma2lapltau22, tv4sigma2lapltau23, t40812, t40813, t40815, t40816, t40819, t40820;
  double t40822, t40823, t40826, t40828, t40831, t40832, t40834, t40836;
  double t40838, t40840, t40843, t40846, t40849, t40851, t40853, t40854;
  double t40858, t40862, tv4sigma2tau20, t40863, t40866, t40868, t40871, t40873;
  double t40876, t40881, t40883, t40885, t40887, t40889, t40891, t40896;
  double t40898, t40900, t40903, t40907, tv4sigma2tau21, t40908, t40910, t40912;
  double t40914, t40917, t40922, t40925, t40927, t40930, t40933, t40936;
  double t40938, t40940, t40944, t40948, tv4sigma2tau22, t40965, tv4sigma2tau23, t40982;
  double tv4sigma2tau24, t40999, tv4sigma2tau25, tv4sigma2tau26, tv4sigma2tau27, tv4sigma2tau28, t41016, tv4sigma2tau29;
  double t41033, tv4sigma2tau210, t41050, tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214, tv4sigma2tau215;
  double tv4sigma2tau216, tv4sigma2tau217, tv4sigmalapl30, tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33, tv4sigmalapl34, tv4sigmalapl35;
  double tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38, tv4sigmalapl39, tv4sigmalapl310, tv4sigmalapl311, tv4sigmalapl2tau0, tv4sigmalapl2tau1;
  double tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7, tv4sigmalapl2tau8, tv4sigmalapl2tau9;
  double tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15, tv4sigmalapl2tau16, tv4sigmalapl2tau17;
  double tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25, tv4sigmalapltau26, tv4sigmalapltau27;
  double tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213, tv4sigmalapltau214, tv4sigmalapltau215;
  double tv4sigmalapltau216, tv4sigmalapltau217, t41051, t41052, t41055, t41056, t41058, t41059;
  double t41061, t41062, t41064, t41065, t41067, t41070, t41071, t41074;
  double t41076, t41080, t41081, t41084, t41086, t41088, t41091, t41093;
  double t41095, t41097, t41099, t41101, t41104, t41106, t41107, t41109;
  double t41111, t41115, tv4sigmatau30, t41116, t41118, t41120, t41122, t41124;
  double t41126, t41128, t41131, t41134, t41138, t41141, t41143, t41145;
  double t41147, t41149, t41150, t41153, t41155, t41157, t41160, t41164;
  double tv4sigmatau31, t41165, t41168, t41171, t41173, t41176, t41179, t41182;
  double t41186, t41188, t41190, t41192, t41194, t41196, t41199, t41200;
  double t41203, t41205, t41208, t41211, t41215, tv4sigmatau32, t41216, t41219;
  double t41220, t41222, t41224, t41226, t41228, t41231, t41234, t41239;
  double t41242, t41244, t41247, t41249, t41251, t41253, t41256, t41259;
  double t41261, t41264, t41268, tv4sigmatau33, t41288, tv4sigmatau34, t41308, tv4sigmatau35;
  double t41328, tv4sigmatau36, t41348, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, tv4sigmatau311;
  double tv4lapl40, tv4lapl41, tv4lapl42, tv4lapl43, tv4lapl44, tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2;
  double tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, tv4lapl3tau7, tv4lapl2tau20, tv4lapl2tau21, tv4lapl2tau22;
  double tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27, tv4lapl2tau28, tv4lapltau30, tv4lapltau31;
  double tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36, tv4lapltau37, t41350, t41351;
  double t41353, t41354, t41358, t41363, t41366, t41368, t41373, t41382;
  double t41384, t41385, t41394, t41403, tv4tau40, tv4tau41, tv4tau42, tv4tau43;
  double t41540, t41541, t41543, t41544, t41553, t41566, t41567, t41576;
  double tv4tau44;

  mgga_c_ccalda_params *params;

  assert(p->params != NULL);
  params = (mgga_c_ccalda_params * ) (p->params);

  t2 = 0.1e1 + params->c;
  t3 = POW_1_3(rho[0]);
  t4 = t3 * t3;
  t6 = 0.1e1 / t4 / rho[0];
  t7 = tau[0] * t6;
  t8 = rho[0] - rho[1];
  t9 = rho[0] + rho[1];
  t10 = 0.1e1 / t9;
  t11 = t8 * t10;
  t12 = 0.1e1 + t11;
  t13 = t12 / 0.2e1;
  t14 = POW_1_3(t13);
  t15 = t14 * t14;
  t16 = t15 * t13;
  t17 = t7 * t16;
  t18 = POW_1_3(rho[1]);
  t19 = t18 * t18;
  t21 = 0.1e1 / t19 / rho[1];
  t22 = tau[1] * t21;
  t23 = 0.1e1 - t11;
  t24 = t23 / 0.2e1;
  t25 = POW_1_3(t24);
  t26 = t25 * t25;
  t27 = t26 * t24;
  t28 = t22 * t27;
  t30 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t31 = t9 * t9;
  t32 = POW_1_3(t9);
  t33 = t32 * t32;
  t35 = 0.1e1 / t33 / t31;
  t38 = t17 + t28 - t30 * t35 / 0.8e1;
  t39 = t2 * t38;
  t40 = M_CBRT6;
  t41 = M_PI * M_PI;
  t42 = POW_1_3(t41);
  t43 = t42 * t42;
  t44 = 0.1e1 / t43;
  t45 = t40 * t44;
  t46 = t39 * t45;
  t47 = M_CBRT2;
  t48 = t47 * t47;
  t50 = t45 * t48;
  t53 = 0.1e1 + 0.5e1 / 0.9e1 * params->c * t38 * t50;
  t54 = 0.1e1 / t53;
  t55 = t48 * t54;
  t56 = t31 * t31;
  t58 = 0.1e1 / t33 / t56;
  t59 = t30 * t58;
  t60 = t17 + t28;
  t61 = 0.1e1 / t60;
  t62 = t8 * t8;
  t63 = t61 * t62;
  t66 = 0.1e1 - t59 * t63 / 0.8e1;
  t67 = M_CBRT3;
  t68 = 0.1e1 / M_PI;
  t69 = POW_1_3(t68);
  t70 = t67 * t69;
  t71 = M_CBRT4;
  t72 = t71 * t71;
  t75 = t70 * t72 / t32;
  t77 = 0.1e1 + 0.53425e-1 * t75;
  t78 = sqrt(t75);
  t81 = POW_3_2(t75);
  t83 = t67 * t67;
  t84 = t69 * t69;
  t85 = t83 * t84;
  t88 = t85 * t71 / t33;
  t90 = 0.379785e1 * t78 + 0.8969e0 * t75 + 0.204775e0 * t81 + 0.123235e0 * t88;
  t93 = 0.1e1 + 0.16081979498692535067e2 / t90;
  t94 = log(t93);
  t96 = 0.621814e-1 * t77 * t94;
  t97 = t62 * t62;
  t98 = 0.1e1 / t56;
  t99 = t97 * t98;
  t100 = t12 <= p->zeta_threshold;
  t101 = POW_1_3(p->zeta_threshold);
  t102 = t101 * p->zeta_threshold;
  t103 = POW_1_3(t12);
  t105 = my_piecewise3(t100, t102, t103 * t12);
  t106 = t23 <= p->zeta_threshold;
  t107 = POW_1_3(t23);
  t109 = my_piecewise3(t106, t102, t107 * t23);
  t110 = t105 + t109 - 0.2e1;
  t113 = 0.1e1 / (0.2e1 * t47 - 0.2e1);
  t114 = t110 * t113;
  t116 = 0.1e1 + 0.5137e-1 * t75;
  t121 = 0.705945e1 * t78 + 0.1549425e1 * t75 + 0.420775e0 * t81 + 0.1562925e0 * t88;
  t124 = 0.1e1 + 0.32163958997385070134e2 / t121;
  t125 = log(t124);
  t129 = 0.1e1 + 0.278125e-1 * t75;
  t134 = 0.51785e1 * t78 + 0.905775e0 * t75 + 0.1100325e0 * t81 + 0.1241775e0 * t88;
  t137 = 0.1e1 + 0.29608749977793437516e2 / t134;
  t138 = log(t137);
  t139 = t129 * t138;
  t141 = -0.310907e-1 * t116 * t125 + t96 - 0.19751673498613801407e-1 * t139;
  t142 = t114 * t141;
  t146 = -t96 + t99 * t142 + 0.19751673498613801407e-1 * t114 * t139;
  t147 = t66 * t146;
  t148 = t55 * t147;
  t150 = 0.5e1 / 0.9e1 * t46 * t148;
  t151 = t39 * t40;
  t152 = t44 * t48;
  t153 = t152 * t54;
  t154 = t151 * t153;
  t156 = 0.1e1 - 0.5e1 / 0.9e1 * t154;
  t157 = t156 * t146;
  tzk0 = t150 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = rho[0] * rho[0];
  t160 = 0.1e1 / t4 / t158;
  t161 = tau[0] * t160;
  t162 = t161 * t16;
  t164 = 0.1e1 / t31;
  t165 = t8 * t164;
  t166 = t10 - t165;
  t167 = t166 / 0.2e1;
  t168 = t15 * t167;
  t169 = t7 * t168;
  t171 = -t167;
  t172 = t26 * t171;
  t173 = t22 * t172;
  t175 = t31 * t9;
  t177 = 0.1e1 / t33 / t175;
  t179 = t30 * t177 / 0.3e1;
  t180 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173 + t179;
  t181 = t2 * t180;
  t182 = t181 * t45;
  t183 = t182 * t148;
  t184 = 0.5e1 / 0.9e1 * t183;
  t185 = t40 * t40;
  t187 = 0.1e1 / t42 / t41;
  t188 = t185 * t187;
  t189 = t188 * t47;
  t190 = t39 * t189;
  t191 = t53 * t53;
  t192 = 0.1e1 / t191;
  t193 = t192 * t66;
  t194 = t146 * params->c;
  t195 = t194 * t180;
  t196 = t193 * t195;
  t197 = t190 * t196;
  t198 = 0.5e2 / 0.81e2 * t197;
  t199 = t56 * t9;
  t201 = 0.1e1 / t33 / t199;
  t202 = t30 * t201;
  t204 = 0.7e1 / 0.12e2 * t202 * t63;
  t205 = t60 * t60;
  t206 = 0.1e1 / t205;
  t207 = t206 * t62;
  t209 = -0.5e1 / 0.3e1 * t162 + 0.5e1 / 0.3e1 * t169 + 0.5e1 / 0.3e1 * t173;
  t210 = t207 * t209;
  t213 = t61 * t8;
  t215 = t59 * t213 / 0.4e1;
  t216 = t204 + t59 * t210 / 0.8e1 - t215;
  t217 = t216 * t146;
  t218 = t55 * t217;
  t219 = t46 * t218;
  t220 = 0.5e1 / 0.9e1 * t219;
  t222 = 0.1e1 / t32 / t9;
  t223 = t72 * t222;
  t226 = 0.11073470983333333333e-2 * t70 * t223 * t94;
  t227 = t90 * t90;
  t228 = 0.1e1 / t227;
  t229 = t77 * t228;
  t231 = 0.1e1 / t78 * t67;
  t232 = t69 * t72;
  t233 = t232 * t222;
  t234 = t231 * t233;
  t236 = t70 * t223;
  t238 = sqrt(t75);
  t239 = t238 * t67;
  t240 = t239 * t233;
  t245 = t85 * t71 / t33 / t9;
  t247 = -0.632975e0 * t234 - 0.29896666666666666667e0 * t236 - 0.1023875e0 * t240 - 0.82156666666666666667e-1 * t245;
  t248 = 0.1e1 / t93;
  t249 = t247 * t248;
  t251 = 0.1e1 * t229 * t249;
  t252 = t62 * t8;
  t253 = t252 * t98;
  t255 = 0.4e1 * t253 * t142;
  t256 = 0.1e1 / t199;
  t257 = t97 * t256;
  t259 = 0.4e1 * t257 * t142;
  t262 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t166);
  t263 = -t166;
  t266 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t263);
  t268 = (t262 + t266) * t113;
  t269 = t268 * t141;
  t274 = t121 * t121;
  t275 = 0.1e1 / t274;
  t276 = t116 * t275;
  t281 = -0.1176575e1 * t234 - 0.516475e0 * t236 - 0.2103875e0 * t240 - 0.104195e0 * t245;
  t282 = 0.1e1 / t124;
  t283 = t281 * t282;
  t289 = t134 * t134;
  t290 = 0.1e1 / t289;
  t291 = t129 * t290;
  t296 = -0.86308333333333333334e0 * t234 - 0.301925e0 * t236 - 0.5501625e-1 * t240 - 0.82785e-1 * t245;
  t297 = 0.1e1 / t137;
  t298 = t296 * t297;
  t301 = 0.53237641966666666666e-3 * t70 * t223 * t125 + 0.1e1 * t276 * t283 - t226 - t251 + 0.18311447306006545054e-3 * t70 * t223 * t138 + 0.5848223622634646207e0 * t291 * t298;
  t302 = t114 * t301;
  t303 = t99 * t302;
  t306 = t114 * t67;
  t308 = t232 * t222 * t138;
  t310 = 0.18311447306006545054e-3 * t306 * t308;
  t311 = t114 * t129;
  t313 = t290 * t296 * t297;
  t315 = 0.5848223622634646207e0 * t311 * t313;
  t316 = t226 + t251 + t255 - t259 + t99 * t269 + t303 + 0.19751673498613801407e-1 * t268 * t139 - t310 - t315;
  t317 = t66 * t316;
  t318 = t55 * t317;
  t319 = t46 * t318;
  t320 = 0.5e1 / 0.9e1 * t319;
  t321 = t181 * t40;
  t322 = t321 * t153;
  t324 = t39 * t188;
  t325 = t47 * t192;
  t326 = params->c * t180;
  t327 = t325 * t326;
  t330 = -0.5e1 / 0.9e1 * t322 + 0.5e2 / 0.81e2 * t324 * t327;
  t331 = t330 * t146;
  t332 = t156 * t316;
  tvrho0 = t150 + t157 + t9 * (t184 - t198 + t220 + t320 + t331 + t332);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t335 = -t10 - t165;
  t336 = t335 / 0.2e1;
  t337 = t15 * t336;
  t338 = t7 * t337;
  t340 = rho[1] * rho[1];
  t342 = 0.1e1 / t19 / t340;
  t343 = tau[1] * t342;
  t344 = t343 * t27;
  t346 = -t336;
  t347 = t26 * t346;
  t348 = t22 * t347;
  t350 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348 + t179;
  t351 = t2 * t350;
  t352 = t351 * t45;
  t353 = t352 * t148;
  t354 = 0.5e1 / 0.9e1 * t353;
  t355 = t194 * t350;
  t356 = t193 * t355;
  t357 = t190 * t356;
  t358 = 0.5e2 / 0.81e2 * t357;
  t360 = 0.5e1 / 0.3e1 * t338 - 0.5e1 / 0.3e1 * t344 + 0.5e1 / 0.3e1 * t348;
  t361 = t207 * t360;
  t364 = t204 + t59 * t361 / 0.8e1 + t215;
  t365 = t364 * t146;
  t366 = t55 * t365;
  t367 = t46 * t366;
  t368 = 0.5e1 / 0.9e1 * t367;
  t371 = my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t335);
  t372 = -t335;
  t375 = my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t372);
  t377 = (t371 + t375) * t113;
  t378 = t377 * t141;
  t382 = t226 + t251 - t255 - t259 + t99 * t378 + t303 + 0.19751673498613801407e-1 * t377 * t139 - t310 - t315;
  t383 = t66 * t382;
  t384 = t55 * t383;
  t385 = t46 * t384;
  t386 = 0.5e1 / 0.9e1 * t385;
  t387 = t351 * t40;
  t388 = t387 * t153;
  t390 = params->c * t350;
  t391 = t325 * t390;
  t394 = -0.5e1 / 0.9e1 * t388 + 0.5e2 / 0.81e2 * t324 * t391;
  t395 = t394 * t146;
  t396 = t156 * t382;
  tvrho1 = t150 + t157 + t9 * (t354 - t358 + t368 + t386 + t395 + t396);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t399 = t2 * t35;
  t400 = t399 * t45;
  t401 = t400 * t148;
  t402 = 0.5e1 / 0.72e2 * t401;
  t403 = t194 * t35;
  t405 = t190 * t193 * t403;
  t406 = 0.25e2 / 0.324e3 * t405;
  t407 = t39 * t50;
  t408 = t54 * t58;
  t409 = t63 * t146;
  t410 = t408 * t409;
  t411 = t407 * t410;
  t412 = 0.5e1 / 0.72e2 * t411;
  t414 = t399 * t40 * t153;
  t416 = params->c * t35;
  t418 = t324 * t325 * t416;
  t420 = 0.5e1 / 0.72e2 * t414 - 0.25e2 / 0.324e3 * t418;
  t421 = t420 * t146;
  tvsigma0 = t9 * (-t402 + t406 - t412 + t421);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t423 = 0.5e1 / 0.36e2 * t401;
  t424 = 0.25e2 / 0.162e3 * t405;
  t425 = 0.5e1 / 0.36e2 * t411;
  t428 = 0.5e1 / 0.36e2 * t414 - 0.25e2 / 0.162e3 * t418;
  t429 = t428 * t146;
  tvsigma1 = t9 * (-t423 + t424 - t425 + t429);

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t431 = t2 * t6;
  t432 = t16 * t40;
  t433 = t431 * t432;
  t434 = t54 * t66;
  t435 = t434 * t146;
  t436 = t152 * t435;
  t438 = 0.5e1 / 0.9e1 * t433 * t436;
  t439 = t193 * t146;
  t440 = params->c * t6;
  t441 = t440 * t16;
  t442 = t439 * t441;
  t444 = 0.5e2 / 0.81e2 * t190 * t442;
  t445 = t59 * t206;
  t446 = t62 * t6;
  t447 = t16 * t146;
  t448 = t446 * t447;
  t449 = t445 * t448;
  t451 = 0.5e1 / 0.72e2 * t154 * t449;
  t452 = t431 * t16;
  t453 = t45 * t55;
  t456 = t325 * t441;
  t459 = -0.5e1 / 0.9e1 * t452 * t453 + 0.5e2 / 0.81e2 * t324 * t456;
  t460 = t459 * t146;
  tvtau0 = t9 * (t438 - t444 + t451 + t460);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t462 = t2 * t21;
  t463 = t27 * t40;
  t464 = t462 * t463;
  t466 = 0.5e1 / 0.9e1 * t464 * t436;
  t467 = params->c * t21;
  t468 = t467 * t27;
  t471 = 0.5e2 / 0.81e2 * t190 * t439 * t468;
  t472 = t62 * t21;
  t473 = t27 * t146;
  t474 = t472 * t473;
  t475 = t445 * t474;
  t477 = 0.5e1 / 0.72e2 * t154 * t475;
  t478 = t462 * t27;
  t479 = t478 * t453;
  t484 = -0.5e1 / 0.9e1 * t479 + 0.5e2 / 0.81e2 * t324 * t325 * t468;
  t485 = t484 * t146;
  tvtau1 = t9 * (t466 - t471 + t477 + t485);

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t493 = t158 * rho[0];
  t495 = 0.1e1 / t4 / t493;
  t496 = tau[0] * t495;
  t498 = 0.4e2 / 0.9e1 * t496 * t16;
  t500 = 0.5e2 / 0.9e1 * t161 * t168;
  t501 = 0.1e1 / t14;
  t502 = t167 * t167;
  t503 = t501 * t502;
  t505 = 0.1e2 / 0.9e1 * t7 * t503;
  t506 = 0.1e1 / t175;
  t507 = t8 * t506;
  t508 = -t164 + t507;
  t509 = t15 * t508;
  t511 = 0.5e1 / 0.3e1 * t7 * t509;
  t512 = 0.1e1 / t25;
  t513 = t171 * t171;
  t514 = t512 * t513;
  t516 = 0.1e2 / 0.9e1 * t22 * t514;
  t517 = -t508;
  t518 = t26 * t517;
  t520 = 0.5e1 / 0.3e1 * t22 * t518;
  t521 = 0.11e2 / 0.9e1 * t59;
  t522 = t498 - t500 + t505 + t511 + t516 + t520 - t521;
  t523 = t2 * t522;
  t524 = t523 * t45;
  t525 = t524 * t148;
  t526 = 0.5e1 / 0.9e1 * t525;
  t527 = t180 * t180;
  t528 = t2 * t527;
  t529 = t528 * t188;
  t530 = t147 * params->c;
  t531 = t325 * t530;
  t532 = t529 * t531;
  t533 = 0.1e3 / 0.81e2 * t532;
  t534 = t182 * t218;
  t535 = 0.1e2 / 0.9e1 * t534;
  t536 = t182 * t318;
  t537 = 0.1e2 / 0.9e1 * t536;
  t538 = t41 * t41;
  t539 = 0.1e1 / t538;
  t541 = 0.1e1 / t191 / t53;
  t542 = t539 * t541;
  t543 = t39 * t542;
  t544 = params->c * params->c;
  t545 = t544 * t527;
  t546 = t147 * t545;
  t547 = t543 * t546;
  t548 = 0.2e4 / 0.243e3 * t547;
  t549 = t192 * t216;
  t550 = t549 * t195;
  t551 = t190 * t550;
  t552 = 0.1e3 / 0.81e2 * t551;
  t553 = t316 * params->c;
  t554 = t553 * t180;
  t555 = t193 * t554;
  t556 = t190 * t555;
  t557 = 0.1e3 / 0.81e2 * t556;
  t558 = t194 * t522;
  t559 = t193 * t558;
  t560 = t190 * t559;
  t561 = 0.5e2 / 0.81e2 * t560;
  t562 = t56 * t31;
  t564 = 0.1e1 / t33 / t562;
  t565 = t30 * t564;
  t567 = 0.119e3 / 0.36e2 * t565 * t63;
  t568 = t202 * t210;
  t571 = 0.7e1 / 0.3e1 * t202 * t213;
  t573 = 0.1e1 / t205 / t60;
  t574 = t573 * t62;
  t575 = t209 * t209;
  t576 = t574 * t575;
  t579 = t206 * t8;
  t580 = t579 * t209;
  t581 = t59 * t580;
  t583 = t498 - t500 + t505 + t511 + t516 + t520;
  t584 = t207 * t583;
  t588 = t59 * t61 / 0.4e1;
  t589 = -t567 - 0.7e1 / 0.6e1 * t568 + t571 - t59 * t576 / 0.4e1 + t581 / 0.2e1 + t59 * t584 / 0.8e1 - t588;
  t590 = t589 * t146;
  t591 = t55 * t590;
  t592 = t46 * t591;
  t593 = 0.5e1 / 0.9e1 * t592;
  t594 = t216 * t316;
  t595 = t55 * t594;
  t596 = t46 * t595;
  t597 = 0.1e2 / 0.9e1 * t596;
  t598 = t289 * t289;
  t599 = 0.1e1 / t598;
  t600 = t296 * t296;
  t601 = t599 * t600;
  t602 = t137 * t137;
  t603 = 0.1e1 / t602;
  t604 = t601 * t603;
  t606 = 0.17315859105681463759e2 * t311 * t604;
  t607 = t268 * t129;
  t608 = t607 * t313;
  t612 = 0.1e1 / t78 / t75 * t83;
  t613 = t84 * t71;
  t614 = t613 * t35;
  t615 = t612 * t614;
  t618 = 0.1e1 / t32 / t31;
  t619 = t232 * t618;
  t620 = t231 * t619;
  t622 = t72 * t618;
  t623 = t70 * t622;
  t625 = 0.1e1/sqrt(t75);
  t626 = t625 * t83;
  t627 = t626 * t614;
  t629 = t239 * t619;
  t632 = t85 * t71 * t35;
  t634 = -0.57538888888888888889e0 * t615 + 0.11507777777777777778e1 * t620 + 0.40256666666666666667e0 * t623 + 0.366775e-1 * t627 + 0.73355e-1 * t629 + 0.137975e0 * t632;
  t636 = t290 * t634 * t297;
  t638 = 0.5848223622634646207e0 * t311 * t636;
  t639 = t103 * t103;
  t640 = 0.1e1 / t639;
  t641 = t166 * t166;
  t644 = 0.2e1 * t508;
  t648 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t640 * t641 + 0.4e1 / 0.3e1 * t103 * t644);
  t649 = t107 * t107;
  t650 = 0.1e1 / t649;
  t651 = t263 * t263;
  t654 = -t644;
  t658 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t650 * t651 + 0.4e1 / 0.3e1 * t107 * t654);
  t660 = (t648 + t658) * t113;
  t669 = -0.42198333333333333333e0 * t615 + 0.84396666666666666666e0 * t620 + 0.39862222222222222223e0 * t623 + 0.68258333333333333333e-1 * t627 + 0.13651666666666666667e0 * t629 + 0.13692777777777777778e0 * t632;
  t670 = t669 * t248;
  t672 = 0.1e1 * t229 * t670;
  t673 = t227 * t227;
  t674 = 0.1e1 / t673;
  t675 = t77 * t674;
  t676 = t247 * t247;
  t677 = t93 * t93;
  t678 = 0.1e1 / t677;
  t679 = t676 * t678;
  t681 = 0.16081979498692535067e2 * t675 * t679;
  t685 = t70 * t72;
  t686 = t222 * t275;
  t690 = t274 * t121;
  t691 = 0.1e1 / t690;
  t692 = t116 * t691;
  t693 = t281 * t281;
  t694 = t693 * t282;
  t703 = -0.78438333333333333333e0 * t615 + 0.15687666666666666667e1 * t620 + 0.68863333333333333333e0 * t623 + 0.14025833333333333333e0 * t627 + 0.28051666666666666667e0 * t629 + 0.17365833333333333333e0 * t632;
  t704 = t703 * t282;
  t707 = t274 * t274;
  t708 = 0.1e1 / t707;
  t709 = t116 * t708;
  t710 = t124 * t124;
  t711 = 0.1e1 / t710;
  t712 = t693 * t711;
  t717 = 0.14764627977777777777e-2 * t70 * t622 * t94;
  t718 = t222 * t228;
  t721 = 0.35616666666666666666e-1 * t685 * t718 * t249;
  t722 = t227 * t90;
  t723 = 0.1e1 / t722;
  t724 = t77 * t723;
  t725 = t676 * t248;
  t727 = 0.2e1 * t724 * t725;
  t731 = t222 * t290;
  t735 = t289 * t134;
  t736 = 0.1e1 / t735;
  t737 = t129 * t736;
  t738 = t600 * t297;
  t741 = t634 * t297;
  t744 = t129 * t599;
  t745 = t600 * t603;
  t748 = -0.70983522622222222221e-3 * t70 * t622 * t125 - 0.34246666666666666666e-1 * t685 * t686 * t283 - 0.2e1 * t692 * t694 + 0.1e1 * t276 * t704 + 0.32163958997385070134e2 * t709 * t712 + t717 + t721 + t727 - t672 - t681 - 0.24415263074675393405e-3 * t70 * t622 * t138 - 0.10843581300301739842e-1 * t685 * t731 * t298 - 0.11696447245269292414e1 * t737 * t738 + 0.5848223622634646207e0 * t291 * t741 + 0.17315859105681463759e2 * t744 * t745;
  t749 = t114 * t748;
  t750 = t99 * t749;
  t751 = t660 * t141;
  t753 = t268 * t301;
  t754 = t99 * t753;
  t756 = t257 * t269;
  t759 = 0.8e1 * t257 * t302;
  t760 = -t606 - 0.11696447245269292414e1 * t608 - t638 + 0.19751673498613801407e-1 * t660 * t139 + t672 + t681 + t750 + t99 * t751 + 0.2e1 * t754 - 0.8e1 * t756 - t759;
  t761 = t253 * t269;
  t764 = 0.8e1 * t253 * t302;
  t766 = t232 * t618 * t138;
  t768 = 0.24415263074675393405e-3 * t306 * t766;
  t769 = 0.1e1 / t562;
  t770 = t97 * t769;
  t772 = 0.2e2 * t770 * t142;
  t773 = t62 * t98;
  t775 = 0.12e2 * t773 * t142;
  t776 = t252 * t256;
  t778 = 0.32e2 * t776 * t142;
  t779 = t114 * t70;
  t780 = t223 * t313;
  t782 = 0.10843581300301739842e-1 * t779 * t780;
  t783 = t268 * t67;
  t784 = t783 * t308;
  t787 = t736 * t600 * t297;
  t789 = 0.11696447245269292414e1 * t311 * t787;
  t790 = 0.8e1 * t761 + t764 - t727 + t768 + t772 + t775 - t778 - t717 + t782 - 0.36622894612013090108e-3 * t784 + t789 - t721;
  t791 = t760 + t790;
  t792 = t66 * t791;
  t793 = t55 * t792;
  t794 = t46 * t793;
  t795 = 0.5e1 / 0.9e1 * t794;
  t796 = t523 * t40;
  t797 = t796 * t153;
  t799 = t528 * t185;
  t800 = t187 * t47;
  t801 = t192 * params->c;
  t802 = t800 * t801;
  t805 = t39 * t539;
  t806 = t541 * t544;
  t807 = t806 * t527;
  t810 = params->c * t522;
  t811 = t325 * t810;
  t814 = -0.5e1 / 0.9e1 * t797 + 0.1e3 / 0.81e2 * t799 * t802 - 0.2e4 / 0.243e3 * t805 * t807 + 0.5e2 / 0.81e2 * t324 * t811;
  t815 = t814 * t146;
  t816 = t330 * t316;
  t817 = 0.2e1 * t816;
  t818 = t156 * t791;
  t819 = t526 - t533 + t535 + t537 + t548 - t552 - t557 - t561 + t593 + t597 + t795 + t815 + t817 + t818;
  tv2rho20 = 0.1e2 / 0.9e1 * t183 - 0.1e3 / 0.81e2 * t197 + 0.1e2 / 0.9e1 * t219 + 0.1e2 / 0.9e1 * t319 + 0.2e1 * t331 + 0.2e1 * t332 + t9 * t819;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t822 = 0.25e2 / 0.9e1 * t161 * t337;
  t823 = t501 * t336;
  t824 = t823 * t167;
  t826 = 0.1e2 / 0.9e1 * t7 * t824;
  t827 = t15 * t8;
  t828 = t827 * t506;
  t830 = 0.5e1 / 0.3e1 * t7 * t828;
  t832 = 0.25e2 / 0.9e1 * t343 * t172;
  t833 = t512 * t346;
  t834 = t833 * t171;
  t836 = 0.1e2 / 0.9e1 * t22 * t834;
  t837 = t26 * t8;
  t838 = t837 * t506;
  t840 = 0.5e1 / 0.3e1 * t22 * t838;
  t841 = -t822 + t826 + t830 - t832 + t836 - t840 - t521;
  t842 = t2 * t841;
  t843 = t842 * t45;
  t844 = t843 * t148;
  t846 = t351 * t189;
  t847 = t846 * t196;
  t849 = t352 * t218;
  t851 = t352 * t318;
  t853 = t544 * t350;
  t854 = t853 * t180;
  t855 = t147 * t854;
  t856 = t543 * t855;
  t858 = t549 * t355;
  t859 = t190 * t858;
  t861 = t553 * t350;
  t862 = t193 * t861;
  t863 = t190 * t862;
  t865 = t194 * t841;
  t866 = t193 * t865;
  t867 = t190 * t866;
  t869 = t182 * t366;
  t871 = t192 * t364;
  t872 = t871 * t195;
  t873 = t190 * t872;
  t876 = t202 * t361;
  t878 = t59 * t573;
  t879 = t62 * t360;
  t880 = t879 * t209;
  t883 = t579 * t360;
  t884 = t59 * t883;
  t886 = -t822 + t826 + t830 - t832 + t836 - t840;
  t887 = t207 * t886;
  t891 = -t567 - 0.7e1 / 0.12e2 * t568 - 0.7e1 / 0.12e2 * t876 - t878 * t880 / 0.4e1 + t884 / 0.4e1 + t59 * t887 / 0.8e1 - t581 / 0.4e1 + t588;
  t892 = t891 * t146;
  t893 = t55 * t892;
  t894 = t46 * t893;
  t896 = t364 * t316;
  t897 = t55 * t896;
  t898 = t46 * t897;
  t900 = t182 * t384;
  t902 = t382 * params->c;
  t903 = t902 * t180;
  t904 = t193 * t903;
  t905 = t190 * t904;
  t907 = t216 * t382;
  t908 = t55 * t907;
  t909 = t46 * t908;
  t911 = t257 * t378;
  t913 = t253 * t378;
  t915 = t640 * t335;
  t918 = t103 * t8;
  t922 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t915 * t166 + 0.8e1 / 0.3e1 * t918 * t506);
  t923 = t650 * t372;
  t926 = t107 * t8;
  t930 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t923 * t263 - 0.8e1 / 0.3e1 * t926 * t506);
  t932 = (t922 + t930) * t113;
  t933 = t932 * t141;
  t935 = t377 * t301;
  t936 = t99 * t935;
  t937 = t377 * t67;
  t938 = t937 * t308;
  t941 = t789 - 0.4e1 * t911 + 0.4e1 * t913 + t99 * t933 + t936 + t782 - 0.18311447306006545054e-3 * t938 - t721 + t768 - 0.18311447306006545054e-3 * t784 + t772 - t775 - t759;
  t945 = t377 * t129;
  t946 = t945 * t313;
  t950 = -0.4e1 * t761 + t754 - 0.4e1 * t756 - t727 - t606 - 0.5848223622634646207e0 * t608 - t638 - t717 + t750 + t672 + t681 - 0.5848223622634646207e0 * t946 + 0.19751673498613801407e-1 * t932 * t139;
  t951 = t941 + t950;
  t952 = t66 * t951;
  t953 = t55 * t952;
  t954 = t46 * t953;
  t956 = t842 * t40;
  t957 = t956 * t153;
  t959 = t351 * t188;
  t962 = t350 * t180;
  t963 = t806 * t962;
  t966 = params->c * t841;
  t967 = t325 * t966;
  t970 = -0.5e1 / 0.9e1 * t957 + 0.1e3 / 0.81e2 * t959 * t327 - 0.2e4 / 0.243e3 * t805 * t963 + 0.5e2 / 0.81e2 * t324 * t967;
  t971 = t970 * t146;
  t972 = t394 * t316;
  t973 = t330 * t382;
  t974 = t156 * t951;
  t975 = 0.5e1 / 0.9e1 * t844 - 0.1e3 / 0.81e2 * t847 + 0.5e1 / 0.9e1 * t849 + 0.5e1 / 0.9e1 * t851 + 0.2e4 / 0.243e3 * t856 - 0.5e2 / 0.81e2 * t859 - 0.5e2 / 0.81e2 * t863 - 0.5e2 / 0.81e2 * t867 + 0.5e1 / 0.9e1 * t869 - 0.5e2 / 0.81e2 * t873 + 0.5e1 / 0.9e1 * t894 + 0.5e1 / 0.9e1 * t898 + 0.5e1 / 0.9e1 * t900 - 0.5e2 / 0.81e2 * t905 + 0.5e1 / 0.9e1 * t909 + 0.5e1 / 0.9e1 * t954 + t971 + t972 + t973 + t974;
  tv2rho21 = t9 * t975 + t184 - t198 + t220 + t320 + t331 + t332 + t354 - t358 + t368 + t386 + t395 + t396;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t983 = t336 * t336;
  t984 = t501 * t983;
  t986 = 0.1e2 / 0.9e1 * t7 * t984;
  t987 = t164 + t507;
  t988 = t15 * t987;
  t990 = 0.5e1 / 0.3e1 * t7 * t988;
  t991 = t340 * rho[1];
  t993 = 0.1e1 / t19 / t991;
  t994 = tau[1] * t993;
  t996 = 0.4e2 / 0.9e1 * t994 * t27;
  t998 = 0.5e2 / 0.9e1 * t343 * t347;
  t999 = t346 * t346;
  t1000 = t512 * t999;
  t1002 = 0.1e2 / 0.9e1 * t22 * t1000;
  t1003 = -t987;
  t1004 = t26 * t1003;
  t1006 = 0.5e1 / 0.3e1 * t22 * t1004;
  t1007 = t986 + t990 + t996 - t998 + t1002 + t1006 - t521;
  t1008 = t2 * t1007;
  t1009 = t1008 * t45;
  t1010 = t1009 * t148;
  t1011 = 0.5e1 / 0.9e1 * t1010;
  t1012 = t350 * t350;
  t1013 = t2 * t1012;
  t1014 = t1013 * t188;
  t1015 = t1014 * t531;
  t1016 = 0.1e3 / 0.81e2 * t1015;
  t1017 = t352 * t366;
  t1018 = 0.1e2 / 0.9e1 * t1017;
  t1019 = t352 * t384;
  t1020 = 0.1e2 / 0.9e1 * t1019;
  t1021 = t544 * t1012;
  t1022 = t147 * t1021;
  t1023 = t543 * t1022;
  t1024 = 0.2e4 / 0.243e3 * t1023;
  t1025 = t871 * t355;
  t1026 = t190 * t1025;
  t1027 = 0.1e3 / 0.81e2 * t1026;
  t1028 = t902 * t350;
  t1029 = t193 * t1028;
  t1030 = t190 * t1029;
  t1031 = 0.1e3 / 0.81e2 * t1030;
  t1032 = t194 * t1007;
  t1033 = t193 * t1032;
  t1034 = t190 * t1033;
  t1035 = 0.5e2 / 0.81e2 * t1034;
  t1037 = t360 * t360;
  t1038 = t574 * t1037;
  t1042 = t986 + t990 + t996 - t998 + t1002 + t1006;
  t1043 = t207 * t1042;
  t1046 = -t567 - 0.7e1 / 0.6e1 * t876 - t571 - t59 * t1038 / 0.4e1 - t884 / 0.2e1 + t59 * t1043 / 0.8e1 - t588;
  t1047 = t1046 * t146;
  t1048 = t55 * t1047;
  t1049 = t46 * t1048;
  t1050 = 0.5e1 / 0.9e1 * t1049;
  t1051 = t364 * t382;
  t1052 = t55 * t1051;
  t1053 = t46 * t1052;
  t1054 = 0.1e2 / 0.9e1 * t1053;
  t1055 = t335 * t335;
  t1058 = 0.2e1 * t987;
  t1062 = my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t640 * t1055 + 0.4e1 / 0.3e1 * t103 * t1058);
  t1063 = t372 * t372;
  t1066 = -t1058;
  t1070 = my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t650 * t1063 + 0.4e1 / 0.3e1 * t107 * t1066);
  t1072 = (t1062 + t1070) * t113;
  t1073 = t1072 * t141;
  t1081 = t99 * t1073 + 0.19751673498613801407e-1 * t1072 * t139 - 0.11696447245269292414e1 * t946 - 0.8e1 * t911 - 0.8e1 * t913 + 0.2e1 * t936 - t606 - t638 + t672 + t681 + t750;
  t1083 = -t759 - t764 - t727 + t768 + t772 + t775 + t778 - t717 + t782 - 0.36622894612013090108e-3 * t938 + t789 - t721;
  t1084 = t1081 + t1083;
  t1085 = t66 * t1084;
  t1086 = t55 * t1085;
  t1087 = t46 * t1086;
  t1088 = 0.5e1 / 0.9e1 * t1087;
  t1089 = t1008 * t40;
  t1090 = t1089 * t153;
  t1092 = t1013 * t185;
  t1095 = t806 * t1012;
  t1098 = params->c * t1007;
  t1099 = t325 * t1098;
  t1102 = -0.5e1 / 0.9e1 * t1090 + 0.1e3 / 0.81e2 * t1092 * t802 - 0.2e4 / 0.243e3 * t805 * t1095 + 0.5e2 / 0.81e2 * t324 * t1099;
  t1103 = t1102 * t146;
  t1104 = t394 * t382;
  t1105 = 0.2e1 * t1104;
  t1106 = t156 * t1084;
  t1107 = t1011 - t1016 + t1018 + t1020 + t1024 - t1027 - t1031 - t1035 + t1050 + t1054 + t1088 + t1103 + t1105 + t1106;
  tv2rho22 = 0.1e2 / 0.9e1 * t353 - 0.1e3 / 0.81e2 * t357 + 0.1e2 / 0.9e1 * t367 + 0.1e2 / 0.9e1 * t385 + 0.2e1 * t395 + 0.2e1 * t396 + t9 * t1107;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t1109 = t2 * t177;
  t1110 = t1109 * t45;
  t1111 = t1110 * t148;
  t1112 = 0.5e1 / 0.27e2 * t1111;
  t1113 = t399 * t189;
  t1114 = t1113 * t196;
  t1115 = 0.25e2 / 0.162e3 * t1114;
  t1116 = t400 * t218;
  t1117 = 0.5e1 / 0.72e2 * t1116;
  t1118 = t400 * t318;
  t1119 = 0.5e1 / 0.72e2 * t1118;
  t1120 = t544 * t35;
  t1121 = t1120 * t180;
  t1122 = t147 * t1121;
  t1123 = t543 * t1122;
  t1124 = 0.25e3 / 0.243e3 * t1123;
  t1126 = t190 * t549 * t403;
  t1127 = 0.25e2 / 0.324e3 * t1126;
  t1128 = t553 * t35;
  t1130 = t190 * t193 * t1128;
  t1131 = 0.25e2 / 0.324e3 * t1130;
  t1132 = t194 * t177;
  t1134 = t190 * t193 * t1132;
  t1135 = 0.5e2 / 0.243e3 * t1134;
  t1136 = t181 * t50;
  t1137 = t1136 * t410;
  t1138 = 0.5e1 / 0.72e2 * t1137;
  t1139 = t39 * t185;
  t1140 = t800 * t192;
  t1141 = t1139 * t1140;
  t1142 = t58 * t61;
  t1143 = t1142 * t62;
  t1144 = t1143 * t195;
  t1145 = t1141 * t1144;
  t1146 = 0.25e2 / 0.324e3 * t1145;
  t1147 = t54 * t201;
  t1148 = t1147 * t409;
  t1149 = t407 * t1148;
  t1150 = 0.35e2 / 0.108e3 * t1149;
  t1151 = t408 * t206;
  t1152 = t62 * t146;
  t1153 = t1152 * t209;
  t1154 = t1151 * t1153;
  t1155 = t407 * t1154;
  t1156 = 0.5e1 / 0.72e2 * t1155;
  t1157 = t213 * t146;
  t1158 = t408 * t1157;
  t1159 = t407 * t1158;
  t1160 = 0.5e1 / 0.36e2 * t1159;
  t1161 = t63 * t316;
  t1162 = t408 * t1161;
  t1163 = t407 * t1162;
  t1164 = 0.5e1 / 0.72e2 * t1163;
  t1166 = t1109 * t40 * t153;
  t1167 = 0.5e1 / 0.27e2 * t1166;
  t1168 = t399 * t188;
  t1169 = t1168 * t327;
  t1171 = t35 * t180;
  t1172 = t806 * t1171;
  t1173 = t805 * t1172;
  t1175 = params->c * t177;
  t1177 = t324 * t325 * t1175;
  t1178 = 0.5e2 / 0.243e3 * t1177;
  t1179 = -t1167 - 0.25e2 / 0.162e3 * t1169 + 0.25e3 / 0.243e3 * t1173 + t1178;
  t1180 = t1179 * t146;
  t1181 = t420 * t316;
  t1182 = t1112 + t1115 - t1117 - t1119 - t1124 + t1127 + t1131 - t1135 - t1138 + t1146 + t1150 + t1156 - t1160 - t1164 + t1180 + t1181;
  tv2rhosigma0 = t9 * t1182 - t402 + t406 - t412 + t421;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t1184 = 0.1e2 / 0.27e2 * t1111;
  t1185 = 0.25e2 / 0.81e2 * t1114;
  t1186 = 0.5e1 / 0.36e2 * t1116;
  t1187 = 0.5e1 / 0.36e2 * t1118;
  t1188 = 0.5e3 / 0.243e3 * t1123;
  t1189 = 0.25e2 / 0.162e3 * t1126;
  t1190 = 0.25e2 / 0.162e3 * t1130;
  t1191 = 0.1e3 / 0.243e3 * t1134;
  t1192 = 0.5e1 / 0.36e2 * t1137;
  t1193 = 0.25e2 / 0.162e3 * t1145;
  t1194 = 0.35e2 / 0.54e2 * t1149;
  t1195 = 0.5e1 / 0.36e2 * t1155;
  t1196 = 0.5e1 / 0.18e2 * t1159;
  t1197 = 0.5e1 / 0.36e2 * t1163;
  t1198 = 0.1e2 / 0.27e2 * t1166;
  t1201 = 0.1e3 / 0.243e3 * t1177;
  t1202 = -t1198 - 0.25e2 / 0.81e2 * t1169 + 0.5e3 / 0.243e3 * t1173 + t1201;
  t1203 = t1202 * t146;
  t1204 = t428 * t316;
  t1205 = t1184 + t1185 - t1186 - t1187 - t1188 + t1189 + t1190 - t1191 - t1192 + t1193 + t1194 + t1195 - t1196 - t1197 + t1203 + t1204;
  tv2rhosigma1 = t9 * t1205 - t423 + t424 - t425 + t429;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t1207 = t1113 * t356;
  t1208 = 0.25e2 / 0.162e3 * t1207;
  t1209 = t400 * t366;
  t1210 = 0.5e1 / 0.72e2 * t1209;
  t1211 = t400 * t384;
  t1212 = 0.5e1 / 0.72e2 * t1211;
  t1213 = t1120 * t350;
  t1214 = t147 * t1213;
  t1215 = t543 * t1214;
  t1216 = 0.25e3 / 0.243e3 * t1215;
  t1218 = t190 * t871 * t403;
  t1219 = 0.25e2 / 0.324e3 * t1218;
  t1220 = t902 * t35;
  t1222 = t190 * t193 * t1220;
  t1223 = 0.25e2 / 0.324e3 * t1222;
  t1224 = t351 * t50;
  t1225 = t1224 * t410;
  t1226 = 0.5e1 / 0.72e2 * t1225;
  t1227 = t1143 * t355;
  t1228 = t1141 * t1227;
  t1229 = 0.25e2 / 0.324e3 * t1228;
  t1230 = t1152 * t360;
  t1231 = t1151 * t1230;
  t1232 = t407 * t1231;
  t1233 = 0.5e1 / 0.72e2 * t1232;
  t1234 = t63 * t382;
  t1235 = t408 * t1234;
  t1236 = t407 * t1235;
  t1237 = 0.5e1 / 0.72e2 * t1236;
  t1238 = t1168 * t391;
  t1240 = t35 * t350;
  t1241 = t806 * t1240;
  t1242 = t805 * t1241;
  t1244 = -t1167 - 0.25e2 / 0.162e3 * t1238 + 0.25e3 / 0.243e3 * t1242 + t1178;
  t1245 = t1244 * t146;
  t1246 = t420 * t382;
  t1247 = t1112 + t1208 - t1210 - t1212 - t1216 + t1219 + t1223 - t1135 - t1226 + t1229 + t1150 + t1233 + t1160 - t1237 + t1245 + t1246;
  tv2rhosigma3 = t9 * t1247 - t402 + t406 - t412 + t421;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  t1249 = 0.25e2 / 0.81e2 * t1207;
  t1250 = 0.5e1 / 0.36e2 * t1209;
  t1251 = 0.5e1 / 0.36e2 * t1211;
  t1252 = 0.5e3 / 0.243e3 * t1215;
  t1253 = 0.25e2 / 0.162e3 * t1218;
  t1254 = 0.25e2 / 0.162e3 * t1222;
  t1255 = 0.5e1 / 0.36e2 * t1225;
  t1256 = 0.25e2 / 0.162e3 * t1228;
  t1257 = 0.5e1 / 0.36e2 * t1232;
  t1258 = 0.5e1 / 0.36e2 * t1236;
  t1261 = -t1198 - 0.25e2 / 0.81e2 * t1238 + 0.5e3 / 0.243e3 * t1242 + t1201;
  t1262 = t1261 * t146;
  t1263 = t428 * t382;
  t1264 = t1184 + t1249 - t1250 - t1251 - t1252 + t1253 + t1254 - t1191 - t1255 + t1256 + t1194 + t1257 + t1196 - t1258 + t1262 + t1263;
  tv2rhosigma4 = t9 * t1264 - t423 + t424 - t425 + t429;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t1266 = t2 * t160;
  t1267 = t1266 * t432;
  t1268 = t1267 * t436;
  t1269 = 0.25e2 / 0.27e2 * t1268;
  t1270 = t15 * t40;
  t1271 = t1270 * t44;
  t1272 = t431 * t1271;
  t1274 = t55 * t147 * t167;
  t1275 = t1272 * t1274;
  t1276 = 0.25e2 / 0.27e2 * t1275;
  t1277 = t16 * t185;
  t1278 = t1277 * t187;
  t1279 = t431 * t1278;
  t1280 = t325 * t66;
  t1281 = t1280 * t195;
  t1282 = t1279 * t1281;
  t1283 = 0.1e3 / 0.81e2 * t1282;
  t1284 = t54 * t216;
  t1286 = t152 * t1284 * t146;
  t1287 = t433 * t1286;
  t1288 = 0.5e1 / 0.9e1 * t1287;
  t1290 = t152 * t434 * t316;
  t1291 = t433 * t1290;
  t1292 = 0.5e1 / 0.9e1 * t1291;
  t1293 = t542 * t66;
  t1294 = t39 * t1293;
  t1295 = t146 * t544;
  t1296 = t6 * t16;
  t1297 = t1296 * t180;
  t1298 = t1295 * t1297;
  t1299 = t1294 * t1298;
  t1300 = 0.2e4 / 0.243e3 * t1299;
  t1301 = t549 * t146;
  t1302 = t1301 * t441;
  t1303 = t190 * t1302;
  t1304 = 0.5e2 / 0.81e2 * t1303;
  t1305 = t193 * t316;
  t1306 = t1305 * t441;
  t1307 = t190 * t1306;
  t1308 = 0.5e2 / 0.81e2 * t1307;
  t1309 = params->c * t160;
  t1310 = t1309 * t16;
  t1311 = t439 * t1310;
  t1312 = t190 * t1311;
  t1313 = 0.25e3 / 0.243e3 * t1312;
  t1314 = t6 * t15;
  t1315 = t1314 * t167;
  t1317 = t1141 * t530 * t1315;
  t1318 = 0.25e3 / 0.243e3 * t1317;
  t1319 = t322 * t449;
  t1320 = 0.5e1 / 0.72e2 * t1319;
  t1321 = t192 * t30;
  t1322 = t800 * t1321;
  t1323 = t1139 * t1322;
  t1324 = t58 * t206;
  t1325 = t1324 * t446;
  t1326 = t447 * t326;
  t1327 = t1325 * t1326;
  t1328 = t1323 * t1327;
  t1329 = 0.25e2 / 0.324e3 * t1328;
  t1330 = t202 * t206;
  t1331 = t1330 * t448;
  t1332 = t154 * t1331;
  t1333 = 0.35e2 / 0.108e3 * t1332;
  t1334 = t54 * t30;
  t1335 = t152 * t1334;
  t1336 = t151 * t1335;
  t1337 = t58 * t573;
  t1338 = t1337 * t62;
  t1339 = t146 * t209;
  t1340 = t1296 * t1339;
  t1341 = t1338 * t1340;
  t1342 = t1336 * t1341;
  t1343 = 0.5e1 / 0.36e2 * t1342;
  t1344 = t8 * t6;
  t1345 = t1344 * t447;
  t1346 = t445 * t1345;
  t1347 = t154 * t1346;
  t1348 = 0.5e1 / 0.36e2 * t1347;
  t1349 = t62 * t160;
  t1350 = t1349 * t447;
  t1351 = t445 * t1350;
  t1352 = t154 * t1351;
  t1353 = 0.25e2 / 0.216e3 * t1352;
  t1354 = t1324 * t62;
  t1355 = t146 * t167;
  t1356 = t1314 * t1355;
  t1357 = t1354 * t1356;
  t1358 = t1336 * t1357;
  t1359 = 0.25e2 / 0.216e3 * t1358;
  t1360 = t16 * t316;
  t1361 = t446 * t1360;
  t1362 = t445 * t1361;
  t1363 = t154 * t1362;
  t1364 = 0.5e1 / 0.72e2 * t1363;
  t1365 = t1266 * t16;
  t1368 = t431 * t1270;
  t1369 = t54 * t167;
  t1370 = t152 * t1369;
  t1373 = t431 * t1277;
  t1375 = t800 * t801 * t180;
  t1378 = t544 * t6;
  t1379 = t16 * t180;
  t1380 = t1378 * t1379;
  t1383 = t325 * t1310;
  t1389 = 0.25e2 / 0.27e2 * t1365 * t453 - 0.25e2 / 0.27e2 * t1368 * t1370 + 0.1e3 / 0.81e2 * t1373 * t1375 - 0.2e4 / 0.243e3 * t543 * t1380 - 0.25e3 / 0.243e3 * t324 * t1383 + 0.25e3 / 0.243e3 * t190 * t801 * t1315;
  t1390 = t1389 * t146;
  t1391 = t459 * t316;
  t1392 = -t1269 + t1276 - t1283 + t1288 + t1292 + t1300 - t1304 - t1308 + t1313 - t1318 + t1320 - t1329 - t1333 - t1343 + t1348 - t1353 + t1359 + t1364 + t1390 + t1391;
  tv2rhotau0 = t9 * t1392 + t438 - t444 + t451 + t460;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t1394 = t26 * t40;
  t1395 = t1394 * t44;
  t1396 = t462 * t1395;
  t1398 = t55 * t147 * t171;
  t1399 = t1396 * t1398;
  t1400 = 0.25e2 / 0.27e2 * t1399;
  t1401 = t27 * t185;
  t1402 = t1401 * t187;
  t1403 = t462 * t1402;
  t1404 = t1403 * t1281;
  t1405 = 0.1e3 / 0.81e2 * t1404;
  t1406 = t464 * t1286;
  t1407 = 0.5e1 / 0.9e1 * t1406;
  t1408 = t464 * t1290;
  t1409 = 0.5e1 / 0.9e1 * t1408;
  t1410 = t21 * t27;
  t1411 = t1410 * t180;
  t1412 = t1295 * t1411;
  t1413 = t1294 * t1412;
  t1414 = 0.2e4 / 0.243e3 * t1413;
  t1416 = t190 * t1301 * t468;
  t1417 = 0.5e2 / 0.81e2 * t1416;
  t1419 = t190 * t1305 * t468;
  t1420 = 0.5e2 / 0.81e2 * t1419;
  t1421 = t21 * t26;
  t1422 = t1421 * t171;
  t1424 = t1141 * t530 * t1422;
  t1425 = 0.25e3 / 0.243e3 * t1424;
  t1426 = t322 * t475;
  t1427 = 0.5e1 / 0.72e2 * t1426;
  t1428 = t1324 * t472;
  t1429 = t473 * t326;
  t1430 = t1428 * t1429;
  t1431 = t1323 * t1430;
  t1432 = 0.25e2 / 0.324e3 * t1431;
  t1433 = t1330 * t474;
  t1434 = t154 * t1433;
  t1435 = 0.35e2 / 0.108e3 * t1434;
  t1436 = t1410 * t1339;
  t1437 = t1338 * t1436;
  t1438 = t1336 * t1437;
  t1439 = 0.5e1 / 0.36e2 * t1438;
  t1440 = t8 * t21;
  t1441 = t1440 * t473;
  t1442 = t445 * t1441;
  t1443 = t154 * t1442;
  t1444 = 0.5e1 / 0.36e2 * t1443;
  t1445 = t146 * t171;
  t1446 = t1421 * t1445;
  t1447 = t1354 * t1446;
  t1448 = t1336 * t1447;
  t1449 = 0.25e2 / 0.216e3 * t1448;
  t1450 = t27 * t316;
  t1451 = t472 * t1450;
  t1452 = t445 * t1451;
  t1453 = t154 * t1452;
  t1454 = 0.5e1 / 0.72e2 * t1453;
  t1455 = t462 * t1394;
  t1456 = t54 * t171;
  t1457 = t152 * t1456;
  t1460 = t462 * t1401;
  t1463 = t544 * t21;
  t1464 = t27 * t180;
  t1465 = t1463 * t1464;
  t1471 = -0.25e2 / 0.27e2 * t1455 * t1457 + 0.1e3 / 0.81e2 * t1460 * t1375 - 0.2e4 / 0.243e3 * t543 * t1465 + 0.25e3 / 0.243e3 * t190 * t801 * t1422;
  t1472 = t1471 * t146;
  t1473 = t484 * t316;
  t1474 = t1400 - t1405 + t1407 + t1409 + t1414 - t1417 - t1420 - t1425 + t1427 - t1432 - t1435 - t1439 + t1444 + t1449 + t1454 + t1472 + t1473;
  tv2rhotau1 = t9 * t1474 + t466 - t471 + t477 + t485;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1477 = t55 * t147 * t336;
  t1478 = t1272 * t1477;
  t1479 = 0.25e2 / 0.27e2 * t1478;
  t1480 = t1280 * t355;
  t1481 = t1279 * t1480;
  t1482 = 0.1e3 / 0.81e2 * t1481;
  t1483 = t54 * t364;
  t1485 = t152 * t1483 * t146;
  t1486 = t433 * t1485;
  t1487 = 0.5e1 / 0.9e1 * t1486;
  t1489 = t152 * t434 * t382;
  t1490 = t433 * t1489;
  t1491 = 0.5e1 / 0.9e1 * t1490;
  t1492 = t1296 * t350;
  t1493 = t1295 * t1492;
  t1494 = t1294 * t1493;
  t1495 = 0.2e4 / 0.243e3 * t1494;
  t1496 = t871 * t146;
  t1497 = t1496 * t441;
  t1498 = t190 * t1497;
  t1499 = 0.5e2 / 0.81e2 * t1498;
  t1500 = t193 * t382;
  t1501 = t1500 * t441;
  t1502 = t190 * t1501;
  t1503 = 0.5e2 / 0.81e2 * t1502;
  t1504 = t1314 * t336;
  t1506 = t1141 * t530 * t1504;
  t1507 = 0.25e3 / 0.243e3 * t1506;
  t1508 = t388 * t449;
  t1509 = 0.5e1 / 0.72e2 * t1508;
  t1510 = t447 * t390;
  t1511 = t1325 * t1510;
  t1512 = t1323 * t1511;
  t1513 = 0.25e2 / 0.324e3 * t1512;
  t1514 = t146 * t360;
  t1515 = t1296 * t1514;
  t1516 = t1338 * t1515;
  t1517 = t1336 * t1516;
  t1518 = 0.5e1 / 0.36e2 * t1517;
  t1519 = t146 * t336;
  t1520 = t1314 * t1519;
  t1521 = t1354 * t1520;
  t1522 = t1336 * t1521;
  t1523 = 0.25e2 / 0.216e3 * t1522;
  t1524 = t16 * t382;
  t1525 = t446 * t1524;
  t1526 = t445 * t1525;
  t1527 = t154 * t1526;
  t1528 = 0.5e1 / 0.72e2 * t1527;
  t1529 = t54 * t336;
  t1530 = t152 * t1529;
  t1534 = t800 * t801 * t350;
  t1537 = t16 * t350;
  t1538 = t1378 * t1537;
  t1544 = -0.25e2 / 0.27e2 * t1368 * t1530 + 0.1e3 / 0.81e2 * t1373 * t1534 - 0.2e4 / 0.243e3 * t543 * t1538 + 0.25e3 / 0.243e3 * t190 * t801 * t1504;
  t1545 = t1544 * t146;
  t1546 = t459 * t382;
  t1547 = t1479 - t1482 + t1487 + t1491 + t1495 - t1499 - t1503 - t1507 + t1509 - t1513 - t1333 - t1518 - t1348 + t1523 + t1528 + t1545 + t1546;
  tv2rhotau2 = t9 * t1547 + t438 - t444 + t451 + t460;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1549 = t2 * t342;
  t1550 = t1549 * t463;
  t1551 = t1550 * t436;
  t1552 = 0.25e2 / 0.27e2 * t1551;
  t1554 = t55 * t147 * t346;
  t1555 = t1396 * t1554;
  t1556 = 0.25e2 / 0.27e2 * t1555;
  t1557 = t1403 * t1480;
  t1558 = 0.1e3 / 0.81e2 * t1557;
  t1559 = t464 * t1485;
  t1560 = 0.5e1 / 0.9e1 * t1559;
  t1561 = t464 * t1489;
  t1562 = 0.5e1 / 0.9e1 * t1561;
  t1563 = t1410 * t350;
  t1564 = t1295 * t1563;
  t1565 = t1294 * t1564;
  t1566 = 0.2e4 / 0.243e3 * t1565;
  t1568 = t190 * t1496 * t468;
  t1569 = 0.5e2 / 0.81e2 * t1568;
  t1571 = t190 * t1500 * t468;
  t1572 = 0.5e2 / 0.81e2 * t1571;
  t1573 = params->c * t342;
  t1574 = t1573 * t27;
  t1576 = t190 * t439 * t1574;
  t1577 = 0.25e3 / 0.243e3 * t1576;
  t1578 = t1421 * t346;
  t1580 = t1141 * t530 * t1578;
  t1581 = 0.25e3 / 0.243e3 * t1580;
  t1582 = t388 * t475;
  t1583 = 0.5e1 / 0.72e2 * t1582;
  t1584 = t473 * t390;
  t1585 = t1428 * t1584;
  t1586 = t1323 * t1585;
  t1587 = 0.25e2 / 0.324e3 * t1586;
  t1588 = t1410 * t1514;
  t1589 = t1338 * t1588;
  t1590 = t1336 * t1589;
  t1591 = 0.5e1 / 0.36e2 * t1590;
  t1592 = t62 * t342;
  t1593 = t1592 * t473;
  t1594 = t445 * t1593;
  t1595 = t154 * t1594;
  t1596 = 0.25e2 / 0.216e3 * t1595;
  t1597 = t146 * t346;
  t1598 = t1421 * t1597;
  t1599 = t1354 * t1598;
  t1600 = t1336 * t1599;
  t1601 = 0.25e2 / 0.216e3 * t1600;
  t1602 = t27 * t382;
  t1603 = t472 * t1602;
  t1604 = t445 * t1603;
  t1605 = t154 * t1604;
  t1606 = 0.5e1 / 0.72e2 * t1605;
  t1607 = t1549 * t27;
  t1608 = t1607 * t453;
  t1610 = t54 * t346;
  t1611 = t152 * t1610;
  t1616 = t27 * t350;
  t1617 = t1463 * t1616;
  t1626 = 0.25e2 / 0.27e2 * t1608 - 0.25e2 / 0.27e2 * t1455 * t1611 + 0.1e3 / 0.81e2 * t1460 * t1534 - 0.2e4 / 0.243e3 * t543 * t1617 - 0.25e3 / 0.243e3 * t324 * t325 * t1574 + 0.25e3 / 0.243e3 * t190 * t801 * t1578;
  t1627 = t1626 * t146;
  t1628 = t484 * t382;
  t1629 = -t1552 + t1556 - t1558 + t1560 + t1562 + t1566 - t1569 - t1572 + t1577 - t1581 + t1583 - t1587 - t1435 - t1591 - t1444 - t1596 + t1601 + t1606 + t1627 + t1628;
  tv2rhotau3 = t9 * t1629 + t466 - t471 + t477 + t485;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1632 = 0.1e1 / t32 / t199;
  t1633 = t2 * t1632;
  t1634 = t1633 * t188;
  t1635 = t1634 * t531;
  t1636 = 0.25e2 / 0.1296e4 * t1635;
  t1637 = t56 * t175;
  t1639 = 0.1e1 / t32 / t1637;
  t1640 = t2 * t1639;
  t1641 = t1640 * t45;
  t1642 = t55 * t409;
  t1643 = t1641 * t1642;
  t1644 = 0.5e1 / 0.288e3 * t1643;
  t1645 = t544 * t1632;
  t1647 = t543 * t147 * t1645;
  t1648 = 0.125e3 / 0.972e3 * t1647;
  t1649 = t192 * t1639;
  t1650 = t1649 * t61;
  t1651 = t1152 * params->c;
  t1652 = t1650 * t1651;
  t1653 = t190 * t1652;
  t1654 = 0.25e2 / 0.1296e4 * t1653;
  t1656 = t1633 * t185 * t802;
  t1659 = t805 * t806 * t1632;
  t1661 = 0.25e2 / 0.1296e4 * t1656 - 0.125e3 / 0.972e3 * t1659;
  t1662 = t1661 * t146;
  tv2sigma20 = t9 * (-t1636 + t1644 + t1648 - t1654 + t1662);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t1664 = 0.25e2 / 0.648e3 * t1635;
  t1665 = 0.5e1 / 0.144e3 * t1643;
  t1666 = 0.125e3 / 0.486e3 * t1647;
  t1667 = 0.25e2 / 0.648e3 * t1653;
  t1670 = 0.25e2 / 0.648e3 * t1656 - 0.125e3 / 0.486e3 * t1659;
  t1671 = t1670 * t146;
  tv2sigma21 = t9 * (-t1664 + t1665 + t1666 - t1667 + t1671);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = tv2sigma20;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  t1673 = 0.25e2 / 0.324e3 * t1635;
  t1674 = 0.5e1 / 0.72e2 * t1643;
  t1675 = 0.125e3 / 0.243e3 * t1647;
  t1676 = 0.25e2 / 0.324e3 * t1653;
  t1679 = 0.25e2 / 0.324e3 * t1656 - 0.125e3 / 0.243e3 * t1659;
  t1680 = t1679 * t146;
  tv2sigma23 = t9 * (-t1673 + t1674 + t1675 - t1676 + t1680);

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = tv2sigma21;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = tv2sigma22;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1682 = t1280 * t403;
  t1683 = t1279 * t1682;
  t1684 = 0.25e2 / 0.162e3 * t1683;
  t1685 = t432 * t44;
  t1686 = t431 * t1685;
  t1687 = t55 * t58;
  t1688 = t1687 * t409;
  t1689 = t1686 * t1688;
  t1690 = 0.5e1 / 0.72e2 * t1689;
  t1691 = t1296 * t35;
  t1692 = t1295 * t1691;
  t1693 = t1294 * t1692;
  t1694 = 0.25e3 / 0.243e3 * t1693;
  t1695 = t194 * t1296;
  t1696 = t1143 * t1695;
  t1697 = t1141 * t1696;
  t1698 = 0.25e2 / 0.324e3 * t1697;
  t1699 = t1640 * t40;
  t1700 = t1699 * t153;
  t1701 = t30 * t206;
  t1702 = t1701 * t62;
  t1703 = t1296 * t146;
  t1704 = t1702 * t1703;
  t1705 = t1700 * t1704;
  t1706 = 0.5e1 / 0.576e3 * t1705;
  t1707 = t1639 * t206;
  t1708 = t1707 * t62;
  t1709 = t1708 * t1695;
  t1710 = t1323 * t1709;
  t1711 = 0.25e2 / 0.2592e4 * t1710;
  t1712 = t1354 * t1703;
  t1713 = t154 * t1712;
  t1714 = 0.5e1 / 0.72e2 * t1713;
  t1716 = t800 * t801 * t35;
  t1717 = t1373 * t1716;
  t1719 = t16 * t35;
  t1721 = t543 * t1378 * t1719;
  t1723 = -0.25e2 / 0.162e3 * t1717 + 0.25e3 / 0.243e3 * t1721;
  t1724 = t1723 * t146;
  tv2sigmatau0 = t9 * (t1684 - t1690 - t1694 + t1698 - t1706 + t1711 + t1714 + t1724);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t1726 = t1403 * t1682;
  t1727 = 0.25e2 / 0.162e3 * t1726;
  t1728 = t463 * t44;
  t1729 = t462 * t1728;
  t1730 = t1729 * t1688;
  t1731 = 0.5e1 / 0.72e2 * t1730;
  t1732 = t1410 * t35;
  t1733 = t1295 * t1732;
  t1734 = t1294 * t1733;
  t1735 = 0.25e3 / 0.243e3 * t1734;
  t1736 = t194 * t1410;
  t1738 = t1141 * t1143 * t1736;
  t1739 = 0.25e2 / 0.324e3 * t1738;
  t1740 = t1410 * t146;
  t1741 = t1702 * t1740;
  t1742 = t1700 * t1741;
  t1743 = 0.5e1 / 0.576e3 * t1742;
  t1744 = t1708 * t1736;
  t1745 = t1323 * t1744;
  t1746 = 0.25e2 / 0.2592e4 * t1745;
  t1747 = t1354 * t1740;
  t1748 = t154 * t1747;
  t1749 = 0.5e1 / 0.72e2 * t1748;
  t1750 = t1460 * t1716;
  t1752 = t27 * t35;
  t1754 = t543 * t1463 * t1752;
  t1756 = -0.25e2 / 0.162e3 * t1750 + 0.25e3 / 0.243e3 * t1754;
  t1757 = t1756 * t146;
  tv2sigmatau1 = t9 * (t1727 - t1731 - t1735 + t1739 - t1743 + t1746 + t1749 + t1757);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  t1759 = 0.25e2 / 0.81e2 * t1683;
  t1760 = 0.5e1 / 0.36e2 * t1689;
  t1761 = 0.5e3 / 0.243e3 * t1693;
  t1762 = 0.25e2 / 0.162e3 * t1697;
  t1763 = 0.5e1 / 0.288e3 * t1705;
  t1764 = 0.25e2 / 0.1296e4 * t1710;
  t1765 = 0.5e1 / 0.36e2 * t1713;
  t1768 = -0.25e2 / 0.81e2 * t1717 + 0.5e3 / 0.243e3 * t1721;
  t1769 = t1768 * t146;
  tv2sigmatau2 = t9 * (t1759 - t1760 - t1761 + t1762 - t1763 + t1764 + t1765 + t1769);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  t1771 = 0.25e2 / 0.81e2 * t1726;
  t1772 = 0.5e1 / 0.36e2 * t1730;
  t1773 = 0.5e3 / 0.243e3 * t1734;
  t1774 = 0.25e2 / 0.162e3 * t1738;
  t1775 = 0.5e1 / 0.288e3 * t1742;
  t1776 = 0.25e2 / 0.1296e4 * t1745;
  t1777 = 0.5e1 / 0.36e2 * t1748;
  t1780 = -0.25e2 / 0.81e2 * t1750 + 0.5e3 / 0.243e3 * t1754;
  t1781 = t1780 * t146;
  tv2sigmatau3 = t9 * (t1771 - t1772 - t1773 + t1774 - t1775 + t1776 + t1777 + t1781);

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = tv2sigmatau0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = tv2sigmatau1;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1784 = 0.1e1 / t3 / t493;
  t1785 = t2 * t1784;
  t1786 = t13 * t13;
  t1788 = t14 * t1786 * t13;
  t1789 = t1788 * t185;
  t1790 = t1789 * t187;
  t1791 = t1785 * t1790;
  t1793 = 0.1e3 / 0.81e2 * t1791 * t531;
  t1794 = t1785 * t1788;
  t1795 = t1794 * t50;
  t1796 = t1334 * t58;
  t1797 = t207 * t146;
  t1798 = t1796 * t1797;
  t1800 = 0.5e1 / 0.36e2 * t1795 * t1798;
  t1801 = t544 * t1784;
  t1802 = t1801 * t1788;
  t1803 = t147 * t1802;
  t1805 = 0.2e4 / 0.243e3 * t543 * t1803;
  t1806 = t1784 * t1788;
  t1807 = t1806 * t194;
  t1808 = t1354 * t1807;
  t1810 = 0.25e2 / 0.162e3 * t1323 * t1808;
  t1811 = t62 * t1784;
  t1812 = t1788 * t146;
  t1813 = t1811 * t1812;
  t1814 = t878 * t1813;
  t1816 = 0.5e1 / 0.36e2 * t154 * t1814;
  t1820 = t806 * t1806;
  t1823 = 0.1e3 / 0.81e2 * t1785 * t1789 * t802 - 0.2e4 / 0.243e3 * t805 * t1820;
  t1824 = t1823 * t146;
  tv2tau20 = t9 * (-t1793 + t1800 + t1805 - t1810 - t1816 + t1824);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t1826 = t478 * t189;
  t1828 = 0.1e3 / 0.81e2 * t1826 * t442;
  t1830 = 0.5e1 / 0.36e2 * t479 * t449;
  t1831 = t1295 * t21;
  t1832 = t27 * t6;
  t1833 = t1832 * t16;
  t1834 = t1831 * t1833;
  t1836 = 0.2e4 / 0.243e3 * t1294 * t1834;
  t1837 = t325 * t59;
  t1838 = t324 * t1837;
  t1839 = t207 * t1296;
  t1840 = t1839 * t1736;
  t1842 = 0.25e2 / 0.162e3 * t1838 * t1840;
  t1843 = t1337 * t472;
  t1844 = t473 * t1296;
  t1845 = t1843 * t1844;
  t1847 = 0.5e1 / 0.36e2 * t1336 * t1845;
  t1853 = 0.1e3 / 0.81e2 * t1403 * t456 - 0.2e4 / 0.243e3 * t543 * t1463 * t1833;
  t1854 = t1853 * t146;
  tv2tau21 = t9 * (-t1828 + t1830 + t1836 - t1842 - t1847 + t1854);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1857 = 0.1e1 / t18 / t991;
  t1858 = t2 * t1857;
  t1859 = t24 * t24;
  t1861 = t25 * t1859 * t24;
  t1862 = t1861 * t185;
  t1863 = t1862 * t187;
  t1864 = t1858 * t1863;
  t1866 = 0.1e3 / 0.81e2 * t1864 * t531;
  t1867 = t1858 * t1861;
  t1868 = t1867 * t50;
  t1870 = 0.5e1 / 0.36e2 * t1868 * t1798;
  t1871 = t544 * t1857;
  t1872 = t1871 * t1861;
  t1875 = 0.2e4 / 0.243e3 * t543 * t147 * t1872;
  t1876 = t1857 * t1861;
  t1877 = t1876 * t194;
  t1878 = t1354 * t1877;
  t1880 = 0.25e2 / 0.162e3 * t1323 * t1878;
  t1881 = t62 * t1857;
  t1882 = t1861 * t146;
  t1883 = t1881 * t1882;
  t1884 = t878 * t1883;
  t1886 = 0.5e1 / 0.36e2 * t154 * t1884;
  t1887 = t1858 * t1862;
  t1893 = 0.1e3 / 0.81e2 * t1887 * t802 - 0.2e4 / 0.243e3 * t805 * t806 * t1876;
  t1894 = t1893 * t146;
  tv2tau22 = t9 * (-t1866 + t1870 + t1875 - t1880 - t1886 + t1894);

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1896 = t814 * t316;
  t1897 = 0.3e1 * t1896;
  t1898 = t158 * t158;
  t1900 = 0.1e1 / t4 / t1898;
  t1901 = tau[0] * t1900;
  t1903 = 0.44e3 / 0.27e2 * t1901 * t16;
  t1905 = 0.2e3 / 0.9e1 * t496 * t168;
  t1907 = 0.5e2 / 0.9e1 * t161 * t503;
  t1909 = 0.25e2 / 0.3e1 * t161 * t509;
  t1910 = t14 * t13;
  t1911 = 0.1e1 / t1910;
  t1912 = t502 * t167;
  t1913 = t1911 * t1912;
  t1915 = 0.1e2 / 0.27e2 * t7 * t1913;
  t1916 = t501 * t167;
  t1917 = t1916 * t508;
  t1919 = 0.1e2 / 0.3e1 * t7 * t1917;
  t1920 = t8 * t98;
  t1921 = t506 - t1920;
  t1922 = 0.3e1 * t1921;
  t1923 = t15 * t1922;
  t1925 = 0.5e1 / 0.3e1 * t7 * t1923;
  t1926 = t25 * t24;
  t1927 = 0.1e1 / t1926;
  t1928 = t513 * t171;
  t1929 = t1927 * t1928;
  t1931 = 0.1e2 / 0.27e2 * t22 * t1929;
  t1932 = t512 * t171;
  t1933 = t1932 * t517;
  t1935 = 0.1e2 / 0.3e1 * t22 * t1933;
  t1936 = -t1922;
  t1937 = t26 * t1936;
  t1939 = 0.5e1 / 0.3e1 * t22 * t1937;
  t1940 = 0.154e3 / 0.27e2 * t202;
  t1941 = -t1903 + t1905 - t1907 - t1909 - t1915 + t1919 + t1925 - t1931 + t1935 + t1939 + t1940;
  t1942 = t2 * t1941;
  t1944 = t1942 * t40 * t153;
  t1949 = t527 * t180;
  t1950 = t2 * t1949;
  t1951 = t542 * t544;
  t1954 = t191 * t191;
  t1955 = 0.1e1 / t1954;
  t1956 = t539 * t1955;
  t1957 = t39 * t1956;
  t1958 = t544 * params->c;
  t1960 = t1958 * t1949 * t50;
  t1963 = t180 * t522;
  t1964 = t806 * t1963;
  t1967 = params->c * t1941;
  t1968 = t325 * t1967;
  t1971 = -0.5e1 / 0.9e1 * t1944 + 0.1e3 / 0.27e2 * t523 * t188 * t327 - 0.2e4 / 0.81e2 * t1950 * t1951 + 0.1e5 / 0.729e3 * t1957 * t1960 - 0.2e4 / 0.81e2 * t805 * t1964 + 0.5e2 / 0.81e2 * t324 * t1968;
  t1972 = t1971 * t146;
  t1973 = t330 * t791;
  t1974 = 0.3e1 * t1973;
  t1975 = t544 * t180;
  t1976 = t1975 * t522;
  t1977 = t147 * t1976;
  t1978 = t543 * t1977;
  t1979 = 0.2e4 / 0.81e2 * t1978;
  t1980 = t217 * params->c;
  t1981 = t325 * t1980;
  t1982 = t529 * t1981;
  t1983 = 0.1e3 / 0.27e2 * t1982;
  t1984 = t317 * params->c;
  t1985 = t325 * t1984;
  t1986 = t529 * t1985;
  t1987 = 0.1e3 / 0.27e2 * t1986;
  t1988 = t1956 * t66;
  t1989 = t39 * t1988;
  t1990 = t146 * t1958;
  t1992 = t1990 * t1949 * t50;
  t1993 = t1989 * t1992;
  t1994 = 0.1e5 / 0.729e3 * t1993;
  t1995 = t257 * t753;
  t1998 = 0.6e2 * t770 * t302;
  t1999 = t776 * t269;
  t2001 = t770 * t269;
  t2003 = t676 * t247;
  t2004 = t2003 * t248;
  t2006 = 0.6e1 * t675 * t2004;
  t2007 = t660 * t301;
  t2008 = t99 * t2007;
  t2010 = t776 * t302;
  t2011 = 0.96e2 * t2010;
  t2012 = t773 * t302;
  t2013 = 0.36e2 * t2012;
  t2014 = t773 * t269;
  t2017 = 0.1e1 / t639 / t12;
  t2018 = t641 * t166;
  t2021 = t640 * t166;
  t2024 = 0.6e1 * t1921;
  t2028 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t2017 * t2018 + 0.4e1 / 0.3e1 * t2021 * t644 + 0.4e1 / 0.3e1 * t103 * t2024);
  t2030 = 0.1e1 / t649 / t23;
  t2031 = t651 * t263;
  t2034 = t650 * t263;
  t2037 = -t2024;
  t2041 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2030 * t2031 + 0.4e1 / 0.3e1 * t2034 * t654 + 0.4e1 / 0.3e1 * t107 * t2037);
  t2043 = (t2028 + t2041) * t113;
  t2044 = t2043 * t141;
  t2047 = 0.1e1 / t598 / t134;
  t2048 = t600 * t296;
  t2050 = t2047 * t2048 * t603;
  t2052 = 0.10389515463408878255e3 * t311 * t2050;
  t2053 = t607 * t787;
  t2055 = -0.24e2 * t1995 + t1998 - 0.96e2 * t1999 + 0.6e2 * t2001 + t2006 + 0.3e1 * t2008 - t2011 + t2013 + 0.36e2 * t2014 + t99 * t2044 + t2052 + 0.35089341735807877242e1 * t2053;
  t2057 = t603 * t634;
  t2058 = t599 * t296 * t2057;
  t2060 = 0.51947577317044391277e2 * t311 * t2058;
  t2064 = 0.10685e0 * t685 * t222 * t723 * t725;
  t2065 = t618 * t228;
  t2068 = 0.71233333333333333332e-1 * t685 * t2065 * t249;
  t2071 = 0.53424999999999999999e-1 * t685 * t718 * t670;
  t2072 = t222 * t674;
  t2075 = 0.85917975471764868594e0 * t685 * t2072 * t679;
  t2077 = 0.1e1 / t32 / t175;
  t2079 = t232 * t2077 * t138;
  t2081 = 0.56968947174242584612e-3 * t306 * t2079;
  t2083 = t736 * t634 * t298;
  t2085 = 0.35089341735807877242e1 * t311 * t2083;
  t2086 = t660 * t67;
  t2087 = t2086 * t308;
  t2092 = 0.1e1 / t78 / t88 * t68 / 0.4e1;
  t2093 = t2092 * t98;
  t2095 = t613 * t177;
  t2096 = t612 * t2095;
  t2098 = t232 * t2077;
  t2099 = t231 * t2098;
  t2101 = t72 * t2077;
  t2102 = t70 * t2101;
  t2104 = 0.1e1/POW_3_2(t75);
  t2105 = t2104 * t68;
  t2106 = t2105 * t98;
  t2108 = t626 * t2095;
  t2110 = t239 * t2098;
  t2113 = t85 * t71 * t177;
  t2115 = -0.34523333333333333333e1 * t2093 + 0.23015555555555555556e1 * t2096 - 0.26851481481481481482e1 * t2099 - 0.93932222222222222223e0 * t2102 + 0.73355e-1 * t2106 - 0.14671e0 * t2108 - 0.17116166666666666667e0 * t2110 - 0.36793333333333333333e0 * t2113;
  t2117 = t290 * t2115 * t297;
  t2119 = 0.5848223622634646207e0 * t311 * t2117;
  t2121 = 0.1e1 / t598 / t289;
  t2124 = 0.1e1 / t602 / t137;
  t2125 = t2121 * t2048 * t2124;
  t2127 = 0.10254018858216406658e4 * t311 * t2125;
  t2128 = t660 * t129;
  t2129 = t2128 * t313;
  t2131 = t607 * t636;
  t2133 = t607 * t604;
  t2135 = -t2060 + t2064 + t2068 - t2071 - t2075 - t2081 + t2085 - 0.54934341918019635162e-3 * t2087 - t2119 - t2127 - 0.17544670867903938621e1 * t2129 - 0.17544670867903938621e1 * t2131 - 0.51947577317044391276e2 * t2133;
  t2137 = t268 * t748;
  t2138 = t99 * t2137;
  t2140 = t618 * t290;
  t2147 = t222 * t599;
  t2151 = t222 * t736;
  t2159 = t618 * t275;
  t2166 = t222 * t708;
  t2170 = t693 * t281;
  t2171 = t2170 * t282;
  t2174 = t2057 * t296;
  t2177 = t669 * t678;
  t2180 = 0.48245938496077605201e2 * t675 * t2177 * t247;
  t2181 = -t2006 + 0.21687162600603479684e-1 * t685 * t2140 * t298 - 0.16265371950452609763e-1 * t685 * t731 * t741 - 0.48159733137676571078e0 * t685 * t2147 * t745 + 0.32530743900905219526e-1 * t685 * t2151 * t738 + 0.10274e0 * t685 * t222 * t691 * t694 - t2064 - t2068 + t2071 + t2075 + 0.68493333333333333332e-1 * t685 * t2159 * t283 - 0.51369999999999999999e-1 * t685 * t686 * t704 - 0.16522625736956710527e1 * t685 * t2166 * t712 + 0.6e1 * t709 * t2171 + 0.51947577317044391277e2 * t744 * t2174 - t2180;
  t2184 = 0.6e1 * t724 * t670 * t247;
  t2186 = 0.1e1 / t673 / t227;
  t2187 = t77 * t2186;
  t2189 = 0.1e1 / t677 / t93;
  t2190 = t2003 * t2189;
  t2192 = 0.51726012919273400301e3 * t2187 * t2190;
  t2201 = -0.47063e1 * t2093 + 0.31375333333333333334e1 * t2096 - 0.36604555555555555556e1 * t2099 - 0.16068111111111111111e1 * t2102 + 0.28051666666666666666e0 * t2106 - 0.56103333333333333332e0 * t2108 - 0.6545388888888888889e0 * t2110 - 0.46308888888888888888e0 * t2113;
  t2202 = t2201 * t282;
  t2205 = t2048 * t297;
  t2208 = t129 * t2121;
  t2209 = t2048 * t2124;
  t2213 = 0.1e1 / t707 / t274;
  t2214 = t116 * t2213;
  t2216 = 0.1e1 / t710 / t124;
  t2217 = t2170 * t2216;
  t2221 = 0.1e1 / t707 / t121;
  t2222 = t116 * t2221;
  t2223 = t2170 * t711;
  t2238 = 0.34450798614814814813e-2 * t70 * t2101 * t94;
  t2242 = t298 * t634;
  t2245 = t129 * t2047;
  t2246 = t2048 * t603;
  t2249 = t2115 * t297;
  t2253 = 0.1e1 / t673 / t90;
  t2254 = t77 * t2253;
  t2255 = t2003 * t678;
  t2257 = 0.96491876992155210402e2 * t2254 * t2255;
  t2266 = -0.25319e1 * t2093 + 0.16879333333333333333e1 * t2096 - 0.19692555555555555555e1 * t2099 - 0.93011851851851851854e0 * t2102 + 0.13651666666666666667e0 * t2106 - 0.27303333333333333333e0 * t2108 - 0.3185388888888888889e0 * t2110 - 0.36514074074074074075e0 * t2113;
  t2267 = t2266 * t248;
  t2269 = 0.1e1 * t229 * t2267;
  t2270 = t2184 - t2192 + 0.1e1 * t276 * t2202 + 0.35089341735807877242e1 * t744 * t2205 + 0.10254018858216406658e4 * t2208 * t2209 + 0.2069040516770936012e4 * t2214 * t2217 - 0.19298375398431042081e3 * t2222 * t2223 + 0.96491876992155210402e2 * t709 * t703 * t711 * t281 - 0.6e1 * t692 * t283 * t703 + 0.56968947174242584612e-3 * t70 * t2101 * t138 - t2238 + 0.16562821945185185185e-2 * t70 * t2101 * t125 - 0.35089341735807877242e1 * t737 * t2242 - 0.10389515463408878255e3 * t2245 * t2246 + 0.5848223622634646207e0 * t291 * t2249 + t2257 - t2269;
  t2271 = t2181 + t2270;
  t2272 = t114 * t2271;
  t2273 = t99 * t2272;
  t2275 = 0.24e2 * t1920 * t142;
  t2276 = t62 * t256;
  t2277 = t2276 * t142;
  t2278 = 0.144e3 * t2277;
  t2279 = 0.1e1 / t1637;
  t2280 = t97 * t2279;
  t2282 = 0.12e3 * t2280 * t142;
  t2283 = t252 * t769;
  t2284 = t2283 * t142;
  t2285 = 0.24e3 * t2284;
  t2287 = t599 * t2048 * t297;
  t2289 = 0.35089341735807877242e1 * t311 * t2287;
  t2291 = 0.12e2 * t257 * t749;
  t2292 = t253 * t749;
  t2293 = 0.12e2 * t2292;
  t2294 = 0.3e1 * t2138 + t2273 + t2275 - t2278 - t2282 + t2285 + t2180 - t2184 + t2192 - t2289 - t2291 + t2293;
  t2295 = t253 * t753;
  t2297 = t253 * t751;
  t2299 = t257 * t751;
  t2301 = t223 * t787;
  t2303 = 0.32530743900905219526e-1 * t779 * t2301;
  t2304 = t622 * t313;
  t2306 = 0.21687162600603479684e-1 * t779 * t2304;
  t2307 = t223 * t604;
  t2309 = 0.48159733137676571078e0 * t779 * t2307;
  t2310 = t268 * t70;
  t2311 = t2310 * t780;
  t2313 = t223 * t636;
  t2315 = 0.16265371950452609763e-1 * t779 * t2313;
  t2316 = t783 * t766;
  t2320 = t2238 + 0.24e2 * t2295 + 0.12e2 * t2297 - 0.12e2 * t2299 - t2303 - t2306 + t2309 + 0.32530743900905219526e-1 * t2311 + t2315 + 0.73245789224026180216e-3 * t2316 - t2257 + t2269 + 0.19751673498613801407e-1 * t2043 * t139;
  t2322 = t2055 + t2135 + t2294 + t2320;
  t2323 = t156 * t2322;
  t2324 = t1950 * t539;
  t2325 = t541 * t66;
  t2326 = t2325 * t1295;
  t2327 = t2324 * t2326;
  t2328 = 0.2e4 / 0.81e2 * t2327;
  t2329 = t553 * t522;
  t2330 = t193 * t2329;
  t2331 = t190 * t2330;
  t2332 = 0.5e2 / 0.27e2 * t2331;
  t2333 = t194 * t1941;
  t2334 = t193 * t2333;
  t2335 = t190 * t2334;
  t2336 = 0.5e2 / 0.81e2 * t2335;
  t2337 = t192 * t589;
  t2339 = t190 * t2337 * t195;
  t2340 = 0.5e2 / 0.27e2 * t2339;
  t2342 = t190 * t549 * t554;
  t2343 = 0.1e3 / 0.27e2 * t2342;
  t2344 = t549 * t558;
  t2345 = t190 * t2344;
  t2346 = 0.5e2 / 0.27e2 * t2345;
  t2347 = t1897 + t1972 + t1974 + t1979 - t1983 - t1987 - t1994 + t2323 + t2328 - t2332 - t2336 - t2340 - t2343 - t2346;
  t2348 = t791 * params->c;
  t2349 = t2348 * t180;
  t2351 = t190 * t193 * t2349;
  t2352 = 0.5e2 / 0.27e2 * t2351;
  t2353 = t523 * t189;
  t2354 = t2353 * t196;
  t2355 = 0.1e3 / 0.27e2 * t2354;
  t2357 = t55 * t66 * t2322;
  t2358 = t46 * t2357;
  t2359 = 0.5e1 / 0.9e1 * t2358;
  t2361 = 0.1e1 / t33 / t1637;
  t2362 = t30 * t2361;
  t2364 = 0.595e3 / 0.27e2 * t2362 * t63;
  t2365 = t565 * t210;
  t2367 = t565 * t213;
  t2368 = 0.119e3 / 0.6e1 * t2367;
  t2369 = t202 * t576;
  t2371 = t202 * t580;
  t2373 = t202 * t584;
  t2375 = t202 * t61;
  t2376 = 0.7e1 / 0.2e1 * t2375;
  t2377 = t205 * t205;
  t2378 = 0.1e1 / t2377;
  t2379 = t2378 * t62;
  t2380 = t575 * t209;
  t2381 = t2379 * t2380;
  t2384 = t573 * t8;
  t2385 = t2384 * t575;
  t2386 = t59 * t2385;
  t2388 = t62 * t209;
  t2389 = t2388 * t583;
  t2392 = t206 * t209;
  t2393 = t59 * t2392;
  t2395 = t579 * t583;
  t2396 = t59 * t2395;
  t2398 = -t1903 + t1905 - t1907 - t1909 - t1915 + t1919 + t1925 - t1931 + t1935 + t1939;
  t2399 = t207 * t2398;
  t2402 = t2364 + 0.119e3 / 0.12e2 * t2365 - t2368 + 0.7e1 / 0.2e1 * t2369 - 0.7e1 * t2371 - 0.7e1 / 0.4e1 * t2373 + t2376 + 0.3e1 / 0.4e1 * t59 * t2381 - 0.3e1 / 0.2e1 * t2386 - 0.3e1 / 0.4e1 * t878 * t2389 + 0.3e1 / 0.4e1 * t2393 + 0.3e1 / 0.4e1 * t2396 + t59 * t2399 / 0.8e1;
  t2404 = t55 * t2402 * t146;
  t2405 = t46 * t2404;
  t2406 = 0.5e1 / 0.9e1 * t2405;
  t2408 = t55 * t589 * t316;
  t2409 = t46 * t2408;
  t2410 = 0.5e1 / 0.3e1 * t2409;
  t2412 = t55 * t216 * t791;
  t2413 = t46 * t2412;
  t2414 = 0.5e1 / 0.3e1 * t2413;
  t2415 = t217 * t545;
  t2416 = t543 * t2415;
  t2417 = 0.2e4 / 0.81e2 * t2416;
  t2418 = t317 * t545;
  t2419 = t543 * t2418;
  t2420 = 0.2e4 / 0.81e2 * t2419;
  t2421 = t182 * t591;
  t2422 = 0.5e1 / 0.3e1 * t2421;
  t2423 = t182 * t595;
  t2424 = 0.1e2 / 0.3e1 * t2423;
  t2425 = t182 * t793;
  t2426 = 0.5e1 / 0.3e1 * t2425;
  t2427 = t1942 * t45;
  t2428 = t2427 * t148;
  t2429 = 0.5e1 / 0.9e1 * t2428;
  t2430 = t524 * t218;
  t2431 = 0.5e1 / 0.3e1 * t2430;
  t2432 = t524 * t318;
  t2433 = 0.5e1 / 0.3e1 * t2432;
  t2434 = -t2352 - t2355 + t2359 + t2406 + t2410 + t2414 + t2417 + t2420 + t2422 + t2424 + t2426 + t2429 + t2431 + t2433;
  tv3rho30 = t9 * (t2347 + t2434) + 0.3e1 * t818 + 0.3e1 * t815 + 0.6e1 * t816 + 0.5e1 / 0.3e1 * t525 + 0.1e2 / 0.3e1 * t534 + 0.1e2 / 0.3e1 * t536 + 0.2e4 / 0.81e2 * t547 + 0.5e1 / 0.3e1 * t592 + 0.1e2 / 0.3e1 * t596 + 0.5e1 / 0.3e1 * t794 - 0.1e3 / 0.27e2 * t551 - 0.1e3 / 0.27e2 * t556 - 0.5e2 / 0.27e2 * t560 - 0.1e3 / 0.27e2 * t532;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t2451 = 0.2e1 * t971;
  t2452 = 0.4e4 / 0.243e3 * t856;
  t2453 = 0.2e3 / 0.81e2 * t847;
  t2454 = 0.1e3 / 0.81e2 * t859;
  t2455 = 0.1e3 / 0.81e2 * t863;
  t2456 = 0.1e3 / 0.81e2 * t867;
  t2457 = 0.1e3 / 0.81e2 * t873;
  t2458 = 0.1e3 / 0.81e2 * t905;
  t2459 = 0.2e1 * t974;
  t2460 = 0.2e1 * t973;
  t2461 = 0.1e2 / 0.9e1 * t954;
  t2462 = -t533 + t2451 + t2452 - t557 - t561 - t2453 - t2454 - t2455 - t2456 - t2457 - t2458 + t817 + t818 + t2459 + t815 + t2460 + t2461;
  t2463 = 0.1e2 / 0.9e1 * t844;
  t2464 = 0.1e2 / 0.9e1 * t849;
  t2465 = 0.1e2 / 0.9e1 * t851;
  t2466 = 0.1e2 / 0.9e1 * t869;
  t2467 = 0.1e2 / 0.9e1 * t894;
  t2468 = 0.1e2 / 0.9e1 * t898;
  t2469 = 0.1e2 / 0.9e1 * t900;
  t2470 = 0.1e2 / 0.9e1 * t909;
  t2471 = t330 * t951;
  t2473 = t814 * t382;
  t2474 = t394 * t791;
  t2475 = t970 * t316;
  t2478 = 0.2e3 / 0.27e2 * t496 * t337;
  t2480 = 0.1e3 / 0.27e2 * t161 * t824;
  t2482 = 0.5e2 / 0.9e1 * t161 * t828;
  t2484 = t1911 * t336 * t502;
  t2486 = 0.1e2 / 0.27e2 * t7 * t2484;
  t2487 = t7 * t501;
  t2488 = t507 * t167;
  t2490 = 0.2e2 / 0.9e1 * t2487 * t2488;
  t2491 = t823 * t508;
  t2493 = 0.1e2 / 0.9e1 * t7 * t2491;
  t2494 = t15 * t506;
  t2496 = 0.5e1 / 0.3e1 * t7 * t2494;
  t2497 = t827 * t98;
  t2499 = 0.5e1 * t7 * t2497;
  t2501 = 0.5e2 / 0.27e2 * t343 * t514;
  t2503 = 0.25e2 / 0.9e1 * t343 * t518;
  t2505 = t1927 * t346 * t513;
  t2507 = 0.1e2 / 0.27e2 * t22 * t2505;
  t2508 = t22 * t512;
  t2509 = t507 * t171;
  t2511 = 0.2e2 / 0.9e1 * t2508 * t2509;
  t2512 = t833 * t517;
  t2514 = 0.1e2 / 0.9e1 * t22 * t2512;
  t2515 = t26 * t506;
  t2517 = 0.5e1 / 0.3e1 * t22 * t2515;
  t2518 = t837 * t98;
  t2520 = 0.5e1 * t22 * t2518;
  t2521 = t2478 - t2480 - t2482 - t2486 + t2490 + t2493 + t2496 - t2499 - t2501 - t2503 - t2507 - t2511 + t2514 - t2517 + t2520 + t1940;
  t2522 = t2 * t2521;
  t2524 = t2522 * t40 * t153;
  t2526 = t842 * t188;
  t2529 = t351 * t539;
  t2534 = t1956 * t1958;
  t2535 = t39 * t2534;
  t2537 = t350 * t527 * t50;
  t2540 = t841 * t180;
  t2541 = t806 * t2540;
  t2544 = t350 * t522;
  t2545 = t806 * t2544;
  t2548 = params->c * t2521;
  t2549 = t325 * t2548;
  t2552 = -0.5e1 / 0.9e1 * t2524 + 0.2e3 / 0.81e2 * t2526 * t327 - 0.2e4 / 0.81e2 * t2529 * t807 + 0.1e3 / 0.81e2 * t959 * t811 + 0.1e5 / 0.729e3 * t2535 * t2537 - 0.4e4 / 0.243e3 * t805 * t2541 - 0.2e4 / 0.243e3 * t805 * t2545 + 0.5e2 / 0.81e2 * t324 * t2549;
  t2553 = t2552 * t146;
  t2554 = t1955 * t66;
  t2555 = t2554 * t146;
  t2556 = t805 * t2555;
  t2557 = t1958 * t350;
  t2559 = t2557 * t527 * t50;
  t2560 = t2556 * t2559;
  t2562 = t902 * t522;
  t2563 = t193 * t2562;
  t2564 = t190 * t2563;
  t2566 = t549 * t903;
  t2567 = t190 * t2566;
  t2569 = t951 * params->c;
  t2570 = t2569 * t180;
  t2571 = t193 * t2570;
  t2572 = t190 * t2571;
  t2574 = t871 * t558;
  t2575 = t190 * t2574;
  t2577 = t553 * t841;
  t2578 = t193 * t2577;
  t2579 = t190 * t2578;
  t2581 = t194 * t2521;
  t2582 = t193 * t2581;
  t2583 = t190 * t2582;
  t2585 = 0.2e1 * t2471 + t2473 + t2474 + 0.2e1 * t2475 + t2553 - 0.1e5 / 0.729e3 * t2560 - 0.5e2 / 0.81e2 * t2564 - 0.1e3 / 0.81e2 * t2567 - 0.1e3 / 0.81e2 * t2572 - 0.5e2 / 0.81e2 * t2575 - 0.1e3 / 0.81e2 * t2579 - 0.5e2 / 0.81e2 * t2583;
  t2586 = t192 * t891;
  t2587 = t2586 * t195;
  t2588 = t190 * t2587;
  t2590 = t871 * t554;
  t2591 = t190 * t2590;
  t2593 = t2337 * t355;
  t2594 = t190 * t2593;
  t2596 = t549 * t861;
  t2597 = t190 * t2596;
  t2599 = t549 * t865;
  t2600 = t190 * t2599;
  t2602 = t2348 * t350;
  t2603 = t193 * t2602;
  t2604 = t190 * t2603;
  t2606 = t846 * t550;
  t2608 = t846 * t555;
  t2610 = t846 * t559;
  t2612 = t842 * t189;
  t2613 = t2612 * t196;
  t2615 = t383 * params->c;
  t2616 = t325 * t2615;
  t2617 = t529 * t2616;
  t2619 = t217 * t854;
  t2620 = t543 * t2619;
  t2622 = t317 * t854;
  t2623 = t543 * t2622;
  t2625 = -0.1e3 / 0.81e2 * t2588 - 0.1e3 / 0.81e2 * t2591 - 0.5e2 / 0.81e2 * t2594 - 0.1e3 / 0.81e2 * t2597 - 0.1e3 / 0.81e2 * t2600 - 0.5e2 / 0.81e2 * t2604 - 0.2e3 / 0.81e2 * t2606 - 0.2e3 / 0.81e2 * t2608 - 0.1e3 / 0.81e2 * t2610 - 0.2e3 / 0.81e2 * t2613 - 0.1e3 / 0.81e2 * t2617 + 0.4e4 / 0.243e3 * t2620 + 0.4e4 / 0.243e3 * t2623;
  t2627 = t544 * t841;
  t2628 = t2627 * t180;
  t2629 = t147 * t2628;
  t2630 = t543 * t2629;
  t2632 = t853 * t522;
  t2633 = t147 * t2632;
  t2634 = t543 * t2633;
  t2636 = t365 * params->c;
  t2637 = t325 * t2636;
  t2638 = t529 * t2637;
  t2642 = t776 * t378;
  t2644 = t770 * t378;
  t2646 = t377 * t748;
  t2647 = t99 * t2646;
  t2648 = 0.32e2 * t2010;
  t2649 = 0.12e2 * t2012;
  t2651 = t257 * t935;
  t2654 = -0.16e2 * t1995 + t1998 + 0.4e2 * t2001 + t2006 - 0.32e2 * t2642 + 0.2e2 * t2644 + t2647 + t2008 - t2648 - t2649 - 0.24e2 * t2014 - 0.8e1 * t2651 + t2052 + 0.23392894490538584828e1 * t2053 - t2060 + t2064;
  t2659 = t945 * t787;
  t2661 = t945 * t604;
  t2663 = t932 * t129;
  t2665 = 0.11696447245269292414e1 * t2663 * t313;
  t2666 = t945 * t636;
  t2668 = t932 * t301;
  t2670 = 0.2e1 * t99 * t2668;
  t2671 = t2068 - t2071 - t2075 - t2081 + t2085 - 0.18311447306006545054e-3 * t2087 - t2119 - t2127 - 0.5848223622634646207e0 * t2129 - 0.11696447245269292414e1 * t2131 - 0.34631718211362927518e2 * t2133 + 0.11696447245269292414e1 * t2659 - 0.17315859105681463759e2 * t2661 - t2665 - 0.5848223622634646207e0 * t2666 + t2670;
  t2674 = 0.8e1 * t253 * t933;
  t2676 = 0.48e2 * t2277;
  t2677 = 0.8e2 * t2284;
  t2678 = t2017 * t335;
  t2681 = t640 * t8;
  t2692 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t2678 * t641 + 0.16e2 / 0.9e1 * t2681 * t506 * t166 + 0.4e1 / 0.9e1 * t915 * t644 + 0.8e1 / 0.3e1 * t103 * t506 - 0.8e1 * t918 * t98);
  t2693 = t2030 * t372;
  t2696 = t650 * t8;
  t2707 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2693 * t651 - 0.16e2 / 0.9e1 * t2696 * t506 * t263 + 0.4e1 / 0.9e1 * t923 * t654 - 0.8e1 / 0.3e1 * t107 * t506 + 0.8e1 * t926 * t98);
  t2709 = (t2692 + t2707) * t113;
  t2710 = t2709 * t141;
  t2712 = t253 * t935;
  t2715 = 0.8e1 * t257 * t933;
  t2716 = 0.4e1 * t2292;
  t2717 = t99 * t2710 + 0.2e1 * t2138 + t2180 - t2184 + t2192 + t2273 - t2275 - t2282 - t2289 - t2291 + t2674 + t2676 + t2677 + 0.8e1 * t2712 - t2715 + t2716;
  t2718 = t377 * t70;
  t2719 = t2718 * t780;
  t2721 = t773 * t378;
  t2723 = t932 * t67;
  t2725 = 0.36622894612013090108e-3 * t2723 * t308;
  t2726 = t937 * t766;
  t2734 = 0.10843581300301739842e-1 * t2719 + 0.12e2 * t2721 - t2725 + 0.24415263074675393405e-3 * t2726 + t2238 - 0.4e1 * t2297 - 0.4e1 * t2299 - t2303 - t2306 + t2309 + 0.21687162600603479684e-1 * t2311 + t2315 + 0.4883052614935078681e-3 * t2316 - t2257 + t2269 + 0.19751673498613801407e-1 * t2709 * t139;
  t2736 = t2654 + t2671 + t2717 + t2734;
  t2737 = t156 * t2736;
  t2739 = t55 * t66 * t2736;
  t2740 = t46 * t2739;
  t2742 = t383 * t545;
  t2743 = t543 * t2742;
  t2746 = t55 * t589 * t382;
  t2747 = t46 * t2746;
  t2750 = t55 * t216 * t951;
  t2751 = t46 * t2750;
  t2753 = t524 * t384;
  t2755 = t182 * t908;
  t2757 = t182 * t953;
  t2759 = t524 * t366;
  t2761 = 0.4e4 / 0.243e3 * t2630 + 0.2e4 / 0.243e3 * t2634 - 0.1e3 / 0.81e2 * t2638 + t2737 + 0.5e1 / 0.9e1 * t2740 + 0.2e4 / 0.243e3 * t2743 + 0.5e1 / 0.9e1 * t2747 + 0.1e2 / 0.9e1 * t2751 + 0.5e1 / 0.9e1 * t2753 + 0.1e2 / 0.9e1 * t2755 + 0.1e2 / 0.9e1 * t2757 + 0.5e1 / 0.9e1 * t2759;
  t2762 = t182 * t893;
  t2764 = t182 * t897;
  t2766 = t365 * t545;
  t2767 = t543 * t2766;
  t2769 = t879 * t583;
  t2772 = t565 * t361;
  t2774 = t202 * t573;
  t2776 = 0.7e1 / 0.3e1 * t2774 * t880;
  t2777 = t202 * t883;
  t2779 = t62 * t886;
  t2780 = t2779 * t209;
  t2783 = t2478 - t2480 - t2482 - t2486 + t2490 + t2493 + t2496 - t2499 - t2501 - t2503 - t2507 - t2511 + t2514 - t2517 + t2520;
  t2784 = t207 * t2783;
  t2788 = 0.7e1 / 0.6e1 * t202 * t887;
  t2789 = t206 * t360;
  t2790 = t59 * t2789;
  t2792 = t579 * t886;
  t2794 = t59 * t2792 / 0.2e1;
  t2795 = t59 * t2378;
  t2796 = t879 * t575;
  t2799 = t8 * t360;
  t2800 = t2799 * t209;
  t2801 = t878 * t2800;
  t2805 = 0.119e3 / 0.18e2 * t2367;
  t2809 = 0.7e1 / 0.6e1 * t2375;
  t2810 = -t878 * t2769 / 0.4e1 + 0.119e3 / 0.36e2 * t2772 + t2776 - 0.7e1 / 0.3e1 * t2777 - t878 * t2780 / 0.2e1 + t59 * t2784 / 0.8e1 - t2788 + t2790 / 0.4e1 + t2794 + 0.3e1 / 0.4e1 * t2795 * t2796 - t2801 + 0.7e1 / 0.6e1 * t2369 + t2386 / 0.2e1 + t2364 + 0.119e3 / 0.18e2 * t2365 - t2805 - 0.7e1 / 0.12e2 * t2373 - t2393 / 0.2e1 - t2396 / 0.4e1 - t2809;
  t2812 = t55 * t2810 * t146;
  t2813 = t46 * t2812;
  t2816 = t55 * t891 * t316;
  t2817 = t46 * t2816;
  t2820 = t55 * t364 * t791;
  t2821 = t46 * t2820;
  t2823 = t2522 * t45;
  t2824 = t2823 * t148;
  t2826 = t843 * t218;
  t2828 = t843 * t318;
  t2830 = t351 * t542;
  t2831 = t2830 * t546;
  t2833 = t352 * t591;
  t2835 = t352 * t595;
  t2837 = t352 * t793;
  t2839 = 0.1e2 / 0.9e1 * t2762 + 0.1e2 / 0.9e1 * t2764 + 0.2e4 / 0.243e3 * t2767 + 0.5e1 / 0.9e1 * t2813 + 0.1e2 / 0.9e1 * t2817 + 0.5e1 / 0.9e1 * t2821 + 0.5e1 / 0.9e1 * t2824 + 0.1e2 / 0.9e1 * t2826 + 0.1e2 / 0.9e1 * t2828 + 0.2e4 / 0.81e2 * t2831 + 0.5e1 / 0.9e1 * t2833 + 0.1e2 / 0.9e1 * t2835 + 0.5e1 / 0.9e1 * t2837;
  t2843 = 0.2e1 * t972;
  t2844 = t2463 + t2464 + t2465 + t2466 + t2467 + t2468 + t2469 + t2470 + t537 + t548 + t593 + t597 + t795 + t526 + t535 + t9 * (t2585 + t2625 + t2761 + t2839) + t2843 - t552;
  tv3rho31 = t2462 + t2844;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t2846 = 0.5e2 / 0.27e2 * t161 * t984;
  t2847 = t1911 * t983;
  t2848 = t2847 * t167;
  t2850 = 0.1e2 / 0.27e2 * t7 * t2848;
  t2851 = t336 * t8;
  t2852 = t2851 * t506;
  t2854 = 0.2e2 / 0.9e1 * t2487 * t2852;
  t2856 = 0.25e2 / 0.9e1 * t161 * t988;
  t2857 = t501 * t987;
  t2858 = t2857 * t167;
  t2860 = 0.1e2 / 0.9e1 * t7 * t2858;
  t2862 = -t506 - 0.3e1 * t1920;
  t2863 = t15 * t2862;
  t2865 = 0.5e1 / 0.3e1 * t7 * t2863;
  t2867 = 0.2e3 / 0.27e2 * t994 * t172;
  t2869 = 0.1e3 / 0.27e2 * t343 * t834;
  t2871 = 0.5e2 / 0.9e1 * t343 * t838;
  t2872 = t1927 * t999;
  t2873 = t2872 * t171;
  t2875 = 0.1e2 / 0.27e2 * t22 * t2873;
  t2876 = t346 * t8;
  t2877 = t2876 * t506;
  t2879 = 0.2e2 / 0.9e1 * t2508 * t2877;
  t2880 = t512 * t1003;
  t2881 = t2880 * t171;
  t2883 = 0.1e2 / 0.9e1 * t22 * t2881;
  t2884 = -t2862;
  t2885 = t26 * t2884;
  t2887 = 0.5e1 / 0.3e1 * t22 * t2885;
  t2888 = -t2846 - t2850 + t2854 - t2856 + t2860 + t2865 + t2867 - t2869 + t2871 - t2875 - t2879 + t2883 + t2887 + t1940;
  t2889 = t2 * t2888;
  t2891 = t2889 * t40 * t153;
  t2893 = t1008 * t188;
  t2898 = t1013 * t539;
  t2899 = t806 * t180;
  t2903 = t1012 * t180 * t50;
  t2906 = t350 * t841;
  t2907 = t806 * t2906;
  t2910 = t1007 * t180;
  t2911 = t806 * t2910;
  t2914 = params->c * t2888;
  t2915 = t325 * t2914;
  t2918 = -0.5e1 / 0.9e1 * t2891 + 0.1e3 / 0.81e2 * t2893 * t327 + 0.2e3 / 0.81e2 * t959 * t967 - 0.2e4 / 0.81e2 * t2898 * t2899 + 0.1e5 / 0.729e3 * t2535 * t2903 - 0.4e4 / 0.243e3 * t805 * t2907 - 0.2e4 / 0.243e3 * t805 * t2911 + 0.5e2 / 0.81e2 * t324 * t2915;
  t2919 = t2918 * t146;
  t2920 = t970 * t382;
  t2922 = t330 * t1084;
  t2931 = -0.8e1 * t1995 + t1998 + 0.32e2 * t1999 + 0.2e2 * t2001 + t2006 + 0.4e2 * t2644 + 0.2e1 * t2647 + t2648 - t2649 + 0.12e2 * t2014 - 0.16e2 * t2651 + t2052 + 0.11696447245269292414e1 * t2053 - t2060 + t2064 + t2068;
  t2934 = t1072 * t129;
  t2935 = t2934 * t313;
  t2940 = -t2071 - t2075 - t2081 + t2085 - t2119 - t2127 - 0.5848223622634646207e0 * t2131 - 0.17315859105681463759e2 * t2133 - 0.5848223622634646207e0 * t2935 + 0.23392894490538584828e1 * t2659 - 0.34631718211362927517e2 * t2661 - t2665 - 0.11696447245269292414e1 * t2666 + t2670 - t2674 + t2138;
  t2942 = t253 * t1073;
  t2944 = t257 * t1073;
  t2946 = t2017 * t1055;
  t2951 = t640 * t1058;
  t2956 = -0.2e1 * t506 - 0.6e1 * t1920;
  t2960 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t2946 * t166 + 0.16e2 / 0.9e1 * t915 * t507 + 0.4e1 / 0.9e1 * t2951 * t166 + 0.4e1 / 0.3e1 * t103 * t2956);
  t2961 = t2030 * t1063;
  t2966 = t650 * t1066;
  t2969 = -t2956;
  t2973 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2961 * t263 - 0.16e2 / 0.9e1 * t923 * t507 + 0.4e1 / 0.9e1 * t2966 * t263 + 0.4e1 / 0.3e1 * t107 * t2969);
  t2975 = (t2960 + t2973) * t113;
  t2976 = t2975 * t141;
  t2978 = t1072 * t301;
  t2979 = t99 * t2978;
  t2980 = t99 * t2976 + t2180 - t2184 + t2192 + t2273 + t2275 - t2282 - t2289 - t2291 + t2676 - t2677 - t2715 - t2716 + 0.4e1 * t2942 - 0.4e1 * t2944 + t2979;
  t2987 = t1072 * t67;
  t2988 = t2987 * t308;
  t2992 = 0.21687162600603479684e-1 * t2719 - 0.24e2 * t2721 - t2725 + 0.48830526149350786811e-3 * t2726 + t2238 - 0.8e1 * t2295 - t2303 - t2306 + t2309 + 0.10843581300301739842e-1 * t2311 + t2315 + 0.24415263074675393405e-3 * t2316 - 0.18311447306006545054e-3 * t2988 - t2257 + t2269 + 0.19751673498613801407e-1 * t2975 * t139;
  t2994 = t2931 + t2940 + t2980 + t2992;
  t2995 = t156 * t2994;
  t2996 = t1958 * t1012;
  t2998 = t2996 * t180 * t50;
  t2999 = t2556 * t2998;
  t3002 = t55 * t66 * t2994;
  t3003 = t46 * t3002;
  t3005 = t182 * t1086;
  t3008 = t55 * t216 * t1084;
  t3009 = t46 * t3008;
  t3012 = t55 * t364 * t951;
  t3013 = t46 * t3012;
  t3015 = t352 * t953;
  t3017 = t217 * t1021;
  t3018 = t543 * t3017;
  t3020 = t317 * t1021;
  t3021 = t543 * t3020;
  t3023 = t2919 + 0.2e1 * t2920 + t2922 + t2995 - 0.1e5 / 0.729e3 * t2999 + 0.5e1 / 0.9e1 * t3003 + 0.5e1 / 0.9e1 * t3005 + 0.5e1 / 0.9e1 * t3009 + 0.1e2 / 0.9e1 * t3013 + 0.1e2 / 0.9e1 * t3015 + 0.2e4 / 0.243e3 * t3018 + 0.2e4 / 0.243e3 * t3021;
  t3024 = t182 * t1048;
  t3029 = t202 * t1038;
  t3031 = t62 * t1037;
  t3032 = t3031 * t209;
  t3035 = t2384 * t1037;
  t3036 = t59 * t3035;
  t3038 = t879 * t886;
  t3042 = t202 * t1043;
  t3044 = t62 * t1042;
  t3045 = t3044 * t209;
  t3048 = t579 * t1042;
  t3049 = t59 * t3048;
  t3051 = -t2846 - t2850 + t2854 - t2856 + t2860 + t2865 + t2867 - t2869 + t2871 - t2875 - t2879 + t2883 + t2887;
  t3052 = t207 * t3051;
  t3056 = t2364 + 0.119e3 / 0.36e2 * t2365 + t2805 + 0.119e3 / 0.18e2 * t2772 + t2776 - t2788 + 0.7e1 / 0.3e1 * t2371 - t2809 + 0.7e1 / 0.6e1 * t3029 + 0.3e1 / 0.4e1 * t2795 * t3032 - t3036 / 0.2e1 - t878 * t3038 / 0.2e1 + t2801 - t2790 / 0.2e1 - t2794 - 0.7e1 / 0.12e2 * t3042 - t878 * t3045 / 0.4e1 + t3049 / 0.4e1 + t59 * t3052 / 0.8e1 + t2393 / 0.4e1;
  t3058 = t55 * t3056 * t146;
  t3059 = t46 * t3058;
  t3062 = t55 * t1046 * t316;
  t3063 = t46 * t3062;
  t3065 = t182 * t1052;
  t3068 = t55 * t891 * t382;
  t3069 = t46 * t3068;
  t3071 = t2889 * t45;
  t3072 = t3071 * t148;
  t3074 = t1009 * t218;
  t3076 = t1009 * t318;
  t3078 = t1013 * t542;
  t3079 = t147 * t1975;
  t3080 = t3078 * t3079;
  t3082 = t843 * t366;
  t3084 = t352 * t893;
  t3086 = t352 * t897;
  t3088 = t843 * t384;
  t3090 = 0.5e1 / 0.9e1 * t3024 + 0.5e1 / 0.9e1 * t3059 + 0.5e1 / 0.9e1 * t3063 + 0.1e2 / 0.9e1 * t3065 + 0.1e2 / 0.9e1 * t3069 + 0.5e1 / 0.9e1 * t3072 + 0.5e1 / 0.9e1 * t3074 + 0.5e1 / 0.9e1 * t3076 + 0.2e4 / 0.81e2 * t3080 + 0.1e2 / 0.9e1 * t3082 + 0.1e2 / 0.9e1 * t3084 + 0.1e2 / 0.9e1 * t3086 + 0.1e2 / 0.9e1 * t3088;
  t3092 = t352 * t908;
  t3094 = t394 * t951;
  t3096 = t1102 * t316;
  t3097 = t549 * t1032;
  t3098 = t190 * t3097;
  t3100 = t553 * t1007;
  t3101 = t193 * t3100;
  t3102 = t190 * t3101;
  t3104 = t846 * t904;
  t3106 = t2586 * t355;
  t3107 = t190 * t3106;
  t3109 = t871 * t861;
  t3110 = t190 * t3109;
  t3112 = t871 * t865;
  t3113 = t190 * t3112;
  t3115 = t1008 * t189;
  t3116 = t3115 * t196;
  t3118 = t846 * t866;
  t3120 = t846 * t872;
  t3122 = 0.1e2 / 0.9e1 * t3092 + 0.2e1 * t3094 + t3096 - 0.5e2 / 0.81e2 * t3098 - 0.5e2 / 0.81e2 * t3102 - 0.2e3 / 0.81e2 * t3104 - 0.1e3 / 0.81e2 * t3107 - 0.1e3 / 0.81e2 * t3110 - 0.1e3 / 0.81e2 * t3113 - 0.1e3 / 0.81e2 * t3116 - 0.2e3 / 0.81e2 * t3118 - 0.2e3 / 0.81e2 * t3120;
  t3123 = t1084 * params->c;
  t3124 = t3123 * t180;
  t3125 = t193 * t3124;
  t3126 = t190 * t3125;
  t3128 = t194 * t2888;
  t3129 = t193 * t3128;
  t3130 = t190 * t3129;
  t3132 = t192 * t1046;
  t3133 = t3132 * t195;
  t3134 = t190 * t3133;
  t3136 = t871 * t903;
  t3137 = t190 * t3136;
  t3139 = t549 * t1028;
  t3140 = t190 * t3139;
  t3142 = t2569 * t350;
  t3143 = t193 * t3142;
  t3144 = t190 * t3143;
  t3146 = t902 * t841;
  t3147 = t193 * t3146;
  t3148 = t190 * t3147;
  t3150 = t1014 * t1981;
  t3153 = t543 * t383 * t854;
  t3155 = t544 * t1007;
  t3156 = t3155 * t180;
  t3158 = t543 * t147 * t3156;
  t3160 = t1014 * t1985;
  t3162 = t853 * t841;
  t3163 = t147 * t3162;
  t3164 = t543 * t3163;
  t3167 = t543 * t365 * t854;
  t3169 = -0.5e2 / 0.81e2 * t3126 - 0.5e2 / 0.81e2 * t3130 - 0.5e2 / 0.81e2 * t3134 - 0.1e3 / 0.81e2 * t3137 - 0.1e3 / 0.81e2 * t3140 - 0.1e3 / 0.81e2 * t3144 - 0.1e3 / 0.81e2 * t3148 - 0.1e3 / 0.81e2 * t3150 + 0.4e4 / 0.243e3 * t3153 + 0.2e4 / 0.243e3 * t3158 - 0.1e3 / 0.81e2 * t3160 + 0.4e4 / 0.243e3 * t3164 + 0.4e4 / 0.243e3 * t3167;
  t3173 = -t1016 + t9 * (t3023 + t3090 + t3122 + t3169) - t1027 - t1031 - t1035 + t1105 + t1106 + t2451 + t2452 - t2453 - t2454 - t2455 - t2456 - t2457 - t2458 + t2459 + t2460;
  t3174 = t1011 + t1018 + t1020 + t1024 + t1050 + t1054 + t1088 + t2461 + t2463 + t2464 + t2465 + t2466 + t2467 + t2468 + t2469 + t2470 + t2843 + t1103;
  tv3rho32 = t3173 + t3174;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t3175 = t1102 * t382;
  t3176 = 0.3e1 * t3175;
  t3177 = t983 * t336;
  t3178 = t1911 * t3177;
  t3180 = 0.1e2 / 0.27e2 * t7 * t3178;
  t3181 = t823 * t987;
  t3183 = 0.1e2 / 0.3e1 * t7 * t3181;
  t3184 = -t506 - t1920;
  t3185 = 0.3e1 * t3184;
  t3186 = t15 * t3185;
  t3188 = 0.5e1 / 0.3e1 * t7 * t3186;
  t3189 = t340 * t340;
  t3191 = 0.1e1 / t19 / t3189;
  t3192 = tau[1] * t3191;
  t3194 = 0.44e3 / 0.27e2 * t3192 * t27;
  t3196 = 0.2e3 / 0.9e1 * t994 * t347;
  t3198 = 0.5e2 / 0.9e1 * t343 * t1000;
  t3200 = 0.25e2 / 0.3e1 * t343 * t1004;
  t3201 = t999 * t346;
  t3202 = t1927 * t3201;
  t3204 = 0.1e2 / 0.27e2 * t22 * t3202;
  t3205 = t833 * t1003;
  t3207 = 0.1e2 / 0.3e1 * t22 * t3205;
  t3208 = -t3185;
  t3209 = t26 * t3208;
  t3211 = 0.5e1 / 0.3e1 * t22 * t3209;
  t3212 = -t3180 + t3183 + t3188 - t3194 + t3196 - t3198 - t3200 - t3204 + t3207 + t3211 + t1940;
  t3213 = t2 * t3212;
  t3215 = t3213 * t40 * t153;
  t3219 = t1012 * t350;
  t3220 = t2 * t3219;
  t3224 = t1958 * t3219 * t50;
  t3227 = t350 * t1007;
  t3228 = t806 * t3227;
  t3231 = params->c * t3212;
  t3232 = t325 * t3231;
  t3235 = -0.5e1 / 0.9e1 * t3215 + 0.1e3 / 0.27e2 * t2893 * t391 - 0.2e4 / 0.81e2 * t3220 * t1951 + 0.1e5 / 0.729e3 * t1957 * t3224 - 0.2e4 / 0.81e2 * t805 * t3228 + 0.5e2 / 0.81e2 * t324 * t3232;
  t3236 = t3235 * t146;
  t3237 = t394 * t1084;
  t3238 = 0.3e1 * t3237;
  t3240 = t1990 * t3219 * t50;
  t3241 = t1989 * t3240;
  t3242 = 0.1e5 / 0.729e3 * t3241;
  t3243 = t3220 * t539;
  t3244 = t3243 * t2326;
  t3245 = 0.2e4 / 0.81e2 * t3244;
  t3250 = t1055 * t335;
  t3255 = 0.6e1 * t3184;
  t3259 = my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t2017 * t3250 + 0.4e1 / 0.3e1 * t915 * t1058 + 0.4e1 / 0.3e1 * t103 * t3255);
  t3260 = t1063 * t372;
  t3265 = -t3255;
  t3269 = my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t2030 * t3260 + 0.4e1 / 0.3e1 * t923 * t1066 + 0.4e1 / 0.3e1 * t107 * t3265);
  t3271 = (t3259 + t3269) * t113;
  t3272 = t3271 * t141;
  t3274 = t99 * t3272 + t1998 + t2006 + t2011 + t2013 + t2052 - t2060 + t2064 + 0.96e2 * t2642 + 0.6e2 * t2644 + 0.3e1 * t2647 - 0.24e2 * t2651;
  t3281 = t2068 - t2071 - t2075 - t2081 + t2085 - t2119 - t2127 - 0.17544670867903938621e1 * t2935 + 0.35089341735807877242e1 * t2659 - 0.51947577317044391276e2 * t2661 - 0.17544670867903938621e1 * t2666 + 0.19751673498613801407e-1 * t3271 * t139 + t2273;
  t3287 = -t2275 - t2278 - t2282 - t2285 + t2180 - t2184 + t2192 - t2289 - 0.12e2 * t2942 - 0.12e2 * t2944 - 0.24e2 * t2712 + 0.3e1 * t2979;
  t3292 = -t2291 - t2293 + 0.32530743900905219526e-1 * t2719 + 0.36e2 * t2721 + 0.73245789224026180216e-3 * t2726 + t2238 - t2303 - t2306 + t2309 + t2315 - 0.54934341918019635162e-3 * t2988 - t2257 + t2269;
  t3294 = t3274 + t3281 + t3287 + t3292;
  t3295 = t156 * t3294;
  t3296 = t853 * t1007;
  t3297 = t147 * t3296;
  t3298 = t543 * t3297;
  t3299 = 0.2e4 / 0.81e2 * t3298;
  t3300 = t1014 * t2637;
  t3301 = 0.1e3 / 0.27e2 * t3300;
  t3302 = t1014 * t2616;
  t3303 = 0.1e3 / 0.27e2 * t3302;
  t3304 = t352 * t1086;
  t3305 = 0.5e1 / 0.3e1 * t3304;
  t3306 = t365 * t1021;
  t3307 = t543 * t3306;
  t3308 = 0.2e4 / 0.81e2 * t3307;
  t3309 = t3213 * t45;
  t3310 = t3309 * t148;
  t3311 = 0.5e1 / 0.9e1 * t3310;
  t3312 = t1009 * t366;
  t3313 = 0.5e1 / 0.3e1 * t3312;
  t3314 = t1009 * t384;
  t3315 = 0.5e1 / 0.3e1 * t3314;
  t3316 = t3176 + t3236 + t3238 - t3242 + t3245 + t3295 + t3299 - t3301 - t3303 + t3305 + t3308 + t3311 + t3313 + t3315;
  t3317 = t352 * t1048;
  t3318 = 0.5e1 / 0.3e1 * t3317;
  t3319 = t352 * t1052;
  t3320 = 0.1e2 / 0.3e1 * t3319;
  t3322 = t55 * t66 * t3294;
  t3323 = t46 * t3322;
  t3324 = 0.5e1 / 0.9e1 * t3323;
  t3329 = t1037 * t360;
  t3330 = t2379 * t3329;
  t3334 = t879 * t1042;
  t3339 = -t3180 + t3183 + t3188 - t3194 + t3196 - t3198 - t3200 - t3204 + t3207 + t3211;
  t3340 = t207 * t3339;
  t3343 = t2364 + 0.119e3 / 0.12e2 * t2772 + t2368 + 0.7e1 / 0.2e1 * t3029 + 0.7e1 * t2777 - 0.7e1 / 0.4e1 * t3042 + t2376 + 0.3e1 / 0.4e1 * t59 * t3330 + 0.3e1 / 0.2e1 * t3036 - 0.3e1 / 0.4e1 * t878 * t3334 + 0.3e1 / 0.4e1 * t2790 - 0.3e1 / 0.4e1 * t3049 + t59 * t3340 / 0.8e1;
  t3345 = t55 * t3343 * t146;
  t3346 = t46 * t3345;
  t3347 = 0.5e1 / 0.9e1 * t3346;
  t3349 = t55 * t1046 * t382;
  t3350 = t46 * t3349;
  t3351 = 0.5e1 / 0.3e1 * t3350;
  t3353 = t55 * t364 * t1084;
  t3354 = t46 * t3353;
  t3355 = 0.5e1 / 0.3e1 * t3354;
  t3356 = t383 * t1021;
  t3357 = t543 * t3356;
  t3358 = 0.2e4 / 0.81e2 * t3357;
  t3359 = t902 * t1007;
  t3360 = t193 * t3359;
  t3361 = t190 * t3360;
  t3362 = 0.5e2 / 0.27e2 * t3361;
  t3363 = t194 * t3212;
  t3364 = t193 * t3363;
  t3365 = t190 * t3364;
  t3366 = 0.5e2 / 0.81e2 * t3365;
  t3368 = t190 * t3132 * t355;
  t3369 = 0.5e2 / 0.27e2 * t3368;
  t3371 = t190 * t871 * t1028;
  t3372 = 0.1e3 / 0.27e2 * t3371;
  t3373 = t871 * t1032;
  t3374 = t190 * t3373;
  t3375 = 0.5e2 / 0.27e2 * t3374;
  t3376 = t3123 * t350;
  t3378 = t190 * t193 * t3376;
  t3379 = 0.5e2 / 0.27e2 * t3378;
  t3380 = t3115 * t356;
  t3381 = 0.1e3 / 0.27e2 * t3380;
  t3382 = t3318 + t3320 + t3324 + t3347 + t3351 + t3355 + t3358 - t3362 - t3366 - t3369 - t3372 - t3375 - t3379 - t3381;
  tv3rho33 = t9 * (t3316 + t3382) + 0.3e1 * t1106 + 0.3e1 * t1103 + 0.6e1 * t1104 + 0.5e1 / 0.3e1 * t1010 + 0.1e2 / 0.3e1 * t1017 + 0.1e2 / 0.3e1 * t1019 + 0.2e4 / 0.81e2 * t1023 + 0.5e1 / 0.3e1 * t1049 + 0.1e2 / 0.3e1 * t1053 + 0.5e1 / 0.3e1 * t1087 - 0.1e3 / 0.27e2 * t1026 - 0.1e3 / 0.27e2 * t1030 - 0.5e2 / 0.27e2 * t1034 - 0.1e3 / 0.27e2 * t1015;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t3399 = t201 * t61;
  t3400 = t3399 * t62;
  t3402 = t1141 * t3400 * t195;
  t3403 = 0.175e3 / 0.243e3 * t3402;
  t3404 = t1142 * t8;
  t3406 = t1141 * t3404 * t195;
  t3407 = 0.25e2 / 0.81e2 * t3406;
  t3408 = t1143 * t554;
  t3409 = t1141 * t3408;
  t3410 = 0.25e2 / 0.162e3 * t3409;
  t3411 = t1143 * t558;
  t3412 = t1141 * t3411;
  t3413 = 0.25e2 / 0.324e3 * t3412;
  t3414 = t400 * t793;
  t3415 = 0.5e1 / 0.72e2 * t3414;
  t3416 = t1110 * t218;
  t3417 = 0.1e2 / 0.27e2 * t3416;
  t3418 = t1110 * t318;
  t3419 = 0.1e2 / 0.27e2 * t3418;
  t3420 = t399 * t542;
  t3421 = t3420 * t546;
  t3422 = 0.25e3 / 0.81e2 * t3421;
  t3423 = t2 * t58;
  t3424 = t3423 * t45;
  t3425 = t3424 * t148;
  t3426 = 0.55e2 / 0.81e2 * t3425;
  t3427 = t400 * t591;
  t3428 = 0.5e1 / 0.72e2 * t3427;
  t3429 = t400 * t595;
  t3430 = 0.5e1 / 0.36e2 * t3429;
  t3431 = t1179 * t316;
  t3432 = 0.2e1 * t3431;
  t3433 = -t3403 + t3407 + t3410 + t3413 - t3415 + t3417 + t3419 - t3422 - t3426 - t3428 - t3430 + t3432;
  t3434 = t317 * t1121;
  t3435 = t543 * t3434;
  t3436 = 0.5e3 / 0.243e3 * t3435;
  t3437 = t1120 * t522;
  t3438 = t147 * t3437;
  t3439 = t543 * t3438;
  t3440 = 0.25e3 / 0.243e3 * t3439;
  t3441 = t217 * t1121;
  t3442 = t543 * t3441;
  t3443 = 0.5e3 / 0.243e3 * t3442;
  t3444 = t1142 * t146;
  t3445 = t55 * t3444;
  t3446 = t46 * t3445;
  t3447 = 0.5e1 / 0.36e2 * t3446;
  t3448 = t544 * t177;
  t3449 = t3448 * t180;
  t3451 = t543 * t147 * t3449;
  t3452 = 0.4e4 / 0.729e3 * t3451;
  t3453 = t180 * t209;
  t3454 = t194 * t3453;
  t3455 = t1354 * t3454;
  t3456 = t1141 * t3455;
  t3457 = 0.25e2 / 0.162e3 * t3456;
  t3459 = t3423 * t40 * t153;
  t3460 = 0.55e2 / 0.81e2 * t3459;
  t3461 = t1109 * t188;
  t3462 = t3461 * t327;
  t3463 = 0.2e3 / 0.243e3 * t3462;
  t3464 = t399 * t539;
  t3465 = t3464 * t807;
  t3467 = t1168 * t811;
  t3471 = t2535 * t35 * t527 * t50;
  t3474 = t806 * t177 * t180;
  t3475 = t805 * t3474;
  t3476 = 0.4e4 / 0.729e3 * t3475;
  t3478 = t806 * t35 * t522;
  t3479 = t805 * t3478;
  t3483 = t324 * t325 * params->c * t58;
  t3484 = 0.55e3 / 0.729e3 * t3483;
  t3485 = t3460 + t3463 + 0.25e3 / 0.81e2 * t3465 - 0.25e2 / 0.162e3 * t3467 - 0.125e4 / 0.729e3 * t3471 - t3476 + 0.25e3 / 0.243e3 * t3479 - t3484;
  t3486 = t3485 * t146;
  t3487 = t420 * t791;
  t3488 = t1958 * t35;
  t3490 = t3488 * t527 * t50;
  t3491 = t2556 * t3490;
  t3492 = 0.125e4 / 0.729e3 * t3491;
  t3493 = t8 * t146;
  t3494 = t3493 * t209;
  t3495 = t1151 * t3494;
  t3496 = t407 * t3495;
  t3497 = 0.5e1 / 0.18e2 * t3496;
  t3498 = t1136 * t1154;
  t3499 = 0.5e1 / 0.36e2 * t3498;
  t3500 = t408 * t573;
  t3501 = t1152 * t575;
  t3502 = t3500 * t3501;
  t3503 = t407 * t3502;
  t3504 = 0.5e1 / 0.36e2 * t3503;
  t3505 = -t3436 - t3440 - t3443 - t3447 + t3452 - t3457 + t3486 + t3487 + t3492 + t3497 + t3499 - t3504;
  t3507 = t1136 * t1158;
  t3508 = 0.5e1 / 0.18e2 * t3507;
  t3509 = t54 * t564;
  t3510 = t3509 * t409;
  t3511 = t407 * t3510;
  t3512 = 0.595e3 / 0.324e3 * t3511;
  t3513 = t1147 * t1157;
  t3514 = t407 * t3513;
  t3515 = 0.35e2 / 0.27e2 * t3514;
  t3517 = t190 * t549 * t1132;
  t3518 = 0.1e3 / 0.243e3 * t3517;
  t3519 = t553 * t177;
  t3521 = t190 * t193 * t3519;
  t3522 = 0.1e3 / 0.243e3 * t3521;
  t3523 = t194 * t58;
  t3525 = t190 * t193 * t3523;
  t3526 = 0.55e3 / 0.729e3 * t3525;
  t3527 = t1136 * t1148;
  t3528 = 0.35e2 / 0.54e2 * t3527;
  t3529 = t2337 * t403;
  t3530 = t190 * t3529;
  t3531 = 0.25e2 / 0.324e3 * t3530;
  t3532 = t549 * t1128;
  t3533 = t190 * t3532;
  t3534 = 0.25e2 / 0.162e3 * t3533;
  t3535 = t2348 * t35;
  t3536 = t193 * t3535;
  t3537 = t190 * t3536;
  t3538 = 0.25e2 / 0.324e3 * t3537;
  t3539 = t1113 * t550;
  t3540 = 0.25e2 / 0.81e2 * t3539;
  t3541 = t1113 * t555;
  t3542 = 0.25e2 / 0.81e2 * t3541;
  t3543 = -t3508 - t3512 + t3515 - t3518 - t3522 + t3526 + t3528 + t3531 + t3534 + t3538 + t3540 + t3542;
  t3544 = t1113 * t559;
  t3545 = 0.25e2 / 0.162e3 * t3544;
  t3546 = t1109 * t189;
  t3547 = t3546 * t196;
  t3548 = 0.2e3 / 0.243e3 * t3547;
  t3549 = t523 * t50;
  t3550 = t3549 * t410;
  t3551 = 0.5e1 / 0.72e2 * t3550;
  t3552 = t1136 * t1162;
  t3553 = 0.5e1 / 0.36e2 * t3552;
  t3554 = t542 * t58;
  t3555 = t39 * t3554;
  t3556 = t1295 * t527;
  t3557 = t63 * t3556;
  t3558 = t3555 * t3557;
  t3559 = 0.25e3 / 0.243e3 * t3558;
  t3560 = t1147 * t1161;
  t3561 = t407 * t3560;
  t3562 = 0.35e2 / 0.54e2 * t3561;
  t3563 = t213 * t316;
  t3564 = t408 * t3563;
  t3565 = t407 * t3564;
  t3566 = 0.5e1 / 0.18e2 * t3565;
  t3567 = t63 * t791;
  t3568 = t408 * t3567;
  t3569 = t407 * t3568;
  t3570 = 0.5e1 / 0.72e2 * t3569;
  t3571 = t528 * t189;
  t3572 = t192 * t58;
  t3573 = t3572 * t61;
  t3574 = t3573 * t1651;
  t3575 = t3571 * t3574;
  t3576 = 0.25e2 / 0.162e3 * t3575;
  t3577 = t1147 * t206;
  t3578 = t3577 * t1153;
  t3579 = t407 * t3578;
  t3580 = 0.35e2 / 0.54e2 * t3579;
  t3581 = t62 * t316;
  t3582 = t3581 * t209;
  t3583 = t1151 * t3582;
  t3584 = t407 * t3583;
  t3585 = 0.5e1 / 0.36e2 * t3584;
  t3586 = t1152 * t583;
  t3587 = t1151 * t3586;
  t3588 = t407 * t3587;
  t3589 = 0.5e1 / 0.72e2 * t3588;
  t3590 = t3545 - t3548 - t3551 - t3553 - t3559 + t3562 - t3566 - t3570 + t3576 - t3580 + t3585 + t3589;
  tv3rho2sigma0 = t9 * (t3433 + t3505 + t3543 + t3590) + 0.2e1 * t1180 + 0.2e1 * t1181 - t1191 + t1194 + t1195 - t1196 + t1193 - t1186 - t1187 + t1185 + t1189 + t1190 - t1192 - t1197 + t1184 - t1188;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t3598 = 0.2e3 / 0.243e3 * t1134;
  t3599 = 0.35e2 / 0.27e2 * t1149;
  t3601 = 0.5e1 / 0.9e1 * t1159;
  t3610 = 0.2e2 / 0.27e2 * t1111;
  t3612 = t1202 * t316;
  t3613 = 0.2e1 * t3612;
  t3614 = 0.11e3 / 0.81e2 * t3459;
  t3621 = 0.11e4 / 0.729e3 * t3483;
  t3622 = t3614 + 0.4e3 / 0.243e3 * t3462 + 0.5e3 / 0.81e2 * t3465 - 0.25e2 / 0.81e2 * t3467 - 0.25e4 / 0.729e3 * t3471 - 0.8e4 / 0.729e3 * t3475 + 0.5e3 / 0.243e3 * t3479 - t3621;
  t3623 = t3622 * t146;
  t3624 = 0.35e3 / 0.243e3 * t3402;
  t3625 = 0.5e2 / 0.81e2 * t3406;
  t3626 = 0.25e2 / 0.81e2 * t3409;
  t3627 = 0.25e2 / 0.162e3 * t3412;
  t3628 = 0.5e1 / 0.36e2 * t3414;
  t3629 = 0.2e2 / 0.27e2 * t3416;
  t3630 = 0.2e2 / 0.27e2 * t3418;
  t3631 = 0.5e3 / 0.81e2 * t3421;
  t3632 = 0.11e3 / 0.81e2 * t3425;
  t3633 = 0.5e1 / 0.36e2 * t3427;
  t3634 = t3613 + t3623 - t3624 + t3625 + t3626 + t3627 - t3628 + t3629 + t3630 - t3631 - t3632 - t3633;
  t3635 = 0.5e1 / 0.18e2 * t3429;
  t3636 = 0.1e4 / 0.243e3 * t3435;
  t3637 = 0.5e3 / 0.243e3 * t3439;
  t3638 = 0.1e4 / 0.243e3 * t3442;
  t3639 = 0.5e1 / 0.18e2 * t3446;
  t3640 = 0.8e4 / 0.729e3 * t3451;
  t3641 = 0.25e2 / 0.81e2 * t3456;
  t3642 = t428 * t791;
  t3643 = 0.25e4 / 0.729e3 * t3491;
  t3644 = 0.5e1 / 0.9e1 * t3496;
  t3645 = 0.5e1 / 0.18e2 * t3498;
  t3646 = 0.5e1 / 0.18e2 * t3503;
  t3647 = -t3635 - t3636 - t3637 - t3638 - t3639 + t3640 - t3641 + t3642 + t3643 + t3644 + t3645 - t3646;
  t3649 = 0.5e1 / 0.9e1 * t3507;
  t3650 = 0.595e3 / 0.162e3 * t3511;
  t3651 = 0.7e2 / 0.27e2 * t3514;
  t3652 = 0.2e3 / 0.243e3 * t3517;
  t3653 = 0.2e3 / 0.243e3 * t3521;
  t3654 = 0.11e4 / 0.729e3 * t3525;
  t3655 = 0.35e2 / 0.27e2 * t3527;
  t3656 = 0.25e2 / 0.162e3 * t3530;
  t3657 = 0.25e2 / 0.81e2 * t3533;
  t3658 = 0.25e2 / 0.162e3 * t3537;
  t3659 = 0.5e2 / 0.81e2 * t3539;
  t3660 = 0.5e2 / 0.81e2 * t3541;
  t3661 = -t3649 - t3650 + t3651 - t3652 - t3653 + t3654 + t3655 + t3656 + t3657 + t3658 + t3659 + t3660;
  t3662 = 0.25e2 / 0.81e2 * t3544;
  t3663 = 0.4e3 / 0.243e3 * t3547;
  t3664 = 0.5e1 / 0.36e2 * t3550;
  t3665 = 0.5e1 / 0.18e2 * t3552;
  t3666 = 0.5e3 / 0.243e3 * t3558;
  t3667 = 0.35e2 / 0.27e2 * t3561;
  t3668 = 0.5e1 / 0.9e1 * t3565;
  t3669 = 0.5e1 / 0.36e2 * t3569;
  t3670 = 0.25e2 / 0.81e2 * t3575;
  t3671 = 0.35e2 / 0.27e2 * t3579;
  t3672 = 0.5e1 / 0.18e2 * t3584;
  t3673 = 0.5e1 / 0.36e2 * t3588;
  t3674 = t3662 - t3663 - t3664 - t3665 - t3666 + t3667 - t3668 - t3669 + t3670 - t3671 + t3672 + t3673;
  tv3rho2sigma1 = 0.2e1 * t1203 + 0.2e1 * t1204 - t3598 + t3599 + 0.5e1 / 0.18e2 * t1155 - t3601 + 0.25e2 / 0.81e2 * t1145 - 0.5e1 / 0.18e2 * t1116 - 0.5e1 / 0.18e2 * t1118 + 0.5e2 / 0.81e2 * t1114 + 0.25e2 / 0.81e2 * t1126 + 0.25e2 / 0.81e2 * t1130 - 0.5e1 / 0.18e2 * t1137 - 0.5e1 / 0.18e2 * t1163 + t3610 - 0.1e4 / 0.243e3 * t1123 + t9 * (t3634 + t3647 + t3661 + t3674);

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  tv3rho2sigma2 = tv3rho2sigma0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t3678 = -t1124 + t1246 + t1194 - t1164 + t1180 + t1208 + t1219 + t1223 - t1226 - t1237 + t1233 + t1115 + t1127 + t1131;
  t3679 = t420 * t951;
  t3680 = t3400 * t355;
  t3681 = t1141 * t3680;
  t3683 = t3404 * t355;
  t3684 = t1141 * t3683;
  t3686 = t3448 * t350;
  t3687 = t147 * t3686;
  t3688 = t543 * t3687;
  t3690 = t400 * t908;
  t3692 = t400 * t953;
  t3694 = t400 * t893;
  t3696 = t400 * t897;
  t3698 = t1110 * t366;
  t3700 = t1110 * t384;
  t3702 = t1179 * t382;
  t3703 = t1120 * t841;
  t3704 = t147 * t3703;
  t3705 = t543 * t3704;
  t3707 = t365 * t1121;
  t3708 = t543 * t3707;
  t3710 = t383 * t1121;
  t3711 = t543 * t3710;
  t3713 = t3420 * t855;
  t3715 = t217 * t1213;
  t3716 = t543 * t3715;
  t3718 = t317 * t1213;
  t3719 = t543 * t3718;
  t3722 = t3461 * t391;
  t3724 = t3464 * t963;
  t3726 = t1168 * t967;
  t3729 = t1240 * t180 * t50;
  t3730 = t2535 * t3729;
  t3732 = t177 * t350;
  t3733 = t806 * t3732;
  t3734 = t805 * t3733;
  t3736 = t35 * t841;
  t3737 = t806 * t3736;
  t3738 = t805 * t3737;
  t3741 = t3460 + 0.1e3 / 0.243e3 * t3462 + 0.1e3 / 0.243e3 * t3722 + 0.25e3 / 0.81e2 * t3724 - 0.25e2 / 0.162e3 * t3726 - 0.125e4 / 0.729e3 * t3730 - 0.2e4 / 0.729e3 * t3734 + 0.25e3 / 0.243e3 * t3738 - 0.2e4 / 0.729e3 * t3475 - t3484;
  t3742 = t3741 * t146;
  t3743 = t3679 - 0.175e3 / 0.486e3 * t3681 + 0.25e2 / 0.162e3 * t3684 + 0.2e4 / 0.729e3 * t3688 - 0.5e1 / 0.72e2 * t3690 - 0.5e1 / 0.72e2 * t3692 - 0.5e1 / 0.72e2 * t3694 - 0.5e1 / 0.72e2 * t3696 + 0.5e1 / 0.27e2 * t3698 + 0.5e1 / 0.27e2 * t3700 + t3702 - 0.25e3 / 0.243e3 * t3705 - 0.25e3 / 0.243e3 * t3708 - 0.25e3 / 0.243e3 * t3711 - 0.25e3 / 0.81e2 * t3713 - 0.25e3 / 0.243e3 * t3716 - 0.25e3 / 0.243e3 * t3719 + t3742;
  t3744 = t1244 * t316;
  t3749 = t1224 * t1158;
  t3751 = t3546 * t356;
  t3754 = t190 * t871 * t1132;
  t3756 = t902 * t177;
  t3758 = t190 * t193 * t3756;
  t3761 = t190 * t2586 * t403;
  t3764 = t190 * t871 * t1128;
  t3767 = t190 * t549 * t1220;
  t3769 = t2569 * t35;
  t3771 = t190 * t193 * t3769;
  t3773 = t1113 * t858;
  t3775 = t1113 * t862;
  t3777 = t1113 * t866;
  t3779 = t1113 * t872;
  t3781 = t3744 - 0.175e3 / 0.486e3 * t3402 - 0.25e2 / 0.162e3 * t3406 + 0.5e1 / 0.27e2 * t3416 + 0.5e1 / 0.27e2 * t3418 - t3426 - 0.5e1 / 0.36e2 * t3749 - 0.1e3 / 0.243e3 * t3751 - 0.5e2 / 0.243e3 * t3754 - 0.5e2 / 0.243e3 * t3758 + 0.25e2 / 0.324e3 * t3761 + 0.25e2 / 0.324e3 * t3764 + 0.25e2 / 0.324e3 * t3767 + 0.25e2 / 0.324e3 * t3771 + 0.25e2 / 0.162e3 * t3773 + 0.25e2 / 0.162e3 * t3775 + 0.25e2 / 0.162e3 * t3777 + 0.25e2 / 0.162e3 * t3779;
  t3783 = t1147 * t1234;
  t3784 = t407 * t3783;
  t3786 = t213 * t382;
  t3787 = t408 * t3786;
  t3788 = t407 * t3787;
  t3790 = t1224 * t1148;
  t3792 = t1136 * t1235;
  t3794 = t63 * t951;
  t3795 = t408 * t3794;
  t3796 = t407 * t3795;
  t3798 = t842 * t50;
  t3799 = t3798 * t410;
  t3801 = t1224 * t1162;
  t3803 = t1113 * t904;
  t3806 = t1143 * t865;
  t3807 = t1141 * t3806;
  t3809 = t1514 * t209;
  t3810 = t1338 * t3809;
  t3811 = t154 * t3810;
  t3813 = t1143 * t903;
  t3814 = t1141 * t3813;
  t3816 = t351 * t185;
  t3817 = t3816 * t1140;
  t3818 = t3817 * t1144;
  t3821 = t1141 * t1143 * t861;
  t3823 = t3577 * t1230;
  t3824 = t407 * t3823;
  t3826 = t3493 * t360;
  t3827 = t1151 * t3826;
  t3828 = t407 * t3827;
  t3830 = t1152 * t886;
  t3831 = t1151 * t3830;
  t3832 = t407 * t3831;
  t3834 = 0.35e2 / 0.108e3 * t3784 - 0.5e1 / 0.36e2 * t3788 + 0.35e2 / 0.108e3 * t3790 - 0.5e1 / 0.72e2 * t3792 - 0.5e1 / 0.72e2 * t3796 - 0.5e1 / 0.72e2 * t3799 - 0.5e1 / 0.72e2 * t3801 + 0.25e2 / 0.162e3 * t3803 + t3447 + 0.2e4 / 0.729e3 * t3451 + 0.25e2 / 0.324e3 * t3807 - 0.5e1 / 0.36e2 * t3811 + 0.25e2 / 0.324e3 * t3814 + 0.25e2 / 0.162e3 * t3818 + 0.25e2 / 0.324e3 * t3821 - 0.35e2 / 0.108e3 * t3824 + 0.5e1 / 0.36e2 * t3828 + 0.5e1 / 0.72e2 * t3832;
  t3835 = t62 * t382;
  t3836 = t3835 * t209;
  t3837 = t1151 * t3836;
  t3838 = t407 * t3837;
  t3840 = t1224 * t1154;
  t3842 = t409 * t854;
  t3843 = t3555 * t3842;
  t3845 = t1136 * t1231;
  t3847 = t3581 * t360;
  t3848 = t1151 * t3847;
  t3849 = t407 * t3848;
  t3851 = t3488 * t350;
  t3853 = t180 * t40 * t152;
  t3854 = t3851 * t3853;
  t3855 = t2556 * t3854;
  t3857 = t350 * t209;
  t3858 = t194 * t3857;
  t3859 = t1354 * t3858;
  t3860 = t1141 * t3859;
  t3862 = t1514 * t326;
  t3863 = t1354 * t3862;
  t3864 = t1141 * t3863;
  t3875 = 0.5e1 / 0.72e2 * t3838 + 0.5e1 / 0.72e2 * t3840 - 0.25e3 / 0.243e3 * t3843 + 0.5e1 / 0.72e2 * t3845 + 0.5e1 / 0.72e2 * t3849 + 0.125e4 / 0.729e3 * t3855 - 0.25e2 / 0.324e3 * t3860 - 0.25e2 / 0.324e3 * t3864 - 0.5e1 / 0.36e2 * t3496 + 0.5e1 / 0.36e2 * t3507 - t3512 - 0.5e2 / 0.243e3 * t3517 - 0.5e2 / 0.243e3 * t3521 + t3526 + 0.35e2 / 0.108e3 * t3527 - 0.1e3 / 0.243e3 * t3547 + 0.35e2 / 0.108e3 * t3561 + 0.5e1 / 0.36e2 * t3565 - 0.35e2 / 0.108e3 * t3579;
  t3879 = -t1191 - t1138 + t1181 - t1210 - t1212 + t1245 + t1184 - t1117 - t1119 + t1156 + t1146 + t1229 - t1216 + t9 * (t3743 + t3781 + t3834 + t3875);
  tv3rho2sigma3 = t3678 + t3879;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  t3880 = -t1188 + t3599 - t1197 + t1263 + t1249 + t1253 + t1254 - t1255 - t1258 + t1257 + t1185 + t1189 + t1190 - t3598;
  t3881 = t1202 * t382;
  t3882 = 0.175e3 / 0.243e3 * t3681;
  t3883 = 0.25e2 / 0.81e2 * t3684;
  t3884 = 0.4e4 / 0.729e3 * t3688;
  t3885 = 0.5e1 / 0.36e2 * t3690;
  t3886 = 0.5e1 / 0.36e2 * t3692;
  t3887 = 0.5e1 / 0.36e2 * t3694;
  t3888 = 0.5e1 / 0.36e2 * t3696;
  t3889 = 0.1e2 / 0.27e2 * t3698;
  t3890 = 0.1e2 / 0.27e2 * t3700;
  t3891 = t428 * t951;
  t3892 = 0.5e3 / 0.243e3 * t3705;
  t3893 = 0.5e3 / 0.243e3 * t3708;
  t3894 = 0.5e3 / 0.243e3 * t3711;
  t3895 = 0.5e3 / 0.81e2 * t3713;
  t3896 = 0.5e3 / 0.243e3 * t3716;
  t3897 = 0.5e3 / 0.243e3 * t3719;
  t3898 = t3881 - t3882 + t3883 + t3884 - t3885 - t3886 - t3887 - t3888 + t3889 + t3890 + t3891 - t3892 - t3893 - t3894 - t3895 - t3896 - t3897 - t3403;
  t3899 = t1261 * t316;
  t3900 = 0.5e1 / 0.18e2 * t3749;
  t3901 = 0.2e3 / 0.243e3 * t3751;
  t3902 = 0.1e3 / 0.243e3 * t3754;
  t3903 = 0.1e3 / 0.243e3 * t3758;
  t3904 = 0.25e2 / 0.162e3 * t3761;
  t3905 = 0.25e2 / 0.162e3 * t3764;
  t3906 = 0.25e2 / 0.162e3 * t3767;
  t3907 = 0.25e2 / 0.162e3 * t3771;
  t3908 = 0.25e2 / 0.81e2 * t3773;
  t3909 = 0.25e2 / 0.81e2 * t3775;
  t3910 = 0.25e2 / 0.81e2 * t3777;
  t3911 = 0.25e2 / 0.81e2 * t3779;
  t3912 = 0.35e2 / 0.54e2 * t3784;
  t3913 = -t3407 + t3417 + t3419 - t3632 + t3899 - t3900 - t3901 - t3902 - t3903 + t3904 + t3905 + t3906 + t3907 + t3908 + t3909 + t3910 + t3911 + t3912;
  t3915 = 0.5e1 / 0.18e2 * t3788;
  t3916 = 0.35e2 / 0.54e2 * t3790;
  t3917 = 0.5e1 / 0.36e2 * t3792;
  t3918 = 0.5e1 / 0.36e2 * t3796;
  t3919 = 0.5e1 / 0.36e2 * t3799;
  t3920 = 0.5e1 / 0.36e2 * t3801;
  t3921 = 0.25e2 / 0.81e2 * t3803;
  t3922 = 0.2e3 / 0.243e3 * t3722;
  t3926 = 0.4e4 / 0.729e3 * t3734;
  t3928 = t3614 + t3463 + t3922 + 0.5e3 / 0.81e2 * t3724 - 0.25e2 / 0.81e2 * t3726 - 0.25e4 / 0.729e3 * t3730 - t3926 + 0.5e3 / 0.243e3 * t3738 - t3476 - t3621;
  t3929 = t3928 * t146;
  t3930 = 0.25e2 / 0.162e3 * t3807;
  t3931 = 0.5e1 / 0.18e2 * t3811;
  t3932 = 0.25e2 / 0.162e3 * t3814;
  t3933 = 0.25e2 / 0.81e2 * t3818;
  t3934 = 0.25e2 / 0.162e3 * t3821;
  t3935 = 0.35e2 / 0.54e2 * t3824;
  t3936 = 0.5e1 / 0.18e2 * t3828;
  t3937 = 0.5e1 / 0.36e2 * t3832;
  t3938 = -t3915 + t3916 - t3917 - t3918 - t3919 - t3920 + t3921 + t3929 + t3639 + t3452 + t3930 - t3931 + t3932 + t3933 + t3934 - t3935 + t3936 + t3937;
  t3939 = 0.5e1 / 0.36e2 * t3838;
  t3940 = 0.5e1 / 0.36e2 * t3840;
  t3941 = 0.5e3 / 0.243e3 * t3843;
  t3942 = 0.5e1 / 0.36e2 * t3845;
  t3943 = 0.5e1 / 0.36e2 * t3849;
  t3944 = 0.25e4 / 0.729e3 * t3855;
  t3945 = 0.25e2 / 0.162e3 * t3860;
  t3946 = 0.25e2 / 0.162e3 * t3864;
  t3947 = t3939 + t3940 - t3941 + t3942 + t3943 + t3944 - t3945 - t3946 - t3497 + t3508 - t3650 - t3518 - t3522 + t3654 + t3528 - t3548 + t3562 + t3566 - t3580;
  t3951 = -t1192 + t1262 - t1250 - t1251 + t1203 + t3610 - t1186 - t1187 + t9 * (t3898 + t3913 + t3938 + t3947) + t1195 + t1204 + t1193 + t1256 - t1252;
  tv3rho2sigma4 = t3880 + t3951;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  tv3rho2sigma5 = tv3rho2sigma3;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t3952 = t1008 * t50;
  t3953 = t3952 * t410;
  t3954 = 0.5e1 / 0.72e2 * t3953;
  t3955 = t1224 * t1235;
  t3956 = 0.5e1 / 0.36e2 * t3955;
  t3957 = t1295 * t1012;
  t3958 = t63 * t3957;
  t3959 = t3555 * t3958;
  t3960 = 0.25e3 / 0.243e3 * t3959;
  t3961 = t63 * t1084;
  t3962 = t408 * t3961;
  t3963 = t407 * t3962;
  t3964 = 0.5e1 / 0.72e2 * t3963;
  t3965 = t871 * t1220;
  t3966 = t190 * t3965;
  t3967 = 0.25e2 / 0.162e3 * t3966;
  t3968 = t3123 * t35;
  t3969 = t193 * t3968;
  t3970 = t190 * t3969;
  t3971 = 0.25e2 / 0.324e3 * t3970;
  t3972 = t3132 * t403;
  t3973 = t190 * t3972;
  t3974 = 0.25e2 / 0.324e3 * t3973;
  t3975 = t1113 * t1025;
  t3976 = 0.25e2 / 0.81e2 * t3975;
  t3977 = t1113 * t1029;
  t3978 = 0.25e2 / 0.81e2 * t3977;
  t3979 = -t3954 - t3956 - t3960 - t3964 + t3967 + t3971 + t3974 + t3976 + t3978 - t3882 - t3883 + t3884;
  t3980 = t365 * t1213;
  t3981 = t543 * t3980;
  t3982 = 0.5e3 / 0.243e3 * t3981;
  t3983 = t383 * t1213;
  t3984 = t543 * t3983;
  t3985 = 0.5e3 / 0.243e3 * t3984;
  t3986 = t1120 * t1007;
  t3987 = t147 * t3986;
  t3988 = t543 * t3987;
  t3989 = 0.25e3 / 0.243e3 * t3988;
  t3990 = t420 * t1084;
  t3991 = t1152 * t1037;
  t3992 = t3500 * t3991;
  t3993 = t407 * t3992;
  t3994 = 0.5e1 / 0.36e2 * t3993;
  t3995 = t1224 * t1231;
  t3996 = 0.5e1 / 0.36e2 * t3995;
  t3997 = t1013 * t189;
  t3998 = t3997 * t3574;
  t3999 = 0.25e2 / 0.162e3 * t3998;
  t4000 = t3835 * t360;
  t4001 = t1151 * t4000;
  t4002 = t407 * t4001;
  t4003 = 0.5e1 / 0.36e2 * t4002;
  t4004 = t1152 * t1042;
  t4005 = t1151 * t4004;
  t4006 = t407 * t4005;
  t4007 = 0.5e1 / 0.72e2 * t4006;
  t4008 = -t3982 - t3985 - t3989 + t3889 + t3890 + t3990 - t3426 - t3994 + t3996 + t3999 + t4003 + t4007;
  t4010 = t1113 * t1033;
  t4011 = 0.25e2 / 0.162e3 * t4010;
  t4012 = t400 * t1086;
  t4013 = 0.5e1 / 0.72e2 * t4012;
  t4014 = t350 * t360;
  t4015 = t194 * t4014;
  t4016 = t1354 * t4015;
  t4017 = t1141 * t4016;
  t4018 = 0.25e2 / 0.162e3 * t4017;
  t4019 = t4011 - t4013 + t3900 - t3901 - t3902 - t3903 + t3912 + t3915 + t3916 - t3447 - t4018 - t3935;
  t4021 = t1141 * t1143 * t1032;
  t4022 = 0.25e2 / 0.324e3 * t4021;
  t4024 = t3488 * t1012 * t50;
  t4025 = t2556 * t4024;
  t4026 = 0.125e4 / 0.729e3 * t4025;
  t4028 = t1141 * t1143 * t1028;
  t4029 = 0.25e2 / 0.162e3 * t4028;
  t4030 = t3420 * t1022;
  t4031 = 0.25e3 / 0.81e2 * t4030;
  t4032 = t400 * t1048;
  t4033 = 0.5e1 / 0.72e2 * t4032;
  t4034 = t400 * t1052;
  t4035 = 0.5e1 / 0.36e2 * t4034;
  t4036 = t1244 * t382;
  t4037 = 0.2e1 * t4036;
  t4038 = t3464 * t1095;
  t4040 = t1168 * t1099;
  t4042 = t35 * t1012;
  t4044 = t2535 * t4042 * t50;
  t4046 = t35 * t1007;
  t4047 = t806 * t4046;
  t4048 = t805 * t4047;
  t4050 = t3460 + t3922 + 0.25e3 / 0.81e2 * t4038 - 0.25e2 / 0.162e3 * t4040 - 0.125e4 / 0.729e3 * t4044 - t3926 + 0.25e3 / 0.243e3 * t4048 - t3484;
  t4051 = t4050 * t146;
  t4052 = -t3936 + t4022 + t4026 + t4029 - t4031 - t4033 - t4035 + t4037 + t4051 - t3512 - t3515 + t3526;
  tv3rho2sigma6 = t9 * (t3979 + t4008 + t4019 + t4052) + 0.2e1 * t1245 + 0.2e1 * t1246 + t1257 - t1191 + t1194 + t1196 + t1256 - t1250 - t1251 + t1249 + t1253 + t1254 - t1255 - t1258 - t1252 + t1184;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  t4070 = 0.5e1 / 0.36e2 * t3953;
  t4071 = 0.5e1 / 0.18e2 * t3955;
  t4072 = 0.5e3 / 0.243e3 * t3959;
  t4073 = 0.5e1 / 0.36e2 * t3963;
  t4074 = 0.25e2 / 0.81e2 * t3966;
  t4075 = 0.25e2 / 0.162e3 * t3970;
  t4076 = 0.25e2 / 0.162e3 * t3973;
  t4077 = 0.5e2 / 0.81e2 * t3975;
  t4078 = 0.5e2 / 0.81e2 * t3977;
  t4079 = 0.35e3 / 0.243e3 * t3681;
  t4080 = 0.5e2 / 0.81e2 * t3684;
  t4081 = 0.8e4 / 0.729e3 * t3688;
  t4082 = -t4070 - t4071 - t4072 - t4073 + t4074 + t4075 + t4076 + t4077 + t4078 - t4079 - t4080 + t4081;
  t4083 = 0.1e4 / 0.243e3 * t3981;
  t4084 = 0.1e4 / 0.243e3 * t3984;
  t4085 = 0.5e3 / 0.243e3 * t3988;
  t4086 = 0.2e2 / 0.27e2 * t3698;
  t4087 = 0.2e2 / 0.27e2 * t3700;
  t4088 = 0.5e1 / 0.18e2 * t3993;
  t4089 = 0.5e1 / 0.18e2 * t3995;
  t4090 = 0.25e2 / 0.81e2 * t3998;
  t4091 = 0.5e1 / 0.18e2 * t4002;
  t4092 = 0.5e1 / 0.36e2 * t4006;
  t4093 = 0.25e2 / 0.81e2 * t4010;
  t4094 = -t4083 - t4084 - t4085 + t4086 + t4087 - t3632 - t4088 + t4089 + t4090 + t4091 + t4092 + t4093;
  t4096 = 0.5e1 / 0.36e2 * t4012;
  t4097 = 0.5e1 / 0.9e1 * t3749;
  t4098 = 0.4e3 / 0.243e3 * t3751;
  t4099 = 0.2e3 / 0.243e3 * t3754;
  t4100 = 0.2e3 / 0.243e3 * t3758;
  t4101 = 0.35e2 / 0.27e2 * t3784;
  t4102 = 0.5e1 / 0.9e1 * t3788;
  t4103 = 0.35e2 / 0.27e2 * t3790;
  t4104 = 0.25e2 / 0.81e2 * t4017;
  t4105 = 0.35e2 / 0.27e2 * t3824;
  t4106 = 0.5e1 / 0.9e1 * t3828;
  t4107 = -t4096 + t4097 - t4098 - t4099 - t4100 + t4101 + t4102 + t4103 - t3639 - t4104 - t4105 - t4106;
  t4108 = t1261 * t382;
  t4109 = 0.2e1 * t4108;
  t4116 = t3614 + 0.4e3 / 0.243e3 * t3722 + 0.5e3 / 0.81e2 * t4038 - 0.25e2 / 0.81e2 * t4040 - 0.25e4 / 0.729e3 * t4044 - 0.8e4 / 0.729e3 * t3734 + 0.5e3 / 0.243e3 * t4048 - t3621;
  t4117 = t4116 * t146;
  t4118 = 0.25e2 / 0.162e3 * t4021;
  t4119 = 0.25e4 / 0.729e3 * t4025;
  t4120 = 0.25e2 / 0.81e2 * t4028;
  t4121 = 0.5e3 / 0.81e2 * t4030;
  t4122 = 0.5e1 / 0.36e2 * t4032;
  t4123 = 0.5e1 / 0.18e2 * t4034;
  t4124 = t428 * t1084;
  t4125 = t4109 + t4117 + t4118 + t4119 + t4120 - t4121 - t4122 - t4123 + t4124 - t3650 - t3651 + t3654;
  tv3rho2sigma7 = 0.2e1 * t1262 + 0.2e1 * t1263 + 0.5e1 / 0.18e2 * t1232 - t3598 + t3599 + t3601 + 0.25e2 / 0.81e2 * t1228 - 0.5e1 / 0.18e2 * t1209 - 0.5e1 / 0.18e2 * t1211 + 0.5e2 / 0.81e2 * t1207 + 0.25e2 / 0.81e2 * t1218 + 0.25e2 / 0.81e2 * t1222 - 0.5e1 / 0.18e2 * t1225 - 0.5e1 / 0.18e2 * t1236 - 0.1e4 / 0.243e3 * t1215 + t3610 + t9 * (t4082 + t4094 + t4107 + t4125);

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  tv3rho2sigma8 = tv3rho2sigma6;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t4129 = t207 * t1314;
  t4130 = t180 * t167;
  t4131 = t194 * t4130;
  t4132 = t4129 * t4131;
  t4133 = t1838 * t4132;
  t4134 = 0.125e3 / 0.486e3 * t4133;
  t4135 = t574 * t1296;
  t4136 = t4135 * t3454;
  t4137 = t1838 * t4136;
  t4138 = 0.25e2 / 0.81e2 * t4137;
  t4139 = t1324 * t8;
  t4140 = t4139 * t1356;
  t4141 = t1336 * t4140;
  t4142 = 0.25e2 / 0.54e2 * t4141;
  t4143 = t321 * t1335;
  t4144 = t4143 * t1357;
  t4145 = 0.25e2 / 0.108e3 * t4144;
  t4146 = t799 * t1322;
  t4147 = t1354 * t1695;
  t4148 = t4146 * t4147;
  t4149 = 0.25e2 / 0.162e3 * t4148;
  t4150 = t201 * t573;
  t4151 = t4150 * t62;
  t4152 = t4151 * t1340;
  t4153 = t1336 * t4152;
  t4154 = 0.35e2 / 0.27e2 * t4153;
  t4155 = t201 * t206;
  t4156 = t4155 * t62;
  t4157 = t4156 * t1356;
  t4158 = t1336 * t4157;
  t4159 = 0.175e3 / 0.162e3 * t4158;
  t4160 = t316 * t209;
  t4161 = t1296 * t4160;
  t4162 = t1338 * t4161;
  t4163 = t1336 * t4162;
  t4164 = 0.5e1 / 0.18e2 * t4163;
  t4165 = t4143 * t1341;
  t4166 = 0.5e1 / 0.18e2 * t4165;
  t4167 = t6 * t501;
  t4168 = t146 * t502;
  t4169 = t4167 * t4168;
  t4170 = t1354 * t4169;
  t4171 = t1336 * t4170;
  t4172 = 0.25e2 / 0.324e3 * t4171;
  t4173 = t58 * t2378;
  t4174 = t4173 * t62;
  t4175 = t146 * t575;
  t4176 = t1296 * t4175;
  t4177 = t4174 * t4176;
  t4178 = t1336 * t4177;
  t4179 = 0.5e1 / 0.12e2 * t4178;
  t4180 = t549 * t316;
  t4181 = t4180 * t441;
  t4182 = t190 * t4181;
  t4183 = 0.1e3 / 0.81e2 * t4182;
  t4184 = t193 * t791;
  t4185 = t4184 * t441;
  t4186 = t190 * t4185;
  t4187 = 0.5e2 / 0.81e2 * t4186;
  t4188 = t325 * t216;
  t4189 = t4188 * t195;
  t4190 = t1279 * t4189;
  t4191 = 0.2e3 / 0.81e2 * t4190;
  t4192 = t1280 * t554;
  t4193 = t1279 * t4192;
  t4194 = 0.2e3 / 0.81e2 * t4193;
  t4195 = t1280 * t558;
  t4196 = t1279 * t4195;
  t4197 = 0.1e3 / 0.81e2 * t4196;
  t4198 = t160 * t15;
  t4199 = t4198 * t1355;
  t4200 = t1354 * t4199;
  t4201 = t1336 * t4200;
  t4202 = 0.125e3 / 0.324e3 * t4201;
  t4203 = t316 * t167;
  t4204 = t1314 * t4203;
  t4205 = t1354 * t4204;
  t4206 = t1336 * t4205;
  t4207 = 0.25e2 / 0.108e3 * t4206;
  t4208 = t146 * t508;
  t4209 = t1314 * t4208;
  t4210 = t1354 * t4209;
  t4211 = t1336 * t4210;
  t4212 = 0.25e2 / 0.216e3 * t4211;
  t4213 = -t4134 + t4138 + t4142 + t4145 - t4149 + t4154 - t4159 - t4164 - t4166 + t4172 + t4179 - t4183 - t4187 - t4191 - t4194 - t4197 - t4202 + t4207 + t4212;
  t4214 = t146 * t583;
  t4215 = t1296 * t4214;
  t4216 = t1338 * t4215;
  t4217 = t1336 * t4216;
  t4218 = 0.5e1 / 0.36e2 * t4217;
  t4219 = t2 * t495;
  t4220 = t4219 * t432;
  t4221 = t4220 * t436;
  t4222 = 0.2e3 / 0.81e2 * t4221;
  t4223 = t1389 * t316;
  t4224 = 0.2e1 * t4223;
  t4225 = t8 * t160;
  t4226 = t4225 * t447;
  t4227 = t445 * t4226;
  t4228 = t154 * t4227;
  t4229 = 0.25e2 / 0.54e2 * t4228;
  t4230 = t62 * t495;
  t4231 = t4230 * t447;
  t4232 = t445 * t4231;
  t4233 = t154 * t4232;
  t4234 = 0.25e2 / 0.81e2 * t4233;
  t4235 = t322 * t1351;
  t4236 = 0.25e2 / 0.108e3 * t4235;
  t4237 = t565 * t206;
  t4238 = t4237 * t448;
  t4239 = t154 * t4238;
  t4240 = 0.595e3 / 0.324e3 * t4239;
  t4241 = t1330 * t1345;
  t4242 = t154 * t4241;
  t4243 = 0.35e2 / 0.27e2 * t4242;
  t4244 = t1330 * t1350;
  t4245 = t154 * t4244;
  t4246 = 0.175e3 / 0.162e3 * t4245;
  t4247 = t1337 * t446;
  t4248 = t15 * t146;
  t4249 = t209 * t167;
  t4250 = t4248 * t4249;
  t4251 = t4247 * t4250;
  t4252 = t1336 * t4251;
  t4253 = 0.25e2 / 0.54e2 * t4252;
  t4254 = t1360 * t326;
  t4255 = t1325 * t4254;
  t4256 = t1323 * t4255;
  t4257 = 0.25e2 / 0.162e3 * t4256;
  t4258 = t447 * t810;
  t4259 = t1325 * t4258;
  t4260 = t1323 * t4259;
  t4261 = 0.25e2 / 0.324e3 * t4260;
  t4262 = t160 * t16;
  t4263 = t4262 * t180;
  t4264 = t1295 * t4263;
  t4265 = t1294 * t4264;
  t4266 = 0.2e5 / 0.729e3 * t4265;
  t4267 = t501 * t40;
  t4268 = t4267 * t44;
  t4269 = t431 * t4268;
  t4271 = t55 * t147 * t502;
  t4272 = t4269 * t4271;
  t4273 = 0.5e2 / 0.81e2 * t4272;
  t4274 = t4155 * t446;
  t4275 = t4274 * t1326;
  t4276 = t1323 * t4275;
  t4277 = 0.175e3 / 0.243e3 * t4276;
  t4278 = t1324 * t1344;
  t4279 = t4278 * t1326;
  t4280 = t1323 * t4279;
  t4281 = 0.25e2 / 0.81e2 * t4280;
  t4282 = t1324 * t1349;
  t4283 = t4282 * t1326;
  t4284 = t1323 * t4283;
  t4285 = 0.125e3 / 0.486e3 * t4284;
  t4286 = t1266 * t1278;
  t4287 = t4286 * t1281;
  t4288 = 0.1e4 / 0.243e3 * t4287;
  t4289 = t1266 * t1271;
  t4290 = t4289 * t1274;
  t4291 = 0.25e3 / 0.81e2 * t4290;
  t4292 = -t4218 + t4222 + t4224 - t4229 + t4234 - t4236 + t4240 - t4243 + t4246 - t4253 - t4257 - t4261 - t4266 + t4273 + t4277 - t4281 + t4285 + t4288 - t4291;
  t4295 = t55 * t217 * t167;
  t4296 = t1272 * t4295;
  t4297 = 0.5e2 / 0.27e2 * t4296;
  t4299 = t55 * t317 * t167;
  t4300 = t1272 * t4299;
  t4301 = 0.5e2 / 0.27e2 * t4300;
  t4303 = t55 * t147 * t508;
  t4304 = t1272 * t4303;
  t4305 = 0.25e2 / 0.27e2 * t4304;
  t4306 = t542 * t216;
  t4307 = t39 * t4306;
  t4308 = t4307 * t1298;
  t4309 = 0.4e4 / 0.243e3 * t4308;
  t4310 = t316 * t544;
  t4311 = t4310 * t1297;
  t4312 = t1294 * t4311;
  t4313 = 0.4e4 / 0.243e3 * t4312;
  t4314 = t1296 * t522;
  t4315 = t1295 * t4314;
  t4316 = t1294 * t4315;
  t4317 = 0.2e4 / 0.243e3 * t4316;
  t4318 = t459 * t791;
  t4320 = params->c * t495 * t16;
  t4321 = t439 * t4320;
  t4322 = t190 * t4321;
  t4323 = 0.2e4 / 0.729e3 * t4322;
  t4324 = t1301 * t1310;
  t4325 = t190 * t4324;
  t4326 = 0.5e3 / 0.243e3 * t4325;
  t4327 = t1305 * t1310;
  t4328 = t190 * t4327;
  t4329 = 0.5e3 / 0.243e3 * t4328;
  t4330 = t1295 * t6;
  t4331 = t15 * t180;
  t4332 = t4331 * t167;
  t4333 = t4330 * t4332;
  t4334 = t1294 * t4333;
  t4335 = 0.2e5 / 0.729e3 * t4334;
  t4336 = t2337 * t146;
  t4337 = t4336 * t441;
  t4338 = t190 * t4337;
  t4339 = 0.5e2 / 0.81e2 * t4338;
  t4340 = t1337 * t8;
  t4341 = t4340 * t1340;
  t4342 = t1336 * t4341;
  t4343 = 0.5e1 / 0.9e1 * t4342;
  t4344 = t4262 * t1339;
  t4345 = t1338 * t4344;
  t4346 = t1336 * t4345;
  t4347 = 0.25e2 / 0.54e2 * t4346;
  t4349 = t152 * t434 * t791;
  t4350 = t433 * t4349;
  t4351 = 0.5e1 / 0.9e1 * t4350;
  t4352 = t1267 * t1286;
  t4353 = 0.5e2 / 0.27e2 * t4352;
  t4354 = t1267 * t1290;
  t4355 = 0.5e2 / 0.27e2 * t4354;
  t4356 = t16 * t539;
  t4357 = t431 * t4356;
  t4358 = t2325 * t3556;
  t4359 = t4357 * t4358;
  t4360 = 0.2e4 / 0.81e2 * t4359;
  t4361 = t54 * t589;
  t4363 = t152 * t4361 * t146;
  t4364 = t433 * t4363;
  t4365 = 0.5e1 / 0.9e1 * t4364;
  t4366 = t4297 + t4301 + t4305 + t4309 + t4313 + t4317 + t4318 - t4323 + t4326 + t4329 + t4335 - t4339 - t4343 + t4347 + t4351 - t4353 - t4355 + t4360 + t4365;
  t4368 = t152 * t1284 * t316;
  t4369 = t433 * t4368;
  t4370 = 0.1e2 / 0.9e1 * t4369;
  t4371 = t445 * t1703;
  t4372 = t154 * t4371;
  t4373 = 0.5e1 / 0.36e2 * t4372;
  t4374 = t4167 * t502;
  t4375 = t530 * t4374;
  t4376 = t1141 * t4375;
  t4377 = 0.5e3 / 0.729e3 * t4376;
  t4378 = t4198 * t167;
  t4380 = t1141 * t530 * t4378;
  t4381 = 0.25e4 / 0.729e3 * t4380;
  t4382 = t1314 * t508;
  t4384 = t1141 * t530 * t4382;
  t4385 = 0.25e3 / 0.243e3 * t4384;
  t4387 = t1141 * t1980 * t1315;
  t4388 = 0.5e3 / 0.243e3 * t4387;
  t4390 = t1141 * t1984 * t1315;
  t4391 = 0.5e3 / 0.243e3 * t4390;
  t4392 = t431 * t15;
  t4393 = t4392 * t189;
  t4394 = t167 * params->c;
  t4395 = t4394 * t180;
  t4396 = t439 * t4395;
  t4397 = t4393 * t4396;
  t4398 = 0.1e4 / 0.243e3 * t4397;
  t4399 = t542 * t545;
  t4402 = t801 * t4382;
  t4406 = t15 * t185 * t187;
  t4407 = t431 * t4406;
  t4408 = t325 * t4395;
  t4411 = t325 * t4320;
  t4421 = t1296 * t527 * t50;
  t4424 = t544 * t160;
  t4428 = t1378 * t4332;
  t4431 = t1266 * t1277;
  t4434 = t431 * t4267;
  t4436 = t152 * t54 * t502;
  t4440 = t800 * t801 * t522;
  t4446 = t1266 * t1270;
  t4450 = t152 * t54 * t508;
  t4453 = t16 * t522;
  t4457 = -0.2e4 / 0.81e2 * t452 * t4399 + 0.25e3 / 0.243e3 * t190 * t4402 + 0.1e4 / 0.243e3 * t4407 * t4408 + 0.2e4 / 0.729e3 * t324 * t4411 - 0.25e4 / 0.729e3 * t190 * t801 * t4378 + 0.5e3 / 0.729e3 * t190 * t801 * t4374 + 0.1e5 / 0.729e3 * t2535 * t4421 + 0.2e5 / 0.729e3 * t543 * t4424 * t1379 - 0.2e5 / 0.729e3 * t543 * t4428 - 0.1e4 / 0.243e3 * t4431 * t1375 - 0.5e2 / 0.81e2 * t4434 * t4436 + 0.1e3 / 0.81e2 * t1373 * t4440 - 0.2e3 / 0.81e2 * t4219 * t16 * t453 + 0.25e3 / 0.81e2 * t4446 * t1370 - 0.25e2 / 0.27e2 * t1368 * t4450 - 0.2e4 / 0.243e3 * t543 * t1378 * t4453;
  t4458 = t4457 * t146;
  t4459 = t322 * t1331;
  t4460 = 0.35e2 / 0.54e2 * t4459;
  t4461 = t322 * t1346;
  t4462 = 0.5e1 / 0.18e2 * t4461;
  t4463 = t1344 * t1360;
  t4464 = t445 * t4463;
  t4465 = t154 * t4464;
  t4466 = 0.5e1 / 0.18e2 * t4465;
  t4467 = t1349 * t1360;
  t4468 = t445 * t4467;
  t4469 = t154 * t4468;
  t4470 = 0.25e2 / 0.108e3 * t4469;
  t4471 = t16 * t791;
  t4472 = t446 * t4471;
  t4473 = t445 * t4472;
  t4474 = t154 * t4473;
  t4475 = 0.5e1 / 0.72e2 * t4474;
  t4476 = t797 * t449;
  t4477 = 0.5e1 / 0.72e2 * t4476;
  t4478 = t322 * t1362;
  t4479 = 0.5e1 / 0.36e2 * t4478;
  t4480 = t541 * t30;
  t4481 = t4480 * t58;
  t4482 = t805 * t4481;
  t4483 = t207 * t6;
  t4484 = t447 * t545;
  t4485 = t4483 * t4484;
  t4486 = t4482 * t4485;
  t4487 = 0.25e3 / 0.243e3 * t4486;
  t4488 = t1330 * t1361;
  t4489 = t154 * t4488;
  t4490 = 0.35e2 / 0.54e2 * t4489;
  t4491 = t1958 * t6;
  t4492 = t4491 * t16;
  t4493 = t527 * t40;
  t4494 = t4493 * t152;
  t4495 = t4492 * t4494;
  t4496 = t2556 * t4495;
  t4497 = 0.1e5 / 0.729e3 * t4496;
  t4498 = t4370 + t4373 - t4377 + t4381 - t4385 - t4388 - t4391 - t4398 + t4458 - t4460 + t4462 + t4466 - t4470 + t4475 + t4477 + t4479 + t4487 - t4490 - t4497;
  t4518 = 0.35e2 / 0.54e2 * t1332;
  t4520 = 0.5e1 / 0.18e2 * t1347;
  t4523 = -0.5e2 / 0.27e2 * t1268 + 0.5e2 / 0.27e2 * t1275 + 0.4e4 / 0.243e3 * t1299 + 0.1e2 / 0.9e1 * t1287 + 0.1e2 / 0.9e1 * t1291 - 0.25e2 / 0.162e3 * t1328 - t4518 - 0.5e1 / 0.18e2 * t1342 + t4520 - 0.25e2 / 0.108e3 * t1352 + 0.25e2 / 0.108e3 * t1358;
  tv3rho2tau0 = t9 * (t4213 + t4292 + t4366 + t4498) + 0.5e1 / 0.36e2 * t1319 + 0.5e1 / 0.36e2 * t1363 + 0.2e1 * t1390 + 0.2e1 * t1391 - 0.1e3 / 0.81e2 * t1303 - 0.1e3 / 0.81e2 * t1307 - 0.2e3 / 0.81e2 * t1282 + 0.5e3 / 0.243e3 * t1312 - 0.5e3 / 0.243e3 * t1317 + t4523;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t4524 = t574 * t1410;
  t4525 = t4524 * t3454;
  t4526 = t1838 * t4525;
  t4527 = 0.25e2 / 0.81e2 * t4526;
  t4528 = t207 * t1421;
  t4529 = t180 * t171;
  t4530 = t194 * t4529;
  t4531 = t4528 * t4530;
  t4532 = t1838 * t4531;
  t4533 = 0.125e3 / 0.486e3 * t4532;
  t4534 = t512 * t40;
  t4535 = t4534 * t44;
  t4536 = t462 * t4535;
  t4538 = t55 * t147 * t513;
  t4539 = t4536 * t4538;
  t4540 = 0.5e2 / 0.81e2 * t4539;
  t4541 = t1410 * t522;
  t4542 = t1295 * t4541;
  t4543 = t1294 * t4542;
  t4544 = 0.2e4 / 0.243e3 * t4543;
  t4546 = t55 * t217 * t171;
  t4547 = t1396 * t4546;
  t4548 = 0.5e2 / 0.27e2 * t4547;
  t4550 = t55 * t317 * t171;
  t4551 = t1396 * t4550;
  t4552 = 0.5e2 / 0.27e2 * t4551;
  t4554 = t55 * t147 * t517;
  t4555 = t1396 * t4554;
  t4556 = 0.25e2 / 0.27e2 * t4555;
  t4557 = t484 * t791;
  t4558 = t4307 * t1412;
  t4559 = 0.4e4 / 0.243e3 * t4558;
  t4560 = t4310 * t1411;
  t4561 = t1294 * t4560;
  t4562 = 0.4e4 / 0.243e3 * t4561;
  t4563 = t4237 * t474;
  t4564 = t154 * t4563;
  t4565 = 0.595e3 / 0.324e3 * t4564;
  t4566 = t1330 * t1441;
  t4567 = t154 * t4566;
  t4568 = 0.35e2 / 0.27e2 * t4567;
  t4569 = t322 * t1433;
  t4570 = 0.35e2 / 0.54e2 * t4569;
  t4571 = t322 * t1442;
  t4572 = 0.5e1 / 0.18e2 * t4571;
  t4573 = t4527 - t4533 + t4540 + t4544 + t4548 + t4552 + t4556 + t4557 + t4559 + t4562 + t4565 - t4568 - t4570 + t4572;
  t4574 = t27 * t791;
  t4575 = t472 * t4574;
  t4576 = t445 * t4575;
  t4577 = t154 * t4576;
  t4578 = 0.5e1 / 0.72e2 * t4577;
  t4579 = t797 * t475;
  t4580 = 0.5e1 / 0.72e2 * t4579;
  t4581 = t322 * t1452;
  t4582 = 0.5e1 / 0.36e2 * t4581;
  t4583 = t207 * t21;
  t4584 = t473 * t545;
  t4585 = t4583 * t4584;
  t4586 = t4482 * t4585;
  t4587 = 0.25e3 / 0.243e3 * t4586;
  t4588 = t1330 * t1451;
  t4589 = t154 * t4588;
  t4590 = 0.35e2 / 0.54e2 * t4589;
  t4591 = t1440 * t1450;
  t4592 = t445 * t4591;
  t4593 = t154 * t4592;
  t4594 = 0.5e1 / 0.18e2 * t4593;
  t4595 = t1958 * t21;
  t4596 = t4595 * t27;
  t4597 = t4596 * t4494;
  t4598 = t2556 * t4597;
  t4599 = 0.1e5 / 0.729e3 * t4598;
  t4600 = t26 * t180;
  t4601 = t4600 * t171;
  t4602 = t1831 * t4601;
  t4603 = t1294 * t4602;
  t4604 = 0.2e5 / 0.729e3 * t4603;
  t4606 = t190 * t4336 * t468;
  t4607 = 0.5e2 / 0.81e2 * t4606;
  t4609 = t190 * t4180 * t468;
  t4610 = 0.1e3 / 0.81e2 * t4609;
  t4612 = t190 * t4184 * t468;
  t4613 = 0.5e2 / 0.81e2 * t4612;
  t4614 = t1403 * t4189;
  t4615 = 0.2e3 / 0.81e2 * t4614;
  t4616 = t1403 * t4192;
  t4617 = 0.2e3 / 0.81e2 * t4616;
  t4618 = t1403 * t4195;
  t4619 = 0.1e3 / 0.81e2 * t4618;
  t4620 = t462 * t4534;
  t4622 = t152 * t54 * t513;
  t4625 = t26 * t185;
  t4626 = t4625 * t187;
  t4627 = t462 * t4626;
  t4628 = t171 * params->c;
  t4629 = t4628 * t180;
  t4630 = t325 * t4629;
  t4634 = t152 * t54 * t517;
  t4648 = t27 * t522;
  t4649 = t1463 * t4648;
  t4652 = t21 * t512;
  t4653 = t4652 * t513;
  t4657 = t1421 * t517;
  t4661 = -0.5e2 / 0.81e2 * t4620 * t4622 + 0.1e4 / 0.243e3 * t4627 * t4630 - 0.25e2 / 0.27e2 * t1455 * t4634 - 0.2e4 / 0.81e2 * t478 * t4399 + 0.1e3 / 0.81e2 * t1460 * t4440 + 0.1e5 / 0.729e3 * t2535 * t1410 * t527 * t50 - 0.2e5 / 0.729e3 * t543 * t1463 * t4601 - 0.2e4 / 0.243e3 * t543 * t4649 + 0.5e3 / 0.729e3 * t190 * t801 * t4653 + 0.25e3 / 0.243e3 * t190 * t801 * t4657;
  t4662 = t4661 * t146;
  t4663 = t4578 + t4580 + t4582 + t4587 - t4590 + t4594 - t4599 + t4604 - t4607 - t4610 - t4613 - t4615 - t4617 - t4619 + t4662;
  t4665 = t4139 * t1446;
  t4666 = t1336 * t4665;
  t4667 = 0.25e2 / 0.54e2 * t4666;
  t4668 = t316 * t171;
  t4669 = t1421 * t4668;
  t4670 = t1354 * t4669;
  t4671 = t1336 * t4670;
  t4672 = 0.25e2 / 0.108e3 * t4671;
  t4673 = t146 * t517;
  t4674 = t1421 * t4673;
  t4675 = t1354 * t4674;
  t4676 = t1336 * t4675;
  t4677 = 0.25e2 / 0.216e3 * t4676;
  t4678 = t4151 * t1436;
  t4679 = t1336 * t4678;
  t4680 = 0.35e2 / 0.27e2 * t4679;
  t4681 = t4156 * t1446;
  t4682 = t1336 * t4681;
  t4683 = 0.175e3 / 0.162e3 * t4682;
  t4684 = t1410 * t4160;
  t4685 = t1338 * t4684;
  t4686 = t1336 * t4685;
  t4687 = 0.5e1 / 0.18e2 * t4686;
  t4688 = t1410 * t4214;
  t4689 = t1338 * t4688;
  t4690 = t1336 * t4689;
  t4691 = 0.5e1 / 0.36e2 * t4690;
  t4692 = t4143 * t1437;
  t4693 = 0.5e1 / 0.18e2 * t4692;
  t4694 = t4143 * t1447;
  t4695 = 0.25e2 / 0.108e3 * t4694;
  t4696 = t1354 * t1736;
  t4697 = t4146 * t4696;
  t4698 = 0.25e2 / 0.162e3 * t4697;
  t4699 = t4340 * t1436;
  t4700 = t1336 * t4699;
  t4701 = 0.5e1 / 0.9e1 * t4700;
  t4702 = t146 * t513;
  t4703 = t4652 * t4702;
  t4704 = t1354 * t4703;
  t4705 = t1336 * t4704;
  t4706 = 0.25e2 / 0.324e3 * t4705;
  t4707 = t1410 * t4175;
  t4708 = t4174 * t4707;
  t4709 = t1336 * t4708;
  t4710 = 0.5e1 / 0.12e2 * t4709;
  t4712 = t1141 * t1984 * t1422;
  t4713 = 0.5e3 / 0.243e3 * t4712;
  t4714 = t4667 + t4672 + t4677 + t4680 - t4683 - t4687 - t4691 - t4693 + t4695 - t4698 - t4701 + t4706 + t4710 - t4713;
  t4716 = t1141 * t530 * t4657;
  t4717 = 0.25e3 / 0.243e3 * t4716;
  t4718 = t462 * t26;
  t4719 = t4718 * t189;
  t4720 = t439 * t4629;
  t4721 = t4719 * t4720;
  t4722 = 0.1e4 / 0.243e3 * t4721;
  t4723 = t530 * t4653;
  t4724 = t1141 * t4723;
  t4725 = 0.5e3 / 0.729e3 * t4724;
  t4726 = t445 * t1740;
  t4727 = t154 * t4726;
  t4728 = 0.5e1 / 0.36e2 * t4727;
  t4730 = t1141 * t1980 * t1422;
  t4731 = 0.5e3 / 0.243e3 * t4730;
  t4732 = t464 * t4363;
  t4733 = 0.5e1 / 0.9e1 * t4732;
  t4734 = t464 * t4368;
  t4735 = 0.1e2 / 0.9e1 * t4734;
  t4736 = t464 * t4349;
  t4737 = 0.5e1 / 0.9e1 * t4736;
  t4738 = t27 * t539;
  t4739 = t462 * t4738;
  t4740 = t4739 * t4358;
  t4741 = 0.2e4 / 0.81e2 * t4740;
  t4742 = t26 * t146;
  t4743 = t209 * t171;
  t4744 = t4742 * t4743;
  t4745 = t1843 * t4744;
  t4746 = t1336 * t4745;
  t4747 = 0.25e2 / 0.54e2 * t4746;
  t4748 = t1450 * t326;
  t4749 = t1428 * t4748;
  t4750 = t1323 * t4749;
  t4751 = 0.25e2 / 0.162e3 * t4750;
  t4752 = t473 * t810;
  t4753 = t1428 * t4752;
  t4754 = t1323 * t4753;
  t4755 = 0.25e2 / 0.324e3 * t4754;
  t4756 = t4155 * t472;
  t4757 = t4756 * t1429;
  t4758 = t1323 * t4757;
  t4759 = 0.175e3 / 0.243e3 * t4758;
  t4760 = t1324 * t1440;
  t4761 = t4760 * t1429;
  t4762 = t1323 * t4761;
  t4763 = 0.25e2 / 0.81e2 * t4762;
  t4764 = t1471 * t316;
  t4765 = 0.2e1 * t4764;
  t4766 = -t4717 - t4722 - t4725 + t4728 - t4731 + t4733 + t4735 + t4737 + t4741 - t4747 - t4751 - t4755 + t4759 - t4763 + t4765;
  t4783 = 0.35e2 / 0.54e2 * t1434;
  t4785 = 0.5e1 / 0.18e2 * t1443;
  tv3rho2tau1 = t9 * (t4573 + t4663 + t4714 + t4766) + 0.2e1 * t1473 + 0.2e1 * t1472 + 0.5e1 / 0.36e2 * t1426 + 0.5e1 / 0.36e2 * t1453 - 0.2e3 / 0.81e2 * t1404 - 0.1e3 / 0.81e2 * t1416 - 0.1e3 / 0.81e2 * t1419 - 0.5e3 / 0.243e3 * t1424 + 0.5e2 / 0.27e2 * t1399 + 0.4e4 / 0.243e3 * t1413 + 0.1e2 / 0.9e1 * t1406 + 0.1e2 / 0.9e1 * t1408 - 0.25e2 / 0.162e3 * t1431 - t4783 - 0.5e1 / 0.18e2 * t1438 + t4785 + 0.25e2 / 0.108e3 * t1448;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t4787 = t1320 - t4518 - t1353 + t1364 + t1509 + t1546 - t1269 + t1288 + t1292 - t1283 - t1304 - t1308 + t1313 - t1482 + t1528 - t1329 - t1513;
  t4788 = t387 * t1335;
  t4789 = t4788 * t1357;
  t4792 = t805 * t4480 * t1324;
  t4793 = t446 * t16;
  t4794 = t1295 * t962;
  t4795 = t4793 * t4794;
  t4796 = t4792 * t4795;
  t4798 = t2554 * t1990;
  t4799 = t805 * t4798;
  t4800 = t1492 * t3853;
  t4801 = t4799 * t4800;
  t4803 = t4156 * t1520;
  t4804 = t1336 * t4803;
  t4806 = t4139 * t1520;
  t4807 = t1336 * t4806;
  t4809 = t4198 * t1519;
  t4810 = t1354 * t4809;
  t4811 = t1336 * t4810;
  t4813 = t4151 * t1515;
  t4814 = t1336 * t4813;
  t4816 = t4340 * t1515;
  t4817 = t1336 * t4816;
  t4819 = t1519 * t326;
  t4820 = t4129 * t4819;
  t4821 = t1838 * t4820;
  t4823 = t350 * t167;
  t4824 = t194 * t4823;
  t4825 = t4129 * t4824;
  t4826 = t1838 * t4825;
  t4828 = t4135 * t3862;
  t4829 = t1838 * t4828;
  t4831 = t4135 * t3858;
  t4832 = t1838 * t4831;
  t4834 = t336 * t209;
  t4835 = t4248 * t4834;
  t4836 = t4247 * t4835;
  t4837 = t1336 * t4836;
  t4839 = 0.25e2 / 0.216e3 * t4789 + 0.25e3 / 0.243e3 * t4796 - 0.1e5 / 0.729e3 * t4801 - 0.175e3 / 0.324e3 * t4804 + 0.25e2 / 0.108e3 * t4807 - 0.125e3 / 0.648e3 * t4811 + 0.35e2 / 0.54e2 * t4814 - 0.5e1 / 0.18e2 * t4817 - 0.125e3 / 0.972e3 * t4821 - 0.125e3 / 0.972e3 * t4826 + 0.25e2 / 0.162e3 * t4829 + 0.25e2 / 0.162e3 * t4832 - 0.25e2 / 0.108e3 * t4837;
  t4840 = t382 * t544;
  t4841 = t4840 * t1297;
  t4842 = t1294 * t4841;
  t4844 = t4307 * t1493;
  t4846 = t4310 * t1492;
  t4847 = t1294 * t4846;
  t4849 = t1296 * t841;
  t4850 = t1295 * t4849;
  t4851 = t1294 * t4850;
  t4853 = t542 * t364;
  t4854 = t39 * t4853;
  t4855 = t4854 * t1298;
  t4858 = t55 * t217 * t336;
  t4859 = t1272 * t4858;
  t4861 = t382 * t167;
  t4862 = t1314 * t4861;
  t4863 = t1354 * t4862;
  t4864 = t1336 * t4863;
  t4866 = t459 * t951;
  t4870 = t2362 * t206;
  t4871 = t252 * t6;
  t4872 = t4871 * t4248;
  t4873 = t4870 * t4872;
  t4874 = t154 * t4873;
  t4876 = t322 * t1526;
  t4878 = 0.2e4 / 0.243e3 * t4842 + 0.2e4 / 0.243e3 * t4844 + 0.2e4 / 0.243e3 * t4847 + 0.2e4 / 0.243e3 * t4851 + 0.2e4 / 0.243e3 * t4855 + 0.25e2 / 0.27e2 * t4859 + 0.25e2 / 0.216e3 * t4864 + t4866 - 0.25e2 / 0.108e3 * t4141 + 0.35e2 / 0.54e2 * t4153 - 0.175e3 / 0.324e3 * t4158 + 0.25e2 / 0.216e3 * t4874 + 0.5e1 / 0.72e2 * t4876;
  t4880 = t16 * t951;
  t4881 = t446 * t4880;
  t4882 = t445 * t4881;
  t4883 = t154 * t4882;
  t4885 = t957 * t449;
  t4887 = t388 * t1362;
  t4889 = t336 * t167;
  t4890 = t4167 * t4889;
  t4891 = t530 * t4890;
  t4892 = t1141 * t4891;
  t4894 = t1314 * t507;
  t4895 = t530 * t4894;
  t4896 = t1141 * t4895;
  t4898 = t1330 * t1525;
  t4899 = t154 * t4898;
  t4903 = t388 * t1331;
  t4905 = t388 * t1346;
  t4907 = t388 * t1351;
  t4909 = t1389 * t382;
  t4910 = 0.5e1 / 0.72e2 * t4883 + 0.5e1 / 0.72e2 * t4885 + 0.5e1 / 0.72e2 * t4887 - 0.5e3 / 0.729e3 * t4892 - 0.25e3 / 0.243e3 * t4896 - 0.35e2 / 0.108e3 * t4899 + 0.25e2 / 0.108e3 * t4228 + t4240 + 0.175e3 / 0.324e3 * t4245 - 0.35e2 / 0.108e3 * t4903 + 0.5e1 / 0.36e2 * t4905 - 0.25e2 / 0.216e3 * t4907 + t4909;
  t4911 = t4262 * t1514;
  t4912 = t1338 * t4911;
  t4913 = t1336 * t4912;
  t4915 = t4143 * t1516;
  t4917 = t316 * t360;
  t4918 = t1296 * t4917;
  t4919 = t1338 * t4918;
  t4920 = t1336 * t4919;
  t4922 = t146 * t886;
  t4923 = t1296 * t4922;
  t4924 = t1338 * t4923;
  t4925 = t1336 * t4924;
  t4927 = t4143 * t1521;
  t4929 = t316 * t336;
  t4930 = t1314 * t4929;
  t4931 = t1354 * t4930;
  t4932 = t1336 * t4931;
  t4934 = t382 * t209;
  t4935 = t1296 * t4934;
  t4936 = t1338 * t4935;
  t4937 = t1336 * t4936;
  t4941 = t871 * t316;
  t4942 = t4941 * t441;
  t4943 = t190 * t4942;
  t4945 = t549 * t382;
  t4946 = t4945 * t441;
  t4947 = t190 * t4946;
  t4949 = t193 * t951;
  t4950 = t4949 * t441;
  t4951 = t190 * t4950;
  t4953 = t337 * t180;
  t4954 = t4330 * t4953;
  t4955 = t1294 * t4954;
  t4957 = 0.25e2 / 0.108e3 * t4913 - 0.5e1 / 0.36e2 * t4915 - 0.5e1 / 0.36e2 * t4920 - 0.5e1 / 0.36e2 * t4925 + 0.25e2 / 0.216e3 * t4927 + 0.25e2 / 0.216e3 * t4932 - 0.5e1 / 0.36e2 * t4937 + 0.175e3 / 0.486e3 * t4276 + 0.25e2 / 0.162e3 * t4280 - 0.5e2 / 0.81e2 * t4943 - 0.5e2 / 0.81e2 * t4947 - 0.5e2 / 0.81e2 * t4951 + 0.1e5 / 0.729e3 * t4955;
  t4960 = t325 * t364;
  t4961 = t4960 * t195;
  t4962 = t1279 * t4961;
  t4964 = t1280 * t903;
  t4965 = t1279 * t4964;
  t4967 = t15 * t350;
  t4968 = t4967 * t167;
  t4969 = t4330 * t4968;
  t4970 = t1294 * t4969;
  t4972 = t2586 * t146;
  t4973 = t4972 * t441;
  t4974 = t190 * t4973;
  t4976 = t4262 * t350;
  t4977 = t1295 * t4976;
  t4978 = t1294 * t4977;
  t4980 = t4289 * t1477;
  t4983 = t55 * t317 * t336;
  t4984 = t1272 * t4983;
  t4986 = t4356 * t541;
  t4987 = t431 * t4986;
  t4988 = t4987 * t855;
  t4991 = t55 * t365 * t167;
  t4992 = t1272 * t4991;
  t4995 = t55 * t383 * t167;
  t4996 = t1272 * t4995;
  t4998 = t4274 * t1510;
  t4999 = t1323 * t4998;
  t5001 = t4278 * t1510;
  t5002 = t1323 * t5001;
  t5004 = t4282 * t1510;
  t5005 = t1323 * t5004;
  t5007 = -0.1e3 / 0.81e2 * t4962 - 0.1e3 / 0.81e2 * t4965 + 0.1e5 / 0.729e3 * t4970 - 0.5e2 / 0.81e2 * t4974 - 0.1e5 / 0.729e3 * t4978 - 0.125e3 / 0.81e2 * t4980 + 0.25e2 / 0.27e2 * t4984 + 0.2e4 / 0.81e2 * t4988 + 0.25e2 / 0.27e2 * t4992 + 0.25e2 / 0.27e2 * t4996 + 0.175e3 / 0.486e3 * t4999 - 0.25e2 / 0.162e3 * t5002 + 0.125e3 / 0.972e3 * t5005;
  t5008 = t447 * t966;
  t5009 = t1325 * t5008;
  t5010 = t1323 * t5009;
  t5012 = t360 * t167;
  t5013 = t4248 * t5012;
  t5014 = t4247 * t5013;
  t5015 = t1336 * t5014;
  t5017 = t3816 * t1322;
  t5018 = t5017 * t1327;
  t5020 = t1360 * t390;
  t5021 = t1325 * t5020;
  t5022 = t1323 * t5021;
  t5024 = t55 * t66;
  t5025 = t1519 * t167;
  t5026 = t5024 * t5025;
  t5027 = t4269 * t5026;
  t5029 = t3493 * t506;
  t5030 = t5024 * t5029;
  t5031 = t1272 * t5030;
  t5033 = t4188 * t355;
  t5034 = t1279 * t5033;
  t5036 = t1280 * t861;
  t5037 = t1279 * t5036;
  t5039 = t1280 * t865;
  t5040 = t1279 * t5039;
  t5042 = t1496 * t1310;
  t5043 = t190 * t5042;
  t5045 = t1500 * t1310;
  t5046 = t190 * t5045;
  t5048 = t4286 * t1480;
  t5051 = t152 * t1284 * t382;
  t5052 = t433 * t5051;
  t5054 = -0.25e2 / 0.324e3 * t5010 - 0.25e2 / 0.108e3 * t5015 - 0.25e2 / 0.162e3 * t5018 - 0.25e2 / 0.324e3 * t5022 + 0.5e2 / 0.81e2 * t5027 + 0.25e2 / 0.27e2 * t5031 - 0.1e3 / 0.81e2 * t5034 - 0.1e3 / 0.81e2 * t5037 - 0.1e3 / 0.81e2 * t5040 + 0.25e3 / 0.243e3 * t5043 + 0.25e3 / 0.243e3 * t5046 + 0.5e3 / 0.243e3 * t5048 + 0.5e1 / 0.9e1 * t5052;
  t5057 = t152 * t434 * t951;
  t5058 = t433 * t5057;
  t5060 = t54 * t891;
  t5062 = t152 * t5060 * t146;
  t5063 = t433 * t5062;
  t5066 = t152 * t1483 * t316;
  t5067 = t433 * t5066;
  t5069 = t1267 * t1485;
  t5071 = t1267 * t1489;
  t5073 = t1344 * t1524;
  t5074 = t445 * t5073;
  t5075 = t154 * t5074;
  t5077 = t1349 * t1524;
  t5078 = t445 * t5077;
  t5079 = t154 * t5078;
  t5081 = t4788 * t1341;
  t5086 = t152 * t1529 * t167;
  t5089 = t336 * params->c;
  t5090 = t5089 * t180;
  t5091 = t325 * t5090;
  t5094 = t54 * t8;
  t5096 = t152 * t5094 * t506;
  t5101 = t390 * t167;
  t5102 = t325 * t5101;
  t5108 = t800 * t801 * t841;
  t5111 = t1955 * t1958;
  t5113 = t805 * t5111 * t6;
  t5115 = t1537 * t180 * t50;
  t5121 = t1378 * t4968;
  t5124 = t16 * t841;
  t5128 = t1378 * t4953;
  t5131 = t4198 * t336;
  t5135 = t801 * t6;
  t5136 = t5135 * t824;
  t5139 = t5135 * t828;
  t5142 = 0.125e3 / 0.81e2 * t4446 * t1530 - 0.5e2 / 0.81e2 * t4434 * t5086 + 0.5e3 / 0.243e3 * t4407 * t5091 - 0.25e2 / 0.27e2 * t1368 * t5096 - 0.5e3 / 0.243e3 * t4431 * t1534 + 0.5e3 / 0.243e3 * t4407 * t5102 - 0.2e4 / 0.81e2 * t4357 * t963 + 0.1e3 / 0.81e2 * t1373 * t5108 + 0.1e5 / 0.729e3 * t5113 * t5115 + 0.1e5 / 0.729e3 * t543 * t4424 * t1537 - 0.1e5 / 0.729e3 * t543 * t5121 - 0.2e4 / 0.243e3 * t543 * t1378 * t5124 - 0.1e5 / 0.729e3 * t543 * t5128 - 0.125e4 / 0.729e3 * t190 * t801 * t5131 + 0.5e3 / 0.729e3 * t190 * t5136 + 0.25e3 / 0.243e3 * t190 * t5139;
  t5143 = t5142 * t146;
  t5145 = t439 * t5101;
  t5146 = t4393 * t5145;
  t5149 = t1141 * t530 * t5131;
  t5152 = t1141 * t1984 * t1504;
  t5154 = 0.5e1 / 0.9e1 * t5058 + 0.5e1 / 0.9e1 * t5063 + 0.5e1 / 0.9e1 * t5067 - 0.25e2 / 0.27e2 * t5069 - 0.25e2 / 0.27e2 * t5071 + 0.5e1 / 0.36e2 * t5075 - 0.25e2 / 0.216e3 * t5079 - 0.5e1 / 0.36e2 * t5081 + t5143 + 0.5e1 / 0.18e2 * t4342 - 0.5e3 / 0.243e3 * t5146 + 0.125e4 / 0.729e3 * t5149 - 0.25e3 / 0.243e3 * t5152;
  t5155 = t439 * t5090;
  t5156 = t4393 * t5155;
  t5159 = t1141 * t2615 * t1315;
  t5162 = t1141 * t1980 * t1504;
  t5165 = t1141 * t2636 * t1315;
  t5171 = t1544 * t316;
  t5172 = t501 * t146;
  t5173 = t5172 * t4889;
  t5174 = t1325 * t5173;
  t5175 = t1336 * t5174;
  t5177 = t1524 * t326;
  t5178 = t1325 * t5177;
  t5179 = t1323 * t5178;
  t5181 = t4173 * t446;
  t5182 = t360 * t209;
  t5183 = t447 * t5182;
  t5184 = t5181 * t5183;
  t5185 = t1336 * t5184;
  t5187 = -0.5e3 / 0.243e3 * t5156 - 0.25e3 / 0.243e3 * t5159 - 0.25e3 / 0.243e3 * t5162 - 0.25e3 / 0.243e3 * t5165 - t4373 - 0.35e2 / 0.108e3 * t4459 - 0.5e1 / 0.36e2 * t4461 - 0.5e1 / 0.36e2 * t4465 - 0.35e2 / 0.108e3 * t4489 + t5171 + 0.25e2 / 0.324e3 * t5175 - 0.25e2 / 0.324e3 * t5179 + 0.5e1 / 0.12e2 * t5185;
  t5192 = t1545 + t1391 + t1390 + t1276 + t1300 - t1318 - t1507 - t1499 - t1503 + t9 * (t4839 + t4878 + t4910 + t4957 + t5007 + t5054 + t5154 + t5187) + t1523 - t1343 + t1359 - t1518 + t1479 + t1495 + t1487 + t1491;
  tv3rho2tau2 = t4787 + t5192;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t5193 = t1563 * t3853;
  t5194 = t4799 * t5193;
  t5196 = t4788 * t1437;
  t5198 = t4788 * t1447;
  t5200 = t472 * t27;
  t5201 = t5200 * t4794;
  t5202 = t4792 * t5201;
  t5204 = t4143 * t1589;
  t5206 = t1410 * t4917;
  t5207 = t1338 * t5206;
  t5208 = t1336 * t5207;
  t5210 = t1410 * t4922;
  t5211 = t1338 * t5210;
  t5212 = t1336 * t5211;
  t5214 = t342 * t27;
  t5215 = t5214 * t1339;
  t5216 = t1338 * t5215;
  t5217 = t1336 * t5216;
  t5219 = t4156 * t1598;
  t5220 = t1336 * t5219;
  t5222 = t4139 * t1598;
  t5223 = t1336 * t5222;
  t5225 = t4151 * t1588;
  t5226 = t1336 * t5225;
  t5228 = t4340 * t1588;
  t5229 = t1336 * t5228;
  t5231 = -0.1e5 / 0.729e3 * t5194 - 0.5e1 / 0.36e2 * t5196 + 0.25e2 / 0.216e3 * t5198 + 0.25e3 / 0.243e3 * t5202 - 0.5e1 / 0.36e2 * t5204 - 0.5e1 / 0.36e2 * t5208 - 0.5e1 / 0.36e2 * t5212 + 0.25e2 / 0.108e3 * t5217 - 0.175e3 / 0.324e3 * t5220 + 0.25e2 / 0.108e3 * t5223 + 0.35e2 / 0.54e2 * t5226 - 0.5e1 / 0.18e2 * t5229 + t4565;
  t5236 = t1403 * t4961;
  t5238 = t1403 * t4964;
  t5240 = t1549 * t1402;
  t5241 = t5240 * t1281;
  t5243 = t1597 * t171;
  t5244 = t5024 * t5243;
  t5245 = t4536 * t5244;
  t5247 = t27 * t951;
  t5248 = t472 * t5247;
  t5249 = t445 * t5248;
  t5250 = t154 * t5249;
  t5252 = t322 * t1594;
  t5254 = t1592 * t1450;
  t5255 = t445 * t5254;
  t5256 = t154 * t5255;
  t5258 = t252 * t21;
  t5259 = t5258 * t4742;
  t5260 = t4870 * t5259;
  t5261 = t154 * t5260;
  t5263 = t322 * t1604;
  t5265 = -0.35e2 / 0.108e3 * t4569 - 0.5e1 / 0.36e2 * t4571 - 0.35e2 / 0.108e3 * t4589 - 0.5e1 / 0.36e2 * t4593 - 0.1e3 / 0.81e2 * t5236 - 0.1e3 / 0.81e2 * t5238 + 0.5e3 / 0.243e3 * t5241 + 0.5e2 / 0.81e2 * t5245 + 0.5e1 / 0.72e2 * t5250 - 0.25e2 / 0.216e3 * t5252 - 0.25e2 / 0.216e3 * t5256 - 0.25e2 / 0.216e3 * t5261 + 0.5e1 / 0.72e2 * t5263;
  t5267 = t346 * t171;
  t5268 = t4652 * t5267;
  t5269 = t530 * t5268;
  t5270 = t1141 * t5269;
  t5272 = t1421 * t507;
  t5273 = t530 * t5272;
  t5274 = t1141 * t5273;
  t5276 = t957 * t475;
  t5278 = t388 * t1452;
  t5280 = t4524 * t3858;
  t5281 = t1838 * t5280;
  t5283 = t350 * t171;
  t5284 = t194 * t5283;
  t5285 = t4528 * t5284;
  t5286 = t1838 * t5285;
  t5288 = t26 * t350;
  t5289 = t5288 * t171;
  t5290 = t1831 * t5289;
  t5291 = t1294 * t5290;
  t5294 = t190 * t4972 * t468;
  t5297 = t190 * t4941 * t468;
  t5300 = t190 * t4945 * t468;
  t5303 = t190 * t4949 * t468;
  t5306 = t190 * t1301 * t1574;
  t5309 = t190 * t1305 * t1574;
  t5311 = -0.5e3 / 0.729e3 * t5270 + 0.25e3 / 0.243e3 * t5274 + 0.5e1 / 0.72e2 * t5276 + 0.5e1 / 0.72e2 * t5278 + 0.25e2 / 0.162e3 * t5281 - 0.125e3 / 0.972e3 * t5286 + 0.1e5 / 0.729e3 * t5291 - 0.5e2 / 0.81e2 * t5294 - 0.5e2 / 0.81e2 * t5297 - 0.5e2 / 0.81e2 * t5300 - 0.5e2 / 0.81e2 * t5303 + 0.25e3 / 0.243e3 * t5306 + 0.25e3 / 0.243e3 * t5309;
  t5312 = t347 * t180;
  t5313 = t1831 * t5312;
  t5314 = t1294 * t5313;
  t5316 = t1396 * t5030;
  t5318 = t1403 * t5033;
  t5320 = t1403 * t5036;
  t5322 = t1403 * t5039;
  t5325 = t1323 * t4756 * t1584;
  t5328 = t1323 * t4760 * t1584;
  t5330 = t4524 * t3862;
  t5331 = t1838 * t5330;
  t5333 = t1597 * t326;
  t5334 = t4528 * t5333;
  t5335 = t1838 * t5334;
  t5337 = t342 * t26;
  t5338 = t5337 * t1445;
  t5339 = t1354 * t5338;
  t5340 = t1336 * t5339;
  t5342 = t4143 * t1599;
  t5344 = t316 * t346;
  t5345 = t1421 * t5344;
  t5346 = t1354 * t5345;
  t5347 = t1336 * t5346;
  t5349 = t1410 * t4934;
  t5350 = t1338 * t5349;
  t5351 = t1336 * t5350;
  t5353 = 0.1e5 / 0.729e3 * t5314 - 0.25e2 / 0.27e2 * t5316 - 0.1e3 / 0.81e2 * t5318 - 0.1e3 / 0.81e2 * t5320 - 0.1e3 / 0.81e2 * t5322 + 0.175e3 / 0.486e3 * t5325 - 0.25e2 / 0.162e3 * t5328 + 0.25e2 / 0.162e3 * t5331 - 0.125e3 / 0.972e3 * t5335 - 0.125e3 / 0.648e3 * t5340 + 0.25e2 / 0.216e3 * t5342 + 0.25e2 / 0.216e3 * t5347 - 0.5e1 / 0.36e2 * t5351;
  t5356 = t382 * t171;
  t5357 = t1421 * t5356;
  t5358 = t1354 * t5357;
  t5359 = t1336 * t5358;
  t5361 = t1450 * t390;
  t5363 = t1323 * t1428 * t5361;
  t5365 = t473 * t966;
  t5366 = t1428 * t5365;
  t5367 = t1323 * t5366;
  t5369 = t360 * t171;
  t5370 = t4742 * t5369;
  t5371 = t1843 * t5370;
  t5372 = t1336 * t5371;
  t5374 = t5017 * t1430;
  t5376 = t512 * t146;
  t5377 = t5376 * t5267;
  t5378 = t1428 * t5377;
  t5379 = t1336 * t5378;
  t5381 = t1602 * t326;
  t5382 = t1428 * t5381;
  t5383 = t1323 * t5382;
  t5385 = t4173 * t472;
  t5386 = t473 * t5182;
  t5387 = t5385 * t5386;
  t5388 = t1336 * t5387;
  t5390 = t1324 * t1592;
  t5392 = t1323 * t5390 * t1429;
  t5394 = t346 * t209;
  t5395 = t4742 * t5394;
  t5396 = t1843 * t5395;
  t5397 = t1336 * t5396;
  t5399 = t1550 * t1286;
  t5401 = t1550 * t1290;
  t5403 = t464 * t5062;
  t5405 = 0.25e2 / 0.216e3 * t5359 - 0.25e2 / 0.324e3 * t5363 - 0.25e2 / 0.324e3 * t5367 - 0.25e2 / 0.108e3 * t5372 - 0.25e2 / 0.162e3 * t5374 + 0.25e2 / 0.324e3 * t5379 - 0.25e2 / 0.324e3 * t5383 + 0.5e1 / 0.12e2 * t5388 + 0.125e3 / 0.972e3 * t5392 - 0.25e2 / 0.108e3 * t5397 - 0.25e2 / 0.27e2 * t5399 - 0.25e2 / 0.27e2 * t5401 + 0.5e1 / 0.9e1 * t5403;
  t5406 = t464 * t5066;
  t5408 = t464 * t5051;
  t5410 = t464 * t5057;
  t5412 = t4840 * t1411;
  t5413 = t1294 * t5412;
  t5415 = t5214 * t180;
  t5416 = t1295 * t5415;
  t5417 = t1294 * t5416;
  t5419 = t4307 * t1564;
  t5421 = t4310 * t1563;
  t5422 = t1294 * t5421;
  t5424 = t1410 * t841;
  t5425 = t1295 * t5424;
  t5426 = t1294 * t5425;
  t5428 = t4854 * t1412;
  t5431 = t55 * t365 * t171;
  t5432 = t1396 * t5431;
  t5435 = t55 * t383 * t171;
  t5436 = t1396 * t5435;
  t5438 = t1549 * t1395;
  t5439 = t5438 * t1398;
  t5442 = t55 * t217 * t346;
  t5443 = t1396 * t5442;
  t5445 = 0.5e1 / 0.9e1 * t5406 + 0.5e1 / 0.9e1 * t5408 + 0.5e1 / 0.9e1 * t5410 + 0.2e4 / 0.243e3 * t5413 - 0.1e5 / 0.729e3 * t5417 + 0.2e4 / 0.243e3 * t5419 + 0.2e4 / 0.243e3 * t5422 + 0.2e4 / 0.243e3 * t5426 + 0.2e4 / 0.243e3 * t5428 + 0.25e2 / 0.27e2 * t5432 + 0.25e2 / 0.27e2 * t5436 - 0.125e3 / 0.81e2 * t5439 + 0.25e2 / 0.27e2 * t5443;
  t5448 = t55 * t317 * t346;
  t5449 = t1396 * t5448;
  t5451 = t4738 * t541;
  t5452 = t462 * t5451;
  t5453 = t5452 * t855;
  t5455 = t390 * t171;
  t5456 = t439 * t5455;
  t5457 = t4719 * t5456;
  t5460 = t1141 * t2636 * t1422;
  t5463 = t1141 * t2615 * t1422;
  t5465 = t5337 * t171;
  t5467 = t1141 * t530 * t5465;
  t5470 = t1141 * t1980 * t1578;
  t5473 = t1141 * t1984 * t1578;
  t5475 = t346 * params->c;
  t5476 = t5475 * t180;
  t5477 = t439 * t5476;
  t5478 = t4719 * t5477;
  t5484 = 0.25e2 / 0.27e2 * t5449 + 0.2e4 / 0.81e2 * t5453 - 0.5e3 / 0.243e3 * t5457 - 0.25e3 / 0.243e3 * t5460 - 0.25e3 / 0.243e3 * t5463 + 0.125e4 / 0.729e3 * t5467 - 0.25e3 / 0.243e3 * t5470 - 0.25e3 / 0.243e3 * t5473 - 0.5e3 / 0.243e3 * t5478 - 0.25e2 / 0.108e3 * t4666 + 0.35e2 / 0.54e2 * t4679 - 0.175e3 / 0.324e3 * t4682 + 0.5e1 / 0.18e2 * t4700;
  t5487 = t1549 * t1394;
  t5490 = t1549 * t1401;
  t5494 = t152 * t1610 * t171;
  t5502 = t325 * t5455;
  t5510 = t805 * t5111 * t21;
  t5512 = t1616 * t180 * t50;
  t5518 = t27 * t841;
  t5519 = t1463 * t5518;
  t5522 = t544 * t342;
  t5523 = t5522 * t1464;
  t5532 = t801 * t21;
  t5539 = 0.125e3 / 0.81e2 * t5487 * t1457 - 0.5e3 / 0.243e3 * t5490 * t1375 - 0.5e2 / 0.81e2 * t4620 * t5494 + 0.5e3 / 0.243e3 * t4627 * t325 * t5476 + 0.25e2 / 0.27e2 * t1455 * t5096 + 0.5e3 / 0.243e3 * t4627 * t5502 - 0.2e4 / 0.81e2 * t4739 * t963 + 0.1e3 / 0.81e2 * t1460 * t5108 + 0.1e5 / 0.729e3 * t5510 * t5512 - 0.1e5 / 0.729e3 * t543 * t1463 * t5289 - 0.2e4 / 0.243e3 * t543 * t5519 + 0.1e5 / 0.729e3 * t543 * t5523 - 0.125e4 / 0.729e3 * t190 * t801 * t5465 - 0.1e5 / 0.729e3 * t543 * t1463 * t5312 + 0.5e3 / 0.729e3 * t190 * t5532 * t834 - 0.25e3 / 0.243e3 * t190 * t5532 * t838;
  t5540 = t5539 * t146;
  t5541 = t1626 * t316;
  t5542 = t388 * t1433;
  t5544 = t388 * t1442;
  t5546 = t1330 * t1593;
  t5547 = t154 * t5546;
  t5549 = t8 * t342;
  t5550 = t5549 * t473;
  t5551 = t445 * t5550;
  t5552 = t154 * t5551;
  t5554 = t1330 * t1603;
  t5555 = t154 * t5554;
  t5557 = t1440 * t1602;
  t5558 = t445 * t5557;
  t5559 = t154 * t5558;
  t5561 = t1471 * t382;
  t5562 = t484 * t951;
  t5563 = -t4728 + 0.175e3 / 0.486e3 * t4758 + 0.25e2 / 0.162e3 * t4762 + t5540 + t5541 - 0.35e2 / 0.108e3 * t5542 + 0.5e1 / 0.36e2 * t5544 + 0.175e3 / 0.324e3 * t5547 - 0.25e2 / 0.108e3 * t5552 - 0.35e2 / 0.108e3 * t5555 + 0.5e1 / 0.36e2 * t5559 + t5561 + t5562;
  t5568 = t1427 - t4783 + t1454 + t1628 + t1627 + t1407 + t1409 - t1405 - t1417 - t1420 + t1583 - t1596 + t1606 - t1587 - t1432 + t9 * (t5231 + t5265 + t5311 + t5353 + t5405 + t5445 + t5484 + t5563) + t1473;
  t5569 = -t1425 - t1581 - t1558 - t1569 - t1572 + t1577 + t1556 + t1566 - t1591 + t1601 - t1439 + t1449 + t1400 + t1414 - t1552 + t1560 + t1562 + t1472;
  tv3rho2tau3 = t5568 + t5569;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t5570 = 0.175e3 / 0.162e3 * t4804;
  t5571 = 0.25e2 / 0.54e2 * t4807;
  t5572 = 0.35e2 / 0.27e2 * t4814;
  t5573 = 0.5e1 / 0.9e1 * t4817;
  t5574 = 0.35e2 / 0.54e2 * t4899;
  t5575 = t4135 * t4015;
  t5576 = t1838 * t5575;
  t5577 = 0.25e2 / 0.81e2 * t5576;
  t5578 = t350 * t336;
  t5579 = t194 * t5578;
  t5580 = t4129 * t5579;
  t5581 = t1838 * t5580;
  t5582 = 0.125e3 / 0.486e3 * t5581;
  t5583 = 0.35e2 / 0.54e2 * t4903;
  t5584 = 0.5e1 / 0.18e2 * t4905;
  t5585 = t459 * t1084;
  t5586 = t1544 * t382;
  t5587 = 0.2e1 * t5586;
  t5588 = t54 * t983;
  t5589 = t152 * t5588;
  t5592 = t5089 * t350;
  t5593 = t325 * t5592;
  t5596 = t54 * t987;
  t5597 = t152 * t5596;
  t5600 = t542 * t1021;
  t5604 = t800 * t801 * t1007;
  t5607 = t1296 * t1012;
  t5608 = t5607 * t50;
  t5611 = t4967 * t336;
  t5612 = t1378 * t5611;
  t5615 = t16 * t1007;
  t5619 = t4167 * t983;
  t5623 = t1314 * t987;
  t5627 = -0.5e2 / 0.81e2 * t4434 * t5589 + 0.1e4 / 0.243e3 * t4407 * t5593 - 0.25e2 / 0.27e2 * t1368 * t5597 - 0.2e4 / 0.81e2 * t452 * t5600 + 0.1e3 / 0.81e2 * t1373 * t5604 + 0.1e5 / 0.729e3 * t2535 * t5608 - 0.2e5 / 0.729e3 * t543 * t5612 - 0.2e4 / 0.243e3 * t543 * t1378 * t5615 + 0.5e3 / 0.729e3 * t190 * t801 * t5619 + 0.25e3 / 0.243e3 * t190 * t801 * t5623;
  t5628 = t5627 * t146;
  t5629 = -t5570 - t5571 + t5572 + t5573 - t5574 + t4240 + t4243 + t5577 - t5582 - t5583 - t5584 + t5585 + t5587 + t5628;
  t5631 = t55 * t147 * t983;
  t5632 = t4269 * t5631;
  t5633 = 0.5e2 / 0.81e2 * t5632;
  t5634 = t4854 * t1493;
  t5635 = 0.4e4 / 0.243e3 * t5634;
  t5636 = t4840 * t1492;
  t5637 = t1294 * t5636;
  t5638 = 0.4e4 / 0.243e3 * t5637;
  t5639 = t1296 * t1007;
  t5640 = t1295 * t5639;
  t5641 = t1294 * t5640;
  t5642 = 0.2e4 / 0.243e3 * t5641;
  t5644 = t55 * t365 * t336;
  t5645 = t1272 * t5644;
  t5646 = 0.5e2 / 0.27e2 * t5645;
  t5648 = t55 * t383 * t336;
  t5649 = t1272 * t5648;
  t5650 = 0.5e2 / 0.27e2 * t5649;
  t5652 = t55 * t147 * t987;
  t5653 = t1272 * t5652;
  t5654 = 0.25e2 / 0.27e2 * t5653;
  t5655 = t447 * t1098;
  t5656 = t1325 * t5655;
  t5657 = t1323 * t5656;
  t5658 = 0.25e2 / 0.324e3 * t5657;
  t5659 = t360 * t336;
  t5660 = t4248 * t5659;
  t5661 = t4247 * t5660;
  t5662 = t1336 * t5661;
  t5663 = 0.25e2 / 0.54e2 * t5662;
  t5664 = t1524 * t390;
  t5665 = t1325 * t5664;
  t5666 = t1323 * t5665;
  t5667 = 0.25e2 / 0.162e3 * t5666;
  t5668 = t1012 * t40;
  t5669 = t5668 * t152;
  t5670 = t4492 * t5669;
  t5671 = t2556 * t5670;
  t5672 = 0.1e5 / 0.729e3 * t5671;
  t5673 = 0.175e3 / 0.243e3 * t4999;
  t5674 = 0.25e2 / 0.81e2 * t5002;
  t5675 = 0.5e1 / 0.18e2 * t5075;
  t5677 = t1141 * t2636 * t1504;
  t5678 = 0.5e3 / 0.243e3 * t5677;
  t5679 = t5633 + t5635 + t5638 + t5642 + t5646 + t5650 + t5654 - t5658 - t5663 - t5667 - t5672 + t5673 + t5674 - t5675 - t5678;
  t5682 = t1141 * t2615 * t1504;
  t5683 = 0.5e3 / 0.243e3 * t5682;
  t5685 = t1141 * t530 * t5623;
  t5686 = 0.25e3 / 0.243e3 * t5685;
  t5687 = t439 * t5592;
  t5688 = t4393 * t5687;
  t5689 = 0.1e4 / 0.243e3 * t5688;
  t5690 = t530 * t5619;
  t5691 = t1141 * t5690;
  t5692 = 0.5e3 / 0.729e3 * t5691;
  t5693 = t4330 * t5611;
  t5694 = t1294 * t5693;
  t5695 = 0.2e5 / 0.729e3 * t5694;
  t5696 = t3132 * t146;
  t5697 = t5696 * t441;
  t5698 = t190 * t5697;
  t5699 = 0.5e2 / 0.81e2 * t5698;
  t5700 = t871 * t382;
  t5701 = t5700 * t441;
  t5702 = t190 * t5701;
  t5703 = 0.1e3 / 0.81e2 * t5702;
  t5704 = t193 * t1084;
  t5705 = t5704 * t441;
  t5706 = t190 * t5705;
  t5707 = 0.5e2 / 0.81e2 * t5706;
  t5708 = t2325 * t3957;
  t5709 = t4357 * t5708;
  t5710 = 0.2e4 / 0.81e2 * t5709;
  t5711 = t54 * t1046;
  t5713 = t152 * t5711 * t146;
  t5714 = t433 * t5713;
  t5715 = 0.5e1 / 0.9e1 * t5714;
  t5717 = t152 * t1483 * t382;
  t5718 = t433 * t5717;
  t5719 = 0.1e2 / 0.9e1 * t5718;
  t5721 = t152 * t434 * t1084;
  t5722 = t433 * t5721;
  t5723 = 0.5e1 / 0.9e1 * t5722;
  t5724 = t4960 * t355;
  t5725 = t1279 * t5724;
  t5726 = 0.2e3 / 0.81e2 * t5725;
  t5727 = -t5683 - t5686 - t5689 - t5692 + t5695 - t5699 - t5703 - t5707 + t5710 + t5715 + t5719 + t5723 + t4373 - t5726;
  t5728 = t1280 * t1028;
  t5729 = t1279 * t5728;
  t5730 = 0.2e3 / 0.81e2 * t5729;
  t5731 = t1280 * t1032;
  t5732 = t1279 * t5731;
  t5733 = 0.1e3 / 0.81e2 * t5732;
  t5734 = t1092 * t1322;
  t5735 = t5734 * t4147;
  t5736 = 0.25e2 / 0.162e3 * t5735;
  t5737 = t382 * t360;
  t5738 = t1296 * t5737;
  t5739 = t1338 * t5738;
  t5740 = t1336 * t5739;
  t5741 = 0.5e1 / 0.18e2 * t5740;
  t5742 = t146 * t1042;
  t5743 = t1296 * t5742;
  t5744 = t1338 * t5743;
  t5745 = t1336 * t5744;
  t5746 = 0.5e1 / 0.36e2 * t5745;
  t5747 = t4788 * t1516;
  t5748 = 0.5e1 / 0.18e2 * t5747;
  t5749 = t4788 * t1521;
  t5750 = 0.25e2 / 0.108e3 * t5749;
  t5751 = t382 * t336;
  t5752 = t1314 * t5751;
  t5753 = t1354 * t5752;
  t5754 = t1336 * t5753;
  t5755 = 0.25e2 / 0.108e3 * t5754;
  t5756 = t146 * t987;
  t5757 = t1314 * t5756;
  t5758 = t1354 * t5757;
  t5759 = t1336 * t5758;
  t5760 = 0.25e2 / 0.216e3 * t5759;
  t5761 = t146 * t983;
  t5762 = t4167 * t5761;
  t5763 = t1354 * t5762;
  t5764 = t1336 * t5763;
  t5765 = 0.25e2 / 0.324e3 * t5764;
  t5766 = t146 * t1037;
  t5767 = t1296 * t5766;
  t5768 = t4174 * t5767;
  t5769 = t1336 * t5768;
  t5770 = 0.5e1 / 0.12e2 * t5769;
  t5771 = t16 * t1084;
  t5772 = t446 * t5771;
  t5773 = t445 * t5772;
  t5774 = t154 * t5773;
  t5775 = 0.5e1 / 0.72e2 * t5774;
  t5776 = t1090 * t449;
  t5777 = 0.5e1 / 0.72e2 * t5776;
  t5778 = t388 * t1526;
  t5779 = 0.5e1 / 0.36e2 * t5778;
  t5780 = t447 * t1021;
  t5781 = t4483 * t5780;
  t5782 = t4482 * t5781;
  t5783 = 0.25e3 / 0.243e3 * t5782;
  t5784 = -t5730 - t5733 - t5736 - t5741 - t5746 - t5748 + t5750 + t5755 + t5760 + t5765 + t5770 + t5775 + t5777 + t5779 + t5783;
  tv3rho2tau4 = t9 * (t5629 + t5679 + t5727 + t5784) + 0.2e1 * t1545 + 0.2e1 * t1546 - 0.25e2 / 0.162e3 * t1512 + 0.5e1 / 0.36e2 * t1508 + 0.5e1 / 0.36e2 * t1527 - 0.2e3 / 0.81e2 * t1481 - 0.1e3 / 0.81e2 * t1498 - 0.1e3 / 0.81e2 * t1502 - 0.5e3 / 0.243e3 * t1506 + 0.5e2 / 0.27e2 * t1478 + 0.4e4 / 0.243e3 * t1494 + 0.1e2 / 0.9e1 * t1486 + 0.1e2 / 0.9e1 * t1490 - t4518 - t4520 - 0.5e1 / 0.18e2 * t1517 + 0.25e2 / 0.108e3 * t1522;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t5803 = t484 * t1084;
  t5804 = t1626 * t382;
  t5805 = 0.2e1 * t5804;
  t5808 = t54 * t999;
  t5809 = t152 * t5808;
  t5814 = t5522 * t1616;
  t5817 = t5288 * t346;
  t5818 = t1463 * t5817;
  t5821 = t5475 * t350;
  t5822 = t325 * t5821;
  t5826 = params->c * t993 * t27;
  t5827 = t325 * t5826;
  t5830 = t5337 * t346;
  t5831 = t801 * t5830;
  t5834 = t1421 * t1003;
  t5835 = t801 * t5834;
  t5842 = t54 * t1003;
  t5843 = t152 * t5842;
  t5846 = t27 * t1007;
  t5847 = t1463 * t5846;
  t5850 = t2 * t993;
  t5851 = t5850 * t27;
  t5852 = t5851 * t453;
  t5854 = t1410 * t1012;
  t5858 = t4652 * t999;
  t5862 = -0.1e4 / 0.243e3 * t5490 * t1534 - 0.5e2 / 0.81e2 * t4620 * t5809 + 0.1e3 / 0.81e2 * t1460 * t5604 + 0.2e5 / 0.729e3 * t543 * t5814 - 0.2e5 / 0.729e3 * t543 * t5818 + 0.1e4 / 0.243e3 * t4627 * t5822 + 0.2e4 / 0.729e3 * t324 * t5827 - 0.25e4 / 0.729e3 * t190 * t5831 + 0.25e3 / 0.243e3 * t190 * t5835 - 0.2e4 / 0.81e2 * t478 * t5600 + 0.25e3 / 0.81e2 * t5487 * t1611 - 0.25e2 / 0.27e2 * t1455 * t5843 - 0.2e4 / 0.243e3 * t543 * t5847 - 0.2e3 / 0.81e2 * t5852 + 0.1e5 / 0.729e3 * t2535 * t5854 * t50 + 0.5e3 / 0.729e3 * t190 * t801 * t5858;
  t5863 = t5862 * t146;
  t5864 = 0.175e3 / 0.162e3 * t5220;
  t5865 = 0.25e2 / 0.54e2 * t5223;
  t5866 = 0.35e2 / 0.27e2 * t5226;
  t5867 = 0.5e1 / 0.9e1 * t5229;
  t5868 = t4524 * t4015;
  t5869 = t1838 * t5868;
  t5870 = 0.25e2 / 0.81e2 * t5869;
  t5871 = t350 * t346;
  t5872 = t194 * t5871;
  t5873 = t4528 * t5872;
  t5874 = t1838 * t5873;
  t5875 = 0.125e3 / 0.486e3 * t5874;
  t5876 = t360 * t346;
  t5877 = t4742 * t5876;
  t5878 = t1843 * t5877;
  t5879 = t1336 * t5878;
  t5880 = 0.25e2 / 0.54e2 * t5879;
  t5881 = t1602 * t390;
  t5883 = t1323 * t1428 * t5881;
  t5884 = 0.25e2 / 0.162e3 * t5883;
  t5885 = t473 * t1098;
  t5887 = t1323 * t1428 * t5885;
  t5888 = 0.25e2 / 0.324e3 * t5887;
  t5889 = t5390 * t1584;
  t5890 = t1323 * t5889;
  t5891 = 0.125e3 / 0.486e3 * t5890;
  t5893 = t55 * t383 * t346;
  t5894 = t1396 * t5893;
  t5895 = 0.5e2 / 0.27e2 * t5894;
  t5897 = t55 * t147 * t1003;
  t5898 = t1396 * t5897;
  t5899 = 0.25e2 / 0.27e2 * t5898;
  t5900 = t5214 * t350;
  t5901 = t1295 * t5900;
  t5902 = t1294 * t5901;
  t5903 = 0.2e5 / 0.729e3 * t5902;
  t5905 = t55 * t147 * t999;
  t5906 = t4536 * t5905;
  t5907 = 0.5e2 / 0.81e2 * t5906;
  t5908 = t5803 + t5805 + t5863 - t5864 - t5865 + t5866 + t5867 + t5870 - t5875 + t4565 + t4568 - t5880 - t5884 - t5888 + t5891 + t5895 + t5899 - t5903 + t5907;
  t5909 = t4840 * t1563;
  t5910 = t1294 * t5909;
  t5911 = 0.4e4 / 0.243e3 * t5910;
  t5912 = t1410 * t1007;
  t5913 = t1295 * t5912;
  t5914 = t1294 * t5913;
  t5915 = 0.2e4 / 0.243e3 * t5914;
  t5916 = t4854 * t1564;
  t5917 = 0.4e4 / 0.243e3 * t5916;
  t5918 = t5438 * t1554;
  t5919 = 0.25e3 / 0.81e2 * t5918;
  t5921 = t55 * t365 * t346;
  t5922 = t1396 * t5921;
  t5923 = 0.5e2 / 0.27e2 * t5922;
  t5924 = t464 * t5717;
  t5925 = 0.1e2 / 0.9e1 * t5924;
  t5926 = t5850 * t463;
  t5927 = t5926 * t436;
  t5928 = 0.2e3 / 0.81e2 * t5927;
  t5929 = t464 * t5721;
  t5930 = 0.5e1 / 0.9e1 * t5929;
  t5931 = t1592 * t1602;
  t5932 = t445 * t5931;
  t5933 = t154 * t5932;
  t5934 = 0.25e2 / 0.108e3 * t5933;
  t5935 = t27 * t1084;
  t5936 = t472 * t5935;
  t5937 = t445 * t5936;
  t5938 = t154 * t5937;
  t5939 = 0.5e1 / 0.72e2 * t5938;
  t5940 = t1090 * t475;
  t5941 = 0.5e1 / 0.72e2 * t5940;
  t5942 = 0.175e3 / 0.243e3 * t5325;
  t5943 = 0.25e2 / 0.81e2 * t5328;
  t5944 = t1831 * t5817;
  t5945 = t1294 * t5944;
  t5946 = 0.2e5 / 0.729e3 * t5945;
  t5948 = t190 * t5696 * t468;
  t5949 = 0.5e2 / 0.81e2 * t5948;
  t5951 = t190 * t5700 * t468;
  t5952 = 0.1e3 / 0.81e2 * t5951;
  t5954 = t190 * t5704 * t468;
  t5955 = 0.5e2 / 0.81e2 * t5954;
  t5956 = t5240 * t1480;
  t5957 = 0.1e4 / 0.243e3 * t5956;
  t5958 = t1403 * t5724;
  t5959 = 0.2e3 / 0.81e2 * t5958;
  t5960 = t5911 + t5915 + t5917 - t5919 + t5923 + t5925 + t5928 + t5930 - t5934 + t5939 + t5941 + t5942 + t5943 + t5946 - t5949 - t5952 - t5955 + t5957 - t5959;
  t5962 = t1403 * t5728;
  t5963 = 0.2e3 / 0.81e2 * t5962;
  t5964 = t1403 * t5731;
  t5965 = 0.1e3 / 0.81e2 * t5964;
  t5967 = t190 * t439 * t5826;
  t5968 = 0.2e4 / 0.729e3 * t5967;
  t5970 = t190 * t1496 * t1574;
  t5971 = 0.5e3 / 0.243e3 * t5970;
  t5973 = t190 * t1500 * t1574;
  t5974 = 0.5e3 / 0.243e3 * t5973;
  t5975 = t5337 * t1597;
  t5976 = t1354 * t5975;
  t5977 = t1336 * t5976;
  t5978 = 0.125e3 / 0.324e3 * t5977;
  t5979 = t382 * t346;
  t5980 = t1421 * t5979;
  t5981 = t1354 * t5980;
  t5982 = t1336 * t5981;
  t5983 = 0.25e2 / 0.108e3 * t5982;
  t5984 = t146 * t1003;
  t5985 = t1421 * t5984;
  t5986 = t1354 * t5985;
  t5987 = t1336 * t5986;
  t5988 = 0.25e2 / 0.216e3 * t5987;
  t5989 = t1410 * t5737;
  t5990 = t1338 * t5989;
  t5991 = t1336 * t5990;
  t5992 = 0.5e1 / 0.18e2 * t5991;
  t5993 = t1410 * t5742;
  t5994 = t1338 * t5993;
  t5995 = t1336 * t5994;
  t5996 = 0.5e1 / 0.36e2 * t5995;
  t5997 = t4788 * t1589;
  t5998 = 0.5e1 / 0.18e2 * t5997;
  t5999 = t4788 * t1599;
  t6000 = 0.25e2 / 0.108e3 * t5999;
  t6001 = t5734 * t4696;
  t6002 = 0.25e2 / 0.162e3 * t6001;
  t6003 = t146 * t999;
  t6004 = t4652 * t6003;
  t6005 = t1354 * t6004;
  t6006 = t1336 * t6005;
  t6007 = 0.25e2 / 0.324e3 * t6006;
  t6008 = t1410 * t5766;
  t6009 = t4174 * t6008;
  t6010 = t1336 * t6009;
  t6011 = 0.5e1 / 0.12e2 * t6010;
  t6012 = t5214 * t1514;
  t6013 = t1338 * t6012;
  t6014 = t1336 * t6013;
  t6015 = 0.25e2 / 0.54e2 * t6014;
  t6016 = t530 * t5858;
  t6017 = t1141 * t6016;
  t6018 = 0.5e3 / 0.729e3 * t6017;
  t6020 = t1141 * t530 * t5830;
  t6021 = 0.25e4 / 0.729e3 * t6020;
  t6023 = t1141 * t530 * t5834;
  t6024 = 0.25e3 / 0.243e3 * t6023;
  t6025 = -t5963 - t5965 - t5968 + t5971 + t5974 - t5978 + t5983 + t5988 - t5992 - t5996 - t5998 + t6000 - t6002 + t6007 + t6011 + t6015 - t6018 + t6021 - t6024;
  t6027 = t1141 * t2636 * t1578;
  t6028 = 0.5e3 / 0.243e3 * t6027;
  t6030 = t1141 * t2615 * t1578;
  t6031 = 0.5e3 / 0.243e3 * t6030;
  t6032 = t439 * t5821;
  t6033 = t4719 * t6032;
  t6034 = 0.1e4 / 0.243e3 * t6033;
  t6035 = t1550 * t1485;
  t6036 = 0.5e2 / 0.27e2 * t6035;
  t6037 = t1550 * t1489;
  t6038 = 0.5e2 / 0.27e2 * t6037;
  t6039 = t4739 * t5708;
  t6040 = 0.2e4 / 0.81e2 * t6039;
  t6041 = t464 * t5713;
  t6042 = 0.5e1 / 0.9e1 * t6041;
  t6043 = t388 * t1604;
  t6044 = 0.5e1 / 0.36e2 * t6043;
  t6045 = t473 * t1021;
  t6046 = t4583 * t6045;
  t6047 = t4482 * t6046;
  t6048 = 0.25e3 / 0.243e3 * t6047;
  t6049 = t4596 * t5669;
  t6050 = t2556 * t6049;
  t6051 = 0.1e5 / 0.729e3 * t6050;
  t6052 = t62 * t993;
  t6053 = t6052 * t473;
  t6054 = t445 * t6053;
  t6055 = t154 * t6054;
  t6056 = 0.25e2 / 0.81e2 * t6055;
  t6057 = t388 * t1594;
  t6058 = 0.25e2 / 0.108e3 * t6057;
  t6059 = 0.35e2 / 0.54e2 * t5542;
  t6060 = 0.5e1 / 0.18e2 * t5544;
  t6061 = 0.175e3 / 0.162e3 * t5547;
  t6062 = 0.25e2 / 0.54e2 * t5552;
  t6063 = 0.35e2 / 0.54e2 * t5555;
  t6064 = 0.5e1 / 0.18e2 * t5559;
  t6065 = -t6028 - t6031 - t6034 - t6036 - t6038 + t6040 + t6042 + t4728 + t6044 + t6048 - t6051 + t6056 - t6058 - t6059 - t6060 + t6061 + t6062 - t6063 - t6064;
  t6088 = -0.5e3 / 0.243e3 * t1580 - 0.5e2 / 0.27e2 * t1551 + 0.5e2 / 0.27e2 * t1555 + 0.4e4 / 0.243e3 * t1565 + 0.1e2 / 0.9e1 * t1559 + 0.1e2 / 0.9e1 * t1561 - t4783 - t4785 - 0.5e1 / 0.18e2 * t1590 - 0.25e2 / 0.108e3 * t1595 + 0.25e2 / 0.108e3 * t1600;
  tv3rho2tau5 = t9 * (t5908 + t5960 + t6025 + t6065) + 0.2e1 * t1627 + 0.2e1 * t1628 - 0.25e2 / 0.162e3 * t1586 + 0.5e1 / 0.36e2 * t1582 + 0.5e1 / 0.36e2 * t1605 - 0.2e3 / 0.81e2 * t1557 - 0.1e3 / 0.81e2 * t1568 - 0.1e3 / 0.81e2 * t1571 + 0.5e3 / 0.243e3 * t1576 + t6088;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t6090 = 0.1e1 / t32 / t562;
  t6091 = t2 * t6090;
  t6092 = t6091 * t188;
  t6093 = t6092 * t531;
  t6094 = 0.25e2 / 0.243e3 * t6093;
  t6095 = t1633 * t542;
  t6096 = t6095 * t3079;
  t6097 = 0.125e3 / 0.324e3 * t6096;
  t6098 = t1634 * t1981;
  t6099 = 0.25e2 / 0.1296e4 * t6098;
  t6100 = t1634 * t1985;
  t6101 = 0.25e2 / 0.1296e4 * t6100;
  t6102 = t56 * t56;
  t6104 = 0.1e1 / t32 / t6102;
  t6105 = t2 * t6104;
  t6106 = t6105 * t45;
  t6107 = t6106 * t1642;
  t6108 = 0.55e2 / 0.432e3 * t6107;
  t6109 = t1640 * t189;
  t6110 = t192 * t61;
  t6111 = t6110 * t62;
  t6112 = t6111 * t195;
  t6113 = t6109 * t6112;
  t6114 = 0.25e2 / 0.648e3 * t6113;
  t6115 = t1640 * t50;
  t6116 = t54 * t206;
  t6117 = t6116 * t1153;
  t6118 = t6115 * t6117;
  t6119 = 0.5e1 / 0.288e3 * t6118;
  t6120 = t55 * t1157;
  t6121 = t1641 * t6120;
  t6122 = 0.5e1 / 0.144e3 * t6121;
  t6123 = t55 * t1161;
  t6124 = t1641 * t6123;
  t6125 = 0.5e1 / 0.288e3 * t6124;
  t6126 = t1958 * t1632;
  t6128 = t6126 * t180 * t50;
  t6129 = t2556 * t6128;
  t6130 = 0.625e3 / 0.2916e4 * t6129;
  t6132 = t543 * t217 * t1645;
  t6133 = 0.125e3 / 0.972e3 * t6132;
  t6135 = t543 * t317 * t1645;
  t6136 = 0.125e3 / 0.972e3 * t6135;
  t6137 = t544 * t6090;
  t6139 = t543 * t147 * t6137;
  t6140 = 0.5e3 / 0.729e3 * t6139;
  t6141 = t542 * t1639;
  t6142 = t39 * t6141;
  t6143 = t1295 * t180;
  t6144 = t63 * t6143;
  t6145 = t6142 * t6144;
  t6146 = 0.125e3 / 0.486e3 * t6145;
  t6148 = t192 * t6104 * t61;
  t6149 = t6148 * t1651;
  t6150 = t190 * t6149;
  t6151 = 0.275e3 / 0.1944e4 * t6150;
  t6152 = t194 * t209;
  t6154 = t1141 * t1708 * t6152;
  t6155 = 0.25e2 / 0.1296e4 * t6154;
  t6156 = t3493 * params->c;
  t6157 = t1650 * t6156;
  t6158 = t190 * t6157;
  t6159 = 0.25e2 / 0.648e3 * t6158;
  t6160 = t3581 * params->c;
  t6161 = t1650 * t6160;
  t6162 = t190 * t6161;
  t6163 = 0.25e2 / 0.1296e4 * t6162;
  t6165 = t6091 * t185 * t802;
  t6166 = 0.25e2 / 0.243e3 * t6165;
  t6167 = t1633 * t539;
  t6168 = t6167 * t2899;
  t6172 = t2535 * t1632 * t180 * t50;
  t6175 = t805 * t806 * t6090;
  t6176 = 0.5e3 / 0.729e3 * t6175;
  t6177 = -t6166 - 0.125e3 / 0.324e3 * t6168 + 0.625e3 / 0.2916e4 * t6172 + t6176;
  t6178 = t6177 * t146;
  t6179 = t1661 * t316;
  t6180 = t6094 + t6097 - t6099 - t6101 - t6108 - t6114 - t6119 + t6122 + t6125 - t6130 + t6133 + t6136 - t6140 + t6146 + t6151 + t6155 - t6159 - t6163 + t6178 + t6179;
  tv3rhosigma20 = t9 * t6180 - t1636 + t1644 + t1648 - t1654 + t1662;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t6182 = 0.5e2 / 0.243e3 * t6093;
  t6183 = 0.125e3 / 0.162e3 * t6096;
  t6184 = 0.25e2 / 0.648e3 * t6098;
  t6185 = 0.25e2 / 0.648e3 * t6100;
  t6186 = 0.55e2 / 0.216e3 * t6107;
  t6187 = 0.25e2 / 0.324e3 * t6113;
  t6188 = 0.5e1 / 0.144e3 * t6118;
  t6189 = 0.5e1 / 0.72e2 * t6121;
  t6190 = 0.5e1 / 0.144e3 * t6124;
  t6191 = 0.625e3 / 0.1458e4 * t6129;
  t6192 = 0.125e3 / 0.486e3 * t6132;
  t6193 = 0.125e3 / 0.486e3 * t6135;
  t6194 = 0.1e4 / 0.729e3 * t6139;
  t6195 = 0.125e3 / 0.243e3 * t6145;
  t6196 = 0.275e3 / 0.972e3 * t6150;
  t6197 = 0.25e2 / 0.648e3 * t6154;
  t6198 = 0.25e2 / 0.324e3 * t6158;
  t6199 = 0.25e2 / 0.648e3 * t6162;
  t6200 = 0.5e2 / 0.243e3 * t6165;
  t6203 = 0.1e4 / 0.729e3 * t6175;
  t6204 = -t6200 - 0.125e3 / 0.162e3 * t6168 + 0.625e3 / 0.1458e4 * t6172 + t6203;
  t6205 = t6204 * t146;
  t6206 = t1670 * t316;
  t6207 = t6182 + t6183 - t6184 - t6185 - t6186 - t6187 - t6188 + t6189 + t6190 - t6191 + t6192 + t6193 - t6194 + t6195 + t6196 + t6197 - t6198 - t6199 + t6205 + t6206;
  tv3rhosigma21 = t9 * t6207 - t1664 + t1665 + t1666 - t1667 + t1671;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = tv3rhosigma20;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  t6209 = 0.1e3 / 0.243e3 * t6093;
  t6210 = 0.125e3 / 0.81e2 * t6096;
  t6211 = 0.25e2 / 0.324e3 * t6098;
  t6212 = 0.25e2 / 0.324e3 * t6100;
  t6213 = 0.55e2 / 0.108e3 * t6107;
  t6214 = 0.25e2 / 0.162e3 * t6113;
  t6215 = 0.5e1 / 0.72e2 * t6118;
  t6216 = 0.5e1 / 0.36e2 * t6121;
  t6217 = 0.5e1 / 0.72e2 * t6124;
  t6218 = 0.625e3 / 0.729e3 * t6129;
  t6219 = 0.125e3 / 0.243e3 * t6132;
  t6220 = 0.125e3 / 0.243e3 * t6135;
  t6221 = 0.2e4 / 0.729e3 * t6139;
  t6222 = 0.25e3 / 0.243e3 * t6145;
  t6223 = 0.275e3 / 0.486e3 * t6150;
  t6224 = 0.25e2 / 0.324e3 * t6154;
  t6225 = 0.25e2 / 0.162e3 * t6158;
  t6226 = 0.25e2 / 0.324e3 * t6162;
  t6227 = 0.1e3 / 0.243e3 * t6165;
  t6230 = 0.2e4 / 0.729e3 * t6175;
  t6231 = -t6227 - 0.125e3 / 0.81e2 * t6168 + 0.625e3 / 0.729e3 * t6172 + t6230;
  t6232 = t6231 * t146;
  t6233 = t1679 * t316;
  t6234 = t6209 + t6210 - t6211 - t6212 - t6213 - t6214 - t6215 + t6216 + t6217 - t6218 + t6219 + t6220 - t6221 + t6222 + t6223 + t6224 - t6225 - t6226 + t6232 + t6233;
  tv3rhosigma23 = t9 * t6234 - t1673 + t1674 + t1675 - t1676 + t1680;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = tv3rhosigma21;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = tv3rhosigma22;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t6236 = t147 * t853;
  t6237 = t6095 * t6236;
  t6238 = 0.125e3 / 0.324e3 * t6237;
  t6239 = t1634 * t2637;
  t6240 = 0.25e2 / 0.1296e4 * t6239;
  t6241 = t1634 * t2616;
  t6242 = 0.25e2 / 0.1296e4 * t6241;
  t6243 = t6111 * t355;
  t6244 = t6109 * t6243;
  t6245 = 0.25e2 / 0.648e3 * t6244;
  t6246 = t6116 * t1230;
  t6247 = t6115 * t6246;
  t6248 = 0.5e1 / 0.288e3 * t6247;
  t6249 = t55 * t1234;
  t6250 = t1641 * t6249;
  t6251 = 0.5e1 / 0.288e3 * t6250;
  t6253 = t6126 * t350 * t50;
  t6254 = t2556 * t6253;
  t6255 = 0.625e3 / 0.2916e4 * t6254;
  t6257 = t543 * t365 * t1645;
  t6258 = 0.125e3 / 0.972e3 * t6257;
  t6260 = t543 * t383 * t1645;
  t6261 = 0.125e3 / 0.972e3 * t6260;
  t6262 = t1295 * t350;
  t6263 = t63 * t6262;
  t6264 = t6142 * t6263;
  t6265 = 0.125e3 / 0.486e3 * t6264;
  t6266 = t194 * t360;
  t6268 = t1141 * t1708 * t6266;
  t6269 = 0.25e2 / 0.1296e4 * t6268;
  t6270 = t3835 * params->c;
  t6271 = t1650 * t6270;
  t6272 = t190 * t6271;
  t6273 = 0.25e2 / 0.1296e4 * t6272;
  t6274 = t806 * t350;
  t6275 = t6167 * t6274;
  t6277 = t1632 * t350;
  t6279 = t2535 * t6277 * t50;
  t6281 = -t6166 - 0.125e3 / 0.324e3 * t6275 + 0.625e3 / 0.2916e4 * t6279 + t6176;
  t6282 = t6281 * t146;
  t6283 = t1661 * t382;
  t6284 = t6094 + t6238 - t6240 - t6242 - t6108 - t6245 - t6248 - t6122 + t6251 - t6255 + t6258 + t6261 - t6140 + t6265 + t6151 + t6269 + t6159 - t6273 + t6282 + t6283;
  tv3rhosigma26 = t9 * t6284 - t1636 + t1644 + t1648 - t1654 + t1662;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  t6286 = 0.125e3 / 0.162e3 * t6237;
  t6287 = 0.25e2 / 0.648e3 * t6239;
  t6288 = 0.25e2 / 0.648e3 * t6241;
  t6289 = 0.25e2 / 0.324e3 * t6244;
  t6290 = 0.5e1 / 0.144e3 * t6247;
  t6291 = 0.5e1 / 0.144e3 * t6250;
  t6292 = 0.625e3 / 0.1458e4 * t6254;
  t6293 = 0.125e3 / 0.486e3 * t6257;
  t6294 = 0.125e3 / 0.486e3 * t6260;
  t6295 = 0.125e3 / 0.243e3 * t6264;
  t6296 = 0.25e2 / 0.648e3 * t6268;
  t6297 = 0.25e2 / 0.648e3 * t6272;
  t6300 = -t6200 - 0.125e3 / 0.162e3 * t6275 + 0.625e3 / 0.1458e4 * t6279 + t6203;
  t6301 = t6300 * t146;
  t6302 = t1670 * t382;
  t6303 = t6182 + t6286 - t6287 - t6288 - t6186 - t6289 - t6290 - t6189 + t6291 - t6292 + t6293 + t6294 - t6194 + t6295 + t6196 + t6296 + t6198 - t6297 + t6301 + t6302;
  tv3rhosigma27 = t9 * t6303 - t1664 + t1665 + t1666 - t1667 + t1671;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = tv3rhosigma26;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  t6305 = 0.125e3 / 0.81e2 * t6237;
  t6306 = 0.25e2 / 0.324e3 * t6239;
  t6307 = 0.25e2 / 0.324e3 * t6241;
  t6308 = 0.25e2 / 0.162e3 * t6244;
  t6309 = 0.5e1 / 0.72e2 * t6247;
  t6310 = 0.5e1 / 0.72e2 * t6250;
  t6311 = 0.625e3 / 0.729e3 * t6254;
  t6312 = 0.125e3 / 0.243e3 * t6257;
  t6313 = 0.125e3 / 0.243e3 * t6260;
  t6314 = 0.25e3 / 0.243e3 * t6264;
  t6315 = 0.25e2 / 0.324e3 * t6268;
  t6316 = 0.25e2 / 0.324e3 * t6272;
  t6319 = -t6227 - 0.125e3 / 0.81e2 * t6275 + 0.625e3 / 0.729e3 * t6279 + t6230;
  t6320 = t6319 * t146;
  t6321 = t1679 * t382;
  t6322 = t6209 + t6305 - t6306 - t6307 - t6213 - t6308 - t6309 - t6216 + t6310 - t6311 + t6312 + t6313 - t6221 + t6314 + t6223 + t6315 + t6225 - t6316 + t6320 + t6321;
  tv3rhosigma29 = t9 * t6322 - t1673 + t1674 + t1675 - t1676 + t1680;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = tv3rhosigma27;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = tv3rhosigma28;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t6324 = t1296 * t316;
  t6325 = t1702 * t6324;
  t6326 = t1700 * t6325;
  t6327 = 0.5e1 / 0.576e3 * t6326;
  t6328 = t322 * t1712;
  t6329 = 0.5e1 / 0.72e2 * t6328;
  t6330 = t1354 * t6324;
  t6331 = t154 * t6330;
  t6332 = 0.5e1 / 0.72e2 * t6331;
  t6333 = t416 * t167;
  t6334 = t439 * t6333;
  t6335 = t4393 * t6334;
  t6336 = 0.125e3 / 0.486e3 * t6335;
  t6337 = t4392 * t50;
  t6338 = t408 * t61;
  t6339 = t1152 * t167;
  t6340 = t6338 * t6339;
  t6341 = t6337 * t6340;
  t6342 = 0.25e2 / 0.216e3 * t6341;
  t6343 = t452 * t50;
  t6344 = t6343 * t1154;
  t6345 = 0.5e1 / 0.72e2 * t6344;
  t6346 = t541 * t58;
  t6347 = t6346 * t61;
  t6348 = t805 * t6347;
  t6349 = t1152 * t544;
  t6350 = t6349 * t1297;
  t6351 = t6348 * t6350;
  t6352 = 0.25e3 / 0.243e3 * t6351;
  t6353 = t4139 * t1703;
  t6354 = t154 * t6353;
  t6355 = 0.5e1 / 0.36e2 * t6354;
  t6356 = t4262 * t146;
  t6357 = t1354 * t6356;
  t6358 = t154 * t6357;
  t6359 = 0.25e2 / 0.216e3 * t6358;
  t6360 = t6105 * t40;
  t6361 = t6360 * t153;
  t6362 = t6361 * t1704;
  t6363 = 0.55e2 / 0.864e3 * t6362;
  t6364 = t1701 * t8;
  t6365 = t6364 * t1703;
  t6366 = t1700 * t6365;
  t6367 = 0.5e1 / 0.288e3 * t6366;
  t6368 = t1702 * t6356;
  t6369 = t1700 * t6368;
  t6370 = 0.25e2 / 0.1728e4 * t6369;
  t6371 = -t6327 + t6329 + t6332 + t6336 - t6342 + t6345 - t6352 + t6355 - t6359 + t6363 - t6367 + t6370;
  t6372 = t4156 * t1703;
  t6373 = t154 * t6372;
  t6374 = 0.35e2 / 0.108e3 * t6373;
  t6375 = t1639 * t573;
  t6376 = t6375 * t446;
  t6377 = params->c * t209;
  t6378 = t447 * t6377;
  t6379 = t6376 * t6378;
  t6380 = t1323 * t6379;
  t6381 = 0.25e2 / 0.1296e4 * t6380;
  t6382 = t1707 * t446;
  t6383 = t4248 * t4394;
  t6384 = t6382 * t6383;
  t6385 = t1323 * t6384;
  t6386 = 0.125e3 / 0.7776e4 * t6385;
  t6387 = t15 * t35;
  t6388 = t6387 * t167;
  t6389 = t4330 * t6388;
  t6390 = t1294 * t6389;
  t6391 = 0.125e4 / 0.729e3 * t6390;
  t6392 = t4188 * t403;
  t6393 = t1279 * t6392;
  t6394 = 0.25e2 / 0.162e3 * t6393;
  t6395 = t1280 * t1128;
  t6396 = t1279 * t6395;
  t6397 = 0.25e2 / 0.162e3 * t6396;
  t6398 = t1687 * t1161;
  t6399 = t1686 * t6398;
  t6400 = 0.5e1 / 0.72e2 * t6399;
  t6401 = t55 * t201;
  t6402 = t6401 * t409;
  t6403 = t1686 * t6402;
  t6404 = 0.35e2 / 0.108e3 * t6403;
  t6405 = t1687 * t1157;
  t6406 = t1686 * t6405;
  t6407 = 0.5e1 / 0.36e2 * t6406;
  t6408 = t4286 * t1682;
  t6409 = 0.125e3 / 0.486e3 * t6408;
  t6410 = t1280 * t1132;
  t6411 = t1279 * t6410;
  t6412 = 0.1e3 / 0.243e3 * t6411;
  t6413 = t1266 * t1685;
  t6414 = t6413 * t1688;
  t6415 = 0.25e2 / 0.216e3 * t6414;
  t6416 = t4262 * t35;
  t6417 = t1295 * t6416;
  t6418 = t1294 * t6417;
  t6419 = 0.125e4 / 0.729e3 * t6418;
  t6420 = -t6374 - t6381 + t6386 - t6391 + t6394 + t6397 - t6400 + t6404 - t6407 - t6409 - t6412 + t6415 + t6419;
  t6422 = t1296 * t177;
  t6423 = t1295 * t6422;
  t6424 = t1294 * t6423;
  t6425 = 0.2e4 / 0.729e3 * t6424;
  t6426 = t4987 * t1122;
  t6427 = 0.25e3 / 0.81e2 * t6426;
  t6428 = t4307 * t1692;
  t6429 = 0.25e3 / 0.243e3 * t6428;
  t6430 = t4310 * t1691;
  t6431 = t1294 * t6430;
  t6432 = 0.25e3 / 0.243e3 * t6431;
  t6433 = t30 * t573;
  t6434 = t6433 * t62;
  t6435 = t6434 * t1340;
  t6436 = t1700 * t6435;
  t6437 = 0.5e1 / 0.288e3 * t6436;
  t6438 = t1702 * t1356;
  t6439 = t1700 * t6438;
  t6440 = 0.25e2 / 0.1728e4 * t6439;
  t6441 = t4480 * t1639;
  t6442 = t805 * t6441;
  t6443 = t447 * t1975;
  t6444 = t4483 * t6443;
  t6445 = t6442 * t6444;
  t6446 = 0.125e3 / 0.972e3 * t6445;
  t6447 = t154 * t1341;
  t6448 = 0.5e1 / 0.36e2 * t6447;
  t6449 = t154 * t1357;
  t6450 = 0.25e2 / 0.216e3 * t6449;
  t6451 = t452 * t189;
  t6452 = t1152 * t326;
  t6453 = t3573 * t6452;
  t6454 = t6451 * t6453;
  t6455 = 0.25e2 / 0.162e3 * t6454;
  t6456 = t553 * t1296;
  t6457 = t1143 * t6456;
  t6458 = t1141 * t6457;
  t6459 = 0.25e2 / 0.324e3 * t6458;
  t6460 = t3400 * t1695;
  t6461 = t1141 * t6460;
  t6462 = 0.175e3 / 0.486e3 * t6461;
  t6463 = t6425 - t6427 - t6429 - t6432 + t6437 - t6440 - t6446 - t6448 + t6450 + t6455 + t6459 - t6462;
  t6464 = t3404 * t1695;
  t6465 = t1141 * t6464;
  t6466 = 0.25e2 / 0.162e3 * t6465;
  t6467 = t194 * t4262;
  t6468 = t1143 * t6467;
  t6469 = t1141 * t6468;
  t6470 = 0.125e3 / 0.972e3 * t6469;
  t6471 = t1723 * t316;
  t6472 = t4431 * t1716;
  t6474 = t325 * t6333;
  t6475 = t4407 * t6474;
  t6477 = t4357 * t1172;
  t6480 = t800 * t801 * t177;
  t6481 = t1373 * t6480;
  t6482 = 0.1e3 / 0.243e3 * t6481;
  t6484 = t1719 * t180 * t50;
  t6485 = t5113 * t6484;
  t6488 = t543 * t4424 * t1719;
  t6490 = t1378 * t6388;
  t6491 = t543 * t6490;
  t6493 = t16 * t177;
  t6495 = t543 * t1378 * t6493;
  t6496 = 0.2e4 / 0.729e3 * t6495;
  t6497 = 0.125e3 / 0.486e3 * t6472 - 0.125e3 / 0.486e3 * t6475 + 0.25e3 / 0.81e2 * t6477 + t6482 - 0.125e4 / 0.729e3 * t6485 - 0.125e4 / 0.729e3 * t6488 + 0.125e4 / 0.729e3 * t6491 - t6496;
  t6498 = t6497 * t146;
  t6499 = t1708 * t6456;
  t6500 = t1323 * t6499;
  t6501 = 0.25e2 / 0.2592e4 * t6500;
  t6502 = t800 * t3572;
  t6503 = t1139 * t6502;
  t6504 = t4483 * t1326;
  t6505 = t6503 * t6504;
  t6506 = 0.25e2 / 0.324e3 * t6505;
  t6507 = t1691 * t3853;
  t6508 = t4799 * t6507;
  t6509 = 0.125e4 / 0.729e3 * t6508;
  t6510 = t16 * t209;
  t6511 = t440 * t6510;
  t6512 = t1797 * t6511;
  t6513 = t6503 * t6512;
  t6514 = 0.25e2 / 0.324e3 * t6513;
  t6515 = t440 * t168;
  t6516 = t409 * t6515;
  t6517 = t6503 * t6516;
  t6518 = 0.125e3 / 0.972e3 * t6517;
  t6519 = t1640 * t185;
  t6520 = t6519 * t1322;
  t6521 = t6520 * t6504;
  t6522 = 0.25e2 / 0.1296e4 * t6521;
  t6523 = t6104 * t206;
  t6524 = t6523 * t62;
  t6525 = t6524 * t1695;
  t6526 = t1323 * t6525;
  t6527 = 0.275e3 / 0.3888e4 * t6526;
  t6528 = t1707 * t8;
  t6529 = t6528 * t1695;
  t6530 = t1323 * t6529;
  t6531 = 0.25e2 / 0.1296e4 * t6530;
  t6532 = t1708 * t6467;
  t6533 = t1323 * t6532;
  t6534 = 0.125e3 / 0.7776e4 * t6533;
  t6535 = t6466 - t6470 + t6471 + t6498 + t6501 - t6506 + t6509 - t6514 + t6518 + t6522 - t6527 + t6531 - t6534;
  tv3rhosigmatau0 = t1684 - t1690 - t1694 + t1698 - t1706 + t1711 + t1714 + t1724 + t9 * (t6371 + t6420 + t6463 + t6535);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t6539 = t1410 * t316;
  t6540 = t1354 * t6539;
  t6541 = t154 * t6540;
  t6542 = 0.5e1 / 0.72e2 * t6541;
  t6543 = t416 * t171;
  t6544 = t439 * t6543;
  t6545 = t4719 * t6544;
  t6546 = 0.125e3 / 0.486e3 * t6545;
  t6547 = t4718 * t50;
  t6548 = t1152 * t171;
  t6549 = t6338 * t6548;
  t6550 = t6547 * t6549;
  t6551 = 0.25e2 / 0.216e3 * t6550;
  t6552 = t478 * t50;
  t6553 = t6552 * t1154;
  t6554 = 0.5e1 / 0.72e2 * t6553;
  t6555 = t6349 * t1411;
  t6556 = t6348 * t6555;
  t6557 = 0.25e3 / 0.243e3 * t6556;
  t6558 = t1702 * t6539;
  t6559 = t1700 * t6558;
  t6560 = 0.5e1 / 0.576e3 * t6559;
  t6561 = t322 * t1747;
  t6562 = 0.5e1 / 0.72e2 * t6561;
  t6563 = t6375 * t472;
  t6564 = t473 * t6377;
  t6566 = t1323 * t6563 * t6564;
  t6567 = 0.25e2 / 0.1296e4 * t6566;
  t6568 = t1707 * t472;
  t6569 = t4742 * t4628;
  t6571 = t1323 * t6568 * t6569;
  t6572 = 0.125e3 / 0.7776e4 * t6571;
  t6573 = t1403 * t6392;
  t6574 = 0.25e2 / 0.162e3 * t6573;
  t6576 = t1403 * t6395;
  t6577 = 0.25e2 / 0.162e3 * t6576;
  t6578 = t1729 * t6398;
  t6579 = 0.5e1 / 0.72e2 * t6578;
  t6580 = t26 * t35;
  t6581 = t6580 * t171;
  t6582 = t1831 * t6581;
  t6583 = t1294 * t6582;
  t6584 = 0.125e4 / 0.729e3 * t6583;
  t6585 = t1729 * t6402;
  t6586 = 0.35e2 / 0.108e3 * t6585;
  t6587 = t1729 * t6405;
  t6588 = 0.5e1 / 0.36e2 * t6587;
  t6589 = t1403 * t6410;
  t6590 = 0.1e3 / 0.243e3 * t6589;
  t6591 = t6364 * t1740;
  t6592 = t1700 * t6591;
  t6593 = 0.5e1 / 0.288e3 * t6592;
  t6594 = t1410 * t177;
  t6595 = t1295 * t6594;
  t6596 = t1294 * t6595;
  t6597 = 0.2e4 / 0.729e3 * t6596;
  t6598 = t5452 * t1122;
  t6599 = 0.25e3 / 0.81e2 * t6598;
  t6600 = t4307 * t1733;
  t6601 = 0.25e3 / 0.243e3 * t6600;
  t6602 = t4310 * t1732;
  t6603 = t1294 * t6602;
  t6604 = 0.25e3 / 0.243e3 * t6603;
  t6605 = t6577 - t6579 - t6584 + t6586 - t6588 - t6590 - t6593 + t6597 - t6599 - t6601 - t6604;
  t6607 = t325 * t6543;
  t6608 = t4627 * t6607;
  t6610 = t4739 * t1172;
  t6612 = t1460 * t6480;
  t6613 = 0.1e3 / 0.243e3 * t6612;
  t6615 = t1752 * t180 * t50;
  t6616 = t5510 * t6615;
  t6619 = t543 * t1463 * t6581;
  t6621 = t27 * t177;
  t6623 = t543 * t1463 * t6621;
  t6624 = 0.2e4 / 0.729e3 * t6623;
  t6625 = -0.125e3 / 0.486e3 * t6608 + 0.25e3 / 0.81e2 * t6610 + t6613 - 0.125e4 / 0.729e3 * t6616 + 0.125e4 / 0.729e3 * t6619 - t6624;
  t6626 = t6625 * t146;
  t6627 = t4156 * t1740;
  t6628 = t154 * t6627;
  t6629 = 0.35e2 / 0.108e3 * t6628;
  t6630 = t4139 * t1740;
  t6631 = t154 * t6630;
  t6632 = 0.5e1 / 0.36e2 * t6631;
  t6633 = t6361 * t1741;
  t6634 = 0.55e2 / 0.864e3 * t6633;
  t6635 = t473 * t1975;
  t6636 = t4583 * t6635;
  t6637 = t6442 * t6636;
  t6638 = 0.125e3 / 0.972e3 * t6637;
  t6640 = t1141 * t3400 * t1736;
  t6641 = 0.175e3 / 0.486e3 * t6640;
  t6643 = t1141 * t3404 * t1736;
  t6644 = 0.25e2 / 0.162e3 * t6643;
  t6645 = t154 * t1437;
  t6646 = 0.5e1 / 0.36e2 * t6645;
  t6647 = t154 * t1447;
  t6648 = 0.25e2 / 0.216e3 * t6647;
  t6649 = t1826 * t6453;
  t6650 = 0.25e2 / 0.162e3 * t6649;
  t6651 = t553 * t1410;
  t6653 = t1141 * t1143 * t6651;
  t6654 = 0.25e2 / 0.324e3 * t6653;
  t6655 = t6626 - t6629 + t6632 + t6634 - t6638 - t6641 + t6644 - t6646 + t6648 + t6650 + t6654;
  t6656 = t6434 * t1436;
  t6657 = t1700 * t6656;
  t6658 = 0.5e1 / 0.288e3 * t6657;
  t6659 = t1702 * t1446;
  t6660 = t1700 * t6659;
  t6661 = 0.25e2 / 0.1728e4 * t6660;
  t6662 = t1756 * t316;
  t6663 = t4583 * t1429;
  t6664 = t6520 * t6663;
  t6665 = 0.25e2 / 0.1296e4 * t6664;
  t6666 = t1708 * t6651;
  t6667 = t1323 * t6666;
  t6668 = 0.25e2 / 0.2592e4 * t6667;
  t6669 = t6503 * t6663;
  t6670 = 0.25e2 / 0.324e3 * t6669;
  t6671 = t1732 * t3853;
  t6672 = t4799 * t6671;
  t6673 = 0.125e4 / 0.729e3 * t6672;
  t6674 = t27 * t209;
  t6675 = t467 * t6674;
  t6676 = t1797 * t6675;
  t6677 = t6503 * t6676;
  t6678 = 0.25e2 / 0.324e3 * t6677;
  t6679 = t467 * t172;
  t6680 = t409 * t6679;
  t6681 = t6503 * t6680;
  t6682 = 0.125e3 / 0.972e3 * t6681;
  t6683 = t6524 * t1736;
  t6684 = t1323 * t6683;
  t6685 = 0.275e3 / 0.3888e4 * t6684;
  t6686 = t6528 * t1736;
  t6687 = t1323 * t6686;
  t6688 = 0.25e2 / 0.1296e4 * t6687;
  t6689 = t6658 - t6661 + t6662 + t6665 + t6668 - t6670 + t6673 - t6678 + t6682 - t6685 + t6688;
  tv3rhosigmatau1 = t1727 - t1731 - t1735 + t1739 - t1743 + t1746 + t1749 + t1757 + t9 * (t6542 + t6546 - t6551 + t6554 - t6557 - t6560 + t6562 - t6567 + t6572 + t6574 + t6605 + t6655 + t6689);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  t6693 = 0.5e1 / 0.288e3 * t6326;
  t6694 = 0.5e1 / 0.36e2 * t6328;
  t6695 = 0.5e1 / 0.36e2 * t6331;
  t6696 = 0.125e3 / 0.243e3 * t6335;
  t6697 = 0.25e2 / 0.108e3 * t6341;
  t6698 = 0.5e1 / 0.36e2 * t6344;
  t6699 = 0.5e3 / 0.243e3 * t6351;
  t6700 = 0.5e1 / 0.18e2 * t6354;
  t6701 = 0.25e2 / 0.108e3 * t6358;
  t6702 = 0.55e2 / 0.432e3 * t6362;
  t6703 = 0.5e1 / 0.144e3 * t6366;
  t6704 = 0.25e2 / 0.864e3 * t6369;
  t6705 = -t6693 + t6694 + t6695 + t6696 - t6697 + t6698 - t6699 + t6700 - t6701 + t6702 - t6703 + t6704;
  t6706 = 0.35e2 / 0.54e2 * t6373;
  t6710 = 0.2e3 / 0.243e3 * t6481;
  t6714 = 0.4e4 / 0.729e3 * t6495;
  t6715 = 0.125e3 / 0.243e3 * t6472 - 0.125e3 / 0.243e3 * t6475 + 0.5e3 / 0.81e2 * t6477 + t6710 - 0.25e4 / 0.729e3 * t6485 - 0.25e4 / 0.729e3 * t6488 + 0.25e4 / 0.729e3 * t6491 - t6714;
  t6716 = t6715 * t146;
  t6717 = 0.25e2 / 0.648e3 * t6380;
  t6718 = 0.125e3 / 0.3888e4 * t6385;
  t6719 = 0.25e4 / 0.729e3 * t6390;
  t6720 = 0.25e2 / 0.81e2 * t6393;
  t6721 = 0.25e2 / 0.81e2 * t6396;
  t6722 = 0.5e1 / 0.36e2 * t6399;
  t6723 = 0.35e2 / 0.54e2 * t6403;
  t6724 = 0.5e1 / 0.18e2 * t6406;
  t6725 = 0.125e3 / 0.243e3 * t6408;
  t6726 = 0.2e3 / 0.243e3 * t6411;
  t6727 = 0.25e2 / 0.108e3 * t6414;
  t6728 = -t6706 + t6716 - t6717 + t6718 - t6719 + t6720 + t6721 - t6722 + t6723 - t6724 - t6725 - t6726 + t6727;
  t6730 = t1768 * t316;
  t6731 = 0.25e4 / 0.729e3 * t6418;
  t6732 = 0.4e4 / 0.729e3 * t6424;
  t6733 = 0.5e3 / 0.81e2 * t6426;
  t6734 = 0.5e3 / 0.243e3 * t6428;
  t6735 = 0.5e3 / 0.243e3 * t6431;
  t6736 = 0.5e1 / 0.144e3 * t6436;
  t6737 = 0.25e2 / 0.864e3 * t6439;
  t6738 = 0.125e3 / 0.486e3 * t6445;
  t6739 = 0.5e1 / 0.18e2 * t6447;
  t6740 = 0.25e2 / 0.108e3 * t6449;
  t6741 = 0.25e2 / 0.81e2 * t6454;
  t6742 = t6730 + t6731 + t6732 - t6733 - t6734 - t6735 + t6736 - t6737 - t6738 - t6739 + t6740 + t6741;
  t6743 = 0.25e2 / 0.162e3 * t6458;
  t6744 = 0.175e3 / 0.243e3 * t6461;
  t6745 = 0.25e2 / 0.81e2 * t6465;
  t6746 = 0.125e3 / 0.486e3 * t6469;
  t6747 = 0.25e2 / 0.1296e4 * t6500;
  t6748 = 0.25e2 / 0.162e3 * t6505;
  t6749 = 0.25e4 / 0.729e3 * t6508;
  t6750 = 0.25e2 / 0.162e3 * t6513;
  t6751 = 0.125e3 / 0.486e3 * t6517;
  t6752 = 0.25e2 / 0.648e3 * t6521;
  t6753 = 0.275e3 / 0.1944e4 * t6526;
  t6754 = 0.25e2 / 0.648e3 * t6530;
  t6755 = 0.125e3 / 0.3888e4 * t6533;
  t6756 = t6743 - t6744 + t6745 - t6746 + t6747 - t6748 + t6749 - t6750 + t6751 + t6752 - t6753 + t6754 - t6755;
  tv3rhosigmatau2 = t1759 - t1760 - t1761 + t1762 - t1763 + t1764 + t1765 + t1769 + t9 * (t6705 + t6728 + t6742 + t6756);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  t6760 = 0.5e1 / 0.36e2 * t6541;
  t6761 = 0.125e3 / 0.243e3 * t6545;
  t6762 = 0.25e2 / 0.108e3 * t6550;
  t6763 = 0.5e1 / 0.36e2 * t6553;
  t6764 = 0.5e3 / 0.243e3 * t6556;
  t6765 = 0.5e1 / 0.288e3 * t6559;
  t6766 = 0.5e1 / 0.36e2 * t6561;
  t6767 = t1780 * t316;
  t6768 = 0.25e2 / 0.648e3 * t6566;
  t6769 = 0.125e3 / 0.3888e4 * t6571;
  t6771 = 0.25e2 / 0.81e2 * t6573;
  t6772 = 0.25e2 / 0.81e2 * t6576;
  t6773 = 0.5e1 / 0.36e2 * t6578;
  t6774 = 0.25e4 / 0.729e3 * t6583;
  t6775 = 0.35e2 / 0.54e2 * t6585;
  t6776 = 0.5e1 / 0.18e2 * t6587;
  t6777 = 0.2e3 / 0.243e3 * t6589;
  t6778 = 0.5e1 / 0.144e3 * t6592;
  t6779 = 0.4e4 / 0.729e3 * t6596;
  t6780 = 0.5e3 / 0.81e2 * t6598;
  t6781 = 0.5e3 / 0.243e3 * t6600;
  t6782 = t6771 + t6772 - t6773 - t6774 + t6775 - t6776 - t6777 - t6778 + t6779 - t6780 - t6781;
  t6784 = 0.5e3 / 0.243e3 * t6603;
  t6787 = 0.2e3 / 0.243e3 * t6612;
  t6790 = 0.4e4 / 0.729e3 * t6623;
  t6791 = -0.125e3 / 0.243e3 * t6608 + 0.5e3 / 0.81e2 * t6610 + t6787 - 0.25e4 / 0.729e3 * t6616 + 0.25e4 / 0.729e3 * t6619 - t6790;
  t6792 = t6791 * t146;
  t6793 = 0.35e2 / 0.54e2 * t6628;
  t6794 = 0.5e1 / 0.18e2 * t6631;
  t6795 = 0.55e2 / 0.432e3 * t6633;
  t6796 = 0.125e3 / 0.486e3 * t6637;
  t6797 = 0.175e3 / 0.243e3 * t6640;
  t6798 = 0.25e2 / 0.81e2 * t6643;
  t6799 = 0.5e1 / 0.18e2 * t6645;
  t6800 = 0.25e2 / 0.108e3 * t6647;
  t6801 = 0.25e2 / 0.81e2 * t6649;
  t6802 = -t6784 + t6792 - t6793 + t6794 + t6795 - t6796 - t6797 + t6798 - t6799 + t6800 + t6801;
  t6803 = 0.25e2 / 0.162e3 * t6653;
  t6804 = 0.5e1 / 0.144e3 * t6657;
  t6805 = 0.25e2 / 0.864e3 * t6660;
  t6806 = 0.25e2 / 0.648e3 * t6664;
  t6807 = 0.25e2 / 0.1296e4 * t6667;
  t6808 = 0.25e2 / 0.162e3 * t6669;
  t6809 = 0.25e4 / 0.729e3 * t6672;
  t6810 = 0.25e2 / 0.162e3 * t6677;
  t6811 = 0.125e3 / 0.486e3 * t6681;
  t6812 = 0.275e3 / 0.1944e4 * t6684;
  t6813 = 0.25e2 / 0.648e3 * t6687;
  t6814 = t6803 + t6804 - t6805 + t6806 + t6807 - t6808 + t6809 - t6810 + t6811 - t6812 + t6813;
  tv3rhosigmatau3 = t1771 - t1772 - t1773 + t1774 - t1775 + t1776 + t1777 + t1781 + t9 * (t6760 + t6761 - t6762 + t6763 - t6764 - t6765 + t6766 + t6767 - t6768 + t6769 + t6782 + t6802 + t6814);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = tv3rhosigmatau0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = tv3rhosigmatau1;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t6818 = t1296 * t382;
  t6819 = t1354 * t6818;
  t6820 = t154 * t6819;
  t6821 = 0.5e1 / 0.72e2 * t6820;
  t6822 = t1152 * t336;
  t6823 = t6338 * t6822;
  t6824 = t6337 * t6823;
  t6825 = 0.25e2 / 0.216e3 * t6824;
  t6826 = t6343 * t1231;
  t6827 = 0.5e1 / 0.72e2 * t6826;
  t6828 = t6349 * t1492;
  t6829 = t6348 * t6828;
  t6830 = 0.25e3 / 0.243e3 * t6829;
  t6831 = t1702 * t6818;
  t6832 = t1700 * t6831;
  t6833 = 0.5e1 / 0.576e3 * t6832;
  t6834 = t388 * t1712;
  t6835 = 0.5e1 / 0.72e2 * t6834;
  t6836 = t416 * t336;
  t6837 = t439 * t6836;
  t6838 = t4393 * t6837;
  t6839 = 0.125e3 / 0.486e3 * t6838;
  t6840 = t6434 * t1515;
  t6841 = t1700 * t6840;
  t6842 = 0.5e1 / 0.288e3 * t6841;
  t6843 = t154 * t1516;
  t6844 = 0.5e1 / 0.36e2 * t6843;
  t6845 = t154 * t1521;
  t6846 = 0.25e2 / 0.216e3 * t6845;
  t6848 = t4248 * t5089;
  t6849 = t6382 * t6848;
  t6850 = t1323 * t6849;
  t6851 = 0.125e3 / 0.7776e4 * t6850;
  t6852 = params->c * t360;
  t6853 = t447 * t6852;
  t6854 = t6376 * t6853;
  t6855 = t1323 * t6854;
  t6856 = 0.25e2 / 0.1296e4 * t6855;
  t6857 = t325 * t6836;
  t6858 = t4407 * t6857;
  t6860 = t4357 * t1241;
  t6862 = t1719 * t350;
  t6863 = t6862 * t50;
  t6864 = t5113 * t6863;
  t6866 = t6387 * t336;
  t6867 = t1378 * t6866;
  t6868 = t543 * t6867;
  t6870 = -0.125e3 / 0.486e3 * t6858 + 0.25e3 / 0.81e2 * t6860 + t6482 - 0.125e4 / 0.729e3 * t6864 + 0.125e4 / 0.729e3 * t6868 - t6496;
  t6871 = t6870 * t146;
  t6872 = t1702 * t1520;
  t6873 = t1700 * t6872;
  t6874 = 0.25e2 / 0.1728e4 * t6873;
  t6875 = t447 * t853;
  t6876 = t4483 * t6875;
  t6877 = t6442 * t6876;
  t6878 = 0.125e3 / 0.972e3 * t6877;
  t6879 = t1152 * t390;
  t6880 = t3573 * t6879;
  t6881 = t6451 * t6880;
  t6882 = 0.25e2 / 0.162e3 * t6881;
  t6883 = t902 * t1296;
  t6884 = t1143 * t6883;
  t6885 = t1141 * t6884;
  t6886 = 0.25e2 / 0.324e3 * t6885;
  t6887 = t6851 - t6856 - t6355 + t6363 + t6367 - t6374 + t6871 - t6874 - t6878 + t6882 + t6886;
  t6889 = t4987 * t1214;
  t6890 = 0.25e3 / 0.81e2 * t6889;
  t6891 = t4854 * t1692;
  t6892 = 0.25e3 / 0.243e3 * t6891;
  t6893 = t4840 * t1691;
  t6894 = t1294 * t6893;
  t6895 = 0.25e3 / 0.243e3 * t6894;
  t6896 = t4483 * t1510;
  t6897 = t6503 * t6896;
  t6898 = 0.25e2 / 0.324e3 * t6897;
  t6900 = t350 * t40 * t152;
  t6901 = t1691 * t6900;
  t6902 = t4799 * t6901;
  t6903 = 0.125e4 / 0.729e3 * t6902;
  t6904 = t16 * t360;
  t6905 = t440 * t6904;
  t6906 = t1797 * t6905;
  t6907 = t6503 * t6906;
  t6908 = 0.25e2 / 0.324e3 * t6907;
  t6909 = t1708 * t6883;
  t6910 = t1323 * t6909;
  t6911 = 0.25e2 / 0.2592e4 * t6910;
  t6912 = t6520 * t6896;
  t6913 = 0.25e2 / 0.1296e4 * t6912;
  t6914 = t4960 * t403;
  t6915 = t1279 * t6914;
  t6916 = 0.25e2 / 0.162e3 * t6915;
  t6917 = t1280 * t1220;
  t6918 = t1279 * t6917;
  t6919 = 0.25e2 / 0.162e3 * t6918;
  t6920 = t1687 * t1234;
  t6921 = t1686 * t6920;
  t6922 = 0.5e1 / 0.72e2 * t6921;
  t6923 = -t6890 - t6892 - t6895 - t6898 + t6903 - t6908 + t6911 + t6913 + t6916 + t6919 - t6922;
  t6924 = t4330 * t6866;
  t6925 = t1294 * t6924;
  t6926 = 0.125e4 / 0.729e3 * t6925;
  t6927 = t440 * t337;
  t6928 = t409 * t6927;
  t6929 = t6503 * t6928;
  t6930 = 0.125e3 / 0.972e3 * t6929;
  t6931 = t1723 * t382;
  t6932 = -t6926 + t6404 + t6407 - t6412 + t6930 + t6425 + t6931 - t6462 - t6466 - t6527 - t6531;
  tv3rhosigmatau6 = t1684 - t1690 - t1694 + t1698 - t1706 + t1711 + t1714 + t1724 + t9 * (t6821 - t6825 + t6827 - t6830 - t6833 + t6835 + t6839 + t6842 - t6844 + t6846 + t6887 + t6923 + t6932);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  t6936 = t1152 * t346;
  t6937 = t6338 * t6936;
  t6938 = t6547 * t6937;
  t6939 = 0.25e2 / 0.216e3 * t6938;
  t6940 = t6552 * t1231;
  t6941 = 0.5e1 / 0.72e2 * t6940;
  t6942 = t6349 * t1563;
  t6943 = t6348 * t6942;
  t6944 = 0.25e3 / 0.243e3 * t6943;
  t6945 = t1410 * t382;
  t6946 = t1702 * t6945;
  t6947 = t1700 * t6946;
  t6948 = 0.5e1 / 0.576e3 * t6947;
  t6949 = t154 * t1599;
  t6950 = 0.25e2 / 0.216e3 * t6949;
  t6951 = t1826 * t6880;
  t6952 = 0.25e2 / 0.162e3 * t6951;
  t6953 = t902 * t1410;
  t6955 = t1141 * t1143 * t6953;
  t6956 = 0.25e2 / 0.324e3 * t6955;
  t6957 = t6434 * t1588;
  t6958 = t1700 * t6957;
  t6959 = 0.5e1 / 0.288e3 * t6958;
  t6960 = t1702 * t1598;
  t6961 = t1700 * t6960;
  t6962 = 0.25e2 / 0.1728e4 * t6961;
  t6963 = t473 * t853;
  t6964 = t4583 * t6963;
  t6965 = t6442 * t6964;
  t6966 = 0.125e3 / 0.972e3 * t6965;
  t6967 = t154 * t1589;
  t6968 = 0.5e1 / 0.36e2 * t6967;
  t6969 = t194 * t5214;
  t6970 = t1143 * t6969;
  t6971 = t1141 * t6970;
  t6972 = 0.125e3 / 0.972e3 * t6971;
  t6973 = -t6939 + t6941 - t6944 - t6948 + t6950 + t6952 + t6956 + t6959 - t6962 - t6966 - t6968 - t6972;
  t6974 = t388 * t1747;
  t6975 = 0.5e1 / 0.72e2 * t6974;
  t6976 = t1354 * t6945;
  t6977 = t154 * t6976;
  t6978 = 0.5e1 / 0.72e2 * t6977;
  t6979 = t416 * t346;
  t6980 = t439 * t6979;
  t6981 = t4719 * t6980;
  t6982 = 0.125e3 / 0.486e3 * t6981;
  t6983 = t5214 * t146;
  t6984 = t1702 * t6983;
  t6985 = t1700 * t6984;
  t6986 = 0.25e2 / 0.1728e4 * t6985;
  t6987 = t1354 * t6983;
  t6988 = t154 * t6987;
  t6989 = 0.25e2 / 0.216e3 * t6988;
  t6990 = t1729 * t6920;
  t6991 = 0.5e1 / 0.72e2 * t6990;
  t6992 = t6580 * t346;
  t6993 = t1831 * t6992;
  t6994 = t1294 * t6993;
  t6995 = 0.125e4 / 0.729e3 * t6994;
  t6996 = t1403 * t6914;
  t6997 = 0.25e2 / 0.162e3 * t6996;
  t6998 = t1403 * t6917;
  t6999 = 0.25e2 / 0.162e3 * t6998;
  t7000 = t5214 * t35;
  t7001 = t1295 * t7000;
  t7002 = t1294 * t7001;
  t7003 = 0.125e4 / 0.729e3 * t7002;
  t7004 = t5452 * t1214;
  t7005 = 0.25e3 / 0.81e2 * t7004;
  t7006 = t4854 * t1733;
  t7007 = 0.25e3 / 0.243e3 * t7006;
  t7008 = t4840 * t1732;
  t7009 = t1294 * t7008;
  t7010 = 0.25e3 / 0.243e3 * t7009;
  t7011 = t6975 + t6978 + t6982 + t6986 - t6989 - t6991 - t6995 + t6997 + t6999 + t7003 - t7005 - t7007 - t7010;
  t7013 = t467 * t347;
  t7014 = t409 * t7013;
  t7015 = t6503 * t7014;
  t7016 = 0.125e3 / 0.972e3 * t7015;
  t7017 = t4583 * t1584;
  t7018 = t6520 * t7017;
  t7019 = 0.25e2 / 0.1296e4 * t7018;
  t7020 = t1708 * t6953;
  t7021 = t1323 * t7020;
  t7022 = 0.25e2 / 0.2592e4 * t7021;
  t7023 = t473 * t6852;
  t7024 = t6563 * t7023;
  t7025 = t1323 * t7024;
  t7026 = 0.25e2 / 0.1296e4 * t7025;
  t7027 = t4742 * t5475;
  t7028 = t6568 * t7027;
  t7029 = t1323 * t7028;
  t7030 = 0.125e3 / 0.7776e4 * t7029;
  t7031 = t6503 * t7017;
  t7032 = 0.25e2 / 0.324e3 * t7031;
  t7033 = t27 * t360;
  t7034 = t467 * t7033;
  t7035 = t1797 * t7034;
  t7036 = t6503 * t7035;
  t7037 = 0.25e2 / 0.324e3 * t7036;
  t7038 = t7016 + t7019 + t7022 - t7026 + t7030 - t7032 - t7037 + t6586 + t6588 - t6590 + t6593 + t6597;
  t7039 = t1549 * t1728;
  t7040 = t7039 * t1688;
  t7041 = 0.25e2 / 0.216e3 * t7040;
  t7042 = t5240 * t1682;
  t7043 = 0.125e3 / 0.486e3 * t7042;
  t7044 = t1756 * t382;
  t7045 = t5490 * t1716;
  t7047 = t325 * t6979;
  t7048 = t4627 * t7047;
  t7050 = t4739 * t1241;
  t7052 = t1752 * t350;
  t7053 = t7052 * t50;
  t7054 = t5510 * t7053;
  t7057 = t543 * t5522 * t1752;
  t7060 = t543 * t1463 * t6992;
  t7062 = 0.125e3 / 0.486e3 * t7045 - 0.125e3 / 0.486e3 * t7048 + 0.25e3 / 0.81e2 * t7050 + t6613 - 0.125e4 / 0.729e3 * t7054 - 0.125e4 / 0.729e3 * t7057 + 0.125e4 / 0.729e3 * t7060 - t6624;
  t7063 = t7062 * t146;
  t7064 = t1732 * t6900;
  t7065 = t4799 * t7064;
  t7066 = 0.125e4 / 0.729e3 * t7065;
  t7067 = t1708 * t6969;
  t7068 = t1323 * t7067;
  t7069 = 0.125e3 / 0.7776e4 * t7068;
  t7070 = t7041 - t7043 + t7044 + t7063 - t6629 - t6632 + t6634 + t7066 - t7069 - t6641 - t6644 - t6685 - t6688;
  tv3rhosigmatau7 = t1727 - t1731 - t1735 + t1739 - t1743 + t1746 + t1749 + t1757 + t9 * (t6973 + t7011 + t7038 + t7070);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  t7074 = 0.5e1 / 0.36e2 * t6820;
  t7075 = 0.25e2 / 0.108e3 * t6824;
  t7076 = 0.5e1 / 0.36e2 * t6826;
  t7077 = 0.5e3 / 0.243e3 * t6829;
  t7078 = 0.5e1 / 0.288e3 * t6832;
  t7079 = 0.5e1 / 0.36e2 * t6834;
  t7080 = 0.125e3 / 0.243e3 * t6838;
  t7081 = t1768 * t382;
  t7082 = 0.5e1 / 0.144e3 * t6841;
  t7083 = 0.5e1 / 0.18e2 * t6843;
  t7085 = 0.25e2 / 0.108e3 * t6845;
  t7086 = 0.125e3 / 0.3888e4 * t6850;
  t7087 = 0.25e2 / 0.648e3 * t6855;
  t7088 = 0.25e2 / 0.864e3 * t6873;
  t7089 = 0.125e3 / 0.486e3 * t6877;
  t7090 = 0.25e2 / 0.81e2 * t6881;
  t7091 = 0.25e2 / 0.162e3 * t6885;
  t7092 = t7085 + t7086 - t7087 - t6700 + t6702 + t6703 - t6706 - t7088 - t7089 + t7090 + t7091;
  t7098 = -0.125e3 / 0.243e3 * t6858 + 0.5e3 / 0.81e2 * t6860 + t6710 - 0.25e4 / 0.729e3 * t6864 + 0.25e4 / 0.729e3 * t6868 - t6714;
  t7099 = t7098 * t146;
  t7100 = 0.5e3 / 0.81e2 * t6889;
  t7101 = 0.5e3 / 0.243e3 * t6891;
  t7102 = 0.5e3 / 0.243e3 * t6894;
  t7103 = 0.25e2 / 0.162e3 * t6897;
  t7104 = 0.25e4 / 0.729e3 * t6902;
  t7105 = 0.25e2 / 0.162e3 * t6907;
  t7106 = 0.25e2 / 0.1296e4 * t6910;
  t7107 = 0.25e2 / 0.648e3 * t6912;
  t7108 = 0.25e2 / 0.81e2 * t6915;
  t7109 = 0.25e2 / 0.81e2 * t6918;
  t7110 = t7099 - t7100 - t7101 - t7102 - t7103 + t7104 - t7105 + t7106 + t7107 + t7108 + t7109;
  t7111 = 0.5e1 / 0.36e2 * t6921;
  t7112 = 0.25e4 / 0.729e3 * t6925;
  t7113 = 0.125e3 / 0.486e3 * t6929;
  t7114 = -t7111 - t7112 + t6723 + t6724 - t6726 + t7113 + t6732 - t6744 - t6745 - t6753 - t6754;
  tv3rhosigmatau8 = t1759 - t1760 - t1761 + t1762 - t1763 + t1764 + t1765 + t1769 + t9 * (t7074 - t7075 + t7076 - t7077 - t7078 + t7079 + t7080 + t7081 + t7082 - t7083 + t7092 + t7110 + t7114);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  t7118 = 0.25e2 / 0.108e3 * t6938;
  t7119 = 0.5e1 / 0.36e2 * t6940;
  t7120 = 0.5e3 / 0.243e3 * t6943;
  t7121 = 0.5e1 / 0.288e3 * t6947;
  t7122 = 0.25e2 / 0.108e3 * t6949;
  t7123 = 0.25e2 / 0.81e2 * t6951;
  t7124 = 0.25e2 / 0.162e3 * t6955;
  t7125 = 0.5e1 / 0.144e3 * t6958;
  t7126 = 0.25e2 / 0.864e3 * t6961;
  t7127 = 0.125e3 / 0.486e3 * t6965;
  t7128 = 0.5e1 / 0.18e2 * t6967;
  t7129 = 0.125e3 / 0.486e3 * t6971;
  t7130 = -t7118 + t7119 - t7120 - t7121 + t7122 + t7123 + t7124 + t7125 - t7126 - t7127 - t7128 - t7129;
  t7131 = 0.5e1 / 0.36e2 * t6974;
  t7132 = 0.5e1 / 0.36e2 * t6977;
  t7133 = 0.125e3 / 0.243e3 * t6981;
  t7134 = 0.25e2 / 0.864e3 * t6985;
  t7135 = 0.25e2 / 0.108e3 * t6988;
  t7142 = 0.125e3 / 0.243e3 * t7045 - 0.125e3 / 0.243e3 * t7048 + 0.5e3 / 0.81e2 * t7050 + t6787 - 0.25e4 / 0.729e3 * t7054 - 0.25e4 / 0.729e3 * t7057 + 0.25e4 / 0.729e3 * t7060 - t6790;
  t7143 = t7142 * t146;
  t7144 = 0.5e1 / 0.36e2 * t6990;
  t7145 = 0.25e4 / 0.729e3 * t6994;
  t7146 = 0.25e2 / 0.81e2 * t6996;
  t7147 = 0.25e2 / 0.81e2 * t6998;
  t7148 = 0.25e4 / 0.729e3 * t7002;
  t7149 = 0.5e3 / 0.81e2 * t7004;
  t7150 = 0.5e3 / 0.243e3 * t7006;
  t7151 = t7131 + t7132 + t7133 + t7134 - t7135 + t7143 - t7144 - t7145 + t7146 + t7147 + t7148 - t7149 - t7150;
  t7153 = 0.5e3 / 0.243e3 * t7009;
  t7154 = 0.125e3 / 0.486e3 * t7015;
  t7155 = 0.25e2 / 0.648e3 * t7018;
  t7156 = 0.25e2 / 0.1296e4 * t7021;
  t7157 = 0.25e2 / 0.648e3 * t7025;
  t7158 = 0.125e3 / 0.3888e4 * t7029;
  t7159 = 0.25e2 / 0.162e3 * t7031;
  t7160 = 0.25e2 / 0.162e3 * t7036;
  t7161 = t1780 * t382;
  t7162 = -t7153 + t7154 + t7155 + t7156 - t7157 + t7158 - t7159 - t7160 + t7161 + t6775 + t6776 - t6777;
  t7163 = 0.25e2 / 0.108e3 * t7040;
  t7164 = 0.125e3 / 0.243e3 * t7042;
  t7165 = 0.25e4 / 0.729e3 * t7065;
  t7166 = 0.125e3 / 0.3888e4 * t7068;
  t7167 = t6778 + t6779 + t7163 - t7164 - t6793 - t6794 + t6795 + t7165 - t7166 - t6797 - t6798 - t6812 - t6813;
  tv3rhosigmatau9 = t1771 - t1772 - t1773 + t1774 - t1775 + t1776 + t1777 + t1781 + t9 * (t7130 + t7151 + t7162 + t7167);

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = tv3rhosigmatau6;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = tv3rhosigmatau7;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t7171 = t217 * t1802;
  t7172 = t543 * t7171;
  t7173 = 0.2e4 / 0.243e3 * t7172;
  t7174 = t317 * t1802;
  t7175 = t543 * t7174;
  t7176 = 0.2e4 / 0.243e3 * t7175;
  t7177 = t1788 * t539;
  t7178 = t1785 * t7177;
  t7179 = t2325 * t6143;
  t7180 = t7178 * t7179;
  t7181 = 0.2e4 / 0.81e2 * t7180;
  t7183 = 0.1e1 / t3 / t1898;
  t7184 = t544 * t7183;
  t7185 = t7184 * t1788;
  t7186 = t147 * t7185;
  t7187 = t543 * t7186;
  t7188 = 0.2e5 / 0.729e3 * t7187;
  t7189 = t1324 * t1811;
  t7190 = t14 * t1786;
  t7191 = t7190 * t146;
  t7192 = t7191 * t4394;
  t7193 = t7189 * t7192;
  t7194 = t1323 * t7193;
  t7195 = 0.125e3 / 0.243e3 * t7194;
  t7196 = t1823 * t316;
  t7197 = t2774 * t1813;
  t7198 = t154 * t7197;
  t7199 = 0.35e2 / 0.54e2 * t7198;
  t7200 = t1337 * t1811;
  t7201 = t1812 * t6377;
  t7202 = t7200 * t7201;
  t7203 = t1323 * t7202;
  t7204 = 0.25e2 / 0.81e2 * t7203;
  t7205 = t207 * t1784;
  t7206 = t1812 * t1975;
  t7207 = t7205 * t7206;
  t7208 = t4482 * t7207;
  t7209 = 0.5e3 / 0.243e3 * t7208;
  t7210 = t322 * t1814;
  t7211 = 0.5e1 / 0.36e2 * t7210;
  t7212 = t1788 * t316;
  t7213 = t1811 * t7212;
  t7214 = t878 * t7213;
  t7215 = t154 * t7214;
  t7216 = 0.5e1 / 0.36e2 * t7215;
  t7217 = t8 * t1784;
  t7218 = t7217 * t1812;
  t7219 = t878 * t7218;
  t7220 = t154 * t7219;
  t7221 = 0.5e1 / 0.18e2 * t7220;
  t7222 = t62 * t7183;
  t7223 = t7222 * t1812;
  t7224 = t878 * t7223;
  t7225 = t154 * t7224;
  t7226 = 0.25e2 / 0.54e2 * t7225;
  t7227 = t1812 * t326;
  t7228 = t7200 * t7227;
  t7229 = t1323 * t7228;
  t7230 = 0.25e2 / 0.162e3 * t7229;
  t7231 = t2 * t7183;
  t7235 = t7190 * t185;
  t7236 = t1785 * t7235;
  t7238 = t800 * t801 * t167;
  t7241 = t542 * t1975;
  t7245 = t1806 * t180 * t50;
  t7248 = t7183 * t1788;
  t7249 = t806 * t7248;
  t7252 = t7190 * t167;
  t7256 = -0.1e4 / 0.243e3 * t7231 * t1789 * t802 + 0.1e4 / 0.243e3 * t7236 * t7238 - 0.2e4 / 0.81e2 * t1794 * t7241 + 0.1e5 / 0.729e3 * t2535 * t7245 + 0.2e5 / 0.729e3 * t805 * t7249 - 0.2e5 / 0.729e3 * t543 * t1801 * t7252;
  t7257 = t7256 * t146;
  t7258 = t7235 * t187;
  t7259 = t1785 * t7258;
  t7260 = t194 * t167;
  t7261 = t1280 * t7260;
  t7262 = t7259 * t7261;
  t7263 = 0.1e4 / 0.243e3 * t7262;
  t7264 = t1785 * t7190;
  t7265 = t7264 * t50;
  t7266 = t207 * t1355;
  t7267 = t1796 * t7266;
  t7268 = t7265 * t7267;
  t7269 = 0.25e2 / 0.54e2 * t7268;
  t7270 = t7173 + t7176 + t7181 - t7188 - t7195 + t7196 + t7199 + t7204 + t7209 - t7211 - t7216 - t7221 + t7226 + t7230 + t7257 - t7263 + t7269;
  t7271 = t574 * t1339;
  t7272 = t1796 * t7271;
  t7273 = t1795 * t7272;
  t7274 = 0.5e1 / 0.18e2 * t7273;
  t7276 = t1958 * t1784 * t1788;
  t7277 = t7276 * t3853;
  t7278 = t2556 * t7277;
  t7279 = 0.1e5 / 0.729e3 * t7278;
  t7280 = t1334 * t201;
  t7281 = t7280 * t1797;
  t7282 = t1795 * t7281;
  t7283 = 0.35e2 / 0.54e2 * t7282;
  t7284 = t579 * t146;
  t7285 = t1796 * t7284;
  t7286 = t1795 * t7285;
  t7287 = 0.5e1 / 0.18e2 * t7286;
  t7288 = t7231 * t1788;
  t7289 = t7288 * t50;
  t7290 = t7289 * t1798;
  t7291 = 0.25e2 / 0.54e2 * t7290;
  t7292 = t207 * t316;
  t7293 = t1796 * t7292;
  t7294 = t1795 * t7293;
  t7295 = 0.5e1 / 0.36e2 * t7294;
  t7296 = t1784 * t7190;
  t7297 = t7296 * t167;
  t7298 = t1295 * t7297;
  t7299 = t1294 * t7298;
  t7300 = 0.2e5 / 0.729e3 * t7299;
  t7301 = t7231 * t1790;
  t7302 = t7301 * t531;
  t7303 = 0.1e4 / 0.243e3 * t7302;
  t7304 = t1806 * t1339;
  t7305 = t4174 * t7304;
  t7306 = t1336 * t7305;
  t7307 = 0.5e1 / 0.12e2 * t7306;
  t7308 = t7296 * t1355;
  t7309 = t1338 * t7308;
  t7310 = t1336 * t7309;
  t7311 = 0.25e2 / 0.54e2 * t7310;
  t7312 = t188 * t325;
  t7313 = t1794 * t7312;
  t7314 = t445 * t6452;
  t7315 = t7313 * t7314;
  t7316 = 0.25e2 / 0.81e2 * t7315;
  t7317 = t1806 * t553;
  t7318 = t1354 * t7317;
  t7319 = t1323 * t7318;
  t7320 = 0.25e2 / 0.162e3 * t7319;
  t7321 = t4139 * t1807;
  t7322 = t1323 * t7321;
  t7323 = 0.25e2 / 0.81e2 * t7322;
  t7324 = t7248 * t194;
  t7325 = t1354 * t7324;
  t7326 = t1323 * t7325;
  t7327 = 0.125e3 / 0.243e3 * t7326;
  t7328 = t4156 * t1807;
  t7329 = t1323 * t7328;
  t7330 = 0.175e3 / 0.243e3 * t7329;
  t7331 = t1791 * t1981;
  t7332 = 0.1e3 / 0.81e2 * t7331;
  t7333 = t1791 * t1985;
  t7334 = 0.1e3 / 0.81e2 * t7333;
  t7335 = -t7274 - t7279 - t7283 + t7287 - t7291 + t7295 + t7300 + t7303 + t7307 - t7311 - t7316 - t7320 - t7323 + t7327 + t7330 - t7332 - t7334;
  tv3rhotau20 = -t1793 + t1800 + t1805 - t1810 - t1816 + t1824 + t9 * (t7270 + t7335);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t7338 = t4143 * t1845;
  t7339 = 0.5e1 / 0.36e2 * t7338;
  t7340 = t1450 * t1296;
  t7341 = t1843 * t7340;
  t7342 = t1336 * t7341;
  t7343 = 0.5e1 / 0.36e2 * t7342;
  t7344 = t4718 * t453;
  t7345 = t59 * t207;
  t7346 = t1296 * t1445;
  t7347 = t7345 * t7346;
  t7348 = t7344 * t7347;
  t7349 = 0.25e2 / 0.108e3 * t7348;
  t7350 = t55 * t59;
  t7351 = t46 * t7350;
  t7352 = t2379 * t1410;
  t7353 = t7352 * t1340;
  t7354 = t7351 * t7353;
  t7355 = 0.5e1 / 0.12e2 * t7354;
  t7356 = t574 * t1421;
  t7357 = t7356 * t7346;
  t7358 = t7351 * t7357;
  t7359 = 0.25e2 / 0.108e3 * t7358;
  t7360 = t4524 * t1356;
  t7361 = t7351 * t7360;
  t7362 = 0.25e2 / 0.108e3 * t7361;
  t7363 = t1460 * t1322;
  t7364 = t7363 * t1327;
  t7365 = 0.25e2 / 0.81e2 * t7364;
  t7366 = t1839 * t6651;
  t7367 = t1838 * t7366;
  t7368 = 0.25e2 / 0.162e3 * t7367;
  t7370 = t324 * t325 * t202;
  t7371 = t7370 * t1840;
  t7372 = 0.175e3 / 0.243e3 * t7371;
  t7373 = t579 * t1296;
  t7374 = t7373 * t1736;
  t7375 = t1838 * t7374;
  t7376 = 0.25e2 / 0.81e2 * t7375;
  t7377 = t207 * t4262;
  t7378 = t7377 * t1736;
  t7379 = t1838 * t7378;
  t7380 = 0.125e3 / 0.486e3 * t7379;
  t7381 = t1853 * t316;
  t7382 = t439 * t6515;
  t7383 = t1826 * t7382;
  t7384 = 0.5e3 / 0.243e3 * t7383;
  t7385 = t16 * t171;
  t7386 = t440 * t7385;
  t7387 = t439 * t7386;
  t7388 = t4719 * t7387;
  t7389 = 0.5e3 / 0.243e3 * t7388;
  t7390 = t59 * t574;
  t7391 = t7390 * t1340;
  t7392 = t479 * t7391;
  t7393 = 0.5e1 / 0.18e2 * t7392;
  t7394 = t7345 * t1356;
  t7395 = t479 * t7394;
  t7396 = 0.25e2 / 0.108e3 * t7395;
  t7397 = t1410 * t1296;
  t7398 = t7397 * t3853;
  t7399 = t4799 * t7398;
  t7400 = 0.1e5 / 0.729e3 * t7399;
  t7401 = t4310 * t21;
  t7402 = t7401 * t1833;
  t7403 = t1294 * t7402;
  t7404 = 0.2e4 / 0.243e3 * t7403;
  t7406 = t27 * t160 * t16;
  t7407 = t1831 * t7406;
  t7408 = t1294 * t7407;
  t7409 = 0.1e5 / 0.729e3 * t7408;
  t7410 = -t7339 - t7343 + t7349 + t7355 - t7359 - t7362 - t7365 - t7368 + t7372 - t7376 + t7380 + t7381 - t7384 - t7389 - t7393 + t7396 - t7400 + t7404 - t7409;
  t7411 = t325 * params->c;
  t7412 = t1296 * t171;
  t7413 = t7411 * t7412;
  t7416 = t806 * t1297;
  t7421 = t7411 * t1315;
  t7424 = t1833 * t3853;
  t7427 = t39 * t1951;
  t7437 = 0.5e3 / 0.243e3 * t4627 * t7413 - 0.2e4 / 0.81e2 * t4739 * t7416 - 0.5e3 / 0.243e3 * t1403 * t1383 + 0.5e3 / 0.243e3 * t1403 * t7421 + 0.1e5 / 0.729e3 * t5510 * t7424 - 0.1e5 / 0.729e3 * t7427 * t1421 * t7412 + 0.1e5 / 0.729e3 * t543 * t1463 * t7406 - 0.1e5 / 0.729e3 * t7427 * t1410 * t1315;
  t7438 = t7437 * t146;
  t7439 = t147 * t544;
  t7440 = t7439 * t1297;
  t7441 = t5452 * t7440;
  t7442 = 0.2e4 / 0.81e2 * t7441;
  t7443 = t4307 * t1834;
  t7444 = 0.2e4 / 0.243e3 * t7443;
  t7445 = t146 * t6;
  t7446 = t16 * params->c;
  t7447 = t7446 * t180;
  t7448 = t7445 * t7447;
  t7449 = t4524 * t7448;
  t7450 = t1838 * t7449;
  t7451 = 0.25e2 / 0.162e3 * t7450;
  t7452 = t1410 * t209;
  t7453 = t194 * t7452;
  t7454 = t4135 * t7453;
  t7455 = t1838 * t7454;
  t7456 = 0.25e2 / 0.81e2 * t7455;
  t7457 = t1410 * t167;
  t7458 = t194 * t7457;
  t7459 = t4129 * t7458;
  t7460 = t1838 * t7459;
  t7461 = 0.125e3 / 0.486e3 * t7460;
  t7462 = t194 * t1422;
  t7463 = t1839 * t7462;
  t7464 = t1838 * t7463;
  t7465 = 0.125e3 / 0.486e3 * t7464;
  t7466 = t1826 * t1311;
  t7467 = 0.5e3 / 0.243e3 * t7466;
  t7468 = t479 * t1362;
  t7469 = 0.5e1 / 0.36e2 * t7468;
  t7470 = t479 * t1331;
  t7471 = 0.35e2 / 0.54e2 * t7470;
  t7472 = t479 * t1346;
  t7473 = 0.5e1 / 0.18e2 * t7472;
  t7474 = t479 * t1351;
  t7475 = 0.25e2 / 0.108e3 * t7474;
  t7476 = t4150 * t472;
  t7477 = t7476 * t1844;
  t7478 = t1336 * t7477;
  t7479 = 0.35e2 / 0.54e2 * t7478;
  t7480 = t1337 * t1440;
  t7481 = t7480 * t1844;
  t7482 = t1336 * t7481;
  t7483 = 0.5e1 / 0.18e2 * t7482;
  t7484 = t473 * t4262;
  t7485 = t1843 * t7484;
  t7486 = t1336 * t7485;
  t7487 = 0.25e2 / 0.108e3 * t7486;
  t7488 = t448 * t1465;
  t7489 = t4792 * t7488;
  t7490 = 0.5e3 / 0.243e3 * t7489;
  t7492 = t805 * t2325 * t146;
  t7493 = t1463 * t26;
  t7494 = t7493 * t7412;
  t7495 = t7492 * t7494;
  t7496 = 0.1e5 / 0.729e3 * t7495;
  t7497 = t1463 * t27;
  t7498 = t7497 * t1315;
  t7499 = t7492 * t7498;
  t7500 = 0.1e5 / 0.729e3 * t7499;
  t7501 = t1826 * t1302;
  t7502 = 0.1e3 / 0.81e2 * t7501;
  t7503 = t1826 * t1306;
  t7504 = 0.1e3 / 0.81e2 * t7503;
  t7505 = t7438 + t7442 + t7444 + t7451 + t7456 - t7461 - t7465 + t7467 + t7469 - t7471 + t7473 - t7475 + t7479 - t7483 + t7487 + t7490 + t7496 + t7500 - t7502 - t7504;
  tv3rhotau21 = -t1828 + t1830 + t1836 - t1842 - t1847 + t1854 + t9 * (t7410 + t7505);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t7508 = t1861 * t539;
  t7509 = t1858 * t7508;
  t7510 = t7509 * t7179;
  t7511 = 0.2e4 / 0.81e2 * t7510;
  t7513 = t543 * t217 * t1872;
  t7514 = 0.2e4 / 0.243e3 * t7513;
  t7515 = t25 * t1859;
  t7516 = t7515 * t185;
  t7517 = t7516 * t187;
  t7518 = t1858 * t7517;
  t7519 = t194 * t171;
  t7520 = t1280 * t7519;
  t7521 = t7518 * t7520;
  t7522 = 0.1e4 / 0.243e3 * t7521;
  t7523 = t1857 * t7515;
  t7524 = t7523 * t1445;
  t7525 = t1338 * t7524;
  t7526 = t1336 * t7525;
  t7527 = 0.25e2 / 0.54e2 * t7526;
  t7528 = t1867 * t7312;
  t7529 = t7528 * t7314;
  t7530 = 0.25e2 / 0.81e2 * t7529;
  t7531 = t1876 * t553;
  t7532 = t1354 * t7531;
  t7533 = t1323 * t7532;
  t7534 = 0.25e2 / 0.162e3 * t7533;
  t7535 = t4156 * t1877;
  t7536 = t1323 * t7535;
  t7537 = 0.175e3 / 0.243e3 * t7536;
  t7538 = t4139 * t1877;
  t7539 = t1323 * t7538;
  t7540 = 0.25e2 / 0.81e2 * t7539;
  t7541 = t1868 * t7293;
  t7542 = 0.5e1 / 0.36e2 * t7541;
  t7543 = t1864 * t1981;
  t7544 = 0.1e3 / 0.81e2 * t7543;
  t7545 = t1864 * t1985;
  t7546 = 0.1e3 / 0.81e2 * t7545;
  t7547 = t7523 * t171;
  t7548 = t1295 * t7547;
  t7549 = t1294 * t7548;
  t7550 = 0.2e5 / 0.729e3 * t7549;
  t7551 = t1324 * t1881;
  t7552 = t7515 * t146;
  t7553 = t7552 * t4628;
  t7555 = t1323 * t7551 * t7553;
  t7556 = 0.125e3 / 0.243e3 * t7555;
  t7557 = t1337 * t1881;
  t7558 = t1882 * t326;
  t7559 = t7557 * t7558;
  t7560 = t1323 * t7559;
  t7561 = 0.25e2 / 0.162e3 * t7560;
  t7562 = t7511 + t7514 - t7522 - t7527 - t7530 - t7534 + t7537 - t7540 + t7542 - t7544 - t7546 + t7550 - t7556 + t7561;
  t7564 = t543 * t317 * t1872;
  t7565 = 0.2e4 / 0.243e3 * t7564;
  t7566 = t1882 * t6377;
  t7568 = t1323 * t7557 * t7566;
  t7569 = 0.25e2 / 0.81e2 * t7568;
  t7570 = t1868 * t7281;
  t7571 = 0.35e2 / 0.54e2 * t7570;
  t7572 = t1868 * t7285;
  t7573 = 0.5e1 / 0.18e2 * t7572;
  t7574 = t1893 * t316;
  t7575 = t1858 * t7516;
  t7577 = t800 * t801 * t171;
  t7586 = t7515 * t171;
  t7587 = t1871 * t7586;
  t7590 = 0.1e4 / 0.243e3 * t7575 * t7577 - 0.2e4 / 0.81e2 * t1867 * t7241 + 0.1e5 / 0.729e3 * t2535 * t1876 * t180 * t50 - 0.2e5 / 0.729e3 * t543 * t7587;
  t7591 = t7590 * t146;
  t7592 = t1858 * t7515;
  t7593 = t7592 * t50;
  t7594 = t207 * t1445;
  t7595 = t1796 * t7594;
  t7596 = t7593 * t7595;
  t7597 = 0.25e2 / 0.54e2 * t7596;
  t7598 = t1868 * t7272;
  t7599 = 0.5e1 / 0.18e2 * t7598;
  t7600 = t1958 * t1857;
  t7601 = t7600 * t1861;
  t7602 = t7601 * t3853;
  t7603 = t2556 * t7602;
  t7604 = 0.1e5 / 0.729e3 * t7603;
  t7605 = t207 * t1857;
  t7606 = t1882 * t1975;
  t7607 = t7605 * t7606;
  t7608 = t4482 * t7607;
  t7609 = 0.5e3 / 0.243e3 * t7608;
  t7610 = t322 * t1884;
  t7611 = 0.5e1 / 0.36e2 * t7610;
  t7612 = t1861 * t316;
  t7613 = t1881 * t7612;
  t7614 = t878 * t7613;
  t7615 = t154 * t7614;
  t7616 = 0.5e1 / 0.36e2 * t7615;
  t7617 = t2774 * t1883;
  t7618 = t154 * t7617;
  t7619 = 0.35e2 / 0.54e2 * t7618;
  t7620 = t8 * t1857;
  t7621 = t7620 * t1882;
  t7622 = t878 * t7621;
  t7623 = t154 * t7622;
  t7624 = 0.5e1 / 0.18e2 * t7623;
  t7625 = t1876 * t1339;
  t7626 = t4174 * t7625;
  t7627 = t1336 * t7626;
  t7628 = 0.5e1 / 0.12e2 * t7627;
  t7629 = t7565 + t7569 - t7571 + t7573 + t7574 + t7591 + t7597 - t7599 - t7604 + t7609 - t7611 - t7616 + t7619 - t7624 + t7628;
  tv3rhotau22 = -t1866 + t1870 + t1875 - t1880 - t1886 + t1894 + t9 * (t7562 + t7629);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t7632 = t194 * t336;
  t7633 = t1280 * t7632;
  t7634 = t7259 * t7633;
  t7635 = 0.1e4 / 0.243e3 * t7634;
  t7636 = t207 * t382;
  t7637 = t1796 * t7636;
  t7638 = t1795 * t7637;
  t7639 = 0.5e1 / 0.36e2 * t7638;
  t7640 = t1791 * t2637;
  t7641 = 0.1e3 / 0.81e2 * t7640;
  t7642 = t1806 * t1514;
  t7643 = t4174 * t7642;
  t7644 = t1336 * t7643;
  t7645 = 0.5e1 / 0.12e2 * t7644;
  t7646 = t7296 * t1519;
  t7647 = t1338 * t7646;
  t7648 = t1336 * t7647;
  t7649 = 0.25e2 / 0.54e2 * t7648;
  t7650 = t445 * t6879;
  t7651 = t7313 * t7650;
  t7652 = 0.25e2 / 0.81e2 * t7651;
  t7653 = t1806 * t902;
  t7654 = t1354 * t7653;
  t7655 = t1323 * t7654;
  t7656 = 0.25e2 / 0.162e3 * t7655;
  t7657 = t1812 * t6852;
  t7658 = t7200 * t7657;
  t7659 = t1323 * t7658;
  t7660 = 0.25e2 / 0.81e2 * t7659;
  t7661 = t7191 * t5089;
  t7662 = t7189 * t7661;
  t7663 = t1323 * t7662;
  t7664 = 0.125e3 / 0.243e3 * t7663;
  t7665 = t1812 * t390;
  t7666 = t7200 * t7665;
  t7667 = t1323 * t7666;
  t7668 = 0.25e2 / 0.162e3 * t7667;
  t7669 = t7199 - t7635 + t7221 + t7639 - t7641 - t7283 - t7287 + t7645 - t7649 - t7652 - t7656 + t7660 - t7664 + t7668;
  t7670 = t1823 * t382;
  t7672 = t800 * t801 * t336;
  t7675 = t542 * t853;
  t7678 = t1806 * t350;
  t7679 = t7678 * t50;
  t7682 = t7190 * t336;
  t7686 = 0.1e4 / 0.243e3 * t7236 * t7672 - 0.2e4 / 0.81e2 * t1794 * t7675 + 0.1e5 / 0.729e3 * t2535 * t7679 - 0.2e5 / 0.729e3 * t543 * t1801 * t7682;
  t7687 = t7686 * t146;
  t7688 = t1791 * t2616;
  t7689 = 0.1e3 / 0.81e2 * t7688;
  t7690 = t7296 * t336;
  t7691 = t1295 * t7690;
  t7692 = t1294 * t7691;
  t7693 = 0.2e5 / 0.729e3 * t7692;
  t7694 = t2325 * t6262;
  t7695 = t7178 * t7694;
  t7696 = 0.2e4 / 0.81e2 * t7695;
  t7697 = t365 * t1802;
  t7698 = t543 * t7697;
  t7699 = 0.2e4 / 0.243e3 * t7698;
  t7700 = t383 * t1802;
  t7701 = t543 * t7700;
  t7702 = 0.2e4 / 0.243e3 * t7701;
  t7703 = t7276 * t6900;
  t7704 = t2556 * t7703;
  t7705 = 0.1e5 / 0.729e3 * t7704;
  t7706 = t1812 * t853;
  t7707 = t7205 * t7706;
  t7708 = t4482 * t7707;
  t7709 = 0.5e3 / 0.243e3 * t7708;
  t7710 = t388 * t1814;
  t7711 = 0.5e1 / 0.36e2 * t7710;
  t7712 = t1788 * t382;
  t7713 = t1811 * t7712;
  t7714 = t878 * t7713;
  t7715 = t154 * t7714;
  t7716 = 0.5e1 / 0.36e2 * t7715;
  t7717 = t207 * t1519;
  t7718 = t1796 * t7717;
  t7719 = t7265 * t7718;
  t7720 = 0.25e2 / 0.54e2 * t7719;
  t7721 = t574 * t1514;
  t7722 = t1796 * t7721;
  t7723 = t1795 * t7722;
  t7724 = 0.5e1 / 0.18e2 * t7723;
  t7725 = t7670 + t7687 - t7689 + t7693 + t7696 + t7699 + t7702 + t7323 + t7330 - t7705 + t7709 - t7711 - t7716 + t7720 - t7724;
  tv3rhotau23 = -t1793 + t1800 + t1805 - t1810 - t1816 + t1824 + t9 * (t7669 + t7725);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  t7728 = t479 * t1526;
  t7729 = 0.5e1 / 0.36e2 * t7728;
  t7730 = t1608 * t449;
  t7731 = 0.25e2 / 0.108e3 * t7730;
  t7732 = t1839 * t6969;
  t7733 = t1838 * t7732;
  t7734 = 0.125e3 / 0.486e3 * t7733;
  t7735 = t1607 * t189;
  t7736 = t7735 * t442;
  t7737 = 0.5e3 / 0.243e3 * t7736;
  t7738 = t7439 * t1492;
  t7739 = t5452 * t7738;
  t7740 = 0.2e4 / 0.81e2 * t7739;
  t7741 = t4854 * t1834;
  t7742 = 0.2e4 / 0.243e3 * t7741;
  t7743 = t4840 * t21;
  t7744 = t7743 * t1833;
  t7745 = t1294 * t7744;
  t7746 = 0.2e4 / 0.243e3 * t7745;
  t7747 = t1295 * t342;
  t7748 = t7747 * t1833;
  t7749 = t1294 * t7748;
  t7750 = 0.1e5 / 0.729e3 * t7749;
  t7753 = t1296 * t346;
  t7754 = t7411 * t7753;
  t7757 = t806 * t1492;
  t7760 = t7411 * t1504;
  t7763 = t1833 * t6900;
  t7775 = -0.5e3 / 0.243e3 * t5240 * t456 + 0.5e3 / 0.243e3 * t4627 * t7754 - 0.2e4 / 0.81e2 * t4739 * t7757 + 0.5e3 / 0.243e3 * t1403 * t7760 + 0.1e5 / 0.729e3 * t5510 * t7763 + 0.1e5 / 0.729e3 * t543 * t5522 * t1833 - 0.1e5 / 0.729e3 * t7427 * t1421 * t7753 - 0.1e5 / 0.729e3 * t7427 * t1410 * t1504;
  t7776 = t7775 * t146;
  t7777 = t1337 * t1592;
  t7778 = t7777 * t1844;
  t7779 = t1336 * t7778;
  t7780 = 0.25e2 / 0.108e3 * t7779;
  t7781 = t7345 * t1520;
  t7782 = t479 * t7781;
  t7783 = 0.25e2 / 0.108e3 * t7782;
  t7784 = t7397 * t6900;
  t7785 = t4799 * t7784;
  t7786 = 0.1e5 / 0.729e3 * t7785;
  t7787 = t1410 * t336;
  t7788 = t194 * t7787;
  t7789 = t4129 * t7788;
  t7790 = t1838 * t7789;
  t7791 = 0.125e3 / 0.486e3 * t7790;
  t7792 = t194 * t1578;
  t7793 = t1839 * t7792;
  t7794 = t1838 * t7793;
  t7795 = 0.125e3 / 0.486e3 * t7794;
  t7796 = t7446 * t350;
  t7797 = t7445 * t7796;
  t7798 = t4524 * t7797;
  t7799 = t1838 * t7798;
  t7800 = 0.25e2 / 0.162e3 * t7799;
  t7801 = t448 * t1617;
  t7802 = t4792 * t7801;
  t7803 = 0.5e3 / 0.243e3 * t7802;
  t7804 = t4788 * t1845;
  t7805 = 0.5e1 / 0.36e2 * t7804;
  t7806 = t7729 - t7731 + t7734 + t7737 + t7740 + t7742 + t7746 - t7750 + t7372 + t7376 + t7776 + t7780 + t7783 - t7786 - t7791 - t7795 + t7800 + t7803 - t7805;
  t7807 = t1602 * t1296;
  t7808 = t1843 * t7807;
  t7809 = t1336 * t7808;
  t7810 = 0.5e1 / 0.36e2 * t7809;
  t7811 = t1296 * t1597;
  t7812 = t7345 * t7811;
  t7813 = t7344 * t7812;
  t7814 = 0.25e2 / 0.108e3 * t7813;
  t7815 = t7390 * t1515;
  t7816 = t479 * t7815;
  t7817 = 0.5e1 / 0.18e2 * t7816;
  t7818 = t7493 * t7753;
  t7819 = t7492 * t7818;
  t7820 = 0.1e5 / 0.729e3 * t7819;
  t7821 = t7497 * t1504;
  t7822 = t7492 * t7821;
  t7823 = 0.1e5 / 0.729e3 * t7822;
  t7824 = t1826 * t1497;
  t7825 = 0.1e3 / 0.81e2 * t7824;
  t7826 = t1826 * t1501;
  t7827 = 0.1e3 / 0.81e2 * t7826;
  t7828 = t1853 * t382;
  t7829 = t1410 * t360;
  t7830 = t194 * t7829;
  t7831 = t4135 * t7830;
  t7832 = t1838 * t7831;
  t7833 = 0.25e2 / 0.81e2 * t7832;
  t7834 = t7363 * t1511;
  t7835 = 0.25e2 / 0.81e2 * t7834;
  t7836 = t1839 * t6953;
  t7837 = t1838 * t7836;
  t7838 = 0.25e2 / 0.162e3 * t7837;
  t7839 = t7352 * t1515;
  t7840 = t7351 * t7839;
  t7841 = 0.5e1 / 0.12e2 * t7840;
  t7842 = t7356 * t7811;
  t7843 = t7351 * t7842;
  t7844 = 0.25e2 / 0.108e3 * t7843;
  t7845 = t4524 * t1520;
  t7846 = t7351 * t7845;
  t7847 = 0.25e2 / 0.108e3 * t7846;
  t7848 = t16 * t346;
  t7849 = t440 * t7848;
  t7850 = t439 * t7849;
  t7851 = t4719 * t7850;
  t7852 = 0.5e3 / 0.243e3 * t7851;
  t7853 = t439 * t6927;
  t7854 = t1826 * t7853;
  t7855 = 0.5e3 / 0.243e3 * t7854;
  t7856 = -t7810 + t7814 - t7817 + t7820 + t7823 - t7825 - t7827 + t7828 + t7833 - t7835 - t7838 + t7841 - t7844 - t7847 - t7471 - t7473 + t7479 + t7483 - t7852 - t7855;
  tv3rhotau24 = -t1828 + t1830 + t1836 - t1842 - t1847 + t1854 + t9 * (t7806 + t7856);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t7859 = t7552 * t5475;
  t7861 = t1323 * t7551 * t7859;
  t7862 = 0.125e3 / 0.243e3 * t7861;
  t7863 = t1882 * t390;
  t7865 = t1323 * t7557 * t7863;
  t7866 = 0.25e2 / 0.162e3 * t7865;
  t7868 = 0.1e1 / t18 / t3189;
  t7869 = t2 * t7868;
  t7870 = t7869 * t1863;
  t7871 = t7870 * t531;
  t7872 = 0.1e4 / 0.243e3 * t7871;
  t7873 = t1882 * t6852;
  t7875 = t1323 * t7557 * t7873;
  t7876 = 0.25e2 / 0.81e2 * t7875;
  t7877 = t544 * t7868;
  t7878 = t7877 * t1861;
  t7879 = t147 * t7878;
  t7880 = t543 * t7879;
  t7881 = 0.2e5 / 0.729e3 * t7880;
  t7882 = t7509 * t7694;
  t7883 = 0.2e4 / 0.81e2 * t7882;
  t7884 = t1868 * t7637;
  t7885 = 0.5e1 / 0.36e2 * t7884;
  t7886 = t7869 * t1861;
  t7887 = t7886 * t50;
  t7888 = t7887 * t1798;
  t7889 = 0.25e2 / 0.54e2 * t7888;
  t7890 = t1893 * t382;
  t7891 = t1876 * t902;
  t7892 = t1354 * t7891;
  t7893 = t1323 * t7892;
  t7894 = 0.25e2 / 0.162e3 * t7893;
  t7895 = t1876 * t1514;
  t7896 = t4174 * t7895;
  t7897 = t1336 * t7896;
  t7898 = 0.5e1 / 0.12e2 * t7897;
  t7899 = t7523 * t1597;
  t7900 = t1338 * t7899;
  t7901 = t1336 * t7900;
  t7902 = 0.25e2 / 0.54e2 * t7901;
  t7903 = t7528 * t7650;
  t7904 = 0.25e2 / 0.81e2 * t7903;
  t7905 = t7868 * t1861;
  t7906 = t7905 * t194;
  t7907 = t1354 * t7906;
  t7908 = t1323 * t7907;
  t7909 = 0.125e3 / 0.243e3 * t7908;
  t7914 = t800 * t801 * t346;
  t7919 = t1876 * t350;
  t7926 = t7515 * t346;
  t7927 = t1871 * t7926;
  t7930 = -0.1e4 / 0.243e3 * t7869 * t1862 * t802 + 0.1e4 / 0.243e3 * t7575 * t7914 - 0.2e4 / 0.81e2 * t1867 * t7675 + 0.1e5 / 0.729e3 * t2535 * t7919 * t50 + 0.2e5 / 0.729e3 * t805 * t806 * t7905 - 0.2e5 / 0.729e3 * t543 * t7927;
  t7931 = t7930 * t146;
  t7932 = -t7862 + t7866 + t7537 + t7540 + t7872 + t7876 - t7881 + t7883 + t7885 - t7889 + t7890 - t7894 + t7898 - t7902 - t7904 + t7909 + t7931;
  t7933 = t388 * t1884;
  t7934 = 0.5e1 / 0.36e2 * t7933;
  t7935 = t1861 * t382;
  t7936 = t1881 * t7935;
  t7937 = t878 * t7936;
  t7938 = t154 * t7937;
  t7939 = 0.5e1 / 0.36e2 * t7938;
  t7940 = t207 * t1597;
  t7941 = t1796 * t7940;
  t7942 = t7593 * t7941;
  t7943 = 0.25e2 / 0.54e2 * t7942;
  t7944 = t1868 * t7722;
  t7945 = 0.5e1 / 0.18e2 * t7944;
  t7946 = t7601 * t6900;
  t7947 = t2556 * t7946;
  t7948 = 0.1e5 / 0.729e3 * t7947;
  t7949 = t1882 * t853;
  t7950 = t7605 * t7949;
  t7951 = t4482 * t7950;
  t7952 = 0.5e3 / 0.243e3 * t7951;
  t7953 = t62 * t7868;
  t7954 = t7953 * t1882;
  t7955 = t878 * t7954;
  t7956 = t154 * t7955;
  t7957 = 0.25e2 / 0.54e2 * t7956;
  t7958 = t1864 * t2637;
  t7959 = 0.1e3 / 0.81e2 * t7958;
  t7960 = t1864 * t2616;
  t7961 = 0.1e3 / 0.81e2 * t7960;
  t7962 = t7523 * t346;
  t7963 = t1295 * t7962;
  t7964 = t1294 * t7963;
  t7965 = 0.2e5 / 0.729e3 * t7964;
  t7966 = t194 * t346;
  t7967 = t1280 * t7966;
  t7968 = t7518 * t7967;
  t7969 = 0.1e4 / 0.243e3 * t7968;
  t7971 = t543 * t365 * t1872;
  t7972 = 0.2e4 / 0.243e3 * t7971;
  t7974 = t543 * t383 * t1872;
  t7975 = 0.2e4 / 0.243e3 * t7974;
  t7976 = -t7934 - t7939 + t7943 - t7945 - t7948 + t7952 + t7957 - t7959 - t7961 + t7965 - t7571 - t7573 - t7969 + t7972 + t7975 + t7619 + t7624;
  tv3rhotau25 = -t1866 + t1870 + t1875 - t1880 - t1886 + t1894 + t9 * (t7932 + t7976);

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t7979 = 0.1e1 / t6102;
  t7980 = t2 * t7979;
  t7981 = t7980 * t539;
  t7982 = t7981 * t2326;
  t7983 = 0.125e3 / 0.2592e4 * t7982;
  t7984 = t6102 * t31;
  t7985 = 0.1e1 / t7984;
  t7986 = t2 * t7985;
  t7987 = t7986 * t189;
  t7988 = t6110 * t1651;
  t7989 = t7987 * t7988;
  t7990 = 0.25e2 / 0.3456e4 * t7989;
  t7992 = t1990 * t7979 * t50;
  t7993 = t1989 * t7992;
  t7994 = 0.625e3 / 0.23328e5 * t7993;
  t7995 = t7985 * t61;
  t7996 = t7995 * t6349;
  t7997 = t543 * t7996;
  t7998 = 0.125e3 / 0.2592e4 * t7997;
  t7999 = t7980 * t1951;
  t8002 = t1958 * t7979 * t50;
  t8003 = t1957 * t8002;
  t8005 = 0.125e3 / 0.2592e4 * t7999 - 0.625e3 / 0.23328e5 * t8003;
  t8006 = t8005 * t146;
  tv3sigma30 = t9 * (-t7983 + t7990 + t7994 - t7998 + t8006);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t8008 = 0.125e3 / 0.1296e4 * t7982;
  t8009 = 0.25e2 / 0.1728e4 * t7989;
  t8010 = 0.625e3 / 0.11664e5 * t7993;
  t8011 = 0.125e3 / 0.1296e4 * t7997;
  t8014 = 0.125e3 / 0.1296e4 * t7999 - 0.625e3 / 0.11664e5 * t8003;
  t8015 = t8014 * t146;
  tv3sigma31 = t9 * (-t8008 + t8009 + t8010 - t8011 + t8015);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = tv3sigma30;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  t8017 = 0.125e3 / 0.648e3 * t7982;
  t8018 = 0.25e2 / 0.864e3 * t7989;
  t8019 = 0.625e3 / 0.5832e4 * t7993;
  t8020 = 0.125e3 / 0.648e3 * t7997;
  t8023 = 0.125e3 / 0.648e3 * t7999 - 0.625e3 / 0.5832e4 * t8003;
  t8024 = t8023 * t146;
  tv3sigma33 = t9 * (-t8017 + t8018 + t8019 - t8020 + t8024);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = tv3sigma31;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = tv3sigma32;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  t8026 = 0.125e3 / 0.324e3 * t7982;
  t8027 = 0.25e2 / 0.432e3 * t7989;
  t8028 = 0.625e3 / 0.2916e4 * t7993;
  t8029 = 0.125e3 / 0.324e3 * t7997;
  t8032 = 0.125e3 / 0.324e3 * t7999 - 0.625e3 / 0.2916e4 * t8003;
  t8033 = t8032 * t146;
  tv3sigma36 = t9 * (-t8026 + t8027 + t8028 - t8029 + t8033);

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = tv3sigma33;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = tv3sigma34;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = tv3sigma35;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t8035 = t1295 * t1632;
  t8036 = t2325 * t8035;
  t8037 = t4357 * t8036;
  t8038 = 0.125e3 / 0.324e3 * t8037;
  t8039 = t6451 * t1652;
  t8040 = 0.25e2 / 0.648e3 * t8039;
  t8042 = t1632 * t40 * t152;
  t8043 = t4492 * t8042;
  t8044 = t2556 * t8043;
  t8045 = 0.625e3 / 0.2916e4 * t8044;
  t8046 = t1378 * t16;
  t8047 = t409 * t8046;
  t8048 = t6142 * t8047;
  t8049 = 0.125e3 / 0.486e3 * t8048;
  t8050 = t7986 * t185;
  t8051 = t8050 * t1140;
  t8052 = t1702 * t1695;
  t8053 = t8051 * t8052;
  t8054 = 0.25e2 / 0.10368e5 * t8053;
  t8055 = t6116 * t62;
  t8056 = t8055 * t1703;
  t8057 = t6115 * t8056;
  t8058 = 0.5e1 / 0.288e3 * t8057;
  t8060 = t805 * t4480 * t7985;
  t8061 = t447 * t544;
  t8062 = t4483 * t8061;
  t8063 = t8060 * t8062;
  t8064 = 0.125e3 / 0.7776e4 * t8063;
  t8065 = t1141 * t1709;
  t8066 = 0.25e2 / 0.1296e4 * t8065;
  t8067 = t542 * t1645;
  t8068 = t452 * t8067;
  t8070 = t1296 * t1632;
  t8071 = t8070 * t50;
  t8072 = t2535 * t8071;
  t8074 = -0.125e3 / 0.324e3 * t8068 + 0.625e3 / 0.2916e4 * t8072;
  t8075 = t8074 * t146;
  tv3sigma2tau0 = t9 * (t8038 - t8040 - t8045 + t8049 - t8054 - t8058 + t8064 + t8066 + t8075);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t8077 = t4739 * t8036;
  t8078 = 0.125e3 / 0.324e3 * t8077;
  t8079 = t1826 * t1652;
  t8080 = 0.25e2 / 0.648e3 * t8079;
  t8081 = t4596 * t8042;
  t8082 = t2556 * t8081;
  t8083 = 0.625e3 / 0.2916e4 * t8082;
  t8084 = t409 * t7497;
  t8085 = t6142 * t8084;
  t8086 = 0.125e3 / 0.486e3 * t8085;
  t8087 = t1702 * t1736;
  t8088 = t8051 * t8087;
  t8089 = 0.25e2 / 0.10368e5 * t8088;
  t8090 = t8055 * t1740;
  t8091 = t6115 * t8090;
  t8092 = 0.5e1 / 0.288e3 * t8091;
  t8093 = t473 * t544;
  t8094 = t4583 * t8093;
  t8095 = t8060 * t8094;
  t8096 = 0.125e3 / 0.7776e4 * t8095;
  t8097 = t1141 * t1744;
  t8098 = 0.25e2 / 0.1296e4 * t8097;
  t8099 = t478 * t8067;
  t8101 = t1410 * t1632;
  t8103 = t2535 * t8101 * t50;
  t8105 = -0.125e3 / 0.324e3 * t8099 + 0.625e3 / 0.2916e4 * t8103;
  t8106 = t8105 * t146;
  tv3sigma2tau1 = t9 * (t8078 - t8080 - t8083 + t8086 - t8089 - t8092 + t8096 + t8098 + t8106);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  t8108 = 0.125e3 / 0.162e3 * t8037;
  t8109 = 0.25e2 / 0.324e3 * t8039;
  t8110 = 0.625e3 / 0.1458e4 * t8044;
  t8111 = 0.125e3 / 0.243e3 * t8048;
  t8112 = 0.25e2 / 0.5184e4 * t8053;
  t8113 = 0.5e1 / 0.144e3 * t8057;
  t8114 = 0.125e3 / 0.3888e4 * t8063;
  t8115 = 0.25e2 / 0.648e3 * t8065;
  t8118 = -0.125e3 / 0.162e3 * t8068 + 0.625e3 / 0.1458e4 * t8072;
  t8119 = t8118 * t146;
  tv3sigma2tau2 = t9 * (t8108 - t8109 - t8110 + t8111 - t8112 - t8113 + t8114 + t8115 + t8119);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  t8121 = 0.125e3 / 0.162e3 * t8077;
  t8122 = 0.25e2 / 0.324e3 * t8079;
  t8123 = 0.625e3 / 0.1458e4 * t8082;
  t8124 = 0.125e3 / 0.243e3 * t8085;
  t8125 = 0.25e2 / 0.5184e4 * t8088;
  t8126 = 0.5e1 / 0.144e3 * t8091;
  t8127 = 0.125e3 / 0.3888e4 * t8095;
  t8128 = 0.25e2 / 0.648e3 * t8097;
  t8131 = -0.125e3 / 0.162e3 * t8099 + 0.625e3 / 0.1458e4 * t8103;
  t8132 = t8131 * t146;
  tv3sigma2tau3 = t9 * (t8121 - t8122 - t8123 + t8124 - t8125 - t8126 + t8127 + t8128 + t8132);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = tv3sigma2tau0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = tv3sigma2tau1;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  t8134 = 0.125e3 / 0.81e2 * t8037;
  t8135 = 0.25e2 / 0.162e3 * t8039;
  t8136 = 0.625e3 / 0.729e3 * t8044;
  t8137 = 0.25e3 / 0.243e3 * t8048;
  t8138 = 0.25e2 / 0.2592e4 * t8053;
  t8139 = 0.5e1 / 0.72e2 * t8057;
  t8140 = 0.125e3 / 0.1944e4 * t8063;
  t8141 = 0.25e2 / 0.324e3 * t8065;
  t8144 = -0.125e3 / 0.81e2 * t8068 + 0.625e3 / 0.729e3 * t8072;
  t8145 = t8144 * t146;
  tv3sigma2tau6 = t9 * (t8134 - t8135 - t8136 + t8137 - t8138 - t8139 + t8140 + t8141 + t8145);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  t8147 = 0.125e3 / 0.81e2 * t8077;
  t8148 = 0.25e2 / 0.162e3 * t8079;
  t8149 = 0.625e3 / 0.729e3 * t8082;
  t8150 = 0.25e3 / 0.243e3 * t8085;
  t8151 = 0.25e2 / 0.2592e4 * t8088;
  t8152 = 0.5e1 / 0.72e2 * t8091;
  t8153 = 0.125e3 / 0.1944e4 * t8095;
  t8154 = 0.25e2 / 0.324e3 * t8097;
  t8157 = -0.125e3 / 0.81e2 * t8099 + 0.625e3 / 0.729e3 * t8103;
  t8158 = t8157 * t146;
  tv3sigma2tau7 = t9 * (t8147 - t8148 - t8149 + t8150 - t8151 - t8152 + t8153 + t8154 + t8158);

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = tv3sigma2tau2;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = tv3sigma2tau3;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = tv3sigma2tau4;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = tv3sigma2tau5;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t8160 = t1295 * t35;
  t8161 = t2325 * t8160;
  t8162 = t7178 * t8161;
  t8163 = 0.25e3 / 0.81e2 * t8162;
  t8164 = t1794 * t189;
  t8165 = t8164 * t3574;
  t8166 = 0.25e2 / 0.162e3 * t8165;
  t8167 = t1321 * t1639;
  t8168 = t207 * t194;
  t8169 = t8167 * t8168;
  t8170 = t8164 * t8169;
  t8171 = 0.25e2 / 0.648e3 * t8170;
  t8172 = t1788 * t40;
  t8173 = t8172 * t44;
  t8174 = t1785 * t8173;
  t8175 = t1687 * t1797;
  t8176 = t8174 * t8175;
  t8177 = 0.5e1 / 0.36e2 * t8176;
  t8179 = t35 * t40 * t152;
  t8180 = t7276 * t8179;
  t8181 = t2556 * t8180;
  t8182 = 0.125e4 / 0.729e3 * t8181;
  t8183 = t409 * t1802;
  t8184 = t3555 * t8183;
  t8185 = 0.25e3 / 0.243e3 * t8184;
  t8186 = t1812 * t544;
  t8187 = t7205 * t8186;
  t8188 = t6442 * t8187;
  t8189 = 0.125e3 / 0.486e3 * t8188;
  t8190 = t1141 * t1808;
  t8191 = 0.25e2 / 0.162e3 * t8190;
  t8192 = t1806 * t146;
  t8193 = t6434 * t8192;
  t8194 = t1700 * t8193;
  t8195 = 0.5e1 / 0.288e3 * t8194;
  t8196 = t6375 * t62;
  t8197 = t8196 * t1807;
  t8198 = t1323 * t8197;
  t8199 = 0.25e2 / 0.1296e4 * t8198;
  t8200 = t1338 * t8192;
  t8201 = t154 * t8200;
  t8202 = 0.5e1 / 0.36e2 * t8201;
  t8203 = t542 * t1120;
  t8204 = t1794 * t8203;
  t8206 = t1806 * t35;
  t8207 = t8206 * t50;
  t8208 = t2535 * t8207;
  t8210 = 0.25e3 / 0.81e2 * t8204 - 0.125e4 / 0.729e3 * t8208;
  t8211 = t8210 * t146;
  t8212 = -t8163 + t8166 + t8171 + t8177 + t8182 - t8185 - t8189 - t8191 + t8195 - t8199 - t8202 + t8211;
  tv3sigmatau20 = t9 * t8212;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t8213 = t7439 * t1691;
  t8214 = t5452 * t8213;
  t8215 = 0.25e3 / 0.81e2 * t8214;
  t8216 = t478 * t7312;
  t8217 = t8216 * t1696;
  t8218 = 0.25e2 / 0.162e3 * t8217;
  t8219 = t30 * t1639;
  t8220 = t8219 * t207;
  t8221 = t8220 * t1695;
  t8222 = t8216 * t8221;
  t8223 = 0.25e2 / 0.648e3 * t8222;
  t8224 = t1151 * t448;
  t8225 = t6552 * t8224;
  t8226 = 0.5e1 / 0.36e2 * t8225;
  t8227 = t7397 * t8179;
  t8228 = t4799 * t8227;
  t8229 = 0.125e4 / 0.729e3 * t8228;
  t8230 = t6349 * t7397;
  t8231 = t6348 * t8230;
  t8232 = 0.25e3 / 0.243e3 * t8231;
  t8234 = t805 * t4480 * t1707;
  t8235 = t8234 * t8230;
  t8236 = 0.125e3 / 0.486e3 * t8235;
  t8237 = t6503 * t1840;
  t8238 = 0.25e2 / 0.162e3 * t8237;
  t8239 = t1699 * t1335;
  t8240 = t574 * t21;
  t8241 = t8240 * t1844;
  t8242 = t8239 * t8241;
  t8243 = 0.5e1 / 0.288e3 * t8242;
  t8245 = t324 * t325 * t8219;
  t8246 = t4524 * t1695;
  t8247 = t8245 * t8246;
  t8248 = 0.25e2 / 0.1296e4 * t8247;
  t8249 = t152 * t408;
  t8250 = t151 * t8249;
  t8251 = t8250 * t8241;
  t8252 = 0.5e1 / 0.36e2 * t8251;
  t8253 = t806 * t1691;
  t8254 = t4739 * t8253;
  t8256 = t1833 * t8179;
  t8257 = t5510 * t8256;
  t8259 = 0.25e3 / 0.81e2 * t8254 - 0.125e4 / 0.729e3 * t8257;
  t8260 = t8259 * t146;
  t8261 = -t8215 + t8218 + t8223 + t8226 + t8229 - t8232 - t8236 - t8238 + t8243 - t8248 - t8252 + t8260;
  tv3sigmatau21 = t9 * t8261;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  t8262 = t7509 * t8161;
  t8263 = 0.25e3 / 0.81e2 * t8262;
  t8264 = t1867 * t189;
  t8265 = t8264 * t3574;
  t8266 = 0.25e2 / 0.162e3 * t8265;
  t8267 = t8264 * t8169;
  t8268 = 0.25e2 / 0.648e3 * t8267;
  t8269 = t1861 * t40;
  t8270 = t8269 * t44;
  t8271 = t1858 * t8270;
  t8272 = t8271 * t8175;
  t8273 = 0.5e1 / 0.36e2 * t8272;
  t8274 = t7601 * t8179;
  t8275 = t2556 * t8274;
  t8276 = 0.125e4 / 0.729e3 * t8275;
  t8277 = t409 * t1872;
  t8278 = t3555 * t8277;
  t8279 = 0.25e3 / 0.243e3 * t8278;
  t8280 = t1882 * t544;
  t8281 = t7605 * t8280;
  t8282 = t6442 * t8281;
  t8283 = 0.125e3 / 0.486e3 * t8282;
  t8284 = t1141 * t1878;
  t8285 = 0.25e2 / 0.162e3 * t8284;
  t8286 = t1876 * t146;
  t8287 = t6434 * t8286;
  t8288 = t1700 * t8287;
  t8289 = 0.5e1 / 0.288e3 * t8288;
  t8290 = t8196 * t1877;
  t8291 = t1323 * t8290;
  t8292 = 0.25e2 / 0.1296e4 * t8291;
  t8293 = t1338 * t8286;
  t8294 = t154 * t8293;
  t8295 = 0.5e1 / 0.36e2 * t8294;
  t8296 = t1867 * t8203;
  t8298 = t1876 * t35;
  t8300 = t2535 * t8298 * t50;
  t8302 = 0.25e3 / 0.81e2 * t8296 - 0.125e4 / 0.729e3 * t8300;
  t8303 = t8302 * t146;
  t8304 = -t8263 + t8266 + t8268 + t8273 + t8276 - t8279 - t8283 - t8285 + t8289 - t8292 - t8295 + t8303;
  tv3sigmatau22 = t9 * t8304;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  t8305 = 0.5e3 / 0.81e2 * t8162;
  t8306 = 0.25e2 / 0.81e2 * t8165;
  t8307 = 0.25e2 / 0.324e3 * t8170;
  t8308 = 0.5e1 / 0.18e2 * t8176;
  t8309 = 0.25e4 / 0.729e3 * t8181;
  t8310 = 0.5e3 / 0.243e3 * t8184;
  t8311 = 0.125e3 / 0.243e3 * t8188;
  t8312 = 0.25e2 / 0.81e2 * t8190;
  t8313 = 0.5e1 / 0.144e3 * t8194;
  t8314 = 0.25e2 / 0.648e3 * t8198;
  t8315 = 0.5e1 / 0.18e2 * t8201;
  t8318 = 0.5e3 / 0.81e2 * t8204 - 0.25e4 / 0.729e3 * t8208;
  t8319 = t8318 * t146;
  t8320 = -t8305 + t8306 + t8307 + t8308 + t8309 - t8310 - t8311 - t8312 + t8313 - t8314 - t8315 + t8319;
  tv3sigmatau23 = t9 * t8320;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  t8321 = 0.5e3 / 0.81e2 * t8214;
  t8322 = 0.25e2 / 0.81e2 * t8217;
  t8323 = 0.25e2 / 0.324e3 * t8222;
  t8324 = 0.5e1 / 0.18e2 * t8225;
  t8325 = 0.25e4 / 0.729e3 * t8228;
  t8326 = 0.5e3 / 0.243e3 * t8231;
  t8327 = 0.125e3 / 0.243e3 * t8235;
  t8328 = 0.25e2 / 0.81e2 * t8237;
  t8329 = 0.5e1 / 0.144e3 * t8242;
  t8330 = 0.25e2 / 0.648e3 * t8247;
  t8331 = 0.5e1 / 0.18e2 * t8251;
  t8334 = 0.5e3 / 0.81e2 * t8254 - 0.25e4 / 0.729e3 * t8257;
  t8335 = t8334 * t146;
  t8336 = -t8321 + t8322 + t8323 + t8324 + t8325 - t8326 - t8327 - t8328 + t8329 - t8330 - t8331 + t8335;
  tv3sigmatau24 = t9 * t8336;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  t8337 = 0.5e3 / 0.81e2 * t8262;
  t8338 = 0.25e2 / 0.81e2 * t8265;
  t8339 = 0.25e2 / 0.324e3 * t8267;
  t8340 = 0.5e1 / 0.18e2 * t8272;
  t8341 = 0.25e4 / 0.729e3 * t8275;
  t8342 = 0.5e3 / 0.243e3 * t8278;
  t8343 = 0.125e3 / 0.243e3 * t8282;
  t8344 = 0.25e2 / 0.81e2 * t8284;
  t8345 = 0.5e1 / 0.144e3 * t8288;
  t8346 = 0.25e2 / 0.648e3 * t8291;
  t8347 = 0.5e1 / 0.18e2 * t8294;
  t8350 = 0.5e3 / 0.81e2 * t8296 - 0.25e4 / 0.729e3 * t8300;
  t8351 = t8350 * t146;
  t8352 = -t8337 + t8338 + t8339 + t8340 + t8341 - t8342 - t8343 - t8344 + t8345 - t8346 - t8347 + t8351;
  tv3sigmatau25 = t9 * t8352;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = tv3sigmatau20;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = tv3sigmatau21;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = tv3sigmatau22;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t8353 = t1898 * rho[0];
  t8354 = 0.1e1 / t8353;
  t8355 = t2 * t8354;
  t8356 = t1786 * t1786;
  t8357 = t8356 * t13;
  t8358 = t8357 * t539;
  t8359 = t8355 * t8358;
  t8361 = 0.2e4 / 0.81e2 * t8359 * t2326;
  t8362 = t8355 * t8357;
  t8363 = t8362 * t189;
  t8364 = t1321 * t58;
  t8365 = t8364 * t8168;
  t8367 = 0.25e2 / 0.54e2 * t8363 * t8365;
  t8368 = t8362 * t50;
  t8369 = t574 * t146;
  t8370 = t1796 * t8369;
  t8372 = 0.5e1 / 0.12e2 * t8368 * t8370;
  t8373 = t1958 * t8354;
  t8375 = t8373 * t8357 * t50;
  t8377 = 0.1e5 / 0.729e3 * t2556 * t8375;
  t8378 = t207 * t8354;
  t8379 = t8357 * t146;
  t8380 = t8379 * t544;
  t8381 = t8378 * t8380;
  t8383 = 0.25e3 / 0.81e2 * t4482 * t8381;
  t8384 = t8354 * t8357;
  t8385 = t8384 * t194;
  t8386 = t1338 * t8385;
  t8388 = 0.25e2 / 0.54e2 * t1323 * t8386;
  t8389 = t62 * t8354;
  t8390 = t8389 * t8379;
  t8391 = t2795 * t8390;
  t8393 = 0.5e1 / 0.12e2 * t154 * t8391;
  t8399 = -0.2e4 / 0.81e2 * t8362 * t1951 + 0.1e5 / 0.729e3 * t2535 * t8384 * t50;
  t8400 = t8399 * t146;
  tv3tau30 = t9 * (t8361 - t8367 - t8372 - t8377 + t8383 + t8388 + t8393 + t8400);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t8403 = 0.2e4 / 0.81e2 * t5452 * t1803;
  t8404 = t7345 * t1807;
  t8406 = 0.25e2 / 0.54e2 * t8216 * t8404;
  t8408 = 0.5e1 / 0.12e2 * t479 * t1814;
  t8410 = t8172 * t152;
  t8411 = t1410 * t1784 * t8410;
  t8413 = 0.1e5 / 0.729e3 * t4799 * t8411;
  t8414 = t1811 * t1788;
  t8415 = t1295 * t1410;
  t8416 = t8414 * t8415;
  t8418 = 0.25e3 / 0.81e2 * t4792 * t8416;
  t8419 = t574 * t1806;
  t8420 = t8419 * t1736;
  t8422 = 0.25e2 / 0.54e2 * t1838 * t8420;
  t8423 = t473 * t1806;
  t8424 = t5385 * t8423;
  t8426 = 0.5e1 / 0.12e2 * t1336 * t8424;
  t8429 = t27 * t1784;
  t8430 = t8429 * t1788;
  t8431 = t8430 * t50;
  t8434 = -0.2e4 / 0.81e2 * t4739 * t1820 + 0.1e5 / 0.729e3 * t5510 * t8431;
  t8435 = t8434 * t146;
  tv3tau31 = t9 * (t8403 - t8406 - t8408 - t8413 + t8418 + t8422 + t8426 + t8435);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  t8437 = t7508 * t541;
  t8438 = t1858 * t8437;
  t8439 = t147 * t8046;
  t8441 = 0.2e4 / 0.81e2 * t8438 * t8439;
  t8442 = t7345 * t1695;
  t8444 = 0.25e2 / 0.54e2 * t7528 * t8442;
  t8445 = t1867 * t453;
  t8446 = t878 * t448;
  t8448 = 0.5e1 / 0.12e2 * t8445 * t8446;
  t8450 = t432 * t152;
  t8451 = t1876 * t6 * t8450;
  t8453 = 0.1e5 / 0.729e3 * t4799 * t8451;
  t8454 = t1295 * t1876;
  t8455 = t4793 * t8454;
  t8457 = 0.25e3 / 0.81e2 * t4792 * t8455;
  t8458 = t574 * t1876;
  t8459 = t8458 * t1695;
  t8461 = 0.25e2 / 0.54e2 * t1838 * t8459;
  t8462 = t4173 * t1881;
  t8463 = t1882 * t1296;
  t8464 = t8462 * t8463;
  t8466 = 0.5e1 / 0.12e2 * t1336 * t8464;
  t8467 = t806 * t1296;
  t8471 = t805 * t5111 * t1857;
  t8472 = t1861 * t6;
  t8473 = t8472 * t16;
  t8474 = t8473 * t50;
  t8477 = -0.2e4 / 0.81e2 * t7509 * t8467 + 0.1e5 / 0.729e3 * t8471 * t8474;
  t8478 = t8477 * t146;
  tv3tau32 = t9 * (t8441 - t8444 - t8448 - t8453 + t8457 + t8461 + t8466 + t8478);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t8480 = t3189 * rho[1];
  t8481 = 0.1e1 / t8480;
  t8482 = t2 * t8481;
  t8483 = t1859 * t1859;
  t8484 = t8483 * t24;
  t8485 = t8484 * t539;
  t8486 = t8482 * t8485;
  t8488 = 0.2e4 / 0.81e2 * t8486 * t2326;
  t8489 = t8482 * t8484;
  t8490 = t8489 * t189;
  t8492 = 0.25e2 / 0.54e2 * t8490 * t8365;
  t8493 = t8489 * t50;
  t8495 = 0.5e1 / 0.12e2 * t8493 * t8370;
  t8496 = t1958 * t8481;
  t8498 = t8496 * t8484 * t50;
  t8500 = 0.1e5 / 0.729e3 * t2556 * t8498;
  t8501 = t207 * t8481;
  t8502 = t8484 * t146;
  t8503 = t8502 * t544;
  t8504 = t8501 * t8503;
  t8506 = 0.25e3 / 0.81e2 * t4482 * t8504;
  t8507 = t8481 * t8484;
  t8508 = t8507 * t194;
  t8509 = t1338 * t8508;
  t8511 = 0.25e2 / 0.54e2 * t1323 * t8509;
  t8512 = t62 * t8481;
  t8513 = t8512 * t8502;
  t8514 = t2795 * t8513;
  t8516 = 0.5e1 / 0.12e2 * t154 * t8514;
  t8519 = t8507 * t50;
  t8522 = -0.2e4 / 0.81e2 * t8489 * t1951 + 0.1e5 / 0.729e3 * t2535 * t8519;
  t8523 = t8522 * t146;
  tv3tau33 = t9 * (t8488 - t8492 - t8495 - t8500 + t8506 + t8511 + t8516 + t8523);

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t8527 = t253 * t2007;
  t8529 = t253 * t2044;
  t8531 = t257 * t2044;
  t8533 = t607 * t2058;
  t8536 = 0.1e1 / t32 / t56;
  t8540 = 0.18989649058080861537e-2 * t306 * t232 * t8536 * t138;
  t8544 = 0.46785788981077169656e1 * t311 * t736 * t2115 * t298;
  t8549 = 0.69263436422725855036e2 * t311 * t599 * t2115 * t603 * t296;
  t8551 = t2124 * t634;
  t8554 = 0.61524113149298439947e4 * t311 * t2121 * t600 * t8551;
  t8555 = t634 * t634;
  t8559 = 0.51947577317044391277e2 * t311 * t599 * t8555 * t603;
  t8563 = 0.35089341735807877242e1 * t311 * t736 * t8555 * t297;
  t8567 = 0.68734380377411894876e1 * t685 * t222 * t2253 * t2255;
  t8571 = 0.22161481481481481481e0 * t685 * t2077 * t228 * t249;
  t8572 = 0.48e2 * t8527 + 0.16e2 * t8529 - 0.16e2 * t8531 - 0.20779030926817756511e3 * t8533 + t8540 + t8544 - t8549 - t8554 - t8559 + t8563 + t8567 - t8571;
  t8575 = 0.71233333333333333332e-1 * t685 * t718 * t2267;
  t8579 = 0.3684616320282908548e2 * t685 * t222 * t2186 * t2190;
  t8580 = t607 * t2083;
  t8582 = t783 * t2079;
  t8585 = t2043 * t67 * t308;
  t8589 = 0.21053605041484726346e2 * t311 * t601 * t741;
  t8590 = t2086 * t766;
  t8594 = 0.4274e0 * t685 * t2072 * t2004;
  t8598 = 0.28493333333333333333e0 * t685 * t618 * t723 * t725;
  t8599 = t600 * t600;
  t8603 = 0.14035736694323150897e2 * t311 * t2047 * t8599 * t297;
  t8604 = t607 * t2050;
  t8606 = t253 * t2272;
  t8607 = 0.16e2 * t8606;
  t8611 = 0.62337092780453269531e3 * t311 * t2047 * t634 * t745;
  t8612 = -t8575 - t8579 + 0.14035736694323150897e2 * t8580 - 0.22787578869697033845e-2 * t8582 - 0.73245789224026180216e-3 * t8585 - t8589 + 0.14649157844805236043e-2 * t8590 - t8594 - t8598 + t8603 + 0.4155806185363551302e3 * t8604 + t8607 + t8611;
  t8616 = 0.14246666666666666666e0 * t685 * t2065 * t670;
  t8620 = 0.22911460125803964958e1 * t685 * t618 * t674 * t679;
  t8621 = t253 * t2137;
  t8623 = t2283 * t302;
  t8624 = 0.96e3 * t8623;
  t8626 = 0.48e3 * t2280 * t302;
  t8631 = 0.34367190188705947438e1 * t236 * t674 * t669 * t678 * t247;
  t8635 = 0.4274e0 * t236 * t723 * t669 * t249;
  t8639 = 0.6233709278045326953e3 * t311 * t2121 * t8599 * t603;
  t8646 = 0.1e1 / t78 / t10 * t1632 * t685 / 0.48e2;
  t8648 = t2092 * t256;
  t8650 = t613 * t58;
  t8651 = t612 * t8650;
  t8653 = t232 * t8536;
  t8654 = t231 * t8653;
  t8656 = t72 * t8536;
  t8657 = t70 * t8656;
  t8659 = pow(t75, -0.25e1);
  t8662 = t8659 * t68 * t1632 * t685;
  t8664 = t2105 * t256;
  t8666 = t626 * t8650;
  t8668 = t239 * t8653;
  t8671 = t85 * t71 * t58;
  t8673 = -0.28769444444444444444e1 * t8646 + 0.27618666666666666667e2 * t8648 - 0.10229135802469135803e2 * t8651 + 0.89504938271604938273e1 * t8654 + 0.31310740740740740741e1 * t8657 + 0.366775e-1 * t8662 - 0.58684e0 * t8664 + 0.65204444444444444445e0 * t8666 + 0.5705388888888888889e0 * t8668 + 0.13490888888888888889e1 * t8671;
  t8677 = 0.5848223622634646207e0 * t311 * t290 * t8673 * t297;
  t8678 = t607 * t2117;
  t8680 = t676 * t676;
  t8683 = 0.57895126195293126241e3 * t2187 * t8680 * t678;
  t8684 = t669 * t669;
  t8687 = 0.6e1 * t724 * t8684 * t248;
  t8688 = t8616 + t8620 + 0.48e2 * t8621 + t8624 - t8626 - t8631 + t8635 - t8639 - t8677 - 0.23392894490538584828e1 * t8678 + t8683 - t8687;
  t8689 = t2283 * t269;
  t8693 = 0.24e2 * t2254 * t8680 * t248;
  t8694 = t2276 * t302;
  t8695 = 0.576e3 * t8694;
  t8697 = t252 * t2279 * t142;
  t8698 = 0.192e4 * t8697;
  t8701 = 0.84e3 * t97 * t7979 * t142;
  t8702 = t2280 * t269;
  t8704 = t2276 * t269;
  t8707 = t62 * t769 * t142;
  t8708 = 0.144e4 * t8707;
  t8709 = t776 * t753;
  t8712 = 0.12e3 * t770 * t749;
  t8713 = t773 * t749;
  t8714 = 0.72e2 * t8713;
  t8718 = 0.24e2 * t98 * t110 * t113 * t141;
  t8719 = t2128 * t787;
  t8721 = 0.96e3 * t8689 - t8693 - t8695 - t8698 + t8701 - 0.48e3 * t8702 - 0.576e3 * t8704 + t8708 - 0.384e3 * t8709 + t8712 + t8714 + t8718 + 0.70178683471615754484e1 * t8719;
  t8724 = t607 * t2287;
  t8726 = t776 * t749;
  t8727 = 0.192e3 * t8726;
  t8728 = t773 * t753;
  t8730 = t773 * t751;
  t8732 = t770 * t751;
  t8734 = t776 * t751;
  t8737 = t99 * t268 * t2271;
  t8744 = 0.62071215503128080361e4 * t77 / t673 / t722 * t8680 * t2189;
  t8758 = 0.1e1 * t229 * (-0.21099166666666666667e1 * t8646 + 0.202552e2 * t8648 - 0.75019259259259259258e1 * t8651 + 0.6564185185185185185e1 * t8654 + 0.31003950617283950618e1 * t8657 + 0.68258333333333333335e-1 * t8662 - 0.10921333333333333333e1 * t8664 + 0.12134814814814814815e1 * t8666 + 0.10617962962962962963e1 * t8668 + 0.13388493827160493828e1 * t8671) * t248;
  t8759 = t2128 * t604;
  t8761 = t598 * t598;
  t8762 = 0.1e1 / t8761;
  t8764 = t602 * t602;
  t8765 = 0.1e1 / t8764;
  t8768 = 0.91082604192152556044e5 * t311 * t8762 * t8599 * t8765;
  t8770 = t2043 * t129 * t313;
  t8772 = -0.14035736694323150897e2 * t8724 - t8727 + 0.144e3 * t8728 + 0.72e2 * t8730 + 0.12e3 * t8732 - 0.192e3 * t8734 + 0.4e1 * t8737 - t8744 + t8758 - 0.10389515463408878255e3 * t8759 - t8768 - 0.23392894490538584828e1 * t8770;
  t8773 = t2128 * t636;
  t8775 = t607 * t2125;
  t8778 = 0.1e1 / t598 / t735;
  t8782 = 0.12304822629859687989e5 * t311 * t8778 * t8599 * t2124;
  t8786 = 0.64327917994770140268e2 * t675 * t2266 * t678 * t247;
  t8789 = 0.8e1 * t724 * t2267 * t247;
  t8793 = 0.3103560775156404018e4 * t2187 * t669 * t2189 * t676;
  t8795 = t99 * t660 * t748;
  t8797 = t12 * t12;
  t8799 = 0.1e1 / t639 / t8797;
  t8800 = t641 * t641;
  t8806 = t644 * t644;
  t8811 = t8 * t256;
  t8812 = -t98 + t8811;
  t8813 = 0.24e2 * t8812;
  t8817 = my_piecewise3(t100, 0, 0.4e2 / 0.81e2 * t8799 * t8800 - 0.16e2 / 0.9e1 * t2017 * t641 * t644 + 0.4e1 / 0.3e1 * t640 * t8806 + 0.16e2 / 0.9e1 * t2021 * t2024 + 0.4e1 / 0.3e1 * t103 * t8813);
  t8818 = t23 * t23;
  t8820 = 0.1e1 / t649 / t8818;
  t8821 = t651 * t651;
  t8827 = t654 * t654;
  t8836 = my_piecewise3(t106, 0, 0.4e2 / 0.81e2 * t8820 * t8821 - 0.16e2 / 0.9e1 * t2030 * t651 * t654 + 0.4e1 / 0.3e1 * t650 * t8827 + 0.16e2 / 0.9e1 * t2034 * t2037 - 0.4e1 / 0.3e1 * t107 * t8813);
  t8838 = (t8817 + t8836) * t113;
  t8843 = 0.36e2 * t675 * t725 * t669;
  t8846 = 0.21687162600603479684e-1 * t779 * t223 * t2117;
  t8849 = 0.38025319932552508021e2 * t779 * t223 * t2125;
  t8852 = 0.1301229756036208781e0 * t779 * t223 * t2287;
  t8853 = t2310 * t2304;
  t8855 = -0.35089341735807877242e1 * t8773 - 0.4101607543286562663e4 * t8775 + t8782 + t8786 - t8789 + t8793 + 0.6e1 * t8795 + t99 * t8838 * t141 + t8843 + t8846 + t8849 + t8852 - 0.86748650402413918736e-1 * t8853;
  t8859 = 0.86748650402413918736e-1 * t779 * t622 * t787;
  t8862 = 0.38527786510141256862e1 * t779 * t223 * t2050;
  t8863 = t2310 * t2301;
  t8867 = 0.43374325201206959368e-1 * t779 * t622 * t636;
  t8870 = 0.12842595503380418954e1 * t779 * t622 * t604;
  t8872 = t660 * t70 * t780;
  t8874 = t2310 * t2313;
  t8876 = t2310 * t2307;
  t8880 = 0.67471172535210825684e-1 * t779 * t2101 * t313;
  t8881 = t114 * t685;
  t8884 = 0.19263893255070628432e1 * t8881 * t2147 * t2174;
  t8887 = 0.1301229756036208781e0 * t8881 * t2151 * t2242;
  t8888 = t8811 * t142;
  t8889 = 0.384e3 * t8888;
  t8890 = t8859 - t8862 - 0.1301229756036208781e0 * t8863 - t8867 - t8870 + 0.65061487801810439052e-1 * t8872 + 0.65061487801810439052e-1 * t8874 + 0.19263893255070628431e1 * t8876 + t8880 + t8884 - t8887 - t8889;
  t8891 = t770 * t753;
  t8894 = 0.16e2 * t257 * t2272;
  t8897 = 0.11483599538271604938e-1 * t70 * t8656 * t94;
  t8900 = 0.57895126195293126241e3 * t2254 * t2177 * t676;
  t8955 = 0.1e1 * t276 * (-0.39219166666666666667e1 * t8646 + 0.376504e2 * t8648 - 0.13944592592592592593e2 * t8651 + 0.12201518518518518519e2 * t8654 + 0.5356037037037037037e1 * t8657 + 0.14025833333333333333e0 * t8662 - 0.22441333333333333332e1 * t8664 + 0.24934814814814814815e1 * t8666 + 0.21817962962962962963e1 * t8668 + 0.16979925925925925926e1 * t8671) * t282 + 0.5848223622634646207e0 * t291 * t8673 * t297 + 0.91082604192152556044e5 * t129 * t8762 * t8599 * t8765 - 0.67471172535210825684e-1 * t685 * t2077 * t290 * t298 - 0.86748650402413918736e-1 * t685 * t618 * t736 * t738 + 0.38527786510141256862e1 * t685 * t222 * t2047 * t2246 + 0.44060335298551228073e1 * t685 * t618 * t708 * t712 - t8567 + t8571 - 0.21309037037037037036e0 * t685 * t2077 * t275 * t283 + t8575 + t8579 + t8594 - 0.41096e0 * t685 * t2166 * t2171 - 0.1301229756036208781e0 * t685 * t2147 * t2205 + 0.13218100589565368422e2 * t685 * t222 * t2221 * t2223 - 0.68493333333333333332e-1 * t685 * t686 * t2202;
  t8981 = t693 * t693;
  t8988 = t703 * t703;
  t9001 = -0.14171548179536397724e3 * t685 * t222 * t2213 * t2217 - 0.38025319932552508021e2 * t685 * t222 * t2121 * t2209 + 0.43374325201206959368e-1 * t685 * t2140 * t741 + 0.12842595503380418954e1 * t685 * t618 * t599 * t745 - 0.21687162600603479684e-1 * t685 * t731 * t2249 + 0.13698666666666666666e0 * t685 * t2159 * t704 - 0.27397333333333333333e0 * t685 * t618 * t691 * t694 + t8598 + 0.11579025239058625248e4 * t2214 * t8981 * t711 - t8616 - t8620 - 0.35089341735807877242e1 * t737 * t8555 * t297 + 0.96491876992155210402e2 * t709 * t8988 * t711 - 0.6609050294782684211e1 * t236 * t708 * t703 * t711 * t281 + 0.41096e0 * t236 * t691 * t281 * t704 + t8631 - t8635;
  t9033 = -0.19263893255070628431e1 * t236 * t2058 + 0.1301229756036208781e0 * t236 * t2083 - 0.14035736694323150897e2 * t2245 * t8599 * t297 - t8683 + t8687 + 0.6233709278045326953e3 * t2208 * t8599 * t603 + 0.51947577317044391277e2 * t744 * t8555 * t603 + t8693 - 0.24828486201251232145e5 * t116 / t707 / t690 * t8981 * t2216 - 0.12304822629859687989e5 * t129 * t8778 * t8599 * t2124 + t8744 - t8758 - t8786 + t8789 - t8793 + 0.12865583598954028054e3 * t709 * t2201 * t711 * t281 + 0.21053605041484726346e2 * t744 * t738 * t634;
  t9072 = t707 * t707;
  t9075 = t710 * t710;
  t9082 = 0.48245938496077605201e2 * t675 * t8684 * t678;
  t9083 = t673 * t673;
  t9086 = t677 * t677;
  t9090 = 0.24955700379505800916e5 * t77 / t9083 * t8680 / t9086;
  t9091 = -0.24e2 * t2222 * t8981 * t282 - 0.6e1 * t692 * t8988 * t282 + 0.69263436422725855036e2 * t744 * t2115 * t603 * t296 + 0.36e2 * t709 * t694 * t703 - t8843 + 0.61524113149298439947e4 * t2208 * t8551 * t600 - 0.46785788981077169656e1 * t737 * t2249 * t296 - 0.18989649058080861537e-2 * t70 * t8656 * t138 - 0.11579025239058625248e4 * t2222 * t712 * t703 + 0.12414243100625616072e5 * t2214 * t693 * t2216 * t703 - 0.8e1 * t692 * t2202 * t281 + t8897 + t8900 - 0.62337092780453269531e3 * t2245 * t2057 * t600 - 0.55209406483950617283e-2 * t70 * t8656 * t125 + 0.19964560303604640732e6 * t116 / t9072 * t8981 / t9075 - t9082 - t9090;
  t9095 = t99 * t114 * (t8955 + t9001 + t9033 + t9091);
  t9096 = t257 * t2007;
  t9098 = t257 * t2137;
  t9103 = t99 * t2043 * t301;
  t9105 = t1920 * t269;
  t9107 = t1920 * t302;
  t9108 = 0.96e2 * t9107;
  t9109 = 0.24e3 * t8891 - t8894 - t8897 - t8900 + t9095 - 0.48e2 * t9096 - 0.48e2 * t9098 + 0.19751673498613801407e-1 * t8838 * t139 + t9082 + t9090 + 0.4e1 * t9103 + 0.96e2 * t9105 + t9108;
  t9112 = t8572 + t8612 + t8688 + t8721 + t8772 + t8855 + t8890 + t9109;
  t9122 = t59 * t206 * t583;
  t9124 = t565 * t61;
  t9125 = 0.119e3 / 0.3e1 * t9124;
  t9128 = t565 * t576;
  t9130 = t565 * t580;
  t9132 = t202 * t2381;
  t9134 = t202 * t2385;
  t9136 = t2774 * t2389;
  t9139 = 0.1e1 / t2377 / t60;
  t9140 = t9139 * t62;
  t9141 = t575 * t575;
  t9145 = t2378 * t8;
  t9147 = t59 * t9145 * t2380;
  t9153 = 0.3e1 / 0.2e1 * t9122 - t9125 - t878 * t2388 * t2398 - 0.119e3 / 0.3e1 * t9128 + 0.238e3 / 0.3e1 * t9130 - 0.14e2 * t9132 + 0.28e2 * t9134 + 0.14e2 * t9136 - 0.3e1 * t59 * t9140 * t9141 + 0.6e1 * t9147 + 0.9e1 / 0.2e1 * t2795 * t62 * t575 * t583;
  t9156 = t878 * t8 * t209 * t583;
  t9158 = t583 * t583;
  t9163 = t59 * t573 * t575;
  t9166 = t59 * t579 * t2398;
  t9167 = 0.1e1 / t7515;
  t9168 = t513 * t513;
  t9171 = 0.4e2 / 0.81e2 * t22 * t9167 * t9168;
  t9175 = 0.2e2 / 0.9e1 * t22 * t1927 * t513 * t517;
  t9176 = t517 * t517;
  t9179 = 0.1e2 / 0.3e1 * t22 * t512 * t9176;
  t9182 = 0.4e2 / 0.9e1 * t22 * t1932 * t1936;
  t9184 = 0.8e3 / 0.27e2 * t496 * t503;
  t9186 = 0.2e3 / 0.81e2 * t161 * t1913;
  t9188 = 0.2e3 / 0.9e1 * t161 * t1917;
  t9189 = 0.1e1 / t7190;
  t9190 = t502 * t502;
  t9193 = 0.4e2 / 0.81e2 * t7 * t9189 * t9190;
  t9197 = 0.2e2 / 0.9e1 * t7 * t1911 * t502 * t508;
  t9198 = t508 * t508;
  t9201 = 0.1e2 / 0.3e1 * t7 * t501 * t9198;
  t9204 = 0.4e2 / 0.9e1 * t7 * t1916 * t1922;
  t9209 = 0.616e4 / 0.81e2 * tau[0] / t4 / t8353 * t16;
  t9211 = 0.88e4 / 0.81e2 * t1901 * t168;
  t9213 = 0.4e3 / 0.9e1 * t496 * t509;
  t9215 = 0.1e3 / 0.9e1 * t161 * t1923;
  t9216 = 0.12e2 * t8812;
  t9219 = 0.5e1 / 0.3e1 * t7 * t15 * t9216;
  t9223 = -0.5e1 / 0.3e1 * t22 * t26 * t9216;
  t9224 = t9171 - t9175 + t9179 + t9182 + t9184 + t9186 - t9188 + t9193 - t9197 + t9201 + t9204 + t9209 - t9211 + t9213 - t9215 + t9219 + t9223;
  t9228 = t565 * t584;
  t9230 = t202 * t2392;
  t9232 = t202 * t2395;
  t9234 = t202 * t2399;
  t9238 = t30 / t33 / t6102;
  t9240 = 0.13685e5 / 0.81e2 * t9238 * t63;
  t9241 = t2362 * t210;
  t9243 = t2362 * t213;
  t9244 = 0.476e4 / 0.27e2 * t9243;
  t9245 = -0.6e1 * t9156 - 0.3e1 / 0.4e1 * t59 * t574 * t9158 - 0.3e1 * t9163 + t9166 + t59 * t207 * t9224 / 0.8e1 + 0.119e3 / 0.6e1 * t9228 - 0.14e2 * t9230 - 0.14e2 * t9232 - 0.7e1 / 0.3e1 * t9234 - t9240 - 0.238e4 / 0.27e2 * t9241 + t9244;
  t9261 = t528 * t542;
  t9262 = t544 * t522;
  t9263 = t147 * t9262;
  t9274 = 0.4e1 * t330 * t2322 + t156 * t9112 + 0.4e4 / 0.81e2 * t543 * t792 * t545 + 0.2e2 / 0.3e1 * t182 * t2412 + 0.2e2 / 0.9e1 * t182 * t2404 + 0.5e1 / 0.9e1 * t46 * t55 * (t9153 + t9245) * t146 + 0.2e2 / 0.9e1 * t46 * t55 * t2402 * t316 + 0.2e2 / 0.3e1 * t182 * t2408 + 0.1e2 / 0.3e1 * t46 * t55 * t589 * t791 + 0.4e4 / 0.27e2 * t9261 * t9263 + 0.4e4 / 0.81e2 * t543 * t590 * t545 + 0.8e4 / 0.81e2 * t543 * t594 * t545 + 0.1e2 / 0.3e1 * t524 * t793;
  t9279 = 0.2618e4 / 0.81e2 * t565;
  t9280 = t9171 - t9175 + t9179 + t9182 + t9184 + t9186 - t9188 + t9193 - t9197 + t9201 + t9204 + t9209 - t9211 + t9213 - t9215 + t9219 + t9223 - t9279;
  t9281 = t2 * t9280;
  t9294 = t541 * t216;
  t9295 = t9294 * t1295;
  t9298 = t2325 * t4310;
  t9301 = t192 * t2402;
  t9308 = t181 * t189;
  t9314 = 0.1e2 / 0.3e1 * t524 * t591 + 0.2e2 / 0.3e1 * t524 * t595 + 0.5e1 / 0.9e1 * t9281 * t45 * t148 + 0.2e2 / 0.9e1 * t2427 * t218 + 0.2e2 / 0.9e1 * t2427 * t318 - 0.2e3 / 0.27e2 * t190 * t549 * t2349 + 0.4e1 * t1971 * t316 + 0.8e4 / 0.81e2 * t2324 * t9295 + 0.8e4 / 0.81e2 * t2324 * t9298 - 0.2e3 / 0.81e2 * t190 * t9301 * t195 - 0.2e3 / 0.27e2 * t190 * t2337 * t554 - 0.4e3 / 0.27e2 * t9308 * t2344 - 0.1e3 / 0.27e2 * t190 * t2337 * t558;
  t9329 = t527 * t527;
  t9330 = t2 * t9329;
  t9332 = t1990 * t50;
  t9344 = t2322 * params->c;
  t9349 = t522 * t522;
  t9350 = t2 * t9349;
  t9355 = 0.1e1 / t1954 / t53;
  t9356 = t539 * t9355;
  t9358 = t39 * t9356 * t66;
  t9359 = t544 * t544;
  t9360 = t146 * t9359;
  t9366 = t39 * t1956 * t216;
  t9369 = t316 * t1958;
  t9374 = -0.2e3 / 0.81e2 * t190 * t193 * t553 * t1941 - 0.4e3 / 0.81e2 * t9308 * t2334 - 0.2e3 / 0.81e2 * t190 * t549 * t2333 - 0.5e2 / 0.81e2 * t190 * t193 * t194 * t9280 - 0.4e5 / 0.729e3 * t9330 * t1988 * t9332 - 0.4e3 / 0.27e2 * t9308 * t2330 - 0.2e3 / 0.27e2 * t190 * t549 * t2329 - 0.1e3 / 0.27e2 * t190 * t193 * t2348 * t522 - 0.2e3 / 0.81e2 * t190 * t193 * t9344 * t180 - 0.1e3 / 0.27e2 * t9350 * t188 * t531 + 0.4e6 / 0.6561e4 * t9358 * t9360 * t9329 * t189 - 0.4e5 / 0.729e3 * t9366 * t1992 - 0.4e5 / 0.729e3 * t1989 * t9369 * t1949 * t50;
  t9397 = t1958 * t40 * t152;
  t9400 = t39 * t9356;
  t9405 = t152 * t522;
  t9441 = t594 * params->c;
  t9442 = t325 * t9441;
  t9445 = t590 * params->c;
  t9446 = t325 * t9445;
  t9449 = t792 * params->c;
  t9450 = t325 * t9449;
  t9453 = t1958 * t527;
  t9458 = 0.5e1 / 0.9e1 * t46 * t55 * t66 * t9112 + 0.2e4 / 0.81e2 * t543 * t147 * t544 * t9349 + (-0.5e1 / 0.9e1 * t9281 * t40 * t153 + 0.4e3 / 0.81e2 * t1942 * t188 * t327 - 0.4e4 / 0.27e2 * t523 * t539 * t807 + 0.1e3 / 0.27e2 * t9350 * t185 * t802 + 0.4e5 / 0.729e3 * t9330 * t1956 * t9397 - 0.4e6 / 0.6561e4 * t9400 * t9359 * t9329 * t189 + 0.2e5 / 0.243e3 * t2535 * t4493 * t9405 - 0.2e4 / 0.81e2 * t805 * t806 * t9349 - 0.8e4 / 0.243e3 * t805 * t806 * t180 * t1941 + 0.5e2 / 0.81e2 * t324 * t325 * params->c * t9280) * t146 + 0.2e2 / 0.9e1 * t46 * t55 * t216 * t2322 + 0.2e2 / 0.9e1 * t182 * t2357 + 0.6e1 * t814 * t791 + 0.8e4 / 0.81e2 * t543 * t317 * t1976 + 0.8e4 / 0.243e3 * t543 * t147 * t544 * t1941 * t180 + 0.8e4 / 0.81e2 * t543 * t217 * t1976 - 0.4e3 / 0.27e2 * t529 * t9442 - 0.2e3 / 0.27e2 * t529 * t9446 - 0.2e3 / 0.27e2 * t529 * t9450 - 0.2e5 / 0.243e3 * t2556 * t9453 * t522 * t50;
  t9475 = t9 * (t9274 + t9314 + t9374 + t9458) + 0.12e2 * t1896 + 0.4e1 * t1972 + 0.12e2 * t1973 + 0.8e4 / 0.81e2 * t1978 - 0.4e3 / 0.27e2 * t1982 - 0.4e3 / 0.27e2 * t1986 - 0.4e5 / 0.729e3 * t1993 + 0.4e1 * t2323 + 0.8e4 / 0.81e2 * t2327 - 0.2e3 / 0.27e2 * t2331 - 0.2e3 / 0.81e2 * t2335 - 0.2e3 / 0.27e2 * t2339 - 0.4e3 / 0.27e2 * t2342;
  t9491 = -0.2e3 / 0.27e2 * t2345 - 0.2e3 / 0.27e2 * t2351 - 0.4e3 / 0.27e2 * t2354 + 0.2e2 / 0.9e1 * t2358 + 0.2e2 / 0.9e1 * t2405 + 0.2e2 / 0.3e1 * t2409 + 0.2e2 / 0.3e1 * t2413 + 0.8e4 / 0.81e2 * t2416 + 0.8e4 / 0.81e2 * t2419 + 0.2e2 / 0.3e1 * t2421 + 0.4e2 / 0.3e1 * t2423 + 0.2e2 / 0.3e1 * t2425 + 0.2e2 / 0.9e1 * t2428 + 0.2e2 / 0.3e1 * t2430 + 0.2e2 / 0.3e1 * t2432;
  tv4rho40 = t9475 + t9491;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t9508 = 0.6e1 * t2471 + 0.3e1 * t2473 + 0.3e1 * t2474 + t1897 + t1972 + t1974 + 0.6e1 * t2475 + 0.3e1 * t2553 - 0.1e5 / 0.243e3 * t2560 - 0.5e2 / 0.27e2 * t2564 - 0.1e3 / 0.27e2 * t2567 - 0.1e3 / 0.27e2 * t2572 - 0.5e2 / 0.27e2 * t2575 - 0.1e3 / 0.27e2 * t2579 - 0.5e2 / 0.27e2 * t2583 - 0.1e3 / 0.27e2 * t2588 - 0.1e3 / 0.27e2 * t2591 - 0.5e2 / 0.27e2 * t2594 - 0.1e3 / 0.27e2 * t2597;
  t9551 = -0.5e2 / 0.81e2 * t190 * t193 * t9344 * t350 - 0.1e3 / 0.27e2 * t9308 * t2593 - 0.5e2 / 0.81e2 * t190 * t9301 * t355 - 0.5e2 / 0.27e2 * t190 * t2337 * t861 - 0.5e2 / 0.27e2 * t190 * t2337 * t865 - 0.2e3 / 0.27e2 * t9308 * t2596 - 0.5e2 / 0.27e2 * t190 * t549 * t2602 - 0.1e3 / 0.27e2 * t190 * t549 * t2570 - 0.1e3 / 0.27e2 * t2353 * t904 - 0.5e2 / 0.27e2 * t190 * t2586 * t558 - 0.5e2 / 0.27e2 * t190 * t871 * t2329 - 0.5e2 / 0.81e2 * t190 * t871 * t2333 - 0.2e3 / 0.27e2 * t9308 * t2578;
  t9560 = t39 * t9356 * t9359;
  t9576 = 0.4e3 / 0.27e2 * t496 * t824;
  t9578 = 0.2e3 / 0.9e1 * t496 * t828;
  t9580 = 0.5e2 / 0.9e1 * t161 * t2491;
  t9583 = 0.1e2 / 0.9e1 * t7 * t823 * t1922;
  t9585 = 0.5e2 / 0.9e1 * t343 * t1933;
  t9587 = 0.5e2 / 0.27e2 * t161 * t2484;
  t9589 = 0.25e2 * t161 * t2497;
  t9593 = 0.4e2 / 0.81e2 * t7 * t9189 * t336 * t1912;
  t9597 = 0.1e2 / 0.3e1 * t7 * t501 * t506 * t167;
  t9600 = 0.2e2 * t7 * t827 * t256;
  t9604 = 0.4e2 / 0.81e2 * t22 * t9167 * t346 * t1928;
  t9608 = 0.1e2 / 0.3e1 * t22 * t512 * t506 * t171;
  t9611 = 0.2e2 * t22 * t837 * t256;
  t9614 = 0.1e2 / 0.9e1 * t22 * t833 * t1936;
  t9615 = t9576 + t9578 - t9580 + t9583 - t9585 + t9587 + t9589 + t9593 + t9597 + t9600 + t9604 - t9608 - t9611 + t9614 - t9279;
  t9633 = t22 * t1927;
  t9649 = t161 * t501;
  t9652 = t7 * t1911;
  t9659 = -0.25e2 / 0.9e1 * t343 * t1937 + 0.1e2 * t22 * t26 * t98 - 0.22e4 / 0.81e2 * t1901 * t337 - 0.25e2 / 0.3e1 * t161 * t2494 - 0.1e2 * t7 * t15 * t98 + 0.5e2 / 0.81e2 * t343 * t1929 + 0.1e2 / 0.3e1 * t2487 * t507 * t508 - 0.1e2 / 0.9e1 * t9633 * t5267 * t517 + 0.1e2 / 0.9e1 * t9633 * t507 * t513 - 0.1e2 / 0.3e1 * t2508 * t507 * t517 - 0.1e2 * t2487 * t1920 * t167 + 0.1e2 * t2508 * t1920 * t171 - 0.1e3 / 0.9e1 * t9649 * t2488 - 0.1e2 / 0.9e1 * t9652 * t4889 * t508 - 0.1e2 / 0.9e1 * t9652 * t507 * t502;
  t9660 = t9615 + t9659;
  t9668 = t962 * t40;
  t9686 = t2 * t9660;
  t9690 = 0.1e5 / 0.243e3 * t2535 * t841 * t527 * t50 - 0.4e6 / 0.6561e4 * t9560 * t350 * t1949 * t189 + 0.4e5 / 0.729e3 * t351 * t1956 * t1960 - 0.2e4 / 0.27e2 * t842 * t539 * t807 + 0.1e3 / 0.27e2 * t2526 * t811 + 0.1e3 / 0.81e2 * t959 * t1968 + 0.5e2 / 0.81e2 * t324 * t325 * params->c * t9660 + 0.1e3 / 0.27e2 * t2522 * t188 * t327 + 0.1e5 / 0.243e3 * t2535 * t9668 * t9405 - 0.2e4 / 0.81e2 * t805 * t806 * t2521 * t180 - 0.2e4 / 0.81e2 * t805 * t806 * t841 * t522 - 0.2e4 / 0.243e3 * t805 * t806 * t350 * t1941 - 0.2e4 / 0.27e2 * t2529 * t1964 - 0.5e1 / 0.9e1 * t9686 * t40 * t153;
  t9695 = t99 * t932 * t748;
  t9696 = 0.3e1 * t9695;
  t9698 = t99 * t377 * t2271;
  t9702 = t945 * t2125;
  t9704 = t2663 * t604;
  t9705 = 0.51947577317044391276e2 * t9704;
  t9706 = t945 * t2117;
  t9709 = t2709 * t129 * t313;
  t9711 = t2663 * t636;
  t9712 = 0.17544670867903938621e1 * t9711;
  t9713 = t9696 + t9698 - 0.4e1 * t8529 - 0.4e1 * t8531 - 0.15584273195113317383e3 * t8533 + t8540 + t8544 - t8549 - t8554 - 0.10254018858216406658e4 * t9702 - t9705 - 0.5848223622634646207e0 * t9706 - 0.17544670867903938621e1 * t9709 - t9712 - t8559 + t8563;
  t9714 = t1920 * t378;
  t9716 = t2276 * t378;
  t9717 = 0.144e3 * t9716;
  t9718 = t2280 * t378;
  t9720 = t2283 * t378;
  t9721 = 0.24e3 * t9720;
  t9722 = t257 * t2646;
  t9748 = 0.32e2 * t918 * t256;
  t9750 = my_piecewise3(t100, 0, 0.4e2 / 0.81e2 * t8799 * t335 * t2018 - 0.16e2 / 0.9e1 * t2017 * t8 * t506 * t641 - 0.8e1 / 0.9e1 * t2678 * t166 * t644 + 0.8e1 / 0.3e1 * t640 * t506 * t166 - 0.8e1 * t2681 * t98 * t166 + 0.8e1 / 0.3e1 * t2681 * t506 * t644 + 0.4e1 / 0.9e1 * t915 * t2024 - 0.16e2 * t103 * t98 + t9748);
  t9775 = 0.32e2 * t926 * t256;
  t9777 = my_piecewise3(t106, 0, 0.4e2 / 0.81e2 * t8820 * t372 * t2031 + 0.16e2 / 0.9e1 * t2030 * t8 * t506 * t651 - 0.8e1 / 0.9e1 * t2693 * t263 * t654 - 0.8e1 / 0.3e1 * t650 * t506 * t263 + 0.8e1 * t2696 * t98 * t263 - 0.8e1 / 0.3e1 * t2696 * t506 * t654 + 0.4e1 / 0.9e1 * t923 * t2037 + 0.16e2 * t107 * t98 - t9775);
  t9779 = (t9750 + t9777) * t113;
  t9786 = 0.24e2 * t9714 - t9717 - 0.12e3 * t9718 + t9721 - 0.12e2 * t9722 + 0.19751673498613801407e-1 * t9779 * t139 + t8567 - t8571 - t8575 - t8579 + 0.10526802520742363173e2 * t8580 - 0.17090684152272775383e-2 * t8582 - 0.18311447306006545054e-3 * t8585 - t8589 + 0.73245789224026180215e-3 * t8590 - t8594 - t8598;
  t9788 = t2663 * t787;
  t9789 = 0.35089341735807877242e1 * t9788;
  t9791 = 0.8e1 * t8606;
  t9792 = t253 * t2646;
  t9793 = 0.12e2 * t9792;
  t9794 = t770 * t933;
  t9795 = 0.6e2 * t9794;
  t9796 = t945 * t2287;
  t9798 = 0.12e2 * t8621;
  t9799 = 0.48e3 * t8623;
  t9800 = t2718 * t2301;
  t9802 = t2718 * t2304;
  t9804 = t2718 * t2307;
  t9806 = t8603 + t9789 + 0.31168546390226634765e3 * t8604 + t9791 + t9793 + t8611 + t8616 + t8620 + t9795 - 0.35089341735807877242e1 * t9796 + t9798 + t9799 - t8626 - 0.32530743900905219526e-1 * t9800 - 0.21687162600603479684e-1 * t9802 + 0.48159733137676571078e0 * t9804;
  t9808 = t932 * t70 * t780;
  t9809 = 0.32530743900905219526e-1 * t9808;
  t9810 = t2718 * t2313;
  t9812 = t253 * t2710;
  t9814 = t257 * t2710;
  t9817 = 0.24e3 * t8689;
  t9818 = 0.96e3 * t8697;
  t9820 = 0.144e3 * t8704;
  t9821 = t9809 + 0.16265371950452609763e-1 * t9810 + 0.12e2 * t9812 - 0.12e2 * t9814 - t8631 + t8635 - t8639 - t8677 - 0.17544670867903938621e1 * t8678 + t8683 - t8687 + t9817 - t8693 - t9818 + t8701 - 0.36e3 * t8702 + t9820;
  t9825 = t2709 * t67 * t308;
  t9827 = t2723 * t766;
  t9828 = 0.73245789224026180216e-3 * t9827;
  t9829 = t937 * t2079;
  t9831 = t945 * t2083;
  t9833 = t945 * t2058;
  t9835 = 0.96e2 * t8709;
  t9837 = t99 * t2709 * t301;
  t9841 = t945 * t2050;
  t9843 = t770 * t935;
  t9846 = 0.96e2 * t776 * t933;
  t9847 = 0.96e2 * t8726;
  t9850 = -0.54934341918019635162e-3 * t9825 + t9828 - 0.56968947174242584612e-3 * t9829 + 0.35089341735807877242e1 * t9831 - 0.51947577317044391277e2 * t9833 - t9835 + t8712 + 0.3e1 * t9837 - t8718 + 0.35089341735807877242e1 * t8719 - 0.10526802520742363173e2 * t8724 + 0.10389515463408878255e3 * t9841 + 0.6e2 * t9843 - t9846 - t9847 + t99 * t9779 * t141;
  t9851 = 0.36e2 * t8728;
  t9856 = 0.24e2 * t253 * t2668;
  t9857 = t257 * t2668;
  t9858 = 0.24e2 * t9857;
  t9859 = t773 * t935;
  t9860 = 0.36e2 * t9859;
  t9865 = -t9851 - 0.36e2 * t8730 + 0.6e2 * t8732 + 0.3e1 * t8737 + t9856 - t9858 + t9860 - t8744 + t8758 - 0.51947577317044391277e2 * t8759 - t8768 - 0.5848223622634646207e0 * t8770 - 0.17544670867903938621e1 * t8773 - 0.30762056574649219973e4 * t8775 + t8782 + t8786 - t8789;
  t9873 = t8793 + 0.3e1 * t8795 + t8843 + t8846 + t8849 + t8852 - 0.65061487801810439052e-1 * t8853 + t8859 - t8862 - 0.97592231702715658578e-1 * t8863 - t8867 - t8870 + 0.32530743900905219526e-1 * t8872 + 0.48796115851357829289e-1 * t8874 + 0.14447919941302971323e1 * t8876 + t8880;
  t9874 = 0.192e3 * t8888;
  t9876 = t776 * t935;
  t9877 = 0.96e2 * t9876;
  t9878 = t773 * t933;
  t9879 = 0.36e2 * t9878;
  t9883 = 0.48e2 * t9107;
  t9884 = t8884 - t8887 + t9874 + 0.18e3 * t8891 - t8894 - t8897 - t8900 - t9877 + t9879 + t9095 - 0.24e2 * t9096 - 0.36e2 * t9098 + t9082 + t9090 + t9103 - 0.72e2 * t9105 - t9883;
  t9887 = t9713 + t9786 + t9806 + t9821 + t9850 + t9865 + t9873 + t9884;
  t9900 = t59 * t206 * t886;
  t9901 = 0.3e1 / 0.4e1 * t9900;
  t9902 = t202 * t2789;
  t9903 = 0.7e1 / 0.2e1 * t9902;
  t9913 = 0.119e3 / 0.6e1 * t9130;
  t9915 = t202 * t2784;
  t9918 = t59 * t579 * t2783;
  t9920 = t2362 * t361;
  t9922 = t565 * t883;
  t9923 = 0.119e3 / 0.6e1 * t9922;
  t9924 = 0.7e1 / 0.2e1 * t9230;
  t9925 = t9901 - t9903 - 0.3e1 / 0.4e1 * t9122 + 0.7e1 / 0.2e1 * t9136 + 0.3e1 / 0.2e1 * t9156 + 0.119e3 / 0.12e2 * t9228 - 0.7e1 / 0.12e2 * t9234 - 0.595e3 / 0.9e1 * t9241 - 0.3e1 / 0.2e1 * t9147 - t9166 / 0.4e1 - 0.119e3 / 0.6e1 * t9128 + t9913 - 0.7e1 / 0.2e1 * t9132 - 0.7e1 / 0.4e1 * t9915 + 0.3e1 / 0.4e1 * t9918 - 0.595e3 / 0.27e2 * t9920 + t9923 + t9924 - t9240;
  t9926 = 0.238e4 / 0.27e2 * t9243;
  t9933 = t878 * t8 * t886 * t209;
  t9935 = t9576 + t9578 - t9580 + t9583 - t9585 + t9587 + t9589 + t9593 + t9597 + t9600 + t9604 - t9608 - t9611 + t9614;
  t9940 = t59 * t9139;
  t9945 = t2795 * t2799 * t575;
  t9947 = t2774 * t2769;
  t9950 = t878 * t2799 * t583;
  t9952 = t202 * t2378;
  t9953 = t9952 * t2796;
  t9956 = 0.14e2 * t2774 * t2800;
  t9957 = t2774 * t2780;
  t9969 = t565 * t573;
  t9970 = t9969 * t880;
  t9971 = 0.119e3 / 0.6e1 * t9970;
  t9972 = t583 * t209;
  t9976 = t565 * t887;
  t9977 = 0.119e3 / 0.12e2 * t9976;
  t9979 = 0.7e1 * t202 * t2792;
  t9982 = t59 * t573 * t360 * t209;
  t9983 = 0.3e1 / 0.2e1 * t9982;
  t9984 = t9926 + 0.3e1 / 0.2e1 * t9163 + 0.9e1 / 0.4e1 * t2795 * t2779 * t575 - 0.3e1 * t9933 + t59 * t207 * (t9935 + t9659) / 0.8e1 - 0.3e1 * t9940 * t879 * t2380 + 0.9e1 / 0.2e1 * t9945 + 0.7e1 / 0.2e1 * t9947 - 0.3e1 / 0.2e1 * t9950 - 0.21e2 / 0.2e1 * t9953 + t9956 + 0.7e1 * t9957 - 0.3e1 / 0.4e1 * t878 * t62 * t2783 * t209 - 0.3e1 / 0.4e1 * t878 * t2779 * t583 - t878 * t879 * t2398 / 0.4e1 - t9971 + 0.9e1 / 0.4e1 * t2795 * t879 * t9972 + t9977 - t9979 - t9983;
  t10009 = -0.1e3 / 0.27e2 * t190 * t549 * t2577 + t9690 * t146 + 0.3e1 * t330 * t2736 + t156 * t9887 + 0.5e1 / 0.3e1 * t46 * t55 * t891 * t791 + 0.2e4 / 0.81e2 * t543 * t892 * t545 + 0.2e4 / 0.81e2 * t543 * t896 * t545 + 0.5e1 / 0.9e1 * t46 * t55 * (t9925 + t9984) * t146 + 0.5e1 / 0.3e1 * t46 * t55 * t2810 * t316 + 0.5e1 / 0.9e1 * t46 * t55 * t364 * t2322 - 0.5e2 / 0.27e2 * t190 * t193 * t2348 * t841 - 0.5e2 / 0.81e2 * t190 * t193 * t902 * t1941 - 0.5e2 / 0.27e2 * t190 * t549 * t2562;
  t10019 = t896 * params->c;
  t10020 = t325 * t10019;
  t10026 = t952 * params->c;
  t10027 = t325 * t10026;
  t10030 = t892 * params->c;
  t10031 = t325 * t10030;
  t10034 = t907 * params->c;
  t10035 = t325 * t10034;
  t10050 = t181 * t542;
  t10060 = -0.1e5 / 0.243e3 * t2556 * t1958 * t841 * t527 * t50 + 0.4e4 / 0.81e2 * t543 * t317 * t2628 - 0.1e3 / 0.27e2 * t529 * t10020 + 0.2e4 / 0.81e2 * t543 * t365 * t1976 - 0.1e3 / 0.27e2 * t529 * t10027 - 0.1e3 / 0.27e2 * t529 * t10031 - 0.1e3 / 0.27e2 * t529 * t10035 + 0.2e4 / 0.81e2 * t543 * t383 * t1976 + 0.2e4 / 0.81e2 * t543 * t147 * t544 * t2521 * t180 + 0.2e4 / 0.81e2 * t543 * t147 * t2627 * t522 + 0.2e4 / 0.27e2 * t10050 * t2633 + 0.2e4 / 0.243e3 * t543 * t147 * t853 * t1941 + 0.2e4 / 0.81e2 * t543 * t590 * t854;
  t10093 = t382 * t1958;
  t10099 = t39 * t1956 * t364;
  t10102 = 0.4e4 / 0.81e2 * t543 * t594 * t854 + 0.4e4 / 0.81e2 * t543 * t217 * t2628 + 0.2e4 / 0.81e2 * t543 * t217 * t2632 + 0.2e4 / 0.81e2 * t543 * t792 * t854 - 0.1e3 / 0.27e2 * t9308 * t2603 + 0.2e4 / 0.81e2 * t543 * t317 * t2632 - 0.1e5 / 0.243e3 * t2556 * t2557 * t522 * t3853 - 0.1e3 / 0.27e2 * t846 * t2344 - 0.1e3 / 0.27e2 * t846 * t2330 - 0.1e3 / 0.27e2 * t2612 * t559 - 0.1e3 / 0.81e2 * t846 * t2334 - 0.4e5 / 0.729e3 * t351 * t1988 * t1992 - 0.1e5 / 0.729e3 * t1989 * t10093 * t1949 * t50 - 0.1e5 / 0.729e3 * t10099 * t1992;
  t10133 = 0.5e1 / 0.3e1 * t2823 * t318 + 0.5e1 / 0.3e1 * t843 * t591 + 0.1e2 / 0.3e1 * t843 * t595 + 0.5e1 / 0.3e1 * t843 * t793 + 0.5e1 / 0.3e1 * t182 * t2739 + 0.5e1 / 0.9e1 * t352 * t2404 + 0.5e1 / 0.3e1 * t352 * t2408 + 0.5e1 / 0.9e1 * t9686 * t45 * t148 + 0.5e1 / 0.3e1 * t2823 * t218 - 0.2e3 / 0.27e2 * t9308 * t2599 + 0.5e1 / 0.9e1 * t46 * t55 * t66 * t9887 + 0.3e1 * t970 * t791 + t394 * t2322;
  t10144 = t2736 * params->c;
  t10162 = t2325 * t4840;
  t10168 = t147 * t2627;
  t10171 = t217 * t853;
  t10174 = -0.5e2 / 0.27e2 * t190 * t193 * t2569 * t522 - 0.5e2 / 0.27e2 * t190 * t871 * t2349 - 0.5e2 / 0.27e2 * t190 * t2337 * t903 - 0.5e2 / 0.27e2 * t190 * t193 * t10144 * t180 - 0.5e2 / 0.27e2 * t190 * t193 * t553 * t2521 - 0.1e3 / 0.27e2 * t9308 * t2582 - 0.5e2 / 0.27e2 * t190 * t549 * t2581 - 0.5e2 / 0.81e2 * t190 * t193 * t194 * t9660 + 0.2e4 / 0.81e2 * t2324 * t10162 + 0.3e1 * t814 * t951 + t1971 * t382 + 0.2e4 / 0.27e2 * t9261 * t10168 + 0.2e4 / 0.27e2 * t9261 * t10171;
  t10176 = t317 * t853;
  t10199 = t541 * t364;
  t10200 = t10199 * t1295;
  t10206 = t192 * t2810;
  t10210 = 0.2e4 / 0.27e2 * t9261 * t10176 + 0.3e1 * t2552 * t316 + 0.5e1 / 0.3e1 * t46 * t55 * t216 * t2736 + 0.5e1 / 0.3e1 * t524 * t953 + 0.5e1 / 0.9e1 * t2427 * t384 + 0.5e1 / 0.3e1 * t524 * t908 + 0.5e1 / 0.3e1 * t182 * t2820 + 0.5e1 / 0.9e1 * t2427 * t366 + 0.5e1 / 0.3e1 * t524 * t893 + 0.5e1 / 0.3e1 * t524 * t897 + 0.2e4 / 0.81e2 * t2324 * t10200 - 0.1e3 / 0.27e2 * t190 * t2586 * t554 - 0.5e2 / 0.27e2 * t190 * t10206 * t195;
  t10213 = t9355 * t66;
  t10215 = t805 * t10213 * t146;
  t10221 = t1955 * t216;
  t10223 = t805 * t10221 * t146;
  t10227 = t805 * t2554 * t316;
  t10256 = -0.1e3 / 0.27e2 * t2353 * t872 + 0.4e6 / 0.6561e4 * t10215 * t9359 * t350 * t1949 * t189 - 0.1e5 / 0.243e3 * t10223 * t2559 - 0.1e5 / 0.243e3 * t10227 * t2559 + 0.5e1 / 0.3e1 * t46 * t55 * t589 * t951 + 0.1e2 / 0.3e1 * t182 * t2750 + 0.2e4 / 0.81e2 * t543 * t907 * t545 + 0.2e4 / 0.81e2 * t543 * t952 * t545 + 0.5e1 / 0.3e1 * t182 * t2746 + 0.5e1 / 0.9e1 * t46 * t55 * t2402 * t382 + 0.5e1 / 0.3e1 * t352 * t2412 + 0.5e1 / 0.9e1 * t352 * t2357 + 0.5e1 / 0.3e1 * t182 * t2812 + 0.1e2 / 0.3e1 * t182 * t2816;
  t10268 = -0.1e3 / 0.27e2 * t2600 - 0.5e2 / 0.27e2 * t2604 - 0.2e3 / 0.27e2 * t2606 - 0.2e3 / 0.27e2 * t2608 - 0.1e3 / 0.27e2 * t2610 - 0.2e3 / 0.27e2 * t2613 + t1979 - t1983 - t1987 + t9 * (t9551 + t10009 + t10060 + t10102 + t10133 + t10174 + t10210 + t10256) - 0.1e3 / 0.27e2 * t2617 + 0.4e4 / 0.81e2 * t2620 + 0.4e4 / 0.81e2 * t2623 + 0.4e4 / 0.81e2 * t2630 + 0.2e4 / 0.81e2 * t2634 - 0.1e3 / 0.27e2 * t2638 - t1994 + 0.3e1 * t2737 + t2323 + t2328;
  t10271 = -t2332 - t2336 - t2340 - t2343 - t2346 - t2352 - t2355 + t2359 + t2406 + t2410 + t2414 + t2417 + t2420 + t2422 + t2424 + t2426 + t2429 + t2431 + t2433 + 0.5e1 / 0.3e1 * t2740;
  t10292 = 0.2e4 / 0.81e2 * t2743 + 0.5e1 / 0.3e1 * t2747 + 0.1e2 / 0.3e1 * t2751 + 0.5e1 / 0.3e1 * t2753 + 0.1e2 / 0.3e1 * t2755 + 0.1e2 / 0.3e1 * t2757 + 0.5e1 / 0.3e1 * t2759 + 0.1e2 / 0.3e1 * t2762 + 0.1e2 / 0.3e1 * t2764 + 0.2e4 / 0.81e2 * t2767 + 0.5e1 / 0.3e1 * t2813 + 0.1e2 / 0.3e1 * t2817 + 0.5e1 / 0.3e1 * t2821 + 0.5e1 / 0.3e1 * t2824 + 0.1e2 / 0.3e1 * t2826 + 0.1e2 / 0.3e1 * t2828 + 0.2e4 / 0.27e2 * t2831 + 0.5e1 / 0.3e1 * t2833 + 0.1e2 / 0.3e1 * t2835 + 0.5e1 / 0.3e1 * t2837;
  tv4rho41 = t9508 + t10268 + t10271 + t10292;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t10296 = t317 * t1975;
  t10333 = t1085 * params->c;
  t10334 = t325 * t10333;
  t10337 = t841 * t841;
  t10338 = t2 * t10337;
  t10342 = t1051 * params->c;
  t10343 = t325 * t10342;
  t10346 = 0.4e4 / 0.81e2 * t3078 * t10296 + 0.8e4 / 0.81e2 * t2830 * t2629 + 0.4e4 / 0.243e3 * t543 * t365 * t2632 - 0.1e3 / 0.81e2 * t1014 * t9446 - 0.1e3 / 0.81e2 * t1014 * t9450 + 0.8e4 / 0.243e3 * t543 * t217 * t3162 + 0.8e4 / 0.243e3 * t543 * t317 * t3162 + 0.4e4 / 0.243e3 * t543 * t147 * t853 * t2521 + 0.4e4 / 0.243e3 * t543 * t383 * t2632 + 0.2e4 / 0.243e3 * t543 * t147 * t3155 * t522 - 0.2e3 / 0.81e2 * t1014 * t9442 + 0.8e4 / 0.243e3 * t543 * t896 * t854 + 0.8e4 / 0.243e3 * t543 * t365 * t2628 - 0.1e3 / 0.81e2 * t529 * t10334 - 0.2e3 / 0.81e2 * t10338 * t188 * t531 - 0.2e3 / 0.81e2 * t529 * t10343;
  t10347 = t1047 * params->c;
  t10348 = t325 * t10347;
  t10365 = t805 * t2554 * t382;
  t10373 = t1955 * t364;
  t10375 = t805 * t10373 * t146;
  t10394 = t1990 * t1012;
  t10395 = t10394 * t50;
  t10398 = t253 * t2978;
  t10404 = t1072 * t70 * t780;
  t10412 = 0.8e1 * t10398 - 0.8e1 * t8527 + 0.4e1 * t9695 + 0.2e1 * t9698 + 0.10843581300301739842e-1 * t10404 - 0.10389515463408878255e3 * t8533 + t8540 + t8544 - t8549 - t8554 - 0.20508037716432813315e4 * t9702 - 0.69263436422725855034e2 * t9704 - 0.11696447245269292414e1 * t9706 - 0.11696447245269292414e1 * t9709 - 0.23392894490538584828e1 * t9711 - t8559 + t8563;
  t10421 = t2934 * t636;
  t10424 = -0.48e2 * t9714 + 0.96e2 * t9716 - 0.24e3 * t9718 + 0.16e3 * t9720 - 0.24e2 * t9722 + t8567 - t8571 - t8575 - t8579 + 0.70178683471615754484e1 * t8580 - 0.11393789434848516922e-2 * t8582 - t8589 + 0.24415263074675393405e-3 * t8590 - t8594 - t8598 + t8603 - 0.5848223622634646207e0 * t10421 + 0.46785788981077169656e1 * t9788;
  t10431 = t2934 * t787;
  t10438 = t776 * t1073;
  t10440 = t773 * t1073;
  t10442 = 0.20779030926817756511e3 * t8604 + 0.8e1 * t9792 + t8611 + t8616 + t8620 + 0.8e2 * t9794 - 0.70178683471615754484e1 * t9796 - 0.8e1 * t8621 - t8626 + 0.11696447245269292414e1 * t10431 - 0.65061487801810439052e-1 * t9800 - 0.43374325201206959368e-1 * t9802 + 0.96319466275353142155e0 * t9804 + 0.43374325201206959368e-1 * t9808 + 0.32530743900905219526e-1 * t9810 - 0.32e2 * t10438 + 0.12e2 * t10440;
  t10445 = t2987 * t766;
  t10448 = t2975 * t67 * t308;
  t10451 = t770 * t1073;
  t10457 = -0.8e1 * t9812 - 0.8e1 * t9814 - t8631 + t8635 - t8639 + 0.24415263074675393405e-3 * t10445 - 0.36622894612013090108e-3 * t10448 - t8677 - 0.11696447245269292414e1 * t8678 + t8683 - t8687 + 0.2e2 * t10451 - 0.16e3 * t8689 - t8693 + 0.192e3 * t8694 + t8701 - 0.24e3 * t8702 + 0.96e2 * t8704;
  t10460 = t257 * t2978;
  t10476 = -0.8e1 * t10460 - 0.36622894612013090108e-3 * t9825 + 0.97661052298701573622e-3 * t9827 - 0.11393789434848516923e-2 * t9829 + 0.70178683471615754484e1 * t9831 - 0.10389515463408878255e3 * t9833 - 0.48e3 * t8707 + 0.64e2 * t8709 + t8712 - 0.24e2 * t8713 + 0.2e1 * t9837 + t8718 + 0.11696447245269292414e1 * t8719 - 0.70178683471615754484e1 * t8724 + 0.2077903092681775651e3 * t9841 + 0.12e3 * t9843 - 0.24e2 * t8728;
  t10484 = t99 * t1072 * t748;
  t10513 = my_piecewise3(t100, 0, 0.4e2 / 0.81e2 * t8799 * t1055 * t641 - 0.64e2 / 0.27e2 * t2678 * t166 * t8 * t506 - 0.8e1 / 0.27e2 * t2946 * t644 + 0.32e2 / 0.9e1 * t640 * t62 * t769 + 0.16e2 / 0.9e1 * t915 * t506 - 0.16e2 / 0.3e1 * t915 * t1920 - 0.8e1 / 0.27e2 * t2017 * t1058 * t641 + 0.8e1 / 0.9e1 * t640 * t2956 * t166 + 0.4e1 / 0.9e1 * t2951 * t644 + t9748);
  t10539 = my_piecewise3(t106, 0, 0.4e2 / 0.81e2 * t8820 * t1063 * t651 + 0.64e2 / 0.27e2 * t2693 * t263 * t8 * t506 - 0.8e1 / 0.27e2 * t2961 * t654 + 0.32e2 / 0.9e1 * t650 * t62 * t769 - 0.16e2 / 0.9e1 * t923 * t506 + 0.16e2 / 0.3e1 * t923 * t1920 - 0.8e1 / 0.27e2 * t2030 * t1066 * t651 + 0.8e1 / 0.9e1 * t650 * t2969 * t263 + 0.4e1 / 0.9e1 * t2966 * t654 - t9775);
  t10541 = (t10513 + t10539) * t113;
  t10544 = 0.12e2 * t8730 + 0.2e2 * t8732 + 0.32e2 * t8734 + 0.2e1 * t8737 - 0.32e2 * t9857 - 0.24e2 * t9859 + t10484 - t8744 + t8758 - 0.17315859105681463759e2 * t8759 - t8768 - 0.5848223622634646207e0 * t8773 - 0.20508037716432813316e4 * t8775 + 0.19751673498613801407e-1 * t10541 * t139 + t8782 + t8786 - t8789 + t8793;
  t10546 = t253 * t2976;
  t10548 = t257 * t2976;
  t10551 = t99 * t2975 * t301;
  t10559 = t8795 + 0.8e1 * t10546 - 0.8e1 * t10548 + 0.2e1 * t10551 + t8843 + t99 * t10541 * t141 + t8846 + t8849 + t8852 - 0.43374325201206959367e-1 * t8853 + t8859 - t8862 - 0.65061487801810439052e-1 * t8863 - t8867 - t8870 + 0.10843581300301739842e-1 * t8872 + 0.32530743900905219526e-1 * t8874;
  t10566 = t2934 * t604;
  t10569 = t2975 * t129 * t313;
  t10572 = 0.96319466275353142156e0 * t8876 + t8880 + t8884 - t8887 + 0.12e3 * t8891 - t8894 - t8897 - t8900 - 0.64e2 * t9876 - 0.48e2 * t9878 + t9095 - 0.8e1 * t9096 - 0.24e2 * t9098 + t9082 + t9090 - 0.17315859105681463759e2 * t10566 - 0.11696447245269292414e1 * t10569 + 0.48e2 * t9105;
  t10575 = t10412 + t10424 + t10442 + t10457 + t10476 + t10544 + t10559 + t10572;
  t10585 = -0.1e3 / 0.81e2 * t529 * t10348 - 0.2e5 / 0.729e3 * t10223 * t2998 - 0.2e5 / 0.729e3 * t10227 * t2998 - 0.1e5 / 0.729e3 * t2556 * t2996 * t522 * t50 + 0.4e6 / 0.6561e4 * t10215 * t9359 * t1012 * t527 * t189 - 0.2e5 / 0.729e3 * t10365 * t2559 - 0.1e5 / 0.729e3 * t2556 * t1958 * t1007 * t527 * t50 - 0.2e5 / 0.729e3 * t10375 * t2559 + t1102 * t791 - 0.4e5 / 0.729e3 * t2556 * t2557 * t841 * t3853 + 0.2e1 * t2552 * t382 + 0.1e2 / 0.9e1 * t46 * t55 * t216 * t2994 + 0.5e1 / 0.9e1 * t46 * t55 * t589 * t1084 - 0.4e5 / 0.729e3 * t528 * t1988 * t10395 + 0.5e1 / 0.9e1 * t46 * t55 * t66 * t10575 + 0.2e1 * t394 * t2736 - 0.2e3 / 0.81e2 * t190 * t549 * t3146;
  t10614 = t2994 * params->c;
  t10630 = -0.4e3 / 0.81e2 * t9308 * t3143 - 0.1e3 / 0.81e2 * t190 * t193 * t10144 * t350 - 0.4e3 / 0.81e2 * t846 * t2578 - 0.2e3 / 0.81e2 * t846 * t2582 - 0.2e3 / 0.81e2 * t190 * t871 * t2577 - 0.4e3 / 0.81e2 * t9308 * t3112 - 0.1e3 / 0.81e2 * t190 * t871 * t2581 - 0.2e3 / 0.81e2 * t190 * t193 * t2569 * t841 - 0.4e3 / 0.81e2 * t9308 * t3147 - 0.1e3 / 0.81e2 * t190 * t549 * t3124 - 0.1e3 / 0.81e2 * t190 * t193 * t10614 * t180 - 0.2e3 / 0.81e2 * t846 * t2574 - 0.1e3 / 0.81e2 * t3115 * t559 - 0.4e3 / 0.81e2 * t846 * t2599 - 0.1e3 / 0.81e2 * t190 * t871 * t2602 - 0.2e3 / 0.81e2 * t846 * t2563;
  t10668 = 0.4e2 / 0.27e2 * t9652 * t4889 * t507;
  t10671 = 0.4e2 / 0.27e2 * t9633 * t5267 * t507;
  t10673 = 0.5e2 / 0.9e1 * t161 * t2863;
  t10675 = 0.2e3 / 0.27e2 * t994 * t518;
  t10677 = 0.5e2 / 0.9e1 * t343 * t2515;
  t10679 = 0.4e3 / 0.81e2 * t496 * t984;
  t10681 = 0.2e3 / 0.27e2 * t496 * t988;
  t10683 = 0.4e3 / 0.81e2 * t994 * t514;
  t10686 = 0.2e2 / 0.3e1 * t2487 * t2851 * t98;
  t10689 = 0.2e2 / 0.3e1 * t2508 * t2876 * t98;
  t10691 = 0.2e3 / 0.27e2 * t9649 * t2852;
  t10692 = t343 * t512;
  t10694 = 0.2e3 / 0.27e2 * t10692 * t2509;
  t10698 = 0.2e2 / 0.9e1 * t7 * t501 * t62 * t769;
  t10700 = 0.1e3 / 0.27e2 * t343 * t2512;
  t10701 = -t10668 + t10671 + t9600 - t9611 - t10673 + t10675 + t10677 + t10679 + t10681 + t10683 - t9279 - t10686 + t10689 - t10691 + t10694 + t10698 - t10700;
  t10756 = -0.1e2 / 0.27e2 * t22 * t2872 * t517 + 0.2e2 / 0.9e1 * t22 * t512 * t62 * t769 + 0.2e2 / 0.9e1 * t22 * t512 * t2884 * t171 + 0.1e2 / 0.9e1 * t22 * t2880 * t517 + 0.1e3 / 0.81e2 * t161 * t2848 - 0.1e2 / 0.27e2 * t7 * t2847 * t508 - 0.1e3 / 0.27e2 * t161 * t2858 + 0.2e2 / 0.9e1 * t7 * t501 * t2862 * t167 + 0.1e2 / 0.9e1 * t7 * t2857 * t508 + 0.4e2 / 0.81e2 * t7 * t9189 * t983 * t502 + 0.2e2 / 0.9e1 * t7 * t823 * t506 - 0.1e2 / 0.27e2 * t7 * t1911 * t987 * t502 + 0.1e3 / 0.81e2 * t343 * t2505 - 0.5e2 / 0.3e1 * t343 * t2518 + 0.4e2 / 0.81e2 * t22 * t9167 * t999 * t513 - 0.2e2 / 0.9e1 * t22 * t833 * t506 - 0.1e2 / 0.27e2 * t22 * t1927 * t1003 * t513;
  t10757 = t10701 + t10756;
  t10758 = t2 * t10757;
  t10764 = -0.2e3 / 0.81e2 * t9308 * t3101 - 0.5e2 / 0.81e2 * t190 * t193 * t2348 * t1007 - 0.1e3 / 0.81e2 * t190 * t193 * t902 * t2521 - 0.2e3 / 0.81e2 * t9308 * t3097 - 0.5e2 / 0.81e2 * t190 * t2337 * t1032 - 0.1e3 / 0.81e2 * t190 * t549 * t3100 + t156 * t10575 + 0.5e1 / 0.9e1 * t1009 * t591 + 0.1e2 / 0.9e1 * t1009 * t595 + 0.1e2 / 0.9e1 * t352 * t2820 + 0.5e1 / 0.9e1 * t1009 * t793 + 0.2e4 / 0.81e2 * t3078 * t9263 + 0.1e2 / 0.9e1 * t2823 * t366 + 0.2e2 / 0.9e1 * t843 * t893 + 0.2e2 / 0.9e1 * t843 * t897 + 0.5e1 / 0.9e1 * t10758 * t45 * t148 + 0.1e2 / 0.9e1 * t3071 * t218;
  t10790 = t202 * t3048;
  t10792 = t565 * t1043;
  t10795 = t59 * t206 * t1042;
  t10797 = t2774 * t3045;
  t10799 = t209 * t886;
  t10814 = t878 * t2799 * t886;
  t10819 = t9952 * t3032;
  t10821 = -0.7e1 / 0.3e1 * t10790 + 0.119e3 / 0.36e2 * t10792 + t10795 / 0.4e1 + 0.7e1 / 0.3e1 * t10797 + 0.3e1 * t2795 * t879 * t10799 - t9900 - t878 * t62 * t3051 * t209 / 0.2e1 - t878 * t3044 * t583 / 0.4e1 + 0.3e1 / 0.4e1 * t2795 * t3031 * t583 - 0.2e1 * t10814 - t878 * t879 * t2783 / 0.2e1 - 0.7e1 * t10819;
  t10823 = -t10668 + t10671 + t9600 - t9611 - t10673 + t10675 + t10677 + t10679 + t10681 + t10683 - t10686 + t10689 - t10691 + t10694 + t10698 - t10700;
  t10828 = t202 * t3052;
  t10838 = t202 * t3035;
  t10840 = 0.7e1 / 0.3e1 * t9902 + t59 * t207 * (t10823 + t10756) / 0.8e1 - 0.7e1 / 0.6e1 * t10828 + t9122 / 0.4e1 + 0.119e3 / 0.36e2 * t9228 + 0.7e1 / 0.3e1 * t9232 - 0.119e4 / 0.27e2 * t9241 - 0.119e3 / 0.18e2 * t9128 - 0.119e3 / 0.9e1 * t9130 - 0.14e2 / 0.3e1 * t9134 - 0.7e1 / 0.6e1 * t9915 + 0.14e2 / 0.3e1 * t10838;
  t10843 = t59 * t579 * t3051;
  t10845 = t886 * t886;
  t10849 = t565 * t1038;
  t10856 = t2795 * t8 * t1037 * t209;
  t10863 = t878 * t8 * t1042 * t209;
  t10868 = t10843 / 0.2e1 - t59 * t574 * t10845 / 0.2e1 - 0.119e3 / 0.18e2 * t10849 - 0.3e1 * t9940 * t3031 * t575 + 0.3e1 * t10856 + 0.3e1 / 0.4e1 * t2795 * t3044 * t575 - t10863 - t9918 / 0.2e1 - 0.119e4 / 0.27e2 * t9920 + 0.119e3 / 0.9e1 * t9922 + 0.7e1 / 0.3e1 * t9230 - t9240;
  t10877 = t59 * t573 * t1037;
  t10880 = t2774 * t3038;
  t10884 = -t9163 / 0.2e1 + 0.2e1 * t9933 - 0.3e1 * t9945 + 0.7e1 / 0.3e1 * t9947 + t9950 - 0.7e1 * t9953 + 0.14e2 / 0.3e1 * t9957 - 0.238e3 / 0.9e1 * t9970 - t10877 / 0.2e1 + 0.119e3 / 0.9e1 * t9124 + 0.14e2 / 0.3e1 * t10880 + 0.119e3 / 0.9e1 * t9976 + 0.2e1 * t9982;
  t10905 = 0.1e2 / 0.9e1 * t3071 * t318 + 0.2e2 / 0.9e1 * t843 * t953 + 0.1e2 / 0.9e1 * t352 * t2746 + 0.2e2 / 0.9e1 * t352 * t2750 + 0.1e2 / 0.9e1 * t352 * t2812 + 0.2e2 / 0.9e1 * t352 * t2816 + 0.1e2 / 0.9e1 * t352 * t2739 + 0.1e2 / 0.9e1 * t2823 * t384 + 0.2e2 / 0.9e1 * t843 * t908 + 0.2e4 / 0.243e3 * t543 * t792 * t1021 + 0.1e2 / 0.9e1 * t182 * t3062 + 0.5e1 / 0.9e1 * t46 * t55 * (t10821 + t10840 + t10868 + t10884) * t146 + 0.1e2 / 0.9e1 * t46 * t55 * t3056 * t316 + 0.5e1 / 0.9e1 * t46 * t55 * t1046 * t791 + 0.2e4 / 0.243e3 * t543 * t590 * t1021 + 0.4e4 / 0.243e3 * t543 * t594 * t1021;
  t10948 = 0.4e1 * t970 * t951 + 0.4e4 / 0.243e3 * t543 * t317 * t3156 + 0.8e4 / 0.243e3 * t543 * t892 * t854 + 0.8e4 / 0.243e3 * t543 * t952 * t854 + 0.8e4 / 0.243e3 * t543 * t383 * t2628 + 0.4e4 / 0.243e3 * t543 * t217 * t3156 + 0.4e4 / 0.243e3 * t543 * t147 * t544 * t2888 * t180 + 0.8e4 / 0.243e3 * t543 * t907 * t854 + t814 * t1084 + 0.2e1 * t2918 * t316 + 0.1e2 / 0.9e1 * t524 * t1052 + 0.2e2 / 0.9e1 * t182 * t3068 + 0.2e2 / 0.9e1 * t182 * t3012 + 0.5e1 / 0.9e1 * t524 * t1048 + 0.1e2 / 0.9e1 * t182 * t3058 + 0.1e2 / 0.9e1 * t182 * t3002 + 0.5e1 / 0.9e1 * t524 * t1086;
  t10999 = 0.1e2 / 0.9e1 * t182 * t3008 + 0.1e2 / 0.9e1 * t46 * t55 * t364 * t2736 + 0.4e4 / 0.243e3 * t543 * t147 * t544 * t10337 - 0.4e3 / 0.81e2 * t9308 * t3106 - 0.1e3 / 0.81e2 * t190 * t10206 * t355 - 0.2e3 / 0.81e2 * t190 * t2586 * t861 - 0.2e3 / 0.81e2 * t190 * t2586 * t865 - 0.4e3 / 0.81e2 * t9308 * t3109 - 0.1e3 / 0.81e2 * t190 * t549 * t3128 - 0.1e3 / 0.81e2 * t190 * t193 * t553 * t2888 - 0.5e2 / 0.81e2 * t190 * t193 * t194 * t10757 - 0.2e3 / 0.81e2 * t190 * t2586 * t903 - 0.2e3 / 0.81e2 * t190 * t871 * t2570 - 0.5e2 / 0.81e2 * t190 * t193 * t3123 * t522 - 0.2e3 / 0.81e2 * t9308 * t3129 - 0.2e3 / 0.81e2 * t190 * t549 * t3142;
  t11000 = t192 * t3056;
  t11020 = t217 * t1975;
  t11025 = t1008 * t542;
  t11030 = t1008 * t539;
  t11033 = t806 * t522;
  t11040 = t9453 * t50;
  t11059 = t2889 * t188;
  t11086 = t152 * t841;
  t11090 = -0.2e4 / 0.81e2 * t11030 * t807 - 0.2e4 / 0.81e2 * t2898 * t11033 - 0.5e1 / 0.9e1 * t10758 * t40 * t153 + 0.4e5 / 0.729e3 * t1013 * t1956 * t11040 + 0.1e5 / 0.729e3 * t2535 * t1012 * t522 * t50 - 0.4e6 / 0.6561e4 * t9560 * t1012 * t527 * t189 + 0.1e5 / 0.729e3 * t2535 * t1007 * t527 * t50 + 0.5e2 / 0.81e2 * t324 * t325 * params->c * t10757 + 0.2e3 / 0.81e2 * t11059 * t327 + 0.1e3 / 0.81e2 * t2893 * t811 + 0.2e3 / 0.81e2 * t10338 * t185 * t802 + 0.2e3 / 0.81e2 * t959 * t2549 - 0.4e4 / 0.243e3 * t805 * t806 * t10337 - 0.4e4 / 0.243e3 * t805 * t806 * t350 * t2521 - 0.4e4 / 0.243e3 * t805 * t806 * t2888 * t180 - 0.2e4 / 0.243e3 * t805 * t806 * t1007 * t522 - 0.8e4 / 0.81e2 * t2529 * t2541 + 0.4e5 / 0.729e3 * t2535 * t9668 * t11086;
  t11109 = -0.1e3 / 0.81e2 * t190 * t11000 * t195 - 0.1e3 / 0.81e2 * t190 * t3132 * t554 - 0.5e2 / 0.81e2 * t190 * t3132 * t558 - 0.1e3 / 0.81e2 * t190 * t871 * t2562 - 0.4e3 / 0.81e2 * t9308 * t3139 - 0.1e3 / 0.81e2 * t190 * t2337 * t1028 + 0.2e1 * t330 * t2994 + 0.4e4 / 0.81e2 * t3078 * t11020 + 0.4e4 / 0.81e2 * t2830 * t2766 + 0.2e4 / 0.81e2 * t11025 * t546 + 0.4e4 / 0.81e2 * t2830 * t2742 + t11090 * t146 + 0.2e4 / 0.243e3 * t543 * t1047 * t545 + 0.4e4 / 0.243e3 * t543 * t1051 * t545 + 0.2e4 / 0.243e3 * t543 * t1085 * t545 + 0.1e2 / 0.9e1 * t46 * t55 * t2810 * t382 + 0.2e2 / 0.9e1 * t46 * t55 * t891 * t951;
  t11123 = 0.4e1 * t2471 + 0.2e1 * t2473 + t9 * (t10346 + t10585 + t10630 + t10764 + t10905 + t10948 + t10999 + t11109) + 0.2e1 * t2474 + 0.2e1 * t2919 + 0.4e1 * t2920 + 0.2e1 * t2922 + 0.2e1 * t2995 + 0.4e1 * t2475 + 0.2e1 * t2553 - 0.2e5 / 0.729e3 * t2560 - 0.2e5 / 0.729e3 * t2999;
  t11137 = -0.1e3 / 0.81e2 * t2564 - 0.2e3 / 0.81e2 * t2567 - 0.2e3 / 0.81e2 * t2572 - 0.1e3 / 0.81e2 * t2575 - 0.2e3 / 0.81e2 * t2579 - 0.1e3 / 0.81e2 * t2583 - 0.2e3 / 0.81e2 * t2588 - 0.2e3 / 0.81e2 * t2591 - 0.1e3 / 0.81e2 * t2594 - 0.2e3 / 0.81e2 * t2597 - 0.2e3 / 0.81e2 * t2600 - 0.1e3 / 0.81e2 * t2604 - 0.4e3 / 0.81e2 * t2606;
  t11151 = -0.4e3 / 0.81e2 * t2608 - 0.2e3 / 0.81e2 * t2610 - 0.4e3 / 0.81e2 * t2613 + 0.1e2 / 0.9e1 * t3003 - 0.2e3 / 0.81e2 * t2617 + 0.8e4 / 0.243e3 * t2620 + 0.8e4 / 0.243e3 * t2623 + 0.8e4 / 0.243e3 * t2630 + 0.4e4 / 0.243e3 * t2634 - 0.2e3 / 0.81e2 * t2638 + 0.2e1 * t2737 + 0.1e2 / 0.9e1 * t3005;
  t11165 = 0.1e2 / 0.9e1 * t3009 + 0.2e2 / 0.9e1 * t3013 + 0.2e2 / 0.9e1 * t3015 + 0.4e4 / 0.243e3 * t3018 + 0.4e4 / 0.243e3 * t3021 + 0.1e2 / 0.9e1 * t3024 + 0.1e2 / 0.9e1 * t3059 + 0.1e2 / 0.9e1 * t3063 + 0.2e2 / 0.9e1 * t3065 + 0.2e2 / 0.9e1 * t3069 + 0.1e2 / 0.9e1 * t3072 + 0.1e2 / 0.9e1 * t3074 + 0.1e2 / 0.9e1 * t3076;
  t11180 = 0.4e4 / 0.81e2 * t3080 + 0.2e2 / 0.9e1 * t3082 + 0.2e2 / 0.9e1 * t3084 + 0.2e2 / 0.9e1 * t3086 + 0.2e2 / 0.9e1 * t3088 + 0.2e2 / 0.9e1 * t3092 + 0.4e1 * t3094 + 0.2e1 * t3096 - 0.1e3 / 0.81e2 * t3098 - 0.1e3 / 0.81e2 * t3102 - 0.4e3 / 0.81e2 * t3104 - 0.2e3 / 0.81e2 * t3107;
  t11194 = -0.2e3 / 0.81e2 * t3110 - 0.2e3 / 0.81e2 * t3113 - 0.2e3 / 0.81e2 * t3116 - 0.4e3 / 0.81e2 * t3118 - 0.4e3 / 0.81e2 * t3120 - 0.1e3 / 0.81e2 * t3126 - 0.1e3 / 0.81e2 * t3130 - 0.1e3 / 0.81e2 * t3134 - 0.2e3 / 0.81e2 * t3137 - 0.2e3 / 0.81e2 * t3140 - 0.2e3 / 0.81e2 * t3144 - 0.2e3 / 0.81e2 * t3148 - 0.2e3 / 0.81e2 * t3150;
  t11209 = 0.8e4 / 0.243e3 * t3153 + 0.4e4 / 0.243e3 * t3158 - 0.2e3 / 0.81e2 * t3160 + 0.8e4 / 0.243e3 * t3164 + 0.8e4 / 0.243e3 * t3167 + 0.1e2 / 0.9e1 * t2740 + 0.4e4 / 0.243e3 * t2743 + 0.1e2 / 0.9e1 * t2747 + 0.2e2 / 0.9e1 * t2751 + 0.1e2 / 0.9e1 * t2753 + 0.2e2 / 0.9e1 * t2755 + 0.2e2 / 0.9e1 * t2757 + 0.1e2 / 0.9e1 * t2759;
  t11223 = 0.2e2 / 0.9e1 * t2762 + 0.2e2 / 0.9e1 * t2764 + 0.4e4 / 0.243e3 * t2767 + 0.1e2 / 0.9e1 * t2813 + 0.2e2 / 0.9e1 * t2817 + 0.1e2 / 0.9e1 * t2821 + 0.1e2 / 0.9e1 * t2824 + 0.2e2 / 0.9e1 * t2826 + 0.2e2 / 0.9e1 * t2828 + 0.4e4 / 0.81e2 * t2831 + 0.1e2 / 0.9e1 * t2833 + 0.2e2 / 0.9e1 * t2835 + 0.1e2 / 0.9e1 * t2837;
  tv4rho42 = t11123 + t11137 + t11151 + t11165 + t11180 + t11194 + t11209 + t11223;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t11241 = t9696 + 0.3e1 * t9698 + 0.32530743900905219526e-1 * t10404 - 0.51947577317044391277e2 * t8533 + t8540 + t8544 - t8549 - t8554 - 0.30762056574649219972e4 * t9702 - t9705 - 0.17544670867903938621e1 * t9706 - t9712 - t8559 + t8563 + 0.72e2 * t9714 + t9717;
  t11248 = -0.36e3 * t9718 - t9721 - 0.36e2 * t9722 + t8567 - t8571 - t8575 - t8579 + 0.35089341735807877242e1 * t8580 - 0.56968947174242584612e-3 * t8582 - t8589 - t8594 - t8598 + t8603 - 0.17544670867903938621e1 * t10421 + t9789 + 0.10389515463408878255e3 * t8604 - t9791;
  t11270 = 0.12e2 * t98 + 0.24e2 * t8811;
  t11274 = my_piecewise3(t100, 0, 0.4e2 / 0.81e2 * t8799 * t3250 * t166 - 0.16e2 / 0.9e1 * t2946 * t507 - 0.8e1 / 0.9e1 * t2678 * t1058 * t166 + 0.8e1 / 0.3e1 * t2681 * t506 * t1058 + 0.4e1 / 0.3e1 * t915 * t2956 + 0.4e1 / 0.9e1 * t640 * t3255 * t166 + 0.4e1 / 0.3e1 * t103 * t11270);
  t11295 = my_piecewise3(t106, 0, 0.4e2 / 0.81e2 * t8820 * t3260 * t263 + 0.16e2 / 0.9e1 * t2961 * t507 - 0.8e1 / 0.9e1 * t2693 * t1066 * t263 - 0.8e1 / 0.3e1 * t2696 * t506 * t1066 + 0.4e1 / 0.3e1 * t923 * t2969 + 0.4e1 / 0.9e1 * t650 * t3265 * t263 - 0.4e1 / 0.3e1 * t107 * t11270);
  t11297 = (t11274 + t11295) * t113;
  t11304 = -t9793 + t8611 + t8616 + t8620 + t9795 - 0.10526802520742363173e2 * t9796 - t9798 - t9799 - t8626 + 0.35089341735807877242e1 * t10431 + 0.19751673498613801407e-1 * t11297 * t139 - 0.97592231702715658578e-1 * t9800 - 0.65061487801810439052e-1 * t9802 + 0.14447919941302971323e1 * t9804 + t9809 + 0.48796115851357829289e-1 * t9810;
  t11307 = t3271 * t129 * t313;
  t11314 = -0.36e2 * t10440 - t8631 + t8635 - 0.5848223622634646207e0 * t11307 - t8639 + 0.73245789224026180216e-3 * t10445 - 0.54934341918019635162e-3 * t10448 - t8677 - 0.5848223622634646207e0 * t8678 + t8683 - t8687 + 0.6e2 * t10451 - t9817 - t8693 + t9818 + t8701 - 0.12e3 * t8702;
  t11324 = -t9820 - 0.24e2 * t10460 + t9828 - 0.17090684152272775384e-2 * t9829 + 0.10526802520742363173e2 * t9831 - 0.15584273195113317383e3 * t9833 + t9835 + t8712 - t8718 - 0.35089341735807877242e1 * t8724 + 0.31168546390226634765e3 * t9841 + 0.18e3 * t9843 + t9846 + t9847 + t9851 + t8737;
  t11328 = t3271 * t67 * t308;
  t11333 = -t9856 - t9858 - t9860 + 0.3e1 * t10484 - t8744 + t8758 - t8768 - 0.10254018858216406658e4 * t8775 - 0.18311447306006545054e-3 * t11328 + t8782 + t8786 - t8789 + t8793 - 0.12e2 * t10546 - 0.12e2 * t10548 + 0.3e1 * t10551 + t8843;
  t11340 = t8846 + t8849 + t8852 - 0.21687162600603479684e-1 * t8853 + t8859 - t8862 - 0.32530743900905219526e-1 * t8863 - t8867 - t8870 + 0.16265371950452609763e-1 * t8874 + 0.48159733137676571078e0 * t8876 + t8880 + t8884 - t8887 - t9874 + 0.6e2 * t8891;
  t11341 = t253 * t3272;
  t11343 = t257 * t3272;
  t11348 = t99 * t3271 * t301;
  t11353 = -t8894 - t8897 - t8900 + t9877 + t9879 + 0.4e1 * t11341 - 0.4e1 * t11343 + t99 * t11297 * t141 + t11348 + t9095 - 0.12e2 * t9098 + t9082 + t9090 - 0.51947577317044391276e2 * t10566 - 0.17544670867903938621e1 * t10569 - 0.24e2 * t9105 + t9883;
  t11356 = t11241 + t11248 + t11304 + t11314 + t11324 + t11333 + t11340 + t11353;
  t11361 = 0.1e2 / 0.9e1 * t9652 * t983 * t8 * t506;
  t11362 = t336 * t987;
  t11365 = 0.1e2 / 0.9e1 * t9652 * t11362 * t167;
  t11368 = 0.1e2 / 0.3e1 * t2487 * t507 * t987;
  t11370 = 0.1e3 / 0.9e1 * t10692 * t2877;
  t11374 = 0.1e2 / 0.9e1 * t9633 * t999 * t8 * t506;
  t11375 = t346 * t1003;
  t11378 = 0.1e2 / 0.9e1 * t9633 * t11375 * t171;
  t11381 = 0.1e2 / 0.3e1 * t2508 * t507 * t1003;
  t11383 = 0.4e3 / 0.27e2 * t994 * t834;
  t11385 = 0.2e3 / 0.9e1 * t994 * t838;
  t11387 = 0.5e2 / 0.27e2 * t343 * t2873;
  t11389 = 0.5e2 / 0.9e1 * t343 * t2881;
  t11393 = 0.4e2 / 0.81e2 * t22 * t9167 * t3201 * t171;
  t11394 = -t11361 - t11365 + t11368 + t11370 + t11374 - t11378 - t11381 + t11383 - t11385 + t11387 - t11389 + t11393;
  t11397 = 0.1e2 / 0.3e1 * t22 * t833 * t2884;
  t11401 = 0.1e2 / 0.9e1 * t22 * t512 * t3208 * t171;
  t11405 = 0.4e2 / 0.81e2 * t7 * t9189 * t3177 * t167;
  t11408 = 0.1e2 / 0.3e1 * t7 * t823 * t2862;
  t11412 = 0.1e2 / 0.9e1 * t7 * t501 * t3185 * t167;
  t11414 = 0.5e2 / 0.9e1 * t161 * t3181;
  t11416 = 0.25e2 / 0.3e1 * t343 * t2885;
  t11419 = -0.6e1 * t98 - 0.12e2 * t8811;
  t11422 = 0.5e1 / 0.3e1 * t22 * t26 * t11419;
  t11424 = 0.5e2 / 0.81e2 * t161 * t3178;
  t11426 = 0.25e2 / 0.9e1 * t161 * t3186;
  t11430 = -0.5e1 / 0.3e1 * t7 * t15 * t11419;
  t11432 = 0.22e4 / 0.81e2 * t3192 * t172;
  t11433 = t11397 + t11401 + t11405 + t11408 + t11412 - t11414 - t9279 - t11416 + t11422 + t11424 - t11426 + t11430 - t11432;
  t11434 = t11394 + t11433;
  t11435 = t2 * t11434;
  t11439 = t3213 * t188;
  t11448 = t806 * t841;
  t11453 = t1958 * t180 * t50;
  t11456 = t3219 * t185;
  t11457 = t800 * t180;
  t11484 = -0.5e1 / 0.9e1 * t11435 * t40 * t153 + 0.1e3 / 0.81e2 * t11439 * t327 + 0.1e3 / 0.27e2 * t11059 * t391 - 0.2e4 / 0.27e2 * t11030 * t963 + 0.1e3 / 0.27e2 * t2893 * t967 - 0.2e4 / 0.27e2 * t2898 * t11448 + 0.4e5 / 0.729e3 * t3220 * t1956 * t11453 - 0.4e6 / 0.6561e4 * t9560 * t11456 * t11457 + 0.1e5 / 0.243e3 * t2535 * t5668 * t11086 + 0.1e5 / 0.243e3 * t2535 * t3227 * t180 * t50 - 0.2e4 / 0.81e2 * t805 * t806 * t841 * t1007 - 0.2e4 / 0.81e2 * t805 * t806 * t350 * t2888 - 0.2e4 / 0.243e3 * t805 * t806 * t3212 * t180 + 0.5e2 / 0.81e2 * t324 * t325 * params->c * t11434;
  t11508 = t3294 * params->c;
  t11513 = -0.1e5 / 0.243e3 * t2556 * t2557 * t1007 * t3853 - 0.5e2 / 0.27e2 * t190 * t871 * t3124 + 0.3e1 * t2918 * t382 + t156 * t11356 + t11484 * t146 - 0.4e5 / 0.729e3 * t181 * t1988 * t3240 - 0.1e5 / 0.729e3 * t9366 * t3240 - 0.1e5 / 0.729e3 * t1989 * t9369 * t3219 * t50 - 0.5e2 / 0.27e2 * t190 * t871 * t3100 - 0.5e2 / 0.27e2 * t190 * t871 * t3128 - 0.5e2 / 0.27e2 * t190 * t549 * t3376 - 0.5e2 / 0.27e2 * t190 * t193 * t10614 * t350 - 0.5e2 / 0.81e2 * t190 * t193 * t11508 * t180;
  t11519 = t3213 * t189;
  t11524 = t192 * t3343;
  t11554 = -0.5e2 / 0.27e2 * t190 * t2586 * t1032 - 0.1e3 / 0.27e2 * t846 * t3125 - 0.1e3 / 0.81e2 * t11519 * t196 - 0.1e3 / 0.27e2 * t3115 * t872 - 0.5e2 / 0.81e2 * t190 * t11524 * t195 - 0.5e2 / 0.27e2 * t190 * t3132 * t903 - 0.5e2 / 0.81e2 * t190 * t193 * t194 * t11434 - 0.5e2 / 0.27e2 * t190 * t11000 * t355 - 0.5e2 / 0.27e2 * t190 * t3132 * t861 - 0.5e2 / 0.27e2 * t190 * t3132 * t865 - 0.1e3 / 0.27e2 * t190 * t2586 * t1028 - 0.5e2 / 0.27e2 * t190 * t549 * t3359 - 0.5e2 / 0.27e2 * t190 * t193 * t2569 * t1007;
  t11571 = t2996 * t40;
  t11589 = -0.2e3 / 0.27e2 * t846 * t3136 - 0.1e3 / 0.27e2 * t3115 * t904 - 0.1e3 / 0.27e2 * t846 * t3133 + 0.4e6 / 0.6561e4 * t10215 * t9359 * t3219 * t185 * t11457 - 0.1e5 / 0.243e3 * t10365 * t2998 - 0.1e5 / 0.243e3 * t10375 * t2998 - 0.1e5 / 0.243e3 * t2556 * t11571 * t11086 + t3235 * t316 + 0.3e1 * t394 * t2994 + 0.5e1 / 0.3e1 * t46 * t55 * t364 * t2994 + 0.2e4 / 0.81e2 * t3243 * t9295 + 0.2e4 / 0.81e2 * t3243 * t9298 + 0.2e4 / 0.81e2 * t543 * t217 * t3296;
  t11629 = 0.2e4 / 0.81e2 * t543 * t317 * t3296 + 0.2e4 / 0.81e2 * t543 * t147 * t2627 * t1007 + 0.2e4 / 0.81e2 * t543 * t147 * t853 * t2888 - 0.1e3 / 0.27e2 * t1014 * t10031 + 0.5e1 / 0.9e1 * t46 * t55 * t66 * t11356 + 0.3e1 * t1102 * t951 - 0.5e2 / 0.27e2 * t190 * t193 * t3123 * t841 - 0.1e3 / 0.27e2 * t2889 * t189 * t356 - 0.1e3 / 0.27e2 * t3115 * t858 - 0.1e3 / 0.27e2 * t3115 * t862 - 0.1e3 / 0.27e2 * t3115 * t866 - 0.2e3 / 0.27e2 * t846 * t3112 - 0.2e3 / 0.27e2 * t846 * t3147 - 0.1e3 / 0.27e2 * t190 * t871 * t3142;
  t11667 = -0.1e3 / 0.27e2 * t190 * t871 * t3146 - 0.5e2 / 0.27e2 * t190 * t193 * t902 * t2888 - 0.5e2 / 0.81e2 * t190 * t549 * t3363 - 0.5e2 / 0.81e2 * t190 * t193 * t553 * t3212 + 0.5e1 / 0.9e1 * t182 * t3322 + 0.2e4 / 0.27e2 * t3078 * t10168 - 0.1e3 / 0.27e2 * t1014 * t10020 - 0.1e3 / 0.27e2 * t1014 * t10035 - 0.1e3 / 0.27e2 * t1014 * t10027 + 0.2e4 / 0.81e2 * t543 * t1085 * t854 + 0.2e4 / 0.27e2 * t11025 * t855 + 0.4e4 / 0.81e2 * t543 * t1051 * t854 + 0.2e4 / 0.81e2 * t543 * t365 * t3156;
  t11671 = t544 * t3212;
  t11707 = t2774 * t3334;
  t11710 = t878 * t2799 * t1042;
  t11725 = t202 * t3340;
  t11728 = t59 * t579 * t3339;
  t11731 = 0.119e3 / 0.12e2 * t10792 - 0.3e1 / 0.4e1 * t10795 + 0.7e1 / 0.2e1 * t10797 + t9901 + 0.3e1 * t10814 - 0.21e2 / 0.2e1 * t10819 + t9903 - 0.7e1 / 0.4e1 * t10828 - t878 * t62 * t3339 * t209 / 0.4e1 + 0.7e1 / 0.2e1 * t11707 - 0.3e1 / 0.2e1 * t11710 - 0.3e1 / 0.4e1 * t878 * t2779 * t1042 - 0.3e1 / 0.4e1 * t878 * t879 * t3051 - 0.3e1 * t9940 * t62 * t3329 * t209 + 0.9e1 / 0.4e1 * t2795 * t3031 * t886 - 0.7e1 / 0.12e2 * t11725 + t11728 / 0.4e1 - 0.595e3 / 0.27e2 * t9241 - t9913;
  t11733 = t59 * t9145 * t3329;
  t11735 = t11424 + t11405 - t11361 - t11414 - t11365 + t11368 + t11408 - t11426 + t11412 + t11430 - t11432 + t11383;
  t11736 = -t11385 + t11387 + t11370 - t11389 - t11416 + t11393 + t11374 - t11378 - t11381 + t11397 + t11401 + t11422;
  t11741 = t202 * t3330;
  t11743 = t1042 * t209;
  t11754 = 0.3e1 / 0.2e1 * t11733 + t59 * t207 * (t11735 + t11736) / 0.8e1 - 0.7e1 / 0.2e1 * t11741 + 0.9e1 / 0.4e1 * t2795 * t879 * t11743 - 0.3e1 / 0.4e1 * t10843 - 0.119e3 / 0.6e1 * t10849 - 0.9e1 / 0.2e1 * t10856 + 0.3e1 / 0.2e1 * t10863 - 0.595e3 / 0.9e1 * t9920 - t9923 - t9924 - t9240 - t9926 - t9956 - t9971 + 0.3e1 / 0.2e1 * t10877 + 0.7e1 * t10880 + t9977 + t9979 - t9983;
  t11770 = 0.2e4 / 0.81e2 * t543 * t383 * t3156 + 0.2e4 / 0.243e3 * t543 * t147 * t11671 * t180 + 0.2e4 / 0.81e2 * t543 * t1047 * t854 + 0.4e4 / 0.81e2 * t543 * t365 * t3162 + 0.4e4 / 0.81e2 * t543 * t383 * t3162 + 0.5e1 / 0.3e1 * t46 * t55 * t891 * t1084 + 0.5e1 / 0.3e1 * t46 * t55 * t1046 * t951 + 0.5e1 / 0.3e1 * t182 * t3353 + 0.5e1 / 0.9e1 * t182 * t3345 + 0.5e1 / 0.9e1 * t46 * t55 * (t11731 + t11754) * t146 + 0.5e1 / 0.9e1 * t46 * t55 * t3343 * t316 + 0.5e1 / 0.3e1 * t182 * t3349 + 0.5e1 / 0.3e1 * t46 * t55 * t3056 * t382;
  t11803 = t330 * t3294 + 0.5e1 / 0.9e1 * t46 * t55 * t216 * t3294 + 0.5e1 / 0.3e1 * t352 * t3002 + 0.2e4 / 0.27e2 * t10050 * t3356 + 0.2e4 / 0.81e2 * t543 * t907 * t1021 + 0.5e1 / 0.3e1 * t843 * t1086 + 0.5e1 / 0.3e1 * t352 * t3008 + 0.5e1 / 0.3e1 * t1009 * t897 + 0.5e1 / 0.3e1 * t3071 * t384 + 0.2e4 / 0.81e2 * t543 * t952 * t1021 + 0.2e4 / 0.81e2 * t543 * t896 * t1021 + 0.5e1 / 0.9e1 * t11435 * t45 * t148 + 0.5e1 / 0.9e1 * t3309 * t218;
  t11833 = 0.5e1 / 0.9e1 * t3309 * t318 + 0.5e1 / 0.3e1 * t3071 * t366 + 0.5e1 / 0.3e1 * t1009 * t893 + 0.5e1 / 0.3e1 * t1009 * t953 + 0.5e1 / 0.3e1 * t843 * t1048 + 0.5e1 / 0.3e1 * t352 * t3058 + 0.5e1 / 0.3e1 * t352 * t3062 + 0.2e4 / 0.27e2 * t10050 * t3306 + 0.2e4 / 0.81e2 * t543 * t892 * t1021 + 0.1e2 / 0.3e1 * t352 * t3068 + 0.1e2 / 0.3e1 * t352 * t3012 + 0.5e1 / 0.3e1 * t1009 * t908 + 0.1e2 / 0.3e1 * t843 * t1052 + 0.3e1 * t970 * t1084;
  t11843 = t3176 + t3236 + t3238 + t9 * (t11513 + t11554 + t11589 + t11629 + t11667 + t11770 + t11803 + t11833) + 0.3e1 * t2919 - t3242 + 0.6e1 * t2920 + 0.3e1 * t2922 + 0.3e1 * t2995 - 0.1e5 / 0.243e3 * t2999 + t3245 + t3295 + t3299 - t3301 - t3303 + t3305 + t3308 + t3311 + t3313;
  t11856 = t3315 + t3318 + t3320 + t3324 + t3347 + t3351 + t3355 + t3358 + 0.5e1 / 0.3e1 * t3003 + 0.5e1 / 0.3e1 * t3005 + 0.5e1 / 0.3e1 * t3009 + 0.1e2 / 0.3e1 * t3013 + 0.1e2 / 0.3e1 * t3015 + 0.2e4 / 0.81e2 * t3018 + 0.2e4 / 0.81e2 * t3021 + 0.5e1 / 0.3e1 * t3024 + 0.5e1 / 0.3e1 * t3059 + 0.5e1 / 0.3e1 * t3063 + 0.1e2 / 0.3e1 * t3065 + 0.1e2 / 0.3e1 * t3069;
  t11871 = 0.5e1 / 0.3e1 * t3072 + 0.5e1 / 0.3e1 * t3074 + 0.5e1 / 0.3e1 * t3076 + 0.2e4 / 0.27e2 * t3080 + 0.1e2 / 0.3e1 * t3082 + 0.1e2 / 0.3e1 * t3084 + 0.1e2 / 0.3e1 * t3086 + 0.1e2 / 0.3e1 * t3088 + 0.1e2 / 0.3e1 * t3092 + 0.6e1 * t3094 + 0.3e1 * t3096 - t3362 - t3366 - t3369 - t3372 - t3375 - t3379 - t3381 - 0.5e2 / 0.27e2 * t3098 - 0.5e2 / 0.27e2 * t3102;
  t11892 = -0.2e3 / 0.27e2 * t3104 - 0.1e3 / 0.27e2 * t3107 - 0.1e3 / 0.27e2 * t3110 - 0.1e3 / 0.27e2 * t3113 - 0.1e3 / 0.27e2 * t3116 - 0.2e3 / 0.27e2 * t3118 - 0.2e3 / 0.27e2 * t3120 - 0.5e2 / 0.27e2 * t3126 - 0.5e2 / 0.27e2 * t3130 - 0.5e2 / 0.27e2 * t3134 - 0.1e3 / 0.27e2 * t3137 - 0.1e3 / 0.27e2 * t3140 - 0.1e3 / 0.27e2 * t3144 - 0.1e3 / 0.27e2 * t3148 - 0.1e3 / 0.27e2 * t3150 + 0.4e4 / 0.81e2 * t3153 + 0.2e4 / 0.81e2 * t3158 - 0.1e3 / 0.27e2 * t3160 + 0.4e4 / 0.81e2 * t3164 + 0.4e4 / 0.81e2 * t3167;
  tv4rho43 = t11843 + t11856 + t11871 + t11892;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t11908 = 0.12e2 * t3175 + 0.4e1 * t3236 + 0.12e2 * t3237 - 0.4e5 / 0.729e3 * t3241 + 0.8e4 / 0.81e2 * t3244 + 0.4e1 * t3295 + 0.8e4 / 0.81e2 * t3298 - 0.4e3 / 0.27e2 * t3300 - 0.4e3 / 0.27e2 * t3302 + 0.2e2 / 0.3e1 * t3304 + 0.8e4 / 0.81e2 * t3307 + 0.2e2 / 0.9e1 * t3310 + 0.2e2 / 0.3e1 * t3312 + 0.2e2 / 0.3e1 * t3314;
  t11918 = t1055 * t1055;
  t11923 = t1058 * t1058;
  t11928 = t98 + t8811;
  t11929 = 0.24e2 * t11928;
  t11933 = my_piecewise3(t100, 0, 0.4e2 / 0.81e2 * t8799 * t11918 - 0.16e2 / 0.9e1 * t2946 * t1058 + 0.4e1 / 0.3e1 * t640 * t11923 + 0.16e2 / 0.9e1 * t915 * t3255 + 0.4e1 / 0.3e1 * t103 * t11929);
  t11934 = t1063 * t1063;
  t11939 = t1066 * t1066;
  t11948 = my_piecewise3(t106, 0, 0.4e2 / 0.81e2 * t8820 * t11934 - 0.16e2 / 0.9e1 * t2961 * t1066 + 0.4e1 / 0.3e1 * t650 * t11939 + 0.16e2 / 0.9e1 * t923 * t3265 - 0.4e1 / 0.3e1 * t107 * t11929);
  t11950 = (t11933 + t11948) * t113;
  t11958 = 0.19751673498613801407e-1 * t11950 * t139 - 0.48e2 * t10398 + 0.4e1 * t9698 + 0.65061487801810439052e-1 * t10404 + t8540 + t8544 - t8549 - t8554 - 0.4101607543286562663e4 * t9702 - 0.23392894490538584828e1 * t9706 - t8559 + t8563;
  t11964 = -0.96e2 * t9714 - 0.576e3 * t9716 - 0.48e3 * t9718 - 0.96e3 * t9720 - 0.48e2 * t9722 + t8567 - t8571 - t8575 - t8579 - t8589 - t8594 - t8598 + t8603;
  t11972 = -0.35089341735807877242e1 * t10421 - t8607 - 0.48e2 * t9792 + t8611 + t8616 + t8620 - 0.14035736694323150897e2 * t9796 - t8624 - t8626 + 0.70178683471615754484e1 * t10431 - 0.1301229756036208781e0 * t9800 - 0.86748650402413918736e-1 * t9802;
  t11980 = 0.19263893255070628431e1 * t9804 + 0.65061487801810439052e-1 * t9810 + 0.192e3 * t10438 + 0.72e2 * t10440 - t8631 + t8635 - 0.23392894490538584828e1 * t11307 - t8639 + 0.14649157844805236043e-2 * t10445 - t8677 + t8683 - t8687 + 0.12e3 * t10451;
  t11987 = -t8693 - t8695 + t8698 + t8701 - 0.48e2 * t10460 - 0.22787578869697033845e-2 * t9829 + 0.14035736694323150897e2 * t9831 - 0.20779030926817756511e3 * t9833 + t8708 + t8712 + t8714 + t8718;
  t11993 = 0.4155806185363551302e3 * t9841 + 0.24e3 * t9843 + t8727 + 0.144e3 * t9859 + 0.6e1 * t10484 - t8744 + t8758 - t8768 - 0.73245789224026180216e-3 * t11328 + t8782 + t8786 - t8789 + t8793;
  t11997 = t99 * t11950 * t141 + t8843 + t8846 + t8849 + t8852 + t8859 - t8862 - t8867 - t8870 + t8880 + t8884 - t8887;
  t12003 = t8889 - t8894 - t8897 - t8900 + 0.384e3 * t9876 - 0.16e2 * t11341 - 0.16e2 * t11343 + 0.4e1 * t11348 + t9095 + t9082 + t9090 - 0.10389515463408878255e3 * t10566 - t9108;
  t12006 = t11958 + t11964 + t11972 + t11980 + t11987 + t11993 + t11997 + t12003;
  t12026 = 0.12e2 * t11928;
  t12029 = 0.5e1 / 0.3e1 * t7 * t15 * t12026;
  t12034 = 0.616e4 / 0.81e2 * tau[1] / t19 / t8480 * t27;
  t12036 = 0.88e4 / 0.81e2 * t3192 * t347;
  t12038 = 0.4e3 / 0.9e1 * t994 * t1004;
  t12040 = 0.1e3 / 0.9e1 * t343 * t3209;
  t12044 = -0.5e1 / 0.3e1 * t22 * t26 * t12026;
  t12045 = t983 * t983;
  t12048 = 0.4e2 / 0.81e2 * t7 * t9189 * t12045;
  t12051 = 0.2e2 / 0.9e1 * t7 * t2847 * t987;
  t12052 = t987 * t987;
  t12055 = 0.1e2 / 0.3e1 * t7 * t501 * t12052;
  t12058 = 0.4e2 / 0.9e1 * t7 * t823 * t3185;
  t12060 = 0.8e3 / 0.27e2 * t994 * t1000;
  t12062 = 0.2e3 / 0.81e2 * t343 * t3202;
  t12064 = 0.2e3 / 0.9e1 * t343 * t3205;
  t12065 = t999 * t999;
  t12068 = 0.4e2 / 0.81e2 * t22 * t9167 * t12065;
  t12071 = 0.2e2 / 0.9e1 * t22 * t2872 * t1003;
  t12072 = t1003 * t1003;
  t12075 = 0.1e2 / 0.3e1 * t22 * t512 * t12072;
  t12078 = 0.4e2 / 0.9e1 * t22 * t833 * t3208;
  t12079 = t12029 + t12034 - t12036 + t12038 - t12040 + t12044 + t12048 - t12051 + t12055 + t12058 + t12060 + t12062 - t12064 + t12068 - t12071 + t12075 + t12078 - t9279;
  t12080 = t2 * t12079;
  t12090 = 0.4e1 * t394 * t3294 + t156 * t12006 - 0.2e3 / 0.27e2 * t1014 * t10348 - 0.2e3 / 0.27e2 * t1014 * t10334 + 0.8e4 / 0.81e2 * t543 * t365 * t3296 + 0.8e4 / 0.81e2 * t543 * t383 * t3296 + 0.8e4 / 0.243e3 * t543 * t147 * t11671 * t350 - 0.4e3 / 0.27e2 * t1014 * t10343 + 0.4e1 * t3235 * t382 + 0.5e1 / 0.9e1 * t12080 * t45 * t148 + 0.2e2 / 0.9e1 * t3309 * t366 + 0.2e2 / 0.9e1 * t3309 * t384 + 0.1e2 / 0.3e1 * t1009 * t1048;
  t12096 = t147 * t3155;
  t12103 = t1012 * t1012;
  t12116 = t1007 * t1007;
  t12117 = t2 * t12116;
  t12121 = t152 * t1007;
  t12131 = 0.2e2 / 0.3e1 * t1009 * t1052 + 0.4e4 / 0.81e2 * t543 * t1047 * t1021 + 0.4e4 / 0.27e2 * t3078 * t12096 - 0.4e5 / 0.729e3 * t1989 * t10093 * t3219 * t50 + 0.4e6 / 0.6561e4 * t9358 * t9360 * t12103 * t189 - 0.4e5 / 0.729e3 * t10099 * t3240 + 0.8e4 / 0.81e2 * t3243 * t10200 + 0.8e4 / 0.81e2 * t3243 * t10162 + 0.6e1 * t1102 * t1084 - 0.1e3 / 0.27e2 * t12117 * t188 * t531 - 0.2e5 / 0.243e3 * t2556 * t11571 * t12121 - 0.2e3 / 0.27e2 * t190 * t871 * t3376 - 0.2e3 / 0.27e2 * t190 * t3132 * t1028;
  t12140 = t2 * t12103;
  t12204 = -0.2e3 / 0.81e2 * t190 * t193 * t11508 * t350 - 0.2e3 / 0.81e2 * t190 * t11524 * t355 - 0.4e5 / 0.729e3 * t12140 * t1988 * t9332 - 0.2e3 / 0.81e2 * t190 * t871 * t3363 - 0.5e2 / 0.81e2 * t190 * t193 * t194 * t12079 - 0.1e3 / 0.27e2 * t190 * t3132 * t1032 - 0.2e3 / 0.27e2 * t190 * t871 * t3359 - 0.1e3 / 0.27e2 * t190 * t193 * t3123 * t1007 - 0.2e3 / 0.81e2 * t190 * t193 * t902 * t3212 - 0.4e3 / 0.27e2 * t3115 * t1029 - 0.4e3 / 0.27e2 * t3115 * t1025 - 0.4e3 / 0.81e2 * t11519 * t356 + (-0.5e1 / 0.9e1 * t12080 * t40 * t153 + 0.4e3 / 0.81e2 * t11439 * t391 - 0.4e4 / 0.27e2 * t11030 * t1095 + 0.1e3 / 0.27e2 * t12117 * t185 * t802 + 0.4e5 / 0.729e3 * t12140 * t1956 * t9397 - 0.4e6 / 0.6561e4 * t9400 * t9359 * t12103 * t189 + 0.2e5 / 0.243e3 * t2535 * t5668 * t12121 - 0.2e4 / 0.81e2 * t805 * t806 * t12116 - 0.8e4 / 0.243e3 * t805 * t806 * t350 * t3212 + 0.5e2 / 0.81e2 * t324 * t325 * params->c * t12079) * t146;
  t12229 = t1037 * t1037;
  t12236 = t1042 * t1042;
  t12242 = t12029 + t12034 - t12036 + t12038 - t12040 + t12044 + t12048 - t12051 + t12055 + t12058 + t12060 + t12062 - t12064 + t12068 - t12071 + t12075 + t12078;
  t12250 = -0.238e4 / 0.27e2 * t9920 - 0.238e3 / 0.3e1 * t9922 - 0.3e1 * t59 * t9140 * t12229 + 0.9e1 / 0.2e1 * t2795 * t3031 * t1042 - 0.3e1 / 0.4e1 * t59 * t574 * t12236 - t878 * t879 * t3339 + t59 * t207 * t12242 / 0.8e1 - 0.14e2 * t11741 - 0.6e1 * t11733 + 0.119e3 / 0.6e1 * t10792 + 0.14e2 * t10790;
  t12259 = -0.119e3 / 0.3e1 * t10849 - 0.28e2 * t10838 + 0.3e1 / 0.2e1 * t10795 - 0.3e1 * t10877 + 0.14e2 * t11707 + 0.6e1 * t11710 - t9125 - t9240 - t9244 - 0.14e2 * t9902 - 0.7e1 / 0.3e1 * t11725 - t11728;
  t12279 = 0.5e1 / 0.9e1 * t46 * t55 * t66 * t12006 + 0.2e2 / 0.9e1 * t46 * t55 * t364 * t3294 + 0.2e2 / 0.9e1 * t352 * t3322 + 0.1e2 / 0.3e1 * t1009 * t1086 + 0.8e4 / 0.81e2 * t543 * t1051 * t1021 + 0.4e4 / 0.81e2 * t543 * t1085 * t1021 + 0.2e2 / 0.3e1 * t352 * t3353 + 0.2e2 / 0.9e1 * t352 * t3345 + 0.5e1 / 0.9e1 * t46 * t55 * (t12250 + t12259) * t146 + 0.2e2 / 0.9e1 * t46 * t55 * t3343 * t382 + 0.2e2 / 0.3e1 * t352 * t3349 + 0.1e2 / 0.3e1 * t46 * t55 * t1046 * t1084 + 0.2e4 / 0.81e2 * t543 * t147 * t544 * t12116;
  t12290 = 0.2e2 / 0.3e1 * t3317 + 0.4e2 / 0.3e1 * t3319 + 0.2e2 / 0.9e1 * t3323 + 0.2e2 / 0.9e1 * t3346 + 0.2e2 / 0.3e1 * t3350 + 0.2e2 / 0.3e1 * t3354 + 0.8e4 / 0.81e2 * t3357 + t9 * (t12090 + t12131 + t12204 + t12279) - 0.2e3 / 0.27e2 * t3361 - 0.2e3 / 0.81e2 * t3365 - 0.2e3 / 0.27e2 * t3368 - 0.4e3 / 0.27e2 * t3371 - 0.2e3 / 0.27e2 * t3374 - 0.2e3 / 0.27e2 * t3378 - 0.4e3 / 0.27e2 * t3380;
  tv4rho44 = t11908 + t12290;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t12296 = t1142 * t6349;
  t12297 = t1950 * t542 * t12296;
  t12301 = t543 * t147 * t1120 * t1941;
  t12305 = t190 * t193 * t9344 * t35;
  t12307 = t1136 * t3513;
  t12309 = t3423 * t189;
  t12310 = t12309 * t196;
  t12314 = t190 * t193 * t2348 * t177;
  t12316 = t3546 * t550;
  t12318 = t3546 * t555;
  t12320 = t3546 * t559;
  t12323 = t190 * t549 * t3535;
  t12325 = t9308 * t3536;
  t12330 = t1141 * t4156 * t3454;
  t12332 = t553 * t3453;
  t12334 = t1141 * t1354 * t12332;
  t12337 = t194 * t522 * t209;
  t12339 = t1141 * t1354 * t12337;
  t12341 = -0.25e3 / 0.81e2 * t12297 - 0.25e3 / 0.243e3 * t12301 + 0.25e2 / 0.324e3 * t12305 + 0.35e2 / 0.9e1 * t12307 + 0.11e4 / 0.243e3 * t12310 - 0.5e2 / 0.81e2 * t12314 - 0.2e3 / 0.81e2 * t12316 - 0.2e3 / 0.81e2 * t12318 - 0.1e3 / 0.81e2 * t12320 + 0.25e2 / 0.108e3 * t12323 + 0.25e2 / 0.54e2 * t12325 + 0.3e1 * t1179 * t791 + 0.175e3 / 0.81e2 * t12330 - 0.25e2 / 0.54e2 * t12334 - 0.25e2 / 0.108e3 * t12339;
  t12343 = t194 * t180 * t583;
  t12345 = t1141 * t1354 * t12343;
  t12347 = t1955 * t58;
  t12349 = t805 * t12347 * t61;
  t12350 = t1152 * t1958;
  t12352 = t1949 * t40 * t152;
  t12354 = t12349 * t12350 * t12352;
  t12358 = t2556 * t3488 * t522 * t3853;
  t12360 = t544 * t58;
  t12363 = t543 * t147 * t12360 * t180;
  t12365 = t3549 * t1154;
  t12367 = t1136 * t3583;
  t12369 = t3573 * t6160;
  t12370 = t3571 * t12369;
  t12374 = t3555 * t1797 * t545 * t209;
  t12377 = t3555 * t213 * t3556;
  t12379 = t1136 * t3510;
  t12381 = t9308 * t3529;
  t12384 = t190 * t9301 * t403;
  t12387 = t190 * t2337 * t1128;
  t12389 = t9308 * t3532;
  t12392 = t1942 * t50 * t410;
  t12394 = -0.25e2 / 0.108e3 * t12345 + 0.125e4 / 0.729e3 * t12354 + 0.125e4 / 0.243e3 * t12358 - 0.22e5 / 0.729e3 * t12363 + 0.5e1 / 0.24e2 * t12365 + 0.5e1 / 0.12e2 * t12367 + 0.25e2 / 0.54e2 * t12370 + 0.25e3 / 0.81e2 * t12374 - 0.5e3 / 0.81e2 * t12377 - 0.595e3 / 0.108e3 * t12379 + 0.25e2 / 0.54e2 * t12381 + 0.25e2 / 0.324e3 * t12384 + 0.25e2 / 0.108e3 * t12387 + 0.25e2 / 0.27e2 * t12389 - 0.5e1 / 0.72e2 * t12392;
  t12396 = t3549 * t1162;
  t12398 = t1136 * t3568;
  t12400 = t3424 * t318;
  t12402 = t400 * t2404;
  t12404 = t400 * t2408;
  t12406 = t400 * t2412;
  t12408 = t400 * t2357;
  t12410 = t3424 * t218;
  t12413 = t194 * t180 * t575;
  t12415 = t1141 * t1338 * t12413;
  t12418 = t1141 * t4139 * t3454;
  t12422 = t190 * t193 * t553 * t58;
  t12426 = t190 * t193 * t194 * t201;
  t12427 = 0.77e4 / 0.2187e4 * t12426;
  t12430 = t407 * t54 * t2361 * t409;
  t12431 = 0.2975e4 / 0.243e3 * t12430;
  t12433 = t407 * t3509 * t1157;
  t12434 = 0.595e3 / 0.54e2 * t12433;
  t12436 = t190 * t2337 * t1132;
  t12438 = -0.5e1 / 0.24e2 * t12396 - 0.5e1 / 0.24e2 * t12398 - 0.55e2 / 0.27e2 * t12400 - 0.5e1 / 0.72e2 * t12402 - 0.5e1 / 0.24e2 * t12404 - 0.5e1 / 0.24e2 * t12406 - 0.5e1 / 0.72e2 * t12408 - 0.55e2 / 0.27e2 * t12410 + 0.25e2 / 0.54e2 * t12415 - 0.25e2 / 0.27e2 * t12418 + 0.55e3 / 0.243e3 * t12422 - t12427 + t12431 - t12434 - 0.5e2 / 0.81e2 * t12436;
  t12440 = t190 * t549 * t3519;
  t12443 = t407 * t3509 * t1161;
  t12446 = t407 * t1147 * t3563;
  t12448 = t3549 * t1148;
  t12450 = t3549 * t1158;
  t12452 = t1136 * t3560;
  t12454 = t1136 * t3564;
  t12457 = t39 * t542 * t201;
  t12458 = t12457 * t3557;
  t12461 = t190 * t3573 * t195;
  t12463 = t8 * t316;
  t12466 = t407 * t1151 * t12463 * t209;
  t12468 = t3420 * t2415;
  t12471 = t9261 * t147 * t3448;
  t12473 = t3420 * t2418;
  t12476 = t1141 * t3400 * t558;
  t12479 = t1141 * t3404 * t558;
  t12481 = t9359 * t35;
  t12484 = t10215 * t12481 * t1949 * t189;
  t12486 = -0.1e3 / 0.81e2 * t12440 - 0.595e3 / 0.108e3 * t12443 + 0.35e2 / 0.9e1 * t12446 + 0.35e2 / 0.36e2 * t12448 - 0.5e1 / 0.12e2 * t12450 + 0.35e2 / 0.18e2 * t12452 - 0.5e1 / 0.6e1 * t12454 + 0.35e4 / 0.243e3 * t12458 + 0.25e2 / 0.54e2 * t12461 + 0.5e1 / 0.6e1 * t12466 - 0.25e3 / 0.27e2 * t12468 + 0.2e4 / 0.81e2 * t12471 - 0.25e3 / 0.27e2 * t12473 - 0.175e3 / 0.162e3 * t12476 + 0.25e2 / 0.54e2 * t12479 - 0.5e5 / 0.6561e4 * t12484;
  t12490 = t1141 * t1143 * t2329;
  t12493 = t1141 * t1143 * t2333;
  t12495 = t399 * t1988;
  t12496 = t12495 * t1992;
  t12498 = t1136 * t3495;
  t12502 = t805 * t806 * t177 * t522;
  t12506 = t805 * t806 * t35 * t1941;
  t12508 = t2 * t201;
  t12510 = t12508 * t40 * t153;
  t12511 = 0.77e3 / 0.243e3 * t12510;
  t12512 = t3464 * t1964;
  t12514 = t1109 * t539;
  t12515 = t12514 * t807;
  t12517 = params->c * t201;
  t12519 = t324 * t325 * t12517;
  t12520 = 0.77e4 / 0.2187e4 * t12519;
  t12521 = t399 * t1956;
  t12522 = t12521 * t1960;
  t12524 = t3423 * t188;
  t12525 = t12524 * t327;
  t12529 = t9560 * t35 * t1949 * t189;
  t12533 = t2535 * t177 * t527 * t50;
  t12537 = t2535 * t1171 * t40 * t9405;
  t12539 = t3461 * t811;
  t12541 = t1168 * t1968;
  t12545 = t805 * t806 * t58 * t180;
  t12547 = -0.2e4 / 0.243e3 * t12502 + 0.25e3 / 0.243e3 * t12506 - t12511 + 0.25e3 / 0.27e2 * t12512 - 0.2e4 / 0.81e2 * t12515 + t12520 - 0.5e4 / 0.729e3 * t12522 - 0.11e4 / 0.243e3 * t12525 + 0.5e5 / 0.6561e4 * t12529 + 0.1e5 / 0.729e3 * t12533 - 0.125e4 / 0.243e3 * t12537 + 0.1e3 / 0.81e2 * t12539 - 0.25e2 / 0.162e3 * t12541 + 0.22e5 / 0.729e3 * t12545;
  t12549 = t1147 * t573;
  t12551 = t407 * t12549 * t3501;
  t12554 = t407 * t3577 * t3494;
  t12556 = t192 * t201;
  t12557 = t12556 * t61;
  t12558 = t12557 * t1651;
  t12559 = t3571 * t12558;
  t12561 = t3573 * t6156;
  t12562 = t3571 * t12561;
  t12566 = t407 * t3500 * t3493 * t575;
  t12568 = t408 * t2378;
  t12571 = t407 * t12568 * t1152 * t2380;
  t12573 = t1136 * t3502;
  t12577 = t407 * t3500 * t3581 * t575;
  t12581 = t154 * t1338 * t4214 * t209;
  t12583 = t10223 * t3490;
  t12585 = 0.25e2 / 0.108e3 * t12490 + 0.25e2 / 0.324e3 * t12493 + 0.5e4 / 0.729e3 * t12496 + 0.5e1 / 0.6e1 * t12498 + t12547 * t146 + 0.35e2 / 0.18e2 * t12551 - 0.35e2 / 0.9e1 * t12554 - 0.175e3 / 0.81e2 * t12559 + 0.25e2 / 0.27e2 * t12562 - 0.5e1 / 0.6e1 * t12566 + 0.5e1 / 0.12e2 * t12571 - 0.5e1 / 0.12e2 * t12573 - 0.5e1 / 0.12e2 * t12577 - 0.5e1 / 0.12e2 * t12581 + 0.125e4 / 0.243e3 * t12583;
  t12586 = t10227 * t3490;
  t12589 = t407 * t1147 * t3567;
  t12591 = t206 * t146;
  t12594 = t407 * t408 * t12591 * t209;
  t12597 = t3555 * t409 * t1976;
  t12601 = t543 * t217 * t3437;
  t12604 = t543 * t317 * t3437;
  t12607 = t543 * t792 * t1121;
  t12609 = t3420 * t1977;
  t12611 = t1110 * t591;
  t12613 = t1110 * t595;
  t12616 = t12508 * t45 * t148;
  t12617 = 0.77e3 / 0.243e3 * t12616;
  t12618 = t1110 * t793;
  t12622 = t46 * t55 * t3399 * t146;
  t12623 = 0.35e2 / 0.18e2 * t12622;
  t12625 = t543 * t217 * t3449;
  t12627 = 0.125e4 / 0.243e3 * t12586 + 0.35e2 / 0.36e2 * t12589 + 0.5e1 / 0.12e2 * t12594 - 0.25e3 / 0.81e2 * t12597 + t420 * t2322 - 0.25e3 / 0.81e2 * t12601 - 0.25e3 / 0.81e2 * t12604 - 0.25e3 / 0.81e2 * t12607 - 0.25e3 / 0.27e2 * t12609 + 0.5e1 / 0.9e1 * t12611 + 0.1e2 / 0.9e1 * t12613 + t12617 + 0.5e1 / 0.9e1 * t12618 + t12623 + 0.4e4 / 0.243e3 * t12625;
  t12630 = t543 * t317 * t3449;
  t12634 = t543 * t147 * t3448 * t522;
  t12637 = t543 * t590 * t1121;
  t12640 = t543 * t594 * t1121;
  t12642 = t182 * t3445;
  t12646 = t46 * t55 * t1142 * t316;
  t12651 = t564 * t61 * t62;
  t12653 = t1141 * t12651 * t195;
  t12655 = t3399 * t8;
  t12657 = t1141 * t12655 * t195;
  t12659 = t799 * t1140;
  t12660 = t1354 * t6152;
  t12661 = t12659 * t12660;
  t12664 = t1141 * t3404 * t554;
  t12667 = t1141 * t1143 * t2349;
  t12669 = t1958 * t177;
  t12672 = t2556 * t12669 * t527 * t50;
  t12676 = t523 * t185 * t1140 * t1144;
  t12679 = t1141 * t3400 * t554;
  t12681 = 0.4e4 / 0.243e3 * t12630 + 0.2e4 / 0.243e3 * t12634 - 0.25e3 / 0.81e2 * t12637 - 0.5e3 / 0.81e2 * t12640 - 0.5e1 / 0.12e2 * t12642 - 0.5e1 / 0.12e2 * t12646 + 0.3e1 * t3485 * t316 + 0.2975e4 / 0.486e3 * t12653 - 0.35e3 / 0.81e2 * t12657 - 0.25e2 / 0.54e2 * t12661 + 0.25e2 / 0.27e2 * t12664 + 0.25e2 / 0.108e3 * t12667 - 0.1e5 / 0.729e3 * t12672 + 0.25e2 / 0.54e2 * t12676 - 0.175e3 / 0.81e2 * t12679;
  t12682 = t1113 * t2330;
  t12684 = t1113 * t2334;
  t12686 = t1113 * t2344;
  t12690 = t407 * t408 * t63 * t2322;
  t12694 = t407 * t408 * t213 * t791;
  t12698 = t3555 * t63 * t4310 * t527;
  t12701 = t190 * t549 * t3523;
  t12705 = t407 * t1151 * t3493 * t583;
  t12707 = t1136 * t3587;
  t12711 = t407 * t1151 * t1152 * t2398;
  t12713 = t3509 * t206;
  t12715 = t407 * t12713 * t1153;
  t12717 = t1136 * t3578;
  t12720 = t407 * t3577 * t3586;
  t12724 = t407 * t1151 * t3581 * t583;
  t12726 = t62 * t791;
  t12729 = t407 * t1151 * t12726 * t209;
  t12732 = t407 * t3577 * t3582;
  t12734 = 0.25e2 / 0.54e2 * t12682 + 0.25e2 / 0.162e3 * t12684 + 0.25e2 / 0.54e2 * t12686 - 0.5e1 / 0.72e2 * t12690 - 0.5e1 / 0.12e2 * t12694 - 0.25e3 / 0.81e2 * t12698 + 0.55e3 / 0.243e3 * t12701 + 0.5e1 / 0.12e2 * t12705 + 0.5e1 / 0.24e2 * t12707 + 0.5e1 / 0.72e2 * t12711 + 0.595e3 / 0.108e3 * t12715 - 0.35e2 / 0.18e2 * t12717 - 0.35e2 / 0.36e2 * t12720 + 0.5e1 / 0.24e2 * t12724 + 0.5e1 / 0.24e2 * t12729 - 0.35e2 / 0.18e2 * t12732;
  t12743 = 0.55e2 / 0.27e2 * t3425;
  t12746 = -0.175e3 / 0.81e2 * t3402 + 0.25e2 / 0.27e2 * t3406 + 0.25e2 / 0.54e2 * t3409 + 0.25e2 / 0.108e3 * t3412 + t9 * (t12341 + t12394 + t12438 + t12486 + t12585 + t12627 + t12681 + t12734) - 0.5e1 / 0.24e2 * t3414 + 0.1e2 / 0.9e1 * t3416 + 0.1e2 / 0.9e1 * t3418 - 0.25e3 / 0.27e2 * t3421 - t12743 - 0.5e1 / 0.24e2 * t3427 - 0.5e1 / 0.12e2 * t3429;
  t12751 = 0.5e1 / 0.12e2 * t3446;
  t12759 = 0.6e1 * t3431 - 0.5e3 / 0.81e2 * t3435 - 0.25e3 / 0.81e2 * t3439 - 0.5e3 / 0.81e2 * t3442 - t12751 + 0.4e4 / 0.243e3 * t3451 - 0.25e2 / 0.54e2 * t3456 + 0.3e1 * t3486 + 0.3e1 * t3487 + 0.125e4 / 0.243e3 * t3491 + 0.5e1 / 0.6e1 * t3496 + 0.5e1 / 0.12e2 * t3498;
  t12763 = 0.595e3 / 0.108e3 * t3511;
  t12764 = 0.35e2 / 0.9e1 * t3514;
  t12767 = 0.55e3 / 0.243e3 * t3525;
  t12773 = -0.5e1 / 0.12e2 * t3503 - 0.5e1 / 0.6e1 * t3507 - t12763 + t12764 - 0.1e3 / 0.81e2 * t3517 - 0.1e3 / 0.81e2 * t3521 + t12767 + 0.35e2 / 0.18e2 * t3527 + 0.25e2 / 0.108e3 * t3530 + 0.25e2 / 0.54e2 * t3533 + 0.25e2 / 0.108e3 * t3537 + 0.25e2 / 0.27e2 * t3539;
  t12787 = 0.25e2 / 0.27e2 * t3541 + 0.25e2 / 0.54e2 * t3544 - 0.2e3 / 0.81e2 * t3547 - 0.5e1 / 0.24e2 * t3550 - 0.5e1 / 0.12e2 * t3552 - 0.25e3 / 0.81e2 * t3558 + 0.35e2 / 0.18e2 * t3561 - 0.5e1 / 0.6e1 * t3565 - 0.5e1 / 0.24e2 * t3569 + 0.25e2 / 0.54e2 * t3575 - 0.35e2 / 0.18e2 * t3579 + 0.5e1 / 0.12e2 * t3584 + 0.5e1 / 0.24e2 * t3588;
  tv4rho3sigma0 = t12746 + t12759 + t12773 + t12787;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t12799 = 0.11e3 / 0.27e2 * t3425;
  t12801 = 0.6e1 * t3612 + 0.3e1 * t3623 - 0.35e3 / 0.81e2 * t3402 + 0.5e2 / 0.27e2 * t3406 + 0.25e2 / 0.27e2 * t3409 + 0.25e2 / 0.54e2 * t3412 - 0.5e1 / 0.12e2 * t3414 + 0.2e2 / 0.9e1 * t3416 + 0.2e2 / 0.9e1 * t3418 - 0.5e3 / 0.27e2 * t3421 - t12799 - 0.5e1 / 0.12e2 * t3427;
  t12807 = 0.154e4 / 0.243e3 * t12510;
  t12810 = 0.154e5 / 0.2187e4 * t12519;
  t12819 = -0.4e4 / 0.243e3 * t12502 + 0.5e3 / 0.243e3 * t12506 - t12807 + 0.5e3 / 0.27e2 * t12512 - 0.4e4 / 0.81e2 * t12515 + t12810 - 0.1e5 / 0.729e3 * t12522 - 0.22e4 / 0.243e3 * t12525 + 0.1e6 / 0.6561e4 * t12529 + 0.2e5 / 0.729e3 * t12533 - 0.25e4 / 0.243e3 * t12537 + 0.2e3 / 0.81e2 * t12539 - 0.25e2 / 0.81e2 * t12541 + 0.44e5 / 0.729e3 * t12545;
  t12833 = -0.5e3 / 0.81e2 * t12297 - 0.5e3 / 0.243e3 * t12301 + t12819 * t146 + 0.25e2 / 0.162e3 * t12305 + 0.7e2 / 0.9e1 * t12307 + 0.22e4 / 0.243e3 * t12310 - 0.1e3 / 0.81e2 * t12314 - 0.4e3 / 0.81e2 * t12316 - 0.4e3 / 0.81e2 * t12318 - 0.2e3 / 0.81e2 * t12320 + 0.25e2 / 0.54e2 * t12323 + 0.25e2 / 0.27e2 * t12325 + 0.35e3 / 0.81e2 * t12330 - 0.25e2 / 0.27e2 * t12334 - 0.25e2 / 0.54e2 * t12339;
  t12849 = -0.25e2 / 0.54e2 * t12345 + 0.25e4 / 0.729e3 * t12354 + 0.25e4 / 0.243e3 * t12358 - 0.44e5 / 0.729e3 * t12363 + 0.5e1 / 0.12e2 * t12365 + 0.5e1 / 0.6e1 * t12367 + 0.25e2 / 0.27e2 * t12370 + 0.5e3 / 0.81e2 * t12374 - 0.1e4 / 0.81e2 * t12377 - 0.595e3 / 0.54e2 * t12379 + 0.25e2 / 0.27e2 * t12381 + 0.25e2 / 0.162e3 * t12384 + 0.25e2 / 0.54e2 * t12387 + 0.5e2 / 0.27e2 * t12389 - 0.5e1 / 0.36e2 * t12392;
  t12862 = 0.154e5 / 0.2187e4 * t12426;
  t12863 = 0.595e4 / 0.243e3 * t12430;
  t12864 = 0.595e3 / 0.27e2 * t12433;
  t12866 = -0.5e1 / 0.12e2 * t12396 - 0.5e1 / 0.12e2 * t12398 - 0.11e3 / 0.27e2 * t12400 - 0.5e1 / 0.36e2 * t12402 - 0.5e1 / 0.12e2 * t12404 - 0.5e1 / 0.12e2 * t12406 - 0.5e1 / 0.36e2 * t12408 - 0.11e3 / 0.27e2 * t12410 + 0.25e2 / 0.27e2 * t12415 - 0.5e2 / 0.27e2 * t12418 + 0.11e4 / 0.243e3 * t12422 - t12862 + t12863 - t12864 - 0.1e3 / 0.81e2 * t12436;
  t12883 = -0.2e3 / 0.81e2 * t12440 - 0.595e3 / 0.54e2 * t12443 + 0.7e2 / 0.9e1 * t12446 + 0.35e2 / 0.18e2 * t12448 - 0.5e1 / 0.6e1 * t12450 + 0.35e2 / 0.9e1 * t12452 - 0.5e1 / 0.3e1 * t12454 + 0.7e4 / 0.243e3 * t12458 + 0.25e2 / 0.27e2 * t12461 + 0.5e1 / 0.3e1 * t12466 - 0.5e3 / 0.27e2 * t12468 + 0.4e4 / 0.81e2 * t12471 - 0.5e3 / 0.27e2 * t12473 - 0.175e3 / 0.81e2 * t12476 + 0.25e2 / 0.27e2 * t12479 - 0.1e6 / 0.6561e4 * t12484;
  t12901 = 0.25e2 / 0.54e2 * t12490 + 0.25e2 / 0.162e3 * t12493 + 0.1e5 / 0.729e3 * t12496 + 0.5e1 / 0.3e1 * t12498 + 0.35e2 / 0.9e1 * t12551 - 0.7e2 / 0.9e1 * t12554 - 0.35e3 / 0.81e2 * t12559 + 0.5e2 / 0.27e2 * t12562 - 0.5e1 / 0.3e1 * t12566 + 0.5e1 / 0.6e1 * t12571 - 0.5e1 / 0.6e1 * t12573 - 0.5e1 / 0.6e1 * t12577 - 0.5e1 / 0.6e1 * t12581 + 0.25e4 / 0.243e3 * t12583 + 0.25e4 / 0.243e3 * t12586;
  t12916 = 0.154e4 / 0.243e3 * t12616;
  t12918 = 0.35e2 / 0.9e1 * t12622;
  t12919 = 0.35e2 / 0.18e2 * t12589 + 0.5e1 / 0.6e1 * t12594 + t428 * t2322 - 0.5e3 / 0.81e2 * t12597 + 0.3e1 * t1202 * t791 - 0.5e3 / 0.81e2 * t12601 - 0.5e3 / 0.81e2 * t12604 - 0.5e3 / 0.81e2 * t12607 - 0.5e3 / 0.27e2 * t12609 + 0.3e1 * t3622 * t316 + 0.1e2 / 0.9e1 * t12611 + 0.2e2 / 0.9e1 * t12613 + t12916 + 0.1e2 / 0.9e1 * t12618 + t12918;
  t12936 = 0.8e4 / 0.243e3 * t12625 + 0.8e4 / 0.243e3 * t12630 + 0.4e4 / 0.243e3 * t12634 - 0.5e3 / 0.81e2 * t12637 - 0.1e4 / 0.81e2 * t12640 - 0.5e1 / 0.6e1 * t12642 - 0.5e1 / 0.6e1 * t12646 + 0.2975e4 / 0.243e3 * t12653 - 0.7e3 / 0.81e2 * t12657 - 0.25e2 / 0.27e2 * t12661 + 0.5e2 / 0.27e2 * t12664 + 0.25e2 / 0.54e2 * t12667 - 0.2e5 / 0.729e3 * t12672 + 0.25e2 / 0.27e2 * t12676 - 0.35e3 / 0.81e2 * t12679;
  t12953 = 0.25e2 / 0.27e2 * t12682 + 0.25e2 / 0.81e2 * t12684 + 0.25e2 / 0.27e2 * t12686 - 0.5e1 / 0.36e2 * t12690 - 0.5e1 / 0.6e1 * t12694 - 0.5e3 / 0.81e2 * t12698 + 0.11e4 / 0.243e3 * t12701 + 0.5e1 / 0.6e1 * t12705 + 0.5e1 / 0.12e2 * t12707 + 0.5e1 / 0.36e2 * t12711 + 0.595e3 / 0.54e2 * t12715 - 0.35e2 / 0.9e1 * t12717 - 0.35e2 / 0.18e2 * t12720 + 0.5e1 / 0.12e2 * t12724 + 0.5e1 / 0.12e2 * t12729 - 0.35e2 / 0.9e1 * t12732;
  t12961 = 0.5e1 / 0.6e1 * t3446;
  t12968 = -0.5e1 / 0.6e1 * t3429 + t9 * (t12833 + t12849 + t12866 + t12883 + t12901 + t12919 + t12936 + t12953) - 0.1e4 / 0.81e2 * t3435 - 0.5e3 / 0.81e2 * t3439 - 0.1e4 / 0.81e2 * t3442 - t12961 + 0.8e4 / 0.243e3 * t3451 - 0.25e2 / 0.27e2 * t3456 + 0.3e1 * t3642 + 0.25e4 / 0.243e3 * t3491 + 0.5e1 / 0.3e1 * t3496 + 0.5e1 / 0.6e1 * t3498;
  t12972 = 0.595e3 / 0.54e2 * t3511;
  t12973 = 0.7e2 / 0.9e1 * t3514;
  t12976 = 0.11e4 / 0.243e3 * t3525;
  t12982 = -0.5e1 / 0.6e1 * t3503 - 0.5e1 / 0.3e1 * t3507 - t12972 + t12973 - 0.2e3 / 0.81e2 * t3517 - 0.2e3 / 0.81e2 * t3521 + t12976 + 0.35e2 / 0.9e1 * t3527 + 0.25e2 / 0.54e2 * t3530 + 0.25e2 / 0.27e2 * t3533 + 0.25e2 / 0.54e2 * t3537 + 0.5e2 / 0.27e2 * t3539;
  t12996 = 0.5e2 / 0.27e2 * t3541 + 0.25e2 / 0.27e2 * t3544 - 0.4e3 / 0.81e2 * t3547 - 0.5e1 / 0.12e2 * t3550 - 0.5e1 / 0.6e1 * t3552 - 0.5e3 / 0.81e2 * t3558 + 0.35e2 / 0.9e1 * t3561 - 0.5e1 / 0.3e1 * t3565 - 0.5e1 / 0.12e2 * t3569 + 0.25e2 / 0.27e2 * t3575 - 0.35e2 / 0.9e1 * t3579 + 0.5e1 / 0.6e1 * t3584 + 0.5e1 / 0.12e2 * t3588;
  tv4rho3sigma1 = t12801 + t12968 + t12982 + t12996;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  tv4rho3sigma2 = tv4rho3sigma0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t12998 = 0.2e1 * t3679;
  t13001 = t6503 * t8369 * t6852 * t3453;
  t13004 = t190 * t2586 * t1128;
  t13007 = t190 * t871 * t3535;
  t13009 = t1113 * t2563;
  t13012 = t2522 * t50 * t410;
  t13014 = t1136 * t3837;
  t13016 = t3573 * t6270;
  t13017 = t3571 * t13016;
  t13019 = 0.22e4 / 0.729e3 * t12310;
  t13024 = t3546 * t904;
  t13025 = 0.2e3 / 0.243e3 * t13024;
  t13026 = t3817 * t3408;
  t13028 = 0.25e2 / 0.81e2 * t13001 + 0.25e2 / 0.162e3 * t13004 + 0.25e2 / 0.324e3 * t13007 + 0.25e2 / 0.162e3 * t13009 - 0.5e1 / 0.72e2 * t13012 + 0.5e1 / 0.36e2 * t13014 + 0.25e2 / 0.162e3 * t13017 + t13019 - 0.5e2 / 0.243e3 * t12314 - 0.2e3 / 0.243e3 * t12316 - 0.2e3 / 0.243e3 * t12318 - 0.1e3 / 0.243e3 * t12320 - t13025 + 0.25e2 / 0.81e2 * t13026;
  t13030 = t1141 * t1143 * t2570;
  t13032 = t842 * t185;
  t13034 = t13032 * t1140 * t1144;
  t13036 = t3464 * t2555;
  t13037 = t13036 * t2559;
  t13039 = t10375 * t3490;
  t13041 = t10365 * t3490;
  t13043 = t181 * t185;
  t13044 = t13043 * t1140;
  t13045 = t13044 * t3859;
  t13047 = t553 * t3857;
  t13049 = t1141 * t1354 * t13047;
  t13052 = t194 * t841 * t209;
  t13054 = t1141 * t1354 * t13052;
  t13058 = t2556 * t3488 * t841 * t3853;
  t13060 = t10223 * t3854;
  t13064 = t399 * t2534;
  t13065 = t13064 * t2537;
  t13067 = 0.22e4 / 0.729e3 * t12525;
  t13068 = t12524 * t391;
  t13070 = t12514 * t963;
  t13071 = 0.4e4 / 0.243e3 * t13070;
  t13072 = t3464 * t2541;
  t13074 = t3464 * t2545;
  t13078 = t805 * t806 * t177 * t841;
  t13079 = 0.4e4 / 0.729e3 * t13078;
  t13080 = -0.2e4 / 0.729e3 * t12502 - t12511 - 0.2e4 / 0.243e3 * t12515 - 0.5e4 / 0.729e3 * t13065 + t12520 - t13067 - 0.11e4 / 0.729e3 * t13068 - t13071 + 0.5e3 / 0.81e2 * t13072 + 0.25e3 / 0.81e2 * t13074 - t13079;
  t13083 = t805 * t806 * t35 * t2521;
  t13088 = t2535 * t3736 * t180 * t50;
  t13092 = t2535 * t1240 * t522 * t50;
  t13096 = t9560 * t1240 * t527 * t189;
  t13100 = t2535 * t3732 * t180 * t50;
  t13101 = 0.2e5 / 0.2187e4 * t13100;
  t13102 = t1168 * t2549;
  t13106 = t805 * t806 * t58 * t350;
  t13108 = t3461 * t967;
  t13109 = 0.2e3 / 0.243e3 * t13108;
  t13111 = 0.44e5 / 0.2187e4 * t12545;
  t13112 = 0.25e3 / 0.243e3 * t13083 + 0.1e5 / 0.2187e4 * t12533 - 0.25e4 / 0.729e3 * t13088 - 0.125e4 / 0.729e3 * t13092 + 0.5e5 / 0.6561e4 * t13096 + t13101 - 0.25e2 / 0.162e3 * t13102 + 0.22e5 / 0.2187e4 * t13106 + t13109 + 0.1e3 / 0.243e3 * t12539 + t13111;
  t13116 = t190 * t3573 * t355;
  t13119 = t543 * t317 * t3686;
  t13120 = 0.4e4 / 0.729e3 * t13119;
  t13123 = t543 * t147 * t12360 * t350;
  t13126 = t543 * t217 * t3686;
  t13127 = 0.4e4 / 0.729e3 * t13126;
  t13128 = 0.25e2 / 0.162e3 * t13030 + 0.25e2 / 0.81e2 * t13034 + 0.5e4 / 0.729e3 * t13037 + 0.125e4 / 0.729e3 * t13039 + 0.125e4 / 0.729e3 * t13041 - 0.25e2 / 0.81e2 * t13045 - 0.25e2 / 0.162e3 * t13049 - 0.25e2 / 0.162e3 * t13054 + 0.25e4 / 0.729e3 * t13058 + 0.25e4 / 0.729e3 * t13060 + (t13080 + t13112) * t146 + 0.25e2 / 0.162e3 * t13116 + t13120 - 0.22e5 / 0.2187e4 * t13123 + t13127;
  t13130 = t3798 * t1162;
  t13132 = t1224 * t3568;
  t13135 = t407 * t1147 * t3794;
  t13136 = 0.35e2 / 0.54e2 * t13135;
  t13138 = t543 * t594 * t1213;
  t13141 = t543 * t792 * t1213;
  t13144 = t543 * t383 * t3449;
  t13145 = 0.4e4 / 0.729e3 * t13144;
  t13146 = t1109 * t542;
  t13147 = t13146 * t855;
  t13148 = 0.4e4 / 0.243e3 * t13147;
  t13150 = t543 * t317 * t3703;
  t13154 = t543 * t147 * t1120 * t2521;
  t13157 = t543 * t892 * t1121;
  t13160 = t543 * t896 * t1121;
  t13163 = t543 * t365 * t3437;
  t13166 = t543 * t907 * t1121;
  t13169 = t543 * t952 * t1121;
  t13172 = t543 * t590 * t1213;
  t13174 = -0.5e1 / 0.36e2 * t13130 - 0.5e1 / 0.72e2 * t13132 + t13136 - 0.5e3 / 0.243e3 * t13138 - 0.25e3 / 0.243e3 * t13141 + t13145 + t13148 - 0.5e3 / 0.243e3 * t13150 - 0.25e3 / 0.243e3 * t13154 - 0.5e3 / 0.243e3 * t13157 - 0.5e3 / 0.243e3 * t13160 - 0.25e3 / 0.243e3 * t13163 - 0.5e3 / 0.243e3 * t13166 - 0.5e3 / 0.243e3 * t13169 - 0.25e3 / 0.243e3 * t13172;
  t13176 = t543 * t383 * t3437;
  t13178 = t3420 * t2619;
  t13180 = t3420 * t2622;
  t13182 = t3420 * t2633;
  t13184 = t10050 * t3704;
  t13187 = t543 * t217 * t3703;
  t13190 = t190 * t2337 * t1220;
  t13193 = t190 * t549 * t3769;
  t13196 = t190 * t10206 * t403;
  t13200 = t322 * t3810;
  t13204 = t154 * t1338 * t4917 * t209;
  t13207 = t1141 * t3404 * t903;
  t13208 = 0.25e2 / 0.81e2 * t13207;
  t13210 = t1141 * t3400 * t903;
  t13211 = 0.175e3 / 0.243e3 * t13210;
  t13212 = -0.25e3 / 0.243e3 * t13176 - 0.5e3 / 0.81e2 * t13178 - 0.5e3 / 0.81e2 * t13180 - 0.25e3 / 0.81e2 * t13182 - 0.5e3 / 0.81e2 * t13184 - 0.5e3 / 0.243e3 * t13187 + 0.25e2 / 0.324e3 * t13190 + 0.25e2 / 0.162e3 * t13193 + 0.25e2 / 0.324e3 * t13196 + 0.175e3 / 0.243e3 * t12330 + t1244 * t791 - 0.5e1 / 0.18e2 * t13200 - 0.5e1 / 0.18e2 * t13204 + t13208 - t13211;
  t13216 = t1141 * t3404 * t861;
  t13217 = 0.25e2 / 0.81e2 * t13216;
  t13219 = t1141 * t3404 * t865;
  t13220 = 0.25e2 / 0.81e2 * t13219;
  t13223 = 0.44e5 / 0.2187e4 * t12363;
  t13227 = t46 * t55 * t1142 * t382;
  t13229 = t352 * t3445;
  t13233 = t543 * t147 * t3448 * t841;
  t13234 = 0.4e4 / 0.729e3 * t13233;
  t13236 = t543 * t365 * t3449;
  t13237 = 0.4e4 / 0.729e3 * t13236;
  t13240 = t154 * t4174 * t1514 * t575;
  t13243 = t154 * t4340 * t3809;
  t13244 = 0.5e1 / 0.9e1 * t13243;
  t13246 = 0.595e3 / 0.162e3 * t12379;
  t13247 = 0.11e3 / 0.81e2 * t12400;
  t13248 = 0.11e3 / 0.81e2 * t12410;
  t13249 = t13217 + t13220 + 0.2e1 * t1179 * t951 - t13223 + t420 * t2736 - 0.5e1 / 0.36e2 * t13227 - 0.5e1 / 0.36e2 * t13229 + t13234 + t13237 + 0.5e1 / 0.12e2 * t13240 - t13244 + 0.5e3 / 0.243e3 * t12377 - t13246 - t13247 - t13248;
  t13250 = t3424 * t384;
  t13252 = t365 * t1120;
  t13253 = t9261 * t13252;
  t13255 = t383 * t1120;
  t13256 = t9261 * t13255;
  t13258 = t3424 * t366;
  t13262 = t1141 * t4139 * t3858;
  t13263 = 0.25e2 / 0.81e2 * t13262;
  t13264 = t4922 * t326;
  t13266 = t1141 * t1354 * t13264;
  t13268 = t1514 * t810;
  t13270 = t1141 * t1354 * t13268;
  t13273 = t194 * t350 * t583;
  t13275 = t1141 * t1354 * t13273;
  t13277 = t4917 * t326;
  t13279 = t1141 * t1354 * t13277;
  t13282 = t522 * t40 * t152;
  t13284 = t2556 * t3851 * t13282;
  t13288 = t527 * t185 * t800;
  t13290 = t10215 * t12481 * t350 * t13288;
  t13293 = t1141 * t4156 * t3858;
  t13294 = 0.175e3 / 0.243e3 * t13293;
  t13296 = 0.11e4 / 0.729e3 * t12422;
  t13297 = -0.55e2 / 0.81e2 * t13250 - 0.25e3 / 0.81e2 * t13253 - 0.25e3 / 0.81e2 * t13256 - 0.55e2 / 0.81e2 * t13258 + t3485 * t382 - t13263 - 0.25e2 / 0.162e3 * t13266 - 0.25e2 / 0.324e3 * t13270 - 0.25e2 / 0.324e3 * t13275 - 0.25e2 / 0.162e3 * t13279 + 0.125e4 / 0.729e3 * t13284 - 0.5e5 / 0.6561e4 * t13290 + t13294 + 0.25e2 / 0.81e2 * t12418 + t13296;
  t13299 = 0.595e3 / 0.162e3 * t12433;
  t13302 = 0.595e3 / 0.162e3 * t12443;
  t13310 = 0.25e2 / 0.81e2 * t12461;
  t13314 = t190 * t193 * t10144 * t35;
  t13316 = -t12427 + t12431 - t13299 - 0.5e2 / 0.243e3 * t12436 - 0.1e3 / 0.243e3 * t12440 - t13302 + 0.35e2 / 0.108e3 * t12448 + 0.5e1 / 0.36e2 * t12450 + 0.35e2 / 0.54e2 * t12452 + 0.5e1 / 0.18e2 * t12454 + 0.35e4 / 0.729e3 * t12458 + 0.2e1 * t3741 * t316 - t13310 - 0.5e1 / 0.18e2 * t12466 + 0.25e2 / 0.324e3 * t13314;
  t13317 = t1110 * t897;
  t13318 = 0.1e2 / 0.27e2 * t13317;
  t13319 = t1110 * t908;
  t13320 = 0.1e2 / 0.27e2 * t13319;
  t13321 = t1110 * t953;
  t13322 = 0.1e2 / 0.27e2 * t13321;
  t13323 = t400 * t2750;
  t13326 = t1110 * t893;
  t13327 = 0.1e2 / 0.27e2 * t13326;
  t13328 = t400 * t2739;
  t13330 = t400 * t2746;
  t13335 = t1136 * t3783;
  t13336 = 0.35e2 / 0.54e2 * t13335;
  t13340 = t13318 + t1