package org.ojalgo.data.domain.finance;

/**
 * Covariance matrices with very small or negative eigenvalues, ill-conditioned and rank deficient.
 *
 * @author apete
 */
public class DirtyCovarianceMatrices {

    public static final double[][] NextGen50 = {
            { 0.04312632038848195, 0.008990339049150475, 0.013192208656533297, -0.007833985877645909, 0.020500008229238746, 0.02420446154110742,
                    0.009891656058354526, 0.02389839740075915, 0.020328267754327937, 0.0228070819114734, 0.02004372818258459, 0.01695120655806672,
                    0.009768090297020741, 0.022961439823574542, 0.05383201066872385, -0.0026346415908305985, -0.0049310999539852575, 0.01680449042767687,
                    -1.7823836301908191E-4, 0.01863517320289796, 0.02632880979559205, 0.027801692639412057, 0.007689643131863631, 0.00850530732788321,
                    0.022220988957982434, 0.022543406793452736, 0.049430123761922365, 0.003611593828777843, 0.017379550392114203, 0.021819187456931698,
                    0.03354135528091716, 0.03865967331467245, 0.015006993380768024, 0.026279015146140006, 0.02838791248619882, 0.0288793474177683,
                    0.01625686413164755, 0.03607588514977384, 0.02182792160563759, 0.0019401081530628272, 0.023088019874954985, 0.021847682491973844,
                    0.01740765458208289, 0.014052347883703707, 0.014661111108107102, 0.0235625379068616, 0.0063519290166566805, 0.02266275927162538,
                    0.015704650036742693, -0.001513963523137642 },
            { 0.008990339049150475, 0.1272355671979538, 0.01813163054473969, -0.014723264751207714, 0.0040989031011881135, 0.013104717632063,
                    0.02526572834464741, 0.017297768815648647, -0.01753030433783295, 0.0037655273426886763, -0.00520410108393609, 0.004242632327914585,
                    0.00997218959951539, 0.03437082437363451, 0.04954747537398849, -4.992879256927452E-4, 0.0018139797620880904, 0.0018379159810954651,
                    0.003828872881436076, 0.002821686418573448, -0.014419811058160998, -0.008103888202760933, 0.00299000268199122, -0.014935204156242037,
                    0.016849818961366208, 0.023197636218853044, 0.009321724903227567, 0.02037324757920066, 0.004564097767417989, 0.007482647984382173,
                    0.02642050111316805, 0.01443627021726802, 0.005890088119023589, 0.03174529101131612, 0.008093639690790678, 0.013172605013065924,
                    0.00974349144048374, -5.5497997313984354E-5, 0.05286629641047535, 0.018091003173312758, 0.007827242720433567, 0.018425128521131803,
                    0.0426802648820412, 0.01128235024313989, 0.006603758972640087, 0.00287525803416068, 0.012220214518728657, 0.008778958864425828,
                    0.001511274203118489, -0.0018951088193391312 },
            { 0.013192208656533297, 0.01813163054473969, 0.13925377584607582, 0.03503771871472622, 0.011199024953559088, 0.010555985974146103,
                    0.02212413876066048, 0.02243272834811884, 0.01334910388427259, 0.01567852103501621, 0.018366978957103878, -1.4696224291150465E-4,
                    0.010166790129018203, 0.05453986316125295, 0.04585474266331463, 0.02256704130382305, 0.01592500149257674, 0.012805240880673379,
                    0.01457888526768961, 0.0024229424117210123, 0.04934303338552469, 0.0074612462636722155, 0.029663285514259063, -0.008301390435044765,
                    0.012928185333559414, 0.027397185404454443, 0.027677454574692284, 0.05541211779758087, 0.014183075732577956, 0.04676318885977255,
                    0.06203027347756032, 0.028476950818287626, 0.012498355056786446, 0.010734767848367452, 0.029636453900777647, 0.014188623540477088,
                    0.015331838784994736, -0.010038208799509875, 0.04795962400012498, 3.6014013917668353E-4, 0.008890898145824498, -0.02406280430614031,
                    0.009145542037329701, 0.016835470685292845, 0.012578271302337022, -2.4490975743401974E-5, 0.025552078098515195, 0.010855233647302861,
                    0.015937426008268245, 0.0056781970835267336 },
            { -0.007833985877645909, -0.014723264751207714, 0.03503771871472622, 0.058328730465364166, 0.010947110391587895, 0.008328216125237122,
                    -0.0054321160989318825, 0.007546634768565125, 0.012840013311469958, 0.016703577978151484, 0.011712093264799873, 0.011463301986072337,
                    0.008739594426691737, 0.0269954951404353, -0.0016938569400365778, 0.023389941905871597, 0.019148360652700362, 0.01700600332799508,
                    0.014590967274885985, 0.008410650403588817, 0.01234906379575084, 0.009882462701426276, 0.016964222302126814, 0.014222963959067317,
                    0.010553356301384795, 0.02155651504277101, 0.010418312292841762, 0.024387538268198908, 0.009572751658816821, 0.01852870330490414,
                    0.009846270183162253, 0.011538607439610323, 0.013166870243799037, 0.006562905476844442, 0.012885815449847723, 0.013194205061238282,
                    0.008899182232958281, 0.005068563598278567, 0.012808823788731227, 0.006327065521531838, 0.006895920230353253, -0.01578544340884814,
                    0.013835190611388043, 0.013270244552979586, 0.005748084954197917, 0.007146186580464384, 0.012540192115472191, 0.011034607240664006,
                    0.0152520817434781, 0.014597506659684484 },
            { 0.020500008229238746, 0.0040989031011881135, 0.011199024953559088, 0.010947110391587895, 0.06087364290525597, 0.020308834892221572,
                    0.015625320836382565, 0.03102563036433139, 0.020536961048443568, 0.02136383228641389, 0.03149309730389599, 0.01914022336288028,
                    0.020900440143944606, 0.038791539673066304, 0.036798879672197034, -0.0010804069832201538, 0.002312958558186094, 0.022561510517235008,
                    0.01143780637628256, 0.011759896162418074, 0.03170685825596954, 0.02398992763847973, 0.016609864286174177, 0.002941260307708972,
                    0.01908031861114843, 0.027007487323394377, 0.02511899983087179, 0.02541804342228997, 0.021927053012076685, 0.008390374311427466,
                    0.02114550356461528, 0.0380306842276163, 0.023377112930532754, 0.03167574170398588, 0.014372510950062053, 0.03418000918492228,
                    0.0199843928153421, 0.021992698393771402, 0.018493037307030762, 0.01916444672150664, 0.022374283744879462, 0.02348699863642628,
                    0.02555899944899036, 0.024087534936220456, 0.02523216350104818, 0.02572983465713241, 0.017460924262885272, 0.02963525358853074,
                    0.0196681585661115, -5.711492813201779E-4 },
            { 0.02420446154110742, 0.013104717632063, 0.010555985974146103, 0.008328216125237122, 0.020308834892221572, 0.04614948793253021,
                    0.012629367570193745, 0.026802075114732413, 0.014564761047202626, 0.017094569789345017, 0.011881648433542055, 0.028117476246392322,
                    0.011002011532779368, 0.028413358634544278, 0.035683954430578535, 7.633601440450236E-4, 0.002759026790886839, 0.027956346187701264,
                    0.008983072305105371, 0.015971156912552333, 0.017715498519991324, 0.027814500725737608, 0.006067493383868996, 0.009638634188762759,
                    0.021652375514109985, 0.015761024826586176, 0.04072872266798379, 0.005924436766867023, 0.017263731657635034, 0.017563042748778762,
                    0.03329892474969793, 0.02413031814991255, 0.014254057677468797, 0.02757586019317899, 0.031419027101342915, 0.026197618466788735,
                    0.019221034476130452, 0.0313198701334376, 0.025499998497679702, 0.010918540853198135, 0.02031996532199529, 0.015392723560923242,
                    0.02557642682695848, 0.01647591044046632, 0.009779204351658969, 0.006875878968911921, -0.0010121562145841796, 0.005979142722023696,
                    0.017903064848172084, 0.002085943533144139 },
            { 0.009891656058354526, 0.02526572834464741, 0.02212413876066048, -0.0054321160989318825, 0.015625320836382565, 0.012629367570193745,
                    0.04575544330046057, 0.02227190266041141, 0.001997466261522536, 0.003586479408830859, 0.007475416488889664, 0.0020852949547668633,
                    0.012811799922152098, 0.027910504216674164, 0.025859577374522113, -0.0033155574211125873, -0.001341812543636904, 0.004183667311456546,
                    0.012542774624082865, 0.005825650351453214, 0.013809250297130515, 0.004709702082556779, 0.009982872645754596, -0.005266533966957726,
                    0.006619978093880494, 0.014209316443921646, -0.004151296457832784, 0.01765062388361201, 0.010158029820702946, 0.013192988468284853,
                    0.01736742275169359, 4.4622338217344956E-4, 0.009702543787932784, 0.005367826132955238, 0.021048502062794964, 0.010157899272126606,
                    0.010081281227236765, 0.01501716178325315, 0.025854408075601035, 0.023219049133161758, 0.0066414009046200095, -0.006805700672259655,
                    0.01080938969249192, 0.012058330553673636, 0.00593917461759169, 0.004418583884501358, 0.012067712684570311, 0.017032385556474305,
                    0.003358830653472287, 0.003452977584111762 },
            { 0.02389839740075915, 0.017297768815648647, 0.02243272834811884, 0.007546634768565125, 0.03102563036433139, 0.026802075114732413,
                    0.02227190266041141, 0.04193620206754963, 0.01611514589781316, 0.02037547850628826, 0.015918269848680503, 0.01529525832645708,
                    0.013497863008971992, 0.04565039520375496, 0.04538176318490847, 0.00138446995319716, 0.001134635315427839, 0.025739751372317564,
                    0.011780417317725642, 0.01478016774551214, 0.03448690512122318, 0.023909689559595642, 0.016075456144607203, 5.578054402247617E-4,
                    0.020795683312548673, 0.0285860837220087, 0.031133360863982627, 0.018574147188804915, 0.0197488938047914, 0.021594901035735477,
                    0.04279523735927658, 0.031446815140279055, 0.021404592041793076, 0.02681315586176325, 0.02936019594714629, 0.029216309130148,
                    0.017992067941916164, 0.027890350880092084, 0.032385392089908316, 0.015010754778326162, 0.021617022673810726, 0.016269521253447557,
                    0.03107357443389102, 0.02407483556450472, 0.01720650553297241, 0.015990206407303097, 0.013426714867330457, 0.02130905733344067,
                    0.018089016306066085, -0.004217848608319288 },
            { 0.020328267754327937, -0.01753030433783295, 0.01334910388427259, 0.012840013311469958, 0.020536961048443568, 0.014564761047202626,
                    0.001997466261522536, 0.01611514589781316, 0.027877800488921554, 0.019551243122395572, 0.021296591535560072, 0.014594588399532309,
                    0.009954233359468594, 0.017179096950893154, 0.024705557080020285, 0.004825038290495026, 0.0018887039474713044, 0.015068224290784134,
                    2.2436106780152916E-4, 0.015879470803890874, 0.013478700833765678, 0.026357500617839202, 0.012110447633138434, 0.01580631571431286,
                    0.01429786147546954, 0.011636278789495032, 0.032268298143283594, 0.008444705793940889, 0.014888717446219224, 0.011625245632574471,
                    0.01890162416113364, 0.01949148144494491, 0.015492223670340418, 0.01984559172410914, 0.01816147420584803, 0.024679940599105662,
                    0.011708697858863854, 0.020160544070968074, 0.001813516301749397, 0.00446054770713945, 0.016211887715750196, 0.0124474695202667,
                    0.0125061765297089, 0.012820584755597171, 0.012657211389221386, 0.013221193190146016, 0.008800613809963966, 0.014364926330115293,
                    0.014088295678198585, 5.744021049862826E-4 },
            { 0.0228070819114734, 0.0037655273426886763, 0.01567852103501621, 0.016703577978151484, 0.02136383228641389, 0.017094569789345017,
                    0.003586479408830859, 0.02037547850628826, 0.019551243122395572, 0.03914292398740147, 0.022380299944484327, 0.010626590639157047,
                    0.010091620049135268, 0.03605506185466529, 0.03871844904966219, 0.0019800592298309027, -6.669749266673136E-5, 0.01308214641756243,
                    0.01017017706631437, 0.014094497693280125, 0.02248675608552466, 0.026968743248496203, 0.010041828575984636, 0.008576680557922394,
                    0.016695046944721938, 0.031934338241022285, 0.038559720063086896, 0.008410033016762783, 0.011112164158651542, 0.021362503940984046,
                    0.026628702903621508, 0.038184261717258895, 0.02160050371147406, 0.021035084043587456, 0.01881030826575375, 0.027988020663419655,
                    0.01202121842771234, 0.029665601186223953, 0.01557233972417593, 0.006428313418953551, 0.019323628983647166, 0.02130614309338997,
                    0.013304017263821483, 0.01961764120541732, 0.008410049037506232, 0.031038905440820358, 0.006133522606056485, 0.02706917016264846,
                    0.015496312179366718, 0.0013991936296724522 },
            { 0.02004372818258459, -0.00520410108393609, 0.018366978957103878, 0.011712093264799873, 0.03149309730389599, 0.011881648433542055,
                    0.007475416488889664, 0.015918269848680503, 0.021296591535560072, 0.022380299944484327, 0.04446746048106935, 0.01910369411860309,
                    0.013037760912621574, 0.030896238237157883, 0.03181034714933226, 0.002561754028214124, -0.0027844062352322847, 0.023997581442693067,
                    0.017321999002426182, 0.018096266313911046, 0.017940452773913033, 0.024242423924396468, 0.004857934374519019, 0.006560281962053749,
                    0.020455030404993135, 0.02762830306747755, 0.035627949697595605, 0.008021026368281892, 0.01314013626843511, 0.017009399793627002,
                    -0.0027441907123049976, 0.04125133310121215, 0.023968271941121968, 0.02851389115004403, 0.006890712503023871, 0.02530005947916317,
                    0.007986837805861072, 0.008600222397107631, 0.01818546505358175, 0.015081468905261065, 0.022532387739614357, 0.019108031118974134,
                    0.015244445592768024, 0.018452739647737873, 0.020598057749998497, 0.023463034128006724, 0.005988255754416581, 0.03791690255264783,
                    0.02371242965781328, -0.0024541495455922126 },
            { 0.01695120655806672, 0.004242632327914585, -1.4696224291150465E-4, 0.011463301986072337, 0.01914022336288028, 0.028117476246392322,
                    0.0020852949547668633, 0.01529525832645708, 0.014594588399532309, 0.010626590639157047, 0.01910369411860309, 0.06374405776056973,
                    0.009366846957758948, 0.012933741981466677, 0.014458450296678206, -0.005685842439866979, -0.008438126018183053, 0.028873083473027333,
                    0.01924851257089237, 0.011772431760404696, 0.007365003618086766, 0.02440140825881043, 0.0012304736431761145, 0.0032982867151250543,
                    0.015930593452980583, 0.016645920778646392, 0.036783241397670925, -0.01959754841874806, 0.011575777876964111, 0.001193338063306272,
                    0.001718358203466875, 0.02252926569733386, 0.008053148837810201, 0.02395478958501434, 0.014210692958089879, 0.02400873945537274,
                    0.01848577045035891, 0.018656998132920165, 0.00766852295773226, 0.01747125892218083, 0.019385100479800924, 0.021725384067406157,
                    0.027901009001847894, 0.01808519319017715, 0.011889591203301835, 0.015745480319644525, -0.0075437193284664215, 0.021196444727637254,
                    0.013255209497180951, -0.002031133745337114 },
            { 0.009768090297020741, 0.00997218959951539, 0.010166790129018203, 0.008739594426691737, 0.020900440143944606, 0.011002011532779368,
                    0.012811799922152098, 0.013497863008971992, 0.009954233359468594, 0.010091620049135268, 0.013037760912621574, 0.009366846957758948,
                    0.017851222970422253, 0.01797889331378685, 0.02284740448566174, 0.006272282994279287, 0.00505814249851424, 0.011759993774940414,
                    0.003930065864418544, 0.010670034011178824, 0.006074309230522152, 0.007899727998848893, 0.009049619484151382, 0.003486724347645951,
                    0.010902658860657497, 0.01035479117274491, 0.017091865247756476, 0.007928441281957096, 0.012305896383400303, 0.008154264921174506,
                    0.0049038614210523265, 0.01684824586059217, 0.010408467637307108, 0.009038171934969669, 0.013680352773746497, 0.012786672390198062,
                    0.012681133575323697, 0.00957266873830471, 0.010777540632164106, 0.010259174033270318, 0.010184755695669432, 0.0026147687378308,
                    0.005680056951686177, 0.012828090216758126, 0.008683638998333111, 0.00921410783353355, 0.008267845422722877, 0.01173422941775155,
                    0.00972520489639116, 0.007361760128319779 },
            { 0.022961439823574542, 0.03437082437363451, 0.05453986316125295, 0.0269954951404353, 0.038791539673066304, 0.028413358634544278,
                    0.027910504216674164, 0.04565039520375496, 0.017179096950893154, 0.03605506185466529, 0.030896238237157883, 0.012933741981466677,
                    0.01797889331378685, 0.10438636234925258, 0.06135129931163908, 0.008207112771026828, 0.004326109302836405, 0.013385130770495385,
                    0.02553644665127387, 0.01793394054878779, 0.04000461951893133, 0.023720470133393234, 0.024181074263911494, 4.4355775746032056E-4,
                    0.03018798567898231, 0.048303346066849245, 0.03797508535929306, 0.04412642511652486, 0.023308649207352962, 0.0412052746098861,
                    0.06034831311776109, 0.04847692608880712, 0.033190887845440865, 0.041770146772901175, 0.03033549704012808, 0.041946111768192566,
                    0.013791248907950623, 0.038054413888482165, 0.07315571092027119, 0.020389198435749278, 0.020732309060892965, 0.013149146188015094,
                    0.03363038446597429, 0.02882830912402931, 0.02147731330133211, 0.03382223812110682, 0.023445101214206926, 0.025605317239171456,
                    0.02856381827269984, 3.5704813583962816E-5 },
            { 0.05383201066872385, 0.04954747537398849, 0.04585474266331463, -0.0016938569400365778, 0.036798879672197034, 0.035683954430578535,
                    0.025859577374522113, 0.04538176318490847, 0.024705557080020285, 0.03871844904966219, 0.03181034714933226, 0.014458450296678206,
                    0.02284740448566174, 0.06135129931163908, 0.10952987940725903, -3.208223137236839E-4, -0.006086961970500603, 0.027481948822416537,
                    0.008202895237763564, 0.030844070411806486, 0.03904955570633169, 0.03910414431841645, 0.006575176429016128, 0.003937561988525,
                    0.03643400046891267, 0.03996349074517502, 0.0665414971754485, 0.019805208179047736, 0.023073451205345572, 0.04099519515793871,
                    0.06077393985868443, 0.06211702239556827, 0.03637750389981989, 0.05016063483861661, 0.03983583759339717, 0.04606207511405481,
                    0.027298170335996852, 0.04526989827532585, 0.061615065568199165, 0.007813195991701851, 0.038130408791341386, 0.03953580686912669,
                    0.04425480311595029, 0.03304122364224013, 0.02433918027177629, 0.029760387150223, 0.011203429134322467, 0.03453236219963221,
                    0.029946767058238993, -0.00478837336688735 },
            { -0.0026346415908305985, -4.992879256927452E-4, 0.02256704130382305, 0.023389941905871597, -0.0010804069832201538, 7.633601440450236E-4,
                    -0.0033155574211125873, 0.00138446995319716, 0.004825038290495026, 0.0019800592298309027, 0.002561754028214124, -0.005685842439866979,
                    0.006272282994279287, 0.008207112771026828, -3.208223137236839E-4, 0.02804460302270642, 0.022499003899712964, 0.01180804978362794,
                    -0.003027491283726166, 0.006385148320256874, 0.0031716359268973487, -0.0051899651585692345, 0.014345243333070704, 0.006592168709690913,
                    0.004861621677740768, 0.010969734961120761, 0.00844742740006384, 0.018214815953619748, 0.012701196929769695, 0.012824075790839384,
                    -0.00657003558471232, 0.008998032430886368, 0.0021473459528090696, -0.0034714635449605014, 0.005977113916260771, -0.0015246959052684212,
                    0.0032959181458816988, -0.0046858264912128435, 0.0015700452197944428, -0.004099750914280496, 0.0019017842099180828, -0.01602277791501922,
                    0.001133432032644065, 0.006588382185161595, 0.0031416417110126, -0.002101041153798418, 0.013493458010022948, -0.001042696694234923,
                    0.008071167763236298, 0.017480036928203727 },
            { -0.0049310999539852575, 0.0018139797620880904, 0.01592500149257674, 0.019148360652700362, 0.002312958558186094, 0.002759026790886839,
                    -0.001341812543636904, 0.001134635315427839, 0.0018887039474713044, -6.669749266673136E-5, -0.0027844062352322847, -0.008438126018183053,
                    0.00505814249851424, 0.004326109302836405, -0.006086961970500603, 0.022499003899712964, 0.024753568788564866, 0.008125506469515216,
                    -0.0042032787150076585, -4.6702680541266034E-4, 0.0014890167134376413, -0.006895177203892242, 0.015348452397924074, 0.005315267953461606,
                    0.001330054964435838, 0.0033909255995594736, 0.005893990211042725, 0.019852056889788063, 0.009797761960917811, 0.007833461197713543,
                    -0.0017367070573952165, 0.0026721578530772925, -6.934714820811162E-4, -0.00542966260423995, 0.002043023346559656, -0.003449397861085963,
                    0.002105150989001039, -0.005362131980266906, -0.002541187922865433, -8.994988810031339E-4, -2.0282038674842445E-4, -0.01185588284769239,
                    0.0022996146645568585, 0.0018092965490755992, 4.8757609949812745E-5, -0.004515591288787984, 0.013914486077396874, 9.440352756290071E-5,
                    0.005112955207958603, 0.017809321996539982 },
            { 0.01680449042767687, 0.0018379159810954651, 0.012805240880673379, 0.01700600332799508, 0.022561510517235008, 0.027956346187701264,
                    0.004183667311456546, 0.025739751372317564, 0.015068224290784134, 0.01308214641756243, 0.023997581442693067, 0.028873083473027333,
                    0.011759993774940414, 0.013385130770495385, 0.027481948822416537, 0.01180804978362794, 0.008125506469515216, 0.06598448187663888,
                    0.020410788287400186, 0.02068525054193091, 0.011301548623066399, 0.02344633741025142, 0.009142141477337537, 0.0015615167046013835,
                    0.026054752811503573, 0.01841384831954375, 0.0476039792901751, -0.011473920920818139, 0.015107788174686717, 0.017145511205990116,
                    -0.008409401873010664, 0.03562829381052402, 0.01837322394690706, 0.029113682120042658, 0.01720857135515176, 0.019038700841459474,
                    0.024590048064132862, 0.010462684202814808, 0.0035017906291575393, 0.010060035087643294, 0.022925632212073006, 0.04474454703489368,
                    0.05058245393652497, 0.02196308901275064, 0.01847663753589149, 0.006848502295165496, 8.821332595726583E-4, 0.016915225076385623,
                    0.025483528314634567, 0.005624473791648439 },
            { -1.7823836301908191E-4, 0.003828872881436076, 0.01457888526768961, 0.014590967274885985, 0.01143780637628256, 0.008983072305105371,
                    0.012542774624082865, 0.011780417317725642, 2.2436106780152916E-4, 0.01017017706631437, 0.017321999002426182, 0.01924851257089237,
                    0.003930065864418544, 0.02553644665127387, 0.008202895237763564, -0.003027491283726166, -0.0042032787150076585, 0.020410788287400186,
                    0.03730709846104698, 0.0045278686715332995, 0.012839614128098031, 0.006276996472944948, 0.0011961286293247473, -0.01103130608581348,
                    0.009731573404008525, 0.018056656136576952, 0.011997713298041562, -0.0020787723452855306, 0.002652481409066985, 0.011910773830258911,
                    -1.4863558744028434E-4, 0.01820375084769147, 0.01196075314699576, 0.009444341221462385, -8.750725038847081E-4, 0.007055775576655125,
                    0.0070206242222774495, 6.593513246663617E-4, 0.01990206383204848, 0.021183487327569403, 0.01182375445247322, 0.006622767856459763,
                    0.01046708437784738, 0.008882864596676107, 0.010740188144429563, 0.005481070770807478, -0.0022555010278700093, 0.025896482658818276,
                    0.014745864335852902, -0.0014071200617345417 },
            { 0.01863517320289796, 0.002821686418573448, 0.0024229424117210123, 0.008410650403588817, 0.011759896162418074, 0.015971156912552333,
                    0.005825650351453214, 0.01478016774551214, 0.015879470803890874, 0.014094497693280125, 0.018096266313911046, 0.011772431760404696,
                    0.010670034011178824, 0.01793394054878779, 0.030844070411806486, 0.006385148320256874, -4.6702680541266034E-4, 0.02068525054193091,
                    0.0045278686715332995, 0.02596689492200816, 0.002854592500305086, 0.02086345297025679, 0.0016708893613592536, 0.011124874798108156,
                    0.01892355233506745, 0.016842042629238333, 0.03230556158264338, -0.004213257826532223, 0.014866346021416127, 0.01770312320633867,
                    0.0060005950568043365, 0.02348660982083252, 0.017193695066834887, 0.021715189472744114, 0.017318812792816714, 0.019717581883267107,
                    0.011956459617217276, 0.020249967303806307, 0.020997714425856333, 0.0037993717619894795, 0.017438934284299778, 0.0184312868401266,
                    0.026218541014483822, 0.01521994621677613, 0.013237662041272854, 0.009958079171752553, 0.0019509067596749467, 0.005441577252885824,
                    0.016450581280423066, 0.004343511615173052 },
            { 0.02632880979559205, -0.014419811058160998, 0.04934303338552469, 0.01234906379575084, 0.03170685825596954, 0.017715498519991324,
                    0.013809250297130515, 0.03448690512122318, 0.013478700833765678, 0.02248675608552466, 0.017940452773913033, 0.007365003618086766,
                    0.006074309230522152, 0.04000461951893133, 0.03904955570633169, 0.0031716359268973487, 0.0014890167134376413, 0.011301548623066399,
                    0.012839614128098031, 0.002854592500305086, 0.07941392420978556, 0.015171097069817946, 0.015231625942372966, -0.008618302514792665,
                    0.009021658729466434, 0.04574040480645418, 0.022536635162822605, 0.02814870479986801, 0.016849367321475368, 0.029853093974998683,
                    0.05339822468046573, 0.03422839553662543, 0.014107232436968924, 0.0027516366805426483, 0.026029040485929952, 0.017657033527818028,
                    0.009000196536330763, 0.022094155288580733, 0.027606092392302453, 0.004179316902702262, 0.01903316642611587, -0.02213647761983185,
                    -0.005686391727211877, 0.02077996096755369, 0.015222521280940277, 0.01887596599749407, 0.011515211312171541, 0.032984837011846846,
                    0.011547993062065678, -0.007000622345030958 },
            { 0.027801692639412057, -0.008103888202760933, 0.0074612462636722155, 0.009882462701426276, 0.02398992763847973, 0.027814500725737608,
                    0.004709702082556779, 0.023909689559595642, 0.026357500617839202, 0.026968743248496203, 0.024242423924396468, 0.02440140825881043,
                    0.007899727998848893, 0.023720470133393234, 0.03910414431841645, -0.0051899651585692345, -0.006895177203892242, 0.02344633741025142,
                    0.006276996472944948, 0.02086345297025679, 0.015171097069817946, 0.04807100707480461, 0.0036697650969751703, 0.020597516570101428,
                    0.019829449077821623, 0.011785248377776775, 0.04560387257852573, 0.001812511433812315, 0.011618628694616905, 0.014817720811248884,
                    0.033962214661211756, 0.03065890010353193, 0.02993373751856449, 0.035136879034381, 0.023861706783309154, 0.03780664303450642,
                    0.015561904114229584, 0.027891136425231475, 0.017832709490990965, 0.008506584876284423, 0.02109357154041667, 0.03202558170707041,
                    0.033464146361256615, 0.014262486778107385, 0.014842255795510156, 0.024750626490851753, 0.0025805255452103224, 0.02209447169991283,
                    0.016043739582648212, -0.007610864783593404 },
            { 0.007689643131863631, 0.00299000268199122, 0.029663285514259063, 0.016964222302126814, 0.016609864286174177, 0.006067493383868996,
                    0.009982872645754596, 0.016075456144607203, 0.012110447633138434, 0.010041828575984636, 0.004857934374519019, 0.0012304736431761145,
                    0.009049619484151382, 0.024181074263911494, 0.006575176429016128, 0.014345243333070704, 0.015348452397924074, 0.009142141477337537,
                    0.0011961286293247473, 0.0016708893613592536, 0.015231625942372966, 0.0036697650969751703, 0.03306808400352563, 0.007675815243667566,
                    0.007766328078859309, 0.005842446844722785, 0.00775719007545952, 0.028016124859550517, 0.013663512173950839, 0.014432436076571716,
                    0.026780691349653406, 0.012368587312106345, 0.0018531553819608059, 0.00511078069618872, 0.020516707054191414, 0.013604649118136589,
                    0.013541372162265843, 0.00971329225493805, 0.0034592318502937487, 0.00770503112989151, 8.819070991140186E-4, -4.5583489349293373E-4,
                    0.008374070021325564, 0.010288546237463815, 0.008266796930948679, 0.012685536007551328, 0.02471145289354339, 0.006960840298794393,
                    0.006963518565645906, 0.012357257401250574 },
            { 0.00850530732788321, -0.014935204156242037, -0.008301390435044765, 0.014222963959067317, 0.002941260307708972, 0.009638634188762759,
                    -0.005266533966957726, 5.578054402247617E-4, 0.01580631571431286, 0.008576680557922394, 0.006560281962053749, 0.0032982867151250543,
                    0.003486724347645951, 4.4355775746032056E-4, 0.003937561988525, 0.006592168709690913, 0.005315267953461606, 0.0015615167046013835,
                    -0.01103130608581348, 0.011124874798108156, -0.008618302514792665, 0.020597516570101428, 0.007675815243667566, 0.03077985993245573,
                    0.006663088188199534, -0.008989030394432069, 0.011202927377785521, 0.0067906973396971, 0.003209677264245481, 0.005219172730176977,
                    0.011066800340903354, 0.0018824521409483439, 0.010688310345795508, 0.007071479124046502, 0.014154697052300904, 0.013604722637366336,
                    0.007104501658179762, 0.015747003945028742, -0.0015364140311595778, -0.003770991263225225, 0.002597775587038229, 0.004346891388492886,
                    0.00940108218803621, 7.729874408787671E-4, 0.001158743134795707, 0.013897365954290433, 0.007125490309728245, 1.577297194999271E-4,
                    0.0071400943830796, 0.007706197328753257 },
            { 0.022220988957982434, 0.016849818961366208, 0.012928185333559414, 0.010553356301384795, 0.01908031861114843, 0.021652375514109985,
                    0.006619978093880494, 0.020795683312548673, 0.01429786147546954, 0.016695046944721938, 0.020455030404993135, 0.015930593452980583,
                    0.010902658860657497, 0.03018798567898231, 0.03643400046891267, 0.004861621677740768, 0.001330054964435838, 0.026054752811503573,
                    0.009731573404008525, 0.01892355233506745, 0.009021658729466434, 0.019829449077821623, 0.007766328078859309, 0.006663088188199534,
                    0.025581956812529217, 0.023751796223287006, 0.037938135029506125, 0.009246888196645061, 0.015361602612979645, 0.019063228064062757,
                    0.018378767221634455, 0.031244453096607026, 0.017605185024254587, 0.03169424120629934, 0.021738209254196932, 0.02432344974648537,
                    0.013785374233316149, 0.01968036403126159, 0.02536807942323897, 0.009158718621249284, 0.019021632987611874, 0.022967120829526948,
                    0.02974293244856069, 0.015164361037898182, 0.015652517421060254, 0.011676787262939314, 0.0070586185843389115, 0.015317952985031292,
                    0.020087687596214276, 0.002038499328383774 },
            { 0.022543406793452736, 0.023197636218853044, 0.027397185404454443, 0.02155651504277101, 0.027007487323394377, 0.015761024826586176,
                    0.014209316443921646, 0.0285860837220087, 0.011636278789495032, 0.031934338241022285, 0.02762830306747755, 0.016645920778646392,
                    0.01035479117274491, 0.048303346066849245, 0.03996349074517502, 0.010969734961120761, 0.0033909255995594736, 0.01841384831954375,
                    0.018056656136576952, 0.016842042629238333, 0.04574040480645418, 0.011785248377776775, 0.005842446844722785, -0.008989030394432069,
                    0.023751796223287006, 0.09855986723915484, 0.034973020696177685, 0.023634050241024253, 0.020948130193494403, 0.0315316014627968,
                    0.018630965779294816, 0.03632647210389995, 0.02328991347526309, 0.01885014931160738, 0.015802751153542877, 0.022815931843985095,
                    0.0011863080950340393, 0.013993121847238658, 0.03900137781307372, 0.010658728023334304, 0.02985286708186641, -0.01837340281195142,
                    0.01830057496771731, 0.030987375225818826, 0.014300495863093577, 0.01933533672228807, 0.010524357674188151, 0.03794932456043361,
                    0.013039104912698017, -4.443375996753306E-4 },
            { 0.049430123761922365, 0.009321724903227567, 0.027677454574692284, 0.010418312292841762, 0.02511899983087179, 0.04072872266798379,
                    -0.004151296457832784, 0.031133360863982627, 0.032268298143283594, 0.038559720063086896, 0.035627949697595605, 0.036783241397670925,
                    0.017091865247756476, 0.03797508535929306, 0.0665414971754485, 0.00844742740006384, 0.005893990211042725, 0.0476039792901751,
                    0.011997713298041562, 0.03230556158264338, 0.022536635162822605, 0.04560387257852573, 0.00775719007545952, 0.011202927377785521,
                    0.037938135029506125, 0.034973020696177685, 0.10798451045504748, -0.009188240699914158, 0.026118863951467376, 0.035982479625548354,
                    0.03143894448264751, 0.06245383074803387, 0.03049582042123504, 0.04263041309120896, 0.02621123254630721, 0.0376866150501354,
                    0.023266082323617248, 0.03259176853622263, 0.029422210468970644, 0.0034036688595096044, 0.03828116923335393, 0.050849287515772376,
                    0.0447416638682924, 0.017631441077007613, 0.02040125304963042, 0.025974338205016288, 0.0013684360828060496, 0.028801419534579778,
                    0.033794089944894364, 0.004465217803507001 },
            { 0.003611593828777843, 0.02037324757920066, 0.05541211779758087, 0.024387538268198908, 0.02541804342228997, 0.005924436766867023,
                    0.01765062388361201, 0.018574147188804915, 0.008444705793940889, 0.008410033016762783, 0.008021026368281892, -0.01959754841874806,
                    0.007928441281957096, 0.04412642511652486, 0.019805208179047736, 0.018214815953619748, 0.019852056889788063, -0.011473920920818139,
                    -0.0020787723452855306, -0.004213257826532223, 0.02814870479986801, 0.001812511433812315, 0.028016124859550517, 0.0067906973396971,
                    0.009246888196645061, 0.023634050241024253, -0.009188240699914158, 0.08533258953697537, 0.016311698141659968, 0.018528299120093444,
                    0.04874287556038651, 0.008457666450866003, 0.012371619162882552, 0.01645469701001602, 0.018474582705894742, 0.015779990756756325,
                    6.760531079431115E-4, 0.010643784389611118, 0.03524741203150567, 0.012165034629777433, 0.004296142039002678, -0.04157489505724116,
                    -0.008454920693158417, 0.010290158792464588, 0.012401731068121943, 0.01081718185856954, 0.03729300629852992, 0.01590421502657845,
                    0.012403521718740268, 0.006496822714270262 },
            { 0.017379550392114203, 0.004564097767417989, 0.014183075732577956, 0.009572751658816821, 0.021927053012076685, 0.017263731657635034,
                    0.010158029820702946, 0.0197488938047914, 0.014888717446219224, 0.011112164158651542, 0.01314013626843511, 0.011575777876964111,
                    0.012305896383400303, 0.023308649207352962, 0.023073451205345572, 0.012701196929769695, 0.009797761960917811, 0.015107788174686717,
                    0.002652481409066985, 0.014866346021416127, 0.016849367321475368, 0.011618628694616905, 0.013663512173950839, 0.003209677264245481,
                    0.015361602612979645, 0.020948130193494403, 0.026118863951467376, 0.016311698141659968, 0.02638419862000057, 0.013039887280665519,
                    0.012859913735767035, 0.02645057798888749, 0.009204970670815328, 0.01619399142032954, 0.020502340797043765, 0.018942452643456724,
                    0.011024534808784086, 0.01480862641702484, 0.01480969007239338, 0.010764944595814889, 0.016045858950686734, 9.550512708569536E-4,
                    0.009519454142167387, 0.015402068774034768, 0.015370561204387238, 0.004389757181879901, 0.013265174918104292, 0.010813652773302637,
                    0.013074258770418653, 0.008368638792066126 },
            { 0.021819187456931698, 0.007482647984382173, 0.04676318885977255, 0.01852870330490414, 0.008390374311427466, 0.017563042748778762,
                    0.013192988468284853, 0.021594901035735477, 0.011625245632574471, 0.021362503940984046, 0.017009399793627002, 0.001193338063306272,
                    0.008154264921174506, 0.0412052746098861, 0.04099519515793871, 0.012824075790839384, 0.007833461197713543, 0.017145511205990116,
                    0.011910773830258911, 0.01770312320633867, 0.029853093974998683, 0.014817720811248884, 0.014432436076571716, 0.005219172730176977,
                    0.019063228064062757, 0.0315316014627968, 0.035982479625548354, 0.018528299120093444, 0.013039887280665519, 0.04084116411804799,
                    0.035127327885310325, 0.02891879893454374, 0.016347279367085247, 0.014514631297099914, 0.0260452903501711, 0.01603953163493417,
                    0.011045238529604708, 0.019550838169833183, 0.0392648615154301, 0.0018889703965769204, 0.015329940361266522, 0.002989145465401866,
                    0.020154417608086825, 0.01661992595694323, 0.00932116372768866, 0.014479096802646682, 0.010936385331627704, 0.013543399375383599,
                    0.020793466250702716, 0.00890230948876778 },
            { 0.03354135528091716, 0.02642050111316805, 0.06203027347756032, 0.009846270183162253, 0.02114550356461528, 0.03329892474969793,
                    0.01736742275169359, 0.04279523735927658, 0.01890162416113364, 0.026628702903621508, -0.0027441907123049976, 0.001718358203466875,
                    0.0049038614210523265, 0.06034831311776109, 0.06077393985868443, -0.00657003558471232, -0.0017367070573952165, -0.008409401873010664,
                    -1.4863558744028434E-4, 0.0060005950568043365, 0.05339822468046573, 0.033962214661211756, 0.026780691349653406, 0.011066800340903354,
                    0.018378767221634455, 0.018630965779294816, 0.03143894448264751, 0.04874287556038651, 0.012859913735767035, 0.035127327885310325,
                    0.1270660726631828, 0.02318657718245968, 0.02226722392912583, 0.029092061290044637, 0.05021617727446637, 0.038784402822659304,
                    0.016875262600282808, 0.03509100105431057, 0.05634143441311294, 0.002804751136383673, 0.013188230011377162, -0.003263422575509032,
                    0.021486858115968593, 0.012595143432008352, 0.012533314162456441, 0.014122224234236551, 0.022115711600265747, 0.00984569197890908,
                    0.00839196434000236, -0.011294032692972834 },
            { 0.03865967331467245, 0.01443627021726802, 0.028476950818287626, 0.011538607439610323, 0.0380306842276163, 0.02413031814991255,
                    4.4622338217344956E-4, 0.031446815140279055, 0.01949148144494491, 0.038184261717258895, 0.04125133310121215, 0.02252926569733386,
                    0.01684824586059217, 0.04847692608880712, 0.06211702239556827, 0.008998032430886368, 0.0026721578530772925, 0.03562829381052402,
                    0.01820375084769147, 0.02348660982083252, 0.03422839553662543, 0.03065890010353193, 0.012368587312106345, 0.0018824521409483439,
                    0.031244453096607026, 0.03632647210389995, 0.06245383074803387, 0.008457666450866003, 0.02645057798888749, 0.02891879893454374,
                    0.02318657718245968, 0.09161917401028148, 0.0303365745816392, 0.03696753349641792, 0.022330849500318484, 0.03848029452742715,
                    0.019488889125853226, 0.018172764163540866, 0.03434436409135776, 0.009548155974914728, 0.03426091283813539, 0.03832685856829979,
                    0.01934643079720676, 0.03189721754750205, 0.0285752309616072, 0.03583289717250668, 0.01081789987172843, 0.048655871683935474,
                    0.029860672431014083, 0.00347782821975552 },
            { 0.015006993380768024, 0.005890088119023589, 0.012498355056786446, 0.013166870243799037, 0.023377112930532754, 0.014254057677468797,
                    0.009702543787932784, 0.021404592041793076, 0.015492223670340418, 0.02160050371147406, 0.023968271941121968, 0.008053148837810201,
                    0.010408467637307108, 0.033190887845440865, 0.03637750389981989, 0.0021473459528090696, -6.934714820811162E-4, 0.01837322394690706,
                    0.01196075314699576, 0.017193695066834887, 0.014107232436968924, 0.02993373751856449, 0.0018531553819608059, 0.010688310345795508,
                    0.017605185024254587, 0.02328991347526309, 0.03049582042123504, 0.012371619162882552, 0.009204970670815328, 0.016347279367085247,
                    0.02226722392912583, 0.0303365745816392, 0.03309358326594752, 0.025096279876438126, 0.011256344050287916, 0.025219537519367802,
                    0.008974322977072326, 0.012905895034641653, 0.026736851608801793, 0.009148979240241889, 0.018926137658468054, 0.019265883553737134,
                    0.028599298400448548, 0.014700312152543145, 0.014611226182495649, 0.019551799791812017, 0.007135737025361431, 0.027564738009527447,
                    0.016148843396335495, -0.0025723170806437835 },
            { 0.026279015146140006, 0.03174529101131612, 0.010734767848367452, 0.006562905476844442, 0.03167574170398588, 0.02757586019317899,
                    0.005367826132955238, 0.02681315586176325, 0.01984559172410914, 0.021035084043587456, 0.02851389115004403, 0.02395478958501434,
                    0.009038171934969669, 0.041770146772901175, 0.05016063483861661, -0.0034714635449605014, -0.00542966260423995, 0.029113682120042658,
                    0.009444341221462385, 0.021715189472744114, 0.0027516366805426483, 0.035136879034381, 0.00511078069618872, 0.007071479124046502,
                    0.03169424120629934, 0.01885014931160738, 0.04263041309120896, 0.01645469701001602, 0.01619399142032954, 0.014514631297099914,
                    0.029092061290044637, 0.03696753349641792, 0.025096279876438126, 0.06802702703194734, 0.020755617649166964, 0.04435550846551548,
                    0.012379745368885958, 0.0276068324489131, 0.03577892261444826, 0.015291731601271707, 0.02242204513969833, 0.047727890536051566,
                    0.05270932588442152, 0.019621278415158986, 0.024021574854612815, 0.015435047699345415, 0.00830413028137543, 0.01846535538144016,
                    0.02606472618943749, -0.011144212669697692 },
            { 0.02838791248619882, 0.008093639690790678, 0.029636453900777647, 0.012885815449847723, 0.014372510950062053, 0.031419027101342915,
                    0.021048502062794964, 0.02936019594714629, 0.01816147420584803, 0.01881030826575375, 0.006890712503023871, 0.014210692958089879,
                    0.013680352773746497, 0.03033549704012808, 0.03983583759339717, 0.005977113916260771, 0.002043023346559656, 0.01720857135515176,
                    -8.750725038847081E-4, 0.017318812792816714, 0.026029040485929952, 0.023861706783309154, 0.020516707054191414, 0.014154697052300904,
                    0.021738209254196932, 0.015802751153542877, 0.02621123254630721, 0.018474582705894742, 0.020502340797043765, 0.0260452903501711,
                    0.05021617727446637, 0.022330849500318484, 0.011256344050287916, 0.020755617649166964, 0.055200532186913516, 0.027336386421487814,
                    0.021395720127413517, 0.034348953111507145, 0.021341326368415688, 0.00998196884469924, 0.012103980057947893, 0.003623792494344337,
                    0.014856997959425555, 0.019728073048889683, 0.009551834283103654, 0.010673747228357565, 0.013091120538149493, 0.008042042231155025,
                    0.012040914962136648, 0.006719714072206652 },
            { 0.0288793474177683, 0.013172605013065924, 0.014188623540477088, 0.013194205061238282, 0.03418000918492228, 0.026197618466788735,
                    0.010157899272126606, 0.029216309130148, 0.024679940599105662, 0.027988020663419655, 0.02530005947916317, 0.02400873945537274,
                    0.012786672390198062, 0.041946111768192566, 0.04606207511405481, -0.0015246959052684212, -0.003449397861085963, 0.019038700841459474,
                    0.007055775576655125, 0.019717581883267107, 0.017657033527818028, 0.03780664303450642, 0.013604649118136589, 0.013604722637366336,
                    0.02432344974648537, 0.022815931843985095, 0.0376866150501354, 0.015779990756756325, 0.018942452643456724, 0.01603953163493417,
                    0.038784402822659304, 0.03848029452742715, 0.025219537519367802, 0.04435550846551548, 0.027336386421487814, 0.045059448068240276,
                    0.016413033310139002, 0.030106472680777346, 0.029036008717857144, 0.014445229026404242, 0.021163193190266952, 0.028777102579643835,
                    0.03492723194849446, 0.021447954146896216, 0.02030072518191541, 0.025270383781133686, 0.012585287319489956, 0.023697742920149423,
                    0.016229541877473982, -0.005560223888707621 },
            { 0.01625686413164755, 0.00974349144048374, 0.015331838784994736, 0.008899182232958281, 0.0199843928153421, 0.019221034476130452,
                    0.010081281227236765, 0.017992067941916164, 0.011708697858863854, 0.01202121842771234, 0.007986837805861072, 0.01848577045035891,
                    0.012681133575323697, 0.013791248907950623, 0.027298170335996852, 0.0032959181458816988, 0.002105150989001039, 0.024590048064132862,
                    0.0070206242222774495, 0.011956459617217276, 0.009000196536330763, 0.015561904114229584, 0.013541372162265843, 0.007104501658179762,
                    0.013785374233316149, 0.0011863080950340393, 0.023266082323617248, 6.760531079431115E-4, 0.011024534808784086, 0.011045238529604708,
                    0.016875262600282808, 0.019488889125853226, 0.008974322977072326, 0.012379745368885958, 0.021395720127413517, 0.016413033310139002,
                    0.02654618886886501, 0.022600394907300925, 0.007295727792185945, 0.004497111059359399, 0.01180744212576737, 0.026222382990613587,
                    0.027262558544050488, 0.014131172102111931, 0.00989541475708838, 0.013825829484061346, 0.006476805823031314, 0.0026380913389321067,
                    0.013164350783609512, 0.007970244332118426 },
            { 0.03607588514977384, -5.5497997313984354E-5, -0.010038208799509875, 0.005068563598278567, 0.021992698393771402, 0.0313198701334376,
                    0.01501716178325315, 0.027890350880092084, 0.020160544070968074, 0.029665601186223953, 0.008600222397107631, 0.018656998132920165,
                    0.00957266873830471, 0.038054413888482165, 0.04526989827532585, -0.0046858264912128435, -0.005362131980266906, 0.010462684202814808,
                    6.593513246663617E-4, 0.020249967303806307, 0.022094155288580733, 0.027891136425231475, 0.00971329225493805, 0.015747003945028742,
                    0.01968036403126159, 0.013993121847238658, 0.03259176853622263, 0.010643784389611118, 0.01480862641702484, 0.019550838169833183,
                    0.03509100105431057, 0.018172764163540866, 0.012905895034641653, 0.0276068324489131, 0.034348953111507145, 0.030106472680777346,
                    0.022600394907300925, 0.09039992984664871, 0.023578409394402082, 0.001830654372884974, 0.017717917033438956, 0.026099816900666668,
                    0.026696173942353102, 0.018125150170145723, 0.00673806072977085, 0.04358791662348518, 0.00510016372379491, 0.004133969208315538,
                    0.021546065756524693, 0.005879351328463924 },
            { 0.02182792160563759, 0.05286629641047535, 0.04795962400012498, 0.012808823788731227, 0.018493037307030762, 0.025499998497679702,
                    0.025854408075601035, 0.032385392089908316, 0.001813516301749397, 0.01557233972417593, 0.01818546505358175, 0.00766852295773226,
                    0.010777540632164106, 0.07315571092027119, 0.061615065568199165, 0.0015700452197944428, -0.002541187922865433, 0.0035017906291575393,
                    0.01990206383204848, 0.020997714425856333, 0.027606092392302453, 0.017832709490990965, 0.0034592318502937487, -0.0015364140311595778,
                    0.02536807942323897, 0.03900137781307372, 0.029422210468970644, 0.03524741203150567, 0.01480969007239338, 0.0392648615154301,
                    0.05634143441311294, 0.03434436409135776, 0.026736851608801793, 0.03577892261444826, 0.021341326368415688, 0.029036008717857144,
                    0.007295727792185945, 0.023578409394402082, 0.09192871697965523, 0.013935876037013278, 0.02024423957205239, -0.007453140336249463,
                    0.03133949310849295, 0.018360711571134555, 0.018961977487401145, 0.016421879532638718, 0.012517578441316141, 0.013729302331103397,
                    0.022832138105457405, -0.004900337165560653 },
            { 0.0019401081530628272, 0.018091003173312758, 3.6014013917668353E-4, 0.006327065521531838, 0.01916444672150664, 0.010918540853198135,
                    0.023219049133161758, 0.015010754778326162, 0.00446054770713945, 0.006428313418953551, 0.015081468905261065, 0.01747125892218083,
                    0.010259174033270318, 0.020389198435749278, 0.007813195991701851, -0.004099750914280496, -8.994988810031339E-4, 0.010060035087643294,
                    0.021183487327569403, 0.0037993717619894795, 0.004179316902702262, 0.008506584876284423, 0.00770503112989151, -0.003770991263225225,
                    0.009158718621249284, 0.010658728023334304, 0.0034036688595096044, 0.012165034629777433, 0.010764944595814889, 0.0018889703965769204,
                    0.002804751136383673, 0.009548155974914728, 0.009148979240241889, 0.015291731601271707, 0.00998196884469924, 0.014445229026404242,
                    0.004497111059359399, 0.001830654372884974, 0.013935876037013278, 0.03587426087738935, 0.009406609718284161, 0.0024167091617811765,
                    0.007706679839942042, 0.010736479840092851, 0.011449021846371348, 0.0050186201062313324, 0.008072930350672346, 0.031409223231271904,
                    0.007509653101337754, 4.2874226256942293E-4 },
            { 0.023088019874954985, 0.007827242720433567, 0.008890898145824498, 0.006895920230353253, 0.022374283744879462, 0.02031996532199529,
                    0.0066414009046200095, 0.021617022673810726, 0.016211887715750196, 0.019323628983647166, 0.022532387739614357, 0.019385100479800924,
                    0.010184755695669432, 0.020732309060892965, 0.038130408791341386, 0.0019017842099180828, -2.0282038674842445E-4, 0.022925632212073006,
                    0.01182375445247322, 0.017438934284299778, 0.01903316642611587, 0.02109357154041667, 8.819070991140186E-4, 0.002597775587038229,
                    0.019021632987611874, 0.02985286708186641, 0.03828116923335393, 0.004296142039002678, 0.016045858950686734, 0.015329940361266522,
                    0.013188230011377162, 0.03426091283813539, 0.018926137658468054, 0.02242204513969833, 0.012103980057947893, 0.021163193190266952,
                    0.01180744212576737, 0.017717917033438956, 0.02024423957205239, 0.009406609718284161, 0.02690591651962456, 0.015218652016845871,
                    0.020428544120472514, 0.01909570789468426, 0.015435492119280116, 0.011402666461673323, 0.002174049659334438, 0.0267438460357846,
                    0.019366643151991568, -4.819951853204372E-4 },
            { 0.021847682491973844, 0.018425128521131803, -0.02406280430614031, -0.01578544340884814, 0.02348699863642628, 0.015392723560923242,
                    -0.006805700672259655, 0.016269521253447557, 0.0124474695202667, 0.02130614309338997, 0.019108031118974134, 0.021725384067406157,
                    0.0026147687378308, 0.013149146188015094, 0.03953580686912669, -0.01602277791501922, -0.01185588284769239, 0.04474454703489368,
                    0.006622767856459763, 0.0184312868401266, -0.02213647761983185, 0.03202558170707041, -4.5583489349293373E-4, 0.004346891388492886,
                    0.022967120829526948, -0.01837340281195142, 0.050849287515772376, -0.04157489505724116, 9.550512708569536E-4, 0.002989145465401866,
                    -0.003263422575509032, 0.03832685856829979, 0.019265883553737134, 0.047727890536051566, 0.003623792494344337, 0.028777102579643835,
                    0.026222382990613587, 0.026099816900666668, -0.007453140336249463, 0.0024167091617811765, 0.015218652016845871, 0.14025133485602365,
                    0.09712068960473474, 0.014172312600462755, 0.011129887791289704, 0.024489837357094757, -0.010129174085695369, 0.003812523657750725,
                    0.018264734377633, -5.055985755887703E-4 },
            { 0.01740765458208289, 0.0426802648820412, 0.009145542037329701, 0.013835190611388043, 0.02555899944899036, 0.02557642682695848,
                    0.01080938969249192, 0.03107357443389102, 0.0125061765297089, 0.013304017263821483, 0.015244445592768024, 0.027901009001847894,
                    0.005680056951686177, 0.03363038446597429, 0.04425480311595029, 0.001133432032644065, 0.0022996146645568585, 0.05058245393652497,
                    0.01046708437784738, 0.026218541014483822, -0.005686391727211877, 0.033464146361256615, 0.008374070021325564, 0.00940108218803621,
                    0.02974293244856069, 0.01830057496771731, 0.0447416638682924, -0.008454920693158417, 0.009519454142167387, 0.020154417608086825,
                    0.021486858115968593, 0.01934643079720676, 0.028599298400448548, 0.05270932588442152, 0.014856997959425555, 0.03492723194849446,
                    0.027262558544050488, 0.026696173942353102, 0.03133949310849295, 0.007706679839942042, 0.020428544120472514, 0.09712068960473474,
                    0.12724898151581052, 0.022233697132198277, 0.016142275091715508, 0.014846897185523445, 0.004777367977794034, 0.0021346565816080304,
                    0.01971010139351168, 0.0032194379583477773 },
            { 0.014052347883703707, 0.01128235024313989, 0.016835470685292845, 0.013270244552979586, 0.024087534936220456, 0.01647591044046632,
                    0.012058330553673636, 0.02407483556450472, 0.012820584755597171, 0.01961764120541732, 0.018452739647737873, 0.01808519319017715,
                    0.012828090216758126, 0.02882830912402931, 0.03304122364224013, 0.006588382185161595, 0.0018092965490755992, 0.02196308901275064,
                    0.008882864596676107, 0.01521994621677613, 0.02077996096755369, 0.014262486778107385, 0.010288546237463815, 7.729874408787671E-4,
                    0.015164361037898182, 0.030987375225818826, 0.017631441077007613, 0.010290158792464588, 0.015402068774034768, 0.01661992595694323,
                    0.012595143432008352, 0.03189721754750205, 0.014700312152543145, 0.019621278415158986, 0.019728073048889683, 0.021447954146896216,
                    0.014131172102111931, 0.018125150170145723, 0.018360711571134555, 0.010736479840092851, 0.01909570789468426, 0.014172312600462755,
                    0.022233697132198277, 0.03103096158565341, 0.0127854158145463, 0.016690143160114048, 0.007474460781411503, 0.019684817591483987,
                    0.01493380515769408, 0.0041169521525162385 },
            { 0.014661111108107102, 0.006603758972640087, 0.012578271302337022, 0.005748084954197917, 0.02523216350104818, 0.009779204351658969,
                    0.00593917461759169, 0.01720650553297241, 0.012657211389221386, 0.008410049037506232, 0.020598057749998497, 0.011889591203301835,
                    0.008683638998333111, 0.02147731330133211, 0.02433918027177629, 0.0031416417110126, 4.8757609949812745E-5, 0.01847663753589149,
                    0.010740188144429563, 0.013237662041272854, 0.015222521280940277, 0.014842255795510156, 0.008266796930948679, 0.001158743134795707,
                    0.015652517421060254, 0.014300495863093577, 0.02040125304963042, 0.012401731068121943, 0.015370561204387238, 0.00932116372768866,
                    0.012533314162456441, 0.0285752309616072, 0.014611226182495649, 0.024021574854612815, 0.009551834283103654, 0.02030072518191541,
                    0.00989541475708838, 0.00673806072977085, 0.018961977487401145, 0.011449021846371348, 0.015435492119280116, 0.011129887791289704,
                    0.016142275091715508, 0.0127854158145463, 0.020955952118363985, 0.008495320312220918, 0.010386799824008978, 0.01824991617535219,
                    0.01482569593835701, -0.0025431829905904453 },
            { 0.0235625379068616, 0.00287525803416068, -2.4490975743401974E-5, 0.007146186580464384, 0.02572983465713241, 0.006875878968911921,
                    0.004418583884501358, 0.015990206407303097, 0.013221193190146016, 0.031038905440820358, 0.023463034128006724, 0.015745480319644525,
                    0.00921410783353355, 0.03382223812110682, 0.029760387150223, -0.002101041153798418, -0.004515591288787984, 0.006848502295165496,
                    0.005481070770807478, 0.009958079171752553, 0.01887596599749407, 0.024750626490851753, 0.012685536007551328, 0.013897365954290433,
                    0.011676787262939314, 0.01933533672228807, 0.025974338205016288, 0.01081718185856954, 0.004389757181879901, 0.014479096802646682,
                    0.014122224234236551, 0.03583289717250668, 0.019551799791812017, 0.015435047699345415, 0.010673747228357565, 0.025270383781133686,
                    0.013825829484061346, 0.04358791662348518, 0.016421879532638718, 0.0050186201062313324, 0.011402666461673323, 0.024489837357094757,
                    0.014846897185523445, 0.016690143160114048, 0.008495320312220918, 0.059415797136154865, 0.011536465432696609, 0.029289692640219904,
                    0.013908120444910643, 0.0035097360975376154 },
            { 0.0063519290166566805, 0.012220214518728657, 0.025552078098515195, 0.012540192115472191, 0.017460924262885272, -0.0010121562145841796,
                    0.012067712684570311, 0.013426714867330457, 0.008800613809963966, 0.006133522606056485, 0.005988255754416581, -0.0075437193284664215,
                    0.008267845422722877, 0.023445101214206926, 0.011203429134322467, 0.013493458010022948, 0.013914486077396874, 8.821332595726583E-4,
                    -0.0022555010278700093, 0.0019509067596749467, 0.011515211312171541, 0.0025805255452103224, 0.02471145289354339, 0.007125490309728245,
                    0.0070586185843389115, 0.010524357674188151, 0.0013684360828060496, 0.03729300629852992, 0.013265174918104292, 0.010936385331627704,
                    0.022115711600265747, 0.01081789987172843, 0.007135737025361431, 0.00830413028137543, 0.013091120538149493, 0.012585287319489956,
                    0.006476805823031314, 0.00510016372379491, 0.012517578441316141, 0.008072930350672346, 0.002174049659334438, -0.010129174085695369,
                    0.004777367977794034, 0.007474460781411503, 0.010386799824008978, 0.011536465432696609, 0.027115062932076155, 0.012052532967102327,
                    0.006311948766966562, 0.008818852070372238 },
            { 0.02266275927162538, 0.008778958864425828, 0.010855233647302861, 0.011034607240664006, 0.02963525358853074, 0.005979142722023696,
                    0.017032385556474305, 0.02130905733344067, 0.014364926330115293, 0.02706917016264846, 0.03791690255264783, 0.021196444727637254,
                    0.01173422941775155, 0.025605317239171456, 0.03453236219963221, -0.001042696694234923, 9.440352756290071E-5, 0.016915225076385623,
                    0.025896482658818276, 0.005441577252885824, 0.032984837011846846, 0.02209447169991283, 0.006960840298794393, 1.577297194999271E-4,
                    0.015317952985031292, 0.03794932456043361, 0.028801419534579778, 0.01590421502657845, 0.010813652773302637, 0.013543399375383599,
                    0.00984569197890908, 0.048655871683935474, 0.027564738009527447, 0.01846535538144016, 0.008042042231155025, 0.023697742920149423,
                    0.0026380913389321067, 0.004133969208315538, 0.013729302331103397, 0.031409223231271904, 0.0267438460357846, 0.003812523657750725,
                    0.0021346565816080304, 0.019684817591483987, 0.01824991617535219, 0.029289692640219904, 0.012052532967102327, 0.08407934948611373,
                    0.016808734904299984, -0.0016458099910362416 },
            { 0.015704650036742693, 0.001511274203118489, 0.015937426008268245, 0.0152520817434781, 0.0196681585661115, 0.017903064848172084,
                    0.003358830653472287, 0.018089016306066085, 0.014088295678198585, 0.015496312179366718, 0.02371242965781328, 0.013255209497180951,
                    0.00972520489639116, 0.02856381827269984, 0.029946767058238993, 0.008071167763236298, 0.005112955207958603, 0.025483528314634567,
                    0.014745864335852902, 0.016450581280423066, 0.011547993062065678, 0.016043739582648212, 0.006963518565645906, 0.0071400943830796,
                    0.020087687596214276, 0.013039104912698017, 0.033794089944894364, 0.012403521718740268, 0.013074258770418653, 0.020793466250702716,
                    0.00839196434000236, 0.029860672431014083, 0.016148843396335495, 0.02606472618943749, 0.012040914962136648, 0.016229541877473982,
                    0.013164350783609512, 0.021546065756524693, 0.022832138105457405, 0.007509653101337754, 0.019366643151991568, 0.018264734377633,
                    0.01971010139351168, 0.01493380515769408, 0.01482569593835701, 0.013908120444910643, 0.006311948766966562, 0.016808734904299984,
                    0.030890341653703073, 0.005189000609108337 },
            { -0.001513963523137642, -0.0018951088193391312, 0.0056781970835267336, 0.014597506659684484, -5.711492813201779E-4, 0.002085943533144139,
                    0.003452977584111762, -0.004217848608319288, 5.744021049862826E-4, 0.0013991936296724522, -0.0024541495455922126, -0.002031133745337114,
                    0.007361760128319779, 3.5704813583962816E-5, -0.00478837336688735, 0.017480036928203727, 0.017809321996539982, 0.005624473791648439,
                    -0.0014071200617345417, 0.004343511615173052, -0.007000622345030958, -0.007610864783593404, 0.012357257401250574, 0.007706197328753257,
                    0.002038499328383774, -4.443375996753306E-4, 0.004465217803507001, 0.006496822714270262, 0.008368638792066126, 0.00890230948876778,
                    -0.011294032692972834, 0.00347782821975552, -0.0025723170806437835, -0.011144212669697692, 0.006719714072206652, -0.005560223888707621,
                    0.007970244332118426, 0.005879351328463924, -0.004900337165560653, 4.2874226256942293E-4, -4.819951853204372E-4, -5.055985755887703E-4,
                    0.0032194379583477773, 0.0041169521525162385, -0.0025431829905904453, 0.0035097360975376154, 0.008818852070372238, -0.0016458099910362416,
                    0.005189000609108337, 0.025197285986999447 } };

}
