// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gl_4_autogen.cpp:
//   Capture functions for the OpenGL ES Desktop GL 4.x entry points.

#include "libANGLE/capture/capture_gl_4_autogen.h"

#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/capture/FrameCapture.h"
#include "libANGLE/validationGL4_autogen.h"

using namespace angle;

namespace gl
{

// GL 4.0
CallCapture CaptureBeginQueryIndexed(const State &glState,
                                     bool isCallValid,
                                     GLenum target,
                                     GLuint index,
                                     QueryID idPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::QueryTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);

    return CallCapture(angle::EntryPoint::GLBeginQueryIndexed, std::move(paramBuffer));
}

CallCapture CaptureDrawTransformFeedback(const State &glState,
                                         bool isCallValid,
                                         GLenum mode,
                                         TransformFeedbackID idPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mode", BigGLEnum::PrimitiveType, ParamType::TGLenum, mode);
    paramBuffer.addValueParam("idPacked", ParamType::TTransformFeedbackID, idPacked);

    return CallCapture(angle::EntryPoint::GLDrawTransformFeedback, std::move(paramBuffer));
}

CallCapture CaptureDrawTransformFeedbackStream(const State &glState,
                                               bool isCallValid,
                                               GLenum mode,
                                               TransformFeedbackID idPacked,
                                               GLuint stream)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mode", BigGLEnum::PrimitiveType, ParamType::TGLenum, mode);
    paramBuffer.addValueParam("idPacked", ParamType::TTransformFeedbackID, idPacked);
    paramBuffer.addValueParam("stream", ParamType::TGLuint, stream);

    return CallCapture(angle::EntryPoint::GLDrawTransformFeedbackStream, std::move(paramBuffer));
}

CallCapture CaptureEndQueryIndexed(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::QueryTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(angle::EntryPoint::GLEndQueryIndexed, std::move(paramBuffer));
}

CallCapture CaptureGetActiveSubroutineName(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           GLenum shadertype,
                                           GLuint index,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("shadertype", BigGLEnum::ShaderType, ParamType::TGLenum, shadertype);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetActiveSubroutineName_length(glState, isCallValid, programPacked, shadertype,
                                              index, bufSize, length, name, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, name, &nameParam.value);
        CaptureGetActiveSubroutineName_name(glState, isCallValid, programPacked, shadertype, index,
                                            bufSize, length, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr), &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    return CallCapture(angle::EntryPoint::GLGetActiveSubroutineName, std::move(paramBuffer));
}

CallCapture CaptureGetActiveSubroutineUniformName(const State &glState,
                                                  bool isCallValid,
                                                  ShaderProgramID programPacked,
                                                  GLenum shadertype,
                                                  GLuint index,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("shadertype", BigGLEnum::ShaderType, ParamType::TGLenum, shadertype);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetActiveSubroutineUniformName_length(glState, isCallValid, programPacked,
                                                     shadertype, index, bufSize, length, name,
                                                     &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, name, &nameParam.value);
        CaptureGetActiveSubroutineUniformName_name(glState, isCallValid, programPacked, shadertype,
                                                   index, bufSize, length, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr), &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    return CallCapture(angle::EntryPoint::GLGetActiveSubroutineUniformName, std::move(paramBuffer));
}

CallCapture CaptureGetActiveSubroutineUniformiv(const State &glState,
                                                bool isCallValid,
                                                ShaderProgramID programPacked,
                                                GLenum shadertype,
                                                GLuint index,
                                                GLenum pname,
                                                GLint *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("shadertype", BigGLEnum::ShaderType, ParamType::TGLenum, shadertype);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", BigGLEnum::SubroutineParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture valuesParam("values", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, values, &valuesParam.value);
        CaptureGetActiveSubroutineUniformiv_values(glState, isCallValid, programPacked, shadertype,
                                                   index, pname, values, &valuesParam);
        paramBuffer.addParam(std::move(valuesParam));
    }
    else
    {
        ParamCapture valuesParam("values", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &valuesParam.value);
        paramBuffer.addParam(std::move(valuesParam));
    }

    return CallCapture(angle::EntryPoint::GLGetActiveSubroutineUniformiv, std::move(paramBuffer));
}

CallCapture CaptureGetProgramStageiv(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLenum shadertype,
                                     GLenum pname,
                                     GLint *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("shadertype", BigGLEnum::ShaderType, ParamType::TGLenum, shadertype);
    paramBuffer.addEnumParam("pname", BigGLEnum::ProgramStagePName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture valuesParam("values", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, values, &valuesParam.value);
        CaptureGetProgramStageiv_values(glState, isCallValid, programPacked, shadertype, pname,
                                        values, &valuesParam);
        paramBuffer.addParam(std::move(valuesParam));
    }
    else
    {
        ParamCapture valuesParam("values", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &valuesParam.value);
        paramBuffer.addParam(std::move(valuesParam));
    }

    return CallCapture(angle::EntryPoint::GLGetProgramStageiv, std::move(paramBuffer));
}

CallCapture CaptureGetQueryIndexediv(const State &glState,
                                     bool isCallValid,
                                     GLenum target,
                                     GLuint index,
                                     GLenum pname,
                                     GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::QueryTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", BigGLEnum::QueryParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetQueryIndexediv_params(glState, isCallValid, target, index, pname, params,
                                        &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetQueryIndexediv, std::move(paramBuffer));
}

CallCapture CaptureGetSubroutineIndex(const State &glState,
                                      bool isCallValid,
                                      ShaderProgramID programPacked,
                                      GLenum shadertype,
                                      const GLchar *name,
                                      GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("shadertype", BigGLEnum::ShaderType, ParamType::TGLenum, shadertype);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureGetSubroutineIndex_name(glState, isCallValid, programPacked, shadertype, name,
                                       &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetSubroutineIndex, std::move(paramBuffer));
}

CallCapture CaptureGetSubroutineUniformLocation(const State &glState,
                                                bool isCallValid,
                                                ShaderProgramID programPacked,
                                                GLenum shadertype,
                                                const GLchar *name,
                                                GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("shadertype", BigGLEnum::ShaderType, ParamType::TGLenum, shadertype);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureGetSubroutineUniformLocation_name(glState, isCallValid, programPacked, shadertype,
                                                 name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetSubroutineUniformLocation, std::move(paramBuffer));
}

CallCapture CaptureGetUniformSubroutineuiv(const State &glState,
                                           bool isCallValid,
                                           GLenum shadertype,
                                           GLint location,
                                           GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("shadertype", BigGLEnum::ShaderType, ParamType::TGLenum, shadertype);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetUniformSubroutineuiv_params(glState, isCallValid, shadertype, location, params,
                                              &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetUniformSubroutineuiv, std::move(paramBuffer));
}

CallCapture CaptureGetUniformdv(const State &glState,
                                bool isCallValid,
                                ShaderProgramID programPacked,
                                UniformLocation locationPacked,
                                GLdouble *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, params, &paramsParam.value);
        CaptureGetUniformdv_params(glState, isCallValid, programPacked, locationPacked, params,
                                   &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, static_cast<GLdouble *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetUniformdv, std::move(paramBuffer));
}

CallCapture CapturePatchParameterfv(const State &glState,
                                    bool isCallValid,
                                    GLenum pname,
                                    const GLfloat *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", BigGLEnum::PatchParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture valuesParam("values", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, values, &valuesParam.value);
        CapturePatchParameterfv_values(glState, isCallValid, pname, values, &valuesParam);
        paramBuffer.addParam(std::move(valuesParam));
    }
    else
    {
        ParamCapture valuesParam("values", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valuesParam.value);
        paramBuffer.addParam(std::move(valuesParam));
    }

    return CallCapture(angle::EntryPoint::GLPatchParameterfv, std::move(paramBuffer));
}

CallCapture CaptureUniform1d(const State &glState,
                             bool isCallValid,
                             UniformLocation locationPacked,
                             GLdouble x)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);

    return CallCapture(angle::EntryPoint::GLUniform1d, std::move(paramBuffer));
}

CallCapture CaptureUniform1dv(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLsizei count,
                              const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureUniform1dv_value(glState, isCallValid, locationPacked, count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLUniform1dv, std::move(paramBuffer));
}

CallCapture CaptureUniform2d(const State &glState,
                             bool isCallValid,
                             UniformLocation locationPacked,
                             GLdouble x,
                             GLdouble y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);

    return CallCapture(angle::EntryPoint::GLUniform2d, std::move(paramBuffer));
}

CallCapture CaptureUniform2dv(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLsizei count,
                              const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureUniform2dv_value(glState, isCallValid, locationPacked, count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLUniform2dv, std::move(paramBuffer));
}

CallCapture CaptureUniform3d(const State &glState,
                             bool isCallValid,
                             UniformLocation locationPacked,
                             GLdouble x,
                             GLdouble y,
                             GLdouble z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);
    paramBuffer.addValueParam("z", ParamType::TGLdouble, z);

    return CallCapture(angle::EntryPoint::GLUniform3d, std::move(paramBuffer));
}

CallCapture CaptureUniform3dv(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLsizei count,
                              const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureUniform3dv_value(glState, isCallValid, locationPacked, count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLUniform3dv, std::move(paramBuffer));
}

CallCapture CaptureUniform4d(const State &glState,
                             bool isCallValid,
                             UniformLocation locationPacked,
                             GLdouble x,
                             GLdouble y,
                             GLdouble z,
                             GLdouble w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);
    paramBuffer.addValueParam("z", ParamType::TGLdouble, z);
    paramBuffer.addValueParam("w", ParamType::TGLdouble, w);

    return CallCapture(angle::EntryPoint::GLUniform4d, std::move(paramBuffer));
}

CallCapture CaptureUniform4dv(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLsizei count,
                              const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureUniform4dv_value(glState, isCallValid, locationPacked, count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLUniform4dv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix2dv(const State &glState,
                                    bool isCallValid,
                                    UniformLocation locationPacked,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureUniformMatrix2dv_value(glState, isCallValid, locationPacked, count, transpose, value,
                                      &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLUniformMatrix2dv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix2x3dv(const State &glState,
                                      bool isCallValid,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureUniformMatrix2x3dv_value(glState, isCallValid, locationPacked, count, transpose,
                                        value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLUniformMatrix2x3dv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix2x4dv(const State &glState,
                                      bool isCallValid,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureUniformMatrix2x4dv_value(glState, isCallValid, locationPacked, count, transpose,
                                        value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLUniformMatrix2x4dv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix3dv(const State &glState,
                                    bool isCallValid,
                                    UniformLocation locationPacked,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureUniformMatrix3dv_value(glState, isCallValid, locationPacked, count, transpose, value,
                                      &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLUniformMatrix3dv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix3x2dv(const State &glState,
                                      bool isCallValid,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureUniformMatrix3x2dv_value(glState, isCallValid, locationPacked, count, transpose,
                                        value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLUniformMatrix3x2dv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix3x4dv(const State &glState,
                                      bool isCallValid,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureUniformMatrix3x4dv_value(glState, isCallValid, locationPacked, count, transpose,
                                        value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLUniformMatrix3x4dv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix4dv(const State &glState,
                                    bool isCallValid,
                                    UniformLocation locationPacked,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureUniformMatrix4dv_value(glState, isCallValid, locationPacked, count, transpose, value,
                                      &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLUniformMatrix4dv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix4x2dv(const State &glState,
                                      bool isCallValid,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureUniformMatrix4x2dv_value(glState, isCallValid, locationPacked, count, transpose,
                                        value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLUniformMatrix4x2dv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix4x3dv(const State &glState,
                                      bool isCallValid,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureUniformMatrix4x3dv_value(glState, isCallValid, locationPacked, count, transpose,
                                        value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLUniformMatrix4x3dv, std::move(paramBuffer));
}

CallCapture CaptureUniformSubroutinesuiv(const State &glState,
                                         bool isCallValid,
                                         GLenum shadertype,
                                         GLsizei count,
                                         const GLuint *indices)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("shadertype", BigGLEnum::ShaderType, ParamType::TGLenum, shadertype);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, indices, &indicesParam.value);
        CaptureUniformSubroutinesuiv_indices(glState, isCallValid, shadertype, count, indices,
                                             &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    return CallCapture(angle::EntryPoint::GLUniformSubroutinesuiv, std::move(paramBuffer));
}

// GL 4.1
CallCapture CaptureDepthRangeArrayv(const State &glState,
                                    bool isCallValid,
                                    GLuint first,
                                    GLsizei count,
                                    const GLdouble *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("first", ParamType::TGLuint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureDepthRangeArrayv_v(glState, isCallValid, first, count, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLDepthRangeArrayv, std::move(paramBuffer));
}

CallCapture CaptureDepthRangeIndexed(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     GLdouble n,
                                     GLdouble f)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("n", ParamType::TGLdouble, n);
    paramBuffer.addValueParam("f", ParamType::TGLdouble, f);

    return CallCapture(angle::EntryPoint::GLDepthRangeIndexed, std::move(paramBuffer));
}

CallCapture CaptureGetDoublei_v(const State &glState,
                                bool isCallValid,
                                GLenum target,
                                GLuint index,
                                GLdouble *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::GetPName, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, data, &dataParam.value);
        CaptureGetDoublei_v_data(glState, isCallValid, target, index, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, static_cast<GLdouble *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLGetDoublei_v, std::move(paramBuffer));
}

CallCapture CaptureGetFloati_v(const State &glState,
                               bool isCallValid,
                               GLenum target,
                               GLuint index,
                               GLfloat *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::GetPName, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, data, &dataParam.value);
        CaptureGetFloati_v_data(glState, isCallValid, target, index, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLGetFloati_v, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribLdv(const State &glState,
                                      bool isCallValid,
                                      GLuint index,
                                      GLenum pname,
                                      GLdouble *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", BigGLEnum::VertexAttribEnum, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, params, &paramsParam.value);
        CaptureGetVertexAttribLdv_params(glState, isCallValid, index, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, static_cast<GLdouble *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetVertexAttribLdv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1d(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLdouble v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLdouble, v0);

    return CallCapture(angle::EntryPoint::GLProgramUniform1d, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1dv(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLsizei count,
                                     const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureProgramUniform1dv_value(glState, isCallValid, programPacked, locationPacked, count,
                                       value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform1dv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2d(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLdouble v0,
                                    GLdouble v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLdouble, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLdouble, v1);

    return CallCapture(angle::EntryPoint::GLProgramUniform2d, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2dv(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLsizei count,
                                     const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureProgramUniform2dv_value(glState, isCallValid, programPacked, locationPacked, count,
                                       value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform2dv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3d(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLdouble v0,
                                    GLdouble v1,
                                    GLdouble v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLdouble, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLdouble, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLdouble, v2);

    return CallCapture(angle::EntryPoint::GLProgramUniform3d, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3dv(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLsizei count,
                                     const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureProgramUniform3dv_value(glState, isCallValid, programPacked, locationPacked, count,
                                       value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform3dv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4d(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLdouble v0,
                                    GLdouble v1,
                                    GLdouble v2,
                                    GLdouble v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLdouble, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLdouble, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLdouble, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLdouble, v3);

    return CallCapture(angle::EntryPoint::GLProgramUniform4d, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4dv(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLsizei count,
                                     const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureProgramUniform4dv_value(glState, isCallValid, programPacked, locationPacked, count,
                                       value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform4dv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix2dv(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           UniformLocation locationPacked,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix2dv_value(glState, isCallValid, programPacked, locationPacked,
                                             count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix2dv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix2x3dv(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             UniformLocation locationPacked,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix2x3dv_value(glState, isCallValid, programPacked, locationPacked,
                                               count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix2x3dv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix2x4dv(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             UniformLocation locationPacked,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix2x4dv_value(glState, isCallValid, programPacked, locationPacked,
                                               count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix2x4dv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix3dv(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           UniformLocation locationPacked,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix3dv_value(glState, isCallValid, programPacked, locationPacked,
                                             count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix3dv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix3x2dv(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             UniformLocation locationPacked,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix3x2dv_value(glState, isCallValid, programPacked, locationPacked,
                                               count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix3x2dv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix3x4dv(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             UniformLocation locationPacked,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix3x4dv_value(glState, isCallValid, programPacked, locationPacked,
                                               count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix3x4dv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix4dv(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           UniformLocation locationPacked,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix4dv_value(glState, isCallValid, programPacked, locationPacked,
                                             count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix4dv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix4x2dv(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             UniformLocation locationPacked,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix4x2dv_value(glState, isCallValid, programPacked, locationPacked,
                                               count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix4x2dv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix4x3dv(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             UniformLocation locationPacked,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLdouble *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix4x3dv_value(glState, isCallValid, programPacked, locationPacked,
                                               count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix4x3dv, std::move(paramBuffer));
}

CallCapture CaptureScissorArrayv(const State &glState,
                                 bool isCallValid,
                                 GLuint first,
                                 GLsizei count,
                                 const GLint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("first", ParamType::TGLuint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureScissorArrayv_v(glState, isCallValid, first, count, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLScissorArrayv, std::move(paramBuffer));
}

CallCapture CaptureScissorIndexed(const State &glState,
                                  bool isCallValid,
                                  GLuint index,
                                  GLint left,
                                  GLint bottom,
                                  GLsizei width,
                                  GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("left", ParamType::TGLint, left);
    paramBuffer.addValueParam("bottom", ParamType::TGLint, bottom);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLScissorIndexed, std::move(paramBuffer));
}

CallCapture CaptureScissorIndexedv(const State &glState,
                                   bool isCallValid,
                                   GLuint index,
                                   const GLint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureScissorIndexedv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLScissorIndexedv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribL1d(const State &glState, bool isCallValid, GLuint index, GLdouble x)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);

    return CallCapture(angle::EntryPoint::GLVertexAttribL1d, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribL1dv(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    const GLdouble *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureVertexAttribL1dv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribL1dv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribL2d(const State &glState,
                                   bool isCallValid,
                                   GLuint index,
                                   GLdouble x,
                                   GLdouble y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);

    return CallCapture(angle::EntryPoint::GLVertexAttribL2d, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribL2dv(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    const GLdouble *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureVertexAttribL2dv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribL2dv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribL3d(const State &glState,
                                   bool isCallValid,
                                   GLuint index,
                                   GLdouble x,
                                   GLdouble y,
                                   GLdouble z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);
    paramBuffer.addValueParam("z", ParamType::TGLdouble, z);

    return CallCapture(angle::EntryPoint::GLVertexAttribL3d, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribL3dv(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    const GLdouble *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureVertexAttribL3dv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribL3dv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribL4d(const State &glState,
                                   bool isCallValid,
                                   GLuint index,
                                   GLdouble x,
                                   GLdouble y,
                                   GLdouble z,
                                   GLdouble w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLdouble, x);
    paramBuffer.addValueParam("y", ParamType::TGLdouble, y);
    paramBuffer.addValueParam("z", ParamType::TGLdouble, z);
    paramBuffer.addValueParam("w", ParamType::TGLdouble, w);

    return CallCapture(angle::EntryPoint::GLVertexAttribL4d, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribL4dv(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    const GLdouble *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, v, &vParam.value);
        CaptureVertexAttribL4dv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoubleConstPointer);
        InitParamValue(ParamType::TGLdoubleConstPointer, static_cast<const GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribL4dv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribLPointer(const State &glState,
                                        bool isCallValid,
                                        GLuint index,
                                        GLint size,
                                        GLenum type,
                                        GLsizei stride,
                                        const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addEnumParam("type", BigGLEnum::VertexAttribLType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureVertexAttribLPointer_pointer(glState, isCallValid, index, size, type, stride,
                                            pointer, &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribLPointer, std::move(paramBuffer));
}

CallCapture CaptureViewportArrayv(const State &glState,
                                  bool isCallValid,
                                  GLuint first,
                                  GLsizei count,
                                  const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("first", ParamType::TGLuint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureViewportArrayv_v(glState, isCallValid, first, count, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLViewportArrayv, std::move(paramBuffer));
}

CallCapture CaptureViewportIndexedf(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    GLfloat x,
                                    GLfloat y,
                                    GLfloat w,
                                    GLfloat h)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("w", ParamType::TGLfloat, w);
    paramBuffer.addValueParam("h", ParamType::TGLfloat, h);

    return CallCapture(angle::EntryPoint::GLViewportIndexedf, std::move(paramBuffer));
}

CallCapture CaptureViewportIndexedfv(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureViewportIndexedfv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLViewportIndexedfv, std::move(paramBuffer));
}

// GL 4.2
CallCapture CaptureDrawArraysInstancedBaseInstance(const State &glState,
                                                   bool isCallValid,
                                                   PrimitiveMode modePacked,
                                                   GLint first,
                                                   GLsizei count,
                                                   GLsizei instancecount,
                                                   GLuint baseinstance)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("first", ParamType::TGLint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);
    paramBuffer.addValueParam("baseinstance", ParamType::TGLuint, baseinstance);

    return CallCapture(angle::EntryPoint::GLDrawArraysInstancedBaseInstance,
                       std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedBaseInstance(const State &glState,
                                                     bool isCallValid,
                                                     PrimitiveMode modePacked,
                                                     GLsizei count,
                                                     DrawElementsType typePacked,
                                                     const void *indices,
                                                     GLsizei instancecount,
                                                     GLuint baseinstance)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstancedBaseInstance_indices(glState, isCallValid, modePacked, count,
                                                         typePacked, indices, instancecount,
                                                         baseinstance, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);
    paramBuffer.addValueParam("baseinstance", ParamType::TGLuint, baseinstance);

    return CallCapture(angle::EntryPoint::GLDrawElementsInstancedBaseInstance,
                       std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedBaseVertexBaseInstance(const State &glState,
                                                               bool isCallValid,
                                                               PrimitiveMode modePacked,
                                                               GLsizei count,
                                                               DrawElementsType typePacked,
                                                               const void *indices,
                                                               GLsizei instancecount,
                                                               GLint basevertex,
                                                               GLuint baseinstance)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstancedBaseVertexBaseInstance_indices(
            glState, isCallValid, modePacked, count, typePacked, indices, instancecount, basevertex,
            baseinstance, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);
    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);
    paramBuffer.addValueParam("baseinstance", ParamType::TGLuint, baseinstance);

    return CallCapture(angle::EntryPoint::GLDrawElementsInstancedBaseVertexBaseInstance,
                       std::move(paramBuffer));
}

CallCapture CaptureDrawTransformFeedbackInstanced(const State &glState,
                                                  bool isCallValid,
                                                  GLenum mode,
                                                  TransformFeedbackID idPacked,
                                                  GLsizei instancecount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mode", BigGLEnum::PrimitiveType, ParamType::TGLenum, mode);
    paramBuffer.addValueParam("idPacked", ParamType::TTransformFeedbackID, idPacked);
    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);

    return CallCapture(angle::EntryPoint::GLDrawTransformFeedbackInstanced, std::move(paramBuffer));
}

CallCapture CaptureDrawTransformFeedbackStreamInstanced(const State &glState,
                                                        bool isCallValid,
                                                        GLenum mode,
                                                        TransformFeedbackID idPacked,
                                                        GLuint stream,
                                                        GLsizei instancecount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mode", BigGLEnum::PrimitiveType, ParamType::TGLenum, mode);
    paramBuffer.addValueParam("idPacked", ParamType::TTransformFeedbackID, idPacked);
    paramBuffer.addValueParam("stream", ParamType::TGLuint, stream);
    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);

    return CallCapture(angle::EntryPoint::GLDrawTransformFeedbackStreamInstanced,
                       std::move(paramBuffer));
}

CallCapture CaptureGetActiveAtomicCounterBufferiv(const State &glState,
                                                  bool isCallValid,
                                                  ShaderProgramID programPacked,
                                                  GLuint bufferIndex,
                                                  GLenum pname,
                                                  GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("bufferIndex", ParamType::TGLuint, bufferIndex);
    paramBuffer.addEnumParam("pname", BigGLEnum::AtomicCounterBufferPName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetActiveAtomicCounterBufferiv_params(glState, isCallValid, programPacked,
                                                     bufferIndex, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetActiveAtomicCounterBufferiv, std::move(paramBuffer));
}

CallCapture CaptureTexStorage1D(const State &glState,
                                bool isCallValid,
                                GLenum target,
                                GLsizei levels,
                                GLenum internalformat,
                                GLsizei width)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);

    return CallCapture(angle::EntryPoint::GLTexStorage1D, std::move(paramBuffer));
}

// GL 4.3
CallCapture CaptureClearBufferData(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLenum internalformat,
                                   GLenum format,
                                   GLenum type,
                                   const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::BufferStorageTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureClearBufferData_data(glState, isCallValid, target, internalformat, format, type,
                                    data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLClearBufferData, std::move(paramBuffer));
}

CallCapture CaptureClearBufferSubData(const State &glState,
                                      bool isCallValid,
                                      GLenum target,
                                      GLenum internalformat,
                                      GLintptr offset,
                                      GLsizeiptr size,
                                      GLenum format,
                                      GLenum type,
                                      const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::BufferTargetARB, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureClearBufferSubData_data(glState, isCallValid, target, internalformat, offset, size,
                                       format, type, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLClearBufferSubData, std::move(paramBuffer));
}

CallCapture CaptureGetInternalformati64v(const State &glState,
                                         bool isCallValid,
                                         GLenum target,
                                         GLenum internalformat,
                                         GLenum pname,
                                         GLsizei count,
                                         GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addEnumParam("pname", BigGLEnum::InternalFormatPName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
        CaptureGetInternalformati64v_params(glState, isCallValid, target, internalformat, pname,
                                            count, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetInternalformati64v, std::move(paramBuffer));
}

CallCapture CaptureGetProgramResourceLocationIndex(const State &glState,
                                                   bool isCallValid,
                                                   ShaderProgramID programPacked,
                                                   GLenum programInterface,
                                                   const GLchar *name,
                                                   GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", BigGLEnum::ProgramInterface, ParamType::TGLenum,
                             programInterface);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureGetProgramResourceLocationIndex_name(glState, isCallValid, programPacked,
                                                    programInterface, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetProgramResourceLocationIndex,
                       std::move(paramBuffer));
}

CallCapture CaptureInvalidateBufferData(const State &glState,
                                        bool isCallValid,
                                        BufferID bufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    return CallCapture(angle::EntryPoint::GLInvalidateBufferData, std::move(paramBuffer));
}

CallCapture CaptureInvalidateBufferSubData(const State &glState,
                                           bool isCallValid,
                                           BufferID bufferPacked,
                                           GLintptr offset,
                                           GLsizeiptr length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("length", ParamType::TGLsizeiptr, length);

    return CallCapture(angle::EntryPoint::GLInvalidateBufferSubData, std::move(paramBuffer));
}

CallCapture CaptureInvalidateTexImage(const State &glState,
                                      bool isCallValid,
                                      TextureID texturePacked,
                                      GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture(angle::EntryPoint::GLInvalidateTexImage, std::move(paramBuffer));
}

CallCapture CaptureInvalidateTexSubImage(const State &glState,
                                         bool isCallValid,
                                         TextureID texturePacked,
                                         GLint level,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLint zoffset,
                                         GLsizei width,
                                         GLsizei height,
                                         GLsizei depth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);

    return CallCapture(angle::EntryPoint::GLInvalidateTexSubImage, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawArraysIndirect(const State &glState,
                                           bool isCallValid,
                                           PrimitiveMode modePacked,
                                           const void *indirect,
                                           GLsizei drawcount,
                                           GLsizei stride)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indirect, &indirectParam.value);
        CaptureMultiDrawArraysIndirect_indirect(glState, isCallValid, modePacked, indirect,
                                                drawcount, stride, &indirectParam);
        paramBuffer.addParam(std::move(indirectParam));
    }
    else
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indirectParam.value);
        paramBuffer.addParam(std::move(indirectParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    return CallCapture(angle::EntryPoint::GLMultiDrawArraysIndirect, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsIndirect(const State &glState,
                                             bool isCallValid,
                                             PrimitiveMode modePacked,
                                             DrawElementsType typePacked,
                                             const void *indirect,
                                             GLsizei drawcount,
                                             GLsizei stride)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indirect, &indirectParam.value);
        CaptureMultiDrawElementsIndirect_indirect(glState, isCallValid, modePacked, typePacked,
                                                  indirect, drawcount, stride, &indirectParam);
        paramBuffer.addParam(std::move(indirectParam));
    }
    else
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indirectParam.value);
        paramBuffer.addParam(std::move(indirectParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    return CallCapture(angle::EntryPoint::GLMultiDrawElementsIndirect, std::move(paramBuffer));
}

CallCapture CaptureShaderStorageBlockBinding(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             GLuint storageBlockIndex,
                                             GLuint storageBlockBinding)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("storageBlockIndex", ParamType::TGLuint, storageBlockIndex);
    paramBuffer.addValueParam("storageBlockBinding", ParamType::TGLuint, storageBlockBinding);

    return CallCapture(angle::EntryPoint::GLShaderStorageBlockBinding, std::move(paramBuffer));
}

CallCapture CaptureTextureView(const State &glState,
                               bool isCallValid,
                               TextureID texturePacked,
                               GLenum target,
                               GLuint origtexture,
                               GLenum internalformat,
                               GLuint minlevel,
                               GLuint numlevels,
                               GLuint minlayer,
                               GLuint numlayers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addEnumParam("target", BigGLEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("origtexture", ParamType::TGLuint, origtexture);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("minlevel", ParamType::TGLuint, minlevel);
    paramBuffer.addValueParam("numlevels", ParamType::TGLuint, numlevels);
    paramBuffer.addValueParam("minlayer", ParamType::TGLuint, minlayer);
    paramBuffer.addValueParam("numlayers", ParamType::TGLuint, numlayers);

    return CallCapture(angle::EntryPoint::GLTextureView, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribLFormat(const State &glState,
                                       bool isCallValid,
                                       GLuint attribindex,
                                       GLint size,
                                       GLenum type,
                                       GLuint relativeoffset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("attribindex", ParamType::TGLuint, attribindex);
    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addEnumParam("type", BigGLEnum::VertexAttribLType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("relativeoffset", ParamType::TGLuint, relativeoffset);

    return CallCapture(angle::EntryPoint::GLVertexAttribLFormat, std::move(paramBuffer));
}

// GL 4.4
CallCapture CaptureBindBuffersBase(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLuint first,
                                   GLsizei count,
                                   const BufferID *buffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::BufferTargetARB, ParamType::TGLenum, target);
    paramBuffer.addValueParam("first", ParamType::TGLuint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, buffersPacked, &buffersPackedParam.value);
        CaptureBindBuffersBase_buffersPacked(glState, isCallValid, target, first, count,
                                             buffersPacked, &buffersPackedParam);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }
    else
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, static_cast<const BufferID *>(nullptr),
                       &buffersPackedParam.value);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLBindBuffersBase, std::move(paramBuffer));
}

CallCapture CaptureBindBuffersRange(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    GLuint first,
                                    GLsizei count,
                                    const BufferID *buffersPacked,
                                    const GLintptr *offsets,
                                    const GLsizeiptr *sizes)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::BufferTargetARB, ParamType::TGLenum, target);
    paramBuffer.addValueParam("first", ParamType::TGLuint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, buffersPacked, &buffersPackedParam.value);
        CaptureBindBuffersRange_buffersPacked(glState, isCallValid, target, first, count,
                                              buffersPacked, offsets, sizes, &buffersPackedParam);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }
    else
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, static_cast<const BufferID *>(nullptr),
                       &buffersPackedParam.value);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }

    if (isCallValid)
    {
        ParamCapture offsetsParam("offsets", ParamType::TGLintptrConstPointer);
        InitParamValue(ParamType::TGLintptrConstPointer, offsets, &offsetsParam.value);
        CaptureBindBuffersRange_offsets(glState, isCallValid, target, first, count, buffersPacked,
                                        offsets, sizes, &offsetsParam);
        paramBuffer.addParam(std::move(offsetsParam));
    }
    else
    {
        ParamCapture offsetsParam("offsets", ParamType::TGLintptrConstPointer);
        InitParamValue(ParamType::TGLintptrConstPointer, static_cast<const GLintptr *>(nullptr),
                       &offsetsParam.value);
        paramBuffer.addParam(std::move(offsetsParam));
    }

    if (isCallValid)
    {
        ParamCapture sizesParam("sizes", ParamType::TGLsizeiptrConstPointer);
        InitParamValue(ParamType::TGLsizeiptrConstPointer, sizes, &sizesParam.value);
        CaptureBindBuffersRange_sizes(glState, isCallValid, target, first, count, buffersPacked,
                                      offsets, sizes, &sizesParam);
        paramBuffer.addParam(std::move(sizesParam));
    }
    else
    {
        ParamCapture sizesParam("sizes", ParamType::TGLsizeiptrConstPointer);
        InitParamValue(ParamType::TGLsizeiptrConstPointer, static_cast<const GLsizeiptr *>(nullptr),
                       &sizesParam.value);
        paramBuffer.addParam(std::move(sizesParam));
    }

    return CallCapture(angle::EntryPoint::GLBindBuffersRange, std::move(paramBuffer));
}

CallCapture CaptureBindImageTextures(const State &glState,
                                     bool isCallValid,
                                     GLuint first,
                                     GLsizei count,
                                     const GLuint *textures)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("first", ParamType::TGLuint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture texturesParam("textures", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, textures, &texturesParam.value);
        CaptureBindImageTextures_textures(glState, isCallValid, first, count, textures,
                                          &texturesParam);
        paramBuffer.addParam(std::move(texturesParam));
    }
    else
    {
        ParamCapture texturesParam("textures", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &texturesParam.value);
        paramBuffer.addParam(std::move(texturesParam));
    }

    return CallCapture(angle::EntryPoint::GLBindImageTextures, std::move(paramBuffer));
}

CallCapture CaptureBindSamplers(const State &glState,
                                bool isCallValid,
                                GLuint first,
                                GLsizei count,
                                const GLuint *samplers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("first", ParamType::TGLuint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture samplersParam("samplers", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, samplers, &samplersParam.value);
        CaptureBindSamplers_samplers(glState, isCallValid, first, count, samplers, &samplersParam);
        paramBuffer.addParam(std::move(samplersParam));
    }
    else
    {
        ParamCapture samplersParam("samplers", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &samplersParam.value);
        paramBuffer.addParam(std::move(samplersParam));
    }

    return CallCapture(angle::EntryPoint::GLBindSamplers, std::move(paramBuffer));
}

CallCapture CaptureBindTextures(const State &glState,
                                bool isCallValid,
                                GLuint first,
                                GLsizei count,
                                const GLuint *textures)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("first", ParamType::TGLuint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture texturesParam("textures", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, textures, &texturesParam.value);
        CaptureBindTextures_textures(glState, isCallValid, first, count, textures, &texturesParam);
        paramBuffer.addParam(std::move(texturesParam));
    }
    else
    {
        ParamCapture texturesParam("textures", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &texturesParam.value);
        paramBuffer.addParam(std::move(texturesParam));
    }

    return CallCapture(angle::EntryPoint::GLBindTextures, std::move(paramBuffer));
}

CallCapture CaptureBindVertexBuffers(const State &glState,
                                     bool isCallValid,
                                     GLuint first,
                                     GLsizei count,
                                     const BufferID *buffersPacked,
                                     const GLintptr *offsets,
                                     const GLsizei *strides)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("first", ParamType::TGLuint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, buffersPacked, &buffersPackedParam.value);
        CaptureBindVertexBuffers_buffersPacked(glState, isCallValid, first, count, buffersPacked,
                                               offsets, strides, &buffersPackedParam);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }
    else
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, static_cast<const BufferID *>(nullptr),
                       &buffersPackedParam.value);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }

    if (isCallValid)
    {
        ParamCapture offsetsParam("offsets", ParamType::TGLintptrConstPointer);
        InitParamValue(ParamType::TGLintptrConstPointer, offsets, &offsetsParam.value);
        CaptureBindVertexBuffers_offsets(glState, isCallValid, first, count, buffersPacked, offsets,
                                         strides, &offsetsParam);
        paramBuffer.addParam(std::move(offsetsParam));
    }
    else
    {
        ParamCapture offsetsParam("offsets", ParamType::TGLintptrConstPointer);
        InitParamValue(ParamType::TGLintptrConstPointer, static_cast<const GLintptr *>(nullptr),
                       &offsetsParam.value);
        paramBuffer.addParam(std::move(offsetsParam));
    }

    if (isCallValid)
    {
        ParamCapture stridesParam("strides", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, strides, &stridesParam.value);
        CaptureBindVertexBuffers_strides(glState, isCallValid, first, count, buffersPacked, offsets,
                                         strides, &stridesParam);
        paramBuffer.addParam(std::move(stridesParam));
    }
    else
    {
        ParamCapture stridesParam("strides", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &stridesParam.value);
        paramBuffer.addParam(std::move(stridesParam));
    }

    return CallCapture(angle::EntryPoint::GLBindVertexBuffers, std::move(paramBuffer));
}

CallCapture CaptureBufferStorage(const State &glState,
                                 bool isCallValid,
                                 BufferBinding targetPacked,
                                 GLsizeiptr size,
                                 const void *data,
                                 GLbitfield flags)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureBufferStorage_data(glState, isCallValid, targetPacked, size, data, flags,
                                  &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    paramBuffer.addEnumParam("flags", BigGLEnum::BufferStorageMask, ParamType::TGLbitfield, flags);

    return CallCapture(angle::EntryPoint::GLBufferStorage, std::move(paramBuffer));
}

CallCapture CaptureClearTexImage(const State &glState,
                                 bool isCallValid,
                                 TextureID texturePacked,
                                 GLint level,
                                 GLenum format,
                                 GLenum type,
                                 const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureClearTexImage_data(glState, isCallValid, texturePacked, level, format, type, data,
                                  &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLClearTexImage, std::move(paramBuffer));
}

CallCapture CaptureClearTexSubImage(const State &glState,
                                    bool isCallValid,
                                    TextureID texturePacked,
                                    GLint level,
                                    GLint xoffset,
                                    GLint yoffset,
                                    GLint zoffset,
                                    GLsizei width,
                                    GLsizei height,
                                    GLsizei depth,
                                    GLenum format,
                                    GLenum type,
                                    const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureClearTexSubImage_data(glState, isCallValid, texturePacked, level, xoffset, yoffset,
                                     zoffset, width, height, depth, format, type, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLClearTexSubImage, std::move(paramBuffer));
}

// GL 4.5
CallCapture CaptureBindTextureUnit(const State &glState,
                                   bool isCallValid,
                                   GLuint unit,
                                   TextureID texturePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("unit", ParamType::TGLuint, unit);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);

    return CallCapture(angle::EntryPoint::GLBindTextureUnit, std::move(paramBuffer));
}

CallCapture CaptureBlitNamedFramebuffer(const State &glState,
                                        bool isCallValid,
                                        GLuint readFramebuffer,
                                        GLuint drawFramebuffer,
                                        GLint srcX0,
                                        GLint srcY0,
                                        GLint srcX1,
                                        GLint srcY1,
                                        GLint dstX0,
                                        GLint dstY0,
                                        GLint dstX1,
                                        GLint dstY1,
                                        GLbitfield mask,
                                        GLenum filter)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("readFramebuffer", ParamType::TGLuint, readFramebuffer);
    paramBuffer.addValueParam("drawFramebuffer", ParamType::TGLuint, drawFramebuffer);
    paramBuffer.addValueParam("srcX0", ParamType::TGLint, srcX0);
    paramBuffer.addValueParam("srcY0", ParamType::TGLint, srcY0);
    paramBuffer.addValueParam("srcX1", ParamType::TGLint, srcX1);
    paramBuffer.addValueParam("srcY1", ParamType::TGLint, srcY1);
    paramBuffer.addValueParam("dstX0", ParamType::TGLint, dstX0);
    paramBuffer.addValueParam("dstY0", ParamType::TGLint, dstY0);
    paramBuffer.addValueParam("dstX1", ParamType::TGLint, dstX1);
    paramBuffer.addValueParam("dstY1", ParamType::TGLint, dstY1);
    paramBuffer.addEnumParam("mask", BigGLEnum::ClearBufferMask, ParamType::TGLbitfield, mask);
    paramBuffer.addEnumParam("filter", BigGLEnum::BlitFramebufferFilter, ParamType::TGLenum,
                             filter);

    return CallCapture(angle::EntryPoint::GLBlitNamedFramebuffer, std::move(paramBuffer));
}

CallCapture CaptureCheckNamedFramebufferStatus(const State &glState,
                                               bool isCallValid,
                                               FramebufferID framebufferPacked,
                                               GLenum target,
                                               GLenum returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addEnumParam("target", BigGLEnum::FramebufferTarget, ParamType::TGLenum, target);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLenum);
    InitParamValue(ParamType::TGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLCheckNamedFramebufferStatus, std::move(paramBuffer));
}

CallCapture CaptureClearNamedBufferData(const State &glState,
                                        bool isCallValid,
                                        BufferID bufferPacked,
                                        GLenum internalformat,
                                        GLenum format,
                                        GLenum type,
                                        const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureClearNamedBufferData_data(glState, isCallValid, bufferPacked, internalformat, format,
                                         type, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLClearNamedBufferData, std::move(paramBuffer));
}

CallCapture CaptureClearNamedBufferSubData(const State &glState,
                                           bool isCallValid,
                                           BufferID bufferPacked,
                                           GLenum internalformat,
                                           GLintptr offset,
                                           GLsizeiptr size,
                                           GLenum format,
                                           GLenum type,
                                           const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureClearNamedBufferSubData_data(glState, isCallValid, bufferPacked, internalformat,
                                            offset, size, format, type, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLClearNamedBufferSubData, std::move(paramBuffer));
}

CallCapture CaptureClearNamedFramebufferfi(const State &glState,
                                           bool isCallValid,
                                           FramebufferID framebufferPacked,
                                           GLenum buffer,
                                           GLint drawbuffer,
                                           GLfloat depth,
                                           GLint stencil)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addEnumParam("buffer", BigGLEnum::Buffer, ParamType::TGLenum, buffer);
    paramBuffer.addValueParam("drawbuffer", ParamType::TGLint, drawbuffer);
    paramBuffer.addValueParam("depth", ParamType::TGLfloat, depth);
    paramBuffer.addValueParam("stencil", ParamType::TGLint, stencil);

    return CallCapture(angle::EntryPoint::GLClearNamedFramebufferfi, std::move(paramBuffer));
}

CallCapture CaptureClearNamedFramebufferfv(const State &glState,
                                           bool isCallValid,
                                           FramebufferID framebufferPacked,
                                           GLenum buffer,
                                           GLint drawbuffer,
                                           const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addEnumParam("buffer", BigGLEnum::Buffer, ParamType::TGLenum, buffer);
    paramBuffer.addValueParam("drawbuffer", ParamType::TGLint, drawbuffer);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureClearNamedFramebufferfv_value(glState, isCallValid, framebufferPacked, buffer,
                                             drawbuffer, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLClearNamedFramebufferfv, std::move(paramBuffer));
}

CallCapture CaptureClearNamedFramebufferiv(const State &glState,
                                           bool isCallValid,
                                           FramebufferID framebufferPacked,
                                           GLenum buffer,
                                           GLint drawbuffer,
                                           const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addEnumParam("buffer", BigGLEnum::Buffer, ParamType::TGLenum, buffer);
    paramBuffer.addValueParam("drawbuffer", ParamType::TGLint, drawbuffer);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
        CaptureClearNamedFramebufferiv_value(glState, isCallValid, framebufferPacked, buffer,
                                             drawbuffer, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLClearNamedFramebufferiv, std::move(paramBuffer));
}

CallCapture CaptureClearNamedFramebufferuiv(const State &glState,
                                            bool isCallValid,
                                            FramebufferID framebufferPacked,
                                            GLenum buffer,
                                            GLint drawbuffer,
                                            const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addEnumParam("buffer", BigGLEnum::Buffer, ParamType::TGLenum, buffer);
    paramBuffer.addValueParam("drawbuffer", ParamType::TGLint, drawbuffer);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureClearNamedFramebufferuiv_value(glState, isCallValid, framebufferPacked, buffer,
                                              drawbuffer, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLClearNamedFramebufferuiv, std::move(paramBuffer));
}

CallCapture CaptureClipControl(const State &glState,
                               bool isCallValid,
                               ClipOrigin originPacked,
                               ClipDepthMode depthPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("originPacked", ParamType::TClipOrigin, originPacked);
    paramBuffer.addValueParam("depthPacked", ParamType::TClipDepthMode, depthPacked);

    return CallCapture(angle::EntryPoint::GLClipControl, std::move(paramBuffer));
}

CallCapture CaptureCompressedTextureSubImage1D(const State &glState,
                                               bool isCallValid,
                                               TextureID texturePacked,
                                               GLint level,
                                               GLint xoffset,
                                               GLsizei width,
                                               GLenum format,
                                               GLsizei imageSize,
                                               const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addEnumParam("format", BigGLEnum::InternalFormat, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTextureSubImage1D_data(glState, isCallValid, texturePacked, level, xoffset,
                                                width, format, imageSize, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLCompressedTextureSubImage1D, std::move(paramBuffer));
}

CallCapture CaptureCompressedTextureSubImage2D(const State &glState,
                                               bool isCallValid,
                                               TextureID texturePacked,
                                               GLint level,
                                               GLint xoffset,
                                               GLint yoffset,
                                               GLsizei width,
                                               GLsizei height,
                                               GLenum format,
                                               GLsizei imageSize,
                                               const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", BigGLEnum::InternalFormat, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTextureSubImage2D_data(glState, isCallValid, texturePacked, level, xoffset,
                                                yoffset, width, height, format, imageSize, data,
                                                &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLCompressedTextureSubImage2D, std::move(paramBuffer));
}

CallCapture CaptureCompressedTextureSubImage3D(const State &glState,
                                               bool isCallValid,
                                               TextureID texturePacked,
                                               GLint level,
                                               GLint xoffset,
                                               GLint yoffset,
                                               GLint zoffset,
                                               GLsizei width,
                                               GLsizei height,
                                               GLsizei depth,
                                               GLenum format,
                                               GLsizei imageSize,
                                               const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", BigGLEnum::InternalFormat, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTextureSubImage3D_data(glState, isCallValid, texturePacked, level, xoffset,
                                                yoffset, zoffset, width, height, depth, format,
                                                imageSize, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLCompressedTextureSubImage3D, std::move(paramBuffer));
}

CallCapture CaptureCopyNamedBufferSubData(const State &glState,
                                          bool isCallValid,
                                          GLuint readBuffer,
                                          GLuint writeBuffer,
                                          GLintptr readOffset,
                                          GLintptr writeOffset,
                                          GLsizeiptr size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("readBuffer", ParamType::TGLuint, readBuffer);
    paramBuffer.addValueParam("writeBuffer", ParamType::TGLuint, writeBuffer);
    paramBuffer.addValueParam("readOffset", ParamType::TGLintptr, readOffset);
    paramBuffer.addValueParam("writeOffset", ParamType::TGLintptr, writeOffset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    return CallCapture(angle::EntryPoint::GLCopyNamedBufferSubData, std::move(paramBuffer));
}

CallCapture CaptureCopyTextureSubImage1D(const State &glState,
                                         bool isCallValid,
                                         TextureID texturePacked,
                                         GLint level,
                                         GLint xoffset,
                                         GLint x,
                                         GLint y,
                                         GLsizei width)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);

    return CallCapture(angle::EntryPoint::GLCopyTextureSubImage1D, std::move(paramBuffer));
}

CallCapture CaptureCopyTextureSubImage2D(const State &glState,
                                         bool isCallValid,
                                         TextureID texturePacked,
                                         GLint level,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLint x,
                                         GLint y,
                                         GLsizei width,
                                         GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLCopyTextureSubImage2D, std::move(paramBuffer));
}

CallCapture CaptureCopyTextureSubImage3D(const State &glState,
                                         bool isCallValid,
                                         TextureID texturePacked,
                                         GLint level,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLint zoffset,
                                         GLint x,
                                         GLint y,
                                         GLsizei width,
                                         GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLCopyTextureSubImage3D, std::move(paramBuffer));
}

CallCapture CaptureCreateBuffers(const State &glState,
                                 bool isCallValid,
                                 GLsizei n,
                                 BufferID *buffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDPointer);
        InitParamValue(ParamType::TBufferIDPointer, buffersPacked, &buffersPackedParam.value);
        CaptureCreateBuffers_buffersPacked(glState, isCallValid, n, buffersPacked,
                                           &buffersPackedParam);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }
    else
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDPointer);
        InitParamValue(ParamType::TBufferIDPointer, static_cast<BufferID *>(nullptr),
                       &buffersPackedParam.value);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLCreateBuffers, std::move(paramBuffer));
}

CallCapture CaptureCreateFramebuffers(const State &glState,
                                      bool isCallValid,
                                      GLsizei n,
                                      GLuint *framebuffers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture framebuffersParam("framebuffers", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, framebuffers, &framebuffersParam.value);
        CaptureCreateFramebuffers_framebuffers(glState, isCallValid, n, framebuffers,
                                               &framebuffersParam);
        paramBuffer.addParam(std::move(framebuffersParam));
    }
    else
    {
        ParamCapture framebuffersParam("framebuffers", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &framebuffersParam.value);
        paramBuffer.addParam(std::move(framebuffersParam));
    }

    return CallCapture(angle::EntryPoint::GLCreateFramebuffers, std::move(paramBuffer));
}

CallCapture CaptureCreateProgramPipelines(const State &glState,
                                          bool isCallValid,
                                          GLsizei n,
                                          GLuint *pipelines)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture pipelinesParam("pipelines", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, pipelines, &pipelinesParam.value);
        CaptureCreateProgramPipelines_pipelines(glState, isCallValid, n, pipelines,
                                                &pipelinesParam);
        paramBuffer.addParam(std::move(pipelinesParam));
    }
    else
    {
        ParamCapture pipelinesParam("pipelines", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &pipelinesParam.value);
        paramBuffer.addParam(std::move(pipelinesParam));
    }

    return CallCapture(angle::EntryPoint::GLCreateProgramPipelines, std::move(paramBuffer));
}

CallCapture CaptureCreateQueries(const State &glState,
                                 bool isCallValid,
                                 GLenum target,
                                 GLsizei n,
                                 GLuint *ids)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::QueryTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture idsParam("ids", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, ids, &idsParam.value);
        CaptureCreateQueries_ids(glState, isCallValid, target, n, ids, &idsParam);
        paramBuffer.addParam(std::move(idsParam));
    }
    else
    {
        ParamCapture idsParam("ids", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr), &idsParam.value);
        paramBuffer.addParam(std::move(idsParam));
    }

    return CallCapture(angle::EntryPoint::GLCreateQueries, std::move(paramBuffer));
}

CallCapture CaptureCreateRenderbuffers(const State &glState,
                                       bool isCallValid,
                                       GLsizei n,
                                       RenderbufferID *renderbuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture renderbuffersPackedParam("renderbuffersPacked",
                                              ParamType::TRenderbufferIDPointer);
        InitParamValue(ParamType::TRenderbufferIDPointer, renderbuffersPacked,
                       &renderbuffersPackedParam.value);
        CaptureCreateRenderbuffers_renderbuffersPacked(glState, isCallValid, n, renderbuffersPacked,
                                                       &renderbuffersPackedParam);
        paramBuffer.addParam(std::move(renderbuffersPackedParam));
    }
    else
    {
        ParamCapture renderbuffersPackedParam("renderbuffersPacked",
                                              ParamType::TRenderbufferIDPointer);
        InitParamValue(ParamType::TRenderbufferIDPointer, static_cast<RenderbufferID *>(nullptr),
                       &renderbuffersPackedParam.value);
        paramBuffer.addParam(std::move(renderbuffersPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLCreateRenderbuffers, std::move(paramBuffer));
}

CallCapture CaptureCreateSamplers(const State &glState,
                                  bool isCallValid,
                                  GLsizei n,
                                  GLuint *samplers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture samplersParam("samplers", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, samplers, &samplersParam.value);
        CaptureCreateSamplers_samplers(glState, isCallValid, n, samplers, &samplersParam);
        paramBuffer.addParam(std::move(samplersParam));
    }
    else
    {
        ParamCapture samplersParam("samplers", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &samplersParam.value);
        paramBuffer.addParam(std::move(samplersParam));
    }

    return CallCapture(angle::EntryPoint::GLCreateSamplers, std::move(paramBuffer));
}

CallCapture CaptureCreateTextures(const State &glState,
                                  bool isCallValid,
                                  GLenum target,
                                  GLsizei n,
                                  GLuint *textures)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture texturesParam("textures", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, textures, &texturesParam.value);
        CaptureCreateTextures_textures(glState, isCallValid, target, n, textures, &texturesParam);
        paramBuffer.addParam(std::move(texturesParam));
    }
    else
    {
        ParamCapture texturesParam("textures", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &texturesParam.value);
        paramBuffer.addParam(std::move(texturesParam));
    }

    return CallCapture(angle::EntryPoint::GLCreateTextures, std::move(paramBuffer));
}

CallCapture CaptureCreateTransformFeedbacks(const State &glState,
                                            bool isCallValid,
                                            GLsizei n,
                                            GLuint *ids)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture idsParam("ids", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, ids, &idsParam.value);
        CaptureCreateTransformFeedbacks_ids(glState, isCallValid, n, ids, &idsParam);
        paramBuffer.addParam(std::move(idsParam));
    }
    else
    {
        ParamCapture idsParam("ids", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr), &idsParam.value);
        paramBuffer.addParam(std::move(idsParam));
    }

    return CallCapture(angle::EntryPoint::GLCreateTransformFeedbacks, std::move(paramBuffer));
}

CallCapture CaptureCreateVertexArrays(const State &glState,
                                      bool isCallValid,
                                      GLsizei n,
                                      VertexArrayID *arraysPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture arraysPackedParam("arraysPacked", ParamType::TVertexArrayIDPointer);
        InitParamValue(ParamType::TVertexArrayIDPointer, arraysPacked, &arraysPackedParam.value);
        CaptureCreateVertexArrays_arraysPacked(glState, isCallValid, n, arraysPacked,
                                               &arraysPackedParam);
        paramBuffer.addParam(std::move(arraysPackedParam));
    }
    else
    {
        ParamCapture arraysPackedParam("arraysPacked", ParamType::TVertexArrayIDPointer);
        InitParamValue(ParamType::TVertexArrayIDPointer, static_cast<VertexArrayID *>(nullptr),
                       &arraysPackedParam.value);
        paramBuffer.addParam(std::move(arraysPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLCreateVertexArrays, std::move(paramBuffer));
}

CallCapture CaptureDisableVertexArrayAttrib(const State &glState,
                                            bool isCallValid,
                                            VertexArrayID vaobjPacked,
                                            GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("vaobjPacked", ParamType::TVertexArrayID, vaobjPacked);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(angle::EntryPoint::GLDisableVertexArrayAttrib, std::move(paramBuffer));
}

CallCapture CaptureEnableVertexArrayAttrib(const State &glState,
                                           bool isCallValid,
                                           VertexArrayID vaobjPacked,
                                           GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("vaobjPacked", ParamType::TVertexArrayID, vaobjPacked);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(angle::EntryPoint::GLEnableVertexArrayAttrib, std::move(paramBuffer));
}

CallCapture CaptureFlushMappedNamedBufferRange(const State &glState,
                                               bool isCallValid,
                                               BufferID bufferPacked,
                                               GLintptr offset,
                                               GLsizeiptr length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("length", ParamType::TGLsizeiptr, length);

    return CallCapture(angle::EntryPoint::GLFlushMappedNamedBufferRange, std::move(paramBuffer));
}

CallCapture CaptureGenerateTextureMipmap(const State &glState,
                                         bool isCallValid,
                                         TextureID texturePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);

    return CallCapture(angle::EntryPoint::GLGenerateTextureMipmap, std::move(paramBuffer));
}

CallCapture CaptureGetCompressedTextureImage(const State &glState,
                                             bool isCallValid,
                                             TextureID texturePacked,
                                             GLint level,
                                             GLsizei bufSize,
                                             void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
        CaptureGetCompressedTextureImage_pixels(glState, isCallValid, texturePacked, level, bufSize,
                                                pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetCompressedTextureImage, std::move(paramBuffer));
}

CallCapture CaptureGetCompressedTextureSubImage(const State &glState,
                                                bool isCallValid,
                                                TextureID texturePacked,
                                                GLint level,
                                                GLint xoffset,
                                                GLint yoffset,
                                                GLint zoffset,
                                                GLsizei width,
                                                GLsizei height,
                                                GLsizei depth,
                                                GLsizei bufSize,
                                                void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
        CaptureGetCompressedTextureSubImage_pixels(glState, isCallValid, texturePacked, level,
                                                   xoffset, yoffset, zoffset, width, height, depth,
                                                   bufSize, pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetCompressedTextureSubImage, std::move(paramBuffer));
}

CallCapture CaptureGetNamedBufferParameteri64v(const State &glState,
                                               bool isCallValid,
                                               BufferID bufferPacked,
                                               GLenum pname,
                                               GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::AllEnums, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
        CaptureGetNamedBufferParameteri64v_params(glState, isCallValid, bufferPacked, pname, params,
                                                  &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetNamedBufferParameteri64v, std::move(paramBuffer));
}

CallCapture CaptureGetNamedBufferParameteriv(const State &glState,
                                             bool isCallValid,
                                             BufferID bufferPacked,
                                             GLenum pname,
                                             GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::AllEnums, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetNamedBufferParameteriv_params(glState, isCallValid, bufferPacked, pname, params,
                                                &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetNamedBufferParameteriv, std::move(paramBuffer));
}

CallCapture CaptureGetNamedBufferPointerv(const State &glState,
                                          bool isCallValid,
                                          BufferID bufferPacked,
                                          GLenum pname,
                                          void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::AllEnums, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
        CaptureGetNamedBufferPointerv_params(glState, isCallValid, bufferPacked, pname, params,
                                             &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetNamedBufferPointerv, std::move(paramBuffer));
}

CallCapture CaptureGetNamedBufferSubData(const State &glState,
                                         bool isCallValid,
                                         BufferID bufferPacked,
                                         GLintptr offset,
                                         GLsizeiptr size,
                                         void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, data, &dataParam.value);
        CaptureGetNamedBufferSubData_data(glState, isCallValid, bufferPacked, offset, size, data,
                                          &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLGetNamedBufferSubData, std::move(paramBuffer));
}

CallCapture CaptureGetNamedFramebufferAttachmentParameteriv(const State &glState,
                                                            bool isCallValid,
                                                            FramebufferID framebufferPacked,
                                                            GLenum attachment,
                                                            GLenum pname,
                                                            GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addEnumParam("attachment", BigGLEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addEnumParam("pname", BigGLEnum::FramebufferAttachmentParameterName,
                             ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetNamedFramebufferAttachmentParameteriv_params(
            glState, isCallValid, framebufferPacked, attachment, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetNamedFramebufferAttachmentParameteriv,
                       std::move(paramBuffer));
}

CallCapture CaptureGetNamedFramebufferParameteriv(const State &glState,
                                                  bool isCallValid,
                                                  FramebufferID framebufferPacked,
                                                  GLenum pname,
                                                  GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::GetFramebufferParameter, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, param, &paramParam.value);
        CaptureGetNamedFramebufferParameteriv_param(glState, isCallValid, framebufferPacked, pname,
                                                    param, &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLGetNamedFramebufferParameteriv, std::move(paramBuffer));
}

CallCapture CaptureGetNamedRenderbufferParameteriv(const State &glState,
                                                   bool isCallValid,
                                                   RenderbufferID renderbufferPacked,
                                                   GLenum pname,
                                                   GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::RenderbufferParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetNamedRenderbufferParameteriv_params(glState, isCallValid, renderbufferPacked,
                                                      pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetNamedRenderbufferParameteriv,
                       std::move(paramBuffer));
}

CallCapture CaptureGetQueryBufferObjecti64v(const State &glState,
                                            bool isCallValid,
                                            GLuint id,
                                            BufferID bufferPacked,
                                            GLenum pname,
                                            GLintptr offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::QueryObjectParameterName, ParamType::TGLenum,
                             pname);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);

    return CallCapture(angle::EntryPoint::GLGetQueryBufferObjecti64v, std::move(paramBuffer));
}

CallCapture CaptureGetQueryBufferObjectiv(const State &glState,
                                          bool isCallValid,
                                          GLuint id,
                                          BufferID bufferPacked,
                                          GLenum pname,
                                          GLintptr offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::QueryObjectParameterName, ParamType::TGLenum,
                             pname);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);

    return CallCapture(angle::EntryPoint::GLGetQueryBufferObjectiv, std::move(paramBuffer));
}

CallCapture CaptureGetQueryBufferObjectui64v(const State &glState,
                                             bool isCallValid,
                                             GLuint id,
                                             BufferID bufferPacked,
                                             GLenum pname,
                                             GLintptr offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::QueryObjectParameterName, ParamType::TGLenum,
                             pname);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);

    return CallCapture(angle::EntryPoint::GLGetQueryBufferObjectui64v, std::move(paramBuffer));
}

CallCapture CaptureGetQueryBufferObjectuiv(const State &glState,
                                           bool isCallValid,
                                           GLuint id,
                                           BufferID bufferPacked,
                                           GLenum pname,
                                           GLintptr offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::QueryObjectParameterName, ParamType::TGLenum,
                             pname);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);

    return CallCapture(angle::EntryPoint::GLGetQueryBufferObjectuiv, std::move(paramBuffer));
}

CallCapture CaptureGetTextureImage(const State &glState,
                                   bool isCallValid,
                                   TextureID texturePacked,
                                   GLint level,
                                   GLenum format,
                                   GLenum type,
                                   GLsizei bufSize,
                                   void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
        CaptureGetTextureImage_pixels(glState, isCallValid, texturePacked, level, format, type,
                                      bufSize, pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTextureImage, std::move(paramBuffer));
}

CallCapture CaptureGetTextureLevelParameterfv(const State &glState,
                                              bool isCallValid,
                                              TextureID texturePacked,
                                              GLint level,
                                              GLenum pname,
                                              GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", BigGLEnum::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetTextureLevelParameterfv_params(glState, isCallValid, texturePacked, level, pname,
                                                 params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTextureLevelParameterfv, std::move(paramBuffer));
}

CallCapture CaptureGetTextureLevelParameteriv(const State &glState,
                                              bool isCallValid,
                                              TextureID texturePacked,
                                              GLint level,
                                              GLenum pname,
                                              GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", BigGLEnum::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTextureLevelParameteriv_params(glState, isCallValid, texturePacked, level, pname,
                                                 params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTextureLevelParameteriv, std::move(paramBuffer));
}

CallCapture CaptureGetTextureParameterIiv(const State &glState,
                                          bool isCallValid,
                                          TextureID texturePacked,
                                          GLenum pname,
                                          GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTextureParameterIiv_params(glState, isCallValid, texturePacked, pname, params,
                                             &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTextureParameterIiv, std::move(paramBuffer));
}

CallCapture CaptureGetTextureParameterIuiv(const State &glState,
                                           bool isCallValid,
                                           TextureID texturePacked,
                                           GLenum pname,
                                           GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetTextureParameterIuiv_params(glState, isCallValid, texturePacked, pname, params,
                                              &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTextureParameterIuiv, std::move(paramBuffer));
}

CallCapture CaptureGetTextureParameterfv(const State &glState,
                                         bool isCallValid,
                                         TextureID texturePacked,
                                         GLenum pname,
                                         GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetTextureParameterfv_params(glState, isCallValid, texturePacked, pname, params,
                                            &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTextureParameterfv, std::move(paramBuffer));
}

CallCapture CaptureGetTextureParameteriv(const State &glState,
                                         bool isCallValid,
                                         TextureID texturePacked,
                                         GLenum pname,
                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTextureParameteriv_params(glState, isCallValid, texturePacked, pname, params,
                                            &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTextureParameteriv, std::move(paramBuffer));
}

CallCapture CaptureGetTextureSubImage(const State &glState,
                                      bool isCallValid,
                                      TextureID texturePacked,
                                      GLint level,
                                      GLint xoffset,
                                      GLint yoffset,
                                      GLint zoffset,
                                      GLsizei width,
                                      GLsizei height,
                                      GLsizei depth,
                                      GLenum format,
                                      GLenum type,
                                      GLsizei bufSize,
                                      void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
        CaptureGetTextureSubImage_pixels(glState, isCallValid, texturePacked, level, xoffset,
                                         yoffset, zoffset, width, height, depth, format, type,
                                         bufSize, pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTextureSubImage, std::move(paramBuffer));
}

CallCapture CaptureGetTransformFeedbacki64_v(const State &glState,
                                             bool isCallValid,
                                             GLuint xfb,
                                             GLenum pname,
                                             GLuint index,
                                             GLint64 *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("xfb", ParamType::TGLuint, xfb);
    paramBuffer.addEnumParam("pname", BigGLEnum::TransformFeedbackPName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, param, &paramParam.value);
        CaptureGetTransformFeedbacki64_v_param(glState, isCallValid, xfb, pname, index, param,
                                               &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTransformFeedbacki64_v, std::move(paramBuffer));
}

CallCapture CaptureGetTransformFeedbacki_v(const State &glState,
                                           bool isCallValid,
                                           GLuint xfb,
                                           GLenum pname,
                                           GLuint index,
                                           GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("xfb", ParamType::TGLuint, xfb);
    paramBuffer.addEnumParam("pname", BigGLEnum::TransformFeedbackPName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, param, &paramParam.value);
        CaptureGetTransformFeedbacki_v_param(glState, isCallValid, xfb, pname, index, param,
                                             &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTransformFeedbacki_v, std::move(paramBuffer));
}

CallCapture CaptureGetTransformFeedbackiv(const State &glState,
                                          bool isCallValid,
                                          GLuint xfb,
                                          GLenum pname,
                                          GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("xfb", ParamType::TGLuint, xfb);
    paramBuffer.addEnumParam("pname", BigGLEnum::TransformFeedbackPName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, param, &paramParam.value);
        CaptureGetTransformFeedbackiv_param(glState, isCallValid, xfb, pname, param, &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTransformFeedbackiv, std::move(paramBuffer));
}

CallCapture CaptureGetVertexArrayIndexed64iv(const State &glState,
                                             bool isCallValid,
                                             VertexArrayID vaobjPacked,
                                             GLuint index,
                                             GLenum pname,
                                             GLint64 *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("vaobjPacked", ParamType::TVertexArrayID, vaobjPacked);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", BigGLEnum::VertexArrayPName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, param, &paramParam.value);
        CaptureGetVertexArrayIndexed64iv_param(glState, isCallValid, vaobjPacked, index, pname,
                                               param, &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLGetVertexArrayIndexed64iv, std::move(paramBuffer));
}

CallCapture CaptureGetVertexArrayIndexediv(const State &glState,
                                           bool isCallValid,
                                           VertexArrayID vaobjPacked,
                                           GLuint index,
                                           GLenum pname,
                                           GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("vaobjPacked", ParamType::TVertexArrayID, vaobjPacked);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", BigGLEnum::VertexArrayPName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, param, &paramParam.value);
        CaptureGetVertexArrayIndexediv_param(glState, isCallValid, vaobjPacked, index, pname, param,
                                             &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLGetVertexArrayIndexediv, std::move(paramBuffer));
}

CallCapture CaptureGetVertexArrayiv(const State &glState,
                                    bool isCallValid,
                                    VertexArrayID vaobjPacked,
                                    GLenum pname,
                                    GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("vaobjPacked", ParamType::TVertexArrayID, vaobjPacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::VertexArrayPName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, param, &paramParam.value);
        CaptureGetVertexArrayiv_param(glState, isCallValid, vaobjPacked, pname, param, &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLGetVertexArrayiv, std::move(paramBuffer));
}

CallCapture CaptureGetnColorTable(const State &glState,
                                  bool isCallValid,
                                  GLenum target,
                                  GLenum format,
                                  GLenum type,
                                  GLsizei bufSize,
                                  void *table)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::ColorTableTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture tableParam("table", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, table, &tableParam.value);
        CaptureGetnColorTable_table(glState, isCallValid, target, format, type, bufSize, table,
                                    &tableParam);
        paramBuffer.addParam(std::move(tableParam));
    }
    else
    {
        ParamCapture tableParam("table", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &tableParam.value);
        paramBuffer.addParam(std::move(tableParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnColorTable, std::move(paramBuffer));
}

CallCapture CaptureGetnCompressedTexImage(const State &glState,
                                          bool isCallValid,
                                          GLenum target,
                                          GLint lod,
                                          GLsizei bufSize,
                                          void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("lod", ParamType::TGLint, lod);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
        CaptureGetnCompressedTexImage_pixels(glState, isCallValid, target, lod, bufSize, pixels,
                                             &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnCompressedTexImage, std::move(paramBuffer));
}

CallCapture CaptureGetnConvolutionFilter(const State &glState,
                                         bool isCallValid,
                                         GLenum target,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         void *image)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::ConvolutionTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture imageParam("image", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, image, &imageParam.value);
        CaptureGetnConvolutionFilter_image(glState, isCallValid, target, format, type, bufSize,
                                           image, &imageParam);
        paramBuffer.addParam(std::move(imageParam));
    }
    else
    {
        ParamCapture imageParam("image", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &imageParam.value);
        paramBuffer.addParam(std::move(imageParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnConvolutionFilter, std::move(paramBuffer));
}

CallCapture CaptureGetnHistogram(const State &glState,
                                 bool isCallValid,
                                 GLenum target,
                                 GLboolean reset,
                                 GLenum format,
                                 GLenum type,
                                 GLsizei bufSize,
                                 void *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::HistogramTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("reset", ParamType::TGLboolean, reset);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture valuesParam("values", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, values, &valuesParam.value);
        CaptureGetnHistogram_values(glState, isCallValid, target, reset, format, type, bufSize,
                                    values, &valuesParam);
        paramBuffer.addParam(std::move(valuesParam));
    }
    else
    {
        ParamCapture valuesParam("values", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &valuesParam.value);
        paramBuffer.addParam(std::move(valuesParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnHistogram, std::move(paramBuffer));
}

CallCapture CaptureGetnMapdv(const State &glState,
                             bool isCallValid,
                             GLenum target,
                             GLenum query,
                             GLsizei bufSize,
                             GLdouble *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::MapTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("query", BigGLEnum::MapQuery, ParamType::TGLenum, query);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, v, &vParam.value);
        CaptureGetnMapdv_v(glState, isCallValid, target, query, bufSize, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, static_cast<GLdouble *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnMapdv, std::move(paramBuffer));
}

CallCapture CaptureGetnMapfv(const State &glState,
                             bool isCallValid,
                             GLenum target,
                             GLenum query,
                             GLsizei bufSize,
                             GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::MapTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("query", BigGLEnum::MapQuery, ParamType::TGLenum, query);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, v, &vParam.value);
        CaptureGetnMapfv_v(glState, isCallValid, target, query, bufSize, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr), &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnMapfv, std::move(paramBuffer));
}

CallCapture CaptureGetnMapiv(const State &glState,
                             bool isCallValid,
                             GLenum target,
                             GLenum query,
                             GLsizei bufSize,
                             GLint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::MapTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("query", BigGLEnum::MapQuery, ParamType::TGLenum, query);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, v, &vParam.value);
        CaptureGetnMapiv_v(glState, isCallValid, target, query, bufSize, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnMapiv, std::move(paramBuffer));
}

CallCapture CaptureGetnMinmax(const State &glState,
                              bool isCallValid,
                              GLenum target,
                              GLboolean reset,
                              GLenum format,
                              GLenum type,
                              GLsizei bufSize,
                              void *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::MinmaxTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("reset", ParamType::TGLboolean, reset);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture valuesParam("values", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, values, &valuesParam.value);
        CaptureGetnMinmax_values(glState, isCallValid, target, reset, format, type, bufSize, values,
                                 &valuesParam);
        paramBuffer.addParam(std::move(valuesParam));
    }
    else
    {
        ParamCapture valuesParam("values", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &valuesParam.value);
        paramBuffer.addParam(std::move(valuesParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnMinmax, std::move(paramBuffer));
}

CallCapture CaptureGetnPixelMapfv(const State &glState,
                                  bool isCallValid,
                                  GLenum map,
                                  GLsizei bufSize,
                                  GLfloat *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("map", BigGLEnum::PixelMap, ParamType::TGLenum, map);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture valuesParam("values", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, values, &valuesParam.value);
        CaptureGetnPixelMapfv_values(glState, isCallValid, map, bufSize, values, &valuesParam);
        paramBuffer.addParam(std::move(valuesParam));
    }
    else
    {
        ParamCapture valuesParam("values", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &valuesParam.value);
        paramBuffer.addParam(std::move(valuesParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnPixelMapfv, std::move(paramBuffer));
}

CallCapture CaptureGetnPixelMapuiv(const State &glState,
                                   bool isCallValid,
                                   GLenum map,
                                   GLsizei bufSize,
                                   GLuint *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("map", BigGLEnum::PixelMap, ParamType::TGLenum, map);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture valuesParam("values", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, values, &valuesParam.value);
        CaptureGetnPixelMapuiv_values(glState, isCallValid, map, bufSize, values, &valuesParam);
        paramBuffer.addParam(std::move(valuesParam));
    }
    else
    {
        ParamCapture valuesParam("values", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &valuesParam.value);
        paramBuffer.addParam(std::move(valuesParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnPixelMapuiv, std::move(paramBuffer));
}

CallCapture CaptureGetnPixelMapusv(const State &glState,
                                   bool isCallValid,
                                   GLenum map,
                                   GLsizei bufSize,
                                   GLushort *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("map", BigGLEnum::PixelMap, ParamType::TGLenum, map);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture valuesParam("values", ParamType::TGLushortPointer);
        InitParamValue(ParamType::TGLushortPointer, values, &valuesParam.value);
        CaptureGetnPixelMapusv_values(glState, isCallValid, map, bufSize, values, &valuesParam);
        paramBuffer.addParam(std::move(valuesParam));
    }
    else
    {
        ParamCapture valuesParam("values", ParamType::TGLushortPointer);
        InitParamValue(ParamType::TGLushortPointer, static_cast<GLushort *>(nullptr),
                       &valuesParam.value);
        paramBuffer.addParam(std::move(valuesParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnPixelMapusv, std::move(paramBuffer));
}

CallCapture CaptureGetnPolygonStipple(const State &glState,
                                      bool isCallValid,
                                      GLsizei bufSize,
                                      GLubyte *pattern)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture patternParam("pattern", ParamType::TGLubytePointer);
        InitParamValue(ParamType::TGLubytePointer, pattern, &patternParam.value);
        CaptureGetnPolygonStipple_pattern(glState, isCallValid, bufSize, pattern, &patternParam);
        paramBuffer.addParam(std::move(patternParam));
    }
    else
    {
        ParamCapture patternParam("pattern", ParamType::TGLubytePointer);
        InitParamValue(ParamType::TGLubytePointer, static_cast<GLubyte *>(nullptr),
                       &patternParam.value);
        paramBuffer.addParam(std::move(patternParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnPolygonStipple, std::move(paramBuffer));
}

CallCapture CaptureGetnSeparableFilter(const State &glState,
                                       bool isCallValid,
                                       GLenum target,
                                       GLenum format,
                                       GLenum type,
                                       GLsizei rowBufSize,
                                       void *row,
                                       GLsizei columnBufSize,
                                       void *column,
                                       void *span)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::SeparableTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("rowBufSize", ParamType::TGLsizei, rowBufSize);

    if (isCallValid)
    {
        ParamCapture rowParam("row", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, row, &rowParam.value);
        CaptureGetnSeparableFilter_row(glState, isCallValid, target, format, type, rowBufSize, row,
                                       columnBufSize, column, span, &rowParam);
        paramBuffer.addParam(std::move(rowParam));
    }
    else
    {
        ParamCapture rowParam("row", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &rowParam.value);
        paramBuffer.addParam(std::move(rowParam));
    }

    paramBuffer.addValueParam("columnBufSize", ParamType::TGLsizei, columnBufSize);

    if (isCallValid)
    {
        ParamCapture columnParam("column", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, column, &columnParam.value);
        CaptureGetnSeparableFilter_column(glState, isCallValid, target, format, type, rowBufSize,
                                          row, columnBufSize, column, span, &columnParam);
        paramBuffer.addParam(std::move(columnParam));
    }
    else
    {
        ParamCapture columnParam("column", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &columnParam.value);
        paramBuffer.addParam(std::move(columnParam));
    }

    if (isCallValid)
    {
        ParamCapture spanParam("span", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, span, &spanParam.value);
        CaptureGetnSeparableFilter_span(glState, isCallValid, target, format, type, rowBufSize, row,
                                        columnBufSize, column, span, &spanParam);
        paramBuffer.addParam(std::move(spanParam));
    }
    else
    {
        ParamCapture spanParam("span", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &spanParam.value);
        paramBuffer.addParam(std::move(spanParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnSeparableFilter, std::move(paramBuffer));
}

CallCapture CaptureGetnTexImage(const State &glState,
                                bool isCallValid,
                                GLenum target,
                                GLint level,
                                GLenum format,
                                GLenum type,
                                GLsizei bufSize,
                                void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
        CaptureGetnTexImage_pixels(glState, isCallValid, target, level, format, type, bufSize,
                                   pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnTexImage, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformdv(const State &glState,
                                 bool isCallValid,
                                 ShaderProgramID programPacked,
                                 UniformLocation locationPacked,
                                 GLsizei bufSize,
                                 GLdouble *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, params, &paramsParam.value);
        CaptureGetnUniformdv_params(glState, isCallValid, programPacked, locationPacked, bufSize,
                                    params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLdoublePointer);
        InitParamValue(ParamType::TGLdoublePointer, static_cast<GLdouble *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnUniformdv, std::move(paramBuffer));
}

CallCapture CaptureInvalidateNamedFramebufferData(const State &glState,
                                                  bool isCallValid,
                                                  FramebufferID framebufferPacked,
                                                  GLsizei numAttachments,
                                                  const GLenum *attachments)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addValueParam("numAttachments", ParamType::TGLsizei, numAttachments);

    if (isCallValid)
    {
        ParamCapture attachmentsParam("attachments", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, attachments, &attachmentsParam.value);
        CaptureInvalidateNamedFramebufferData_attachments(glState, isCallValid, framebufferPacked,
                                                          numAttachments, attachments,
                                                          &attachmentsParam);
        paramBuffer.addParam(std::move(attachmentsParam));
    }
    else
    {
        ParamCapture attachmentsParam("attachments", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &attachmentsParam.value);
        paramBuffer.addParam(std::move(attachmentsParam));
    }

    return CallCapture(angle::EntryPoint::GLInvalidateNamedFramebufferData, std::move(paramBuffer));
}

CallCapture CaptureInvalidateNamedFramebufferSubData(const State &glState,
                                                     bool isCallValid,
                                                     FramebufferID framebufferPacked,
                                                     GLsizei numAttachments,
                                                     const GLenum *attachments,
                                                     GLint x,
                                                     GLint y,
                                                     GLsizei width,
                                                     GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addValueParam("numAttachments", ParamType::TGLsizei, numAttachments);

    if (isCallValid)
    {
        ParamCapture attachmentsParam("attachments", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, attachments, &attachmentsParam.value);
        CaptureInvalidateNamedFramebufferSubData_attachments(
            glState, isCallValid, framebufferPacked, numAttachments, attachments, x, y, width,
            height, &attachmentsParam);
        paramBuffer.addParam(std::move(attachmentsParam));
    }
    else
    {
        ParamCapture attachmentsParam("attachments", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &attachmentsParam.value);
        paramBuffer.addParam(std::move(attachmentsParam));
    }

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLInvalidateNamedFramebufferSubData,
                       std::move(paramBuffer));
}

CallCapture CaptureMapNamedBuffer(const State &glState,
                                  bool isCallValid,
                                  BufferID bufferPacked,
                                  GLenum access,
                                  void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addEnumParam("access", BigGLEnum::BufferAccessARB, ParamType::TGLenum, access);

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLMapNamedBuffer, std::move(paramBuffer));
}

CallCapture CaptureMapNamedBufferRange(const State &glState,
                                       bool isCallValid,
                                       BufferID bufferPacked,
                                       GLintptr offset,
                                       GLsizeiptr length,
                                       GLbitfield access,
                                       void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("length", ParamType::TGLsizeiptr, length);
    paramBuffer.addEnumParam("access", BigGLEnum::MapBufferAccessMask, ParamType::TGLbitfield,
                             access);

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLMapNamedBufferRange, std::move(paramBuffer));
}

CallCapture CaptureNamedBufferData(const State &glState,
                                   bool isCallValid,
                                   BufferID bufferPacked,
                                   GLsizeiptr size,
                                   const void *data,
                                   GLenum usage)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureNamedBufferData_data(glState, isCallValid, bufferPacked, size, data, usage,
                                    &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    paramBuffer.addEnumParam("usage", BigGLEnum::VertexBufferObjectUsage, ParamType::TGLenum,
                             usage);

    return CallCapture(angle::EntryPoint::GLNamedBufferData, std::move(paramBuffer));
}

CallCapture CaptureNamedBufferStorage(const State &glState,
                                      bool isCallValid,
                                      BufferID bufferPacked,
                                      GLsizeiptr size,
                                      const void *data,
                                      GLbitfield flags)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureNamedBufferStorage_data(glState, isCallValid, bufferPacked, size, data, flags,
                                       &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    paramBuffer.addEnumParam("flags", BigGLEnum::BufferStorageMask, ParamType::TGLbitfield, flags);

    return CallCapture(angle::EntryPoint::GLNamedBufferStorage, std::move(paramBuffer));
}

CallCapture CaptureNamedBufferSubData(const State &glState,
                                      bool isCallValid,
                                      BufferID bufferPacked,
                                      GLintptr offset,
                                      GLsizeiptr size,
                                      const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureNamedBufferSubData_data(glState, isCallValid, bufferPacked, offset, size, data,
                                       &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLNamedBufferSubData, std::move(paramBuffer));
}

CallCapture CaptureNamedFramebufferDrawBuffer(const State &glState,
                                              bool isCallValid,
                                              FramebufferID framebufferPacked,
                                              GLenum buf)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addEnumParam("buf", BigGLEnum::ColorBuffer, ParamType::TGLenum, buf);

    return CallCapture(angle::EntryPoint::GLNamedFramebufferDrawBuffer, std::move(paramBuffer));
}

CallCapture CaptureNamedFramebufferDrawBuffers(const State &glState,
                                               bool isCallValid,
                                               FramebufferID framebufferPacked,
                                               GLsizei n,
                                               const GLenum *bufs)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture bufsParam("bufs", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, bufs, &bufsParam.value);
        CaptureNamedFramebufferDrawBuffers_bufs(glState, isCallValid, framebufferPacked, n, bufs,
                                                &bufsParam);
        paramBuffer.addParam(std::move(bufsParam));
    }
    else
    {
        ParamCapture bufsParam("bufs", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &bufsParam.value);
        paramBuffer.addParam(std::move(bufsParam));
    }

    return CallCapture(angle::EntryPoint::GLNamedFramebufferDrawBuffers, std::move(paramBuffer));
}

CallCapture CaptureNamedFramebufferParameteri(const State &glState,
                                              bool isCallValid,
                                              FramebufferID framebufferPacked,
                                              GLenum pname,
                                              GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::FramebufferParameterName, ParamType::TGLenum,
                             pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLNamedFramebufferParameteri, std::move(paramBuffer));
}

CallCapture CaptureNamedFramebufferReadBuffer(const State &glState,
                                              bool isCallValid,
                                              FramebufferID framebufferPacked,
                                              GLenum src)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addEnumParam("src", BigGLEnum::ColorBuffer, ParamType::TGLenum, src);

    return CallCapture(angle::EntryPoint::GLNamedFramebufferReadBuffer, std::move(paramBuffer));
}

CallCapture CaptureNamedFramebufferRenderbuffer(const State &glState,
                                                bool isCallValid,
                                                FramebufferID framebufferPacked,
                                                GLenum attachment,
                                                GLenum renderbuffertarget,
                                                RenderbufferID renderbufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addEnumParam("attachment", BigGLEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addEnumParam("renderbuffertarget", BigGLEnum::RenderbufferTarget,
                             ParamType::TGLenum, renderbuffertarget);
    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    return CallCapture(angle::EntryPoint::GLNamedFramebufferRenderbuffer, std::move(paramBuffer));
}

CallCapture CaptureNamedFramebufferTexture(const State &glState,
                                           bool isCallValid,
                                           FramebufferID framebufferPacked,
                                           GLenum attachment,
                                           TextureID texturePacked,
                                           GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addEnumParam("attachment", BigGLEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture(angle::EntryPoint::GLNamedFramebufferTexture, std::move(paramBuffer));
}

CallCapture CaptureNamedFramebufferTextureLayer(const State &glState,
                                                bool isCallValid,
                                                FramebufferID framebufferPacked,
                                                GLenum attachment,
                                                TextureID texturePacked,
                                                GLint level,
                                                GLint layer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addEnumParam("attachment", BigGLEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("layer", ParamType::TGLint, layer);

    return CallCapture(angle::EntryPoint::GLNamedFramebufferTextureLayer, std::move(paramBuffer));
}

CallCapture CaptureNamedRenderbufferStorage(const State &glState,
                                            bool isCallValid,
                                            RenderbufferID renderbufferPacked,
                                            GLenum internalformat,
                                            GLsizei width,
                                            GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLNamedRenderbufferStorage, std::move(paramBuffer));
}

CallCapture CaptureNamedRenderbufferStorageMultisample(const State &glState,
                                                       bool isCallValid,
                                                       RenderbufferID renderbufferPacked,
                                                       GLsizei samples,
                                                       GLenum internalformat,
                                                       GLsizei width,
                                                       GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLNamedRenderbufferStorageMultisample,
                       std::move(paramBuffer));
}

CallCapture CaptureTextureBarrier(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLTextureBarrier, std::move(paramBuffer));
}

CallCapture CaptureTextureBuffer(const State &glState,
                                 bool isCallValid,
                                 TextureID texturePacked,
                                 GLenum internalformat,
                                 BufferID bufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    return CallCapture(angle::EntryPoint::GLTextureBuffer, std::move(paramBuffer));
}

CallCapture CaptureTextureBufferRange(const State &glState,
                                      bool isCallValid,
                                      TextureID texturePacked,
                                      GLenum internalformat,
                                      BufferID bufferPacked,
                                      GLintptr offset,
                                      GLsizeiptr size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    return CallCapture(angle::EntryPoint::GLTextureBufferRange, std::move(paramBuffer));
}

CallCapture CaptureTextureParameterIiv(const State &glState,
                                       bool isCallValid,
                                       TextureID texturePacked,
                                       GLenum pname,
                                       const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::TextureParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureTextureParameterIiv_params(glState, isCallValid, texturePacked, pname, params,
                                          &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTextureParameterIiv, std::move(paramBuffer));
}

CallCapture CaptureTextureParameterIuiv(const State &glState,
                                        bool isCallValid,
                                        TextureID texturePacked,
                                        GLenum pname,
                                        const GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::TextureParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, params, &paramsParam.value);
        CaptureTextureParameterIuiv_params(glState, isCallValid, texturePacked, pname, params,
                                           &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTextureParameterIuiv, std::move(paramBuffer));
}

CallCapture CaptureTextureParameterf(const State &glState,
                                     bool isCallValid,
                                     TextureID texturePacked,
                                     GLenum pname,
                                     GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::TextureParameterName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(angle::EntryPoint::GLTextureParameterf, std::move(paramBuffer));
}

CallCapture CaptureTextureParameterfv(const State &glState,
                                      bool isCallValid,
                                      TextureID texturePacked,
                                      GLenum pname,
                                      const GLfloat *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::TextureParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, param, &paramParam.value);
        CaptureTextureParameterfv_param(glState, isCallValid, texturePacked, pname, param,
                                        &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLTextureParameterfv, std::move(paramBuffer));
}

CallCapture CaptureTextureParameteri(const State &glState,
                                     bool isCallValid,
                                     TextureID texturePacked,
                                     GLenum pname,
                                     GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::TextureParameterName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLTextureParameteri, std::move(paramBuffer));
}

CallCapture CaptureTextureParameteriv(const State &glState,
                                      bool isCallValid,
                                      TextureID texturePacked,
                                      GLenum pname,
                                      const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::TextureParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
        CaptureTextureParameteriv_param(glState, isCallValid, texturePacked, pname, param,
                                        &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLTextureParameteriv, std::move(paramBuffer));
}

CallCapture CaptureTextureStorage1D(const State &glState,
                                    bool isCallValid,
                                    TextureID texturePacked,
                                    GLsizei levels,
                                    GLenum internalformat,
                                    GLsizei width)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);

    return CallCapture(angle::EntryPoint::GLTextureStorage1D, std::move(paramBuffer));
}

CallCapture CaptureTextureStorage2D(const State &glState,
                                    bool isCallValid,
                                    TextureID texturePacked,
                                    GLsizei levels,
                                    GLenum internalformat,
                                    GLsizei width,
                                    GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLTextureStorage2D, std::move(paramBuffer));
}

CallCapture CaptureTextureStorage2DMultisample(const State &glState,
                                               bool isCallValid,
                                               TextureID texturePacked,
                                               GLsizei samples,
                                               GLenum internalformat,
                                               GLsizei width,
                                               GLsizei height,
                                               GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture(angle::EntryPoint::GLTextureStorage2DMultisample, std::move(paramBuffer));
}

CallCapture CaptureTextureStorage3D(const State &glState,
                                    bool isCallValid,
                                    TextureID texturePacked,
                                    GLsizei levels,
                                    GLenum internalformat,
                                    GLsizei width,
                                    GLsizei height,
                                    GLsizei depth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);

    return CallCapture(angle::EntryPoint::GLTextureStorage3D, std::move(paramBuffer));
}

CallCapture CaptureTextureStorage3DMultisample(const State &glState,
                                               bool isCallValid,
                                               TextureID texturePacked,
                                               GLsizei samples,
                                               GLenum internalformat,
                                               GLsizei width,
                                               GLsizei height,
                                               GLsizei depth,
                                               GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture(angle::EntryPoint::GLTextureStorage3DMultisample, std::move(paramBuffer));
}

CallCapture CaptureTextureSubImage1D(const State &glState,
                                     bool isCallValid,
                                     TextureID texturePacked,
                                     GLint level,
                                     GLint xoffset,
                                     GLsizei width,
                                     GLenum format,
                                     GLenum type,
                                     const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTextureSubImage1D_pixels(glState, isCallValid, texturePacked, level, xoffset, width,
                                        format, type, pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLTextureSubImage1D, std::move(paramBuffer));
}

CallCapture CaptureTextureSubImage2D(const State &glState,
                                     bool isCallValid,
                                     TextureID texturePacked,
                                     GLint level,
                                     GLint xoffset,
                                     GLint yoffset,
                                     GLsizei width,
                                     GLsizei height,
                                     GLenum format,
                                     GLenum type,
                                     const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTextureSubImage2D_pixels(glState, isCallValid, texturePacked, level, xoffset,
                                        yoffset, width, height, format, type, pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLTextureSubImage2D, std::move(paramBuffer));
}

CallCapture CaptureTextureSubImage3D(const State &glState,
                                     bool isCallValid,
                                     TextureID texturePacked,
                                     GLint level,
                                     GLint xoffset,
                                     GLint yoffset,
                                     GLint zoffset,
                                     GLsizei width,
                                     GLsizei height,
                                     GLsizei depth,
                                     GLenum format,
                                     GLenum type,
                                     const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", BigGLEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", BigGLEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTextureSubImage3D_pixels(glState, isCallValid, texturePacked, level, xoffset,
                                        yoffset, zoffset, width, height, depth, format, type,
                                        pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLTextureSubImage3D, std::move(paramBuffer));
}

CallCapture CaptureTransformFeedbackBufferBase(const State &glState,
                                               bool isCallValid,
                                               GLuint xfb,
                                               GLuint index,
                                               BufferID bufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("xfb", ParamType::TGLuint, xfb);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    return CallCapture(angle::EntryPoint::GLTransformFeedbackBufferBase, std::move(paramBuffer));
}

CallCapture CaptureTransformFeedbackBufferRange(const State &glState,
                                                bool isCallValid,
                                                GLuint xfb,
                                                GLuint index,
                                                BufferID bufferPacked,
                                                GLintptr offset,
                                                GLsizeiptr size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("xfb", ParamType::TGLuint, xfb);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    return CallCapture(angle::EntryPoint::GLTransformFeedbackBufferRange, std::move(paramBuffer));
}

CallCapture CaptureUnmapNamedBuffer(const State &glState,
                                    bool isCallValid,
                                    BufferID bufferPacked,
                                    GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLUnmapNamedBuffer, std::move(paramBuffer));
}

CallCapture CaptureVertexArrayAttribBinding(const State &glState,
                                            bool isCallValid,
                                            VertexArrayID vaobjPacked,
                                            GLuint attribindex,
                                            GLuint bindingindex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("vaobjPacked", ParamType::TVertexArrayID, vaobjPacked);
    paramBuffer.addValueParam("attribindex", ParamType::TGLuint, attribindex);
    paramBuffer.addValueParam("bindingindex", ParamType::TGLuint, bindingindex);

    return CallCapture(angle::EntryPoint::GLVertexArrayAttribBinding, std::move(paramBuffer));
}

CallCapture CaptureVertexArrayAttribFormat(const State &glState,
                                           bool isCallValid,
                                           VertexArrayID vaobjPacked,
                                           GLuint attribindex,
                                           GLint size,
                                           GLenum type,
                                           GLboolean normalized,
                                           GLuint relativeoffset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("vaobjPacked", ParamType::TVertexArrayID, vaobjPacked);
    paramBuffer.addValueParam("attribindex", ParamType::TGLuint, attribindex);
    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addEnumParam("type", BigGLEnum::VertexAttribType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("normalized", ParamType::TGLboolean, normalized);
    paramBuffer.addValueParam("relativeoffset", ParamType::TGLuint, relativeoffset);

    return CallCapture(angle::EntryPoint::GLVertexArrayAttribFormat, std::move(paramBuffer));
}

CallCapture CaptureVertexArrayAttribIFormat(const State &glState,
                                            bool isCallValid,
                                            VertexArrayID vaobjPacked,
                                            GLuint attribindex,
                                            GLint size,
                                            GLenum type,
                                            GLuint relativeoffset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("vaobjPacked", ParamType::TVertexArrayID, vaobjPacked);
    paramBuffer.addValueParam("attribindex", ParamType::TGLuint, attribindex);
    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addEnumParam("type", BigGLEnum::VertexAttribIType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("relativeoffset", ParamType::TGLuint, relativeoffset);

    return CallCapture(angle::EntryPoint::GLVertexArrayAttribIFormat, std::move(paramBuffer));
}

CallCapture CaptureVertexArrayAttribLFormat(const State &glState,
                                            bool isCallValid,
                                            VertexArrayID vaobjPacked,
                                            GLuint attribindex,
                                            GLint size,
                                            GLenum type,
                                            GLuint relativeoffset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("vaobjPacked", ParamType::TVertexArrayID, vaobjPacked);
    paramBuffer.addValueParam("attribindex", ParamType::TGLuint, attribindex);
    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addEnumParam("type", BigGLEnum::VertexAttribLType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("relativeoffset", ParamType::TGLuint, relativeoffset);

    return CallCapture(angle::EntryPoint::GLVertexArrayAttribLFormat, std::move(paramBuffer));
}

CallCapture CaptureVertexArrayBindingDivisor(const State &glState,
                                             bool isCallValid,
                                             VertexArrayID vaobjPacked,
                                             GLuint bindingindex,
                                             GLuint divisor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("vaobjPacked", ParamType::TVertexArrayID, vaobjPacked);
    paramBuffer.addValueParam("bindingindex", ParamType::TGLuint, bindingindex);
    paramBuffer.addValueParam("divisor", ParamType::TGLuint, divisor);

    return CallCapture(angle::EntryPoint::GLVertexArrayBindingDivisor, std::move(paramBuffer));
}

CallCapture CaptureVertexArrayElementBuffer(const State &glState,
                                            bool isCallValid,
                                            VertexArrayID vaobjPacked,
                                            BufferID bufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("vaobjPacked", ParamType::TVertexArrayID, vaobjPacked);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    return CallCapture(angle::EntryPoint::GLVertexArrayElementBuffer, std::move(paramBuffer));
}

CallCapture CaptureVertexArrayVertexBuffer(const State &glState,
                                           bool isCallValid,
                                           VertexArrayID vaobjPacked,
                                           GLuint bindingindex,
                                           BufferID bufferPacked,
                                           GLintptr offset,
                                           GLsizei stride)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("vaobjPacked", ParamType::TVertexArrayID, vaobjPacked);
    paramBuffer.addValueParam("bindingindex", ParamType::TGLuint, bindingindex);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    return CallCapture(angle::EntryPoint::GLVertexArrayVertexBuffer, std::move(paramBuffer));
}

CallCapture CaptureVertexArrayVertexBuffers(const State &glState,
                                            bool isCallValid,
                                            VertexArrayID vaobjPacked,
                                            GLuint first,
                                            GLsizei count,
                                            const BufferID *buffersPacked,
                                            const GLintptr *offsets,
                                            const GLsizei *strides)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("vaobjPacked", ParamType::TVertexArrayID, vaobjPacked);
    paramBuffer.addValueParam("first", ParamType::TGLuint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, buffersPacked, &buffersPackedParam.value);
        CaptureVertexArrayVertexBuffers_buffersPacked(glState, isCallValid, vaobjPacked, first,
                                                      count, buffersPacked, offsets, strides,
                                                      &buffersPackedParam);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }
    else
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, static_cast<const BufferID *>(nullptr),
                       &buffersPackedParam.value);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }

    if (isCallValid)
    {
        ParamCapture offsetsParam("offsets", ParamType::TGLintptrConstPointer);
        InitParamValue(ParamType::TGLintptrConstPointer, offsets, &offsetsParam.value);
        CaptureVertexArrayVertexBuffers_offsets(glState, isCallValid, vaobjPacked, first, count,
                                                buffersPacked, offsets, strides, &offsetsParam);
        paramBuffer.addParam(std::move(offsetsParam));
    }
    else
    {
        ParamCapture offsetsParam("offsets", ParamType::TGLintptrConstPointer);
        InitParamValue(ParamType::TGLintptrConstPointer, static_cast<const GLintptr *>(nullptr),
                       &offsetsParam.value);
        paramBuffer.addParam(std::move(offsetsParam));
    }

    if (isCallValid)
    {
        ParamCapture stridesParam("strides", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, strides, &stridesParam.value);
        CaptureVertexArrayVertexBuffers_strides(glState, isCallValid, vaobjPacked, first, count,
                                                buffersPacked, offsets, strides, &stridesParam);
        paramBuffer.addParam(std::move(stridesParam));
    }
    else
    {
        ParamCapture stridesParam("strides", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &stridesParam.value);
        paramBuffer.addParam(std::move(stridesParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexArrayVertexBuffers, std::move(paramBuffer));
}

// GL 4.6
CallCapture CaptureMultiDrawArraysIndirectCount(const State &glState,
                                                bool isCallValid,
                                                GLenum mode,
                                                const void *indirect,
                                                GLintptr drawcount,
                                                GLsizei maxdrawcount,
                                                GLsizei stride)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mode", BigGLEnum::PrimitiveType, ParamType::TGLenum, mode);

    if (isCallValid)
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indirect, &indirectParam.value);
        CaptureMultiDrawArraysIndirectCount_indirect(
            glState, isCallValid, mode, indirect, drawcount, maxdrawcount, stride, &indirectParam);
        paramBuffer.addParam(std::move(indirectParam));
    }
    else
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indirectParam.value);
        paramBuffer.addParam(std::move(indirectParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLintptr, drawcount);
    paramBuffer.addValueParam("maxdrawcount", ParamType::TGLsizei, maxdrawcount);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    return CallCapture(angle::EntryPoint::GLMultiDrawArraysIndirectCount, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsIndirectCount(const State &glState,
                                                  bool isCallValid,
                                                  GLenum mode,
                                                  GLenum type,
                                                  const void *indirect,
                                                  GLintptr drawcount,
                                                  GLsizei maxdrawcount,
                                                  GLsizei stride)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mode", BigGLEnum::PrimitiveType, ParamType::TGLenum, mode);
    paramBuffer.addEnumParam("type", BigGLEnum::DrawElementsType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indirect, &indirectParam.value);
        CaptureMultiDrawElementsIndirectCount_indirect(glState, isCallValid, mode, type, indirect,
                                                       drawcount, maxdrawcount, stride,
                                                       &indirectParam);
        paramBuffer.addParam(std::move(indirectParam));
    }
    else
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indirectParam.value);
        paramBuffer.addParam(std::move(indirectParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLintptr, drawcount);
    paramBuffer.addValueParam("maxdrawcount", ParamType::TGLsizei, maxdrawcount);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    return CallCapture(angle::EntryPoint::GLMultiDrawElementsIndirectCount, std::move(paramBuffer));
}

CallCapture CapturePolygonOffsetClamp(const State &glState,
                                      bool isCallValid,
                                      GLfloat factor,
                                      GLfloat units,
                                      GLfloat clamp)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("factor", ParamType::TGLfloat, factor);
    paramBuffer.addValueParam("units", ParamType::TGLfloat, units);
    paramBuffer.addValueParam("clamp", ParamType::TGLfloat, clamp);

    return CallCapture(angle::EntryPoint::GLPolygonOffsetClamp, std::move(paramBuffer));
}

CallCapture CaptureSpecializeShader(const State &glState,
                                    bool isCallValid,
                                    GLuint shader,
                                    const GLchar *pEntryPoint,
                                    GLuint numSpecializationConstants,
                                    const GLuint *pConstantIndex,
                                    const GLuint *pConstantValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shader", ParamType::TGLuint, shader);

    if (isCallValid)
    {
        ParamCapture pEntryPointParam("pEntryPoint", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, pEntryPoint, &pEntryPointParam.value);
        CaptureSpecializeShader_pEntryPoint(glState, isCallValid, shader, pEntryPoint,
                                            numSpecializationConstants, pConstantIndex,
                                            pConstantValue, &pEntryPointParam);
        paramBuffer.addParam(std::move(pEntryPointParam));
    }
    else
    {
        ParamCapture pEntryPointParam("pEntryPoint", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &pEntryPointParam.value);
        paramBuffer.addParam(std::move(pEntryPointParam));
    }

    paramBuffer.addValueParam("numSpecializationConstants", ParamType::TGLuint,
                              numSpecializationConstants);

    if (isCallValid)
    {
        ParamCapture pConstantIndexParam("pConstantIndex", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, pConstantIndex, &pConstantIndexParam.value);
        CaptureSpecializeShader_pConstantIndex(glState, isCallValid, shader, pEntryPoint,
                                               numSpecializationConstants, pConstantIndex,
                                               pConstantValue, &pConstantIndexParam);
        paramBuffer.addParam(std::move(pConstantIndexParam));
    }
    else
    {
        ParamCapture pConstantIndexParam("pConstantIndex", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &pConstantIndexParam.value);
        paramBuffer.addParam(std::move(pConstantIndexParam));
    }

    if (isCallValid)
    {
        ParamCapture pConstantValueParam("pConstantValue", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, pConstantValue, &pConstantValueParam.value);
        CaptureSpecializeShader_pConstantValue(glState, isCallValid, shader, pEntryPoint,
                                               numSpecializationConstants, pConstantIndex,
                                               pConstantValue, &pConstantValueParam);
        paramBuffer.addParam(std::move(pConstantValueParam));
    }
    else
    {
        ParamCapture pConstantValueParam("pConstantValue", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &pConstantValueParam.value);
        paramBuffer.addParam(std::move(pConstantValueParam));
    }

    return CallCapture(angle::EntryPoint::GLSpecializeShader, std::move(paramBuffer));
}

}  // namespace gl
