"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  getDefaultOptions: true,
  withDefaultOptions: true,
  getExtensions: true,
  createCypherEditor: true
};
exports.createCypherEditor = createCypherEditor;
exports.withDefaultOptions = exports.getExtensions = exports.getDefaultOptions = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _autocomplete = require("@codemirror/autocomplete");
var _search = require("@codemirror/search");
var _state = require("@codemirror/state");
var _view = require("@codemirror/view");
var _cypherCodemirrorBase = require("./cypher-codemirror-base");
Object.keys(_cypherCodemirrorBase).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _cypherCodemirrorBase[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _cypherCodemirrorBase[key];
    }
  });
});
var _cypherStateSelectors = require("./cypher-state-selectors");
var _cypherExtensions = require("./cypher-extensions");
Object.keys(_cypherExtensions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _cypherExtensions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _cypherExtensions[key];
    }
  });
});
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
const getDefaultOptions = () => _objectSpread({}, _cypherCodemirrorBase.defaultOptions);
exports.getDefaultOptions = getDefaultOptions;
const withDefaultOptions = options => {
  const combinedOptions = _objectSpread({}, _cypherCodemirrorBase.defaultOptions);
  for (let key of Object.keys(options)) {
    if (options[key] !== undefined) {
      combinedOptions[key] = options[key];
    }
  }
  return combinedOptions;
};
exports.withDefaultOptions = withDefaultOptions;
const isTruthyObject = obj => obj && typeof obj === "object";
const areSchemasDifferent = (oldSchema, newSchema) => {
  const oldIsObject = isTruthyObject(oldSchema);
  const newIsObject = isTruthyObject(newSchema);
  if (oldIsObject !== newIsObject) {
    return true;
  } else if (oldIsObject) {
    const oldKeys = Object.keys(oldSchema);
    const newKeys = Object.keys(newSchema);
    if (oldKeys.length !== newKeys.length) {
      return true;
    } else {
      return oldKeys.some(key => oldSchema[key] !== newSchema[key]);
    }
  } else {
    return false;
  }
};
const getExtensions = (options = {}, {
  lintConf = new _state.Compartment(),
  autocompleteConf = new _state.Compartment(),
  bracketMatchingConf = new _state.Compartment(),
  closeBracketsConf = new _state.Compartment(),
  cursorWideConf = new _state.Compartment(),
  cypherLanguageConf = new _state.Compartment(),
  readableConf = new _state.Compartment(),
  readOnlyConf = new _state.Compartment(),
  showLinesConf = new _state.Compartment(),
  lineWrappingConf = new _state.Compartment(),
  historyConf = new _state.Compartment(),
  placeholderConf = new _state.Compartment(),
  searchConf = new _state.Compartment(),
  tabKeyConf = new _state.Compartment(),
  themeConf = new _state.Compartment(),
  tooltipAbsoluteConf = new _state.Compartment(),
  onLineNumberClick = () => {},
  onFocusChanged = () => {},
  onScrollChanged = () => {},
  onKeyDown = () => {},
  onKeyUp = () => {}
} = {}) => {
  const combinedOptions = withDefaultOptions(options);
  const {
    autocomplete,
    autocompleteCloseOnBlur,
    bracketMatching,
    closeBrackets,
    cursorWide,
    cypherLanguage,
    history,
    tabKey,
    indentUnit,
    lineNumberFormatter,
    lineNumbers,
    lineWrapping,
    lint,
    placeholder,
    readOnly,
    readOnlyCursor,
    search,
    searchTop,
    theme,
    tooltipAbsolute
  } = combinedOptions;
  return [(0, _cypherExtensions.domListener)({
    onFocusChanged,
    onScrollChanged,
    onKeyDown,
    onKeyUp
  }), cypherLanguageConf.of((0, _cypherExtensions.getCypherLanguageExtensions)({
    cypherLanguage
  })), lintConf.of((0, _cypherExtensions.getLintExtensions)({
    cypherLanguage,
    readOnly,
    lint
  })), autocompleteConf.of((0, _cypherExtensions.getAutocompleteExtensions)({
    cypherLanguage,
    readOnly,
    autocomplete,
    autocompleteCloseOnBlur
  })), showLinesConf.of((0, _cypherExtensions.getLineNumbersExtensions)({
    lineNumbers,
    lineNumberFormatter,
    onLineNumberClick
  })), lineWrappingConf.of((0, _cypherExtensions.getLineWrappingExtensions)({
    lineWrapping
  })), historyConf.of((0, _cypherExtensions.getHistoryExtensions)({
    history
  })), tabKeyConf.of((0, _cypherExtensions.getTabKeyExtensions)({
    tabKey,
    indentUnit
  })), readableConf.of((0, _cypherExtensions.getReadableExtensions)({
    readOnly,
    readOnlyCursor
  })), placeholderConf.of((0, _cypherExtensions.getPlaceholderExtensions)({
    placeholder
  })), themeConf.of((0, _cypherExtensions.getThemeExtensions)({
    theme
  })), cursorWideConf.of((0, _cypherExtensions.getCursorWideExtensions)({
    cursorWide
  })), searchConf.of((0, _cypherExtensions.getSearchExtensions)({
    readOnly,
    search,
    searchTop
  })), tooltipAbsoluteConf.of((0, _cypherExtensions.getTooltipAbsoluteExtensions)({
    tooltipAbsolute
  })), readOnlyConf.of((0, _cypherExtensions.getReadOnlyExtensions)({
    readOnly,
    readOnlyCursor
  })), bracketMatchingConf.of((0, _cypherExtensions.getBracketMatchingExtensions)({
    bracketMatching
  })), closeBracketsConf.of((0, _cypherExtensions.getCloseBracketsExtensions)({
    closeBrackets
  }))];
};
exports.getExtensions = getExtensions;
const isActiveSearchMatches = searchMatches => searchMatches > 0 && searchMatches <= 1000;
const detectThemeDark = () => window.matchMedia && window.matchMedia("(prefers-color-scheme: dark)").matches;
const addDetectThemeDarkListener = isThemeDarkCallback => {
  const listener = event => {
    isThemeDarkCallback(event.matches);
  };
  window.matchMedia && window.matchMedia("(prefers-color-scheme: dark)").addEventListener("change", listener);
  return listener;
};
const removeDetectThemeDarkListener = listener => {
  window.matchMedia && window.matchMedia("(prefers-color-scheme: dark)").removeEventListener("change", listener);
};
function createCypherEditor(parentDOMElement, options = {}) {
  const combinedOptions = withDefaultOptions(options);
  const {
    autofocus,
    position,
    selection,
    parseOnSetValue,
    value,
    preExtensions,
    postExtensions
  } = combinedOptions;
  let {
    autocomplete,
    autocompleteOpen,
    autocompleteCloseOnBlur,
    autocompleteTriggerStrings,
    cypherLanguage,
    history,
    indentUnit,
    lineNumberFormatter,
    lineNumbers,
    lineWrapping,
    lint,
    placeholder,
    readOnly,
    readOnlyCursor,
    search,
    searchMatches,
    searchOpen,
    searchText,
    searchTop,
    schema,
    tabKey,
    theme,
    tooltipAbsolute
  } = combinedOptions;
  let editorSupport = null;
  let lastPosition = null;
  let lastSelection = null;
  let searchInitializing = false;
  let detectedThemeDark = theme === "auto" ? detectThemeDark() : null;
  let pressedKey = null;
  let deferredAutocomplete = false;
  const setDetectedThemeDark = dark => {
    detectedThemeDark = dark;
    updateTheme();
  };
  let detectedThemeDarkListener = theme === "auto" ? addDetectThemeDarkListener(setDetectedThemeDark) : null;
  const {
    on: onValueChanged,
    off: offValueChanged,
    fire: fireValueChanged
  } = (0, _cypherCodemirrorBase.createEventHandlers)();
  const {
    on: onFocusChanged,
    off: offFocusChanged,
    fire: fireFocusChanged
  } = (0, _cypherCodemirrorBase.createEventHandlers)();
  const {
    on: onScrollChanged,
    off: offScrollChanged,
    fire: fireScrollChanged
  } = (0, _cypherCodemirrorBase.createEventHandlers)();
  const {
    on: onPositionChanged,
    off: offPositionChanged,
    fire: firePositionChanged
  } = (0, _cypherCodemirrorBase.createEventHandlers)();
  const {
    on: onSelectionChanged,
    off: offSelectionChanged,
    fire: fireSelectionChanged
  } = (0, _cypherCodemirrorBase.createEventHandlers)();
  const {
    on: onAutocompleteChanged,
    off: offAutocompleteChanged,
    fire: fireAutocompleteChanged
  } = (0, _cypherCodemirrorBase.createEventHandlers)();
  const {
    on: onSearchChanged,
    off: offSearchChanged,
    fire: fireSearchChanged
  } = (0, _cypherCodemirrorBase.createEventHandlers)();
  const {
    on: onLineNumberClick,
    off: offLineNumberClick,
    fire: fireLineNumberClick
  } = (0, _cypherCodemirrorBase.createEventHandlers)();
  const {
    on: onKeyDown,
    off: offKeyDown,
    fire: fireKeyDown
  } = (0, _cypherCodemirrorBase.createEventHandlers)();
  const {
    on: onKeyUp,
    off: offKeyUp,
    fire: fireKeyUp
  } = (0, _cypherCodemirrorBase.createEventHandlers)();
  const lineNumberClick = (line, event) => {
    fireLineNumberClick(line, event);
  };
  const keyDown = event => {
    pressedKey = !event.metaKey && !event.ctrlKey && !event.altKey && event.key && event.key.length === 1 ? event.key : null;
    fireKeyDown(event);
  };
  const keyUp = event => {
    if (deferredAutocomplete) {
      showAutocomplete();
      deferredAutocomplete = false;
    }
    pressedKey = null;
    fireKeyUp(event);
  };
  const deferAutocompleteForChanges = changes => {
    const {
      length = 0,
      newLength = 0
    } = changes;
    const isSmallInsert = newLength > length && newLength - length <= 2;
    if (pressedKey && cypherLanguage && autocomplete && Array.isArray(autocompleteTriggerStrings) && isSmallInsert) {
      let changedText = null;
      changes.iterChanges((fromA, toA, fromB, toB, inserted) => {
        if (!changedText && inserted && typeof inserted === "object" && Array.isArray(inserted.text) && inserted.text.length == 1) {
          changedText = inserted.text[0];
        }
      });
      if (changedText && autocompleteTriggerStrings.includes(changedText)) {
        deferredAutocomplete = true;
      }
    }
  };
  const handleValueChanged = (value, changes) => {
    deferAutocompleteForChanges(changes);
    fireValueChanged(value, changes);
  };
  const handlePositionChanged = positionObject => {
    lastPosition = (positionObject || {
      position: null
    }).position;
    firePositionChanged((0, _cypherCodemirrorBase.positionOldToNew)(positionObject));
  };
  const handleSelectionChanged = selection => {
    lastSelection = selection;
    fireSelectionChanged(selection);
  };
  const handleAutocompleteChanged = (newAutocompleteOpen, options, option) => {
    autocompleteOpen = newAutocompleteOpen;
    fireAutocompleteChanged(autocompleteOpen, options, option);
  };
  const handleSearchChanged = (newSearchOpen, text, matches) => {
    if (!searchInitializing) {
      searchOpen = newSearchOpen;
      fireSearchChanged(searchOpen, text, matches);
    }
  };
  const handleFocusChanged = focused => {
    fireFocusChanged(focused);
  };
  const handleScrollChanged = scrollInfo => {
    fireScrollChanged(scrollInfo);
  };
  const updateListener = _view.EditorView.updateListener.of(v => {
    const {
      docChanged: valueChanged,
      selectionSet: selectionChanged
    } = v;
    const oldPosition = selectionChanged ? valueChanged ? null : (0, _cypherStateSelectors.getStatePositionAbsolute)(v.startState) : null;
    const newPosition = selectionChanged ? (0, _cypherStateSelectors.getStatePositionAbsolute)(v.state) : null;
    const positionChanged = valueChanged || oldPosition !== newPosition;
    const oldAutocompleteOpen = (0, _cypherStateSelectors.getStateAutocompleteOpen)(v.startState);
    const newAutocompleteOpen = (0, _cypherStateSelectors.getStateAutocompleteOpen)(v.state);
    const pickedAutocompleteOption = (0, _cypherStateSelectors.getViewUpdatePickedAutocompleteOption)(v, true);
    const autocompleteChanged = cypherLanguage && autocomplete && (oldAutocompleteOpen !== newAutocompleteOpen || !(0, _cypherStateSelectors.areViewUpdateAutocompleteOptionsEqual)(v) || pickedAutocompleteOption);
    const oldSearchOpen = (0, _cypherStateSelectors.getStateSearchOpen)(v.startState);
    const newSearchOpen = (0, _cypherStateSelectors.getStateSearchOpen)(v.state);
    const oldSearchText = (0, _cypherStateSelectors.getStateSearchText)(v.startState);
    const newSearchText = (0, _cypherStateSelectors.getStateSearchText)(v.state);
    const oldSearchSpec = (0, _cypherStateSelectors.getStateSearchSpec)(v.startState);
    const newSearchSpec = (0, _cypherStateSelectors.getStateSearchSpec)(v.state);
    const activeSearchMatches = isActiveSearchMatches(searchMatches);
    const searchChanged = search && (oldSearchOpen !== newSearchOpen || (activeSearchMatches ? oldSearchSpec !== newSearchSpec : oldSearchText !== newSearchText));
    if (valueChanged) {
      handleValueChanged((0, _cypherStateSelectors.getStateValue)(v.state), v.changes);
    }
    if (positionChanged) {
      handlePositionChanged((0, _cypherStateSelectors.getStatePosition)(v.state));
    }
    // if (selectionChanged && deferredAutocomplete) {
    //   deferredAutocomplete = false;
    //   showAutocomplete();
    // }
    if (selectionChanged) {
      handleSelectionChanged((0, _cypherStateSelectors.getStateSelection)(v.state));
    }
    if (autocompleteChanged) {
      const newAutocompleteOptions = newAutocompleteOpen ? (0, _cypherStateSelectors.getStateAutocompleteOptions)(v.state, true) : undefined;
      const newAutocompleteOption = pickedAutocompleteOption;
      handleAutocompleteChanged(newAutocompleteOpen, newAutocompleteOptions, newAutocompleteOption);
    }
    if (searchChanged) {
      if (oldSearchOpen || newSearchOpen) {
        const newSearchMatches = activeSearchMatches && newSearchOpen ? (0, _cypherStateSelectors.getStateSearchMatches)(v.state, searchMatches) : undefined;
        handleSearchChanged(newSearchOpen, newSearchText, newSearchMatches);
      }
    } else if (valueChanged && activeSearchMatches && newSearchOpen) {
      handleSearchChanged(newSearchOpen, newSearchText, (0, _cypherStateSelectors.getStateSearchMatches)(v.state, searchMatches));
    }
  });
  const preConf = new _state.Compartment();
  const lintConf = new _state.Compartment();
  const autocompleteConf = new _state.Compartment();
  const bracketMatchingConf = new _state.Compartment();
  const closeBracketsConf = new _state.Compartment();
  const readableConf = new _state.Compartment();
  const readOnlyConf = new _state.Compartment();
  const showLinesConf = new _state.Compartment();
  const lineWrappingConf = new _state.Compartment();
  const historyConf = new _state.Compartment();
  const placeholderConf = new _state.Compartment();
  const searchConf = new _state.Compartment();
  const tabKeyConf = new _state.Compartment();
  const themeConf = new _state.Compartment();
  const cursorWideConf = new _state.Compartment();
  const cypherLanguageConf = new _state.Compartment();
  const tooltipAbsoluteConf = new _state.Compartment();
  const postConf = new _state.Compartment();
  const createOptions = theme === "auto" ? _objectSpread(_objectSpread({}, combinedOptions), {}, {
    theme: detectedThemeDark ? "dark" : "light"
  }) : combinedOptions;
  const initialState = _state.EditorState.create({
    doc: value,
    extensions: [preConf.of(preExtensions), ...getExtensions(createOptions, {
      lintConf,
      autocompleteConf,
      bracketMatchingConf,
      closeBracketsConf,
      cursorWideConf,
      cypherLanguageConf,
      tabKeyConf,
      readableConf,
      readOnlyConf,
      showLinesConf,
      lineWrappingConf,
      historyConf,
      placeholderConf,
      searchConf,
      themeConf,
      tooltipAbsoluteConf,
      postConf,
      onLineNumberClick: lineNumberClick,
      onFocusChanged: handleFocusChanged,
      onScrollChanged: handleScrollChanged,
      onKeyDown: keyDown,
      onKeyUp: keyUp
    }), updateListener, postConf.of(postExtensions)]
  });
  let editor = new _view.EditorView({
    parent: parentDOMElement,
    state: initialState
  });
  editor.version = 1;
  editor.newContentVersion = function newContentVersion() {
    this.version += 1;
    return this.version;
  };
  editor.newContentVersion.bind(editor);
  if (cypherLanguage) {
    editorSupport = (0, _cypherStateSelectors.getStateEditorSupport)(editor.state);
    editorSupport.update(value);
  }
  const getPositionForValue = positionValue => (0, _cypherStateSelectors.getStatePositionForAny)(editor.state, (0, _cypherCodemirrorBase.positionNewToOld)(positionValue));
  const setPosition = (positionParam, scrollIntoView = true) => {
    const positionObject = getPositionForValue(positionParam);
    if (positionObject) {
      const {
        position
      } = positionObject;
      if (position !== lastPosition) {
        lastPosition = position;
        editor.dispatch(editor.state.update({
          scrollIntoView,
          selection: {
            anchor: position
          }
        }));
      }
    }
  };
  const setSelection = (selection, scrollIntoView = true) => {
    const ranges = [_state.SelectionRange.fromJSON({
      from: 0,
      to: 2,
      anchor: 0,
      head: 2
    }), _state.SelectionRange.fromJSON({
      from: 3,
      to: 4,
      anchor: 3,
      head: 4
    }), _state.SelectionRange.fromJSON({
      from: 6,
      to: 8,
      anchor: 6,
      head: 8
    })];
    let newSelection = _state.EditorSelection.create(ranges, 2);
    if (selection && selection !== lastSelection) {
      lastSelection = selection;
      editor.dispatch(editor.state.update({
        scrollIntoView,
        selection
      }));
    }
  };
  const showAutocomplete = () => {
    if (cypherLanguage && autocomplete) {
      (0, _autocomplete.startCompletion)(editor);
    }
  };
  const hideAutocomplete = () => {
    if (cypherLanguage && autocomplete) {
      (0, _autocomplete.closeCompletion)(editor);
    }
  };
  const showSearch = () => {
    if (search) {
      (0, _search.openSearchPanel)(editor);
    }
  };
  const hideSearch = () => {
    if (search) {
      (0, _search.closeSearchPanel)(editor);
    }
  };
  if (position !== undefined) {
    setPosition(position);
  } else if (selection !== undefined) {
    setSelection(selection);
  }
  lastPosition = ((0, _cypherStateSelectors.getStatePosition)(editor.state) || {
    position: null
  }).position;
  lastSelection = (0, _cypherStateSelectors.getStateSelection)(editor.state) || null;
  if (cypherLanguage && schema !== undefined) {
    editorSupport.setSchema(schema);
  }
  if (cypherLanguage && autocomplete && autocompleteOpen === true) {
    showAutocomplete();
  }
  if (cypherLanguage && search && searchOpen === true) {
    showSearch();
  }
  if (autofocus) {
    editor.contentDOM.focus();
  }
  const setPreExtensions = (preExtensions = _cypherCodemirrorBase.defaultOptions.preExtensions) => {
    editor.dispatch({
      effects: preConf.reconfigure(preExtensions)
    });
  };
  const setPostExtensions = (postExtensions = _cypherCodemirrorBase.defaultOptions.postExtensions) => {
    editor.dispatch({
      effects: postConf.reconfigure(postExtensions)
    });
  };
  const setValue = (value = _cypherCodemirrorBase.defaultOptions.value, parseOnSetValueParam = parseOnSetValue) => {
    const update = editor.state.update({
      changes: {
        from: 0,
        to: (0, _cypherStateSelectors.getStateLength)(editor.state),
        insert: value
      }
    });
    editor.update([update]);
    if (cypherLanguage && parseOnSetValueParam !== false) {
      const version = editor.newContentVersion();
      const editorSupport = (0, _cypherStateSelectors.getStateEditorSupport)(editor.state);
      editorSupport.update(value, version);
      (0, _cypherExtensions.fixColors)(editor, editorSupport);
    }
  };
  const selectAutocompleteOption = index => {
    if (cypherLanguage && autocomplete) {
      editor.dispatch({
        effects: (0, _autocomplete.setSelectedCompletion)(index)
      });
      (0, _autocomplete.acceptCompletion)(editor);
    }
  };
  const setHistory = (newHistory = _cypherCodemirrorBase.defaultOptions.history) => {
    history = newHistory;
    editor.dispatch({
      effects: historyConf.reconfigure((0, _cypherExtensions.getHistoryExtensions)({
        history
      }))
    });
  };
  const clearHistory = () => {
    if (history) {
      editor.dispatch({
        effects: historyConf.reconfigure([])
      });
      editor.dispatch({
        effects: historyConf.reconfigure((0, _cypherExtensions.getHistoryExtensions)({
          history
        }))
      });
    }
  };
  const setLineNumbers = (newLineNumbers = _cypherCodemirrorBase.defaultOptions.lineNumbers) => {
    lineNumbers = newLineNumbers;
    editor.dispatch({
      effects: showLinesConf.reconfigure((0, _cypherExtensions.getLineNumbersExtensions)({
        lineNumbers,
        lineNumberFormatter,
        onLineNumberClick: lineNumberClick
      }))
    });
  };
  const setLineNumberFormatter = (newLineNumberFormatter = _cypherCodemirrorBase.defaultOptions.lineNumberFormatter) => {
    lineNumberFormatter = newLineNumberFormatter;
    if (lineNumbers) {
      editor.dispatch({
        effects: showLinesConf.reconfigure((0, _cypherExtensions.getLineNumbersExtensions)({
          lineNumbers,
          lineNumberFormatter,
          onLineNumberClick: lineNumberClick
        }))
      });
    }
  };
  const setReadOnly = (newReadOnly = _cypherCodemirrorBase.defaultOptions.readOnly) => {
    readOnly = newReadOnly;
    editor.dispatch({
      effects: [readableConf.reconfigure((0, _cypherExtensions.getReadableExtensions)({
        readOnly,
        readOnlyCursor
      })), readOnlyConf.reconfigure((0, _cypherExtensions.getReadOnlyExtensions)({
        readOnly,
        readOnlyCursor
      })), autocompleteConf.reconfigure((0, _cypherExtensions.getAutocompleteExtensions)({
        cypherLanguage,
        readOnly,
        autocomplete,
        autocompleteCloseOnBlur
      })), lintConf.reconfigure((0, _cypherExtensions.getLintExtensions)({
        cypherLanguage,
        readOnly,
        lint
      }))]
    });
  };
  const setReadOnlyCursor = (newReadOnlyCursor = _cypherCodemirrorBase.defaultOptions.readOnlyCursor) => {
    readOnlyCursor = newReadOnlyCursor;
    editor.dispatch({
      effects: [readableConf.reconfigure((0, _cypherExtensions.getReadableExtensions)({
        readOnly,
        readOnlyCursor
      })), readOnlyConf.reconfigure((0, _cypherExtensions.getReadOnlyExtensions)({
        readOnly,
        readOnlyCursor
      }))]
    });
  };
  const setPlaceholder = (newPlaceholder = _cypherCodemirrorBase.defaultOptions.placeholder) => {
    placeholder = newPlaceholder;
    editor.dispatch({
      effects: [placeholderConf.reconfigure((0, _cypherExtensions.getPlaceholderExtensions)({
        placeholder
      }))]
    });
  };
  const setLineWrapping = (newLineWrapping = _cypherCodemirrorBase.defaultOptions.lineWrapping) => {
    lineWrapping = newLineWrapping;
    editor.dispatch({
      effects: [lineWrappingConf.reconfigure((0, _cypherExtensions.getLineWrappingExtensions)({
        lineWrapping
      }))]
    });
  };
  const setAutocomplete = (newAutocomplete = _cypherCodemirrorBase.defaultOptions.autocomplete) => {
    const autocompleteActivated = cypherLanguage && newAutocomplete && !(cypherLanguage && autocomplete);
    autocomplete = newAutocomplete;
    editor.dispatch({
      effects: autocompleteConf.reconfigure((0, _cypherExtensions.getAutocompleteExtensions)({
        cypherLanguage,
        readOnly,
        autocomplete,
        autocompleteCloseOnBlur
      }))
    });
    if (autocompleteActivated) {
      if (autocompleteOpen) {
        showAutocomplete();
      }
    }
  };
  const setAutocompleteCloseOnBlur = (newAutocompleteCloseOnBlur = _cypherCodemirrorBase.defaultOptions.autocompleteCloseOnBlur) => {
    autocompleteCloseOnBlur = newAutocompleteCloseOnBlur;
    editor.dispatch({
      effects: autocompleteConf.reconfigure((0, _cypherExtensions.getAutocompleteExtensions)({
        cypherLanguage,
        readOnly,
        autocomplete,
        autocompleteCloseOnBlur
      }))
    });
  };
  const setAutocompleteOpen = (newAutocompleteOpen = _cypherCodemirrorBase.defaultOptions.autocompleteOpen) => {
    autocompleteOpen = newAutocompleteOpen;
    if (autocompleteOpen) {
      showAutocomplete();
    } else {
      hideAutocomplete();
    }
  };
  const setAutocompleteTriggerStrings = (newAutocompleteTriggerStrings = _cypherCodemirrorBase.defaultOptions.autocompleteTriggerStrings) => {
    autocompleteTriggerStrings = newAutocompleteTriggerStrings;
  };
  const setLint = (newLint = _cypherCodemirrorBase.defaultOptions.lint) => {
    lint = newLint;
    editor.dispatch({
      effects: lintConf.reconfigure((0, _cypherExtensions.getLintExtensions)({
        cypherLanguage,
        readOnly,
        lint
      }))
    });
  };
  const getPosition = () => {
    return (0, _cypherCodemirrorBase.positionOldToNew)((0, _cypherStateSelectors.getStatePosition)(editor.state));
  };
  const getSelection = () => {
    return (0, _cypherStateSelectors.getStateSelection)(editor.state);
  };
  const getLineCount = () => {
    return editor ? (0, _cypherStateSelectors.getStateLineCount)(editor.state) : 0;
  };
  const setSchema = (newSchema = _cypherCodemirrorBase.defaultOptions.schema) => {
    const schemaChanged = areSchemasDifferent(schema, newSchema);
    schema = newSchema;
    if (cypherLanguage) {
      editorSupport.setSchema(schema);
      if (schemaChanged && autocomplete && autocompleteOpen) {
        showAutocomplete();
      }
    }
  };
  const setTheme = (newTheme = _cypherCodemirrorBase.defaultOptions.theme) => {
    const oldTheme = theme;
    theme = newTheme;
    if (oldTheme === "auto" && newTheme !== "auto") {
      detectedThemeDark = null;
      detectedThemeDarkListener && removeDetectThemeDarkListener(detectedThemeDarkListener);
      detectedThemeDarkListener = null;
    }
    if (oldTheme !== "auto" && newTheme === "auto") {
      detectedThemeDark = detectThemeDark();
      detectedThemeDarkListener = addDetectThemeDarkListener(setDetectedThemeDark);
    }
    const derivedTheme = theme === "auto" ? detectedThemeDark ? "dark" : "light" : theme;
    editor.dispatch({
      effects: themeConf.reconfigure((0, _cypherExtensions.getThemeExtensions)({
        theme: derivedTheme
      }))
    });
  };
  const updateTheme = () => {
    setTheme(theme);
  };
  const setCursorWide = (cursorWide = _cypherCodemirrorBase.defaultOptions.cursorWide) => {
    editor.dispatch({
      effects: cursorWideConf.reconfigure((0, _cypherExtensions.getCursorWideExtensions)({
        cursorWide
      }))
    });
  };
  const setCypherLanguage = (newCypherLanguage = _cypherCodemirrorBase.defaultOptions.cypherLanguage) => {
    const cypherLanguageChanged = cypherLanguage !== newCypherLanguage;
    const autocompleteActivated = newCypherLanguage && autocomplete && !(cypherLanguage && autocomplete);
    cypherLanguage = newCypherLanguage;
    if (cypherLanguageChanged && !cypherLanguage) {
      editorSupport = null;
    }
    editor.dispatch({
      effects: cypherLanguageConf.reconfigure((0, _cypherExtensions.getCypherLanguageExtensions)({
        cypherLanguage
      }))
    });
    editor.dispatch({
      effects: autocompleteConf.reconfigure((0, _cypherExtensions.getAutocompleteExtensions)({
        cypherLanguage,
        readOnly,
        autocomplete,
        autocompleteCloseOnBlur
      }))
    });
    editor.dispatch({
      effects: lintConf.reconfigure((0, _cypherExtensions.getLintExtensions)({
        cypherLanguage,
        readOnly,
        lint
      }))
    });
    if (cypherLanguageChanged && cypherLanguage) {
      editor.version = 1;
      const version = editor.newContentVersion();
      editorSupport = (0, _cypherStateSelectors.getStateEditorSupport)(editor.state);
      editorSupport.setSchema(schema);
      editorSupport.update(value, version);
      (0, _cypherExtensions.fixColors)(editor, editorSupport);
    }
    if (autocompleteActivated) {
      if (autocompleteOpen) {
        showAutocomplete();
      }
    }
    if (!cypherLanguage) {
      editor && (0, _cypherExtensions.resetColors)(editor);
    }
  };
  const setTooltipAbsolute = (newTooltipAbsolute = _cypherCodemirrorBase.defaultOptions.tooltipAbsolute) => {
    tooltipAbsolute = newTooltipAbsolute;
    editor.dispatch({
      effects: tooltipAbsoluteConf.reconfigure((0, _cypherExtensions.getTooltipAbsoluteExtensions)({
        tooltipAbsolute
      }))
    });
  };
  const focus = () => {
    editor && editor.focus();
  };
  const destroy = () => {
    editor && editor.destroy();
    detectedThemeDarkListener && removeDetectThemeDarkListener(detectedThemeDarkListener);
  };
  const setTabKey = (newTabKey = _cypherCodemirrorBase.defaultOptions.tabKey) => {
    tabKey = newTabKey;
    editor.dispatch({
      effects: tabKeyConf.reconfigure((0, _cypherExtensions.getTabKeyExtensions)({
        tabKey,
        indentUnit
      }))
    });
  };
  const setIndentUnit = (newIndentUnit = _cypherCodemirrorBase.defaultOptions.indentUnit) => {
    indentUnit = newIndentUnit;
    editor.dispatch({
      effects: tabKeyConf.reconfigure((0, _cypherExtensions.getTabKeyExtensions)({
        tabKey,
        indentUnit
      }))
    });
  };
  const setSearch = (newSearch = _cypherCodemirrorBase.defaultOptions.search) => {
    const searchActivated = newSearch && !search;
    search = newSearch;
    if (searchActivated) {
      searchInitializing = true;
    }
    editor.dispatch({
      effects: searchConf.reconfigure((0, _cypherExtensions.getSearchExtensions)({
        readOnly,
        search,
        searchTop
      }))
    });
    if (searchActivated) {
      setSearchText(searchText);
      if (searchOpen) {
        showSearch();
      }
      searchInitializing = false;
      handleSearchChanged(searchOpen, searchText, searchOpen ? (0, _cypherStateSelectors.getStateSearchMatches)(editor.state, searchMatches) : undefined);
    }
  };
  const setSearchMatches = (newSearchMatches = _cypherCodemirrorBase.defaultOptions.searchMatches) => {
    const searchMatchesChanged = newSearchMatches !== searchMatches;
    searchMatches = newSearchMatches;
    if (searchMatchesChanged && searchMatches > 0) {}
  };
  const setSearchOpen = (newSearchOpen = _cypherCodemirrorBase.defaultOptions.searchOpen) => {
    searchOpen = newSearchOpen;
    if (searchOpen) {
      showSearch();
    } else {
      hideSearch();
    }
  };
  const setSearchText = (newSearchText = _cypherCodemirrorBase.defaultOptions.searchText) => {
    searchText = newSearchText;
    if (search) {
      const searchQuery = (0, _search.getSearchQuery)(editor.state);
      const {
        caseSensitive,
        literal,
        regexp,
        replace,
        wholeWord
      } = searchQuery;
      const newSearchQuery = new _search.SearchQuery({
        search: searchText,
        caseSensitive,
        literal,
        regexp,
        replace,
        wholeWord
      });
      editor.dispatch({
        effects: _search.setSearchQuery.of(newSearchQuery)
      });
    }
  };
  const setSearchTop = (newSearchTop = _cypherCodemirrorBase.defaultOptions.searchTop) => {
    searchTop = newSearchTop;
    editor.dispatch({
      effects: searchConf.reconfigure((0, _cypherExtensions.getSearchExtensions)({
        readOnly,
        search,
        searchTop
      }))
    });
  };
  const setBracketMatching = (bracketMatching = _cypherCodemirrorBase.defaultOptions.bracketMatching) => {
    editor.dispatch({
      effects: bracketMatchingConf.reconfigure((0, _cypherExtensions.getBracketMatchingExtensions)({
        bracketMatching
      }))
    });
  };
  const setCloseBrackets = (closeBrackets = _cypherCodemirrorBase.defaultOptions.closeBrackets) => {
    editor.dispatch({
      effects: closeBracketsConf.reconfigure((0, _cypherExtensions.getCloseBracketsExtensions)({
        closeBrackets
      }))
    });
  };
  const editorAPI = {
    clearHistory,
    destroy,
    focus,
    getLineCount,
    getPosition,
    getPositionForValue,
    getSelection,
    selectAutocompleteOption,
    setAutocomplete,
    setAutocompleteCloseOnBlur,
    setAutocompleteOpen,
    setAutocompleteTriggerStrings,
    setBracketMatching,
    setCloseBrackets,
    setCursorWide,
    setCypherLanguage,
    setHistory,
    setIndentUnit,
    setLineNumberFormatter,
    setLineNumbers,
    setLineWrapping,
    setLint,
    setPlaceholder,
    setPosition,
    setReadOnly,
    setReadOnlyCursor,
    setSchema,
    setSearch,
    setSearchMatches,
    setSearchOpen,
    setSearchText,
    setSearchTop,
    setSelection,
    setTabKey,
    setTheme,
    setTooltipAbsolute,
    setValue,
    onAutocompleteChanged,
    offAutocompleteChanged,
    onFocusChanged,
    offFocusChanged,
    onKeyDown,
    offKeyDown,
    onKeyUp,
    offKeyUp,
    onLineNumberClick,
    offLineNumberClick,
    onPositionChanged,
    offPositionChanged,
    onScrollChanged,
    offScrollChanged,
    onSearchChanged,
    offSearchChanged,
    onSelectionChanged,
    offSelectionChanged,
    onValueChanged,
    offValueChanged,
    setPreExtensions,
    setPostExtensions,
    codemirror: editor,
    editorSupport
  };
  if (cypherLanguage && parseOnSetValue !== false) {
    const version = editor.newContentVersion();
    editorSupport.update(value, version);
    (0, _cypherExtensions.fixColors)(editor, editorSupport);
  }
  return {
    editor: editorAPI
  };
}