"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ZoomControl = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const plus_solid_svg_1 = require("../../assets/icons/plus-solid.svg");
const minus_solid_svg_1 = require("../../assets/icons/minus-solid.svg");
const dot_circle_regular_svg_1 = require("../../assets/icons/dot-circle-regular.svg");
const useCamera_1 = require("../../hooks/useCamera");
const ZoomControl = ({ className, style, animationDuration = 200, children, labels = {}, }) => {
    const { zoomIn, zoomOut, reset } = (0, useCamera_1.useCamera)({ duration: animationDuration, factor: 1.5 });
    const htmlProps = {
        style,
        className: `react-sigma-control ${className || ""}`,
    };
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("div", Object.assign({}, htmlProps),
            react_1.default.createElement("button", { onClick: () => zoomIn(), title: labels["zoomIn"] || "Zoom In" }, children ? children[0] : react_1.default.createElement(plus_solid_svg_1.ReactComponent, { style: { width: "1em" } }))),
        react_1.default.createElement("div", Object.assign({}, htmlProps),
            react_1.default.createElement("button", { onClick: () => zoomOut(), title: labels["zoomOut"] || "Zoom Out" }, children ? children[1] : react_1.default.createElement(minus_solid_svg_1.ReactComponent, { style: { width: "1em" } }))),
        react_1.default.createElement("div", Object.assign({}, htmlProps),
            react_1.default.createElement("button", { onClick: () => reset(), title: labels["reset"] || "See whole graph" }, children ? children[2] : react_1.default.createElement(dot_circle_regular_svg_1.ReactComponent, { style: { width: "1em" } })))));
};
exports.ZoomControl = ZoomControl;
//# sourceMappingURL=ZoomControl.js.map