/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.completion;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLTableAliasInsertMode;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionAnalyzer;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionContext;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItem;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemVisitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.utils.CommonUtils;

public class SQLQueryCompletionTextProvider
implements SQLQueryCompletionItemVisitor<String> {
    private static final Log log = Log.getLog(SQLQueryCompletionTextProvider.class);
    private final SQLCompletionRequest request;
    private final SQLQueryCompletionContext queryCompletionContext;
    private final SQLTableAliasInsertMode aliasMode;
    private final String structSeparator;
    private final Set<String> localKnownColumnNames;
    private final DBRProgressMonitor monitor;
    private final DBSObjectContainer activeContext;

    public SQLQueryCompletionTextProvider(@NotNull SQLCompletionRequest request, @NotNull SQLQueryCompletionContext queryCompletionContext, @NotNull DBRProgressMonitor monitor) {
        DBSObjectContainer c2;
        DBSObject dBSObject;
        this.request = request;
        this.queryCompletionContext = queryCompletionContext;
        this.aliasMode = SQLTableAliasInsertMode.fromPreferences(request.getContext().getSyntaxManager().getPreferenceStore());
        this.structSeparator = Character.toString(request.getContext().getDataSource().getSQLDialect().getStructSeparator());
        this.localKnownColumnNames = queryCompletionContext.getDataContext() == null ? Collections.emptySet() : queryCompletionContext.getDataContext().getColumnsList().stream().map(c -> c.symbol.getName()).collect(Collectors.toSet());
        this.monitor = monitor;
        this.activeContext = request.getContext().getExecutionContext() == null ? null : ((dBSObject = DBUtils.getSelectedObject((DBCExecutionContext)request.getContext().getExecutionContext())) instanceof DBSObjectContainer ? (c2 = (DBSObjectContainer)dBSObject) : null);
    }

    @Override
    @NotNull
    public String visitSubqueryAlias(@NotNull SQLQueryCompletionItem.SQLRowsSourceAliasCompletionItem subqueryAlias) {
        return this.prepareDefiningEntryName(subqueryAlias.symbol);
    }

    @Override
    @NotNull
    public String visitCompositeField(@NotNull SQLQueryCompletionItem.SQLCompositeFieldCompletionItem compositeField) {
        return compositeField.memberInfo.name();
    }

    @Override
    @Nullable
    public String visitSpecialCompositeField(@NotNull SQLQueryCompletionItem.SQLSpecialCompositeFieldCompletionItem compositeField) {
        return compositeField.memberInfo.name();
    }

    @Override
    @NotNull
    public String visitColumnName(@NotNull SQLQueryCompletionItem.SQLColumnNameCompletionItem columnName) {
        Object prefix;
        String preparedColumnName = this.convertCaseIfNeeded(columnName.columnInfo.symbol.getName());
        if (columnName.sourceInfo != null && this.queryCompletionContext.getInspectionResult().expectingColumnReference() && columnName.absolute) {
            boolean forceQualifiedName;
            boolean bl = forceQualifiedName = this.request.getContext().isForceQualifiedColumnNames() || this.queryCompletionContext.isColumnNameConflicting(columnName.columnInfo.symbol.getName());
            prefix = columnName.sourceInfo.aliasOrNull != null ? this.prepareDefiningEntryName(columnName.sourceInfo.aliasOrNull) + this.structSeparator : (columnName.sourceInfo.referenceName != null && forceQualifiedName ? this.prepareQualifiedName(columnName.sourceInfo.referenceName.stringParts) + this.structSeparator : (columnName.sourceInfo.tableOrNull != null && forceQualifiedName ? this.prepareObjectName((DBSObject)columnName.sourceInfo.tableOrNull) + this.structSeparator : ""));
        } else {
            prefix = "";
        }
        return (String)prefix + preparedColumnName;
    }

    @Override
    @NotNull
    public String visitTableName(@NotNull SQLQueryCompletionItem.SQLTableNameCompletionItem tableName) {
        Object suffix;
        if (this.queryCompletionContext.getInspectionResult().expectingTableSourceIntroduction() && this.aliasMode != SQLTableAliasInsertMode.NONE) {
            SQLDialect sqlDialect = SQLUtils.getDialectFromObject((DBPObject)tableName.object);
            String alias = SQLUtils.generateEntityAlias((DBSEntity)((DBSEntity)tableName.object), s -> sqlDialect.getKeywordType(s) != null || this.queryCompletionContext.getAliasesInUse().contains(s.toLowerCase()) || this.queryCompletionContext.getDataContext() != null && this.queryCompletionContext.getDataContext().resolveSource(this.monitor, List.of(s)) != null);
            suffix = this.prepareAliasPrefix() + this.convertCaseIfNeeded(alias);
        } else {
            suffix = "";
        }
        return this.prepareObjectName(tableName) + (String)suffix;
    }

    @NotNull
    private String prepareAliasPrefix() {
        return this.aliasMode == SQLTableAliasInsertMode.EXTENDED ? " " + SQLCompletionAnalyzer.convertKeywordCase(this.request, "as", false) + " " : " ";
    }

    @Override
    @NotNull
    public String visitReservedWord(@NotNull SQLQueryCompletionItem.SQLReservedWordCompletionItem reservedWord) {
        return SQLCompletionAnalyzer.convertKeywordCase(this.request, reservedWord.text, false);
    }

    @Override
    @NotNull
    public String visitNamedObject(@NotNull SQLQueryCompletionItem.SQLDbNamedObjectCompletionItem namedObject) {
        return this.prepareObjectName(namedObject);
    }

    @Override
    @Nullable
    public String visitJoinCondition(@NotNull SQLQueryCompletionItem.SQLJoinConditionCompletionItem joinCondition) {
        return joinCondition.left.apply(this) + " = " + joinCondition.right.apply(this);
    }

    private String prepareObjectName(@NotNull SQLQueryCompletionItem.SQLDbObjectCompletionItem<?> objectCompletionItem) {
        Object name;
        if (objectCompletionItem.resolvedContext != null) {
            String accomplishedPart = objectCompletionItem.resolvedContext.preventFullName() ? this.convertCaseIfNeeded(DBUtils.getQuotedIdentifier(objectCompletionItem.getObject())) : this.prepareQualifiedName((DBSObject)objectCompletionItem.object, objectCompletionItem.resolvedContext.object());
            name = objectCompletionItem.resolvedContext.string() + this.convertCaseIfNeeded(accomplishedPart);
        } else {
            name = this.prepareObjectName((DBSObject)objectCompletionItem.object);
        }
        return name;
    }

    @NotNull
    private <T extends DBSObject> String prepareObjectName(@NotNull DBSObject namedObject) {
        String name;
        boolean forceFullName = !this.objectBelongsToTheActiveContext(namedObject) || this.activeContextHasConflictingName(namedObject);
        String shortName = DBUtils.getQuotedIdentifier((DBSObject)namedObject);
        if (this.request.getContext().isUseShortNames() && !forceFullName) {
            name = shortName;
        } else if (this.request.getContext().isUseFQNames() || forceFullName) {
            name = DBUtils.getObjectFullName((DBPNamedObject)namedObject, (DBPEvaluationContext)DBPEvaluationContext.DML);
            if (name.equals(shortName)) {
                name = this.prepareQualifiedName(namedObject, null);
            }
        } else {
            name = shortName;
        }
        return this.convertCaseIfNeeded(name);
    }

    private boolean objectBelongsToTheActiveContext(@NotNull DBSObject object) {
        DBSObject dBSObject = object.getParentObject();
        if (dBSObject instanceof DBSObjectContainer) {
            DBSObjectContainer objectContainer = (DBSObjectContainer)dBSObject;
            if (this.queryCompletionContext.getExposedContexts().contains(objectContainer)) {
                return true;
            }
        }
        return false;
    }

    private boolean activeContextHasConflictingName(@NotNull DBSObject object) {
        try {
            if (this.activeContext != null) {
                DBSObject child = this.activeContext.getChild(this.monitor, object.getName());
                return child != null && !child.equals(object);
            }
        }
        catch (DBException e) {
            log.debug((Object)"Failed to validate database object completion name ambiguity", (Throwable)e);
        }
        return false;
    }

    private String prepareQualifiedName(@NotNull DBSObject object, DBSObject knownSubroot) {
        List<String> parts = SQLQueryCompletionItem.prepareQualifiedNameParts(object, knownSubroot);
        return String.join((CharSequence)this.structSeparator, parts);
    }

    private String prepareQualifiedName(@NotNull List<String> nameParts) {
        DBPDataSource dataSource = this.request.getContext().getDataSource();
        return nameParts.stream().map(s -> DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)s)).collect(Collectors.joining(this.structSeparator));
    }

    @NotNull
    private String convertCaseIfNeeded(@NotNull String name) {
        String result = this.request.getWordDetector().isQuoted(name) ? name : SQLCompletionAnalyzer.convertKeywordCase(this.request, name, true);
        return result;
    }

    @NotNull
    private String prepareDefiningEntryName(@NotNull SQLQuerySymbol symbol) {
        String string;
        SQLQuerySymbolDefinition sQLQuerySymbolDefinition = symbol.getDefinition();
        if (sQLQuerySymbolDefinition instanceof SQLQuerySymbolEntry) {
            SQLQuerySymbolEntry entry = (SQLQuerySymbolEntry)sQLQuerySymbolDefinition;
            string = entry.getRawName();
        } else {
            string = symbol.getName();
        }
        return string;
    }

    @Override
    @NotNull
    public String visitProcedure(@NotNull SQLQueryCompletionItem.SQLProcedureCompletionItem procedure) {
        String name = this.prepareObjectName(procedure);
        try {
            Object text;
            Collection parameters = ((DBSProcedure)procedure.getObject()).getParameters(this.monitor);
            if (!CommonUtils.isEmpty((Collection)parameters)) {
                StringBuilder sb = new StringBuilder();
                sb.append(name).append("(");
                int index = 0;
                for (DBSProcedureParameter param : parameters) {
                    if (!param.getParameterKind().isInput()) continue;
                    if (index++ > 0) {
                        sb.append(", ");
                    }
                    sb.append(":").append(param.getName());
                }
                sb.append(")");
                text = sb.toString();
            } else {
                text = name + "()";
            }
            return text;
        }
        catch (DBException e) {
            log.error((Object)"Failed to obtain procedure parameters info", (Throwable)e);
            return name;
        }
    }

    @Override
    @Nullable
    public String visitBuiltinFunction(@NotNull SQLQueryCompletionItem.SQLBuiltinFunctionCompletionItem function) {
        return function.name + "()";
    }

    @Override
    @Nullable
    public String visitSpecialText(@NotNull SQLQueryCompletionItem.SQLSpecialTextCompletionItem specialText) {
        return specialText.text;
    }
}

