/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions.links;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.ui.navigator.actions.links.CreateLinkHandler;
import org.jkiss.dbeaver.ui.navigator.actions.links.CreateLinkedFoldersRunnable;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class LinkFolderHandler
extends CreateLinkHandler {
    @Override
    protected Path[] selectTargets(ExecutionEvent event) {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        DirectoryDialog dialog = new DirectoryDialog(shell, 4096);
        String folder = dialog.open();
        if (folder == null) {
            return NO_TARGETS;
        }
        Path folderPath = Paths.get(folder, new String[0]);
        return new Path[]{folderPath};
    }

    @Override
    protected IStatus createLink(IContainer container, IProgressMonitor monitor, Path ... targets) {
        return LinkFolderHandler.createLinkedFolders(container, monitor, targets);
    }

    public static IStatus createLinkedFolders(IContainer container, IProgressMonitor monitor, Path ... paths) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        CreateLinkedFoldersRunnable action = new CreateLinkedFoldersRunnable(container, paths);
        try {
            workspace.run((ICoreRunnable)action, monitor);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (Throwable e) {
            return GeneralUtils.makeErrorStatus((String)action.composeErrorMessage((IResource)container, paths), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

