/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.List;

public class DirectedGraph {
    private final List<Node> nodes = new LinkedList<Node>();
    private final List<Edge> edges = new LinkedList<Edge>();

    public Node createNode(String label, String color) {
        Node node = new Node(this.nodes.size(), label, color);
        this.nodes.add(node);
        return node;
    }

    public Edge createEdge(Node from, Node to, String label, String color) {
        Edge edge = new Edge(from, to, label, color);
        this.edges.add(edge);
        return edge;
    }

    public void saveToFile(String fileName) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(Path.of(fileName, new String[0]), Charset.forName("utf-8"), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
                writer.write("<DirectedGraph xmlns=\"http://schemas.microsoft.com/vs/2009/dgml\">\r\n");
                writer.write("   <Nodes>\r\n");
                for (Node node : this.nodes) {
                    writer.write("      <Node Id=\"" + node.id + "\" Label=\"" + node.label + "\" Background=\"" + node.color + "\" />\r\n");
                }
                writer.write("   </Nodes>\r\n");
                writer.write("   <Links>\r\n");
                for (Edge edge : this.edges) {
                    writer.write("      <Link Source=\"" + edge.from.id + "\" Target=\"" + edge.to.id + "\" Label=\"" + edge.label + "\" Background=\"" + edge.color + "\" />\r\n");
                }
                writer.write("   </Links>\r\n");
                writer.write("</DirectedGraph>\r\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class Edge {
        public final Node from;
        public final Node to;
        public String label;
        public String color;

        public Edge(Node from, Node to, String label, String color) {
            this.from = from;
            this.to = to;
            this.label = label;
            this.color = color;
        }
    }

    class Node {
        public final int id;
        public String label;
        public String color;

        public Node(int id, String label, String color) {
            this.id = id;
            this.label = label;
            this.color = color;
        }
    }
}

