/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.dom;

import java.util.ArrayList;
import java.util.List;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.stylesheets.MediaList;

public class MediaListImpl
implements MediaList {
    private final List<String> mediaList = new ArrayList<String>();

    public MediaListImpl(SACMediaList media) {
        int i = 0;
        while (i < media.getLength()) {
            this.mediaList.add(media.item(i));
            ++i;
        }
    }

    @Override
    public void appendMedium(String newMedium) throws DOMException {
        if (this.mediaList.contains(newMedium)) {
            this.mediaList.remove(newMedium);
        }
        this.mediaList.add(newMedium);
    }

    @Override
    public void deleteMedium(String oldMedium) throws DOMException {
        this.mediaList.remove(oldMedium);
    }

    @Override
    public int getLength() {
        return this.mediaList != null ? this.mediaList.size() : 0;
    }

    @Override
    public String getMediaText() {
        StringBuilder media = new StringBuilder();
        int size = this.mediaList.size();
        if (size > 0) {
            media.append(this.mediaList.get(0));
            int i = 1;
            while (i < this.mediaList.size()) {
                media.append(", ");
                media.append(this.mediaList.get(i));
                ++i;
            }
        }
        return media.toString();
    }

    @Override
    public String item(int index) {
        if (index > this.mediaList.size()) {
            return null;
        }
        return this.mediaList.get(index);
    }

    @Override
    public void setMediaText(String mediaText) throws DOMException {
        while (mediaText.length() > 0) {
            int next = mediaText.indexOf(44);
            if (next == -1) {
                next = mediaText.length();
            }
            String media = mediaText.substring(0, next);
            this.appendMedium(media.trim());
            if (next + 1 >= mediaText.length()) break;
            mediaText = mediaText.substring(next + 1, mediaText.length());
        }
    }
}

