// Copyright © 2024 Rot127 <unisono@quyllur.org>
// SPDX-License-Identifier: BSD-3

#ifndef TEST_MAPPING_H
#define TEST_MAPPING_H

#include "../../../Mapping.h"
#include <capstone/capstone.h>

/// Maps a string to an option
typedef struct {
	const char *str;
	cs_opt opt;
} TestOptionMapEntry;

/// REMEMBER TO SORT AFTER EDIT
static const cs_enum_id_map test_arch_map[] = {
	{ .str = "AArch64", .val = CS_ARCH_AARCH64 },
	{ .str = "CS_ARCH_AARCH64", .val = CS_ARCH_AARCH64 },
	{ .str = "CS_ARCH_ALPHA", .val = CS_ARCH_ALPHA },
	{ .str = "CS_ARCH_ARC", .val = CS_ARCH_ARC },
	{ .str = "CS_ARCH_ARM", .val = CS_ARCH_ARM },
	{ .str = "CS_ARCH_BPF", .val = CS_ARCH_BPF },
	{ .str = "CS_ARCH_EVM", .val = CS_ARCH_EVM },
	{ .str = "CS_ARCH_HPPA", .val = CS_ARCH_HPPA },
	{ .str = "CS_ARCH_LOONGARCH", .val = CS_ARCH_LOONGARCH },
	{ .str = "CS_ARCH_M680X", .val = CS_ARCH_M680X },
	{ .str = "CS_ARCH_M68K", .val = CS_ARCH_M68K },
	{ .str = "CS_ARCH_MIPS", .val = CS_ARCH_MIPS },
	{ .str = "CS_ARCH_MOS65XX", .val = CS_ARCH_MOS65XX },
	{ .str = "CS_ARCH_PPC", .val = CS_ARCH_PPC },
	{ .str = "CS_ARCH_RISCV", .val = CS_ARCH_RISCV },
	{ .str = "CS_ARCH_SH", .val = CS_ARCH_SH },
	{ .str = "CS_ARCH_SPARC", .val = CS_ARCH_SPARC },
	{ .str = "CS_ARCH_SYSTEMZ", .val = CS_ARCH_SYSTEMZ },
	{ .str = "CS_ARCH_TMS320C64X", .val = CS_ARCH_TMS320C64X },
	{ .str = "CS_ARCH_TRICORE", .val = CS_ARCH_TRICORE },
	{ .str = "CS_ARCH_WASM", .val = CS_ARCH_WASM },
	{ .str = "CS_ARCH_X86", .val = CS_ARCH_X86 },
	{ .str = "CS_ARCH_XCORE", .val = CS_ARCH_XCORE },
	{ .str = "CS_ARCH_XTENSA", .val = CS_ARCH_XTENSA },
	{ .str = "aarch64", .val = CS_ARCH_AARCH64 },
	{ .str = "alpha", .val = CS_ARCH_ALPHA },
	{ .str = "arc", .val = CS_ARCH_ARC },
	{ .str = "arm", .val = CS_ARCH_ARM },
	{ .str = "bpf", .val = CS_ARCH_BPF },
	{ .str = "evm", .val = CS_ARCH_EVM },
	{ .str = "hppa", .val = CS_ARCH_HPPA },
	{ .str = "loongarch", .val = CS_ARCH_LOONGARCH },
	{ .str = "m680x", .val = CS_ARCH_M680X },
	{ .str = "m68k", .val = CS_ARCH_M68K },
	{ .str = "mips", .val = CS_ARCH_MIPS },
	{ .str = "mos65xx", .val = CS_ARCH_MOS65XX },
	{ .str = "ppc", .val = CS_ARCH_PPC },
	{ .str = "riscv", .val = CS_ARCH_RISCV },
	{ .str = "sh", .val = CS_ARCH_SH },
	{ .str = "sparc", .val = CS_ARCH_SPARC },
	{ .str = "systemz", .val = CS_ARCH_SYSTEMZ },
	{ .str = "tms320c64x", .val = CS_ARCH_TMS320C64X },
	{ .str = "tricore", .val = CS_ARCH_TRICORE },
	{ .str = "wasm", .val = CS_ARCH_WASM },
	{ .str = "x86", .val = CS_ARCH_X86 },
	{ .str = "xcore", .val = CS_ARCH_XCORE },
	{ .str = "xtensa", .val = CS_ARCH_XTENSA },
};

/// REMEMBER TO SORT AFTER EDIT
static const cs_enum_id_map test_mode_map[] = {
	{ .str = "CS_MODE_16", .val = CS_MODE_16 },
	{ .str = "CS_MODE_32", .val = CS_MODE_32 },
	{ .str = "CS_MODE_64", .val = CS_MODE_64 },
	{ .str = "CS_MODE_AIX_OS", .val = CS_MODE_AIX_OS },
	{ .str = "CS_MODE_APPLE_PROPRIETARY",
	  .val = CS_MODE_APPLE_PROPRIETARY },
	{ .str = "CS_MODE_ARM", .val = CS_MODE_ARM },
	{ .str = "CS_MODE_BIG_ENDIAN", .val = CS_MODE_BIG_ENDIAN },
	{ .str = "CS_MODE_BOOKE", .val = CS_MODE_BOOKE },
	{ .str = "CS_MODE_BPF_CLASSIC", .val = CS_MODE_BPF_CLASSIC },
	{ .str = "CS_MODE_BPF_EXTENDED", .val = CS_MODE_BPF_EXTENDED },
	{ .str = "CS_MODE_HPPA_11", .val = CS_MODE_HPPA_11 },
	{ .str = "CS_MODE_HPPA_20", .val = CS_MODE_HPPA_20 },
	{ .str = "CS_MODE_HPPA_20W", .val = CS_MODE_HPPA_20W },
	{ .str = "CS_MODE_I7200", .val = CS_MODE_I7200 },
	{ .str = "CS_MODE_LITTLE_ENDIAN", .val = CS_MODE_LITTLE_ENDIAN },
	{ .str = "CS_MODE_LOONGARCH32", .val = CS_MODE_LOONGARCH32 },
	{ .str = "CS_MODE_LOONGARCH64", .val = CS_MODE_LOONGARCH64 },
	{ .str = "CS_MODE_M680X_6301", .val = CS_MODE_M680X_6301 },
	{ .str = "CS_MODE_M680X_6309", .val = CS_MODE_M680X_6309 },
	{ .str = "CS_MODE_M680X_6800", .val = CS_MODE_M680X_6800 },
	{ .str = "CS_MODE_M680X_6801", .val = CS_MODE_M680X_6801 },
	{ .str = "CS_MODE_M680X_6805", .val = CS_MODE_M680X_6805 },
	{ .str = "CS_MODE_M680X_6808", .val = CS_MODE_M680X_6808 },
	{ .str = "CS_MODE_M680X_6809", .val = CS_MODE_M680X_6809 },
	{ .str = "CS_MODE_M680X_6811", .val = CS_MODE_M680X_6811 },
	{ .str = "CS_MODE_M680X_CPU12", .val = CS_MODE_M680X_CPU12 },
	{ .str = "CS_MODE_M680X_HCS08", .val = CS_MODE_M680X_HCS08 },
	{ .str = "CS_MODE_M68K_000", .val = CS_MODE_M68K_000 },
	{ .str = "CS_MODE_M68K_010", .val = CS_MODE_M68K_010 },
	{ .str = "CS_MODE_M68K_020", .val = CS_MODE_M68K_020 },
	{ .str = "CS_MODE_M68K_030", .val = CS_MODE_M68K_030 },
	{ .str = "CS_MODE_M68K_040", .val = CS_MODE_M68K_040 },
	{ .str = "CS_MODE_M68K_060", .val = CS_MODE_M68K_060 },
	{ .str = "CS_MODE_MCLASS", .val = CS_MODE_MCLASS },
	{ .str = "CS_MODE_MICRO", .val = CS_MODE_MICRO },
	{ .str = "CS_MODE_MICRO32R3", .val = CS_MODE_MICRO32R3 },
	{ .str = "CS_MODE_MICRO32R6", .val = CS_MODE_MICRO32R6 },
	{ .str = "CS_MODE_MIPS1", .val = CS_MODE_MIPS1 },
	{ .str = "CS_MODE_MIPS16", .val = CS_MODE_MIPS16 },
	{ .str = "CS_MODE_MIPS2", .val = CS_MODE_MIPS2 },
	{ .str = "CS_MODE_MIPS3", .val = CS_MODE_MIPS3 },
	{ .str = "CS_MODE_MIPS32", .val = CS_MODE_MIPS32 },
	{ .str = "CS_MODE_MIPS32R2", .val = CS_MODE_MIPS32R2 },
	{ .str = "CS_MODE_MIPS32R3", .val = CS_MODE_MIPS32R3 },
	{ .str = "CS_MODE_MIPS32R5", .val = CS_MODE_MIPS32R5 },
	{ .str = "CS_MODE_MIPS32R6", .val = CS_MODE_MIPS32R6 },
	{ .str = "CS_MODE_MIPS4", .val = CS_MODE_MIPS4 },
	{ .str = "CS_MODE_MIPS5", .val = CS_MODE_MIPS5 },
	{ .str = "CS_MODE_MIPS64", .val = CS_MODE_MIPS64 },
	{ .str = "CS_MODE_MIPS64R2", .val = CS_MODE_MIPS64R2 },
	{ .str = "CS_MODE_MIPS64R3", .val = CS_MODE_MIPS64R3 },
	{ .str = "CS_MODE_MIPS64R5", .val = CS_MODE_MIPS64R5 },
	{ .str = "CS_MODE_MIPS64R6", .val = CS_MODE_MIPS64R6 },
	{ .str = "CS_MODE_MIPS_NOFLOAT", .val = CS_MODE_MIPS_NOFLOAT },
	{ .str = "CS_MODE_MIPS_PTR64", .val = CS_MODE_MIPS_PTR64 },
	{ .str = "CS_MODE_MODERN_AIX_AS", .val = CS_MODE_MODERN_AIX_AS },
	{ .str = "CS_MODE_MOS65XX_6502", .val = CS_MODE_MOS65XX_6502 },
	{ .str = "CS_MODE_MOS65XX_65816", .val = CS_MODE_MOS65XX_65816 },
	{ .str = "CS_MODE_MOS65XX_65816_LONG_M",
	  .val = CS_MODE_MOS65XX_65816_LONG_M },
	{ .str = "CS_MODE_MOS65XX_65816_LONG_MX",
	  .val = CS_MODE_MOS65XX_65816_LONG_M | CS_MODE_MOS65XX_65816_LONG_X },
	{ .str = "CS_MODE_MOS65XX_65816_LONG_X",
	  .val = CS_MODE_MOS65XX_65816_LONG_X },
	{ .str = "CS_MODE_MOS65XX_65C02", .val = CS_MODE_MOS65XX_65C02 },
	{ .str = "CS_MODE_MOS65XX_W65C02", .val = CS_MODE_MOS65XX_W65C02 },
	{ .str = "CS_MODE_MSYNC", .val = CS_MODE_MSYNC },
	{ .str = "CS_MODE_NANOMIPS", .val = CS_MODE_NANOMIPS },
	{ .str = "CS_MODE_NMS1", .val = CS_MODE_NMS1 },
	{ .str = "CS_MODE_OCTEON", .val = CS_MODE_OCTEON },
	{ .str = "CS_MODE_OCTEONP", .val = CS_MODE_OCTEONP },
	{ .str = "CS_MODE_PPC_ISA_FUTURE", .val = CS_MODE_PPC_ISA_FUTURE },
	{ .str = "CS_MODE_PS", .val = CS_MODE_PS },
	{ .str = "CS_MODE_PWR10", .val = CS_MODE_PWR10 },
	{ .str = "CS_MODE_PWR7", .val = CS_MODE_PWR7 },
	{ .str = "CS_MODE_PWR8", .val = CS_MODE_PWR8 },
	{ .str = "CS_MODE_PWR9", .val = CS_MODE_PWR9 },
	{ .str = "CS_MODE_QPX", .val = CS_MODE_QPX },
	{ .str = "CS_MODE_RISCV32", .val = CS_MODE_RISCV32 },
	{ .str = "CS_MODE_RISCV64", .val = CS_MODE_RISCV64 },
	{ .str = "CS_MODE_RISCVC", .val = CS_MODE_RISCVC },
	{ .str = "CS_MODE_SH2", .val = CS_MODE_SH2 },
	{ .str = "CS_MODE_SH2A", .val = CS_MODE_SH2A },
	{ .str = "CS_MODE_SH3", .val = CS_MODE_SH3 },
	{ .str = "CS_MODE_SH4", .val = CS_MODE_SH4 },
	{ .str = "CS_MODE_SH4A", .val = CS_MODE_SH4A },
	{ .str = "CS_MODE_SHDSP", .val = CS_MODE_SHDSP },
	{ .str = "CS_MODE_SHFPU", .val = CS_MODE_SHFPU },
	{ .str = "CS_MODE_SPE", .val = CS_MODE_SPE },
	{ .str = "CS_MODE_SYSTEMZ_ARCH10", .val = CS_MODE_SYSTEMZ_ARCH10 },
	{ .str = "CS_MODE_SYSTEMZ_ARCH11", .val = CS_MODE_SYSTEMZ_ARCH11 },
	{ .str = "CS_MODE_SYSTEMZ_ARCH12", .val = CS_MODE_SYSTEMZ_ARCH12 },
	{ .str = "CS_MODE_SYSTEMZ_ARCH13", .val = CS_MODE_SYSTEMZ_ARCH13 },
	{ .str = "CS_MODE_SYSTEMZ_ARCH14", .val = CS_MODE_SYSTEMZ_ARCH14 },
	{ .str = "CS_MODE_SYSTEMZ_ARCH8", .val = CS_MODE_SYSTEMZ_ARCH8 },
	{ .str = "CS_MODE_SYSTEMZ_ARCH9", .val = CS_MODE_SYSTEMZ_ARCH9 },
	{ .str = "CS_MODE_SYSTEMZ_GENERIC", .val = CS_MODE_SYSTEMZ_GENERIC },
	{ .str = "CS_MODE_SYSTEMZ_Z10", .val = CS_MODE_SYSTEMZ_Z10 },
	{ .str = "CS_MODE_SYSTEMZ_Z13", .val = CS_MODE_SYSTEMZ_Z13 },
	{ .str = "CS_MODE_SYSTEMZ_Z14", .val = CS_MODE_SYSTEMZ_Z14 },
	{ .str = "CS_MODE_SYSTEMZ_Z15", .val = CS_MODE_SYSTEMZ_Z15 },
	{ .str = "CS_MODE_SYSTEMZ_Z16", .val = CS_MODE_SYSTEMZ_Z16 },
	{ .str = "CS_MODE_SYSTEMZ_Z196", .val = CS_MODE_SYSTEMZ_Z196 },
	{ .str = "CS_MODE_SYSTEMZ_ZEC12", .val = CS_MODE_SYSTEMZ_ZEC12 },
	{ .str = "CS_MODE_THUMB", .val = CS_MODE_THUMB },
	{ .str = "CS_MODE_TRICORE_110", .val = CS_MODE_TRICORE_110 },
	{ .str = "CS_MODE_TRICORE_120", .val = CS_MODE_TRICORE_120 },
	{ .str = "CS_MODE_TRICORE_130", .val = CS_MODE_TRICORE_130 },
	{ .str = "CS_MODE_TRICORE_131", .val = CS_MODE_TRICORE_131 },
	{ .str = "CS_MODE_TRICORE_160", .val = CS_MODE_TRICORE_160 },
	{ .str = "CS_MODE_TRICORE_161", .val = CS_MODE_TRICORE_161 },
	{ .str = "CS_MODE_TRICORE_162", .val = CS_MODE_TRICORE_162 },
	{ .str = "CS_MODE_TRICORE_180", .val = CS_MODE_TRICORE_180 },
	{ .str = "CS_MODE_V8", .val = CS_MODE_V8 },
	{ .str = "CS_MODE_V9", .val = CS_MODE_V9 },
	{ .str = "CS_MODE_XTENSA_ESP32", .val = CS_MODE_XTENSA_ESP32 },
	{ .str = "CS_MODE_XTENSA_ESP32S2", .val = CS_MODE_XTENSA_ESP32S2 },
	{ .str = "CS_MODE_XTENSA_ESP8266", .val = CS_MODE_XTENSA_ESP8266 },
};

static const TestOptionMapEntry test_option_map[] = {
	{ .str = "CS_OPT_DETAIL",
	  .opt = { .type = CS_OPT_DETAIL, .val = CS_OPT_ON } },
	{ .str = "CS_OPT_DETAIL_REAL",
	  .opt = { .type = CS_OPT_DETAIL,
		   .val = CS_OPT_DETAIL_REAL | CS_OPT_ON } },
	{ .str = "CS_OPT_SKIPDATA",
	  .opt = { .type = CS_OPT_SKIPDATA, .val = CS_OPT_ON } },
	{ .str = "CS_OPT_UNSIGNED",
	  .opt = { .type = CS_OPT_UNSIGNED, .val = CS_OPT_ON } },
	{ .str = "CS_OPT_ONLY_OFFSET_BRANCH",
	  .opt = { .type = CS_OPT_ONLY_OFFSET_BRANCH, .val = CS_OPT_ON } },
	{ .str = "CS_OPT_SYNTAX_DEFAULT",
	  .opt = { .type = CS_OPT_SYNTAX, .val = CS_OPT_SYNTAX_DEFAULT } },
	{ .str = "CS_OPT_SYNTAX_INTEL",
	  .opt = { .type = CS_OPT_SYNTAX, .val = CS_OPT_SYNTAX_INTEL } },
	{ .str = "CS_OPT_SYNTAX_ATT",
	  .opt = { .type = CS_OPT_SYNTAX, .val = CS_OPT_SYNTAX_ATT } },
	{ .str = "CS_OPT_SYNTAX_NOREGNAME",
	  .opt = { .type = CS_OPT_SYNTAX, .val = CS_OPT_SYNTAX_NOREGNAME } },
	{ .str = "CS_OPT_SYNTAX_MASM",
	  .opt = { .type = CS_OPT_SYNTAX, .val = CS_OPT_SYNTAX_MASM } },
	{ .str = "CS_OPT_SYNTAX_MOTOROLA",
	  .opt = { .type = CS_OPT_SYNTAX, .val = CS_OPT_SYNTAX_MOTOROLA } },
	{ .str = "CS_OPT_SYNTAX_CS_REG_ALIAS",
	  .opt = { .type = CS_OPT_SYNTAX, .val = CS_OPT_SYNTAX_CS_REG_ALIAS } },
	{ .str = "CS_OPT_SYNTAX_PERCENT",
	  .opt = { .type = CS_OPT_SYNTAX, .val = CS_OPT_SYNTAX_PERCENT } },
	{ .str = "CS_OPT_SYNTAX_NO_DOLLAR",
	  .opt = { .type = CS_OPT_SYNTAX, .val = CS_OPT_SYNTAX_NO_DOLLAR } },
};

static const cs_enum_id_map cs_enum_map[] = {
	{ .str = "AAAAAAAAAAAAAAAAAAAAAAAAAA", .val = 0xffffff }, // For testing
	{ .str = "AAAAAAAAAAAAAAAAAAAAAAAAAB", .val = 0xffffff }, // For testing
	{ .str = "AARCH64LAYOUT_INVALID", .val = AARCH64LAYOUT_INVALID },
	{ .str = "AARCH64LAYOUT_VL_16B", .val = AARCH64LAYOUT_VL_16B },
	{ .str = "AARCH64LAYOUT_VL_16S", .val = AARCH64LAYOUT_VL_16S },
	{ .str = "AARCH64LAYOUT_VL_1D", .val = AARCH64LAYOUT_VL_1D },
	{ .str = "AARCH64LAYOUT_VL_1Q", .val = AARCH64LAYOUT_VL_1Q },
	{ .str = "AARCH64LAYOUT_VL_1S", .val = AARCH64LAYOUT_VL_1S },
	{ .str = "AARCH64LAYOUT_VL_2D", .val = AARCH64LAYOUT_VL_2D },
	{ .str = "AARCH64LAYOUT_VL_2H", .val = AARCH64LAYOUT_VL_2H },
	{ .str = "AARCH64LAYOUT_VL_2S", .val = AARCH64LAYOUT_VL_2S },
	{ .str = "AARCH64LAYOUT_VL_32H", .val = AARCH64LAYOUT_VL_32H },
	{ .str = "AARCH64LAYOUT_VL_4B", .val = AARCH64LAYOUT_VL_4B },
	{ .str = "AARCH64LAYOUT_VL_4H", .val = AARCH64LAYOUT_VL_4H },
	{ .str = "AARCH64LAYOUT_VL_4S", .val = AARCH64LAYOUT_VL_4S },
	{ .str = "AARCH64LAYOUT_VL_64B", .val = AARCH64LAYOUT_VL_64B },
	{ .str = "AARCH64LAYOUT_VL_8B", .val = AARCH64LAYOUT_VL_8B },
	{ .str = "AARCH64LAYOUT_VL_8D", .val = AARCH64LAYOUT_VL_8D },
	{ .str = "AARCH64LAYOUT_VL_8H", .val = AARCH64LAYOUT_VL_8H },
	{ .str = "AARCH64LAYOUT_VL_B", .val = AARCH64LAYOUT_VL_B },
	{ .str = "AARCH64LAYOUT_VL_COMPLETE",
	  .val = AARCH64LAYOUT_VL_COMPLETE },
	{ .str = "AARCH64LAYOUT_VL_D", .val = AARCH64LAYOUT_VL_D },
	{ .str = "AARCH64LAYOUT_VL_H", .val = AARCH64LAYOUT_VL_H },
	{ .str = "AARCH64LAYOUT_VL_Q", .val = AARCH64LAYOUT_VL_Q },
	{ .str = "AARCH64LAYOUT_VL_S", .val = AARCH64LAYOUT_VL_S },
	{ .str = "AARCH64_EXT_INVALID", .val = AARCH64_EXT_INVALID },
	{ .str = "AARCH64_EXT_SXTB", .val = AARCH64_EXT_SXTB },
	{ .str = "AARCH64_EXT_SXTH", .val = AARCH64_EXT_SXTH },
	{ .str = "AARCH64_EXT_SXTW", .val = AARCH64_EXT_SXTW },
	{ .str = "AARCH64_EXT_SXTX", .val = AARCH64_EXT_SXTX },
	{ .str = "AARCH64_EXT_UXTB", .val = AARCH64_EXT_UXTB },
	{ .str = "AARCH64_EXT_UXTH", .val = AARCH64_EXT_UXTH },
	{ .str = "AARCH64_EXT_UXTW", .val = AARCH64_EXT_UXTW },
	{ .str = "AARCH64_EXT_UXTX", .val = AARCH64_EXT_UXTX },
	{ .str = "AARCH64_OP_AT", .val = AARCH64_OP_AT },
	{ .str = "AARCH64_OP_BTI", .val = AARCH64_OP_BTI },
	{ .str = "AARCH64_OP_CIMM", .val = AARCH64_OP_CIMM },
	{ .str = "AARCH64_OP_DB", .val = AARCH64_OP_DB },
	{ .str = "AARCH64_OP_DBNXS", .val = AARCH64_OP_DBNXS },
	{ .str = "AARCH64_OP_DC", .val = AARCH64_OP_DC },
	{ .str = "AARCH64_OP_EXACTFPIMM", .val = AARCH64_OP_EXACTFPIMM },
	{ .str = "AARCH64_OP_FP", .val = AARCH64_OP_FP },
	{ .str = "AARCH64_OP_IC", .val = AARCH64_OP_IC },
	{ .str = "AARCH64_OP_IMM", .val = AARCH64_OP_IMM },
	{ .str = "AARCH64_OP_IMM_RANGE", .val = AARCH64_OP_IMM_RANGE },
	{ .str = "AARCH64_OP_IMPLICIT_IMM_0",
	  .val = AARCH64_OP_IMPLICIT_IMM_0 },
	{ .str = "AARCH64_OP_ISB", .val = AARCH64_OP_ISB },
	{ .str = "AARCH64_OP_MEM", .val = AARCH64_OP_MEM },
	{ .str = "AARCH64_OP_MEM_IMM", .val = AARCH64_OP_MEM_IMM },
	{ .str = "AARCH64_OP_MEM_REG", .val = AARCH64_OP_MEM_REG },
	{ .str = "AARCH64_OP_PRED", .val = AARCH64_OP_PRED },
	{ .str = "AARCH64_OP_PRFM", .val = AARCH64_OP_PRFM },
	{ .str = "AARCH64_OP_PSB", .val = AARCH64_OP_PSB },
	{ .str = "AARCH64_OP_PSTATEIMM0_1", .val = AARCH64_OP_PSTATEIMM0_1 },
	{ .str = "AARCH64_OP_PSTATEIMM0_15", .val = AARCH64_OP_PSTATEIMM0_15 },
	{ .str = "AARCH64_OP_REG", .val = AARCH64_OP_REG },
	{ .str = "AARCH64_OP_REG_MRS", .val = AARCH64_OP_REG_MRS },
	{ .str = "AARCH64_OP_REG_MSR", .val = AARCH64_OP_REG_MSR },
	{ .str = "AARCH64_OP_RPRFM", .val = AARCH64_OP_RPRFM },
	{ .str = "AARCH64_OP_SME", .val = AARCH64_OP_SME },
	{ .str = "AARCH64_OP_SVCR", .val = AARCH64_OP_SVCR },
	{ .str = "AARCH64_OP_SVEPREDPAT", .val = AARCH64_OP_SVEPREDPAT },
	{ .str = "AARCH64_OP_SVEPRFM", .val = AARCH64_OP_SVEPRFM },
	{ .str = "AARCH64_OP_SVEVECLENSPECIFIER",
	  .val = AARCH64_OP_SVEVECLENSPECIFIER },
	{ .str = "AARCH64_OP_SYSALIAS", .val = AARCH64_OP_SYSALIAS },
	{ .str = "AARCH64_OP_SYSIMM", .val = AARCH64_OP_SYSIMM },
	{ .str = "AARCH64_OP_SYSREG", .val = AARCH64_OP_SYSREG },
	{ .str = "AARCH64_OP_TLBI", .val = AARCH64_OP_TLBI },
	{ .str = "AARCH64_OP_TSB", .val = AARCH64_OP_TSB },
	{ .str = "AARCH64_SFT_ASR", .val = AARCH64_SFT_ASR },
	{ .str = "AARCH64_SFT_ASR_REG", .val = AARCH64_SFT_ASR_REG },
	{ .str = "AARCH64_SFT_INVALID", .val = AARCH64_SFT_INVALID },
	{ .str = "AARCH64_SFT_LSL", .val = AARCH64_SFT_LSL },
	{ .str = "AARCH64_SFT_LSL_REG", .val = AARCH64_SFT_LSL_REG },
	{ .str = "AARCH64_SFT_LSR", .val = AARCH64_SFT_LSR },
	{ .str = "AARCH64_SFT_LSR_REG", .val = AARCH64_SFT_LSR_REG },
	{ .str = "AARCH64_SFT_MSL", .val = AARCH64_SFT_MSL },
	{ .str = "AARCH64_SFT_MSL_REG", .val = AARCH64_SFT_MSL_REG },
	{ .str = "AARCH64_SFT_ROR", .val = AARCH64_SFT_ROR },
	{ .str = "AARCH64_SFT_ROR_REG", .val = AARCH64_SFT_ROR_REG },
	{ .str = "AARCH64_SME_OP_INVALID", .val = AARCH64_SME_OP_INVALID },
	{ .str = "AARCH64_SME_OP_TILE", .val = AARCH64_SME_OP_TILE },
	{ .str = "AARCH64_SME_OP_TILE_VEC", .val = AARCH64_SME_OP_TILE_VEC },
	{ .str = "AArch64CC_AL", .val = AArch64CC_AL },
	{ .str = "AArch64CC_EQ", .val = AArch64CC_EQ },
	{ .str = "AArch64CC_GE", .val = AArch64CC_GE },
	{ .str = "AArch64CC_GT", .val = AArch64CC_GT },
	{ .str = "AArch64CC_HI", .val = AArch64CC_HI },
	{ .str = "AArch64CC_HS", .val = AArch64CC_HS },
	{ .str = "AArch64CC_Invalid", .val = AArch64CC_Invalid },
	{ .str = "AArch64CC_LE", .val = AArch64CC_LE },
	{ .str = "AArch64CC_LO", .val = AArch64CC_LO },
	{ .str = "AArch64CC_LS", .val = AArch64CC_LS },
	{ .str = "AArch64CC_LT", .val = AArch64CC_LT },
	{ .str = "AArch64CC_MI", .val = AArch64CC_MI },
	{ .str = "AArch64CC_NE", .val = AArch64CC_NE },
	{ .str = "AArch64CC_NV", .val = AArch64CC_NV },
	{ .str = "AArch64CC_PL", .val = AArch64CC_PL },
	{ .str = "AArch64CC_VC", .val = AArch64CC_VC },
	{ .str = "AArch64CC_VS", .val = AArch64CC_VS },
	{ .str = "ALPHA_OP_IMM", .val = ALPHA_OP_IMM },
	{ .str = "ALPHA_OP_REG", .val = ALPHA_OP_REG },
	{ .str = "ARC_GRP_BRANCH_RELATIVE", .val = ARC_GRP_BRANCH_RELATIVE },
	{ .str = "ARC_GRP_CALL", .val = ARC_GRP_CALL },
	{ .str = "ARC_GRP_JUMP", .val = ARC_GRP_JUMP },
	{ .str = "ARC_GRP_RET", .val = ARC_GRP_RET },
	{ .str = "ARC_OP_IMM", .val = ARC_OP_IMM },
	{ .str = "ARC_OP_REG", .val = ARC_OP_REG },
	{ .str = "ARMCC_AL", .val = ARMCC_AL },
	{ .str = "ARMCC_EQ", .val = ARMCC_EQ },
	{ .str = "ARMCC_GE", .val = ARMCC_GE },
	{ .str = "ARMCC_GT", .val = ARMCC_GT },
	{ .str = "ARMCC_HI", .val = ARMCC_HI },
	{ .str = "ARMCC_HS", .val = ARMCC_HS },
	{ .str = "ARMCC_LE", .val = ARMCC_LE },
	{ .str = "ARMCC_LO", .val = ARMCC_LO },
	{ .str = "ARMCC_LS", .val = ARMCC_LS },
	{ .str = "ARMCC_LT", .val = ARMCC_LT },
	{ .str = "ARMCC_MI", .val = ARMCC_MI },
	{ .str = "ARMCC_NE", .val = ARMCC_NE },
	{ .str = "ARMCC_PL", .val = ARMCC_PL },
	{ .str = "ARMCC_UNDEF", .val = ARMCC_UNDEF },
	{ .str = "ARMCC_VC", .val = ARMCC_VC },
	{ .str = "ARMCC_VS", .val = ARMCC_VS },
	{ .str = "ARMVCC_Else", .val = ARMVCC_Else },
	{ .str = "ARMVCC_None", .val = ARMVCC_None },
	{ .str = "ARMVCC_Then", .val = ARMVCC_Then },
	{ .str = "ARM_CPSFLAG_A", .val = ARM_CPSFLAG_A },
	{ .str = "ARM_CPSFLAG_F", .val = ARM_CPSFLAG_F },
	{ .str = "ARM_CPSFLAG_I", .val = ARM_CPSFLAG_I },
	{ .str = "ARM_CPSFLAG_INVALID", .val = ARM_CPSFLAG_INVALID },
	{ .str = "ARM_CPSFLAG_NONE", .val = ARM_CPSFLAG_NONE },
	{ .str = "ARM_CPSMODE_ID", .val = ARM_CPSMODE_ID },
	{ .str = "ARM_CPSMODE_IE", .val = ARM_CPSMODE_IE },
	{ .str = "ARM_CPSMODE_INVALID", .val = ARM_CPSMODE_INVALID },
	{ .str = "ARM_FIELD_CPSR_C", .val = ARM_FIELD_CPSR_C },
	{ .str = "ARM_FIELD_CPSR_F", .val = ARM_FIELD_CPSR_F },
	{ .str = "ARM_FIELD_CPSR_S", .val = ARM_FIELD_CPSR_S },
	{ .str = "ARM_FIELD_CPSR_X", .val = ARM_FIELD_CPSR_X },
	{ .str = "ARM_FIELD_SPSR_C", .val = ARM_FIELD_SPSR_C },
	{ .str = "ARM_FIELD_SPSR_F", .val = ARM_FIELD_SPSR_F },
	{ .str = "ARM_FIELD_SPSR_S", .val = ARM_FIELD_SPSR_S },
	{ .str = "ARM_FIELD_SPSR_X", .val = ARM_FIELD_SPSR_X },
	{ .str = "ARM_MB_ISH", .val = ARM_MB_ISH },
	{ .str = "ARM_MB_ISHLD", .val = ARM_MB_ISHLD },
	{ .str = "ARM_MB_ISHST", .val = ARM_MB_ISHST },
	{ .str = "ARM_MB_LD", .val = ARM_MB_LD },
	{ .str = "ARM_MB_NSH", .val = ARM_MB_NSH },
	{ .str = "ARM_MB_NSHLD", .val = ARM_MB_NSHLD },
	{ .str = "ARM_MB_NSHST", .val = ARM_MB_NSHST },
	{ .str = "ARM_MB_OSH", .val = ARM_MB_OSH },
	{ .str = "ARM_MB_OSHLD", .val = ARM_MB_OSHLD },
	{ .str = "ARM_MB_OSHST", .val = ARM_MB_OSHST },
	{ .str = "ARM_MB_RESERVED_0", .val = ARM_MB_RESERVED_0 },
	{ .str = "ARM_MB_RESERVED_12", .val = ARM_MB_RESERVED_12 },
	{ .str = "ARM_MB_RESERVED_4", .val = ARM_MB_RESERVED_4 },
	{ .str = "ARM_MB_RESERVED_8", .val = ARM_MB_RESERVED_8 },
	{ .str = "ARM_MB_ST", .val = ARM_MB_ST },
	{ .str = "ARM_MB_SY", .val = ARM_MB_SY },
	{ .str = "ARM_OP_BANKEDREG", .val = ARM_OP_BANKEDREG },
	{ .str = "ARM_OP_CIMM", .val = ARM_OP_CIMM },
	{ .str = "ARM_OP_CPSR", .val = ARM_OP_CPSR },
	{ .str = "ARM_OP_FP", .val = ARM_OP_FP },
	{ .str = "ARM_OP_IMM", .val = ARM_OP_IMM },
	{ .str = "ARM_OP_MEM", .val = ARM_OP_MEM },
	{ .str = "ARM_OP_PIMM", .val = ARM_OP_PIMM },
	{ .str = "ARM_OP_PRED", .val = ARM_OP_PRED },
	{ .str = "ARM_OP_REG", .val = ARM_OP_REG },
	{ .str = "ARM_OP_SETEND", .val = ARM_OP_SETEND },
	{ .str = "ARM_OP_SPSR", .val = ARM_OP_SPSR },
	{ .str = "ARM_OP_SYSM", .val = ARM_OP_SYSM },
	{ .str = "ARM_OP_SYSREG", .val = ARM_OP_SYSREG },
	{ .str = "ARM_OP_VPRED_N", .val = ARM_OP_VPRED_N },
	{ .str = "ARM_OP_VPRED_R", .val = ARM_OP_VPRED_R },
	{ .str = "ARM_SETEND_BE", .val = ARM_SETEND_BE },
	{ .str = "ARM_SETEND_INVALID", .val = ARM_SETEND_INVALID },
	{ .str = "ARM_SETEND_LE", .val = ARM_SETEND_LE },
	{ .str = "ARM_SFT_ASR", .val = ARM_SFT_ASR },
	{ .str = "ARM_SFT_ASR_REG", .val = ARM_SFT_ASR_REG },
	{ .str = "ARM_SFT_INVALID", .val = ARM_SFT_INVALID },
	{ .str = "ARM_SFT_LSL", .val = ARM_SFT_LSL },
	{ .str = "ARM_SFT_LSL_REG", .val = ARM_SFT_LSL_REG },
	{ .str = "ARM_SFT_LSR", .val = ARM_SFT_LSR },
	{ .str = "ARM_SFT_LSR_REG", .val = ARM_SFT_LSR_REG },
	{ .str = "ARM_SFT_ROR", .val = ARM_SFT_ROR },
	{ .str = "ARM_SFT_ROR_REG", .val = ARM_SFT_ROR_REG },
	{ .str = "ARM_SFT_RRX", .val = ARM_SFT_RRX },
	{ .str = "ARM_SFT_UXTW", .val = ARM_SFT_UXTW },
	{ .str = "ARM_T", .val = ARM_T },
	{ .str = "ARM_TE", .val = ARM_TE },
	{ .str = "ARM_TEE", .val = ARM_TEE },
	{ .str = "ARM_TEEE", .val = ARM_TEEE },
	{ .str = "ARM_TEET", .val = ARM_TEET },
	{ .str = "ARM_TET", .val = ARM_TET },
	{ .str = "ARM_TETE", .val = ARM_TETE },
	{ .str = "ARM_TETT", .val = ARM_TETT },
	{ .str = "ARM_TT", .val = ARM_TT },
	{ .str = "ARM_TTE", .val = ARM_TTE },
	{ .str = "ARM_TTEE", .val = ARM_TTEE },
	{ .str = "ARM_TTET", .val = ARM_TTET },
	{ .str = "ARM_TTT", .val = ARM_TTT },
	{ .str = "ARM_TTTE", .val = ARM_TTTE },
	{ .str = "ARM_TTTT", .val = ARM_TTTT },
	{ .str = "ARM_VECTORDATA_F16", .val = ARM_VECTORDATA_F16 },
	{ .str = "ARM_VECTORDATA_F16F32", .val = ARM_VECTORDATA_F16F32 },
	{ .str = "ARM_VECTORDATA_F16F64", .val = ARM_VECTORDATA_F16F64 },
	{ .str = "ARM_VECTORDATA_F16S16", .val = ARM_VECTORDATA_F16S16 },
	{ .str = "ARM_VECTORDATA_F16S32", .val = ARM_VECTORDATA_F16S32 },
	{ .str = "ARM_VECTORDATA_F16U16", .val = ARM_VECTORDATA_F16U16 },
	{ .str = "ARM_VECTORDATA_F16U32", .val = ARM_VECTORDATA_F16U32 },
	{ .str = "ARM_VECTORDATA_F32", .val = ARM_VECTORDATA_F32 },
	{ .str = "ARM_VECTORDATA_F32F16", .val = ARM_VECTORDATA_F32F16 },
	{ .str = "ARM_VECTORDATA_F32F64", .val = ARM_VECTORDATA_F32F64 },
	{ .str = "ARM_VECTORDATA_F32S16", .val = ARM_VECTORDATA_F32S16 },
	{ .str = "ARM_VECTORDATA_F32S32", .val = ARM_VECTORDATA_F32S32 },
	{ .str = "ARM_VECTORDATA_F32U16", .val = ARM_VECTORDATA_F32U16 },
	{ .str = "ARM_VECTORDATA_F32U32", .val = ARM_VECTORDATA_F32U32 },
	{ .str = "ARM_VECTORDATA_F64", .val = ARM_VECTORDATA_F64 },
	{ .str = "ARM_VECTORDATA_F64F16", .val = ARM_VECTORDATA_F64F16 },
	{ .str = "ARM_VECTORDATA_F64F32", .val = ARM_VECTORDATA_F64F32 },
	{ .str = "ARM_VECTORDATA_F64S16", .val = ARM_VECTORDATA_F64S16 },
	{ .str = "ARM_VECTORDATA_F64S32", .val = ARM_VECTORDATA_F64S32 },
	{ .str = "ARM_VECTORDATA_F64U16", .val = ARM_VECTORDATA_F64U16 },
	{ .str = "ARM_VECTORDATA_F64U32", .val = ARM_VECTORDATA_F64U32 },
	{ .str = "ARM_VECTORDATA_I16", .val = ARM_VECTORDATA_I16 },
	{ .str = "ARM_VECTORDATA_I32", .val = ARM_VECTORDATA_I32 },
	{ .str = "ARM_VECTORDATA_I64", .val = ARM_VECTORDATA_I64 },
	{ .str = "ARM_VECTORDATA_I8", .val = ARM_VECTORDATA_I8 },
	{ .str = "ARM_VECTORDATA_INVALID", .val = ARM_VECTORDATA_INVALID },
	{ .str = "ARM_VECTORDATA_P16", .val = ARM_VECTORDATA_P16 },
	{ .str = "ARM_VECTORDATA_P8", .val = ARM_VECTORDATA_P8 },
	{ .str = "ARM_VECTORDATA_S16", .val = ARM_VECTORDATA_S16 },
	{ .str = "ARM_VECTORDATA_S16F16", .val = ARM_VECTORDATA_S16F16 },
	{ .str = "ARM_VECTORDATA_S16F32", .val = ARM_VECTORDATA_S16F32 },
	{ .str = "ARM_VECTORDATA_S16F64", .val = ARM_VECTORDATA_S16F64 },
	{ .str = "ARM_VECTORDATA_S32", .val = ARM_VECTORDATA_S32 },
	{ .str = "ARM_VECTORDATA_S32F16", .val = ARM_VECTORDATA_S32F16 },
	{ .str = "ARM_VECTORDATA_S32F32", .val = ARM_VECTORDATA_S32F32 },
	{ .str = "ARM_VECTORDATA_S32F64", .val = ARM_VECTORDATA_S32F64 },
	{ .str = "ARM_VECTORDATA_S64", .val = ARM_VECTORDATA_S64 },
	{ .str = "ARM_VECTORDATA_S8", .val = ARM_VECTORDATA_S8 },
	{ .str = "ARM_VECTORDATA_U16", .val = ARM_VECTORDATA_U16 },
	{ .str = "ARM_VECTORDATA_U16F16", .val = ARM_VECTORDATA_U16F16 },
	{ .str = "ARM_VECTORDATA_U16F32", .val = ARM_VECTORDATA_U16F32 },
	{ .str = "ARM_VECTORDATA_U16F64", .val = ARM_VECTORDATA_U16F64 },
	{ .str = "ARM_VECTORDATA_U32", .val = ARM_VECTORDATA_U32 },
	{ .str = "ARM_VECTORDATA_U32F16", .val = ARM_VECTORDATA_U32F16 },
	{ .str = "ARM_VECTORDATA_U32F32", .val = ARM_VECTORDATA_U32F32 },
	{ .str = "ARM_VECTORDATA_U32F64", .val = ARM_VECTORDATA_U32F64 },
	{ .str = "ARM_VECTORDATA_U64", .val = ARM_VECTORDATA_U64 },
	{ .str = "ARM_VECTORDATA_U8", .val = ARM_VECTORDATA_U8 },
	{ .str = "Alpha_GRP_BRANCH_RELATIVE",
	  .val = Alpha_GRP_BRANCH_RELATIVE },
	{ .str = "Alpha_GRP_CALL", .val = Alpha_GRP_CALL },
	{ .str = "Alpha_GRP_ENDING", .val = Alpha_GRP_ENDING },
	{ .str = "Alpha_GRP_JUMP", .val = Alpha_GRP_JUMP },
	{ .str = "BPF_EXT_LEN", .val = BPF_EXT_LEN },
	{ .str = "BPF_GRP_ALU", .val = BPF_GRP_ALU },
	{ .str = "BPF_GRP_CALL", .val = BPF_GRP_CALL },
	{ .str = "BPF_GRP_JUMP", .val = BPF_GRP_JUMP },
	{ .str = "BPF_GRP_LOAD", .val = BPF_GRP_LOAD },
	{ .str = "BPF_GRP_MISC", .val = BPF_GRP_MISC },
	{ .str = "BPF_GRP_RETURN", .val = BPF_GRP_RETURN },
	{ .str = "BPF_GRP_STORE", .val = BPF_GRP_STORE },
	{ .str = "BPF_OP_EXT", .val = BPF_OP_EXT },
	{ .str = "BPF_OP_IMM", .val = BPF_OP_IMM },
	{ .str = "BPF_OP_MEM", .val = BPF_OP_MEM },
	{ .str = "BPF_OP_MMEM", .val = BPF_OP_MMEM },
	{ .str = "BPF_OP_MSH", .val = BPF_OP_MSH },
	{ .str = "BPF_OP_OFF", .val = BPF_OP_OFF },
	{ .str = "BPF_OP_REG", .val = BPF_OP_REG },
	{ .str = "CS_AC_READ", .val = CS_AC_READ },
	{ .str = "CS_AC_READ_WRITE", .val = CS_AC_READ_WRITE },
	{ .str = "CS_AC_WRITE", .val = CS_AC_WRITE },
	{ .str = "CS_OP_BOUND", .val = CS_OP_BOUND },
	{ .str = "CS_OP_FP", .val = CS_OP_FP },
	{ .str = "CS_OP_IMM", .val = CS_OP_IMM },
	{ .str = "CS_OP_INVALID", .val = CS_OP_INVALID },
	{ .str = "CS_OP_MEM", .val = CS_OP_MEM },
	{ .str = "CS_OP_MEM_IMM", .val = CS_OP_MEM_IMM },
	{ .str = "CS_OP_MEM_REG", .val = CS_OP_MEM_REG },
	{ .str = "CS_OP_PRED", .val = CS_OP_PRED },
	{ .str = "CS_OP_REG", .val = CS_OP_REG },
	{ .str = "CS_OP_RESERVED_10", .val = CS_OP_RESERVED_10 },
	{ .str = "CS_OP_RESERVED_11", .val = CS_OP_RESERVED_11 },
	{ .str = "CS_OP_RESERVED_12", .val = CS_OP_RESERVED_12 },
	{ .str = "CS_OP_RESERVED_13", .val = CS_OP_RESERVED_13 },
	{ .str = "CS_OP_RESERVED_14", .val = CS_OP_RESERVED_14 },
	{ .str = "CS_OP_RESERVED_15", .val = CS_OP_RESERVED_15 },
	{ .str = "CS_OP_RESERVED_5", .val = CS_OP_RESERVED_5 },
	{ .str = "CS_OP_RESERVED_6", .val = CS_OP_RESERVED_6 },
	{ .str = "CS_OP_RESERVED_7", .val = CS_OP_RESERVED_7 },
	{ .str = "CS_OP_RESERVED_8", .val = CS_OP_RESERVED_8 },
	{ .str = "CS_OP_RESERVED_9", .val = CS_OP_RESERVED_9 },
	{ .str = "CS_OP_SPECIAL", .val = CS_OP_SPECIAL },
	{ .str = "EVM_GRP_HALT", .val = EVM_GRP_HALT },
	{ .str = "EVM_GRP_JUMP", .val = EVM_GRP_JUMP },
	{ .str = "EVM_GRP_MATH", .val = EVM_GRP_MATH },
	{ .str = "EVM_GRP_MEM_READ", .val = EVM_GRP_MEM_READ },
	{ .str = "EVM_GRP_MEM_WRITE", .val = EVM_GRP_MEM_WRITE },
	{ .str = "EVM_GRP_STACK_READ", .val = EVM_GRP_STACK_READ },
	{ .str = "EVM_GRP_STACK_WRITE", .val = EVM_GRP_STACK_WRITE },
	{ .str = "EVM_GRP_STORE_READ", .val = EVM_GRP_STORE_READ },
	{ .str = "EVM_GRP_STORE_WRITE", .val = EVM_GRP_STORE_WRITE },
	{ .str = "HPPA_GRP_ASSIST", .val = HPPA_GRP_ASSIST },
	{ .str = "HPPA_GRP_BRANCH", .val = HPPA_GRP_BRANCH },
	{ .str = "HPPA_GRP_COMPUTATION", .val = HPPA_GRP_COMPUTATION },
	{ .str = "HPPA_GRP_FLOAT", .val = HPPA_GRP_FLOAT },
	{ .str = "HPPA_GRP_LONG_IMM", .val = HPPA_GRP_LONG_IMM },
	{ .str = "HPPA_GRP_MEM_REF", .val = HPPA_GRP_MEM_REF },
	{ .str = "HPPA_GRP_MULTIMEDIA", .val = HPPA_GRP_MULTIMEDIA },
	{ .str = "HPPA_GRP_PERFMON", .val = HPPA_GRP_PERFMON },
	{ .str = "HPPA_GRP_SYSCTRL", .val = HPPA_GRP_SYSCTRL },
	{ .str = "HPPA_OP_DISP", .val = HPPA_OP_DISP },
	{ .str = "HPPA_OP_IDX_REG", .val = HPPA_OP_IDX_REG },
	{ .str = "HPPA_OP_IMM", .val = HPPA_OP_IMM },
	{ .str = "HPPA_OP_MEM", .val = HPPA_OP_MEM },
	{ .str = "HPPA_OP_REG", .val = HPPA_OP_REG },
	{ .str = "HPPA_OP_TARGET", .val = HPPA_OP_TARGET },
	{ .str = "LOONGARCH_FEATURE_HASLAGLOBALWITHABS",
	  .val = LOONGARCH_FEATURE_HASLAGLOBALWITHABS },
	{ .str = "LOONGARCH_FEATURE_HASLAGLOBALWITHPCREL",
	  .val = LOONGARCH_FEATURE_HASLAGLOBALWITHPCREL },
	{ .str = "LOONGARCH_FEATURE_HASLALOCALWITHABS",
	  .val = LOONGARCH_FEATURE_HASLALOCALWITHABS },
	{ .str = "LOONGARCH_FEATURE_ISLA32", .val = LOONGARCH_FEATURE_ISLA32 },
	{ .str = "LOONGARCH_FEATURE_ISLA64", .val = LOONGARCH_FEATURE_ISLA64 },
	{ .str = "LOONGARCH_GRP_BRANCH_RELATIVE",
	  .val = LOONGARCH_GRP_BRANCH_RELATIVE },
	{ .str = "LOONGARCH_GRP_CALL", .val = LOONGARCH_GRP_CALL },
	{ .str = "LOONGARCH_GRP_INT", .val = LOONGARCH_GRP_INT },
	{ .str = "LOONGARCH_GRP_IRET", .val = LOONGARCH_GRP_IRET },
	{ .str = "LOONGARCH_GRP_JUMP", .val = LOONGARCH_GRP_JUMP },
	{ .str = "LOONGARCH_GRP_PRIVILEGE", .val = LOONGARCH_GRP_PRIVILEGE },
	{ .str = "LOONGARCH_GRP_RET", .val = LOONGARCH_GRP_RET },
	{ .str = "LOONGARCH_INSN_FORM_FMT1RI13_VI",
	  .val = LOONGARCH_INSN_FORM_FMT1RI13_VI },
	{ .str = "LOONGARCH_INSN_FORM_FMT1RI13_XI",
	  .val = LOONGARCH_INSN_FORM_FMT1RI13_XI },
	{ .str = "LOONGARCH_INSN_FORM_FMT1RI20",
	  .val = LOONGARCH_INSN_FORM_FMT1RI20 },
	{ .str = "LOONGARCH_INSN_FORM_FMT1RI21",
	  .val = LOONGARCH_INSN_FORM_FMT1RI21 },
	{ .str = "LOONGARCH_INSN_FORM_FMT1RI4",
	  .val = LOONGARCH_INSN_FORM_FMT1RI4 },
	{ .str = "LOONGARCH_INSN_FORM_FMT1RI5I8",
	  .val = LOONGARCH_INSN_FORM_FMT1RI5I8 },
	{ .str = "LOONGARCH_INSN_FORM_FMT1RI8",
	  .val = LOONGARCH_INSN_FORM_FMT1RI8 },
	{ .str = "LOONGARCH_INSN_FORM_FMT2R",
	  .val = LOONGARCH_INSN_FORM_FMT2R },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI10_VRI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI10_VRI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI10_XRI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI10_XRI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI11_VRI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI11_VRI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI11_XRI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI11_XRI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI12",
	  .val = LOONGARCH_INSN_FORM_FMT2RI12 },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI12_VRI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI12_VRI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI12_XRI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI12_XRI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI14",
	  .val = LOONGARCH_INSN_FORM_FMT2RI14 },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI16",
	  .val = LOONGARCH_INSN_FORM_FMT2RI16 },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI1_RVI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI1_RVI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI1_VRI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI1_VRI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI1_VVI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI1_VVI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI1_XXI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI1_XXI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI2_RVI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI2_RVI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI2_RXI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI2_RXI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI2_VRI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI2_VRI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI2_VVI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI2_VVI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI2_XRI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI2_XRI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI2_XXI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI2_XXI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI3",
	  .val = LOONGARCH_INSN_FORM_FMT2RI3 },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI3_RVI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI3_RVI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI3_RXI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI3_RXI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI3_VRI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI3_VRI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI3_VVI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI3_VVI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI3_XRI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI3_XRI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI3_XXI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI3_XXI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI4",
	  .val = LOONGARCH_INSN_FORM_FMT2RI4 },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI4_RVI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI4_RVI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI4_VRI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI4_VRI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI4_VVI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI4_VVI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI4_XXI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI4_XXI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI5",
	  .val = LOONGARCH_INSN_FORM_FMT2RI5 },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI5_VVI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI5_VVI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI5_XXI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI5_XXI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI6",
	  .val = LOONGARCH_INSN_FORM_FMT2RI6 },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI6_VVI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI6_VVI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI6_XXI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI6_XXI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI7_VVI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI7_VVI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI7_XXI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI7_XXI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI8",
	  .val = LOONGARCH_INSN_FORM_FMT2RI8 },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI8I1_VRII",
	  .val = LOONGARCH_INSN_FORM_FMT2RI8I1_VRII },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI8I2_VRII",
	  .val = LOONGARCH_INSN_FORM_FMT2RI8I2_VRII },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI8I2_XRII",
	  .val = LOONGARCH_INSN_FORM_FMT2RI8I2_XRII },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI8I3_VRII",
	  .val = LOONGARCH_INSN_FORM_FMT2RI8I3_VRII },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI8I3_XRII",
	  .val = LOONGARCH_INSN_FORM_FMT2RI8I3_XRII },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI8I4_VRII",
	  .val = LOONGARCH_INSN_FORM_FMT2RI8I4_VRII },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI8I4_XRII",
	  .val = LOONGARCH_INSN_FORM_FMT2RI8I4_XRII },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI8I5_XRII",
	  .val = LOONGARCH_INSN_FORM_FMT2RI8I5_XRII },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI8_VVI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI8_VVI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI8_XXI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI8_XXI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI9_VRI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI9_VRI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2RI9_XRI",
	  .val = LOONGARCH_INSN_FORM_FMT2RI9_XRI },
	{ .str = "LOONGARCH_INSN_FORM_FMT2R_CV",
	  .val = LOONGARCH_INSN_FORM_FMT2R_CV },
	{ .str = "LOONGARCH_INSN_FORM_FMT2R_CX",
	  .val = LOONGARCH_INSN_FORM_FMT2R_CX },
	{ .str = "LOONGARCH_INSN_FORM_FMT2R_VR",
	  .val = LOONGARCH_INSN_FORM_FMT2R_VR },
	{ .str = "LOONGARCH_INSN_FORM_FMT2R_VV",
	  .val = LOONGARCH_INSN_FORM_FMT2R_VV },
	{ .str = "LOONGARCH_INSN_FORM_FMT2R_XR",
	  .val = LOONGARCH_INSN_FORM_FMT2R_XR },
	{ .str = "LOONGARCH_INSN_FORM_FMT2R_XX",
	  .val = LOONGARCH_INSN_FORM_FMT2R_XX },
	{ .str = "LOONGARCH_INSN_FORM_FMT3R",
	  .val = LOONGARCH_INSN_FORM_FMT3R },
	{ .str = "LOONGARCH_INSN_FORM_FMT3RI2",
	  .val = LOONGARCH_INSN_FORM_FMT3RI2 },
	{ .str = "LOONGARCH_INSN_FORM_FMT3RI3",
	  .val = LOONGARCH_INSN_FORM_FMT3RI3 },
	{ .str = "LOONGARCH_INSN_FORM_FMT3R_VRR",
	  .val = LOONGARCH_INSN_FORM_FMT3R_VRR },
	{ .str = "LOONGARCH_INSN_FORM_FMT3R_VVR",
	  .val = LOONGARCH_INSN_FORM_FMT3R_VVR },
	{ .str = "LOONGARCH_INSN_FORM_FMT3R_VVV",
	  .val = LOONGARCH_INSN_FORM_FMT3R_VVV },
	{ .str = "LOONGARCH_INSN_FORM_FMT3R_XRR",
	  .val = LOONGARCH_INSN_FORM_FMT3R_XRR },
	{ .str = "LOONGARCH_INSN_FORM_FMT3R_XXR",
	  .val = LOONGARCH_INSN_FORM_FMT3R_XXR },
	{ .str = "LOONGARCH_INSN_FORM_FMT3R_XXX",
	  .val = LOONGARCH_INSN_FORM_FMT3R_XXX },
	{ .str = "LOONGARCH_INSN_FORM_FMT4R_VVVV",
	  .val = LOONGARCH_INSN_FORM_FMT4R_VVVV },
	{ .str = "LOONGARCH_INSN_FORM_FMT4R_XXXX",
	  .val = LOONGARCH_INSN_FORM_FMT4R_XXXX },
	{ .str = "LOONGARCH_INSN_FORM_FMTASRT",
	  .val = LOONGARCH_INSN_FORM_FMTASRT },
	{ .str = "LOONGARCH_INSN_FORM_FMTBSTR_D",
	  .val = LOONGARCH_INSN_FORM_FMTBSTR_D },
	{ .str = "LOONGARCH_INSN_FORM_FMTBSTR_W",
	  .val = LOONGARCH_INSN_FORM_FMTBSTR_W },
	{ .str = "LOONGARCH_INSN_FORM_FMTCACOP",
	  .val = LOONGARCH_INSN_FORM_FMTCACOP },
	{ .str = "LOONGARCH_INSN_FORM_FMTCSR",
	  .val = LOONGARCH_INSN_FORM_FMTCSR },
	{ .str = "LOONGARCH_INSN_FORM_FMTCSRXCHG",
	  .val = LOONGARCH_INSN_FORM_FMTCSRXCHG },
	{ .str = "LOONGARCH_INSN_FORM_FMTGR2SCR",
	  .val = LOONGARCH_INSN_FORM_FMTGR2SCR },
	{ .str = "LOONGARCH_INSN_FORM_FMTI15",
	  .val = LOONGARCH_INSN_FORM_FMTI15 },
	{ .str = "LOONGARCH_INSN_FORM_FMTI26",
	  .val = LOONGARCH_INSN_FORM_FMTI26 },
	{ .str = "LOONGARCH_INSN_FORM_FMTI32",
	  .val = LOONGARCH_INSN_FORM_FMTI32 },
	{ .str = "LOONGARCH_INSN_FORM_FMTINVTLB",
	  .val = LOONGARCH_INSN_FORM_FMTINVTLB },
	{ .str = "LOONGARCH_INSN_FORM_FMTJISCR",
	  .val = LOONGARCH_INSN_FORM_FMTJISCR },
	{ .str = "LOONGARCH_INSN_FORM_FMTLDPTE",
	  .val = LOONGARCH_INSN_FORM_FMTLDPTE },
	{ .str = "LOONGARCH_INSN_FORM_FMTMFTOP",
	  .val = LOONGARCH_INSN_FORM_FMTMFTOP },
	{ .str = "LOONGARCH_INSN_FORM_FMTMTTOP",
	  .val = LOONGARCH_INSN_FORM_FMTMTTOP },
	{ .str = "LOONGARCH_INSN_FORM_FMTPRELD",
	  .val = LOONGARCH_INSN_FORM_FMTPRELD },
	{ .str = "LOONGARCH_INSN_FORM_FMTPRELDX",
	  .val = LOONGARCH_INSN_FORM_FMTPRELDX },
	{ .str = "LOONGARCH_INSN_FORM_FMTSCR2GR",
	  .val = LOONGARCH_INSN_FORM_FMTSCR2GR },
	{ .str = "LOONGARCH_INSN_FORM_FPFMT2R",
	  .val = LOONGARCH_INSN_FORM_FPFMT2R },
	{ .str = "LOONGARCH_INSN_FORM_FPFMT2RI12",
	  .val = LOONGARCH_INSN_FORM_FPFMT2RI12 },
	{ .str = "LOONGARCH_INSN_FORM_FPFMT3R",
	  .val = LOONGARCH_INSN_FORM_FPFMT3R },
	{ .str = "LOONGARCH_INSN_FORM_FPFMT4R",
	  .val = LOONGARCH_INSN_FORM_FPFMT4R },
	{ .str = "LOONGARCH_INSN_FORM_FPFMTBR",
	  .val = LOONGARCH_INSN_FORM_FPFMTBR },
	{ .str = "LOONGARCH_INSN_FORM_FPFMTFCMP",
	  .val = LOONGARCH_INSN_FORM_FPFMTFCMP },
	{ .str = "LOONGARCH_INSN_FORM_FPFMTFSEL",
	  .val = LOONGARCH_INSN_FORM_FPFMTFSEL },
	{ .str = "LOONGARCH_INSN_FORM_FPFMTMEM",
	  .val = LOONGARCH_INSN_FORM_FPFMTMEM },
	{ .str = "LOONGARCH_INSN_FORM_FPFMTMOV",
	  .val = LOONGARCH_INSN_FORM_FPFMTMOV },
	{ .str = "LOONGARCH_INSN_FORM_NODSTFMT1R",
	  .val = LOONGARCH_INSN_FORM_NODSTFMT1R },
	{ .str = "LOONGARCH_INSN_FORM_NODSTFMT1RI3",
	  .val = LOONGARCH_INSN_FORM_NODSTFMT1RI3 },
	{ .str = "LOONGARCH_INSN_FORM_NODSTFMT1RI4",
	  .val = LOONGARCH_INSN_FORM_NODSTFMT1RI4 },
	{ .str = "LOONGARCH_INSN_FORM_NODSTFMT1RI5",
	  .val = LOONGARCH_INSN_FORM_NODSTFMT1RI5 },
	{ .str = "LOONGARCH_INSN_FORM_NODSTFMT1RI5I4",
	  .val = LOONGARCH_INSN_FORM_NODSTFMT1RI5I4 },
	{ .str = "LOONGARCH_INSN_FORM_NODSTFMT1RI6",
	  .val = LOONGARCH_INSN_FORM_NODSTFMT1RI6 },
	{ .str = "LOONGARCH_INSN_FORM_NODSTFMT2R",
	  .val = LOONGARCH_INSN_FORM_NODSTFMT2R },
	{ .str = "LOONGARCH_INSN_FORM_NODSTFMT2RI4",
	  .val = LOONGARCH_INSN_FORM_NODSTFMT2RI4 },
	{ .str = "LOONGARCH_INSN_FORM_PSEUDO",
	  .val = LOONGARCH_INSN_FORM_PSEUDO },
	{ .str = "LOONGARCH_OP_IMM", .val = LOONGARCH_OP_IMM },
	{ .str = "LOONGARCH_OP_MEM", .val = LOONGARCH_OP_MEM },
	{ .str = "LOONGARCH_OP_REG", .val = LOONGARCH_OP_REG },
	{ .str = "M680X_FIRST_OP_IN_MNEM", .val = M680X_FIRST_OP_IN_MNEM },
	{ .str = "M680X_GRP_BRAREL", .val = M680X_GRP_BRAREL },
	{ .str = "M680X_GRP_CALL", .val = M680X_GRP_CALL },
	{ .str = "M680X_GRP_INT", .val = M680X_GRP_INT },
	{ .str = "M680X_GRP_IRET", .val = M680X_GRP_IRET },
	{ .str = "M680X_GRP_JUMP", .val = M680X_GRP_JUMP },
	{ .str = "M680X_GRP_PRIV", .val = M680X_GRP_PRIV },
	{ .str = "M680X_GRP_RET", .val = M680X_GRP_RET },
	{ .str = "M680X_IDX_INDIRECT", .val = M680X_IDX_INDIRECT },
	{ .str = "M680X_IDX_NO_COMMA", .val = M680X_IDX_NO_COMMA },
	{ .str = "M680X_IDX_POST_INC_DEC", .val = M680X_IDX_POST_INC_DEC },
	{ .str = "M680X_OFFSET_BITS_16", .val = M680X_OFFSET_BITS_16 },
	{ .str = "M680X_OFFSET_BITS_5", .val = M680X_OFFSET_BITS_5 },
	{ .str = "M680X_OFFSET_BITS_8", .val = M680X_OFFSET_BITS_8 },
	{ .str = "M680X_OFFSET_BITS_9", .val = M680X_OFFSET_BITS_9 },
	{ .str = "M680X_OFFSET_NONE", .val = M680X_OFFSET_NONE },
	{ .str = "M680X_OP_CONSTANT", .val = M680X_OP_CONSTANT },
	{ .str = "M680X_OP_DIRECT", .val = M680X_OP_DIRECT },
	{ .str = "M680X_OP_EXTENDED", .val = M680X_OP_EXTENDED },
	{ .str = "M680X_OP_IMMEDIATE", .val = M680X_OP_IMMEDIATE },
	{ .str = "M680X_OP_INDEXED", .val = M680X_OP_INDEXED },
	{ .str = "M680X_OP_REGISTER", .val = M680X_OP_REGISTER },
	{ .str = "M680X_OP_RELATIVE", .val = M680X_OP_RELATIVE },
	{ .str = "M680X_SECOND_OP_IN_MNEM", .val = M680X_SECOND_OP_IN_MNEM },
	{ .str = "M68K_AM_ABSOLUTE_DATA_LONG",
	  .val = M68K_AM_ABSOLUTE_DATA_LONG },
	{ .str = "M68K_AM_ABSOLUTE_DATA_SHORT",
	  .val = M68K_AM_ABSOLUTE_DATA_SHORT },
	{ .str = "M68K_AM_AREGI_INDEX_8_BIT_DISP",
	  .val = M68K_AM_AREGI_INDEX_8_BIT_DISP },
	{ .str = "M68K_AM_AREGI_INDEX_BASE_DISP",
	  .val = M68K_AM_AREGI_INDEX_BASE_DISP },
	{ .str = "M68K_AM_BRANCH_DISPLACEMENT",
	  .val = M68K_AM_BRANCH_DISPLACEMENT },
	{ .str = "M68K_AM_IMMEDIATE", .val = M68K_AM_IMMEDIATE },
	{ .str = "M68K_AM_MEMI_POST_INDEX", .val = M68K_AM_MEMI_POST_INDEX },
	{ .str = "M68K_AM_MEMI_PRE_INDEX", .val = M68K_AM_MEMI_PRE_INDEX },
	{ .str = "M68K_AM_NONE", .val = M68K_AM_NONE },
	{ .str = "M68K_AM_PCI_DISP", .val = M68K_AM_PCI_DISP },
	{ .str = "M68K_AM_PCI_INDEX_8_BIT_DISP",
	  .val = M68K_AM_PCI_INDEX_8_BIT_DISP },
	{ .str = "M68K_AM_PCI_INDEX_BASE_DISP",
	  .val = M68K_AM_PCI_INDEX_BASE_DISP },
	{ .str = "M68K_AM_PC_MEMI_POST_INDEX",
	  .val = M68K_AM_PC_MEMI_POST_INDEX },
	{ .str = "M68K_AM_PC_MEMI_PRE_INDEX",
	  .val = M68K_AM_PC_MEMI_PRE_INDEX },
	{ .str = "M68K_AM_REGI_ADDR", .val = M68K_AM_REGI_ADDR },
	{ .str = "M68K_AM_REGI_ADDR_DISP", .val = M68K_AM_REGI_ADDR_DISP },
	{ .str = "M68K_AM_REGI_ADDR_POST_INC",
	  .val = M68K_AM_REGI_ADDR_POST_INC },
	{ .str = "M68K_AM_REGI_ADDR_PRE_DEC",
	  .val = M68K_AM_REGI_ADDR_PRE_DEC },
	{ .str = "M68K_AM_REG_DIRECT_ADDR", .val = M68K_AM_REG_DIRECT_ADDR },
	{ .str = "M68K_AM_REG_DIRECT_DATA", .val = M68K_AM_REG_DIRECT_DATA },
	{ .str = "M68K_CPU_SIZE_BYTE", .val = M68K_CPU_SIZE_BYTE },
	{ .str = "M68K_CPU_SIZE_LONG", .val = M68K_CPU_SIZE_LONG },
	{ .str = "M68K_CPU_SIZE_NONE", .val = M68K_CPU_SIZE_NONE },
	{ .str = "M68K_CPU_SIZE_WORD", .val = M68K_CPU_SIZE_WORD },
	{ .str = "M68K_FPU_SIZE_DOUBLE", .val = M68K_FPU_SIZE_DOUBLE },
	{ .str = "M68K_FPU_SIZE_EXTENDED", .val = M68K_FPU_SIZE_EXTENDED },
	{ .str = "M68K_FPU_SIZE_NONE", .val = M68K_FPU_SIZE_NONE },
	{ .str = "M68K_FPU_SIZE_SINGLE", .val = M68K_FPU_SIZE_SINGLE },
	{ .str = "M68K_GRP_BRANCH_RELATIVE", .val = M68K_GRP_BRANCH_RELATIVE },
	{ .str = "M68K_GRP_IRET", .val = M68K_GRP_IRET },
	{ .str = "M68K_GRP_JUMP", .val = M68K_GRP_JUMP },
	{ .str = "M68K_GRP_RET", .val = M68K_GRP_RET },
	{ .str = "M68K_OP_BR_DISP", .val = M68K_OP_BR_DISP },
	{ .str = "M68K_OP_BR_DISP_SIZE_BYTE",
	  .val = M68K_OP_BR_DISP_SIZE_BYTE },
	{ .str = "M68K_OP_BR_DISP_SIZE_LONG",
	  .val = M68K_OP_BR_DISP_SIZE_LONG },
	{ .str = "M68K_OP_BR_DISP_SIZE_WORD",
	  .val = M68K_OP_BR_DISP_SIZE_WORD },
	{ .str = "M68K_OP_FP_DOUBLE", .val = M68K_OP_FP_DOUBLE },
	{ .str = "M68K_OP_FP_SINGLE", .val = M68K_OP_FP_SINGLE },
	{ .str = "M68K_OP_IMM", .val = M68K_OP_IMM },
	{ .str = "M68K_OP_MEM", .val = M68K_OP_MEM },
	{ .str = "M68K_OP_REG", .val = M68K_OP_REG },
	{ .str = "M68K_OP_REG_BITS", .val = M68K_OP_REG_BITS },
	{ .str = "M68K_OP_REG_PAIR", .val = M68K_OP_REG_PAIR },
	{ .str = "M68K_SIZE_TYPE_CPU", .val = M68K_SIZE_TYPE_CPU },
	{ .str = "M68K_SIZE_TYPE_FPU", .val = M68K_SIZE_TYPE_FPU },
	{ .str = "MIPS_INS_ADDIU", .val = MIPS_INS_ADDIU },
	{ .str = "MIPS_INS_ADDIUPC", .val = MIPS_INS_ADDIUPC },
	{ .str = "MIPS_INS_ALIAS_B", .val = MIPS_INS_ALIAS_B },
	{ .str = "MIPS_INS_ALIAS_BEQZ", .val = MIPS_INS_ALIAS_BEQZ },
	{ .str = "MIPS_INS_ALIAS_LAPC", .val = MIPS_INS_ALIAS_LAPC },
	{ .str = "MIPS_INS_ALIAS_LI", .val = MIPS_INS_ALIAS_LI },
	{ .str = "MIPS_INS_ALIAS_NEGU", .val = MIPS_INS_ALIAS_NEGU },
	{ .str = "MIPS_INS_BEQ", .val = MIPS_INS_BEQ },
	{ .str = "MIPS_INS_SUBU", .val = MIPS_INS_SUBU },
	{ .str = "MIPS_OP_IMM", .val = MIPS_OP_IMM },
	{ .str = "MIPS_OP_MEM", .val = MIPS_OP_MEM },
	{ .str = "MIPS_OP_REG", .val = MIPS_OP_REG },
	{ .str = "MOS65XX_AM_ABS", .val = MOS65XX_AM_ABS },
	{ .str = "MOS65XX_AM_ABS_IND", .val = MOS65XX_AM_ABS_IND },
	{ .str = "MOS65XX_AM_ABS_IND_LONG", .val = MOS65XX_AM_ABS_IND_LONG },
	{ .str = "MOS65XX_AM_ABS_LONG", .val = MOS65XX_AM_ABS_LONG },
	{ .str = "MOS65XX_AM_ABS_LONG_X", .val = MOS65XX_AM_ABS_LONG_X },
	{ .str = "MOS65XX_AM_ABS_X", .val = MOS65XX_AM_ABS_X },
	{ .str = "MOS65XX_AM_ABS_X_IND", .val = MOS65XX_AM_ABS_X_IND },
	{ .str = "MOS65XX_AM_ABS_Y", .val = MOS65XX_AM_ABS_Y },
	{ .str = "MOS65XX_AM_ACC", .val = MOS65XX_AM_ACC },
	{ .str = "MOS65XX_AM_BLOCK", .val = MOS65XX_AM_BLOCK },
	{ .str = "MOS65XX_AM_IMM", .val = MOS65XX_AM_IMM },
	{ .str = "MOS65XX_AM_IMP", .val = MOS65XX_AM_IMP },
	{ .str = "MOS65XX_AM_INT", .val = MOS65XX_AM_INT },
	{ .str = "MOS65XX_AM_REL", .val = MOS65XX_AM_REL },
	{ .str = "MOS65XX_AM_SR", .val = MOS65XX_AM_SR },
	{ .str = "MOS65XX_AM_SR_IND_Y", .val = MOS65XX_AM_SR_IND_Y },
	{ .str = "MOS65XX_AM_ZP", .val = MOS65XX_AM_ZP },
	{ .str = "MOS65XX_AM_ZP_IND", .val = MOS65XX_AM_ZP_IND },
	{ .str = "MOS65XX_AM_ZP_IND_LONG", .val = MOS65XX_AM_ZP_IND_LONG },
	{ .str = "MOS65XX_AM_ZP_IND_LONG_Y", .val = MOS65XX_AM_ZP_IND_LONG_Y },
	{ .str = "MOS65XX_AM_ZP_IND_Y", .val = MOS65XX_AM_ZP_IND_Y },
	{ .str = "MOS65XX_AM_ZP_REL", .val = MOS65XX_AM_ZP_REL },
	{ .str = "MOS65XX_AM_ZP_X", .val = MOS65XX_AM_ZP_X },
	{ .str = "MOS65XX_AM_ZP_X_IND", .val = MOS65XX_AM_ZP_X_IND },
	{ .str = "MOS65XX_AM_ZP_Y", .val = MOS65XX_AM_ZP_Y },
	{ .str = "MOS65XX_GRP_BRANCH_RELATIVE",
	  .val = MOS65XX_GRP_BRANCH_RELATIVE },
	{ .str = "MOS65XX_GRP_CALL", .val = MOS65XX_GRP_CALL },
	{ .str = "MOS65XX_GRP_INT", .val = MOS65XX_GRP_INT },
	{ .str = "MOS65XX_GRP_IRET", .val = MOS65XX_GRP_IRET },
	{ .str = "MOS65XX_GRP_JUMP", .val = MOS65XX_GRP_JUMP },
	{ .str = "MOS65XX_GRP_RET", .val = MOS65XX_GRP_RET },
	{ .str = "MOS65XX_OP_IMM", .val = MOS65XX_OP_IMM },
	{ .str = "MOS65XX_OP_MEM", .val = MOS65XX_OP_MEM },
	{ .str = "MOS65XX_OP_REG", .val = MOS65XX_OP_REG },
	{ .str = "PPC_BH_INVALID", .val = PPC_BH_INVALID },
	{ .str = "PPC_BH_NOT_PREDICTABLE", .val = PPC_BH_NOT_PREDICTABLE },
	{ .str = "PPC_BH_NO_SUBROUTINE_RET", .val = PPC_BH_NO_SUBROUTINE_RET },
	{ .str = "PPC_BH_RESERVED", .val = PPC_BH_RESERVED },
	{ .str = "PPC_BH_SUBROUTINE_RET", .val = PPC_BH_SUBROUTINE_RET },
	{ .str = "PPC_BI_GT", .val = PPC_BI_GT },
	{ .str = "PPC_BI_LT", .val = PPC_BI_LT },
	{ .str = "PPC_BI_SO", .val = PPC_BI_SO },
	{ .str = "PPC_BI_Z", .val = PPC_BI_Z },
	{ .str = "PPC_BO_CR_CMP", .val = PPC_BO_CR_CMP },
	{ .str = "PPC_BO_CTR_CMP", .val = PPC_BO_CTR_CMP },
	{ .str = "PPC_BO_DECR_CTR", .val = PPC_BO_DECR_CTR },
	{ .str = "PPC_BO_T", .val = PPC_BO_T },
	{ .str = "PPC_BO_TEST_CR", .val = PPC_BO_TEST_CR },
	{ .str = "PPC_BR_HINT_MASK", .val = PPC_BR_HINT_MASK },
	{ .str = "PPC_BR_NOT_GIVEN", .val = PPC_BR_NOT_GIVEN },
	{ .str = "PPC_BR_NOT_TAKEN", .val = PPC_BR_NOT_TAKEN },
	{ .str = "PPC_BR_RESERVED", .val = PPC_BR_RESERVED },
	{ .str = "PPC_BR_TAKEN", .val = PPC_BR_TAKEN },
	{ .str = "PPC_FEATURE_HASBPERMD", .val = PPC_FEATURE_HASBPERMD },
	{ .str = "PPC_FEATURE_HASEXTDIV", .val = PPC_FEATURE_HASEXTDIV },
	{ .str = "PPC_FEATURE_HASFPU", .val = PPC_FEATURE_HASFPU },
	{ .str = "PPC_FEATURE_HASICBT", .val = PPC_FEATURE_HASICBT },
	{ .str = "PPC_FEATURE_HASONLYMSYNC", .val = PPC_FEATURE_HASONLYMSYNC },
	{ .str = "PPC_FEATURE_HASPARTWORDATOMICS",
	  .val = PPC_FEATURE_HASPARTWORDATOMICS },
	{ .str = "PPC_FEATURE_HASPS", .val = PPC_FEATURE_HASPS },
	{ .str = "PPC_FEATURE_HASQPX", .val = PPC_FEATURE_HASQPX },
	{ .str = "PPC_FEATURE_HASQUADWORDATOMICS",
	  .val = PPC_FEATURE_HASQUADWORDATOMICS },
	{ .str = "PPC_FEATURE_HASSPE", .val = PPC_FEATURE_HASSPE },
	{ .str = "PPC_FEATURE_HASSYNC", .val = PPC_FEATURE_HASSYNC },
	{ .str = "PPC_FEATURE_IN32BITMODE", .val = PPC_FEATURE_IN32BITMODE },
	{ .str = "PPC_FEATURE_IN64BITMODE", .val = PPC_FEATURE_IN64BITMODE },
	{ .str = "PPC_FEATURE_ISAIX", .val = PPC_FEATURE_ISAIX },
	{ .str = "PPC_FEATURE_ISBOOKE", .val = PPC_FEATURE_ISBOOKE },
	{ .str = "PPC_FEATURE_ISE500", .val = PPC_FEATURE_ISE500 },
	{ .str = "PPC_FEATURE_ISISA2_06", .val = PPC_FEATURE_ISISA2_06 },
	{ .str = "PPC_FEATURE_ISISA2_07", .val = PPC_FEATURE_ISISA2_07 },
	{ .str = "PPC_FEATURE_ISISA3_0", .val = PPC_FEATURE_ISISA3_0 },
	{ .str = "PPC_FEATURE_ISISAFUTURE", .val = PPC_FEATURE_ISISAFUTURE },
	{ .str = "PPC_FEATURE_ISNOTBOOKE", .val = PPC_FEATURE_ISNOTBOOKE },
	{ .str = "PPC_FEATURE_ISNOTISA3_1", .val = PPC_FEATURE_ISNOTISA3_1 },
	{ .str = "PPC_FEATURE_ISNOTISAFUTURE",
	  .val = PPC_FEATURE_ISNOTISAFUTURE },
	{ .str = "PPC_FEATURE_ISPPC4XX", .val = PPC_FEATURE_ISPPC4XX },
	{ .str = "PPC_FEATURE_ISPPC6XX", .val = PPC_FEATURE_ISPPC6XX },
	{ .str = "PPC_FEATURE_MODERNAS", .val = PPC_FEATURE_MODERNAS },
	{ .str = "PPC_FEATURE_NANSFPMATH", .val = PPC_FEATURE_NANSFPMATH },
	{ .str = "PPC_FEATURE_NONANSFPMATH", .val = PPC_FEATURE_NONANSFPMATH },
	{ .str = "PPC_FEATURE_NOTAIX", .val = PPC_FEATURE_NOTAIX },
	{ .str = "PPC_FEATURE_PCRELATIVEMEMOPS",
	  .val = PPC_FEATURE_PCRELATIVEMEMOPS },
	{ .str = "PPC_GRP_BRANCH_RELATIVE", .val = PPC_GRP_BRANCH_RELATIVE },
	{ .str = "PPC_GRP_CALL", .val = PPC_GRP_CALL },
	{ .str = "PPC_GRP_INT", .val = PPC_GRP_INT },
	{ .str = "PPC_GRP_IRET", .val = PPC_GRP_IRET },
	{ .str = "PPC_GRP_JUMP", .val = PPC_GRP_JUMP },
	{ .str = "PPC_GRP_PRIVILEGE", .val = PPC_GRP_PRIVILEGE },
	{ .str = "PPC_GRP_RET", .val = PPC_GRP_RET },
	{ .str = "PPC_INSN_FORM_AFORM_1", .val = PPC_INSN_FORM_AFORM_1 },
	{ .str = "PPC_INSN_FORM_AFORM_4", .val = PPC_INSN_FORM_AFORM_4 },
	{ .str = "PPC_INSN_FORM_BFORM_3", .val = PPC_INSN_FORM_BFORM_3 },
	{ .str = "PPC_INSN_FORM_BFORM_3_AT", .val = PPC_INSN_FORM_BFORM_3_AT },
	{ .str = "PPC_INSN_FORM_DCBZL_FORM", .val = PPC_INSN_FORM_DCBZL_FORM },
	{ .str = "PPC_INSN_FORM_DCB_FORM", .val = PPC_INSN_FORM_DCB_FORM },
	{ .str = "PPC_INSN_FORM_DCB_FORM_HINT",
	  .val = PPC_INSN_FORM_DCB_FORM_HINT },
	{ .str = "PPC_INSN_FORM_DFORM_2_R0", .val = PPC_INSN_FORM_DFORM_2_R0 },
	{ .str = "PPC_INSN_FORM_DFORM_4", .val = PPC_INSN_FORM_DFORM_4 },
	{ .str = "PPC_INSN_FORM_DFORM_5", .val = PPC_INSN_FORM_DFORM_5 },
	{ .str = "PPC_INSN_FORM_DFORM_BASE", .val = PPC_INSN_FORM_DFORM_BASE },
	{ .str = "PPC_INSN_FORM_DQFORM_RTP5_RA17_MEM",
	  .val = PPC_INSN_FORM_DQFORM_RTP5_RA17_MEM },
	{ .str = "PPC_INSN_FORM_DQFORM_XTP5_RA17_MEM",
	  .val = PPC_INSN_FORM_DQFORM_XTP5_RA17_MEM },
	{ .str = "PPC_INSN_FORM_DQ_RD6_RS5_DQ12",
	  .val = PPC_INSN_FORM_DQ_RD6_RS5_DQ12 },
	{ .str = "PPC_INSN_FORM_DSFORM_1", .val = PPC_INSN_FORM_DSFORM_1 },
	{ .str = "PPC_INSN_FORM_DSS_FORM", .val = PPC_INSN_FORM_DSS_FORM },
	{ .str = "PPC_INSN_FORM_DXFORM", .val = PPC_INSN_FORM_DXFORM },
	{ .str = "PPC_INSN_FORM_EFXFORM_1", .val = PPC_INSN_FORM_EFXFORM_1 },
	{ .str = "PPC_INSN_FORM_EFXFORM_3", .val = PPC_INSN_FORM_EFXFORM_3 },
	{ .str = "PPC_INSN_FORM_EVXFORM_1", .val = PPC_INSN_FORM_EVXFORM_1 },
	{ .str = "PPC_INSN_FORM_EVXFORM_3", .val = PPC_INSN_FORM_EVXFORM_3 },
	{ .str = "PPC_INSN_FORM_EVXFORM_4", .val = PPC_INSN_FORM_EVXFORM_4 },
	{ .str = "PPC_INSN_FORM_EVXFORM_D", .val = PPC_INSN_FORM_EVXFORM_D },
	{ .str = "PPC_INSN_FORM_IFORM", .val = PPC_INSN_FORM_IFORM },
	{ .str = "PPC_INSN_FORM_MDFORM_1", .val = PPC_INSN_FORM_MDFORM_1 },
	{ .str = "PPC_INSN_FORM_MDSFORM_1", .val = PPC_INSN_FORM_MDSFORM_1 },
	{ .str = "PPC_INSN_FORM_MFORM_1", .val = PPC_INSN_FORM_MFORM_1 },
	{ .str = "PPC_INSN_FORM_MFORM_2", .val = PPC_INSN_FORM_MFORM_2 },
	{ .str = "PPC_INSN_FORM_PSFORM_C", .val = PPC_INSN_FORM_PSFORM_C },
	{ .str = "PPC_INSN_FORM_PSFORM_QD", .val = PPC_INSN_FORM_PSFORM_QD },
	{ .str = "PPC_INSN_FORM_PSFORM_QI", .val = PPC_INSN_FORM_PSFORM_QI },
	{ .str = "PPC_INSN_FORM_PSFORM_X", .val = PPC_INSN_FORM_PSFORM_X },
	{ .str = "PPC_INSN_FORM_PSFORM_Y", .val = PPC_INSN_FORM_PSFORM_Y },
	{ .str = "PPC_INSN_FORM_REQUIRES", .val = PPC_INSN_FORM_REQUIRES },
	{ .str = "PPC_INSN_FORM_SCFORM", .val = PPC_INSN_FORM_SCFORM },
	{ .str = "PPC_INSN_FORM_VAFORM_1", .val = PPC_INSN_FORM_VAFORM_1 },
	{ .str = "PPC_INSN_FORM_VAFORM_1A", .val = PPC_INSN_FORM_VAFORM_1A },
	{ .str = "PPC_INSN_FORM_VAFORM_2", .val = PPC_INSN_FORM_VAFORM_2 },
	{ .str = "PPC_INSN_FORM_VNFORM_VTAB5_SD3",
	  .val = PPC_INSN_FORM_VNFORM_VTAB5_SD3 },
	{ .str = "PPC_INSN_FORM_VXFORM_1", .val = PPC_INSN_FORM_VXFORM_1 },
	{ .str = "PPC_INSN_FORM_VXFORM_2", .val = PPC_INSN_FORM_VXFORM_2 },
	{ .str = "PPC_INSN_FORM_VXFORM_3", .val = PPC_INSN_FORM_VXFORM_3 },
	{ .str = "PPC_INSN_FORM_VXFORM_4", .val = PPC_INSN_FORM_VXFORM_4 },
	{ .str = "PPC_INSN_FORM_VXFORM_5", .val = PPC_INSN_FORM_VXFORM_5 },
	{ .str = "PPC_INSN_FORM_VXFORM_BF3_VAB5",
	  .val = PPC_INSN_FORM_VXFORM_BF3_VAB5 },
	{ .str = "PPC_INSN_FORM_VXFORM_BX", .val = PPC_INSN_FORM_VXFORM_BX },
	{ .str = "PPC_INSN_FORM_VXFORM_CR", .val = PPC_INSN_FORM_VXFORM_CR },
	{ .str = "PPC_INSN_FORM_VXFORM_RD5_MP_VB5",
	  .val = PPC_INSN_FORM_VXFORM_RD5_MP_VB5 },
	{ .str = "PPC_INSN_FORM_VXFORM_RD5_N3_VB5",
	  .val = PPC_INSN_FORM_VXFORM_RD5_N3_VB5 },
	{ .str = "PPC_INSN_FORM_VXFORM_RD5_XO5_RS5",
	  .val = PPC_INSN_FORM_VXFORM_RD5_XO5_RS5 },
	{ .str = "PPC_INSN_FORM_VXFORM_VTB5_RC",
	  .val = PPC_INSN_FORM_VXFORM_VTB5_RC },
	{ .str = "PPC_INSN_FORM_VXRFORM_1", .val = PPC_INSN_FORM_VXRFORM_1 },
	{ .str = "PPC_INSN_FORM_VX_RD5_EO5_RS5_PS1_XO9",
	  .val = PPC_INSN_FORM_VX_RD5_EO5_RS5_PS1_XO9 },
	{ .str = "PPC_INSN_FORM_VX_RD5_RSP5_PS1_XO9",
	  .val = PPC_INSN_FORM_VX_RD5_RSP5_PS1_XO9 },
	{ .str = "PPC_INSN_FORM_XFLFORM_1", .val = PPC_INSN_FORM_XFLFORM_1 },
	{ .str = "PPC_INSN_FORM_XFORMMEMOP", .val = PPC_INSN_FORM_XFORMMEMOP },
	{ .str = "PPC_INSN_FORM_XFORM_16", .val = PPC_INSN_FORM_XFORM_16 },
	{ .str = "PPC_INSN_FORM_XFORM_17", .val = PPC_INSN_FORM_XFORM_17 },
	{ .str = "PPC_INSN_FORM_XFORM_18", .val = PPC_INSN_FORM_XFORM_18 },
	{ .str = "PPC_INSN_FORM_XFORM_20", .val = PPC_INSN_FORM_XFORM_20 },
	{ .str = "PPC_INSN_FORM_XFORM_24", .val = PPC_INSN_FORM_XFORM_24 },
	{ .str = "PPC_INSN_FORM_XFORM_24_SYNC",
	  .val = PPC_INSN_FORM_XFORM_24_SYNC },
	{ .str = "PPC_INSN_FORM_XFORM_44", .val = PPC_INSN_FORM_XFORM_44 },
	{ .str = "PPC_INSN_FORM_XFORM_45", .val = PPC_INSN_FORM_XFORM_45 },
	{ .str = "PPC_INSN_FORM_XFORM_AT3", .val = PPC_INSN_FORM_XFORM_AT3 },
	{ .str = "PPC_INSN_FORM_XFORM_ATB3", .val = PPC_INSN_FORM_XFORM_ATB3 },
	{ .str = "PPC_INSN_FORM_XFORM_ATTN", .val = PPC_INSN_FORM_XFORM_ATTN },
	{ .str = "PPC_INSN_FORM_XFORM_BASE_R3XO",
	  .val = PPC_INSN_FORM_XFORM_BASE_R3XO },
	{ .str = "PPC_INSN_FORM_XFORM_BASE_R3XO_SWAPPED",
	  .val = PPC_INSN_FORM_XFORM_BASE_R3XO_SWAPPED },
	{ .str = "PPC_INSN_FORM_XFORM_BF3_UIM6_FRB5",
	  .val = PPC_INSN_FORM_XFORM_BF3_UIM6_FRB5 },
	{ .str = "PPC_INSN_FORM_XFORM_HTM0", .val = PPC_INSN_FORM_XFORM_HTM0 },
	{ .str = "PPC_INSN_FORM_XFORM_HTM1", .val = PPC_INSN_FORM_XFORM_HTM1 },
	{ .str = "PPC_INSN_FORM_XFORM_HTM2", .val = PPC_INSN_FORM_XFORM_HTM2 },
	{ .str = "PPC_INSN_FORM_XFORM_HTM3", .val = PPC_INSN_FORM_XFORM_HTM3 },
	{ .str = "PPC_INSN_FORM_XFORM_ICBT", .val = PPC_INSN_FORM_XFORM_ICBT },
	{ .str = "PPC_INSN_FORM_XFORM_IMM2_IMM2",
	  .val = PPC_INSN_FORM_XFORM_IMM2_IMM2 },
	{ .str = "PPC_INSN_FORM_XFORM_IMM3_IMM2",
	  .val = PPC_INSN_FORM_XFORM_IMM3_IMM2 },
	{ .str = "PPC_INSN_FORM_XFORM_MBAR", .val = PPC_INSN_FORM_XFORM_MBAR },
	{ .str = "PPC_INSN_FORM_XFORM_MTMSR",
	  .val = PPC_INSN_FORM_XFORM_MTMSR },
	{ .str = "PPC_INSN_FORM_XFORM_S1_FRTB5",
	  .val = PPC_INSN_FORM_XFORM_S1_FRTB5 },
	{ .str = "PPC_INSN_FORM_XFORM_SP2_FRTB5",
	  .val = PPC_INSN_FORM_XFORM_SP2_FRTB5 },
	{ .str = "PPC_INSN_FORM_XFORM_SR", .val = PPC_INSN_FORM_XFORM_SR },
	{ .str = "PPC_INSN_FORM_XFORM_SRIN", .val = PPC_INSN_FORM_XFORM_SRIN },
	{ .str = "PPC_INSN_FORM_XFORM_TLBWS",
	  .val = PPC_INSN_FORM_XFORM_TLBWS },
	{ .str = "PPC_INSN_FORM_XFORM_XD6_RA5_RB5",
	  .val = PPC_INSN_FORM_XFORM_XD6_RA5_RB5 },
	{ .str = "PPC_INSN_FORM_XFORM_XT6_IMM5",
	  .val = PPC_INSN_FORM_XFORM_XT6_IMM5 },
	{ .str = "PPC_INSN_FORM_XFORM_XT6_IMM5_VB5",
	  .val = PPC_INSN_FORM_XFORM_XT6_IMM5_VB5 },
	{ .str = "PPC_INSN_FORM_XFXFORM_1", .val = PPC_INSN_FORM_XFXFORM_1 },
	{ .str = "PPC_INSN_FORM_XFXFORM_3", .val = PPC_INSN_FORM_XFXFORM_3 },
	{ .str = "PPC_INSN_FORM_XFXFORM_3P", .val = PPC_INSN_FORM_XFXFORM_3P },
	{ .str = "PPC_INSN_FORM_XFXFORM_5", .val = PPC_INSN_FORM_XFXFORM_5 },
	{ .str = "PPC_INSN_FORM_XFXFORM_5A", .val = PPC_INSN_FORM_XFXFORM_5A },
	{ .str = "PPC_INSN_FORM_XLFORM_1", .val = PPC_INSN_FORM_XLFORM_1 },
	{ .str = "PPC_INSN_FORM_XLFORM_2", .val = PPC_INSN_FORM_XLFORM_2 },
	{ .str = "PPC_INSN_FORM_XLFORM_3", .val = PPC_INSN_FORM_XLFORM_3 },
	{ .str = "PPC_INSN_FORM_XLFORM_4", .val = PPC_INSN_FORM_XLFORM_4 },
	{ .str = "PPC_INSN_FORM_XLFORM_S", .val = PPC_INSN_FORM_XLFORM_S },
	{ .str = "PPC_INSN_FORM_XOFORM_1", .val = PPC_INSN_FORM_XOFORM_1 },
	{ .str = "PPC_INSN_FORM_XOFORM_RTAB5_L1",
	  .val = PPC_INSN_FORM_XOFORM_RTAB5_L1 },
	{ .str = "PPC_INSN_FORM_XSFORM_1", .val = PPC_INSN_FORM_XSFORM_1 },
	{ .str = "PPC_INSN_FORM_XX1FORM", .val = PPC_INSN_FORM_XX1FORM },
	{ .str = "PPC_INSN_FORM_XX2FORM", .val = PPC_INSN_FORM_XX2FORM },
	{ .str = "PPC_INSN_FORM_XX2FORM_1", .val = PPC_INSN_FORM_XX2FORM_1 },
	{ .str = "PPC_INSN_FORM_XX2FORM_2", .val = PPC_INSN_FORM_XX2FORM_2 },
	{ .str = "PPC_INSN_FORM_XX2FORM_AT3_XBP5_P2",
	  .val = PPC_INSN_FORM_XX2FORM_AT3_XBP5_P2 },
	{ .str = "PPC_INSN_FORM_XX2_BF3_DCMX7_RS6",
	  .val = PPC_INSN_FORM_XX2_BF3_DCMX7_RS6 },
	{ .str = "PPC_INSN_FORM_XX2_BF3_XO5_XB6_XO9",
	  .val = PPC_INSN_FORM_XX2_BF3_XO5_XB6_XO9 },
	{ .str = "PPC_INSN_FORM_XX2_RD5_XO5_RS6",
	  .val = PPC_INSN_FORM_XX2_RD5_XO5_RS6 },
	{ .str = "PPC_INSN_FORM_XX2_RD6_DCMX7_RS6",
	  .val = PPC_INSN_FORM_XX2_RD6_DCMX7_RS6 },
	{ .str = "PPC_INSN_FORM_XX2_RD6_UIM5_RS6",
	  .val = PPC_INSN_FORM_XX2_RD6_UIM5_RS6 },
	{ .str = "PPC_INSN_FORM_XX2_RD6_XO5_RS6",
	  .val = PPC_INSN_FORM_XX2_RD6_XO5_RS6 },
	{ .str = "PPC_INSN_FORM_XX3FORM", .val = PPC_INSN_FORM_XX3FORM },
	{ .str = "PPC_INSN_FORM_XX3FORM_1", .val = PPC_INSN_FORM_XX3FORM_1 },
	{ .str = "PPC_INSN_FORM_XX3FORM_2", .val = PPC_INSN_FORM_XX3FORM_2 },
	{ .str = "PPC_INSN_FORM_XX3FORM_AT3_XAB6",
	  .val = PPC_INSN_FORM_XX3FORM_AT3_XAB6 },
	{ .str = "PPC_INSN_FORM_XX3FORM_AT3_XABP5_P1",
	  .val = PPC_INSN_FORM_XX3FORM_AT3_XABP5_P1 },
	{ .str = "PPC_INSN_FORM_XX3FORM_RC", .val = PPC_INSN_FORM_XX3FORM_RC },
	{ .str = "PPC_INSN_FORM_XX4FORM", .val = PPC_INSN_FORM_XX4FORM },
	{ .str = "PPC_INSN_FORM_X_BF3_DCMX7_RS5",
	  .val = PPC_INSN_FORM_X_BF3_DCMX7_RS5 },
	{ .str = "PPC_INSN_FORM_X_BF3_L1_RS5_RS5",
	  .val = PPC_INSN_FORM_X_BF3_L1_RS5_RS5 },
	{ .str = "PPC_INSN_FORM_X_BF3_RS5_RS5",
	  .val = PPC_INSN_FORM_X_BF3_RS5_RS5 },
	{ .str = "PPC_INSN_FORM_X_RD6_IMM8", .val = PPC_INSN_FORM_X_RD6_IMM8 },
	{ .str = "PPC_INSN_FORM_Z22FORM_BF3_FRA5_DCM6",
	  .val = PPC_INSN_FORM_Z22FORM_BF3_FRA5_DCM6 },
	{ .str = "PPC_INSN_FORM_Z22FORM_FRTA5_SH6",
	  .val = PPC_INSN_FORM_Z22FORM_FRTA5_SH6 },
	{ .str = "PPC_INSN_FORM_Z23FORM_1", .val = PPC_INSN_FORM_Z23FORM_1 },
	{ .str = "PPC_INSN_FORM_Z23FORM_3", .val = PPC_INSN_FORM_Z23FORM_3 },
	{ .str = "PPC_INSN_FORM_Z23FORM_8", .val = PPC_INSN_FORM_Z23FORM_8 },
	{ .str = "PPC_INSN_FORM_Z23FORM_FRTAB5_RMC2",
	  .val = PPC_INSN_FORM_Z23FORM_FRTAB5_RMC2 },
	{ .str = "PPC_INSN_FORM_Z23FORM_FRTB5_R1_RMC2",
	  .val = PPC_INSN_FORM_Z23FORM_FRTB5_R1_RMC2 },
	{ .str = "PPC_INSN_FORM_Z23FORM_RTAB5_CY2",
	  .val = PPC_INSN_FORM_Z23FORM_RTAB5_CY2 },
	{ .str = "PPC_OP_IMM", .val = PPC_OP_IMM },
	{ .str = "PPC_OP_MEM", .val = PPC_OP_MEM },
	{ .str = "PPC_OP_REG", .val = PPC_OP_REG },
	{ .str = "PPC_PRED_BIT_SET", .val = PPC_PRED_BIT_SET },
	{ .str = "PPC_PRED_BIT_UNSET", .val = PPC_PRED_BIT_UNSET },
	{ .str = "PPC_PRED_EQ", .val = PPC_PRED_EQ },
	{ .str = "PPC_PRED_EQ_MINUS", .val = PPC_PRED_EQ_MINUS },
	{ .str = "PPC_PRED_EQ_PLUS", .val = PPC_PRED_EQ_PLUS },
	{ .str = "PPC_PRED_EQ_RESERVED", .val = PPC_PRED_EQ_RESERVED },
	{ .str = "PPC_PRED_GE", .val = PPC_PRED_GE },
	{ .str = "PPC_PRED_GE_MINUS", .val = PPC_PRED_GE_MINUS },
	{ .str = "PPC_PRED_GE_PLUS", .val = PPC_PRED_GE_PLUS },
	{ .str = "PPC_PRED_GE_RESERVED", .val = PPC_PRED_GE_RESERVED },
	{ .str = "PPC_PRED_GT", .val = PPC_PRED_GT },
	{ .str = "PPC_PRED_GT_MINUS", .val = PPC_PRED_GT_MINUS },
	{ .str = "PPC_PRED_GT_PLUS", .val = PPC_PRED_GT_PLUS },
	{ .str = "PPC_PRED_GT_RESERVED", .val = PPC_PRED_GT_RESERVED },
	{ .str = "PPC_PRED_LE", .val = PPC_PRED_LE },
	{ .str = "PPC_PRED_LE_MINUS", .val = PPC_PRED_LE_MINUS },
	{ .str = "PPC_PRED_LE_PLUS", .val = PPC_PRED_LE_PLUS },
	{ .str = "PPC_PRED_LE_RESERVED", .val = PPC_PRED_LE_RESERVED },
	{ .str = "PPC_PRED_LT", .val = PPC_PRED_LT },
	{ .str = "PPC_PRED_LT_MINUS", .val = PPC_PRED_LT_MINUS },
	{ .str = "PPC_PRED_LT_PLUS", .val = PPC_PRED_LT_PLUS },
	{ .str = "PPC_PRED_LT_RESERVED", .val = PPC_PRED_LT_RESERVED },
	{ .str = "PPC_PRED_NE", .val = PPC_PRED_NE },
	{ .str = "PPC_PRED_NE_MINUS", .val = PPC_PRED_NE_MINUS },
	{ .str = "PPC_PRED_NE_PLUS", .val = PPC_PRED_NE_PLUS },
	{ .str = "PPC_PRED_NE_RESERVED", .val = PPC_PRED_NE_RESERVED },
	{ .str = "PPC_PRED_NS", .val = PPC_PRED_NS },
	{ .str = "PPC_PRED_NU", .val = PPC_PRED_NU },
	{ .str = "PPC_PRED_NU_MINUS", .val = PPC_PRED_NU_MINUS },
	{ .str = "PPC_PRED_NU_PLUS", .val = PPC_PRED_NU_PLUS },
	{ .str = "PPC_PRED_NU_RESERVED", .val = PPC_PRED_NU_RESERVED },
	{ .str = "PPC_PRED_NZ", .val = PPC_PRED_NZ },
	{ .str = "PPC_PRED_NZ_MINUS", .val = PPC_PRED_NZ_MINUS },
	{ .str = "PPC_PRED_NZ_PLUS", .val = PPC_PRED_NZ_PLUS },
	{ .str = "PPC_PRED_NZ_RESERVED", .val = PPC_PRED_NZ_RESERVED },
	{ .str = "PPC_PRED_SO", .val = PPC_PRED_SO },
	{ .str = "PPC_PRED_SPE", .val = PPC_PRED_SPE },
	{ .str = "PPC_PRED_UN", .val = PPC_PRED_UN },
	{ .str = "PPC_PRED_UN_MINUS", .val = PPC_PRED_UN_MINUS },
	{ .str = "PPC_PRED_UN_PLUS", .val = PPC_PRED_UN_PLUS },
	{ .str = "PPC_PRED_UN_RESERVED", .val = PPC_PRED_UN_RESERVED },
	{ .str = "PPC_PRED_Z", .val = PPC_PRED_Z },
	{ .str = "PPC_PRED_Z_MINUS", .val = PPC_PRED_Z_MINUS },
	{ .str = "PPC_PRED_Z_PLUS", .val = PPC_PRED_Z_PLUS },
	{ .str = "PPC_PRED_Z_RESERVED", .val = PPC_PRED_Z_RESERVED },
	{ .str = "RISCV_GRP_BRANCH_RELATIVE",
	  .val = RISCV_GRP_BRANCH_RELATIVE },
	{ .str = "RISCV_GRP_CALL", .val = RISCV_GRP_CALL },
	{ .str = "RISCV_GRP_HASSTDEXTA", .val = RISCV_GRP_HASSTDEXTA },
	{ .str = "RISCV_GRP_HASSTDEXTC", .val = RISCV_GRP_HASSTDEXTC },
	{ .str = "RISCV_GRP_HASSTDEXTD", .val = RISCV_GRP_HASSTDEXTD },
	{ .str = "RISCV_GRP_HASSTDEXTF", .val = RISCV_GRP_HASSTDEXTF },
	{ .str = "RISCV_GRP_HASSTDEXTM", .val = RISCV_GRP_HASSTDEXTM },
	{ .str = "RISCV_GRP_INT", .val = RISCV_GRP_INT },
	{ .str = "RISCV_GRP_IRET", .val = RISCV_GRP_IRET },
	{ .str = "RISCV_GRP_ISRV32", .val = RISCV_GRP_ISRV32 },
	{ .str = "RISCV_GRP_ISRV64", .val = RISCV_GRP_ISRV64 },
	{ .str = "RISCV_GRP_JUMP", .val = RISCV_GRP_JUMP },
	{ .str = "RISCV_GRP_PRIVILEGE", .val = RISCV_GRP_PRIVILEGE },
	{ .str = "RISCV_GRP_RET", .val = RISCV_GRP_RET },
	{ .str = "RISCV_OP_IMM", .val = RISCV_OP_IMM },
	{ .str = "RISCV_OP_MEM", .val = RISCV_OP_MEM },
	{ .str = "RISCV_OP_REG", .val = RISCV_OP_REG },
	{ .str = "SH_GRP_BRANCH_RELATIVE", .val = SH_GRP_BRANCH_RELATIVE },
	{ .str = "SH_GRP_CALL", .val = SH_GRP_CALL },
	{ .str = "SH_GRP_INT", .val = SH_GRP_INT },
	{ .str = "SH_GRP_IRET", .val = SH_GRP_IRET },
	{ .str = "SH_GRP_JUMP", .val = SH_GRP_JUMP },
	{ .str = "SH_GRP_PRIVILEGE", .val = SH_GRP_PRIVILEGE },
	{ .str = "SH_GRP_RET", .val = SH_GRP_RET },
	{ .str = "SH_GRP_SH1", .val = SH_GRP_SH1 },
	{ .str = "SH_GRP_SH2", .val = SH_GRP_SH2 },
	{ .str = "SH_GRP_SH2A", .val = SH_GRP_SH2A },
	{ .str = "SH_GRP_SH2AFPU", .val = SH_GRP_SH2AFPU },
	{ .str = "SH_GRP_SH2DSP", .val = SH_GRP_SH2DSP },
	{ .str = "SH_GRP_SH2E", .val = SH_GRP_SH2E },
	{ .str = "SH_GRP_SH3", .val = SH_GRP_SH3 },
	{ .str = "SH_GRP_SH3DSP", .val = SH_GRP_SH3DSP },
	{ .str = "SH_GRP_SH4", .val = SH_GRP_SH4 },
	{ .str = "SH_GRP_SH4A", .val = SH_GRP_SH4A },
	{ .str = "SH_OP_IMM", .val = SH_OP_IMM },
	{ .str = "SH_OP_MEM", .val = SH_OP_MEM },
	{ .str = "SH_OP_MEM_GBR_DISP", .val = SH_OP_MEM_GBR_DISP },
	{ .str = "SH_OP_MEM_GBR_R0", .val = SH_OP_MEM_GBR_R0 },
	{ .str = "SH_OP_MEM_PCR", .val = SH_OP_MEM_PCR },
	{ .str = "SH_OP_MEM_REG_DISP", .val = SH_OP_MEM_REG_DISP },
	{ .str = "SH_OP_MEM_REG_IND", .val = SH_OP_MEM_REG_IND },
	{ .str = "SH_OP_MEM_REG_POST", .val = SH_OP_MEM_REG_POST },
	{ .str = "SH_OP_MEM_REG_PRE", .val = SH_OP_MEM_REG_PRE },
	{ .str = "SH_OP_MEM_REG_R0", .val = SH_OP_MEM_REG_R0 },
	{ .str = "SH_OP_MEM_TBR_DISP", .val = SH_OP_MEM_TBR_DISP },
	{ .str = "SH_OP_REG", .val = SH_OP_REG },
	{ .str = "SPARC_ASITAG_ASI_AIUP", .val = SPARC_ASITAG_ASI_AIUP },
	{ .str = "SPARC_ASITAG_ASI_AIUP_L", .val = SPARC_ASITAG_ASI_AIUP_L },
	{ .str = "SPARC_ASITAG_ASI_AIUS", .val = SPARC_ASITAG_ASI_AIUS },
	{ .str = "SPARC_ASITAG_ASI_AIUS_L", .val = SPARC_ASITAG_ASI_AIUS_L },
	{ .str = "SPARC_ASITAG_ASI_N", .val = SPARC_ASITAG_ASI_N },
	{ .str = "SPARC_ASITAG_ASI_N_L", .val = SPARC_ASITAG_ASI_N_L },
	{ .str = "SPARC_ASITAG_ASI_P", .val = SPARC_ASITAG_ASI_P },
	{ .str = "SPARC_ASITAG_ASI_PNF", .val = SPARC_ASITAG_ASI_PNF },
	{ .str = "SPARC_ASITAG_ASI_PNF_L", .val = SPARC_ASITAG_ASI_PNF_L },
	{ .str = "SPARC_ASITAG_ASI_P_L", .val = SPARC_ASITAG_ASI_P_L },
	{ .str = "SPARC_ASITAG_ASI_S", .val = SPARC_ASITAG_ASI_S },
	{ .str = "SPARC_ASITAG_ASI_SNF", .val = SPARC_ASITAG_ASI_SNF },
	{ .str = "SPARC_ASITAG_ASI_SNF_L", .val = SPARC_ASITAG_ASI_SNF_L },
	{ .str = "SPARC_ASITAG_ASI_S_L", .val = SPARC_ASITAG_ASI_S_L },
	{ .str = "SPARC_CC_CPCC_0", .val = SPARC_CC_CPCC_0 },
	{ .str = "SPARC_CC_CPCC_01", .val = SPARC_CC_CPCC_01 },
	{ .str = "SPARC_CC_CPCC_012", .val = SPARC_CC_CPCC_012 },
	{ .str = "SPARC_CC_CPCC_013", .val = SPARC_CC_CPCC_013 },
	{ .str = "SPARC_CC_CPCC_02", .val = SPARC_CC_CPCC_02 },
	{ .str = "SPARC_CC_CPCC_023", .val = SPARC_CC_CPCC_023 },
	{ .str = "SPARC_CC_CPCC_03", .val = SPARC_CC_CPCC_03 },
	{ .str = "SPARC_CC_CPCC_1", .val = SPARC_CC_CPCC_1 },
	{ .str = "SPARC_CC_CPCC_12", .val = SPARC_CC_CPCC_12 },
	{ .str = "SPARC_CC_CPCC_123", .val = SPARC_CC_CPCC_123 },
	{ .str = "SPARC_CC_CPCC_13", .val = SPARC_CC_CPCC_13 },
	{ .str = "SPARC_CC_CPCC_2", .val = SPARC_CC_CPCC_2 },
	{ .str = "SPARC_CC_CPCC_23", .val = SPARC_CC_CPCC_23 },
	{ .str = "SPARC_CC_CPCC_3", .val = SPARC_CC_CPCC_3 },
	{ .str = "SPARC_CC_CPCC_A", .val = SPARC_CC_CPCC_A },
	{ .str = "SPARC_CC_CPCC_N", .val = SPARC_CC_CPCC_N },
	{ .str = "SPARC_CC_FCC_A", .val = SPARC_CC_FCC_A },
	{ .str = "SPARC_CC_FCC_E", .val = SPARC_CC_FCC_E },
	{ .str = "SPARC_CC_FCC_G", .val = SPARC_CC_FCC_G },
	{ .str = "SPARC_CC_FCC_GE", .val = SPARC_CC_FCC_GE },
	{ .str = "SPARC_CC_FCC_L", .val = SPARC_CC_FCC_L },
	{ .str = "SPARC_CC_FCC_LE", .val = SPARC_CC_FCC_LE },
	{ .str = "SPARC_CC_FCC_LG", .val = SPARC_CC_FCC_LG },
	{ .str = "SPARC_CC_FCC_N", .val = SPARC_CC_FCC_N },
	{ .str = "SPARC_CC_FCC_NE", .val = SPARC_CC_FCC_NE },
	{ .str = "SPARC_CC_FCC_O", .val = SPARC_CC_FCC_O },
	{ .str = "SPARC_CC_FCC_U", .val = SPARC_CC_FCC_U },
	{ .str = "SPARC_CC_FCC_UE", .val = SPARC_CC_FCC_UE },
	{ .str = "SPARC_CC_FCC_UG", .val = SPARC_CC_FCC_UG },
	{ .str = "SPARC_CC_FCC_UGE", .val = SPARC_CC_FCC_UGE },
	{ .str = "SPARC_CC_FCC_UL", .val = SPARC_CC_FCC_UL },
	{ .str = "SPARC_CC_FCC_ULE", .val = SPARC_CC_FCC_ULE },
	{ .str = "SPARC_CC_FIELD_FCC0", .val = SPARC_CC_FIELD_FCC0 },
	{ .str = "SPARC_CC_FIELD_FCC1", .val = SPARC_CC_FIELD_FCC1 },
	{ .str = "SPARC_CC_FIELD_FCC2", .val = SPARC_CC_FIELD_FCC2 },
	{ .str = "SPARC_CC_FIELD_FCC3", .val = SPARC_CC_FIELD_FCC3 },
	{ .str = "SPARC_CC_FIELD_ICC", .val = SPARC_CC_FIELD_ICC },
	{ .str = "SPARC_CC_FIELD_NONE", .val = SPARC_CC_FIELD_NONE },
	{ .str = "SPARC_CC_FIELD_RESERVED_I",
	  .val = SPARC_CC_FIELD_RESERVED_I },
	{ .str = "SPARC_CC_FIELD_RESERVED_II",
	  .val = SPARC_CC_FIELD_RESERVED_II },
	{ .str = "SPARC_CC_FIELD_XCC", .val = SPARC_CC_FIELD_XCC },
	{ .str = "SPARC_CC_ICC_A", .val = SPARC_CC_ICC_A },
	{ .str = "SPARC_CC_ICC_CC", .val = SPARC_CC_ICC_CC },
	{ .str = "SPARC_CC_ICC_CS", .val = SPARC_CC_ICC_CS },
	{ .str = "SPARC_CC_ICC_E", .val = SPARC_CC_ICC_E },
	{ .str = "SPARC_CC_ICC_G", .val = SPARC_CC_ICC_G },
	{ .str = "SPARC_CC_ICC_GE", .val = SPARC_CC_ICC_GE },
	{ .str = "SPARC_CC_ICC_GU", .val = SPARC_CC_ICC_GU },
	{ .str = "SPARC_CC_ICC_L", .val = SPARC_CC_ICC_L },
	{ .str = "SPARC_CC_ICC_LE", .val = SPARC_CC_ICC_LE },
	{ .str = "SPARC_CC_ICC_LEU", .val = SPARC_CC_ICC_LEU },
	{ .str = "SPARC_CC_ICC_N", .val = SPARC_CC_ICC_N },
	{ .str = "SPARC_CC_ICC_NE", .val = SPARC_CC_ICC_NE },
	{ .str = "SPARC_CC_ICC_NEG", .val = SPARC_CC_ICC_NEG },
	{ .str = "SPARC_CC_ICC_POS", .val = SPARC_CC_ICC_POS },
	{ .str = "SPARC_CC_ICC_VC", .val = SPARC_CC_ICC_VC },
	{ .str = "SPARC_CC_ICC_VS", .val = SPARC_CC_ICC_VS },
	{ .str = "SPARC_CC_REG_GEZ", .val = SPARC_CC_REG_GEZ },
	{ .str = "SPARC_CC_REG_GZ", .val = SPARC_CC_REG_GZ },
	{ .str = "SPARC_CC_REG_LEZ", .val = SPARC_CC_REG_LEZ },
	{ .str = "SPARC_CC_REG_LZ", .val = SPARC_CC_REG_LZ },
	{ .str = "SPARC_CC_REG_NZ", .val = SPARC_CC_REG_NZ },
	{ .str = "SPARC_CC_REG_Z", .val = SPARC_CC_REG_Z },
	{ .str = "SPARC_CC_UNDEF", .val = SPARC_CC_UNDEF },
	{ .str = "SPARC_FEATURE_HASCASA", .val = SPARC_FEATURE_HASCASA },
	{ .str = "SPARC_FEATURE_HASPWRPSR", .val = SPARC_FEATURE_HASPWRPSR },
	{ .str = "SPARC_FEATURE_HASV9", .val = SPARC_FEATURE_HASV9 },
	{ .str = "SPARC_FEATURE_HASVIS", .val = SPARC_FEATURE_HASVIS },
	{ .str = "SPARC_FEATURE_HASVIS2", .val = SPARC_FEATURE_HASVIS2 },
	{ .str = "SPARC_FEATURE_HASVIS3", .val = SPARC_FEATURE_HASVIS3 },
	{ .str = "SPARC_FEATURE_IS64BIT", .val = SPARC_FEATURE_IS64BIT },
	{ .str = "SPARC_FEATURE_USESOFTMULDIV",
	  .val = SPARC_FEATURE_USESOFTMULDIV },
	{ .str = "SPARC_HINT_A", .val = SPARC_HINT_A },
	{ .str = "SPARC_HINT_A_PN", .val = SPARC_HINT_A_PN },
	{ .str = "SPARC_HINT_A_PT", .val = SPARC_HINT_A_PT },
	{ .str = "SPARC_HINT_PN", .val = SPARC_HINT_PN },
	{ .str = "SPARC_HINT_PT", .val = SPARC_HINT_PT },
	{ .str = "SPARC_MEMBAR_TAG_LOADLOAD",
	  .val = SPARC_MEMBAR_TAG_LOADLOAD },
	{ .str = "SPARC_MEMBAR_TAG_LOADSTORE",
	  .val = SPARC_MEMBAR_TAG_LOADSTORE },
	{ .str = "SPARC_MEMBAR_TAG_LOOKASIDE",
	  .val = SPARC_MEMBAR_TAG_LOOKASIDE },
	{ .str = "SPARC_MEMBAR_TAG_MEMISSUE",
	  .val = SPARC_MEMBAR_TAG_MEMISSUE },
	{ .str = "SPARC_MEMBAR_TAG_NONE", .val = SPARC_MEMBAR_TAG_NONE },
	{ .str = "SPARC_MEMBAR_TAG_STORELOAD",
	  .val = SPARC_MEMBAR_TAG_STORELOAD },
	{ .str = "SPARC_MEMBAR_TAG_STORESTORE",
	  .val = SPARC_MEMBAR_TAG_STORESTORE },
	{ .str = "SPARC_MEMBAR_TAG_SYNC", .val = SPARC_MEMBAR_TAG_SYNC },
	{ .str = "SPARC_OP_ASI", .val = SPARC_OP_ASI },
	{ .str = "SPARC_OP_IMM", .val = SPARC_OP_IMM },
	{ .str = "SPARC_OP_MEM", .val = SPARC_OP_MEM },
	{ .str = "SPARC_OP_MEMBAR_TAG", .val = SPARC_OP_MEMBAR_TAG },
	{ .str = "SPARC_OP_REG", .val = SPARC_OP_REG },
	{ .str = "SYSTEMZ_AM_BD", .val = SYSTEMZ_AM_BD },
	{ .str = "SYSTEMZ_AM_BDL", .val = SYSTEMZ_AM_BDL },
	{ .str = "SYSTEMZ_AM_BDR", .val = SYSTEMZ_AM_BDR },
	{ .str = "SYSTEMZ_AM_BDV", .val = SYSTEMZ_AM_BDV },
	{ .str = "SYSTEMZ_AM_BDX", .val = SYSTEMZ_AM_BDX },
	{ .str = "SYSTEMZ_CC_E", .val = SYSTEMZ_CC_E },
	{ .str = "SYSTEMZ_CC_H", .val = SYSTEMZ_CC_H },
	{ .str = "SYSTEMZ_CC_HE", .val = SYSTEMZ_CC_HE },
	{ .str = "SYSTEMZ_CC_L", .val = SYSTEMZ_CC_L },
	{ .str = "SYSTEMZ_CC_LE", .val = SYSTEMZ_CC_LE },
	{ .str = "SYSTEMZ_CC_LH", .val = SYSTEMZ_CC_LH },
	{ .str = "SYSTEMZ_CC_NE", .val = SYSTEMZ_CC_NE },
	{ .str = "SYSTEMZ_CC_NH", .val = SYSTEMZ_CC_NH },
	{ .str = "SYSTEMZ_CC_NHE", .val = SYSTEMZ_CC_NHE },
	{ .str = "SYSTEMZ_CC_NL", .val = SYSTEMZ_CC_NL },
	{ .str = "SYSTEMZ_CC_NLE", .val = SYSTEMZ_CC_NLE },
	{ .str = "SYSTEMZ_CC_NLH", .val = SYSTEMZ_CC_NLH },
	{ .str = "SYSTEMZ_CC_NO", .val = SYSTEMZ_CC_NO },
	{ .str = "SYSTEMZ_CC_O", .val = SYSTEMZ_CC_O },
	{ .str = "SYSTEMZ_INSN_FORM_INSTE", .val = SYSTEMZ_INSN_FORM_INSTE },
	{ .str = "SYSTEMZ_INSN_FORM_INSTI", .val = SYSTEMZ_INSN_FORM_INSTI },
	{ .str = "SYSTEMZ_INSN_FORM_INSTIE", .val = SYSTEMZ_INSN_FORM_INSTIE },
	{ .str = "SYSTEMZ_INSN_FORM_INSTMII",
	  .val = SYSTEMZ_INSN_FORM_INSTMII },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRIA",
	  .val = SYSTEMZ_INSN_FORM_INSTRIA },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRIB",
	  .val = SYSTEMZ_INSN_FORM_INSTRIB },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRIC",
	  .val = SYSTEMZ_INSN_FORM_INSTRIC },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRIEA",
	  .val = SYSTEMZ_INSN_FORM_INSTRIEA },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRIEB",
	  .val = SYSTEMZ_INSN_FORM_INSTRIEB },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRIEC",
	  .val = SYSTEMZ_INSN_FORM_INSTRIEC },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRIED",
	  .val = SYSTEMZ_INSN_FORM_INSTRIED },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRIEE",
	  .val = SYSTEMZ_INSN_FORM_INSTRIEE },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRIEF",
	  .val = SYSTEMZ_INSN_FORM_INSTRIEF },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRIEG",
	  .val = SYSTEMZ_INSN_FORM_INSTRIEG },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRILA",
	  .val = SYSTEMZ_INSN_FORM_INSTRILA },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRILB",
	  .val = SYSTEMZ_INSN_FORM_INSTRILB },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRILC",
	  .val = SYSTEMZ_INSN_FORM_INSTRILC },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRIS",
	  .val = SYSTEMZ_INSN_FORM_INSTRIS },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRR", .val = SYSTEMZ_INSN_FORM_INSTRR },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRRD",
	  .val = SYSTEMZ_INSN_FORM_INSTRRD },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRRE",
	  .val = SYSTEMZ_INSN_FORM_INSTRRE },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRRFA",
	  .val = SYSTEMZ_INSN_FORM_INSTRRFA },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRRFB",
	  .val = SYSTEMZ_INSN_FORM_INSTRRFB },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRRFC",
	  .val = SYSTEMZ_INSN_FORM_INSTRRFC },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRRFD",
	  .val = SYSTEMZ_INSN_FORM_INSTRRFD },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRRFE",
	  .val = SYSTEMZ_INSN_FORM_INSTRRFE },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRRS",
	  .val = SYSTEMZ_INSN_FORM_INSTRRS },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRSA",
	  .val = SYSTEMZ_INSN_FORM_INSTRSA },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRSB",
	  .val = SYSTEMZ_INSN_FORM_INSTRSB },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRSI",
	  .val = SYSTEMZ_INSN_FORM_INSTRSI },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRSLA",
	  .val = SYSTEMZ_INSN_FORM_INSTRSLA },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRSLB",
	  .val = SYSTEMZ_INSN_FORM_INSTRSLB },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRSYA",
	  .val = SYSTEMZ_INSN_FORM_INSTRSYA },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRSYB",
	  .val = SYSTEMZ_INSN_FORM_INSTRSYB },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRXA",
	  .val = SYSTEMZ_INSN_FORM_INSTRXA },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRXB",
	  .val = SYSTEMZ_INSN_FORM_INSTRXB },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRXE",
	  .val = SYSTEMZ_INSN_FORM_INSTRXE },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRXF",
	  .val = SYSTEMZ_INSN_FORM_INSTRXF },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRXYA",
	  .val = SYSTEMZ_INSN_FORM_INSTRXYA },
	{ .str = "SYSTEMZ_INSN_FORM_INSTRXYB",
	  .val = SYSTEMZ_INSN_FORM_INSTRXYB },
	{ .str = "SYSTEMZ_INSN_FORM_INSTS", .val = SYSTEMZ_INSN_FORM_INSTS },
	{ .str = "SYSTEMZ_INSN_FORM_INSTSI", .val = SYSTEMZ_INSN_FORM_INSTSI },
	{ .str = "SYSTEMZ_INSN_FORM_INSTSIL",
	  .val = SYSTEMZ_INSN_FORM_INSTSIL },
	{ .str = "SYSTEMZ_INSN_FORM_INSTSIY",
	  .val = SYSTEMZ_INSN_FORM_INSTSIY },
	{ .str = "SYSTEMZ_INSN_FORM_INSTSMI",
	  .val = SYSTEMZ_INSN_FORM_INSTSMI },
	{ .str = "SYSTEMZ_INSN_FORM_INSTSSA",
	  .val = SYSTEMZ_INSN_FORM_INSTSSA },
	{ .str = "SYSTEMZ_INSN_FORM_INSTSSB",
	  .val = SYSTEMZ_INSN_FORM_INSTSSB },
	{ .str = "SYSTEMZ_INSN_FORM_INSTSSC",
	  .val = SYSTEMZ_INSN_FORM_INSTSSC },
	{ .str = "SYSTEMZ_INSN_FORM_INSTSSD",
	  .val = SYSTEMZ_INSN_FORM_INSTSSD },
	{ .str = "SYSTEMZ_INSN_FORM_INSTSSE",
	  .val = SYSTEMZ_INSN_FORM_INSTSSE },
	{ .str = "SYSTEMZ_INSN_FORM_INSTSSF",
	  .val = SYSTEMZ_INSN_FORM_INSTSSF },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRIA",
	  .val = SYSTEMZ_INSN_FORM_INSTVRIA },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRIB",
	  .val = SYSTEMZ_INSN_FORM_INSTVRIB },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRIC",
	  .val = SYSTEMZ_INSN_FORM_INSTVRIC },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRID",
	  .val = SYSTEMZ_INSN_FORM_INSTVRID },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRIE",
	  .val = SYSTEMZ_INSN_FORM_INSTVRIE },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRIF",
	  .val = SYSTEMZ_INSN_FORM_INSTVRIF },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRIG",
	  .val = SYSTEMZ_INSN_FORM_INSTVRIG },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRIH",
	  .val = SYSTEMZ_INSN_FORM_INSTVRIH },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRII",
	  .val = SYSTEMZ_INSN_FORM_INSTVRII },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRRA",
	  .val = SYSTEMZ_INSN_FORM_INSTVRRA },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRRB",
	  .val = SYSTEMZ_INSN_FORM_INSTVRRB },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRRC",
	  .val = SYSTEMZ_INSN_FORM_INSTVRRC },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRRD",
	  .val = SYSTEMZ_INSN_FORM_INSTVRRD },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRRE",
	  .val = SYSTEMZ_INSN_FORM_INSTVRRE },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRRF",
	  .val = SYSTEMZ_INSN_FORM_INSTVRRF },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRRG",
	  .val = SYSTEMZ_INSN_FORM_INSTVRRG },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRRH",
	  .val = SYSTEMZ_INSN_FORM_INSTVRRH },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRRI",
	  .val = SYSTEMZ_INSN_FORM_INSTVRRI },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRRJ",
	  .val = SYSTEMZ_INSN_FORM_INSTVRRJ },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRRK",
	  .val = SYSTEMZ_INSN_FORM_INSTVRRK },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRSA",
	  .val = SYSTEMZ_INSN_FORM_INSTVRSA },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRSB",
	  .val = SYSTEMZ_INSN_FORM_INSTVRSB },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRSC",
	  .val = SYSTEMZ_INSN_FORM_INSTVRSC },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRSD",
	  .val = SYSTEMZ_INSN_FORM_INSTVRSD },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRV",
	  .val = SYSTEMZ_INSN_FORM_INSTVRV },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVRX",
	  .val = SYSTEMZ_INSN_FORM_INSTVRX },
	{ .str = "SYSTEMZ_INSN_FORM_INSTVSI",
	  .val = SYSTEMZ_INSN_FORM_INSTVSI },
	{ .str = "SYSTEMZ_OP_IMM", .val = SYSTEMZ_OP_IMM },
	{ .str = "SYSTEMZ_OP_MEM", .val = SYSTEMZ_OP_MEM },
	{ .str = "SYSTEMZ_OP_REG", .val = SYSTEMZ_OP_REG },
	{ .str = "TMS320C64X_FUNIT_D", .val = TMS320C64X_FUNIT_D },
	{ .str = "TMS320C64X_FUNIT_L", .val = TMS320C64X_FUNIT_L },
	{ .str = "TMS320C64X_FUNIT_M", .val = TMS320C64X_FUNIT_M },
	{ .str = "TMS320C64X_FUNIT_NO", .val = TMS320C64X_FUNIT_NO },
	{ .str = "TMS320C64X_FUNIT_S", .val = TMS320C64X_FUNIT_S },
	{ .str = "TMS320C64X_GRP_FUNIT_D", .val = TMS320C64X_GRP_FUNIT_D },
	{ .str = "TMS320C64X_GRP_FUNIT_L", .val = TMS320C64X_GRP_FUNIT_L },
	{ .str = "TMS320C64X_GRP_FUNIT_M", .val = TMS320C64X_GRP_FUNIT_M },
	{ .str = "TMS320C64X_GRP_FUNIT_NO", .val = TMS320C64X_GRP_FUNIT_NO },
	{ .str = "TMS320C64X_GRP_FUNIT_S", .val = TMS320C64X_GRP_FUNIT_S },
	{ .str = "TMS320C64X_GRP_JUMP", .val = TMS320C64X_GRP_JUMP },
	{ .str = "TMS320C64X_MEM_DIR_BW", .val = TMS320C64X_MEM_DIR_BW },
	{ .str = "TMS320C64X_MEM_DIR_FW", .val = TMS320C64X_MEM_DIR_FW },
	{ .str = "TMS320C64X_MEM_DISP_CONSTANT",
	  .val = TMS320C64X_MEM_DISP_CONSTANT },
	{ .str = "TMS320C64X_MEM_DISP_REGISTER",
	  .val = TMS320C64X_MEM_DISP_REGISTER },
	{ .str = "TMS320C64X_MEM_MOD_NO", .val = TMS320C64X_MEM_MOD_NO },
	{ .str = "TMS320C64X_MEM_MOD_POST", .val = TMS320C64X_MEM_MOD_POST },
	{ .str = "TMS320C64X_MEM_MOD_PRE", .val = TMS320C64X_MEM_MOD_PRE },
	{ .str = "TMS320C64X_OP_IMM", .val = TMS320C64X_OP_IMM },
	{ .str = "TMS320C64X_OP_MEM", .val = TMS320C64X_OP_MEM },
	{ .str = "TMS320C64X_OP_REG", .val = TMS320C64X_OP_REG },
	{ .str = "TMS320C64X_OP_REGPAIR", .val = TMS320C64X_OP_REGPAIR },
	{ .str = "TRICORE_OP_IMM", .val = TRICORE_OP_IMM },
	{ .str = "TRICORE_OP_MEM", .val = TRICORE_OP_MEM },
	{ .str = "TRICORE_OP_REG", .val = TRICORE_OP_REG },
	{ .str = "WASM_GRP_CONTROL", .val = WASM_GRP_CONTROL },
	{ .str = "WASM_GRP_MEMORY", .val = WASM_GRP_MEMORY },
	{ .str = "WASM_GRP_NUMBERIC", .val = WASM_GRP_NUMBERIC },
	{ .str = "WASM_GRP_PARAMETRIC", .val = WASM_GRP_PARAMETRIC },
	{ .str = "WASM_GRP_VARIABLE", .val = WASM_GRP_VARIABLE },
	{ .str = "WASM_OP_BRTABLE", .val = WASM_OP_BRTABLE },
	{ .str = "WASM_OP_IMM", .val = WASM_OP_IMM },
	{ .str = "WASM_OP_INT7", .val = WASM_OP_INT7 },
	{ .str = "WASM_OP_NONE", .val = WASM_OP_NONE },
	{ .str = "WASM_OP_UINT32", .val = WASM_OP_UINT32 },
	{ .str = "WASM_OP_UINT64", .val = WASM_OP_UINT64 },
	{ .str = "WASM_OP_VARUINT32", .val = WASM_OP_VARUINT32 },
	{ .str = "WASM_OP_VARUINT64", .val = WASM_OP_VARUINT64 },
	{ .str = "X86_AVX_BCAST_16", .val = X86_AVX_BCAST_16 },
	{ .str = "X86_AVX_BCAST_2", .val = X86_AVX_BCAST_2 },
	{ .str = "X86_AVX_BCAST_4", .val = X86_AVX_BCAST_4 },
	{ .str = "X86_AVX_BCAST_8", .val = X86_AVX_BCAST_8 },
	{ .str = "X86_AVX_CC_EQ", .val = X86_AVX_CC_EQ },
	{ .str = "X86_AVX_CC_EQ_OS", .val = X86_AVX_CC_EQ_OS },
	{ .str = "X86_AVX_CC_EQ_UQ", .val = X86_AVX_CC_EQ_UQ },
	{ .str = "X86_AVX_CC_EQ_US", .val = X86_AVX_CC_EQ_US },
	{ .str = "X86_AVX_CC_FALSE", .val = X86_AVX_CC_FALSE },
	{ .str = "X86_AVX_CC_FALSE_OS", .val = X86_AVX_CC_FALSE_OS },
	{ .str = "X86_AVX_CC_GE", .val = X86_AVX_CC_GE },
	{ .str = "X86_AVX_CC_GE_OQ", .val = X86_AVX_CC_GE_OQ },
	{ .str = "X86_AVX_CC_GT", .val = X86_AVX_CC_GT },
	{ .str = "X86_AVX_CC_GT_OQ", .val = X86_AVX_CC_GT_OQ },
	{ .str = "X86_AVX_CC_LE", .val = X86_AVX_CC_LE },
	{ .str = "X86_AVX_CC_LE_OQ", .val = X86_AVX_CC_LE_OQ },
	{ .str = "X86_AVX_CC_LT", .val = X86_AVX_CC_LT },
	{ .str = "X86_AVX_CC_LT_OQ", .val = X86_AVX_CC_LT_OQ },
	{ .str = "X86_AVX_CC_NEQ", .val = X86_AVX_CC_NEQ },
	{ .str = "X86_AVX_CC_NEQ_OQ", .val = X86_AVX_CC_NEQ_OQ },
	{ .str = "X86_AVX_CC_NEQ_OS", .val = X86_AVX_CC_NEQ_OS },
	{ .str = "X86_AVX_CC_NEQ_US", .val = X86_AVX_CC_NEQ_US },
	{ .str = "X86_AVX_CC_NGE", .val = X86_AVX_CC_NGE },
	{ .str = "X86_AVX_CC_NGE_UQ", .val = X86_AVX_CC_NGE_UQ },
	{ .str = "X86_AVX_CC_NGT", .val = X86_AVX_CC_NGT },
	{ .str = "X86_AVX_CC_NGT_UQ", .val = X86_AVX_CC_NGT_UQ },
	{ .str = "X86_AVX_CC_NLE", .val = X86_AVX_CC_NLE },
	{ .str = "X86_AVX_CC_NLE_UQ", .val = X86_AVX_CC_NLE_UQ },
	{ .str = "X86_AVX_CC_NLT", .val = X86_AVX_CC_NLT },
	{ .str = "X86_AVX_CC_NLT_UQ", .val = X86_AVX_CC_NLT_UQ },
	{ .str = "X86_AVX_CC_ORD", .val = X86_AVX_CC_ORD },
	{ .str = "X86_AVX_CC_ORD_S", .val = X86_AVX_CC_ORD_S },
	{ .str = "X86_AVX_CC_TRUE", .val = X86_AVX_CC_TRUE },
	{ .str = "X86_AVX_CC_TRUE_US", .val = X86_AVX_CC_TRUE_US },
	{ .str = "X86_AVX_CC_UNORD", .val = X86_AVX_CC_UNORD },
	{ .str = "X86_AVX_CC_UNORD_S", .val = X86_AVX_CC_UNORD_S },
	{ .str = "X86_AVX_RM_RD", .val = X86_AVX_RM_RD },
	{ .str = "X86_AVX_RM_RN", .val = X86_AVX_RM_RN },
	{ .str = "X86_AVX_RM_RU", .val = X86_AVX_RM_RU },
	{ .str = "X86_AVX_RM_RZ", .val = X86_AVX_RM_RZ },
	{ .str = "X86_EFLAGS_MODIFY_AF", .val = X86_EFLAGS_MODIFY_AF },
	{ .str = "X86_EFLAGS_MODIFY_CF", .val = X86_EFLAGS_MODIFY_CF },
	{ .str = "X86_EFLAGS_MODIFY_DF", .val = X86_EFLAGS_MODIFY_DF },
	{ .str = "X86_EFLAGS_MODIFY_IF", .val = X86_EFLAGS_MODIFY_IF },
	{ .str = "X86_EFLAGS_MODIFY_NT", .val = X86_EFLAGS_MODIFY_NT },
	{ .str = "X86_EFLAGS_MODIFY_OF", .val = X86_EFLAGS_MODIFY_OF },
	{ .str = "X86_EFLAGS_MODIFY_PF", .val = X86_EFLAGS_MODIFY_PF },
	{ .str = "X86_EFLAGS_MODIFY_RF", .val = X86_EFLAGS_MODIFY_RF },
	{ .str = "X86_EFLAGS_MODIFY_SF", .val = X86_EFLAGS_MODIFY_SF },
	{ .str = "X86_EFLAGS_MODIFY_TF", .val = X86_EFLAGS_MODIFY_TF },
	{ .str = "X86_EFLAGS_MODIFY_ZF", .val = X86_EFLAGS_MODIFY_ZF },
	{ .str = "X86_EFLAGS_PRIOR_AF", .val = X86_EFLAGS_PRIOR_AF },
	{ .str = "X86_EFLAGS_PRIOR_CF", .val = X86_EFLAGS_PRIOR_CF },
	{ .str = "X86_EFLAGS_PRIOR_DF", .val = X86_EFLAGS_PRIOR_DF },
	{ .str = "X86_EFLAGS_PRIOR_IF", .val = X86_EFLAGS_PRIOR_IF },
	{ .str = "X86_EFLAGS_PRIOR_NT", .val = X86_EFLAGS_PRIOR_NT },
	{ .str = "X86_EFLAGS_PRIOR_OF", .val = X86_EFLAGS_PRIOR_OF },
	{ .str = "X86_EFLAGS_PRIOR_PF", .val = X86_EFLAGS_PRIOR_PF },
	{ .str = "X86_EFLAGS_PRIOR_SF", .val = X86_EFLAGS_PRIOR_SF },
	{ .str = "X86_EFLAGS_PRIOR_TF", .val = X86_EFLAGS_PRIOR_TF },
	{ .str = "X86_EFLAGS_PRIOR_ZF", .val = X86_EFLAGS_PRIOR_ZF },
	{ .str = "X86_EFLAGS_RESET_0F", .val = X86_EFLAGS_RESET_0F },
	{ .str = "X86_EFLAGS_RESET_AC", .val = X86_EFLAGS_RESET_AC },
	{ .str = "X86_EFLAGS_RESET_AF", .val = X86_EFLAGS_RESET_AF },
	{ .str = "X86_EFLAGS_RESET_CF", .val = X86_EFLAGS_RESET_CF },
	{ .str = "X86_EFLAGS_RESET_DF", .val = X86_EFLAGS_RESET_DF },
	{ .str = "X86_EFLAGS_RESET_IF", .val = X86_EFLAGS_RESET_IF },
	{ .str = "X86_EFLAGS_RESET_NT", .val = X86_EFLAGS_RESET_NT },
	{ .str = "X86_EFLAGS_RESET_OF", .val = X86_EFLAGS_RESET_OF },
	{ .str = "X86_EFLAGS_RESET_PF", .val = X86_EFLAGS_RESET_PF },
	{ .str = "X86_EFLAGS_RESET_RF", .val = X86_EFLAGS_RESET_RF },
	{ .str = "X86_EFLAGS_RESET_SF", .val = X86_EFLAGS_RESET_SF },
	{ .str = "X86_EFLAGS_RESET_TF", .val = X86_EFLAGS_RESET_TF },
	{ .str = "X86_EFLAGS_RESET_ZF", .val = X86_EFLAGS_RESET_ZF },
	{ .str = "X86_EFLAGS_SET_AF", .val = X86_EFLAGS_SET_AF },
	{ .str = "X86_EFLAGS_SET_CF", .val = X86_EFLAGS_SET_CF },
	{ .str = "X86_EFLAGS_SET_DF", .val = X86_EFLAGS_SET_DF },
	{ .str = "X86_EFLAGS_SET_IF", .val = X86_EFLAGS_SET_IF },
	{ .str = "X86_EFLAGS_SET_OF", .val = X86_EFLAGS_SET_OF },
	{ .str = "X86_EFLAGS_SET_PF", .val = X86_EFLAGS_SET_PF },
	{ .str = "X86_EFLAGS_SET_SF", .val = X86_EFLAGS_SET_SF },
	{ .str = "X86_EFLAGS_SET_ZF", .val = X86_EFLAGS_SET_ZF },
	{ .str = "X86_EFLAGS_TEST_AF", .val = X86_EFLAGS_TEST_AF },
	{ .str = "X86_EFLAGS_TEST_CF", .val = X86_EFLAGS_TEST_CF },
	{ .str = "X86_EFLAGS_TEST_DF", .val = X86_EFLAGS_TEST_DF },
	{ .str = "X86_EFLAGS_TEST_IF", .val = X86_EFLAGS_TEST_IF },
	{ .str = "X86_EFLAGS_TEST_NT", .val = X86_EFLAGS_TEST_NT },
	{ .str = "X86_EFLAGS_TEST_OF", .val = X86_EFLAGS_TEST_OF },
	{ .str = "X86_EFLAGS_TEST_PF", .val = X86_EFLAGS_TEST_PF },
	{ .str = "X86_EFLAGS_TEST_RF", .val = X86_EFLAGS_TEST_RF },
	{ .str = "X86_EFLAGS_TEST_SF", .val = X86_EFLAGS_TEST_SF },
	{ .str = "X86_EFLAGS_TEST_TF", .val = X86_EFLAGS_TEST_TF },
	{ .str = "X86_EFLAGS_TEST_ZF", .val = X86_EFLAGS_TEST_ZF },
	{ .str = "X86_EFLAGS_UNDEFINED_AF", .val = X86_EFLAGS_UNDEFINED_AF },
	{ .str = "X86_EFLAGS_UNDEFINED_CF", .val = X86_EFLAGS_UNDEFINED_CF },
	{ .str = "X86_EFLAGS_UNDEFINED_OF", .val = X86_EFLAGS_UNDEFINED_OF },
	{ .str = "X86_EFLAGS_UNDEFINED_PF", .val = X86_EFLAGS_UNDEFINED_PF },
	{ .str = "X86_EFLAGS_UNDEFINED_SF", .val = X86_EFLAGS_UNDEFINED_SF },
	{ .str = "X86_EFLAGS_UNDEFINED_ZF", .val = X86_EFLAGS_UNDEFINED_ZF },
	{ .str = "X86_FPU_FLAGS_MODIFY_C0", .val = X86_FPU_FLAGS_MODIFY_C0 },
	{ .str = "X86_FPU_FLAGS_MODIFY_C1", .val = X86_FPU_FLAGS_MODIFY_C1 },
	{ .str = "X86_FPU_FLAGS_MODIFY_C2", .val = X86_FPU_FLAGS_MODIFY_C2 },
	{ .str = "X86_FPU_FLAGS_MODIFY_C3", .val = X86_FPU_FLAGS_MODIFY_C3 },
	{ .str = "X86_FPU_FLAGS_RESET_C0", .val = X86_FPU_FLAGS_RESET_C0 },
	{ .str = "X86_FPU_FLAGS_RESET_C1", .val = X86_FPU_FLAGS_RESET_C1 },
	{ .str = "X86_FPU_FLAGS_RESET_C2", .val = X86_FPU_FLAGS_RESET_C2 },
	{ .str = "X86_FPU_FLAGS_RESET_C3", .val = X86_FPU_FLAGS_RESET_C3 },
	{ .str = "X86_FPU_FLAGS_SET_C0", .val = X86_FPU_FLAGS_SET_C0 },
	{ .str = "X86_FPU_FLAGS_SET_C1", .val = X86_FPU_FLAGS_SET_C1 },
	{ .str = "X86_FPU_FLAGS_SET_C2", .val = X86_FPU_FLAGS_SET_C2 },
	{ .str = "X86_FPU_FLAGS_SET_C3", .val = X86_FPU_FLAGS_SET_C3 },
	{ .str = "X86_FPU_FLAGS_TEST_C0", .val = X86_FPU_FLAGS_TEST_C0 },
	{ .str = "X86_FPU_FLAGS_TEST_C1", .val = X86_FPU_FLAGS_TEST_C1 },
	{ .str = "X86_FPU_FLAGS_TEST_C2", .val = X86_FPU_FLAGS_TEST_C2 },
	{ .str = "X86_FPU_FLAGS_TEST_C3", .val = X86_FPU_FLAGS_TEST_C3 },
	{ .str = "X86_FPU_FLAGS_UNDEFINED_C0",
	  .val = X86_FPU_FLAGS_UNDEFINED_C0 },
	{ .str = "X86_FPU_FLAGS_UNDEFINED_C1",
	  .val = X86_FPU_FLAGS_UNDEFINED_C1 },
	{ .str = "X86_FPU_FLAGS_UNDEFINED_C2",
	  .val = X86_FPU_FLAGS_UNDEFINED_C2 },
	{ .str = "X86_FPU_FLAGS_UNDEFINED_C3",
	  .val = X86_FPU_FLAGS_UNDEFINED_C3 },
	{ .str = "X86_INS_VCMP", .val = X86_INS_VCMP },
	{ .str = "X86_OP_IMM", .val = X86_OP_IMM },
	{ .str = "X86_OP_MEM", .val = X86_OP_MEM },
	{ .str = "X86_OP_REG", .val = X86_OP_REG },
	{ .str = "X86_PREFIX_0", .val = 0 },
	{ .str = "X86_PREFIX_ADDRSIZE", .val = X86_PREFIX_ADDRSIZE },
	{ .str = "X86_PREFIX_CS", .val = X86_PREFIX_CS },
	{ .str = "X86_PREFIX_DS", .val = X86_PREFIX_DS },
	{ .str = "X86_PREFIX_ES", .val = X86_PREFIX_ES },
	{ .str = "X86_PREFIX_FS", .val = X86_PREFIX_FS },
	{ .str = "X86_PREFIX_GS", .val = X86_PREFIX_GS },
	{ .str = "X86_PREFIX_LOCK", .val = X86_PREFIX_LOCK },
	{ .str = "X86_PREFIX_OPSIZE", .val = X86_PREFIX_OPSIZE },
	{ .str = "X86_PREFIX_REP", .val = X86_PREFIX_REP },
	{ .str = "X86_PREFIX_REPE", .val = X86_PREFIX_REPE },
	{ .str = "X86_PREFIX_REPNE", .val = X86_PREFIX_REPNE },
	{ .str = "X86_PREFIX_SS", .val = X86_PREFIX_SS },
	{ .str = "X86_SSE_CC_EQ", .val = X86_SSE_CC_EQ },
	{ .str = "X86_SSE_CC_LE", .val = X86_SSE_CC_LE },
	{ .str = "X86_SSE_CC_LT", .val = X86_SSE_CC_LT },
	{ .str = "X86_SSE_CC_NEQ", .val = X86_SSE_CC_NEQ },
	{ .str = "X86_SSE_CC_NLE", .val = X86_SSE_CC_NLE },
	{ .str = "X86_SSE_CC_NLT", .val = X86_SSE_CC_NLT },
	{ .str = "X86_SSE_CC_ORD", .val = X86_SSE_CC_ORD },
	{ .str = "X86_SSE_CC_UNORD", .val = X86_SSE_CC_UNORD },
	{ .str = "X86_XOP_CC_EQ", .val = X86_XOP_CC_EQ },
	{ .str = "X86_XOP_CC_FALSE", .val = X86_XOP_CC_FALSE },
	{ .str = "X86_XOP_CC_GE", .val = X86_XOP_CC_GE },
	{ .str = "X86_XOP_CC_GT", .val = X86_XOP_CC_GT },
	{ .str = "X86_XOP_CC_LE", .val = X86_XOP_CC_LE },
	{ .str = "X86_XOP_CC_LT", .val = X86_XOP_CC_LT },
	{ .str = "X86_XOP_CC_NEQ", .val = X86_XOP_CC_NEQ },
	{ .str = "X86_XOP_CC_TRUE", .val = X86_XOP_CC_TRUE },
	{ .str = "XCORE_OP_IMM", .val = XCORE_OP_IMM },
	{ .str = "XCORE_OP_MEM", .val = XCORE_OP_MEM },
	{ .str = "XCORE_OP_REG", .val = XCORE_OP_REG },
	{ .str = "XTENSA_INSN_FORM_AEINST24",
	  .val = XTENSA_INSN_FORM_AEINST24 },
	{ .str = "XTENSA_INSN_FORM_BRI12", .val = XTENSA_INSN_FORM_BRI12 },
	{ .str = "XTENSA_INSN_FORM_CALL", .val = XTENSA_INSN_FORM_CALL },
	{ .str = "XTENSA_INSN_FORM_CALLX", .val = XTENSA_INSN_FORM_CALLX },
	{ .str = "XTENSA_INSN_FORM_EE_INST24",
	  .val = XTENSA_INSN_FORM_EE_INST24 },
	{ .str = "XTENSA_INSN_FORM_RI16", .val = XTENSA_INSN_FORM_RI16 },
	{ .str = "XTENSA_INSN_FORM_RI7", .val = XTENSA_INSN_FORM_RI7 },
	{ .str = "XTENSA_INSN_FORM_RRI4", .val = XTENSA_INSN_FORM_RRI4 },
	{ .str = "XTENSA_INSN_FORM_RRI8", .val = XTENSA_INSN_FORM_RRI8 },
	{ .str = "XTENSA_INSN_FORM_RRR", .val = XTENSA_INSN_FORM_RRR },
	{ .str = "XTENSA_INSN_FORM_RRRN", .val = XTENSA_INSN_FORM_RRRN },
	{ .str = "XTENSA_INSN_FORM_RSR", .val = XTENSA_INSN_FORM_RSR },
	{ .str = "XTENSA_OP_IMM", .val = XTENSA_OP_IMM },
	{ .str = "XTENSA_OP_L32R", .val = XTENSA_OP_L32R },
	{ .str = "XTENSA_OP_MEM", .val = XTENSA_OP_MEM },
	{ .str = "XTENSA_OP_REG", .val = XTENSA_OP_REG },
	{ .str = "zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzx",
	  .val = 0xffffff }, // For testing
	{ .str = "zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz",
	  .val = 0xffffff }, // For testing
};

#endif // TEST_MAPPING_H
