; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=loop-load-elim -S < %s | FileCheck %s

; If the store and the load use different types, but have the same
; size then we should still be able to forward the value.
;
;   for (unsigned i = 0; i < 100; i++) {
;     A[i+1] = B[i] + 2;
;     C[i] = ((float*)A)[i] * 2;
;   }

target datalayout = "e-m:o-p64:64:64-i64:64-f80:128-n8:16:32:64-S128"

define void @f(ptr noalias %A, ptr noalias %B, ptr noalias %C, i64 %N) {
; CHECK-LABEL: @f(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LOAD_INITIAL:%.*]] = load float, ptr [[A:%.*]], align 4
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[STORE_FORWARDED:%.*]] = phi float [ [[LOAD_INITIAL]], [[ENTRY:%.*]] ], [ [[STORE_FORWARD_CAST:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[AIDX_NEXT:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[INDVARS_IV_NEXT]]
; CHECK-NEXT:    [[BIDX:%.*]] = getelementptr inbounds i32, ptr [[B:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[CIDX:%.*]] = getelementptr inbounds i32, ptr [[C:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[AIDX:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[B:%.*]] = load i32, ptr [[BIDX]], align 4
; CHECK-NEXT:    [[A_P1:%.*]] = add i32 [[B]], 2
; CHECK-NEXT:    [[STORE_FORWARD_CAST]] = bitcast i32 [[A_P1]] to float
; CHECK-NEXT:    store i32 [[A_P1]], ptr [[AIDX_NEXT]], align 4
; CHECK-NEXT:    [[A:%.*]] = load float, ptr [[AIDX]], align 4
; CHECK-NEXT:    [[C:%.*]] = fmul float [[STORE_FORWARDED]], 2.000000e+00
; CHECK-NEXT:    [[C_INT:%.*]] = fptosi float [[C]] to i32
; CHECK-NEXT:    store i32 [[C_INT]], ptr [[CIDX]], align 4
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1

  %Aidx_next = getelementptr inbounds i32, ptr %A, i64 %indvars.iv.next
  %Bidx = getelementptr inbounds i32, ptr %B, i64 %indvars.iv
  %Cidx = getelementptr inbounds i32, ptr %C, i64 %indvars.iv
  %Aidx = getelementptr inbounds i32, ptr %A, i64 %indvars.iv

  %b = load i32, ptr %Bidx, align 4
  %a_p1 = add i32 %b, 2
  store i32 %a_p1, ptr %Aidx_next, align 4

  %a = load float, ptr %Aidx, align 4
  %c = fmul float %a, 2.0
  %c.int = fptosi float %c to i32
  store i32 %c.int, ptr %Cidx, align 4

  %exitcond = icmp eq i64 %indvars.iv.next, %N
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}

; If the store and the load use different types, but have the same
; size then we should still be able to forward the value.
;
;   for (unsigned i = 0; i < 100; i++) {
;     A[i+1] = B[i] + 2;
;     A[i+1] = B[i] + 3;
;     C[i] = ((float*)A)[i] * 2;
;   }

define void @f2(ptr noalias %A, ptr noalias %B, ptr noalias %C, i64 %N) {
; CHECK-LABEL: @f2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LOAD_INITIAL:%.*]] = load float, ptr [[A:%.*]], align 4
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[STORE_FORWARDED:%.*]] = phi float [ [[LOAD_INITIAL]], [[ENTRY:%.*]] ], [ [[STORE_FORWARD_CAST:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[AIDX_NEXT:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[INDVARS_IV_NEXT]]
; CHECK-NEXT:    [[BIDX:%.*]] = getelementptr inbounds i32, ptr [[B:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[CIDX:%.*]] = getelementptr inbounds i32, ptr [[C:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[AIDX:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[B:%.*]] = load i32, ptr [[BIDX]], align 4
; CHECK-NEXT:    [[A_P2:%.*]] = add i32 [[B]], 2
; CHECK-NEXT:    store i32 [[A_P2]], ptr [[AIDX_NEXT]], align 4
; CHECK-NEXT:    [[A_P3:%.*]] = add i32 [[B]], 3
; CHECK-NEXT:    [[STORE_FORWARD_CAST]] = bitcast i32 [[A_P3]] to float
; CHECK-NEXT:    store i32 [[A_P3]], ptr [[AIDX_NEXT]], align 4
; CHECK-NEXT:    [[A:%.*]] = load float, ptr [[AIDX]], align 4
; CHECK-NEXT:    [[C:%.*]] = fmul float [[STORE_FORWARDED]], 2.000000e+00
; CHECK-NEXT:    [[C_INT:%.*]] = fptosi float [[C]] to i32
; CHECK-NEXT:    store i32 [[C_INT]], ptr [[CIDX]], align 4
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1

  %Aidx_next = getelementptr inbounds i32, ptr %A, i64 %indvars.iv.next
  %Bidx = getelementptr inbounds i32, ptr %B, i64 %indvars.iv
  %Cidx = getelementptr inbounds i32, ptr %C, i64 %indvars.iv
  %Aidx = getelementptr inbounds i32, ptr %A, i64 %indvars.iv

  %b = load i32, ptr %Bidx, align 4
  %a_p2 = add i32 %b, 2
  store i32 %a_p2, ptr %Aidx_next, align 4

  %a_p3 = add i32 %b, 3
  store i32 %a_p3, ptr %Aidx_next, align 4

  %a = load float, ptr %Aidx, align 4
  %c = fmul float %a, 2.0
  %c.int = fptosi float %c to i32
  store i32 %c.int, ptr %Cidx, align 4

  %exitcond = icmp eq i64 %indvars.iv.next, %N
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}

; Check that we can forward between pointer-sized integers and actual
; pointers.

define void @f3(ptr noalias %A, ptr noalias %B, ptr noalias %C, i64 %N) {
; CHECK-LABEL: @f3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LOAD_INITIAL:%.*]] = load ptr, ptr [[A:%.*]], align 8
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[STORE_FORWARDED:%.*]] = phi ptr [ [[LOAD_INITIAL]], [[ENTRY:%.*]] ], [ [[STORE_FORWARD_CAST:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[AIDX_NEXT:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[INDVARS_IV_NEXT]]
; CHECK-NEXT:    [[BIDX:%.*]] = getelementptr inbounds i64, ptr [[B:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[CIDX:%.*]] = getelementptr inbounds i64, ptr [[C:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[AIDX:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[B:%.*]] = load i64, ptr [[BIDX]], align 8
; CHECK-NEXT:    [[A_P1:%.*]] = add i64 [[B]], 2
; CHECK-NEXT:    [[STORE_FORWARD_CAST]] = inttoptr i64 [[A_P1]] to ptr
; CHECK-NEXT:    store i64 [[A_P1]], ptr [[AIDX_NEXT]], align 8
; CHECK-NEXT:    [[A:%.*]] = load ptr, ptr [[AIDX]], align 8
; CHECK-NEXT:    [[C:%.*]] = getelementptr i8, ptr [[STORE_FORWARDED]], i64 57
; CHECK-NEXT:    [[C_I64P:%.*]] = ptrtoint ptr [[C]] to i64
; CHECK-NEXT:    store i64 [[C_I64P]], ptr [[CIDX]], align 8
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1

  %Aidx_next = getelementptr inbounds i64, ptr %A, i64 %indvars.iv.next
  %Bidx = getelementptr inbounds i64, ptr %B, i64 %indvars.iv
  %Cidx = getelementptr inbounds i64, ptr %C, i64 %indvars.iv
  %Aidx = getelementptr inbounds i64, ptr %A, i64 %indvars.iv

  %b = load i64, ptr %Bidx, align 8
  %a_p1 = add i64 %b, 2
  store i64 %a_p1, ptr %Aidx_next, align 8

  %a = load ptr, ptr %Aidx , align 8
  %c = getelementptr i8, ptr %a, i64 57
  %c.i64p = ptrtoint ptr %c to i64
  store i64 %c.i64p, ptr %Cidx, align 8

  %exitcond = icmp eq i64 %indvars.iv.next, %N
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}

; If the store and the load use different types, but have the same
; size then we should still be able to forward the value--also for
; vector types.
;
;   for (unsigned i = 0; i < 100; i++) {
;     A[i+1] = B[i] + 2;
;     C[i] = ((float*)A)[i] * 2;
;   }

define void @f4(ptr noalias %A, ptr noalias %B, ptr noalias %C, i64 %N) {
; CHECK-LABEL: @f4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LOAD_INITIAL:%.*]] = load <2 x half>, ptr [[A:%.*]], align 4
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[STORE_FORWARDED:%.*]] = phi <2 x half> [ [[LOAD_INITIAL]], [[ENTRY:%.*]] ], [ [[STORE_FORWARD_CAST:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[AIDX_NEXT:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[INDVARS_IV_NEXT]]
; CHECK-NEXT:    [[BIDX:%.*]] = getelementptr inbounds i32, ptr [[B:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[CIDX:%.*]] = getelementptr inbounds i32, ptr [[C:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[AIDX:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[B:%.*]] = load i32, ptr [[BIDX]], align 4
; CHECK-NEXT:    [[A_P1:%.*]] = add i32 [[B]], 2
; CHECK-NEXT:    [[STORE_FORWARD_CAST]] = bitcast i32 [[A_P1]] to <2 x half>
; CHECK-NEXT:    store i32 [[A_P1]], ptr [[AIDX_NEXT]], align 4
; CHECK-NEXT:    [[A:%.*]] = load <2 x half>, ptr [[AIDX]], align 4
; CHECK-NEXT:    [[C:%.*]] = fmul <2 x half> [[STORE_FORWARDED]], <half 0xH4000, half 0xH4000>
; CHECK-NEXT:    [[C_INT:%.*]] = bitcast <2 x half> [[C]] to i32
; CHECK-NEXT:    store i32 [[C_INT]], ptr [[CIDX]], align 4
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1

  %Aidx_next = getelementptr inbounds i32, ptr %A, i64 %indvars.iv.next
  %Bidx = getelementptr inbounds i32, ptr %B, i64 %indvars.iv
  %Cidx = getelementptr inbounds i32, ptr %C, i64 %indvars.iv
  %Aidx = getelementptr inbounds i32, ptr %A, i64 %indvars.iv

  %b = load i32, ptr %Bidx, align 4
  %a_p1 = add i32 %b, 2
  store i32 %a_p1, ptr %Aidx_next, align 4

  %a = load <2 x half>, ptr %Aidx, align 4
  %c = fmul <2 x half> %a, <half 2.0, half 2.0>
  %c.int = bitcast <2 x half> %c to i32
  store i32 %c.int, ptr %Cidx, align 4

  %exitcond = icmp eq i64 %indvars.iv.next, %N
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}

; Check that we don't forward between integers and actual
; pointers if sizes don't match.

define void @f5(ptr noalias %A, ptr noalias %B, ptr noalias %C, i64 %N) {
; CHECK-LABEL: @f5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[AIDX_NEXT:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i64 [[INDVARS_IV_NEXT]]
; CHECK-NEXT:    [[BIDX:%.*]] = getelementptr inbounds i32, ptr [[B:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[CIDX:%.*]] = getelementptr inbounds i32, ptr [[C:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[AIDX:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[B:%.*]] = load i32, ptr [[BIDX]], align 4
; CHECK-NEXT:    [[A_P1:%.*]] = add i32 [[B]], 2
; CHECK-NEXT:    store i32 [[A_P1]], ptr [[AIDX_NEXT]], align 4
; CHECK-NEXT:    [[A:%.*]] = load ptr, ptr [[AIDX]], align 8
; CHECK-NEXT:    [[C:%.*]] = getelementptr i8, ptr [[A]], i32 57
; CHECK-NEXT:    [[C_I64P:%.*]] = ptrtoint ptr [[C]] to i32
; CHECK-NEXT:    store i32 [[C_I64P]], ptr [[CIDX]], align 8
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1

  %Aidx_next = getelementptr inbounds i32, ptr %A, i64 %indvars.iv.next
  %Bidx = getelementptr inbounds i32, ptr %B, i64 %indvars.iv
  %Cidx = getelementptr inbounds i32, ptr %C, i64 %indvars.iv
  %Aidx = getelementptr inbounds i32, ptr %A, i64 %indvars.iv

  %b = load i32, ptr %Bidx, align 4
  %a_p1 = add i32 %b, 2
  store i32 %a_p1, ptr %Aidx_next, align 4

  %a = load ptr, ptr %Aidx , align 8
  %c = getelementptr i8, ptr %a, i32 57
  %c.i64p = ptrtoint ptr %c to i32
  store i32 %c.i64p, ptr %Cidx, align 8

  %exitcond = icmp eq i64 %indvars.iv.next, %N
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}
