/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.internal;

import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import sharpen.core.Annotations;
import sharpen.core.Bindings;
import sharpen.core.framework.BindingUtils;
import sharpen.core.framework.Environments;
import sharpen.core.framework.JavadocUtility;

public class AnnotationsImpl
implements Annotations {
    private final CompilationUnit _ast = Environments.my(CompilationUnit.class);
    private final Bindings _bindings = Environments.my(Bindings.class);

    @Override
    public TagElement effectiveAnnotationFor(MethodDeclaration node, String annotation) {
        TagElement eventTag = this.javadocTagFor(node, annotation);
        if (eventTag != null) {
            return eventTag;
        }
        MethodDeclaration originalMethod = this.findOriginalMethodDeclaration(node);
        if (originalMethod == null) {
            return null;
        }
        return this.javadocTagFor(originalMethod, annotation);
    }

    private TagElement javadocTagFor(MethodDeclaration method, String annotation) {
        return JavadocUtility.getJavadocTag((BodyDeclaration)method, annotation);
    }

    private MethodDeclaration findOriginalMethodDeclaration(MethodDeclaration node) {
        return this.findOriginalMethodDeclaration(node.resolveBinding());
    }

    private MethodDeclaration findOriginalMethodDeclaration(IMethodBinding binding) {
        IMethodBinding definition = BindingUtils.findMethodDefininition(binding, this._ast.getAST());
        if (definition == null) {
            return null;
        }
        return (MethodDeclaration)this._bindings.findDeclaringNode((IBinding)definition);
    }

    @Override
    public String annotatedPropertyName(MethodDeclaration node) {
        TagElement propertyTag = this.effectiveAnnotationFor(node, "@sharpen.property");
        if (JavadocUtility.hasSingleTextFragment(propertyTag)) {
            return JavadocUtility.singleTextFragmentFrom(propertyTag);
        }
        return null;
    }

    @Override
    public String annotatedRenaming(BodyDeclaration node) {
        TagElement renameTag = JavadocUtility.getJavadocTag(node, "@sharpen.rename");
        if (renameTag == null) {
            return null;
        }
        return JavadocUtility.singleTextFragmentFrom(renameTag);
    }
}

