# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1566-1 (cpio)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60932);
 script_cve_id("CVE-2007-4476");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1566-1 (cpio)";
 script_name(name);

 desc = "The remote host is missing an update to cpio
announced via advisory DSA 1566-1.

Dmitry Levin discovered a vulnerability in path handling code used by
the cpio archive utility.  The weakness could enable a denial of
service (crash) or potentially the execution of arbitrary code if a
vulnerable version of cpio is used to extract or to list the contents
of a maliciously crafted archive.

For the stable distribution (etch), these problems have been fixed in
version 2.6-18.1+etch1.

For the unstable distribution (sid), these problems have been fixed in
version 2.9-5.

We recommend that you upgrade your cpio packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201566-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1566-1 (cpio)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cpio", ver:"2.6-18.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
