# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1828-1 (ocsinventory-agent)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64380);
 script_cve_id("CVE-2009-0667");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1828-1 (ocsinventory-agent)";
 script_name(name);

 desc = "The remote host is missing an update to ocsinventory-agent
announced via advisory DSA 1828-1.


It was discovered that the ocsinventory-agent which is part of the
ocsinventory suite, a hardware and software configuration indexing service,
is prone to an insecure perl module search path.  As the agent is started
via cron and the current directory (/ in this case) is included in the
default perl module path the agent scans every directory on the system
for its perl modules.  This enables an attacker to execute arbitrary code
via a crafted ocsinventory-agent perl module placed on the system.


The oldstable distribution (etch) does not contain ocsinventory-agent.

For the stable distribution (lenny), this problem has been fixed in
version 1:0.0.9.2repack1-4lenny1.

For the testing distribution (squeeze), this problem has been fixed in
version 1:0.0.9.2repack1-5

For the unstable distribution (sid), this problem has been fixed in
version 1:0.0.9.2repack1-5.


We recommend that you upgrade your ocsinventory-agent packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201828-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1828-1 (ocsinventory-agent)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ocsinventory-agent", ver:"0.0.9.2repack1-4lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
