# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 202-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53445);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 202-1 (im)";
 script_name(name);

 desc = "The remote host is missing an update to im
announced via advisory DSA 202-1.

Tatsuya Kinoshita discovered that IM, which contains interface
commands and Perl libraries for E-mail and NetNews, creates temporary
files insecurely.

1. The impwagent program creates a temporary directory in an insecure
manner in /tmp using predictable directory names without checking
the return code of mkdir, so it's possible to seize a permission
of the temporary directory by local access as another user.

2. The immknmz program creates a temporary file in an insecure manner
in /tmp using a predictable filename, so an attacker with local
access can easily create and overwrite files as another user.

These problems have been fixed in version 141-18.1 for the current
stable distribution (woody), in version 133-2.2 of the old stable
distribution (potato) and in version 141-20 for the unstable
distribution (sid).

We recommend that you upgrade your IM package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20202-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 202-1 (im)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"im", ver:"133-2.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"im", ver:"141-18.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
