###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_baofeng_storm_smpl_bof_vuln.nasl 3686 2009-08-03 17:36:24Z aug $
#
# BaoFeng Storm '.smpl' File Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800914);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-2617");
  script_bugtraq_id(35512);
  script_name("BaoFeng Storm '.smpl' File Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is installed with BaoFeng Storm and is prone to
  Buffer Overflow vulnerability.

  Vulnerability Insight:
  A boundary error occurs in the MediaLib.dll file while processing '.smpl'
  playlist file containing long pathname in the source attribute of ani item
  element.

  Impact:
  Attacker may exploit this issue to execute arbitrary script code and may cause
  denial of service.

  Impact Level: Application

  Affected Software/OS:
  BaoFeng Storm version 3.09.62 and prior on Windows.

  Fix: Upgarde to the latest BaoFeng Storm version 3.09.07.08
  http://www.baofeng.com/

  References:
  http://secunia.com/advisories/35592
  http://marc.info/?l=full-disclosure&m=124627617220913&w=2
  http://archives.neohapsis.com/archives/fulldisclosure/2009-06/0287.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of BaoFeng Storm");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_baofeng_storm_detect.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

stormVer = get_kb_item("BaoFeng/Storm/Ver");
if(!stormVer){
  exit(0);
}

stormPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                  "\Uninstall\Storm2", item:"DisplayIcon");
if(!stormPath){
  exit(0);
}

stormPath = stormPath - "Storm.exe" + "MediaLib.dll";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:stormPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:stormPath);
stormdllVer = GetVer(share:share, file:file);

# If MediaLib.dll exists, check for the version of Storm.
if(stormdllVer != NULL)
{
  if(version_is_less_equal(version:stormVer, test_version:"3.09.62")){
    security_hole(0);
  }
}
