###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Kerberos HPSBUX02421
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835203);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "HPSBUX", value: "02421");
  script_cve_id("CVE-2009-0846", "CVE-2009-0847");
  script_name("HP-UX Update for Kerberos HPSBUX02421");
  desc = "

  Vulnerability Insight:
  Potential security vulnerabilities have been identified on HP-UX running 
  Kerberos. These vulnerabilities could be exploited by remote unauthenticated 
  users to create a Denial of Service (DoS) or to execute arbitrary code. 

  Impact:
  Remote Denial of Service (DoS) and execution of arbitrary code

  Affected Software/OS:
  Kerberos on
  HP-UX B.11.11 running the Kerberos Client software versions prior to 
  1.3.5.09. HP-UX B.11.23 and B.11.31 running the Kerberos Client software 
  versions prior to 1.6.2. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01717795-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Kerberos");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-64SLIB-A", revision:"E.1.6.2.03", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-PRG-A", revision:"E.1.6.2.03", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-RUN-A", revision:"E.1.6.2.03", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-SHLIB-A", revision:"E.1.6.2.03", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5IA32SLIB-A", revision:"E.1.6.2.03", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5IA64SLIB-A", revision:"E.1.6.2.03", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-64SLIB-A", revision:"D.1.6.2.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-PRG-A", revision:"D.1.6.2.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-RUN-A", revision:"D.1.6.2.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-SHLIB-A", revision:"D.1.6.2.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5IA32SLIB-A", revision:"D.1.6.2.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5IA64SLIB-A", revision:"D.1.6.2.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-64SLIB-A", revision:"C.1.3.5.09", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-PRG-A", revision:"C.1.3.5.09", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-RUN-A", revision:"C.1.3.5.09", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-SHLIB-A", revision:"C.1.3.5.09", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}