###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_xm_easy_personal_ftp_detect.nasl 5237 2009-10-21 15:18:29Z oct $
#
# XM Easy Personal FTP Server Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801119);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("XM Easy Personal FTP Server Version Detection");
  desc = "
  Overview: This script detects the installed version of Rhino Software
  Serv-U and sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of XM Easy Personal FTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");

xmPort = get_kb_item("Services/ftp");
if(!xmPort){
  xmPort = 21;
}

if(!get_port_state(xmPort)){
  exit(0);
}

banner = get_ftp_banner(port:xmPort);

if("220 Welcome to DXM's FTP Server" >< banner)
{
  xmVer = eregmatch(pattern:"DXM's FTP Server ([0-9.]+)", string:banner);

  if(!isnull(xmVer[1])){
    set_kb_item(name:"XM-Easy-Personal-FTP/Ver", value:xmVer[1]);
    security_note(data:"XM Easy Personal FTP Server Version " + xmVer[1] +
                                                  " was detected on the host");
  }
}
