# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:011 (virtualbox)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63198);
 script_cve_id("CVE-2008-5256");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.4");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Mandrake Security Advisory MDVSA-2009:011 (virtualbox)";
 script_name(name);

 desc = "The remote host is missing an update to virtualbox
announced via advisory MDVSA-2009:011.

A vulnerability have been discovered and corrected in VirtualBox,
affecting versions prior to 2.0.6, which allows local users
to overwrite arbitrary files via a symlink attack on a
/tmp/.vbox-qateam-ipc/lock temporary file (CVE-2008-5256).

The updated packages have been patched to prevent this.

Affected: 2008.0, 2008.1, 2009.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:011

Risk factor : High";

 script_description(desc);

 summary = "Mandrake Security Advisory MDVSA-2009:011 (virtualbox)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Mandrake Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"dkms-vboxadd", rpm:"dkms-vboxadd~1.5.0~6.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dkms-vboxvfs", rpm:"dkms-vboxvfs~1.5.0~6.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dkms-virtualbox", rpm:"dkms-virtualbox~1.5.0~6.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox", rpm:"virtualbox~1.5.0~6.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox-guest-additions", rpm:"virtualbox-guest-additions~1.5.0~6.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"x11-driver-input-vboxmouse", rpm:"x11-driver-input-vboxmouse~1.5.0~6.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"x11-driver-video-vboxvideo", rpm:"x11-driver-video-vboxvideo~1.5.0~6.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dkms-vboxadd", rpm:"dkms-vboxadd~1.5.6~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dkms-vboxvfs", rpm:"dkms-vboxvfs~1.5.6~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dkms-virtualbox", rpm:"dkms-virtualbox~1.5.6~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox", rpm:"virtualbox~1.5.6~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox-guest-additions", rpm:"virtualbox-guest-additions~1.5.6~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"x11-driver-input-vboxmouse", rpm:"x11-driver-input-vboxmouse~1.5.6~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"x11-driver-video-vboxvideo", rpm:"x11-driver-video-vboxvideo~1.5.6~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dkms-vboxadd", rpm:"dkms-vboxadd~2.0.2~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dkms-vboxvfs", rpm:"dkms-vboxvfs~2.0.2~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dkms-virtualbox", rpm:"dkms-virtualbox~2.0.2~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox", rpm:"virtualbox~2.0.2~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox-guest-additions", rpm:"virtualbox-guest-additions~2.0.2~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"x11-driver-input-vboxmouse", rpm:"x11-driver-input-vboxmouse~2.0.2~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"x11-driver-video-vboxvideo", rpm:"x11-driver-video-vboxvideo~2.0.2~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
