###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_elog_detect.nasl 4137 2009-08-21 12:25:24Z aug $
#
# ELOG Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901008);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("ELOG Version Detection");
  desc = "

  Overview : This script finds the running ELOG Version and saves the
  result in KB.

  Risk factor : None";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_summary("Set Version of ELOG in KB");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");

elogPort = get_http_port(default:8080);
if(!elogPort){
  elogPort = 8080;
}

if(!get_port_state(elogPort)){
  exit(0);
}

banner = get_http_banner(port:elogPort);
if("ELOG" >!< banner){
  exit(0);
}

elogVer = eregmatch(pattern:"Server: ELOG HTTP (([0-9.]+)-?([0-9]+)?)",
                     string:banner);
if(elogVer[1] != NULL)
{
  elogVer = ereg_replace(pattern:"-", string:elogVer[1], replace: ".");
  set_kb_item(name:"www/" + elogPort + "/ELOG", value:elogVer);
  security_note(data:"ELOG version " + elogVer + " was detected on the host");
}
