###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mediawiki_detect.nasl 771 2008-12-17 13:15:29Z dec $
#
# MediaWiki Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Updated By : Sooraj KS <kssooraj@secpod.com> on 2010-04-27
# Modified the regex for detecting beta versions.
#
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900420);
  script_version("$Revision: 7734 $:1.1");
  script_tag(name:"risk_factor", value:"None");
  script_name("MediaWiki script Version Detection");
  desc = "

  Overview: The script detects the version of MediaWiki on remote host
  and sets the KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Check for MediaWiki script version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("General");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  port = 80;
}

foreach dir (make_list("/wiki", "/mediawiki", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php/Special:Version"), port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }

  if("[P|p]owered by" && "MediaWiki" >< rcvRes)
  {
    wikiVer = eregmatch(pattern:"MediaWiki ([0-9.]+)(.?([a-zA-Z0-9]+))?", string:rcvRes);
    if(wikiVer[1] != NULL)
    {
      if(wikiVer[3] != NULL){
        set_kb_item(name:"MediaWiki/Version", value:wikiVer[1]+ "." +wikiVer[2]);
        security_note(data:"MediaWiki Version " + wikiVer[1]+ "." +wikiVer[2] +
                 " running at location " + dir +  " was detected on the host");
      }
      else {
        set_kb_item(name:"MediaWiki/Version", value:wikiVer[1]);
        security_note(data:"MediaWiki Version " + wikiVer[1] + 
                 " running at location " + dir +  " was detected on the host");
      }
    }
  }
}
