###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_wordpress_sec_bypass_vuln.nasl 4019 2009-08-18 15:44:09Z aug $
#
# WordPress-MU wp-login.php Security Bypass Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900816);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-2762");
  script_bugtraq_id(36014);
  script_name("WordPress-MU wp-login.php Security Bypass Vulnerability");
  desc = "

  Overview: The host is running WordPres-MU and is prone to Security Bypass
  vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an error in the wp-login.php script password reset
  mechanism which can be exploited by passing an array variable in a resetpass
  (aka rp) action.

  Impact:
  Attackers can exploit this issue to bypass security restrictions and change
  the administrative password.

  Impact Level: Application

  Affected Software/OS:
  WordPress-MU version prior to 2.8.4 on all running platform.

  Fix: Update to Version 2.8.4
  http://mu.wordpress.org/download/

  References:
  http://www.milw0rm.com/exploits/9410
  http://xforce.iss.net/xforce/xfdb/52382
  http://wordpress.org/development/2009/08/2-8-4-security-release/

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the attack string and version of WordPress-MU");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_wordpress_detect_900182.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

# Get for WordPress-Mu Default Port
wpmuPort = get_http_port(default:80);
if(!wpmuPort){
  exit(0);
}

# Get KB for WordPress-Mu Version
wpmuVer = get_kb_item("www/" + wpmuPort + "/WordPress-Mu");
wpmuVer = eregmatch(pattern:"^(.+) under (/.*)$", string:wpmuVer);

# Check WordPress-Mu Security Bypass Attack
if((wpmuVer[2] != NULL) && (!safe_checks()))
{
  sndReq = http_get(item:string(wpmuVer[2], "/wp-login.php?action=rp&key[]="),
                    port:wpmuPort);
  rcvRes = http_send_recv(port:wpmuPort, data:sndReq);

  if("checkemail=newpass" >< rcvRes)
  {
    security_hole(wpmuPort);
    exit(0);
  }
}

# Check for WordPress-Mu Version 2.8 < 2.8.4
if(wpmuVer[1] != NULL)
{
  if(version_in_range(version:wpmuVer[1], test_version:"2.8",
                                         test_version2:"2.8.3")){
    security_hole(wpmuPort);
  }
}
