/*  
	Copyright (C) 2006 Salvatore Scarciglia <laas.mono@gmail.com>
	http://laas.altervista.org

    This code is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This code is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/

using System;
using Gtk;
using Gdk;
using Glade;

public class ytApp
{
	// MainWindow Widgets  
	[Widget] Gtk.Window		mainWindow;
	[Widget] Gtk.Button		cmdFlag1;
	[Widget] Gtk.Button		cmdFlag2;
	[Widget] Gtk.Button		cmdTool;
	[Widget] Gtk.Button		cmdGo1;
	[Widget] Gtk.Button		cmdGo2;
	[Widget] Gtk.Entry		txtEntry1;
	[Widget] Gtk.Entry		txtEntry2;
	[Widget] Gtk.Image		imgFlag1;
	[Widget] Gtk.Image		imgFlag2;
	private	yTUserProfile 	UserProfiler;
	private yTService		TransService;
	private yTProvider		TransProvider;
	private YTTrayIcon		SysTrayIcon; // 1.1.10
	
	public static void Main (string[] args){
		new ytApp (args);
	}

	public ytApp (string[] args)	{
		Application.Init ();
		Glade.XML gxml = new Glade.XML (null, "yt.glade", "mainWindow", null);
		gxml.Autoconnect (this);
		setupGUI();
		Application.Run ();
	}
	
		
	// GUI setup
	private void setupGUI(){
		mainWindow.Icon = new Gdk.Pixbuf(null,"yTicon.png");
		mainWindow.DeleteEvent+=closeMainWindow;
		mainWindow.WindowStateEvent+=stateChanged;
		mainWindow.Title = "YouTranslate! v1.1.10";
		mainWindow.SetDefaultSize(680,50);
		txtEntry1.Activated+=prepareTranslation;
		txtEntry2.Activated+=prepareTranslation;
		txtEntry1.KeyReleaseEvent+=openLargeTRanslator;
		txtEntry2.KeyReleaseEvent+=openLargeTRanslator;
		cmdFlag1.Clicked+=buttonHandling;
		cmdFlag2.Clicked+=buttonHandling;
		cmdTool.Clicked+=buttonHandling;
		cmdGo1.Clicked+=buttonHandling;
		cmdGo2.Clicked+=buttonHandling;
		
		// Custom objects
		UserProfiler = new yTUserProfile();
		UserProfiler.readSettings();
		TransProvider = new yTProvider(UserProfiler.ProviderID);
		TransService = new yTService(TransProvider,txtEntry1,txtEntry2);
		TransService.Language1 = UserProfiler.Language1;
		TransService.Language2 = UserProfiler.Language2;
		imgFlag1.Pixbuf = new Pixbuf(null, TransService.Language1+".png");
		imgFlag2.Pixbuf = new Pixbuf(null, TransService.Language2+".png");
		txtEntry1.HasFocus = true;
		checkStartUpMode();
		checkVisibility();
		SysTrayIcon = new YTTrayIcon(mainWindow,this); 
	}

	// startup mode MainWindow visible/MainWindo not visible
	private void checkStartUpMode(){
		if(UserProfiler.startMode==true){
			mainWindow.Visible = false;		
		}
	}

	// startup mode MainWindow visible/MainWindo not visible
	private void checkVisibility(){
		if(UserProfiler.allWorkspace==true){
			mainWindow.Stick();		
		}
	}

	// Window Events
	private void closeMainWindow (object sender, DeleteEventArgs a){
		UserProfiler.saveBookmarks(false);
		Application.Quit ();
		a.RetVal = true;
	}
	
	// Used to handle state change of the Window
	private void stateChanged (object sender, WindowStateEventArgs a){ // <--- Systray
		/*
		if(a.Event.NewWindowState == WindowState.Iconified) {
			mainWindow.Visible = false;
			mainWindow.Hide();
		}
		*/
	}
	
	// Entries handler
	// this one handle the ENTER button
	private void prepareTranslation (object sender, EventArgs a){
		string ttt="";
		Entry x = (Entry) sender;
		if(x == txtEntry1) {
			ttt = txtEntry1.Text;
			TransService.goTranslate(ttt,1);
		}
		else if(x == txtEntry2){
			ttt = txtEntry2.Text;
			TransService.goTranslate(ttt,2);
		}
	}	
	
	// this one handle the KEY RELEASE event
	private void openLargeTRanslator (object sender, KeyReleaseEventArgs a){
		string src="";
		Entry x = (Entry) sender;
		if(x == txtEntry1) src = "1"; 
		else if(x == txtEntry2) src = "2";
		
		if(a.Event.Key.ToString() == "F"+UserProfiler.largeKey) {
			new yTLargeTranslator(mainWindow,UserProfiler,TransService,TransProvider,src);
		}
	}		
	
	// Button handler
	private void buttonHandling (object sender, EventArgs a){
		string ttt="";
		Button b = (Button) sender;
		if(b == cmdFlag1) {
			new yTLangSelector(mainWindow,UserProfiler,imgFlag1,TransService,1);
		}
		else if(b == cmdFlag2) {
			new yTLangSelector(mainWindow,UserProfiler,imgFlag2,TransService,2);
		}
		else if(b == cmdTool) {
			new yTToolWin(mainWindow,UserProfiler,TransService,TransProvider);
		}
		else if(b == cmdGo1) {
			ttt = txtEntry1.Text;
			TransService.goTranslate(ttt,1);
		}
		else if(b == cmdGo2) {
			ttt = txtEntry2.Text;
			TransService.goTranslate(ttt,2);
		}		

	}		
	
	public void showPrefs(){
		new yTToolWin(null,UserProfiler,TransService,TransProvider);
	}
	
	public void savePrefs(){
		UserProfiler.saveBookmarks(false);
	}
}

